/*
* Copyright (c) 2001-2008 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/

#include "cfileparser.h"

#include <S32FILE.H>
#include <VERSIT.H> 


CFileParser::CFileParser()
    {
   
    }

CFileParser::~CFileParser()
    {
    iFileServ.Close();    
    
    }

CFileParser* CFileParser::NewLC()
    {
    CFileParser* self = new (ELeave) CFileParser();
    CleanupStack::PushL(self);
    self->ConstructL();
    return self;
    }

CFileParser* CFileParser::NewL()
    {
    CFileParser* self = CFileParser::NewLC();
    CleanupStack::Pop(); // self;
    return self;
    }

void CFileParser::ConstructL()
    {
    iFileServ.Connect();
    iStart = false;
    SetMediaType(CFileParser::ENone);   //no  specific folder
    
    }

void CFileParser::SetMediaType(TMediaType aType)
    {
    iCurMediaType = aType;
    }
    
CFileParser::TMediaType CFileParser::GetMediaType()
    {
    return iCurMediaType;
    }

/*
 * aFileName - is the file to be parsed
 * this contain the text in the form
 * [photos]
 * --
 * --
 * [/photos]
 * [music]
 * --
 * --[/music]
 * [videos]
 * ---
 * --
 * [/videos]
 * ParseFile function takes such a file & parses the sections
 * and writes the photo filename to aPhotoFile,
 * music file names to aMusicFile &
 * video file names to aVideoFile
 * 
 */


void CFileParser::ParseFile( const TDesC& aFileName,const TDesC& aPhotoFile,const TDesC& aMusicFile,const TDesC& aVideoFile )
    {
    TFileText lineReader;
    TFileName name;
    RBuf8 fileName;
    RFile photoFile, musicFile, videoFile;
    
    //declare the start & end tags
    _LIT(KPhotoStart,"[photos]");
    _LIT(KMusicStart,"[music]");
    _LIT(KVideoStart,"[videos]");
    _LIT(KPhotoEnd,"[/photos]");
    _LIT(KMusicEnd,"[/music]");
    _LIT(KVideoEnd,"[/videos]");
    
    _LIT(KStartTag,"[%s]");
    _LIT(KEndTag,"[/%s]");
    
    TBuf<KMaxFileName> buf;
    name.Copy(aFileName);
    RFileReadStream readStream;
    readStream.PushL();

    User::LeaveIfError(readStream.Open(iFileServ, name, EFileRead));
    CLineReader* myReader = CLineReader::NewL(readStream);
    TInt aPos = 0;
    TInt aErr = 0;
    
    photoFile.Replace(iFileServ,aPhotoFile,EFileWrite);
    musicFile.Replace(iFileServ,aMusicFile,EFileWrite);
    videoFile.Replace(iFileServ,aVideoFile,EFileWrite);
    
    while(aErr!=KErrEof)
       {
          myReader->ReadLineL(aPos, aErr);
        // Do your parsing here ..          
          fileName.CreateL(KMaxFileName);
          buf.Copy(myReader->iBufPtr);          
          //compare buf with the start & end tags
          //if it is the start or end tag, dont write to the file          
          if( buf.Compare(KPhotoStart)== 0){  //photo tag start
              SetMediaType(CFileParser::EPhotos); 
              iStart = true;
          }
          else if( buf.Compare(KPhotoEnd)== 0){        //photo tag end
              SetMediaType(CFileParser::ENone);  
          }
          else if( buf.Compare(KMusicStart)== 0 ){       //music tag start
              SetMediaType(CFileParser::EMusic);
              iStart = true;
          }
          else if( buf.Compare(KMusicEnd)== 0){
              SetMediaType(CFileParser::ENone);       //music tag end
          }
          else if( buf.Compare(KVideoStart)== 0 ){
              SetMediaType(CFileParser::EVideos);  
              iStart = true;//video tag start
          }
          else if( buf.Compare(KVideoEnd)== 0 ){       
              SetMediaType(CFileParser::ENone);       //video tag end
          }
          else 
              {
                  fileName.Copy(buf);
                  switch( GetMediaType() )
                    {
                      case EPhotos:
                          {
                          if(!iStart){
                              photoFile.Write(_L8("\n"));
                          }
                          else {
                              iStart = false;
                          }
                          photoFile.Write(fileName);
                          }            
                              break;
                      case EMusic:
                          {
                          if(!iStart){
                              musicFile.Write(_L8("\n"));
                          }
                          else {
                              iStart = false;
                          }
                          musicFile.Write(fileName);
                          }
                              break;
                      case EVideos:
                          {
                          if(!iStart){
                              videoFile.Write(_L8("\n"));
                          }
                          else {
                               iStart = false;
                           }
                          videoFile.Write(fileName);
                          }
                              break;
                      default:
                              break;
                    }
              }
          
       }
    //close all file handles
    photoFile.Close();
    musicFile.Close();
    videoFile.Close();
    //close the filename rbuf
    fileName.Close();
    CleanupStack::PopAndDestroy();    
    delete myReader;
    }
