/*
* Copyright (c) 2001-2008 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/

#ifndef FILEPARSER_H
#define FILEPARSER_H

// INCLUDES
#include <e32std.h>
#include <e32base.h>
#include <f32file.h> 

// CLASS DECLARATION

/**
 *  CFileParser
 * 
 */
class CFileParser : public CBase
    {
public:
    
    enum TMediaType{
            EPhotos,
            EMusic,
            EVideos,
            ENone
        };
    enum TFileReadPos{
        EStartOfGrp,
        EEndOfGrp
    };
   
    ~CFileParser();

    static CFileParser* NewL();

    static CFileParser* NewLC();    

    void ParseFile(const TDesC& aFileName,const TDesC& aPhotoFile,const TDesC& aMusicFile,const TDesC& aVideoFile);
    
    void SetMediaType(TMediaType aType);
    
    CFileParser::TMediaType GetMediaType();   
    

private:

    CFileParser();

    void ConstructL();
   
private:
    RFs iFileServ;
    TMediaType iCurMediaType; 
    TBool iStart;

    };

#endif // FILEPARSER_H
