/*
* Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/
#ifndef DOWNLOADICON_H_
#define DOWNLOADICON_H_

#include <QObject>
#include <QtGui>
#include <QNetworkAccessManager>
#include <QNetworkReply>

#include "ui_mainwindow.h"

class DownloadIcon : public QObject
    {
    Q_OBJECT
public:
    DownloadIcon(Ui::MainWindow &aMainUi);
    virtual ~DownloadIcon();
    
    void GetIcon(const TDesC8& aContactName, const TDesC8& aUri, const TDesC8& aFileName);
private:
    
    void DisplayMsgBox(QString str);
    void UpdateAvatarItem();
    void ChangePathSlash();
    
    QNetworkAccessManager *manager;
    QNetworkReply *reply;

    QString contactName;
    QString filePath;
    
    Ui::MainWindow &MainUi;
    
private slots:
    void RequestFinished();

    };


#endif /* DOWNLOADICON_H_ */
