/*
* Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/
#ifndef MUSICPROVIDER_H_
#define MUSICPROVIDER_H_

#include <e32base.h>
#include <mpxplaybackobserver.h>
#include <mpxplaybackutility.h>


class MNowPlayObserver;

class CMusicProvider: public MMPXPlaybackObserver, 
                      public MMPXPlaybackCallback
    {
public:
    static CMusicProvider* NewL(MNowPlayObserver* aOb);
    ~CMusicProvider();
    void StartTestL();
    void RequestMediaL();
    
private:
    CMusicProvider(MNowPlayObserver* aOb);
    void ConstructL();

public:
    //From MMPXPlaybackObserver
    void HandlePlaybackMessage( CMPXMessage* aMessage, TInt aError );
    

    //Callbacks from MMPXPlaybackCallback
    void HandlePropertyL(TMPXPlaybackProperty aProperty,
                                 TInt aValue, 
                                 TInt aError);
    
    void HandleSubPlayerNamesL(TUid aPlayer, 
                                       const MDesCArray* aSubPlayers,
                                       TBool aComplete,
                                       TInt aError
                                       );
    
    void HandleMediaL(const CMPXMedia& aProperties,
                              TInt aError);
    
    
    void DoHandlePlaybackMessageL( const CMPXMessage& aMessage );
    
private:    
    MMPXPlaybackUtility*               iPlaybackUtility;
    RBuf                               iBuf;
    MNowPlayObserver*                  iObserver;
    RBuf                               iPreviousTrack;
    
    
    };

#endif /* MUSICPROVIDER_H_ */
