// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#ifndef __CMDNSPNPPSERVICEPUBLISHERIMPL_H__
#define __CMDNSPNPPSERVICEPUBLISHERIMPL_H__


#include <pnp/cpnpservicepublisherbase.h>
#include <pnp/mpnpobserver.h>

//User includes
#include "cmdnsclient.h"
#include "mdnsparamset.h"
#include "mdnsdebug.h"

//Uid3 of this  ecomplugin interface.
const TUint KMDnsPublisherUid = 0x2001DC8A;
/* Body of RPnPServicePublisher class and calls the SubmitRequest and NotifyResults
   of respective classes
 */
class CMDnsServicePublisherImpl :public CPnPServicePublisherBase 
	{
public:
	static CMDnsServicePublisherImpl* NewL();
	~CMDnsServicePublisherImpl ( );
		
private:
	TInt Construct ( TUint aTierId );
	void Publish ( const RPnPParameterBundle& aServiceInfo );
	void SendNotify ( const RPnPParameterBundle& aServiceInfo );
	CControlChannelBase* InitiateControlL ();


private:
	CMDnsServicePublisherImpl ( );
	void PublishL ( const RPnPParameterBundle& aServiceInfo );
	void SendNotifyL ( const RPnPParameterBundle& aServiceInfo );
	
private:
    //Mdns client instance.
    RMdns iMdns;
    /**
    FLOGGER debug trace member variable.
    */
    __FLOG_DECLARATION_MEMBER_MUTABLE;

	};

#endif // __CMdnsPNPPSERVICEPUBLISHERIMPL_H__
