// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// cmdnsregisternotifier.h
// 
//

/**
@file
@internalTechnology
*/

#ifndef CMDNSREGISTERNOTIFIER_H_
#define CMDNSREGISTERNOTIFIER_H_

//System Include 
#include <e32base.h>

//User Include
#include "cmdnsserverconstants.h"
#include <mdns/dnsconstants.h>
#include "mdnsdebug.h"
class MPnPObserver;

class RMdns;

class CMdnsRegisterNotifier : public CActive
    {
    public:
        static CMdnsRegisterNotifier* NewL(RMdns& aMdns);
        ~CMdnsRegisterNotifier();
        void SetPnpObserver(MPnPObserver* aObserver);
    private:
        CMdnsRegisterNotifier(RMdns& aMdns);
        void ConstructL();
        void RunL();
        void DoCancel();
        TInt RunError(TInt aError);
        void Start();
    private:
        RMdns& iMdns;
        HBufC8* iNotifyRcvdMessage;
        TPtr8 iPtrNotifyRcvdMessage;
        MPnPObserver* iObserver;
        /**
        FLOGGER debug trace member variable.
        */
        __FLOG_DECLARATION_MEMBER_MUTABLE;
    };

#endif /* CMDNSREGISTERNOTIFIER_H_ */
