// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// cmdnspnpservicepublisherimpl.cpp
// 
//

//User include 
#include "cmdnspnpservicepublisherimpl.h"
__FLOG_STMT(_LIT8(KComponent,"CMDnsServicePublisherImpl");)
/*
 *Default constructor  
 */
CMDnsServicePublisherImpl::CMDnsServicePublisherImpl ()
	{
	__FLOG_OPEN(KMDNSSubsystem, KComponent);
	}

/*
 * Two phase constructor 
 */	
CMDnsServicePublisherImpl* CMDnsServicePublisherImpl::NewL()
	{
	
	return new ( ELeave ) CMDnsServicePublisherImpl;
	
	}

/*
 * Destructor 
 */
CMDnsServicePublisherImpl::~CMDnsServicePublisherImpl ()
	{
	__FLOG(_L8("CMDnsServicePublisherImpl::~CMDnsServicePublisherImpl - Entry"));
	iMdns.Close();
	__FLOG(_L8("CMDnsServicePublisherImpl::~CMDnsServicePublisherImpl - Exit"));
	__FLOG_CLOSE;
	}

/*
 * virtual function in the base class CPnPServicePublisherBase
 * Will be called to construct the object.
 * Launches the Mdns server if not already and creates a new session.
 * Graps the Iap and sends the same to server to use .
 * 
 */
TInt CMDnsServicePublisherImpl::Construct(TUint /*aTierId*/)
	{
	__FLOG(_L8("CMDnsServicePublisherImpl::Construct - Entry"));
	RSocketServ sockServ;
    RConnection connection;
    TInt error = sockServ.Connect();
    error = connection.Open(sockServ);
        
    // start a connection, and grab the IAP ID
    error = connection.Start();
        
    TUint32 iap ;
    _LIT(KCommdbIapSetting, "IAP\\Id");
    connection.GetIntSetting(KCommdbIapSetting, iap);
    iMdns.Open(iap);
    connection.Close();
    sockServ.Close();
    __FLOG(_L8("CMDnsServicePublisherImpl::Construct - Exit"));
    return error;
	}

/*
 * Publishes the service client sent along with bundle.
 * any error will be notified back using the Observer inside the bundle.
 */
void CMDnsServicePublisherImpl::Publish ( const RPnPParameterBundle& aServiceInfo )
	{
	__FLOG(_L8("CMDnsServicePublisherImpl::Publish - Entry"));
	TRAPD(err, PublishL( aServiceInfo ));
	if(err != KErrNone )
		aServiceInfo.PnPObserver()->OnPnPError(err);
	__FLOG(_L8("CMDnsServicePublisherImpl::Publish - Exit"));
	}

/*
 *Leaving function which publish any services client want to .
 *Might contain the additional text record . If client wish to publish.
 *@param aServiceInfo RPnpParameterBundle contains the domainName need to be published.
 */
void CMDnsServicePublisherImpl::PublishL (const RPnPParameterBundle& aServiceInfo )
	{
	__FLOG(_L8("CMDnsServicePublisherImpl::PublishL - Entry"));
	TBool isUpdate = EFalse;
	HBufC8* data = HBufC8::NewLC(aServiceInfo.Length());
	TPtr8 buffer = data->Des();
	aServiceInfo.Store(buffer);
	RPnPParameterBundle serviceInfo;
	serviceInfo.CreateL();
	serviceInfo.Load(buffer);
	RParameterFamily publishFamily = serviceInfo.FindFamily( EMdnsPublishParamset) ;
	if(!publishFamily.IsNull() && publishFamily.CountParameterSets()>0)
	    {
	    CMDnsPublishParamSet* publishParamSet = static_cast<CMDnsPublishParamSet*> (publishFamily.GetParameterSetAtIndex ( 0, RParameterFamily::ERequested ));
	    isUpdate = publishParamSet->PublishUpdate();
	    }
	iMdns.RegisterServiceL(aServiceInfo,isUpdate);
	serviceInfo.Close();
	CleanupStack::PopAndDestroy();//data
	__FLOG(_L8("CMDnsServicePublisherImpl::PublishL - Exit"));
	}

/*
 * Used to request for any notification of the service type client is interested in .
 * @param aServiceInfo a RPnPParameterBundle which contains the servicetype ,
 * client is interested in .
 */
void CMDnsServicePublisherImpl::SendNotify ( const RPnPParameterBundle& aServiceInfo )
	{
	__FLOG(_L8("CMDnsServicePublisherImpl::SendNotify - Entry"));
	TRAPD( err, SendNotifyL( aServiceInfo ));
	if ( err != KErrNone )
		aServiceInfo.PnPObserver()->OnPnPError(err);
	__FLOG(_L8("CMDnsServicePublisherImpl::SendNotify - Exit"));
	}
	
/*
 *@param aServiceInfo a RPnPParameterBundle which contains the servicetype ,
 *client is interested in .  
 */	
void CMDnsServicePublisherImpl::SendNotifyL ( const RPnPParameterBundle& aServiceInfo )
	{
	__FLOG(_L8("CMDnsServicePublisherImpl::SendNotifyL - Entry"));
	iMdns.RegisterServiceL(aServiceInfo);
	__FLOG(_L8("CMDnsServicePublisherImpl::SendNotifyL - Exit"));
	}
	
/*
 * Nothing to do with this .
 * Might need it in future.
 */
CControlChannelBase* CMDnsServicePublisherImpl::InitiateControlL ()
	{
	__FLOG(_L8("CMDnsServicePublisherImpl::InitiateControlL - Entry"));
	//Nothing to do .
	//Not Implemented
	__FLOG(_L8("CMDnsServicePublisherImpl::InitiateControlL - Exit"));
    return  NULL;
	}


