// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// cpnpservicediscovery.cpp
// 
//
//System include
#include <connpref.h>

//User include
#include "CMDnsServiceDiscoveryImpl.h"
#include "pnp/mpnpobserver.h"
__FLOG_STMT(_LIT8(KComponent,"CMDnsServiceDiscoveryImpl");)
/*
 * Constructor.
 */
CMDnsServiceDiscoveryImpl::CMDnsServiceDiscoveryImpl ()
	{
	}
/*
 * Two phase constructor
 */
CMDnsServiceDiscoveryImpl* CMDnsServiceDiscoveryImpl::NewL()
	{
	CMDnsServiceDiscoveryImpl* self = new (ELeave) CMDnsServiceDiscoveryImpl;
	return self;
	}

/*
 * Destructor
 */
CMDnsServiceDiscoveryImpl::~CMDnsServiceDiscoveryImpl ()
	{
	__FLOG(_L8("CMDnsServiceDiscoveryImpl:: - Entry"));
	iMdns.Close();
	__FLOG(_L8("CMDnsServiceDiscoveryImpl:: - Exit"));
	__FLOG_CLOSE;
	}

/*
 *  Explicitly start the connection
 *  Read the iap using RConnection and send the same to the RMdns.
 *  @param aTierId implementation uid of the plugin
 */
TInt CMDnsServiceDiscoveryImpl::Construct( TUint aTierId )
	{
	__FLOG_OPEN(KMDNSSubsystem, KComponent);
	__FLOG(_L8("CMDnsServiceDiscoveryImpl:: - Entry"));
	RSocketServ sockServ;
	RConnection connection;
	User::LeaveIfError(sockServ.Connect());
	    User::LeaveIfError(connection.Open(sockServ));
	    
	    // start a connection, and grab the IAP ID
	    User::LeaveIfError(connection.Start());
	    
	    TUint32 iap ;
	    _LIT(KCommdbIapSetting, "IAP\\Id");
	    User::LeaveIfError(connection.GetIntSetting(KCommdbIapSetting, iap));
	iMdns.Open(iap);
	connection.Close();
	sockServ.Close();
	__FLOG(_L8("CMDnsServiceDiscoveryImpl:: - Exit"));
	return KErrNone;
	}

/*
 * Any query request will be handled by this.
 * @param aServiceInfo parameter bundle which contains the query.
 */
void CMDnsServiceDiscoveryImpl::Discover ( const RPnPParameterBundle& aServiceInfo )
	{
	__FLOG(_L8("CMDnsServiceDiscoveryImpl:: - Entry"));
	TRAPD( err, DiscoverL( aServiceInfo ));
	if(err != KErrNone )
		aServiceInfo.PnPObserver()->OnPnPError(err);
	__FLOG(_L8("CMDnsServiceDiscoveryImpl:: - Exit"));
	}

/*
 * Any query request will be handled by this.
 * @param aServiceInfo parameter bundle which contains the query.
 */
void CMDnsServiceDiscoveryImpl::DiscoverL ( const RPnPParameterBundle& aServiceInfo )
	{
	__FLOG(_L8("CMDnsServiceDiscoveryImpl:: - Entry"));
	iMdns.QueryL(aServiceInfo);
	__FLOG(_L8("CMDnsServiceDiscoveryImpl:: - Exit"));
	}

/*
 * Not supported in ZeroConf.
 */
void CMDnsServiceDiscoveryImpl::Describe(  const RPnPParameterBundle& aServiceInfo )
	{
	__FLOG(_L8("CMDnsServiceDiscoveryImpl:: - Entry"));
	TRAPD( err, DescribeL( aServiceInfo ));
	if(err != KErrNone )
		aServiceInfo.PnPObserver()->OnPnPError(err);
	__FLOG(_L8("CMDnsServiceDiscoveryImpl:: - Exit"));
	}

/*
 * Not supported in ZeroConf.
 */
void CMDnsServiceDiscoveryImpl::DescribeL ( const RPnPParameterBundle& /*aServiceInfo*/ )
	{
	__FLOG(_L8("CMDnsServiceDiscoveryImpl:: - Entry"));
	User::Leave(KErrNotSupported);
	__FLOG(_L8("CMDnsServiceDiscoveryImpl:: - Exit"));
	}
/*
 * Not supported in ZeroConf.
 */
void CMDnsServiceDiscoveryImpl::Subscribe ( const RPnPParameterBundle& aServiceInfo )
	{
	__FLOG(_L8("CMDnsServiceDiscoveryImpl:: - Entry"));
	TRAPD( err, SubscribeL( aServiceInfo ));
	if(err != KErrNone )
		aServiceInfo.PnPObserver()->OnPnPError(err);
	__FLOG(_L8("CMDnsServiceDiscoveryImpl:: - Exit"));
	}

/*
 * Not supported in ZeroConf.
 */
void CMDnsServiceDiscoveryImpl::SubscribeL ( const RPnPParameterBundle& /* aServiceInfo*/ )
	{
	__FLOG(_L8("CMDnsServiceDiscoveryImpl:: - Entry"));
	User::Leave(KErrNotSupported);
	__FLOG(_L8("CMDnsServiceDiscoveryImpl:: - Exit"));
	}
/*
 * Client intersted in any new service to be notified, will call this.
 * @param aServiceInfo parameter bundle which contains the ptr domain name client is intersted in.
 */
void CMDnsServiceDiscoveryImpl::RegisterNotify(  const RPnPParameterBundle& aServiceInfo )//done
	{
	__FLOG(_L8("CMDnsServiceDiscoveryImpl:: - Entry"));
	TRAPD( err, RegisterNotifyL( aServiceInfo ));
	if(err != KErrNone )
		aServiceInfo.PnPObserver()->OnPnPError(err);
	__FLOG(_L8("CMDnsServiceDiscoveryImpl:: - Exit"));
	}
// Used to register for advertisements of specific service type 
void CMDnsServiceDiscoveryImpl::RegisterNotifyL ( const RPnPParameterBundle& aServiceInfo )//done
	{
	__FLOG(_L8("CMDnsServiceDiscoveryImpl:: - Entry"));
	iMdns.WaitForNotificationL(aServiceInfo);
	__FLOG(_L8("CMDnsServiceDiscoveryImpl:: - Exit"));
	}

/* Used to cancel previous requests of services. */
void CMDnsServiceDiscoveryImpl::Cancel ( const RPnPParameterBundle& aServiceInfo )//done
	{
	__FLOG(_L8("CMDnsServiceDiscoveryImpl:: - Entry"));
	//Ignore the error.
	TRAP_IGNORE(iMdns.Cancel(aServiceInfo));
	__FLOG(_L8("CMDnsServiceDiscoveryImpl:: - Exit"));
	}


/*
 * Not supported in ZeroConf.
 */
CControlChannelBase*  CMDnsServiceDiscoveryImpl::InitiateControlL (const TDesC8& /*aUri*/ )
	{
	__FLOG(_L8("CMDnsServiceDiscoveryImpl:: - Entry"));
	__FLOG(_L8("CMDnsServiceDiscoveryImpl:: - Exit"));
	return NULL;
	}

