/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/



#ifndef __CDNSMSGBUF_H__
#define __CDNSMSGBUF_H__

#include <e32base.h>
#include <es_sock.h>
#include <in_sock.h>

#include "tdnsheader.h"
#include "cstringparser.h"


//CDnsMsgBuf class composes a raw buffer from the supplied inputs
class CDnsMsgBuf : public CBase
	{
public:
    ~CDnsMsgBuf();
	static CDnsMsgBuf* NewL(const TDesC8& aBuf);
	void SetChar(TUint8 aVal);
	void SetInt16(TUint16 aVal);
	void SetInt32(TUint32 aVal);
	void SetDomainNameL(const TDesC8& aName);
	void SetText(const TDesC8& aTxt);
	void SetPtrRdLengthL(const TDesC8& aName);
	void SetSrvRdLengthL(const TDesC8& aName);
	void SetTxtRdLength(const RArray<RBuf8>& aTxtList);
		
private:
	void ConstructL(const TDesC8& aBuf);
	CDnsMsgBuf(const TDesC8& aBuf);
	TUint16 GetDomainLengthL(const TDesC8& aName)const;
	
private:
	TUint8* iPtr;
	TUint iIndex;
	TUint iDataLength;
	};

#endif  //__CDNSMSGBUF_H__
