/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/


#ifndef __CDNSQUESTION_H__
#define __CDNSQUESTION_H__

#include <mdns/cdnssection.h>
#include <mdns/tdnsheader.h>
#include <mdns/dnsconstants.h>

/*                                  1  1  1  1  1  1
      0  1  2  3  4  5  6  7  8  9  0  1  2  3  4  5
    +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
    |                                               |
    /                     QNAME                     /
    /                                               /
    +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
    |                     QTYPE                     |
    +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
    |UC                   QCLASS                    |
    +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+

*/

class CDnsQuestion : public CDnsSection
     {
public:	
	IMPORT_C ~CDnsQuestion();
	IMPORT_C  static CDnsQuestion* NewL();
	
	IMPORT_C  TBool IsUnicast()const;
	IMPORT_C  void SetUnicast(TBool);
	
	IMPORT_C TUint16 Size()const;

private:
	CDnsQuestion();
     };
	 
#endif	//__CDNSQUESTION_H__
