/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/



#ifndef __CDNSRESOURCEDATA_H__
#define __CDNSRESOURCEDATA_H__


#include <mdns/cdnssection.h>
#include <mdns/tdnsheader.h>
#include <mdns/dnsconstants.h>


/*                                     1  1  1  1  1
      0  1  2  3  4  5  6  7  8  9  0  1  2  3  4  5
    +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
    |                                               |
    /                                               /
    /                      NAME                     /
    |                                               |
    +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
    |                      TYPE                     |
    +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
    |FL                   CLASS                     |
    +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
    |                      TTL                      |
    |                                               |
    +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
    |                   RDLENGTH                    |
    +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--|
    /                     RDATA                     /
    /                                               /
    +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+

*/

class CDnsResourceData: public CDnsSection
    {
public:
	IMPORT_C virtual ~CDnsResourceData();
	
	IMPORT_C CDnsResourceData* CloneL()const;
	
	IMPORT_C TBool IsFlushBitSet()const;
	IMPORT_C void SetFlushBit(TBool aFlushBit);

	IMPORT_C TUint16 RdLength()const;
	IMPORT_C void SetRdLength(TUint16 aRdLength);

	IMPORT_C TUint32 Ttl()const;
	IMPORT_C void SetTtl(TUint32 aTtl);	
	
	virtual TUint16 Size()const;
		
protected:   
	CDnsResourceData();
	

protected:  
	TUint16	iRdLength;
	TUint32	iTtl;
    };

#endif __CDNSRESOURCEDATA_H__