/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/



#ifndef __TDNSHEADER_H__
#define __TDNSHEADER_H__

#include <mdns/dnsconstants.h>

class TDnsHeader
    {
public:
	inline TUint16 Id()const;
	inline TUint16 IsQuery()const;
	inline TUint16 Opcode()const;
	inline TUint16 IsAuthoritative()const;
	inline TUint16 IsTruncated()const;
	inline TUint16 RecursionDesired()const;
	inline TUint16 RecursionAvailable()const;
	inline TUint16 Reserved()const;
	inline TUint16 ResponseCode()const;
	inline TUint16 QueryCount()const;
	inline TUint16 AnswerCount()const;
	inline TUint16 AuthorityNSCount()const;
	inline TUint16 AdditionalRCount()const;
	inline TUint16 Flags()const;
	
	inline void SetId(TUint16 aId);
	inline void SetQuery(TBool aQuery);
	inline void SetOpcode(TUint16  aOpcode);
	inline void SetAuthoritative(TBool aAuthBit);
	inline void SetTruncated(TBool aTruncBit);
	inline void SetRecursionDesired(TBool aRecDesired);
	inline void SetRecursionAvailable(TBool aRecAvailable);
	inline void SetReserved(TUint16 aResv);
	inline void SetResponseCode(TUint16 aRespCode);
	inline void SetFlags(TUint16 aFlags);
	inline void SetQueryCount(TUint16 aCount);
	inline void SetAnswerCount(TUint16 aCount);
	inline void SetAuthorityNSCount(TUint16 aCount);
	inline void SetAdditionalRCount(TUint16 aCount);
	
	inline TDnsHeader();
	inline TDnsHeader(const TDnsHeader& aHeader);
	
private:
/*	                              1  1  1  1  1  1
    0  1  2  3  4  5  6  7  8  9  0  1  2  3  4  5
  +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
  |                      ID                       |
  +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
  |QR|   Opcode  |AA|TC|RD|RA|   Z    |   RCODE   |
  +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
  |                    QDCOUNT                    |
  +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
  |                    ANCOUNT                    |
  +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
  |                    NSCOUNT                    |
  +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
  |                    ARCOUNT                    |
  +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
  
*/
	TUint16 iID;
	TUint16 iFlags;
	TUint16 iQCount;
	TUint16 iACount;
	TUint16 iNSCount;
	TUint16 iARCount;	
    };

#include <mdns/tdnsheader.inl>

#endif //__TDNSHEADER_H__

