/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/


#ifndef __TDNSHEADER_INL__
#define __TDNSHEADER_INL__


TDnsHeader::TDnsHeader()
  {
  iQCount = 0;
  iACount = 0;
  iNSCount = 0;
  iARCount = 0;	
  iID = 0;   
  iFlags = 0;    
  }


TDnsHeader::TDnsHeader(const TDnsHeader& aHeader)
    {
    iQCount = aHeader.QueryCount();
    iACount = aHeader.AnswerCount();
    iNSCount = aHeader.AuthorityNSCount();
    iARCount = aHeader.AdditionalRCount(); 
    iID = aHeader.Id();   
    iFlags = aHeader.Flags();    
    }



TUint16 TDnsHeader::Id()const
  {
  return iID;
  }

TUint16 TDnsHeader::IsQuery()const
  {
  return !(iFlags & EFlagQuery); 
  }

TUint16 TDnsHeader::Opcode()const
  {
  return (iFlags >> 3) & EFlagOpcode; 
  }

TUint16 TDnsHeader::IsAuthoritative()const
  {
  return iFlags & EFlagAuthoritative;
  }

TUint16 TDnsHeader::IsTruncated()const
  {
  return iFlags & EFlagTruncated;
  }

TUint16 TDnsHeader::RecursionDesired()const
  {
  return iFlags & EFlagRecurse;
  }

TUint16 TDnsHeader::RecursionAvailable()const
  {
  return iFlags & EFlagRecursionAvailable;
  }

TUint16 TDnsHeader::Reserved()const
  {
  return iFlags & EFlagReserved;
  }

TUint16 TDnsHeader::ResponseCode()const
  {
  return iFlags & EFlagResponseCode;
  }

TUint16 TDnsHeader::Flags()const
  {
  return iFlags;
  }

TUint16 TDnsHeader::QueryCount()const
  {
  return iQCount;
  }
	
TUint16 TDnsHeader::AnswerCount()const
  {
  return iACount;
  }
	
TUint16 TDnsHeader::AuthorityNSCount()const
  {
  return iNSCount;
  }
	
TUint16 TDnsHeader::AdditionalRCount()const
  {
  return iARCount;
  }
	
void TDnsHeader::SetId(TUint16 aId)
  {
  iID = aId;
  }

void TDnsHeader::SetQuery(TBool aQuery)
  {
  if (!aQuery)
    iFlags |= EFlagQuery;
  else
    iFlags &= ~EFlagQuery; 
  }


void TDnsHeader::SetOpcode(TUint16 aOpcode)
  {
  aOpcode << 11;
  iFlags |= aOpcode ; 
  }

void TDnsHeader::SetAuthoritative(TBool aAuthBit)
  {
  if(aAuthBit)
     iFlags |= EFlagAuthoritative; 
  else
     iFlags &= ~EFlagAuthoritative;
  }

	
void TDnsHeader::SetTruncated(TBool aTruncBit)
  {
  if(aTruncBit)
     iFlags |= EFlagTruncated;
  else
     iFlags &= ~EFlagTruncated;
  }

void TDnsHeader::SetRecursionDesired(TBool aRecDesired)
  {
  if (aRecDesired)
	 iFlags |= EFlagRecurse;
  else
     iFlags &= ~EFlagRecurse;
  }

void TDnsHeader::SetRecursionAvailable(TBool aRecAvailable)
  {
  if (aRecAvailable)
     iFlags |= EFlagRecursionAvailable;
  else
     iFlags &= ~EFlagRecursionAvailable;
  }

void TDnsHeader::SetReserved(TUint16 aResv)
  {
  aResv << 4;
  iFlags |= aResv;
  }

void TDnsHeader::SetResponseCode(TUint16 aRespCode)
  {
  iFlags |= aRespCode;
  }

void TDnsHeader::SetFlags(TUint16 aFlags)
  {
  iFlags = aFlags;
  }

void TDnsHeader::SetQueryCount(TUint16 aCount)
  {
  iQCount = aCount;
  }

void TDnsHeader::SetAnswerCount(TUint16 aCount)
  {
  iACount = aCount;
  }

void TDnsHeader::SetAuthorityNSCount(TUint16 aCount)
  {
  iNSCount = aCount;
  }

void TDnsHeader::SetAdditionalRCount(TUint16 aCount)
  {
  iARCount = aCount;
  }
	
#endif //__TDNSHEADER_INL__

