/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/


#include "crdtypeptr.h"


CRdTypePtr::CRdTypePtr():CDnsResourceData()          
	{
	}

EXPORT_C CRdTypePtr* CRdTypePtr::NewL()
	{
	return (new(ELeave)CRdTypePtr());
	}

EXPORT_C CRdTypePtr::~CRdTypePtr()
	{
	iDomainName.Close();
	}

EXPORT_C const TDesC8& CRdTypePtr::DomainName()const
	{
	return iDomainName;
	}

EXPORT_C void CRdTypePtr::SetDomainNameL(const TDesC8& aDomainName)
	{
	iDomainName.Close();
	iDomainName.CreateL(aDomainName);
	}

EXPORT_C TUint16 CRdTypePtr::Size()const
	{
	TUint16 count = 0;
	count += iName.Size();
	count += 2; // 2 bytes = descriptor length+ 0 length octet at the end
	count += sizeof(iType);
	count += sizeof(iClass);
	count += sizeof(iTtl);
	count += sizeof(iRdLength);
	count += iDomainName.Size();
	count += 2; // 2 bytes = descriptor length+ 0 length octet at the end
	return count;	
	}


