// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// cmessagehandler.h
// 
//
/**
@file
@internalTechnology
*/

#ifndef __CMESSAGEHANDLER_H__
#define __CMESSAGEHANDLER_H__

//System include
#include <e32base.h>
#include <es_sock.h>
#include <mdns/mdnscachemgr.h>
#include <mdns/cdnsmessage.h>
#include <mdns/cdnsresourcedata.h>
#include <mdns/dnsconstants.h>

//user include
#include "cmdnscachemanager.h"
#include "msockethandlerobserver.h"
#include "csockethandler.h"
#include "csendmessagequeue.h"
#include "mdnsserver.h"
#include "mmessagehandler.h"
#include "mdnsdebug.h"

//
_LIT8(KTcpProtocolType, "_tcp.");
_LIT8(KUdpProtocolType, "_udp.");
_LIT8(KLocalTld, "local");
//
class CBaseHandler;
class CQueryHandler;
class CResponseHandler;
class CAdvertizeHandler;

	
/**

Derives from the abstract class MSocketHandlerObserver 
This instance of this will be owned by the bonjour server.
This holds an instance of 
1.iRecieveSocket Pointer to CSocketHandler which continously reads packet from the mdns port .
2.iOperationHandler Pointer to CBaseHandler ,
3.iSendMessageQueue Pointer to CSendMessageQueue Any resonse ,query or advertizig packet to be sent ,should be added to send message queue.
4.iServer Used to notify server on any new service arrival.
5.iDnsCache pointer to dnscache 

*/
class CMessageHandler : public CBase, public MSocketHandlerObserver
	{
	
	public:
		static CMessageHandler* NewL(CMdnsServer& aServer);
		MDNSCacheMgr& DnsCache()const;
		//Derived from MSocketHandlerObserver
		virtual void OnCompletionL(TDesC8& aData, const TSockAddr& aAddr, TInt length ) ;
		virtual void OnError(TInt aError);
		~CMessageHandler();
		void ServiceClientQueryL(CDnsMessage* aMessage,TInt aHandle);
		CSendMessageQueue& MessageQueue()const;
		void NotifyClientQuery(TInt aClientHandle);
		void NotifyServicePublishL(const RBuf8& aName,TInt aError, TInt aSessionId);
		void SendQueryL(CDnsMessage* aMessage, MMessageHandler& aObserver);
		void AdvertizePacketL(const RPointerArray<CDnsResourceData> aData, TInt aSessionId ,TBool aIsUpdate=EFalse);
		void SetStateHostProbing(TBool aProbing);
		void NotifyNewServiceL(const RArray<RBuf8>& aName);
		CMdnsServer& Server();
	private:
		CMessageHandler(CMdnsServer& aServer);
		void ConstructL();
		
		void HandleIncomingPacketL(TDesC8& aData, const TSockAddr& aAddr, TInt length);
		CBaseHandler& GetHandlerL(CDnsMessage& aMessage);
		
	private:
		CSocketHandler* iRecieveSocket;
		CQueryHandler* iQueryHandler;
		CResponseHandler* iResponseHandler;
		CAdvertizeHandler* iAdvertizeHandler;
		CSendMessageQueue* iSendMessageQueue;
		CMdnsServer& iServer;
		HBufC8* iPacket;
		MDNSCacheMgr* iDnsCache;	
		CBaseHandler* iDummyhandler;
		/**
		    *FLOGGER debug trace member variable.
		    */
		    __FLOG_DECLARATION_MEMBER_MUTABLE;
	};

#endif
