/*
* Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/

#ifndef CONTACTINFO_H_
#define CONTACTINFO_H_

#include <BAUTILS.H> 

class CContactInfo : public CBase
    {
    public:
        
        static CContactInfo* NewL();
        static CContactInfo* NewLC();
        
        ~CContactInfo();
        
        const TDesC8& ContactName()const;
        void SetContactName(const TDesC8& aContactName);
        
        const TDesC8& CurrentlyPlaying()const;
        void SetCurrentlyPlaying(const TDesC8& aCurrentlyPlaying);
        
        const TDesC8& Status()const;
        void SetStatus(const TDesC8& aStatus);
        //Create the contact-specific directory,
              
        //To get the file 
        void SetContactDirectory();
        void StoreContactDirectory(const TDesC8& aContactDirectory);
        const TDesC8& ContactDirectory();
        const TDesC8& IconFilePath(const TDesC8& aIconFile);
        const TDesC8& IconPath();
        const TDesC8& FileListPath(const TDesC8& aFileListName);
        const TDesC8& FilePath(const TDesC8& aFileName);
        const TDesC8& ImgFileName();
        const TDesC8& MusicFileName();
        const TDesC8& VideoFileName();


        //Base Url for the host, on the n/w (in Ip addr form) 
        //Set base Url & filename to get Absolute filename
        void SetBaseUrl(const TDesC8& aBaseUrl);
        const TDesC8& BaseUrl()const;
        const  TDesC8& FileUrl(const TDesC8& aFileName);
        
        
        //Checks if the file has already been downloaded
        TBool HasBeenDownloadedL(const TDesC8& aFileName);
                
        
        
    private:
        
        CContactInfo();
        void ConstructL();    
    
    private:

        //Contact name :Key
        RBuf8 iContact;
                
        //Directory in which the contact details are stored
        //Every contact will have different directory - on client
        RBuf8 iContactDirectory;
        
        //The path in which Icon is stored
        RBuf8 iIconPath;
        
        //The Path in which all the Info related to Contact's data is stored
        RBuf8 iFileListPath;
        RBuf8 iFilePath;

		//BaseUrl of the particular contact over the network
		RBuf8 iBaseUrl;

        //Current file's Url (file name)
        RBuf8 iFileUrl;
        
        RBuf8 iImgFile;
        RBuf8 iMusicFile;
        RBuf8 iVideoFile;
        
        //Currently Playing 
        RBuf8 iCurrentlyPlaying; 
        
        RBuf8 iStatus;
        
        RFs iFs;
        RFile iFile;
    };



#endif /* CONTACTINFO_H_ */
