/*
* Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/

#include "musicprovider.h"
#include <mpxplaybackframeworkdefs.h>
#include <mpxplaybackmessage.h>
#include <mpxmedia.h>
#include <mpxmediageneraldefs.h>
#include <mpxmediamusicdefs.h>
#include <mpxmessagegeneraldefs.h>
#include <mpxplaybackmessagedefs.h>
#include "zeroconfsharing.h"
//#include "zeroconfconsole.h"

const TInt KMax =1024;

CMusicProvider* CMusicProvider::NewL(MNowPlayObserver* aOb)
    {
    CMusicProvider* me = new(ELeave) CMusicProvider(aOb);
    CleanupStack::PushL(me);
    me->ConstructL();
    CleanupStack::Pop(me);
    return me;
    }

void CMusicProvider::ConstructL()
    {
    iPlaybackUtility = MMPXPlaybackUtility::NewL(KPbModeActivePlayer, this);
    }

CMusicProvider::~CMusicProvider()
    {
    if ( iPlaybackUtility )
        {
        iPlaybackUtility->Close();
        }
    iPreviousTrack.Close();
 //   iBuf.Close();
    }
    
CMusicProvider::CMusicProvider(MNowPlayObserver* aOb):iPlaybackUtility(NULL)
    {
    iObserver = aOb;
//    iBuf.CreateL(KMax);
    }
    

void CMusicProvider::HandlePropertyL(TMPXPlaybackProperty /*aProperty*/,
                             TInt /*aValue*/, 
                             TInt /*aError*/)
    {
    // do nothing
    }

void CMusicProvider::HandleSubPlayerNamesL(TUid /*aPlayer*/, 
                                   const MDesCArray* /*aSubPlayers*/,
                                   TBool /*aComplete*/,
                                   TInt /*aError*/
                                   )
    {
    // do nothing
    }


void CMusicProvider::HandlePlaybackMessage( CMPXMessage* aMessage, TInt aError )
    {
    if ( aError == KErrNone && aMessage )
        {
        TRAP_IGNORE( DoHandlePlaybackMessageL( *aMessage ) );
        }
    }

void CMusicProvider::DoHandlePlaybackMessageL( const CMPXMessage& aMessage )
    {
    TMPXMessageId id( aMessage.ValueTObjectL<TMPXMessageId>( KMPXMessageGeneralId ) );
    if ( KMPXMessageGeneral == id )
        {
        TInt event( aMessage.ValueTObjectL<TInt>( KMPXMessageGeneralEvent ) );
        switch ( event )
               {
               case TMPXPlaybackMessage::EMediaChanged:
                 {
                 RequestMediaL();
                 break;
                 }
               default:
                 {
                 break;
                 }
               }
        }
    }

void CMusicProvider::RequestMediaL()
    {   
    MMPXSource* s = iPlaybackUtility->Source();
    if ( s )
        {
        RArray<TMPXAttribute> attrs;
        CleanupClosePushL(attrs);
        attrs.Append( KMPXMediaGeneralTitle );
        s->MediaL( attrs.Array(), *this );
        CleanupStack::PopAndDestroy(&attrs);
        }
    }

void CMusicProvider::HandleMediaL(const CMPXMedia& aProperties,
                          TInt aError)
    {
    if ( KErrNone == aError )
        {
        if(aProperties.IsSupported(KMPXMediaGeneralTitle))
            {
            RBuf title;
            title.CreateL(aProperties.ValueText(KMPXMediaGeneralTitle));

            if(title.Compare(iPreviousTrack)!=0)
                {
                iPreviousTrack.Close();
                iPreviousTrack.CreateL(title);
                iObserver->NowPlaying(title);   
                }
            
            title.Close();
            }
        }
    }
