/*
* Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/

#include "zeroconfclient.h"
#include "e32math.h"

#include <in_sock.h>
#include <ecom/ecom.h>
const TUint KPublishTierId = 0x2001DC8A;

CZeroconfClient* CZeroconfClient::NewL(MPnPObserver* aObserver)
	{
	CZeroconfClient* self = CZeroconfClient::NewLC(aObserver);
	CleanupStack::Pop(self);
	return self;
	}
	

CZeroconfClient* CZeroconfClient::NewLC(MPnPObserver* aObserver)
	{
	CZeroconfClient* self = new (ELeave) CZeroconfClient(aObserver);
	CleanupStack::PushL(self);
	self->ConstructL();
	return self;
	}



void CZeroconfClient::ConnectL()
	{
  
    GetBTName();    
    TInt openStatus1 = iServicePublish.Open(KPublishTierId);
    const TUint KTestTierId = 536924288;
    TInt openStatus = iControlPoint.Open(KTestTierId);
	//
	}

CZeroconfClient::~CZeroconfClient()
	{
	iServicePublish.Close();
	iControlPoint.Close();
	iBTName.Close();
	REComSession::FinalClose();
	}
	
CZeroconfClient::CZeroconfClient(MPnPObserver* aObserver)
	{
	iMdnsObserver = aObserver;
	}
	
void CZeroconfClient::ConstructL()
	{

	}

void CZeroconfClient::GetBTName()
    {
    iBTName.CreateL(KMaxFileName);
    TInt rand = Math::Random()%100;
    iBTName.Num(rand);
    
    }

void CZeroconfClient::PublishMyService(const TDesC8& aBaseUrl,const TDesC8& aFileList,const TDesC8& aIconName)
    {
    RPnPParameterBundle pnpBundle;
    pnpBundle.Open ();
        //CleanupClosePushL( pnpBundle );
    RParameterFamily srvFamily = pnpBundle.CreateFamilyL (EMdnsSrvParamset);
    RParameterFamily txtFamily = pnpBundle.CreateFamilyL (EMdnsTxtParamset);
    RParameterFamily ptrFamily = pnpBundle.CreateFamilyL (EMdnsPtrParamset);
        //Srv Record
    pnpBundle.SetPnPObserver((MPnPObserver*)iMdnsObserver);
    CMDnsSrvParamSet* srvParam = CMDnsSrvParamSet::NewL(srvFamily);
        //CleanupStack::PushL(srvParam);
    RBuf8 serviceName;
    serviceName.CreateL(KMaxFileName);
    serviceName.Append(_L8("DeviceService"));
    serviceName.Append(iBTName.Collapse());
    serviceName.Append(_L8("._daap._tcp.local"));
    srvParam->SetDomainNameL(serviceName);
    srvParam->SetTargetL(_L8("2IND50001.Local"));
    srvParam->SetPriority(2);
    srvParam->SetWeight(100);
    srvParam->SetPort(80);
    
    CMDnsPtrParamSet* ptrParam = CMDnsPtrParamSet::NewL(ptrFamily);
    ptrParam->SetInstanceNameL(_L8("_daap._tcp.local"));
    ptrParam->SetDomainNameL(serviceName);
        //Txt record
    CMDnsTxtParamSet* txtParam = CMDnsTxtParamSet::NewL(txtFamily);
    //CleanupStack::PushL(txtParam);
    txtParam->SetDomainNameL(serviceName);
    RBuf8 baseUrl,fileUrl,iconUrl;
   
    //data3 contains the base ip addr
    baseUrl.Create(KMaxPath);
    fileUrl.Create(KMaxFileName);
    iconUrl.Create(KMaxFileName);
    
    //data4 contains the filelist name
    baseUrl.Append(_L8("BaseUrl = "));
    baseUrl.Append(aBaseUrl);
    
    fileUrl.Append(_L8("FileUrl = "));
    fileUrl.Append(aFileList);
    
    iconUrl.Append(_L8("IconUrl = "));
    iconUrl.Append(aIconName);
    
    txtParam->AppendTxtData(baseUrl);
    txtParam->AppendTxtData(fileUrl);
    txtParam->AppendTxtData(iconUrl);
    
    iServicePublish.Publish(pnpBundle);
    pnpBundle.Close();
    
    baseUrl.Close();
    fileUrl.Close();
    iconUrl.Close();
    serviceName.Close();
    }

void CZeroconfClient::PublishNowPlayingServiceL(TDes& aTitleBuf)
    {
    TInt openStatus1 = iMusicPublish.Open(KPublishTierId);
    
    RPnPParameterBundle pnpBundle;
    pnpBundle.Open ();
    CleanupClosePushL( pnpBundle );
    RParameterFamily srvFamily = pnpBundle.CreateFamilyL (EMdnsSrvParamset);
    RParameterFamily txtFamily = pnpBundle.CreateFamilyL (EMdnsTxtParamset);
    //Srv Record

    pnpBundle.SetPnPObserver((MPnPObserver*)iMdnsObserver);
    
    CMDnsSrvParamSet* srvParam = CMDnsSrvParamSet::NewL(srvFamily);
    //CleanupStack::PushL(srvParam);
    RBuf8 serviceName;
    serviceName.CreateL(KMaxFileName);
    serviceName.Append(_L8("MusicService"));
    serviceName.Append(iBTName.Collapse());
    serviceName.Append(_L8("._daap._tcp.local"));
    
    srvParam->SetDomainNameL(serviceName);
    srvParam->SetTargetL(_L8("2IND04990.Local"));
    srvParam->SetPriority(2);
    srvParam->SetWeight(100);
    srvParam->SetPort(80);
    //Txt record
    RBuf8 data;
    TUint KMaxLength(255);
    data.CreateL(_L8("Now playing = "),KMaxLength);
    data.Append(aTitleBuf.Collapse());  
    CMDnsTxtParamSet* txtParam = CMDnsTxtParamSet::NewL(txtFamily);
    //CleanupStack::PushL(txtParam);
    txtParam->SetDomainNameL(serviceName); 
    txtParam->AppendTxtData(data);  
    iServicePublish.Publish(pnpBundle); 
    data.Close();
    serviceName.Close();
    CleanupStack::PopAndDestroy(1);//pnpBundle
    
    }     

void CZeroconfClient::UpdateNowPlayingServiceL(TDes& aTitleBuf)
    {
    RPnPParameterBundle pnpBundle;
    pnpBundle.Open ();
    pnpBundle.SetPnPObserver((MPnPObserver*)iMdnsObserver);

    RParameterFamily srvFamily = pnpBundle.CreateFamilyL (EMdnsSrvParamset);
    RParameterFamily txtFamily = pnpBundle.CreateFamilyL (EMdnsTxtParamset);
    //update Publish 
    //pnpBundle.ClearAllParameters(RParameterFamily::ERequested);
    RParameterFamily publishFamily = pnpBundle.CreateFamilyL (EMdnsPublishParamset);
    CMDnsPublishParamSet* publishParam = CMDnsPublishParamSet::NewL(publishFamily);
    publishParam->SetPublishUpdate(ETrue);
    CMDnsSrvParamSet* srvParam = CMDnsSrvParamSet::NewL(srvFamily);
    //CleanupStack::PushL(srvParam);
    RBuf8 serviceName;
    serviceName.CreateL(KMaxFileName);
    serviceName.Append(_L8("MusicService"));
    serviceName.Append(iBTName.Collapse());
    serviceName.Append(_L8("._daap._tcp.local"));
    
    srvParam->SetDomainNameL(serviceName);
    srvParam->SetTargetL(_L8("2IND04990.Local"));
    srvParam->SetPriority(2);
    srvParam->SetWeight(100);
    srvParam->SetPort(80);
    //Txt record
    RBuf8 data;
    TUint KMaxLength(255);
    data.CreateL(_L8("Now playing = "),KMaxLength);
    data.Append(aTitleBuf.Collapse());   
    CMDnsTxtParamSet* txtParam = CMDnsTxtParamSet::NewL(txtFamily);
    //CleanupStack::PushL(txtParam);
    txtParam->SetDomainNameL(serviceName); 
    txtParam->AppendTxtData(data);
    iServicePublish.Publish(pnpBundle); 
    data.Close();
    serviceName.Close();
    pnpBundle.Close();        
    }
void CZeroconfClient::PublishCurrentStatusServiceL(const TDesC8& aStatus)
    {
    TInt openStatus1 = iStatusPublish.Open(KPublishTierId);
    RPnPParameterBundle pnpBundle;
    pnpBundle.Open ();
    CleanupClosePushL( pnpBundle );
    RParameterFamily srvFamily = pnpBundle.CreateFamilyL (EMdnsSrvParamset);
    RParameterFamily txtFamily = pnpBundle.CreateFamilyL (EMdnsTxtParamset);
    //Srv Record

    pnpBundle.SetPnPObserver((MPnPObserver*)iMdnsObserver);
    
    CMDnsSrvParamSet* srvParam = CMDnsSrvParamSet::NewL(srvFamily);
    //CleanupStack::PushL(srvParam);
    
    RBuf8 serviceName;
    serviceName.CreateL(KMaxFileName);
    serviceName.Append(_L8("StatusService"));
    serviceName.Append(iBTName.Collapse());
    serviceName.Append(_L8("._daap._tcp.local"));
    
    srvParam->SetDomainNameL(serviceName);
    
    srvParam->SetTargetL(_L8("2IND04990.Local"));
    srvParam->SetPriority(2);
    srvParam->SetWeight(100);
    srvParam->SetPort(80);
    //Txt record
    RBuf8 data;
    TUint KMaxLength(255);
    data.CreateL(_L8("Status = "),KMaxLength);
    data.Append(aStatus);  
    CMDnsTxtParamSet* txtParam = CMDnsTxtParamSet::NewL(txtFamily);
    //CleanupStack::PushL(txtParam);
    txtParam->SetDomainNameL(serviceName); 
    txtParam->AppendTxtData(data);  
    iServicePublish.Publish(pnpBundle); 
    data.Close();
    serviceName.Close();
    CleanupStack::PopAndDestroy(1);//pnpBundle
    
    }     

void CZeroconfClient::UpdateCurrentStatusServiceL(const TDesC8& aStatus)
    {
    RPnPParameterBundle pnpBundle;
    pnpBundle.Open ();
    pnpBundle.SetPnPObserver((MPnPObserver*)iMdnsObserver);

    RParameterFamily srvFamily = pnpBundle.CreateFamilyL (EMdnsSrvParamset);
    RParameterFamily txtFamily = pnpBundle.CreateFamilyL (EMdnsTxtParamset);
    //update Publish 
    //pnpBundle.ClearAllParameters(RParameterFamily::ERequested);
    RParameterFamily publishFamily = pnpBundle.CreateFamilyL (EMdnsPublishParamset);
    CMDnsPublishParamSet* publishParam = CMDnsPublishParamSet::NewL(publishFamily);
    publishParam->SetPublishUpdate(ETrue);
    CMDnsSrvParamSet* srvParam = CMDnsSrvParamSet::NewL(srvFamily);
    //CleanupStack::PushL(srvParam);
    
    RBuf8 serviceName;
    serviceName.CreateL(KMaxFileName);
    serviceName.Append(_L8("StatusService"));
    serviceName.Append(iBTName.Collapse());
    serviceName.Append(_L8("._daap._tcp.local"));
    
    srvParam->SetDomainNameL(serviceName);
    srvParam->SetTargetL(_L8("2IND04990.Local"));
    srvParam->SetPriority(2);
    srvParam->SetWeight(100);
    srvParam->SetPort(80);
    //Txt record
    RBuf8 data;
    TUint KMaxLength(255);
    data.CreateL(_L8("Status = "),KMaxLength);
    data.Append(aStatus);   
    CMDnsTxtParamSet* txtParam = CMDnsTxtParamSet::NewL(txtFamily);
    //CleanupStack::PushL(txtParam);
    txtParam->SetDomainNameL(serviceName); 
    txtParam->AppendTxtData(data);
    iServicePublish.Publish(pnpBundle); 
    data.Close();
    serviceName.Close();
    pnpBundle.Close();        
    }
void CZeroconfClient::PublishService()
	{
    RPnPParameterBundle pnpBundle;
    pnpBundle.Open ();
    //CleanupClosePushL( pnpBundle );
    RParameterFamily srvFamily = pnpBundle.CreateFamilyL (EMdnsSrvParamset);
    RParameterFamily txtFamily = pnpBundle.CreateFamilyL (EMdnsTxtParamset);
    //Srv Record

    pnpBundle.SetPnPObserver((MPnPObserver*)iMdnsObserver);
    
    CMDnsSrvParamSet* srvParam = CMDnsSrvParamSet::NewL(srvFamily);
    //CleanupStack::PushL(srvParam);
    srvParam->SetDomainNameL(_L8("xyz._daap._tcp.local"));
    srvParam->SetTargetL(_L8("2IND04990.Local"));
    srvParam->SetPriority(2);
    srvParam->SetWeight(100);
    srvParam->SetPort(80);
    //Txt record
    CMDnsTxtParamSet* txtParam = CMDnsTxtParamSet::NewL(txtFamily);
    //CleanupStack::PushL(txtParam);
    txtParam->SetDomainNameL(_L8("xyz._daap._tcp.local")); 
    RBuf8 data1,data2;
    data1.Create(_L8("vadan = ct "));
    data2.Create(_L8("prakash  = sharma "));
    txtParam->AppendTxtData(data1);
    txtParam->AppendTxtData(data2);
    iServicePublish.Publish(pnpBundle);	
    pnpBundle.Close();
    data1.Close();
    data2.Close();
	}
	
void CZeroconfClient::WriteServices()
	{
    RPnPParameterBundle pnpBundle;
    pnpBundle.Open ();
    pnpBundle.SetPnPObserver((MPnPObserver*)iMdnsObserver);
    RParameterFamily pnpFamily = pnpBundle.CreateFamilyL (EMdnsRegisterNotifyParamset);
    CMDnsRegisterNotifyParamSet* registerParam = CMDnsRegisterNotifyParamSet::NewL(pnpFamily);
    _LIT8(KInstance,"_daap._tcp.local");
    registerParam->SetInstanceNameL(KInstance);
    iControlPoint.RegisterNotify(pnpBundle);	
    pnpBundle.Close();
	}

void CZeroconfClient::WriteServiceTypes()
	{
	
	_LIT8(KInstance,"");
    _LIT8(KServiceType,"_daap.");
    RPnPParameterBundle pnpBundle;
    
    pnpBundle.Open ();
    
    pnpBundle.SetPnPObserver((MPnPObserver*)iMdnsObserver);
    RParameterFamily pnpFamily = pnpBundle.CreateFamilyL (EMDnsDiscoverRequestParamSet);
    CMDnsQueryRequestParamSet* queryParam = CMDnsQueryRequestParamSet::NewL(pnpFamily);

    queryParam->SetInstanceNameL(KInstance);
    queryParam->SetQueryTypeL(EDnsQType_Any);
    queryParam->SetProtocol(1);
    queryParam->SetServiceTypeL(KServiceType);
    
    User::After(5000000);
    iControlPoint.Discover(pnpBundle);
    pnpBundle.Close();
	
	}

void CZeroconfClient::GetService(const TDesC8& aInstanceName,TDnsType aType)
    {
    _LIT8(KServiceType,"_daap.");
    RPnPParameterBundle pnpBundle;
    
    pnpBundle.Open ();
    
    pnpBundle.SetPnPObserver((MPnPObserver*)iMdnsObserver);
    RParameterFamily pnpFamily = pnpBundle.CreateFamilyL (EMDnsDiscoverRequestParamSet);
    CMDnsQueryRequestParamSet* queryParam = CMDnsQueryRequestParamSet::NewL(pnpFamily);

    queryParam->SetInstanceNameL(aInstanceName);
    queryParam->SetQueryTypeL(aType);
    queryParam->SetProtocol(1);
    queryParam->SetServiceTypeL(KServiceType);
    
    
    iControlPoint.Discover(pnpBundle);
    pnpBundle.Close();
    }


void CZeroconfClient::SearchService()
	{}

void CZeroconfClient::UnPublishServices()
    {
        iServicePublish.Close();
        iMusicPublish.Close();
        iStatusPublish.Close();
    }
