/*
* Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/

#ifndef ZEROCONFSHARINGUI_H
#define ZEROCONFSHARINGUI_H

#include <QObject>
#include <QtGui>
#include <QTimer>
#include <QFile>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <f32file.h>

#include "ui_mainwindow.h"
#include "zeroconfclient.h"

#include <mdns/dnsconstants.h>
#include <e32hashtab.h>
#include "musicprovider.h"

class MNowPlayObserver
    {
public:
    virtual void NowPlaying(TDes& aTitleBuf) = 0;
    };


class CHttpServer;
class CHttpClient;
class CContactInfo;

class QZeroConfSharingUi : public QMainWindow , MPnPObserver, MNowPlayObserver
{
    Q_OBJECT

public:
	QZeroConfSharingUi(QWidget *parent = 0);
    ~QZeroConfSharingUi();
    
    void setIcon(const QIcon &icon);
    void setSize(const QSize &size);
    
    void OnPnPEventL (RPnPParameterBundleBase& aServiceEventInfo);
    void OnPnPError (TInt aError);

    void DiscoverServices();
    void GetSrvInfo(const TDesC8& aQueryString,TDnsType aType);
    void PublishService();
    void FetchBaseUrl(RArray <RBuf8> aTxtData);
    void FetchIconUrl(RArray <RBuf8> aTxtData);
    void FetchFileUrl(RArray <RBuf8> aTxtData);
    void FetchCurrentlyPlaying(RArray <RBuf8> aTxtData);
    void FetchStatus(RArray <RBuf8> aTxtData);

    void PublishMyService(const TDesC8& afilelist,const TDesC8& aIconName);
    CContactInfo* Clone(CContactInfo* aContact);
    
    void NowPlaying(TDes& aTitleBuf);
    
    CContactInfo* Create_Icon_Contact();
    
    void ShowCur_Status_and_Track();
    
private:
    enum TCommand
        {
        EStart = 1,
        EStop,
        EExit,
        };
    
    enum TTabEnum
        {
        ETabContacts,
        ETabContact,
        ETabMusic,
        ETabVideo,
        ETabChat,
        ETabFileSharing
        };

    QTabWidget* tabWidget;
    //Ui::ContactTabWidget* contactWidget;
    QTimer* iTimer;

    QStringList iContacts;
    QStringList iCommunities;
    QString iSelectedContact;
    QString iSelectedFileListName;
    QString iSelectedFileName;
    
    void PopulateUserList();
    void PopulateCommunityList();
    void ShowAllContacts(bool aShow);
    void ShowBackButtons(bool aShow);
    void PopulateMainWindow(QString qname);
    void RequestSharedContent();
    void Log(const char* msg);
    
    CContactInfo* GetSelectedContact(const TDesC8& aConatactName);
    
    void PopulateContactSpecificData();
    void ReadFile();
    Ui::MainWindow ui;
    bool isShared;
    
    CZeroconfClient* iZeroConfClient;
    CMusicProvider* iMusic;
    RPointerArray <CContactInfo> iEntries;
    RBuf8 iSrvName;
    
    RBuf8 iPublishBaseUrl;
    
    RBuf8 iBaseUrl;
    RBuf8 iIconName;
    RBuf8 iFileName;
    RBuf8 iCurrentlyPlaying;
    RBuf8 iContactName;
    RBuf8 iStatus;
    
    CContactInfo* iNewContact;
    //@ TODO remove later
    //TInt iCount;
    //TBool isPresent;
    
    
    QAction* shareAction;
    QAction* unshareAction;
    CHttpServer* iHttpServer;
    //CHttpClient* iHttpClient;
    TBool iStatusUpdate;
    QFile iGenericFile;
    QByteArray filename;

    QNetworkAccessManager *manager;
    QNetworkReply *reply;
    QNetworkReply *itemReply;
    QProgressDialog* progressBar;
    
    //Flag to keep track whether to publish/ update service
    TBool                               iUpdate;
    //TBool IsDownloadItem;
    
    //QNetworkAccessManager *manager;
    //QNetworkReply *reply;
    QFile MyStatusFile;     //used for persistence storage of
                            //status string
    QString nowStatus;      //stores the current status of string
    
    QFile logFile;
private slots:
    void on_pushBackFile_clicked();
    void on_pushBackChat_clicked();
    void on_pushBackVideo_clicked();
    void on_pushBackMusic_clicked();
    void on_pushBackContact_clicked();
    void on_listAvatars_itemClicked(QListWidgetItem* item);
    void RequestFinished();    
    void ItemRequestFinished();
    void StartServer();
    void backPressed();
    void StopServer();
    void ContactitemClicked(QTreeWidgetItem* item, int column);
    void ProgressBarCanceled();    
    void UpdateMyStatus();
    
};

#endif // ZEROCONFSHARINGUI_H
