/*
* Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/
#ifndef CMDNSCACHEMANAGER_H_
#define CMDNSCACHEMANAGER_H_

#include <e32base.h>

#include "cmdnscachemap.h"
#include "mdnscachemgr.h"

class CMDNSCacheManager : public CBase,public MDNSCacheMgr
	{
	public:

	IMPORT_C static CMDNSCacheManager* NewL(TUint aMaxCacheEntries);
	IMPORT_C static CMDNSCacheManager* NewLC(TUint aMaxCacheEntries);
	IMPORT_C static CMDNSCacheManager* NewL();
	
	//From MDNSCacheMgr
	IMPORT_C void UpdateCacheL(CDnsResourceData& aEntry,TBool aAuthoritative,TUint32 aSessionId);
	IMPORT_C TInt FindServiceL(RPointerArray <CCacheEntry> & aEntries,const TDesC8& aName,TDnsType aType)const;
	IMPORT_C TInt DeleteEntryL(const TDesC8& aServiceInstanceName);
	IMPORT_C void FlushCache();		
	IMPORT_C CCacheEntry* NextStaleEntry(TBool aActiveCacheMgmtEnabled,TBool aIteratorReset);
	IMPORT_C void AuthoritativeEntriesL(RPointerArray <CCacheEntry> & aEntries);
	IMPORT_C TUint NumberOfEntries();
	IMPORT_C void DumpCacheL();
	
	
	IMPORT_C TUint32 CacheEntryCount();

	~CMDNSCacheManager();

	private:
	
	void CacheEntryL(CCacheEntry* aTargetEntry,const CServiceInfo* aSourceEntry)const;
	void UpdateCacheEntry(CServiceInfo* aEntry,CDnsResourceData* aRecordInfo);
	CMDNSCacheManager();
	void ConstructL(TUint aMaxCacheEntries);

	private:

	CMDNSCacheMap* iHashMap;
	
	RPointerArray <CServiceInfo> iAuthoritativeEntries;
		
	};

#endif /*CMDNSCACHEMANAGER_H_*/
