// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// csockethandler.h
// 
//
/**
@file
@internalTechnology
*/
#ifndef __CSOCKETHANDLER_H__
#define __CSOCKETHANDLER_H__

//System include
#include <e32base.h>
#include <in_sock.h>
#include <es_mbuf.h>


//User include 
#include "msockethandlerobserver.h"
#include "mdnsdebug.h"

/*
	1.	 This is an Active Object which can be activated to recieve or 
	 send asynchronusly as per the operation list mentioned.An Observer should be
	 provided at the time of construction so as to notify the success or failure of 
	 opertion.The client using CSocketHandler should implement the observer class 
	 MSOcketHandlerObserver.
 
	2.	 Maximum size of the packet this could either send or recieve is KMaxDnsPacketSize = 9216
	
	3.	TSocketHandlerParams-- This is typedef from TIpcArgs ,which can hold an 
	  	pointer to an array of four variables.
	  	a.	The first variable it is pointing to should specify the operation(TSocketOPeration).
	  	b.  Second should provide the packet to be send .
	  	c.	Third should provide the address to which it should be send.
	
  
 */

const TInt KDefaultFlags = 0;
//const TInt KMaxDnsPacketSize = 9216;

enum TSocketOperation
			{
			ESocketIdle,
			ESocketSend,
			ESocketSendTo,
			ESocketRecieve,
			ESocketRecieveFrom,	
			};
			
typedef TIpcArgs TSocketHandlerParams;
			
class CSocketHandler : public CActive
	{
	public:
		
		static CSocketHandler* NewL(RSocket& aSocket, MSocketHandlerObserver& aObserver, TSocketOperation aOperation); 	
		void Activate ( const TSocketHandlerParams& aParams );
		~CSocketHandler();
				
	private:
		CSocketHandler(RSocket& aSocket, MSocketHandlerObserver& aObserver, TSocketOperation aOperation);
		void ConstructL();
		void CompleteSelf ( TInt aError );
		void CancelCurrent();
		void NotifyCompletionL( );
		
		//Derived from CActive
		void RunL();
		void DoCancel();
		TInt RunError(TInt aError);
		
	private:
		HBufC8*					iPacketBuffer;
		TPtr8					iPacketPtr;
		TSockAddr				iSockAddr;
		TSocketOperation 		iOperation;
		RSocket&					iSocket;
		MSocketHandlerObserver& iObserver;
		TSockXfrLength 			iLength;
		/**
		    *FLOGGER debug trace member variable.
		    */
		    __FLOG_DECLARATION_MEMBER_MUTABLE;
	};
	
#endif
	
