// Copyright (c) 2008-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
// mdns.cpp
// 
//
/**
@file
@internalTechnology
*/

#include <e32base.h>
#include <f32file.h>
#include "mdnsserver.h"

void MainL()
    {
        
    CActiveScheduler* sched = new (ELeave) CActiveScheduler;
    CleanupStack::PushL(sched);
    CActiveScheduler::Install(sched);
    	
    CMdnsServer::NewLC();
    RProcess::Rendezvous(KErrNone);
 	CActiveScheduler::Start();
 	

    
    CleanupStack::PopAndDestroy(); 
    CleanupStack::PopAndDestroy();
    
	}

TInt E32Main()
	{
	// --------- check memory leak -------------
	__UHEAP_MARK;
	CTrapCleanup* cleanup = CTrapCleanup::New();
	TInt err = KErrNone;
	if (cleanup)
		{
		TRAPD(err, MainL());
		delete cleanup;
		}
	__UHEAP_MARKEND;
	return err;
	}
