/*
* Copyright (c) 2001-2008 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/

#ifndef FILELISTENGINE_H
#define FILELISTENGINE_H

// INCLUDES
#include <e32std.h>
#include <e32base.h>
#include <f32file.h>

class CFileListEngine : public CBase
    {
public:
   
    enum TDirOption{
        EDirPhotos,
        EDirMusic,
        EDirVideos
    };
    
    ~CFileListEngine();

    static CFileListEngine* NewL();
   
    static CFileListEngine* NewLC();    
    
    void GetAllMediaContent();
    
    TInt SetOutputFileName(const TDesC& aFileName);
    
    TDirOption getDirectory();
    
    void WriteEndTag();
    
private:

    CFileListEngine();

    void ConstructL();
    
    void SetDirectory(TDirOption aOption);
    
    //get the specific directory
    void StartFileListL();
    
    void GetResourceFilesL ( RBuf &aBasePath );
    
    TInt AcceptedExtension(TPtr aPtr);
    
private:
    RArray<TEntry> iFileList;
    RArray<TFileName> iDirList;
    RFs iFsSession;
    RFile iFile;
    TFileName iSysDirName;
    TDirOption iDirectory;

    };

#endif // FILELISTENGINE_H
