/*
* Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: 
*
*/
#include <contactinfo.h>

_LIT8(KPath,"C:\\Data\\ZeroConf\\");

const TUint MaxLength= 255;


CContactInfo* CContactInfo::NewL()
    {
    CContactInfo* self = CContactInfo::NewLC();
    CleanupStack::Pop(self);
    return self;
    }
        
CContactInfo* CContactInfo::NewLC()
    {
    CContactInfo* self = new (ELeave) CContactInfo();
    CleanupStack::PushL(self);
    self->ConstructL();
    return self;
    }
        
CContactInfo::CContactInfo()
    {
    
    }
    
void CContactInfo::ConstructL()
    {
    iFs.Connect();
    }
        
CContactInfo::~CContactInfo()
    {
    iFs.Close();
    iContact.Close();
    iCurrentlyPlaying.Close();
    iContactDirectory.Close();
    iFileUrl.Close(); 
    iIconPath.Close();
    iBaseUrl.Close();
    iFileUrl.Close();
    iImgFile.Close();
    iMusicFile.Close();
    iVideoFile.Close();
    iFilePath.Close();
    }
        
const TDesC8& CContactInfo::ContactName()const
    {
    return iContact;
    }
 
void CContactInfo::SetContactName(const TDesC8& aContactName)
    {
    iContact.Close();
    iContact.Create(aContactName);
    }
        
const TDesC8& CContactInfo::CurrentlyPlaying()const
    {
    return iCurrentlyPlaying;
    }
       
void CContactInfo::SetCurrentlyPlaying(const TDesC8& aCurrentlyPlaying)
    {
    iCurrentlyPlaying.Close();
    iCurrentlyPlaying.Create(aCurrentlyPlaying);
    }

const TDesC8& CContactInfo::Status()const
    {
    return iStatus;
    }
       
void CContactInfo::SetStatus(const TDesC8& aStatus)
    {
    iStatus.Close();
    iStatus.Create(aStatus);
    }
        
void CContactInfo::SetContactDirectory()
    {
    iContactDirectory.Close();
    
    _LIT8(KTrailingSlash,"\\");
    TBuf8 <255> path(KPath);
    iContactDirectory.Create(path,MaxLength);
    iContactDirectory.Append(iContact);
    iContactDirectory.Append(KTrailingSlash);
    
    RBuf folder;
    folder.Create(iContactDirectory.Length());
    
    folder.Copy(iContactDirectory);
    
    if(!BaflUtils::FolderExists(iFs,folder))
        {
        iFs.MkDirAll(folder);
        }
    }
const TDesC8& CContactInfo::ContactDirectory()
    {
    return iContactDirectory;
    }

const TDesC8& CContactInfo::ImgFileName()
    {
    _LIT8(KImageFile,"ImageFile.txt");
    iImgFile.Close();
    iImgFile.Create(iContactDirectory,MaxLength);
    iImgFile.Append(KImageFile);
    return iImgFile;
    }

const TDesC8& CContactInfo::MusicFileName()
    {
    _LIT8(KMusicFile,"MusicFile.txt");
    iMusicFile.Close();
    iMusicFile.Create(iContactDirectory,MaxLength);
    iMusicFile.Append(KMusicFile);
    return iMusicFile;
    }

const TDesC8& CContactInfo::VideoFileName()
    {
    _LIT8(KVideoFile,"VideoFile.txt");
    iVideoFile.Close();
    iVideoFile.Create(iContactDirectory,MaxLength);
    iVideoFile.Append(KVideoFile);
    return iVideoFile;
    }

void CContactInfo::SetBaseUrl(const TDesC8& aBaseUrl)
    {
    iBaseUrl.Close();
    iBaseUrl.CreateL(aBaseUrl);
    }
const TDesC8& CContactInfo::BaseUrl()const
    {
    return iBaseUrl;
    }

const  TDesC8& CContactInfo::FileUrl(const TDesC8& aFileName)
    {    
    iFileUrl.Close();    
    iFileUrl.Create(iBaseUrl,MaxLength);
    iFileUrl.Append(aFileName);
    return iFileUrl;
    }

TBool CContactInfo::HasBeenDownloadedL(const TDesC8& aFileName)
    {
    iFileUrl.Close(); 
    RBuf8 contactDir;
    
    contactDir.Create(iContactDirectory.Length());
    contactDir.Copy(iContactDirectory);
    
    iFileUrl.Create(contactDir,MaxLength);
    iFileUrl.Copy(contactDir);
    iFileUrl.Append(aFileName);
    
    RBuf fileName;
    fileName.CreateL(iFileUrl.Length());
    fileName.Copy(iFileUrl);
    
    
    if(BaflUtils::FileExists(iFs,fileName))
        return ETrue;
    else
        return EFalse;
    }


const TDesC8& CContactInfo::IconFilePath(const TDesC8& aIconFile)
    {
    iIconPath.Close();
    iIconPath.Create(iContactDirectory,MaxLength);
    iIconPath.Append(aIconFile);
    return iIconPath;
    }
const TDesC8& CContactInfo::IconPath()
    {
    return iIconPath;
    }

const TDesC8& CContactInfo::FileListPath(const TDesC8& aFileListName)
    {
    iFileListPath.Close();
    iFileListPath.Create(iContactDirectory,MaxLength);
    iFileListPath.Append(aFileListName);
    return iFileListPath;
    }
        
const TDesC8& CContactInfo::FilePath(const TDesC8& aFileName)
    {
    iFilePath.Close();
    iFilePath.Create(iContactDirectory,MaxLength);
    iFilePath.Append(aFileName);
    return iFilePath;
    }



void CContactInfo::StoreContactDirectory(const TDesC8& aContactDirectory)
    {
    iContactDirectory.Close();
    iContactDirectory.Create(aContactDirectory);
    }
        
