/*
* Copyright (c) 2002 - 2007 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  test api of alf_core_toolkit
*
*/



// [INCLUDE FILES]
#include <e32svr.h>
#include <stifparser.h>
#include <stiftestinterface.h>
#include <uiacceltk/huifontspecification.h>
#include <uiacceltk/huiinteractioninterval.h>
#include <uiacceltk/huifontmanager.h>
#include <uiacceltk/huienv.h>
#include <uiacceltk/huipanic.h>
#include <uiacceltk/huithememanager.h>

#include "testuiaifcoretoolkit.h"

// CONSTANTS
//const ?type ?constant_var = ?constant;

// FORWARD DECLARATIONS
//class ?FORWARD_CLASSNAME;

// ============================ MEMBER FUNCTIONS ===============================

// -----------------------------------------------------------------------------
// CTestUiAifCoreToolkit::RunMethodL
// Run specified method. Contains also table of test mothods and their names.
// -----------------------------------------------------------------------------
//
TInt CTestUiAifCoreToolkit::RunMethodL( CStifItemParser& aItem ) 
    {

    static TStifFunctionInfo const KFunctions[] =
        {  
        // First string is the function name used in TestScripter script file.
        // Second is the actual implementation member function.
        //For test HuiAnchorLayout.h
        ENTRY( "TestCHuiAnLayAddNewL",
            CTestUiAifCoreToolkit::TestCHuiAnLayAddNewL ),
        ENTRY( "TestCHuiAnLayDestructL",
            CTestUiAifCoreToolkit::TestCHuiAnLayDestructL ),
        ENTRY( "TestCHuiAnLayResetL",
            CTestUiAifCoreToolkit::TestCHuiAnLayResetL ),
        ENTRY( "TestCHuiAnLaySetAnchorL",
            CTestUiAifCoreToolkit::TestCHuiAnLaySetAnchorL ),
        ENTRY( "TestCHuiAnLaySetRelativeAnchorRectL", 
            CTestUiAifCoreToolkit::TestCHuiAnLaySetRelativeAnchorRectL ),
        ENTRY( "TestCHuiAnLayRemoveAnchorL",
            CTestUiAifCoreToolkit::TestCHuiAnLayRemoveAnchorL ),
        ENTRY( "TestCHuiAnLayAttachOriginL",
            CTestUiAifCoreToolkit::TestCHuiAnLayAttachOriginL ),
        ENTRY( "TestCHuiAnLayAttachOriginTopLeftL", 
            CTestUiAifCoreToolkit::TestCHuiAnLayAttachOriginTopLeftL ),
        ENTRY( "TestCHuiAnLayAttachOriginNoneL",
            CTestUiAifCoreToolkit::TestCHuiAnLayAttachOriginNoneL ),
        ENTRY( "TestCHuiAnLayDetachL",
            CTestUiAifCoreToolkit::TestCHuiAnLayDetachL ),
        ENTRY( "TestCHuiAnLayDetachAnchorL",
            CTestUiAifCoreToolkit::TestCHuiAnLayDetachAnchorL ),
        ENTRY( "TestCHuiAnLaySetSizeL",
            CTestUiAifCoreToolkit::TestCHuiAnLaySetSizeL ),
        ENTRY( "TestCHuiAnLayChildSizeL",
            CTestUiAifCoreToolkit::TestCHuiAnLayChildSizeL ),
        ENTRY( "TestCHuiAnLayChildPosL",
            CTestUiAifCoreToolkit::TestCHuiAnLayChildPosL ),
        ENTRY( "TestCHuiAnLayChildRectL",
            CTestUiAifCoreToolkit::TestCHuiAnLayChildRectL ),
        //For test HuiBorderBrush.h
        ENTRY( "TestCHuiBdeBrshNewL",
            CTestUiAifCoreToolkit::TestCHuiBdeBrshNewL ),
        ENTRY( "TestCHuiBdeBrshNewCL",
            CTestUiAifCoreToolkit::TestCHuiBdeBrshNewCL ),
        ENTRY( "TestCHuiBdeBrshOtherNewL",
            CTestUiAifCoreToolkit::TestCHuiBdeBrshOtherNewL ),
        ENTRY( "TestCHuiBdeBrshOtherNewCL",
            CTestUiAifCoreToolkit::TestCHuiBdeBrshOtherNewCL ),
        ENTRY( "TestCHuiBdeBrshSetImageL",
            CTestUiAifCoreToolkit::TestCHuiBdeBrshSetImageL ),
        ENTRY( "TestCHuiBdeBrshSetColorL",
            CTestUiAifCoreToolkit::TestCHuiBdeBrshSetColorL ),
        ENTRY( "TestCHuiBdeBrshSetThicknessL",
            CTestUiAifCoreToolkit::TestCHuiBdeBrshSetThicknessL ),
        ENTRY( "TestCHuiBdeBrshSetEdgeOffsetL",
            CTestUiAifCoreToolkit::TestCHuiBdeBrshSetEdgeOffsetL ),
        ENTRY( "TestCHuiBdeBrshSetImageOffsetL",
            CTestUiAifCoreToolkit::TestCHuiBdeBrshSetImageOffsetL ),
            //For test HuiAnimatedTexture.h            
        ENTRY( "TestCHuiATextDestructL",
            CTestUiAifCoreToolkit::TestCHuiATextDestructL ),
        ENTRY( "TestCHuiATextTextureL",
            CTestUiAifCoreToolkit::TestCHuiATextTextureL ),
        ENTRY( "TestCHuiATextSegmentTextureL",
            CTestUiAifCoreToolkit::TestCHuiATextSegmentTextureL ),
        ENTRY( "TestCHuiATextSegmentTextureConstL",
            CTestUiAifCoreToolkit::TestCHuiATextSegmentTextureConstL ),
        ENTRY( "TestCHuiATextShadowedTextureL",
            CTestUiAifCoreToolkit::TestCHuiATextShadowedTextureL ),
        ENTRY( "TestCHuiATextShadowedTextureConstL",
            CTestUiAifCoreToolkit::TestCHuiATextShadowedTextureConstL ),
        ENTRY( "TestCHuiATextHasContentL",
            CTestUiAifCoreToolkit::TestCHuiATextHasContentL ),
        ENTRY( "TestCHuiATextSizeL",
            CTestUiAifCoreToolkit::TestCHuiATextSizeL ),
        ENTRY( "TestCHuiATextSegmentCountL",
            CTestUiAifCoreToolkit::TestCHuiATextSegmentCountL ),
        ENTRY( "TestCHuiATextTextureChangedL",
            CTestUiAifCoreToolkit::TestCHuiATextTextureChangedL ),
        ENTRY( "TestCHuiATextTextureClearChangedL",
            CTestUiAifCoreToolkit::TestCHuiATextTextureClearChangedL ),
        ENTRY( "TestCHuiATextTextureConstructorL",
            CTestUiAifCoreToolkit::TestCHuiATextTextureConstructorL ),
        ENTRY( "TestCHuiATextBaseConstructL",
            CTestUiAifCoreToolkit::TestCHuiATextBaseConstructL ),
        ENTRY( "TestCHuiATextTextureExtensionL",
            CTestUiAifCoreToolkit::TestCHuiATextTextureExtensionL ),
        ENTRY( "TestCHuiATextSegmentNameL",
            CTestUiAifCoreToolkit::TestCHuiATextSegmentNameL ),
        ENTRY( "TestCHuiATextSegmentSizeL",
            CTestUiAifCoreToolkit::TestCHuiATextSegmentSizeL ),
        ENTRY( "TestCHuiATextSegmentTextureSizeL",
            CTestUiAifCoreToolkit::TestCHuiATextSegmentTextureSizeL ),
        ENTRY( "TestCHuiATextSegmentOffsetL",
            CTestUiAifCoreToolkit::TestCHuiATextSegmentOffsetL ),
        //For test HuiControl.h
        ENTRY( "TestCHuiControlL",
            CTestUiAifCoreToolkit::TestCHuiControlL ),
        ENTRY( "TestCHuiControlDestructL",
            CTestUiAifCoreToolkit::TestCHuiControlDestructL ),
        ENTRY( "TestCHuiControlSetIdL",
            CTestUiAifCoreToolkit::TestCHuiControlSetIdL ),
        ENTRY( "TestCHuiControlIdL",
            CTestUiAifCoreToolkit::TestCHuiControlIdL ),
        ENTRY( "TestCHuiControlEnvL",
            CTestUiAifCoreToolkit::TestCHuiControlEnvL ),
        ENTRY( "TestCHuiControlControlGroupL",
            CTestUiAifCoreToolkit::TestCHuiControlControlGroupL ),
        ENTRY( "TestCHuiControlTextureManagerL",
            CTestUiAifCoreToolkit::TestCHuiControlTextureManagerL ),
        ENTRY( "TestCHuiControlDisplayL",
            CTestUiAifCoreToolkit::TestCHuiControlDisplayL ),
        ENTRY( "TestCHuiControlBindDisplayL",
            CTestUiAifCoreToolkit::TestCHuiControlBindDisplayL ),
        ENTRY( "TestCHuiControlAppendL",
            CTestUiAifCoreToolkit::TestCHuiControlAppendL ),
        ENTRY( "TestCHuiControlAppendLayoutL",
            CTestUiAifCoreToolkit::TestCHuiControlAppendLayoutL ),
        ENTRY( "TestCHuiControlRemoveL",
            CTestUiAifCoreToolkit::TestCHuiControlRemoveL ),
        ENTRY( "TestCHuiControlAppendVisualL",
            CTestUiAifCoreToolkit::TestCHuiControlAppendVisualL ),
        ENTRY( "TestCHuiControlAppendTypeLayoutL",
            CTestUiAifCoreToolkit::TestCHuiControlAppendTypeLayoutL ),
        ENTRY( "TestCHuiControlVisualL",
            CTestUiAifCoreToolkit::TestCHuiControlVisualL ),
        ENTRY( "TestCHuiControlVisualCountL",
            CTestUiAifCoreToolkit::TestCHuiControlVisualCountL ),
        ENTRY( "TestCHuiControlFindTagL",
            CTestUiAifCoreToolkit::TestCHuiControlFindTagL ),
        ENTRY( "TestCHuiControlHostL",
            CTestUiAifCoreToolkit::TestCHuiControlHostL ),
        ENTRY( "TestCHuiControlAddConnectionL",
            CTestUiAifCoreToolkit::TestCHuiControlAddConnectionL ),
        ENTRY( "TestCHuiControlRemoveConnectionL",
            CTestUiAifCoreToolkit::TestCHuiControlRemoveConnectionL ),
        ENTRY( "TestCHuiControlFindConnectionL",
            CTestUiAifCoreToolkit::TestCHuiControlFindConnectionL ),
        ENTRY( "TestCHuiControlConnectionCountL",
            CTestUiAifCoreToolkit::TestCHuiControlConnectionCountL ),
        ENTRY( "TestCHuiControlConnectionL",
            CTestUiAifCoreToolkit::TestCHuiControlConnectionL ),
        ENTRY( "TestCHuiControlConnectionByOrdinalL",
            CTestUiAifCoreToolkit::TestCHuiControlConnectionByOrdinalL ),
        ENTRY( "TestCHuiControlConnectionRoleL",
            CTestUiAifCoreToolkit::TestCHuiControlConnectionRoleL ),
        ENTRY( "TestCHuiControlConnectionOrdinalL",
            CTestUiAifCoreToolkit::TestCHuiControlConnectionOrdinalL ),
        ENTRY( "TestCHuiControlRoleL",
            CTestUiAifCoreToolkit::TestCHuiControlRoleL ),
        ENTRY( "TestCHuiControlSetRoleL",
            CTestUiAifCoreToolkit::TestCHuiControlSetRoleL ),
        ENTRY( "TestCHuiControlHostIdL",
            CTestUiAifCoreToolkit::TestCHuiControlHostIdL ),
        ENTRY( "TestCHuiControlSetHostIdL",
            CTestUiAifCoreToolkit::TestCHuiControlSetHostIdL ),
        ENTRY( "TestCHuiControlSetHostL",
            CTestUiAifCoreToolkit::TestCHuiControlSetHostL ),
        ENTRY( "TestCHuiControlContainerLayoutL",
            CTestUiAifCoreToolkit::TestCHuiControlContainerLayoutL ),
        ENTRY( "TestCHuiControlHostToDisplayL",
            CTestUiAifCoreToolkit::TestCHuiControlHostToDisplayL ),
        ENTRY( "TestCHuiControlDisplayToHostL",
            CTestUiAifCoreToolkit::TestCHuiControlDisplayToHostL ),
        ENTRY( "TestCHuiControlBoundsL",
            CTestUiAifCoreToolkit::TestCHuiControlBoundsL ),
        ENTRY( "TestCHuiControlHitTestL",
            CTestUiAifCoreToolkit::TestCHuiControlHitTestL ),
        ENTRY( "TestCHuiControlAcquireFocusL",
            CTestUiAifCoreToolkit::TestCHuiControlAcquireFocusL ),
        ENTRY( "TestCHuiControlFocusL",
            CTestUiAifCoreToolkit::TestCHuiControlFocusL ),
        ENTRY( "TestCHuiControlIsFocusingL",
            CTestUiAifCoreToolkit::TestCHuiControlIsFocusingL ),
        ENTRY( "TestCHuiControlFocusChangedL",
            CTestUiAifCoreToolkit::TestCHuiControlFocusChangedL ),
        ENTRY( "TestCHuiControlAcceptInputL",
            CTestUiAifCoreToolkit::TestCHuiControlAcceptInputL ),
        ENTRY( "TestCHuiControlOfferEventL",
            CTestUiAifCoreToolkit::TestCHuiControlOfferEventL ),
        ENTRY( "TestCHuiControlDisplayAreaL",
            CTestUiAifCoreToolkit::TestCHuiControlDisplayAreaL ),
        ENTRY( "TestCHuiControlDisplayCenterL",
            CTestUiAifCoreToolkit::TestCHuiControlDisplayCenterL ),
        ENTRY( "TestCHuiControlCancelAllCommandsL",
            CTestUiAifCoreToolkit::TestCHuiControlCancelAllCommandsL ),
        ENTRY( "TestCHuiControlVisualLayoutUpdatedL",
            CTestUiAifCoreToolkit::TestCHuiControlVisualLayoutUpdatedL ),
        ENTRY( "TestCHuiControlVisualDestroyedL",
            CTestUiAifCoreToolkit::TestCHuiControlVisualDestroyedL ),
        ENTRY( "TestCHuiControlEventHandlerL",
            CTestUiAifCoreToolkit::TestCHuiControlEventHandlerL ),
        ENTRY( "TestCHuiControlNotifyVisibilityL",
            CTestUiAifCoreToolkit::TestCHuiControlNotifyVisibilityL ),
        ENTRY( "TestCHuiControlVisualAddedL",
            CTestUiAifCoreToolkit::TestCHuiControlVisualAddedL ),
        ENTRY( "TestCHuiControlVisualRemovedL",
            CTestUiAifCoreToolkit::TestCHuiControlVisualRemovedL ),
        ENTRY( "TestCHuiControlConnectionAddedL",
            CTestUiAifCoreToolkit::TestCHuiControlConnectionAddedL ),
        ENTRY( "TestCHuiControlConnectionRemovedL",
            CTestUiAifCoreToolkit::TestCHuiControlConnectionRemovedL ),
        ENTRY( "TestCHuiControlHostChangingL",
            CTestUiAifCoreToolkit::TestCHuiControlHostChangingL ),
        ENTRY( "TestCHuiControlBaseConstructL",
            CTestUiAifCoreToolkit::TestCHuiControlBaseConstructL ),
        ENTRY( "TestCHuiControlControlExtensionL",
            CTestUiAifCoreToolkit::TestCHuiControlControlExtensionL ),
        ENTRY( "TestCHuiControlTypeL",
            CTestUiAifCoreToolkit::TestCHuiControlTypeL ),
        ENTRY( "TestCHuiControlSessionIdL",
            CTestUiAifCoreToolkit::TestCHuiControlSessionIdL ),
        ENTRY( "TestCHuiControlSetSessionIdL",
            CTestUiAifCoreToolkit::TestCHuiControlSetSessionIdL ),
        //For test HuiControlGroup.h
        ENTRY( "TestCHuiCntlGroupAppendL",
            CTestUiAifCoreToolkit::TestCHuiCntlGroupAppendL ),
        ENTRY( "TestCHuiCntlGroupAppendAndPopL",
            CTestUiAifCoreToolkit::TestCHuiCntlGroupAppendAndPopL ),
        ENTRY( "TestCHuiCntlGroupRemoveL",
            CTestUiAifCoreToolkit::TestCHuiCntlGroupRemoveL ),
        ENTRY( "TestCHuiCntlCountL",
            CTestUiAifCoreToolkit::TestCHuiCntlCountL ),
        ENTRY( "TestCHuiCntlControlL",
            CTestUiAifCoreToolkit::TestCHuiCntlControlL ),
        ENTRY( "TestCHuiCntlFindControlL",
            CTestUiAifCoreToolkit::TestCHuiCntlFindControlL ),
        ENTRY( "TestCHuiCntlEnableTsfomatonL",
            CTestUiAifCoreToolkit::TestCHuiCntlEnableTsfomatonL ),
        ENTRY( "TestCHuiCntlIsTransformedL",
            CTestUiAifCoreToolkit::TestCHuiCntlIsTransformedL ),
        ENTRY( "TestCHuiCntlTransformationL",
            CTestUiAifCoreToolkit::TestCHuiCntlTransformationL ),
        ENTRY( "TestCHuiCntlAcceptInputL",
            CTestUiAifCoreToolkit::TestCHuiCntlAcceptInputL ),
        ENTRY( "TestCHuiCntlSetAcceptInputL",
            CTestUiAifCoreToolkit::TestCHuiCntlSetAcceptInputL ),
        ENTRY( "TestCHuiCntlTypeL",
            CTestUiAifCoreToolkit::TestCHuiCntlTypeL ),
        ENTRY( "TestCHuiCntlSessionIdL",
            CTestUiAifCoreToolkit::TestCHuiCntlSessionIdL ),
        ENTRY( "TestCHuiCntlSetSessionIdL",
            CTestUiAifCoreToolkit::TestCHuiCntlSetSessionIdL ),
        //For test HuiControlGroup.h
        ENTRY( "TestCHuiCurvePathNewL",
            CTestUiAifCoreToolkit::TestCHuiCurvePathNewL ),
        ENTRY( "TestCHuiCurvePathNewCL",
            CTestUiAifCoreToolkit::TestCHuiCurvePathNewCL ),
        ENTRY( "TestCHuiCurvePathDestructL",
            CTestUiAifCoreToolkit::TestCHuiCurvePathDestructL ),
        ENTRY( "TestCHuiCurvePathResetL",
            CTestUiAifCoreToolkit::TestCHuiCurvePathResetL ),
        ENTRY( "TestCHuiCurvePathEnableLoopL",
            CTestUiAifCoreToolkit::TestCHuiCurvePathEnableLoopL ),
        ENTRY( "TestCHuiCurvePathLoopL",
            CTestUiAifCoreToolkit::TestCHuiCurvePathLoopL ),
        ENTRY( "TestCHuiCurvePathSetOriginL",
            CTestUiAifCoreToolkit::TestCHuiCurvePathSetOriginL ),
        ENTRY( "TestCHuiCurvePathAppendLineL",
            CTestUiAifCoreToolkit::TestCHuiCurvePathAppendLineL ),
        ENTRY( "TestCHuiCurvePathAppendRealLineL",
            CTestUiAifCoreToolkit::TestCHuiCurvePathAppendRealLineL ),
        ENTRY( "TestCHuiCurvePathAppendArcL",
            CTestUiAifCoreToolkit::TestCHuiCurvePathAppendArcL ),
        ENTRY( "TestCHuiCurvePathAppendHuiArcL",
            CTestUiAifCoreToolkit::TestCHuiCurvePathAppendHuiArcL ),
        ENTRY( "TestCHuiCurvePathLengthL",
            CTestUiAifCoreToolkit::TestCHuiCurvePathLengthL ),
        ENTRY( "TestCHuiCurvePathEvaluateL",
            CTestUiAifCoreToolkit::TestCHuiCurvePathEvaluateL ),
        //For test HuiCurvePathLayout.h
        ENTRY( "TestCHuiCurvePathLayAddNewL",
            CTestUiAifCoreToolkit::TestCHuiCurvePathLayAddNewL ),
        ENTRY( "TestCHuiCurvePathLayCurvePathL",
            CTestUiAifCoreToolkit::TestCHuiCurvePathLayCurvePathL ),
        //For test Huidecklayout.h
        ENTRY( "TestCHuiDeckLayoutAddNewL",
            CTestUiAifCoreToolkit::TestCHuiDeckLayoutAddNewL ),
        ENTRY( "TestCHuiDeckLayoutDestructL",
            CTestUiAifCoreToolkit::TestCHuiDeckLayoutDestructL ),
        //For test HuiCommand.h
        ENTRY( "TestCHuiCommandDestructL",
            CTestUiAifCoreToolkit::TestCHuiCommandDestructL ),
        ENTRY( "TestCHuiCommandObjectCommandL",
            CTestUiAifCoreToolkit::TestCHuiCommandObjectCommandL ),
        ENTRY( "TestCHuiCommandSetSenderL",
            CTestUiAifCoreToolkit::TestCHuiCommandSetSenderL ),
        ENTRY( "TestCHuiCommandTypeL",
            CTestUiAifCoreToolkit::TestCHuiCommandTypeL ),
        ENTRY( "TestCHuiSenderTypeL",
            CTestUiAifCoreToolkit::TestCHuiSenderTypeL ),
        ENTRY( "TestCHuiSenderL",
            CTestUiAifCoreToolkit::TestCHuiSenderL ),
        ENTRY( "TestCHuiSenderVisualL",
            CTestUiAifCoreToolkit::TestCHuiSenderVisualL ),
        ENTRY( "TestCHuiSenderControlL",
            CTestUiAifCoreToolkit::TestCHuiSenderControlL ),
        ENTRY( "TestCHuiSenderControlGroupL",
            CTestUiAifCoreToolkit::TestCHuiSenderControlGroupL ),
        ENTRY( "TestCHuiCommandConstructL",
            CTestUiAifCoreToolkit::TestCHuiCommandConstructL ),
        ENTRY( "TestCHuiCommandExtensionL",
            CTestUiAifCoreToolkit::TestCHuiCommandExtensionL ),
        ENTRY( "TestCHuiCommandTActionCommandL",
            CTestUiAifCoreToolkit::TestCHuiCommandTActionCommandL ),
        ENTRY( "TestCHuiCommandExecuteL",
            CTestUiAifCoreToolkit::TestCHuiCommandExecuteL ),
        ENTRY( "TestCHuiCommandSizeL",
            CTestUiAifCoreToolkit::TestCHuiCommandSizeL ),
        ENTRY( "TestCHuiCommandIdL",
            CTestUiAifCoreToolkit::TestCHuiCommandIdL ),
        ENTRY( "TestCHuiActionCommandExtensionL",
            CTestUiAifCoreToolkit::TestCHuiActionCommandExtensionL ),
        ENTRY( "TestCHuiObjectCommandL",
            CTestUiAifCoreToolkit::TestCHuiObjectCommandL ),
        ENTRY( "TestCHuiObjectCommandExecuteL",
            CTestUiAifCoreToolkit::TestCHuiObjectCommandExecuteL ),
        ENTRY( "TestCHuiObjectCommandSizeL",
            CTestUiAifCoreToolkit::TestCHuiObjectCommandSizeL ),
        ENTRY( "TestCHuiObjectCommandObjectL",
            CTestUiAifCoreToolkit::TestCHuiObjectCommandObjectL ),
        ENTRY( "TestCHuiObjectCommandOperationL",
            CTestUiAifCoreToolkit::TestCHuiObjectCommandOperationL ),
        ENTRY( "TestCHuiObjectCommandConstructL",
            CTestUiAifCoreToolkit::TestCHuiObjectCommandConstructL ),
        ENTRY( "TestCHuiObjectCommandExtensionL",
            CTestUiAifCoreToolkit::TestCHuiObjectCommandExtensionL ),
        ENTRY( "TestTHuiGroupCommandL",
            CTestUiAifCoreToolkit::TestTHuiGroupCommandL ),
        ENTRY( "TestTHuiGroupCommandExecuteL",
            CTestUiAifCoreToolkit::TestTHuiGroupCommandExecuteL ),
        ENTRY( "TestTHuiGroupCommandSizeL",
            CTestUiAifCoreToolkit::TestTHuiGroupCommandSizeL ),
        ENTRY( "TestTHuiGroupCommandControlGroupL",
            CTestUiAifCoreToolkit::TestTHuiGroupCommandControlGroupL ),
        ENTRY( "TestTHuiGroupCommandDisplayL",
            CTestUiAifCoreToolkit::TestTHuiGroupCommandDisplayL ),
        ENTRY( "TestTHuiGroupCommandExtensionL",
            CTestUiAifCoreToolkit::TestTHuiGroupCommandExtensionL ),
        ENTRY( "TestTHuiControlCommandL",
            CTestUiAifCoreToolkit::TestTHuiControlCommandL ),
        ENTRY( "TestTHuiControlCommandExecuteL",
            CTestUiAifCoreToolkit::TestTHuiControlCommandExecuteL ),
        ENTRY( "TestTHuiControlCommandSizeL",
            CTestUiAifCoreToolkit::TestTHuiControlCommandSizeL ),
        ENTRY( "TestTHuiControlCommandControlL",
            CTestUiAifCoreToolkit::TestTHuiControlCommandControlL ),
        ENTRY( "TestTHuiControlCommandExtensionL",
            CTestUiAifCoreToolkit::TestTHuiControlCommandExtensionL ),
        ENTRY( "TestTHuiVisualCommandL",
            CTestUiAifCoreToolkit::TestTHuiVisualCommandL ),
        ENTRY( "TestTHuiVisualCommandExecuteL",
            CTestUiAifCoreToolkit::TestTHuiVisualCommandExecuteL ),
        ENTRY( "TestTHuiVisualCommandSizeL",
            CTestUiAifCoreToolkit::TestTHuiVisualCommandSizeL ),
        ENTRY( "TestTHuiVisualCommandVisualL",
            CTestUiAifCoreToolkit::TestTHuiVisualCommandVisualL ),
        ENTRY( "TestTHuiVisualCommandFlagsToSetL",
            CTestUiAifCoreToolkit::TestTHuiVisualCommandFlagsToSetL ),
        ENTRY( "TestTHuiVisualCommandFlagsToClearL",
            CTestUiAifCoreToolkit::TestTHuiVisualCommandFlagsToClearL ),
        ENTRY( "TestTHuiVisualCommandExtensionL",
            CTestUiAifCoreToolkit::TestTHuiVisualCommandExtensionL ),
        ENTRY( "TestTHuiImageCommandL",
            CTestUiAifCoreToolkit::TestTHuiImageCommandL ),
        ENTRY( "TestTHuiImageCommandExecuteL",
            CTestUiAifCoreToolkit::TestTHuiImageCommandExecuteL ),
        ENTRY( "TestTHuiImageCommandSizeL",
            CTestUiAifCoreToolkit::TestTHuiImageCommandSizeL ),
        ENTRY( "TestTHuiImageCommandVisualL",
            CTestUiAifCoreToolkit::TestTHuiImageCommandVisualL ),
        ENTRY( "TestTHuiImageCommandImageL",
            CTestUiAifCoreToolkit::TestTHuiImageCommandImageL ),
        ENTRY( "TestTHuiImageCommandExtensionL",
            CTestUiAifCoreToolkit::TestTHuiImageCommandExtensionL ),
        ENTRY( "TestTHuiTextCommandL",
            CTestUiAifCoreToolkit::TestTHuiTextCommandL ),
        ENTRY( "TestTHuiTextCommandExecuteL",
            CTestUiAifCoreToolkit::TestTHuiTextCommandExecuteL ),
        ENTRY( "TestTHuiTextCommandSizeL",
            CTestUiAifCoreToolkit::TestTHuiTextCommandSizeL ),
        ENTRY( "TestTHuiTextCommandTextVisualL",
            CTestUiAifCoreToolkit::TestTHuiTextCommandTextVisualL ),
        ENTRY( "TestTHuiTextCommandTextL",
            CTestUiAifCoreToolkit::TestTHuiTextCommandTextL ),
        ENTRY( "TestTHuiTextCommandExtensionL",
            CTestUiAifCoreToolkit::TestTHuiTextCommandExtensionL ),
        ENTRY( "TestTHuiValueCommandL",
            CTestUiAifCoreToolkit::TestTHuiValueCommandL ),
        ENTRY( "TestTHuiValueCommandMutiRefL",
            CTestUiAifCoreToolkit::TestTHuiValueCommandMutiRefL ),
        ENTRY( "TestTHuiValueCommandExecuteL",
            CTestUiAifCoreToolkit::TestTHuiValueCommandExecuteL ),
        ENTRY( "TestTHuiValueCommandSizeL",
            CTestUiAifCoreToolkit::TestTHuiValueCommandSizeL ),
        ENTRY( "TestTHuiValueCommandTimedValueL",
            CTestUiAifCoreToolkit::TestTHuiValueCommandTimedValueL ),
        ENTRY( "TestTHuiValueCommandTargetL",
            CTestUiAifCoreToolkit::TestTHuiValueCommandTargetL ),
        ENTRY( "TestTHuiValueCommandTransitionTimeL",
            CTestUiAifCoreToolkit::TestTHuiValueCommandTransitionTimeL ),
        ENTRY( "TestTHuiValueCommandSpeedL",
            CTestUiAifCoreToolkit::TestTHuiValueCommandSpeedL ),
        ENTRY( "TestTHuiValueCommandExtensionL",
            CTestUiAifCoreToolkit::TestTHuiValueCommandExtensionL ),
        ENTRY( "TestTHuiPointCommandL",
            CTestUiAifCoreToolkit::TestTHuiPointCommandL ),
        ENTRY( "TestTHuiPointCommandMutiRefL",
            CTestUiAifCoreToolkit::TestTHuiPointCommandMutiRefL ),
        ENTRY( "TestTHuiPointCommandMutiRefOtherL",
            CTestUiAifCoreToolkit::TestTHuiPointCommandMutiRefOtherL ),
        ENTRY( "TestTHuiPointCommandExecuteL",
            CTestUiAifCoreToolkit::TestTHuiPointCommandExecuteL ),
        ENTRY( "TestTHuiPointCommandSizeL",
            CTestUiAifCoreToolkit::TestTHuiPointCommandSizeL ),
        ENTRY( "TestTHuiPointCommandTimedPointL",
            CTestUiAifCoreToolkit::TestTHuiPointCommandTimedPointL ),
        ENTRY( "TestTHuiPointCommandTargetL",
            CTestUiAifCoreToolkit::TestTHuiPointCommandTargetL ),
        ENTRY( "TestTHuiPointCommandTransitionTimeL",
            CTestUiAifCoreToolkit::TestTHuiPointCommandTransitionTimeL ),
        ENTRY( "TestTHuiPointCommandSpeedL",
            CTestUiAifCoreToolkit::TestTHuiPointCommandSpeedL ),
        ENTRY( "TestTHuiPointCommandExtensionL",
            CTestUiAifCoreToolkit::TestTHuiPointCommandExtensionL ),
        ENTRY( "TestTHuiTransformationCommandL",
            CTestUiAifCoreToolkit::TestTHuiTransformationCommandL ),
        ENTRY( "TestTHuiTransformationCommandExecuteL",
            CTestUiAifCoreToolkit::TestTHuiTransformationCommandExecuteL ),
        ENTRY( "TestTHuiTransformationCommandSizeL",
            CTestUiAifCoreToolkit::TestTHuiTransformationCommandSizeL ),
        ENTRY( "TestTHuiTransformationCommandTransmasnL",
            CTestUiAifCoreToolkit::TestTHuiTransformationCommandTransmasnL ),
        ENTRY( "TestTHuiTransformationCommandStepL",
            CTestUiAifCoreToolkit::TestTHuiTransformationCommandStepL ),
        ENTRY( "TestTHuiTransformationCommandSetXL",
            CTestUiAifCoreToolkit::TestTHuiTransformationCommandSetXL ),
        ENTRY( "TestTHuiTransformationCommandSetYL",
            CTestUiAifCoreToolkit::TestTHuiTransformationCommandSetYL ),
        ENTRY( "TestTHuiTransformationCommandSetZL",
            CTestUiAifCoreToolkit::TestTHuiTransformationCommandSetZL ),
        ENTRY( "TestTHuiTransformationCommandSetAngleL",
            CTestUiAifCoreToolkit::TestTHuiTransformationCommandSetAngleL ),
        ENTRY( "TestTHuiTransformationCommandExtensionL",
            CTestUiAifCoreToolkit::TestTHuiTransformationCommandExtensionL ),
        ENTRY( "TestTHuiMarkerCommandL",
            CTestUiAifCoreToolkit::TestTHuiMarkerCommandL ),
        ENTRY( "TestTHuiMarkerCommandExecuteL",
            CTestUiAifCoreToolkit::TestTHuiMarkerCommandExecuteL ),
        ENTRY( "TestTHuiMarkerCommandSizeL",
            CTestUiAifCoreToolkit::TestTHuiMarkerCommandSizeL ),
        ENTRY( "TestTHuiMarkerCommandIdL",
            CTestUiAifCoreToolkit::TestTHuiMarkerCommandIdL ),
        ENTRY( "TestTHuiMarkerCommandExtensionL",
            CTestUiAifCoreToolkit::TestTHuiMarkerCommandExtensionL ),
        ENTRY( "TestTHuiCustomEventCommandL",
            CTestUiAifCoreToolkit::TestTHuiCustomEventCommandL ),   
        ENTRY( "TestTHuiCustomEventCommandExecuteL",
            CTestUiAifCoreToolkit::TestTHuiCustomEventCommandExecuteL ),
        ENTRY( "TestTHuiCustomEventCommandSizeL",
            CTestUiAifCoreToolkit::TestTHuiCustomEventCommandSizeL ),
        ENTRY( "TestTHuiCustomEventCommandRecipientL",
            CTestUiAifCoreToolkit::TestTHuiCustomEventCommandRecipientL ),
        ENTRY( "TestTHuiCustomEventCommandParamL",
            CTestUiAifCoreToolkit::TestTHuiCustomEventCommandParamL ),
        ENTRY( "TestTHuiCustomEventCommandExtensionL",
            CTestUiAifCoreToolkit::TestTHuiCustomEventCommandExtensionL ),
            
            
        // for test the huivisual.h api
        ENTRY( "TestHuiVisualAddNewL", CTestUiAifCoreToolkit::TestHuiVisualAddNewL ),
        ENTRY( "TestHuiVisualCHuiVisual", CTestUiAifCoreToolkit::TestHuiVisualCHuiVisualL ),
        ENTRY( "TestHuiVisualConstructL", CTestUiAifCoreToolkit::TestHuiVisualConstructL ),
        ENTRY( "TestHuiVisualDelete", CTestUiAifCoreToolkit::TestHuiVisualDelete ),
        ENTRY( "TestHuiVisualRemoveAndDestroyAllD", CTestUiAifCoreToolkit::TestHuiVisualRemoveAndDestroyAllD ),
        ENTRY( "TestHuiVisualSetTagL", CTestUiAifCoreToolkit::TestHuiVisualSetTagL ),
        ENTRY( "TestHuiVisualTag", CTestUiAifCoreToolkit::TestHuiVisualTag ),
        ENTRY( "TestHuiVisualIsTagged", CTestUiAifCoreToolkit::TestHuiVisualIsTagged ),
        ENTRY( "TestHuiVisualFindTag", CTestUiAifCoreToolkit::TestHuiVisualFindTag ),
        ENTRY( "TestHuiVisualSetFlag", CTestUiAifCoreToolkit::TestHuiVisualSetFlag ),
        ENTRY( "TestHuiVisualSetFlags", CTestUiAifCoreToolkit::TestHuiVisualSetFlags ),
        ENTRY( "TestHuiVisualClearFlag", CTestUiAifCoreToolkit::TestHuiVisualClearFlag ),
        ENTRY( "TestHuiVisualClearFlags", CTestUiAifCoreToolkit::TestHuiVisualClearFlags ),
        ENTRY( "TestHuiVisualFlags", CTestUiAifCoreToolkit::TestHuiVisualFlags ),
        ENTRY( "TestHuiVisualOwner", CTestUiAifCoreToolkit::TestHuiVisualOwner ),
        ENTRY( "TestHuiVisualSetOwner", CTestUiAifCoreToolkit::TestHuiVisualSetOwnerL ),
        ENTRY( "TestHuiVisualCount", CTestUiAifCoreToolkit::TestHuiVisualCount ),
        ENTRY( "TestHuiVisualVisual", CTestUiAifCoreToolkit::TestHuiVisualVisual ),
        ENTRY( "TestHuiVisualLayout", CTestUiAifCoreToolkit::TestHuiVisualLayoutL ),
        ENTRY( "TestHuiVisualEnv", CTestUiAifCoreToolkit::TestHuiVisualEnv ),
        ENTRY( "TestHuiVisualSkin", CTestUiAifCoreToolkit::TestHuiVisualSkin ),
        ENTRY( "TestHuiVisualDisplay", CTestUiAifCoreToolkit::TestHuiVisualDisplay ),
        ENTRY( "TestHuiVisualSetOrigin", CTestUiAifCoreToolkit::TestHuiVisualSetOrigin ),
        ENTRY( "TestHuiVisualHorizontalOrigin", CTestUiAifCoreToolkit::TestHuiVisualHorizontalOrigin ),
        ENTRY( "TestHuiVisualVerticalOrigin", CTestUiAifCoreToolkit::TestHuiVisualVerticalOrigin ),
        ENTRY( "TestHuiVisualAlignByOrigin", CTestUiAifCoreToolkit::TestHuiVisualAlignByOrigin ),
        ENTRY( "TestHuiVisualSetMinTSizeL", CTestUiAifCoreToolkit::TestHuiVisualSetMinTSizeL ),
        ENTRY( "TestHuiVisualSetMinHuiSizeL", CTestUiAifCoreToolkit::TestHuiVisualSetMinHuiSizeL ),
        ENTRY( "TestHuiVisualMinSize", CTestUiAifCoreToolkit::TestHuiVisualMinSizeL ),
        ENTRY( "TestHuiVisualMinSizeInBaseUnits", CTestUiAifCoreToolkit::TestHuiVisualMinSizeInBaseUnitsL ),
        ENTRY( "TestHuiVisualSetMaxTSize", CTestUiAifCoreToolkit::TestHuiVisualSetMaxTSizeL ),
        ENTRY( "TestHuiVisualSetMaxHuiSize", CTestUiAifCoreToolkit::TestHuiVisualSetMaxHuiSizeL ),
        ENTRY( "TestHuiVisualMaxSize", CTestUiAifCoreToolkit::TestHuiVisualMaxSizeL ),
        ENTRY( "TestHuiVisualMaxSizeInBaseUnits", CTestUiAifCoreToolkit::TestHuiVisualMaxSizeInBaseUnitsL ),
        ENTRY( "TestHuiVisualPosConst", CTestUiAifCoreToolkit::TestHuiVisualPosConst ),
        ENTRY( "TestHuiVisualConstSize", CTestUiAifCoreToolkit::TestHuiVisualConstSize ),
        ENTRY( "TestHuiVisualSize", CTestUiAifCoreToolkit::TestHuiVisualSize ),
        ENTRY( "TestHuiVisualSetPos", CTestUiAifCoreToolkit::TestHuiVisualSetPos ),
        ENTRY( "TestHuiVisualSetSize", CTestUiAifCoreToolkit::TestHuiVisualSetSize ),
        ENTRY( "TestHuiVisualSetRect", CTestUiAifCoreToolkit::TestHuiVisualSetRect ),
        ENTRY( "TestHuiVisualTMove", CTestUiAifCoreToolkit::TestHuiVisualTMoveL ),
        ENTRY( "TestHuiVisualHuiMove", CTestUiAifCoreToolkit::TestHuiVisualHuiMoveL ),
        ENTRY( "TestHuiVisualMimic", CTestUiAifCoreToolkit::TestHuiVisualMimicL ),
        ENTRY( "TestHuiVisualSetCenteredPosAndTSize", CTestUiAifCoreToolkit::TestHuiVisualSetCenteredPosAndTSizeL ),
        ENTRY( "TestHuiVisualSetCenteredPosAndHuiSize", CTestUiAifCoreToolkit::TestHuiVisualSetCenteredPosAndHuiSizeL ),
        ENTRY( "TestHuiVisualUpdateChildrenLayout", CTestUiAifCoreToolkit::TestHuiVisualUpdateChildrenLayout ),
        ENTRY( "TestHuiVisualUpdateSiblingLayout", CTestUiAifCoreToolkit::TestHuiVisualUpdateSiblingLayout ),
        ENTRY( "TestHuiVisualDisplayRect", CTestUiAifCoreToolkit::TestHuiVisualDisplayRect ),
        ENTRY( "TestHuiVisualDisplayRectTarget", CTestUiAifCoreToolkit::TestHuiVisualDisplayRectTarget ),
        ENTRY( "TestHuiVisualLocalBaseUnit", CTestUiAifCoreToolkit::TestHuiVisualLocalBaseUnit ),
        ENTRY( "TestHuiVisualLocalPointInPixels", CTestUiAifCoreToolkit::TestHuiVisualLocalPointInPixels ),
        ENTRY( "TestHuiVisualLocalPointInPixelsWithState", CTestUiAifCoreToolkit::TestHuiVisualLocalPointInPixelsWithState ),
        ENTRY( "TestHuiVisualPixelPointInLocal", CTestUiAifCoreToolkit::TestHuiVisualPixelPointInLocal ),
        ENTRY( "TestHuiVisualPixelPointInLocalWithState", CTestUiAifCoreToolkit::TestHuiVisualPixelPointInLocalWithState ),
        ENTRY( "TestHuiVisualMetricToPixels", CTestUiAifCoreToolkit::TestHuiVisualMetricToPixels ),
        ENTRY( "TestHuiVisualMetricToPixelsWithState", CTestUiAifCoreToolkit::TestHuiVisualMetricToPixelsWithState ),
        ENTRY( "TestHuiVisualPixelsToMetric", CTestUiAifCoreToolkit::TestHuiVisualPixelsToMetric ),
        ENTRY( "TestHuiVisualPixelsToMetricWithState", CTestUiAifCoreToolkit::TestHuiVisualPixelsToMetricWithState ),
        ENTRY( "TestHuiVisualMetricReferenceInPixels", CTestUiAifCoreToolkit::TestHuiVisualMetricReferenceInPixels ),
        ENTRY( "TestHuiVisualMetricReferenceInPixelsWithState", CTestUiAifCoreToolkit::TestHuiVisualMetricReferenceInPixelsWithState ),
        ENTRY( "TestHuiVisualLocalToDisplayT", CTestUiAifCoreToolkit::TestHuiVisualLocalToDisplayT ),
        ENTRY( "TestHuiVisualLocalToDisplayHui", CTestUiAifCoreToolkit::TestHuiVisualLocalToDisplayHui ),
        ENTRY( "TestHuiVisualDisplayToLocalT", CTestUiAifCoreToolkit::TestHuiVisualDisplayToLocalT ),
        ENTRY( "TestHuiVisualDisplayToLocalHui", CTestUiAifCoreToolkit::TestHuiVisualDisplayToLocalHui ),
        ENTRY( "TestHuiVisualBoxMetricToPixelRect", CTestUiAifCoreToolkit::TestHuiVisualBoxMetricToPixelRect ),
        ENTRY( "TestHuiVisualBoxMetricToPixelRectWithState", CTestUiAifCoreToolkit::TestHuiVisualBoxMetricToPixelRectWithState ),
        ENTRY( "TestHuiVisualMoveToFront", CTestUiAifCoreToolkit::TestHuiVisualMoveToFront ),
        ENTRY( "TestHuiVisualPos", CTestUiAifCoreToolkit::TestHuiVisualPos ),
        ENTRY( "TestHuiVisualEffectiveOpacity", CTestUiAifCoreToolkit::TestHuiVisualEffectiveOpacity ),
        ENTRY( "TestHuiVisualSetClipping", CTestUiAifCoreToolkit::TestHuiVisualSetClipping ),
        ENTRY( "TestHuiVisualClipping", CTestUiAifCoreToolkit::TestHuiVisualClipping ),
        ENTRY( "TestHuiVisualEnableTransformationL", CTestUiAifCoreToolkit::TestHuiVisualEnableTransformationL ),
        ENTRY( "TestHuiVisualTransformation", CTestUiAifCoreToolkit::TestHuiVisualTransformation ),
        ENTRY( "TestHuiVisualSetPadding", CTestUiAifCoreToolkit::TestHuiVisualSetPadding ),
        ENTRY( "TestHuiVisualSetPaddingWithPoint", CTestUiAifCoreToolkit::TestHuiVisualSetPaddingWithPoint ),
        ENTRY( "TestHuiVisualSetPaddingWithHuiBoxMetrix", CTestUiAifCoreToolkit::TestHuiVisualSetPaddingWithHuiBoxMetrix ),
        ENTRY( "TestHuiVisualPadding", CTestUiAifCoreToolkit::TestHuiVisualPadding ),
        ENTRY( "TestHuiVisualPaddingInPixels", CTestUiAifCoreToolkit::TestHuiVisualPaddingInPixels ),
        ENTRY( "TestHuiVisualPaddingInPixelsWithState", CTestUiAifCoreToolkit::TestHuiVisualPaddingInPixelsWithState ),
        ENTRY( "TestHuiVisualPrepareDrawL", CTestUiAifCoreToolkit::TestHuiVisualPrepareDrawL ),
        ENTRY( "TestHuiVisualDraw", CTestUiAifCoreToolkit::TestHuiVisualDrawL ),
        ENTRY( "TestHuiVisualDrawBrushes", CTestUiAifCoreToolkit::TestHuiVisualDrawBrushesL ),
        ENTRY( "TestHuiVisualDrawSelf", CTestUiAifCoreToolkit::TestHuiVisualDrawSelfL ),
        ENTRY( "TestHuiVisualSetChanged", CTestUiAifCoreToolkit::TestHuiVisualSetChanged ),
        ENTRY( "TestHuiVisualChanged", CTestUiAifCoreToolkit::TestHuiVisualChanged ),
        ENTRY( "TestHuiVisualReportChanged", CTestUiAifCoreToolkit::TestHuiVisualReportChanged ),
        ENTRY( "TestHuiVisualClearChanged", CTestUiAifCoreToolkit::TestHuiVisualClearChanged ),
        ENTRY( "TestHuiVisualEnableBrushesL", CTestUiAifCoreToolkit::TestHuiVisualEnableBrushesL ),
        ENTRY( "TestHuiVisualBrushes", CTestUiAifCoreToolkit::TestHuiVisualBrushes ),
        ENTRY( "TestHuiVisualDumpTree", CTestUiAifCoreToolkit::TestHuiVisualDumpTree ),
        ENTRY( "TestHuiVisualGetInstanceName", CTestUiAifCoreToolkit::TestHuiVisualGetInstanceName ),
        ENTRY( "TestHuiVisualGetClassName", CTestUiAifCoreToolkit::TestHuiVisualGetClassName ),
        ENTRY( "TestHuiVisualEnterLocalProjection", CTestUiAifCoreToolkit::TestHuiVisualEnterLocalProjectionL ),
        ENTRY( "TestHuiVisualNotifySkinChangedL", CTestUiAifCoreToolkit::TestHuiVisualNotifySkinChangedL ),
        ENTRY( "TestHuiVisualSetTactileFeedbackL", CTestUiAifCoreToolkit::TestHuiVisualSetTactileFeedbackL ),
        ENTRY( "TestHuiVisualHasTactileFeedback", CTestUiAifCoreToolkit::TestHuiVisualHasTactileFeedbackL ),
        ENTRY( "TestHuiVisualRemoveTactileFeedback", CTestUiAifCoreToolkit::TestHuiVisualRemoveTactileFeedbackL ),
        ENTRY( "TestHuiVisualEnableDropShadowL", CTestUiAifCoreToolkit::TestHuiVisualEnableDropShadowL ),
        ENTRY( "TestHuiVisualDropShadowHandler", CTestUiAifCoreToolkit::TestHuiVisualDropShadowHandler ),
        ENTRY( "TestHuiVisualBrushOpacity", CTestUiAifCoreToolkit::TestHuiVisualBrushOpacity ),
        ENTRY( "TestHuiVisualBrushRect", CTestUiAifCoreToolkit::TestHuiVisualBrushRect ),
        ENTRY( "TestHuiVisualBrushSkin", CTestUiAifCoreToolkit::TestHuiVisualBrushSkin ),
        ENTRY( "TestHuiVisualType", CTestUiAifCoreToolkit::TestHuiVisualType ),
        ENTRY( "TestHuiVisualSessionId", CTestUiAifCoreToolkit::TestHuiVisualSessionId ),
        ENTRY( "TestHuiVisualSetSessionId", CTestUiAifCoreToolkit::TestHuiVisualSetSessionId ),
        ENTRY( "TestHuiVisualTransform", CTestUiAifCoreToolkit::TestHuiVisualTransformL ),
        ENTRY( "TestHuiVisualExpandRectWithContent", CTestUiAifCoreToolkit::TestHuiVisualExpandRectWithContentL ),
        ENTRY( "TestHuiVisualVisualExtension", CTestUiAifCoreToolkit::TestHuiVisualVisualExtensionL ),
            
        // for HuiBrushArray.h
        ENTRY( "TestHuiBrushArrayNewLL", CTestUiAifCoreToolkit::TestHuiBrushArrayNewLL ),
        ENTRY( "TestHuiBrushArrayNewLCL", CTestUiAifCoreToolkit::TestHuiBrushArrayNewLCL ),
        ENTRY( "TestHuiBrushArrayResetL", CTestUiAifCoreToolkit::TestHuiBrushArrayResetL ),
        ENTRY( "TestHuiBrushArrayAppendL", CTestUiAifCoreToolkit::TestHuiBrushArrayAppendL ),
        ENTRY( "TestHuiBrushArrayInsertL", CTestUiAifCoreToolkit::TestHuiBrushArrayInsertL ),
        ENTRY( "TestHuiBrushArrayRemoveL", CTestUiAifCoreToolkit::TestHuiBrushArrayRemoveL ),
        ENTRY( "TestHuiBrushArrayCountL", CTestUiAifCoreToolkit::TestHuiBrushArrayCountL ),
        ENTRY( "TestHuiBrushArrayOperatorL", CTestUiAifCoreToolkit::TestHuiBrushArrayOperatorL ),
        ENTRY( "TestHuiBrushArrayAtL", CTestUiAifCoreToolkit::TestHuiBrushArrayAtL ),
        ENTRY( "TestHuiBrushArrayLayerBrushCountL", CTestUiAifCoreToolkit::TestHuiBrushArrayLayerBrushCountL ),
        ENTRY( "TestHuiBrushArrayDrawL", CTestUiAifCoreToolkit::TestHuiBrushArrayDrawL ),
        
        // for HuiBrushArray.h
        ENTRY( "TestHuiBrushArrayNewLL", CTestUiAifCoreToolkit::TestHuiBrushArrayNewLL ),
        ENTRY( "TestHuiBrushArrayNewLCL", CTestUiAifCoreToolkit::TestHuiBrushArrayNewLCL ),
        ENTRY( "TestHuiBrushArrayResetL", CTestUiAifCoreToolkit::TestHuiBrushArrayResetL ),
        ENTRY( "TestHuiBrushArrayAppendL", CTestUiAifCoreToolkit::TestHuiBrushArrayAppendL ),
        ENTRY( "TestHuiBrushArrayInsertL", CTestUiAifCoreToolkit::TestHuiBrushArrayInsertL ),
        ENTRY( "TestHuiBrushArrayRemoveL", CTestUiAifCoreToolkit::TestHuiBrushArrayRemoveL ),
        ENTRY( "TestHuiBrushArrayCountL", CTestUiAifCoreToolkit::TestHuiBrushArrayCountL ),
        ENTRY( "TestHuiBrushArrayOperatorL", CTestUiAifCoreToolkit::TestHuiBrushArrayOperatorL ),
        ENTRY( "TestHuiBrushArrayAtL", CTestUiAifCoreToolkit::TestHuiBrushArrayAtL ),
        ENTRY( "TestHuiBrushArrayLayerBrushCountL", CTestUiAifCoreToolkit::TestHuiBrushArrayLayerBrushCountL ),
        ENTRY( "TestHuiBrushArrayDrawL", CTestUiAifCoreToolkit::TestHuiBrushArrayDrawL ),
        
        // for HuiBrush.h
        ENTRY( "TestHuiBrushExpandVisualRectL", CTestUiAifCoreToolkit::TestHuiBrushExpandVisualRectL ),
        ENTRY( "TestHuiBrushSetChangedL", CTestUiAifCoreToolkit::TestHuiBrushSetChangedL ),
        ENTRY( "TestHuiBrushChangedL", CTestUiAifCoreToolkit::TestHuiBrushChangedL ),
        ENTRY( "TestHuiBrushClearChangedL", CTestUiAifCoreToolkit::TestHuiBrushClearChangedL ),
        ENTRY( "TestHuiBrushSetClipToVisualL", CTestUiAifCoreToolkit::TestHuiBrushSetClipToVisualL ),
        ENTRY( "TestHuiBrushClipToVisualL", CTestUiAifCoreToolkit::TestHuiBrushClipToVisualL ),
        ENTRY( "TestHuiBrushSetLayerL", CTestUiAifCoreToolkit::TestHuiBrushSetLayerL ),
        ENTRY( "TestHuiBrushLayerL", CTestUiAifCoreToolkit::TestHuiBrushLayerL ),
        ENTRY( "TestHuiBrushBeginDrawL", CTestUiAifCoreToolkit::TestHuiBrushBeginDrawL ),
        ENTRY( "TestHuiBrushDrawL", CTestUiAifCoreToolkit::TestHuiBrushDrawL ),
        ENTRY( "TestHuiBrushEndDrawL", CTestUiAifCoreToolkit::TestHuiBrushEndDrawL ),
        ENTRY( "TestHuiBrushTypeL", CTestUiAifCoreToolkit::TestHuiBrushTypeL ),
        ENTRY( "TestHuiBrushSessionIdL", CTestUiAifCoreToolkit::TestHuiBrushSessionIdL ),
        ENTRY( "TestHuiBrushSetSessionIdL", CTestUiAifCoreToolkit::TestHuiBrushSetSessionIdL ),
        ENTRY( "TestHuiBrushCHuiBrushL", CTestUiAifCoreToolkit::TestHuiBrushCHuiBrushL ),
        ENTRY( "TestHuiBrushBrushExtensionL", CTestUiAifCoreToolkit::TestHuiBrushBrushExtensionL ),
        // for HuiFrameBrush.h
        ENTRY( "TestHuiFrameBrushNewLL", CTestUiAifCoreToolkit::TestHuiFrameBrushNewLL ),
        ENTRY( "TestHuiFrameBrushNewLCL", CTestUiAifCoreToolkit::TestHuiFrameBrushNewLCL ),
        ENTRY( "TestHuiFrameBrushSetFrameRectsLL", CTestUiAifCoreToolkit::TestHuiFrameBrushSetFrameRectsLL ),
        ENTRY( "TestHuiFrameBrushSetEdgeOffsetL", CTestUiAifCoreToolkit::TestHuiFrameBrushSetEdgeOffsetL ),
        ENTRY( "TestHuiFrameBrushSetImageL", CTestUiAifCoreToolkit::TestHuiFrameBrushSetImageL ),
        // for HuiGradientBrush.h
        ENTRY( "TestHuiGradientBrushNewLL", CTestUiAifCoreToolkit::TestHuiGradientBrushNewLL ),
        ENTRY( "TestHuiGradientBrushNewLCL", CTestUiAifCoreToolkit::TestHuiGradientBrushNewLCL ),
        ENTRY( "TestHuiGradientBrushSetDirectionL", CTestUiAifCoreToolkit::TestHuiGradientBrushSetDirectionL ),
        ENTRY( "TestHuiGradientBrushSetColorL", CTestUiAifCoreToolkit::TestHuiGradientBrushSetColorL ),
        ENTRY( "TestHuiGradientBrushSetImageL", CTestUiAifCoreToolkit::TestHuiGradientBrushSetImageL ),
        ENTRY( "TestHuiGradientBrushColorL", CTestUiAifCoreToolkit::TestHuiGradientBrushColorL ),
        ENTRY( "TestHuiGradientBrushOpacityL", CTestUiAifCoreToolkit::TestHuiGradientBrushOpacityL ),
        ENTRY( "TestHuiGradientBrushImageL", CTestUiAifCoreToolkit::TestHuiGradientBrushImageL ),
        ENTRY( "TestHuiGradientBrushAppendColorLL", CTestUiAifCoreToolkit::TestHuiGradientBrushAppendColorLL ),
        // for HuiGc.h
        ENTRY( "TestHuiGcTHuiPathPoint", CTestUiAifCoreToolkit::TestHuiGcTHuiPathPoint ),
        ENTRY( "TestHuiGcDrawImageL", CTestUiAifCoreToolkit::TestHuiGcDrawImageL ),
        ENTRY( "TestHuiGcDrawImagesL", CTestUiAifCoreToolkit::TestHuiGcDrawImagesL ),
        ENTRY( "TestHuiGcFontL", CTestUiAifCoreToolkit::TestHuiGcFontL ),
        ENTRY( "TestHuiGcNearClipDistanceL", CTestUiAifCoreToolkit::TestHuiGcNearClipDistanceL ),
        ENTRY( "TestHuiGcFarClipDistanceL", CTestUiAifCoreToolkit::TestHuiGcFarClipDistanceL ),
        ENTRY( "TestHuiGcFovFactorL", CTestUiAifCoreToolkit::TestHuiGcFovFactorL ),
        ENTRY( "TestHuiGcOffset2DL", CTestUiAifCoreToolkit::TestHuiGcOffset2DL ),
        ENTRY( "TestHuiGcSetWindowTransformationL", CTestUiAifCoreToolkit::TestHuiGcSetWindowTransformationL ),
        ENTRY( "TestHuiGcLocaleTextAlignmentL", CTestUiAifCoreToolkit::TestHuiGcLocaleTextAlignmentL ),
        // for HuiOwnerdPointer.h
        ENTRY( "TestHuiOwnerdPointerCloseL", CTestUiAifCoreToolkit::TestHuiOwnerdPointerCloseL ),
        ENTRY( "TestHuiOwnerdPointerOperatorTL", CTestUiAifCoreToolkit::TestHuiOwnerdPointerOperatorTL ),
        ENTRY( "TestHuiOwnerdPointerOperatorConstTL", CTestUiAifCoreToolkit::TestHuiOwnerdPointerOperatorConstTL ),
        ENTRY( "TestHuiOwnerdPointerOperatorL", CTestUiAifCoreToolkit::TestHuiOwnerdPointerOperatorL ),
        ENTRY( "TestHuiOwnerdPointerPtrL", CTestUiAifCoreToolkit::TestHuiOwnerdPointerPtrL ),
        ENTRY( "TestHuiOwnerdPointerRefL", CTestUiAifCoreToolkit::TestHuiOwnerdPointerRefL ),
        ENTRY( "TestHuiOwnerdPointerNonConstRefL", CTestUiAifCoreToolkit::TestHuiOwnerdPointerNonConstRefL ),
        ENTRY( "TestHuiOwnerdPointerSetL", CTestUiAifCoreToolkit::TestHuiOwnerdPointerSetL ),
        ENTRY( "TestHuiOwnerdPointerOwnershipL", CTestUiAifCoreToolkit::TestHuiOwnerdPointerOwnershipL ),
        // for HuiGifAnimationTexture.h
        ENTRY( "TestHuiGifAnimationTextureNewLL", CTestUiAifCoreToolkit::TestHuiGifAnimationTextureNewLL ),
        ENTRY( "TestHuiGifAnimationTextureIdL", CTestUiAifCoreToolkit::TestHuiGifAnimationTextureIdL ),
        ENTRY( "TestHuiGifAnimationTextureStartL", CTestUiAifCoreToolkit::TestHuiGifAnimationTextureStartL ),
        ENTRY( "TestHuiGifAnimationTextureStopL", CTestUiAifCoreToolkit::TestHuiGifAnimationTextureStopL ),
        ENTRY( "TestHuiGifAnimationTextureEnableAnimationL", CTestUiAifCoreToolkit::TestHuiGifAnimationTextureEnableAnimationL ),
            // [test cases entries]

        // HuiLayout.h CHuiLayout
        ENTRY( "TestCHuiLayoutAddNewL",
            CTestUiAifCoreToolkit::TestCHuiLayoutAddNewL ),
        ENTRY( "TestCHuiLayoutConstructorL",
            CTestUiAifCoreToolkit::TestCHuiLayoutConstructorL ),
        ENTRY( "TestCHuiLayoutDestructorL",
            CTestUiAifCoreToolkit::TestCHuiLayoutDestructorL ),
        ENTRY( "TestCHuiLayoutConstructL",
            CTestUiAifCoreToolkit::TestCHuiLayoutConstructL ),
        ENTRY( "TestCHuiLayoutRemoveAndDestroyAllDL",
            CTestUiAifCoreToolkit::TestCHuiLayoutRemoveAndDestroyAllDL ),
        ENTRY( "TestCHuiLayoutFindTagL",
            CTestUiAifCoreToolkit::TestCHuiLayoutFindTagL ),
        ENTRY( "TestCHuiLayoutAppendL",
            CTestUiAifCoreToolkit::TestCHuiLayoutAppendL ),
        ENTRY( "TestCHuiLayoutInsertL",
            CTestUiAifCoreToolkit::TestCHuiLayoutInsertL ),
        ENTRY( "TestCHuiLayoutRemoveL",
            CTestUiAifCoreToolkit::TestCHuiLayoutRemoveL ),
        ENTRY( "TestCHuiLayoutCountL",
            CTestUiAifCoreToolkit::TestCHuiLayoutCountL ),
        ENTRY( "TestCHuiLayoutVisualL",
            CTestUiAifCoreToolkit::TestCHuiLayoutVisualL ),
        ENTRY( "TestCHuiLayoutFindVisualL",
            CTestUiAifCoreToolkit::TestCHuiLayoutFindVisualL ),
        ENTRY( "TestCHuiLayoutSetPosL",
            CTestUiAifCoreToolkit::TestCHuiLayoutSetPosL ),
        ENTRY( "TestCHuiLayoutSetSizeL",
            CTestUiAifCoreToolkit::TestCHuiLayoutSetSizeL ),
        ENTRY( "TestCHuiLayoutUpdateChildrenLayoutL",
            CTestUiAifCoreToolkit::TestCHuiLayoutUpdateChildrenLayoutL ),
        ENTRY( "TestCHuiLayoutUpdateChildLayoutL",
            CTestUiAifCoreToolkit::TestCHuiLayoutUpdateChildLayoutL ),
        ENTRY( "TestCHuiLayoutSetInnerPaddingL",
            CTestUiAifCoreToolkit::TestCHuiLayoutSetInnerPaddingL ),
        ENTRY( "TestCHuiLayoutSetInnerPaddingWithMetricL",
            CTestUiAifCoreToolkit::TestCHuiLayoutSetInnerPaddingWithMetricL ),
        ENTRY( "TestCHuiLayoutInnerPaddingL",
            CTestUiAifCoreToolkit::TestCHuiLayoutInnerPaddingL ),
        ENTRY( "TestCHuiLayoutHorizontalInnerPaddingL",
            CTestUiAifCoreToolkit::TestCHuiLayoutHorizontalInnerPaddingL ),
        ENTRY( "TestCHuiLayoutVerticalInnerPaddingL",
            CTestUiAifCoreToolkit::TestCHuiLayoutVerticalInnerPaddingL ),
        ENTRY( "TestCHuiLayoutInnerPaddingInBaseUnitsL",
            CTestUiAifCoreToolkit::TestCHuiLayoutInnerPaddingInBaseUnitsL ),
        ENTRY( "TestCHuiLayoutEnableScrollingL",
            CTestUiAifCoreToolkit::TestCHuiLayoutEnableScrollingL ),
        ENTRY( "TestCHuiLayoutScrollingL",
            CTestUiAifCoreToolkit::TestCHuiLayoutScrollingL ),
        ENTRY( "TestCHuiLayoutScrollOffsetL",
            CTestUiAifCoreToolkit::TestCHuiLayoutScrollOffsetL ),
        ENTRY( "TestCHuiLayoutScrollOffsetWithconstL",
            CTestUiAifCoreToolkit::TestCHuiLayoutScrollOffsetWithconstL ),
        ENTRY( "TestCHuiLayoutSetScrollOffsetInBaseUnitsL",
            CTestUiAifCoreToolkit::TestCHuiLayoutSetScrollOffsetInBaseUnitsL ),
        ENTRY( "TestCHuiLayoutVirtualSizeL",
            CTestUiAifCoreToolkit::TestCHuiLayoutVirtualSizeL ),
        ENTRY( "TestCHuiLayoutEffectiveLayoutOrdinalL",
            CTestUiAifCoreToolkit::TestCHuiLayoutEffectiveLayoutOrdinalL ),
        ENTRY( "TestCHuiLayoutReorderL",
            CTestUiAifCoreToolkit::TestCHuiLayoutReorderL ),
        ENTRY( "TestCHuiLayoutMoveVisualToFrontL",
            CTestUiAifCoreToolkit::TestCHuiLayoutMoveVisualToFrontL ),
        ENTRY( "TestCHuiLayoutMoveVisualToBackL",
            CTestUiAifCoreToolkit::TestCHuiLayoutMoveVisualToBackL ),
        ENTRY( "TestCHuiLayoutNotifySkinChangedL",
            CTestUiAifCoreToolkit::TestCHuiLayoutNotifySkinChangedL ),
        ENTRY( "TestCHuiLayoutSetTransitionTimeL",
            CTestUiAifCoreToolkit::TestCHuiLayoutSetTransitionTimeL ),
        ENTRY( "TestCHuiLayoutTransitionTimeL",
            CTestUiAifCoreToolkit::TestCHuiLayoutTransitionTimeL ),
        ENTRY( "TestCHuiLayoutChildOrdinalL",
            CTestUiAifCoreToolkit::TestCHuiLayoutChildOrdinalL ),
        ENTRY( "TestCHuiLayoutPrepareDrawL",
            CTestUiAifCoreToolkit::TestCHuiLayoutPrepareDrawL ),
        ENTRY( "TestCHuiLayoutDrawL",
            CTestUiAifCoreToolkit::TestCHuiLayoutDrawL ),
        ENTRY( "TestCHuiLayoutReportChangedL",
            CTestUiAifCoreToolkit::TestCHuiLayoutReportChangedL ),
        ENTRY( "TestCHuiLayoutClearChangedL",
            CTestUiAifCoreToolkit::TestCHuiLayoutClearChangedL ),
        ENTRY( "TestCHuiLayoutChangedL",
            CTestUiAifCoreToolkit::TestCHuiLayoutChangedL ),
        ENTRY( "TestCHuiLayoutDumpTreeL",
            CTestUiAifCoreToolkit::TestCHuiLayoutDumpTreeL ),
        ENTRY( "TestCHuiLayoutSetBaseUnitL",
            CTestUiAifCoreToolkit::TestCHuiLayoutSetBaseUnitL ),
        ENTRY( "TestCHuiLayoutSetBaseUnitXYL",
            CTestUiAifCoreToolkit::TestCHuiLayoutSetBaseUnitXYL ),
        ENTRY( "TestCHuiLayoutBaseUnitL",
            CTestUiAifCoreToolkit::TestCHuiLayoutBaseUnitL ),
        ENTRY( "TestCHuiLayoutInnerSizeL",
            CTestUiAifCoreToolkit::TestCHuiLayoutInnerSizeL ),
        ENTRY( "TestCHuiLayoutInnerTopLeftL",
            CTestUiAifCoreToolkit::TestCHuiLayoutInnerTopLeftL ),
        ENTRY( "TestCHuiLayoutChildSizeL",
            CTestUiAifCoreToolkit::TestCHuiLayoutChildSizeL ),
        ENTRY( "TestCHuiLayoutChildPosL",
            CTestUiAifCoreToolkit::TestCHuiLayoutChildPosL ),
        ENTRY( "TestCHuiLayoutChildRectL",
            CTestUiAifCoreToolkit::TestCHuiLayoutChildRectL ),
        ENTRY( "TestCHuiLayoutBrushOpacityL",
            CTestUiAifCoreToolkit::TestCHuiLayoutBrushOpacityL ),
        ENTRY( "TestCHuiLayoutBrushRectL",
            CTestUiAifCoreToolkit::TestCHuiLayoutBrushRectL ),
        ENTRY( "TestCHuiLayoutBrushSkinL",
            CTestUiAifCoreToolkit::TestCHuiLayoutBrushSkinL ),
        ENTRY( "TestCHuiLayoutGetInstanceNameL",
            CTestUiAifCoreToolkit::TestCHuiLayoutGetInstanceNameL ),
        ENTRY( "TestCHuiLayoutGetClassNameL",
            CTestUiAifCoreToolkit::TestCHuiLayoutGetClassNameL ),
        ENTRY( "TestCHuiLayoutTypeL",
            CTestUiAifCoreToolkit::TestCHuiLayoutTypeL ),
        ENTRY( "TestCHuiLayoutSessionIdL",
            CTestUiAifCoreToolkit::TestCHuiLayoutSessionIdL ),
        ENTRY( "TestCHuiLayoutSetSessionIdL",
            CTestUiAifCoreToolkit::TestCHuiLayoutSetSessionIdL ),
        ENTRY( "TestCHuiLayoutDrawSelfL",
            CTestUiAifCoreToolkit::TestCHuiLayoutDrawSelfL ),
        ENTRY( "TestHLMetricReferenceForLayoutInPixelsWithLayoutL",
            CTestUiAifCoreToolkit::TestHLMetricReferenceForLayoutInPixelsWithLayoutL ),
        ENTRY( "TestHLMetricReferenceForLayoutInPixelsL",
            CTestUiAifCoreToolkit::TestHLMetricReferenceForLayoutInPixelsL ),
        ENTRY( "TestCHuiLayoutExpandRectWithContentL",
            CTestUiAifCoreToolkit::TestCHuiLayoutExpandRectWithContentL ),
        ENTRY( "TestCHuiLayoutVisualExtensionL",
            CTestUiAifCoreToolkit::TestCHuiLayoutVisualExtensionL ),

        // HuiLineLayout.h CHuiLineVisual
        ENTRY( "TestCHLVAddNewL", CTestUiAifCoreToolkit::TestCHLVAddNewL ),
        ENTRY( "TestCHLVSetPathL", CTestUiAifCoreToolkit::TestCHLVSetPathL ),
        ENTRY( "TestCHLVPathL", CTestUiAifCoreToolkit::TestCHLVPathL ),
        ENTRY( "TestCHLVSetImageL", CTestUiAifCoreToolkit::TestCHLVSetImageL ),
        ENTRY( "TestCHLVSetAlphaFunctionL",
            CTestUiAifCoreToolkit::TestCHLVSetAlphaFunctionL ),
        ENTRY( "TestCHLVSetWidthFunctionL",
            CTestUiAifCoreToolkit::TestCHLVSetWidthFunctionL ),
        ENTRY( "TestCHLVSetColorL", CTestUiAifCoreToolkit::TestCHLVSetColorL ),

        // huim3gmesh.h CHuiM3GMesh
        ENTRY( "TestCHM3GMLoadSceneL", CTestUiAifCoreToolkit::TestCHM3GMLoadSceneL ),
        ENTRY( "TestCHM3GMSetAnimationPositionL",
            CTestUiAifCoreToolkit::TestCHM3GMSetAnimationPositionL ),
        ENTRY( "TestCHM3GMStartAnimationControllerL",
            CTestUiAifCoreToolkit::TestCHM3GMStartAnimationControllerL ),
        ENTRY( "TestCHM3GMStopAnimationControllerL",
            CTestUiAifCoreToolkit::TestCHM3GMStopAnimationControllerL ),
        
        // HuiMappingFunctions.h THuiConstantMappingFunction
        ENTRY( "TestTHCMFConstructorL", CTestUiAifCoreToolkit::TestTHCMFConstructorL ),
        ENTRY( "TestTHCMFMapValueL", CTestUiAifCoreToolkit::TestTHCMFMapValueL ),
        ENTRY( "TestTHLMFConstructorL", CTestUiAifCoreToolkit::TestTHLMFConstructorL ),
        ENTRY( "TestTHLMFMapValueL", CTestUiAifCoreToolkit::TestTHLMFMapValueL ),
        ENTRY( "TestTHSMFConstructorL", CTestUiAifCoreToolkit::TestTHSMFConstructorL ),
        ENTRY( "TestTHSMFMapValueL", CTestUiAifCoreToolkit::TestTHSMFMapValueL ),
        ENTRY( "TestTHCosineMFConstructorL",
            CTestUiAifCoreToolkit::TestTHCosineMFConstructorL ),
        ENTRY( "TestTHCosineMFMapValueL", CTestUiAifCoreToolkit::TestTHCosineMFMapValueL ),
        ENTRY( "TestTHAMFConstructorL", CTestUiAifCoreToolkit::TestTHAMFConstructorL ),
        ENTRY( "TestTHAMFMapValueL", CTestUiAifCoreToolkit::TestTHAMFMapValueL ),
        ENTRY( "TestTHAMFMappingFunctionChangedL",
            CTestUiAifCoreToolkit::TestTHAMFMappingFunctionChangedL ),
        ENTRY( "TestTHAMFMappingFunctionClearChangedL",
            CTestUiAifCoreToolkit::TestTHAMFMappingFunctionClearChangedL ),

        // huimesh.h CHuiMesh
        ENTRY( "TestCHuiMeshNewL", CTestUiAifCoreToolkit::TestCHuiMeshNewL ),
        ENTRY( "TestCHuiMeshNewLCL", CTestUiAifCoreToolkit::TestCHuiMeshNewLCL ),
        ENTRY( "TestCHuiMeshDestructL", CTestUiAifCoreToolkit::TestCHuiMeshDestructL ),
        ENTRY( "TestCHuiMeshMeshTypeL", CTestUiAifCoreToolkit::TestCHuiMeshMeshTypeL ),
        ENTRY( "TestCHuiMeshResetL", CTestUiAifCoreToolkit::TestCHuiMeshResetL ),
        ENTRY( "TestCHuiMeshStretchUniformlyL",
            CTestUiAifCoreToolkit::TestCHuiMeshStretchUniformlyL ),
        ENTRY( "TestCHuiMeshScaleUniformlyL",
            CTestUiAifCoreToolkit::TestCHuiMeshScaleUniformlyL ),
        ENTRY( "TestCHuiMeshTypeL", CTestUiAifCoreToolkit::TestCHuiMeshTypeL ),
        ENTRY( "TestCHuiMeshSessionIdL", CTestUiAifCoreToolkit::TestCHuiMeshSessionIdL ),
        ENTRY( "TestCHuiMeshSetSessionIdL", CTestUiAifCoreToolkit::TestCHuiMeshSetSessionIdL ),
        ENTRY( "TestCHuiMeshAnimationControllerCountL",
            CTestUiAifCoreToolkit::TestCHuiMeshAnimationControllerCountL ),
        ENTRY( "TestCHuiMeshSetAnimationPositionL",
            CTestUiAifCoreToolkit::TestCHuiMeshSetAnimationPositionL ),
        ENTRY( "TestCHuiMeshStartAnimationControllerL",
            CTestUiAifCoreToolkit::TestCHuiMeshStartAnimationControllerL ),
        ENTRY( "TestCHuiMeshStopAnimationControllerL",
            CTestUiAifCoreToolkit::TestCHuiMeshStopAnimationControllerL ),

        // huimeshvisual.h CHuiMeshVisual
        ENTRY( "TestCHuiMeshVisualAddNewL",
            CTestUiAifCoreToolkit::TestCHuiMeshVisualAddNewL ),
        ENTRY( "TestCHuiMeshVisualCreateMeshL",
            CTestUiAifCoreToolkit::TestCHuiMeshVisualCreateMeshL ),
        ENTRY( "TestCHuiMeshVisualSetImageL",
            CTestUiAifCoreToolkit::TestCHuiMeshVisualSetImageL ),
        ENTRY( "TestCHuiMeshVisualSetSecondaryImageL",
            CTestUiAifCoreToolkit::TestCHuiMeshVisualSetSecondaryImageL ),
        ENTRY( "TestCHuiMeshVisualSetSpecularImageL",
            CTestUiAifCoreToolkit::TestCHuiMeshVisualSetSpecularImageL ),
        ENTRY( "TestCHuiMeshVisualMeshL",
            CTestUiAifCoreToolkit::TestCHuiMeshVisualMeshL ),
        ENTRY( "TestCHuiMeshVisualProceduralMeshL",
            CTestUiAifCoreToolkit::TestCHuiMeshVisualProceduralMeshL ),
        ENTRY( "TestCHuiMeshVisualM3GMeshL",
            CTestUiAifCoreToolkit::TestCHuiMeshVisualM3GMeshL ),

        // huimetric.h THuiMetric
        ENTRY( "TestTHMConstructor", CTestUiAifCoreToolkit::TestTHMConstructor ),
        ENTRY( "TestTHMConstructorWithPixel",
            CTestUiAifCoreToolkit::TestTHMConstructorWithPixel ),
        ENTRY( "TestTHMAbs", CTestUiAifCoreToolkit::TestTHMAbs ),
        ENTRY( "TestTHMoperator", CTestUiAifCoreToolkit::TestTHMoperator ),
        // THuiXYMetric
        ENTRY( "TestTHXYMConstructor", CTestUiAifCoreToolkit::TestTHXYMConstructor ),
        ENTRY( "TestTHXYMConstructorWithMetric",
            CTestUiAifCoreToolkit::TestTHXYMConstructorWithMetric ),
        ENTRY( "TestTHXYMConstructorWithTwo",
            CTestUiAifCoreToolkit::TestTHXYMConstructorWithTwo ),
        ENTRY( "TestTHXYMoperator", CTestUiAifCoreToolkit::TestTHXYMoperator ),
        ENTRY( "TestTHXYMAbs", CTestUiAifCoreToolkit::TestTHXYMAbs ),
        // THuiBoxMetric
        ENTRY( "TestTHBMConstructor", CTestUiAifCoreToolkit::TestTHBMConstructor ),
        ENTRY( "TestTHBMConstructorWithMetric",
            CTestUiAifCoreToolkit::TestTHBMConstructorWithMetric ),
        ENTRY( "TestTHBMConstructorWithXYMetric",
            CTestUiAifCoreToolkit::TestTHBMConstructorWithXYMetric ),
        ENTRY( "TestTHBMConstructorWithTwo",
            CTestUiAifCoreToolkit::TestTHBMConstructorWithTwo ),
        ENTRY( "TestTHBMConstructorWithFour",
            CTestUiAifCoreToolkit::TestTHBMConstructorWithFour ),

        // huirealpoint.h THuiRealPoint
        ENTRY( "TestTHRPConstructor", CTestUiAifCoreToolkit::TestTHRPConstructor ),
        ENTRY( "TestTHRPConstructorWithTReal",
            CTestUiAifCoreToolkit::TestTHRPConstructorWithTReal ),
        ENTRY( "TestTHRPConstructorWithTPoint",
            CTestUiAifCoreToolkit::TestTHRPConstructorWithTPoint ),
        ENTRY( "TestTHRPAsSize", CTestUiAifCoreToolkit::TestTHRPAsSize ),
        ENTRY( "TestTHRPTPoint", CTestUiAifCoreToolkit::TestTHRPTPoint ),
        ENTRY( "TestTHRPRound", CTestUiAifCoreToolkit::TestTHRPRound ),
        ENTRY( "TestTHRPoperator1", CTestUiAifCoreToolkit::TestTHRPoperator1 ),
        ENTRY( "TestTHRPoperator2", CTestUiAifCoreToolkit::TestTHRPoperator2 ),
        ENTRY( "TestTHRPoperator3", CTestUiAifCoreToolkit::TestTHRPoperator3 ),
        ENTRY( "TestTHRPoperator4", CTestUiAifCoreToolkit::TestTHRPoperator4 ),
        ENTRY( "TestTHRPoperator5", CTestUiAifCoreToolkit::TestTHRPoperator5 ),
        ENTRY( "TestTHRPoperator6", CTestUiAifCoreToolkit::TestTHRPoperator6 ),
        ENTRY( "TestTHRPAbs", CTestUiAifCoreToolkit::TestTHRPAbs ),

        // huirealrect.h THuiRealRect
        ENTRY( "TestTHRRConstructor", CTestUiAifCoreToolkit::TestTHRRConstructor ),
        ENTRY( "TestTHRRConstructorWithPoint",
            CTestUiAifCoreToolkit::TestTHRRConstructorWithPoint ),
        ENTRY( "TestTHRRConstructorWithPointAndSize",
            CTestUiAifCoreToolkit::TestTHRRConstructorWithPointAndSize ),
        ENTRY( "TestTHRRConstructorWithTRect",
            CTestUiAifCoreToolkit::TestTHRRConstructorWithTRect ),
        ENTRY( "TestTHRRWidth", CTestUiAifCoreToolkit::TestTHRRWidth ),
        ENTRY( "TestTHRRHeight", CTestUiAifCoreToolkit::TestTHRRHeight ),
        ENTRY( "TestTHRRTopRight", CTestUiAifCoreToolkit::TestTHRRTopRight ),
        ENTRY( "TestTHRRBottomLeft", CTestUiAifCoreToolkit::TestTHRRBottomLeft ),
        ENTRY( "TestTHRRSize", CTestUiAifCoreToolkit::TestTHRRSize ),
        ENTRY( "TestTHRRCenter", CTestUiAifCoreToolkit::TestTHRRCenter ),
        ENTRY( "TestTHRRGrow", CTestUiAifCoreToolkit::TestTHRRGrow ),
        ENTRY( "TestTHRRShrink", CTestUiAifCoreToolkit::TestTHRRShrink ),
        ENTRY( "TestTHRRShrinkTPoint", CTestUiAifCoreToolkit::TestTHRRShrinkTPoint ),
        ENTRY( "TestTHRRShrinkTHuiRealPoint", 
            CTestUiAifCoreToolkit::TestTHRRShrinkTHuiRealPoint ),
        ENTRY( "TestTHRRShrinkTHuiRealRect",
            CTestUiAifCoreToolkit::TestTHRRShrinkTHuiRealRect ),
        ENTRY( "TestTHRRMove", CTestUiAifCoreToolkit::TestTHRRMove ),
        ENTRY( "TestTHRRoperatorTRect", CTestUiAifCoreToolkit::TestTHRRoperatorTRect ),
        ENTRY( "TestTHRRRound", CTestUiAifCoreToolkit::TestTHRRRound ),
        ENTRY( "TestTHRRBoundingRect", CTestUiAifCoreToolkit::TestTHRRBoundingRect ),

        // huirealsize.h THuiRealSize
        ENTRY( "TestTHRSConstructor", CTestUiAifCoreToolkit::TestTHRSConstructor ),
        ENTRY( "TestTHRSConstructorWithTReal",
            CTestUiAifCoreToolkit::TestTHRSConstructorWithTReal ),
        ENTRY( "TestTHRSConstructorWithTSize",
            CTestUiAifCoreToolkit::TestTHRSConstructorWithTSize ),
        ENTRY( "TestTHRSoperatorTSize", CTestUiAifCoreToolkit::TestTHRSoperatorTSize ),
        ENTRY( "TestTHRSRound", CTestUiAifCoreToolkit::TestTHRSRound ),
        ENTRY( "TestTHRSoperatorPlus", CTestUiAifCoreToolkit::TestTHRSoperatorPlus ),

        // huiproceduralmesh.h CHuiProceduralMesh
        ENTRY( "TestHPMDeleteL", CTestUiAifCoreToolkit::TestHPMDeleteL ),
        ENTRY( "TestHPMResetL", CTestUiAifCoreToolkit::TestHPMResetL ),
        ENTRY( "TestHPMMakeCubeL", CTestUiAifCoreToolkit::TestHPMMakeCubeL ),
        ENTRY( "TestHPMMakeSphereL", CTestUiAifCoreToolkit::TestHPMMakeSphereL ),
        ENTRY( "TestHPMMakeTorusL", CTestUiAifCoreToolkit::TestHPMMakeTorusL ),
        ENTRY( "TestHPMStretchUniformlyL",
            CTestUiAifCoreToolkit::TestHPMStretchUniformlyL ),
        ENTRY( "TestHPMScaleUniformlyL", CTestUiAifCoreToolkit::TestHPMScaleUniformlyL ),

        // huistatic.h CHuiStatic
        ENTRY( "TestCHuiStaticEnv", CTestUiAifCoreToolkit::TestCHuiStaticEnv ),
        ENTRY( "TestCHuiStaticTime", CTestUiAifCoreToolkit::TestCHuiStaticTime ),
        ENTRY( "TestCHuiStaticSetTimeFactor",
            CTestUiAifCoreToolkit::TestCHuiStaticSetTimeFactor ),
        ENTRY( "TestCHuiStaticTimeFactor", CTestUiAifCoreToolkit::TestCHuiStaticTimeFactor ),
        ENTRY( "TestCHuiStaticPauseTime", CTestUiAifCoreToolkit::TestCHuiStaticPauseTime ),
        ENTRY( "TestCHuiStaticContinueTime",
            CTestUiAifCoreToolkit::TestCHuiStaticContinueTime ),
        ENTRY( "TestCHuiStaticTimePaused", CTestUiAifCoreToolkit::TestCHuiStaticTimePaused ),
        ENTRY( "TestCHuiStaticElapsedSeconds",
            CTestUiAifCoreToolkit::TestCHuiStaticElapsedSeconds ),
        ENTRY( "TestCHuiStaticSecondsSinceStart",
            CTestUiAifCoreToolkit::TestCHuiStaticSecondsSinceStart ),
        ENTRY( "TestCHuiStaticMilliSecondsSinceStart",
            CTestUiAifCoreToolkit::TestCHuiStaticMilliSecondsSinceStart ),
        ENTRY( "TestCHuiStaticFrameCount", CTestUiAifCoreToolkit::TestCHuiStaticFrameCount ),
        ENTRY( "TestCHuiStaticAverageFrameRate",
            CTestUiAifCoreToolkit::TestCHuiStaticAverageFrameRate ),
        ENTRY( "TestCHuiStaticFrameRate", CTestUiAifCoreToolkit::TestCHuiStaticFrameRate ),
        ENTRY( "TestCHuiStaticPrintfTDesC8",
            CTestUiAifCoreToolkit::TestCHuiStaticPrintfTDesC8 ),
        ENTRY( "TestCHuiStaticPrintfTDesC16",
            CTestUiAifCoreToolkit::TestCHuiStaticPrintfTDesC16 ),
        ENTRY( "TestCHuiStaticEnableLogging",
            CTestUiAifCoreToolkit::TestCHuiStaticEnableLogging ),
        ENTRY( "TestCHuiStaticLogging", CTestUiAifCoreToolkit::TestCHuiStaticLogging ),
        ENTRY( "TestCHuiStaticTic", CTestUiAifCoreToolkit::TestCHuiStaticTic ),
        ENTRY( "TestCHuiStaticToc", CTestUiAifCoreToolkit::TestCHuiStaticToc ),
        ENTRY( "TestCHuiStaticFsSession", CTestUiAifCoreToolkit::TestCHuiStaticFsSession ),
        ENTRY( "TestCHuiStaticSetLayoutTransitionTime",
                CTestUiAifCoreToolkit::TestCHuiStaticSetLayoutTransitionTime ),
        ENTRY( "TestCHuiStaticLayoutTransitionTime",
                CTestUiAifCoreToolkit::TestCHuiStaticLayoutTransitionTime ),
        ENTRY( "TestCHuiStaticSetProbe", CTestUiAifCoreToolkit::TestCHuiStaticSetProbe ),

        // huisoftkeycontrol.h CHuiSoftKeyControl
        ENTRY( "TestCHSKCNewL", CTestUiAifCoreToolkit::TestCHSKCNewL ),
        ENTRY( "TestCHSKCNewLCL", CTestUiAifCoreToolkit::TestCHSKCNewLCL ),
        ENTRY( "TestCHSKCDestruct", CTestUiAifCoreToolkit::TestCHSKCDestructL ),
        ENTRY( "TestCHSKCSetLabelL", CTestUiAifCoreToolkit::TestCHSKCSetLabelL ),
        ENTRY( "TestCHSKCSetBackgroundL", CTestUiAifCoreToolkit::TestCHSKCSetBackgroundL ),
        ENTRY( "TestCHSKCSetAnimationTimesL",
            CTestUiAifCoreToolkit::TestCHSKCSetAnimationTimesL ),
        ENTRY( "TestCHSKCEnterViewL", CTestUiAifCoreToolkit::TestCHSKCEnterViewL ),
        ENTRY( "TestCHSKCExitViewL", CTestUiAifCoreToolkit::TestCHSKCExitViewL ),
        ENTRY( "TestCHSKCSetBackgroundTypeL",
            CTestUiAifCoreToolkit::TestCHSKCSetBackgroundTypeL ),

        // huiutil.h HuiUtil
        ENTRY( "TestHuiUtilPower2", CTestUiAifCoreToolkit::TestHuiUtilPower2 ),
        ENTRY( "TestHuiUtilPower2RoundDown",
            CTestUiAifCoreToolkit::TestHuiUtilPower2RoundDown ),
        ENTRY( "TestHuiUtilInterpolate", CTestUiAifCoreToolkit::TestHuiUtilInterpolate ),
        ENTRY( "TestHuiUtilWrapValue", CTestUiAifCoreToolkit::TestHuiUtilWrapValue ),
        ENTRY( "TestHuiUtilRandomInt", CTestUiAifCoreToolkit::TestHuiUtilRandomInt ),
        ENTRY( "TestHuiUtilRandomReal", CTestUiAifCoreToolkit::TestHuiUtilRandomReal ),
        ENTRY( "TestHuiUtilQuickLengthWithPoint",
            CTestUiAifCoreToolkit::TestHuiUtilQuickLengthWithPoint ),
        ENTRY( "TestHuiUtilQuickLength", CTestUiAifCoreToolkit::TestHuiUtilQuickLength ),
        ENTRY( "TestHuiUtilQuickNormalizeWithPoint",
            CTestUiAifCoreToolkit::TestHuiUtilQuickNormalizeWithPoint ),
        ENTRY( "TestHuiUtilQuickNormalize",
            CTestUiAifCoreToolkit::TestHuiUtilQuickNormalize ),
        ENTRY( "TestHuiUtilCrossProduct",
            CTestUiAifCoreToolkit::TestHuiUtilCrossProduct ),
        ENTRY( "TestHuiUtilNormalFromPoints",
            CTestUiAifCoreToolkit::TestHuiUtilNormalFromPoints ),
        ENTRY( "TestHuiUtilShadowMatrix",
            CTestUiAifCoreToolkit::TestHuiUtilShadowMatrix ),
        ENTRY( "TestHuiUtilFreeMemory", CTestUiAifCoreToolkit::TestHuiUtilFreeMemory ),
        ENTRY( "TestHuiUtilScreenSize", CTestUiAifCoreToolkit::TestHuiUtilScreenSize ),
        ENTRY( "TestHuiUtilLengthUnit", CTestUiAifCoreToolkit::TestHuiUtilLengthUnit ),
        ENTRY( "TestHuiUtilColorLightness",
            CTestUiAifCoreToolkit::TestHuiUtilColorLightness ),
        ENTRY( "TestHuiUtilScaleFbsBitmapL",
            CTestUiAifCoreToolkit::TestHuiUtilScaleFbsBitmapL ),
        ENTRY( "TestHuiUtilCombineMaskFbsBitmapL",
            CTestUiAifCoreToolkit::TestHuiUtilCombineMaskFbsBitmapL ),
        ENTRY( "TestHuiUtilCropFbsBitmapL",
            CTestUiAifCoreToolkit::TestHuiUtilCropFbsBitmapL ),
        ENTRY( "TestHuiUtilScaleImageL", CTestUiAifCoreToolkit::TestHuiUtilScaleImageL ),
        ENTRY( "TestHuiUtilCropImageL", CTestUiAifCoreToolkit::TestHuiUtilCropImageL ),
        ENTRY( "TestHuiUtilTagMatches", CTestUiAifCoreToolkit::TestHuiUtilTagMatches ),
        ENTRY( "TestHuiUtilConvertBitmapToDisplayModeLCL",
            CTestUiAifCoreToolkit::TestHuiUtilConvertBitmapToDisplayModeLCL ),
        
        // huitimedvalue.h MHuiMappingFunction
        ENTRY( "TestMHMFMappingFunctionChangedL",
            CTestUiAifCoreToolkit::TestMHMFMappingFunctionChangedL ),
        ENTRY( "TestMHMFMappingFunctionClearChangedL",
            CTestUiAifCoreToolkit::TestMHMFMappingFunctionClearChangedL ),
        ENTRY( "TestTHTVConstructor", CTestUiAifCoreToolkit::TestTHTVConstructor ),
        ENTRY( "TestTHTVConstructorWithValue",
            CTestUiAifCoreToolkit::TestTHTVConstructorWithValue ),
        ENTRY( "TestTHTVStyle", CTestUiAifCoreToolkit::TestTHTVStyle ),
        ENTRY( "TestTHTVSetStyle", CTestUiAifCoreToolkit::TestTHTVSetStyle ),
        ENTRY( "TestTHTVSetFunction", CTestUiAifCoreToolkit::TestTHTVSetFunction ),
        ENTRY( "TestTHTVSetMappingMode",
            CTestUiAifCoreToolkit::TestTHTVSetMappingMode ),
        ENTRY( "TestTHTVNow", CTestUiAifCoreToolkit::TestTHTVNow ),
        ENTRY( "TestTHTVUnmappedNow", CTestUiAifCoreToolkit::TestTHTVUnmappedNow ),
        ENTRY( "TestTHTVTarget", CTestUiAifCoreToolkit::TestTHTVTarget ),
        ENTRY( "TestTHTVSetValue", CTestUiAifCoreToolkit::TestTHTVSetValue ),
        ENTRY( "TestTHTVSetValueTime", CTestUiAifCoreToolkit::TestTHTVSetValueTime ),
        ENTRY( "TestTHTVSetWithSpeed", CTestUiAifCoreToolkit::TestTHTVSetWithSpeed ),
        ENTRY( "TestTHTVRemainingTime",
            CTestUiAifCoreToolkit::TestTHTVRemainingTime ),
        ENTRY( "TestTHTVFinish", CTestUiAifCoreToolkit::TestTHTVFinish ),
        ENTRY( "TestTHTVChanged", CTestUiAifCoreToolkit::TestTHTVChanged ),
        ENTRY( "TestTHTVInterpolating",
            CTestUiAifCoreToolkit::TestTHTVInterpolating ),
        ENTRY( "TestTHTVClearChanged", CTestUiAifCoreToolkit::TestTHTVClearChanged ),
        ENTRY( "TestTHTVEnableClock", CTestUiAifCoreToolkit::TestTHTVEnableClock ),
        ENTRY( "TestTHTVSuspend", CTestUiAifCoreToolkit::TestTHTVSuspend ),
        ENTRY( "TestTHTVoperatorEqualTo",
            CTestUiAifCoreToolkit::TestTHTVoperatorEqualTo ),

        //huiimage.h THuiImage
        ENTRY( "TestTHIConstructor", CTestUiAifCoreToolkit::TestTHIConstructor ),
        ENTRY( "TestTHIConstructorWithParaL",
            CTestUiAifCoreToolkit::TestTHIConstructorWithParaL ),
        ENTRY( "TestTHISegmentCountL", CTestUiAifCoreToolkit::TestTHISegmentCountL ),
        ENTRY( "TestTHIGetVertexCoordsL",
            CTestUiAifCoreToolkit::TestTHIGetVertexCoordsL ),
        ENTRY( "TestTHIGetTexCoordsL", CTestUiAifCoreToolkit::TestTHIGetTexCoordsL ),
        ENTRY( "TestTHISetTexCoords", CTestUiAifCoreToolkit::TestTHISetTexCoordsL ),
        ENTRY( "TestTHITopLeft", CTestUiAifCoreToolkit::TestTHITopLeftL ),
        ENTRY( "TestTHIBottomRight", CTestUiAifCoreToolkit::TestTHIBottomRightL ),
        ENTRY( "TestTHIHasTexture", CTestUiAifCoreToolkit::TestTHIHasTextureL ),
        ENTRY( "TestTHISetTextureL", CTestUiAifCoreToolkit::TestTHISetTextureL ),
        ENTRY( "TestTHITextureL", CTestUiAifCoreToolkit::TestTHITextureL ),
        ENTRY( "TestTHITextureIfL", CTestUiAifCoreToolkit::TestTHITextureIfL ),
        ENTRY( "TestTHIHasShadow", CTestUiAifCoreToolkit::TestTHIHasShadow ),
        ENTRY( "TestTHIShadowTexture", CTestUiAifCoreToolkit::TestTHIShadowTexture ),
        ENTRY( "TestTHITranslate", CTestUiAifCoreToolkit::TestTHITranslate ),
        ENTRY( "TestTHIScale", CTestUiAifCoreToolkit::TestTHIScale ),

        //huiimagebrush.h CHuiImageBrush
        ENTRY( "TestCHIBNewL", CTestUiAifCoreToolkit::TestCHIBNewL ),
        ENTRY( "TestCHIBNewLCL", CTestUiAifCoreToolkit::TestCHIBNewLCL ),
        ENTRY( "TestCHIBSetScaleModeL",
            CTestUiAifCoreToolkit::TestCHIBSetScaleModeL ),
        ENTRY( "TestCHIBSetImageL", CTestUiAifCoreToolkit::TestCHIBSetImageL ),
        ENTRY( "TestCHIBSetBordersL", CTestUiAifCoreToolkit::TestCHIBSetBordersL ),
        ENTRY( "TestCHIBBorderDrawingEnabledL",
            CTestUiAifCoreToolkit::TestCHIBBorderDrawingEnabledL ),
        ENTRY( "TestCHIBCenterDrawingEnabledL",
            CTestUiAifCoreToolkit::TestCHIBCenterDrawingEnabledL ),
        ENTRY( "TestCHIBExpandVisualRectL",
            CTestUiAifCoreToolkit::TestCHIBExpandVisualRectL ),
        ENTRY( "TestCHIBDrawL", CTestUiAifCoreToolkit::TestCHIBDrawL ),

        // huitimedpoint.h THuiTimedPoint
        ENTRY( "TestTHTPConstructor", CTestUiAifCoreToolkit::TestTHTPConstructor ),
        ENTRY( "TestTHTPConstructorWithTReal",
            CTestUiAifCoreToolkit::TestTHTPConstructorWithTReal ),
        ENTRY( "TestTHTPSetStyle", CTestUiAifCoreToolkit::TestTHTPSetStyle ),
        ENTRY( "TestTHTPSetFunctionL", CTestUiAifCoreToolkit::TestTHTPSetFunctionL ),
        ENTRY( "TestTHTPSet", CTestUiAifCoreToolkit::TestTHTPSet ),
        ENTRY( "TestTHTPSetTReal", CTestUiAifCoreToolkit::TestTHTPSetTReal ),
        ENTRY( "TestTHTPSetWithSpeed", CTestUiAifCoreToolkit::TestTHTPSetWithSpeed ),
        ENTRY( "TestTHTPSetWithSpeedTReal",
            CTestUiAifCoreToolkit::TestTHTPSetWithSpeedTReal ),
        ENTRY( "TestTHTPNow", CTestUiAifCoreToolkit::TestTHTPNow ),
        ENTRY( "TestTHTPRealNow", CTestUiAifCoreToolkit::TestTHTPRealNow ),
        ENTRY( "TestTHTPTarget", CTestUiAifCoreToolkit::TestTHTPTarget ),
        ENTRY( "TestTHTPRealTarget", CTestUiAifCoreToolkit::TestTHTPRealTarget ),
        ENTRY( "TestTHTPFinish", CTestUiAifCoreToolkit::TestTHTPFinish ),

        // huitexturehandle.h THuiTextureHandle
        ENTRY( "TestTHTHConstructorL", CTestUiAifCoreToolkit::TestTHTHConstructorL ),
        ENTRY( "TestTHTHConstructorWithParaL",
            CTestUiAifCoreToolkit::TestTHTHConstructorWithParaL ),
        ENTRY( "TestTHTHIsNullL", CTestUiAifCoreToolkit::TestTHTHIsNullL ),
        ENTRY( "TestTHTHHasContentL", CTestUiAifCoreToolkit::TestTHTHHasContentL ),
        ENTRY( "TestTHTHReleaseL", CTestUiAifCoreToolkit::TestTHTHReleaseL ),
        ENTRY( "TestTHTHSetL", CTestUiAifCoreToolkit::TestTHTHSetL ),
        ENTRY( "TestTHTHSetNameL", CTestUiAifCoreToolkit::TestTHTHSetNameL ),
        ENTRY( "TestTHTHSetSizeL", CTestUiAifCoreToolkit::TestTHTHSetSizeL ),
        ENTRY( "TestTHTHSetTextureSizeL",
            CTestUiAifCoreToolkit::TestTHTHSetTextureSizeL ),
        ENTRY( "TestTHTHSegmentedTextureL",
            CTestUiAifCoreToolkit::TestTHTHSegmentedTextureL ),
        ENTRY( "TestTHTHSegmentedTextureconstL",
            CTestUiAifCoreToolkit::TestTHTHSegmentedTextureconstL ),
        ENTRY( "TestTHTHShadowedTextureL",
            CTestUiAifCoreToolkit::TestTHTHShadowedTextureL ),
        ENTRY( "TestTHTHShadowedTextureconstL",
            CTestUiAifCoreToolkit::TestTHTHShadowedTextureconstL ),
        ENTRY( "TestTHTHTextureChangedL",
            CTestUiAifCoreToolkit::TestTHTHTextureChangedL ),
        ENTRY( "TestTHTHTextureClearChangedL",
            CTestUiAifCoreToolkit::TestTHTHTextureClearChangedL ),
        ENTRY( "TestTHTHNameL", CTestUiAifCoreToolkit::TestTHTHNameL ),
        ENTRY( "TestTHTHSizeL", CTestUiAifCoreToolkit::TestTHTHSizeL ),
        ENTRY( "TestTHTHSegmentCountL",
            CTestUiAifCoreToolkit::TestTHTHSegmentCountL ),
        ENTRY( "TestTHTHSegmentNameL",
            CTestUiAifCoreToolkit::TestTHTHSegmentNameL ),
        ENTRY( "TestTHTHSegmentSizeL",
            CTestUiAifCoreToolkit::TestTHTHSegmentSizeL ),
        ENTRY( "TestTHTHSegmentTextureSizeL",
            CTestUiAifCoreToolkit::TestTHTHSegmentTextureSizeL ),
        ENTRY( "TestTHTHSegmentOffsetL",
            CTestUiAifCoreToolkit::TestTHTHSegmentOffsetL ),
        ENTRY( "TestTHTHTextureExtensionL",
            CTestUiAifCoreToolkit::TestTHTHTextureExtensionL ),

        // huitransformation.h CHuiTransformation
        ENTRY( "TestCHTranNewL", CTestUiAifCoreToolkit::TestCHTranNewL ),
        ENTRY( "TestCHTranNewLCL", CTestUiAifCoreToolkit::TestCHTranNewLCL ),
        ENTRY( "TestCHTranCountL", CTestUiAifCoreToolkit::TestCHTranCountL ),
        ENTRY( "TestCHTranNonIdentityCountL",
            CTestUiAifCoreToolkit::TestCHTranNonIdentityCountL ),
        ENTRY( "TestCHTranStepL", CTestUiAifCoreToolkit::TestCHTranStepL ),
        ENTRY( "TestCHTranoperatorL", CTestUiAifCoreToolkit::TestCHTranoperatorL ),
        ENTRY( "TestCHTranLoadIdentityL",
            CTestUiAifCoreToolkit::TestCHTranLoadIdentityL ),
        ENTRY( "TestCHTranTranslateL", CTestUiAifCoreToolkit::TestCHTranTranslateL ),
        ENTRY( "TestCHTranTranslateWithValueL",
            CTestUiAifCoreToolkit::TestCHTranTranslateWithValueL ),
        ENTRY( "TestCHTranScaleL", CTestUiAifCoreToolkit::TestCHTranScaleL ),
        ENTRY( "TestCHTranScaleWithValueL",
            CTestUiAifCoreToolkit::TestCHTranScaleWithValueL ),
        ENTRY( "TestCHTranScaleWithThreeL",
            CTestUiAifCoreToolkit::TestCHTranScaleWithThreeL ),
        ENTRY( "TestCHTranScaleWithThreeValueL",
            CTestUiAifCoreToolkit::TestCHTranScaleWithThreeValueL ),
        ENTRY( "TestCHTranRotateL", CTestUiAifCoreToolkit::TestCHTranRotateL ),
        ENTRY( "TestCHTranRotateValueL",
            CTestUiAifCoreToolkit::TestCHTranRotateValueL ),
        ENTRY( "TestCHTranRotateFourL",
            CTestUiAifCoreToolkit::TestCHTranRotateFourL ),
        ENTRY( "TestCHTranRotateValueThreeL",
            CTestUiAifCoreToolkit::TestCHTranRotateValueThreeL ),
        
        // huifixmath.h HuiFixMath
        ENTRY( "TestHFMFixHypot", CTestUiAifCoreToolkit::TestHFMFixHypot ),
        ENTRY( "TestHFMFixSin", CTestUiAifCoreToolkit::TestHFMFixSin ),
        ENTRY( "TestHFMFixCos", CTestUiAifCoreToolkit::TestHFMFixCos ),
        ENTRY( "TestHFMFixMul", CTestUiAifCoreToolkit::TestHFMFixMul ),
        ENTRY( "TestHFMFixDiv", CTestUiAifCoreToolkit::TestHFMFixDiv ),
        ENTRY( "TestHFMFloatToFix", CTestUiAifCoreToolkit::TestHFMFloatToFix ),
        ENTRY( "TestHFMFixToFloat", CTestUiAifCoreToolkit::TestHFMFixToFloat ),

        // huifont.h THuiFont
        ENTRY( "TestTHFConstructorL", CTestUiAifCoreToolkit::TestTHFConstructorL ),
        ENTRY( "TestTHFConstructorWithParaL",
            CTestUiAifCoreToolkit::TestTHFConstructorWithParaL ),
        ENTRY( "TestTHFConstructorWithFontL",
            CTestUiAifCoreToolkit::TestTHFConstructorWithFontL ),
        ENTRY( "TestTHFoperatorEqualL", CTestUiAifCoreToolkit::TestTHFoperatorEqual ),
        ENTRY( "TestTHFIdL", CTestUiAifCoreToolkit::TestTHFIdL ),
        ENTRY( "TestTHFCategoryL", CTestUiAifCoreToolkit::TestTHFCategoryL ),
        ENTRY( "TestTHFFontSpecL", CTestUiAifCoreToolkit::TestTHFFontSpecL ),

        // huifontmanager.h THuiFontManager
        ENTRY( "TestTHFMEnumerateFontsL",
            CTestUiAifCoreToolkit::TestTHFMEnumerateFontsL ),

        // huiinteractioninterval.h THuiInteractionInterval
        ENTRY( "TestTHIIConstructorL", CTestUiAifCoreToolkit::TestTHIIConstructorL ),
        ENTRY( "TestTHIISetScalarL", CTestUiAifCoreToolkit::TestTHIISetScalarL ),
        ENTRY( "TestTHIIScalarL", CTestUiAifCoreToolkit::TestTHIIScalarL ),
        ENTRY( "TestTHIIIntervalL", CTestUiAifCoreToolkit::TestTHIIIntervalL ),

        // For test the huitextvisual.h
        ENTRY( "TestHuiTextVisualAddNewL", CTestUiAifCoreToolkit::TestHuiTextVisualAddNewL ),
        ENTRY( "TestHuiTextVisualSetTextL", CTestUiAifCoreToolkit::TestHuiTextVisualSetTextL ),
        ENTRY( "TestHuiTextVisualText", CTestUiAifCoreToolkit::TestHuiTextVisualText ),
        ENTRY( "TestHuiTextVisualSetAlign", CTestUiAifCoreToolkit::TestHuiTextVisualSetAlign ),
        ENTRY( "TestHuiTextVisualSetLineSpacing", CTestUiAifCoreToolkit::TestHuiTextVisualSetLineSpacing ),
        ENTRY( "TestHuiTextVisualSetStyle", CTestUiAifCoreToolkit::TestHuiTextVisualSetStyle ),
        ENTRY( "TestHuiTextVisualSetTextStyle", CTestUiAifCoreToolkit::TestHuiTextVisualSetTextStyle ),
        ENTRY( "TestHuiTextVisualStyle", CTestUiAifCoreToolkit::TestHuiTextVisualStyle ),
        ENTRY( "TestHuiTextVisualTextStyle", CTestUiAifCoreToolkit::TestHuiTextVisualTextStyle ),
        ENTRY( "TestHuiTextVisualSetMaxLineCount", CTestUiAifCoreToolkit::TestHuiTextVisualSetMaxLineCount ),
        ENTRY( "TestHuiTextVisualMaxLineCount", CTestUiAifCoreToolkit::TestHuiTextVisualMaxLineCount ),
        ENTRY( "TestHuiTextVisualWrapping", CTestUiAifCoreToolkit::TestHuiTextVisualWrapping ),
        ENTRY( "TestHuiTextVisualSetWrapping", CTestUiAifCoreToolkit::TestHuiTextVisualSetWrapping ),
        ENTRY( "TestHuiTextVisualBackgroundType", CTestUiAifCoreToolkit::TestHuiTextVisualBackgroundType ),
        ENTRY( "TestHuiTextVisualOffset", CTestUiAifCoreToolkit::TestHuiTextVisualOffset ),
        ENTRY( "TestHuiTextVisualOffsetConst", CTestUiAifCoreToolkit::TestHuiTextVisualOffsetConst ),
        ENTRY( "TestHuiTextVisualTextExtents", CTestUiAifCoreToolkit::TestHuiTextVisualTextExtentsL ),
        ENTRY( "TestHuiTextVisualPrepareDrawL", CTestUiAifCoreToolkit::TestHuiTextVisualPrepareDrawL ),
        ENTRY( "TestHuiTextVisualSetColor", CTestUiAifCoreToolkit::TestHuiTextVisualSetColor ),
        ENTRY( "TestHuiTextVisualSetColorWithIndex", CTestUiAifCoreToolkit::TestHuiTextVisualSetColorWithIndex ),
        ENTRY( "TestHuiTextVisualSubstringExtents", CTestUiAifCoreToolkit::TestHuiTextVisualSubstringExtents ),
        ENTRY( "TestHuiTextVisualEnableShadow", CTestUiAifCoreToolkit::TestHuiTextVisualEnableShadow ),
        ENTRY( "TestHuiTextVisualSetHighlightRange", CTestUiAifCoreToolkit::TestHuiTextVisualSetHighlightRange ),
        
        // for test the huiviewportlayout.h
        ENTRY( "TestHuiViewPortLayoutAddNewL", CTestUiAifCoreToolkit::TestHuiViewPortLayoutAddNewL ),
        ENTRY( "TestHuiViewPortLayoutSetVirtualSize", CTestUiAifCoreToolkit::TestHuiViewPortLayoutSetVirtualSize ),
        ENTRY( "TestHuiViewPortLayoutSetViewportSize", CTestUiAifCoreToolkit::TestHuiViewPortLayoutSetViewportSize ),
        ENTRY( "TestHuiViewPortLayoutSetViewportPos", CTestUiAifCoreToolkit::TestHuiViewPortLayoutSetViewportPos ),
        
        // for test the huiimagevisual.h
        ENTRY( "TestHuiImageVisualAddNewL", CTestUiAifCoreToolkit::TestHuiImageVisualAddNewL ),
        ENTRY( "TestHuiImageVisualSetScaleMode", CTestUiAifCoreToolkit::TestHuiImageVisualSetScaleMode ),
        ENTRY( "TestHuiImageVisualSetImage", CTestUiAifCoreToolkit::TestHuiImageVisualSetImageL ),
        ENTRY( "TestHuiImageVisualSetSecondaryImage", CTestUiAifCoreToolkit::TestHuiImageVisualSetSecondaryImageL ),
        ENTRY( "TestHuiImageVisualImage", CTestUiAifCoreToolkit::TestHuiImageVisualImage ),
        ENTRY( "TestHuiImageVisualSecondaryImage", CTestUiAifCoreToolkit::TestHuiImageVisualSecondaryImage ),
        ENTRY( "TestHuiImageVisualSetColor", CTestUiAifCoreToolkit::TestHuiImageVisualSetColor ),
        ENTRY( "TestHuiImageVisualSetColorMode", CTestUiAifCoreToolkit::TestHuiImageVisualSetColorMode ),
        ENTRY( "TestHuiImageVisualSetStretch", CTestUiAifCoreToolkit::TestHuiImageVisualSetStretch ),
        ENTRY( "TestHuiImageVisualSetStretchMode", CTestUiAifCoreToolkit::TestHuiImageVisualSetStretchMode ),
        ENTRY( "TestHuiImageVisualSetDropShadow", CTestUiAifCoreToolkit::TestHuiImageVisualSetDropShadow ),
        ENTRY( "TestHuiImageVisualSetDropShadowWithHuiMetric", CTestUiAifCoreToolkit::TestHuiImageVisualSetDropShadowWithHuiMetric ),
        ENTRY( "TestHuiImageVisualSetDropShadowWithHuiXYMetric", CTestUiAifCoreToolkit::TestHuiImageVisualSetDropShadowWithHuiXYMetric ),
        
        // for test the huigridlayout.h
        ENTRY( "TestHuiGridLayoutAddNewL", CTestUiAifCoreToolkit::TestHuiGridLayoutAddNewL ),
        ENTRY( "TestHuiGridLayoutConstructor", CTestUiAifCoreToolkit::TestHuiGridLayoutConstructor ),
        ENTRY( "TestHuiGridLayoutConstructL", CTestUiAifCoreToolkit::TestHuiGridLayoutConstructL ),
        ENTRY( "TestHuiGridLayoutDelete", CTestUiAifCoreToolkit::TestHuiGridLayoutDelete ),
        ENTRY( "TestHuiGridLayoutSetSize", CTestUiAifCoreToolkit::TestHuiGridLayoutSetSize ),
        ENTRY( "TestHuiGridLayoutChildOrdinalL", CTestUiAifCoreToolkit::TestHuiGridLayoutChildOrdinalL ),
        ENTRY( "TestHuiGridLayoutChildPos", CTestUiAifCoreToolkit::TestHuiGridLayoutChildPos ),
        ENTRY( "TestHuiGridLayoutChildSize", CTestUiAifCoreToolkit::TestHuiGridLayoutChildSize ),
        ENTRY( "TestHuiGridLayoutChildRect", CTestUiAifCoreToolkit::TestHuiGridLayoutChildRect ),
        ENTRY( "TestHuiGridLayoutBaseUnit", CTestUiAifCoreToolkit::TestHuiGridLayoutBaseUnit ),
        ENTRY( "TestHuiGridLayoutRemoveAndDestroyAllD", CTestUiAifCoreToolkit::TestHuiGridLayoutRemoveAndDestroyAllD ),
        ENTRY( "TestHuiGridLayoutFindTagL", CTestUiAifCoreToolkit::TestHuiGridLayoutFindTagL ),
        ENTRY( "TestHuiGridLayoutCount", CTestUiAifCoreToolkit::TestHuiGridLayoutCount ),
        ENTRY( "TestHuiGridLayoutVisualL", CTestUiAifCoreToolkit::TestHuiGridLayoutVisualL ),
        ENTRY( "TestHuiGridLayoutSetPos", CTestUiAifCoreToolkit::TestHuiGridLayoutSetPos ),
        ENTRY( "TestHuiGridLayoutUpdateChildrenLayout", CTestUiAifCoreToolkit::TestHuiGridLayoutUpdateChildrenLayout ),
        ENTRY( "TestHuiGridLayoutPrepareDrawL", CTestUiAifCoreToolkit::TestHuiGridLayoutPrepareDrawL ),
        ENTRY( "TestHuiGridLayoutDraw", CTestUiAifCoreToolkit::TestHuiGridLayoutDrawL ),
        ENTRY( "TestHuiGridLayoutDrawSelf", CTestUiAifCoreToolkit::TestHuiGridLayoutDrawSelfL ),
        ENTRY( "TestHuiGridLayoutChanged", CTestUiAifCoreToolkit::TestHuiGridLayoutChanged ),
        ENTRY( "TestHuiGridLayoutReportChanged", CTestUiAifCoreToolkit::TestHuiGridLayoutReportChanged ),
        ENTRY( "TestHuiGridLayoutClearChanged", CTestUiAifCoreToolkit::TestHuiGridLayoutClearChanged ),
        ENTRY( "TestHuiGridLayoutNotifySkinChangedL", CTestUiAifCoreToolkit::TestHuiGridLayoutNotifySkinChangedL ),
        ENTRY( "TestHuiGridLayoutExpandRectWithContent", CTestUiAifCoreToolkit::TestHuiGridLayoutExpandRectWithContent ),
        ENTRY( "TestHuiGridLayoutVisualExtension", CTestUiAifCoreToolkit::TestHuiGridLayoutVisualExtension ),
        ENTRY( "TestHuiGridLayoutSetColumnsL", CTestUiAifCoreToolkit::TestHuiGridLayoutSetColumnsL ),
        ENTRY( "TestHuiGridLayoutSetRowsL", CTestUiAifCoreToolkit::TestHuiGridLayoutSetRowsL ),
        ENTRY( "TestHuiGridLayoutSetColumnsLWithArray", CTestUiAifCoreToolkit::TestHuiGridLayoutSetColumnsLWithArray ),
        ENTRY( "TestHuiGridLayoutSetRowsLWithArray", CTestUiAifCoreToolkit::TestHuiGridLayoutSetRowsLWithArray ),
        ENTRY( "TestHuiGridLayoutFillWeightsL", CTestUiAifCoreToolkit::TestHuiGridLayoutFillWeightsL ),
        ENTRY( "TestHuiGridLayoutAppendWeightL", CTestUiAifCoreToolkit::TestHuiGridLayoutAppendWeightL ),
        ENTRY( "TestHuiGridLayoutInsertWeightL", CTestUiAifCoreToolkit::TestHuiGridLayoutInsertWeightL ),
        ENTRY( "TestHuiGridLayoutReplaceWeightL", CTestUiAifCoreToolkit::TestHuiGridLayoutReplaceWeightL ),
        ENTRY( "TestHuiGridLayoutRemoveWeightL", CTestUiAifCoreToolkit::TestHuiGridLayoutRemoveWeightL ),
        ENTRY( "TestHuiGridLayoutWeight", CTestUiAifCoreToolkit::TestHuiGridLayoutWeight ),
        ENTRY( "TestHuiGridLayoutDimensionCount", CTestUiAifCoreToolkit::TestHuiGridLayoutDimensionCount ),
        ENTRY( "TestHuiGridLayoutSetExpanding", CTestUiAifCoreToolkit::TestHuiGridLayoutSetExpanding ),
        ENTRY( "TestHuiGridLayoutRowCount", CTestUiAifCoreToolkit::TestHuiGridLayoutRowCount ),
        ENTRY( "TestHuiGridLayoutColumnCount", CTestUiAifCoreToolkit::TestHuiGridLayoutColumnCount ),
        ENTRY( "TestHuiGridLayoutOrdinalToBlock", CTestUiAifCoreToolkit::TestHuiGridLayoutOrdinalToBlock ),
        ENTRY( "TestHuiGridLayoutSetLayoutModeFlags", CTestUiAifCoreToolkit::TestHuiGridLayoutSetLayoutModeFlags ),
        ENTRY( "TestHuiGridLayoutClearLayoutModeFlags", CTestUiAifCoreToolkit::TestHuiGridLayoutClearLayoutModeFlags ),
        ENTRY( "TestHuiGridLayoutLayoutModeFlags", CTestUiAifCoreToolkit::TestHuiGridLayoutLayoutModeFlags ),
        ENTRY( "TestHuiGridLayoutGetClassName", CTestUiAifCoreToolkit::TestHuiGridLayoutGetClassName ),
        ENTRY( "TestHuiGridLayoutDumpTree", CTestUiAifCoreToolkit::TestHuiGridLayoutDumpTree ),
        ENTRY( "TestHuiGridLayoutGetInstanceNameL", CTestUiAifCoreToolkit::TestHuiGridLayoutGetInstanceNameL ),
        ENTRY( "TestHuiGridLayoutType", CTestUiAifCoreToolkit::TestHuiGridLayoutType ),
        ENTRY( "TestHuiGridLayoutSessionId", CTestUiAifCoreToolkit::TestHuiGridLayoutSessionId ),
        ENTRY( "TestHuiGridLayoutSetSessionId", CTestUiAifCoreToolkit::TestHuiGridLayoutSetSessionId ),
        
        // for testing the huitexturemanager.h api
        ENTRY( "TestHuiTxureManagerEnvL", CTestUiAifCoreToolkit::TestHuiTxureManagerEnvL ),
        ENTRY( "TestHuiTxureManagerTextureL", CTestUiAifCoreToolkit::TestHuiTxureManagerTextureL ),
        ENTRY( "TestHuiTxureManagerTextureConstL", CTestUiAifCoreToolkit::TestHuiTxureManagerTextureConstL ),
        ENTRY( "TestHuiTxureManagerTextureLL", CTestUiAifCoreToolkit::TestHuiTxureManagerTextureLL ),
        ENTRY( "TestHuiTxureManagerSetImagePathL", CTestUiAifCoreToolkit::TestHuiTxureManagerSetImagePathL ),
        ENTRY( "TestHuiTxureManagerImagePath", CTestUiAifCoreToolkit::TestHuiTxureManagerImagePath ),
        ENTRY( "TestHuiTxureManagerBlankTextureConstL", CTestUiAifCoreToolkit::TestHuiTxureManagerBlankTextureConstL ),
        ENTRY( "TestHuiTxureManagerBlankTextureL", CTestUiAifCoreToolkit::TestHuiTxureManagerBlankTextureL ),
        ENTRY( "TestHuiTxureManagerLoadTextureL", CTestUiAifCoreToolkit::TestHuiTxureManagerLoadTextureL ),
        ENTRY( "TestHuiTxureManagerLoadTextureLWithIdL", CTestUiAifCoreToolkit::TestHuiTxureManagerLoadTextureLWithIdL ),
        ENTRY( "TestHuiTxureManagerLoadTextureLWithSizeImageL", CTestUiAifCoreToolkit::TestHuiTxureManagerLoadTextureLWithSizeImageL ),
        ENTRY( "TestHuiTxureManagerCreateTextureL", CTestUiAifCoreToolkit::TestHuiTxureManagerCreateTextureL ),
        ENTRY( "TestHuiTxureManagerUpdateTextureFromBitmapL", CTestUiAifCoreToolkit::TestHuiTxureManagerUpdateTextureFromBitmapL ),
        ENTRY( "TestHuiTxureManagerUnloadTexture", CTestUiAifCoreToolkit::TestHuiTxureManagerUnloadTexture ),
        ENTRY( "TestHuiTxureManagerUnloadTextureWithID", CTestUiAifCoreToolkit::TestHuiTxureManagerUnloadTextureWithID ),
        ENTRY( "TestHuiTxureManagerDefineFileNameL", CTestUiAifCoreToolkit::TestHuiTxureManagerDefineFileNameL ),
        ENTRY( "TestHuiTxureManagerLoadQueueCount", CTestUiAifCoreToolkit::TestHuiTxureManagerLoadQueueCount ),
        ENTRY( "TestHuiTxureManagerState", CTestUiAifCoreToolkit::TestHuiTxureManagerState ),
        ENTRY( "TestHuiTxureManagerProcessorL", CTestUiAifCoreToolkit::TestHuiTxureManagerProcessorL ),
        ENTRY( "TestHuiTxureManagerPrependImagePath", CTestUiAifCoreToolkit::TestHuiTxureManagerPrependImagePath ),
        ENTRY( "TestHuiTxureManagerSetTextureId", CTestUiAifCoreToolkit::TestHuiTxureManagerSetTextureId ),
        ENTRY( "TestHuiTxureManagerIsLoaded", CTestUiAifCoreToolkit::TestHuiTxureManagerIsLoaded ),
        ENTRY( "TestHuiTxureManagerIsLoadedWithID", CTestUiAifCoreToolkit::TestHuiTxureManagerIsLoadedWithID ),
        ENTRY( "TestHuiTxureManagerIsLoadedWithTexture", CTestUiAifCoreToolkit::TestHuiTxureManagerIsLoadedWithTexture ),
            
        // for testing the huiflowlayout.h
        ENTRY( "TestHuiFlowLayoutAddNewL", CTestUiAifCoreToolkit::TestHuiFlowLayoutAddNewL ),
        ENTRY( "TestHuiFlowLayoutDelete", CTestUiAifCoreToolkit::TestHuiFlowLayoutDelete ),
        ENTRY( "TestHuiFlowLayoutSetSize", CTestUiAifCoreToolkit::TestHuiFlowLayoutSetSize ),
        ENTRY( "TestHuiFlowLayoutSetFlowDirection", CTestUiAifCoreToolkit::TestHuiFlowLayoutSetFlowDirection ),
        ENTRY( "TestHuiFlowLayoutSetCentering", CTestUiAifCoreToolkit::TestHuiFlowLayoutSetCentering ),
        ENTRY( "TestHuiFlowLayoutSetMode", CTestUiAifCoreToolkit::TestHuiFlowLayoutSetMode ),
        ENTRY( "TestHuiFlowLayoutMode", CTestUiAifCoreToolkit::TestHuiFlowLayoutMode ),
        
        // for testing the huiimageloaderutils.h
        ENTRY( "TestHuiImageLoaderUtilConstructorL", CTestUiAifCoreToolkit::TestHuiImageLoaderUtilConstructorL ),
        ENTRY( "TestHuiImageLoaderUtilDelete", CTestUiAifCoreToolkit::TestHuiImageLoaderUtilDelete ),
        ENTRY( "TestHuiImageLoaderUtilCreateImageLoaderL", CTestUiAifCoreToolkit::TestHuiImageLoaderUtilCreateImageLoaderL ),
        ENTRY( "TestHuiImageLoaderUtilCreateImageLoaderLWithAppUidL", CTestUiAifCoreToolkit::TestHuiImageLoaderUtilCreateImageLoaderLWithAppUidL ),
        ENTRY( "TestHuiImageLoaderUtilSetSize", CTestUiAifCoreToolkit::TestHuiImageLoaderUtilSetSize ),
        ENTRY( "TestHuiImageLoaderUtilSetSkinInstance", CTestUiAifCoreToolkit::TestHuiImageLoaderUtilSetSkinInstance ),
        ENTRY( "TestHuiImageLoaderUtilImageLoaderExtension", CTestUiAifCoreToolkit::TestHuiImageLoaderUtilImageLoaderExtension ),
        
        // for testing the huitextureautoparams.h
        ENTRY( "TestHuiTexureAutoSizeParaConstructor", CTestUiAifCoreToolkit::TestHuiTexureAutoSizeParaConstructor ),
        ENTRY( "TestHuiTexureAutoSizeParaSizeLowerThreshold", CTestUiAifCoreToolkit::TestHuiTexureAutoSizeParaSizeLowerThreshold ),
        ENTRY( "TestHuiTexureAutoSizeParaSetSizeLowerThreshold", CTestUiAifCoreToolkit::TestHuiTexureAutoSizeParaSetSizeLowerThreshold ),
        ENTRY( "TestHuiTexureAutoSizeParaSizeUpperThreshold", CTestUiAifCoreToolkit::TestHuiTexureAutoSizeParaSizeUpperThreshold ),
        ENTRY( "TestHuiTexureAutoSizeParaSetSizeUpperThreshold", CTestUiAifCoreToolkit::TestHuiTexureAutoSizeParaSetSizeUpperThreshold ),
        ENTRY( "TestHuiTexureAutoSizeParaMinSizeChange", CTestUiAifCoreToolkit::TestHuiTexureAutoSizeParaMinSizeChange ),
        ENTRY( "TestHuiTexureAutoSizeParaSetMinSizeChange", CTestUiAifCoreToolkit::TestHuiTexureAutoSizeParaSetMinSizeChange ),
        ENTRY( "TestHuiTexureAutoSizeParaDownsizeSettleThreshold", CTestUiAifCoreToolkit::TestHuiTexureAutoSizeParaDownsizeSettleThreshold ),
        ENTRY( "TestHuiTexureAutoSizeParaSetDownsizeSettleThreshold", CTestUiAifCoreToolkit::TestHuiTexureAutoSizeParaSetDownsizeSettleThreshold ),
        
        //huitextstyle.h
        ENTRY( "TestTHuiTextTHuiTextStyle",
            CTestUiAifCoreToolkit::TestTHuiTextTHuiTextStyle ),
        ENTRY( "TestTHuiTextTFont",
            CTestUiAifCoreToolkit::TestTHuiTextTFont ),
        ENTRY( "TestTHuiTextTFontConst",
            CTestUiAifCoreToolkit::TestTHuiTextTFontConst ),
        ENTRY( "TestTHuiTextTSetFont",
            CTestUiAifCoreToolkit::TestTHuiTextTSetFont ),
        ENTRY( "TestTHuiTextTParentId",
            CTestUiAifCoreToolkit::TestTHuiTextTParentId ),
        ENTRY( "TestTHuiTextTSetParentId",
            CTestUiAifCoreToolkit::TestTHuiTextTSetParentId ),
        ENTRY( "TestTHuiTextTId",
            CTestUiAifCoreToolkit::TestTHuiTextTId ),
        ENTRY( "TestTHuiTextTTextColor",
            CTestUiAifCoreToolkit::TestTHuiTextTTextColor ),
        ENTRY( "TestTHuiTextTSetTextColor",
            CTestUiAifCoreToolkit::TestTHuiTextTSetTextColor ),
        ENTRY( "TestTHuiTextTBackgroundColor",
            CTestUiAifCoreToolkit::TestTHuiTextTBackgroundColor ),
        ENTRY( "TestTHuiTextTSetBackgroundColor",
            CTestUiAifCoreToolkit::TestTHuiTextTSetBackgroundColor ),
        ENTRY( "TestTHuiTextTTextSizeInTwips",
            CTestUiAifCoreToolkit::TestTHuiTextTTextSizeInTwips ),
        ENTRY( "TestTHuiTextTSetTextSizeInTwips",
            CTestUiAifCoreToolkit::TestTHuiTextTSetTextSizeInTwips ),
        ENTRY( "TestTHuiTextTextSizeInPixels",
            CTestUiAifCoreToolkit::TestTHuiTextTextSizeInPixels ),
        ENTRY( "TestTHuiTextTSetTextSizeInPixels",
            CTestUiAifCoreToolkit::TestTHuiTextTSetTextSizeInPixels ),
        ENTRY( "TestTHuiTextStrokeWeight",
            CTestUiAifCoreToolkit::TestTHuiTextStrokeWeight ),
        ENTRY( "TestTHuiTextTSetStrokeWeight",
            CTestUiAifCoreToolkit::TestTHuiTextTSetStrokeWeight ),
        ENTRY( "TestTHuiTextTPosture",
            CTestUiAifCoreToolkit::TestTHuiTextTPosture ),
        ENTRY( "TestTHuiTextTSetPosture",
            CTestUiAifCoreToolkit::TestTHuiTextTSetPosture ),
        ENTRY( "TestTHuiTextTUnderline",
            CTestUiAifCoreToolkit::TestTHuiTextTUnderline ),
        ENTRY( "TestTHuiTextTSetUnderline",
            CTestUiAifCoreToolkit::TestTHuiTextTSetUnderline ),
        ENTRY( "TestTHuiTextTStrikeThrough",
            CTestUiAifCoreToolkit::TestTHuiTextTStrikeThrough ),
        ENTRY( "TestTHuiTextTSetStrikeThrough",
            CTestUiAifCoreToolkit::TestTHuiTextTSetStrikeThrough ),
        ENTRY( "TestTHuiTextTFontStyleId",
            CTestUiAifCoreToolkit::TestTHuiTextTFontStyleId ),
        ENTRY( "TestTHuiTextGetTypeface",
            CTestUiAifCoreToolkit::TestTHuiTextGetTypeface ),
        ENTRY( "TestTHuiTextSetTextPaneHeightInPixels",
            CTestUiAifCoreToolkit::TestTHuiTextSetTextPaneHeightInPixels ),
            
        //huisegmentedtexture.h
        ENTRY( "TestHuisegmentedTextureHandleL",
            CTestUiAifCoreToolkit::TestHuisegmentedTextureHandleL ),
        ENTRY( "TestHuisegmentedTextureBindL",
            CTestUiAifCoreToolkit::TestHuisegmentedTextureBindL ),
            
        //huitextstylemanager.h
        ENTRY( "TestTHuiTextCHuiEnvL",
            CTestUiAifCoreToolkit::TestTHuiTextCHuiEnvL ),
        ENTRY( "TestTHuiTextTextStyle",
            CTestUiAifCoreToolkit::TestTHuiTextTextStyle ),
        ENTRY( "TestTHuiTextCopyTextStyleL",
            CTestUiAifCoreToolkit::TestTHuiTextCopyTextStyleL ),
        ENTRY( "TestTHuiTextDeleteTextStyle",
            CTestUiAifCoreToolkit::TestTHuiTextDeleteTextStyle ),
            
        //huitexture.h
        ENTRY( "TestTHuiTextNewL",CTestUiAifCoreToolkit::TestTHuiTextNewL ),
        ENTRY( "TestTHuiTextNewLC",CTestUiAifCoreToolkit::TestTHuiTextNewLC ),
        ENTRY( "TestTHuiTextImageFileNameL",
            CTestUiAifCoreToolkit::TestTHuiTextImageFileNameL ),
        ENTRY( "TestTHuiTextHasContentL",
            CTestUiAifCoreToolkit::TestTHuiTextHasContentL ),
        ENTRY( "TestTHuiTextHasAlphaL",
            CTestUiAifCoreToolkit::TestTHuiTextHasAlphaL ),
        ENTRY( "TestTHuiTextMaxTextureSizeL",
            CTestUiAifCoreToolkit::TestTHuiTextMaxTextureSizeL ),
        ENTRY( "TestTHuiTextClearLL",
            CTestUiAifCoreToolkit::TestTHuiTextClearLL ),
        ENTRY( "TestTHuiClearWithAlphaLL",
            CTestUiAifCoreToolkit::TestTHuiClearWithAlphaLL ),
        ENTRY( "TestTHuiSegmentedTextureL",
            CTestUiAifCoreToolkit::TestTHuiSegmentedTextureL ),
        ENTRY( "TestTHuiSegmentedTextureConstL",
            CTestUiAifCoreToolkit::TestTHuiSegmentedTextureConstL ),
        ENTRY( "TestTHuiShadowedTextureL",
            CTestUiAifCoreToolkit::TestTHuiShadowedTextureL ),
        ENTRY( "TestTHuiShadowedTextureConstL",
            CTestUiAifCoreToolkit::TestTHuiShadowedTextureConstL ),
        ENTRY( "TestTHuiEnableShadowL",
            CTestUiAifCoreToolkit::TestTHuiEnableShadowL ),
        ENTRY( "TestTHuiIsShadowEnabledL",
            CTestUiAifCoreToolkit::TestTHuiIsShadowEnabledL ),
        ENTRY( "TestTHuiSetShadowStyleL",
            CTestUiAifCoreToolkit::TestTHuiSetShadowStyleL ),
        ENTRY( "TestTHuiShadowStyleL",
            CTestUiAifCoreToolkit::TestTHuiShadowStyleL ),
        ENTRY( "TestTHuiSetSizeL",
            CTestUiAifCoreToolkit::TestTHuiSetSizeL ),
        ENTRY( "TestTHuiSizeL",CTestUiAifCoreToolkit::TestTHuiSizeL ),
        ENTRY( "TestTHuiSegmentCountL",
            CTestUiAifCoreToolkit::TestTHuiSegmentCountL ),
        ENTRY( "TestTHuiSegmentNameL",
            CTestUiAifCoreToolkit::TestTHuiSegmentNameL ),
        ENTRY( "TestTHuiSegmentSizeL",
            CTestUiAifCoreToolkit::TestTHuiSegmentSizeL ),
        ENTRY( "TestTHuiSegmentTextureSizeL",
            CTestUiAifCoreToolkit::TestTHuiSegmentTextureSizeL ),
        ENTRY( "TestTHuiSegmentOffsetL",
            CTestUiAifCoreToolkit::TestTHuiSegmentOffsetL ),
        ENTRY( "TestTHuiTextureChangedL",
            CTestUiAifCoreToolkit::TestTHuiTextureChangedL ),
        ENTRY( "TestTHuiTextureClearChangedL",
            CTestUiAifCoreToolkit::TestTHuiTextureClearChangedL ),
        ENTRY( "TestTHuiSetSegmentOffsetL",
            CTestUiAifCoreToolkit::TestTHuiSetSegmentOffsetL ),
        ENTRY( "TestTHuiSetSegmentCountL",
            CTestUiAifCoreToolkit::TestTHuiSetSegmentCountL ),
        ENTRY( "TestTHuiSetSegmentNameL",
            CTestUiAifCoreToolkit::TestTHuiSetSegmentNameL ),
        ENTRY( "TestTHuiSetSegmentSizeL",
            CTestUiAifCoreToolkit::TestTHuiSetSegmentSizeL ),
        ENTRY( "TestTHuiSetSegmentTextureSizeL",
            CTestUiAifCoreToolkit::TestTHuiSetSegmentTextureSizeL ),
        ENTRY( "TestTHuiSetSkinContentL",
            CTestUiAifCoreToolkit::TestTHuiSetSkinContentL ),
        ENTRY( "TestTHuiIsSkinContentL",
            CTestUiAifCoreToolkit::TestTHuiIsSkinContentL ),
        ENTRY( "TestTHuiTypeL",CTestUiAifCoreToolkit::TestTHuiTypeL ),
        ENTRY( "TestTHuiSessionIdL",CTestUiAifCoreToolkit::TestTHuiSessionIdL ),
        ENTRY( "TestTHuiSetSessionIdL",
            CTestUiAifCoreToolkit::TestTHuiSetSessionIdL ),
        ENTRY( "TestTHuiSetPriorityL",
            CTestUiAifCoreToolkit::TestTHuiSetPriorityL ),
        ENTRY( "TestTHuiPriorityL",CTestUiAifCoreToolkit::TestTHuiPriorityL ),
        ENTRY( "TestTHuiEnableAutoSizeCalculationL",
            CTestUiAifCoreToolkit::TestTHuiEnableAutoSizeCalculationL ),
        ENTRY( "TestTHuiSetAutoSizeParamsL",
            CTestUiAifCoreToolkit::TestTHuiSetAutoSizeParamsL ),
        ENTRY( "TestTHuiAutoSizeParamsL",
            CTestUiAifCoreToolkit::TestTHuiAutoSizeParamsL ),
            
        //huidisplay.h
        ENTRY( "TestTHuiEnvL", CTestUiAifCoreToolkit::TestTHuiEnvL ),
        ENTRY( "TestTDisplayActivateL", 
            CTestUiAifCoreToolkit::TestTDisplayActivateL ),
        ENTRY( "TestTDisplayActiveL", 
            CTestUiAifCoreToolkit::TestTDisplayActiveL ),
        ENTRY( "TestTDisplaySetSizeLL", 
            CTestUiAifCoreToolkit::TestTDisplaySetSizeLL ),
        ENTRY( "TestTDisplaySizeL", 
            CTestUiAifCoreToolkit::TestTDisplaySizeL ),
        ENTRY( "TestTDisplaySetVisibleAreaL", 
            CTestUiAifCoreToolkit::TestTDisplaySetVisibleAreaL ),
        ENTRY( "TestTDisplayVisibleAreaL", 
            CTestUiAifCoreToolkit::TestTDisplayVisibleAreaL ),
        ENTRY( "TestTDisplaySetOrientationL", 
            CTestUiAifCoreToolkit::TestTDisplaySetOrientationL ),
        ENTRY( "TestTDisplayOrientationL", 
            CTestUiAifCoreToolkit::TestTDisplayOrientationL ),
        ENTRY( "TestTDisplaySetUseDepthL", 
            CTestUiAifCoreToolkit::TestTDisplaySetUseDepthL ),
        ENTRY( "TestTDisplaySetClearBackgroundLL", 
            CTestUiAifCoreToolkit::TestTDisplaySetClearBackgroundLL ),
        ENTRY( "TestTDisplaySetBackgroundColorL", 
            CTestUiAifCoreToolkit::TestTDisplaySetBackgroundColorL ),
        ENTRY( "TestTDisplaySetBackgroundItemsL", 
            CTestUiAifCoreToolkit::TestTDisplaySetBackgroundItemsL ),
        ENTRY( "TestTDisplayCaptureLCL", 
            CTestUiAifCoreToolkit::TestTDisplayCaptureLCL ),
        ENTRY( "TestTDisplayTransformationL", 
            CTestUiAifCoreToolkit::TestTDisplayTransformationL ),
        ENTRY( "TestTDisplayRosterL", 
            CTestUiAifCoreToolkit::TestTDisplayRosterL ),
        ENTRY( "TestTDisplayConstRosterL", 
            CTestUiAifCoreToolkit::TestTDisplayConstRosterL ),
        ENTRY( "TestTDisplayShowL", 
            CTestUiAifCoreToolkit::TestTDisplayShowL ),
        ENTRY( "TestTDisplaySetDirtyL", 
            CTestUiAifCoreToolkit::TestTDisplaySetDirtyL ),
        ENTRY( "TestTDisplaySetQualityL", 
            CTestUiAifCoreToolkit::TestTDisplaySetQualityL ),
        ENTRY( "TestTDisplayQualityL", 
            CTestUiAifCoreToolkit::TestTDisplayQualityL ),
        ENTRY( "TestTDisplaySetUsageLL", 
            CTestUiAifCoreToolkit::TestTDisplaySetUsageLL ),
        ENTRY( "TestTDisplayReleaseL", 
            CTestUiAifCoreToolkit::TestTDisplayReleaseL ),
        ENTRY( "TestTDisplayRestoreLL", 
            CTestUiAifCoreToolkit::TestTDisplayRestoreLL ),
        ENTRY( "TestTDisplaySetScreenBufferLockL", 
            CTestUiAifCoreToolkit::TestTDisplaySetScreenBufferLockL ),
        ENTRY( "TestTDisplayIsScreenBufferLockedL", 
            CTestUiAifCoreToolkit::TestTDisplayIsScreenBufferLockedL ),
        ENTRY( "TestTDisplayGetDrawingInterfaceL", 
            CTestUiAifCoreToolkit::TestTDisplayGetDrawingInterfaceL ),
        ENTRY( "TestTDisplayGetGraphicsContextL", 
            CTestUiAifCoreToolkit::TestTDisplayGetGraphicsContextL ),
        ENTRY( "TestTDisplayAddScreenBufferObserverLL", 
            CTestUiAifCoreToolkit::TestTDisplayAddScreenBufferObserverLL ),
        ENTRY( "TestTDisplayRemoveScreenBufferObserverL", 
            CTestUiAifCoreToolkit::TestTDisplayRemoveScreenBufferObserverL ),
        ENTRY( "TestTDisplayScreenBufferObserverL", 
            CTestUiAifCoreToolkit::TestTDisplayScreenBufferObserverL ),
        ENTRY( "TestTDisplayScreenBufferUidL", 
            CTestUiAifCoreToolkit::TestTDisplayScreenBufferUidL ),
        ENTRY( "TestTDisplayDisplayTypeL", 
            CTestUiAifCoreToolkit::TestTDisplayDisplayTypeL ),
        ENTRY( "TestTDisplayShowDirtyRegionsL", 
            CTestUiAifCoreToolkit::TestTDisplayShowDirtyRegionsL ),
        ENTRY( "TestTDisplayGetPreferredTextureFormatsL", 
            CTestUiAifCoreToolkit::TestTDisplayGetPreferredTextureFormatsL ),
        ENTRY( "TestTDisplaySetDrawVisualOutlineL", 
            CTestUiAifCoreToolkit::TestTDisplaySetDrawVisualOutlineL ),
        ENTRY( "TestTDisplaySetVisibleAreaClippingRectL", 
            CTestUiAifCoreToolkit::TestTDisplaySetVisibleAreaClippingRectL ),
            
        //huidisplaybackgrounditem.h
        ENTRY( "TestTTHuiDisplayBackgroundItemL", 
            CTestUiAifCoreToolkit::TestTTHuiDisplayBackgroundItemL ),
        ENTRY( "TestTTHuiDisplayBackgroundItemRectL", 
            CTestUiAifCoreToolkit::TestTTHuiDisplayBackgroundItemRectL ),
        ENTRY( "TestTTHuiDisplayBackgroundItemItemIDL", 
            CTestUiAifCoreToolkit::TestTTHuiDisplayBackgroundItemItemIDL ),
        ENTRY( "TestTTHuiDisplayBackgroundColorL", 
            CTestUiAifCoreToolkit::TestTTHuiDisplayBackgroundColorL ),
        ENTRY( "TestTTHuiDisplayBackgroundTRgbL", 
            CTestUiAifCoreToolkit::TestTTHuiDisplayBackgroundTRgbL ),
        ENTRY( "TestTTHuiTestTSetRectLL", 
            CTestUiAifCoreToolkit::TestTTHuiTestTSetRectLL ),
        ENTRY( "TestTTHuiSetColorL", 
            CTestUiAifCoreToolkit::TestTTHuiSetColorL ),
        ENTRY( "TestTTHuiSetColorItemL", 
            CTestUiAifCoreToolkit::TestTTHuiSetColorItemL ),
        ENTRY( "TestTTHuiSetSkinBackgroundL", 
            CTestUiAifCoreToolkit::TestTTHuiSetSkinBackgroundL ),
            
        //HuiDisplayCoeControl.h
        ENTRY( "TestTTHuiCCNewLL", CTestUiAifCoreToolkit::TestTTHuiCCNewLL ),
        ENTRY( "TestTTHuiCCNewLCL", CTestUiAifCoreToolkit::TestTTHuiCCNewLCL ),
        ENTRY( "TestTTHuiCCEnvL", CTestUiAifCoreToolkit::TestTTHuiCCEnvL ),
        ENTRY( "TestTTHuiCCDisplayL", CTestUiAifCoreToolkit::TestTTHuiCCDisplayL ),
        ENTRY( "TestTTHuiCCHandlePointerEventL",
            CTestUiAifCoreToolkit::TestTTHuiCCHandlePointerEventL ),
        ENTRY( "TestTTHuiCCDisplayCoeCntrlExtensionL",
            CTestUiAifCoreToolkit::TestTTHuiCCDisplayCoeCntrlExtensionL ),
        
        //huienv.h
        ENTRY( "TestTTHuiCEnvHuiEnvLC",
            CTestUiAifCoreToolkit::TestTTHuiCEnvHuiEnvLC ),
        ENTRY( "TestTTHuiCEnvRenderer",
            CTestUiAifCoreToolkit::TestTTHuiCEnvRenderer ),
        ENTRY( "TestTTHuiCEnvNewDisplayL",
            CTestUiAifCoreToolkit::TestTTHuiCEnvNewDisplayL ),
        ENTRY( "TestTTHuiCEnvNewDisplayLL",
            CTestUiAifCoreToolkit::TestTTHuiCEnvNewDisplayLL ),
        ENTRY( "TestTTHuiCEnvDisplayCount",
            CTestUiAifCoreToolkit::TestTTHuiCEnvDisplayCount ),
        ENTRY( "TestTTHuiCEnvSetRefreshMode",
            CTestUiAifCoreToolkit::TestTTHuiCEnvSetRefreshMode ),
        ENTRY( "TestTTHuiCEnvRefreshMode",
            CTestUiAifCoreToolkit::TestTTHuiCEnvRefreshMode ),
        ENTRY( "TestTTHuiCEnvSetMaxFrameRate",
            CTestUiAifCoreToolkit::TestTTHuiCEnvSetMaxFrameRate ),
        ENTRY( "TestTTHuiCEnvContinueRefresh",
            CTestUiAifCoreToolkit::TestTTHuiCEnvContinueRefresh ),
        ENTRY( "TestTTHuiCEnvPauseRefresh",
            CTestUiAifCoreToolkit::TestTTHuiCEnvPauseRefresh ),
        ENTRY( "TestTTHuiCEnvNewControlGroupL",
            CTestUiAifCoreToolkit::TestTTHuiCEnvNewControlGroupL ),
        ENTRY( "TestTTHuiCEnvDeleteControlGroup",
            CTestUiAifCoreToolkit::TestTTHuiCEnvDeleteControlGroup ),
        ENTRY( "TestTTHuiCEnvLoadControlGroupL",
            CTestUiAifCoreToolkit::TestTTHuiCEnvLoadControlGroupL ),
        ENTRY( "TestTTHuiCEnvControlGroup",
            CTestUiAifCoreToolkit::TestTTHuiCEnvControlGroup ),
        ENTRY( "TestTTHuiCEnvLoadBitmapsL",
            CTestUiAifCoreToolkit::TestTTHuiCEnvLoadBitmapsL ),
        ENTRY( "TestTTHuiCVisualFactory",
            CTestUiAifCoreToolkit::TestTTHuiCVisualFactory ),
        ENTRY( "TestTTHuiCTextureManager",
            CTestUiAifCoreToolkit::TestTTHuiCTextureManager ),
        ENTRY( "TestTTHuiCFontManager",
            CTestUiAifCoreToolkit::TestTTHuiCFontManager ),
        ENTRY( "TestTTHuiCTextStyleManager",
            CTestUiAifCoreToolkit::TestTTHuiCTextStyleManager ),
        ENTRY( "TestTTHuiCFindControl",
            CTestUiAifCoreToolkit::TestTTHuiCFindControl ),
        ENTRY( "TestTTHuiCSendL", CTestUiAifCoreToolkit::TestTTHuiCSendL ),
        ENTRY( "TestTTHuiCSendLL", CTestUiAifCoreToolkit::TestTTHuiCSendLL ),
        ENTRY( "TestTTHuiCCancelCommandsL",
            CTestUiAifCoreToolkit::TestTTHuiCCancelCommandsL ),
        ENTRY( "TestTTHuiCCancelCommandsEventHandlerL",
            CTestUiAifCoreToolkit::TestTTHuiCCancelCommandsEventHandlerL ),
        ENTRY( "TestTTHuiCCancelCommandsTHuiOpL",
            CTestUiAifCoreToolkit::TestTTHuiCCancelCommandsTHuiOpL ),
        ENTRY( "TestTTHuiCCancelCommandsTIntL",
            CTestUiAifCoreToolkit::TestTTHuiCCancelCommandsTIntL ),
        ENTRY( "TestTTHuiCTimeUntilCommandL",
            CTestUiAifCoreToolkit::TestTTHuiCTimeUntilCommandL ),
        ENTRY( "TestTTHuiCSkin",
            CTestUiAifCoreToolkit::TestTTHuiCSkin ),
        ENTRY( "TestTStartRefresh",
            CTestUiAifCoreToolkit::TestTStartRefresh ),
        ENTRY( "TestTHandleKeyEventLL",
            CTestUiAifCoreToolkit::TestTHandleKeyEventLL ),
        ENTRY( "TestTSetIdleThreshold", 
            CTestUiAifCoreToolkit::TestTSetIdleThreshold ),
        ENTRY( "TestTBroadcastEventLL", 
            CTestUiAifCoreToolkit::TestTBroadcastEventLL ),
        ENTRY( "TestTPrimaryDisplayL", 
            CTestUiAifCoreToolkit::TestTPrimaryDisplayL ),
        ENTRY( "TestTCHuiEnvDisplayL", 
            CTestUiAifCoreToolkit::TestTCHuiEnvDisplayL ),
        ENTRY( "TestTCNotifySkinChangedLL", 
            CTestUiAifCoreToolkit::TestTCNotifySkinChangedLL ),
        ENTRY( "TestTCRefreshCallBack", 
            CTestUiAifCoreToolkit::TestTCRefreshCallBack ),
        ENTRY( "TestTCRelease", CTestUiAifCoreToolkit::TestTCRelease ),
        ENTRY( "TestTCRestoreL", CTestUiAifCoreToolkit::TestTCRestoreL ),
        ENTRY( "TestTCSetMaxCpuTime", 
            CTestUiAifCoreToolkit::TestTCSetMaxCpuTime ),
        ENTRY( "TestTCStatic", CTestUiAifCoreToolkit::TestTCStatic ),
        ENTRY( "TestTCThemeManager", CTestUiAifCoreToolkit::TestTCThemeManager ),
        ENTRY( "TestTCSetFPSCounterThreshold", 
            CTestUiAifCoreToolkit::TestTCSetFPSCounterThreshold ),
        ENTRY( "TestTCChangeRefreshLoopPriority", 
            CTestUiAifCoreToolkit::TestTCChangeRefreshLoopPriority ),
        
        //huievent.h
        ENTRY( "TestTHETHuiEventL", CTestUiAifCoreToolkit::TestTHETHuiEventL ),
        ENTRY( "TestTHETPointerEventL",
            CTestUiAifCoreToolkit::TestTHETPointerEventL ),
        ENTRY( "TestTHETypeL", CTestUiAifCoreToolkit::TestTHETypeL ),
        ENTRY( "TestTHEIsCustomEventL",
            CTestUiAifCoreToolkit::TestTHEIsCustomEventL ),
        ENTRY( "TestTHEIsKeyEventL",CTestUiAifCoreToolkit::TestTHEIsKeyEventL ),
        ENTRY( "TestTHEIsPointerEventL",
            CTestUiAifCoreToolkit::TestTHEIsPointerEventL ),
        ENTRY( "TestTHEDisplayL",CTestUiAifCoreToolkit::TestTHEDisplayL ),
        ENTRY( "TestTHEPointerDownL",CTestUiAifCoreToolkit::TestTHEPointerDownL ),
        ENTRY( "TestTHEPointerUpL",CTestUiAifCoreToolkit::TestTHEPointerUpL ),
        ENTRY( "TestTHEPointerLongTapL",
            CTestUiAifCoreToolkit::TestTHEPointerLongTapL ),
        ENTRY( "TestTHESetVisualL",
            CTestUiAifCoreToolkit::TestTHESetVisualL ),
        ENTRY( "TestTHEVisualL",CTestUiAifCoreToolkit::TestTHEVisualL ),
            
        //huidropshadow.h
        ENTRY( "TestTHSetOffsetL",CTestUiAifCoreToolkit::TestTHSetOffsetL ),
        ENTRY( "TestTHSetColorL",CTestUiAifCoreToolkit::TestTHSetColorL ),
        ENTRY( "TestTHSetColorTAknsItemIDL",
            CTestUiAifCoreToolkit::TestTHSetColorTAknsItemIDL ),
            
        //huidropshadowbrush.h
        ENTRY( "TestShadowBrushNewLL",
            CTestUiAifCoreToolkit::TestShadowBrushNewLL ),
        ENTRY( "TestShadowBrushNewLCL",
            CTestUiAifCoreToolkit::TestShadowBrushNewLCL ),
        ENTRY( "TestShadowBrushNewLTIntL",
            CTestUiAifCoreToolkit::TestShadowBrushNewLTIntL ),
        ENTRY( "TestShadowBrushNewLTIntLCL",
            CTestUiAifCoreToolkit::TestShadowBrushNewLTIntLCL ),
        ENTRY( "TestShadowBrushSetDepthL",
            CTestUiAifCoreToolkit::TestShadowBrushSetDepthL ),
        ENTRY( "TestShadowSetSoftnessL",
            CTestUiAifCoreToolkit::TestShadowSetSoftnessL ),
        ENTRY( "TestShadowSetColorL",
            CTestUiAifCoreToolkit::TestShadowSetColorL ),
            
        //huiskin.h
        ENTRY( "TestHSkinOrientationL",
            CTestUiAifCoreToolkit::TestHSkinOrientationL ),
        ENTRY( "TestHSkinLocationL",
            CTestUiAifCoreToolkit::TestHSkinLocationL ),
        ENTRY( "TestHSkinNotifyDisplaySizeChangedL",
            CTestUiAifCoreToolkit::TestHSkinNotifyDisplaySizeChangedL ),
        ENTRY( "TestHSkinSetContextL",
            CTestUiAifCoreToolkit::TestHSkinSetContextL ),
        ENTRY( "TestHSkinContextL",
            CTestUiAifCoreToolkit::TestHSkinContextL ),
        ENTRY( "TestHSkinStyleTextColorL",
            CTestUiAifCoreToolkit::TestHSkinStyleTextColorL ),
        ENTRY( "TestHSkinTextureL",
            CTestUiAifCoreToolkit::TestHSkinTextureL ),
        ENTRY( "TestHSkinReleaseTextureL",
            CTestUiAifCoreToolkit::TestHSkinReleaseTextureL ),
        ENTRY( "TestHSkinGetTextureL",
            CTestUiAifCoreToolkit::TestHSkinGetTextureL ),
        ENTRY( "TestHSkinTextureContentUploadedL",
            CTestUiAifCoreToolkit::TestHSkinTextureContentUploadedL ),
        ENTRY( "TestHSkinTextureContentReleasedL",
            CTestUiAifCoreToolkit::TestHSkinTextureContentReleasedL ),
        ENTRY( "TestHSkinRestoreTextureContentLL",
            CTestUiAifCoreToolkit::TestHSkinRestoreTextureContentLL ),
            
        //huis60skin.h
        ENTRY( "TestH60SkinCHuiS60SkinL",
            CTestUiAifCoreToolkit::TestH60SkinCHuiS60SkinL ),
        ENTRY( "TestH60SkinConstructLL",
            CTestUiAifCoreToolkit::TestH60SkinConstructLL ),
        ENTRY( "TestH60SkinLocationL",
            CTestUiAifCoreToolkit::TestH60SkinLocationL ),
        ENTRY( "TestH60SkinTextureLL",
            CTestUiAifCoreToolkit::TestH60SkinTextureLL ),
        ENTRY( "TestH60SkinReleaseTextureL",
            CTestUiAifCoreToolkit::TestH60SkinReleaseTextureL ),
        ENTRY( "TestH60SkinNotifyDisplaySizeChangedLL",
            CTestUiAifCoreToolkit::TestH60SkinNotifyDisplaySizeChangedLL ),
        ENTRY( "TestH60SkinStyleTextColorL",
            CTestUiAifCoreToolkit::TestH60SkinStyleTextColorL ),
        ENTRY( "TestH60SkinRestoreTextureContentLL",
            CTestUiAifCoreToolkit::TestH60SkinRestoreTextureContentLL ),
        ENTRY( "TestH60SkinOrientationL",
            CTestUiAifCoreToolkit::TestH60SkinOrientationL ),
        ENTRY( "TestH60SkinSetContextL",
            CTestUiAifCoreToolkit::TestH60SkinSetContextL ),
        ENTRY( "TestH60SkinContextL",
            CTestUiAifCoreToolkit::TestH60SkinContextL ),
        ENTRY( "TestH60SkinGetTextureL",
            CTestUiAifCoreToolkit::TestH60SkinGetTextureL ),
        ENTRY( "TestH60SkinSkinExtensionL",
            CTestUiAifCoreToolkit::TestH60SkinSkinExtensionL ),
            
        //huishadowborderbrush.h
        ENTRY( "TestH60BordBrushNewLL",
            CTestUiAifCoreToolkit::TestH60BordBrushNewLL ),
        ENTRY( "TestH60BordBrushNewLCL",
            CTestUiAifCoreToolkit::TestH60BordBrushNewLCL ),
        ENTRY( "TestH60BordBrushNewLTIntL",
            CTestUiAifCoreToolkit::TestH60BordBrushNewLTIntL ),
        ENTRY( "TestH60BordBrushNewLCTIntL",
            CTestUiAifCoreToolkit::TestH60BordBrushNewLCTIntL ),
        ENTRY( "TestH60BordBrushSetWidthL",
            CTestUiAifCoreToolkit::TestH60BordBrushSetWidthL ),
        };

    const TInt count = sizeof( KFunctions ) / sizeof( TStifFunctionInfo );

    return RunInternalL( KFunctions, count, aItem );

    }

// -----------------------------------------------------------------------------
// CTestUiAifCoreToolkit::TestTHFMEnumerateFontsL
// -----------------------------------------------------------------------------
//
TInt CTestUiAifCoreToolkit::TestTHFMEnumerateFontsL( CStifItemParser& /*aItem*/ )
    {

    // Print to UI
    _LIT( KTestuiaifcoretoolkit, "testuiaifcoretoolkit" );
    _LIT( KCHuiProceduralMesh, "In TestTHFMEnumerateFontsL" );
    TestModuleIf().Printf( 0, KTestuiaifcoretoolkit, KCHuiProceduralMesh );
    // Print to log file
    iLog->Log( KCHuiProceduralMesh );

    RArray<THuiFontSpecification> supportedFonts;
    iHuiEnv->FontManager().EnumerateFontsL( supportedFonts );
    supportedFonts.Close();

    return KErrNone;
    }

// -----------------------------------------------------------------------------
// CTestUiAifCoreToolkit::TestTHIIConstructorL
// -----------------------------------------------------------------------------
//
TInt CTestUiAifCoreToolkit::TestTHIIConstructorL( CStifItemParser& /*aItem*/ )
    {

    // Print to UI
    _LIT( KTestuiaifcoretoolkit, "testuiaifcoretoolkit" );
    _LIT( KCHuiProceduralMesh, "In TestTHIIConstructorL" );
    TestModuleIf().Printf( 0, KTestuiaifcoretoolkit, KCHuiProceduralMesh );
    // Print to log file
    iLog->Log( KCHuiProceduralMesh );

    THuiInteractionInterval* interval = new( ELeave ) THuiInteractionInterval;
    CleanupStack::PushL( interval );
    STIF_ASSERT_NOT_NULL( interval );
    CleanupStack::PopAndDestroy( interval );

    return KErrNone;
    }

// -----------------------------------------------------------------------------
// CTestUiAifCoreToolkit::TestTHIISetScalarL
// -----------------------------------------------------------------------------
//
TInt CTestUiAifCoreToolkit::TestTHIISetScalarL( CStifItemParser& /*aItem*/ )
    {

    // Print to UI
    _LIT( KTestuiaifcoretoolkit, "testuiaifcoretoolkit" );
    _LIT( KCHuiProceduralMesh, "In TestTHIISetScalarL" );
    TestModuleIf().Printf( 0, KTestuiaifcoretoolkit, KCHuiProceduralMesh );
    // Print to log file
    iLog->Log( KCHuiProceduralMesh );

    THuiInteractionInterval* interval = new( ELeave ) THuiInteractionInterval;
    CleanupStack::PushL( interval );
    STIF_ASSERT_NOT_NULL( interval );
    interval->SetScalar( 1 );
    CleanupStack::PopAndDestroy( interval );

    return KErrNone;
    }

// -----------------------------------------------------------------------------
// CTestUiAifCoreToolkit::TestTHIIScalarL
// -----------------------------------------------------------------------------
//
TInt CTestUiAifCoreToolkit::TestTHIIScalarL( CStifItemParser& /*aItem*/ )
    {

    // Print to UI
    _LIT( KTestuiaifcoretoolkit, "testuiaifcoretoolkit" );
    _LIT( KCHuiProceduralMesh, "In TestTHIIScalarL" );
    TestModuleIf().Printf( 0, KTestuiaifcoretoolkit, KCHuiProceduralMesh );
    // Print to log file
    iLog->Log( KCHuiProceduralMesh );

    THuiInteractionInterval* interval = new( ELeave ) THuiInteractionInterval;
    CleanupStack::PushL( interval );
    STIF_ASSERT_NOT_NULL( interval );
    interval->SetScalar( 1 );
    TInt saclar = interval->Scalar();
    STIF_ASSERT_EQUALS( saclar, 1 );
    CleanupStack::PopAndDestroy( interval );

    return KErrNone;
    }

// -----------------------------------------------------------------------------
// CTestUiAifCoreToolkit::TestTHIIIntervalL
// -----------------------------------------------------------------------------
//
TInt CTestUiAifCoreToolkit::TestTHIIIntervalL( CStifItemParser& /*aItem*/ )
    {

    // Print to UI
    _LIT( KTestuiaifcoretoolkit, "testuiaifcoretoolkit" );
    _LIT( KCHuiProceduralMesh, "In TestTHIIIntervalL" );
    TestModuleIf().Printf( 0, KTestuiaifcoretoolkit, KCHuiProceduralMesh );
    // Print to log file
    iLog->Log( KCHuiProceduralMesh );

    THuiInteractionInterval* interval = new( ELeave ) THuiInteractionInterval;
    CleanupStack::PushL( interval );
    STIF_ASSERT_NOT_NULL( interval );
    interval->Interval( 0 );
    CleanupStack::PopAndDestroy( interval );

    return KErrNone;
    }

//  [End of File]
