/*
* Copyright (c) 2002-2004 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/



// This header file contains the customisation implementation identity for Adaptation_Layer_AppLayout_Elaf
// It was generated by hand, not by layout compiler.
// This file may be manually modified.
// This customisation implements the interface defined in AppLayout.cdl

// ___Instructions___
// 1. use Adaptation_Layer_AknLayout_Elaf as an example
// 2. fill in the implementations for the global methods (see section "Adaptation Layer Implementation" below")
// 3. do not modify KDataLookup
// 4. then remove the "NULL, //" from the lines in KCdlImpl at the BOTTOM of this file
//
// Notes:
// - if there is NULL in the bottom table, then the implementation in other CDL instance will be used (the ones generated from LAY files)
// - ensure that the instances are in the packs in the correct order in packages.mk (with adaptation layer after LAY file instances)


#include "adaptation_layer_applayout_elaf.h"
#include "AknLayout2AdaptationDecode.h"
#include "aknlayoutscalable_avkon.cdl.h"
#include "aknlayoutscalable_apps.cdl.h"
#include "layoutmetadata.cdl.h"

//
// panic
//

enum TAdaptation_Layer_AppLayout_Elaf_Panic
	{
	EParamsOutsideKnownRange,
    ELayoutLineMissing, 
    ECompositionStrategyFailed,
    };

void Panic(TAdaptation_Layer_AppLayout_Elaf_Panic aCode)
	{
	_LIT(KLayoutPanic, "Layout: App Elaf Adaptation Layer panic");
	User::Panic(KLayoutPanic, aCode);
	}


namespace Adaptation_Layer_AppLayout_Elaf
{


extern const TUint KDataLookup[AppLayout::E_TApiId_TableSize];

//
// Macros
// 

#define ASSERT_ALWAYS_WITHIN_LIMITS( valToCheck, limitsApi )    \
    TAknLayoutScalableTableLimits macroLineLimits = limitsApi; \
    __ASSERT_ALWAYS( macroLineLimits.FirstIndex() <= valToCheck && valToCheck <= macroLineLimits.LastIndex(), \
        Panic(EParamsOutsideKnownRange) );

//
// Helper Methods
//

TAknLayoutTableLimits Limits() { return AknLayoutAdaptationDecode::TableLimits(KDataLookup); }

TAknWindowLineLayout WindowLine0f() { return AknLayoutAdaptationDecode::WindowLine0f(KDataLookup); }
TAknWindowLineLayout WindowLine1f(TInt aParam0) { return AknLayoutAdaptationDecode::WindowLine1f(KDataLookup, aParam0); }
TAknWindowLineLayout WindowLine2f(TInt aParam0,TInt aParam1) { return AknLayoutAdaptationDecode::WindowLine2f(KDataLookup, aParam0, aParam1); }
TAknWindowLineLayout WindowLine3f(TInt aParam0,TInt aParam1,TInt aParam2) { return AknLayoutAdaptationDecode::WindowLine3f(KDataLookup, aParam0, aParam1, aParam2); }
TAknWindowLineLayout WindowLine0t(const TRect& aParentRect) { return AknLayoutAdaptationDecode::WindowLine0t(KDataLookup, aParentRect); }
TAknWindowLineLayout WindowLine1t(const TRect& aParentRect,TInt aParam0) { return AknLayoutAdaptationDecode::WindowLine1t(KDataLookup, aParentRect, aParam0); }

TAknTextLineLayout TextLine0f() { return AknLayoutAdaptationDecode::TextLine0f(KDataLookup); }
TAknTextLineLayout TextLine1f(TInt aParam0) { return AknLayoutAdaptationDecode::TextLine1f(KDataLookup, aParam0); }
TAknTextLineLayout TextLine2f(TInt aParam0,TInt aParam1) { return AknLayoutAdaptationDecode::TextLine2f(KDataLookup, aParam0, aParam1); }
TAknTextLineLayout TextLine3f(TInt aParam0,TInt aParam1,TInt aParam2) { return AknLayoutAdaptationDecode::TextLine3f(KDataLookup, aParam0, aParam1, aParam2); }
TAknTextLineLayout TextLine4f(TInt aParam0,TInt aParam1,TInt aParam2,TInt aParam3) { return AknLayoutAdaptationDecode::TextLine4f(KDataLookup, aParam0, aParam1, aParam2, aParam3); }

TAknMultiLineTextLayout MultiLineTextLine2f(TInt aParam0,TInt aParam1) { return AknLayoutAdaptationDecode::MultiLineTextLine2f(KDataLookup, aParam0, aParam1); }
TAknMultiLineTextLayout MultiLineTextLine4f(TInt aParam0,TInt aParam1,TInt aParam2,TInt aParam3) { return AknLayoutAdaptationDecode::MultiLineTextLine4f(KDataLookup, aParam0, aParam1, aParam2, aParam3); }

TAknWindowLineLayout WindowTable0f(TInt aLineIndex) { return AknLayoutAdaptationDecode::WindowTable0f(KDataLookup, aLineIndex); }
TAknWindowLineLayout WindowTable1f(TInt aLineIndex, TInt aParam0) { return AknLayoutAdaptationDecode::WindowTable1f(KDataLookup, aLineIndex, aParam0); }
TAknWindowLineLayout WindowTable2f(TInt aLineIndex, TInt aParam0, TInt aParam1) { return AknLayoutAdaptationDecode::WindowTable2f(KDataLookup, aLineIndex, aParam0, aParam1); }
TAknWindowLineLayout WindowTable0t(TInt aLineIndex, const TRect& aParentRect) { return AknLayoutAdaptationDecode::WindowTable0t(KDataLookup, aLineIndex, aParentRect); }
TAknWindowLineLayout WindowTable1t(TInt aLineIndex, const TRect& aParentRect, TInt aParam0) { return AknLayoutAdaptationDecode::WindowTable1t(KDataLookup, aLineIndex, aParentRect, aParam0); }

TAknTextLineLayout TextTable0f(TInt aLineIndex) { return AknLayoutAdaptationDecode::TextTable0f(KDataLookup, aLineIndex); }
TAknTextLineLayout TextTable1f(TInt aLineIndex, TInt aParam0) { return AknLayoutAdaptationDecode::TextTable1f(KDataLookup, aLineIndex, aParam0); }
TAknTextLineLayout TextTable2f(TInt aLineIndex, TInt aParam0, TInt aParam1) { return AknLayoutAdaptationDecode::TextTable2f(KDataLookup, aLineIndex, aParam0, aParam1); }

TAknMultiLineTextLayout MultiLineTextLine1f(TInt aParam0) { return AknLayoutAdaptationDecode::MultiLineTextLine1f(KDataLookup, aParam0); }
TAknMultiLineTextLayout MultiLineTextLine3f(TInt aParam0,TInt aParam1,TInt aParam2) { return AknLayoutAdaptationDecode::MultiLineTextLine3f(KDataLookup, aParam0, aParam1, aParam2); }

inline TAknWindowComponentLayout DoCompose(TAknWindowComponentLayout aLine1, TAknWindowComponentLayout aLine2) 
    { 
    return TAknWindowComponentLayout::Compose(aLine1, aLine2); 
    }

inline TAknTextComponentLayout DoComposeText(TAknWindowComponentLayout aLine1, TAknTextComponentLayout aLine2) 
    { 
    return TAknWindowComponentLayout::ComposeText(aLine1, aLine2); 
    }

inline TAknWindowComponentLayout DoIntersect(TAknWindowComponentLayout aLine, TAknWindowComponentLayout aLine2) 
    { 
    return TAknWindowComponentLayout::Intersect(aLine, aLine2);
    }

inline TAknWindowComponentLayout DoMinus(TAknWindowComponentLayout aLine, TAknWindowComponentLayout aParentDiff)
    {
    return TAknWindowComponentLayout::Minus(aLine, aParentDiff);
    }

inline TAknWindowComponentLayout DoSetZeroSized( TAknWindowComponentLayout aLine )
    {
    aLine.SetZeroSized();
    return aLine;
    }


//
// Local Functions to determine if parameters are relative in various ways
//
// Positive relative means that the value is expressed as ELayoutP +/- ELayoutPRange 
// Negative relative means that the value is expressed as  - ELayoutP +/- ELayoutPRange 
// The latter usually arises not from the layout tool, but from automatic elimination of EEmptys
// Two positive relative values in the same "column" (e.g. l,r .. ) can safely pass through the "Minus" method.
//

/**
* @param    layout cell value
* @return   ETrue if the value is positive parent-relative
*/ 
TBool IsPositiveParentRelative(TInt aVal)
    {
    return aVal > ELayoutP-ELayoutPRange && aVal <= ELayoutP;
    }

/**
* @param    layout cell value
* @return   ETrue if the value is negative parent-relative
*/ 
TBool IsNegativeParentRelative(TInt aVal)
    {
    return ( (0-ELayoutP) <= aVal && aVal < (ELayoutPRange - ELayoutP) );
    }

/**
* @param    layout cell value
* @return   ETrue if the value is either negative or positive parent-relative
*/ 
TBool IsNegativeOrPositiveParentRelative(TInt aVal)
    {
    return (IsPositiveParentRelative( aVal ) || IsNegativeParentRelative( aVal ) );
    }

/**
* @param    layout cell value
* @return   ETrue if the value is absolute
*/ 
TBool IsAbsolute( TInt aVal )
    {
    return ( (0-ELayoutPRange) <= aVal && aVal <= ELayoutPRange );
    }

/**
* @param    layout cell value
* @return   ETrue if the value marked as Empty 
*/ 
inline TBool IsEmpty( TInt aVal )
    {
    return ( aVal == ELayoutEmpty );
    }

/**
* Checks if the two layout lines have the same absolute and relative values 
* 
* @param    first Component layout
* @param    second Component layout
* @return   ETrue if the paterns of absolutes and positive parent relatives are the same and valid
*/ 
TBool LayoutsHaveSameParentRelativePatterns( 
    TAknWindowComponentLayout aLine1, 
    TAknWindowComponentLayout aLine2 )
    {
    TAknWindowLineLayout line1 = aLine1.LayoutLine();
    TAknWindowLineLayout line2 = aLine2.LayoutLine();

    if ( !( ( IsAbsolute( line1.il ) && IsAbsolute( line2.il ) ) ||
            ( IsEmpty( line1.il ) && IsEmpty( line2.il ) ) ||
            ( IsPositiveParentRelative( line1.il ) && IsPositiveParentRelative( line2.il ) ) ) )
        return EFalse;

    if ( !( ( IsAbsolute( line1.ir ) && IsAbsolute( line2.ir ) ) ||
            ( IsEmpty( line1.ir ) && IsEmpty( line2.ir ) ) ||
            ( IsPositiveParentRelative( line1.ir ) && IsPositiveParentRelative( line2.ir ) ) ) )
        return EFalse;

    if ( !( ( IsAbsolute( line1.it ) && IsAbsolute( line2.it ) ) ||
            ( IsEmpty( line1.it ) && IsEmpty( line2.it ) ) ||
            ( IsPositiveParentRelative( line1.it ) && IsPositiveParentRelative( line2.it ) ) ) )
        return EFalse;

    if ( !( ( IsAbsolute( line1.ib ) && IsAbsolute( line2.ib ) ) ||
            ( IsEmpty( line1.ib ) && IsEmpty( line2.ib ) ) ||
            ( IsPositiveParentRelative( line1.ib ) && IsPositiveParentRelative( line2.ib ) ) ) )
        return EFalse;

    // If we have managed to get through all these, the l,r,t,b have the same set of permitted patterns

    return ETrue;
    }

// 
//  Common functions
//


//
// This method returns empty TAknWindowLineLayout instance. (Filled with zeroes)
//
const TAknWindowLineLayoutImp KEmptyWindowLayout = {ELayoutEmpty,0,0,ELayoutEmpty,ELayoutEmpty,0,1}; // H=1 is for now only to prevent panics in AknLayoutRect
inline const TAknWindowLineLayout& EmptyWindowLayout()
    {
    return *(TAknWindowLineLayout*)&KEmptyWindowLayout;
    }

//
// This method returns empty TAknTextLineLayout instance. (Filled with zeroes)
//
const TAknTextLineLayoutImp KEmptyTextLayout = {ELayoutEmpty,0,0,0,0,ELayoutEmpty,ELayoutEmpty,0,0};
inline const TAknTextLineLayout& EmptyTextLayout()
    {
    return *(TAknTextLineLayout*)&KEmptyTextLayout;
    }

//
// This method returns zero-sized TAknWindowLineLayout instance. (Filled with zeroes)
//
const TAknWindowLineLayoutImp KZeroWindowLayout = {ELayoutEmpty,0,0,p,p,0,1}; // H=1 is for now only to prevent panics in AknLayoutRect
inline const TAknWindowLineLayout& ZeroWindowLayout()
    {
    return *(TAknWindowLineLayout*)&KZeroWindowLayout;
    }

//
// This method returns zero-sized TAknTextLineLayout instance. (Filled with zeroes)
//
const TAknTextLineLayoutImp KZeroTextLayout = {ELayoutEmpty,0,0,p,0,0,0,0,0};
inline const TAknTextLineLayout& ZeroTextLayout()
    {
    return *(TAknTextLineLayout*)&KZeroTextLayout;
    }

//
// This method is a common method for skin color palette preview related data. 
// Used to optimize this adaptation layer size.
//
TAknWindowLineLayout Skin_color_palette_preview_color_pane_common(TInt aColumn, TInt aRow)
    {
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_skin_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::grid_skin_colour_pane();
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::cell_skin_colour_pane(aColumn, aRow); // multigrid        
    TAknWindowComponentLayout layout4 = AknLayoutScalable_Apps::cell_skin_colour_pane_g1();

    return DoCompose(layout1, DoCompose(layout2, DoCompose(layout3, layout4))).LayoutLine();
    }

//
// Adaptation Layer Implementation
//


// C=230 H= W= b=0 l=0 r=0 t=0 
// Remark                    : Vertical line.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 36%) : grid_highlight_pane_cp01
// Scale parent match (  0%) : 
TAknWindowLineLayout Browser_image_highlight_Line_1() 
    {
    // NOT SUPPORTED (used in BrowserAudioPlugin 20.1.2006)
    return EmptyWindowLayout();
    }

// C=230 H= W= b=0 l=0 r=0 t=0 
// Remark                    : Vertical line.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 36%) : grid_highlight_pane_cp01
// Scale parent match (  0%) : 
TAknWindowLineLayout Browser_image_highlight_Line_2() 
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// C=230 H= W= b=0 l=0 r=0 t=0 
// Remark                    : Horizontal line.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 36%) : grid_highlight_pane_cp01
// Scale parent match (  0%) : 
TAknWindowLineLayout Browser_image_highlight_Line_3() 
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// C=230 H= W= b=0 l=0 r=0 t=0 
// Remark                    : Horizontal line.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 36%) : grid_highlight_pane_cp01
// Scale parent match (  0%) : 
TAknWindowLineLayout Browser_image_highlight_Line_4()
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// C=0 H= W= b= l=-2 r= t=-2 
// Remark                    : Vertical line.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 36%) : grid_highlight_pane_cp01
// Scale parent match (  0%) : 
TAknWindowLineLayout Browser_image_highlight_Line_5()
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// C=0 H= W= b= l=-4 r=-2 t=-2 
// Remark                    : Horizontal line.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 36%) : grid_highlight_pane_cp01
// Scale parent match (  0%) : 
TAknWindowLineLayout Browser_image_highlight_Line_6()
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// C=228 H= W= b= l= r=-2 t=-4 
// Remark                    : Vertical line.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 36%) : grid_highlight_pane_cp01
// Scale parent match (  0%) : 
TAknWindowLineLayout Browser_image_highlight_Line_7()
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// C=228 H= W= b=-2 l=-4 r=-4 t= 
// Remark                    : Horizontal line.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 36%) : grid_highlight_pane_cp01
// Scale parent match (  0%) : 
TAknWindowLineLayout Browser_image_highlight_Line_8()
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// C=0 H=330 W=750 b=-4 l=-4 r=-4 t=-4 
// Remark                    : 
// Parent                    : 
// Parent API                : 
// Scale API match    ( 36%) : grid_highlight_pane_cp01
// Scale parent match (  0%) : 
TAknWindowLineLayout Browser_image_highlight_Line_9()
    {
    // NOT USED
    return EmptyWindowLayout();
    }


// LAF Table : Navi pane elements
// C=1 H=24 W=56 b= l=42 r= t=4 
// Remark                    : Display view indication.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 29%) : wml_selection_box_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Navi_pane_elements_Line_1()
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// LAF Table : Application specific list panes
// C= H={34, 68, 102, 136} W=342 b= l=0 r= t={0, 34, 68, 102, 136, 170, 204, 238} 
// Remark                    : Parent list_cale_day_pane. List pane for the Calendar Day view.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : list_cale_time_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout list_cale_time_pane(TInt /*aIndex_t*/, TInt aIndex_H)
    {
    // MAN: DONE but this ignores aIndex_t and the layout data looks a bit strange...

    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_cale_day_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_cale_day_pane();
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::list_cale_pane();
    TAknWindowComponentLayout layout4;

    TInt option = aIndex_H;
    layout4 = AknLayoutScalable_Apps::list_cale_time_pane(option);
    
    return DoCompose(layout1, DoCompose(layout2,DoCompose(layout3,layout4))).LayoutLine(); 
    
    }

// C= H=58 W=330 b= l=0 r= t={0, 58, 116, 174, 232, 290} 
// Remark                    : Parent list_pinb_pane. List pane for the Pinboard List view.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : list_pinb_item_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout list_pinb_item_pane(TInt aIndex_t)
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_pinb_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_pinb_pane(1); // =larger pane
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::list_pinb_pane();
    TAknWindowComponentLayout layout4 = AknLayoutScalable_Apps::list_pinb_item_pane(aIndex_t);
    return DoCompose(layout1, DoCompose(layout2, DoCompose(layout3,layout4))).LayoutLine(); 
    }

// LAF Table : List pane elements (cale time)
// C=219 H=2 W=342 b= l=0 r= t={32, 66, 100, 134} 
// Remark                    : Horizontal line between list panes.
// Parent                    : list_cale_time_pane
// Parent API                : list_cale_time_pane
// Scale API match    ( 51%) : list_cale_time_pane_g_Limits
// Scale parent match (100%) : list_cale_time_pane
TAknWindowLineLayout List_pane_elements__cale_time__Line_1(TInt /*aIndex_t*/)
    {
    // MAN: DONE: check option, otherwise this should be ok
    // NOTE: aIndex_t is ignored. 
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::list_cale_time_pane_g2(0);
    return layout1.LayoutLine();    
    }

// C= H=26 W=26 b= l=22 r= t=4 
// Remark                    : Calendar item type indication.
// Parent                    : list_cale_time_pane
// Parent API                : list_cale_time_pane
// Scale API match    ( 51%) : list_cale_time_pane_g_Limits
// Scale parent match (100%) : list_cale_time_pane
TAknWindowLineLayout List_pane_elements__cale_time__Line_2()
    {
    // MAN: DONE: check option, otherwise this should be ok
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::list_cale_time_pane_g1(0); // why option here
    return layout1.LayoutLine();    
    }

// C= H=26 W=26 b= l={310, 284} r= t={4, 38, 72, 106} 
// Remark                    : Additional icons.
// Parent                    : list_cale_time_pane
// Parent API                : list_cale_time_pane
// Scale API match    ( 51%) : list_cale_time_pane_g_Limits
// Scale parent match (100%) : list_cale_time_pane
TAknWindowLineLayout List_pane_elements__cale_time__Line_3(TInt aIndex_l, TInt /*aIndex_t*/)
    {
    // MAN: DONE: check option, otherwise this should be ok
    TAknWindowComponentLayout layout1;

    // NOTE: aIndex_t is ignored. 
    
    if (aIndex_l == 0)
        layout1 = AknLayoutScalable_Apps::list_cale_time_pane_g3(0);
    else if (aIndex_l == 1)
        layout1 = AknLayoutScalable_Apps::list_cale_time_pane_g4(0);
    else if (aIndex_l == 2)         // This has not been supported previously
        layout1 = AknLayoutScalable_Apps::list_cale_time_pane_g5(0); 

    return layout1.LayoutLine();    
    }

// LAF Table : List pane texts (cale time)
// B={24, 58} C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignRight W={56, 84, 96}[aCommon1] l=6 r={280, 252, 240}[aCommon1] 
// Remark                    : Hours.
// Parent                    : list_cale_time_pane
// Parent API                : list_cale_time_pane
// Scale API match    ( 59%) : list_cale_time_pane_g_Limits
// Scale parent match (100%) : list_cale_time_pane
TAknTextLineLayout List_pane_texts__cale_time__Line_1(TInt aCommon1, TInt aIndex_B)
    {
    // MAN: DONE but check options
    // Need to compose to generate multiple rows [LMB 16/03/2005]
    TAknWindowComponentLayout layout0 = AknLayoutScalable_Apps::list_cale_pane();
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::list_cale_time_pane(aIndex_B);
    TAknTextComponentLayout layout2 = AknLayoutScalable_Apps::list_cale_time_pane_t2(aCommon1);
    return DoComposeText(layout0,DoComposeText(layout1,layout2)).LayoutLine(); 
    }


// B=24 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=8 l={62, 90, 94}[aCommon1] r={272, 244, 232}[aCommon1] 
// Remark                    : Hyphen.
// Parent                    : list_cale_time_pane
// Parent API                : list_cale_time_pane
// Scale API match    ( 59%) : list_cale_time_pane_g_Limits
// Scale parent match (100%) : list_cale_time_pane
TAknTextLineLayout List_pane_texts__cale_time__Line_2(TInt aCommon1)
    {
    // MAN: DONE
    // Need to compose to generate multiple rows 
    // but not enough info in this API [LMB 16/03/2005]
    TAknWindowComponentLayout layout0 = AknLayoutScalable_Apps::list_cale_pane();
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::list_cale_time_pane(0);
    TAknTextComponentLayout layout2 = AknLayoutScalable_Apps::list_cale_time_pane_t4(aCommon1);
    return DoComposeText(layout0,DoComposeText(layout1,layout2)).LayoutLine(); 
    }

// B={24, 58, 92, 128} C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={256, 224, 198, 228, 196, 170, 216, 184, 158} l={76, 104, 116} r={10, 42, 68} 
// Remark                    : Item text.
// Parent                    : list_cale_time_pane
// Parent API                : list_cale_time_pane
// Scale API match    ( 59%) : list_cale_time_pane_g_Limits
// Scale parent match (100%) : list_cale_time_pane
TAknTextLineLayout List_pane_texts__cale_time__Line_3(TInt aIndex_l, TInt /*aIndex_r*/, TInt aIndex_B, TInt /*aIndex_W*/)
    {
    // MAN: DONE but currently W, r indexes are not supported because new LAF does not privide those...
    //      ..only to 4th line those are provided. But anyway currently calendar does not seem to use those.
    TInt option = aIndex_l;

    // Need to compose to generate multiple rows [LMB 16/03/2005]
    TAknWindowComponentLayout layout0 = AknLayoutScalable_Apps::list_cale_pane();
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::list_cale_time_pane(aIndex_B);
    TAknTextComponentLayout layout2 = AknLayoutScalable_Apps::list_cale_time_pane_t1(option);
    return DoComposeText(layout0,DoComposeText(layout1,layout2)).LayoutLine(); 
    }


// LAF Table : List pane elements (pinb item)
// C=215 H=58 W=2 b= l=100 r= t=0 
// Remark                    : A line between the AB and C columns.
// Parent                    : list_pinb_item_pane
// Parent API                : list_pinb_item_pane
// Scale API match    ( 54%) : list_pinb_item_pane_g_Limits
// Scale parent match (100%) : list_pinb_item_pane
TAknWindowLineLayout List_pane_elements__pinb_item__Line_1()
    {
    // MAN: NOT SUPPORTED (not used 26.11.2004)
    return EmptyWindowLayout();
    }

// C= H=50 W=58 b= l=22 r= t=4 
// Remark                    : Calendar item type indication.
// Parent                    : list_pinb_item_pane
// Parent API                : list_pinb_item_pane
// Scale API match    ( 54%) : list_pinb_item_pane_g_Limits
// Scale parent match (100%) : list_pinb_item_pane
TAknWindowLineLayout List_pane_elements__pinb_item__Line_2()
    {
    // MAN: (DONE)
    TAknWindowLineLayout line = AknLayoutScalable_Apps::list_pinb_item_pane_g1(0).LayoutLine();
    return line;
    }

// C= H=26 W=26 b= l=28 r= t=28 
// Remark                    : 
// Parent                    : list_pinb_item_pane
// Parent API                : list_pinb_item_pane
// Scale API match    ( 54%) : list_pinb_item_pane_g_Limits
// Scale parent match (100%) : list_pinb_item_pane
TAknWindowLineLayout List_pane_elements__pinb_item__Line_3()
    {
    // MAN: (DONE)
    TAknWindowLineLayout line = AknLayoutScalable_Apps::list_pinb_item_pane_g2(0).LayoutLine();
    return line;
    }

// C= H=26 W=26 b= l={298, 272} r= t=14 
// Remark                    : Additional icon.
// Parent                    : list_pinb_item_pane
// Parent API                : list_pinb_item_pane
// Scale API match    ( 54%) : list_pinb_item_pane_g_Limits
// Scale parent match (100%) : list_pinb_item_pane
TAknWindowLineLayout List_pane_elements__pinb_item__Line_4(TInt aIndex_l)
    {
    // MAN: (DONE)
    TAknWindowLineLayout line;
    if (aIndex_l == 0)
        {
        line = AknLayoutScalable_Apps::list_pinb_item_pane_g3(0).LayoutLine();
        }
    else // aIndex_l == 1
        {
        line = AknLayoutScalable_Apps::list_pinb_item_pane_g4(0).LayoutLine();
        }
    return line;
    }


// LAF Table : List pane texts (pinb item)
// B=36 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={210, 178, 152}[aCommon1] l=114 r={10, 42, 68}[aCommon1] 
// Remark                    : Pinboard item title.
// Parent                    : list_pinb_item_pane
// Parent API                : list_pinb_item_pane
// Scale API match    ( 59%) : list_pinb_item_pane_g_Limits
// Scale parent match (100%) : list_pinb_item_pane
TAknTextLineLayout List_pane_texts__pinb_item__Line_1(TInt aCommon1)
    {
    // MAN: (DONE)
    TAknTextLineLayout textLine = AknLayoutScalable_Apps::list_pinb_item_pane_t1(aCommon1+1).LayoutLine();
    return textLine;
    }

// LAF Table : List pane highlight (several)
// C=222 H=p-4 W=p-8 b= l=6 r= t=4 
// Remark                    : Shadow.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 52%) : list_highlight_pane_cp02
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_highlight__several__Line_1(const TRect& /*aParentRect*/)
    {
    // MAN: NOT SUPPORTED (used in Calendar)
    return EmptyWindowLayout();
    }

// C=244 H=p-2 W=p-6 b= l=2 r= t=0 
// Remark                    : Highlight.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 52%) : list_highlight_pane_cp02
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_highlight__several__Line_2(const TRect& /*aParentRect*/)
    {
    // MAN: NOT SUPPORTED (used in Calendar)
    return EmptyWindowLayout();
    }


// LAF Table : Grid pane descendants
// C= H=58 W=66 b= l={0, , , , , 66, , , , , 132, , , , , 198, , , , , 264, , , , , } r= t={0, 58, 116, 174, 232, 0, 58, 116, 174, 232, 0, 58, 116, 174, 232, 0, 58, 116, 174, 232, 0, 58, 116, 174, 232, , , , , } 
// Remark                    : Parent grid_pinb_pane. Pinboard 5x5 grid.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : cell_pinb_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout cell_pinb_pane(TInt /*aIndex_l*/, TInt aIndex_t)
    {
    // MAN: DONE
    TInt columnIndex = aIndex_t / 5;        
    TInt rowIndex = aIndex_t - columnIndex * 5;    
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_pinb_pane(columnIndex, rowIndex);
    return layout1.LayoutLine();    
    }

// C= H=120 W=116 b= l={0, 116, 232, 0, 116, 232, 0, 116, 232} r= t={0, , , 120, , , 240} 
// Remark                    : Parent grid_qdial_pane. Speed Dial 3x3 grid.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : cell_qdial_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout cell_qdial_pane(TInt aIndex_l, TInt /*aIndex_t*/)
    {
    // MAN: DONE
    TInt rowIndex = aIndex_l / 3;
    TInt columnIndex = aIndex_l - rowIndex * 3;        
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_qdial_pane(columnIndex, rowIndex);
    return layout1.LayoutLine();    
    }

// C= H=38 W={42, 46} b= l={0, 44, 88, 132, 176, 220, 264, 0, 44, 88, 132, 176, 220, 264, 0, 44, 88, 132, 176, 220, 264, 0, 44, 88, 132, 176, 220, 264, 0, 44, 88, 132, 176, 220, 264, 0, 44, 88, 132, 176, 220, 264, 0, 48, 96, 144, 192, 240, 288} r= t={0, , , , , , , 40, , , , , , , 80, , , , , , , 120, , , , , , , 160, , , , , , , 200} 
// Remark                    : Parent grid_cale_month_pane. Calendar Month view 7x6 grid.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : cell_cale_month_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout cell_cale_month_pane(TInt aIndex_l, TInt /*aIndex_t*/, TInt /*aIndex_W*/)
    {
    // MAN: DONE    
    TInt varietyIndex = 0; // this is the layout with a day column at the left side, which is the only one supported in old LAF spec
    TInt rowIndex = aIndex_l / 7;
    TInt columnIndex = aIndex_l - rowIndex * 7;        
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_cale_month_pane(varietyIndex, rowIndex, columnIndex);    
    return layout1.LayoutLine();    
    }

// C= H=52 W=60 b= l={0, , , , , 60} r= t={0, 54, 108, 162, 216, 0, 54, 108, 162, 216} 
// Remark                    : Parent grid_calc_pane. Calculator 2x4 grid.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : cell_calc_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout cell_calc_pane(TInt aIndex_l, TInt aIndex_t)
    {
    // MAN: DONE
    TInt columnIndex = 0;
    TInt rowIndex = 0;
    if (aIndex_l > 0)
        columnIndex = 1;
    else
        columnIndex = 0;        

    rowIndex = aIndex_t;    
    
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_calc_pane(columnIndex, rowIndex);    
    return layout1.LayoutLine();    
    }

// C= H=28 W=38 b= l={0, , , , , , , , 40, , , , , , , , 80, , , , , , , , 120, , , , , , , , 160, , , , , , , , 200, , , , , , , , 240} r= t={0, 30, 60, 90, 120, 150, 180, 210, 0, 30, 60, 90, 120, 150, 180, 210, 0, 30, 60, 90, 120, 150, 180, 210, 0, 30, 60, 90, 120, 150, 180, 210, 0, 30, 60, 90, 120, 150, 180, 210, 0, 30, 60, 90, 120, 150, 180, 210, 0, 30, 60, 90, 120, 150, 180, 210} 
// Remark                    : Parent grid_cale_week_pane. Calendar Week view 7x8 grid.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : cell_cale_week_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout cell_cale_week_pane(TInt /*aIndex_l*/, TInt aIndex_t)
    {
    // MAN: DONE
    TInt columnIndex = aIndex_t / 8;        
    TInt rowIndex = aIndex_t - columnIndex * 8;    
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_cale_week_pane(rowIndex, columnIndex);
    return layout1.LayoutLine();    
    }

// C= H=52 W=68 b= l=0 r= t={0, 52, 104, 156, 208} 
// Remark                    : Parent grid_vorec_pane. Voice Recorder 1x5 grid.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : cell_vorec_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout cell_vorec_pane(TInt aIndex_t) 
    {

    // MAN: DONE
    //	the index is exactly the row index, so don't need this any more [LMB 26/11/2004]
/*
    TInt columnIndex = aIndex_t / 5;        
    TInt rowIndex = aIndex_t - columnIndex * 5;*/
	TInt rowIndex = aIndex_t;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_vorec_pane(rowIndex);

//		seems to take the params now, so don't need this any more [LMB 26/11/2004]
/*
    TInt aGapBetweenColumns = 0; // TODO: how to get real gap
    TInt aGapBetweenRows = 0;    // TODO: how to get real gap
    layout1 = TAknWindowComponentLayout::MultiLineGrid(layout1, columnIndex, rowIndex, aGapBetweenColumns, aGapBetweenRows);    
    */

    return layout1.LayoutLine();    
    }

// C= H=68 W=160 b= l={0, , , , 162} r= t={0, 70, 140, 210, 0, 70, 140, 210} 
// Remark                    : Parent grid_gms_pane. Graphical message selection 2x4 grid.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : cell_gms_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout cell_gms_pane(TInt /*aIndex_l*/, TInt aIndex_t)
    {
    // MAN: DONE
    TInt columnIndex = aIndex_t / 4;        
    TInt rowIndex = aIndex_t - columnIndex * 4;    
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_gms_pane(columnIndex, rowIndex);

//		seems to take the row and column params now, so don't need this any more [LMB 26/11/2004]
/*    TInt aGapBetweenColumns = 0; // TODO: how to get real gap
    TInt aGapBetweenRows = 0;    // TODO: how to get real gap
	layout1 = TAknWindowComponentLayout::MultiLineGrid(layout1, columnIndex, rowIndex, aGapBetweenColumns, aGapBetweenRows);    
	*/

    return layout1.LayoutLine();    

    }

// C= H=46 W=64 b= l=0 r= t={0, 46, 92, 138, 184, 230} 
// Remark                    : Parent grid_mp_pane Media Player Playlist  1x6 grid.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : cell_mp_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout cell_mp_pane(TInt /*aIndex_t*/)
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_mp_pane();
    return layout1.LayoutLine();    
    }


// LAF Table : Cell pane elements (pinb)
// C= H=50 W=58 b= l=4 r= t=4 
// Remark                    : Shortcut icons for documents and applications.
// Parent                    : cell_pinb_pane
// Parent API                : cell_pinb_pane
// Scale API match    ( 46%) : cell_pinb_pane_g_Limits
// Scale parent match (100%) : cell_pinb_pane
TAknWindowLineLayout Cell_pane_elements__pinb__Line_1()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_pinb_pane_g1(0);
    return layout1.LayoutLine();    
    }

// C= H=26 W=26 b= l=38 r= t=2 
// Remark                    : Marked item indication.
// Parent                    : cell_pinb_pane
// Parent API                : cell_pinb_pane
// Scale API match    ( 46%) : cell_pinb_pane_g_Limits
// Scale parent match (100%) : cell_pinb_pane
TAknWindowLineLayout Cell_pane_elements__pinb__Line_2()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_pinb_pane_g3(0);
    return layout1.LayoutLine();    
    }

// C= H=26 W=26 b= l=10 r= t=28 
// Remark                    : Identifier icon indication.
// Parent                    : cell_pinb_pane
// Parent API                : cell_pinb_pane
// Scale API match    ( 46%) : cell_pinb_pane_g_Limits
// Scale parent match (100%) : cell_pinb_pane
TAknWindowLineLayout Cell_pane_elements__pinb__Line_3()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_pinb_pane_g2(0);
    return layout1.LayoutLine();    
    }


// LAF Table : Cell pane elements (qdial)
// C=222 H=88 W=72 b= l=26 r= t=16 
// Remark                    : Shadow for a tnCIF90 image.
// Parent                    : cell_qdial_pane
// Parent API                : cell_qdial_pane
// Scale API match    ( 48%) : cell_qdial_pane_g_Limits
// Scale parent match (100%) : cell_qdial_pane
TAknWindowLineLayout Cell_pane_elements__qdial__Line_1()
    {
    // MAN: NOT SUPPORTED (shadow)
    return EmptyWindowLayout();
    }

// C= H=88 W=72 b= l=24 r= t=14 
// Remark                    : tnCIF90
// Parent                    : cell_qdial_pane
// Parent API                : cell_qdial_pane
// Scale API match    ( 48%) : cell_qdial_pane_g_Limits
// Scale parent match (100%) : cell_qdial_pane
TAknWindowLineLayout Cell_pane_elements__qdial__Line_2()
    {
    // MAN: DONE but note that only one image size is defined in new LAF
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::thumbnail_qdial_pane(0);
    return layout1.LayoutLine();    
    }

// C= H=30 W=30 b= l=12 r= t=18 
// Remark                    : Number type icon.
// Parent                    : cell_qdial_pane
// Parent API                : cell_qdial_pane
// Scale API match    ( 48%) : cell_qdial_pane_g_Limits
// Scale parent match (100%) : cell_qdial_pane
TAknWindowLineLayout Cell_pane_elements__qdial__Line_3()
    {
    // MAN: DONE but note that only one image size is defined in new LAF
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_qdial_pane_g2(0);
    return layout1.LayoutLine();    
    }

// C=222 H=72 W=88 b= l=18 r= t=16 
// Remark                    : Shadow for a tnCIF image.
// Parent                    : cell_qdial_pane
// Parent API                : cell_qdial_pane
// Scale API match    ( 48%) : cell_qdial_pane_g_Limits
// Scale parent match (100%) : cell_qdial_pane
TAknWindowLineLayout Cell_pane_elements__qdial__Line_4()
    {
    // MAN: NOT SUPPORTED (shadow)
    return EmptyWindowLayout();
    }

// C= H=72 W=88 b= l=16 r= t=14 
// Remark                    : tnCIF
// Parent                    : cell_qdial_pane
// Parent API                : cell_qdial_pane
// Scale API match    ( 48%) : cell_qdial_pane_g_Limits
// Scale parent match (100%) : cell_qdial_pane
TAknWindowLineLayout Cell_pane_elements__qdial__Line_5()
    {
    // MAN: DONE but note that only one image size is defined in new LAF
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::thumbnail_qdial_pane(0);
    return layout1.LayoutLine();    
    }

// C= H=30 W=30 b= l=4 r= t=18 
// Remark                    : Number type icon.
// Parent                    : cell_qdial_pane
// Parent API                : cell_qdial_pane
// Scale API match    ( 48%) : cell_qdial_pane_g_Limits
// Scale parent match (100%) : cell_qdial_pane
TAknWindowLineLayout Cell_pane_elements__qdial__Line_6()
    {
    // MAN: DONE but note that only one image size is defined in new LAF
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_qdial_pane_g2(0);
    return layout1.LayoutLine();    
    }
// C=222 H=80 W=60 b= l=32 r= t=16 
// Remark                    : Shadow for a tnVGA90 image.
// Parent                    : cell_qdial_pane
// Parent API                : cell_qdial_pane
// Scale API match    ( 48%) : cell_qdial_pane_g_Limits
// Scale parent match (100%) : cell_qdial_pane
TAknWindowLineLayout Cell_pane_elements__qdial__Line_7()
    {
    // MAN: NOT SUPPORTED (shadow)
    return EmptyWindowLayout();
    }

// C= H=80 W=60 b= l=30 r= t=14 
// Remark                    : tnVGA90
// Parent                    : cell_qdial_pane
// Parent API                : cell_qdial_pane
// Scale API match    ( 48%) : cell_qdial_pane_g_Limits
// Scale parent match (100%) : cell_qdial_pane
TAknWindowLineLayout Cell_pane_elements__qdial__Line_8()
    {
    // MAN: DONE but note that only one image size is defined in new LAF
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::thumbnail_qdial_pane(0);
    return layout1.LayoutLine();    
    }

// C= H=30 W=30 b= l=18 r= t=18 
// Remark                    : Number type icon.
// Parent                    : cell_qdial_pane
// Parent API                : cell_qdial_pane
// Scale API match    ( 48%) : cell_qdial_pane_g_Limits
// Scale parent match (100%) : cell_qdial_pane
TAknWindowLineLayout Cell_pane_elements__qdial__Line_9()
    {
    // MAN: DONE but note that only one image size is defined in new LAF
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_qdial_pane_g2(0);
    return layout1.LayoutLine();    
    }

// C=222 H=60 W=80 b= l=22 r= t=16 
// Remark                    : Shadow for a tnVGA image.
// Parent                    : cell_qdial_pane
// Parent API                : cell_qdial_pane
// Scale API match    ( 46%) : cell_qdial_pane_g_Limits
// Scale parent match (100%) : cell_qdial_pane
TAknWindowLineLayout Cell_pane_elements__qdial__Line_10()
    {
    // MAN: NOT SUPPORTED (shadow)
    return EmptyWindowLayout();
    }

// C= H=60 W=80 b= l=20 r= t=14 
// Remark                    : tnVGA
// Parent                    : cell_qdial_pane
// Parent API                : cell_qdial_pane
// Scale API match    ( 46%) : cell_qdial_pane_g_Limits
// Scale parent match (100%) : cell_qdial_pane
TAknWindowLineLayout Cell_pane_elements__qdial__Line_11()
    {
    // MAN: DONE but note that only one image size is defined in new LAF
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::thumbnail_qdial_pane(0);
    return layout1.LayoutLine();    
    }

// C= H=30 W=30 b= l=8 r= t=18 
// Remark                    : Number type icon.
// Parent                    : cell_qdial_pane
// Parent API                : cell_qdial_pane
// Scale API match    ( 46%) : cell_qdial_pane_g_Limits
// Scale parent match (100%) : cell_qdial_pane
TAknWindowLineLayout Cell_pane_elements__qdial__Line_12()
    {
    // MAN: DONE but note that only one image size is defined in new LAF
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_qdial_pane_g2(0);
    return layout1.LayoutLine();    
    }

// C=222 H=96 W=80 b= l=22 r= t=16 
// Remark                    : Shadow for a tnCOM image.
// Parent                    : cell_qdial_pane
// Parent API                : cell_qdial_pane
// Scale API match    ( 46%) : cell_qdial_pane_g_Limits
// Scale parent match (100%) : cell_qdial_pane
TAknWindowLineLayout Cell_pane_elements__qdial__Line_13()
    {
    // MAN: NOT SUPPORTED (shadow)
    return EmptyWindowLayout();
    }

// C= H=96 W=80 b= l=20 r= t=14 
// Remark                    : tnCOM
// Parent                    : cell_qdial_pane
// Parent API                : cell_qdial_pane
// Scale API match    ( 46%) : cell_qdial_pane_g_Limits
// Scale parent match (100%) : cell_qdial_pane
TAknWindowLineLayout Cell_pane_elements__qdial__Line_14() 
    {
    // MAN: DONE but note that only one image size is defined in new LAF
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::thumbnail_qdial_pane(0);
    return layout1.LayoutLine();    
    }

// C= H=30 W=30 b= l=8 r= t=18 
// Remark                    : Number type icon.
// Parent                    : cell_qdial_pane
// Parent API                : cell_qdial_pane
// Scale API match    ( 46%) : cell_qdial_pane_g_Limits
// Scale parent match (100%) : cell_qdial_pane
TAknWindowLineLayout Cell_pane_elements__qdial__Line_15()
    {
    // MAN: DONE but note that only one image size is defined in new LAF
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_qdial_pane_g2(0);
    return layout1.LayoutLine();    
    }

// C=222 H= W= b= l=-2 r= t=16 
// Remark                    : Shadow for any other size.
// Parent                    : cell_qdial_pane
// Parent API                : cell_qdial_pane
// Scale API match    ( 46%) : cell_qdial_pane_g_Limits
// Scale parent match (100%) : cell_qdial_pane
TAknWindowLineLayout Cell_pane_elements__qdial__Line_16()
    {
    // MAN: NOT SUPPORTED (shadow)
    return EmptyWindowLayout();
    }

// C= H=96 W=88 b= l= r= t=14 
// Remark                    : Any other size.
// Parent                    : cell_qdial_pane
// Parent API                : cell_qdial_pane
// Scale API match    ( 46%) : cell_qdial_pane_g_Limits
// Scale parent match (100%) : cell_qdial_pane
TAknWindowLineLayout Cell_pane_elements__qdial__Line_17()
    {
    // MAN: DONE but note that only one image size is defined in new LAF
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::thumbnail_qdial_pane(0);
    return layout1.LayoutLine();    
    }

// C= H=26 W=26 b= l=-12 r= t=18 
// Remark                    : Number type icon.
// Parent                    : cell_qdial_pane
// Parent API                : cell_qdial_pane
// Scale API match    ( 46%) : cell_qdial_pane_g_Limits
// Scale parent match (100%) : cell_qdial_pane
TAknWindowLineLayout Cell_pane_elements__qdial__Line_18()
    {
    // MAN: DONE but note that only one image size is defined in new LAF
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_qdial_pane_g2(0);
    return layout1.LayoutLine();    
    }

// C= H=30 W=30 b= l=8 r= t=18 
// Remark                    : Number type icon.
// Parent                    : cell_qdial_pane
// Parent API                : cell_qdial_pane
// Scale API match    ( 46%) : cell_qdial_pane_g_Limits
// Scale parent match (100%) : cell_qdial_pane
TAknWindowLineLayout Cell_pane_elements__qdial__Line_19()
    {
    // MAN: DONE but note that only one image size is defined in new LAF
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_qdial_pane_g2(1);
    return layout1.LayoutLine();    
    }

// C= H=112 W=108 b= l=2 r= t=2 
// Remark                    : Speed Dial number graphics.
// Parent                    : cell_qdial_pane
// Parent API                : cell_qdial_pane
// Scale API match    ( 46%) : cell_qdial_pane_g_Limits
// Scale parent match (100%) : cell_qdial_pane
TAknWindowLineLayout Cell_pane_elements__qdial__Line_20()
    {
    // MAN: DONE but not quite sure if this is correctly mapped now
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_qdial_pane_g1(0);
    return layout1.LayoutLine();    
    }

// C= H=26 W=26 b= l=88 r= t=2 
// Remark                    : Marked item indication.
// Parent                    : cell_qdial_pane
// Parent API                : cell_qdial_pane
// Scale API match    ( 46%) : cell_qdial_pane_g_Limits
// Scale parent match (100%) : cell_qdial_pane
TAknWindowLineLayout Cell_pane_elements__qdial__Line_21()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_qdial_pane_g3(0);
    return layout1.LayoutLine();        
    }


// LAF Table : Cell pane texts (qdial)
// B={42, 72, 102}[aCommon1] C=215 Font=ELatinBold12_Scaled J=ELayoutAlignLeft W={98, 70} l={10, 38, 10, 10} r={8, 8, 8}[aCommon1] 
// Remark                    : Speed Dial name or the text Voice mailbox.
// Parent                    : cell_qdial_pane
// Parent API                : cell_qdial_pane
// Scale API match    ( 57%) : cell_qdial_pane_t_Limits
// Scale parent match (100%) : cell_qdial_pane
TAknTextLineLayout Cell_pane_texts__qdial__Line_1(TInt aIndex_l, TInt aCommon1, TInt aIndex_W)
    {
    // MAN: DONE    
    TInt option = 1;
    if (aIndex_l == 1 || aIndex_W == 1)
        option = 0;

    TAknTextComponentLayout textLayout;
    
    if (aCommon1 == 0)
        textLayout = AknLayoutScalable_Apps::cell_qdial_pane_t1(option);
    else if (aCommon1 == 1)
        textLayout = AknLayoutScalable_Apps::cell_qdial_pane_t2(option);    
    else if (aCommon1 == 2)
        textLayout = AknLayoutScalable_Apps::cell_qdial_pane_t3(option);

    return textLayout.LayoutLine();
    }


// LAF Table : Cell pane elements (cale month)
// C={0, 14, 84} H=38 W={42, , , 46} b= l=0 r= t=0 
// Remark                    : Saturday Sunday or holiday indication.
// Parent                    : cell_cale_month_pane
// Parent API                : cell_cale_month_pane
// Scale API match    ( 50%) : cell_cale_month_pane_ParamLimits
// Scale parent match (100%) : cell_cale_month_pane
TAknWindowLineLayout Cell_pane_elements__cale_month__Line_1(TInt /*aIndex_C*/, TInt /*aIndex_W*/)
    {
    // MAN: NOT SUPPORTED (calendar only uses color from this line.)
    return EmptyWindowLayout();
    }

// C= H=10 W=10 b= l={32, 36} r= t=28 
// Remark                    : E.g. a Calendar event indicator.
// Parent                    : cell_cale_month_pane
// Parent API                : cell_cale_month_pane
// Scale API match    ( 50%) : cell_cale_month_pane_ParamLimits
// Scale parent match (100%) : cell_cale_month_pane
TAknWindowLineLayout Cell_pane_elements__cale_month__Line_2(TInt /*aIndex_l*/)
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_cale_month_pane_g1();
    return layout1.LayoutLine();    
    }

// LAF Table : Cell pane texts (cale month)
// B=28 C={215, 219} Font=ELatinBold12_Scaled J=ELayoutAlignCenter W=28 l={8, 10}[aCommon1] r={6, 8}[aCommon1] 
// Remark                    : Day number.
// Parent                    : cell_cale_month_pane
// Parent API                : cell_cale_month_pane
// Scale API match    ( 57%) : cell_cale_month_pane_t1_ParamLimits
// Scale parent match (100%) : cell_cale_month_pane
TAknTextLineLayout Cell_pane_texts__cale_month__Line_1(TInt aIndex_C, TInt /*aCommon1*/)
    {
    // MAN: DONE
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::cell_cale_month_pane_t1(aIndex_C);
    return textLayout.LayoutLine();    
    }

// LAF Table : Cell pane elements (calc)
// C= H=52 W=60 b= l=0 r= t=0 
// Remark                    : Button graphics. Not pressed and pressed indication.
// Parent                    : cell_calc_pane
// Parent API                : cell_calc_pane
// Scale API match    ( 40%) : cell_calc_pane_ParamLimits
// Scale parent match (100%) : cell_calc_pane
TAknWindowLineLayout Cell_pane_elements__calc__Line_1()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_calc_pane_g1();
    return layout1.LayoutLine();    
    }

// LAF Table : Cell pane elements (cale week)
// C={0, 14, 84} H=p W=p b= l=0 r= t=0 
// Remark                    : Saturday Sunday or holiday indication.
// Parent                    : cell_cale_week_pane
// Parent API                : cell_cale_week_pane
// Scale API match    ( 51%) : cell_cale_week_pane_g_Limits
// Scale parent match (100%) : cell_cale_week_pane
TAknWindowLineLayout Cell_pane_elements__cale_week__Line_1(const TRect& /*aParentRect*/, TInt /*aIndex_C*/)
    {
    // MAN: NOT SUPPORTED (calendar only uses color from this line.)
    return EmptyWindowLayout();
    }

// C= H=6 W=14 b= l=12 r= t={0, 22} 
// Remark                    : Calendar event indicators.
// Parent                    : cell_cale_week_pane
// Parent API                : cell_cale_week_pane
// Scale API match    ( 51%) : cell_cale_week_pane_g_Limits
// Scale parent match (100%) : cell_cale_week_pane
TAknWindowLineLayout Cell_pane_elements__cale_week__Line_2(TInt aIndex_t)
    {
    // MAN: DONE
    TInt option = 0;
    if (aIndex_t == 0)
        option = 0;
    else
        option = 5;

    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_cale_week_pane_g3(option);
    return layout1.LayoutLine();    
    }

// C= H=4 W=14 b= l=12 r= t={6, 10, 14, 18} 
// Remark                    : Calendar event indicators.
// Parent                    : cell_cale_week_pane
// Parent API                : cell_cale_week_pane
// Scale API match    ( 51%) : cell_cale_week_pane_g_Limits
// Scale parent match (100%) : cell_cale_week_pane
TAknWindowLineLayout Cell_pane_elements__cale_week__Line_3(TInt aIndex_t)
    {
    // MAN: DONE
    TInt option = 0;
    if (aIndex_t == 0)
        option = 1;
    else if (aIndex_t == 1)
        option = 2;
    else if (aIndex_t == 2)
        option = 3;
    else if (aIndex_t == 3)
        option = 4;

    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_cale_week_pane_g3(option);
    return layout1.LayoutLine();    
    }

// C= H=26 W=26 b= l=6 r= t=2 
// Remark                    : Calendar event type indicators. Used in non-timed events.
// Parent                    : cell_cale_week_pane
// Parent API                : cell_cale_week_pane
// Scale API match    ( 51%) : cell_cale_week_pane_g_Limits
// Scale parent match (100%) : cell_cale_week_pane
TAknWindowLineLayout Cell_pane_elements__cale_week__Line_4() 
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_cale_week_pane_g2();
    return layout1.LayoutLine();    
    }


// LAF Table : Voice Recorder cell elements
// C= H=52 W=68 b= l=0 r= t=0 
// Remark                    : Function button graphics. Pressed and not pressed indication.
// Parent                    : cell_vorec_pane
// Parent API                : cell_vorec_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : cell_vorec_pane
TAknWindowLineLayout Voice_Recorder_cell_elements_Line_1()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_vorec_pane_g1();
    return layout1.LayoutLine();    
    }

// LAF Table : Graphical message cell elements
// C= H=56 W=144 b= l=8 r= t=6 
// Remark                    : Graphical picture message image.
// Parent                    : cell_gms_pane
// Parent API                : cell_gms_pane
// Scale API match    ( 30%) : cell_large_graphic_popup_pane_ParamLimits
// Scale parent match (100%) : cell_gms_pane
TAknWindowLineLayout Graphical_message_cell_elements_Line_1()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_gms_pane_g1();
    return layout1.LayoutLine();    
    }

// C= H=26 W=26 b= l=130 r= t=4 
// Remark                    : Marked item indication.
// Parent                    : cell_gms_pane
// Parent API                : cell_gms_pane
// Scale API match    ( 30%) : cell_large_graphic_popup_pane_ParamLimits
// Scale parent match (100%) : cell_gms_pane
TAknWindowLineLayout Graphical_message_cell_elements_Line_2()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_gms_pane_g2();
    return layout1.LayoutLine();    
    }


// LAF Table : MediaPlayer cell elements
// C= H=46 W=64 b= l=0 r= t=0 
// Remark                    : Player button graphics.
// Parent                    : cell_mp_pane
// Parent API                : cell_mp_pane
// Scale API match    ( 33%) : media_player_g1
// Scale parent match (100%) : cell_mp_pane
TAknWindowLineLayout MediaPlayer_cell_elements_Line_1()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_mp_pane_g1();
    return layout1.LayoutLine();    
    }

// LAF Table : Cell pane highlight elements (various)
// C=215 H=p W=p b= l=p r= t=p 
// Remark                    : 
// Parent                    : 
// Parent API                : 
// Scale API match    ( 32%) : grid_highlight_pane_cp01
// Scale parent match (  0%) : 
TAknWindowLineLayout Cell_pane_highlight_elements__various__Line_1(const TRect& /*aParentRect*/)
    {
    // MAN: NOT SUPPORTED (used in calendar)
    return EmptyWindowLayout();    
    }

// LAF Table : Cell pane highlight elements (qdial)
// C=215 H=p W=p b= l=p r= t=p 
// Remark                    : Highlighting graphics.
// Parent                    : cell_qdial_pane
// Parent API                : cell_qdial_pane
// Scale API match    ( 36%) : cell_qdial_pane_g_Limits
// Scale parent match (100%) : cell_qdial_pane
TAknWindowLineLayout Cell_pane_highlight_elements__qdial__Line_1(const TRect& /*aParentRect*/)
    {
    // MAN: NOT SUPPORTED (not used 26.11.2004)
    return EmptyWindowLayout();    
    }

// C=86 H= W= b= l= r= t= 
// Remark                    : Highlight shadow graphics.
// Parent                    : cell_qdial_pane
// Parent API                : cell_qdial_pane
// Scale API match    ( 36%) : cell_qdial_pane_g_Limits
// Scale parent match (100%) : cell_qdial_pane
TAknWindowLineLayout Cell_pane_highlight_elements__qdial__Line_2()
    {
    // MAN: NOT SUPPORTED (not used 26.11.2004)
    return EmptyWindowLayout();
    }

// LAF Table : Browser texts
// B={38, 70, 102, 134, 198, 230, 262, } C={215, 210, , 104} Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=338 l=8 r=6 
// Remark                    : Small plain text small bold text small italic plain text small italic bold text. 8 lines of text.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 50%) : main_browser_pane
// Scale parent match (  0%) : 
TAknTextLineLayout Browser_texts_Line_1(TInt /*aIndex_C*/, TInt /*aIndex_B*/)
    {
    // NOT USED
    return EmptyTextLayout();
    }


// B={40, 76, 112, 148, 184, 220, 256, } C={215, 210, , 104} Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=338 l=8 r=6 
// Remark                    : Normal plain text normal bold text normal italic plain text normal italic bold text. 7 lines of text.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 50%) : main_browser_pane
// Scale parent match (  0%) : 
TAknTextLineLayout Browser_texts_Line_2(TInt /*aIndex_C*/, TInt /*aIndex_B*/)
    {
    // NOT USED
    return EmptyTextLayout();
    }


// B={46, 88, 130, 172, 214, 256} C={215, 210, , 104} Font=qfn_latin_plain_17_Scaled J=ELayoutAlignLeft W=338 l=8 r=6 
// Remark                    : Big plain text big bold text big italic plain text big italic bold text. 6 lines of text.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 50%) : main_browser_pane
// Scale parent match (  0%) : 
TAknTextLineLayout Browser_texts_Line_3(TInt /*aIndex_C*/, TInt /*aIndex_B*/)
    {
    // NOT USED
    return EmptyTextLayout();
    }



// LAF Table : Browser selection box elements
// C=215 H= W= b=4 l=-4 r=4 t=-4 
// Remark                    : Selection list indication i.e. selection box.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 48%) : wml_selection_box_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Browser_selection_box_elements_Line_1()
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// C=215 H= W= b=6 l=-6 r=6 t=-6 
// Remark                    : Highlight box.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 48%) : wml_selection_box_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Browser_selection_box_elements_Line_2()
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// C=221 H=2 W= b= l=4 r=-2 t=2 
// Remark                    : Vertical shadow line. Note: copied from appApac.lay
// Parent                    : 
// Parent API                : 
// Scale API match    ( 48%) : wml_selection_box_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Browser_selection_box_elements_Line_3()
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// C=210 H= W= b= l= r= t= 
// Remark                    : Selection box indication. Included in the fonts. Unicode value E133.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 48%) : wml_selection_box_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Browser_selection_box_elements_Line_4()
    {
    // NOT USED
    return EmptyWindowLayout();
    }


// LAF Table : Browser highlights
// C=222 H={p+4, p+2}[aCommon1] W={p+4, p+2}[aCommon1] b= l=0 r= t=0 
// Remark                    : Shadow. pp_text_space
// Parent                    : 
// Parent API                : 
// Scale API match    ( 47%) : grid_highlight_pane_cp01
// Scale parent match (  0%) : 
TAknWindowLineLayout Browser_highlights_Line_1(const TRect& /*aParentRect*/, TInt /*aCommon1*/)
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// C=244 H={p+6, p+4}[aCommon1] W={p+6, p+4}[aCommon1] b= l=-4 r= t=4 
// Remark                    : Highlight.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 47%) : grid_highlight_pane_cp01
// Scale parent match (  0%) : 
TAknWindowLineLayout Browser_highlights_Line_2(const TRect& /*aParentRect*/, TInt /*aCommon1*/)
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// LAF Table : Browser text link underlining
// C=210 H=2 W={p-2, p-4} b= l=0 r= t= 
// Remark                    : Underline. pp_text_space
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Browser_text_link_underlining_Line_1(const TRect& /*aParentRect*/, TInt /*aIndex_W*/)
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// LAF Table : Browser table frame graphics and highlight
// C=215 H= W= b=0 l=0 r=0 t=0 
// Remark                    : Frames.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Browser_table_frame_graphics_and_highlight_Line_1()
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// C=215 H= W= b=2 l=2 r=2 t=2 
// Remark                    : Highlight.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Browser_table_frame_graphics_and_highlight_Line_2()
    {
    // NOT USED
    return EmptyWindowLayout();
    }


// LAF Table : Browser image frame and highlight
// C={210, 104} H= W= b=4 l=-4 r=4 t=-4 
// Remark                    : Link (an unfocused image).
// Parent                    : 
// Parent API                : 
// Scale API match    ( 28%) : grid_highlight_pane_cp01
// Scale parent match (  0%) : 
TAknWindowLineLayout Browser_image_frame_and_highlight_Line_1(TInt /*aIndex_C*/)
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// C=215 H= W= b=0 l=2 r=0 t=2 
// Remark                    : 1sthighlight rectangle.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 28%) : grid_highlight_pane_cp01
// Scale parent match (  0%) : 
TAknWindowLineLayout Browser_image_frame_and_highlight_Line_2()
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// C=0 H= W= b=2 l=0 r=2 t=0 
// Remark                    : 2ndhighlight rectangle.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 28%) : grid_highlight_pane_cp01
// Scale parent match (  0%) : 
TAknWindowLineLayout Browser_image_frame_and_highlight_Line_3() 
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// LAF Table : Browser broken image
// C=215 H=32 W=340 b= l=-6 r=6 t= 
// Remark                    : Frame.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 42%) : main_browser_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Browser_broken_image_Line_1()
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// C=215 H=36 W=344 b= l=-4 r=4 t= 
// Remark                    : Frame.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 42%) : main_browser_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Browser_broken_image_Line_2()
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// C= H=26 W=26 b= l=6 r= t=4 
// Remark                    : Image not shown indication.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 42%) : main_browser_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Browser_broken_image_Line_3() 
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// LAF Table : Browser broken image text
// B= C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=304 l=38 r=10 
// Remark                    : Image attribute text.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 33%) : main_browser_pane
// Scale parent match (  0%) : 
TAknTextLineLayout Browser_broken_image_text_Line_1() 
    {
    // NOT USED
    return EmptyTextLayout();
    }

// LAF Table : Calendar Day view elements and descendants
// C=221 H=274 W=344 b= l=6 r= t=6 
// Remark                    : Shadow.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Calendar_Day_view_elements_and_descendants_Line_1()
    {
    // MAN: NOT SUPPORTED (shadow)
    return EmptyWindowLayout();
    }

// C=215 H=276 W=346 b= l=2 r= t=2 
// Remark                    : Outline frame. The frame width is one pixel.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Calendar_Day_view_elements_and_descendants_Line_2()
    {
    // MAN: NOT SUPPORTED (rectangle)
    return EmptyWindowLayout();
    }

// C=0 H=272 W=342 b= l=4 r= t=4 
// Remark                    : Inside area.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Calendar_Day_view_elements_and_descendants_Line_3()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_cale_day_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_cale_day_pane();
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::list_cale_pane();
    return DoCompose(layout1, DoCompose(layout2, layout3)).LayoutLine();
    }

// C= H=272 W=342 b= l=4 r= t=4 
// Remark                    : Daily events list.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : list_cale_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout list_cale_pane() 
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_cale_day_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_cale_day_pane();
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::list_cale_pane();
    return DoCompose(layout1, DoCompose(layout2, layout3)).LayoutLine();
    }


// LAF Table : List pane texts (cale time empty)
// B={92, 128} C=215 Font=ELatinBold13_Scaled J=ELayoutAlignCenter W=318 l=14 r=10 
// Remark                    : No datatext.
// Parent                    : list_cale_pane
// Parent API                : list_cale_pane
// Scale API match    ( 50%) : list_cale_time_pane_g_Limits
// Scale parent match (100%) : list_cale_pane
TAknTextLineLayout List_pane_texts__cale_time_empty__Line_1(TInt /*aIndex_B*/)
    {
    // MAN: NOT SUPPORTED (not used 26.11.2004)
    return EmptyTextLayout();
    }

// LAF Table : Calendar Week view elements
// C=221 H=274 W=344 b= l=6 r= t=6 
// Remark                    : Shadow.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Calendar_Week_view_elements_Line_1()
    {
    // MAN: NOT SUPPORTED (shadow)
    return EmptyWindowLayout();
    }

// C=215 H=276 W=346 b= l=2 r= t=2 
// Remark                    : Outline frame. The frame width is one pixel.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Calendar_Week_view_elements_Line_2()
    {
    // MAN: NOT SUPPORTED (rectangle)
    return EmptyWindowLayout();
    }

// C=0 H=272 W=342 b= l=4 r= t=4 
// Remark                    : Inside area.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Calendar_Week_view_elements_Line_3()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_cale_week_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_cale_week_pane();
    TInt varietyIndex = 0;
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::bg_cale_pane_cp01(varietyIndex); // AsM 24082005
    return DoCompose(layout1, DoCompose(layout2, layout3)).LayoutLine();
    }

// C=215 H=272 W=2 b= l=66 r= t=4 
// Remark                    : Vertical line between hours and grid elements.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Calendar_Week_view_elements_Line_4()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_cale_week_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_cale_week_pane();
    TInt varietyIndex = 0;
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::cale_week_scroll_pane_g2(varietyIndex); // AsM 24082005
    return DoCompose(layout1, DoCompose(layout2, layout3)).LayoutLine();
    }

// C=215 H=2 W=342 b= l=4 r= t=36 
// Remark                    : Horizontal line between weekdays and grid elements.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Calendar_Week_view_elements_Line_5()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_cale_week_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_cale_week_pane();
    TInt varietyIndex = 0;
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::cale_week_scroll_pane_g1(varietyIndex); // AsM 24082005
    return DoCompose(layout1, DoCompose(layout2, layout3)).LayoutLine();
    }

// C=219 H=238 W=2 b= l={106, 146, 186, 226, 266, 306} r= t=38 
// Remark                    : Vertical lines between grid elements.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Calendar_Week_view_elements_Line_6(TInt aIndex_l)
    {
    // MAN: DONE
    TInt lineIndex = aIndex_l + 2; 
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_cale_week_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_cale_week_pane();
    TInt varietyIndex = 0;
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::cale_week_scroll_pane_g(lineIndex, varietyIndex); // AsM 24082005
    return DoCompose(layout1, DoCompose(layout2, layout3)).LayoutLine();
    }

// C=219 H=2 W=278 b= l=68 r= t={66, 96, 126, 156, 186, 216, 246} 
// Remark                    : Horizontal lines between grid elements.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Calendar_Week_view_elements_Line_7(TInt aIndex_t)
    {
    // MAN: DONE
    TInt lineIndex = aIndex_t + 8;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_cale_week_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_cale_week_pane();
    TInt varietyIndex = 0;
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::cale_week_scroll_pane_g(lineIndex, varietyIndex); // AsM 24082005
    return DoCompose(layout1, DoCompose(layout2,layout3)).LayoutLine();
    }

// C= H=20 W=2 b= l=66 r= t={38, 256} 
// Remark                    : Events not in view indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Calendar_Week_view_elements_Line_8(TInt /*aIndex_t*/)
    {
    // MAN: NOT SUPPORTED (Scrollbar makes this unnecessary.)    
    return EmptyWindowLayout();
    }

// C= H=238 W=278 b= l=68 r= t=38 
// Remark                    : Daily hours grid.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : grid_cale_week_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout grid_cale_week_pane()
    {
    // MAN :DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_cale_week_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_cale_week_pane();
    TInt varietyIndex = 0;
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::grid_cale_week_pane(varietyIndex); // AsM 24082005
    return DoCompose(layout1, DoCompose(layout2,layout3)).LayoutLine();
    }

// LAF Table : Calendar Week view texts
// B=28 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignCenter W=32 l={72, 112, 152, 192, 232, 272, 312}[aCommon1] r={248, 208, 168, 128, 88, 48, 8}[aCommon1] 
// Remark                    : Day name abbreviations. Seven text elements.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 26%) : main_cale_week_pane
// Scale parent match (  0%) : 
TAknTextLineLayout Calendar_Week_view_texts_Line_1(TInt aCommon1) 
    {
    // MAN: DONE
    TInt lineIndex = aCommon1;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_cale_week_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_cale_week_pane();
    TInt varietyIndex = 0;
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::cale_week_day_heading_pane(varietyIndex); // AsM 24082005
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::cale_week_day_heading_pane_t(lineIndex);
    return DoComposeText(layout1, DoComposeText(layout2,DoComposeText(layout3,textLayout))).LayoutLine();
    }

// B={60, 90, 120, 150, 180, 240, 270} C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignRight W=52 l=10 r=290 
// Remark                    : Hours. Seven text elements.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 26%) : main_cale_week_pane
// Scale parent match (  0%) : 
TAknTextLineLayout Calendar_Week_view_texts_Line_2(TInt aIndex_B) 
    {
    // MAN: DONE
    TInt lineIndex = aIndex_B;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_cale_week_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_cale_week_pane();
    TInt varietyIndex = 0;
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::cale_week_time_pane(varietyIndex); // AsM 24082005
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::cale_week_time_pane_t(lineIndex);
    return DoComposeText(layout1, DoComposeText(layout2,DoComposeText(layout3,textLayout))).LayoutLine();
    }


// LAF Table : Calendar Month view elements
// C=221 H=274 W=344 b= l=6 r= t=6 
// Remark                    : Shadow.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 25%) : main_cale_month_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Calendar_Month_view_elements_Line_1()
    {
    // MAN: NOT SUPPORTED (shadow)
    return EmptyWindowLayout();
    }

// C=215 H=276 W=346 b= l=2 r= t=2 
// Remark                    : Outline frame. The frame width is one pixel.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 25%) : main_cale_month_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Calendar_Month_view_elements_Line_2()
    {
    // MAN: NOT SUPPORTED (rectangle)
    return EmptyWindowLayout();
    }

// C=0 H=272 W=342 b= l=4 r= t=4 
// Remark                    : Inside area.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 25%) : main_cale_month_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Calendar_Month_view_elements_Line_3()
    {
    // MAN: (DONE)
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_cale_month_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::bg_cale_pane_cp02(0);
    return DoCompose(layout1, layout2).LayoutLine();
    }

// C=215 H=272 W=2 b= l=38 r= t=4 
// Remark                    : Vertical line between week numbers and grid elements.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 25%) : main_cale_month_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Calendar_Month_view_elements_Line_4()
    {
    // MAN: (DONE)
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_cale_month_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::cale_month_pane_g2(0);
    return DoCompose(layout1, layout2).LayoutLine();
    }

// C=215 H=2 W=342 b= l=4 r= t=36 
// Remark                    : Horizontal line between weekdays and grid elements.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 25%) : main_cale_month_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Calendar_Month_view_elements_Line_5()
    {
    // MAN: (DONE)
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_cale_month_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::cale_month_pane_g1(0);
    return DoCompose(layout1, layout2).LayoutLine();
    }

// C=219 H=238 W=2 b= l={82, 126, 170, 214, 258, 302, 6, 54, 102, 150, 198, 246, 294, 342} r= t=38 
// Remark                    : Vertical lines between grid elements.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 25%) : main_cale_month_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Calendar_Month_view_elements_Line_6(TInt aIndex_l)
    {
    // MAN: (DONE)
    TInt option = 0;
    TInt index = aIndex_l + 2; // starts at g3
    if (aIndex_l > 5)
        {
        // Week number column is not shown.
        option = 1;
        index -= 6;
        }
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_cale_month_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::cale_month_pane_g(index, option);
    return DoCompose(layout1, layout2).LayoutLine();
    }

// C=219 H=2 W={306, 334}[aCommon1] b= l={40, 8}[aCommon1] r= t={76, 116, 156, 196, 236} 
// Remark                    : Horizontal line between grid elements.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 25%) : main_cale_month_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Calendar_Month_view_elements_Line_7(TInt aCommon1, TInt aIndex_t)
    {
    // MAN: (DONE)
    TInt option = 0;
    if ( aCommon1 == 1 )
        {
        // Week number column is not shown.
        option = 1;
        }
    TInt lineIndex = aIndex_t + 8; // starts at g9
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_cale_month_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::cale_month_pane_g(lineIndex, option);
    return DoCompose(layout1, layout2).LayoutLine();
    }

// C= H=238 W={306, 334}[aCommon1] b= l={40, 8}[aCommon1] r= t=38 
// Remark                    : Monthly days grid.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : grid_cale_month_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout grid_cale_month_pane(TInt aCommon1)
    {
    // MAN: (DONE)
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_cale_month_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::grid_cale_month_pane(aCommon1);
    return DoCompose(layout1, layout2).LayoutLine();
    }


// LAF Table : Calendar Month view texts
// B=28 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignCenter W=32 l={46, 90, 134, 178, 222, 266, 310, 16, 64, 112, 160, 208, 256, 304}[aCommon1] r={274, 230, 186, 142, 98, 54, 10, 304, 256, 208, 160, 112, 64, 16}[aCommon1] 
// Remark                    : Day name abbreviations. Seven text elements.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 29%) : main_cale_month_pane
// Scale parent match (  0%) : 
TAknTextLineLayout Calendar_Month_view_texts_Line_1(TInt aCommon1) 
    {
    // MAN: (DONE)
    /*
    TInt option = 0;
    TInt index = aCommon1;
    if (index > 6)
        {
        // Week number column is not shown.
        option = 1;
        index -= 7;
        }

    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_cale_month_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::cale_month_day_heading_pane(option);
    TAknTextComponentLayout textLine = AknLayoutScalable_Apps::cale_month_day_heading_pane_t(index);
    return DoComposeText(DoCompose(layout1, layout2), textLine).LayoutLine();
    */

    // MAN: Changed 7.6.2005: Layout data v0.9
    TInt option = 0;
    TInt index = aCommon1;
    if (index > 6)
        {
        // Week number column is not shown.
        option = 1;
        index -= 7;
        }

    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_cale_month_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::cale_month_day_heading_pane(option);

    TAknTextComponentLayout textLine;
    if (index == 0)
        {
        textLine = AknLayoutScalable_Apps::cale_month_day_heading_pane_t1(option);
        }
    else if (index == 1)
        {
        textLine = AknLayoutScalable_Apps::cale_month_day_heading_pane_t2(option);
        }
    else if (index == 2)
        {
        textLine = AknLayoutScalable_Apps::cale_month_day_heading_pane_t3(option);
        }
    else if (index == 3)
        {
        textLine = AknLayoutScalable_Apps::cale_month_day_heading_pane_t4(option);
        }
    else if (index == 4)
        {
        textLine = AknLayoutScalable_Apps::cale_month_day_heading_pane_t5(option);
        }
    else if (index == 5)
        {
        textLine = AknLayoutScalable_Apps::cale_month_day_heading_pane_t6(option);
        }
    else if (index == 6)
        {
        textLine = AknLayoutScalable_Apps::cale_month_day_heading_pane_t7(option);
        }
    
    return DoComposeText(DoCompose(layout1, layout2), textLine).LayoutLine();

    }

// B={66, 106, 146, 186, 226, 266} C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignCenter W=24 l=10 r=318 
// Remark                    : Week numbers. Six text elements.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 29%) : main_cale_month_pane
// Scale parent match (  0%) : 
TAknTextLineLayout Calendar_Month_view_texts_Line_2(TInt aIndex_B)
    {
    // MAN: (DONE)
    TInt lineIndex = aIndex_B;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_cale_month_pane();
    TInt varietyIndex = 0;
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::cale_month_week_pane(varietyIndex); // AsM 24082005
    TAknTextComponentLayout textLine = AknLayoutScalable_Apps::cale_month_week_pane_t(lineIndex);
    return DoComposeText(DoCompose(layout1, layout2), textLine).LayoutLine();
    }


// LAF Table : Calculator elements
// C= H=64 W=340 b= l=6 r= t=292 
// Remark                    : Display background image.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Calculator_elements_Line_1()
    {
    // MAN: OK
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_calc_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::calc_display_pane();
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::bg_calc_display_pane();            
    return DoCompose(layout1, DoCompose(layout2, layout3)).LayoutLine(); 
    }
// C= H=260 W=216 b= l=6 r= t=16 
// Remark                    : Paper background image.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 52%) : bg_calc_paper_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout gqn_graf_calc_paper()
    {
    // MAN: OK
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_calc_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::calc_paper_pane();
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::bg_calc_paper_pane();
    return DoCompose(layout1, DoCompose(layout2, layout3)).LayoutLine(); 
    }

// C=107 H=2 W=192 b= l=18 r= t={54, 88, 122, 156, 190, 224} 
// Remark                    : Sum lines on paper.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Calculator_elements_Line_3(TInt aIndex_t)
    {
    // MAN: OK
	TInt rowIndex = aIndex_t;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_calc_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::calc_paper_pane();
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::list_calc_pane();
    TAknWindowComponentLayout layout4 = AknLayoutScalable_Apps::list_calc_item_pane(rowIndex);
    TAknWindowComponentLayout layout5 = AknLayoutScalable_Apps::list_calc_item_pane_g1();
    return DoCompose(layout1, DoCompose(DoCompose(DoCompose(layout2,layout3), layout4),layout5)).LayoutLine();
    }

// C= H=268 W=120 b= l=226 r= t=10 
// Remark                    : Calculator buttons.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : grid_calc_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout grid_calc_pane()
    {
    // MAN: OK
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_calc_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::grid_calc_pane();
    return DoCompose(layout1, layout2).LayoutLine(); 
    }

// LAF Table : Calculator texts
// B=344 C=219 Font=ECalcBold21_Scaled J=ELayoutAlignRight W=242 l=94 r=16 
// Remark                    : Number entry shadow.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Calculator_texts_Line_1() 
    {
    // MAN: NOT SUPPORTED (shadow)
    return EmptyTextLayout();
    }

// B=342 C=210 Font=ECalcBold21_Scaled J=ELayoutAlignRight W=242 l=92 r=18 
// Remark                    : Number entry. Max. eight digits.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Calculator_texts_Line_2()
    {
    // MAN: OK
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_calc_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::calc_display_pane();
    TAknTextComponentLayout  textLine = AknLayoutScalable_Apps::calc_display_pane_t1();
    return DoComposeText(layout1, DoComposeText(layout2,textLine)).LayoutLine();
    }

// B=344 C=219 Font=ECalcOperBold21_Scaled J=ELayoutAlignLeft W=26 l=42 r=284 
// Remark                    : Operator shadow.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Calculator_texts_Line_3()
    {
    // MAN: NOT SUPPORTED (shadow)
    return EmptyTextLayout();
    }

// B=342 C=215 Font=ECalcOperBold21_Scaled J=ELayoutAlignLeft W=26 l=40 r=286 
// Remark                    : Operator entry.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Calculator_texts_Line_4() 
    {
    // MAN: OK
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_calc_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::calc_display_pane();
    TAknTextComponentLayout  textLine = AknLayoutScalable_Apps::calc_display_pane_t2();
    return DoComposeText(layout1, DoComposeText(layout2,textLine)).LayoutLine();
    }

// B=344 C=219 Font=ELatinBold12_Scaled J=ELayoutAlignLeft W=24 l=16 r=312 
// Remark                    : Memory indication shadow.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Calculator_texts_Line_5() 
    {
    // MAN: NOT SUPPORTED (shadow)
    return EmptyTextLayout();
    }

// B=342 C=35 Font=ELatinBold12_Scaled J=ELayoutAlignLeft W=24 l=14 r=314 
// Remark                    : Memory indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Calculator_texts_Line_6()
    {
    // MAN: OK
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_calc_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::calc_display_pane();
    TAknTextComponentLayout  textLine = AknLayoutScalable_Apps::calc_display_pane_t3();
    return DoComposeText(layout1, DoComposeText(layout2,textLine)).LayoutLine();
    }

// B={48, 82, 116, 150, 184, 218, 252} C=215 Font=ELatinBold13_Scaled J=ELayoutAlignRight W=172 l=38 r=142 
// Remark                    : Calculations on paper. Seven lines.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Calculator_texts_Line_7(TInt aIndex_B) 
    {
    // MAN: OK
	TInt rowIndex = aIndex_B;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_calc_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::calc_paper_pane();
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::list_calc_pane();
    TAknWindowComponentLayout layout4 = AknLayoutScalable_Apps::list_calc_item_pane(rowIndex);
    TAknTextComponentLayout  textLine = AknLayoutScalable_Apps::list_calc_item_pane_t1(0);
    return DoComposeText(layout1, DoComposeText(DoCompose(DoCompose(layout2,layout3), layout4),textLine)).LayoutLine();
    }

// B={48, 82, 116, 150, 184, 218, 252} C=215 Font=ECalcOperBold13_Scaled J=ELayoutAlignCenter W=16 l=22 r=314 
// Remark                    : Operators. One operator in a line.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Calculator_texts_Line_8(TInt aIndex_B)
    {
    // MAN: OK
	TInt rowIndex = aIndex_B;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_calc_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::calc_paper_pane();
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::list_calc_pane();
    TAknWindowComponentLayout layout4 = AknLayoutScalable_Apps::list_calc_item_pane(rowIndex);
    TAknTextComponentLayout  textLine = AknLayoutScalable_Apps::list_calc_item_pane_t2(0);
    return DoComposeText(layout1, DoComposeText(DoCompose(DoCompose(layout2,layout3), layout4),textLine)).LayoutLine();
    }

// LAF Table : Real Time Alarm Clock view descendants panes and elements
// C= H=112 W=102 b= l=2 r= t=10 
// Remark                    : Clock.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 68%) : popup_clock_analogue_window_cp02
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_clock__ref__window()
    {
    // MAN: (DONE)
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_clock_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::popup_clock_analogue_window_cp02();
	return DoCompose(layout1,layout2).LayoutLine();
    }

// C=215 H=280 W=2 b= l=104 r= t=0 
// Remark                    : Vertical line.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Real_Time_Alarm_Clock_view_descendants_panes_and_elements_Line_2()
    {    
    // MAN: (DONE)
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_clock_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::bg_list_pane(0);
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Avkon::bg_list_pane_g4(2);
    return DoCompose(DoCompose(layout1, layout2), layout3).LayoutLine();
    }

// C=215 H=2 W=248 b= l=104 r= t=278 
// Remark                    : Horizontal line.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Real_Time_Alarm_Clock_view_descendants_panes_and_elements_Line_3()
    {
    // MAN: (DONE)
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_clock_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::bg_list_pane(0);
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Avkon::bg_list_pane_g5(2);
    return DoCompose(DoCompose(layout1, layout2), layout3).LayoutLine();
    }

// C= H=26 W=26 b= l=320 r= t=24 
// Remark                    : Daylight saving time indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Real_Time_Alarm_Clock_view_descendants_panes_and_elements_Line_4()
    {
    // MAN: (DONE)
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_clock_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::clock_g1();
	return DoCompose(layout1,layout2).LayoutLine();
    }

// C= H=26 W=26 b= l=320 r= t=180 
// Remark                    : Alarm active indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Real_Time_Alarm_Clock_view_descendants_panes_and_elements_Line_5()
    {
    // MAN: (DONE)
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_clock_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::clock_g2();
	return DoCompose(layout1,layout2).LayoutLine();
    }

// LAF Table : Real Time Alarm Clock view texts (skins)
// B=46 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={230, 198}[aCommon1] l=114 r={8, 40}[aCommon1] 
// Remark                    : City or Current timetext.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Real_Time_Alarm_Clock_view_texts__skins__Line_1(TInt aCommon1)
    {
    // MAN: (DONE)
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_clock_pane();
    TAknTextComponentLayout layout2 = AknLayoutScalable_Apps::clock_t1(aCommon1);
    return DoComposeText(layout1, layout2).LayoutLine();
    }

// B={78, 108, 138} C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=222 l=124 r=8 
// Remark                    : Additional information.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Real_Time_Alarm_Clock_view_texts__skins__Line_2(TInt aIndex_B) 
    {
    // MAN: (DONE)
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_clock_pane();
    TAknTextComponentLayout layout2;
    switch (aIndex_B)
        {
        case 0:
        default:
            layout2 = AknLayoutScalable_Apps::clock_t2(0);
            break;
        case 1:
            layout2 = AknLayoutScalable_Apps::clock_t3(0);
            break;
        case 2:
            layout2 = AknLayoutScalable_Apps::clock_t4(0);
            break;
        }
    return DoComposeText(layout1, layout2).LayoutLine();
    }


// B=202 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=230 l=114 r=8 
// Remark                    : Alarmor no alarmtext.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Real_Time_Alarm_Clock_view_texts__skins__Line_3()
    {
    // MAN: (DONE)
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_clock_pane();
    TAknTextComponentLayout layout2 = AknLayoutScalable_Apps::clock_t5(0);
    return DoComposeText(layout1, layout2).LayoutLine();
    }

// B={234, 264} C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=222 l=124 r=8 
// Remark                    : Additional information.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Real_Time_Alarm_Clock_view_texts__skins__Line_4(TInt aIndex_B) 
    {
    // MAN: (DONE)
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_clock_pane();
    TAknTextComponentLayout layout2;
    switch (aIndex_B)
        {
        case 0:
        default:
            layout2 = AknLayoutScalable_Apps::clock_t6(0);
            break;
        case 1:
            layout2 = AknLayoutScalable_Apps::clock_t7(0);
            break;
        }
    return DoComposeText(layout1, layout2).LayoutLine();
    }

// B=202 C=215 Font=ELatinClock14_Scaled J=ELayoutAlignRight W=78 l=14 r=260 
// Remark                    : Alarm time.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Real_Time_Alarm_Clock_view_texts__skins__Line_5() 
    {
    // MAN: (DONE)
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_clock_pane();
    TAknTextComponentLayout layout2 = AknLayoutScalable_Apps::clock_t8(0);
    return DoComposeText(layout1, layout2).LayoutLine();
    }

// B=234 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignRight W=72 l=18 r=262 
// Remark                    : A.m.p.m. indicator.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Real_Time_Alarm_Clock_view_texts__skins__Line_6() 
    {
    // MAN: (DONE)
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_clock_pane();
    TAknTextComponentLayout layout2 = AknLayoutScalable_Apps::clock_t9(0);
    return DoComposeText(layout1, layout2).LayoutLine();
    }


// LAF Table : Clock find pane elements
// C=221 H=42 W=2 b= l=102 r= t=12 
// Remark                    : Vertical shadow inside the find box frame.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 39%) : chi_dic_find_pane_t1
// Scale parent match (  0%) : 
TAknWindowLineLayout Clock_find_pane_elements_Line_1()
    {
    // MAN: NOT SUPPORTED (not used)
    // This has been removed from LAF in A2.1
    return EmptyWindowLayout();
    }

// C=221 H=2 W=244 b= l=104 r= t=12 
// Remark                    : Horizontal shadow inside the find box frame.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 39%) : chi_dic_find_pane_t1
// Scale parent match (  0%) : 
TAknWindowLineLayout Clock_find_pane_elements_Line_2()
    {
    // MAN: NOT SUPPORTED (not used)
    // This has been removed from LAF in A2.1
    return EmptyWindowLayout();
    }

// C=215 H=10 W=2 b= l=100 r= t=0 
// Remark                    : Vertical line extension.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 39%) : chi_dic_find_pane_t1
// Scale parent match (  0%) : 
TAknWindowLineLayout Clock_find_pane_elements_Line_3()
    {
    // MAN: NOT SUPPORTED (not used)
    // This has been removed from LAF in A2.1
    return EmptyWindowLayout();
    }

// C=215 H=46 W=250 b= l=100 r= t=10 
// Remark                    : Outline frame.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 39%) : chi_dic_find_pane_t1
// Scale parent match (  0%) : 
TAknWindowLineLayout Clock_find_pane_elements_Line_4()
    {
    // MAN: NOT SUPPORTED (not used)
    // This has been removed from LAF in A2.1
    return EmptyWindowLayout();
    }

// C= H=52 W=48 b= l=66 r= t=4 
// Remark                    : Magnifying glass icon.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 39%) : chi_dic_find_pane_t1
// Scale parent match (  0%) : 
TAknWindowLineLayout Clock_find_pane_elements_Line_5()
    {
    // MAN: NOT SUPPORTED (not used)
    // This has been removed from LAF in A2.1
    return EmptyWindowLayout();
    }


// LAF Table : Find pane texts
// B=40 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=222 l=120 r=10 
// Remark                    : Search string.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 64%) : find_pinb_pane_t1
// Scale parent match (  0%) : 
TAknTextLineLayout Find_pane_texts_Line_1() 
    {
    // MAN: NOT SUPPORTED (not used)
    // This has been removed from LAF in A2.1
    return EmptyTextLayout();
    }

// LAF Table : Camcorder Still Image Viewfinder descendants and elements
// C= H=264 W=348 b= l=2 r= t=2 
// Remark                    : scaled image from the camera.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 28%) : image_subqcif_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Near_QCIF()
    {
    // MAN: DONE
    // WARNING - very close name clash: Near_QCIF != near_QCIF() 
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_camera_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::image_vga_pane(varietyIndex);
    return DoCompose(layout1, layout2).LayoutLine();
    }

// C=35 H=26 W=26 b= l=288 r= t=234 
// Remark                    : Activated timer indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_2()
    {
    // MAN: DONE
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_camera_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::main_camera_pane_g7(varietyIndex); // activated timer indic
    return DoCompose(layout1, layout2).LayoutLine();
    }

// C=35 H=24 W=22 b= l=14 r= t=8 
// Remark                    : Selected memory type indication
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_3()
    {
    // MAN: DONE
    // Note that this line number is wrong (4th vs 3rd line) in the LAF spec rel 2.6 v4.0.
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_camera_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::main_camera_pane_g1(varietyIndex); // memory type indic 
    return DoCompose(layout1, layout2).LayoutLine();    
    }

// C= H=104 W=30 b= l=320 r= t=8 
// Remark                    : Zooming factor  indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_4()
    {
    // MAN: DONE
    // Note that this line number is wrong in the LAF spec rel 2.6 v4.0.
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_camera_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::cams_zoom_pane(varietyIndex); // zoom pane
    return DoCompose(layout1, layout2).LayoutLine();    
    }

// C=35 H=26 W=26 b= l=14 r= t=234 
// Remark                    : Flash mode  indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_5()
    {
    // MAN: DONE
    // Note that this line number is wrong in the LAF spec rel 2.6 v4.0.
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_camera_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::main_camera_pane_g2(varietyIndex); // flash mode
    return DoCompose(layout1, layout2).LayoutLine();    
    }


// LAF Table : Camcorder Zooming factor pane elements
// C=215 H=104 W=30 b= l=0 r= t=0 
// Remark                    : Zooming scale.
// Parent                    : cams_zoom_pane
// Parent API                : Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_4
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Zooming_factor_pane_elements_Line_1()
    {
    // MAN: DONE
    // Note that it is a bit unsure if the new and old laf can be mapped like this.
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cams_zoom_pane_g2();
    return layout1.LayoutLine();    
    }

// C=215 H=10 W=6 b= l=12 r= t=0 
// Remark                    : Elevator.
// Parent                    : cams_zoom_pane
// Parent API                : Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_4
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Zooming_factor_pane_elements_Line_2()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cams_zoom_pane_g4();
    return layout1.LayoutLine();    
    }


// LAF Table : Camcorder Still Image Viewfinder texts
// B=30 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=284 l=36 r=32 
// Remark                    : Available memory  indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Camcorder_Still_Image_Viewfinder_texts_Line_1()
    {
    // MAN: DONE
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_camera_pane();
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::main_camera_pane_t1(varietyIndex);
    return DoComposeText(layout1, textLayout).LayoutLine();
    }

// B=258 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignRight W=24 l=320 r=8 
// Remark                    : Timer indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Camcorder_Still_Image_Viewfinder_texts_Line_2()
    {
    // MAN: DONE
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_camera_pane();
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::main_camera_pane_t2(varietyIndex); 
    return DoComposeText(layout1, textLayout).LayoutLine();
    }


// LAF Table : Camcorder Video Viewfinder descendants and elements
// C= H=192 W=256 b= l=48 r= t=48 
// Remark                    : SubQCIF Viewfinder  image.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Video_Viewfinder_descendants_and_elements_Line_1()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_video_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::image_subqcif_pane();
    return DoCompose(layout1, layout2).LayoutLine();        
    }

// C= H=286 W=348 b= l=2 r= t=2 
// Remark                    : QCIF Viewfinder  image.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Video_Viewfinder_descendants_and_elements_Line_2()
    {
    // MAN: DONE
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 2 : 0;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_video_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::image_cif_pane(varietyIndex);
    return DoCompose(layout1, layout2).LayoutLine();        
    }

// C={215, 35} H=26 W=26 b= l=40 r= t=260 
// Remark                    : Microphone off  mode indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Video_Viewfinder_descendants_and_elements_Line_3(TInt /*aIndex_C*/)
    {
    // MAN: DONE
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 4 : 0;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_video_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::main_video_pane_g2(varietyIndex);
    return DoCompose(layout1, layout2).LayoutLine();        
    }

// C={215, 35} H=26 W=26 b= l=66 r= t=260 
// Remark                    : Night mode  indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Video_Viewfinder_descendants_and_elements_Line_4(TInt /*aIndex_C*/)
    {
    // MAN: DONE
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 4 : 0;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_video_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::main_video_pane_g3(varietyIndex);
    return DoCompose(layout1, layout2).LayoutLine();        
    }

// C={215, 35} H=26 W=26 b= l=92 r= t=260 
// Remark                    : Color toning  indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Video_Viewfinder_descendants_and_elements_Line_5(TInt /*aCommon1*/)
    {
    // MAN: DONE
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 4 : 0;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_video_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::main_video_pane_g4(varietyIndex);
    return DoCompose(layout1, layout2).LayoutLine();        
    }

// C={215, 35} H=26 W=26 b= l=118 r= t=260 
// Remark                    : White balance  indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Video_Viewfinder_descendants_and_elements_Line_6(TInt /* aIndex_C */)
    {
    // MAN: DONE
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 3 : 0;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_video_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::main_video_pane_g5(varietyIndex);
    return DoCompose(layout1, layout2).LayoutLine();        
    }



// LAF Table : Camcorder Video Recording descendants and elements
// C= H=192 W=256 b= l=48 r= t=48 
// Remark                    : SubQCIF Viewfinder  image.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Video_Recording_descendants_and_elements_Line_1()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_video_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::image_subqcif_pane();
    return DoCompose(layout1, layout2).LayoutLine();        
    }

// C= H=286 W=348 b= l=2 r= t=2 
// Remark                    : QCIF Viewfinder  image.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Video_Recording_descendants_and_elements_Line_2()
    {
    // MAN: DONE
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 2 : 1;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_video_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::image_cif_pane(varietyIndex);
    return DoCompose(layout1, layout2).LayoutLine();        
    }

// C={215, 35} H=26 W=26 b= l=40 r= t=260 
// Remark                    : Microphone off  mode indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Video_Recording_descendants_and_elements_Line_3(TInt /*aIndex_C*/)
    {
    // MAN: DONE
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 4 : 3;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_video_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::main_video_pane_g2(varietyIndex);
    return DoCompose(layout1, layout2).LayoutLine();        
    }

// C={215, 35} H=26 W=26 b= l=66 r= t=260 
// Remark                    : Night mode  indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Video_Recording_descendants_and_elements_Line_4(TInt /*aIndex_C*/) 
    {
    // MAN: DONE
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 4 : 3;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_video_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::main_video_pane_g3(varietyIndex);
    return DoCompose(layout1, layout2).LayoutLine();        
    }

// C={215, 35} H=26 W=26 b= l=92 r= t=260 
// Remark                    : Color toning  indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Video_Recording_descendants_and_elements_Line_5(TInt /*aIndex_C*/) 
    {
    // MAN: DONE
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 4 : 3;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_video_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::main_video_pane_g4(varietyIndex);
    return DoCompose(layout1, layout2).LayoutLine();        
    }

// C={215, 35} H=26 W=26 b= l=118 r= t=260 
// Remark                    : White balance  indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Video_Recording_descendants_and_elements_Line_6(TInt /* aIndex_C */) 
    {
    // MAN: DONE
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 3 : 2;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_video_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::main_video_pane_g5(varietyIndex);
    return DoCompose(layout1, layout2).LayoutLine();        
    }


// LAF Table : Camcorder Duration texts
// B=24 C=0 Font=ELatinPlain12_Scaled J=ELayoutAlignRight W=222 l=10 r=8 
// Remark                    : Timer indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Camcorder_Duration_texts_Line_1() 
    {
    // MAN: DONE but uses mediaplayers layout
    return AknLayoutScalable_Apps::navi_pane_mp_t1().LayoutLine();
    }

// LAF Table : Camcorder Post Recording elements
// C= H=240 W=320 b= l=16 r= t=24 
// Remark                    : QVGA image.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 50%) : image_vga_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout QVGA() 
    {
    // MAN: NOT SUPPORTED (not used 26.11.2004)
    return EmptyWindowLayout();
    }

// C= H=192 W=256 b= l=48 r= t=48 
// Remark                    : SubQCIF video.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Video_Post_recording_elements_Line_2()
    {
    return Camcorder_Video_Viewfinder_descendants_and_elements_Line_1();
    }

// C= H=286 W=348 b= l=2 r= t=2 
// Remark                    : QCIF video.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Video_Post_recording_elements_Line_3()
    {
    return Camcorder_Video_Viewfinder_descendants_and_elements_Line_2();
    }


// LAF Table : Graphical message selection layout elements
// C=219 H=2 W=326 b= l=14 r= t={2, 72, 142, 212, 282} 
// Remark                    : Horizontal lines between the cells.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Graphical_message_selection_layout_elements_Line_1(TInt /*aIndex_t*/)
    {
    // MAN: DONE but only index 0 is supported
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_graph_messa_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_gms_pane_g1();
    return DoCompose(layout1, layout2).LayoutLine(); 
    }

// C=219 H=278 W=2 b= l={14, 176, 338} r= t=4 
// Remark                    : Vertical lines between the cells.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Graphical_message_selection_layout_elements_Line_2(TInt /*aIndex_l*/)
    {
    // MAN: DONE but only index 0 is supported
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_graph_messa_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_gms_pane_g2();
    return DoCompose(layout1, layout2).LayoutLine(); 
    }

// C= H=278 W=322 b= l=16 r= t=4 
// Remark                    : Picture message selection grid.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : grid_gms_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout grid_gms_pane()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_graph_messa_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_gms_pane();
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::grid_gms_pane();
    return DoCompose(layout1, DoCompose(layout2, layout3)).LayoutLine(); 
    }

// LAF Table : Help texts
// B={42, 74, 106, 138, 170, 202, 266} C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=334 l=8 r=10 
// Remark                    : Help item text.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 33%) : main_help_pane
// Scale parent match (  0%) : 
TAknTextLineLayout Help_texts_Line_1(TInt aIndex_B) 
    {
    // MAN: DONE
	TInt rowIndex = aIndex_B;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_help_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_help_pane();
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::list_help_pane();
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::help_list_pane_t1(rowIndex);    
    return DoComposeText(layout1, DoComposeText(layout2, DoComposeText(layout3, textLayout))).LayoutLine(); 
    }
    
// LAF Table : Phonebook Photo view elements
// C=221 H=284 W=346 b= l=4 r= t=4 
// Remark                    : Shadow.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Phonebook_Photo_view_elements_Line_1()
    {
    // MAN: NOT SUPPORTED This has been removed from LAF specs (rel2.6 v1.0)
    TAknWindowLineLayout line = AknLayoutScalable_Apps::Screen().LayoutLine(); // NOT IMPLEMENTED
    return line;
    }

// C= H=284 W=346 b= l=2 r= t=2 
// Remark                    : QQCIF image (176x144).
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Phonebook_Photo_view_elements_Line_2() 
    {
    // MAN: NOT SUPPORTED This has been removed from LAF specs (rel2.6 v1.0)
    TAknWindowLineLayout line = AknLayoutScalable_Apps::Screen().LayoutLine(); // NOT IMPLEMENTED
    return line;
    }

// C=221 H=238 W=318 b= l=20 r= t=28 
// Remark                    : Shadow.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Phonebook_Photo_view_elements_Line_3() 
    {
    // MAN: NOT SUPPORTED This has been removed from LAF specs (rel2.6 v1.0)
    TAknWindowLineLayout line = AknLayoutScalable_Apps::Screen().LayoutLine(); // NOT IMPLEMENTED
    return line;
    }

// C= H=240 W=320 b= l=16 r= t=24 
// Remark                    : 116 VGA image (160x120).
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Phonebook_Photo_view_elements_Line_4()
    {
    // MAN: NOT SUPPORTED This has been removed from LAF specs (rel2.6 v1.0)
    TAknWindowLineLayout line = AknLayoutScalable_Apps::Screen().LayoutLine(); // NOT IMPLEMENTED
    return line;
    }

// C=221 H=190 W=158 b= l=100 r= t=52 
// Remark                    : Shadow.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Phonebook_Photo_view_elements_Line_5()
    {
    // MAN: NOT SUPPORTED This has been removed from LAF specs (rel2.6 v1.0)
    TAknWindowLineLayout line = AknLayoutScalable_Apps::Screen().LayoutLine(); // NOT IMPLEMENTED
    return line;
    }

// C= H=192 W=160 b= l=96 r= t=48 
// Remark                    : Personal image (80x96).
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Phonebook_Photo_view_elements_Line_6()
    {
    // MAN: NOT SUPPORTED This has been removed from LAF specs (rel2.6 v1.0)
    TAknWindowLineLayout line = AknLayoutScalable_Apps::Screen().LayoutLine(); // NOT IMPLEMENTED
    return line;
    }

// C= H= W= b= l=-2 r= t=-2 
// Remark                    : Shadow for any other size.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Phonebook_Photo_view_elements_Line_7()
    {
    // MAN: NOT SUPPORTED This has been removed from LAF specs (rel2.6 v1.0)
    TAknWindowLineLayout line = AknLayoutScalable_Apps::Screen().LayoutLine(); // NOT IMPLEMENTED
    return line;
    }

// C= H=284 W=346 b= l= r= t= 
// Remark                    : Any other size.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Phonebook_Photo_view_elements_Line_8()
    {
    // MAN: NOT SUPPORTED This has been removed from LAF specs (rel2.6 v1.0)
    TAknWindowLineLayout line = AknLayoutScalable_Apps::Screen().LayoutLine(); // NOT IMPLEMENTED
    return line;
    }


// LAF Table : Presence status list components
// C= H=26 W=26 b= l=308 r=18 t=14 
// Remark                    : Icon place A
// Parent                    : 
// Parent API                : 
// Scale API match    ( 30%) : phob_pre_status_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout Presence_status_list_components_Line_1()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_phob_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::phob_pre_status_pane_g1();
    return DoCompose(layout1, layout2).LayoutLine(); 
    }

// C= H=26 W=26 b= l=278 r=48 t=14 
// Remark                    : Icon place B
// Parent                    : 
// Parent API                : 
// Scale API match    ( 30%) : phob_pre_status_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout Presence_status_list_components_Line_2()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_phob_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::phob_pre_status_pane_g2();
    return DoCompose(layout1, layout2).LayoutLine(); 
    }

// C= H=26 W=26 b= l=246 r= t=14 
// Remark                    : Icon place C
// Parent                    : 
// Parent API                : 
// Scale API match    ( 30%) : phob_pre_status_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout Presence_status_list_components_Line_3()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_phob_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::phob_pre_status_pane_g3();
    return DoCompose(layout1, layout2).LayoutLine(); 
    }

// C= H=120 W=200 b= l=76 r= t=50 
// Remark                    : User defined image or default status graphic
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout image_or_qgn_prop_dyc_big__ref_() 
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_phob_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::phob_pre_status_pane_g4();
    return DoCompose(layout1, layout2).LayoutLine(); 
    }

// LAF Table : Presence status list texts
// B={206, 234, 262} C=215 Font=ELatinBold12_Scaled J=ELayoutAlignCenter W=316 l=18 r=18 
// Remark                    : Optional text maximum three (3) lines of text
// Parent                    : 
// Parent API                : 
// Scale API match    ( 36%) : phob_pre_status_pane_g_Limits
// Scale parent match (  0%) : 
TAknTextLineLayout Presence_status_list_texts_Line_1(TInt aIndex_B) 
    {
    // MAN: DONE
    TInt lineIndex = aIndex_B;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_phob_pane();
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::phob_pre_status_pane_t(lineIndex);
    return DoComposeText(layout1, textLayout).LayoutLine(); 
    }


// LAF Table : Pinboard elements (grid)
// C=221 H=362 W=344 b= l=6 r= t=6 
// Remark                    : Shadow.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Pinboard_elements__grid__Line_1()
    {
    // MAN: NOT SUPPORTED (shadows)
    return EmptyWindowLayout();
    }

// C=215 H=364 W=346 b= l=2 r= t=2 
// Remark                    : Outer frame.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Pinboard_elements__grid__Line_2()
    {
    // MAN: NOT SUPPORTED (shadows)
    return EmptyWindowLayout();
    }

// C=0 H=360 W=342 b= l=4 r= t=4 
// Remark                    : Pinboard inside.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Pinboard_elements__grid__Line_3() 
    {
    // MAN: NOT SUPPORTED (shadows)
    return EmptyWindowLayout();
    }

// C=137 H={2, 354}[aCommon1] W={336, 2}[aCommon1] b= l=6 r= t={6, 8}[aCommon1] 
// Remark                    : Upper and left inside border.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Pinboard_elements__grid__Line_4(TInt /*aCommon1*/)
    {
    // MAN: NOT SUPPORTED (shadows)
    return EmptyWindowLayout();
    }

// C=94 H=360 W=342 b= l=4 r= t=4 
// Remark                    : Middle border.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Pinboard_elements__grid__Line_5()
    {
    // MAN: NOT SUPPORTED (shadows)
    return EmptyWindowLayout();
    }

// C=51 H={2, 354}[aCommon1] W={336, 2}[aCommon1] b= l={8, 342}[aCommon1] r= t={360, 6}[aCommon1] 
// Remark                    : Lower and right inside border.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Pinboard_elements__grid__Line_6(TInt /*aCommon1*/)
    {
    // MAN: NOT SUPPORTED (shadows)
    return EmptyWindowLayout();
    }

// C= H=290 W=330 b= l=10 r= t=10 
// Remark                    : Pinboard item grid.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Pinboard_elements__grid__Line_7()
    {
    // MAN: OK
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_pinb_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_pinb_pane(0);
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::grid_pinb_pane();
    return DoCompose(layout1, DoCompose(layout2,layout3)).LayoutLine();
    }

// C= H=58 W=330 b= l=10 r= t=300 
// Remark                    : Pinboard title or find box.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : find_pinb_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout find_pinb_pane()
    {
    // MAN: OK
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_pinb_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::find_pinb_pane();
    return DoCompose(layout1, layout2).LayoutLine();
    }



// LAF Table : Find pane elements (pinb)
// C=221 H=38 W=2 b= l=40 r= t=12 
// Remark                    : Vertical shadow inside the find box frame.
// Parent                    : find_pinb_pane
// Parent API                : find_pinb_pane
// Scale API match    ( 46%) : find_pinb_pane_t_Limits
// Scale parent match (100%) : find_pinb_pane
TAknWindowLineLayout Find_pane_elements__pinb__Line_1()
    {
    // MAN: NOT SUPPORTED (shadows)
    return EmptyWindowLayout();
    }

// C=221 H=2 W=280 b= l=42 r= t=12 
// Remark                    : Horizontal shadow inside the find box frame.
// Parent                    : find_pinb_pane
// Parent API                : find_pinb_pane
// Scale API match    ( 46%) : find_pinb_pane_t_Limits
// Scale parent match (100%) : find_pinb_pane
TAknWindowLineLayout Find_pane_elements__pinb__Line_2()
    {
    // MAN: NOT SUPPORTED (shadows)
    return EmptyWindowLayout();
    }

// C=215 H=42 W=286 b= l=38 r= t=10 
// Remark                    : Outline frame.
// Parent                    : find_pinb_pane
// Parent API                : find_pinb_pane
// Scale API match    ( 46%) : find_pinb_pane_t_Limits
// Scale parent match (100%) : find_pinb_pane
TAknWindowLineLayout Find_pane_elements__pinb__Line_3()
    {
    // MAN: OK
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::input_focus_pane_cp01(0);
    return layout1.LayoutLine();
    }

// C= H=52 W=48 b= l=4 r= t=4 
// Remark                    : Magnifying glass indication or item title indication.
// Parent                    : find_pinb_pane
// Parent API                : find_pinb_pane
// Scale API match    ( 46%) : find_pinb_pane_t_Limits
// Scale parent match (100%) : find_pinb_pane
TAknWindowLineLayout Find_pane_elements__pinb__Line_4()
    {
    // MAN: OK
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::find_pinb_pane_g1(0);
    return layout1.LayoutLine();
    }


// LAF Table : Find pane texts (pinb)
// B=40 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=258 l=58 r=14 
// Remark                    : Item title text.
// Parent                    : find_pinb_pane
// Parent API                : find_pinb_pane
// Scale API match    ( 55%) : find_pinb_pane_t_Limits
// Scale parent match (100%) : find_pinb_pane
TAknTextLineLayout Find_pane_texts__pinb__Line_1() 
    {
    // MAN: OK
    TAknTextComponentLayout layout1 = AknLayoutScalable_Apps::find_pinb_pane_t1(0);
    return layout1.LayoutLine();
    }

// B=40 C=215 Font=gfn_latin_bold_13_Scaled J=ELayoutAlignLeft W=258 l=58 r=14 
// Remark                    : Search string.
// Parent                    : find_pinb_pane
// Parent API                : find_pinb_pane
// Scale API match    ( 55%) : find_pinb_pane_t_Limits
// Scale parent match (100%) : find_pinb_pane
TAknTextLineLayout Find_pane_texts__pinb__Line_2() 
    {
    // MAN: OK
    TInt varietyIndex = Layout_Meta_Data::IsAPAC() ? 1 : 0; // AsM 27.06.2005
    TAknTextComponentLayout layout1 = AknLayoutScalable_Apps::find_pinb_pane_t2(varietyIndex);
    return layout1.LayoutLine();
    }


// LAF Table : Pinboard elements (list)
// C=221 H=362 W=344 b= l=6 r= t=6 
// Remark                    : Shadow.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 27%) : list_pinb_item_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout Pinboard_elements__list__Line_1()
    {
    // MAN: NOT SUPPORTED (shadows)
    return EmptyWindowLayout();
    }

// C=215 H=364 W=346 b= l=2 r= t=2 
// Remark                    : Outer frame.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 27%) : list_pinb_item_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout Pinboard_elements__list__Line_2()
    {
    // MAN: NOT SUPPORTED (shadows)
    return EmptyWindowLayout();
    }

// C=0 H=360 W=342 b= l=4 r= t=4 
// Remark                    : Pinboard inside.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 27%) : list_pinb_item_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout Pinboard_elements__list__Line_3()
    {
    // MAN: NOT SUPPORTED (shadows)
    return EmptyWindowLayout();
    }

// C=137 H={2, 354}[aCommon1] W={336, 2}[aCommon1] b= l=6 r= t={6, 8}[aCommon1] 
// Remark                    : Upper and left inside border.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 27%) : list_pinb_item_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout Pinboard_elements__list__Line_4(TInt /*aCommon1*/)
    {
    // MAN: NOT SUPPORTED (shadows)
    return EmptyWindowLayout();
    }

// C=94 H=360 W=342 b= l=4 r= t=4 
// Remark                    : Middle border.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 27%) : list_pinb_item_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout Pinboard_elements__list__Line_5()
    {
    // MAN: NOT SUPPORTED (shadows)
    return EmptyWindowLayout();
    }

// C=51 H={2, 354}[aCommon1] W={336, 2}[aCommon1] b= l={8, 342}[aCommon1] r= t={360, 6}[aCommon1] 
// Remark                    : Lower and right inside border.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 27%) : list_pinb_item_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout Pinboard_elements__list__Line_6(TInt /*aCommon1*/)
    {
    // MAN: NOT SUPPORTED (shadows)
    return EmptyWindowLayout();
    }

// C= H=348 W=334 b= l=8 r= t=10 
// Remark                    : Pinboard item list.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : list_pinb_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout list_pinb_pane() 
    {
    // MAN: OK
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_pinb_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_pinb_pane(1);
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::list_pinb_pane();
    return DoCompose(layout1, DoCompose(layout2,layout3)).LayoutLine();
    }


// LAF Table : Speed Dial descendants
// C= H=360 W=348 b= l=2 r= t=2 
// Remark                    : Speed Dial grid.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Speed_Dial_descendants_Line_1()
    {
    // MAN: OK
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_qdial_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::grid_qdial_pane();
    return DoCompose(layout1, layout2).LayoutLine();
    }

// LAF Table : Voice Recorder elements
// C= H=260 W=68 b= l=18 r= t=8 
// Remark                    : Recorder function buttons.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : grid_vorec_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout grid_vorec_pane()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_vorec_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::grid_vorec_pane();
    return DoCompose(layout1, layout2).LayoutLine();
    }

// C=215 H=280 W=2 b= l=100 r= t=0 
// Remark                    : Vertical line between the AB and C columns.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Voice_Recorder_elements_Line_2() 
    {
    // MAN: NOT SUPPORTED (line)
    return EmptyWindowLayout();
    }

// C=215 H=2 W=248 b= l=102 r= t=278 
// Remark                    : Horizontal line at the bottom of the pane.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Voice_Recorder_elements_Line_3()
    {
    // MAN: NOT SUPPORTED (line)
    return EmptyWindowLayout();
    }

// C= H=20 W=228 b= l=114 r= t=242 
// Remark                    : Animation background graphics.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Voice_Recorder_elements_Line_4()
    {
    // MAN: DONE
    // NOTE: There is no spearate panes for this (Line_5) and Line_4 as in old LAF has.
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_vorec_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::wait_bar_pane_cp01();
    return DoCompose(layout1, layout2).LayoutLine();
    }

// C= H=16 W=226 b= l=114 r= t=242 
// Remark                    : Progress bar animation.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Voice_Recorder_elements_Line_5()
    {
    // MAN: DONE
    // NOTE: There is no spearate panes for this (Line_5) and Line_4 as in old LAF has.
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_vorec_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::wait_bar_pane_cp01();
    return DoCompose(layout1, layout2).LayoutLine();
    }


// LAF Table : Voice Recorder texts
// B=46 C=215 Font=gfn_latin_bold_13_Scaled J=ELayoutAlignLeft W=228 l=114 r=10 
// Remark                    : Item title.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Voice_Recorder_texts_Line_1()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_vorec_pane();
    TAknTextComponentLayout textLine = AknLayoutScalable_Apps::vorec_t1();
    return DoComposeText(layout1, textLine).LayoutLine();
    }

// B=78 C=215 Font=gfn_latin_plain_12_Scaled J=ELayoutAlignLeft W=218 l=124 r=10 
// Remark                    : Additional item information.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Voice_Recorder_texts_Line_2() 
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_vorec_pane();
    TAknTextComponentLayout textLine = AknLayoutScalable_Apps::vorec_t2();
    return DoComposeText(layout1, textLine).LayoutLine();
    }

// B=108 C=215 Font=gfn_latin_plain_12_Scaled J=ELayoutAlignLeft W=218 l=124 r=10 
// Remark                    : Additional item information.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Voice_Recorder_texts_Line_3() 
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_vorec_pane();
    TAknTextComponentLayout textLine = AknLayoutScalable_Apps::vorec_t3();
    return DoComposeText(layout1, textLine).LayoutLine();
    }

// B=196 C=35 Font=gfn_latin_bold_13_Scaled J=ELayoutAlignLeft W=228 l=114 r=10 
// Remark                    : State indication e.g. Recording Paused.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Voice_Recorder_texts_Line_4()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_vorec_pane();
    TAknTextComponentLayout textLine = AknLayoutScalable_Apps::vorec_t4();
    return DoComposeText(layout1, textLine).LayoutLine();
    }

// B=230 C=215 Font=gfn_latin_plain_12_Scaled J=ELayoutAlignLeft W=36 l=116 r=200 
// Remark                    : Progress bar minimum value.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Voice_Recorder_texts_Line_5()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_vorec_pane();
    TAknTextComponentLayout textLine = AknLayoutScalable_Apps::vorec_t6(); // note 6
    return DoComposeText(layout1, textLine).LayoutLine();
    }

// B=230 C=215 Font=gfn_latin_plain_12_Scaled J=ELayoutAlignRight W=36 l=308 r=8 
// Remark                    : Progress bar maximum value.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Voice_Recorder_texts_Line_6()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_vorec_pane();
    TAknTextComponentLayout textLine = AknLayoutScalable_Apps::vorec_t5(); // note 5
    return DoComposeText(layout1, textLine).LayoutLine();
    }


// LAF Table : Message writing texts
// B={36, 70, 104, 138, 172, 206, 240, 274} C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignRight W=88 l=6 r=258 
// Remark                    : Heading text (i.e. label).
// Parent                    : 
// Parent API                : 
// Scale API match    ( 35%) : popup_dyc_status_message_window
// Scale parent match (  0%) : 
TAknTextLineLayout Message_writing_texts_Line_1(TInt /*aIndex_B*/)
    {
    // MAN: DONE but check the used options
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_messa_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_mce_pane();
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::mce_header_pane(0);
    TAknWindowComponentLayout layout4 = AknLayoutScalable_Apps::mce_header_field_pane(0);
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::mce_header_field_pane_t1();
    
    return DoComposeText(layout1, DoComposeText(layout2,DoComposeText(layout3,DoComposeText(layout4,textLayout)))).LayoutLine();
    }


// B={36, 70, 104, 138, 172, 206, 240, 274} C=215 Font=ELatinBold12_Scaled J=ELayoutAlignLeft W=232 l=112 r=8 
// Remark                    : Entered header information i.e. To or Cc recipients subject.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 35%) : popup_dyc_status_message_window
// Scale parent match (  0%) : 
TAknTextLineLayout Message_writing_texts_Line_2(TInt aIndex_B)
    {
    // MAN: DONE but check the used options
	TInt rowIndex = aIndex_B;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_messa_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_mce_pane();
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::mce_header_pane(0);
    TAknWindowComponentLayout layout4 = AknLayoutScalable_Apps::mce_header_field_pane(0);
    TAknWindowComponentLayout layout5 = AknLayoutScalable_Apps::list_header_data_pane();
    TAknWindowComponentLayout layout6 = AknLayoutScalable_Apps::list_single_mce_header_pane(rowIndex);
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::list_single_mce_header_pane_t1();    
    return DoComposeText(layout1, DoComposeText(layout2,DoComposeText(layout3,DoComposeText(layout4,DoComposeText(layout5,DoComposeText(layout6, textLayout)))))).LayoutLine();
    }


// B={36, 70, 104, 138, 172, 206, 240, 274} C=215 Font=ELatinBold12_Scaled J=ELayoutAlignLeft W=342 l=6 r=4 
// Remark                    : Message text.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 35%) : popup_dyc_status_message_window
// Scale parent match (  0%) : 
TAknTextLineLayout Message_writing_texts_Line_3(TInt aIndex_B)
    {
    // MAN: DONE
	TInt rowIndex = aIndex_B;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_messa_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_mce_pane();
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::mce_text_pane(0);    
    TAknWindowComponentLayout layout4 = AknLayoutScalable_Apps::list_single_mce_message_pane(rowIndex);
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::list_single_mce_message_pane_t1();
    return DoComposeText(layout1, DoComposeText(layout2,DoComposeText(layout3,DoComposeText(layout4,textLayout)))).LayoutLine();
    }

// LAF Table : Smart Messages
// B={38, 72, 106, 140, 174, 208, 242, 276} C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=342 l=6 r=4 
// Remark                    : Message heading.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 46%) : popup_dyc_status_message_window
// Scale parent match (  0%) : 
TAknTextLineLayout Smart_Messages_Line_1(TInt aIndex_B) 
    {
    // MAN: DONE
	TInt rowIndex = aIndex_B;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_messa_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_mce_pane();
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::mce_text_pane(0);    
    TAknWindowComponentLayout layout4 = AknLayoutScalable_Apps::list_single_mce_smart_pane(1, rowIndex); // should be no varieties, bug in layout data [LMB 28/11/2004]
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::list_single_mce_smart_pane_t1(0); // should be no varieties, bug in layout data [LMB 28/11/2004]
    
    return DoComposeText(layout1, DoComposeText(layout2,DoComposeText(layout3,DoComposeText(layout4,textLayout)))).LayoutLine();
    }


// B={38, 72, 106, 140, 174, 208, 242, 276} C=215 Font=ELatinBold12_Scaled J=ELayoutAlignLeft W=342 l=6 r=4 
// Remark                    : Message text.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 46%) : popup_dyc_status_message_window
// Scale parent match (  0%) : 
TAknTextLineLayout Smart_Messages_Line_2(TInt aIndex_B) 
    {
    // MAN: DONE
	TInt rowIndex = aIndex_B;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_messa_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_mce_pane();
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::mce_text_pane(0);    
    TAknWindowComponentLayout layout4 = AknLayoutScalable_Apps::list_single_mce_smart_pane(1, rowIndex); // should be no varieties, bug in layout data [LMB 28/11/2004]
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::list_single_mce_smart_pane_t2(1); // should be no varieties, bug in layout data [LMB 28/11/2004]
    return DoComposeText(layout1, DoComposeText(layout2,DoComposeText(layout3,DoComposeText(layout4,textLayout)))).LayoutLine();
    }

// LAF Table : Note writing layout elements
// C=221 H=246 W=344 b= l=6 r= t=32 
// Remark                    : Shadow.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 25%) : im_writing_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Note_writing_layout_elements_Line_1()
    {
    // MAN: NOT SUPPORTED (not used)
    return EmptyWindowLayout();
    }

// C=215 H=246 W=346 b= l=2 r= t=30 
// Remark                    : Outline frame. The outline width is one pixel.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 25%) : im_writing_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Note_writing_layout_elements_Line_2()
    {
    // MAN: DONE 
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_notes_pane(); 
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::bg_notes_pane(); 
    return DoCompose(layout1, layout2).LayoutLine();
    }

// C=1 H=242 W=342 b= l=4 r= t=32 
// Remark                    : Inside area.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 25%) : im_writing_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Note_writing_layout_elements_Line_3()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_notes_pane(); 
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::list_notes_pane(); 
    return DoCompose(layout1, layout2).LayoutLine();
    }

// C= H=30 W=352 b= l=2 r= t=2 
// Remark                    : Upper edge graphics.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 25%) : im_writing_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Note_writing_layout_elements_Line_4()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_notes_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::bg_notes_pane();
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::notes_bg_pane_g6();
    return DoCompose(layout1, DoCompose(layout2,layout3)).LayoutLine();
    }

// C=84 H=2 W=326 b= l=10 r= t={32, 70, 108, 146, 184, 222, 260} 
// Remark                    : Paper lines.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 25%) : im_writing_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Note_writing_layout_elements_Line_5(TInt aIndex_t) 
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_notes_pane(); 
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::list_notes_pane(); 
    TAknWindowComponentLayout layout3;
    
    // both options seem to be the same [LMB 28/02/2005]
    // Options have now been removed MAN: 23.5.2005
    TAknWindowComponentLayout layout4 = AknLayoutScalable_Apps::list_notes_text_pane_g1(); 

    if (aIndex_t == 0)
        {
        // New LAF has 6 values, but old has 7. Discard the first one as it
        // does not have corresponding line in new LAF.
        TAknWindowComponentLayout empty;
        layout3 = empty;
        }
    else
        {
        aIndex_t--;
        layout3 = AknLayoutScalable_Apps::list_notes_text_pane(aIndex_t); 
        }

    return DoCompose(layout1, DoCompose(layout2,DoCompose(layout3,layout4))).LayoutLine();
    }


// LAF Table : Note writing texts
// B={60, 98, 136, 174, 212, 248} C=215 Font=ELatinBold13_Scaled J=ELayoutAlignBidi W=324 l=16 r=12 
// Remark                    : Note text.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 41%) : im_writing_pane_ParamLimits
// Scale parent match (  0%) : 
TAknTextLineLayout Note_writing_texts_Line_1(TInt aIndex_B) 
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_notes_pane(); 
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::list_notes_pane(); 
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::list_notes_text_pane(aIndex_B); 
    
    // MAN: 23.5.2005: Options removed.
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::list_notes_text_pane_t1(); 
    return DoComposeText(layout1, DoComposeText(layout2,DoComposeText(layout3,textLayout))).LayoutLine();
    }


// LAF Table : IM chat view descendant panes
// C= H={256, 224, 192} W=348 b= l=2 r= t=6 
// Remark                    : IM message pane.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : im_reading_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout im_reading_pane(TInt aCommon1)
    {
    // MAN: DONE
    // MAN: Fixed 18.3.2005
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_im_pane();
    
    TInt option = 0;
    if (aCommon1 == 0)
        option = 2;
    else if (aCommon1 == 1)
        option = 1;
    else
        option = 0;
    
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::im_reading_pane(option);
    
    return DoCompose(layout1, layout2).LayoutLine();    
    }

// C= H={46, 76}[aCommon1] W=348 b= l=2 r= t={234, 204}[aCommon1] 
// Remark                    : IM writing text.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : im_writing_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout im_writing_pane(TInt aCommon1) 
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_im_pane();

    TInt option = 0;
    if (aCommon1 == 0)
        option = 1;
    else
        option = 0;
    
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::im_writing_pane(option);
    
    return DoCompose(layout1, layout2).LayoutLine();    
    }

// LAF Table : IM navi pane texts
// B=24 C={234, 232, 230, 228, 226, 0, 226, 227, 228, 229} Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W={192, 108} l=40 r=8 
// Remark                    : Fading hint text.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 47%) : list_notes_text_pane_t1
// Scale parent match (  0%) : 
TAknTextLineLayout IM_navi_pane_texts_Line_1(TInt /*aIndex_C*/, TInt /*aIndex_W*/)
    {
    // MAN: DONE but colors are not supported. Maybe app should hard code those or something.
    return AknLayoutScalable_Apps::navi_pane_im_t1().LayoutLine();
    }

// LAF Table : IM reading pane texts
// B=22 C=215 Font=ELatinBold12_Scaled J=ELayoutAlignLeft W={146, 340, 308}[aCommon1] l={36, 4, 36}[aCommon1] r={198, 4, 4}[aCommon1] 
// Remark                    : IM reading field first element nickname or name of the writer.
// Parent                    : im_reading_field
// Parent API                : im_reading_field
// Scale API match    ( 75%) : im_reading_pane_t1
// Scale parent match ( 64%) : im_reading_pane_ParamLimits
TAknTextLineLayout IM_reading_pane_texts_Line_1(TInt aIndex_l)
    {
    // MAN: update 4.4.2005: It looks like IM app uses also other indexes than "0".
	// [LMB 13/04/2005] new varieties present in v0.51, but only variety 2 has a different left value
    TAknTextComponentLayout textLayout;
	TInt varietyIndex = 0;
    if (aIndex_l == 0)
        {
        varietyIndex = 0; // This is ok, but check variety after scalable LAF has been updated
        }
    else if (aIndex_l == 1)
        {
        // extends from _very_ left side to right side
        varietyIndex = 1; // this doesn't seem to be any different to variety 0 in v0.51[LMB 13/04/2005]
        }
    else if (aIndex_l == 2)
        {
        // extends from _intended_ (same as in index 0 case) left side to right side
        varietyIndex = 2;
        }
	textLayout = AknLayoutScalable_Apps::im_reading_pane_t1(varietyIndex); 
    return textLayout.LayoutLine();
    }

// B=22 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=308 l=36 r=4 
// Remark                    : Message text.
// Parent                    : im_reading_field
// Parent API                : im_reading_field
// Scale API match    ( 75%) : im_reading_pane_t1
// Scale parent match ( 64%) : im_reading_pane_ParamLimits
TAknTextLineLayout IM_reading_pane_texts_Line_2()
    {
    // MAN: DONE
    // im_reading_pane_t2 seems to have been replaced with list_single_im_pane_t1 according to the alias field  [LMB 02/02/2005]
	
    // MAN: Fixed 4.4.2005
	TInt varietyIndex = 0; // variety 3 is further to the left, but don't seem to need it here [LMB 13.04.2005]
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::list_im_pane(varietyIndex);
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::list_im_single_pane(0);    
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::list_single_im_pane_t1();
    return DoComposeText(layout1, DoComposeText(layout2, textLayout)).LayoutLine();
    }

TAknWindowLineLayout im_reading_field(TInt aIndex_t)
    {
    // MAN: DONE
	TInt varietyIndex = 0; // variety 3 is further to the left, but don't seem to need it here [LMB 13.04.2005]
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::list_im_pane(varietyIndex);
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::list_im_single_pane(aIndex_t);
    return DoCompose(layout1, layout2).LayoutLine();    
    }

// LAF Table : IM text elements
// C= H=26 W=26 b= l=4 r= t=0 
// Remark                    : Sender indication.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 26%) : list_notes_text_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout IM_text_elements_Line_1() 
    {
    // MAN: DONE
    // MAN: 4.4.2005: This does not work with currewnt layout data at all. Deactivated for now.
    /* 
       TAknWindowComponentLayout layout1 = AknLayoutScalable_Avkon::icon_primary_small_g1();
       return layout1.LayoutLine();
       */
    return EmptyWindowLayout();
    }

// C= H=26 W=26 b= l=2 r= t=0 
// Remark                    : Receiver indication.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 26%) : list_notes_text_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout IM_text_elements_Line_2() 
    {
    // MAN: DONE
    // MAN: 4.4.2005: This does not work with currewnt layout data at all. Deactivated for now.
    /*
       TAknWindowComponentLayout layout1 = AknLayoutScalable_Avkon::icon_primary_small_g1();
       return layout1.LayoutLine();
       */
    return EmptyWindowLayout();
    }

// C= H=26 W=26 b= l=4 r= t=22 
// Remark                    : Smileys.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout smiley__qgn_prop_im_smileys__ref__() 
    {
    // MAN: DONE
    // MAN: 4.4.2005: This does not work with currewnt layout data at all. Deactivated for now.
    /* 
       TAknWindowComponentLayout layout1 = AknLayoutScalable_Avkon::icon_primary_small_g1();
       return layout1.LayoutLine();
       */
    return EmptyWindowLayout();
    }

// LAF Table : IM reading field highlight graphics
// C=222 H=p-4 W=p-4 b= l=4 r= t=4 
// Remark                    : Shadow.
// Parent                    : im_reading_field
// Parent API                : im_reading_field
// Scale API match    ( 29%) : grid_highlight_pane_cp01
// Scale parent match ( 64%) : im_reading_pane_ParamLimits
TAknWindowLineLayout IM_reading_field_highlight_graphics_Line_1(const TRect& /*aParentRect*/)
    {
    // MAN: NOT SUPPORTED (highlight shadow) (used in wvui20)
    return EmptyWindowLayout();
    }

// C=244 H=p-2 W=p-2 b= l=0 r= t=0 
// Remark                    : Highlight.
// Parent                    : im_reading_field
// Parent API                : im_reading_field
// Scale API match    ( 29%) : grid_highlight_pane_cp01
// Scale parent match ( 64%) : im_reading_pane_ParamLimits
TAknWindowLineLayout IM_reading_field_highlight_graphics_Line_2(const TRect& /*aParentRect*/)
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::input_focus_pane_cp04();
    return layout1.LayoutLine();
    }

// LAF Table : IM writing field elements
// C=221 H={40, 70} W=2 b= l=2 r= t=2 
// Remark                    : Vertical shadow inside the editing frame.
// Parent                    : im_writing_pane
// Parent API                : im_writing_pane
// Scale API match    ( 37%) : im_writing_pane_ParamLimits
// Scale parent match (100%) : im_writing_pane
TAknWindowLineLayout IM_writing_field_elements_Line_1(TInt /*aIndex_H*/)
    {
    // MAN: NOT SUPPORTED (line)
    return EmptyWindowLayout();
    }

// C=221 H=2 W=344 b= l=4 r= t=2 
// Remark                    : Horizontal shadow inside the editing frame.
// Parent                    : im_writing_pane
// Parent API                : im_writing_pane
// Scale API match    ( 37%) : im_writing_pane_ParamLimits
// Scale parent match (100%) : im_writing_pane
TAknWindowLineLayout IM_writing_field_elements_Line_2() 
    {
    // MAN: NOT SUPPORTED (line)
    return EmptyWindowLayout();
    }

// C=215 H={46, 76} W=348 b= l=0 r= t=0 
// Remark                    : Outline frame.
// Parent                    : im_writing_pane
// Parent API                : im_writing_pane
// Scale API match    ( 37%) : im_writing_pane_ParamLimits
// Scale parent match (100%) : im_writing_pane
TAknWindowLineLayout IM_writing_field_elements_Line_3(TInt /*aIndex_H*/)
    {
    // MAN: NOT SUPPORTED (line)
    return EmptyWindowLayout();
    }

// LAF Table : IM writing pane texts
// B={28, 60} C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=332 l=10 r=6 
// Remark                    : IM reading field first element nickname or name of the writer and message text
// Parent                    : im_writing_pane
// Parent API                : im_writing_pane
// Scale API match    ( 75%) : im_writing_pane_t1_ParamLimits
// Scale parent match (100%) : im_writing_pane
TAknTextLineLayout IM_writing_pane_texts_Line_1(TInt aIndex_B)
    {
    // MAN: DONE
    TAknTextComponentLayout textLayout;
    
    if (aIndex_B == 0)
        textLayout = AknLayoutScalable_Apps::im_writing_pane_t1(1);
    else
        textLayout = AknLayoutScalable_Apps::im_writing_pane_t2(1);

    return textLayout.LayoutLine();
    }

// LAF Table : Media Player layout descendant pane
// C= H=286 W=348 b= l=2 r= t=2 
// Remark                    : Media Player background pane.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : mp_bg_pane_g1
// Scale parent match (  0%) : 
TAknWindowLineLayout mp_bg_pane() 
    {
    //MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_mp_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::bg_mp_pane();
    return DoCompose(layout1, layout2).LayoutLine();
    }

// LAF Table : Empty Player view elements
// C= H=286 W=348 b= l=0 r= t=0 
// Remark                    : 
// Parent                    : mp_bg_pane
// Parent API                : mp_bg_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : mp_bg_pane_g1
TAknWindowLineLayout Empty_Player_view_elements_Line_1() 
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::mp_bg_pane_g1();
    return layout1.LayoutLine();
    }

// LAF Table : Media Player Playback view navi pane elements
// C= H=32 W=26 b= l=0 r= t=0 
// Remark                    : Shown if the user has paused the clip.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 31%) : media_player_g1
// Scale parent match (  0%) : 
TAknWindowLineLayout Media_Player_Playback_view_navi_pane_elements_Line_1()
    {
    // MAN: DONE
    // MAN: Fixed 25.4.2005
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::navi_pane_mp_g1(1);
    return layout1.LayoutLine();
    }

// C= H=32 W=34 b= l=26 r= t=0 
// Remark                    : Shown if the user has muted the clip.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 31%) : media_player_g1
// Scale parent match (  0%) : 
TAknWindowLineLayout Media_Player_Playback_view_navi_pane_elements_Line_2()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::navi_pane_mp_g2(0);
    return layout1.LayoutLine();
    }


// LAF Table : Media Player Playback view navi pane texts
// B=26 C=0 Font=ELatinBold12_Scaled J=ELayoutAlignRight W=146 l=86 r=8 
// Remark                    : Length of the video or audio clip.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 34%) : media_player_g1
// Scale parent match (  0%) : 
TAknTextLineLayout Media_Player_Playback_view_navi_pane_texts_Line_1()
    {
    // MAN: DONE
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::navi_pane_mp_t1();
    return textLayout.LayoutLine();
    }

// LAF Table : Media Player Playlist navi pane elements
// C= H=32 W=34 b= l=16 r= t=0 
// Remark                    : 
// Parent                    : 
// Parent API                : 
// Scale API match    ( 35%) : media_player_g1
// Scale parent match (  0%) : 
TAknWindowLineLayout Media_Player_Playlist_navi_pane_elements_Line_1()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::navi_pane_mp_g2(0);
    return layout1.LayoutLine();
    }

// C= H=32 W=44 b= l=194 r= t=0 
// Remark                    : 
// Parent                    : 
// Parent API                : 
// Scale API match    ( 35%) : media_player_g1
// Scale parent match (  0%) : 
TAknWindowLineLayout Media_Player_Playlist_navi_pane_elements_Line_2()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::navi_pane_mp_g3(0);
    return layout1.LayoutLine();
    }


// LAF Table : Media Player Playback view  elements
// C= H=276 W=64 b= l=16 r= t=4 
// Remark                    : Function buttons.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : grid_mp_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout grid_mp_pane()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_mp_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::grid_mp_pane();
    return DoCompose(layout1, layout2).LayoutLine();    
    }

// C=215 H=280 W=2 b= l=100 r= t=0 
// Remark                    : Vertical line.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 41%) : media_player_g1
// Scale parent match (  0%) : 
TAknWindowLineLayout Media_Player_Playback_view_elements_Line_2()
    {
    // MAN: NOT SUPPORTED (line) (not used)
    return EmptyWindowLayout();
    }

// C=215 H=2 W=248 b= l=102 r= t=278 
// Remark                    : Horizontal line.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 41%) : media_player_g1
// Scale parent match (  0%) : 
TAknWindowLineLayout Media_Player_Playback_view_elements_Line_3()
    {
    // MAN: NOT SUPPORTED (line) (not used)
    return EmptyWindowLayout();
    }

// C= H=40 W=36 b= l=238 r= t=20 
// Remark                    : Status indicator.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 41%) : media_player_g1
// Scale parent match (  0%) : 
TAknWindowLineLayout Media_Player_Playback_view_elements_Line_4()
    {
    // MAN: DONE    
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_mp_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::media_player_g1();
    return DoCompose(layout1, layout2).LayoutLine();    
    }

// C= H=20 W=228 b= l=114 r= t=242 
// Remark                    : Shadow.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 41%) : media_player_g1
// Scale parent match (  0%) : 
TAknWindowLineLayout Media_Player_Playback_view_elements_Line_5()
    {
    // MAN: DONE
    // TODO: not separate line for shadow exist. Use wait pane instead here...
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_mp_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::wait_bar_pane_cp02();
    return DoCompose(layout1, layout2).LayoutLine();    
    }

// C= H=16 W=226 b= l=114 r= t=242 
// Remark                    : Progress bar indication.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 41%) : media_player_g1
// Scale parent match (  0%) : 
TAknWindowLineLayout Media_Player_Playback_view_elements_Line_6()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_mp_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::wait_bar_pane_cp02();
    return DoCompose(layout1, layout2).LayoutLine();    
    }

// LAF Table : Media Player Playback view texts
// B=60 C=215 Font=ECalcBold21_Scaled J=ELayoutAlignRight W=114 l=114 r=124 
// Remark                    : Duration.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 45%) : media_player_g1
// Scale parent match (  0%) : 
TAknTextLineLayout Media_Player_Playback_view_texts_Line_1()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_mp_pane();
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::media_player_t3();
    return DoComposeText(layout1, textLayout).LayoutLine();
    }

// B=96 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=228 l=114 r=10 
// Remark                    : First item heading.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 45%) : media_player_g1
// Scale parent match (  0%) : 
TAknTextLineLayout Media_Player_Playback_view_texts_Line_2() 
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_mp_pane();
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::media_player_t4();
    return DoComposeText(layout1, textLayout).LayoutLine();
    }

// B=128 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=218 l=124 r=10 
// Remark                    : First item text.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 45%) : media_player_g1
// Scale parent match (  0%) : 
TAknTextLineLayout Media_Player_Playback_view_texts_Line_3()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_mp_pane();
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::media_player_t5();
    return DoComposeText(layout1, textLayout).LayoutLine();
    }

// B=160 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=228 l=114 r=10 
// Remark                    : Second item heading.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 45%) : media_player_g1
// Scale parent match (  0%) : 
TAknTextLineLayout Media_Player_Playback_view_texts_Line_4() 
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_mp_pane();
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::media_player_t6();
    return DoComposeText(layout1, textLayout).LayoutLine();
    }

// B=192 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=218 l=124 r=10 
// Remark                    : Second item text.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 45%) : media_player_g1
// Scale parent match (  0%) : 
TAknTextLineLayout Media_Player_Playback_view_texts_Line_5() 
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_mp_pane();
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::media_player_t7();
    return DoComposeText(layout1, textLayout).LayoutLine();
    }

// B=232 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=68 l=114 r=170 
// Remark                    : Minimum value.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 45%) : media_player_g1
// Scale parent match (  0%) : 
TAknTextLineLayout Media_Player_Playback_view_texts_Line_6() 
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_mp_pane();
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::media_player_t2();
    return DoComposeText(layout1, textLayout).LayoutLine();
    }

// B=232 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignRight W=68 l=274 r=10 
// Remark                    : Maximum value.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 45%) : media_player_g1
// Scale parent match (  0%) : 
TAknTextLineLayout Media_Player_Playback_view_texts_Line_7() 
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_mp_pane();
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::media_player_t1();
    return DoComposeText(layout1, textLayout).LayoutLine();
    }


// LAF Table : SMIL presentation attachment element
// C= H=150 W=140 b= l=100 r= t=90 
// Remark                    : MMS SMIL presentation attachment.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout SMIL_presentation_attachment_element_Line_1()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_messa_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_mce_pane();
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::mce_image_pane_g4();
    return DoCompose(layout1, DoCompose(layout2,layout3)).LayoutLine();    
    }

// LAF Table : SMIL presentation attachment highlight
// C=215 H=60 W=60 b= l=102 r= t=170 
// Remark                    : 1sthighlight rectangle.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout SMIL_presentation_attachment_highlight_Line_1()
    {
    // MAN: NOT SUPPORTED (not used)
    // new scalbale LAF does not seem to specify this. (currently this line is not used in codes)
    return EmptyWindowLayout();
    }

// C=0 H=60 W=60 b= l=100 r= t=168 
// Remark                    : 2ndhighlight rectangle.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout SMIL_presentation_attachment_highlight_Line_2()
    {
    // MAN: NOT SUPPORTED (not used)
    // new scalbale LAF does not seem to specify this. (currently this line is not used in codes)
    return EmptyWindowLayout();
    }


// LAF Table : SMIL presentation elements and descendant panes
// C= H=416 W=352 b= l= r= t= 
// Remark                    : 
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout SMIL_presentation_elements_and_descendant_panes_Line_1()
    {
    // MAN: DONE, the hierarchy is a bit odd here
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_smil_g1();
    return layout1.LayoutLine();    
    }

// C= H=40 W=352 b= l=0 r= t=0 
// Remark                    : 
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : smil_status_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout smil_status_pane()
    {
    // MAN: DONE, the hierarchy is a bit odd here
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::smil_status_pane();
    return layout1.LayoutLine();    
    }

// C= H={40, 54, 80, 120, 160, 200, 240, 280, 320, 374} W=352 b= l= r= t={40, 68, 96, 124, 152, 180, 208, 236, 264, 292, 320, 348, 376} 
// Remark                    : 
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : smil_text_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout smil_text_pane(TInt /*aIndex_t*/, TInt /*aIndex_H*/)
    {
    // MAN: DONE but this ignores indexes always (=returns max value)
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::smil_text_pane(); 
            
    return layout1.LayoutLine();   
    }


// LAF Table : SMIL status pane elements and descendant panes
// C= H=28 W=118 b= l=60 r= t=2 
// Remark                    : Volume indication.
// Parent                    : smil_status_pane
// Parent API                : smil_status_pane
// Scale API match    (100%) : smil_volume_pane_g1
// Scale parent match (100%) : smil_status_pane
TAknWindowLineLayout smil_volume_pane()
    {
    // MAN: DONE
    // MAN: Changed 3.6.2005, layout v0.90
    TAknWindowComponentLayout layout0 = AknLayoutScalable_Apps::smil_status_volume_pane();
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::volume_smil_pane(1); // MAN: Weird, but this has variety "1".
    return DoCompose(layout0, layout1).LayoutLine();    
    }

// C= H=28 W=18 b= l=8 r= t=2 
// Remark                    : Scrolling left possible playback paused playback stopped indication.
// Parent                    : smil_status_pane
// Parent API                : smil_status_pane
// Scale API match    ( 40%) : smil_status_pane_g1
// Scale parent match (100%) : smil_status_pane
TAknWindowLineLayout SMIL_status_pane_elements_and_descendant_panes_Line_2()
    {
    // MAN: DONE
    // MAN: Changed 3.6.2005, layout v0.90
    TAknWindowComponentLayout layout0 = AknLayoutScalable_Apps::smil_status_volume_pane();
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::smil_status_volume_pane_g1();
    return DoCompose(layout0, layout1).LayoutLine();    
    }

// C= H=28 W=18 b= l=178 r= t=2 
// Remark                    : Scrolling right possible indication.
// Parent                    : smil_status_pane
// Parent API                : smil_status_pane
// Scale API match    ( 40%) : smil_status_pane_g1
// Scale parent match (100%) : smil_status_pane
TAknWindowLineLayout SMIL_status_pane_elements_and_descendant_panes_Line_3()
    {
    // MAN: DONE
    // MAN: Changed 3.6.2005, layout v0.90
    TAknWindowComponentLayout layout0 = AknLayoutScalable_Apps::smil_status_volume_pane();
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::smil_status_volume_pane_g2();
    return DoCompose(layout0, layout1).LayoutLine();    
    }

// C= H=28 W=34 b= l=26 r= t=2 
// Remark                    : Speaker earpiece or muted speaker indication.
// Parent                    : smil_status_pane
// Parent API                : smil_status_pane
// Scale API match    ( 40%) : smil_status_pane_g1
// Scale parent match (100%) : smil_status_pane
TAknWindowLineLayout SMIL_status_pane_elements_and_descendant_panes_Line_4()
    {
    // MAN: DONE
    // MAN: Changed 3.6.2005, layout v0.90
    TAknWindowComponentLayout layout0 = AknLayoutScalable_Apps::smil_status_volume_pane();
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::smil_status_volume_pane_g3();
    return DoCompose(layout0, layout1).LayoutLine();    
    }


// LAF Table : SMIL status pane texts
// B=28 C=43 Font=ELatinPlain12_Scaled J=ELayoutAlignRight W=112 l=232 r=8 
// Remark                    : Time elapsed total time.
// Parent                    : smil_status_pane
// Parent API                : smil_status_pane
// Scale API match    ( 76%) : smil_status_pane_t1
// Scale parent match (100%) : smil_status_pane
TAknTextLineLayout SMIL_status_pane_texts_Line_1() 
    {
    // MAN: DONE
    TAknTextComponentLayout layout1 = AknLayoutScalable_Apps::smil_status_pane_t1();
    return layout1.LayoutLine();    
    }

// LAF Table : SMIL volume pane elements
// C= H=28 W=118 b= l=0 r= t=0 
// Remark                    : Passive volume indication.
// Parent                    : smil_volume_pane
// Parent API                : smil_volume_pane
// Scale API match    ( 62%) : smil_volume_pane_g1
// Scale parent match (100%) : smil_volume_pane_g1
TAknWindowLineLayout SMIL_volume_pane_elements_Line_1() 
    {
    // MAN: DONE
    // MAN: Changed 3.6.2005, layout v0.90
    TAknWindowComponentLayout layout0 = AknLayoutScalable_Apps::smil_status_volume_pane();
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::smil_status_volume_pane_g1();
    return DoCompose(layout0, layout1).LayoutLine();    
    }

// C= H=28 W= b= l=0 r= t=0 
// Remark                    : Active volume indication.
// Parent                    : smil_volume_pane
// Parent API                : smil_volume_pane
// Scale API match    ( 62%) : smil_volume_pane_g1
// Scale parent match (100%) : smil_volume_pane_g1
TAknWindowLineLayout SMIL_volume_pane_elements_Line_2()
    {
    // MAN: DONE
    // MAN: Changed 3.6.2005, layout v0.90
    TAknWindowComponentLayout layout0 = AknLayoutScalable_Apps::smil_status_volume_pane();
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::smil_status_volume_pane_g2();
    return DoCompose(layout0, layout1).LayoutLine();    
    }


// B={54, 60, 92} C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W={306, 296}[aCommon1] l=16 r={10, 24}[aCommon1] 
// Remark                    : Request type text. Maximum number of text lines is three  (3).
// Parent                    : loc_type_pane
// Parent API                : loc_type_pane
// Scale API match    ( 34%) : list_single_loc_request_popup_menu_pane_t1_ParamLimits
// Scale parent match (100%) : loc_type_pane
TAknTextLineLayout Location_request_type_texts_Line_1(TInt aIndex_B) 
    {
	// MurrayR 08/12/04: Good match, but with a pointless looking option required by 
	// the layout tool.
    TAknTextLineLayout textLine;
	switch (aIndex_B)
		{
		case 0:
			textLine = AknLayoutScalable_Apps::loc_type_pane_t1(0).LayoutLine();
			break;
		case 1:
			textLine = AknLayoutScalable_Apps::loc_type_pane_t2(0).LayoutLine();
			break;
		case 2:
		default:
			textLine = AknLayoutScalable_Apps::loc_type_pane_t3(0).LayoutLine();
			break;
		}
    return textLine;
    }
// C= H=26 W=26 b= l={300, 274, 286, 260} r= t=6 
// Remark                    : 
// Parent                    : list_single_loc_popup_menu_pane
// Parent API                : list_single_loc_popup_menu_pane
// Scale API match    ( 38%) : list_single_loc_request_popup_menu_pane_ParamLimits
// Scale parent match ( 96%) : list_single_loc_request_popup_menu_pane_ParamLimits
TAknWindowLineLayout Location_requestor_pane_elements_Line_1(TInt aIndex_l)
    {
	// MurrayR 08/12/04: Good match, except for more silly paramterisation in layout tool
    TAknWindowLineLayout line;
	switch (aIndex_l)
		{
		case 0:
			line = AknLayoutScalable_Apps::list_single_loc_request_popup_menu_pane_g1(0).LayoutLine();
			break;
		default:
			line = AknLayoutScalable_Apps::list_single_loc_request_popup_menu_pane_g2(0).LayoutLine();
			break;
		}
    return line;
    }

// B=26 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W={310, 280, 254} l=16 r={10, 40, 66} 
// Remark                    : Requestor name.
// Parent                    : list_single_loc_popup_menu_pane
// Parent API                : list_single_loc_popup_menu_pane
// Scale API match    ( 37%) : main_location_pane
// Scale parent match ( 96%) : list_single_loc_request_popup_menu_pane_ParamLimits
TAknTextLineLayout Location_reqestor_pane_texts_Line_1(TInt aIndex_r, TInt /*aIndex_W*/) 
    {
	// MurrayR 08/12/04: Good match, but the layout tool doesn't actually show that the
	// line has varieties. This is only visible from the XML data.
    // TInt rowIndex = 0; // only ever seems to have one row [LMB 16/03/2005]
    // MAN: 7.6.2005: Now only one param is generated in layout data v0.9
    TAknTextLineLayout textLine = AknLayoutScalable_Apps::list_single_loc_request_popup_menu_pane_t1(aIndex_r/*, rowIndex*/).LayoutLine();
    return textLine;
    }
// C=0 H=p W=352 b= l=0 r= t=0 
// Remark                    : A rectangle to cover the main pane items.
// Parent                    : popup_loc_request_window
// Parent API                : popup_loc_request_window
// Scale API match    ( 45%) : popup_loc_request_window
// Scale parent match (100%) : popup_loc_request_window
TAknWindowLineLayout Location_request_popup_window_grapihcs_Line_1(const TRect& /*aParentRect*/)
    {
	// MurrayR 08/12/04: More shadow graphics
    TAknWindowLineLayout line = AknLayoutScalable_Apps::bg_popup_window_pane_cp02(0).LayoutLine();
    return line;
    }

// C=86 H=p-20 W=336 b= l=12 r= t=12 
// Remark                    : Second shadow.
// Parent                    : popup_loc_request_window
// Parent API                : popup_loc_request_window
// Scale API match    ( 45%) : popup_loc_request_window
// Scale parent match (100%) : popup_loc_request_window
TAknWindowLineLayout Location_request_popup_window_grapihcs_Line_2(const TRect& /*aParentRect*/)
    {
	// MurrayR 08/12/04: More shadow graphics
    return ZeroWindowLayout();
    }

// C=221 H=p-18 W=338 b= l=8 r= t=8 
// Remark                    : First shadow.
// Parent                    : popup_loc_request_window
// Parent API                : popup_loc_request_window
// Scale API match    ( 45%) : popup_loc_request_window
// Scale parent match (100%) : popup_loc_request_window
TAknWindowLineLayout Location_request_popup_window_grapihcs_Line_3(const TRect& /*aParentRect*/)
    {
	// MurrayR 08/12/04: More shadow graphics
    return ZeroWindowLayout();
    }

// C=215 H=p-16 W=340 b= l=4 r= t=4 
// Remark                    : Outline frame.
// Parent                    : popup_loc_request_window
// Parent API                : popup_loc_request_window
// Scale API match    ( 45%) : popup_loc_request_window
// Scale parent match (100%) : popup_loc_request_window
TAknWindowLineLayout Location_request_popup_window_grapihcs_Line_4(const TRect& /*aParentRect*/)
    {
	// MurrayR 08/12/04: More shadow graphics
    return ZeroWindowLayout();
    }

// C=0 H=p-20 W=336 b= l=6 r= t=6 
// Remark                    : Inside area.
// Parent                    : popup_loc_request_window
// Parent API                : popup_loc_request_window
// Scale API match    ( 45%) : popup_loc_request_window
// Scale parent match (100%) : popup_loc_request_window
TAknWindowLineLayout Location_request_popup_window_grapihcs_Line_5(const TRect& /*aParentRect*/)
    {
	// MurrayR 08/12/04: More shadow graphics
    return ZeroWindowLayout();
    }

TAknWindowLineLayout Volume_strength_area_values(TInt aLineIndex)
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1;
    if (aLineIndex > 0)
        layout1 = AknLayoutScalable_Apps::aid_volume_smil(aLineIndex-1);
    return layout1.LayoutLine();
    }

// LAF Table : SMIL text pane elements
// C=0 H=p W=p b= l=0 r= t=0 
// Remark                    : Text background.
// Parent                    : smil_text_pane
// Parent API                : smil_text_pane
// Scale API match    ( 59%) : smil_text_list_pane_t1_ParamLimits
// Scale parent match (100%) : smil_text_pane
TAknWindowLineLayout SMIL_text_pane_elements_Line_1(const TRect& /*aParentRect*/)
    {
    // MAN: NOT SUPPORTED (not used)
    return EmptyWindowLayout();
    }

// C= H=p W=14 b= l=0 r=0 t= 
// Remark                    : Scrolling indicator.
// Parent                    : smil_text_pane
// Parent API                : smil_text_pane
// Scale API match    ( 71%) : cale_week_scroll_pane_g1
// Scale parent match (100%) : smil_text_pane
TAknWindowLineLayout smil_scroll_pane(const TRect& /*aParentRect*/)
    {
    // MAN: DONE but aParentRect is ignored always, so max size is used. 
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::scroll_pane_cp011();    
    return layout1.LayoutLine();
    }

// LAF Table : SMIL text pane texts
// B={26, 54, 82, 110, 138, 166, 194, 222, 250, 278, 306, 334, 362} C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W={340, 330}[aCommon1] l=6 r={6, 16}[aCommon1] 
// Remark                    : Presentation text.
// Parent                    : smil_text_pane
// Parent API                : smil_text_pane
// Scale API match    ( 89%) : smil_text_list_pane_t1_ParamLimits
// Scale parent match (100%) : smil_text_pane
TAknTextLineLayout SMIL_text_pane_texts_Line_1(TInt /*aCommon1*/, TInt aIndex_B)
    {
    // MAN: DONE
    // NOTE: aCommon1 is always ignored.
	TInt rowIndex = aIndex_B;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::list_smil_text_pane();
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::smil_text_list_pane_t1(rowIndex);        
    return DoComposeText(layout1, textLayout).LayoutLine();    
    }


// LAF Table : SMIL scroll pane elements
// C=218 H=p-8 W=6 b= l=4 r= t=4 
// Remark                    : Background scroll bar.
// Parent                    : smil_scroll_pane
// Parent API                : smil_scroll_pane
// Scale API match    ( 45%) : cale_week_scroll_pane_g1
// Scale parent match ( 71%) : cale_week_scroll_pane_g1
TAknWindowLineLayout SMIL_scroll_pane_elements_Line_1(const TRect& /*aParentRect*/)
    {
    // MAN: NOT SUPPORTED (not used)
    return EmptyWindowLayout();
    }

// C=0 H=+4 W=6 b= l=0 r= t=-2 
// Remark                    : Marker outline.
// Parent                    : smil_scroll_pane
// Parent API                : smil_scroll_pane
// Scale API match    ( 45%) : cale_week_scroll_pane_g1
// Scale parent match ( 71%) : cale_week_scroll_pane_g1
TAknWindowLineLayout SMIL_scroll_pane_elements_Line_2()
    {
    // MAN: NOT SUPPORTED (not used)
    return EmptyWindowLayout();
    }

// C=221 H= W=6 b= l=4 r= t= 
// Remark                    : Marker inside.
// Parent                    : smil_scroll_pane
// Parent API                : smil_scroll_pane
// Scale API match    ( 45%) : cale_week_scroll_pane_g1
// Scale parent match ( 71%) : cale_week_scroll_pane_g1
TAknWindowLineLayout SMIL_scroll_pane_elements_Line_3()
    {
    // MAN: NOT SUPPORTED (not used)
    return EmptyWindowLayout();
    }

// LAF Table : Pop-up windows (status pane as parent)
// C= H=104 W=88 b= l=24 r= t=0 
// Remark                    : Thumbnail image.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 38%) : popup_number_entry_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_pbook_thumbnail_window()
    {
	// MurrayR 21/12/04: Good match found in updated layout data
    // MAN: 31/01/05 Added context pane as parent here
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Avkon::context_pane(0); 
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::popup_phob_thumbnail_window();
    
    return DoCompose(layout1, layout2).LayoutLine();

//    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_phob_thumbnail_window().LayoutLine();
//    return line;
    }

// C= H=66 W=72 b= l={280, 256} r= t=0 
// Remark                    : Call status indication during application browsing.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : popup_call_status_window
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_call_status_window(TInt aIndex_l)
    {
	// MurrayR 21/12/04: Good match, but ordering is reversed in LAF and layout tool
    TInt varietyIndex = 1 - aIndex_l;
    // MAN: 25.8.2005 (landscape call statusbubble redesign)
    if (Layout_Meta_Data::IsLandscapeOrientation())
        varietyIndex = 6;
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_status_window(varietyIndex).LayoutLine();
    return line;
    }

// C= H={288, 74}[aCommon1] W={352, 90}[aCommon1] b= l={0, 28}[aCommon1] r= t={0, 4}[aCommon1] 
// Remark                    : Uplink video stream.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 62%) : popup_call_status_window
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_call_video_up_window(TInt aCommon1)
    {
	// MurrayR 07/12/04: only the second option looks sensible
	// MurrayR 21/12/04: now using the downlink full sized pane for the
	// uplink full sized pane.
	if (aCommon1 ==0)
		{
		TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
		TAknWindowLineLayout line = AknLayoutScalable_Apps::video_down_pane(varietyIndex).LayoutLine();
		return line;
		}
	else
		{
		TAknWindowLineLayout line = AknLayoutScalable_Apps::call_video_uplink_pane(1).LayoutLine();
		return line;
		}
    }

// C= H={40, 68, 96, 124}[aCommon1] W=268 b= l=84 r= t={56, 28, 0, 0}[aCommon1] 
// Remark                    : Calendar events list.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : popup_cale_events_window
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_cale_events_window(TInt aCommon1)
    {
    // Start 15:18 - 16:00

    // Option passed is probably number of events/lines
    // INvestigate hierarchy
    // Have to compose up to status pane

    TInt variety = aCommon1; // variety now correct [LMB 29/11/2004]
    return AknLayoutScalable_Apps::popup_cale_events_window( variety ).LayoutLine(); // lines
    }

// LAF Table : Pop-up window list pane descendants(call conf)
// C= H=38 W=320 b= l=0 r= t={0, 38, 76, 114, 152, 190} 
// Remark                    : List pane for a conference call.
// Parent                    : list_conf_pane
// Parent API                : list_conf_pane
// Scale API match    (100%) : list_single_graphic_popup_conf_pane
// Scale parent match (100%) : list_conf_pane
TAknWindowLineLayout list_single_graphic_popup_conf_pane(TInt aIndex_t) 
    {
    // layout data 0.75 contains multirow information [LMB 16/12/2004]
	// MurrayR 21/12/04: Limited indexing, because new layout has 5 lines vs 6 in old LAF
	TAknLayoutScalableParameterLimits lim = AknLayoutScalable_Apps::list_single_graphic_popup_conf_pane_ParamLimits();
    TInt varietyIndex = Min(aIndex_t, lim.LastRow());
    TAknWindowLineLayout line = AknLayoutScalable_Apps::list_single_graphic_popup_conf_pane(varietyIndex).LayoutLine();
    return line;
    }

// LAF Table : List pane elements (conf single graphic)
// C= H=32 W=40 b= l=8 r= t=2 
// Remark                    : Call state indication.
// Parent                    : list_single_graphic_popup_conf_pane
// Parent API                : list_single_graphic_popup_conf_pane
// Scale API match    ( 60%) : list_single_graphic_popup_conf_pane_g_Limits
// Scale parent match (100%) : list_single_graphic_popup_conf_pane
TAknWindowLineLayout List_pane_elements__conf_single_graphic__Line_1()
    {
	// MurrayR 06/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::list_single_graphic_popup_conf_pane_g1().LayoutLine();
    return line;
    }

// C= H=16 W=18 b= l=4 r= t=0 
// Remark                    : Cyphering off indication.
// Parent                    : list_single_graphic_popup_conf_pane
// Parent API                : list_single_graphic_popup_conf_pane
// Scale API match    ( 60%) : list_single_graphic_popup_conf_pane_g_Limits
// Scale parent match (100%) : list_single_graphic_popup_conf_pane
TAknWindowLineLayout List_pane_elements__conf_single_graphic__Line_2()
    {
	// MurrayR 06/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::list_single_graphic_popup_conf_pane_g2().LayoutLine();
    return line;
    }


// LAF Table : List pane texts (conf single graphic)
// B=26 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=254 l=56 r=10 
// Remark                    : CLI.
// Parent                    : list_single_graphic_popup_conf_pane
// Parent API                : list_single_graphic_popup_conf_pane
// Scale API match    ( 64%) : list_single_graphic_popup_conf_pane_g_Limits
// Scale parent match (100%) : list_single_graphic_popup_conf_pane
TAknTextLineLayout List_pane_texts__conf_single_graphic__Line_1() 
    {
	// MurrayR 06/12/04: Good match
    //TInt rowIndex = 0; // only ever seems to have one row [LMB 16/03/2005]
    // MAN: 7.6.2005 Seems that in v0.9 layout no more param 
    TAknTextLineLayout textLine = AknLayoutScalable_Apps::list_single_graphic_popup_conf_pane_t1(/*rowIndex*/).LayoutLine();
    return textLine;
    }

// LAF Table : List pane elements (menu single graphic bt)
// C= H=26 W=26 b= l=8 r= t=6 
// Remark                    : Marked or unmarked indication.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 47%) : list_single_graphic_popup_wml_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__menu_single_graphic_bt__Line_1()
    {
	// MurrayR 21/12/04 - Used avkon's menu, single, graphic list
    return AknLayoutScalable_Avkon::list_single_graphic_pane_g1_cp2(0).LayoutLine();
    }

// C= H=26 W=26 b= l={300, 274} r= t=6 
// Remark                    : Paired indication.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 47%) : list_single_graphic_popup_wml_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__menu_single_graphic_bt__Line_2(TInt aIndex_l)
    {
	// MurrayR 21/12/04 - Used avkon's menu, single, graphic list
    TAknWindowComponentLayout layout;
    if (aIndex_l == 1)
        {
        layout = AknLayoutScalable_Avkon::list_single_graphic_pane_g3_cp2();
        }
    else
        {
        layout = AknLayoutScalable_Avkon::list_single_graphic_pane_g2_cp2(0);
        }
    return layout.LayoutLine();
    }

// LAF Table : List pane text (menu single graphic bt)
// B=26 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={282, 252, 226}[aCommon1] l=44 r={10, 40, 66}[aCommon1] 
// Remark                    : Device name text.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 52%) : list_single_graphic_popup_wml_pane_g_Limits
// Scale parent match (  0%) : 
TAknTextLineLayout List_pane_text__menu_single_graphic_bt__Line_1(TInt aCommon1)
    {
	// MurrayR 21/12/04 - Used avkon's menu, single, graphic list
    return AknLayoutScalable_Avkon::list_single_graphic_pane_t1_cp2(aCommon1).LayoutLine();
    }

// LAF Table : Highlight graphics
// C=222 H=p-4 W=p-8 b= l=6 r= t=4 
// Remark                    : Shadow.
// Parent                    : list_single_graphic_popup_conf_pane
// Parent API                : list_single_graphic_popup_conf_pane
// Scale API match    ( 47%) : grid_highlight_pane_cp01
// Scale parent match (100%) : list_single_graphic_popup_conf_pane
TAknWindowLineLayout Highlight_graphics_Line_1(const TRect& /*aParentRect*/)
    {
	// MurrayR 06/12/04: Looks similar.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::list_highlight_pane_cp01().LayoutLine();
    return line;
    }

// C=244 H=p-2 W=p-6 b= l=2 r= t=0 
// Remark                    : Highlight.
// Parent                    : list_single_graphic_popup_conf_pane
// Parent API                : list_single_graphic_popup_conf_pane
// Scale API match    ( 47%) : grid_highlight_pane_cp01
// Scale parent match (100%) : list_single_graphic_popup_conf_pane
TAknWindowLineLayout Highlight_graphics_Line_2(const TRect& /*aParentRect*/)
    {
	// MurrayR 06/12/04: Looks similar.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::list_highlight_pane_cp01().LayoutLine();
    return line;
    }


// LAF Table : Pop-up window grid pane descendants (large graphic gms)
// C= H=72 W=160 b= l={0, , , , 162} r= t={0, 74, 148, 222, 0, 74, 148, 222} 
// Remark                    : Graphical message images.
// Parent                    : grid_large_graphic_popup_pane
// Parent API                : grid_large_graphic_popup_pane
// Scale API match    (100%) : cell_large_graphic_popup_pane
// Scale parent match (100%) : grid_large_graphic_popup_pane
TAknWindowLineLayout cell_large_graphic_popup_pane(TInt aIndex_l, TInt aIndex_t)
    {
	// MurrayR 06/12/04: Got to unpack the dimensions, but basically ok.
	const TInt KNumRows = 4;
	TInt col = aIndex_l / KNumRows;
	TInt row = aIndex_t % KNumRows;
    TAknWindowLineLayout line = AknLayoutScalable_Apps::cell_large_graphic_popup_pane(col, row).LayoutLine();
    return line;
    }

// LAF Table : Cell pane elements (popup large graphic gms)
// C= H=56 W=144 b= l=8 r= t=8 
// Remark                    : Graphical message images.
// Parent                    : cell_large_graphic_popup_pane
// Parent API                : cell_large_graphic_popup_pane
// Scale API match    ( 55%) : cell_large_graphic_popup_pane_g_Limits
// Scale parent match (100%) : cell_large_graphic_popup_pane
TAknWindowLineLayout Cell_pane_elements__popup_large_graphic_gms__Line_1()
    {
	// MurrayR 06/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::cell_large_graphic_popup_pane_g1(0).LayoutLine();
    return line;
    }

// C= H=26 W=26 b= l=130 r= t=4 
// Remark                    : Marked item indication.
// Parent                    : cell_large_graphic_popup_pane
// Parent API                : cell_large_graphic_popup_pane
// Scale API match    ( 55%) : cell_large_graphic_popup_pane_g_Limits
// Scale parent match (100%) : cell_large_graphic_popup_pane
TAknWindowLineLayout Cell_pane_elements__popup_large_graphic_gms__Line_2()
    {
	// MurrayR 06/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::cell_large_graphic_popup_pane_g2(0).LayoutLine();
    return line;
    }


// LAF Table : Highlight elements (grid pop-up)
// C=215 H=p W=p b= l=p r= t=p 
// Remark                    : 
// Parent                    : cell_large_graphic_popup_pane
// Parent API                : cell_large_graphic_popup_pane
// Scale API match    ( 32%) : grid_highlight_pane_cp01
// Scale parent match (100%) : cell_large_graphic_popup_pane
TAknWindowLineLayout Highlight_elements__grid_pop_up__Line_1(const TRect& /*aParentRect*/)
    {
	// MurrayR 06/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::grid_highlight_pane_cp010().LayoutLine();
    return line;
    }

// LAF Table : Number entry pop-up window texts
// Started 10/11 11:59 - 12:30; 14:30 - 16:00 ; 10:00 - 12:00 
// This and next API tool 4 hours
// B=88 C=215 Font=ELatinBold17_Scaled J=ELayoutAlignRight W={308, 288}[aCommon1] l={22, 42}[aCommon1] r=22 
// Remark                    : Number entry. One line of numbers. Max. 1514 numbers.
// Parent                    : popup_number_entry_window
// Parent API                : popup_number_entry_window
// Scale API match    ( 64%) : popup_number_entry_window_t1_ParamLimits
// Scale parent match (100%) : popup_number_entry_window
TAknTextLineLayout Number_entry_pop_up_window_texts_Line_1(TInt aCommon1)
    {
    __ASSERT_ALWAYS(0 <= aCommon1 && aCommon1 <= 1, Panic(EParamsOutsideKnownRange));
    /*
    Old _Line_1 is new api's _t1; 
    aCommon1 = 0 is number entry
    aCommon1 = 1 is "when there is one incoming or outgoing call"
    The following code assumes that the parent window used in both cases is the
    "no incoming or outgoing call" case
    */
    TInt firstLineOptionId = 2; // this can be either 0 or 2.
    TAknTextComponentLayout text = AknLayoutScalable_Apps::popup_number_entry_window_t1(); // layout data 0.75 is not multirow [LMB 16/12/2004]
    if (firstLineOptionId == 2)
	{
    text = AknLayoutScalable_Apps::text_title_cp2();/*AknLayoutScalable_Apps::popup_number_entry_window_t1();*/ // layout data 0.75 is not multirow [LMB 16/12/2004]
	}
    if ( aCommon1 == 0 )
        {
        return text.LayoutLine();
        }
    else 
        {
        // Need to do something here because in new API, the variability is in next level up
        // Construct a false intermediate rectangle which represents the 2nd option
        TAknWindowComponentLayout l0 = AknLayoutScalable_Apps::popup_number_entry_window(0); 
        TAknWindowComponentLayout l1 = AknLayoutScalable_Apps::popup_number_entry_window(1);
        __ASSERT_ALWAYS( LayoutsHaveSameParentRelativePatterns( l0, l1 ),
            Panic(ECompositionStrategyFailed) );       
        TAknWindowComponentLayout intermediate = TAknWindowComponentLayout::SiblingAsChild( l0, l1 ); // bigger - smaller
        TAknTextComponentLayout textLayout = DoComposeText( intermediate, text);
        return textLayout.LayoutLine();
        }
    // ADDITIONAL INFORMATION: New API is likely to change to having two options. This _Line_1
    // API is likely to be the first variety.
    // "aRow" parameter is likely to be a mistake for the one line case. Above I supply 0.
    }

// B={52, 88} C=215 Font=ELatinBold13_Scaled J=ELayoutAlignRight W={308, 288}[aCommon1] l={22, 42}[aCommon1] r=22 
// Remark                    : Number entry. Two lines of numbers. Max. 3432 numbers.
// Parent                    : popup_number_entry_window
// Parent API                : popup_number_entry_window
// Scale API match    ( 64%) : popup_number_entry_window_t1_ParamLimits
// Scale parent match (100%) : popup_number_entry_window
TAknTextLineLayout Number_entry_pop_up_window_texts_Line_2(TInt aCommon1, TInt aIndex_B) 
    {
    // RSD: DONE
    // Old _line_2 is new api's _t2 or _t3 depending on aIndex_B. 
    // aCommon1 = 0 is number entry
    // aCommon1 = 1 is "when there is one incoming or outgoing call"
    // In future layout data, aIndex_B may map to a Row API
    __ASSERT_ALWAYS(0 <= aCommon1 && aCommon1 <= 1, Panic(EParamsOutsideKnownRange));
    TAknTextComponentLayout text;
    if ( aIndex_B == 0 )
        text = AknLayoutScalable_Apps::popup_number_entry_window_t2(); // layout data 0.75 is not multirow [LMB 16/12/2004]
    else if ( aIndex_B == 1 )
        text = AknLayoutScalable_Apps::popup_number_entry_window_t3();// layout data 0.75 is not multirow, but do we need  a non-zero baseline separation. TODO [LMB 16/12/2004]

    TAknTextLineLayout textLine;
    if ( aCommon1 == 0 )
        textLine = text.LayoutLine();
    else // aCommon == 1
        {
        // Need to do something here because in new API, the variability is in next level up.
        // Construct a false intermediate rectangle which represents the 2nd option
        TAknWindowComponentLayout l0 = AknLayoutScalable_Apps::popup_number_entry_window(0); 
        TAknWindowComponentLayout l1 = AknLayoutScalable_Apps::popup_number_entry_window(1);
        __ASSERT_ALWAYS( LayoutsHaveSameParentRelativePatterns( l0, l1 ),
            Panic(ECompositionStrategyFailed) ); 
        TAknWindowComponentLayout intermediate = TAknWindowComponentLayout::SiblingAsChild( l0, l1 );
        textLine = DoComposeText( intermediate, text).LayoutLine(); 
        }

    return textLine;
    }

// LAF Table : Number entry pop-up window graphics
// Started 13:30 - done 14:53 (added SetZeroSized )
// C=0 H={126, 116}[aCommon1] W={352, 330}[aCommon1] b= l={0, 22}[aCommon1] r= t={0, 10}[aCommon1] 
// Remark                    : A rectangle to cover the main pane items.
// Parent                    : popup_number_entry_window
// Parent API                : popup_number_entry_window
// Scale API match    ( 55%) : popup_number_entry_window_ParamLimits
// Scale parent match (100%) : popup_number_entry_window
TAknWindowLineLayout Number_entry_pop_up_window_graphics_Line_1(TInt aCommon1)
    {
    // RSD: DONE
    // Issue 1: Currenly new API DOES have this option at this level.  But it also has the same option in 
    // popup_number_entry_window( option). It should not be in both places. So one of them may change
    // Issue 2: New API only has the single graphic to perform all the shadowing etc..
    // Only this line returns anything
    TAknWindowLineLayout line = AknLayoutScalable_Apps::bg_popup_call_pane_cp05(aCommon1).LayoutLine();
    return line;
    }

// C=86 H=98 W={336, 316}[aCommon1] b= l={12, 32}[aCommon1] r= t=20 
// Remark                    : Second shadow.
// Parent                    : popup_number_entry_window
// Parent API                : popup_number_entry_window
// Scale API match    ( 55%) : popup_number_entry_window_ParamLimits
// Scale parent match (100%) : popup_number_entry_window
TAknWindowLineLayout Number_entry_pop_up_window_graphics_Line_2(TInt /*aCommon1*/)
    {
    // RSD: DONE
    TAknWindowComponentLayout line;
    return DoSetZeroSized( line ).LayoutLine();
    }

// C=221 H=100 W={338, 318}[aCommon1] b= l={8, 28}[aCommon1] r= t=16 
// Remark                    : First shadow.
// Parent                    : popup_number_entry_window
// Parent API                : popup_number_entry_window
// Scale API match    ( 55%) : popup_number_entry_window_ParamLimits
// Scale parent match (100%) : popup_number_entry_window
TAknWindowLineLayout Number_entry_pop_up_window_graphics_Line_3(TInt /*aCommon1*/)
    {
    // RSD: DONE
    TAknWindowComponentLayout line;
    return DoSetZeroSized( line ).LayoutLine();
    }

// C=215 H=102 W={340, 320}[aCommon1] b= l={4, 24}[aCommon1] r= t=12 
// Remark                    : Outline frame. The frame width is one pixel.
// Parent                    : popup_number_entry_window
// Parent API                : popup_number_entry_window
// Scale API match    ( 55%) : popup_number_entry_window_ParamLimits
// Scale parent match (100%) : popup_number_entry_window
TAknWindowLineLayout Number_entry_pop_up_window_graphics_Line_4(TInt /*aCommon1*/)
    {
    // RSD: DONE
    TAknWindowComponentLayout line;
    return DoSetZeroSized( line ).LayoutLine();
    }

// C=0 H=98 W={336, 316}[aCommon1] b= l={6, 26}[aCommon1] r= t=14 
// Remark                    : Inside area.
// Parent                    : popup_number_entry_window
// Parent API                : popup_number_entry_window
// Scale API match    ( 55%) : popup_number_entry_window_ParamLimits
// Scale parent match (100%) : popup_number_entry_window
TAknWindowLineLayout Number_entry_pop_up_window_graphics_Line_5(TInt /*aCommon1*/)
    {
    // RSD: DONE
    TAknWindowComponentLayout line;
    return DoSetZeroSized( line ).LayoutLine();
    }


// LAF Table : Phonebook memory status pop-up window descendants and elements
// C=0 H=46 W=336 b= l=6 r= t=12 
// Remark                    : Pop-up window title.
// Parent                    : popup_pb_memory_status_window
// Parent API                : popup_pb_memory_status_window
// Scale API match    ( 68%) : bg_cale_heading_pane
// Scale parent match ( 59%) : popup_call_status_window
TAknWindowLineLayout popup_heading_pane()
    {
	// MurrayR 09/12/04: Phonebook memory status does not exist in LAF or layout tool
    return ZeroWindowLayout();
    }

// C=221 H=202 W=332 b= l=8 r= t=56 
// Remark                    : Memory status window background graphics.
// Parent                    : popup_pb_memory_status_window
// Parent API                : popup_pb_memory_status_window
// Scale API match    (  0%) : 
// Scale parent match ( 59%) : popup_call_status_window
TAknWindowLineLayout Phonebook_memory_status_pop_up_window_descendants_and_elements_Line_2()
    {
	// MurrayR 09/12/04: Phonebook memory status does not exist in LAF or layout tool
    return ZeroWindowLayout();
    }


// LAF Table : Phonebook memory status pop-up window texts
// B={118, 152} C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=198 l=134 r=20 
// Remark                    : Amount of memory entries. Amount of groups. Amount of names saved (SIM). Amount of places free.
// Parent                    : popup_pb_memory_status_window
// Parent API                : popup_pb_memory_status_window
// Scale API match    ( 38%) : popup_dyc_status_message_window_t1
// Scale parent match ( 59%) : popup_call_status_window
TAknTextLineLayout Phonebook_memory_status_pop_up_window_texts_Line_1(TInt /*aIndex_B*/) 
    {
	// MurrayR 09/12/04: Phonebook memory status does not exist in LAF or layout tool
    return ZeroTextLayout();
    }


// B={188, 220} C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=188 l=144 r=20 
// Remark                    : Amount of memory used and available in bytes.
// Parent                    : popup_pb_memory_status_window
// Parent API                : popup_pb_memory_status_window
// Scale API match    ( 38%) : popup_dyc_status_message_window_t1
// Scale parent match ( 59%) : popup_call_status_window
TAknTextLineLayout Phonebook_memory_status_pop_up_window_texts_Line_2(TInt /*aIndex_B*/)
    {
	// MurrayR 09/12/04: Phonebook memory status does not exist in LAF or layout tool
    return ZeroTextLayout();
    }



// LAF Table : Phonebook memory status pop-up window graphics
// C=0 H=274 W=352 b= l=0 r= t=0 
// Remark                    : A rectangle to cover the main pane items.
// Parent                    : popup_pb_memory_status_window
// Parent API                : popup_pb_memory_status_window
// Scale API match    ( 35%) : popup_dyc_status_message_window_g1
// Scale parent match ( 59%) : popup_call_status_window
TAknWindowLineLayout Phonebook_memory_status_pop_up_window_graphics_Line_1()
    {
	// MurrayR 09/12/04: Phonebook memory status does not exist in LAF or layout tool
    return ZeroWindowLayout();
    }

// C=86 H=254 W=336 b= l=12 r= t=12 
// Remark                    : Second shadow.
// Parent                    : popup_pb_memory_status_window
// Parent API                : popup_pb_memory_status_window
// Scale API match    ( 35%) : popup_dyc_status_message_window_g1
// Scale parent match ( 59%) : popup_call_status_window
TAknWindowLineLayout Phonebook_memory_status_pop_up_window_graphics_Line_2()
    {
	// MurrayR 09/12/04: Phonebook memory status does not exist in LAF or layout tool
    return ZeroWindowLayout();
    }

// C=221 H=256 W=338 b= l=8 r= t=8 
// Remark                    : First shadow.
// Parent                    : popup_pb_memory_status_window
// Parent API                : popup_pb_memory_status_window
// Scale API match    ( 35%) : popup_dyc_status_message_window_g1
// Scale parent match ( 59%) : popup_call_status_window
TAknWindowLineLayout Phonebook_memory_status_pop_up_window_graphics_Line_3()
    {
	// MurrayR 09/12/04: Phonebook memory status does not exist in LAF or layout tool
    return ZeroWindowLayout();
    }

// C=215 H=258 W=340 b= l=4 r= t=4 
// Remark                    : Outline frame.
// Parent                    : popup_pb_memory_status_window
// Parent API                : popup_pb_memory_status_window
// Scale API match    ( 35%) : popup_dyc_status_message_window_g1
// Scale parent match ( 59%) : popup_call_status_window
TAknWindowLineLayout Phonebook_memory_status_pop_up_window_graphics_Line_4()
    {
	// MurrayR 09/12/04: Phonebook memory status does not exist in LAF or layout tool
    return ZeroWindowLayout();
    }

// C=0 H=254 W=336 b= l=6 r= t=6 
// Remark                    : Inside area.
// Parent                    : popup_pb_memory_status_window
// Parent API                : popup_pb_memory_status_window
// Scale API match    ( 35%) : popup_dyc_status_message_window_g1
// Scale parent match ( 59%) : popup_call_status_window
TAknWindowLineLayout Phonebook_memory_status_pop_up_window_graphics_Line_5()
    {
	// MurrayR 09/12/04: Phonebook memory status does not exist in LAF or layout tool
    return ZeroWindowLayout();
    }


// LAF Table : Graphical message image selection pop-up window descendants
// C= H= W= b= l=6 r= t=12 
// Remark                    : For the dimensions see reference document 1.
// Parent                    : popup_grid_large_graphic_window
// Parent API                : popup_grid_large_graphic_window
// Scale API match    ( 29%) : popup_dyc_status_message_window_g1
// Scale parent match (100%) : popup_grid_large_graphic_window
TAknWindowLineLayout Graphical_message_image_selection_pop_up_window_descendants_Line_1() 
    {
	// MurrayR 29/11/04: using heading_pane_cp03 for list_heading_pane
    TAknWindowLineLayout line = AknLayoutScalable_Apps::heading_pane_cp03().LayoutLine();
    return line;
    }

// C= H={72, 146, 220, 294} W=322 b= l=14 r= t=60 
// Remark                    : Graphical message image selection grid.
// Parent                    : popup_grid_large_graphic_window
// Parent API                : popup_grid_large_graphic_window
// Scale API match    (100%) : grid_large_graphic_popup_pane
// Scale parent match (100%) : popup_grid_large_graphic_window
TAknWindowLineLayout grid_large_graphic_popup_pane(TInt /*aIndex_H*/)
    {
	// MurrayR 29/11/04: This one seems to be like its namesake
	// TODO - will probably need to use new options later
	// MurrayR 30/11/04: It looks like new spec only specifies full height popup
    TAknWindowLineLayout line = AknLayoutScalable_Apps::grid_large_graphic_popup_pane().LayoutLine();
    return line;
    }

// LAF Table : Graphical message image selection pop-up window elements
// C=219 H=2 W=326 b= l=12 r= t={58, 132, 206, 280, 354} 
// Remark                    : Horizontal line between grid elements.
// Parent                    : popup_grid_large_graphic_window
// Parent API                : popup_grid_large_graphic_window
// Scale API match    ( 30%) : popup_dyc_status_message_window_g1
// Scale parent match (100%) : popup_grid_large_graphic_window
TAknWindowLineLayout Graphical_message_image_selection_pop_up_window_elements_Line_1(TInt /*aIndex_t*/) 
    {
	// MurrayR 29/11/04: ok, this is a bit mental. There's only one horizontal line
	// in cell_large_graphic_popup_pane_g3.
	// These APIs return the new layout systems way of specifying the horizontal and vertical lines, which only apply to individual cells
	// TODO - will probably need to use new options later
    TAknWindowLineLayout line = AknLayoutScalable_Apps::cell_large_graphic_popup_pane_g3(0).LayoutLine();
    return line;
    }

// C=219 H={72, 146, 220, 294} W=2 b= l={12, 174, 336} r= t=60 
// Remark                    : Vertical line between grid elements.
// Parent                    : popup_grid_large_graphic_window
// Parent API                : popup_grid_large_graphic_window
// Scale API match    ( 30%) : popup_dyc_status_message_window_g1
// Scale parent match (100%) : popup_grid_large_graphic_window
TAknWindowLineLayout Graphical_message_image_selection_pop_up_window_elements_Line_2(TInt /*aIndex_l*/, TInt /*aIndex_H*/) 
    {
	// MurrayR 29/11/04: this is like the horizontal line, there aren't any options
	// TODO - some options are bound to appear.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::cell_large_graphic_popup_pane_g4(0).LayoutLine();
    return line;
    }

// LAF Table : Graphical message image selection pop-up window graphics
// C=0 H=p W=352 b= l=0 r= t=0 
// Remark                    : A rectangle to cover the main pane items.
// Parent                    : popup_grid_large_graphic_window
// Parent API                : popup_grid_large_graphic_window
// Scale API match    ( 38%) : popup_grid_large_graphic_window_ParamLimits
// Scale parent match (100%) : popup_grid_large_graphic_window
TAknWindowLineLayout Graphical_message_image_selection_pop_up_window_graphics_Line_1(const TRect& /*aParentRect*/)
    {
	// MurrayR 30/11/04: TODO - I can't see where this is in the layout tool
	// Borders should be done by skins, so returning background for first & zero for rest
    TAknWindowLineLayout line = AknLayoutScalable_Apps::bg_popup_window_pane_cp04().LayoutLine();
    return line;
    }

// C=86 H=p-20 W=338 b= l=12 r= t=12 
// Remark                    : Second shadow.
// Parent                    : popup_grid_large_graphic_window
// Parent API                : popup_grid_large_graphic_window
// Scale API match    ( 38%) : popup_grid_large_graphic_window_ParamLimits
// Scale parent match (100%) : popup_grid_large_graphic_window
TAknWindowLineLayout Graphical_message_image_selection_pop_up_window_graphics_Line_2(const TRect& /*aParentRect*/)
    {
	// MurrayR 30/11/04: TODO - I can't see where this is in the layout tool
	// Borders should be done by skins, so returning empty layout
    return ZeroWindowLayout();
    }

// C=221 H=p-18 W=340 b= l=8 r= t=8 
// Remark                    : First shadow.
// Parent                    : popup_grid_large_graphic_window
// Parent API                : popup_grid_large_graphic_window
// Scale API match    ( 38%) : popup_grid_large_graphic_window_ParamLimits
// Scale parent match (100%) : popup_grid_large_graphic_window
TAknWindowLineLayout Graphical_message_image_selection_pop_up_window_graphics_Line_3(const TRect& /*aParentRect*/)
    {
	// MurrayR 30/11/04: TODO - I can't see where this is in the layout tool
	// Borders should be done by skins, so returning empty layout
    return ZeroWindowLayout();
    }

// C=215 H=p-16 W=342 b= l=4 r= t=4 
// Remark                    : Outline frame.
// Parent                    : popup_grid_large_graphic_window
// Parent API                : popup_grid_large_graphic_window
// Scale API match    ( 38%) : popup_grid_large_graphic_window_ParamLimits
// Scale parent match (100%) : popup_grid_large_graphic_window
TAknWindowLineLayout Graphical_message_image_selection_pop_up_window_graphics_Line_4(const TRect& /*aParentRect*/)
    {
	// MurrayR 30/11/04: TODO - I can't see where this is in the layout tool
	// Borders should be done by skins, so returning empty layout
    return ZeroWindowLayout();
    }

// C=0 H=p-20 W=338 b= l=6 r= t=6 
// Remark                    : Inside area.
// Parent                    : popup_grid_large_graphic_window
// Parent API                : popup_grid_large_graphic_window
// Scale API match    ( 38%) : popup_grid_large_graphic_window_ParamLimits
// Scale parent match (100%) : popup_grid_large_graphic_window
TAknWindowLineLayout Graphical_message_image_selection_pop_up_window_graphics_Line_5(const TRect& /*aParentRect*/)
    {
	// MurrayR 30/11/04: TODO - I can't see where this is in the layout tool
	// Borders should be done by skins, so returning empty layout
    return ZeroWindowLayout();
    }


// LAF Table : Browser WIM PIN Code query pop-up window elements
// C=215 H=2 W=336 b= l=6 r= t=50 
// Remark                    : Line between the pop-up heading and query text.
// Parent                    : popup_query_wml_wim_window
// Parent API                : popup_query_wml_wim_window
// Scale API match    ( 25%) : popup_number_entry_window_ParamLimits
// Scale parent match ( 54%) : popup_wml_address_window_ParamLimits
TAknWindowLineLayout Browser_WIM_PIN_Code_query_pop_up_window_elements_Line_1() 
    {
	// MurrayR 30/11/04: Browser does not seem to use this layout, uses CAknTextQueryDialog instead
    return ZeroWindowLayout();
    }

// C=221 H=2 W=300 b= l=24 r= t={122, 160, 198} 
// Remark                    : Vertical shadow inside the editing frame.
// Parent                    : popup_query_wml_wim_window
// Parent API                : popup_query_wml_wim_window
// Scale API match    ( 25%) : popup_number_entry_window_ParamLimits
// Scale parent match ( 54%) : popup_wml_address_window_ParamLimits
TAknWindowLineLayout Browser_WIM_PIN_Code_query_pop_up_window_elements_Line_2(TInt /*aIndex_t*/) 
    {
	// MurrayR 30/11/04: Browser does not seem to use this layout, uses CAknTextQueryDialog instead
    return ZeroWindowLayout();
    }

// C=221 H=40 W=2 b= l=24 r= t={124, 162, 200} 
// Remark                    : Horizontal shadow inside the editing frame.
// Parent                    : popup_query_wml_wim_window
// Parent API                : popup_query_wml_wim_window
// Scale API match    ( 25%) : popup_number_entry_window_ParamLimits
// Scale parent match ( 54%) : popup_wml_address_window_ParamLimits
TAknWindowLineLayout Browser_WIM_PIN_Code_query_pop_up_window_elements_Line_3(TInt /*aIndex_t*/) 
    {
	// MurrayR 30/11/04: Browser does not seem to use this layout, uses CAknTextQueryDialog instead
    return ZeroWindowLayout();
    }

// C=215 H=46 W=306 b= l=22 r= t={120, 158, 196} 
// Remark                    : Outline for the editing frame.
// Parent                    : popup_query_wml_wim_window
// Parent API                : popup_query_wml_wim_window
// Scale API match    ( 25%) : popup_number_entry_window_ParamLimits
// Scale parent match ( 54%) : popup_wml_address_window_ParamLimits
TAknWindowLineLayout Browser_WIM_PIN_Code_query_pop_up_window_elements_Line_4(TInt /*aIndex_t*/)
    {
	// MurrayR 30/11/04: Browser does not seem to use this layout, uses CAknTextQueryDialog instead
    return ZeroWindowLayout();
    }

// C= H=32 W=32 b= l=304 r= t=12 
// Remark                    : Secure WIM query indication.
// Parent                    : popup_query_wml_wim_window
// Parent API                : popup_query_wml_wim_window
// Scale API match    ( 25%) : popup_number_entry_window_ParamLimits
// Scale parent match ( 54%) : popup_wml_address_window_ParamLimits
TAknWindowLineLayout Browser_WIM_PIN_Code_query_pop_up_window_elements_Line_5()
    {
	// MurrayR 30/11/04: Browser does not seem to use this layout, uses CAknTextQueryDialog instead
    return ZeroWindowLayout();
    }

// C= H=18 W=180 b= l=140 r= t={96, 134, 172} 
// Remark                    : Editing state icons.
// Parent                    : popup_query_wml_wim_window
// Parent API                : popup_query_wml_wim_window
// Scale API match    ( 25%) : popup_number_entry_window_ParamLimits
// Scale parent match ( 54%) : popup_wml_address_window_ParamLimits
TAknWindowLineLayout Browser_WIM_PIN_Code_query_pop_up_window_elements_Line_6(TInt /*aIndex_t*/) 
    {
	// MurrayR 30/11/04: Browser does not seem to use this layout, uses CAknTextQueryDialog instead
    return ZeroWindowLayout();
    }


// LAF Table : Browser WIM PIN Code query pop-up window texts
// B=36 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=276 l=22 r=54 
// Remark                    : WIM heading text.
// Parent                    : popup_query_wml_wim_window
// Parent API                : popup_query_wml_wim_window
// Scale API match    ( 26%) : popup_number_entry_window_t1_ParamLimits
// Scale parent match ( 54%) : popup_wml_address_window_ParamLimits
TAknTextLineLayout Browser_WIM_PIN_Code_query_pop_up_window_texts_Line_1() 
    {
	// MurrayR 30/11/04: Browser does not seem to use this layout, uses CAknTextQueryDialog instead
    return ZeroTextLayout();
    }

// B={88, 126, 164} C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=304 l=22 r=26 
// Remark                    : WIM prompt text.
// Parent                    : popup_query_wml_wim_window
// Parent API                : popup_query_wml_wim_window
// Scale API match    ( 26%) : popup_number_entry_window_t1_ParamLimits
// Scale parent match ( 54%) : popup_wml_address_window_ParamLimits
TAknTextLineLayout Browser_WIM_PIN_Code_query_pop_up_window_texts_Line_2(TInt /*aIndex_B*/) 
    {
	// MurrayR 30/11/04: Browser does not seem to use this layout, uses CAknTextQueryDialog instead
    return ZeroTextLayout();
    }


// B={152, 190, 228} C=215 Font=ELatinBold13_Scaled J=ELayoutAlignCenter W=286 l=34 r=32 
// Remark                    : Code entry.
// Parent                    : popup_query_wml_wim_window
// Parent API                : popup_query_wml_wim_window
// Scale API match    ( 26%) : popup_number_entry_window_t1_ParamLimits
// Scale parent match ( 54%) : popup_wml_address_window_ParamLimits
TAknTextLineLayout Browser_WIM_PIN_Code_query_pop_up_window_texts_Line_3(TInt /*aIndex_B*/)
    {
	// MurrayR 30/11/04: Browser does not seem to use this layout, uses CAknTextQueryDialog instead
    return ZeroTextLayout();
    }



// LAF Table : Browser WIM PIN Code query pop-up window graphics
// C=0 H=p W=352 b= l=0 r= t=0 
// Remark                    : A rectangle to cover the main pane items.
// Parent                    : popup_query_wml_wim_window
// Parent API                : popup_query_wml_wim_window
// Scale API match    ( 31%) : popup_grid_large_graphic_window_ParamLimits
// Scale parent match ( 54%) : popup_wml_address_window_ParamLimits
TAknWindowLineLayout Browser_WIM_PIN_Code_query_pop_up_window_graphics_Line_1(const TRect& /*aParentRect*/)
    {
	// MurrayR 30/11/04: Browser does not seem to use this layout, uses CAknTextQueryDialog instead
	// also, border graphics such as these are all done by skins
    return ZeroWindowLayout();
    }

// C=86 H=p-20 W=338 b= l=12 r= t=12 
// Remark                    : Second shadow.
// Parent                    : popup_query_wml_wim_window
// Parent API                : popup_query_wml_wim_window
// Scale API match    ( 31%) : popup_grid_large_graphic_window_ParamLimits
// Scale parent match ( 54%) : popup_wml_address_window_ParamLimits
TAknWindowLineLayout Browser_WIM_PIN_Code_query_pop_up_window_graphics_Line_2(const TRect& /*aParentRect*/)
    {
	// MurrayR 30/11/04: Browser does not seem to use this layout, uses CAknTextQueryDialog instead
	// also, border graphics such as these are all done by skins
    return ZeroWindowLayout();
    }

// C=221 H=p-18 W=340 b= l=8 r= t=8 
// Remark                    : First shadow.
// Parent                    : popup_query_wml_wim_window
// Parent API                : popup_query_wml_wim_window
// Scale API match    ( 31%) : popup_grid_large_graphic_window_ParamLimits
// Scale parent match ( 54%) : popup_wml_address_window_ParamLimits
TAknWindowLineLayout Browser_WIM_PIN_Code_query_pop_up_window_graphics_Line_3(const TRect& /*aParentRect*/)
    {
	// MurrayR 30/11/04: Browser does not seem to use this layout, uses CAknTextQueryDialog instead
	// also, border graphics such as these are all done by skins
    return ZeroWindowLayout();
    }

// C=215 H=p-16 W=342 b= l=4 r= t=4 
// Remark                    : Outline frame.
// Parent                    : popup_query_wml_wim_window
// Parent API                : popup_query_wml_wim_window
// Scale API match    ( 31%) : popup_grid_large_graphic_window_ParamLimits
// Scale parent match ( 54%) : popup_wml_address_window_ParamLimits
TAknWindowLineLayout Browser_WIM_PIN_Code_query_pop_up_window_graphics_Line_4(const TRect& /*aParentRect*/) 
    {
	// MurrayR 30/11/04: Browser does not seem to use this layout, uses CAknTextQueryDialog instead
	// also, border graphics such as these are all done by skins
    return ZeroWindowLayout();
    }

// C=0 H=p-20 W=338 b= l=6 r= t=6 
// Remark                    : Inside area.
// Parent                    : popup_query_wml_wim_window
// Parent API                : popup_query_wml_wim_window
// Scale API match    ( 31%) : popup_grid_large_graphic_window_ParamLimits
// Scale parent match ( 54%) : popup_wml_address_window_ParamLimits
TAknWindowLineLayout Browser_WIM_PIN_Code_query_pop_up_window_graphics_Line_5(const TRect& /*aParentRect*/) 
    {
	// MurrayR 30/11/04: Browser does not seem to use this layout, uses CAknTextQueryDialog instead
	// also, border graphics such as these are all done by skins
    return ZeroWindowLayout();
    }


// LAF Table : Browser Digital Signing query pop-up window elements
// C=215 H=2 W=336 b= l=6 r= t=50 
// Remark                    : Line between the pop-up heading and query text.
// Parent                    : popup_query_wml_sign_window
// Parent API                : popup_query_wml_sign_window
// Scale API match    ( 29%) : popup_clock_digital_window_cp01
// Scale parent match ( 48%) : popup_wml_address_window_ParamLimits
TAknWindowLineLayout Browser_Digital_Signing_query_pop_up_window_elements_Line_1()
    {
	// MurrayR 30/11/04: Browser does not seem to use this layout
	// no evidence of this layout in layout tool data either
    return ZeroWindowLayout();
    }

// C= H=32 W=32 b= l=304 r= t=12 
// Remark                    : Secure WIM query indication.
// Parent                    : popup_query_wml_sign_window
// Parent API                : popup_query_wml_sign_window
// Scale API match    ( 29%) : popup_clock_digital_window_cp01
// Scale parent match ( 48%) : popup_wml_address_window_ParamLimits
TAknWindowLineLayout Browser_Digital_Signing_query_pop_up_window_elements_Line_2() 
    {
	// MurrayR 30/11/04: Browser does not seem to use this layout
	// no evidence of this layout in layout tool data either
    return ZeroWindowLayout();
    }


// LAF Table : Browser Digital Signing query pop-up window texts
// B=36 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=276 l=22 r=54 
// Remark                    : Heading text.
// Parent                    : popup_query_wml_sign_window
// Parent API                : popup_query_wml_sign_window
// Scale API match    ( 33%) : popup_clock_digital_window_t1
// Scale parent match ( 48%) : popup_wml_address_window_ParamLimits
TAknTextLineLayout Browser_Digital_Signing_query_pop_up_window_texts_Line_1() 
    {
	// MurrayR 30/11/04: Browser does not seem to use this layout
	// no evidence of this layout in layout tool data either
    return ZeroTextLayout();
    }

// B={84, 116, 180, 148, 212, 244} C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W={306, 306}[aCommon1] l=22 r={24, 24}[aCommon1] 
// Remark                    : Item text.
// Parent                    : popup_query_wml_sign_window
// Parent API                : popup_query_wml_sign_window
// Scale API match    ( 33%) : popup_clock_digital_window_t1
// Scale parent match ( 48%) : popup_wml_address_window_ParamLimits
TAknTextLineLayout Browser_Digital_Signing_query_pop_up_window_texts_Line_2(TInt /*aCommon1*/, TInt /*aIndex_B*/) 
    {
	// MurrayR 30/11/04: Browser does not seem to use this layout
	// no evidence of this layout in layout tool data either
    return ZeroTextLayout();
    }


// LAF Table : SAT Information query pop-up window elements
// C= H= W= b= l=6 r= t=10 
// Remark                    : For the dimensions see reference document 1.
// Parent                    : popup_query_sat_info_window
// Parent API                : popup_query_sat_info_window
// Scale API match    (  0%) : 
// Scale parent match ( 40%) : popup_loc_request_window
TAknWindowLineLayout SAT_Information_query_pop_up_window_elements_Line_1() 
    {
	// MurrayR 09/12/04: SAT does not exist in either LAF spec or layout tool
    return ZeroWindowLayout();
    }

// C= H=196 W=324 b= l=12 r= t=58 
// Remark                    : Image.
// Parent                    : popup_query_sat_info_window
// Parent API                : popup_query_sat_info_window
// Scale API match    (  0%) : 
// Scale parent match ( 40%) : popup_loc_request_window
TAknWindowLineLayout SAT_Information_query_pop_up_window_elements_Line_2() 
    {
	// MurrayR 09/12/04: SAT does not exist in either LAF spec or layout tool
    return ZeroWindowLayout();
    }


// LAF Table : SAT Information query pop-up window texts
// B={84, 116, 148, 212, 244} C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W={306, 306}[aCommon1] l=22 r={24, 24}[aCommon1] 
// Remark                    : Item text.
// Parent                    : popup_query_sat_info_window
// Parent API                : popup_query_sat_info_window
// Scale API match    ( 25%) : bg_popup_window_pane_cp01_ParamLimits
// Scale parent match ( 40%) : popup_loc_request_window
TAknTextLineLayout SAT_Information_query_pop_up_window_texts_Line_1(TInt /*aCommon1*/, TInt /*aIndex_B*/)
    {
	// MurrayR 09/12/04: SAT does not exist in either LAF spec or layout tool
    return ZeroTextLayout();
    }


// LAF Table : Analogue clock pop-up window elements
// C= H=p W=p b= l=0 r= t=0 
// Remark                    : Shadow graphics for the clock.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 55%) : popup_clock_analogue_window_cp02
// Scale parent match (  0%) : 
TAknWindowLineLayout Analogue_clock_pop_up_window_elements_Line_1(const TRect& /*aParentRect*/)
    {
	// MurrayR 30/11/04: Some of the API for analogue clock is called, but it looks like
	// none of the values are actually used.
	// The layout tool spec for the analogue clock gives totally different info from the old
	// layout specs. However, this rectangle looks about right.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_clock_analogue_window_g1().LayoutLine();
    return line;
    }

// C= H=p W=p b= l=0 r= t=0 
// Remark                    : Analogue clock face graphics.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 55%) : popup_clock_analogue_window_cp02
// Scale parent match (  0%) : 
TAknWindowLineLayout Analogue_clock_pop_up_window_elements_Line_2(const TRect& /*aParentRect*/)
    {
	// MurrayR 30/11/04: Some of the API for analogue clock is called, but it looks like
	// none of the values are actually used
	// The layout tool spec for the analogue clock gives totally different info from the old
	// layout specs. However, this rectangle looks about right.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_clock_analogue_window_g1().LayoutLine();
    return line;
    }

// C=215 H=28 W=4 b= l=46 r= t=50 
// Remark                    : Hour pointer.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 55%) : popup_clock_analogue_window_cp02
// Scale parent match (  0%) : 
TAknWindowLineLayout Analogue_clock_pop_up_window_elements_Line_3()
    {
	// MurrayR 30/11/04: Some of the API for analogue clock is called, but it looks like
	// none of the values are actually used.
	// The layout tool spec for the analogue clock gives totally different info from the old
	// layout specs.
	// MurrayR 09/02/05: Ok, we need to make up something here, so we hard code some working values...
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_clock_analogue_window_g3().LayoutLine();
	TInt h = line.iH;
	if (h > 90)
		{
		// double res range
		const TAknWindowLineLayoutImp lineImp = {215,47,49,ELayoutEmpty,ELayoutEmpty,4,28};
	    return *(TAknWindowLineLayout*)&lineImp;
		}
	else if (h > 65)
		{
		// qvga range
		const TAknWindowLineLayoutImp lineImp = {215,33,34,ELayoutEmpty,ELayoutEmpty,3,21};
	    return *(TAknWindowLineLayout*)&lineImp;
		}
	else
	   return ZeroWindowLayout();
    }

// C=215 H=36 W=4 b= l=46 r= t=50 
// Remark                    : Minute pointer.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 55%) : popup_clock_analogue_window_cp02
// Scale parent match (  0%) : 
TAknWindowLineLayout Analogue_clock_pop_up_window_elements_Line_4() 
    {
	// MurrayR 30/11/04: Some of the API for analogue clock is called, but it looks like
	// none of the values are actually used.
	// The layout tool spec for the analogue clock gives totally different info from the old
	// layout specs.
	// MurrayR 09/02/05: Ok, we need to make up something here, so we hard code some working values...
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_clock_analogue_window_g3().LayoutLine();
	TInt h = line.iH;
	if (h > 90)
		{
		// double res range
		const TAknWindowLineLayoutImp lineImp = {215,47,49,ELayoutEmpty,ELayoutEmpty,4,36};
	    return *(TAknWindowLineLayout*)&lineImp;
		}
	else if (h > 65)
		{
		// qvga range
		const TAknWindowLineLayoutImp lineImp = {215,33,34,ELayoutEmpty,ELayoutEmpty,3,27};
	    return *(TAknWindowLineLayout*)&lineImp;
		}
	else
	   return ZeroWindowLayout();
    }

// C=35 H=8 W=8 b= l=44 r= t=46 
// Remark                    : Center rectangle.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 55%) : popup_clock_analogue_window_cp02
// Scale parent match (  0%) : 
TAknWindowLineLayout Analogue_clock_pop_up_window_elements_Line_5()
    {
	// MurrayR 30/11/04: Some of the API for analogue clock is called, but it looks like
	// none of the values are actually used.
	// The layout tool spec for the analogue clock gives totally different info from the old
	// layout specs. So, the adaptation layer may aswell return nul rects.
    return ZeroWindowLayout();
    }

// LAF Table : Analogue clock pop-up window texts
// B=54 C=198 Font=ENumberPlain5_Scaled J=ELayoutAlignCenter W=16 l=66 r=20 
// Remark                    : Current date.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 63%) : popup_clock_analogue_window_t1
// Scale parent match (  0%) : 
TAknTextLineLayout Analogue_clock_pop_up_window_texts_Line_1()
    {
	// MurrayR 30/11/04: the day number area seems to map well
    TAknTextLineLayout textLine = AknLayoutScalable_Apps::popup_clock_analogue_window_t1().LayoutLine();
    return textLine;
    }

// LAF Table : Digital clock pop-up window elements
// C= H=30 W=44 b= l=0 r= t=58 
// Remark                    : Shadow graphics for the first two digits.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 54%) : popup_clock_digital_window_cp01
// Scale parent match (  0%) : 
TAknWindowLineLayout Digital_clock_pop_up_window_elements_Line_1() 
    {
	// MurrayR 01/12/04: Layout tool does not specify these shadow graphics
    return ZeroWindowLayout();
    }

// C= H=30 W=44 b= l= r=2 t=58 
// Remark                    : Shadow graphics for the last two digits.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 54%) : popup_clock_digital_window_cp01
// Scale parent match (  0%) : 
TAknWindowLineLayout Digital_clock_pop_up_window_elements_Line_2() 
    {
	// MurrayR 01/12/04: Layout tool does not specify these shadow graphics
    return ZeroWindowLayout();
    }

// C= H=30 W=12 b= l=44 r= t=58 
// Remark                    : Shadow graphics for the middle part.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 54%) : popup_clock_digital_window_cp01
// Scale parent match (  0%) : 
TAknWindowLineLayout Digital_clock_pop_up_window_elements_Line_3()
    {
	// MurrayR 01/12/04: Layout tool does not specify these shadow graphics
    return ZeroWindowLayout();
    }


// LAF Table : Digital clock pop-up window texts
// B=72 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignRight W=86 l=8 r=8 
// Remark                    : Time indication.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 62%) : popup_clock_digital_window_t1
// Scale parent match (  0%) : 
TAknTextLineLayout Digital_clock_pop_up_window_texts_Line_1() 
    {
	// MurrayR 01/12/04: Layout tool does not specify digital clock digit area as text.
	// instead it is as a set of window spaces
    return ZeroTextLayout();
    }

// B=102 C=215 Font=ELatinBold12_Scaled J=ELayoutAlignRight W=72 l=22 r=8 
// Remark                    : 12-hour clock a.m.p.m. indication.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 62%) : popup_clock_digital_window_t1
// Scale parent match (  0%) : 
TAknTextLineLayout Digital_clock_pop_up_window_texts_Line_2() 
    {
	// MurrayR 01/12/04: This looks like a good match
    TAknTextLineLayout textLine = AknLayoutScalable_Apps::popup_clock_digital_window_t1().LayoutLine();
    return textLine;
    }


// LAF Table : Thumbnail pop-up window elements
// C=221 H=88 W=72 b= l=10 r= t=8 
// Remark                    : Shadow rectangle.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 32%) : popup_cale_events_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Thumbnail_pop_up_window_elements_Line_1()
    {
	// MurrayR 21/12/04: One thumbnail window specified for all sizes
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_phob_thumbnail_window().LayoutLine();
    return line;
    }

// C=245 H=30 W=72 b= l=10 r= t=58 
// Remark                    : Second shadow rectangle.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 32%) : popup_cale_events_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Thumbnail_pop_up_window_elements_Line_2()
    {
	// MurrayR 21/12/04: One thumbnail window specified for all sizes
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_phob_thumbnail_window().LayoutLine();
    return line;
    }

// C= H=88 W=72 b= l=8 r= t=6 
// Remark                    : tnCIF90
// Parent                    : 
// Parent API                : 
// Scale API match    ( 32%) : popup_cale_events_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Thumbnail_pop_up_window_elements_Line_3()
    {
	// MurrayR 21/12/04: One thumbnail window specified for all sizes
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_phob_thumbnail_window().LayoutLine();
    return line;
    }

// C=221 H=80 W=60 b= l=14 r= t=12 
// Remark                    : Shadow rectangle.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 32%) : popup_cale_events_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Thumbnail_pop_up_window_elements_Line_4()
    {
	// MurrayR 21/12/04: One thumbnail window specified for all sizes
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_phob_thumbnail_window().LayoutLine();
    return line;
    }

// C=245 H=30 W=60 b= l=14 r= t=58 
// Remark                    : Second shadow rectangle.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 32%) : popup_cale_events_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Thumbnail_pop_up_window_elements_Line_5()
    {
	// MurrayR 21/12/04: One thumbnail window specified for all sizes
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_phob_thumbnail_window().LayoutLine();
    return line;
    }

// C= H=80 W=60 b= l=12 r= t=10 
// Remark                    : tnVGA90
// Parent                    : 
// Parent API                : 
// Scale API match    ( 32%) : popup_cale_events_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Thumbnail_pop_up_window_elements_Line_6() 
    {
	// MurrayR 21/12/04: One thumbnail window specified for all sizes
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_phob_thumbnail_window().LayoutLine();
    return line;
    }

// C=221 H=96 W=80 b= l=4 r= t=4 
// Remark                    : Shadow rectangle.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 32%) : popup_cale_events_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Thumbnail_pop_up_window_elements_Line_7()
    {
	// MurrayR 21/12/04: One thumbnail window specified for all sizes
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_phob_thumbnail_window().LayoutLine();
    return line;
    }

// C=245 H=30 W=80 b= l=14 r= t=58 
// Remark                    : Second shadow rectangle.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 32%) : popup_cale_events_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Thumbnail_pop_up_window_elements_Line_8()
    {
	// MurrayR 21/12/04: One thumbnail window specified for all sizes
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_phob_thumbnail_window().LayoutLine();
    return line;
    }

// C= H=96 W=80 b= l=2 r= t=2 
// Remark                    : tnCOM
// Parent                    : 
// Parent API                : 
// Scale API match    ( 32%) : popup_cale_events_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Thumbnail_pop_up_window_elements_Line_9() 
    {
	// MurrayR 21/12/04: One thumbnail window specified for all sizes
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_phob_thumbnail_window().LayoutLine();
    return line;
    }

// C=221 H=60 W=80 b= l=4 r= t=12 
// Remark                    : Shadow rectangle.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 31%) : popup_cale_events_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Thumbnail_pop_up_window_elements_Line_10() 
    {
	// MurrayR 21/12/04: One thumbnail window specified for all sizes
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_phob_thumbnail_window().LayoutLine();
    return line;
    }

// C=245 H=30 W=80 b= l=4 r= t=58 
// Remark                    : Second shadow rectangle.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 31%) : popup_cale_events_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Thumbnail_pop_up_window_elements_Line_11() 
    {
	// MurrayR 21/12/04: One thumbnail window specified for all sizes
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_phob_thumbnail_window().LayoutLine();
    return line;
    }

// C= H=60 W=80 b= l=2 r= t=10 
// Remark                    : tnVGA
// Parent                    : 
// Parent API                : 
// Scale API match    ( 31%) : popup_cale_events_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Thumbnail_pop_up_window_elements_Line_12()
    {
	// MurrayR 21/12/04: One thumbnail window specified for all sizes
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_phob_thumbnail_window().LayoutLine();
    return line;
    }

// C=221 H=72 W=80 b= l=4 r= t=8 
// Remark                    : Shadow rectangle.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 31%) : popup_cale_events_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Thumbnail_pop_up_window_elements_Line_13()
    {
	// MurrayR 21/12/04: One thumbnail window specified for all sizes
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_phob_thumbnail_window().LayoutLine();
    return line;
    }

// C=245 H=30 W=80 b= l=4 r= t=58 
// Remark                    : Second shadow rectangle.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 31%) : popup_cale_events_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Thumbnail_pop_up_window_elements_Line_14()
    {
	// MurrayR 21/12/04: One thumbnail window specified for all sizes
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_phob_thumbnail_window().LayoutLine();
    return line;
    }

// C= H=60 W=80 b= l=2 r= t=6 
// Remark                    : tnCIF
// Parent                    : 
// Parent API                : 
// Scale API match    ( 31%) : popup_cale_events_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Thumbnail_pop_up_window_elements_Line_15()
    {
	// MurrayR 21/12/04: One thumbnail window specified for all sizes
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_phob_thumbnail_window().LayoutLine();
    return line;
    }

// C=221 H= W= b= l=-2 r= t=-2 
// Remark                    : Shadow rectangle.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 31%) : popup_cale_events_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Thumbnail_pop_up_window_elements_Line_16() 
    {
	// MurrayR 21/12/04: One thumbnail window specified for all sizes
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_phob_thumbnail_window().LayoutLine();
    return line;
    }

// C=245 H=30 W= b= l=-2 r= t=-2 
// Remark                    : Second shadow rectangle.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 31%) : popup_cale_events_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Thumbnail_pop_up_window_elements_Line_17()
    {
	// MurrayR 21/12/04: One thumbnail window specified for all sizes
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_phob_thumbnail_window().LayoutLine();
    return line;
    }

// C= H=96 W=80 b= l= r= t= 
// Remark                    : Any other size.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 31%) : popup_cale_events_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Thumbnail_pop_up_window_elements_Line_18()
    {
	// MurrayR 21/12/04: One thumbnail window specified for all sizes
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_phob_thumbnail_window().LayoutLine();
    return line;
    }


// LAF Table : Call status pop-up window elements
// C= H=66 W=72 b= l=0 r= t=0 
// Remark                    : Status window background graphics.
// Parent                    : popup_call_status_window
// Parent API                : popup_call_status_window
// Scale API match    ( 54%) : popup_call_status_window_g1
// Scale parent match (100%) : popup_call_status_window
TAknWindowLineLayout Call_status_pop_up_window_elements_Line_1()
    {
	// MurrayR 01/12/04: good match
    // MAN: 25.8.2005 (landscape call statusbubble redesign)
    TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_status_window_g1(varietyIndex).LayoutLine();
    return line;
    }

// C= H=46 W=50 b= l=10 r= t=14 
// Remark                    : Activeheldmutedwaiting call indication.
// Parent                    : popup_call_status_window
// Parent API                : popup_call_status_window
// Scale API match    ( 54%) : popup_call_status_window_g1
// Scale parent match (100%) : popup_call_status_window
TAknWindowLineLayout Call_status_pop_up_window_elements_Line_2()
    {
	// MurrayR 01/12/04: good match
    // MAN: 25.8.2005 (landscape call statusbubble redesign)
    TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_status_window_g2(varietyIndex).LayoutLine();
    return line;
    }

// C= H=12 W=24 b= l=36 r= t=42 
// Remark                    : Data callfax call2ndline indication.
// Parent                    : popup_call_status_window
// Parent API                : popup_call_status_window
// Scale API match    ( 54%) : popup_call_status_window_g1
// Scale parent match (100%) : popup_call_status_window
TAknWindowLineLayout Call_status_pop_up_window_elements_Line_3() 
    {
	// MurrayR 01/12/04: good match, except table in different order
    // MAN: 25.8.2005 (landscape call statusbubble redesign)
    if (!Layout_Meta_Data::IsLandscapeOrientation())
        {
        TAknWindowLineLayout line = AknLayoutScalable_Apps::call_type_pane().LayoutLine();
        return line;
        }
    else
        {
        return EmptyWindowLayout(); // This is not shown in landscape mode. Bubble is too small.
        }
    }

// C= H=16 W=18 b= l=14 r= t=14 
// Remark                    : Cyphering off indication.
// Parent                    : popup_call_status_window
// Parent API                : popup_call_status_window
// Scale API match    ( 54%) : popup_call_status_window_g1
// Scale parent match (100%) : popup_call_status_window
TAknWindowLineLayout Call_status_pop_up_window_elements_Line_4()
    {
	// MurrayR 01/12/04: good match, except table in different order
    // MAN: 25.8.2005 (landscape call statusbubble redesign)
    if (!Layout_Meta_Data::IsLandscapeOrientation())
        {
        TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_status_window_g3(0).LayoutLine();
        return line;
        }
    else
        {
        return EmptyWindowLayout(); // This is not shown in landscape mode. Bubble is too small.
        }
    }


// LAF Table : Incoming call pop-up window elements
// C= H=52 W=52 b= l=12 r= t=2 
// Remark                    : Animated incoming call indication.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 34%) : popup_cale_events_window_ParamLimits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements_Line_1()
    {
	// MurrayR 02/12/04: This looks like a good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_audio_in_window_g1(0).LayoutLine();
    return line;
    }

// C= H=26 W=26 b= l=38 r= t=30 
// Remark                    : Number type icon.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 34%) : popup_cale_events_window_ParamLimits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements_Line_2()
    {
	// MurrayR 02/12/04: It's a slightly different size and position, but looks about right
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_audio_in_window_g2(0).LayoutLine();
    return line;
    }

// C=221 H=72 W=88 b= l=242 r= t=28 
// Remark                    : Thumbnail image shadow.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 34%) : popup_cale_events_window_ParamLimits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements_Line_3()
    {
	// MurrayR 02/12/04: Thumbnail shadows & different sizes of thumbnames are not specified.
	// so returning the thumbnail pane for all of them.
	// TODO: improve or remove this API, depending on whether better layout tool data arrives.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane().LayoutLine();
    return line;
    }

// C= H=72 W=88 b= l=240 r= t=26 
// Remark                    : tnCIF
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 34%) : popup_cale_events_window_ParamLimits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements_Line_4()
    {
	// MurrayR 02/12/04: Thumbnail shadows & different sizes of thumbnames are not specified.
	// so returning the thumbnail pane for all of them.
	// TODO: improve or remove this API, depending on whether better layout tool data arrives.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane().LayoutLine();
    return line;
    }

// C=221 H=84 W=72 b= l=258 r= t=22 
// Remark                    : Thumbnail image shadow.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 34%) : popup_cale_events_window_ParamLimits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements_Line_5() 
    {
	// MurrayR 02/12/04: Thumbnail shadows & different sizes of thumbnames are not specified.
	// so returning the thumbnail pane for all of them.
	// TODO: improve or remove this API, depending on whether better layout tool data arrives.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane().LayoutLine();
    return line;
    }

// C= H=84 W=72 b= l=256 r= t=20 
// Remark                    : tnCIF90
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 34%) : popup_cale_events_window_ParamLimits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements_Line_6()
    {
	// MurrayR 02/12/04: Thumbnail shadows & different sizes of thumbnames are not specified.
	// so returning the thumbnail pane for all of them.
	// TODO: improve or remove this API, depending on whether better layout tool data arrives.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane().LayoutLine();
    return line;
    }

// C=221 H=60 W=80 b= l=250 r= t=34 
// Remark                    : Thumbnail image shadow.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 34%) : popup_cale_events_window_ParamLimits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements_Line_7() 
    {
	// MurrayR 02/12/04: Thumbnail shadows & different sizes of thumbnames are not specified.
	// so returning the thumbnail pane for all of them.
	// TODO: improve or remove this API, depending on whether better layout tool data arrives.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane().LayoutLine();
    return line;
    }

// C= H=60 W=80 b= l=248 r= t=32 
// Remark                    : tnVGA
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 34%) : popup_cale_events_window_ParamLimits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements_Line_8() 
    {
	// MurrayR 02/12/04: Thumbnail shadows & different sizes of thumbnames are not specified.
	// so returning the thumbnail pane for all of them.
	// TODO: improve or remove this API, depending on whether better layout tool data arrives.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane().LayoutLine();
    return line;
    }

// C=221 H=80 W=60 b= l=270 r= t=24 
// Remark                    : Thumbnail image shadow.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 34%) : popup_cale_events_window_ParamLimits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements_Line_9() 
    {
	// MurrayR 02/12/04: Thumbnail shadows & different sizes of thumbnames are not specified.
	// so returning the thumbnail pane for all of them.
	// TODO: improve or remove this API, depending on whether better layout tool data arrives.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane().LayoutLine();
    return line;
    }

// C= H=80 W=60 b= l=268 r= t=22 
// Remark                    : tnVGA90
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 33%) : popup_cale_events_window_ParamLimits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements_Line_10() 
    {
	// MurrayR 02/12/04: Thumbnail shadows & different sizes of thumbnames are not specified.
	// so returning the thumbnail pane for all of them.
	// TODO: improve or remove this API, depending on whether better layout tool data arrives.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane().LayoutLine();
    return line;
    }

// C=221 H=88 W=80 b= l=250 r= t=20 
// Remark                    : Thumbnail image shadow.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 33%) : popup_cale_events_window_ParamLimits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements_Line_11()
    {
	// MurrayR 02/12/04: Thumbnail shadows & different sizes of thumbnames are not specified.
	// so returning the thumbnail pane for all of them.
	// TODO: improve or remove this API, depending on whether better layout tool data arrives.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane().LayoutLine();
    return line;
    }

// C= H=88 W=80 b= l=248 r= t=18 
// Remark                    : tnCOM
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 33%) : popup_cale_events_window_ParamLimits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements_Line_12()
    {
	// MurrayR 02/12/04: Thumbnail shadows & different sizes of thumbnames are not specified.
	// so returning the thumbnail pane for all of them.
	// TODO: improve or remove this API, depending on whether better layout tool data arrives.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane().LayoutLine();
    return line;
    }

// C=221 H= W= b= l=-2 r= t=-2 
// Remark                    : Shadow.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 33%) : popup_cale_events_window_ParamLimits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements_Line_13()
    {
	// MurrayR 02/12/04: Thumbnail shadows & different sizes of thumbnames are not specified.
	// so returning the thumbnail pane for all of them.
	// TODO: improve or remove this API, depending on whether better layout tool data arrives.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane().LayoutLine();
    return line;
    }

// C= H=88 W=88 b= l= r={-22, -22} t= 
// Remark                    : Any other size.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 33%) : popup_cale_events_window_ParamLimits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements_Line_14(TInt /*aIndex_r*/)
    {
	// MurrayR 02/12/04: Thumbnail shadows & different sizes of thumbnames are not specified.
	// so returning the thumbnail pane for all of them.
	// TODO: improve or remove this API, depending on whether better layout tool data arrives.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane().LayoutLine();
    return line;
    }

// C= H=16 W=18 b= l=12 r= t=4 
// Remark                    : Cyphering off indication.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 33%) : popup_cale_events_window_ParamLimits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements_Line_15()
    {
	// MurrayR 02/12/04: This looks quite a good match.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_audio_in_window_g3(0).LayoutLine();
    return line;
    }


// LAF Table : Incoming call pop-up window texts
// B={52, 88}[aCommon1] C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={262, 262, , 188, 176, 168, 160}[aCommon2] l={70, 70}[aCommon1] r={20, 20, , 94, 106, 114, 122}[aCommon2] 
// Remark                    : CLI and the text calling or Callif there is no CLI available. Two lines of text. Image width is 30. Image width is 36. Image width is 40. Image width is 44.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 40%) : popup_call_audio_in_window_t1_ParamLimits
// Scale parent match (100%) : popup_call_audio_in_window
TAknTextLineLayout Incoming_call_pop_up_window_texts_Line_1(TInt aCommon1, TInt aCommon2) 
    {
	// MurrayR 03/12/04: TODO - the numbers do not look right here
	TInt lineNumber = 0;
	switch (aCommon1)
		{
		case 0:
			lineNumber = 0;
			break;
		default:
			lineNumber = 1;
			break;
		}
	// LeonB 26.05.2005: fixed for thumbnail
	TBool thumbnail = aCommon2 >= 2;
    TInt varietyIndex = thumbnail ? 0 : 1; // variety 0 = thumb. variety 1 = no thumb
	TAknTextLineLayout textLine = AknLayoutScalable_Apps::popup_call_audio_in_window_t(lineNumber, varietyIndex).LayoutLine();
    return textLine;
    }


// B={52, 88, 124}[aCommon1] C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={262, 262, , 188, 176, 168, 160}[aCommon2] l={70, 70, 70}[aCommon1] r={20, 20, , 94, 106, 114, 122}[aCommon2] 
// Remark                    : CLI and the text calling or Callif there is no CLI available. Two lines of text. Image width is 30. Image width is 36. Image width is 40. Image width is 44.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 40%) : popup_call_audio_in_window_t1_ParamLimits
// Scale parent match (100%) : popup_call_audio_in_window
TAknTextLineLayout Incoming_call_pop_up_window_texts_Line_2(TInt aCommon1, TInt aCommon2) 
    {
    // 18.11.2005
	TInt lineNumber = aCommon1;
	TBool thumbnail = aCommon2 > 2;
    TInt varietyIndex = thumbnail ? 0 : 2; // variety 0 = thumb. variety 2 = no thumb
    if (lineNumber >= 2)
        {
        lineNumber = 2;
        varietyIndex = 0; // variety 0 = no thumb for 3rd line.
        }
    TAknTextLineLayout textLine = AknLayoutScalable_Apps::popup_call_audio_in_window_t(lineNumber, varietyIndex).LayoutLine();
    return textLine;
    }



// LAF Table : Incoming call pop-up window graphics
// C=0 H={126, 154} W=352 b= l= r=0 t=0 
// Remark                    : A rectangle to cover the main pane items.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 40%) : popup_grid_large_graphic_window_ParamLimits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_graphics_Line_1(TInt /*aIndex_H*/)
    {
	// MurrayR 03/12/04: These graphics are done with skins in new layout world.
	// this line gives approximately the same area.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::bg_popup_call_pane_cp(0).LayoutLine();
    return line;
    }

// C=86 H={98, 126} W=336 b= l=12 r= t=20 
// Remark                    : Second shadow.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 40%) : popup_grid_large_graphic_window_ParamLimits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_graphics_Line_2(TInt /*aIndex_H*/)
    {
	// MurrayR 03/12/04: These graphics are done with skins in new layout world.
	// this line gives approximately the same area.
    return ZeroWindowLayout();
    }

// C=221 H={100, 128} W=338 b= l=8 r= t=16 
// Remark                    : First shadow.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 40%) : popup_grid_large_graphic_window_ParamLimits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_graphics_Line_3(TInt /*aIndex_H*/)
    {
	// MurrayR 03/12/04: These graphics are done with skins in new layout world.
	// this line gives approximately the same area.
    return ZeroWindowLayout();
    }

// C=215 H={102, 130} W=340 b= l=4 r= t=12 
// Remark                    : Outline frame. The frame width is one pixel.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 40%) : popup_grid_large_graphic_window_ParamLimits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_graphics_Line_4(TInt /*aIndex_H*/)
    {
	// MurrayR 03/12/04: These graphics are done with skins in new layout world.
	// this line gives approximately the same area.
    return ZeroWindowLayout();
    }

// C=0 H={98, 126} W=336 b= l=6 r= t=14 
// Remark                    : Inside area.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 40%) : popup_grid_large_graphic_window_ParamLimits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_graphics_Line_5(TInt /*aIndex_H*/)
    {
	// MurrayR 03/12/04: These graphics are done with skins in new layout world.
	// this line gives approximately the same area.
    return ZeroWindowLayout();
    }


// LAF Table : Incoming call pop-up window elements (NE)
// C= H=52 W=52 b= l=12 r= t=2 
// Remark                    : Animated incoming call indication.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 30%) : popup_cale_events_window_g_Limits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements__NE__Line_1() 
    {
	// MurrayR 08/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_audio_in_window_g1(0).LayoutLine();
    return line;
    }

// C= H=26 W=26 b= l=38 r= t=30 
// Remark                    : Number type icon.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 30%) : popup_cale_events_window_g_Limits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements__NE__Line_2() 
    {
	// MurrayR 08/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_audio_in_window_g2(0).LayoutLine();
    return line;
    }

// C=221 H=72 W=88 b= l=222 r= t=28 
// Remark                    : Thumbnail image shadow.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 30%) : popup_cale_events_window_g_Limits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements__NE__Line_3()
    {
	// MurrayR 08/12/04: Only one thumbnail pane is specified
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane().LayoutLine();
    return line;
    }

// C= H=72 W=88 b= l=220 r= t=26 
// Remark                    : tnCIF
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 30%) : popup_cale_events_window_g_Limits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements__NE__Line_4() 
    {
	// MurrayR 08/12/04: Only one thumbnail pane is specified
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane().LayoutLine();
    return line;
    }

// C=221 H=84 W=72 b= l=238 r= t=22 
// Remark                    : Thumbnail image shadow.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 30%) : popup_cale_events_window_g_Limits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements__NE__Line_5() 
    {
	// MurrayR 08/12/04: Only one thumbnail pane is specified
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane().LayoutLine();
    return line;
    }

// C= H=84 W=72 b= l=236 r= t=20 
// Remark                    : tnCIF90
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 30%) : popup_cale_events_window_g_Limits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements__NE__Line_6()
    {
	// MurrayR 08/12/04: Only one thumbnail pane is specified
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane().LayoutLine();
    return line;
    }

// C=221 H=60 W=80 b= l=230 r= t=34 
// Remark                    : Thumbnail image shadow.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 30%) : popup_cale_events_window_g_Limits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements__NE__Line_7()
    {
	// MurrayR 08/12/04: Only one thumbnail pane is specified
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane().LayoutLine();
    return line;
    }

// C= H=60 W=80 b= l=228 r= t=32 
// Remark                    : tnVGA
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 30%) : popup_cale_events_window_g_Limits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements__NE__Line_8()
    {
	// MurrayR 08/12/04: Only one thumbnail pane is specified
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane().LayoutLine();
    return line;
    }

// C=221 H=80 W=60 b= l=250 r= t=24 
// Remark                    : Thumbnail image shadow.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 30%) : popup_cale_events_window_g_Limits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements__NE__Line_9()
    {
	// MurrayR 08/12/04: Only one thumbnail pane is specified
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane().LayoutLine();
    return line;
    }

// C= H=80 W=60 b= l=248 r= t=22 
// Remark                    : tnVGA90
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 29%) : popup_cale_events_window_g_Limits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements__NE__Line_10()
    {
	// MurrayR 08/12/04: Only one thumbnail pane is specified
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane().LayoutLine();
    return line;
    }

// C=221 H=88 W=80 b= l=230 r= t=20 
// Remark                    : Thumbnail image shadow.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 29%) : popup_cale_events_window_g_Limits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements__NE__Line_11()
    {
	// MurrayR 08/12/04: Only one thumbnail pane is specified
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane().LayoutLine();
    return line;
    }

// C= H=88 W=80 b= l=228 r= t=18 
// Remark                    : tnCOM
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 29%) : popup_cale_events_window_g_Limits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements__NE__Line_12()
    {
	// MurrayR 08/12/04: Only one thumbnail pane is specified
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane().LayoutLine();
    return line;
    }

// C=221 H= W= b= l=-2 r= t=-2 
// Remark                    : Shadow.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 29%) : popup_cale_events_window_g_Limits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements__NE__Line_13()
    {
	// MurrayR 08/12/04: Only one thumbnail pane is specified
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane().LayoutLine();
    return line;
    }

// C= H=88 W=88 b= l= r=-42 t= 
// Remark                    : Any other size.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 29%) : popup_cale_events_window_g_Limits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements__NE__Line_14()
    {
	// MurrayR 08/12/04: Only one thumbnail pane is specified
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane().LayoutLine();
    return line;
    }

// C= H=16 W=18 b= l=12 r= t=4 
// Remark                    : Cyphering off indication.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 29%) : popup_cale_events_window_g_Limits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_elements__NE__Line_15()
    {
	// MurrayR 08/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_audio_in_window_g3(0).LayoutLine();
    return line;
    }


// LAF Table : Incoming call pop-up window texts (NE)
// B={52, 88}[aCommon1] C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={242, 242, , 168, 156, 148, 140}[aCommon2] l={70, 70}[aCommon1] r={40, 40, , 114, 126, 134, 142}[aCommon2] 
// Remark                    : CLI and the text calling or Callif there is no CLI available. Two lines of text. Image width is 30. Image width is 36. Image width is 40. Image width is 44.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 32%) : popup_call_audio_in_window_t_Limits
// Scale parent match (100%) : popup_call_audio_in_window
TAknTextLineLayout Incoming_call_pop_up_window_texts__NE__Line_1(TInt aCommon1, TInt aCommon2)
    {
	// two lines of text
	TInt lineIndex = aCommon1;
	TBool thumbnail = aCommon2 >= 2;
    TInt varietyIndex = thumbnail ? 0 : 1; // variety 0 = thumb. variety 1 = no thumb
    TAknTextLineLayout textLine = AknLayoutScalable_Apps::popup_call_audio_in_window_t(lineIndex, varietyIndex).LayoutLine();
    return textLine;
    }


// B={38, 68, 98}[aCommon1] C=215 Font=ELatinBold12_Scaled J=ELayoutAlignLeft W={242, 242, 242, 168, 156, 148, 140}[aCommon2] l={70, 70, 70}[aCommon1] r={40, 40, 40, 114, 126, 134, 142}[aCommon2] 
// Remark                    : CLI and the text calling or Callif there is no CLI available. Two lines of text. Image width is 30. Image width is 36. Image width is 40. Image width is 44.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 32%) : popup_call_audio_in_window_t_Limits
// Scale parent match (100%) : popup_call_audio_in_window
TAknTextLineLayout Incoming_call_pop_up_window_texts__NE__Line_2(TInt aCommon1, TInt aCommon2)
    {
    // 18.11.2005
	TInt lineNumber = aCommon1;
	TBool thumbnail = aCommon2 > 2;
    TInt varietyIndex = thumbnail ? 0 : 2; // variety 0 = thumb. variety 2 = no thumb
    if (lineNumber >= 2)
        {
        lineNumber = 2;
        varietyIndex = 0; // variety 0 = no thumb for 3rd line.
        }
	TAknTextLineLayout textLine = AknLayoutScalable_Apps::popup_call_audio_in_window_t(lineNumber, varietyIndex).LayoutLine();
    return textLine;
    }



// LAF Table : Incoming call pop-up window graphics (NE)
// C=0 H=126 W=352 b= l=0 r= t=0 
// Remark                    : A rectangle to cover the main pane items.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 32%) : list_single_graphic_popup_wml_pane_g_Limits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_graphics__NE__Line_1()
    {
	// MurrayR 08/12/04: Another of these graphics specs - return overall rectangle for this one
    TAknWindowLineLayout line = AknLayoutScalable_Apps::bg_popup_call_pane_cp(0).LayoutLine();
    return line;
    }
// C=86 H=98 W=316 b= l=12 r= t=20 
// Remark                    : Second shadow.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 32%) : list_single_graphic_popup_wml_pane_g_Limits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_graphics__NE__Line_2()
    {
	// MurrayR 08/12/04: Shadows should be handled by skins
    return ZeroWindowLayout();
    }

// C=221 H=100 W=318 b= l=8 r= t=16 
// Remark                    : First shadow.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 32%) : list_single_graphic_popup_wml_pane_g_Limits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_graphics__NE__Line_3()
    {
	// MurrayR 08/12/04: Shadows should be handled by skins
    return ZeroWindowLayout();
    }

// C=215 H=102 W=320 b= l=4 r= t=12 
// Remark                    : Outline frame. The frame width is one pixel.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 32%) : list_single_graphic_popup_wml_pane_g_Limits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_graphics__NE__Line_4()
    {
	// MurrayR 08/12/04: Shadows should be handled by skins
    return ZeroWindowLayout();
    }

// C=0 H=98 W=316 b= l=6 r= t=14 
// Remark                    : Inside area.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 32%) : list_single_graphic_popup_wml_pane_g_Limits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Incoming_call_pop_up_window_graphics__NE__Line_5()
    {
	// MurrayR 08/12/04: Shadows should be handled by skins
    return ZeroWindowLayout();
    }


// LAF Table : Outgoing call pop-up window elements (held)
// C= H=52 W=52 b= l=32 r= t=2 
// Remark                    : Animated outgoing call indication.
// Parent                    : popup_call_audio_out_window
// Parent API                : popup_call_audio_out_window
// Scale API match    ( 29%) : popup_call_audio_out_window_g_Limits
// Scale parent match (100%) : popup_call_audio_out_window
TAknWindowLineLayout Outgoing_call_pop_up_window_elements__held__Line_1()
    {
	// MurrayR 06/12/04: Layout tool has options that this API doesn't
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_audio_out_window_g1(0).LayoutLine();
    return line;
    }

// C= H=26 W=26 b= l=58 r= t=30 
// Remark                    : Number type icon.
// Parent                    : popup_call_audio_out_window
// Parent API                : popup_call_audio_out_window
// Scale API match    ( 29%) : popup_call_audio_out_window_g_Limits
// Scale parent match (100%) : popup_call_audio_out_window
TAknWindowLineLayout Outgoing_call_pop_up_window_elements__held__Line_2()
    {
	// MurrayR 06/12/04: Looks ok.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_audio_out_window_g2(0).LayoutLine();
    return line;
    }

// C=221 H=72 W=88 b= l=242 r= t=28 
// Remark                    : Thumbnail image shadow.
// Parent                    : popup_call_audio_out_window
// Parent API                : popup_call_audio_out_window
// Scale API match    ( 29%) : popup_call_audio_out_window_g_Limits
// Scale parent match (100%) : popup_call_audio_out_window
TAknWindowLineLayout Outgoing_call_pop_up_window_elements__held__Line_3()
    {
	// MurrayR 06/12/04: Layout tool only specifies one thumbnail pane.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane_cp02().LayoutLine();
    return line;
    }

// C= H=72 W=88 b= l=240 r= t=26 
// Remark                    : tnCIF
// Parent                    : popup_call_audio_out_window
// Parent API                : popup_call_audio_out_window
// Scale API match    ( 29%) : popup_call_audio_out_window_g_Limits
// Scale parent match (100%) : popup_call_audio_out_window
TAknWindowLineLayout Outgoing_call_pop_up_window_elements__held__Line_4()
    {
	// MurrayR 06/12/04: Layout tool only specifies one thumbnail pane.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane_cp02().LayoutLine();
    return line;
    }

// C=221 H=84 W=72 b= l=258 r= t=22 
// Remark                    : Thumbnail image shadow.
// Parent                    : popup_call_audio_out_window
// Parent API                : popup_call_audio_out_window
// Scale API match    ( 29%) : popup_call_audio_out_window_g_Limits
// Scale parent match (100%) : popup_call_audio_out_window
TAknWindowLineLayout Outgoing_call_pop_up_window_elements__held__Line_5()
    {
	// MurrayR 06/12/04: Layout tool only specifies one thumbnail pane.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane_cp02().LayoutLine();
    return line;
    }

// C= H=84 W=72 b= l=256 r= t=20 
// Remark                    : tnCIF90
// Parent                    : popup_call_audio_out_window
// Parent API                : popup_call_audio_out_window
// Scale API match    ( 29%) : popup_call_audio_out_window_g_Limits
// Scale parent match (100%) : popup_call_audio_out_window
TAknWindowLineLayout Outgoing_call_pop_up_window_elements__held__Line_6() 
    {
	// MurrayR 06/12/04: Layout tool only specifies one thumbnail pane.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane_cp02().LayoutLine();
    return line;
    }

// C=221 H=60 W=80 b= l=250 r= t=34 
// Remark                    : Thumbnail image shadow.
// Parent                    : popup_call_audio_out_window
// Parent API                : popup_call_audio_out_window
// Scale API match    ( 29%) : popup_call_audio_out_window_g_Limits
// Scale parent match (100%) : popup_call_audio_out_window
TAknWindowLineLayout Outgoing_call_pop_up_window_elements__held__Line_7() 
    {
	// MurrayR 06/12/04: Layout tool only specifies one thumbnail pane.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane_cp02().LayoutLine();
    return line;
    }

// C= H=60 W=80 b= l=248 r= t=32 
// Remark                    : tnVGA
// Parent                    : popup_call_audio_out_window
// Parent API                : popup_call_audio_out_window
// Scale API match    ( 29%) : popup_call_audio_out_window_g_Limits
// Scale parent match (100%) : popup_call_audio_out_window
TAknWindowLineLayout Outgoing_call_pop_up_window_elements__held__Line_8() 
    {
	// MurrayR 06/12/04: Layout tool only specifies one thumbnail pane.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane_cp02().LayoutLine();
    return line;
    }

// C=221 H=80 W=60 b= l=270 r= t=24 
// Remark                    : Thumbnail image shadow.
// Parent                    : popup_call_audio_out_window
// Parent API                : popup_call_audio_out_window
// Scale API match    ( 29%) : popup_call_audio_out_window_g_Limits
// Scale parent match (100%) : popup_call_audio_out_window
TAknWindowLineLayout Outgoing_call_pop_up_window_elements__held__Line_9()
    {
	// MurrayR 06/12/04: Layout tool only specifies one thumbnail pane.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane_cp02().LayoutLine();
    return line;
    }

// C= H=80 W=60 b= l=268 r= t=22 
// Remark                    : tnVGA90
// Parent                    : popup_call_audio_out_window
// Parent API                : popup_call_audio_out_window
// Scale API match    ( 28%) : popup_call_audio_out_window_g_Limits
// Scale parent match (100%) : popup_call_audio_out_window
TAknWindowLineLayout Outgoing_call_pop_up_window_elements__held__Line_10() 
    {
	// MurrayR 06/12/04: Layout tool only specifies one thumbnail pane.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane_cp02().LayoutLine();
    return line;
    }

// C=221 H=88 W=80 b= l=250 r= t=20 
// Remark                    : Thumbnail image shadow.
// Parent                    : popup_call_audio_out_window
// Parent API                : popup_call_audio_out_window
// Scale API match    ( 28%) : popup_call_audio_out_window_g_Limits
// Scale parent match (100%) : popup_call_audio_out_window
TAknWindowLineLayout Outgoing_call_pop_up_window_elements__held__Line_11()
    {
	// MurrayR 06/12/04: Layout tool only specifies one thumbnail pane.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane_cp02().LayoutLine();
    return line;
    }

// C= H=88 W=80 b= l=248 r= t=18 
// Remark                    : tnCOM
// Parent                    : popup_call_audio_out_window
// Parent API                : popup_call_audio_out_window
// Scale API match    ( 28%) : popup_call_audio_out_window_g_Limits
// Scale parent match (100%) : popup_call_audio_out_window
TAknWindowLineLayout Outgoing_call_pop_up_window_elements__held__Line_12()
    {
	// MurrayR 06/12/04: Layout tool only specifies one thumbnail pane.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane_cp02().LayoutLine();
    return line;
    }

// C=221 H= W= b= l=-2 r= t=-2 
// Remark                    : Shadow.
// Parent                    : popup_call_audio_out_window
// Parent API                : popup_call_audio_out_window
// Scale API match    ( 28%) : popup_call_audio_out_window_g_Limits
// Scale parent match (100%) : popup_call_audio_out_window
TAknWindowLineLayout Outgoing_call_pop_up_window_elements__held__Line_13()
    {
	// MurrayR 06/12/04: Layout tool only specifies one thumbnail pane.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane_cp02().LayoutLine();
    return line;
    }

// C= H=88 W=88 b= l= r=-22 t= 
// Remark                    : Any other size.
// Parent                    : popup_call_audio_out_window
// Parent API                : popup_call_audio_out_window
// Scale API match    ( 28%) : popup_call_audio_out_window_g_Limits
// Scale parent match (100%) : popup_call_audio_out_window
TAknWindowLineLayout Outgoing_call_pop_up_window_elements__held__Line_14() 
    {
	// MurrayR 06/12/04: Layout tool only specifies one thumbnail pane.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane_cp02().LayoutLine();
    return line;
    }

// C= H=16 W=18 b= l=32 r= t=4 
// Remark                    : Cyphering off indication.
// Parent                    : popup_call_audio_out_window
// Parent API                : popup_call_audio_out_window
// Scale API match    ( 28%) : popup_call_audio_out_window_g_Limits
// Scale parent match (100%) : popup_call_audio_out_window
TAknWindowLineLayout Outgoing_call_pop_up_window_elements__held__Line_15()
    {
	// MurrayR 06/12/04: Layout tool has parameterisation not specified in old layout
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_audio_out_window_g3(0).LayoutLine();
    return line;
    }


// LAF Table : Outgoing call pop-up window texts (held)
// B={52, 88}[aCommon1] C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={242, 242, , 168, 156, 148, 140}[aCommon2] l={90, 90}[aCommon1] r={20, 20, , 94, 106, 114, 122}[aCommon2] 
// Remark                    : CLI and the text calling or Callif there is no CLI available. Two lines of text. Image width is 30. Image width is 36. Image width is 40. Image width is 44.
// Parent                    : popup_call_audio_out_window
// Parent API                : popup_call_audio_out_window
// Scale API match    ( 33%) : popup_call_audio_out_window_t_Limits
// Scale parent match (100%) : popup_call_audio_out_window
TAknTextLineLayout Outgoing_call_pop_up_window_texts__held__Line_1(TInt aCommon1, TInt aCommon2) 
    {
	TInt lineIndex = (aCommon1 == 0) ? 0 : 1;
	TBool thumbnail = aCommon2 >= 2;
    TInt varietyIndex = thumbnail ? 0 : 1; // variety 0 = thumb. variety 1 = no thumb
	TAknTextLineLayout textLine = AknLayoutScalable_Apps::popup_call_audio_out_window_t(lineIndex, varietyIndex).LayoutLine();
    return textLine;
    }


// LAF Table : Outgoing call pop-up window graphics (held)
// C= H=126 W=352 b=0 l= r=0 t= 
// Remark                    : Background pop-up window graphics. Alerting or disconnected variations.
// Parent                    : popup_call_audio_in_window
// Parent API                : popup_call_audio_in_window
// Scale API match    ( 31%) : popup_call_audio_out_window_g_Limits
// Scale parent match (100%) : popup_call_audio_in_window
TAknWindowLineLayout Outgoing_call_pop_up_window_graphics__held__Line_1()
    {
	// MurrayR 06/12/04: A resonable match. Parameters don't match of course.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::bg_popup_call_pane_cp01(0).LayoutLine();
    return line;
    }

// LAF Table : Outgoing call pop-up window elements (held NE)
// C= H=46 W=50 b= l=34 r= t=12 
// Remark                    : Animated outgoing call indication.
// Parent                    : popup_call_audio_out_window
// Parent API                : popup_call_audio_out_window
// Scale API match    ( 27%) : popup_call_audio_out_window_g_Limits
// Scale parent match (100%) : popup_call_audio_out_window
TAknWindowLineLayout Outgoing_call_pop_up_window_elements__held_NE__Line_1() 
    {
	// MurrayR 06/12/04: Looks like a good match with option 2
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_audio_out_window_g1(2).LayoutLine();
    return line;
    }

// C= H=12 W=24 b= l=60 r= t=40 
// Remark                    : Data call or fax call indication.
// Parent                    : popup_call_audio_out_window
// Parent API                : popup_call_audio_out_window
// Scale API match    ( 27%) : popup_call_audio_out_window_g_Limits
// Scale parent match (100%) : popup_call_audio_out_window
TAknWindowLineLayout Outgoing_call_pop_up_window_elements__held_NE__Line_2()
    {
	// MurrayR 06/12/04: Looks like a good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_type_pane_cp022().LayoutLine();
    return line;
    }

// C= H=16 W=18 b= l=36 r= t=12 
// Remark                    : Cyphering off indication.
// Parent                    : popup_call_audio_out_window
// Parent API                : popup_call_audio_out_window
// Scale API match    ( 27%) : popup_call_audio_out_window_g_Limits
// Scale parent match (100%) : popup_call_audio_out_window
TAknWindowLineLayout Outgoing_call_pop_up_window_elements__held_NE__Line_3()
    {
	// LeonB 25.05.2005: option 2 is a good match (one line of text)
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_audio_out_window_g3(2).LayoutLine();
    return line;
    }


// LAF Table : Outgoing call pop-up window texts (held NE)
// B=52 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=222 l=90 r=40 
// Remark                    : CLI possible callingtext.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 31%) : popup_call_audio_out_window_t_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknTextLineLayout Outgoing_call_pop_up_window_texts__held_NE__Line_1() 
    {
	// 07/12/04: Used line from popup_call_audio_out_window, for consistency with other lines
    // 09.01.2006: Variety changed to 2.
	TAknTextLineLayout textLine = AknLayoutScalable_Apps::popup_call_audio_out_window_t1(2).LayoutLine();
    return textLine;
    }

// LAF Table : Outgoing call pop-up window graphics (held NE)
// C= H=82 W=352 b= l=0 r= t=0 
// Remark                    : Background pop-up window graphics. Alerting or disconnected variations.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 29%) : popup_call_audio_out_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout Outgoing_call_pop_up_window_graphics__held_NE__Line_1()
    {
	// MurrayR 07/12/04: Used line from popup_call_audio_out_window, for consistency with other lines
    TAknWindowLineLayout line = AknLayoutScalable_Apps::bg_popup_call_pane_cp01(0).LayoutLine();
    return line;
    }

// LAF Table : First call pop-up window elements (one call)
// C= H=46 W=50 b= l=14 r= t=20 
// Remark                    : Active held or disconnected call indication.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 42%) : popup_call_audio_first_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_elements__one_call__Line_1() 
    {
	// MurrayR 07/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_audio_first_window_g1(11).LayoutLine();
    return line;
    }

// C= H=12 W=24 b= l=42 r= t=48 
// Remark                    : Data call fax call or 2ndline indication.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 42%) : popup_call_audio_first_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_elements__one_call__Line_2() 
    {
	// MurrayR 07/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_type_pane_cp01(12).LayoutLine();
    return line;
    }

// C= H=16 W=18 b= l=18 r= t=20 
// Remark                    : Cyphering off indication.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 42%) : popup_call_audio_first_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_elements__one_call__Line_3()
    {
	// MurrayR 07/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_audio_first_window_g2(12).LayoutLine();
    return line;
    }


// LAF Table : First call pop-up window texts (one call)
// B={52, 88}[aCommon1] C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={262, 262, , 188, 176, 168, 160}[aCommon2] l={70, 70}[aCommon1] r={20, 20, , 94, 106, 114, 122}[aCommon2] 
// Remark                    : CLI. The text on holdor disconnected. Image width is 30. Image width is 36. Image width is 40. Image width is 44.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 47%) : popup_call_audio_first_window_t_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknTextLineLayout First_call_pop_up_window_texts__one_call__Line_1(TInt aCommon1, TInt aCommon2) 
    {
	// MurrayR 07/12/04: Layout tool doesn't support the multiple thumbnail sizes of the LAF spec
	// but it does have a present/not-present option.
	// MurrayR 21/12/04: Updated for new option numbers.
	TBool thumbnail = (aCommon2 >= 2);
    TAknTextLineLayout textLine;
	switch (aCommon1)
		{
		case 0:
			textLine = AknLayoutScalable_Apps::popup_call_audio_first_window_t1(thumbnail ? 10 : 16).LayoutLine();
			break;
		default:
			textLine = AknLayoutScalable_Apps::popup_call_audio_first_window_t4(thumbnail ? 5 : 12).LayoutLine();
			break;
		}
    return textLine;
    }


// B=88 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W={252, , 178, 166, 158, 150}[aCommon1] l=80 r={20, , 94, 106, 114, 122}[aCommon1] 
// Remark                    : Call timer and costs. Image width is 30. Image width is 36. Image width is 40. Image width is 44.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 47%) : popup_call_audio_first_window_t_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknTextLineLayout First_call_pop_up_window_texts__one_call__Line_2(TInt aCommon1)
    {
	// MurrayR 21/12/04: Fixed for new option numbers
	TBool thumbnail = (aCommon1 >= 1);
    TAknTextLineLayout textLine = AknLayoutScalable_Apps::popup_call_audio_first_window_t4(thumbnail ? 9 : 13).LayoutLine();
    return textLine;
    }

// LAF Table : First call pop-up window graphics (one call)
// C= H=126 W=352 b= l=0 r= t=0 
// Remark                    : Background pop-up window graphic. Active held and disconnected versions.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 44%) : popup_call_audio_first_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_graphics__one_call__Line_1()
    {
	// MurrayR 07/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::bg_popup_call_pane(12).LayoutLine();
    return line;
    }

// LAF Table : First call pop-up window elements (two calls)
// C= H=46 W=50 b= l=14 r= t=20 
// Remark                    : Active held disconnected call indication.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 40%) : popup_call_audio_first_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_elements__two_calls__Line_1() 
    {
	// MurrayR 07/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_audio_first_window_g1(11).LayoutLine();
    return line;
    }

// C= H=12 W=24 b= l=40 r= t=48 
// Remark                    : Data call fax call 2ndline indication.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 40%) : popup_call_audio_first_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_elements__two_calls__Line_2()
    {
	// MurrayR 07/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_type_pane_cp01(12).LayoutLine();
    return line;
    }

// C=221 H=72 W=88 b= l=222 r= t=28 
// Remark                    : Thumbnail image shadow.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 40%) : popup_call_audio_first_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_elements__two_calls__Line_3()
    {
	// MurrayR 07/12/04: Only one thumbnail pane is specified in the layout tool
    TInt varietyIndex = 1; // first pane has cp, which has variety 1 in option 6, but other options would also be valid. [LMB 16/12/2004]
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane_cp(varietyIndex).LayoutLine();
    return line;
    }

// C= H=72 W=88 b= l=220 r= t=26 
// Remark                    : tnCIF
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 40%) : popup_call_audio_first_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_elements__two_calls__Line_4()
    {
	// MurrayR 07/12/04: Only one thumbnail pane is specified in the layout tool
    // this is the graphic, so need to compose with the new pane
    TInt varietyIndex = 1; // first pane has cp, which has variety 1 in option 6, but other options would also be valid. [LMB 16/12/2004]
    TAknWindowComponentLayout subPane = AknLayoutScalable_Apps::call_thumbnail_pane_cp(varietyIndex);
    TAknWindowComponentLayout graphic = AknLayoutScalable_Apps::call_thumbnail_pane_g1();
    return DoCompose( subPane, graphic ).LayoutLine();
    }

// C=221 H=84 W=72 b= l=238 r= t=22 
// Remark                    : Thumbnail image shadow.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 40%) : popup_call_audio_first_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_elements__two_calls__Line_5()
    {
	// MurrayR 07/12/04: Only one thumbnail pane is specified in the layout tool
    TInt varietyIndex = 1; // first pane has cp, which has variety 1 in option 6, but other options would also be valid. [LMB 16/12/2004]
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane_cp(varietyIndex).LayoutLine();
    return line;
    }

// C= H=84 W=72 b= l=236 r= t=20 
// Remark                    : tnCIF90
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 40%) : popup_call_audio_first_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_elements__two_calls__Line_6() 
    {
	// MurrayR 07/12/04: Only one thumbnail pane is specified in the layout tool
    // this is the graphic, so need to compose with the new pane
    TInt varietyIndex = 1; // first pane has cp, which has variety 1 in option 6, but other options would also be valid. [LMB 16/12/2004]
    TAknWindowComponentLayout subPane = AknLayoutScalable_Apps::call_thumbnail_pane_cp(varietyIndex);
    TAknWindowComponentLayout graphic = AknLayoutScalable_Apps::call_thumbnail_pane_g1();
    return DoCompose( subPane, graphic ).LayoutLine();
    }

// C=221 H=60 W=80 b= l=230 r= t=34 
// Remark                    : Thumbnail image shadow.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 40%) : popup_call_audio_first_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_elements__two_calls__Line_7() 
    {
	// MurrayR 07/12/04: Only one thumbnail pane is specified in the layout tool
    TInt varietyIndex = 1; // first pane has cp, which has variety 1 in option 6, but other options would also be valid. [LMB 16/12/2004]
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane_cp(varietyIndex).LayoutLine();
    return line;
    }

// C= H=60 W=80 b= l=228 r= t=32 
// Remark                    : tnVGA
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 40%) : popup_call_audio_first_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_elements__two_calls__Line_8()
    {
	// MurrayR 07/12/04: Only one thumbnail pane is specified in the layout tool
    // this is the graphic, so need to compose with the new pane
    TInt varietyIndex = 1; // first pane has cp, which has variety 1 in option 6, but other options would also be valid. [LMB 16/12/2004]
    TAknWindowComponentLayout subPane = AknLayoutScalable_Apps::call_thumbnail_pane_cp(varietyIndex);
    TAknWindowComponentLayout graphic = AknLayoutScalable_Apps::call_thumbnail_pane_g1();
    return DoCompose( subPane, graphic ).LayoutLine();
    }

// C=221 H=80 W=60 b= l=250 r= t=24 
// Remark                    : Thumbnail image shadow.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 40%) : popup_call_audio_first_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_elements__two_calls__Line_9() 
    {
	// MurrayR 07/12/04: Only one thumbnail pane is specified in the layout tool
    TInt varietyIndex = 1; // first pane has cp, which has variety 1 in option 6, but other options would also be valid. [LMB 16/12/2004]
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane_cp(varietyIndex).LayoutLine();
    return line;
    }

// C= H=80 W=60 b= l=248 r= t=22 
// Remark                    : tnVGA90
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 39%) : popup_call_audio_first_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_elements__two_calls__Line_10()
    {
	// MurrayR 07/12/04: Only one thumbnail pane is specified in the layout tool
    // this is the graphic, so need to compose with the new pane
    TInt varietyIndex = 1; // first pane has cp, which has variety 1 in option 6, but other options would also be valid. [LMB 16/12/2004]
    TAknWindowComponentLayout subPane = AknLayoutScalable_Apps::call_thumbnail_pane_cp(varietyIndex);
    TAknWindowComponentLayout graphic = AknLayoutScalable_Apps::call_thumbnail_pane_g1();
    return DoCompose( subPane, graphic ).LayoutLine();
    }

// C=221 H=88 W=88 b= l=230 r= t=20 
// Remark                    : Thumbnail image shadow.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 39%) : popup_call_audio_first_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_elements__two_calls__Line_11()
    {
	// MurrayR 07/12/04: Only one thumbnail pane is specified in the layout tool
    TInt varietyIndex = 1; // first pane has cp, which has variety 1 in option 6, but other options would also be valid. [LMB 16/12/2004]
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane_cp(varietyIndex).LayoutLine();
    return line;
    }

// C= H=88 W=88 b= l=228 r= t=18 
// Remark                    : tnCOM
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 39%) : popup_call_audio_first_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_elements__two_calls__Line_12() 
    {
	// MurrayR 07/12/04: Only one thumbnail pane is specified in the layout tool
    // this is the graphic, so need to compose with the new pane
    TInt varietyIndex = 1; // first pane has cp, which has variety 1 in option 6, but other options would also be valid. [LMB 16/12/2004]
    TAknWindowComponentLayout subPane = AknLayoutScalable_Apps::call_thumbnail_pane_cp(varietyIndex);
    TAknWindowComponentLayout graphic = AknLayoutScalable_Apps::call_thumbnail_pane_g1();
    return DoCompose( subPane, graphic ).LayoutLine();
    }

// C=221 H= W= b= l=-2 r= t=-2 
// Remark                    : Shadow.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 39%) : popup_call_audio_first_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_elements__two_calls__Line_13()
    {
	// MurrayR 07/12/04: Only one thumbnail pane is specified in the layout tool
    TInt varietyIndex = 1; // first pane has cp, which has variety 1 in option 6, but other options would also be valid. [LMB 16/12/2004]
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_thumbnail_pane_cp(varietyIndex).LayoutLine();
    return line;
    }

// C= H=88 W=88 b= l= r=-42 t= 
// Remark                    : Any other size.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 39%) : popup_call_audio_first_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_elements__two_calls__Line_14()
    {
	// MurrayR 07/12/04: Only one thumbnail pane is specified in the layout tool
    // this is the graphic, so need to compose with the new pane
    TInt varietyIndex = 1; // first pane has cp, which has variety 1 in option 6, but other options would also be valid. [LMB 16/12/2004]
    TAknWindowComponentLayout subPane = AknLayoutScalable_Apps::call_thumbnail_pane_cp(varietyIndex);
    TAknWindowComponentLayout graphic = AknLayoutScalable_Apps::call_thumbnail_pane_g1();
    return DoCompose( subPane, graphic ).LayoutLine();
    }

// C= H=16 W=18 b= l=18 r= t=20 
// Remark                    : Cyphering off indication.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 39%) : popup_call_audio_first_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_elements__two_calls__Line_15()
    {
	// MurrayR 07/12/04: good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_audio_first_window_g2(12).LayoutLine();
    return line;
    }


// LAF Table : First call pop-up window texts (two calls)
// B={52, 88}[aCommon1] C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={242, 242, , 168, 156, 148, 140}[aCommon2] l={70, 70}[aCommon1] r={40, 40, , 114, 126, 134, 142}[aCommon2] 
// Remark                    : CLI. The text on holdor disconnected. Image width is 30. Image width is 36. Image width is 40. Image width is 44.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 44%) : popup_call_audio_first_window_t_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknTextLineLayout First_call_pop_up_window_texts__two_calls__Line_1(TInt aCommon1, TInt aCommon2)
    {
	// MurrayR 07/12/04: There is no layout tool support for this line and a thumbnail
    // layout data 0.75 now has thumbnail options [LMB 16/12/2004]

    // line1 is always CLI so group1 option 7
    // thumbnail is option 6, no thumbnail is option 17
    TInt option17_7 = 0;
    TInt option6_7 = 1;

    // select the option depending on the thumbnail
	 TInt thumbnail = (aCommon2 >= 2) ? 1 : 0;
     TInt option = thumbnail ? option6_7 : option17_7;

     TInt varietyIndex = 0;
    TAknTextLineLayout textLine;
	switch (aCommon1)
		{
		case 0:
            // pick the variety for t1 based on the option
            varietyIndex = (option == option6_7) ? 6 : 15;
			textLine = AknLayoutScalable_Apps::popup_call_audio_first_window_t1(varietyIndex).LayoutLine();
			break;
		default:
            // pick the variety for t4 based on the option
            varietyIndex = (option == option6_7) ? 5 : 12;
			textLine = AknLayoutScalable_Apps::popup_call_audio_first_window_t4(varietyIndex).LayoutLine();
			break;
		}
    return textLine;
    }


// B=88 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W={232, , 158, 146, 138, 130}[aCommon1] l=80 r={40, , 114, 126, 134, 142}[aCommon1] 
// Remark                    : Call timer and costs. Image width is 30. Image width is 36. Image width is 40. Image width is 44.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 44%) : popup_call_audio_first_window_t_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknTextLineLayout First_call_pop_up_window_texts__two_calls__Line_2(TInt aCommon1)
    {
	// MurrayR 07/12/04: There is no layout tool support for this line and a thumbnail
    // layout data 0.75 now has thumbnail options [LMB 16/12/2004]

    // line2 is always call timer so group1 option 11
    // thumbnail is option 6, no thumbnail is option 17
    TInt option17_11 = 0;
    TInt option6_11 = 1;

    // select the option depending on the thumbnail
	 TInt thumbnail = (aCommon1 >= 1) ? 1 : 0;
     TInt option = thumbnail ? option6_11 : option17_11;

     TInt varietyIndex = (option == option6_11) ? 9 : 13;
    TAknTextLineLayout textLine = AknLayoutScalable_Apps::popup_call_audio_first_window_t4(varietyIndex).LayoutLine();
    return textLine;
    }

// LAF Table : First call pop-up window graphics (two calls)
// C= H=126 W=352 b= l=0 r= t=0 
// Remark                    : Background pop-up window graphics. Active held and disconnected versions.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 42%) : popup_call_audio_first_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_graphics__two_calls__Line_1()
    {
	// MurrayR 07/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::bg_popup_call_pane(12).LayoutLine();
    return line;
    }

// LAF Table : First call pop-up window elements (two calls a waiting call)
// C= H=46 W=50 b= l=14 r= t=20 
// Remark                    : Active held and disconnected call indication.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 36%) : popup_call_audio_first_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_elements__two_calls_a_waiting_call__Line_1()
    {
	// MurrayR 07/12/04: Option 3 looks like a good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_audio_first_window_g1(11).LayoutLine();
    return line;
    }

// C= H=12 W=24 b= l=40 r= t=48 
// Remark                    : Data call fax call 2ndline indication.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 36%) : popup_call_audio_first_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_elements__two_calls_a_waiting_call__Line_2()
    {
	// MurrayR 07/12/04: Option 3 looks like a good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_type_pane_cp01(12).LayoutLine();
    return line;
    }
 
// C= H=16 W=18 b= l=18 r= t=20 
// Remark                    : Cyphering off indication.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 36%) : popup_call_audio_first_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_elements__two_calls_a_waiting_call__Line_3()
    {
	// LeonB 25.05.2005: Option 17_13 looks like a good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_audio_first_window_g2(13).LayoutLine();
    return line;
    }


// LAF Table : First call pop-up window texts (two calls a waiting call)
// B=52 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=242 l=70 r=40 
// Remark                    : CLI.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 40%) : popup_call_audio_first_window_t_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknTextLineLayout First_call_pop_up_window_texts__two_calls_a_waiting_call__Line_1() 
    {
	// LMB 25.05.2005: variety 12 no longer exists, changing to option 17_13 which is variety 17
    TAknTextLineLayout textLine = AknLayoutScalable_Apps::popup_call_audio_first_window_t1(17).LayoutLine();
    return textLine;
    }

// LAF Table : First call pop-up window graphics (two calls a waiting call)
// C= H=82 W=352 b= l=0 r= t=0 
// Remark                    : Background pop-up window graphics. Active held and disconnected versions.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 38%) : popup_call_audio_first_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_graphics__two_calls_a_waiting_call__Line_1()
    {
	// MurrayR 07/12/04: Option 3 looks like a good match
    // MAN: 13.4.2005: There does not anymore exist option 3, changed it to 12 
    TAknWindowLineLayout line = AknLayoutScalable_Apps::bg_popup_call_pane(12).LayoutLine();
    return line;
    }

// LAF Table : First call pop-up window graphics (two wait NE)
// C= H=82 W=24 b= l=0 r= t=0 
// Remark                    : Background pop-up window graphics. Held and disconnected versions.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 36%) : popup_call_audio_wait_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_graphics__two_wait_NE__Line_1() 
    {
	// MurrayR 07/12/04: Option 4 looks like a good match for the call hidden corner
    TAknWindowLineLayout line = AknLayoutScalable_Apps::bg_popup_call_pane(4).LayoutLine();
    return line;
    }

// LAF Table : Waiting call pop-up window elements (held out NE)
// C= H=46 W=50 b= l=14 r= t=20 
// Remark                    : Animated waiting call indication.
// Parent                    : popup_call_audio_wait_window
// Parent API                : popup_call_audio_wait_window
// Scale API match    ( 29%) : popup_call_audio_out_window_g_Limits
// Scale parent match (100%) : popup_call_audio_wait_window
TAknWindowLineLayout Waiting_call_pop_up_window_elements__held_out_NE__Line_1() 
    {
	// MurrayR 07/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_audio_wait_window_g1().LayoutLine();
    return line;
    }

// C= H=12 W=24 b= l=40 r= t=48 
// Remark                    : Data call fax call 2ndline indication
// Parent                    : popup_call_audio_wait_window
// Parent API                : popup_call_audio_wait_window
// Scale API match    ( 29%) : popup_call_audio_out_window_g_Limits
// Scale parent match (100%) : popup_call_audio_wait_window
TAknWindowLineLayout Waiting_call_pop_up_window_elements__held_out_NE__Line_2() 
    {
	// MurrayR 07/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_type_pane_cp023().LayoutLine();
    return line;
    }

// C= H=16 W=18 b= l=16 r= t=18 
// Remark                    : Cyphering off indication.
// Parent                    : popup_call_audio_wait_window
// Parent API                : popup_call_audio_wait_window
// Scale API match    ( 29%) : popup_call_audio_out_window_g_Limits
// Scale parent match (100%) : popup_call_audio_wait_window
TAknWindowLineLayout Waiting_call_pop_up_window_elements__held_out_NE__Line_3()
    {
	// MurrayR 07/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_audio_wait_window_g2().LayoutLine();
    return line;
    }


// LAF Table : Waiting call pop-up window texts (held out NE)
// B=52 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=242 l=70 r=40 
// Remark                    : CLI.
// Parent                    : popup_call_audio_wait_window
// Parent API                : popup_call_audio_wait_window
// Scale API match    ( 33%) : popup_call_audio_out_window_t_Limits
// Scale parent match (100%) : popup_call_audio_wait_window
TAknTextLineLayout Waiting_call_pop_up_window_texts__held_out_NE__Line_1() 
    {
	// MurrayR 07/12/04: Good match
    TAknTextLineLayout textLine = AknLayoutScalable_Apps::popup_call_audio_wait_window_t3().LayoutLine();
    return textLine;
    }

// LAF Table : Waiting call pop-up window graphics (held out NE)
// C= H=82 W=352 b= l=0 r= t=0 
// Remark                    : Background pop-up window graphics.
// Parent                    : popup_call_audio_wait_window
// Parent API                : popup_call_audio_wait_window
// Scale API match    ( 31%) : popup_call_audio_out_window_g_Limits
// Scale parent match (100%) : popup_call_audio_wait_window
TAknWindowLineLayout Waiting_call_pop_up_window_graphics__held_out_NE__Line_1()
    {
	// MurrayR 07/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::bg_popup_call_pane_cp02().LayoutLine();
    return line;
    }

// LAF Table : Waiting call pop-up window graphics (out)
// C= H=82 W=352 b= l=0 r= t=0 
// Remark                    : Background pop-up window graphics.
// Parent                    : popup_call_audio_wait_window
// Parent API                : popup_call_audio_wait_window
// Scale API match    ( 36%) : popup_call_audio_out_window_g_Limits
// Scale parent match (100%) : popup_call_audio_wait_window
TAknWindowLineLayout Waiting_call_pop_up_window_graphics__out__Line_1()
    {
	// MurrayR 07/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::bg_popup_call_pane_cp02().LayoutLine();
    return line;
    }

// LAF Table : Second call pop-up window elements (two)
// C= H=46 W=50 b= l=34 r= t=20 
// Remark                    : Active held and disconnected call indication.
// Parent                    : popup_call_audio_second_window
// Parent API                : popup_call_audio_second_window
// Scale API match    ( 40%) : popup_call_audio_second_window_g_Limits
// Scale parent match (100%) : popup_call_audio_second_window
TAknWindowLineLayout Second_call_pop_up_window_elements__two__Line_1()
    {
	// MurrayR 07/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_audio_second_window_g1(0).LayoutLine();
    return line;
    }

// C= H=12 W=24 b= l=60 r= t=48 
// Remark                    : Data call fax call 2ndline indication.
// Parent                    : popup_call_audio_second_window
// Parent API                : popup_call_audio_second_window
// Scale API match    ( 40%) : popup_call_audio_second_window_g_Limits
// Scale parent match (100%) : popup_call_audio_second_window
TAknWindowLineLayout Second_call_pop_up_window_elements__two__Line_2()
    {
	// MurrayR 07/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_type_pane_cp034(0).LayoutLine();
    return line;
    }

// C= H=16 W=18 b= l=38 r= t=18 
// Remark                    : Cyphering off indication.
// Parent                    : popup_call_audio_second_window
// Parent API                : popup_call_audio_second_window
// Scale API match    ( 40%) : popup_call_audio_second_window_g_Limits
// Scale parent match (100%) : popup_call_audio_second_window
TAknWindowLineLayout Second_call_pop_up_window_elements__two__Line_3()
    {
	// MurrayR 07/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_audio_second_window_g2(0).LayoutLine();
    return line;
    }


// LAF Table : Second call pop-up window texts (two calls)
// B={52, 88}[aCommon1] C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={242, 242, , 168, 156, 148, 140}[aCommon2] l={90, 90}[aCommon1] r={20, 20, , 94, 106, 114, 122}[aCommon2] 
// Remark                    : CLI. The text on holdor disconnected. Image width is 30. Image width is 36. Image width is 40. Image width is 44.
// Parent                    : popup_call_audio_second_window
// Parent API                : popup_call_audio_second_window
// Scale API match    ( 45%) : popup_call_audio_second_window_t_Limits
// Scale parent match (100%) : popup_call_audio_second_window
TAknTextLineLayout Second_call_pop_up_window_texts__two_calls__Line_1(TInt aCommon1, TInt aCommon2) 
    {
	// MurrayR 21/12/04: Updated with layout support for thumbnails
	TBool thumbnail = (aCommon2 >= 2);
	TAknTextLineLayout textLine;
	switch (aCommon1)
		{
		case 0:
			textLine = AknLayoutScalable_Apps::popup_call_audio_second_window_t1(thumbnail ? 9 : 12).LayoutLine();
			break;
		default:
			textLine = AknLayoutScalable_Apps::popup_call_audio_second_window_t3(thumbnail ? 3 : 4).LayoutLine();
			break;
		}
    return textLine;
    }


// B=88 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W={232, , 158, 146, 138, 130}[aCommon1] l=100 r={20, , 94, 106, 114, 122}[aCommon1] 
// Remark                    : Call timer and costs. Image width is 30. Image width is 36. Image width is 40. Image width is 44.
// Parent                    : popup_call_audio_second_window
// Parent API                : popup_call_audio_second_window
// Scale API match    ( 45%) : popup_call_audio_second_window_t_Limits
// Scale parent match (100%) : popup_call_audio_second_window
TAknTextLineLayout Second_call_pop_up_window_texts__two_calls__Line_2(TInt aCommon1) 
    {
	// MurrayR 21/12/04: Updated with layout support for thumbnails
	TBool thumbnail = (aCommon1 >= 1);
    TAknTextLineLayout textLine = AknLayoutScalable_Apps::popup_call_audio_second_window_t2(thumbnail ? 3 : 4).LayoutLine();
    return textLine;
    }

// LAF Table : Second call pop-up window graphics (two calls)
// C= H=126 W=352 b= l=0 r= t=0 
// Remark                    : Background pop-up window graphics. Active held and disconnected indication.
// Parent                    : popup_call_audio_second_window
// Parent API                : popup_call_audio_second_window
// Scale API match    ( 43%) : popup_call_audio_second_window_g_Limits
// Scale parent match (100%) : popup_call_audio_second_window
TAknWindowLineLayout Second_call_pop_up_window_graphics__two_calls__Line_1()
    {
	// MurrayR 07/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::bg_popup_call_pane_cp03(0).LayoutLine();
    return line;
    }

// LAF Table : Second call pop-up window elements (two calls waiting call)
// C= H=46 W=50 b= l=34 r= t=10 
// Remark                    : Active held and disconnected call indication.
// Parent                    : popup_call_audio_second_window
// Parent API                : popup_call_audio_second_window
// Scale API match    ( 39%) : popup_call_audio_second_window_g_Limits
// Scale parent match (100%) : popup_call_audio_second_window
TAknWindowLineLayout Second_call_pop_up_window_elements__two_calls_waiting_call__Line_1()
    {
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_audio_second_window_g1(11).LayoutLine();
    return line;
    }

// C= H=12 W=24 b= l=60 r= t=38 
// Remark                    : Data call fax call 2ndline indication.
// Parent                    : popup_call_audio_second_window
// Parent API                : popup_call_audio_second_window
// Scale API match    ( 39%) : popup_call_audio_second_window_g_Limits
// Scale parent match (100%) : popup_call_audio_second_window
TAknWindowLineLayout Second_call_pop_up_window_elements__two_calls_waiting_call__Line_2() 
    {
	// LeonB 25.5.2005: All options seem to have the same values. Option 0 seems as good a choice as any, so use variety index 0
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_type_pane_cp034(0).LayoutLine();
    return line;
    }

// C= H=16 W=18 b= l=36 r= t=10 
// Remark                    : Cyphering off indication.
// Parent                    : popup_call_audio_second_window
// Parent API                : popup_call_audio_second_window
// Scale API match    ( 39%) : popup_call_audio_second_window_g_Limits
// Scale parent match (100%) : popup_call_audio_second_window
TAknWindowLineLayout Second_call_pop_up_window_elements__two_calls_waiting_call__Line_3()
    {
	// LeonB 25.5.2005: All options seem to have the same values. Option 0 seems as good a choice as any, so use variety index 0
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_call_audio_second_window_g2(0).LayoutLine();
    return line;
    }


// LAF Table : Second call pop-up window texts (two calls waiting call)
// B=42 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=242 l=90 r=20 
// Remark                    : CLI.
// Parent                    : popup_call_audio_second_window
// Parent API                : popup_call_audio_second_window
// Scale API match    ( 42%) : popup_call_audio_second_window_t_Limits
// Scale parent match (100%) : popup_call_audio_second_window
TAknTextLineLayout Second_call_pop_up_window_texts__two_calls_waiting_call__Line_1() 
    {
	// LeonB 25.05.2005: Good match with Option 0_7, as only one line of text, and can assume no thumbnail. So variety 13.
    TAknTextLineLayout textLine = AknLayoutScalable_Apps::popup_call_audio_second_window_t1(13).LayoutLine();
    return textLine;
    }

// LAF Table : Second call pop-up window graphics (two calls waiting call)
// C= H=82 W=352 b= l=0 r= t=0 
// Remark                    : Background pop-up window graphics.
// Parent                    : popup_call_audio_second_window
// Parent API                : popup_call_audio_second_window
// Scale API match    ( 40%) : popup_call_audio_second_window_g_Limits
// Scale parent match (100%) : popup_call_audio_second_window
TAknWindowLineLayout Second_call_pop_up_window_graphics__two_calls_waiting_call__Line_1()
    {
	// LeonB 25.5.2005: don't think it matters which option we use, as the background graphics
	// is always the same as the parent. So in this case, variety index 0 is a good choice.
    TAknWindowLineLayout line = AknLayoutScalable_Apps::bg_popup_call_pane_cp03(0).LayoutLine();
    return line;
    }

// LAF Table : Conference call pop-up window descendants and elements
// C= H=p W=352 b= l=0 r= t=0 
// Remark                    : Background pop-up window graphics.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 26%) : popup_cale_events_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Conference_call_pop_up_window_descendants_and_elements_Line_1(const TRect& /*aParentRect*/)
    {
	// MurrayR 07/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::bg_popup_call_pane_cp04().LayoutLine();
    return line;
    }

// C= H={76, 114, 152, 190} W=320 b= l=14 r= t=26 
// Remark                    : Call status and a CLI.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : list_conf_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout list_conf_pane(TInt /*aIndex_H*/)
    {
	// MurrayR 07/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::list_conf_pane().LayoutLine();
    return line;
    }

// LAF Table : Conference call pop-up window texts
// B={126, 164, 202, 240} C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=244 l=80 r=28 
// Remark                    : Call timer and costs.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 44%) : popup_call_audio_conf_window_t1
// Scale parent match (  0%) : 
TAknTextLineLayout Conference_call_pop_up_window_texts_Line_1(TInt /*aIndex_B*/) 
    {
	// MurrayR 07/12/04: Good match, except parameterisation is not needed
    TAknTextLineLayout textLine = AknLayoutScalable_Apps::popup_call_audio_conf_window_t1().LayoutLine();
    return textLine;
    }


// LAF Table : Muted state elements
// C= H=144 W=150 b= l=100 r= t=48 
// Remark                    : Muted state indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Muted_state_elements_Line_1() 
    {
    // RSD: DONE
    // Compose up to main_pane
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_call_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::call_muted_g1();
    return DoCompose( layout1, layout2 ).LayoutLine();
    }

// LAF Table : Calendar events list popup components
// C= H=20 W=2 b= l=2 r= t={8, 94} 
// Remark                    : 
// Parent                    : popup_cale_events_window
// Parent API                : popup_cale_events_window
// Scale API match    ( 44%) : popup_cale_events_window_g_Limits
// Scale parent match (100%) : popup_cale_events_window
TAknWindowLineLayout Calendar_events_list_popup_components_Line_1(TInt aIndex_t)
    {
    // RSD: DONE
    // Must be 0 or 1
    __ASSERT_ALWAYS(0 <= aIndex_t && aIndex_t <= 1, Panic(EParamsOutsideKnownRange));
    TInt variety( 4 ); // Variety 4 is the one where there are missing events, and only one with this graphics
    TInt lineNumber( aIndex_t );
    ASSERT_ALWAYS_WITHIN_LIMITS( lineNumber, AknLayoutScalable_Apps::popup_cale_events_window_g_Limits() ); 
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::popup_cale_events_window_g( lineNumber, variety );
    return layout1.LayoutLine();
    }

// LAF Table : Calendar events list popup texts
// B={26, 54, 82, 110} C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=250 l=8 r=10 
// Remark                    : 4 rows of text max.
// Parent                    : popup_cale_events_window
// Parent API                : popup_cale_events_window
// Scale API match    ( 41%) : popup_cale_events_window_g_Limits
// Scale parent match (100%) : popup_cale_events_window
TAknTextLineLayout Calendar_events_list_popup_texts_Line_1(TInt aIndex_B) 
    {
    // RSD: DONE
    // Must be positive
    __ASSERT_ALWAYS(0 <= aIndex_B, Panic(EParamsOutsideKnownRange));

    // Dead reckon the newIndex from the old. Reasonable assumption
    TInt newIndex = aIndex_B;

    // This can be formally checked too
    ASSERT_ALWAYS_WITHIN_LIMITS( newIndex, AknLayoutScalable_Apps::popup_cale_events_window_t_Limits() );

	// this should be number of lines, but not available from old API, so choose max variety
	TInt varietyIndex = AknLayoutScalable_Apps::popup_cale_events_window_t_ParamLimits(newIndex).LastVariety(); 
    return AknLayoutScalable_Apps::popup_cale_events_window_t( newIndex, varietyIndex ).LayoutLine();
    }


// LAF Table : Calendar events list popup graphics
// C=0 H=p W=268 b= l=0 r= t=0 
// Remark                    : A rectangle to cover the main pane items.
// Parent                    : popup_cale_events_window
// Parent API                : popup_cale_events_window
// Scale API match    ( 44%) : list_single_graphic_popup_wml_pane_g_Limits
// Scale parent match (100%) : popup_cale_events_window
TAknWindowLineLayout Calendar_events_list_popup_graphics_Line_1(const TRect& aParentRect)
    {
	// MurrayR 09/12/04: Can't implement with the data as supplied in the layout tool
	// so, return the parent rectangle instead.
	// TODO fix the layout tool so that these data driven layouts works
    TAknWindowLineLayout line = AknLayoutScalable_Apps::bg_popup_sub_pane_cp01(3).LayoutLine();
    TAknWindowLineLayoutImp fixedLine = 
		{
		/*iC*/	line.iC,
		/*il*/	(TInt16)aParentRect.iTl.iX,
		/*it*/	(TInt16)aParentRect.iTl.iY,
		/*ir*/	ELayoutEmpty,
		/*ib*/	ELayoutEmpty,
		/*iW*/	(TInt16)aParentRect.Width(),
		/*iH*/	(TInt16)aParentRect.Height()
		};

    return fixedLine;
    }

// C=221 H=p-8 W=260 b= l=6 r= t=6 
// Remark                    : Shadow.
// Parent                    : popup_cale_events_window
// Parent API                : popup_cale_events_window
// Scale API match    ( 44%) : list_single_graphic_popup_wml_pane_g_Limits
// Scale parent match (100%) : popup_cale_events_window
TAknWindowLineLayout Calendar_events_list_popup_graphics_Line_2(const TRect& /*aParentRect*/)
    {
	// MurrayR 09/12/04: These graphics should be done with skins
    return ZeroWindowLayout();
    }

// C=215 H=p-6 W=262 b= l=2 r= t=2 
// Remark                    : Outline frame.
// Parent                    : popup_cale_events_window
// Parent API                : popup_cale_events_window
// Scale API match    ( 44%) : list_single_graphic_popup_wml_pane_g_Limits
// Scale parent match (100%) : popup_cale_events_window
TAknWindowLineLayout Calendar_events_list_popup_graphics_Line_3(const TRect& /*aParentRect*/) 
    {
	// MurrayR 09/12/04: These graphics should be done with skins
    return ZeroWindowLayout();
    }

// C=3 H=p-10 W=258 b= l=4 r= t=4 
// Remark                    : Inside area.
// Parent                    : popup_cale_events_window
// Parent API                : popup_cale_events_window
// Scale API match    ( 44%) : list_single_graphic_popup_wml_pane_g_Limits
// Scale parent match (100%) : popup_cale_events_window
TAknWindowLineLayout Calendar_events_list_popup_graphics_Line_4(const TRect& /*aParentRect*/) 
    {
	// MurrayR 09/12/04: These graphics should be done with skins
    return ZeroWindowLayout();
    }


// LAF Table : Presence status popup window elements
// C= H=86 W=112 b= l={0, 114, 228, 0, 114, 228} r= t={0, , , 88} 
// Remark                    : Parent grid_cams_pane Camcorder 3x2 grid.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : cell_cams_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout cell_cams_pane(TInt aIndex_l, TInt aIndex_t)
    {
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowLineLayout line = AknLayoutScalable_Apps::cell_cams_pane(varietyIndex, aIndex_l, aIndex_t).LayoutLine();
    return line;
    }

// C= H=120 W=200 b= l=76 r= t=62 
// Remark                    : User defined image or default presence status graphic
// Parent                    : popup_dyc_status_message_window
// Parent API                : popup_dyc_status_message_window
// Scale API match    (  0%) : 
// Scale parent match (100%) : popup_dyc_status_message_window
TAknWindowLineLayout image_or_qgn_prop_dyc__ref_()
    {
	// MurrayR 08/12/04: Good match
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_dyc_status_message_window_g1(varietyIndex).LayoutLine();
    return line;
    }

// C= H={40, 72, 104} W={336, 322} b= l=6 r= t=56 
// Remark                    : Request  type text.
// Parent                    : popup_loc_request_window
// Parent API                : popup_loc_request_window
// Scale API match    (100%) : loc_type_pane
// Scale parent match (100%) : popup_loc_request_window
TAknWindowLineLayout loc_type_pane(TInt aIndex_H) 
    {
	// MurrayR 08/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::loc_type_pane(aIndex_H).LayoutLine();
    return line;
    }

// C= H={40, 80, 120, 160, 200} W={336, 322} b= l=6 r= t={96, 128, 160} 
// Remark                    : Requestor  names. The maximum number of lines shown depends on the height of the loc_type_pane.
// Parent                    : popup_loc_request_window
// Parent API                : popup_loc_request_window
// Scale API match    (100%) : loc_req_pane
// Scale parent match (100%) : popup_loc_request_window
TAknWindowLineLayout loc_req_pane(TInt aIndex_t, TInt /*aIndex_H*/) 
    {
	// MurrayR 08/12/04: Good match, except all parameters are not used
    TAknWindowLineLayout line = AknLayoutScalable_Apps::loc_req_pane(aIndex_t).LayoutLine();
    return line;
    }


// LAF Table : Additional heading pane elements
// C= H=26 W=26 b= l=300 r= t=6 
// Remark                    : Icon place A
// Parent                    : popup_list_heading_pane
// Parent API                : Presence_status_popup_window_elements_Line_1
// Scale API match    ( 38%) : cale_week_day_heading_pane_t1
// Scale parent match ( 44%) : popup_dyc_status_message_window_g1
TAknWindowLineLayout Additional_heading_pane_elements_Line_1()
    {
	// MurrayR 08/12/04: Parent matches heading_loc_req_pane. popup_list_heading_pane is
	// an avkon thing. Otherwise, this is a good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::heading_loc_req_pane_g1().LayoutLine();
    return line;
    }

// C= H=26 W=26 b= l=270 r= t=6 
// Remark                    : Icon place B
// Parent                    : popup_list_heading_pane
// Parent API                : Presence_status_popup_window_elements_Line_1
// Scale API match    ( 38%) : cale_week_day_heading_pane_t1
// Scale parent match ( 44%) : popup_dyc_status_message_window_g1
TAknWindowLineLayout Additional_heading_pane_elements_Line_2()
    {
	// MurrayR 08/12/04: Parent matches heading_loc_req_pane. popup_list_heading_pane is
	// an avkon thing. Otherwise, this is a good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::heading_loc_req_pane_g2().LayoutLine();
    return line;
    }

// C= H=26 W=26 b= l=238 r= t=6 
// Remark                    : Icon place C
// Parent                    : popup_list_heading_pane
// Parent API                : Presence_status_popup_window_elements_Line_1
// Scale API match    ( 38%) : cale_week_day_heading_pane_t1
// Scale parent match ( 44%) : popup_dyc_status_message_window_g1
TAknWindowLineLayout Additional_heading_pane_elements_Line_3() 
    {
	// MurrayR 08/12/04: Parent matches heading_loc_req_pane. popup_list_heading_pane is
	// an avkon thing. Otherwise, this is a good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::heading_loc_req_pane_g3().LayoutLine();
    return line;
    }

// LAF Table : Presence status popup window texts
// B=28 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=214 l=16 r=106 
// Remark                    : Heading title name nickname wv address Parent popup_list_heading_pane
// Parent                    : 
// Parent API                : 
// Scale API match    ( 51%) : popup_dyc_status_message_window_t1
// Scale parent match (  0%) : 
TAknTextLineLayout Presence_status_popup_window_texts_Line_1() 
    {
	// MurrayR 08/12/04: Parent is heading_loc_req_pane.
	// Otherwise, this is a good match
    //TInt rowIndex = 0; // only ever seems to have one row [LMB 16/03/2005]
    // MAN: 7.6.2005 Seems that layout v0.9 no more param needed
    TAknTextLineLayout textLine = AknLayoutScalable_Apps::heading_loc_req_pane_t1(/*rowIndex*/).LayoutLine();
    return textLine;
    }

// B={212, 240, 268} C=215 Font=ELatinBold12_Scaled J=ELayoutAlignCenter W=314 l=18 r=20 
// Remark                    : Status message max three (3) lines of text. Parent popup_dyc_status_message_ window
// Parent                    : 
// Parent API                : 
// Scale API match    ( 51%) : popup_dyc_status_message_window_t1
// Scale parent match (  0%) : 
TAknTextLineLayout Presence_status_popup_window_texts_Line_2(TInt aIndex_B) 
    {
	// MurrayR 08/12/04: Parent is popup_dyc_status_message_window
	// Otherwise, this is a good match
    TInt lineIndex = aIndex_B;
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknTextLineLayout textLine = AknLayoutScalable_Apps::popup_dyc_status_message_window_t(lineIndex, varietyIndex).LayoutLine();
    return textLine;
    }


// LAF Table : Presence status window graphics
// C=0 H=304 W=352 b= l=0 r= t=0 
// Remark                    : A rectangle to cover the main pane items.
// Parent                    : popup_dyc_status_message_window
// Parent API                : popup_dyc_status_message_window
// Scale API match    ( 46%) : popup_call_status_window_g1
// Scale parent match (100%) : popup_dyc_status_message_window
TAknWindowLineLayout Presence_status_window_graphics_Line_1()
    {
	// MurrayR 08/12/04: Another of these shadow graphics tables
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowLineLayout line = AknLayoutScalable_Apps::bg_popup_window_pane_cp03(varietyIndex).LayoutLine();
    return line;
    }

// C=86 H=284 W=336 b= l=12 r= t=12 
// Remark                    : Second shadow.
// Parent                    : popup_dyc_status_message_window
// Parent API                : popup_dyc_status_message_window
// Scale API match    ( 46%) : popup_call_status_window_g1
// Scale parent match (100%) : popup_dyc_status_message_window
TAknWindowLineLayout Presence_status_window_graphics_Line_2()
    {
	// MurrayR 08/12/04: Returning zero for all internal structure - should be skinned
    return ZeroWindowLayout();
    }

// C=221 H=284 W=338 b= l=8 r= t=8 
// Remark                    : First shadow.
// Parent                    : popup_dyc_status_message_window
// Parent API                : popup_dyc_status_message_window
// Scale API match    ( 46%) : popup_call_status_window_g1
// Scale parent match (100%) : popup_dyc_status_message_window
TAknWindowLineLayout Presence_status_window_graphics_Line_3()
    {
	// MurrayR 08/12/04: Returning zero for all internal structure - should be skinned
    return ZeroWindowLayout();
    }

// C=215 H=288 W=340 b= l=4 r= t=4 
// Remark                    : Outline frame.
// Parent                    : popup_dyc_status_message_window
// Parent API                : popup_dyc_status_message_window
// Scale API match    ( 46%) : popup_call_status_window_g1
// Scale parent match (100%) : popup_dyc_status_message_window
TAknWindowLineLayout Presence_status_window_graphics_Line_4() 
    {
	// MurrayR 08/12/04: Returning zero for all internal structure - should be skinned
    return ZeroWindowLayout();
    }

// C=0 H=284 W=336 b= l=6 r= t=6 
// Remark                    : Inside area.
// Parent                    : popup_dyc_status_message_window
// Parent API                : popup_dyc_status_message_window
// Scale API match    ( 46%) : popup_call_status_window_g1
// Scale parent match (100%) : popup_dyc_status_message_window
TAknWindowLineLayout Presence_status_window_graphics_Line_5()
    {
	// MurrayR 08/12/04: Returning zero for all internal structure - should be skinned
    return ZeroWindowLayout();
    }

// Section 5
// LAF Table : Pop-up windows (main pane as parent)
// C= H=126 W=352 b=0 l= r=0 t= 
// Remark                    : Number entry.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : popup_number_entry_window
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_number_entry_window()
    {
    // RSD: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_call_pane();
    // In scalable layout, the option is used at the number_entry_window level (which is better)
    // but the old API uses the option in the texts only.
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::popup_number_entry_window(0);
    return DoCompose( layout1, layout2 ).LayoutLine();
    }

// C= H=274 W=352 b=0 l= r=0 t= 
// Remark                    : Phonebook memory status indication.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 59%) : popup_call_status_window
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_pb_memory_status_window() 
    {
	// MurrayR 07/12/04: Not supported in the layout tool & not used in code.
	// TODO: Confirm not used.
    return ZeroWindowLayout();
    }

// C= H={154, 228, 302, 376} W=352 b=0 l= r=0 t= 
// Remark                    : Graphical messages image selection pop-up window. p_height_popup_grid_large_graphic_window.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : popup_grid_large_graphic_window
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_grid_large_graphic_window(TInt aIndex_H) 
    {
	// MurrayR 07/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_grid_large_graphic_window(aIndex_H).LayoutLine();
    return line;
    }

// C= H={126, 126, 154, 126}[aCommon1] W={352, 352, 352, 352}[aCommon1] b={0, 94, 0, 122}[aCommon1] l= r={0, 2, 0, 0}[aCommon1] t= 
// Remark                    : Incoming call indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : popup_call_audio_in_window
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_call_audio_in_window(TInt aCommon1)
    {
	// MurrayR 07/12/04: Good match
	TAknWindowComponentLayout main = AknLayoutScalable_Apps::main_call_pane();
    TAknWindowComponentLayout popup = AknLayoutScalable_Apps::popup_call_audio_in_window(aCommon1);
    return DoCompose(main, popup).LayoutLine();
    }

// C= H={126, 82}[aCommon1] W=352 b={0, 126}[aCommon1] l= r=0 t= 
// Remark                    : Outgoing call indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : popup_call_audio_out_window
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_call_audio_out_window(TInt aCommon1)
    {
	// MurrayR 07/12/04: Good match, except layout tool has an extra option
	TAknWindowComponentLayout main = AknLayoutScalable_Apps::main_call_pane();
    TAknWindowComponentLayout popup = AknLayoutScalable_Apps::popup_call_audio_out_window(aCommon1);
    return DoCompose(main, popup).LayoutLine();
    }

// C= H={126, 126, 126, 82, 126, 82}[aCommon1] W={352, 352, 352, 352, 352, 24}[aCommon1] b={0, 94, 96, 194, 122, 126}[aCommon1] l= r={0, 2, 0, 0, 0} t= 
// Remark                    : First call indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : popup_call_audio_first_window
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_call_audio_first_window(TInt /*aIndex_r*/, TInt aCommon1)
    {
	// MurrayR 07/12/04: Good match, except for the second last entry, where aCommon1 == 4
	// an array mapping from aCommon1, to coresponding options in the layout tool
	CDL_ARRAY_START(TInt, KLay2ToolMap)
		{
		0,
		1,
		2,
		3,
		5,
		4
		}
	CDL_ARRAY_END(TInt, KLay2ToolMap);
	TAknWindowComponentLayout main = AknLayoutScalable_Apps::main_call_pane();
    TAknWindowComponentLayout popup = AknLayoutScalable_Apps::popup_call_audio_first_window(KLay2ToolMap[aCommon1]);
    return DoCompose(main, popup).LayoutLine();
    }

// C= H={126, 82, 82, 82}[aCommon1] W=352 b={0, 126, 194, 96}[aCommon1] l= r=0 t= 
// Remark                    : Waiting call indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : popup_call_audio_wait_window
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_call_audio_wait_window(TInt aCommon1)
    {
	// MurrayR 07/12/04: Good match
	TAknWindowComponentLayout main = AknLayoutScalable_Apps::main_call_pane();
    TAknWindowComponentLayout popup = AknLayoutScalable_Apps::popup_call_audio_wait_window(aCommon1);
    return DoCompose(main, popup).LayoutLine();
    }

// C= H={126, 126, 82, 82, 82}[aCommon1] W={352, 352, 352, 352, 24}[aCommon1] b={0, 2, 126, 194, 126}[aCommon1] l= r={0, 2, 0, 0, 0} t= 
// Remark                    : Second call indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : popup_call_audio_second_window
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_call_audio_second_window(TInt /*aIndex_r*/, TInt aCommon1) 
    {
	// MurrayR 07/12/04: Good match
	TAknWindowComponentLayout main = AknLayoutScalable_Apps::main_call_pane();
    TAknWindowComponentLayout popup = AknLayoutScalable_Apps::popup_call_audio_second_window(aCommon1);
    return DoCompose(main, popup).LayoutLine();
    }

// C= H={162, 200, 238, 276} W=352 b=0 l= r=0 t= 
// Remark                    : Conference call indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : popup_call_audio_conf_window
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_call_audio_conf_window(TInt aIndex_H) 
    {
	// MurrayR 07/12/04: Good match
	TAknWindowComponentLayout main = AknLayoutScalable_Apps::main_call_pane();
    TAknWindowComponentLayout popup = AknLayoutScalable_Apps::popup_call_audio_conf_window(aIndex_H);
    return DoCompose(main, popup).LayoutLine();
    }

// C= H=102 W=352 b=0 l= r=0 t= 
// Remark                    : Incoming video call indication.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 75%) : popup_call_audio_in_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_call_video_in_window() 
    {
	// MurrayR 07/12/04: Not supported in the layout tool & not used in code.
	// TODO: Confirm not used.
    return ZeroWindowLayout();
    }

// C= H=48 W=352 b=0 l= r=0 t= 
// Remark                    : (First) video call indication.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 77%) : popup_call_audio_first_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_call_video_first_window() 
    {
	// MurrayR 07/12/04: Not supported in the layout tool & not used in code.
	// TODO: Confirm not used.
    return ZeroWindowLayout();
    }

// C= H=288 W=352 b=0 l= r=0 t= 
// Remark                    : Downlink video stream indication.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 61%) : popup_call_audio_in_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_call_video_down_window() 
    {
	// MurrayR 07/12/04: I think this is reasonable
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
	TAknWindowComponentLayout main = AknLayoutScalable_Apps::main_video_tele_pane();
    TAknWindowComponentLayout popup = AknLayoutScalable_Apps::video_down_pane(varietyIndex);
    return DoCompose(main, popup).LayoutLine();
    }

// C= H={198, 236, 274} W=352 b=0 l= r=0 t= 
// Remark                    : Browser WIM PIN query indication. p_height_popup_query_wml_wim_window.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 54%) : popup_wml_address_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_query_wml_wim_window(TInt /*aIndex_H*/)
    {
	// MurrayR 07/12/04: Not supported in the layout tool & not used in code.
	// TODO: Confirm not used.
    return ZeroWindowLayout();
    }

// C= H={114, 146, 178, 210, 242, 274} W=352 b=0 l= r=0 t= 
// Remark                    : Browser Digital Signing query indication. p_height_popup_query_wml_sign_window.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 48%) : popup_wml_address_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_query_wml_sign_window(TInt /*aIndex_H*/) 
    {
	// MurrayR 07/12/04: Not supported in the layout tool & not used in code.
	// TODO: Confirm not used.
    return ZeroWindowLayout();
    }

// C= H={114, 146, 178, 210, 242, 274} W=352 b=0 l= r=0 t= 
// Remark                    : SAT Information query indication. p_height_popup_query_sat_info_window.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 40%) : popup_loc_request_window
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_query_sat_info_window(TInt /*aIndex_H*/) 
    {
	// MurrayR 07/12/04: I can't find anything to match this SAT thing.
	// MurrayR 09/12/04: SAT does not exist in either LAF spec or layout tool
    return ZeroWindowLayout();
    }

// C= H=312 W=352 b=0 l= r=0 t= 
// Remark                    : Composer symbol selection pop-up window.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 80%) : popup_grid_large_graphic_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_grid_large_compo_graphic_window() 
    {
	// MurrayR 07/12/04: Not supported in the layout tool & not used in code.
	// TODO: Confirm not used.
    return ZeroWindowLayout();
    }

// C= H=304 W=352 b=0 l= r=0 t= 
// Remark                    : Presence status indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : popup_dyc_status_message_window
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_dyc_status_message_window()
    {
	// MurrayR 07/12/04: Good match
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_dyc_status_message_window(varietyIndex).LayoutLine();
    return line;
    }

// LAF Table : Thumbnail image sizes
// C= H=60 W=80 b= l= r= t= 
// Remark                    : 
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (100%) : image_vga_pane
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknWindowLineLayout VGA() 
    {
	// MurrayR 07/12/04: No corresponding thumbnail support in layout tool
	// TODO: Fix if thumbnail support is ever added
    return ZeroWindowLayout();
    }

// C= H=80 W=60 b= l= r= t= 
// Remark                    : 
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (  0%) : 
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknWindowLineLayout VGA_turned_90() 
    {
	// MurrayR 07/12/04: No corresponding thumbnail support in layout tool
	// TODO: Fix if thumbnail support is ever added
    return ZeroWindowLayout();
    }

// C= H=72 W=88 b= l= r= t= 
// Remark                    : 
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (100%) : image_cif_pane
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknWindowLineLayout CIF()
    {
	// MurrayR 07/12/04: No corresponding thumbnail support in layout tool
	// TODO: Fix if thumbnail support is ever added
    return ZeroWindowLayout();
    }

// C= H=68 W=72 b= l= r= t= 
// Remark                    : 
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (  0%) : 
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknWindowLineLayout CIF_turned_90()
    {
	// MurrayR 07/12/04: No corresponding thumbnail support in layout tool
	// TODO: Fix if thumbnail support is ever added
    return ZeroWindowLayout();
    }

// C= H=96 W=80 b= l= r= t= 
// Remark                    : 
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (  0%) : 
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknWindowLineLayout Communicator_personal_image()
    {
	// MurrayR 07/12/04: No corresponding thumbnail support in layout tool
	// TODO: Fix if thumbnail support is ever added
    return ZeroWindowLayout();
    }

// C= H=96 W=60 b= l= r= t= 
// Remark                    : 
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (  0%) : 
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknWindowLineLayout Image_aspect_ratio___0_625()
    {
	// MurrayR 07/12/04: No corresponding thumbnail support in layout tool
	// TODO: Fix if thumbnail support is ever added
    return ZeroWindowLayout();
    }

// C= H=60 W=88 b= l= r= t= 
// Remark                    : 
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (  0%) : 
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknWindowLineLayout Image_aspect_ratio___1_467()
    {
	// MurrayR 07/12/04: No corresponding thumbnail support in layout tool
	// TODO: Fix if thumbnail support is ever added
    return ZeroWindowLayout();
    }

// C= H=84 W=80 b= l= r= t= 
// Remark                    : 
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (  0%) : 
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknWindowLineLayout _0_625___image_aspect_ratio___1_467() 
    {
	// MurrayR 07/12/04: No corresponding thumbnail support in layout tool
	// TODO: Fix if thumbnail support is ever added
    return ZeroWindowLayout();
    }

// LAF Table : Message writing layout elements
// C=215 H={34, 68, 102, 136, 170, 204, 238, 272} W=348 b= l=2 r= t={12, 46, 80, 114, 148, 182, 216, 250} 
// Remark                    : Outline editing frame.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Message_writing_layout_elements_Line_1(TInt /*aIndex_t*/, TInt aIndex_H)
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_messa_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_mce_pane();
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::mce_header_pane(0);
    TAknWindowComponentLayout layout4 = AknLayoutScalable_Apps::mce_header_field_pane(aIndex_H);
    TAknWindowComponentLayout layout5 = AknLayoutScalable_Apps::input_focus_pane_cp03();
    return DoCompose(layout1, DoCompose(layout2,DoCompose(layout3, DoCompose(layout4,layout5)))).LayoutLine();
    }
    
// C=221 H={28, 62, 96, 130, 164, 198, 232, 266} W=2 b= l=4 r= t={14, 42, 70, 98, 126, 154, 182, 210, 238} 
// Remark                    : Vertical shadow inside the editing frame.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Message_writing_layout_elements_Line_2(TInt /*aIndex_t*/, TInt /*aIndex_H*/)
    {
    // MAN: NOT SUPPORTED (line) (not used)
    return EmptyWindowLayout();
    }
    
// C=221 H=2 W=342 b= l=6 r= t={16, 50, 84, 118, 152, 186, 220, 254} 
// Remark                    : Horizontal shadow inside the editing frame.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Message_writing_layout_elements_Line_3(TInt /*aIndex_t*/)
    {
    // MAN: NOT SUPPORTED (line) (not used)
    return EmptyWindowLayout();
    }
    
// C=215 H={56, 90, 124, 158, 192, 226, 260} W=2 b= l=100 r= t=0 
// Remark                    : A line between the heading and user data.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Message_writing_layout_elements_Line_4(TInt /*aIndex_H*/)
    {
    // NOT USED
    return EmptyWindowLayout();
    }
    
// C= H=2 W=248 b= l=102 r= t={58, 92, 126, 160, 194, 228} 
// Remark                    : A line at the bottom of the header section.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Message_writing_layout_elements_Line_5(TInt /*aIndex_t*/)
    {
    // NOT USED
    return EmptyWindowLayout();
    }
    
// C={42, 128} H=2 W=344 b= l=4 r= t={44, 78, 112, 146, 180, 214, 248, 282} 
// Remark                    : Text lines on the text section.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Message_writing_layout_elements_Line_6(TInt /*aIndex_C*/, TInt aIndex_t)
    {
    // MAN: DONE but aIndex_C is always ignored as new LAF does not provide more than 1 colors
    //
    // MAN 19.1.2005: Actually new laf does not even provide any colors, it sis assumed that application draws
    // this with SVG graphics
	TInt rowIndex = aIndex_t;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_messa_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_mce_pane();
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::mce_text_pane(0);    
    TAknWindowComponentLayout layout4 = AknLayoutScalable_Apps::list_single_mce_message_pane(rowIndex);
    TAknWindowComponentLayout layout5 = AknLayoutScalable_Apps::list_single_mce_message_pane_g1();
    
    return DoCompose(layout1, DoCompose(layout2,DoCompose(layout3,DoCompose(layout4,layout5)))).LayoutLine();
    }
    
// C= H=30 W=4 b=6 l= r= t= 
// Remark                    : Cursor graphics.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Message_writing_layout_elements_Line_7()
    {
    // MAN: NOT SUPPORTED (line)
    return EmptyWindowLayout();
    }

// C= H={284, 100, 112} W={348, 300, 288} b= l= r= t={2, 38, 74, 110, 146, 182, 218, 254} 
// Remark                    : Maximum value.2 x operator logo.2 x image.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Message_writing_layout_elements_Line_8(TInt /*aIndex_t*/, TInt /*aIndex_W*/, TInt /*aIndex_H*/)
    {
    // MAN: DONE but all idexes are ignored.
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_messa_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::listscroll_mce_pane();
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::mce_image_pane();

    return DoCompose(layout1, DoCompose(layout2,layout3)).LayoutLine();    
    }

// C= H=78 W=104 b= l=4 r= t=4 
// Remark                    : Photo thumbnails.
// Parent                    : cell_cams_pane
// Parent API                : cell_cams_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : cell_cams_pane
TAknWindowLineLayout CamcorderBurst_Mode_Post_Recording_cell_elements_Line_1()
    {
    // MAN :DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cams_burst_image_pane();
    return layout1.LayoutLine();
    }

// C= H=26 W=26 b= l=82 r= t=4 
// Remark                    : Marked item indication.
// Parent                    : cell_cams_pane
// Parent API                : cell_cams_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : cell_cams_pane
TAknWindowLineLayout CamcorderBurst_Mode_Post_Recording_cell_elements_Line_2() 
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_cams_pane_g1();
    return layout1.LayoutLine();

    }

// C=35 H=26 W=26 b= l=40 r= t=234 
// Remark                    : Burst mode  indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_6() 
    {
    // MAN: DONE
    // Note that this line number is wrong in the LAF spec rel 2.6 v4.0.
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_camera_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::main_camera_pane_g3(varietyIndex); // burst mode
    return DoCompose(layout1, layout2).LayoutLine();    

    }
// C=35 H=26 W=26 b= l=66 r= t=234 
// Remark                    : Night mode indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_7()
    {
    // MAN: DONE
    // Note that this line number is wrong in the LAF spec rel 2.6 v4.0.
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_camera_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::main_camera_pane_g4(varietyIndex); // night mode
    return DoCompose(layout1, layout2).LayoutLine();    
    }

// C= H=264 W=348 b= l=2 r= t=2 
// Remark                    : Near QCIF image.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 28%) : image_subqcif_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout near_QCIF() 
    {
    // WARNING - Very close name clash: Near_QCIF != near_QCIF() 
    return EmptyWindowLayout();
    }
    
// B=28 C=0 Font=ELatinBold12_Scaled J=ELayoutAlignRight W=94 l=96 r=50 
// Remark                    : 
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    ( 40%) : media_player_g1
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknTextLineLayout Media_Player_navi_pane_texts_Line_1()
    {
    // MAN: DONE
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::navi_pane_mp_t2();
    return textLayout.LayoutLine();
    }
    
// C= H= W= b= l= r= t= 
// Remark                    : Volume off.
// Parent                    : smil_volume_pane
// Parent API                : smil_volume_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : smil_volume_pane_g1
TAknWindowLineLayout Volume_strength_area_values_Line_1() 
    {
    // MAN: NOT SUPPORTED (not used)
    // Volume_strength_area_values(TInt aLineIndex) can be used instead.
    return EmptyWindowLayout();
    }
    
// C= H=28 W=12 b= l=0 r= t=0 
// Remark                    : 
// Parent                    : smil_volume_pane
// Parent API                : smil_volume_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : smil_volume_pane_g1
TAknWindowLineLayout Volume_strength_area_values_Line_2() 
    {
    // MAN: NOT SUPPORTED (not used)
    // Volume_strength_area_values(TInt aLineIndex) can be used instead.
    return EmptyWindowLayout();
    }

// C= H=28 W=24 b= l=0 r= t=0 
// Remark                    : 
// Parent                    : smil_volume_pane
// Parent API                : smil_volume_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : smil_volume_pane_g1
TAknWindowLineLayout Volume_strength_area_values_Line_3() 
    {
    // MAN: NOT SUPPORTED (not used)
    // Volume_strength_area_values(TInt aLineIndex) can be used instead.
    return EmptyWindowLayout();
    }
    
// C= H=28 W=36 b= l=0 r= t=0 
// Remark                    : 
// Parent                    : smil_volume_pane
// Parent API                : smil_volume_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : smil_volume_pane_g1
TAknWindowLineLayout Volume_strength_area_values_Line_4()
    {
    // MAN: NOT SUPPORTED (not used)
    // Volume_strength_area_values(TInt aLineIndex) can be used instead.
    return EmptyWindowLayout();
    }
    
// C= H=28 W=48 b= l=0 r= t=0 
// Remark                    : 
// Parent                    : smil_volume_pane
// Parent API                : smil_volume_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : smil_volume_pane_g1
TAknWindowLineLayout Volume_strength_area_values_Line_5() 
    {
    // MAN: NOT SUPPORTED (not used)
    // Volume_strength_area_values(TInt aLineIndex) can be used instead.
    return EmptyWindowLayout();
    }
    
// C= H=28 W=60 b= l=0 r= t=0 
// Remark                    : 
// Parent                    : smil_volume_pane
// Parent API                : smil_volume_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : smil_volume_pane_g1
TAknWindowLineLayout Volume_strength_area_values_Line_6() 
    {
    // MAN: NOT SUPPORTED (not used)
    // Volume_strength_area_values(TInt aLineIndex) can be used instead.
    return EmptyWindowLayout();
   }
   
// C= H=28 W=72 b= l=0 r= t=0 
// Remark                    : 
// Parent                    : smil_volume_pane
// Parent API                : smil_volume_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : smil_volume_pane_g1
TAknWindowLineLayout Volume_strength_area_values_Line_7()
    {
    // MAN: NOT SUPPORTED (not used)
    // Volume_strength_area_values(TInt aLineIndex) can be used instead.
    return EmptyWindowLayout();
    }
    
// C= H=28 W=84 b= l=0 r= t=0 
// Remark                    : 
// Parent                    : smil_volume_pane
// Parent API                : smil_volume_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : smil_volume_pane_g1
TAknWindowLineLayout Volume_strength_area_values_Line_8() 
    {
    // MAN: NOT SUPPORTED (not used)
    // Volume_strength_area_values(TInt aLineIndex) can be used instead.
    return EmptyWindowLayout();
    }
    
// C= H=248 W=256 b= l=0 r= t=40 
// Remark                    : Compass graphics.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : blid_compass_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout blid_compass_pane() 
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_location_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::blid_compass_pane(); 
    return DoCompose(layout1, layout2).LayoutLine();    
    }
    
// C= H=82 W=26 b= l=318 r= t=160 
// Remark                    : Accuracy graphics. Off state.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 44%) : blid_compass_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout BLID_compass_view_elements_Line_2() 
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_location_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::blid_accuracy_pane(); 
    return DoCompose(layout1, layout2).LayoutLine();    
    }
    
// C= H=82 W=26 b= l=318 r= t=160 
// Remark                    : Accuracy graphics.  On state.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 44%) : blid_compass_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout BLID_compass_view_elements_Line_3() 
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_location_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::blid_accuracy_pane(); 
    return DoCompose(layout1, layout2).LayoutLine();    
    }
    
// C= H= W= b= l= r= t= 
// Remark                    : No coverage.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 46%) : blid_accuracy_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Accuracyvalues_Line_1() 
    {
    // NOT USED
    return EmptyWindowLayout();
    }
    
// C= H= W= b= l=318 r= t=232 
// Remark                    : level 1 (minimum  accuracy)
// Parent                    : 
// Parent API                : 
// Scale API match    ( 46%) : blid_accuracy_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Accuracyvalues_Line_2() 
    {
    // NOT USED
    return EmptyWindowLayout();
    }
    
// C= H= W= b= l=318 r= t=220 
// Remark                    : level 2
// Parent                    : 
// Parent API                : 
// Scale API match    ( 46%) : blid_accuracy_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Accuracyvalues_Line_3() 
    {
    // NOT USED
    return EmptyWindowLayout();
    }
    
// C= H= W= b= l=318 r= t=208 
// Remark                    : level 3
// Parent                    : 
// Parent API                : 
// Scale API match    ( 46%) : blid_accuracy_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Accuracyvalues_Line_4() 
    {
    // NOT USED
    return EmptyWindowLayout();
    }
    
// C= H= W= b= l=318 r= t=196 
// Remark                    : level 4
// Parent                    : 
// Parent API                : 
// Scale API match    ( 46%) : blid_accuracy_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Accuracyvalues_Line_5()
    {
    // NOT USED
    return EmptyWindowLayout();
    }
    
// C= H= W= b= l=318 r= t=184 
// Remark                    : level 5
// Parent                    : 
// Parent API                : 
// Scale API match    ( 46%) : blid_accuracy_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Accuracyvalues_Line_6() 
    {
    // NOT USED
    return EmptyWindowLayout();
    }
    
// C= H= W= b= l=318 r= t=172 
// Remark                    : level 6
// Parent                    : 
// Parent API                : 
// Scale API match    ( 46%) : blid_accuracy_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Accuracyvalues_Line_7() 
    {
    // NOT USED
    return EmptyWindowLayout();
    }
    
// C= H= W= b= l=318 r= t=160 
// Remark                    : level 7 (maximum  accuracy)
// Parent                    : 
// Parent API                : 
// Scale API match    ( 46%) : blid_accuracy_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Accuracyvalues_Line_8()
    {
    // NOT USED
    return EmptyWindowLayout();
    }
    
// B=32 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=160 l=6 r=186 
// Remark                    : Distance or speed  indication.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 38%) : blid_compass_pane
// Scale parent match (  0%) : 
TAknTextLineLayout BLIDcompass_view_texts_Line_1()
    {
    // MAN: DONE
	// t1 is distance or speed [LMB 12/01/2005]
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_location_pane();
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::main_location_t1();
    return DoComposeText(layout1, textLayout).LayoutLine();    
    }
    
// B=32 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignRight W=160 l=188 r=4 
// Remark                    : Time of arrival or  heading indication.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 38%) : blid_compass_pane
// Scale parent match (  0%) : 
TAknTextLineLayout BLIDcompass_view_texts_Line_2()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_location_pane();
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::main_location_t2(); 
    return DoComposeText(layout1, textLayout).LayoutLine();    
    }
    
// B=274 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignRight W=92 l=256 r=4 
// Remark                    : Accuracy  indication.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 38%) : blid_compass_pane
// Scale parent match (  0%) : 
TAknTextLineLayout BLIDcompass_view_texts_Line_3()
    {
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_location_pane();
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::main_location_t3(); 
    return DoComposeText(layout1, textLayout).LayoutLine();    
    }
    
// C= H=248 W=256 b= l=0 r= t=0 
// Remark                    : Compass  background graphics.
// Parent                    : blid_compass_pane
// Parent API                : blid_compass_pane
// Scale API match    ( 36%) : blid_compass_pane
// Scale parent match (100%) : blid_compass_pane
TAknWindowLineLayout Compasspane_elements_Line_1()
    {
    // MAN: NOT USED 19.1.2005
    return EmptyWindowLayout();
    }
    
// C=215 H=54 W=106 b= l= r= t= 
// Remark                    : Vector.
// Parent                    : blid_compass_pane
// Parent API                : blid_compass_pane
// Scale API match    ( 41%) : popup_grid_large_graphic_window_ParamLimits
// Scale parent match (100%) : blid_compass_pane
TAknWindowLineLayout Arrow_head__graphic() 
    {
    // MAN: NOT USED 19.1.2005
    return EmptyWindowLayout();
    }
    
// C=215 H=78 W=38 b=0 l= r= t= 
// Remark                    : Vector.
// Parent                    : blid_compass_pane
// Parent API                : blid_compass_pane
// Scale API match    ( 41%) : popup_grid_large_graphic_window_ParamLimits
// Scale parent match (100%) : blid_compass_pane
TAknWindowLineLayout Arrow_body__graphic()
    {
    // MAN: NOT USED 19.1.2005
    return EmptyWindowLayout();
    }
    
// C= H=32 W=32 b= l=94 r= t=94 
// Remark                    : 
// Parent                    : 
// Parent API                : 
// Scale API match    ( 47%) : wml_selection_box_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout blid_direction_pane() 
    {
    // MAN: NOT USED 19.1.2005
    return EmptyWindowLayout();
    }
    
// B=26 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignCenter W=32 l=0 r=0 
// Remark                    : Compass points.
// Parent                    : blid_direction_pane
// Parent API                : blid_direction_pane
// Scale API match    ( 28%) : wml_selection_box_pane_ParamLimits
// Scale parent match ( 47%) : wml_selection_box_pane_ParamLimits
TAknTextLineLayout BLIDdirection_elements_Line_1() 
    {
    // MAN: NOT USED 19.1.2005
    return EmptyTextLayout();
    }
    
// C= H=52 W=52 b= l=12 r= t=2 
// Remark                    : Animated incoming call indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Outgoingincoming_video_call_elements_Line_1()
    {
    // MAN: NOT SUPPORTED (Not specified in scalable LAF, not used. 22.11.2004)
    return EmptyWindowLayout();
    }
    
// C= H= W= b= l= r= t= 
// Remark                    : 
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Outgoingincoming_video_call_elements_Line_2()
    {
    // MAN: NOT SUPPORTED (This is only a dummy line in LAF, not used)
    return EmptyWindowLayout();
    }
    
// C= H=96 W=116 b= l=2 r= t=2 
// Remark                    : Background  graphics.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 38%) : call_video_uplink_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Uplink_video_image__large__Line_1() 
    {
	// MAN: DONE
    if ( Layout_Meta_Data::IsLandscapeOrientation() )
        {
        TAknWindowComponentLayout layout1 = 
            AknLayoutScalable_Apps::main_pane( 4 );
        TAknWindowComponentLayout layout2 = 
            AknLayoutScalable_Apps::main_video_tele_pane();
        TAknWindowComponentLayout layout3 = 
            AknLayoutScalable_Apps::call_video_uplink_pane_cp1( 0 );
        TAknWindowComponentLayout layout4 = 
            AknLayoutScalable_Apps::call_video_uplink_pane_g1();
        return 
            DoCompose( 
                DoCompose( layout1, layout2 ), 
                DoCompose( layout3, layout4 ) ).LayoutLine();
        }
    else
        {
        TAknWindowComponentLayout layout1 = 
            AknLayoutScalable_Apps::call_video_uplink_pane(0);
        TAknWindowComponentLayout layout2 = 
            AknLayoutScalable_Apps::call_video_uplink_pane_g1();
        return DoCompose(layout1, layout2).LayoutLine();  
        }
    }

// C= H=92 W=112 b= l=4 r= t=4 
// Remark                    : Uplink video  stream.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 38%) : call_video_uplink_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Uplink_video_image__large__Line_2()
    {
	// MAN: DONE
    if ( Layout_Meta_Data::IsLandscapeOrientation() )
        {
        TAknWindowComponentLayout layout1 = 
            AknLayoutScalable_Apps::main_pane( 4 );
        TAknWindowComponentLayout layout2 = 
            AknLayoutScalable_Apps::main_video_tele_pane();
        TAknWindowComponentLayout layout3 = 
            AknLayoutScalable_Apps::call_video_uplink_pane_cp1( 0 );
        TAknWindowComponentLayout layout4 = 
            AknLayoutScalable_Apps::video_uplink_pane();
        return 
            DoCompose( 
                DoCompose( layout1, layout2 ), 
                DoCompose( layout3, layout4 ) ).LayoutLine();
        }
    else
        {
        TAknWindowComponentLayout layout1 = 
            AknLayoutScalable_Apps::call_video_uplink_pane( 0 );
        TAknWindowComponentLayout layout2 = 
            AknLayoutScalable_Apps::video_uplink_pane();
        return DoCompose(layout1, layout2).LayoutLine();
        }
    }

// C= H=26 W=42 b= l=74 r= t=4 
// Remark                    : Uplink blind  indication.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 38%) : call_video_uplink_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Uplink_video_image__large__Line_3() 
    {
	// MAN: DONE
    if ( Layout_Meta_Data::IsLandscapeOrientation() )
        {
        TAknWindowComponentLayout layout1 = 
            AknLayoutScalable_Apps::main_pane( 4 );
        TAknWindowComponentLayout layout2 = 
            AknLayoutScalable_Apps::main_video_tele_pane();
        TAknWindowComponentLayout layout3 = 
            AknLayoutScalable_Apps::call_video_uplink_pane_cp1( 0 );
        TAknWindowComponentLayout layout4 = 
            AknLayoutScalable_Apps::call_video_uplink_pane_g2();
        return 
            DoCompose( 
                DoCompose( layout1, layout2 ), 
                DoCompose( layout3, layout4 ) ).LayoutLine();
        }
    else
        {
        TAknWindowComponentLayout layout1 = 
            AknLayoutScalable_Apps::call_video_uplink_pane( 0 );
        TAknWindowComponentLayout layout2 = 
            AknLayoutScalable_Apps::call_video_uplink_pane_g2();
        return DoCompose(layout1, layout2).LayoutLine();  
        }
    }
    
// C=217 H=286 W=348 b= l=2 r= t=2 
// Remark                    : Background  graphics.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 42%) : call_video_uplink_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Downlink_video_image_Line_1() 
    {
    // MAN: DONE
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_video_tele_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::call_video_g1(varietyIndex); 
    return DoCompose(layout1, layout2).LayoutLine();    
    }
    
// C= H=286 W=348 b= l=2 r= t=2 
// Remark                    : Cropped downlink  video stream.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout downlink_stream() 
    {
    // MAN: DONE
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 2 : 0;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_video_tele_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::video_down_crop_pane(varietyIndex); 
    return DoCompose(layout1, layout2).LayoutLine();    
    }
// C= H=50 W=106 b= l=242 r= t=4 
// Remark                    : Downlink blind  indicator.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 42%) : call_video_uplink_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Downlink_video_image_Line_3() 
    {
    // MAN: DONE
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_video_tele_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::call_video_g2(varietyIndex); 
    return DoCompose(layout1, layout2).LayoutLine();    
    }
    
// C= H=56 W=178 b= l=112 r= t=0 
// Remark                    : 
// Parent                    : 
// Parent API                : 
// Scale API match    ( 62%) : main_video_tele_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout title_pane() 
    {
    // MAN: DONE 
    // This may become a problem, for double and qvga we can use
    // values from Avkon layout but for 176x208 not....
    return AknLayoutScalable_Avkon::title_pane(1).LayoutLine();
    }
    
// C= H=56 W=24 b= l= r=24 t=0 
// Remark                    : 
// Parent                    : 
// Parent API                : 
// Scale API match    ( 43%) : clock_digital_separator_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout uni_indicator_pane() 
    {
    // MAN: DONE 
    // This may become a problem, for double and qvga we can use
    // values from Avkon layout but for 176x208 not....

	// 0 = classic, 1 = flat
	return AknLayoutScalable_Avkon::uni_indicator_pane(0).LayoutLine();
    }
    
// B={22, 50} C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=170 l=2 r=6 
// Remark                    : CLI two rows of text.
// Parent                    : title_pane
// Parent API                : title_pane
// Scale API match    ( 60%) : mce_text_pane_ParamLimits
// Scale parent match ( 62%) : main_video_tele_pane
TAknTextLineLayout Title_pane_texts_Line_2(TInt aIndex_B)
    {
    // MAN: DONE 
    // This may become a problem, for double and qvga we can use
    // values from Avkon layout but for 176x208 not....
    if (aIndex_B == 0)
		return AknLayoutScalable_Avkon::title_pane_t2(0).LayoutLine();
	else
		return AknLayoutScalable_Avkon::title_pane_t3(0).LayoutLine();
    }
    
// C=0 H=32 W=34 b= l=18 r= t=0 
// Remark                    : Audio routing  indicator.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Navipane_elements_and_descendant_panes_Line_1()
    {
    // MAN: DONE
    return AknLayoutScalable_Apps::navi_pane_vt_g1().LayoutLine();
    }
    
// C= H=32 W=202 b= l=0 r= t=0 
// Remark                    : Zooming indicator  pane.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 60%) : bg_cale_heading_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout zooming_pane()
    {
    // MAN: DONE
    return AknLayoutScalable_Apps::zooming_pane().LayoutLine();
    }
    
// C=0 H=32 W=18 b= l=10 r= t=0 
// Remark                    : Zooming adjusting  direction indication + and - signs
// Parent                    : zooming_pane
// Parent API                : zooming_pane
// Scale API match    ( 35%) : cale_week_day_heading_pane_t1
// Scale parent match ( 60%) : bg_cale_heading_pane
TAknWindowLineLayout Zooming_pane_elements_Line_1() 
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::zooming_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::zooming_pane_g1(); 
    return DoCompose(layout1, layout2).LayoutLine();    
    }
    
// C=0 H=22 W=166 b= l=28 r= t=0 
// Remark                    : Zooming area  form skinnable component.
// Parent                    : zooming_pane
// Parent API                : zooming_pane
// Scale API match    ( 35%) : cale_week_day_heading_pane_t1
// Scale parent match ( 60%) : bg_cale_heading_pane
TAknWindowLineLayout Zooming_pane_elements_Line_2() 
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::zooming_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::zooming_pane_g2(); 
    return DoCompose(layout1, layout2).LayoutLine();    
    }
    
// C= H=22 W=166 b= l=28 r= t=6 
// Remark                    : Minimum zooming  level indication.
// Parent                    : zooming_pane
// Parent API                : zooming_pane
// Scale API match    ( 35%) : cale_week_day_heading_pane_t1
// Scale parent match ( 60%) : bg_cale_heading_pane
TAknWindowLineLayout Zooming_pane_elements_Line_3() 
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::zooming_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::zooming_pane_g3(); 
    return DoCompose(layout1, layout2).LayoutLine();    
    }
    
// C= H=22 W=166 b= l=28 r= t=6 
// Remark                    : Maximum zooming  level indication.
// Parent                    : zooming_pane
// Parent API                : zooming_pane
// Scale API match    ( 35%) : cale_week_day_heading_pane_t1
// Scale parent match ( 60%) : bg_cale_heading_pane
TAknWindowLineLayout Zooming_pane_elements_Line_4()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::zooming_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::zooming_pane_g3(); 
    return DoCompose(layout1, layout2).LayoutLine();    
    }
    
// B=24 C=0 Font=ELatinPlain12_Scaled J=ELayoutAlignRight W=80 l=104 r=20 
// Remark                    : Call duration.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 33%) : context_pane
// Scale parent match (  0%) : 
TAknTextLineLayout Navipanetexts_Line_1() 
    {
    // MAN: DONE
    return AknLayoutScalable_Apps::navi_pane_vt_t1().LayoutLine();
    }
    
// B=24 C=0 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=186 l=12 r=6 
// Remark                    : Muted call  indication.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 33%) : context_pane
// Scale parent match (  0%) : 
TAknTextLineLayout Navipanetexts_Line_2() 
    {
    // AsM 01.09.2005: The pane changed to navi_text_pane_t1.
    return AknLayoutScalable_Avkon::navi_text_pane_t1().LayoutLine();
    }
    
// C= H=46 W=50 b= l=14 r= t=20 
// Remark                    : Video call indicator.
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 26%) : call_video_uplink_pane_ParamLimits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout Videocall_indicator__NEwaiting_call__Line_1() 
    {
    //NOT USED
    TAknWindowLineLayout line = AknLayoutScalable_Apps::Screen().LayoutLine(); // NOT IMPLEMENTED
    return line;
    }
    
// C= H= W= b= l= r= t= 
// Remark                    : 
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 26%) : call_video_uplink_pane_ParamLimits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout Videocall_indicator__NEwaiting_call__Line_2() 
    {
    //NOT USED
    TAknWindowLineLayout line = AknLayoutScalable_Apps::Screen().LayoutLine(); // NOT IMPLEMENTED
    return line;
    }
    
// C= H=66 W=72 b= l=0 r= t=0 
// Remark                    : Status window  background graphics.
// Parent                    : popup_call_status_window
// Parent API                : popup_call_status_window
// Scale API match    ( 46%) : popup_call_status_window_g1
// Scale parent match (100%) : popup_call_status_window
TAknWindowLineLayout Callstatus_pop_up_window_elements_Line_1() 
    {
    //NOT USED
    TAknWindowLineLayout line = AknLayoutScalable_Apps::Screen().LayoutLine(); // NOT IMPLEMENTED
    return line;
    }
    
// C= H=46 W=50 b= l=10 r= t=14 
// Remark                    : Video call indicator.
// Parent                    : popup_call_status_window
// Parent API                : popup_call_status_window
// Scale API match    ( 46%) : popup_call_status_window_g1
// Scale parent match (100%) : popup_call_status_window
TAknWindowLineLayout Callstatus_pop_up_window_elements_Line_2() 
    {
    //NOT USED
    TAknWindowLineLayout line = AknLayoutScalable_Apps::Screen().LayoutLine(); // NOT IMPLEMENTED
    return line;
    }
    
// C= H=88 W=328 b= l=12 r= t=28 
// Remark                    : Index value 0
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    ( 28%) : list_im_single_pane_ParamLimits
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknWindowLineLayout Rectangle() 
    {
    // MAN: DONE    
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_skin_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::skin_g1();

    return DoCompose(layout1, layout2).LayoutLine();
    }
    
// C= H=32 W=32 b= l=20 r= t=36 
// Remark                    : Index value 226
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (  0%) : 
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknWindowLineLayout Colorpalette_preview_screen_element_placing__main_area__Line_2() 
    {
    // MAN: DONE    
    return Skin_color_palette_preview_color_pane_common(0, 0); // local function
    }
    
// C= H=32 W=32 b= l=60 r= t=36 
// Remark                    : Index value 227
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (  0%) : 
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknWindowLineLayout Colorpalette_preview_screen_element_placing__main_area__Line_3() 
    {
    // MAN: DONE    
    return Skin_color_palette_preview_color_pane_common(1, 0); // local function
    }
    
// C= H=32 W=32 b= l=100 r= t=36 
// Remark                    : Index value 228
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (  0%) : 
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknWindowLineLayout Colorpalette_preview_screen_element_placing__main_area__Line_4()
    {
    // MAN: DONE    
    return Skin_color_palette_preview_color_pane_common(2, 0); // local function
    }
    
// C= H=32 W=32 b= l=140 r= t=36 
// Remark                    : Index value 229
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (  0%) : 
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknWindowLineLayout Colorpalette_preview_screen_element_placing__main_area__Line_5() 
    {
    // MAN: DONE    
    return Skin_color_palette_preview_color_pane_common(3, 0); // local function
    }
    
// C= H=32 W=32 b= l=180 r= t=36 
// Remark                    : Index value 230
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (  0%) : 
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknWindowLineLayout Colorpalette_preview_screen_element_placing__main_area__Line_6() 
    {
    // MAN: DONE    
    return Skin_color_palette_preview_color_pane_common(4, 0); // local function
    }
    
// C= H=32 W=32 b= l=220 r= t=36 
// Remark                    : Index value 231
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (  0%) : 
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknWindowLineLayout Colorpalette_preview_screen_element_placing__main_area__Line_7() 
    {
    // MAN: DONE    
    return Skin_color_palette_preview_color_pane_common(5, 0); // local function
    }
    
// C= H=32 W=32 b= l=260 r= t=36 
// Remark                    : Index value 232
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (  0%) : 
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknWindowLineLayout Colorpalette_preview_screen_element_placing__main_area__Line_8() 
    {
    // MAN: DONE    
    return Skin_color_palette_preview_color_pane_common(6, 0); // local function
    }
    
// C= H=32 W=32 b= l=300 r= t=36 
// Remark                    : Index value 233
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (  0%) : 
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknWindowLineLayout Colorpalette_preview_screen_element_placing__main_area__Line_9() 
    {
    // MAN: DONE    
    return Skin_color_palette_preview_color_pane_common(7, 0); // local function
    }
    
// C= H=32 W=32 b= l=20 r= t=76 
// Remark                    : Index value 234
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (  0%) : 
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknWindowLineLayout Colorpalette_preview_screen_element_placing__main_area__Line_10() 
    {
    // MAN: DONE    
    return Skin_color_palette_preview_color_pane_common(0, 1); // local function
    }
    
// C= H=32 W=32 b= l=60 r= t=76 
// Remark                    : Index value 235
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (  0%) : 
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknWindowLineLayout Colorpalette_preview_screen_element_placing__main_area__Line_11() 
    {
    // MAN: DONE    
    return Skin_color_palette_preview_color_pane_common(1, 1); // local function
    }
    
// C= H=32 W=32 b= l=100 r= t=76 
// Remark                    : Index value 236
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (  0%) : 
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknWindowLineLayout Colorpalette_preview_screen_element_placing__main_area__Line_12() 
    {
    // MAN: DONE    
    return Skin_color_palette_preview_color_pane_common(2, 1); // local function
    }
    
// C= H=32 W=32 b= l=140 r= t=76 
// Remark                    : Index value 237
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (  0%) : 
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknWindowLineLayout Colorpalette_preview_screen_element_placing__main_area__Line_13() 
    {
    // MAN: DONE    
    return Skin_color_palette_preview_color_pane_common(3, 1); // local function
    }
    
// C= H=32 W=32 b= l=180 r= t=76 
// Remark                    : Index value 238
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (  0%) : 
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknWindowLineLayout Colorpalette_preview_screen_element_placing__main_area__Line_14() 
    {
    // MAN: DONE    
    return Skin_color_palette_preview_color_pane_common(4, 1); // local function
    }
    
// C= H=32 W=32 b= l=220 r= t=76 
// Remark                    : Index value 239
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (  0%) : 
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknWindowLineLayout Colorpalette_preview_screen_element_placing__main_area__Line_15() 
    {
    // MAN: DONE    
    return Skin_color_palette_preview_color_pane_common(5, 1); // local function
    }
    
// C= H=32 W=32 b= l=260 r= t=76 
// Remark                    : Index value 240
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (  0%) : 
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknWindowLineLayout Colorpalette_preview_screen_element_placing__main_area__Line_16() 
    {
    // MAN: DONE    
    return Skin_color_palette_preview_color_pane_common(6, 1); // local function
    }
    
// C= H=32 W=32 b= l=300 r= t=76 
// Remark                    : Index value 241
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (  0%) : 
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknWindowLineLayout Colorpalette_preview_screen_element_placing__main_area__Line_17() 
    {
    // MAN: DONE    
    return Skin_color_palette_preview_color_pane_common(7, 1); // local function
    }
    
// C= H=40 W=352 b= l=0 r= t=186 
// Remark                    : List highlight  background
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (  0%) : 
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknWindowLineLayout Colorpalette_preview_screen_element_placing__main_area__Line_18() 
    {
    // MAN: DONE    
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_skin_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::list_highlight_pane_cp03();

    return DoCompose(layout1, layout2).LayoutLine();
    }

// B=168 C=11 Font=ELatinBold13_Scaled J=ELayoutAlignCenter W=320 l=18 r=14 
// Remark                    : 
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (  0%) : 
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknTextLineLayout Colorpalette_preview_screen_text_placing__main_area__Line_1() 
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_skin_pane();
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::skin_t1();

    return DoComposeText(layout1, textLayout).LayoutLine();
    }
    
// B=214 C=14 Font=ELatinBold13_Scaled J=ELayoutAlignCenter W=320 l=18 r=14 
// Remark                    : 
// Parent                    : 
// Parent API                : List_pane_texts__cale_time__Line_1
// Scale API match    (  0%) : 
// Scale parent match ( 59%) : list_cale_time_pane_g_Limits
TAknTextLineLayout Colorpalette_preview_screen_text_placing__main_area__Line_2() 
    {
    // MAN: DONE    
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_skin_pane();
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::skin_t2();

    return DoComposeText(layout1, textLayout).LayoutLine();
    }
    
// C= H=120 W=304 b= l=24 r= t=154 
// Remark                    : Audioskin pane.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 58%) : main_skin_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout audioskin_pane() 
    {
    // MAN: NOT SUPPORTED (not used 26.11.2004)
    return EmptyWindowLayout();
    }
    
// B=38 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=304 l=24 r=24 
// Remark                    : First item heading.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Audio_Playbackview_texts_Line_1()
    {
    // MAN: NOT SUPPORTED (not used 26.11.2004)
    return EmptyTextLayout();
    }
    
// B=70 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=294 l=34 r=24 
// Remark                    : First item data.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Audio_Playbackview_texts_Line_2()
    {
    // MAN: NOT SUPPORTED (not used 26.11.2004)
    return EmptyTextLayout();
    }
    
// B=102 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=304 l=24 r=24 
// Remark                    : Second item heading.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Audio_Playbackview_texts_Line_3()
    {
    // MAN: NOT SUPPORTED (not used 26.11.2004)
    return EmptyTextLayout();
    }
    
// B=134 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=294 l=34 r=24 
// Remark                    : Second item data.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Audio_Playbackview_texts_Line_4()
    {
    // MAN: NOT SUPPORTED (not used 26.11.2004)
    return EmptyTextLayout();
    }
    
// C= H=120 W=304 b= l=0 r= t=0 
// Remark                    : Audio skin.
// Parent                    : audioskin_pane
// Parent API                : audioskin_pane
// Scale API match    ( 31%) : main_skin_pane
// Scale parent match ( 58%) : main_skin_pane
TAknWindowLineLayout Audioskin_pane_elements_Line_1()
    {
    // MAN: NOT SUPPORTED (not used 26.11.2004)
    return EmptyWindowLayout();
    }
    
// C= H={156, 196, 236, 276, 316, 188, 228, 268, 310, 220, 260, 300, 340} W=352 b= l= r= t= 
// Remark                    : Location request query.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : popup_loc_request_window
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_loc_request_window(TInt aIndex_H) 
    {
    // layout data 0.75 now has options for this [LMB 16/12/2004]
    TInt varietyIndex = aIndex_H;
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_loc_request_window(varietyIndex).LayoutLine();
    return line;
    }
    
// C= H=38 W=324 b= l=6 r= t={8, 46, 84, 122, 160, 198} 
// Remark                    : Parent list_wml_pane
// Parent                    : list_conf_pane
// Parent API                : list_conf_pane
// Scale API match    (100%) : list_single_graphic_popup_wml_pane
// Scale parent match (100%) : list_conf_pane
TAknWindowLineLayout list_single_graphic_popup_wml_pane(TInt aIndex_t) 
    {
	// MurrayR 21/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::list_single_graphic_popup_wml_pane(aIndex_t).LayoutLine();
    return line;
    }
    
// C= H={38, 76, 114, 152, 190, 228} W=336 b= l=6 r= t=8 
// Remark                    : Address pane.
// Parent                    : popup_wml_address_window
// Parent API                : popup_wml_address_window
// Scale API match    (100%) : list_wml_pane
// Scale parent match (100%) : popup_wml_address_window
TAknWindowLineLayout list_wml_pane(TInt /*aIndex_H*/) 
    {
    // AsM modified
    TAknWindowComponentLayout single = AknLayoutScalable_Apps::listscroll_popup_wml_pane();
    TAknWindowComponentLayout line = AknLayoutScalable_Apps::list_wml_pane();
    return DoCompose(line, single).LayoutLine();
    }
    
// C=0 H=p W=350 b= l=0 r= t=0 
// Remark                    : A rectangle to cover the mainpane items
// Parent                    : popup_wml_address_window
// Parent API                : popup_wml_address_window
// Scale API match    ( 37%) : popup_wml_address_window_ParamLimits
// Scale parent match (100%) : popup_wml_address_window
TAknWindowLineLayout Browser_address_field_pop_up_window_graphics_Line_1(const TRect& /*aParentRect*/) 
    {
	// MurrayR 30/11/04 - This should be implemented with skins, client should not be calling this
    // could give an outer rectangle with bg_popup_sub_pane_cp02() but it seems better to
	// save space and return nul layout
    return EmptyWindowLayout();
    }
    
// C=221 H=p-8 W=342 b= l=6 r= t=6 
// Remark                    : Shadow
// Parent                    : popup_wml_address_window
// Parent API                : popup_wml_address_window
// Scale API match    ( 37%) : popup_wml_address_window_ParamLimits
// Scale parent match (100%) : popup_wml_address_window
TAknWindowLineLayout Browser_address_field_pop_up_window_graphics_Line_2(const TRect& /*aParentRect*/) 
    {
	// MurrayR 30/11/04 - This should be implemented with skins, client should not be calling this
    // could give an outer rectangle with bg_popup_sub_pane_cp02() but it seems better to
	// save space and return nul layout
    return EmptyWindowLayout();
    }
    
// C=215 H=p-6 W=344 b= l=2 r= t=2 
// Remark                    : Outline frame
// Parent                    : popup_wml_address_window
// Parent API                : popup_wml_address_window
// Scale API match    ( 37%) : popup_wml_address_window_ParamLimits
// Scale parent match (100%) : popup_wml_address_window
TAknWindowLineLayout Browser_address_field_pop_up_window_graphics_Line_3(const TRect& /*aParentRect*/) 
    {
	// MurrayR 30/11/04 - This should be implemented with skins, client should not be calling this
    // could give an outer rectangle with bg_popup_sub_pane_cp02() but it seems better to
	// save space and return nul layout
    return EmptyWindowLayout();
    }
    
// C=0 H=p-10 W=340 b= l=4 r= t=4 
// Remark                    : Inside area
// Parent                    : popup_wml_address_window
// Parent API                : popup_wml_address_window
// Scale API match    ( 37%) : popup_wml_address_window_ParamLimits
// Scale parent match (100%) : popup_wml_address_window
TAknWindowLineLayout Browser_address_field_pop_up_window_graphics_Line_4(const TRect& /*aParentRect*/) 
    {
	// MurrayR 30/11/04 - This should be implemented with skins, client should not be calling this
    // could give an outer rectangle with bg_popup_sub_pane_cp02() but it seems better to
	// save space and return nul layout
    return EmptyWindowLayout();
    }

// B=122 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=252 l=80 r=20 
// Remark                    : 3rd line of emergency call
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 47%) : popup_call_audio_first_window_t_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknTextLineLayout First_call_pop_up_window_texts__one_call__Line_3() 
    {
	// MurrayR 07/12/04: Good match
    TAknTextLineLayout textLine = AknLayoutScalable_Apps::popup_call_audio_first_window_t5(0).LayoutLine();
    return textLine;
    }
    
// C= H=154 W=352 b= l=0 r= t=0 
// Remark                    : emergency call
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 44%) : popup_call_audio_first_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_graphics__one_call__Line_2() 
    {
	// MurrayR 07/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::bg_popup_call_pane(5).LayoutLine();
    return line;
    }
    
// B=122 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=232 l=80 r=40 
// Remark                    : 3rd line of emergency call
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 44%) : popup_call_audio_first_window_t_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknTextLineLayout First_call_pop_up_window_texts__two_calls__Line_3()
    {
	// MurrayR 07/12/04: Good match
    TAknTextLineLayout textLine = AknLayoutScalable_Apps::popup_call_audio_first_window_t5(0).LayoutLine();
    return textLine;
    }
    
// C= H=154 W=352 b= l=0 r= t=0 
// Remark                    : emergency call
// Parent                    : popup_call_audio_first_window
// Parent API                : popup_call_audio_first_window
// Scale API match    ( 42%) : popup_call_audio_first_window_g_Limits
// Scale parent match (100%) : popup_call_audio_first_window
TAknWindowLineLayout First_call_pop_up_window_graphics__two_calls__Line_2() 
    {
	// MurrayR 07/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::bg_popup_call_pane(5).LayoutLine();
    return line;
    }

// C= H=12 W=12 b= l=0 r= t=0 
// Remark                    : First icon
// Parent                    : call_type_pane
// Parent API                : Call_status_pop_up_window_elements_Line_3
// Scale API match    ( 68%) : call_type_pane_cp022
// Scale parent match ( 54%) : popup_call_status_window_g1
TAknWindowLineLayout Call_type_pane_split_Line_1() 
    {
	// MurrayR 07/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_type_pane_g1().LayoutLine();
    return line;
    }
    
// C= H=12 W=12 b= l=12 r= t=0 
// Remark                    : Second icon
// Parent                    : call_type_pane
// Parent API                : Call_status_pop_up_window_elements_Line_3
// Scale API match    ( 68%) : call_type_pane_cp022
// Scale parent match ( 54%) : popup_call_status_window_g1
TAknWindowLineLayout Call_type_pane_split_Line_2()
    {
	// MurrayR 07/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::call_type_pane_g2().LayoutLine();
    return line;
    }

// C= H={56, 94, 132, 170, 208, 246} W=350 b={54, 80} l= r=0 t= 
// Remark                    : Browser address field popup window.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : popup_wml_address_window
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_wml_address_window(TInt aIndex_b, TInt aIndex_H)
    {
	// MurrayR 21/12/04: Good match
	TInt optionOffsetB = (aIndex_b == 1) ? 0 : 6;
    TAknWindowLineLayout line = AknLayoutScalable_Apps::popup_wml_address_window(optionOffsetB + aIndex_H).LayoutLine();
    return line;
    }
    
// C={0, 243} H=38 W=336 b= l=0 r= t=0 
// Remark                    : Highlight.
// Parent                    : list_single_graphic_popup_wml_pane
// Parent API                : list_single_graphic_popup_wml_pane
// Scale API match    ( 47%) : list_single_graphic_popup_wml_pane_g_Limits
// Scale parent match (100%) : list_single_graphic_popup_wml_pane
TAknWindowLineLayout List_pane_elements__browser_single_graphic__Line_1(TInt /*aIndex_C*/)
    {
	// MurrayR 06/12/04 - looks ok, except for lack of color parameterisation
    TAknWindowLineLayout line = AknLayoutScalable_Apps::list_single_graphic_popup_wml_pane_g1().LayoutLine();
    return line;
    }
    
// C= H=26 W=26 b= l=4 r= t=4 
// Remark                    : Address type indication.
// Parent                    : list_single_graphic_popup_wml_pane
// Parent API                : list_single_graphic_popup_wml_pane
// Scale API match    ( 47%) : list_single_graphic_popup_wml_pane_g_Limits
// Scale parent match (100%) : list_single_graphic_popup_wml_pane
TAknWindowLineLayout List_pane_elements__browser_single_graphic__Line_2()
    {
	// MurrayR 06/12/04: Good match
    TAknWindowLineLayout line = AknLayoutScalable_Apps::list_single_graphic_popup_wml_pane_g2().LayoutLine();
    return line;
    }
    
// B=26 C={215, 0} Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=296 l=36 r=4 
// Remark                    : Address text.
// Parent                    : list_single_graphic_popup_wml_pane
// Parent API                : list_single_graphic_popup_wml_pane
// Scale API match    ( 51%) : list_single_graphic_popup_wml_pane_g_Limits
// Scale parent match (100%) : list_single_graphic_popup_wml_pane
TAknTextLineLayout List_pane_texts__browser_single_graphic__Line_1(TInt /*aIndex_C*/)
    {
	// MurrayR 06/12/04: Good match, except for color parameterisation
    TAknTextLineLayout textLine = AknLayoutScalable_Apps::list_single_graphic_popup_wml_pane_t1().LayoutLine();
    return textLine;
    }
    
// C=35 H=26 W=26 b= l=92 r= t=234 
// Remark                    : White balance indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_8()
    {
    // MAN: DONE
    // Note that this line number is wrong in the LAF spec rel 2.6 v4.0.
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_camera_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::main_camera_pane_g5(varietyIndex); // night mode
    return DoCompose(layout1, layout2).LayoutLine();    
    }
    
// C= H=26 W=26 b= l=118 r= t=234 
// Remark                    : Burst mode  indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_9()
    {
    // MAN: DONE
    // Note that this line number is wrong in the LAF spec rel 2.6 v4.0.
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_camera_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::main_camera_pane_g6(varietyIndex);
    return DoCompose(layout1, layout2).LayoutLine();    
    }
    
// C={215, 35} H=24 W=22 b= l=14 r= t=8 
// Remark                    : Selected memory  type indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Video_Viewfinder_descendants_and_elements_Line_7(TInt /*aIndex_C*/)
    {
    // MAN :DONE
    // Note that this line number is wrong in the LAF spec rel 2.6 v4.0.
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 3 : 0;    
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_video_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::main_video_pane_g1(varietyIndex); // memory type
    return DoCompose(layout1, layout2).LayoutLine();        
    }
    
// C={215, 35} H=104 W=30 b= l=320 r= t=8 
// Remark                    : Zooming factor  indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Video_Viewfinder_descendants_and_elements_Line_8(TInt aIndex_C)
    {
    // MAN: DONE
    // Note that this line number is wrong in the LAF spec rel 2.6 v4.0.
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_video_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::cams_zoom_pane_cp(aIndex_C);
    return DoCompose(layout1, layout2).LayoutLine();        
    }
    
// C={215, 35} H=24 W=22 b= l=14 r= t=8 
// Remark                    : Selected memory  type indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Video_Recording_descendants_and_elements_Line_7(TInt aIndex_C)
    {
    // MAN :DONE
    // Note that this line number is wrong in the LAF spec rel 2.6 v4.0.
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_video_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::main_video_pane_g1(aIndex_C); // memory type
    return DoCompose(layout1, layout2).LayoutLine();        
    }
    
// C={215, 35} H=104 W=30 b= l=320 r= t=8 
// Remark                    : Zooming factor  indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Video_Recording_descendants_and_elements_Line_8(TInt aIndex_C)
    {
    // MAN: DONE
    // Note that this line number is wrong in the LAF spec rel 2.6 v4.0.
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_video_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::cams_zoom_pane_cp(aIndex_C);
    return DoCompose(layout1, layout2).LayoutLine();        
    }
    
// C={215, 35} H=26 W=26 b= l=8 r= t=40 
// Remark                    : Recording state  indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Video_Recording_descendants_and_elements_Line_9(TInt /*aIndex_C*/)
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_video_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::main_video_pane_g6(2); // rec/pause
    return DoCompose(layout1, layout2).LayoutLine();        
    }
    
// B=30 C={215, 35} Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=284 l=36 r=32 
// Remark                    : Available memory  indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Camcorder_viewfinder_texts_Line_1(TInt /*aIndex_C*/)
    {
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 3 : 0;
    TAknWindowComponentLayout layout = AknLayoutScalable_Apps::main_video_pane();
    TAknTextComponentLayout textLayout = AknLayoutScalable_Apps::main_video_pane_t1(varietyIndex);
    return DoComposeText(layout, textLayout).LayoutLine();
    }
    
// C=219 H=2 W=344 b= l=4 r= t={2, 90, 178} 
// Remark                    : Horizontal lines  between the cells.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Still_Image_Burst_Mode_Post_recording_elements_Line_1(TInt aIndex_t)
    {
    // MAN: DONE 
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TInt param = aIndex_t; 
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_burst_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::linegrid_cams_pane(varietyIndex);
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::linegrid_cams_pane_g(param);
    return DoCompose(layout1, DoCompose(layout2,layout3)).LayoutLine();    
    }

// C=219 H=176 W=2 b= l={4, 118, 232, 346} r= t=4 
// Remark                    : Vertical lines  between the cells.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Still_Image_Burst_Mode_Post_recording_elements_Line_2(TInt aIndex_l)
    {
    // MAN: DONE
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TInt param = aIndex_l + 3; 
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_burst_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::linegrid_cams_pane(varietyIndex);
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Apps::linegrid_cams_pane_g(param);
    return DoCompose(layout1, DoCompose(layout2,layout3)).LayoutLine();    
    }

// C= H=174 W=340 b= l=6 r= t=4 
// Remark                    : Burst mode photo  thumbnail selection grid.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : grid_cams_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout grid_cams_pane()
    {
    // MAN: DONE
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_burst_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::grid_cams_pane(varietyIndex);
    return DoCompose(layout1, layout2).LayoutLine();        
    }
    
// B=24 C=0 Font=ELatinPlain12_Scaled J=ELayoutAlignRight W=222 l=10 r=8 
// Remark                    : Timer indication.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknTextLineLayout Camcorder_Burst_Mode_texts_Line_1()
    {
    // MAN: NOT SUPPORTED (not used)
    // This has been removed from LAF specs (removed in A2.6 v1.1).
    return EmptyTextLayout();
    }
    
// C=0 H=32 W=30 b= l=0 r= t=2 
// Remark                    : Brightnesscontrast indications.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Brightness_Contrast_descendants_and_elements_Line_1()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::navi_pane_cams_g5(); 
    return layout1.LayoutLine();    
    }
    
// C= H=22 W=180 b= l=40 r= t=8 
// Remark                    : Slider graphics.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 42%) : mce_header_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout navi_slider_pane()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::navi_slider_pane(); 
    return layout1.LayoutLine();    
    }
    
//TAknLayoutTableLimits Camcorder_Brightness_Contrast_descendants_and_elements_Limits()
//TAknWindowLineLayout Camcorder_Brightness_Contrast_descendants_and_elements(TInt aLineIndex)

// C=0 H=2 W=180 b= l=40 r= t=16 
// Remark                    : Horizontal slider line.
// Parent                    : navi_slider_pane
// Parent API                : navi_slider_pane
// Scale API match    ( 29%) : mce_header_pane_ParamLimits
// Scale parent match ( 42%) : mce_header_pane_ParamLimits
TAknWindowLineLayout Navi_Slider_pane_elements_Line_1()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::navi_slider_pane_g1(); 
    return layout1.LayoutLine();    
    }
    
// C=0 H=22 W=22 b= l= r= t=6 
// Remark                    : Slider current value indication.
// Parent                    : navi_slider_pane
// Parent API                : navi_slider_pane
// Scale API match    ( 29%) : mce_header_pane_ParamLimits
// Scale parent match ( 42%) : mce_header_pane_ParamLimits
TAknWindowLineLayout Navi_Slider_pane_elements_Line_2()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::navi_slider_pane_g2(); 
    return layout1.LayoutLine();    
    }
    
//TAknLayoutTableLimits Navi_Slider_pane_elements_Limits()
//TAknWindowLineLayout Navi_Slider_pane_elements(TInt aLineIndex)

// C=0 H=32 W=30 b= l=0 r= t=2 
// Remark                    : Manual exposure indications.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Manual_Exposure_descendants_and_elements_Line_1()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::navi_pane_cams_g5(); 
    return layout1.LayoutLine();    
    }

// C= H=2 W=166 b= l=28 r= t=26 
// Remark                    : Minimum zooming level.
// Parent                    : zooming_pane
// Parent API                : zooming_pane
// Scale API match    (  0%) : 
// Scale parent match ( 60%) : bg_cale_heading_pane
TAknWindowLineLayout Zooming_steps_sizes_Line_1()    
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::aid_levels_zoom();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::level_1_zoom();
    return DoCompose(layout1, layout2).LayoutLine();        
    }

// C= H=2 W=166 b= l=28 r= t=24 
// Remark                    : 
// Parent                    : zooming_pane
// Parent API                : zooming_pane
// Scale API match    (  0%) : 
// Scale parent match ( 60%) : bg_cale_heading_pane
TAknWindowLineLayout Zooming_steps_sizes_Line_2()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::aid_levels_zoom();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::level_2_zoom();
    return DoCompose(layout1, layout2).LayoutLine();        
    }

// C= H=2 W=166 b= l=28 r= t=22 
// Remark                    : 
// Parent                    : zooming_pane
// Parent API                : zooming_pane
// Scale API match    (  0%) : 
// Scale parent match ( 60%) : bg_cale_heading_pane
TAknWindowLineLayout Zooming_steps_sizes_Line_3()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::aid_levels_zoom();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::level_3_zoom();
    return DoCompose(layout1, layout2).LayoutLine();        
    }

// C= H=2 W=166 b= l=28 r= t=20 
// Remark                    : 
// Parent                    : zooming_pane
// Parent API                : zooming_pane
// Scale API match    (  0%) : 
// Scale parent match ( 60%) : bg_cale_heading_pane
TAknWindowLineLayout Zooming_steps_sizes_Line_4()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::aid_levels_zoom();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::level_4_zoom();
    return DoCompose(layout1, layout2).LayoutLine();        
    }

// C= H=2 W=166 b= l=28 r= t=18 
// Remark                    : 
// Parent                    : zooming_pane
// Parent API                : zooming_pane
// Scale API match    (  0%) : 
// Scale parent match ( 60%) : bg_cale_heading_pane
TAknWindowLineLayout Zooming_steps_sizes_Line_5()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::aid_levels_zoom();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::level_5_zoom();
    return DoCompose(layout1, layout2).LayoutLine();        
    }

// C= H=2 W=166 b= l=28 r= t=16 
// Remark                    : 
// Parent                    : zooming_pane
// Parent API                : zooming_pane
// Scale API match    (  0%) : 
// Scale parent match ( 60%) : bg_cale_heading_pane
TAknWindowLineLayout Zooming_steps_sizes_Line_6()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::aid_levels_zoom();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::level_6_zoom();
    return DoCompose(layout1, layout2).LayoutLine();        
    }

// C= H=2 W=166 b= l=28 r= t=14 
// Remark                    : 
// Parent                    : zooming_pane
// Parent API                : zooming_pane
// Scale API match    (  0%) : 
// Scale parent match ( 60%) : bg_cale_heading_pane
TAknWindowLineLayout Zooming_steps_sizes_Line_7()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::aid_levels_zoom();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::level_7_zoom();
    return DoCompose(layout1, layout2).LayoutLine();        
    }

// C= H=2 W=166 b= l=28 r= t=12 
// Remark                    : 
// Parent                    : zooming_pane
// Parent API                : zooming_pane
// Scale API match    (  0%) : 
// Scale parent match ( 60%) : bg_cale_heading_pane
TAknWindowLineLayout Zooming_steps_sizes_Line_8()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::aid_levels_zoom();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::level_8_zoom();
    return DoCompose(layout1, layout2).LayoutLine();        
    }
// C= H=2 W=166 b= l=28 r= t=10 
// Remark                    : 
// Parent                    : zooming_pane
// Parent API                : zooming_pane
// Scale API match    (  0%) : 
// Scale parent match ( 60%) : bg_cale_heading_pane
TAknWindowLineLayout Zooming_steps_sizes_Line_9()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::aid_levels_zoom();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::level_9_zoom();
    return DoCompose(layout1, layout2).LayoutLine();        
    }

// C= H=2 W=166 b= l=28 r= t=8 
// Remark                    : 
// Parent                    : zooming_pane
// Parent API                : zooming_pane
// Scale API match    (  0%) : 
// Scale parent match ( 60%) : bg_cale_heading_pane
TAknWindowLineLayout Zooming_steps_sizes_Line_10()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::aid_levels_zoom();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::level_10_zoom();
    return DoCompose(layout1, layout2).LayoutLine();        
    }

// C= H=2 W=166 b= l=28 r= t=6 
// Remark                    : Maximum zooming level.
// Parent                    : zooming_pane
// Parent API                : zooming_pane
// Scale API match    (  0%) : 
// Scale parent match ( 60%) : bg_cale_heading_pane
TAknWindowLineLayout Zooming_steps_sizes_Line_11()
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::aid_levels_zoom();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::level_11_zoom();
    return DoCompose(layout1, layout2).LayoutLine();        
    }

// C= H=76 W=92 b= l=28 r= t=6 
// Remark                    : Background graphics.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 45%) : call_video_uplink_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Uplink_video_image__small__Line_1()
    {
	// MAN: DONE
    if ( Layout_Meta_Data::IsLandscapeOrientation() )
        {
        TAknWindowComponentLayout layout1 = 
            AknLayoutScalable_Apps::main_pane( 4 );
        TAknWindowComponentLayout layout2 = 
            AknLayoutScalable_Apps::main_video_tele_pane();
        TAknWindowComponentLayout layout3 = 
            AknLayoutScalable_Apps::call_video_uplink_pane_cp2(); 
        TAknWindowComponentLayout layout4 = 
            AknLayoutScalable_Apps::call_video_uplink_pane_g1();
        return 
            DoCompose( 
                DoCompose( layout1, layout2 ), 
                DoCompose( layout3, layout4 ) ).LayoutLine();
        }
    else
        {
        TAknWindowComponentLayout layout1 = 
            AknLayoutScalable_Apps::call_video_uplink_pane(1);
        TAknWindowComponentLayout layout2 = 
            AknLayoutScalable_Apps::call_video_uplink_pane_g1();
        return DoCompose(layout1, layout2).LayoutLine(); 
        }
    }

// C= H=72 W=88 b= l=30 r= t=8 
// Remark                    : Uplink video stream.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 45%) : call_video_uplink_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Uplink_video_image__small__Line_2()
    {
	// MAN: DONE
    if ( Layout_Meta_Data::IsLandscapeOrientation() )
        {
        TAknWindowComponentLayout layout1 = 
            AknLayoutScalable_Apps::main_pane( 4 );
        TAknWindowComponentLayout layout2 = 
            AknLayoutScalable_Apps::main_video_tele_pane();
        TAknWindowComponentLayout layout3 = 
            AknLayoutScalable_Apps::call_video_uplink_pane_cp2(); 
        TAknWindowComponentLayout layout4 = 
            AknLayoutScalable_Apps::video_uplink_pane();
        return 
            DoCompose( 
                DoCompose( layout1, layout2 ), 
                DoCompose( layout3, layout4 ) ).LayoutLine();
        }
    else
        {
        TAknWindowComponentLayout layout1 = 
            AknLayoutScalable_Apps::call_video_uplink_pane( 1 );
        TAknWindowComponentLayout layout2 = 
            AknLayoutScalable_Apps::video_uplink_pane();
        return DoCompose(layout1, layout2).LayoutLine();  
        }
    }

// C= H=26 W=42 b= l=76 r= t=8 
// Remark                    : Uplink blind indication.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 45%) : call_video_uplink_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Uplink_video_image__small__Line_3()
    {
 	// MAN: DONE
    if ( Layout_Meta_Data::IsLandscapeOrientation() )
        {
        TAknWindowComponentLayout layout1 = 
            AknLayoutScalable_Apps::main_pane( 4 );
        TAknWindowComponentLayout layout2 = 
            AknLayoutScalable_Apps::main_video_tele_pane();
        TAknWindowComponentLayout layout3 = 
            AknLayoutScalable_Apps::call_video_uplink_pane_cp2(); 
        TAknWindowComponentLayout layout4 = 
            AknLayoutScalable_Apps::call_video_uplink_pane_g2();
        return 
            DoCompose( 
                DoCompose( layout1, layout2 ), 
                DoCompose( layout3, layout4 ) ).LayoutLine();
        }
    else
        {
        TAknWindowComponentLayout layout1 = 
            AknLayoutScalable_Apps::call_video_uplink_pane( 1 );
        TAknWindowComponentLayout layout2 = 
            AknLayoutScalable_Apps::call_video_uplink_pane_g2();
        return DoCompose(layout1, layout2).LayoutLine();  
        }
    }

// C= H=10 W=116 b= l=2 r= t=0 
// Remark                    : Uplink image.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 42%) : call_video_uplink_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Downlink_video_image_Line_4()
    {
    // MAN: NOT SUPPORTED (not used 27.12.2004)
    return EmptyWindowLayout(); // NOT IMPLEMENTED
    }

// C= H=288 W=352 b= l=0 r= t=0 
// Remark                    : Uncropped downlink video stream.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout downlink_stream_area()
    {
    // MAN: DONE
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_video_tele_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::video_down_pane(varietyIndex);
    return DoCompose(layout1, layout2).LayoutLine();    
    }
    
TAknWindowLineLayout MIDP_text_elements_Line_1(TInt /*aIndex_t*/)
    {
    //NOT USED
    return EmptyWindowLayout();
    }

TAknWindowLineLayout MIDP_text_elements_Line_2()
    {
    // NOT USED
    return EmptyWindowLayout();
    }

TAknTextLineLayout MIDP_texts_Line_1(TInt /*aIndex_B*/)
    {
    // NOT USED
    return EmptyTextLayout();
    }

// LAF Table : Camcorder Zooming factor pane elements
// C=215 H=104 W=30 b= l=0 r= t=0 
// Remark                    : Zooming scale.
// Parent                    : cams_zoom_pane
// Parent API                : Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_4
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Zooming_factor_pane_elements_v2_Line_1(TInt /*aIndex_C*/)
    {
    // MAN: DONE
    // Note that it is a bit unsure if the new and old laf can be mapped like this.
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cams_zoom_pane_g2();
    return layout1.LayoutLine();    
    }

// C=215 H=10 W=6 b= l=12 r= t=0 
// Remark                    : Elevator.
// Parent                    : cams_zoom_pane
// Parent API                : Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_4
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Camcorder_Zooming_factor_pane_elements_v2_Line_2(TInt /*aIndex_C*/)
    {
    // MAN: DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cams_zoom_pane_g4();
    return layout1.LayoutLine();    
    }

TAknWindowLineLayout Camcorder_Zooming_factor_pane_elements_v2_Line_3(TInt /*aIndex_C*/)
    {
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cams_zoom_pane_g3(); // Min
    return layout1.LayoutLine();    
    }

TAknWindowLineLayout Camcorder_Zooming_factor_pane_elements_v2_Line_4(TInt /*aIndex_C*/)
    {
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cams_zoom_pane_g1(); // Max
    return layout1.LayoutLine();    
    }

// FM Radio layouts
TAknWindowLineLayout cell_radio_pane(TInt aIndex_t)
    {
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::cell_fmradio_pane(aIndex_t);
    return layout1.LayoutLine();   
    }

TAknWindowLineLayout FM_Radio_cell_elements_Line_1()
    {
    return EmptyWindowLayout(); // NOT USED
    }

TAknWindowLineLayout grid_radio_pane()
    {
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::grid_radio_pane();
    return layout1.LayoutLine();   
    }

TAknWindowLineLayout FM_Radio_elements_Line_2()
    {
    // vertical
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::bg_list_pane(0);
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Avkon::bg_list_pane_g4(2);
    return DoCompose(layout2, layout3).LayoutLine();
    }

TAknWindowLineLayout FM_Radio_elements_Line_3()
    {
    // horizontal
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::bg_list_pane(0);
    TAknWindowComponentLayout layout3 = AknLayoutScalable_Avkon::bg_list_pane_g5(2);
    return DoCompose(layout2, layout3).LayoutLine();
    }

TAknWindowLineLayout FM_Radio_elements_Line_4()
    {
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::wait_bar_pane_cp03();
    return layout1.LayoutLine();    
    }

TAknWindowLineLayout FM_Radio_elements_Line_5()
    {
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::wait_bar_pane_cp03();
    return layout1.LayoutLine();    
    }

/* TAknLayoutTableLimits FM_Radio_elements_Limits();
   TAknWindowLineLayout FM_Radio_elements(TInt aLineIndex); */

TAknTextLineLayout FM_Radio_texts_Line_1()
    {
    TAknTextComponentLayout layout1 = AknLayoutScalable_Apps::main_fmradio_pane_t1();
    return layout1.LayoutLine();    
    }

TAknTextLineLayout FM_Radio_texts_Line_2()
    {
    TAknTextComponentLayout layout1 = AknLayoutScalable_Apps::main_fmradio_pane_t2();
    return layout1.LayoutLine();    
    }

TAknTextLineLayout FM_Radio_texts_Line_3()
    {
    TAknTextComponentLayout layout1 = AknLayoutScalable_Apps::main_fmradio_pane_t3();
    return layout1.LayoutLine();    
    }

TAknTextLineLayout FM_Radio_texts_Line_4()
    {
    TAknTextComponentLayout layout1 = AknLayoutScalable_Apps::main_fmradio_pane_t4();
    return layout1.LayoutLine();    
    }

TAknTextLineLayout FM_Radio_texts_Line_5()
    {
    TAknTextComponentLayout layout1 = AknLayoutScalable_Apps::main_fmradio_pane_t5();
    return layout1.LayoutLine();    
    }

/* TAknLayoutTableLimits FM_Radio_texts_Limits();
   TAknTextLineLayout FM_Radio_texts(TInt aLineIndex);*/

TAknWindowLineLayout aid_cams_cif_uncrop_pane()
    {
    // AsM 06.05.2005: DONE
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 2 : 0;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_video_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Apps::aid_cams_cif_uncrop_pane(varietyIndex);
    return DoCompose(layout1, layout2).LayoutLine();        
    }

TAknWindowLineLayout video_down_subqcif_pane()
    {
    // AsM DONE
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Apps::main_video_tele_pane();
    TAknWindowComponentLayout layout2;
    if (Layout_Meta_Data::IsLandscapeOrientation())
        {
        layout2 = AknLayoutScalable_Apps::video_down_subqcif_pane_cp(5);
        }
    else
        {
        layout2 = AknLayoutScalable_Apps::video_down_subqcif_pane(2);
        }
    return DoCompose(layout1, layout2).LayoutLine();    
    }

//
// Lookup Table
// This is needed for multiline texts and table decoding
// Do not modify
//

const TUint KDataLookup[AppLayout::E_TApiId_TableSize] =
	{
(TUint)&Browser_image_highlight_Line_1,

(TUint)&Browser_image_highlight_Line_2,

(TUint)&Browser_image_highlight_Line_3,

(TUint)&Browser_image_highlight_Line_4,

(TUint)&Browser_image_highlight_Line_5,

(TUint)&Browser_image_highlight_Line_6,

(TUint)&Browser_image_highlight_Line_7,

(TUint)&Browser_image_highlight_Line_8,

(TUint)&Browser_image_highlight_Line_9,

0x0008,

(TUint16)AppLayout::EApiId_Browser_image_highlight_Line_1,

(TUint)&Navi_pane_elements_Line_1,

(TUint)&list_cale_time_pane,

(TUint)&list_pinb_item_pane,

(TUint)&List_pane_elements__cale_time__Line_1,

(TUint)&List_pane_elements__cale_time__Line_2,

(TUint)&List_pane_elements__cale_time__Line_3,

(TUint)&List_pane_texts__cale_time__Line_1,

0x0101,	// Multiline_List_pane_texts__cale_time__Line_1

(TUint)&List_pane_texts__cale_time__Line_2,

(TUint)&List_pane_texts__cale_time__Line_3,

0x0203,	// Multiline_List_pane_texts__cale_time__Line_3

(TUint)&List_pane_elements__pinb_item__Line_1,

(TUint)&List_pane_elements__pinb_item__Line_2,

(TUint)&List_pane_elements__pinb_item__Line_3,

(TUint)&List_pane_elements__pinb_item__Line_4,

0x0002,

(TUint16)AppLayout::EApiId_List_pane_elements__pinb_item__Line_1,

(TUint)&List_pane_texts__pinb_item__Line_1,

(TUint)&List_pane_highlight__several__Line_1,

(TUint)&List_pane_highlight__several__Line_2,

0x0001,

(TUint16)AppLayout::EApiId_List_pane_highlight__several__Line_1,

(TUint)&cell_pinb_pane,

(TUint)&cell_qdial_pane,

(TUint)&cell_cale_month_pane,

(TUint)&cell_calc_pane,

(TUint)&cell_cale_week_pane,

(TUint)&cell_vorec_pane,

(TUint)&cell_gms_pane,

(TUint)&cell_mp_pane,

0x0001,

(TUint16)AppLayout::EApiId_cell_pinb_pane,

(TUint)&Cell_pane_elements__pinb__Line_1,

(TUint)&Cell_pane_elements__pinb__Line_2,

(TUint)&Cell_pane_elements__pinb__Line_3,

0x0002,

(TUint16)AppLayout::EApiId_Cell_pane_elements__pinb__Line_1,

(TUint)&Cell_pane_elements__qdial__Line_1,

(TUint)&Cell_pane_elements__qdial__Line_2,

(TUint)&Cell_pane_elements__qdial__Line_3,

(TUint)&Cell_pane_elements__qdial__Line_4,

(TUint)&Cell_pane_elements__qdial__Line_5,

(TUint)&Cell_pane_elements__qdial__Line_6,

(TUint)&Cell_pane_elements__qdial__Line_7,

(TUint)&Cell_pane_elements__qdial__Line_8,

(TUint)&Cell_pane_elements__qdial__Line_9,

(TUint)&Cell_pane_elements__qdial__Line_10,

(TUint)&Cell_pane_elements__qdial__Line_11,

(TUint)&Cell_pane_elements__qdial__Line_12,

(TUint)&Cell_pane_elements__qdial__Line_13,

(TUint)&Cell_pane_elements__qdial__Line_14,

(TUint)&Cell_pane_elements__qdial__Line_15,

(TUint)&Cell_pane_elements__qdial__Line_16,

(TUint)&Cell_pane_elements__qdial__Line_17,

(TUint)&Cell_pane_elements__qdial__Line_18,

(TUint)&Cell_pane_elements__qdial__Line_19,

(TUint)&Cell_pane_elements__qdial__Line_20,

(TUint)&Cell_pane_elements__qdial__Line_21,

0x0014,

(TUint16)AppLayout::EApiId_Cell_pane_elements__qdial__Line_1,

(TUint)&Cell_pane_texts__qdial__Line_1,

0x0403,	// Multiline_Cell_pane_texts__qdial__Line_1

(TUint)&Cell_pane_elements__cale_month__Line_1,

(TUint)&Cell_pane_elements__cale_month__Line_2,

(TUint)&Cell_pane_texts__cale_month__Line_1,

(TUint)&Cell_pane_elements__calc__Line_1,

(TUint)&Cell_pane_elements__cale_week__Line_1,

(TUint)&Cell_pane_elements__cale_week__Line_2,

(TUint)&Cell_pane_elements__cale_week__Line_3,

(TUint)&Cell_pane_elements__cale_week__Line_4,

0x0102,

(TUint16)AppLayout::EApiId_Cell_pane_elements__cale_week__Line_1,

(TUint)&Voice_Recorder_cell_elements_Line_1,

(TUint)&Graphical_message_cell_elements_Line_1,

(TUint)&Graphical_message_cell_elements_Line_2,

0x0001,

(TUint16)AppLayout::EApiId_Graphical_message_cell_elements_Line_1,

(TUint)&MediaPlayer_cell_elements_Line_1,

(TUint)&Cell_pane_highlight_elements__various__Line_1,

(TUint)&Cell_pane_highlight_elements__qdial__Line_1,

(TUint)&Cell_pane_highlight_elements__qdial__Line_2,

(TUint)&Browser_texts_Line_1,

0x0101,	// Multiline_Browser_texts_Line_1

(TUint)&Browser_texts_Line_2,

0x0101,	// Multiline_Browser_texts_Line_2

(TUint)&Browser_texts_Line_3,

0x0101,	// Multiline_Browser_texts_Line_3

0x0002,

(TUint16)AppLayout::EApiId_Browser_texts_Line_1,

(TUint)&Browser_selection_box_elements_Line_1,

(TUint)&Browser_selection_box_elements_Line_2,

(TUint)&Browser_selection_box_elements_Line_3,

(TUint)&Browser_selection_box_elements_Line_4,

0x0003,

(TUint16)AppLayout::EApiId_Browser_selection_box_elements_Line_1,

(TUint)&Browser_highlights_Line_1,

(TUint)&Browser_highlights_Line_2,

0x0001,

(TUint16)AppLayout::EApiId_Browser_highlights_Line_1,

(TUint)&Browser_text_link_underlining_Line_1,

(TUint)&Browser_table_frame_graphics_and_highlight_Line_1,

(TUint)&Browser_table_frame_graphics_and_highlight_Line_2,

0x0001,

(TUint16)AppLayout::EApiId_Browser_table_frame_graphics_and_highlight_Line_1,

(TUint)&Browser_image_frame_and_highlight_Line_1,

(TUint)&Browser_image_frame_and_highlight_Line_2,

(TUint)&Browser_image_frame_and_highlight_Line_3,

0x0102,

(TUint16)AppLayout::EApiId_Browser_image_frame_and_highlight_Line_1,

(TUint)&Browser_broken_image_Line_1,

(TUint)&Browser_broken_image_Line_2,

(TUint)&Browser_broken_image_Line_3,

0x0002,

(TUint16)AppLayout::EApiId_Browser_broken_image_Line_1,

(TUint)&Browser_broken_image_text_Line_1,

(TUint)&Calendar_Day_view_elements_and_descendants_Line_1,

(TUint)&Calendar_Day_view_elements_and_descendants_Line_2,

(TUint)&Calendar_Day_view_elements_and_descendants_Line_3,

(TUint)&list_cale_pane,

0x0003,

(TUint16)AppLayout::EApiId_Calendar_Day_view_elements_and_descendants_Line_1,

(TUint)&List_pane_texts__cale_time_empty__Line_1,

0x0000,	// Multiline_List_pane_texts__cale_time_empty__Line_1

(TUint)&Calendar_Week_view_elements_Line_1,

(TUint)&Calendar_Week_view_elements_Line_2,

(TUint)&Calendar_Week_view_elements_Line_3,

(TUint)&Calendar_Week_view_elements_Line_4,

(TUint)&Calendar_Week_view_elements_Line_5,

(TUint)&Calendar_Week_view_elements_Line_6,

(TUint)&Calendar_Week_view_elements_Line_7,

(TUint)&Calendar_Week_view_elements_Line_8,

(TUint)&grid_cale_week_pane,

0x0004,

(TUint16)AppLayout::EApiId_Calendar_Week_view_elements_Line_1,

(TUint)&Calendar_Week_view_texts_Line_1,

(TUint)&Calendar_Week_view_texts_Line_2,

0x0000,	// Multiline_Calendar_Week_view_texts_Line_2

(TUint)&Calendar_Month_view_elements_Line_1,

(TUint)&Calendar_Month_view_elements_Line_2,

(TUint)&Calendar_Month_view_elements_Line_3,

(TUint)&Calendar_Month_view_elements_Line_4,

(TUint)&Calendar_Month_view_elements_Line_5,

(TUint)&Calendar_Month_view_elements_Line_6,

(TUint)&Calendar_Month_view_elements_Line_7,

(TUint)&grid_cale_month_pane,

0x0004,

(TUint16)AppLayout::EApiId_Calendar_Month_view_elements_Line_1,

(TUint)&Calendar_Month_view_texts_Line_1,

(TUint)&Calendar_Month_view_texts_Line_2,

0x0000,	// Multiline_Calendar_Month_view_texts_Line_2

(TUint)&Calculator_elements_Line_1,

(TUint)&gqn_graf_calc_paper,

(TUint)&Calculator_elements_Line_3,

(TUint)&grid_calc_pane,

0x0001,

(TUint16)AppLayout::EApiId_Calculator_elements_Line_1,

(TUint)&Calculator_texts_Line_1,

(TUint)&Calculator_texts_Line_2,

(TUint)&Calculator_texts_Line_3,

(TUint)&Calculator_texts_Line_4,

(TUint)&Calculator_texts_Line_5,

(TUint)&Calculator_texts_Line_6,

(TUint)&Calculator_texts_Line_7,

0x0000,	// Multiline_Calculator_texts_Line_7

(TUint)&Calculator_texts_Line_8,

0x0000,	// Multiline_Calculator_texts_Line_8

0x0005,

(TUint16)AppLayout::EApiId_Calculator_texts_Line_1,

0x0607,

(TUint16)AppLayout::EApiId_Calculator_texts_Line_1,

(TUint)&popup_clock__ref__window,

(TUint)&Real_Time_Alarm_Clock_view_descendants_panes_and_elements_Line_2,

(TUint)&Real_Time_Alarm_Clock_view_descendants_panes_and_elements_Line_3,

(TUint)&Real_Time_Alarm_Clock_view_descendants_panes_and_elements_Line_4,

(TUint)&Real_Time_Alarm_Clock_view_descendants_panes_and_elements_Line_5,

0x0004,

(TUint16)AppLayout::EApiId_popup_clock__ref__window,

(TUint)&Real_Time_Alarm_Clock_view_texts__skins__Line_1,

(TUint)&Real_Time_Alarm_Clock_view_texts__skins__Line_2,

0x0000,	// Multiline_Real_Time_Alarm_Clock_view_texts__skins__Line_2

(TUint)&Real_Time_Alarm_Clock_view_texts__skins__Line_3,

(TUint)&Real_Time_Alarm_Clock_view_texts__skins__Line_4,

0x0000,	// Multiline_Real_Time_Alarm_Clock_view_texts__skins__Line_4

(TUint)&Real_Time_Alarm_Clock_view_texts__skins__Line_5,

(TUint)&Real_Time_Alarm_Clock_view_texts__skins__Line_6,

0x0405,

(TUint16)AppLayout::EApiId_Real_Time_Alarm_Clock_view_texts__skins__Line_1,

(TUint)&Clock_find_pane_elements_Line_1,

(TUint)&Clock_find_pane_elements_Line_2,

(TUint)&Clock_find_pane_elements_Line_3,

(TUint)&Clock_find_pane_elements_Line_4,

(TUint)&Clock_find_pane_elements_Line_5,

0x0004,

(TUint16)AppLayout::EApiId_Clock_find_pane_elements_Line_1,

(TUint)&Find_pane_texts_Line_1,

(TUint)&Near_QCIF,

(TUint)&Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_2,

(TUint)&Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_3,

(TUint)&Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_4,

(TUint)&Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_5,

0x0008,

(TUint16)AppLayout::EApiId_Near_QCIF,

(TUint)&Camcorder_Zooming_factor_pane_elements_Line_1,

(TUint)&Camcorder_Zooming_factor_pane_elements_Line_2,

0x0001,

(TUint16)AppLayout::EApiId_Camcorder_Zooming_factor_pane_elements_Line_1,

(TUint)&Camcorder_Still_Image_Viewfinder_texts_Line_1,

(TUint)&Camcorder_Still_Image_Viewfinder_texts_Line_2,

0x0001,

(TUint16)AppLayout::EApiId_Camcorder_Still_Image_Viewfinder_texts_Line_1,

(TUint)&Camcorder_Video_Viewfinder_descendants_and_elements_Line_1,

(TUint)&Camcorder_Video_Viewfinder_descendants_and_elements_Line_2,

(TUint)&Camcorder_Video_Viewfinder_descendants_and_elements_Line_3,

(TUint)&Camcorder_Video_Viewfinder_descendants_and_elements_Line_4,

(TUint)&Camcorder_Video_Viewfinder_descendants_and_elements_Line_5,

(TUint)&Camcorder_Video_Viewfinder_descendants_and_elements_Line_6,

0x0001,

(TUint16)AppLayout::EApiId_Camcorder_Video_Viewfinder_descendants_and_elements_Line_1,

0x0207,

(TUint16)AppLayout::EApiId_Camcorder_Video_Viewfinder_descendants_and_elements_Line_1,

(TUint)&Camcorder_Video_Recording_descendants_and_elements_Line_1,

(TUint)&Camcorder_Video_Recording_descendants_and_elements_Line_2,

(TUint)&Camcorder_Video_Recording_descendants_and_elements_Line_3,

(TUint)&Camcorder_Video_Recording_descendants_and_elements_Line_4,

(TUint)&Camcorder_Video_Recording_descendants_and_elements_Line_5,

(TUint)&Camcorder_Video_Recording_descendants_and_elements_Line_6,

0x0001,

(TUint16)AppLayout::EApiId_Camcorder_Video_Recording_descendants_and_elements_Line_1,

0x0208,

(TUint16)AppLayout::EApiId_Camcorder_Video_Recording_descendants_and_elements_Line_1,

(TUint)&Camcorder_Duration_texts_Line_1,

(TUint)&QVGA,

(TUint)&Camcorder_Video_Post_recording_elements_Line_2,

(TUint)&Camcorder_Video_Post_recording_elements_Line_3,

0x0003,

(TUint16)AppLayout::EApiId_QVGA,

(TUint)&Graphical_message_selection_layout_elements_Line_1,

(TUint)&Graphical_message_selection_layout_elements_Line_2,

(TUint)&grid_gms_pane,

(TUint)&Help_texts_Line_1,

0x0000, // Multiline_Help_texts_Line_1

(TUint)&Phonebook_Photo_view_elements_Line_1,

(TUint)&Phonebook_Photo_view_elements_Line_2,

(TUint)&Phonebook_Photo_view_elements_Line_3,

(TUint)&Phonebook_Photo_view_elements_Line_4,

(TUint)&Phonebook_Photo_view_elements_Line_5,

(TUint)&Phonebook_Photo_view_elements_Line_6,

(TUint)&Phonebook_Photo_view_elements_Line_7,

(TUint)&Phonebook_Photo_view_elements_Line_8,

0x0007,

(TUint16)AppLayout::EApiId_Phonebook_Photo_view_elements_Line_1,

(TUint)&Presence_status_list_components_Line_1,

(TUint)&Presence_status_list_components_Line_2,

(TUint)&Presence_status_list_components_Line_3,

(TUint)&image_or_qgn_prop_dyc_big__ref_,

(TUint)&Presence_status_list_texts_Line_1,

0x0000,	// Multiline_Presence_status_list_texts_Line_1

(TUint)&Pinboard_elements__grid__Line_1,

(TUint)&Pinboard_elements__grid__Line_2,

(TUint)&Pinboard_elements__grid__Line_3,

(TUint)&Pinboard_elements__grid__Line_4,

(TUint)&Pinboard_elements__grid__Line_5,

(TUint)&Pinboard_elements__grid__Line_6,

(TUint)&Pinboard_elements__grid__Line_7,

(TUint)&find_pinb_pane,

0x0002,

(TUint16)AppLayout::EApiId_Pinboard_elements__grid__Line_1,

0x0607,

(TUint16)AppLayout::EApiId_Pinboard_elements__grid__Line_1,

(TUint)&Find_pane_elements__pinb__Line_1,

(TUint)&Find_pane_elements__pinb__Line_2,

(TUint)&Find_pane_elements__pinb__Line_3,

(TUint)&Find_pane_elements__pinb__Line_4,

0x0003,

(TUint16)AppLayout::EApiId_Find_pane_elements__pinb__Line_1,

(TUint)&Find_pane_texts__pinb__Line_1,

(TUint)&Find_pane_texts__pinb__Line_2,

0x0001,

(TUint16)AppLayout::EApiId_Find_pane_texts__pinb__Line_1,

(TUint)&Pinboard_elements__list__Line_1,

(TUint)&Pinboard_elements__list__Line_2,

(TUint)&Pinboard_elements__list__Line_3,

(TUint)&Pinboard_elements__list__Line_4,

(TUint)&Pinboard_elements__list__Line_5,

(TUint)&Pinboard_elements__list__Line_6,

(TUint)&list_pinb_pane,

0x0002,

(TUint16)AppLayout::EApiId_Pinboard_elements__list__Line_1,

(TUint)&Speed_Dial_descendants_Line_1,

(TUint)&grid_vorec_pane,

(TUint)&Voice_Recorder_elements_Line_2,

(TUint)&Voice_Recorder_elements_Line_3,

(TUint)&Voice_Recorder_elements_Line_4,

(TUint)&Voice_Recorder_elements_Line_5,

0x0004,

(TUint16)AppLayout::EApiId_grid_vorec_pane,

(TUint)&Voice_Recorder_texts_Line_1,

(TUint)&Voice_Recorder_texts_Line_2,

(TUint)&Voice_Recorder_texts_Line_3,

(TUint)&Voice_Recorder_texts_Line_4,

(TUint)&Voice_Recorder_texts_Line_5,

(TUint)&Voice_Recorder_texts_Line_6,

0x0005,

(TUint16)AppLayout::EApiId_Voice_Recorder_texts_Line_1,

(TUint)&Message_writing_texts_Line_1,

0x0000,	// Multiline_Message_writing_texts_Line_1

(TUint)&Message_writing_texts_Line_2,

0x0000,	// Multiline_Message_writing_texts_Line_2

(TUint)&Message_writing_texts_Line_3,

0x0000, // Multiline_Message_writing_texts_Line_3

0x0002,

(TUint16)AppLayout::EApiId_Message_writing_texts_Line_1,

(TUint)&Smart_Messages_Line_1,

0x0000,	// Multiline_Smart_Messages_Line_1

(TUint)&Smart_Messages_Line_2,

0x0000,	// Multiline_Smart_Messages_Line_2

0x0001,

(TUint16)AppLayout::EApiId_Smart_Messages_Line_1,

(TUint)&Note_writing_layout_elements_Line_1,

(TUint)&Note_writing_layout_elements_Line_2,

(TUint)&Note_writing_layout_elements_Line_3,

(TUint)&Note_writing_layout_elements_Line_4,

(TUint)&Note_writing_layout_elements_Line_5,

0x0003,

(TUint16)AppLayout::EApiId_Note_writing_layout_elements_Line_1,

(TUint)&Note_writing_texts_Line_1,

0x0000,	// Multiline_Note_writing_texts_Line_1

(TUint)&im_reading_pane,

(TUint)&im_writing_pane,

(TUint)&IM_navi_pane_texts_Line_1,

(TUint)&IM_reading_pane_texts_Line_1,

(TUint)&IM_reading_pane_texts_Line_2,

0x0000,	// Multiline_IM_reading_pane_texts_Line_2

(TUint)&IM_text_elements_Line_1,

(TUint)&IM_text_elements_Line_2,

(TUint)&smiley__qgn_prop_im_smileys__ref__,

0x0002,

(TUint16)AppLayout::EApiId_IM_text_elements_Line_1,

(TUint)&IM_reading_field_highlight_graphics_Line_1,

(TUint)&IM_reading_field_highlight_graphics_Line_2,

0x0001,

(TUint16)AppLayout::EApiId_IM_reading_field_highlight_graphics_Line_1,

(TUint)&IM_writing_field_elements_Line_1,

(TUint)&IM_writing_field_elements_Line_2,

(TUint)&IM_writing_field_elements_Line_3,

(TUint)&IM_writing_pane_texts_Line_1,

0x0000,	// Multiline_IM_writing_pane_texts_Line_1

(TUint)&mp_bg_pane,

(TUint)&Empty_Player_view_elements_Line_1,

(TUint)&Media_Player_Playback_view_navi_pane_elements_Line_1,

(TUint)&Media_Player_Playback_view_navi_pane_elements_Line_2,

0x0001,

(TUint16)AppLayout::EApiId_Media_Player_Playback_view_navi_pane_elements_Line_1,

(TUint)&Media_Player_Playback_view_navi_pane_texts_Line_1,

(TUint)&Media_Player_Playlist_navi_pane_elements_Line_1,

(TUint)&Media_Player_Playlist_navi_pane_elements_Line_2,

0x0001,

(TUint16)AppLayout::EApiId_Media_Player_Playlist_navi_pane_elements_Line_1,

(TUint)&grid_mp_pane,

(TUint)&Media_Player_Playback_view_elements_Line_2,

(TUint)&Media_Player_Playback_view_elements_Line_3,

(TUint)&Media_Player_Playback_view_elements_Line_4,

(TUint)&Media_Player_Playback_view_elements_Line_5,

(TUint)&Media_Player_Playback_view_elements_Line_6,

(TUint)&Media_Player_Playback_view_texts_Line_1,

(TUint)&Media_Player_Playback_view_texts_Line_2,

(TUint)&Media_Player_Playback_view_texts_Line_3,

(TUint)&Media_Player_Playback_view_texts_Line_4,

(TUint)&Media_Player_Playback_view_texts_Line_5,

(TUint)&Media_Player_Playback_view_texts_Line_6,

(TUint)&Media_Player_Playback_view_texts_Line_7,

0x0006,

(TUint16)AppLayout::EApiId_Media_Player_Playback_view_texts_Line_1,

(TUint)&SMIL_presentation_attachment_element_Line_1,

(TUint)&SMIL_presentation_attachment_highlight_Line_1,

(TUint)&SMIL_presentation_attachment_highlight_Line_2,

0x0001,

(TUint16)AppLayout::EApiId_SMIL_presentation_attachment_highlight_Line_1,

(TUint)&SMIL_presentation_elements_and_descendant_panes_Line_1,

(TUint)&smil_status_pane,

(TUint)&smil_text_pane,

0x0001,

(TUint16)AppLayout::EApiId_SMIL_presentation_elements_and_descendant_panes_Line_1,

(TUint)&smil_volume_pane,

(TUint)&SMIL_status_pane_elements_and_descendant_panes_Line_2,

(TUint)&SMIL_status_pane_elements_and_descendant_panes_Line_3,

(TUint)&SMIL_status_pane_elements_and_descendant_panes_Line_4,

0x0003,

(TUint16)AppLayout::EApiId_smil_volume_pane,

(TUint)&SMIL_status_pane_texts_Line_1,

(TUint)&SMIL_volume_pane_elements_Line_1,

(TUint)&SMIL_volume_pane_elements_Line_2,

0x0001,

(TUint16)AppLayout::EApiId_SMIL_volume_pane_elements_Line_1,

(TUint)&Location_request_type_texts_Line_1,

0x0000,	// Multiline_Location_request_type_texts_Line_1

(TUint)&Location_requestor_pane_elements_Line_1,

(TUint)&Location_reqestor_pane_texts_Line_1,

(TUint)&Location_request_popup_window_grapihcs_Line_1,

(TUint)&Location_request_popup_window_grapihcs_Line_2,

(TUint)&Location_request_popup_window_grapihcs_Line_3,

(TUint)&Location_request_popup_window_grapihcs_Line_4,

(TUint)&Location_request_popup_window_grapihcs_Line_5,

0x0004,

(TUint16)AppLayout::EApiId_Location_request_popup_window_grapihcs_Line_1,

0x000a,

(TUint16)AppLayout::EApiId_Volume_strength_area_values_Line_1,

(TUint)&SMIL_text_pane_elements_Line_1,

(TUint)&smil_scroll_pane,

(TUint)&SMIL_text_pane_texts_Line_1,

0x0101,	// Multiline_SMIL_text_pane_texts_Line_1

(TUint)&SMIL_scroll_pane_elements_Line_1,

(TUint)&SMIL_scroll_pane_elements_Line_2,

(TUint)&SMIL_scroll_pane_elements_Line_3,

0x0102,

(TUint16)AppLayout::EApiId_SMIL_scroll_pane_elements_Line_1,

(TUint)&popup_pbook_thumbnail_window,

(TUint)&popup_call_status_window,

(TUint)&popup_call_video_up_window,

(TUint)&popup_cale_events_window,

(TUint)&list_single_graphic_popup_conf_pane,

(TUint)&List_pane_elements__conf_single_graphic__Line_1,

(TUint)&List_pane_elements__conf_single_graphic__Line_2,

0x0001,

(TUint16)AppLayout::EApiId_List_pane_elements__conf_single_graphic__Line_1,

(TUint)&List_pane_texts__conf_single_graphic__Line_1,

(TUint)&List_pane_elements__menu_single_graphic_bt__Line_1,

(TUint)&List_pane_elements__menu_single_graphic_bt__Line_2,

(TUint)&List_pane_text__menu_single_graphic_bt__Line_1,

(TUint)&Highlight_graphics_Line_1,

(TUint)&Highlight_graphics_Line_2,

0x0001,

(TUint16)AppLayout::EApiId_Highlight_graphics_Line_1,

(TUint)&cell_large_graphic_popup_pane,

(TUint)&Cell_pane_elements__popup_large_graphic_gms__Line_1,

(TUint)&Cell_pane_elements__popup_large_graphic_gms__Line_2,

0x0001,

(TUint16)AppLayout::EApiId_Cell_pane_elements__popup_large_graphic_gms__Line_1,

(TUint)&Highlight_elements__grid_pop_up__Line_1,

(TUint)&Number_entry_pop_up_window_texts_Line_1,

(TUint)&Number_entry_pop_up_window_texts_Line_2,

0x0101,	// Multiline_Number_entry_pop_up_window_texts_Line_2

(TUint)&Number_entry_pop_up_window_graphics_Line_1,

(TUint)&Number_entry_pop_up_window_graphics_Line_2,

(TUint)&Number_entry_pop_up_window_graphics_Line_3,

(TUint)&Number_entry_pop_up_window_graphics_Line_4,

(TUint)&Number_entry_pop_up_window_graphics_Line_5,

0x0104,

(TUint16)AppLayout::EApiId_Number_entry_pop_up_window_graphics_Line_1,

(TUint)&popup_heading_pane,

(TUint)&Phonebook_memory_status_pop_up_window_descendants_and_elements_Line_2,

0x0001,

(TUint16)AppLayout::EApiId_popup_heading_pane,

(TUint)&Phonebook_memory_status_pop_up_window_texts_Line_1,

0x0000,	// Multiline_Phonebook_memory_status_pop_up_window_texts_Line_1

(TUint)&Phonebook_memory_status_pop_up_window_texts_Line_2,

0x0000,	// Multiline_Phonebook_memory_status_pop_up_window_texts_Line_2

0x0001,

(TUint16)AppLayout::EApiId_Phonebook_memory_status_pop_up_window_texts_Line_1,

(TUint)&Phonebook_memory_status_pop_up_window_graphics_Line_1,

(TUint)&Phonebook_memory_status_pop_up_window_graphics_Line_2,

(TUint)&Phonebook_memory_status_pop_up_window_graphics_Line_3,

(TUint)&Phonebook_memory_status_pop_up_window_graphics_Line_4,

(TUint)&Phonebook_memory_status_pop_up_window_graphics_Line_5,

0x0004,

(TUint16)AppLayout::EApiId_Phonebook_memory_status_pop_up_window_graphics_Line_1,

(TUint)&Graphical_message_image_selection_pop_up_window_descendants_Line_1,

(TUint)&grid_large_graphic_popup_pane,

(TUint)&Graphical_message_image_selection_pop_up_window_elements_Line_1,

(TUint)&Graphical_message_image_selection_pop_up_window_elements_Line_2,

(TUint)&Graphical_message_image_selection_pop_up_window_graphics_Line_1,

(TUint)&Graphical_message_image_selection_pop_up_window_graphics_Line_2,

(TUint)&Graphical_message_image_selection_pop_up_window_graphics_Line_3,

(TUint)&Graphical_message_image_selection_pop_up_window_graphics_Line_4,

(TUint)&Graphical_message_image_selection_pop_up_window_graphics_Line_5,

0x0004,

(TUint16)AppLayout::EApiId_Graphical_message_image_selection_pop_up_window_graphics_Line_1,

(TUint)&Browser_WIM_PIN_Code_query_pop_up_window_elements_Line_1,

(TUint)&Browser_WIM_PIN_Code_query_pop_up_window_elements_Line_2,

(TUint)&Browser_WIM_PIN_Code_query_pop_up_window_elements_Line_3,

(TUint)&Browser_WIM_PIN_Code_query_pop_up_window_elements_Line_4,

(TUint)&Browser_WIM_PIN_Code_query_pop_up_window_elements_Line_5,

(TUint)&Browser_WIM_PIN_Code_query_pop_up_window_elements_Line_6,

0x0103,

(TUint16)AppLayout::EApiId_Browser_WIM_PIN_Code_query_pop_up_window_elements_Line_1,

(TUint)&Browser_WIM_PIN_Code_query_pop_up_window_texts_Line_1,

(TUint)&Browser_WIM_PIN_Code_query_pop_up_window_texts_Line_2,

0x0000,	// Multiline_Browser_WIM_PIN_Code_query_pop_up_window_texts_Line_2

(TUint)&Browser_WIM_PIN_Code_query_pop_up_window_texts_Line_3,

0x0000,	// Multiline_Browser_WIM_PIN_Code_query_pop_up_window_texts_Line_3

0x0102,

(TUint16)AppLayout::EApiId_Browser_WIM_PIN_Code_query_pop_up_window_texts_Line_1,

(TUint)&Browser_WIM_PIN_Code_query_pop_up_window_graphics_Line_1,

(TUint)&Browser_WIM_PIN_Code_query_pop_up_window_graphics_Line_2,

(TUint)&Browser_WIM_PIN_Code_query_pop_up_window_graphics_Line_3,

(TUint)&Browser_WIM_PIN_Code_query_pop_up_window_graphics_Line_4,

(TUint)&Browser_WIM_PIN_Code_query_pop_up_window_graphics_Line_5,

0x0004,

(TUint16)AppLayout::EApiId_Browser_WIM_PIN_Code_query_pop_up_window_graphics_Line_1,

(TUint)&Browser_Digital_Signing_query_pop_up_window_elements_Line_1,

(TUint)&Browser_Digital_Signing_query_pop_up_window_elements_Line_2,

0x0001,

(TUint16)AppLayout::EApiId_Browser_Digital_Signing_query_pop_up_window_elements_Line_1,

(TUint)&Browser_Digital_Signing_query_pop_up_window_texts_Line_1,

(TUint)&Browser_Digital_Signing_query_pop_up_window_texts_Line_2,

0x0101,	// Multiline_Browser_Digital_Signing_query_pop_up_window_texts_Line_2

(TUint)&SAT_Information_query_pop_up_window_elements_Line_1,

(TUint)&SAT_Information_query_pop_up_window_elements_Line_2,

0x0001,

(TUint16)AppLayout::EApiId_SAT_Information_query_pop_up_window_elements_Line_1,

(TUint)&SAT_Information_query_pop_up_window_texts_Line_1,

0x0101,	// Multiline_SAT_Information_query_pop_up_window_texts_Line_1

(TUint)&Analogue_clock_pop_up_window_elements_Line_1,

(TUint)&Analogue_clock_pop_up_window_elements_Line_2,

(TUint)&Analogue_clock_pop_up_window_elements_Line_3,

(TUint)&Analogue_clock_pop_up_window_elements_Line_4,

(TUint)&Analogue_clock_pop_up_window_elements_Line_5,

0x0001,

(TUint16)AppLayout::EApiId_Analogue_clock_pop_up_window_elements_Line_1,

0x0204,

(TUint16)AppLayout::EApiId_Analogue_clock_pop_up_window_elements_Line_1,

(TUint)&Analogue_clock_pop_up_window_texts_Line_1,

(TUint)&Digital_clock_pop_up_window_elements_Line_1,

(TUint)&Digital_clock_pop_up_window_elements_Line_2,

(TUint)&Digital_clock_pop_up_window_elements_Line_3,

0x0002,

(TUint16)AppLayout::EApiId_Digital_clock_pop_up_window_elements_Line_1,

(TUint)&Digital_clock_pop_up_window_texts_Line_1,

(TUint)&Digital_clock_pop_up_window_texts_Line_2,

0x0001,

(TUint16)AppLayout::EApiId_Digital_clock_pop_up_window_texts_Line_1,

(TUint)&Thumbnail_pop_up_window_elements_Line_1,

(TUint)&Thumbnail_pop_up_window_elements_Line_2,

(TUint)&Thumbnail_pop_up_window_elements_Line_3,

(TUint)&Thumbnail_pop_up_window_elements_Line_4,

(TUint)&Thumbnail_pop_up_window_elements_Line_5,

(TUint)&Thumbnail_pop_up_window_elements_Line_6,

(TUint)&Thumbnail_pop_up_window_elements_Line_7,

(TUint)&Thumbnail_pop_up_window_elements_Line_8,

(TUint)&Thumbnail_pop_up_window_elements_Line_9,

(TUint)&Thumbnail_pop_up_window_elements_Line_10,

(TUint)&Thumbnail_pop_up_window_elements_Line_11,

(TUint)&Thumbnail_pop_up_window_elements_Line_12,

(TUint)&Thumbnail_pop_up_window_elements_Line_13,

(TUint)&Thumbnail_pop_up_window_elements_Line_14,

(TUint)&Thumbnail_pop_up_window_elements_Line_15,

(TUint)&Thumbnail_pop_up_window_elements_Line_16,

(TUint)&Thumbnail_pop_up_window_elements_Line_17,

(TUint)&Thumbnail_pop_up_window_elements_Line_18,

0x0011,

(TUint16)AppLayout::EApiId_Thumbnail_pop_up_window_elements_Line_1,

(TUint)&Call_status_pop_up_window_elements_Line_1,

(TUint)&Call_status_pop_up_window_elements_Line_2,

(TUint)&Call_status_pop_up_window_elements_Line_3,

(TUint)&Call_status_pop_up_window_elements_Line_4,

0x0003,

(TUint16)AppLayout::EApiId_Call_status_pop_up_window_elements_Line_1,

(TUint)&Incoming_call_pop_up_window_elements_Line_1,

(TUint)&Incoming_call_pop_up_window_elements_Line_2,

(TUint)&Incoming_call_pop_up_window_elements_Line_3,

(TUint)&Incoming_call_pop_up_window_elements_Line_4,

(TUint)&Incoming_call_pop_up_window_elements_Line_5,

(TUint)&Incoming_call_pop_up_window_elements_Line_6,

(TUint)&Incoming_call_pop_up_window_elements_Line_7,

(TUint)&Incoming_call_pop_up_window_elements_Line_8,

(TUint)&Incoming_call_pop_up_window_elements_Line_9,

(TUint)&Incoming_call_pop_up_window_elements_Line_10,

(TUint)&Incoming_call_pop_up_window_elements_Line_11,

(TUint)&Incoming_call_pop_up_window_elements_Line_12,

(TUint)&Incoming_call_pop_up_window_elements_Line_13,

(TUint)&Incoming_call_pop_up_window_elements_Line_14,

(TUint)&Incoming_call_pop_up_window_elements_Line_15,

0x000c,

(TUint16)AppLayout::EApiId_Incoming_call_pop_up_window_elements_Line_1,

(TUint)&Incoming_call_pop_up_window_texts_Line_1,

0x0402,	// Multiline_Incoming_call_pop_up_window_texts_Line_1

(TUint)&Incoming_call_pop_up_window_texts_Line_2,

0x0402,	// Multiline_Incoming_call_pop_up_window_texts_Line_2

0x0001,

(TUint16)AppLayout::EApiId_Incoming_call_pop_up_window_texts_Line_1,

(TUint)&Incoming_call_pop_up_window_graphics_Line_1,

(TUint)&Incoming_call_pop_up_window_graphics_Line_2,

(TUint)&Incoming_call_pop_up_window_graphics_Line_3,

(TUint)&Incoming_call_pop_up_window_graphics_Line_4,

(TUint)&Incoming_call_pop_up_window_graphics_Line_5,

0x0004,

(TUint16)AppLayout::EApiId_Incoming_call_pop_up_window_graphics_Line_1,

(TUint)&Incoming_call_pop_up_window_elements__NE__Line_1,

(TUint)&Incoming_call_pop_up_window_elements__NE__Line_2,

(TUint)&Incoming_call_pop_up_window_elements__NE__Line_3,

(TUint)&Incoming_call_pop_up_window_elements__NE__Line_4,

(TUint)&Incoming_call_pop_up_window_elements__NE__Line_5,

(TUint)&Incoming_call_pop_up_window_elements__NE__Line_6,

(TUint)&Incoming_call_pop_up_window_elements__NE__Line_7,

(TUint)&Incoming_call_pop_up_window_elements__NE__Line_8,

(TUint)&Incoming_call_pop_up_window_elements__NE__Line_9,

(TUint)&Incoming_call_pop_up_window_elements__NE__Line_10,

(TUint)&Incoming_call_pop_up_window_elements__NE__Line_11,

(TUint)&Incoming_call_pop_up_window_elements__NE__Line_12,

(TUint)&Incoming_call_pop_up_window_elements__NE__Line_13,

(TUint)&Incoming_call_pop_up_window_elements__NE__Line_14,

(TUint)&Incoming_call_pop_up_window_elements__NE__Line_15,

0x000e,

(TUint16)AppLayout::EApiId_Incoming_call_pop_up_window_elements__NE__Line_1,

(TUint)&Incoming_call_pop_up_window_texts__NE__Line_1,

0x0402,	// Multiline_Incoming_call_pop_up_window_texts__NE__Line_1

(TUint)&Incoming_call_pop_up_window_texts__NE__Line_2,

0x0402,	// Multiline_Incoming_call_pop_up_window_texts__NE__Line_2

0x0001,

(TUint16)AppLayout::EApiId_Incoming_call_pop_up_window_texts__NE__Line_1,

(TUint)&Incoming_call_pop_up_window_graphics__NE__Line_1,

(TUint)&Incoming_call_pop_up_window_graphics__NE__Line_2,

(TUint)&Incoming_call_pop_up_window_graphics__NE__Line_3,

(TUint)&Incoming_call_pop_up_window_graphics__NE__Line_4,

(TUint)&Incoming_call_pop_up_window_graphics__NE__Line_5,

0x0004,

(TUint16)AppLayout::EApiId_Incoming_call_pop_up_window_graphics__NE__Line_1,

(TUint)&Outgoing_call_pop_up_window_elements__held__Line_1,

(TUint)&Outgoing_call_pop_up_window_elements__held__Line_2,

(TUint)&Outgoing_call_pop_up_window_elements__held__Line_3,

(TUint)&Outgoing_call_pop_up_window_elements__held__Line_4,

(TUint)&Outgoing_call_pop_up_window_elements__held__Line_5,

(TUint)&Outgoing_call_pop_up_window_elements__held__Line_6,

(TUint)&Outgoing_call_pop_up_window_elements__held__Line_7,

(TUint)&Outgoing_call_pop_up_window_elements__held__Line_8,

(TUint)&Outgoing_call_pop_up_window_elements__held__Line_9,

(TUint)&Outgoing_call_pop_up_window_elements__held__Line_10,

(TUint)&Outgoing_call_pop_up_window_elements__held__Line_11,

(TUint)&Outgoing_call_pop_up_window_elements__held__Line_12,

(TUint)&Outgoing_call_pop_up_window_elements__held__Line_13,

(TUint)&Outgoing_call_pop_up_window_elements__held__Line_14,

(TUint)&Outgoing_call_pop_up_window_elements__held__Line_15,

0x000e,

(TUint16)AppLayout::EApiId_Outgoing_call_pop_up_window_elements__held__Line_1,

(TUint)&Outgoing_call_pop_up_window_texts__held__Line_1,

0x0402,	// Multiline_Outgoing_call_pop_up_window_texts__held__Line_1

(TUint)&Outgoing_call_pop_up_window_graphics__held__Line_1,

(TUint)&Outgoing_call_pop_up_window_elements__held_NE__Line_1,

(TUint)&Outgoing_call_pop_up_window_elements__held_NE__Line_2,

(TUint)&Outgoing_call_pop_up_window_elements__held_NE__Line_3,

0x0002,

(TUint16)AppLayout::EApiId_Outgoing_call_pop_up_window_elements__held_NE__Line_1,

(TUint)&Outgoing_call_pop_up_window_texts__held_NE__Line_1,

(TUint)&Outgoing_call_pop_up_window_graphics__held_NE__Line_1,

(TUint)&First_call_pop_up_window_elements__one_call__Line_1,

(TUint)&First_call_pop_up_window_elements__one_call__Line_2,

(TUint)&First_call_pop_up_window_elements__one_call__Line_3,

0x0002,

(TUint16)AppLayout::EApiId_First_call_pop_up_window_elements__one_call__Line_1,

(TUint)&First_call_pop_up_window_texts__one_call__Line_1,

0x0402,	// Multiline_First_call_pop_up_window_texts__one_call__Line_1

(TUint)&First_call_pop_up_window_texts__one_call__Line_2,

(TUint)&First_call_pop_up_window_graphics__one_call__Line_1,

(TUint)&First_call_pop_up_window_elements__two_calls__Line_1,

(TUint)&First_call_pop_up_window_elements__two_calls__Line_2,

(TUint)&First_call_pop_up_window_elements__two_calls__Line_3,

(TUint)&First_call_pop_up_window_elements__two_calls__Line_4,

(TUint)&First_call_pop_up_window_elements__two_calls__Line_5,

(TUint)&First_call_pop_up_window_elements__two_calls__Line_6,

(TUint)&First_call_pop_up_window_elements__two_calls__Line_7,

(TUint)&First_call_pop_up_window_elements__two_calls__Line_8,

(TUint)&First_call_pop_up_window_elements__two_calls__Line_9,

(TUint)&First_call_pop_up_window_elements__two_calls__Line_10,

(TUint)&First_call_pop_up_window_elements__two_calls__Line_11,

(TUint)&First_call_pop_up_window_elements__two_calls__Line_12,

(TUint)&First_call_pop_up_window_elements__two_calls__Line_13,

(TUint)&First_call_pop_up_window_elements__two_calls__Line_14,

(TUint)&First_call_pop_up_window_elements__two_calls__Line_15,

0x000e,

(TUint16)AppLayout::EApiId_First_call_pop_up_window_elements__two_calls__Line_1,

(TUint)&First_call_pop_up_window_texts__two_calls__Line_1,

0x0402,	// Multiline_First_call_pop_up_window_texts__two_calls__Line_1

(TUint)&First_call_pop_up_window_texts__two_calls__Line_2,

(TUint)&First_call_pop_up_window_graphics__two_calls__Line_1,

(TUint)&First_call_pop_up_window_elements__two_calls_a_waiting_call__Line_1,

(TUint)&First_call_pop_up_window_elements__two_calls_a_waiting_call__Line_2,

(TUint)&First_call_pop_up_window_elements__two_calls_a_waiting_call__Line_3,

0x0002,

(TUint16)AppLayout::EApiId_First_call_pop_up_window_elements__two_calls_a_waiting_call__Line_1,

(TUint)&First_call_pop_up_window_texts__two_calls_a_waiting_call__Line_1,

(TUint)&First_call_pop_up_window_graphics__two_calls_a_waiting_call__Line_1,

(TUint)&First_call_pop_up_window_graphics__two_wait_NE__Line_1,

(TUint)&Waiting_call_pop_up_window_elements__held_out_NE__Line_1,

(TUint)&Waiting_call_pop_up_window_elements__held_out_NE__Line_2,

(TUint)&Waiting_call_pop_up_window_elements__held_out_NE__Line_3,

0x0002,

(TUint16)AppLayout::EApiId_Waiting_call_pop_up_window_elements__held_out_NE__Line_1,

(TUint)&Waiting_call_pop_up_window_texts__held_out_NE__Line_1,

(TUint)&Waiting_call_pop_up_window_graphics__held_out_NE__Line_1,

(TUint)&Waiting_call_pop_up_window_graphics__out__Line_1,

(TUint)&Second_call_pop_up_window_elements__two__Line_1,

(TUint)&Second_call_pop_up_window_elements__two__Line_2,

(TUint)&Second_call_pop_up_window_elements__two__Line_3,

0x0002,

(TUint16)AppLayout::EApiId_Second_call_pop_up_window_elements__two__Line_1,

(TUint)&Second_call_pop_up_window_texts__two_calls__Line_1,

0x0402,	// Multiline_Second_call_pop_up_window_texts__two_calls__Line_1

(TUint)&Second_call_pop_up_window_texts__two_calls__Line_2,

(TUint)&Second_call_pop_up_window_graphics__two_calls__Line_1,

(TUint)&Second_call_pop_up_window_elements__two_calls_waiting_call__Line_1,

(TUint)&Second_call_pop_up_window_elements__two_calls_waiting_call__Line_2,

(TUint)&Second_call_pop_up_window_elements__two_calls_waiting_call__Line_3,

0x0002,

(TUint16)AppLayout::EApiId_Second_call_pop_up_window_elements__two_calls_waiting_call__Line_1,

(TUint)&Second_call_pop_up_window_texts__two_calls_waiting_call__Line_1,

(TUint)&Second_call_pop_up_window_graphics__two_calls_waiting_call__Line_1,

(TUint)&Conference_call_pop_up_window_descendants_and_elements_Line_1,

(TUint)&list_conf_pane,

(TUint)&Conference_call_pop_up_window_texts_Line_1,

0x0000,	// Multiline_Conference_call_pop_up_window_texts_Line_1

(TUint)&Muted_state_elements_Line_1,

(TUint)&Calendar_events_list_popup_components_Line_1,

(TUint)&Calendar_events_list_popup_texts_Line_1,

0x0000,	// Multiline_Calendar_events_list_popup_texts_Line_1

(TUint)&Calendar_events_list_popup_graphics_Line_1,

(TUint)&Calendar_events_list_popup_graphics_Line_2,

(TUint)&Calendar_events_list_popup_graphics_Line_3,

(TUint)&Calendar_events_list_popup_graphics_Line_4,

0x0003,

(TUint16)AppLayout::EApiId_Calendar_events_list_popup_graphics_Line_1,

(TUint)&cell_cams_pane,

(TUint)&image_or_qgn_prop_dyc__ref_,

(TUint)&loc_type_pane,

(TUint)&loc_req_pane,

(TUint)&Additional_heading_pane_elements_Line_1,

(TUint)&Additional_heading_pane_elements_Line_2,

(TUint)&Additional_heading_pane_elements_Line_3,

(TUint)&Presence_status_popup_window_texts_Line_1,

(TUint)&Presence_status_popup_window_texts_Line_2,

0x0000,	// Multiline_Presence_status_popup_window_texts_Line_2

(TUint)&Presence_status_window_graphics_Line_1,

(TUint)&Presence_status_window_graphics_Line_2,

(TUint)&Presence_status_window_graphics_Line_3,

(TUint)&Presence_status_window_graphics_Line_4,

(TUint)&Presence_status_window_graphics_Line_5,

0x0004,

(TUint16)AppLayout::EApiId_Presence_status_window_graphics_Line_1,

(TUint)&popup_number_entry_window,

(TUint)&popup_pb_memory_status_window,

(TUint)&popup_grid_large_graphic_window,

(TUint)&popup_call_audio_in_window,

(TUint)&popup_call_audio_out_window,

(TUint)&popup_call_audio_first_window,

(TUint)&popup_call_audio_wait_window,

(TUint)&popup_call_audio_second_window,

(TUint)&popup_call_audio_conf_window,

(TUint)&popup_call_video_in_window,

(TUint)&popup_call_video_first_window,

(TUint)&popup_call_video_down_window,

(TUint)&popup_query_wml_wim_window,

(TUint)&popup_query_wml_sign_window,

(TUint)&popup_query_sat_info_window,

(TUint)&popup_grid_large_compo_graphic_window,

(TUint)&popup_dyc_status_message_window,

(TUint)&VGA,

(TUint)&VGA_turned_90,

(TUint)&CIF,

(TUint)&CIF_turned_90,

(TUint)&Communicator_personal_image,

(TUint)&Image_aspect_ratio___0_625,

(TUint)&Image_aspect_ratio___1_467,

(TUint)&_0_625___image_aspect_ratio___1_467,

0x0007,

(TUint16)AppLayout::EApiId_VGA,

(TUint)&Message_writing_layout_elements_Line_1,

(TUint)&Message_writing_layout_elements_Line_2,

(TUint)&Message_writing_layout_elements_Line_3,

(TUint)&Message_writing_layout_elements_Line_4,

(TUint)&Message_writing_layout_elements_Line_5,

(TUint)&Message_writing_layout_elements_Line_6,

(TUint)&Message_writing_layout_elements_Line_7,

(TUint)&Message_writing_layout_elements_Line_8,

(TUint)&CamcorderBurst_Mode_Post_Recording_cell_elements_Line_1,

(TUint)&CamcorderBurst_Mode_Post_Recording_cell_elements_Line_2,

0x0001,

(TUint16)AppLayout::EApiId_CamcorderBurst_Mode_Post_Recording_cell_elements_Line_1,

(TUint)&Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_6,

(TUint)&Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_7,

(TUint)&near_QCIF,

(TUint)&Media_Player_navi_pane_texts_Line_1,

(TUint)&Volume_strength_area_values_Line_1,

(TUint)&Volume_strength_area_values_Line_2,

(TUint)&Volume_strength_area_values_Line_3,

(TUint)&Volume_strength_area_values_Line_4,

(TUint)&Volume_strength_area_values_Line_5,

(TUint)&Volume_strength_area_values_Line_6,

(TUint)&Volume_strength_area_values_Line_7,

(TUint)&Volume_strength_area_values_Line_8,

(TUint)&blid_compass_pane,

(TUint)&BLID_compass_view_elements_Line_2,

(TUint)&BLID_compass_view_elements_Line_3,

0x0002,

(TUint16)AppLayout::EApiId_blid_compass_pane,

(TUint)&Accuracyvalues_Line_1,

(TUint)&Accuracyvalues_Line_2,

(TUint)&Accuracyvalues_Line_3,

(TUint)&Accuracyvalues_Line_4,

(TUint)&Accuracyvalues_Line_5,

(TUint)&Accuracyvalues_Line_6,

(TUint)&Accuracyvalues_Line_7,

(TUint)&Accuracyvalues_Line_8,

0x0007,

(TUint16)AppLayout::EApiId_Accuracyvalues_Line_1,

(TUint)&BLIDcompass_view_texts_Line_1,

(TUint)&BLIDcompass_view_texts_Line_2,

(TUint)&BLIDcompass_view_texts_Line_3,

0x0002,

(TUint16)AppLayout::EApiId_BLIDcompass_view_texts_Line_1,

(TUint)&Compasspane_elements_Line_1,

(TUint)&Arrow_head__graphic,

(TUint)&Arrow_body__graphic,

0x0002,

(TUint16)AppLayout::EApiId_Compasspane_elements_Line_1,

(TUint)&blid_direction_pane,

(TUint)&BLIDdirection_elements_Line_1,

(TUint)&Outgoingincoming_video_call_elements_Line_1,

(TUint)&Outgoingincoming_video_call_elements_Line_2,

0x0001,

(TUint16)AppLayout::EApiId_Outgoingincoming_video_call_elements_Line_1,

(TUint)&Uplink_video_image__large__Line_1,

(TUint)&Uplink_video_image__large__Line_2,

(TUint)&Uplink_video_image__large__Line_3,

0x0002,

(TUint16)AppLayout::EApiId_Uplink_video_image__large__Line_1,

(TUint)&Downlink_video_image_Line_1,

(TUint)&downlink_stream,

(TUint)&Downlink_video_image_Line_3,

0x0002,

(TUint16)AppLayout::EApiId_Downlink_video_image_Line_1,

(TUint)&title_pane,

(TUint)&uni_indicator_pane,

0x0001,

(TUint16)AppLayout::EApiId_title_pane,

(TUint)&Title_pane_texts_Line_2,

0x0000,	// Multiline_Title_pane_texts_Line_2

(TUint)&Navipane_elements_and_descendant_panes_Line_1,

(TUint)&zooming_pane,

0x0001,

(TUint16)AppLayout::EApiId_Navipane_elements_and_descendant_panes_Line_1,

(TUint)&Zooming_pane_elements_Line_1,

(TUint)&Zooming_pane_elements_Line_2,

(TUint)&Zooming_pane_elements_Line_3,

(TUint)&Zooming_pane_elements_Line_4,

0x0003,

(TUint16)AppLayout::EApiId_Zooming_pane_elements_Line_1,

(TUint)&Navipanetexts_Line_1,

(TUint)&Navipanetexts_Line_2,

0x0001,

(TUint16)AppLayout::EApiId_Navipanetexts_Line_1,

(TUint)&Videocall_indicator__NEwaiting_call__Line_1,

(TUint)&Videocall_indicator__NEwaiting_call__Line_2,

0x0001,

(TUint16)AppLayout::EApiId_Videocall_indicator__NEwaiting_call__Line_1,

(TUint)&Callstatus_pop_up_window_elements_Line_1,

(TUint)&Callstatus_pop_up_window_elements_Line_2,

0x0001,

(TUint16)AppLayout::EApiId_Callstatus_pop_up_window_elements_Line_1,

(TUint)&Rectangle,

(TUint)&Colorpalette_preview_screen_element_placing__main_area__Line_2,

(TUint)&Colorpalette_preview_screen_element_placing__main_area__Line_3,

(TUint)&Colorpalette_preview_screen_element_placing__main_area__Line_4,

(TUint)&Colorpalette_preview_screen_element_placing__main_area__Line_5,

(TUint)&Colorpalette_preview_screen_element_placing__main_area__Line_6,

(TUint)&Colorpalette_preview_screen_element_placing__main_area__Line_7,

(TUint)&Colorpalette_preview_screen_element_placing__main_area__Line_8,

(TUint)&Colorpalette_preview_screen_element_placing__main_area__Line_9,

(TUint)&Colorpalette_preview_screen_element_placing__main_area__Line_10,

(TUint)&Colorpalette_preview_screen_element_placing__main_area__Line_11,

(TUint)&Colorpalette_preview_screen_element_placing__main_area__Line_12,

(TUint)&Colorpalette_preview_screen_element_placing__main_area__Line_13,

(TUint)&Colorpalette_preview_screen_element_placing__main_area__Line_14,

(TUint)&Colorpalette_preview_screen_element_placing__main_area__Line_15,

(TUint)&Colorpalette_preview_screen_element_placing__main_area__Line_16,

(TUint)&Colorpalette_preview_screen_element_placing__main_area__Line_17,

(TUint)&Colorpalette_preview_screen_element_placing__main_area__Line_18,

0x0011,

(TUint16)AppLayout::EApiId_Rectangle,

(TUint)&Colorpalette_preview_screen_text_placing__main_area__Line_1,

(TUint)&Colorpalette_preview_screen_text_placing__main_area__Line_2,

0x0001,

(TUint16)AppLayout::EApiId_Colorpalette_preview_screen_text_placing__main_area__Line_1,

(TUint)&audioskin_pane,

(TUint)&Audio_Playbackview_texts_Line_1,

(TUint)&Audio_Playbackview_texts_Line_2,

(TUint)&Audio_Playbackview_texts_Line_3,

(TUint)&Audio_Playbackview_texts_Line_4,

0x0003,

(TUint16)AppLayout::EApiId_Audio_Playbackview_texts_Line_1,

(TUint)&Audioskin_pane_elements_Line_1,

(TUint)&popup_loc_request_window,

(TUint)&list_single_graphic_popup_wml_pane,

0x0001,

(TUint16)AppLayout::EApiId_list_single_graphic_popup_conf_pane,

(TUint)&list_wml_pane,

(TUint)&Browser_address_field_pop_up_window_graphics_Line_1,

(TUint)&Browser_address_field_pop_up_window_graphics_Line_2,

(TUint)&Browser_address_field_pop_up_window_graphics_Line_3,

(TUint)&Browser_address_field_pop_up_window_graphics_Line_4,

0x0003,

(TUint16)AppLayout::EApiId_Browser_address_field_pop_up_window_graphics_Line_1,

(TUint)&First_call_pop_up_window_texts__one_call__Line_3,

(TUint)&First_call_pop_up_window_graphics__one_call__Line_2,

0x0001,

(TUint16)AppLayout::EApiId_First_call_pop_up_window_graphics__one_call__Line_1,

(TUint)&First_call_pop_up_window_texts__two_calls__Line_3,

(TUint)&First_call_pop_up_window_graphics__two_calls__Line_2,

0x0001,

(TUint16)AppLayout::EApiId_First_call_pop_up_window_graphics__two_calls__Line_1,

(TUint)&Call_type_pane_split_Line_1,

(TUint)&Call_type_pane_split_Line_2,

(TUint)&popup_wml_address_window,

(TUint)&List_pane_elements__browser_single_graphic__Line_1,

(TUint)&List_pane_elements__browser_single_graphic__Line_2,

(TUint)&List_pane_texts__browser_single_graphic__Line_1,

(TUint)&Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_8,

(TUint)&Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_9,

(TUint)&Camcorder_Video_Viewfinder_descendants_and_elements_Line_7,

(TUint)&Camcorder_Video_Viewfinder_descendants_and_elements_Line_8,

(TUint)&Camcorder_Video_Recording_descendants_and_elements_Line_7,

(TUint)&Camcorder_Video_Recording_descendants_and_elements_Line_8,

(TUint)&Camcorder_Video_Recording_descendants_and_elements_Line_9,

(TUint)&Camcorder_viewfinder_texts_Line_1,

(TUint)&Camcorder_Still_Image_Burst_Mode_Post_recording_elements_Line_1,

(TUint)&Camcorder_Still_Image_Burst_Mode_Post_recording_elements_Line_2,

(TUint)&grid_cams_pane,

(TUint)&Camcorder_Burst_Mode_texts_Line_1,

(TUint)&Camcorder_Brightness_Contrast_descendants_and_elements_Line_1,

(TUint)&navi_slider_pane,

0x0001,

(TUint16)AppLayout::EApiId_Camcorder_Brightness_Contrast_descendants_and_elements_Line_1,

(TUint)&Navi_Slider_pane_elements_Line_1,

(TUint)&Navi_Slider_pane_elements_Line_2,

0x0001,

(TUint16)AppLayout::EApiId_Navi_Slider_pane_elements_Line_1,

(TUint)&Camcorder_Manual_Exposure_descendants_and_elements_Line_1,

(TUint)&Zooming_steps_sizes_Line_1,

(TUint)&Zooming_steps_sizes_Line_2,

(TUint)&Zooming_steps_sizes_Line_3,

(TUint)&Zooming_steps_sizes_Line_4,

(TUint)&Zooming_steps_sizes_Line_5,

(TUint)&Zooming_steps_sizes_Line_6,

(TUint)&Zooming_steps_sizes_Line_7,

(TUint)&Zooming_steps_sizes_Line_8,

(TUint)&Zooming_steps_sizes_Line_9,

(TUint)&Zooming_steps_sizes_Line_10,

(TUint)&Zooming_steps_sizes_Line_11,

(TUint)&Uplink_video_image__small__Line_1,

(TUint)&Uplink_video_image__small__Line_2,

(TUint)&Uplink_video_image__small__Line_3,

0x0002,

(TUint16)AppLayout::EApiId_Uplink_video_image__small__Line_1,

(TUint)&Downlink_video_image_Line_4,

(TUint)&downlink_stream_area,

(TUint)&MIDP_text_elements_Line_1,

(TUint)&MIDP_text_elements_Line_2,

(TUint)&MIDP_texts_Line_1,

0x0000,	// Multiline_MIDP_texts_Line_1

(TUint)&Camcorder_Zooming_factor_pane_elements_v2_Line_1,

(TUint)&Camcorder_Zooming_factor_pane_elements_v2_Line_2,

(TUint)&Camcorder_Zooming_factor_pane_elements_v2_Line_3,

(TUint)&Camcorder_Zooming_factor_pane_elements_v2_Line_4,

0x0003,

(TUint16)AppLayout::EApiId_Camcorder_Zooming_factor_pane_elements_v2_Line_1,

(TUint)&cell_radio_pane,

(TUint)&FM_Radio_cell_elements_Line_1,

(TUint)&grid_radio_pane,

(TUint)&FM_Radio_elements_Line_2,

(TUint)&FM_Radio_elements_Line_3,

(TUint)&FM_Radio_elements_Line_4,

(TUint)&FM_Radio_elements_Line_5,

0x0004,

(TUint16)AppLayout::EApiId_grid_radio_pane,

(TUint)&FM_Radio_texts_Line_1,

(TUint)&FM_Radio_texts_Line_2,

(TUint)&FM_Radio_texts_Line_3,

(TUint)&FM_Radio_texts_Line_4,

(TUint)&FM_Radio_texts_Line_5,

0x0004,

(TUint16)AppLayout::EApiId_FM_Radio_texts_Line_1,

(TUint)&aid_cams_cif_uncrop_pane,

(TUint)&video_down_subqcif_pane,

};



/*
* Use these macro to turn on or off all the APIs marked with the macro
*/
//#define NOT_IMPL(api) NULL
#define NOT_IMPL(api) &api

//#define NO_DATA(api) NULL
#define NO_DATA(api) &api

//#define NOT_SUPP(api) NULL
#define NOT_SUPP(api) &api

//#define NOT_USED(api) NULL
#define NOT_USED(api) &api

//#define IMPL_OK(api) NULL
#define IMPL_OK(api) &api

//#define MGR_TODO(api) NULL
#define MGR_TODO(api) &api

//#define RSD_TODO(api) NULL
#define RSD_TODO(api) &api

//#define MAN_OK(api) NULL
#define MAN_OK(api) &api

//#define MAN_TODO(api) NULL
#define MAN_TODO(api) &api

//#define MAN_OK_BUT_DO_NOT_WORK(api) NULL
#define MAN_OK_BUT_DO_NOT_WORK(api) &api


//
// Implementation
// - if there is NULL in this table, then the implementation in other CDL instance will be used (the ones generated from LAY files)
//
const AppLayout::SCdlImpl KCdlImpl = 
	{
	NOT_SUPP(Browser_image_highlight_Line_1), //	&WindowLine0f,
	NOT_USED(Browser_image_highlight_Line_2), //	&WindowLine0f,
	NOT_USED(Browser_image_highlight_Line_3), //	&WindowLine0f,
	NOT_USED(Browser_image_highlight_Line_4), //	&WindowLine0f,
	NOT_USED(Browser_image_highlight_Line_5), //	&WindowLine0f,
	NOT_USED(Browser_image_highlight_Line_6), //	&WindowLine0f,
	NOT_USED(Browser_image_highlight_Line_7), //	&WindowLine0f,
	NOT_USED(Browser_image_highlight_Line_8), //	&WindowLine0f,
	NOT_USED(Browser_image_highlight_Line_9), //	&WindowLine0f,
	NOT_USED(Limits), // &Browser_image_highlight_Limits, //	&Limits,
	NOT_USED(WindowTable0f), // &Browser_image_highlight, //	&WindowTable0f,
	NOT_USED(Navi_pane_elements_Line_1), //	&WindowLine0f,
	MAN_OK(list_cale_time_pane), // &list_cale_time_pane, //	&WindowLine2f,
	MAN_OK(list_pinb_item_pane), // &list_pinb_item_pane, //	&WindowLine1f,
	MAN_OK(List_pane_elements__cale_time__Line_1), // &List_pane_elements__cale_time__Line_1, //	&WindowLine1f,
	MAN_OK(List_pane_elements__cale_time__Line_2), // &List_pane_elements__cale_time__Line_2, //	&WindowLine0f,
	MAN_OK(List_pane_elements__cale_time__Line_3), // &List_pane_elements__cale_time__Line_3, //	&WindowLine2f,
	MAN_OK(List_pane_texts__cale_time__Line_1), // &List_pane_texts__cale_time__Line_1, //	&TextLine2f,
   	MAN_OK(MultiLineTextLine2f), // &Multiline_List_pane_texts__cale_time__Line_1, //	&MultiLineTextLine2f,
	MAN_OK(List_pane_texts__cale_time__Line_2), // &List_pane_texts__cale_time__Line_2, //	&TextLine1f,
	MAN_OK(List_pane_texts__cale_time__Line_3), // &List_pane_texts__cale_time__Line_3, //	&TextLine4f,
    MAN_OK(MultiLineTextLine4f), // &Multiline_List_pane_texts__cale_time__Line_3, 
   	NOT_SUPP(List_pane_elements__pinb_item__Line_1), //	&WindowLine0f,
	MAN_OK(List_pane_elements__pinb_item__Line_2), // &List_pane_elements__pinb_item__Line_2, //	&WindowLine0f,
	MAN_OK(List_pane_elements__pinb_item__Line_3), // &List_pane_elements__pinb_item__Line_3, //	&WindowLine0f,
	MAN_OK(List_pane_elements__pinb_item__Line_4), // &List_pane_elements__pinb_item__Line_4, //	&WindowLine1f,
   	MAN_OK(Limits), // &List_pane_elements__pinb_item__SUB_TABLE_0_Limits, 
   	MAN_OK(WindowTable0f),// &List_pane_elements__pinb_item__SUB_TABLE_0, //	&WindowTable0f,
	MAN_OK(List_pane_texts__pinb_item__Line_1), // &List_pane_texts__pinb_item__Line_1, //	&TextLine1f,
	NOT_SUPP(List_pane_highlight__several__Line_1), //	&WindowLine0t,
	NOT_SUPP(List_pane_highlight__several__Line_2), //	&WindowLine0t,
    NOT_SUPP(Limits), // &List_pane_highlight__several__Limits, //	
    NOT_SUPP(WindowTable0t), // &List_pane_highlight__several_, //	
	MAN_OK(cell_pinb_pane), // &cell_pinb_pane, //	&WindowLine2f,
    MAN_OK(cell_qdial_pane), // &cell_qdial_pane, //	&WindowLine2f,
	MAN_OK(cell_cale_month_pane), // &cell_cale_month_pane, //	&WindowLine3f,
    MAN_OK(cell_calc_pane), // &cell_calc_pane, //	&WindowLine2f,
	MAN_OK(cell_cale_week_pane), // &cell_cale_week_pane, //	&WindowLine2f,
	MAN_OK(cell_vorec_pane), //	&WindowLine1f,
	MAN_OK(cell_gms_pane), //	&WindowLine2f,
	MAN_OK(cell_mp_pane), // &cell_mp_pane, //	&WindowLine1f,
    MAN_OK(Limits), // &Grid_pane_descendants_SUB_TABLE_0_Limits, //	
    MAN_OK(WindowTable2f), // &Grid_pane_descendants_SUB_TABLE_0, //	
	MAN_OK(Cell_pane_elements__pinb__Line_1), // &Cell_pane_elements__pinb__Line_1, //	&WindowLine0f,
	MAN_OK(Cell_pane_elements__pinb__Line_2), // &Cell_pane_elements__pinb__Line_2, //	&WindowLine0f,
	MAN_OK(Cell_pane_elements__pinb__Line_3), // &Cell_pane_elements__pinb__Line_3, //	&WindowLine0f,
    MAN_OK(Limits), // &Cell_pane_elements__pinb__Limits, //	
    MAN_OK(WindowTable0f), // &Cell_pane_elements__pinb_, //	
	NOT_SUPP(Cell_pane_elements__qdial__Line_1), //	&WindowLine0f,
    MAN_OK(Cell_pane_elements__qdial__Line_2), // &Cell_pane_elements__qdial__Line_2, //	&WindowLine0f,
	MAN_OK(Cell_pane_elements__qdial__Line_3), // &Cell_pane_elements__qdial__Line_3, //	&WindowLine0f,
	NOT_SUPP(Cell_pane_elements__qdial__Line_4), //	&WindowLine0f,
	MAN_OK(Cell_pane_elements__qdial__Line_5), // &Cell_pane_elements__qdial__Line_5, //	&WindowLine0f,
	MAN_OK(Cell_pane_elements__qdial__Line_6), // &Cell_pane_elements__qdial__Line_6, //	&WindowLine0f,
	NOT_SUPP(Cell_pane_elements__qdial__Line_7), //	&WindowLine0f,
	MAN_OK(Cell_pane_elements__qdial__Line_8), // &Cell_pane_elements__qdial__Line_8, //	&WindowLine0f,
	MAN_OK(Cell_pane_elements__qdial__Line_9), // &Cell_pane_elements__qdial__Line_9, //	&WindowLine0f,
	NOT_SUPP(Cell_pane_elements__qdial__Line_10), //	&WindowLine0f,
	MAN_OK(Cell_pane_elements__qdial__Line_11), // &Cell_pane_elements__qdial__Line_11, //	&WindowLine0f,
	MAN_OK(Cell_pane_elements__qdial__Line_12), // &Cell_pane_elements__qdial__Line_12, //	&WindowLine0f,
	NOT_SUPP(Cell_pane_elements__qdial__Line_13), //	&WindowLine0f,
	MAN_OK(Cell_pane_elements__qdial__Line_14), // &Cell_pane_elements__qdial__Line_14, //	&WindowLine0f,
	MAN_OK(Cell_pane_elements__qdial__Line_15), // &Cell_pane_elements__qdial__Line_15, //	&WindowLine0f,
	NOT_SUPP(Cell_pane_elements__qdial__Line_16), //	&WindowLine0f,
	MAN_OK(Cell_pane_elements__qdial__Line_17), // &Cell_pane_elements__qdial__Line_17, //	&WindowLine0f,
	MAN_OK(Cell_pane_elements__qdial__Line_18), // &Cell_pane_elements__qdial__Line_18, //	&WindowLine0f,
	MAN_OK(Cell_pane_elements__qdial__Line_19), // &Cell_pane_elements__qdial__Line_19, //	&WindowLine0f,
   	MAN_OK(Cell_pane_elements__qdial__Line_20), // &Cell_pane_elements__qdial__Line_20, //	&WindowLine0f,
    MAN_OK(Cell_pane_elements__qdial__Line_21), // &Cell_pane_elements__qdial__Line_21, //	&WindowLine0f,
    MAN_OK(Limits), // &Cell_pane_elements__qdial__Limits, //	
    MAN_OK(WindowTable0f), // &Cell_pane_elements__qdial_, //	
    MAN_OK(Cell_pane_texts__qdial__Line_1), // &Cell_pane_texts__qdial__Line_1, //	&TextLine3f,
    MAN_OK(MultiLineTextLine4f), // &Multiline_Cell_pane_texts__qdial__Line_1, //	
	NOT_SUPP(Cell_pane_elements__cale_month__Line_1), //	&WindowLine2f,
    MAN_OK(Cell_pane_elements__cale_month__Line_2), // &Cell_pane_elements__cale_month__Line_2, //	&WindowLine1f,
	MAN_OK(Cell_pane_texts__cale_month__Line_1), // &Cell_pane_texts__cale_month__Line_1, //	&TextLine2f,
	MAN_OK(Cell_pane_elements__calc__Line_1), // &Cell_pane_elements__calc__Line_1, //	&WindowLine0f,
	NOT_SUPP(Cell_pane_elements__cale_week__Line_1), //	&WindowLine1t,
    MAN_OK(Cell_pane_elements__cale_week__Line_2), // &Cell_pane_elements__cale_week__Line_2, //	&WindowLine1f,
  	MAN_OK(Cell_pane_elements__cale_week__Line_3), // &Cell_pane_elements__cale_week__Line_3, //	&WindowLine1f,
	MAN_OK(Cell_pane_elements__cale_week__Line_4), // &Cell_pane_elements__cale_week__Line_4, //	&WindowLine0f,
    MAN_OK(Limits), // &Cell_pane_elements__cale_week__SUB_TABLE_0_Limits, //	
    MAN_OK(WindowTable1f), // &Cell_pane_elements__cale_week__SUB_TABLE_0, //	
	MAN_OK(Voice_Recorder_cell_elements_Line_1), //	&WindowLine0f,
	MAN_OK(Graphical_message_cell_elements_Line_1), //	&WindowLine0f,
	MAN_OK(Graphical_message_cell_elements_Line_2), //	&WindowLine0f,
    MAN_OK(Limits), // &Graphical_message_cell_elements_Limits, //	
    MAN_OK(WindowTable0f), // &Graphical_message_cell_elements, //	
	MAN_OK(MediaPlayer_cell_elements_Line_1), // &MediaPlayer_cell_elements_Line_1, //	&WindowLine0f,
	NOT_SUPP(Cell_pane_highlight_elements__various__Line_1), //	&WindowLine0t,
	NOT_SUPP(Cell_pane_highlight_elements__qdial__Line_1), //	&WindowLine0t,
	NOT_SUPP(Cell_pane_highlight_elements__qdial__Line_2), //	&WindowLine0f,
	NOT_USED(Browser_texts_Line_1), //	&TextLine2f,
    NOT_USED(MultiLineTextLine2f), // &Multiline_Browser_texts_Line_1, //	
	NOT_USED(Browser_texts_Line_2), //	&TextLine2f,
    NOT_USED(MultiLineTextLine2f), // &Multiline_Browser_texts_Line_2, //	
	NOT_USED(Browser_texts_Line_3), //	&TextLine2f,
    NOT_USED(MultiLineTextLine2f), // &Multiline_Browser_texts_Line_3, //	
    NOT_USED(Limits), // &Browser_texts_Limits, //	
	NOT_USED(TextTable2f), // &Browser_texts, //	
	NOT_USED(Browser_selection_box_elements_Line_1), //	&WindowLine0f,
	NOT_USED(Browser_selection_box_elements_Line_2), //	&WindowLine0f,
	NOT_USED(Browser_selection_box_elements_Line_3), //	&WindowLine0f,
	NOT_USED(Browser_selection_box_elements_Line_4), //	&WindowLine0f,
	NOT_USED(Limits), // &Browser_selection_box_elements_Limits, //	
	NOT_USED(WindowTable0f), // &Browser_selection_box_elements, //	
	NOT_USED(Browser_highlights_Line_1), //	&WindowLine1t,
	NOT_USED(Browser_highlights_Line_2), //	&WindowLine1t,
    NOT_USED(Limits), // &Browser_highlights_Limits, //	
	NOT_USED(WindowTable1t), // &Browser_highlights, //	
	NOT_USED(Browser_text_link_underlining_Line_1), //	&WindowLine1t,
	NOT_USED(Browser_table_frame_graphics_and_highlight_Line_1), //	&WindowLine0f,
	NOT_USED(Browser_table_frame_graphics_and_highlight_Line_2), //	&WindowLine0f,
    NOT_USED(Limits), // Browser_table_frame_graphics_and_highlight_Limits, //	
	NOT_USED(WindowTable0f), // &Browser_table_frame_graphics_and_highlight, //	
	NOT_USED(Browser_image_frame_and_highlight_Line_1), //	&WindowLine1f,
	NOT_USED(Browser_image_frame_and_highlight_Line_2), //	&WindowLine0f,
	NOT_USED(Browser_image_frame_and_highlight_Line_3), //	&WindowLine0f,
    NOT_USED(Limits), // &Browser_image_frame_and_highlight_SUB_TABLE_0_Limits, //	
    NOT_USED(WindowTable0f), // &Browser_image_frame_and_highlight_SUB_TABLE_0, //	
	NOT_USED(Browser_broken_image_Line_1), //	&WindowLine0f,
	NOT_USED(Browser_broken_image_Line_2), //	&WindowLine0f,
	NOT_USED(Browser_broken_image_Line_3), //	&WindowLine0f,
    NOT_USED(Limits), // &Browser_broken_image_Limits, //	
	NOT_USED(WindowTable0f), // &Browser_broken_image, //	
	NOT_USED(Browser_broken_image_text_Line_1), //	&TextLine0f,
	NOT_SUPP(Calendar_Day_view_elements_and_descendants_Line_1), //	&WindowLine0f,
	NOT_SUPP(Calendar_Day_view_elements_and_descendants_Line_2), //	&WindowLine0f,
    MAN_OK(Calendar_Day_view_elements_and_descendants_Line_3), // &Calendar_Day_view_elements_and_descendants_Line_3, //	&WindowLine0f,
    MAN_OK(list_cale_pane), // &list_cale_pane, //	&WindowLine0f,
    MAN_OK(Limits), // &Calendar_Day_view_elements_and_descendants_Limits, //	
    MAN_OK(WindowTable0f), // &Calendar_Day_view_elements_and_descendants, //	
	NOT_SUPP(List_pane_texts__cale_time_empty__Line_1), //	&TextLine1f,
    NOT_SUPP(MultiLineTextLine1f), // &Multiline_List_pane_texts__cale_time_empty__Line_1, //	
	NOT_SUPP(Calendar_Week_view_elements_Line_1), //	&WindowLine0f,
	NOT_SUPP(Calendar_Week_view_elements_Line_2), //	&WindowLine0f,
    MAN_OK(Calendar_Week_view_elements_Line_3), // &Calendar_Week_view_elements_Line_3, //	&WindowLine0f,
    MAN_OK(Calendar_Week_view_elements_Line_4), // &Calendar_Week_view_elements_Line_4, //	&WindowLine0f,
    MAN_OK(Calendar_Week_view_elements_Line_5), // &Calendar_Week_view_elements_Line_5, //	&WindowLine0f,
    MAN_OK(Calendar_Week_view_elements_Line_6), // &Calendar_Week_view_elements_Line_6, //	&WindowLine1f,
    MAN_OK(Calendar_Week_view_elements_Line_7), // &Calendar_Week_view_elements_Line_7, //	&WindowLine1f,
	NOT_SUPP(Calendar_Week_view_elements_Line_8), //	&WindowLine1f,
    MAN_OK(grid_cale_week_pane), // &grid_cale_week_pane, //	&WindowLine0f,
    MAN_OK(Limits), // &Calendar_Week_view_elements_SUB_TABLE_0_Limits, //	
    MAN_OK(WindowTable0f), // &Calendar_Week_view_elements_SUB_TABLE_0, //	
    MAN_OK(Calendar_Week_view_texts_Line_1), // &Calendar_Week_view_texts_Line_1, //	&TextLine1f,
    MAN_OK(Calendar_Week_view_texts_Line_2), // &Calendar_Week_view_texts_Line_2, //	&TextLine1f,
    MAN_OK(MultiLineTextLine1f), // &Multiline_Calendar_Week_view_texts_Line_2, //	
	NOT_USED(Calendar_Month_view_elements_Line_1), //	&WindowLine0f,
	NOT_USED(Calendar_Month_view_elements_Line_2), //	&WindowLine0f,
    MAN_OK(Calendar_Month_view_elements_Line_3), // &4, //	&WindowLine0f,
    MAN_OK(Calendar_Month_view_elements_Line_4), // &Calendar_Month_view_elements_Line_4, //	&WindowLine0f,
    MAN_OK(Calendar_Month_view_elements_Line_5), // &Calendar_Month_view_elements_Line_5, //	&WindowLine0f,
    MAN_OK(Calendar_Month_view_elements_Line_6), // &Calendar_Month_view_elements_Line_6, //	&WindowLine1f,
    MAN_OK(Calendar_Month_view_elements_Line_7), // &Calendar_Month_view_elements_Line_7, //	&WindowLine2f,
    MAN_OK(grid_cale_month_pane), // &grid_cale_month_pane, //	&WindowLine1f,
    MAN_OK(Limits), // &Calendar_Month_view_elements_SUB_TABLE_0_Limits, //	
    MAN_OK(WindowTable0f), // &Calendar_Month_view_elements_SUB_TABLE_0, //	
    MAN_OK(Calendar_Month_view_texts_Line_1), // &Calendar_Month_view_texts_Line_1, //	&TextLine1f,
    MAN_OK(Calendar_Month_view_texts_Line_2), // &Calendar_Month_view_texts_Line_2, //	&TextLine1f,
    MAN_OK(MultiLineTextLine1f), // &Multiline_Calendar_Month_view_texts_Line_2, //	
	MAN_OK(Calculator_elements_Line_1), // &Calculator_elements_Line_1, //	&WindowLine0f,
    MAN_OK(gqn_graf_calc_paper), // &gqn_graf_calc_paper, //	&WindowLine0f,
    MAN_OK(Calculator_elements_Line_3), // &Calculator_elements_Line_3, //	&WindowLine1f,
    MAN_OK(grid_calc_pane), // &grid_calc_pane, //	&WindowLine0f,
    MAN_OK(Limits), // &Calculator_elements_SUB_TABLE_0_Limits, //	
    MAN_OK(WindowTable0f), // &Calculator_elements_SUB_TABLE_0, //	
	NOT_SUPP(Calculator_texts_Line_1), //	&TextLine0f,
    MAN_OK(Calculator_texts_Line_2), // &Calculator_texts_Line_2, //	&TextLine0f,
	NOT_SUPP(Calculator_texts_Line_3), //	&TextLine0f,
    MAN_OK(Calculator_texts_Line_4), // &Calculator_texts_Line_4, //	&TextLine0f,
	NOT_SUPP(Calculator_texts_Line_5), //	&TextLine0f,
	MAN_OK(Calculator_texts_Line_6), // &Calculator_texts_Line_6, //	&TextLine0f,
	MAN_OK(Calculator_texts_Line_7), // &Calculator_texts_Line_7, //	&TextLine1f,
    MAN_OK(MultiLineTextLine1f),// &Multiline_Calculator_texts_Line_7, //	
	MAN_OK(Calculator_texts_Line_8), // &Calculator_texts_Line_8, //	&TextLine1f,
    MAN_OK(MultiLineTextLine1f), // &Multiline_Calculator_texts_Line_8, //	
    MAN_OK(Limits), // &Calculator_texts_SUB_TABLE_0_Limits, //	
    MAN_OK(TextTable0f), // &Calculator_texts_SUB_TABLE_0, //	
    MAN_OK(Limits), // &Calculator_texts_SUB_TABLE_1_Limits, //	
    MAN_OK(TextTable1f), // &Calculator_texts_SUB_TABLE_1, //	
    MAN_OK(popup_clock__ref__window), // &popup_clock__ref__window, //	&WindowLine0f,
	MAN_OK(Real_Time_Alarm_Clock_view_descendants_panes_and_elements_Line_2), // &Real_Time_Alarm_Clock_view_descendants_panes_and_elements_Line_2, //	&WindowLine0f,
	MAN_OK(Real_Time_Alarm_Clock_view_descendants_panes_and_elements_Line_3), // &Real_Time_Alarm_Clock_view_descendants_panes_and_elements_Line_3, //	&WindowLine0f,
	MAN_OK(Real_Time_Alarm_Clock_view_descendants_panes_and_elements_Line_4), // &Real_Time_Alarm_Clock_view_descendants_panes_and_elements_Line_4, //	&WindowLine0f,
    MAN_OK(Real_Time_Alarm_Clock_view_descendants_panes_and_elements_Line_5), // &Real_Time_Alarm_Clock_view_descendants_panes_and_elements_Line_5, //	&WindowLine0f,
	MAN_OK(Limits), // &Real_Time_Alarm_Clock_view_descendants_panes_and_elements_Limits, //	
	MAN_OK(WindowTable0f), // &Real_Time_Alarm_Clock_view_descendants_panes_and_elements, //	
	MAN_OK(Real_Time_Alarm_Clock_view_texts__skins__Line_1), // &Real_Time_Alarm_Clock_view_texts__skins__Line_1, //	&TextLine1f,
	MAN_OK(Real_Time_Alarm_Clock_view_texts__skins__Line_2), // &Real_Time_Alarm_Clock_view_texts__skins__Line_2, //	&TextLine1f,
	MAN_OK(MultiLineTextLine1f), // &Multiline_Real_Time_Alarm_Clock_view_texts__skins__Line_2, //	
	MAN_OK(Real_Time_Alarm_Clock_view_texts__skins__Line_3), // &Real_Time_Alarm_Clock_view_texts__skins__Line_3, //	&TextLine0f,
	MAN_OK(Real_Time_Alarm_Clock_view_texts__skins__Line_4), // &Real_Time_Alarm_Clock_view_texts__skins__Line_4, //	&TextLine1f,
	MAN_OK(MultiLineTextLine1f), // &Multiline_Real_Time_Alarm_Clock_view_texts__skins__Line_4, //	
	MAN_OK(Real_Time_Alarm_Clock_view_texts__skins__Line_5), // &Real_Time_Alarm_Clock_view_texts__skins__Line_5, //	&TextLine0f,
	MAN_OK(Real_Time_Alarm_Clock_view_texts__skins__Line_6), // &Real_Time_Alarm_Clock_view_texts__skins__Line_6, //	&TextLine0f,
    MAN_OK(Limits), // &Real_Time_Alarm_Clock_view_texts__skins__SUB_TABLE_0_Limits, //	
    MAN_OK(TextTable0f), // &Real_Time_Alarm_Clock_view_texts__skins__SUB_TABLE_0, //	
	NOT_SUPP(Clock_find_pane_elements_Line_1), //	&WindowLine0f,
	NOT_SUPP(Clock_find_pane_elements_Line_2), //	&WindowLine0f,
	NOT_SUPP(Clock_find_pane_elements_Line_3), //	&WindowLine0f,
	NOT_SUPP(Clock_find_pane_elements_Line_4), //	&WindowLine0f,
	NOT_SUPP(Clock_find_pane_elements_Line_5), //	&WindowLine0f,
    NOT_SUPP(Limits), // &Clock_find_pane_elements_Limits, //	
    NOT_SUPP(WindowTable0f), // &Clock_find_pane_elements, //	
	NOT_SUPP(Find_pane_texts_Line_1), //	&TextLine0f,
	MAN_OK(Near_QCIF), //	&WindowLine0f,
	MAN_OK(Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_2), //	&WindowLine0f,
	MAN_OK(Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_3), //	&WindowLine0f,
	MAN_OK(Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_4), //	&WindowLine0f,
	MAN_OK(Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_5), //	&WindowLine0f,
    MAN_OK(Limits), // &Camcorder_Still_Image_Viewfinder_descendants_and_elements_Limits, //	
    MAN_OK(WindowTable0f), // &Camcorder_Still_Image_Viewfinder_descendants_and_elements, //	
	MAN_OK(Camcorder_Zooming_factor_pane_elements_Line_1), //	&WindowLine0f,
	MAN_OK(Camcorder_Zooming_factor_pane_elements_Line_2), //	&WindowLine0f,
    MAN_OK(Limits), // &Camcorder_Zooming_factor_pane_elements_Limits, //	
    MAN_OK(WindowTable0f), // &Camcorder_Zooming_factor_pane_elements, //	
	MAN_OK(Camcorder_Still_Image_Viewfinder_texts_Line_1), //	&TextLine0f,
	MAN_OK(Camcorder_Still_Image_Viewfinder_texts_Line_2), //	&TextLine0f,
    MAN_OK(Limits), // &Camcorder_Still_Image_Viewfinder_texts_Limits, //	
    MAN_OK(TextTable0f), // &Camcorder_Still_Image_Viewfinder_texts, //	&TextTable0f,
	MAN_OK(Camcorder_Video_Viewfinder_descendants_and_elements_Line_1), //	&WindowLine0f,
	MAN_OK(Camcorder_Video_Viewfinder_descendants_and_elements_Line_2), //	&WindowLine0f,
	MAN_OK(Camcorder_Video_Viewfinder_descendants_and_elements_Line_3), //	&WindowLine1f,
	MAN_OK(Camcorder_Video_Viewfinder_descendants_and_elements_Line_4), //	&WindowLine1f,
	MAN_OK(Camcorder_Video_Viewfinder_descendants_and_elements_Line_5), //	&WindowLine1f,
	MAN_OK(Camcorder_Video_Viewfinder_descendants_and_elements_Line_6), //	&WindowLine1f,
    MAN_OK(Limits), // &Camcorder_Video_Viewfinder_descendants_and_elements_SUB_TABLE_0_Limits, //	
    MAN_OK(WindowTable0f), // &Camcorder_Video_Viewfinder_descendants_and_elements_SUB_TABLE_0, //	
    MAN_OK(Limits), // &Camcorder_Video_Viewfinder_descendants_and_elements_SUB_TABLE_1_Limits, //	
    MAN_OK(WindowTable1f), // &Camcorder_Video_Viewfinder_descendants_and_elements_SUB_TABLE_1, //	
	MAN_OK(Camcorder_Video_Recording_descendants_and_elements_Line_1), //	&WindowLine0f,
	MAN_OK(Camcorder_Video_Recording_descendants_and_elements_Line_2), //	&WindowLine0f,
	MAN_OK(Camcorder_Video_Recording_descendants_and_elements_Line_3), //	&WindowLine1f,
	MAN_OK(Camcorder_Video_Recording_descendants_and_elements_Line_4), //	&WindowLine1f,
	MAN_OK(Camcorder_Video_Recording_descendants_and_elements_Line_5), //	&WindowLine1f,
	MAN_OK(Camcorder_Video_Recording_descendants_and_elements_Line_6), //	&WindowLine1f,
    MAN_OK(Limits), // &Camcorder_Video_Recording_descendants_and_elements_SUB_TABLE_0_Limits, //	
    MAN_OK(WindowTable0f), // &Camcorder_Video_Recording_descendants_and_elements_SUB_TABLE_0, //	
    MAN_OK(Limits), // &Camcorder_Video_Recording_descendants_and_elements_SUB_TABLE_1_Limits, //	
    MAN_OK(WindowTable1f), // &Camcorder_Video_Recording_descendants_and_elements_SUB_TABLE_1, //	
	MAN_OK(Camcorder_Duration_texts_Line_1), //	&TextLine0f,
	NOT_SUPP(QVGA), //	&WindowLine0f,
	IMPL_OK(Camcorder_Video_Post_recording_elements_Line_2), //	&WindowLine0f,
	IMPL_OK(Camcorder_Video_Post_recording_elements_Line_3), //	&WindowLine0f,
    NOT_SUPP(Limits), // &Camcorder_Video_Post_recording_elements_Limits, //	
	NOT_SUPP(WindowTable0f), // &Camcorder_Video_Post_recording_elements, //	
	MAN_OK(Graphical_message_selection_layout_elements_Line_1), //	&WindowLine1f,
	MAN_OK(Graphical_message_selection_layout_elements_Line_2), //	&WindowLine1f,
	MAN_OK(grid_gms_pane), //	&WindowLine0f,
	MAN_OK(Help_texts_Line_1), // &Help_texts_Line_1, //	&TextLine1f,
    NOT_SUPP(MultiLineTextLine1f), // &Multiline_Help_texts_Line_1, //	
	NOT_SUPP(Phonebook_Photo_view_elements_Line_1), //	&WindowLine0f,
	NOT_SUPP(Phonebook_Photo_view_elements_Line_2), //	&WindowLine0f,
	NOT_SUPP(Phonebook_Photo_view_elements_Line_3), //	&WindowLine0f,
	NOT_SUPP(Phonebook_Photo_view_elements_Line_4), //	&WindowLine0f,
	NOT_SUPP(Phonebook_Photo_view_elements_Line_5), //	&WindowLine0f,
	NOT_SUPP(Phonebook_Photo_view_elements_Line_6), //	&WindowLine0f,
	NOT_SUPP(Phonebook_Photo_view_elements_Line_7), //	&WindowLine0f,
	NOT_SUPP(Phonebook_Photo_view_elements_Line_8), //	&WindowLine0f,
    NOT_SUPP(Limits), // &Phonebook_Photo_view_elements_Limits, //	
    NOT_SUPP(WindowTable0f), // &Phonebook_Photo_view_elements, //	
	MAN_OK(Presence_status_list_components_Line_1), //	&WindowLine0f,
	MAN_OK(Presence_status_list_components_Line_2), //	&WindowLine0f,
	MAN_OK(Presence_status_list_components_Line_3), //	&WindowLine0f,
	MAN_OK(image_or_qgn_prop_dyc_big__ref_), //	&WindowLine0f,
	MAN_OK(Presence_status_list_texts_Line_1), //	&TextLine1f,
    MAN_OK(MultiLineTextLine1f), // &Multiline_Presence_status_list_texts_Line_1, //	
	NOT_SUPP(Pinboard_elements__grid__Line_1), //	&WindowLine0f,
	NOT_SUPP(Pinboard_elements__grid__Line_2), //	&WindowLine0f,
	NOT_SUPP(Pinboard_elements__grid__Line_3), //	&WindowLine0f,
	NOT_SUPP(Pinboard_elements__grid__Line_4), //	&WindowLine1f,
	NOT_SUPP(Pinboard_elements__grid__Line_5), //	&WindowLine0f,
	NOT_SUPP(Pinboard_elements__grid__Line_6), //	&WindowLine1f,
	MAN_OK(Pinboard_elements__grid__Line_7), // &Pinboard_elements__grid__Line_7, //	&WindowLine0f,
	MAN_OK(find_pinb_pane), // &find_pinb_pane, //	&WindowLine0f,
    NOT_SUPP(Limits), // &Pinboard_elements__grid__SUB_TABLE_0_Limits, //	
    NOT_SUPP(WindowTable0f), // &Pinboard_elements__grid__SUB_TABLE_0, //	
    NOT_SUPP(Limits), // &Pinboard_elements__grid__SUB_TABLE_1_Limits, //	
    NOT_SUPP(WindowTable0f), // &Pinboard_elements__grid__SUB_TABLE_1, //	
	NOT_SUPP(Find_pane_elements__pinb__Line_1), //	&WindowLine0f,
	NOT_SUPP(Find_pane_elements__pinb__Line_2), //	&WindowLine0f,
	MAN_OK(Find_pane_elements__pinb__Line_3), // &Find_pane_elements__pinb__Line_3, //	&WindowLine0f,
	MAN_OK(Find_pane_elements__pinb__Line_4), // &Find_pane_elements__pinb__Line_4, //	&WindowLine0f,
    NOT_SUPP(Limits), // &Find_pane_elements__pinb__Limits, //	
    NOT_SUPP(WindowTable0f), // &Find_pane_elements__pinb_, //	
	MAN_OK(Find_pane_texts__pinb__Line_1), // &Find_pane_texts__pinb__Line_1, //	&TextLine0f,
	MAN_OK(Find_pane_texts__pinb__Line_2), // &Find_pane_texts__pinb__Line_2, //	&TextLine0f,
    MAN_OK(Limits), // &Find_pane_texts__pinb__Limits, //	
    MAN_OK(TextTable0f), // &Find_pane_texts__pinb_, //	
	NOT_SUPP(Pinboard_elements__list__Line_1), //	&WindowLine0f,
	NOT_SUPP(Pinboard_elements__list__Line_2), //	&WindowLine0f,
	NOT_SUPP(Pinboard_elements__list__Line_3), //	&WindowLine0f,
	NOT_SUPP(Pinboard_elements__list__Line_4), //	&WindowLine1f,
	NOT_SUPP(Pinboard_elements__list__Line_5), //	&WindowLine0f,
	NOT_SUPP(Pinboard_elements__list__Line_6), //	&WindowLine1f,
	MAN_OK(list_pinb_pane), // &list_pinb_pane, //	&WindowLine0f,
    NOT_SUPP(Limits), // &Pinboard_elements__list__SUB_TABLE_0_Limits, //	
    NOT_SUPP(WindowTable0f), // &Pinboard_elements__list__SUB_TABLE_0, //	
    MAN_OK(Speed_Dial_descendants_Line_1), // &Speed_Dial_descendants_Line_1, //	&WindowLine0f,
	MAN_OK(grid_vorec_pane), //	&WindowLine0f,
	NOT_SUPP(Voice_Recorder_elements_Line_2), //	&WindowLine0f,
	NOT_SUPP(Voice_Recorder_elements_Line_3), //	&WindowLine0f,
	MAN_OK(Voice_Recorder_elements_Line_4), //	&WindowLine0f,
	MAN_OK(Voice_Recorder_elements_Line_5), //	&WindowLine0f,
    NOT_SUPP(Limits), // &Voice_Recorder_elements_Limits, //	
    NOT_SUPP(WindowTable0f), // &Voice_Recorder_elements, //	
	MAN_OK(Voice_Recorder_texts_Line_1), //	&TextLine0f,
	MAN_OK(Voice_Recorder_texts_Line_2), //	&TextLine0f,
	MAN_OK(Voice_Recorder_texts_Line_3), //	&TextLine0f,
	MAN_OK(Voice_Recorder_texts_Line_4), //	&TextLine0f,
	MAN_OK(Voice_Recorder_texts_Line_5), //	&TextLine0f,
	MAN_OK(Voice_Recorder_texts_Line_6), //	&TextLine0f,
    MAN_OK(Limits), // &Voice_Recorder_texts_Limits, //	
    MAN_OK(TextTable0f), // &Voice_Recorder_texts, //	
	MAN_OK(Message_writing_texts_Line_1), //	&TextLine1f,
    MAN_OK(MultiLineTextLine1f), // &Multiline_Message_writing_texts_Line_1, //	
	MAN_OK(Message_writing_texts_Line_2), //	&TextLine1f,
    MAN_OK(MultiLineTextLine1f), // Multiline_Message_writing_texts_Line_2), //	
	MAN_OK(Message_writing_texts_Line_3), //	&TextLine1f,
    MAN_OK(MultiLineTextLine1f), // &Multiline_Message_writing_texts_Line_3, //	
    MAN_OK(Limits), // &Message_writing_texts_Limits, //	
    MAN_OK(TextTable1f), // &Message_writing_texts, //	
	MAN_OK(Smart_Messages_Line_1), //	&TextLine1f,
    MAN_OK(MultiLineTextLine1f), // &Multiline_Smart_Messages_Line_1, //	
	MAN_OK(Smart_Messages_Line_2), //	&TextLine1f,
    MAN_OK(MultiLineTextLine1f), // &Multiline_Smart_Messages_Line_2, //	
    MAN_OK(Limits), // &Smart_Messages_Limits, //	
    MAN_OK(TextTable1f), // &Smart_Messages, //	
	NOT_SUPP(Note_writing_layout_elements_Line_1), //	&WindowLine0f,
    MAN_OK(Note_writing_layout_elements_Line_2), //	&WindowLine0f,
	MAN_OK(Note_writing_layout_elements_Line_3), //	&WindowLine0f,
    MAN_OK(Note_writing_layout_elements_Line_4), //	&WindowLine0f,
    MAN_OK(Note_writing_layout_elements_Line_5), //	&WindowLine1f,
    MAN_OK(Limits), // &Note_writing_layout_elements_SUB_TABLE_0_Limits, //	
    MAN_OK(WindowTable0f), // &Note_writing_layout_elements_SUB_TABLE_0, //	
	MAN_OK(Note_writing_texts_Line_1), //	&TextLine1f,
    MAN_OK(MultiLineTextLine1f), // &Multiline_Note_writing_texts_Line_1, //	
	MAN_OK(im_reading_pane), //	&WindowLine1f,
	MAN_OK(im_writing_pane), //	&WindowLine1f,
	MAN_OK(IM_navi_pane_texts_Line_1), //	&TextLine2f,
	MAN_OK(IM_reading_pane_texts_Line_1), //	&TextLine1f,
	MAN_OK(IM_reading_pane_texts_Line_2), //	&TextLine1f,
    MAN_OK(im_reading_field), // WindowLine1f
	MAN_TODO(IM_text_elements_Line_1), //	&WindowLine0f,
	MAN_TODO(IM_text_elements_Line_2), //	&WindowLine0f,
	MAN_TODO(smiley__qgn_prop_im_smileys__ref__), //	&WindowLine0f,
    MAN_TODO(Limits), // &IM_text_elements_Limits, //	
    MAN_TODO(WindowTable0f), // &IM_text_elements, //	
	NOT_SUPP(IM_reading_field_highlight_graphics_Line_1), //	&WindowLine0t,
	MAN_OK(IM_reading_field_highlight_graphics_Line_2), //	&WindowLine0t,
	MAN_OK(Limits), // &IM_reading_field_highlight_graphics_Limits, //	
	MAN_OK(WindowTable0t), // &IM_reading_field_highlight_graphics, //	
	NOT_SUPP(IM_writing_field_elements_Line_1), //	&WindowLine1f,
	NOT_SUPP(IM_writing_field_elements_Line_2), //	&WindowLine0f,
	NOT_SUPP(IM_writing_field_elements_Line_3), //	&WindowLine1f,
	MAN_OK(IM_writing_pane_texts_Line_1), //	&TextLine1f,
    MAN_OK(MultiLineTextLine1f), // &Multiline_IM_writing_pane_texts_Line_1, //	
	MAN_OK(mp_bg_pane), // &mp_bg_pane, //	&WindowLine0f,
	MAN_OK(Empty_Player_view_elements_Line_1), //	&WindowLine0f,
	MAN_OK(Media_Player_Playback_view_navi_pane_elements_Line_1), //	&WindowLine0f,
	MAN_OK(Media_Player_Playback_view_navi_pane_elements_Line_2), //	&WindowLine0f,
    MAN_OK(Limits), // Media_Player_Playback_view_navi_pane_elements_Limits, //	
    MAN_OK(WindowTable0f), // &Media_Player_Playback_view_navi_pane_elements, //	
	MAN_OK(Media_Player_Playback_view_navi_pane_texts_Line_1), //	&TextLine0f,
	MAN_OK(Media_Player_Playlist_navi_pane_elements_Line_1), //	&WindowLine0f,
	MAN_OK(Media_Player_Playlist_navi_pane_elements_Line_2), //	&WindowLine0f,
    MAN_OK(Limits), // &Media_Player_Playlist_navi_pane_elements_Limits, //	
    MAN_OK(WindowTable0f), // &Media_Player_Playlist_navi_pane_elements, //	
	MAN_OK(grid_mp_pane), // &grid_mp_pane, //	&WindowLine0f,
	NOT_SUPP(Media_Player_Playback_view_elements_Line_2), //	&WindowLine0f,
	NOT_SUPP(Media_Player_Playback_view_elements_Line_3), //	&WindowLine0f,
	MAN_OK(Media_Player_Playback_view_elements_Line_4), // &Media_Player_Playback_view_elements_Line_4, //	&WindowLine0f,
	MAN_OK(Media_Player_Playback_view_elements_Line_5), //	&WindowLine0f,
	MAN_OK(Media_Player_Playback_view_elements_Line_6), //	&WindowLine0f,
	MAN_OK(Media_Player_Playback_view_texts_Line_1), // &Media_Player_Playback_view_texts_Line_1, //	&TextLine0f,
	MAN_OK(Media_Player_Playback_view_texts_Line_2), // &Media_Player_Playback_view_texts_Line_2, //	&TextLine0f,
	MAN_OK(Media_Player_Playback_view_texts_Line_3), // &Media_Player_Playback_view_texts_Line_3, //	&TextLine0f,
	MAN_OK(Media_Player_Playback_view_texts_Line_4), // &Media_Player_Playback_view_texts_Line_4, //	&TextLine0f,
    MAN_OK(Media_Player_Playback_view_texts_Line_5), // &Media_Player_Playback_view_texts_Line_5, //	&TextLine0f,
	MAN_OK(Media_Player_Playback_view_texts_Line_6), // &Media_Player_Playback_view_texts_Line_6, //	&TextLine0f,
	MAN_OK(Media_Player_Playback_view_texts_Line_7), // &Media_Player_Playback_view_texts_Line_7, //	&TextLine0f,
    MAN_OK(Limits), // &Media_Player_Playback_view_texts_Limits, //	
    MAN_OK(TextTable0f), // &Media_Player_Playback_view_texts, //	
	MAN_OK(SMIL_presentation_attachment_element_Line_1), //	&WindowLine0f,
	NOT_SUPP(SMIL_presentation_attachment_highlight_Line_1), //	&WindowLine0f,
	NOT_SUPP(SMIL_presentation_attachment_highlight_Line_2), //	&WindowLine0f,
    NOT_SUPP(Limits), // &SMIL_presentation_attachment_highlight_Limits, //	
    NOT_SUPP(WindowTable0f), // &SMIL_presentation_attachment_highlight, //	
	MAN_OK(SMIL_presentation_elements_and_descendant_panes_Line_1), //	&WindowLine0f,
	MAN_OK(smil_status_pane), //	&WindowLine0f,
	MAN_OK(smil_text_pane), //	&WindowLine2f,
    MAN_OK(Limits), // &SMIL_presentation_elements_and_descendant_panes_SUB_TABLE_0_Limits, //	
    MAN_OK(WindowTable0f), // &SMIL_presentation_elements_and_descendant_panes_SUB_TABLE_0, //	
	MAN_OK(smil_volume_pane), //	&WindowLine0f,
	MAN_OK(SMIL_status_pane_elements_and_descendant_panes_Line_2), //	&WindowLine0f,
	MAN_OK(SMIL_status_pane_elements_and_descendant_panes_Line_3), //	&WindowLine0f,
	MAN_OK(SMIL_status_pane_elements_and_descendant_panes_Line_4), //	&WindowLine0f,
    MAN_OK(Limits), // &SMIL_status_pane_elements_and_descendant_panes_Limits, //	
    MAN_OK(WindowTable0f), // &SMIL_status_pane_elements_and_descendant_panes, //	
	MAN_OK(SMIL_status_pane_texts_Line_1), //	&TextLine0f,
	MAN_OK(SMIL_volume_pane_elements_Line_1), //	&WindowLine0f,
	MAN_OK(SMIL_volume_pane_elements_Line_2), //	&WindowLine0f,
    MAN_OK(Limits), // &SMIL_volume_pane_elements_Limits, //	
    MAN_OK(WindowTable0f), // &SMIL_volume_pane_elements, //	
	IMPL_OK(Location_request_type_texts_Line_1),	// MurrayR implemented
	IMPL_OK(MultiLineTextLine1f), // &Multiline_Location_request_type_texts_Line_1, //	
	IMPL_OK(Location_requestor_pane_elements_Line_1),	// MurrayR implemented
	IMPL_OK(Location_reqestor_pane_texts_Line_1),	// MurrayR implemented
	IMPL_OK(Location_request_popup_window_grapihcs_Line_1),	// MurrayR implemented
	NOT_SUPP(Location_request_popup_window_grapihcs_Line_2), //	&WindowLine0t,
	NOT_SUPP(Location_request_popup_window_grapihcs_Line_3), //	&WindowLine0t,
	NOT_SUPP(Location_request_popup_window_grapihcs_Line_4), //	&WindowLine0t,
	NOT_SUPP(Location_request_popup_window_grapihcs_Line_5), //	&WindowLine0t,
    NOT_SUPP(Limits), // &Location_request_popup_window_grapihcs_Limits, //	
    NOT_SUPP(WindowTable0t), // &Location_request_popup_window_grapihcs, //	
    NOT_SUPP(Limits), // &Volume_strength_area_values_Limits, //	
    NOT_SUPP(Volume_strength_area_values), //	&WindowTable0f, // table implemented by hand
	NOT_SUPP(SMIL_text_pane_elements_Line_1), //	&WindowLine0t,
	MAN_OK(smil_scroll_pane), //	&WindowLine0t,
	MAN_OK(SMIL_text_pane_texts_Line_1), //	&TextLine2f,
    MAN_OK(MultiLineTextLine2f), // &Multiline_SMIL_text_pane_texts_Line_1, //	
	NOT_SUPP(SMIL_scroll_pane_elements_Line_1), //	&WindowLine0t,
	NOT_SUPP(SMIL_scroll_pane_elements_Line_2), //	&WindowLine0f,
	NOT_SUPP(SMIL_scroll_pane_elements_Line_3), //	&WindowLine0f,
    NOT_SUPP(Limits), // &SMIL_scroll_pane_elements_SUB_TABLE_0_Limits, //	
    NOT_SUPP(WindowTable0f), // &SMIL_scroll_pane_elements_SUB_TABLE_0, //	
	IMPL_OK(popup_pbook_thumbnail_window),	// MurrayR implemented
	IMPL_OK(popup_call_status_window),	// MurrayR implemented
	IMPL_OK(popup_call_video_up_window),	// MurrayR implemented
	IMPL_OK(popup_cale_events_window), // BobD implemented
	IMPL_OK(list_single_graphic_popup_conf_pane),	// MurrayR implemented
	IMPL_OK(List_pane_elements__conf_single_graphic__Line_1),	// MurrayR implemented
	IMPL_OK(List_pane_elements__conf_single_graphic__Line_2),	// MurrayR implemented
    IMPL_OK(Limits), // &List_pane_elements__conf_single_graphic__Limits, //	
    IMPL_OK(WindowTable0f), // &List_pane_elements__conf_single_graphic_, //	
	IMPL_OK(List_pane_texts__conf_single_graphic__Line_1),	// MurrayR implemented
	IMPL_OK(List_pane_elements__menu_single_graphic_bt__Line_1), //	&WindowLine0f,
	IMPL_OK(List_pane_elements__menu_single_graphic_bt__Line_2), //	&WindowLine1f,
	IMPL_OK(List_pane_text__menu_single_graphic_bt__Line_1), //	&TextLine1f,
	IMPL_OK(Highlight_graphics_Line_1),	// MurrayR implemented
	IMPL_OK(Highlight_graphics_Line_2),	// MurrayR implemented
	IMPL_OK(Limits), // &Highlight_graphics_Limits, //	&
	IMPL_OK(WindowTable0t), // &Highlight_graphics, //	&
	IMPL_OK(cell_large_graphic_popup_pane),	// MurrayR implemented
	IMPL_OK(Cell_pane_elements__popup_large_graphic_gms__Line_1),	// MurrayR implemented
	IMPL_OK(Cell_pane_elements__popup_large_graphic_gms__Line_2),	// MurrayR implemented
	IMPL_OK(Limits), // &Cell_pane_elements__popup_large_graphic_gms__Limits, //	&
	IMPL_OK(WindowTable0f), // &Cell_pane_elements__popup_large_graphic_gms_, //	&
	IMPL_OK(Highlight_elements__grid_pop_up__Line_1),	// MurrayR implemented
	IMPL_OK(Number_entry_pop_up_window_texts_Line_1), // BobD implemented
	IMPL_OK(Number_entry_pop_up_window_texts_Line_2), // BobD implemented
	IMPL_OK(MultiLineTextLine2f), // &Multiline_Number_entry_pop_up_window_texts_Line_2, //	&
	IMPL_OK(Number_entry_pop_up_window_graphics_Line_1), //	&WindowLine1f,
	IMPL_OK(Number_entry_pop_up_window_graphics_Line_2), //	&WindowLine1f,
	IMPL_OK(Number_entry_pop_up_window_graphics_Line_3), //	&WindowLine1f,
	IMPL_OK(Number_entry_pop_up_window_graphics_Line_4), //	&WindowLine1f,
	IMPL_OK(Number_entry_pop_up_window_graphics_Line_5), //	&WindowLine1f,
	IMPL_OK(Limits), // &Number_entry_pop_up_window_graphics_SUB_TABLE_0_Limits, //	&
	IMPL_OK(WindowTable1f), // &Number_entry_pop_up_window_graphics_SUB_TABLE_0, //	&
	NO_DATA(popup_heading_pane), //	&WindowLine0f,
	NO_DATA(Phonebook_memory_status_pop_up_window_descendants_and_elements_Line_2), //	&WindowLine0f,
	NO_DATA(Limits), // &Phonebook_memory_status_pop_up_window_descendants_and_elements_Limits, //	&
	NO_DATA(WindowTable0f), // &Phonebook_memory_status_pop_up_window_descendants_and_elements, //	&
	NO_DATA(Phonebook_memory_status_pop_up_window_texts_Line_1), //	&TextLine1f,
	NO_DATA(MultiLineTextLine1f), // &Multiline_Phonebook_memory_status_pop_up_window_texts_Line_1, //	&
	NO_DATA(Phonebook_memory_status_pop_up_window_texts_Line_2), //	&TextLine1f,
	NO_DATA(MultiLineTextLine1f),  // &Multiline_Phonebook_memory_status_pop_up_window_texts_Line_2, //	&MultiLineTextLine1f,
	NO_DATA(Limits), // &Phonebook_memory_status_pop_up_window_texts_Limits, //	&
	NO_DATA(TextTable1f), // &Phonebook_memory_status_pop_up_window_texts, //	&
	NO_DATA(Phonebook_memory_status_pop_up_window_graphics_Line_1), //	&WindowLine0f,
	NO_DATA(Phonebook_memory_status_pop_up_window_graphics_Line_2), //	&WindowLine0f,
	NO_DATA(Phonebook_memory_status_pop_up_window_graphics_Line_3), //	&WindowLine0f,
	NO_DATA(Phonebook_memory_status_pop_up_window_graphics_Line_4), //	&WindowLine0f,
	NO_DATA(Phonebook_memory_status_pop_up_window_graphics_Line_5), //	&WindowLine0f,
	NO_DATA(Limits), // &Phonebook_memory_status_pop_up_window_graphics_Limits, //	&
	NO_DATA(WindowTable0f), // &Phonebook_memory_status_pop_up_window_graphics, //	&
	IMPL_OK(Graphical_message_image_selection_pop_up_window_descendants_Line_1),	// MurrayR implemented
	IMPL_OK(grid_large_graphic_popup_pane),	// MurrayR implemented
	IMPL_OK(Graphical_message_image_selection_pop_up_window_elements_Line_1),	// MurrayR implemented
	IMPL_OK(Graphical_message_image_selection_pop_up_window_elements_Line_2),	// MurrayR implemented
	IMPL_OK(Graphical_message_image_selection_pop_up_window_graphics_Line_1),	// MurrayR implemented
	NOT_SUPP(Graphical_message_image_selection_pop_up_window_graphics_Line_2), //	&WindowLine0t,
	NOT_SUPP(Graphical_message_image_selection_pop_up_window_graphics_Line_3), //	&WindowLine0t,
	NOT_SUPP(Graphical_message_image_selection_pop_up_window_graphics_Line_4), //	&WindowLine0t,
	NOT_SUPP(Graphical_message_image_selection_pop_up_window_graphics_Line_5), //	&WindowLine0t,
	NOT_SUPP(Limits), // &Graphical_message_image_selection_pop_up_window_graphics_Limits, //	&
	NOT_SUPP(WindowTable0t), // &Graphical_message_image_selection_pop_up_window_graphics, //	&
	NOT_SUPP(Browser_WIM_PIN_Code_query_pop_up_window_elements_Line_1), //	&WindowLine0f,
	NOT_SUPP(Browser_WIM_PIN_Code_query_pop_up_window_elements_Line_2), //	&WindowLine1f,
	NOT_SUPP(Browser_WIM_PIN_Code_query_pop_up_window_elements_Line_3), //	&WindowLine1f,
	NOT_SUPP(Browser_WIM_PIN_Code_query_pop_up_window_elements_Line_4), //	&WindowLine1f,
	NOT_SUPP(Browser_WIM_PIN_Code_query_pop_up_window_elements_Line_5), //	&WindowLine0f,
	NOT_SUPP(Browser_WIM_PIN_Code_query_pop_up_window_elements_Line_6), //	&WindowLine1f,
	NOT_SUPP(Limits), // &Browser_WIM_PIN_Code_query_pop_up_window_elements_SUB_TABLE_0_Limits, //	&
	NOT_SUPP(WindowTable1f), // &Browser_WIM_PIN_Code_query_pop_up_window_elements_SUB_TABLE_0, //	&
	NOT_SUPP(Browser_WIM_PIN_Code_query_pop_up_window_texts_Line_1), //	&TextLine0f,
	NOT_SUPP(Browser_WIM_PIN_Code_query_pop_up_window_texts_Line_2), //	&TextLine1f,
	NOT_SUPP(MultiLineTextLine1f), // &Multiline_Browser_WIM_PIN_Code_query_pop_up_window_texts_Line_2, //	&
	NOT_SUPP(Browser_WIM_PIN_Code_query_pop_up_window_texts_Line_3), //	&TextLine1f,
	NOT_SUPP(MultiLineTextLine1f), // &Multiline_Browser_WIM_PIN_Code_query_pop_up_window_texts_Line_3, //	&
	NOT_SUPP(Limits), // &Browser_WIM_PIN_Code_query_pop_up_window_texts_SUB_TABLE_0_Limits, //	
	NOT_SUPP(TextTable1f), // &Browser_WIM_PIN_Code_query_pop_up_window_texts_SUB_TABLE_0, //	&
	NOT_SUPP(Browser_WIM_PIN_Code_query_pop_up_window_graphics_Line_1), //	&WindowLine0t,
	NOT_SUPP(Browser_WIM_PIN_Code_query_pop_up_window_graphics_Line_2), //	&WindowLine0t,
	NOT_SUPP(Browser_WIM_PIN_Code_query_pop_up_window_graphics_Line_3), //	&WindowLine0t,
	NOT_SUPP(Browser_WIM_PIN_Code_query_pop_up_window_graphics_Line_4), //	&WindowLine0t,
	NOT_SUPP(Browser_WIM_PIN_Code_query_pop_up_window_graphics_Line_5), //	&WindowLine0t,
	NOT_SUPP(Limits), // &Browser_WIM_PIN_Code_query_pop_up_window_graphics_Limits, //	&
	NOT_SUPP(WindowTable0t), // &Browser_WIM_PIN_Code_query_pop_up_window_graphics, //	&
	NOT_SUPP(Browser_Digital_Signing_query_pop_up_window_elements_Line_1), //	&WindowLine0f,
	NOT_SUPP(Browser_Digital_Signing_query_pop_up_window_elements_Line_2), //	&WindowLine0f,
	NOT_SUPP(Limits), // &Browser_Digital_Signing_query_pop_up_window_elements_Limits, //	&
	NOT_SUPP(WindowTable0f), // &Browser_Digital_Signing_query_pop_up_window_elements, //	&
	NOT_SUPP(Browser_Digital_Signing_query_pop_up_window_texts_Line_1), //	&TextLine0f,
	NOT_SUPP(Browser_Digital_Signing_query_pop_up_window_texts_Line_2), //	&TextLine2f,
	NOT_SUPP(MultiLineTextLine2f), // &Multiline_Browser_Digital_Signing_query_pop_up_window_texts_Line_2, //	&
	NO_DATA(SAT_Information_query_pop_up_window_elements_Line_1), //	&WindowLine0f,
	NO_DATA(SAT_Information_query_pop_up_window_elements_Line_2), //	&WindowLine0f,
	NO_DATA(Limits), // &SAT_Information_query_pop_up_window_elements_Limits, //	&
	NO_DATA(WindowTable0f), // &SAT_Information_query_pop_up_window_elements, //	&
	NO_DATA(SAT_Information_query_pop_up_window_texts_Line_1), //	&TextLine2f,
	NO_DATA(MultiLineTextLine2f), // &Multiline_SAT_Information_query_pop_up_window_texts_Line_1, //	&
	IMPL_OK(Analogue_clock_pop_up_window_elements_Line_1),	// MurrayR implemented
	IMPL_OK(Analogue_clock_pop_up_window_elements_Line_2),	// MurrayR implemented
	NOT_SUPP(Analogue_clock_pop_up_window_elements_Line_3), //	&WindowLine0f, // Clock crashes is activated
	NOT_SUPP(Analogue_clock_pop_up_window_elements_Line_4), //	&WindowLine0f, // Clock crashes is activated
	NOT_SUPP(Analogue_clock_pop_up_window_elements_Line_5), //	&WindowLine0f,
	NOT_SUPP(Limits), // &Analogue_clock_pop_up_window_elements_SUB_TABLE_0_Limits, //	&
	NOT_SUPP(WindowTable0t), // &Analogue_clock_pop_up_window_elements_SUB_TABLE_0, //	&
	NOT_SUPP(Limits), // &Analogue_clock_pop_up_window_elements_SUB_TABLE_1_Limits, //	&
	NOT_SUPP(WindowTable0f), // &Analogue_clock_pop_up_window_elements_SUB_TABLE_1, //	&
	IMPL_OK(Analogue_clock_pop_up_window_texts_Line_1),	// MurrayR implemented
	NOT_SUPP(Digital_clock_pop_up_window_elements_Line_1), //	&WindowLine0f,
	NOT_SUPP(Digital_clock_pop_up_window_elements_Line_2), //	&WindowLine0f,
	NOT_SUPP(Digital_clock_pop_up_window_elements_Line_3), //	&WindowLine0f,
	NOT_SUPP(Limits), // &Digital_clock_pop_up_window_elements_Limits, //	&
	NOT_SUPP(WindowTable0f), // &Digital_clock_pop_up_window_elements, //	&
	NOT_SUPP(Digital_clock_pop_up_window_texts_Line_1), //	&TextLine0f,
	IMPL_OK(Digital_clock_pop_up_window_texts_Line_2),	// MurrayR implemented
	NOT_SUPP(Limits), // &Digital_clock_pop_up_window_texts_Limits, //	&
	NOT_SUPP(TextTable0f), // &Digital_clock_pop_up_window_texts, //	&
	IMPL_OK(Thumbnail_pop_up_window_elements_Line_1),	// MurrayR implemented
	IMPL_OK(Thumbnail_pop_up_window_elements_Line_2),	// MurrayR implemented
	IMPL_OK(Thumbnail_pop_up_window_elements_Line_3),	// MurrayR implemented
	IMPL_OK(Thumbnail_pop_up_window_elements_Line_4),	// MurrayR implemented
	IMPL_OK(Thumbnail_pop_up_window_elements_Line_5),	// MurrayR implemented
	IMPL_OK(Thumbnail_pop_up_window_elements_Line_6),	// MurrayR implemented
	IMPL_OK(Thumbnail_pop_up_window_elements_Line_7),	// MurrayR implemented
	IMPL_OK(Thumbnail_pop_up_window_elements_Line_8),	// MurrayR implemented
	IMPL_OK(Thumbnail_pop_up_window_elements_Line_9),	// MurrayR implemented
	IMPL_OK(Thumbnail_pop_up_window_elements_Line_10),	// MurrayR implemented
	IMPL_OK(Thumbnail_pop_up_window_elements_Line_11),	// MurrayR implemented
	IMPL_OK(Thumbnail_pop_up_window_elements_Line_12),	// MurrayR implemented
	IMPL_OK(Thumbnail_pop_up_window_elements_Line_13),	// MurrayR implemented
	IMPL_OK(Thumbnail_pop_up_window_elements_Line_14),	// MurrayR implemented
	IMPL_OK(Thumbnail_pop_up_window_elements_Line_15),	// MurrayR implemented
	IMPL_OK(Thumbnail_pop_up_window_elements_Line_16),	// MurrayR implemented
	IMPL_OK(Thumbnail_pop_up_window_elements_Line_17),	// MurrayR implemented
	IMPL_OK(Thumbnail_pop_up_window_elements_Line_18),	// MurrayR implemented
	IMPL_OK(Limits), // &Thumbnail_pop_up_window_elements_Limits, //	&
	IMPL_OK(WindowTable0f), // &Thumbnail_pop_up_window_elements, //	&,
	IMPL_OK(Call_status_pop_up_window_elements_Line_1),	// MurrayR implemented
	IMPL_OK(Call_status_pop_up_window_elements_Line_2),	// MurrayR implemented
	IMPL_OK(Call_status_pop_up_window_elements_Line_3),	// MurrayR implemented
	IMPL_OK(Call_status_pop_up_window_elements_Line_4),	// MurrayR implemented
	IMPL_OK(Limits), // &Call_status_pop_up_window_elements_Limits, //	&
	IMPL_OK(WindowTable0f), // &Call_status_pop_up_window_elements, //	&
	IMPL_OK(Incoming_call_pop_up_window_elements_Line_1),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements_Line_2),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements_Line_3),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements_Line_4),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements_Line_5),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements_Line_6),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements_Line_7),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements_Line_8),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements_Line_9),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements_Line_10),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements_Line_11),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements_Line_12),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements_Line_13),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements_Line_14),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements_Line_15),	// MurrayR implemented
	IMPL_OK(Limits), // &Incoming_call_pop_up_window_elements_SUB_TABLE_0_Limits, //	&Limits,
	IMPL_OK(WindowTable0f), // &Incoming_call_pop_up_window_elements_SUB_TABLE_0, //	&WindowTable0f,
	IMPL_OK(Incoming_call_pop_up_window_texts_Line_1),	// MurrayR implemented
	IMPL_OK(MultiLineTextLine3f), // &Multiline_Incoming_call_pop_up_window_texts_Line_1, //	&
	IMPL_OK(Incoming_call_pop_up_window_texts_Line_2),	// MurrayR implemented
	IMPL_OK(MultiLineTextLine3f), // &Multiline_Incoming_call_pop_up_window_texts_Line_2, //	&
	IMPL_OK(Limits), // &Incoming_call_pop_up_window_texts_Limits, //	&
	IMPL_OK(TextTable2f), // &Incoming_call_pop_up_window_texts, //	&
	IMPL_OK(Incoming_call_pop_up_window_graphics_Line_1),	// MurrayR implemented
	NOT_SUPP(Incoming_call_pop_up_window_graphics_Line_2), //	&WindowLine1f,
	NOT_SUPP(Incoming_call_pop_up_window_graphics_Line_3), //	&WindowLine1f,
	NOT_SUPP(Incoming_call_pop_up_window_graphics_Line_4), //	&WindowLine1f,
	NOT_SUPP(Incoming_call_pop_up_window_graphics_Line_5), //	&WindowLine1f,
	NOT_SUPP(Limits), // &Incoming_call_pop_up_window_graphics_Limits, //	&
	NOT_SUPP(WindowTable1f), // &Incoming_call_pop_up_window_graphics, //	&
	IMPL_OK(Incoming_call_pop_up_window_elements__NE__Line_1),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements__NE__Line_2),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements__NE__Line_3),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements__NE__Line_4),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements__NE__Line_5),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements__NE__Line_6),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements__NE__Line_7),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements__NE__Line_8),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements__NE__Line_9),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements__NE__Line_10),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements__NE__Line_11),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements__NE__Line_12),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements__NE__Line_13),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements__NE__Line_14),	// MurrayR implemented
	IMPL_OK(Incoming_call_pop_up_window_elements__NE__Line_15),	// MurrayR implemented
	IMPL_OK(Limits), // &Incoming_call_pop_up_window_elements__NE__Limits, //	&
	IMPL_OK(WindowTable0f), // &Incoming_call_pop_up_window_elements__NE_, //	&
	IMPL_OK(Incoming_call_pop_up_window_texts__NE__Line_1),	// MurrayR implemented
	IMPL_OK(MultiLineTextLine3f), // &Multiline_Incoming_call_pop_up_window_texts__NE__Line_1, //	&
	IMPL_OK(Incoming_call_pop_up_window_texts__NE__Line_2),	// MurrayR implemented
	IMPL_OK(MultiLineTextLine3f), // &Multiline_Incoming_call_pop_up_window_texts__NE__Line_2, //	&
	IMPL_OK(Limits), // &Incoming_call_pop_up_window_texts__NE__Limits, //	&
	IMPL_OK(TextTable2f), // &Incoming_call_pop_up_window_texts__NE_, //	&
	IMPL_OK(Incoming_call_pop_up_window_graphics__NE__Line_1),	// MurrayR implemented
	NOT_SUPP(Incoming_call_pop_up_window_graphics__NE__Line_2), //	&WindowLine0f,
	NOT_SUPP(Incoming_call_pop_up_window_graphics__NE__Line_3), //	&WindowLine0f,
	NOT_SUPP(Incoming_call_pop_up_window_graphics__NE__Line_4), //	&WindowLine0f,
	NOT_SUPP(Incoming_call_pop_up_window_graphics__NE__Line_5), //	&WindowLine0f,
	NOT_SUPP(Limits), // &Incoming_call_pop_up_window_graphics__NE__Limits, //	&
	NOT_SUPP(WindowTable0f), // &Incoming_call_pop_up_window_graphics__NE_, //	&
	IMPL_OK(Outgoing_call_pop_up_window_elements__held__Line_1),	// MurrayR implemented
	IMPL_OK(Outgoing_call_pop_up_window_elements__held__Line_2),	// MurrayR implemented
	IMPL_OK(Outgoing_call_pop_up_window_elements__held__Line_3),	// MurrayR implemented
	IMPL_OK(Outgoing_call_pop_up_window_elements__held__Line_4),	// MurrayR implemented
	IMPL_OK(Outgoing_call_pop_up_window_elements__held__Line_5),	// MurrayR implemented
	IMPL_OK(Outgoing_call_pop_up_window_elements__held__Line_6),	// MurrayR implemented
	IMPL_OK(Outgoing_call_pop_up_window_elements__held__Line_7),	// MurrayR implemented
	IMPL_OK(Outgoing_call_pop_up_window_elements__held__Line_8),	// MurrayR implemented
	IMPL_OK(Outgoing_call_pop_up_window_elements__held__Line_9),	// MurrayR implemented
	IMPL_OK(Outgoing_call_pop_up_window_elements__held__Line_10),	// MurrayR implemented
	IMPL_OK(Outgoing_call_pop_up_window_elements__held__Line_11),	// MurrayR implemented
	IMPL_OK(Outgoing_call_pop_up_window_elements__held__Line_12),	// MurrayR implemented
	IMPL_OK(Outgoing_call_pop_up_window_elements__held__Line_13),	// MurrayR implemented
	IMPL_OK(Outgoing_call_pop_up_window_elements__held__Line_14),	// MurrayR implemented
	IMPL_OK(Outgoing_call_pop_up_window_elements__held__Line_15),	// MurrayR implemented
	IMPL_OK(Limits), // &Outgoing_call_pop_up_window_elements__held__Limits, //	&
	IMPL_OK(WindowTable0f), // &Outgoing_call_pop_up_window_elements__held_, //	&
	IMPL_OK(Outgoing_call_pop_up_window_texts__held__Line_1),	// MurrayR implemented
	IMPL_OK(MultiLineTextLine3f), // &Multiline_Outgoing_call_pop_up_window_texts__held__Line_1, //	&
	IMPL_OK(Outgoing_call_pop_up_window_graphics__held__Line_1),	// MurrayR implemented
	IMPL_OK(Outgoing_call_pop_up_window_elements__held_NE__Line_1),	// MurrayR implemented
	IMPL_OK(Outgoing_call_pop_up_window_elements__held_NE__Line_2),	// MurrayR implemented
	IMPL_OK(Outgoing_call_pop_up_window_elements__held_NE__Line_3),	// MurrayR implemented
	IMPL_OK(Limits), // &Outgoing_call_pop_up_window_elements__held_NE__Limits, //	&
	IMPL_OK(WindowTable0f), // &Outgoing_call_pop_up_window_elements__held_NE_, //	&
	IMPL_OK(Outgoing_call_pop_up_window_texts__held_NE__Line_1),	// MurrayR implemented
	IMPL_OK(Outgoing_call_pop_up_window_graphics__held_NE__Line_1),	// MurrayR implemented
	IMPL_OK(First_call_pop_up_window_elements__one_call__Line_1),	// MurrayR implemented
	IMPL_OK(First_call_pop_up_window_elements__one_call__Line_2),	// MurrayR implemented
	IMPL_OK(First_call_pop_up_window_elements__one_call__Line_3),	// MurrayR implemented
	IMPL_OK(Limits), // &First_call_pop_up_window_elements__one_call__Limits, //	&
	IMPL_OK(WindowTable0f), // &First_call_pop_up_window_elements__one_call_, //	&
	IMPL_OK(First_call_pop_up_window_texts__one_call__Line_1),	// MurrayR implemented
	IMPL_OK(MultiLineTextLine3f), // &Multiline_First_call_pop_up_window_texts__one_call__Line_1, //	&
	IMPL_OK(First_call_pop_up_window_texts__one_call__Line_2),	// MurrayR implemented
	IMPL_OK(First_call_pop_up_window_graphics__one_call__Line_1),	// MurrayR implemented
	IMPL_OK(First_call_pop_up_window_elements__two_calls__Line_1),	// MurrayR implemented
	IMPL_OK(First_call_pop_up_window_elements__two_calls__Line_2),	// MurrayR implemented
	IMPL_OK(First_call_pop_up_window_elements__two_calls__Line_3),	// MurrayR implemented
	IMPL_OK(First_call_pop_up_window_elements__two_calls__Line_4),	// MurrayR implemented
	IMPL_OK(First_call_pop_up_window_elements__two_calls__Line_5),	// MurrayR implemented
	IMPL_OK(First_call_pop_up_window_elements__two_calls__Line_6),	// MurrayR implemented
	IMPL_OK(First_call_pop_up_window_elements__two_calls__Line_7),	// MurrayR implemented
	IMPL_OK(First_call_pop_up_window_elements__two_calls__Line_8),	// MurrayR implemented
	IMPL_OK(First_call_pop_up_window_elements__two_calls__Line_9),	// MurrayR implemented
	IMPL_OK(First_call_pop_up_window_elements__two_calls__Line_10),	// MurrayR implemented
	IMPL_OK(First_call_pop_up_window_elements__two_calls__Line_11),	// MurrayR implemented
	IMPL_OK(First_call_pop_up_window_elements__two_calls__Line_12),	// MurrayR implemented
	IMPL_OK(First_call_pop_up_window_elements__two_calls__Line_13),	// MurrayR implemented
	IMPL_OK(First_call_pop_up_window_elements__two_calls__Line_14),	// MurrayR implemented
	IMPL_OK(First_call_pop_up_window_elements__two_calls__Line_15),	// MurrayR implemented
	IMPL_OK(Limits), // &First_call_pop_up_window_elements__two_calls__Limits, //	&
	IMPL_OK(WindowTable0f), // &First_call_pop_up_window_elements__two_calls_, //	&
	IMPL_OK(First_call_pop_up_window_texts__two_calls__Line_1),	// MurrayR implemented
	IMPL_OK(MultiLineTextLine3f), // &Multiline_First_call_pop_up_window_texts__two_calls__Line_1, //	&
	IMPL_OK(First_call_pop_up_window_texts__two_calls__Line_2),	// MurrayR implemented
	IMPL_OK(First_call_pop_up_window_graphics__two_calls__Line_1),	// MurrayR implemented
	IMPL_OK(First_call_pop_up_window_elements__two_calls_a_waiting_call__Line_1),	// MurrayR implemented
	IMPL_OK(First_call_pop_up_window_elements__two_calls_a_waiting_call__Line_2),	// MurrayR implemented
	IMPL_OK(First_call_pop_up_window_elements__two_calls_a_waiting_call__Line_3),	// MurrayR implemented
	IMPL_OK(Limits), // &First_call_pop_up_window_elements__two_calls_a_waiting_call__Limits, //	&
	IMPL_OK(WindowTable0f), // &First_call_pop_up_window_elements__two_calls_a_waiting_call_, //	&
	IMPL_OK(First_call_pop_up_window_texts__two_calls_a_waiting_call__Line_1),	// MurrayR implemented
	IMPL_OK(First_call_pop_up_window_graphics__two_calls_a_waiting_call__Line_1),	// MurrayR implemented
	IMPL_OK(First_call_pop_up_window_graphics__two_wait_NE__Line_1),	// MurrayR implemented
	IMPL_OK(Waiting_call_pop_up_window_elements__held_out_NE__Line_1),	// MurrayR implemented
	IMPL_OK(Waiting_call_pop_up_window_elements__held_out_NE__Line_2),	// MurrayR implemented
	IMPL_OK(Waiting_call_pop_up_window_elements__held_out_NE__Line_3),	// MurrayR implemented
	IMPL_OK(Limits), // &Waiting_call_pop_up_window_elements__held_out_NE__Limits, //	&
	IMPL_OK(WindowTable0f), // &Waiting_call_pop_up_window_elements__held_out_NE_, //	&
	IMPL_OK(Waiting_call_pop_up_window_texts__held_out_NE__Line_1),	// MurrayR implemented
	IMPL_OK(Waiting_call_pop_up_window_graphics__held_out_NE__Line_1),	// MurrayR implemented
	IMPL_OK(Waiting_call_pop_up_window_graphics__out__Line_1),	// MurrayR implemented
	IMPL_OK(Second_call_pop_up_window_elements__two__Line_1),	// MurrayR implemented
	IMPL_OK(Second_call_pop_up_window_elements__two__Line_2),	// MurrayR implemented
	IMPL_OK(Second_call_pop_up_window_elements__two__Line_3),	// MurrayR implemented
	IMPL_OK(Limits), // &Second_call_pop_up_window_elements__two__Limits, //	&
	IMPL_OK(WindowTable0f), // &Second_call_pop_up_window_elements__two_, //	&
	IMPL_OK(Second_call_pop_up_window_texts__two_calls__Line_1),	// MurrayR implemented
	IMPL_OK(MultiLineTextLine3f), // &Multiline_Second_call_pop_up_window_texts__two_calls__Line_1, //	&
	IMPL_OK(Second_call_pop_up_window_texts__two_calls__Line_2),	// MurrayR implemented
	IMPL_OK(Second_call_pop_up_window_graphics__two_calls__Line_1),	// MurrayR implemented
	IMPL_OK(Second_call_pop_up_window_elements__two_calls_waiting_call__Line_1),	// MurrayR implemented
	IMPL_OK(Second_call_pop_up_window_elements__two_calls_waiting_call__Line_2),	// MurrayR implemented
	IMPL_OK(Second_call_pop_up_window_elements__two_calls_waiting_call__Line_3),	// MurrayR implemented
	IMPL_OK(Limits), // &Second_call_pop_up_window_elements__two_calls_waiting_call__Limits, //	&
	IMPL_OK(WindowTable0f), // &Second_call_pop_up_window_elements__two_calls_waiting_call_, //	&WindowTable0f,
	IMPL_OK(Second_call_pop_up_window_texts__two_calls_waiting_call__Line_1),	// MurrayR implemented
	IMPL_OK(Second_call_pop_up_window_graphics__two_calls_waiting_call__Line_1),	// MurrayR implemented
	IMPL_OK(Conference_call_pop_up_window_descendants_and_elements_Line_1),	// MurrayR implemented
	IMPL_OK(list_conf_pane),	// MurrayR implemented
	IMPL_OK(Conference_call_pop_up_window_texts_Line_1),	// MurrayR implemented
	IMPL_OK(MultiLineTextLine1f), // &Multiline_Conference_call_pop_up_window_texts_Line_1, //	&
    IMPL_OK(Muted_state_elements_Line_1), //	&WindowLine0f,
    IMPL_OK(Calendar_events_list_popup_components_Line_1), // BobD implemented
	IMPL_OK(Calendar_events_list_popup_texts_Line_1), // BobD implemented
	IMPL_OK(MultiLineTextLine1f), // &Multiline_Calendar_events_list_popup_texts_Line_1, //	&MultiLineTextLine1f,
	MGR_TODO(Calendar_events_list_popup_graphics_Line_1),	// MurrayR implemented
	NOT_SUPP(Calendar_events_list_popup_graphics_Line_2), //	&WindowLine0t,
	NOT_SUPP(Calendar_events_list_popup_graphics_Line_3), //	&WindowLine0t,
	NOT_SUPP(Calendar_events_list_popup_graphics_Line_4), //	&WindowLine0t,
	NOT_SUPP(Limits), // &Calendar_events_list_popup_graphics_Limits, //	&
	NOT_SUPP(WindowTable0t), // &Calendar_events_list_popup_graphics, //	&
	IMPL_OK(cell_cams_pane), //	&WindowLine2f,
	IMPL_OK(image_or_qgn_prop_dyc__ref_),	// MurrayR implemented
	IMPL_OK(loc_type_pane),	// MurrayR implemented
	IMPL_OK(loc_req_pane),	// MurrayR implemented
	IMPL_OK(Additional_heading_pane_elements_Line_1),	// MurrayR implemented
	IMPL_OK(Additional_heading_pane_elements_Line_2),	// MurrayR implemented
	IMPL_OK(Additional_heading_pane_elements_Line_3),	// MurrayR implemented
	IMPL_OK(Presence_status_popup_window_texts_Line_1),	// MurrayR implemented
	IMPL_OK(Presence_status_popup_window_texts_Line_2),	// MurrayR implemented
	IMPL_OK(MultiLineTextLine1f), // &Multiline_Presence_status_popup_window_texts_Line_2, //	&
	IMPL_OK(Presence_status_window_graphics_Line_1),	// MurrayR implemented
	NOT_SUPP(Presence_status_window_graphics_Line_2), //	&WindowLine0f,
	NOT_SUPP(Presence_status_window_graphics_Line_3), //	&WindowLine0f,
	NOT_SUPP(Presence_status_window_graphics_Line_4), //	&WindowLine0f,
	NOT_SUPP(Presence_status_window_graphics_Line_5), //	&WindowLine0f,
	NOT_SUPP(Limits), // &Presence_status_window_graphics_Limits, //	&Limits,
	NOT_SUPP(WindowTable0f), // &Presence_status_window_graphics, //	&WindowTable0f,
    IMPL_OK(popup_number_entry_window), // BobD implemented
	NOT_SUPP(popup_pb_memory_status_window), //	&WindowLine0f,
	IMPL_OK(popup_grid_large_graphic_window),	// MurrayR implemented
	IMPL_OK(popup_call_audio_in_window),	// MurrayR implemented
	IMPL_OK(popup_call_audio_out_window),	// MurrayR implemented
	IMPL_OK(popup_call_audio_first_window),	// MurrayR implemented
	IMPL_OK(popup_call_audio_wait_window),	// MurrayR implemented
	IMPL_OK(popup_call_audio_second_window),	// MurrayR implemented
	IMPL_OK(popup_call_audio_conf_window),	// MurrayR implemented
	NOT_SUPP(popup_call_video_in_window), //	&WindowLine0f,
	NOT_SUPP(popup_call_video_first_window), //	&WindowLine0f,
	IMPL_OK(popup_call_video_down_window), // MurrayR implemented
	NOT_SUPP(popup_query_wml_wim_window), //	&WindowLine1f,
	NOT_SUPP(popup_query_wml_sign_window), //	&WindowLine1f,
	NO_DATA(popup_query_sat_info_window), // MurrayR can't implement
	NOT_SUPP(popup_grid_large_compo_graphic_window), //	&WindowLine0f,
	IMPL_OK(popup_dyc_status_message_window),	// MurrayR implemented
	NO_DATA(VGA), //	&WindowLine0f,
	NO_DATA(VGA_turned_90), //	&WindowLine0f,
	NO_DATA(CIF), //	&WindowLine0f,
	NO_DATA(CIF_turned_90), //	&WindowLine0f,
	NO_DATA(Communicator_personal_image), //	&WindowLine0f,
	NO_DATA(Image_aspect_ratio___0_625), //	&WindowLine0f,
	NO_DATA(Image_aspect_ratio___1_467), //	&WindowLine0f,
	NO_DATA(_0_625___image_aspect_ratio___1_467), //	&WindowLine0f,
	NO_DATA(Limits), // &Thumbnail_image_sizes_Limits, //	&
	NO_DATA(WindowTable0f), // &Thumbnail_image_sizes, //	&
	MAN_OK(Message_writing_layout_elements_Line_1), //	&WindowLine2f,
	NOT_SUPP(Message_writing_layout_elements_Line_2), //	&WindowLine2f,
	NOT_SUPP(Message_writing_layout_elements_Line_3), //	&WindowLine1f,
	NOT_SUPP(Message_writing_layout_elements_Line_4), //	&WindowLine1f,
	NOT_SUPP(Message_writing_layout_elements_Line_5), //	&WindowLine1f,
	MAN_OK(Message_writing_layout_elements_Line_6), //	&WindowLine2f,
	NOT_SUPP(Message_writing_layout_elements_Line_7), //	&WindowLine0f,
	MAN_OK(Message_writing_layout_elements_Line_8), //	&WindowLine3f,
	MAN_OK(CamcorderBurst_Mode_Post_Recording_cell_elements_Line_1), //	&WindowLine0f,
	MAN_OK(CamcorderBurst_Mode_Post_Recording_cell_elements_Line_2), //	&WindowLine0f,
	MAN_OK(Limits), // &CamcorderBurst_Mode_Post_Recording_cell_elements_Limits, //	&
	MAN_OK(WindowTable0f), // &CamcorderBurst_Mode_Post_Recording_cell_elements, //	&
	MAN_OK(Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_6), //	&WindowLine0f,
	MAN_OK(Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_7), //	&WindowLine0f,
	NOT_SUPP(near_QCIF), //	&WindowLine0f,
	MAN_OK(Media_Player_navi_pane_texts_Line_1), //	&TextLine0f,
	NOT_SUPP(Volume_strength_area_values_Line_1), //	&WindowLine0f,
	NOT_SUPP(Volume_strength_area_values_Line_2), //	&WindowLine0f,
	NOT_SUPP(Volume_strength_area_values_Line_3), //	&WindowLine0f,
	NOT_SUPP(Volume_strength_area_values_Line_4), //	&WindowLine0f,
	NOT_SUPP(Volume_strength_area_values_Line_5), //	&WindowLine0f,
	NOT_SUPP(Volume_strength_area_values_Line_6), //	&WindowLine0f,
	NOT_SUPP(Volume_strength_area_values_Line_7), //	&WindowLine0f,
	NOT_SUPP(Volume_strength_area_values_Line_8), //	&WindowLine0f,
	MAN_OK(blid_compass_pane), //	&WindowLine0f,
	MAN_OK(BLID_compass_view_elements_Line_2), //	&WindowLine0f,
	MAN_OK(BLID_compass_view_elements_Line_3), //	&WindowLine0f,
	MAN_OK(Limits), // &BLID_compass_view_elements_Limits, //	&
	MAN_OK(WindowTable0f), // &BLID_compass_view_elements, //	&
	NOT_USED(Accuracyvalues_Line_1), //	&WindowLine0f,
	NOT_USED(Accuracyvalues_Line_2), //	&WindowLine0f,
	NOT_USED(Accuracyvalues_Line_3), //	&WindowLine0f,
	NOT_USED(Accuracyvalues_Line_4), //	&WindowLine0f,
	NOT_USED(Accuracyvalues_Line_5), //	&WindowLine0f,
	NOT_USED(Accuracyvalues_Line_6), //	&WindowLine0f,
	NOT_USED(Accuracyvalues_Line_7), //	&WindowLine0f,
	NOT_USED(Accuracyvalues_Line_8), //	&WindowLine0f,
	NOT_USED(Limits), // &Accuracyvalues_Limits, //	&
	NOT_USED(WindowTable0f), // &Accuracyvalues, //	&
	MAN_OK(BLIDcompass_view_texts_Line_1), //	&TextLine0f,
	MAN_OK(BLIDcompass_view_texts_Line_2), //	&TextLine0f,
	MAN_OK(BLIDcompass_view_texts_Line_3), //	&TextLine0f,
	MAN_OK(Limits), // &BLIDcompass_view_texts_Limits, //	&
	MAN_OK(TextTable0f), // &BLIDcompass_view_texts, //	&
	NOT_USED(Compasspane_elements_Line_1), //	&WindowLine0f,
	NOT_USED(Arrow_head__graphic), //	&WindowLine0f,
	NOT_USED(Arrow_body__graphic), //	&WindowLine0f,
	NOT_USED(Limits), // &Compasspane_elements_Limits, //	&
	NOT_USED(WindowTable0f), // &Compasspane_elements, //	&
	NOT_USED(blid_direction_pane), //	&WindowLine0f,
	NOT_USED(BLIDdirection_elements_Line_1), //	&TextLine0f,
    NO_DATA(Outgoingincoming_video_call_elements_Line_1), //	&WindowLine0f,
    NOT_SUPP(Outgoingincoming_video_call_elements_Line_2), //	&WindowLine0f,
    NOT_SUPP(Limits), // &Outgoingincoming_video_call_elements_Limits, //	&
    NOT_SUPP(WindowTable0f), // &Outgoingincoming_video_call_elements, //	&
    MAN_OK(Uplink_video_image__large__Line_1), //	&WindowTable0f,
    MAN_OK(Uplink_video_image__large__Line_2), //	&WindowTable0f,
    MAN_OK(Uplink_video_image__large__Line_3), //	&WindowTable0f,
    MAN_OK(Limits), // &Uplink_video_image__large__Limits, //	&
    MAN_OK(WindowTable0f), // &Uplink_video_image__large_, //	&
    MAN_OK(Downlink_video_image_Line_1), //	&WindowLine0f,
    MAN_OK(downlink_stream), //	&WindowLine0f,
    MAN_OK(Downlink_video_image_Line_3), //	&WindowLine0f,
    MAN_OK(Limits), // &Downlink_video_image_Limits, //	&
    MAN_OK(WindowTable0f), // &Downlink_video_image, //	&
    MAN_OK(title_pane), // &title_pane, //	&WindowLine0f,
    MAN_OK(uni_indicator_pane), // &uni_indicator_pane, //	&WindowLine0f,
    MAN_OK(Limits), // &Status_pane_changes_Limits, //	&
    MAN_OK(WindowTable0f), // &Status_pane_changes, //	&,
    MAN_OK(Title_pane_texts_Line_2), //	&TextLine1f,
    MAN_OK(MultiLineTextLine1f), // &Multiline_Title_pane_texts_Line_2, //	&
    MAN_OK(Navipane_elements_and_descendant_panes_Line_1), //	&WindowLine0f,
    MAN_OK(zooming_pane), //	&WindowLine0f,
    IMPL_OK(Limits), // &Navipane_elements_and_descendant_panes_Limits, //	&
    IMPL_OK(WindowTable0f), // &Navipane_elements_and_descendant_panes, //	&WindowTable0f,
    MAN_OK(Zooming_pane_elements_Line_1), //	&WindowLine0f,
    MAN_OK(Zooming_pane_elements_Line_2), //	&WindowLine0f,
    MAN_OK(Zooming_pane_elements_Line_3), //	&WindowLine0f,
    MAN_OK(Zooming_pane_elements_Line_4), //	&WindowLine0f,
    MAN_OK(Limits), // &Zooming_pane_elements_Limits, //	&
    MAN_OK(WindowTable0f), // &Zooming_pane_elements, //	&
    MAN_OK(Navipanetexts_Line_1), //	&TextLine0f,
    MAN_OK(Navipanetexts_Line_2), //	&TextLine0f,
    MAN_OK(Limits), // &Navipanetexts_Limits, //	&
    MAN_OK(TextTable0f), // &Navipanetexts, //	&
    NOT_USED(Videocall_indicator__NEwaiting_call__Line_1), //	&WindowLine0f,
    NOT_USED(Videocall_indicator__NEwaiting_call__Line_2), //	&WindowLine0f,
    NOT_USED(Limits), // &Videocall_indicator__NEwaiting_call__Limits, //	&
    NOT_USED(WindowTable0f), // &Videocall_indicator__NEwaiting_call_, //	&
    NOT_USED(Callstatus_pop_up_window_elements_Line_1), //	&WindowLine0f,
    NOT_USED(Callstatus_pop_up_window_elements_Line_2), //	&WindowLine0f,
    NOT_USED(Limits), // &Callstatus_pop_up_window_elements_Limits, //	&
    NOT_USED(WindowTable0f), // &Callstatus_pop_up_window_elements, //	&
    MAN_OK(Rectangle), // &Rectangle, //	&WindowLine0f,
    MAN_OK(Colorpalette_preview_screen_element_placing__main_area__Line_2), // &Colorpalette_preview_screen_element_placing__main_area__Line_2, //	&WindowLine0f,
    MAN_OK(Colorpalette_preview_screen_element_placing__main_area__Line_3), // &Colorpalette_preview_screen_element_placing__main_area__Line_3, //	&WindowLine0f,
    MAN_OK(Colorpalette_preview_screen_element_placing__main_area__Line_4), // &Colorpalette_preview_screen_element_placing__main_area__Line_4, //	&WindowLine0f,
    MAN_OK(Colorpalette_preview_screen_element_placing__main_area__Line_5), // &Colorpalette_preview_screen_element_placing__main_area__Line_5, //	&WindowLine0f,
    MAN_OK(Colorpalette_preview_screen_element_placing__main_area__Line_6), // &Colorpalette_preview_screen_element_placing__main_area__Line_6, //	&WindowLine0f,
    MAN_OK(Colorpalette_preview_screen_element_placing__main_area__Line_7), // &Colorpalette_preview_screen_element_placing__main_area__Line_7, //	&WindowLine0f,
    MAN_OK(Colorpalette_preview_screen_element_placing__main_area__Line_8), // &Colorpalette_preview_screen_element_placing__main_area__Line_8, //	&WindowLine0f,
    MAN_OK(Colorpalette_preview_screen_element_placing__main_area__Line_9), // &Colorpalette_preview_screen_element_placing__main_area__Line_9, //	&WindowLine0f,
    MAN_OK(Colorpalette_preview_screen_element_placing__main_area__Line_10), // &Colorpalette_preview_screen_element_placing__main_area__Line_10, //	&WindowLine0f,
    MAN_OK(Colorpalette_preview_screen_element_placing__main_area__Line_11), // &Colorpalette_preview_screen_element_placing__main_area__Line_11, //	&WindowLine0f,
    MAN_OK(Colorpalette_preview_screen_element_placing__main_area__Line_12), // &Colorpalette_preview_screen_element_placing__main_area__Line_12, //	&WindowLine0f,
    MAN_OK(Colorpalette_preview_screen_element_placing__main_area__Line_13), // &Colorpalette_preview_screen_element_placing__main_area__Line_13, //	&WindowLine0f,
    MAN_OK(Colorpalette_preview_screen_element_placing__main_area__Line_14), // &Colorpalette_preview_screen_element_placing__main_area__Line_14, //	&WindowLine0f,
    MAN_OK(Colorpalette_preview_screen_element_placing__main_area__Line_15), // &Colorpalette_preview_screen_element_placing__main_area__Line_15, //	&WindowLine0f,
    MAN_OK(Colorpalette_preview_screen_element_placing__main_area__Line_16), // &Colorpalette_preview_screen_element_placing__main_area__Line_16, //	&WindowLine0f,
    MAN_OK(Colorpalette_preview_screen_element_placing__main_area__Line_17), // &Colorpalette_preview_screen_element_placing__main_area__Line_17, //	&WindowLine0f,
    MAN_OK(Colorpalette_preview_screen_element_placing__main_area__Line_18), // &Colorpalette_preview_screen_element_placing__main_area__Line_18, //	&WindowLine0f,
    MAN_OK(Limits), // &Colorpalette_preview_screen_element_placing__main_area__Limits, //	&
    MAN_OK(WindowTable0f), // &Colorpalette_preview_screen_element_placing__main_area_, //	&
    MAN_OK(Colorpalette_preview_screen_text_placing__main_area__Line_1), // &Colorpalette_preview_screen_text_placing__main_area__Line_1, //	&TextLine0f,
    MAN_OK(Colorpalette_preview_screen_text_placing__main_area__Line_2), // &Colorpalette_preview_screen_text_placing__main_area__Line_2, //	&TextLine0f,
    MAN_OK(Limits), // &Colorpalette_preview_screen_text_placing__main_area__Limits, //	&
    MAN_OK(TextTable0f), // &Colorpalette_preview_screen_text_placing__main_area_, //	&
    NOT_SUPP(audioskin_pane), //	&WindowLine0f,
    NOT_SUPP(Audio_Playbackview_texts_Line_1), //	&TextLine0f,
    NOT_SUPP(Audio_Playbackview_texts_Line_2), //	&TextLine0f,
    NOT_SUPP(Audio_Playbackview_texts_Line_3), //	&TextLine0f,
    NOT_SUPP(Audio_Playbackview_texts_Line_4), //	&TextLine0f,
    NOT_SUPP(Limits), // &Audio_Playbackview_texts_Limits, //	&
    NOT_SUPP(TextTable0f), // &Audio_Playbackview_texts, //	&
    NOT_SUPP(Audioskin_pane_elements_Line_1), //	&WindowLine0f,
    IMPL_OK(popup_loc_request_window),	// MurrayR implemented
    IMPL_OK(list_single_graphic_popup_wml_pane),	// MurrayR implemented
    IMPL_OK(Limits), // &Pop_up_window_list_pane_descendants_call_conf__Limits, //	&
    IMPL_OK(WindowTable1f), // &Pop_up_window_list_pane_descendants_call_conf_, //	&
    IMPL_OK(list_wml_pane),	// AsM
    NOT_SUPP(Browser_address_field_pop_up_window_graphics_Line_1), //	&WindowLine0t,
    NOT_SUPP(Browser_address_field_pop_up_window_graphics_Line_2), //	&WindowLine0t,
    NOT_SUPP(Browser_address_field_pop_up_window_graphics_Line_3), //	&WindowLine0t,
    NOT_SUPP(Browser_address_field_pop_up_window_graphics_Line_4), //	&WindowLine0t,
    NOT_SUPP(Limits), // &Browser_address_field_pop_up_window_graphics_Limits, //	&
    NOT_SUPP(WindowTable0t), // &Browser_address_field_pop_up_window_graphics, //	&
    IMPL_OK(First_call_pop_up_window_texts__one_call__Line_3),	// MurrayR implemented
    IMPL_OK(First_call_pop_up_window_graphics__one_call__Line_2),	// MurrayR implemented
    IMPL_OK(Limits), // &First_call_pop_up_window_graphics__one_call__Limits, //	&
    IMPL_OK(WindowTable0f), // &First_call_pop_up_window_graphics__one_call_, //	&
    IMPL_OK(First_call_pop_up_window_texts__two_calls__Line_3),	// MurrayR implemented
    IMPL_OK(First_call_pop_up_window_graphics__two_calls__Line_2),	// MurrayR implemented
    IMPL_OK(Limits), // &First_call_pop_up_window_graphics__two_calls__Limits, //	&
    IMPL_OK(WindowTable0f), // &First_call_pop_up_window_graphics__two_calls_, //	&
    IMPL_OK(Call_type_pane_split_Line_1),	// MurrayR implemented
    IMPL_OK(Call_type_pane_split_Line_2),	// MurrayR implemented
    IMPL_OK(popup_wml_address_window),	// MurrayR implemented
    IMPL_OK(List_pane_elements__browser_single_graphic__Line_1),	// MurrayR implemented
    IMPL_OK(List_pane_elements__browser_single_graphic__Line_2),	// MurrayR implemented
    IMPL_OK(List_pane_texts__browser_single_graphic__Line_1),	// MurrayR implemented
    MAN_OK(Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_8), //	&WindowLine0f,
    MAN_OK(Camcorder_Still_Image_Viewfinder_descendants_and_elements_Line_9), //	&WindowLine0f,
    MAN_OK(Camcorder_Video_Viewfinder_descendants_and_elements_Line_7), //	&WindowLine1f,
    MAN_OK(Camcorder_Video_Viewfinder_descendants_and_elements_Line_8), //	&WindowLine1f,
    MAN_OK(Camcorder_Video_Recording_descendants_and_elements_Line_7), //	&WindowLine1f,
    MAN_OK(Camcorder_Video_Recording_descendants_and_elements_Line_8), //	&WindowLine1f,
    MAN_OK(Camcorder_Video_Recording_descendants_and_elements_Line_9), //	&WindowLine1f,
    MAN_OK(Camcorder_viewfinder_texts_Line_1), //	&TextLine1f,
    MAN_OK(Camcorder_Still_Image_Burst_Mode_Post_recording_elements_Line_1), //	&WindowLine1f,
    MAN_OK(Camcorder_Still_Image_Burst_Mode_Post_recording_elements_Line_2), //	&WindowLine1f,
    MAN_OK(grid_cams_pane), //	&WindowLine0f,
    NOT_SUPP(Camcorder_Burst_Mode_texts_Line_1), //	&TextLine0f,
    MAN_OK(Camcorder_Brightness_Contrast_descendants_and_elements_Line_1), //	&WindowLine0f,
    MAN_OK(navi_slider_pane), //	&WindowLine0f,
    MAN_OK(Limits), // &Camcorder_Brightness_Contrast_descendants_and_elements_Limits, //	&
    MAN_OK(WindowTable0f), // &Camcorder_Brightness_Contrast_descendants_and_elements, //	&
    MAN_OK(Navi_Slider_pane_elements_Line_1), //	&WindowLine0f,
    MAN_OK(Navi_Slider_pane_elements_Line_2), //	&WindowLine0f,
    MAN_OK(Limits), // &Navi_Slider_pane_elements_Limits, //	&
    MAN_OK(WindowTable0f), // &Navi_Slider_pane_elements, //	&
    MAN_OK(Camcorder_Manual_Exposure_descendants_and_elements_Line_1), //	&WindowLine0f,
    MAN_OK(Zooming_steps_sizes_Line_1), // &WindowLine0f,
    MAN_OK(Zooming_steps_sizes_Line_2), //&WindowLine0f,
    MAN_OK(Zooming_steps_sizes_Line_3), //&WindowLine0f,
    MAN_OK(Zooming_steps_sizes_Line_4), //&WindowLine0f,
    MAN_OK(Zooming_steps_sizes_Line_5), //&WindowLine0f,
    MAN_OK(Zooming_steps_sizes_Line_6), //&WindowLine0f,
    MAN_OK(Zooming_steps_sizes_Line_7), // &WindowLine0f,
    MAN_OK(Zooming_steps_sizes_Line_8), //&WindowLine0f,
    MAN_OK(Zooming_steps_sizes_Line_9), //&WindowLine0f,
    MAN_OK(Zooming_steps_sizes_Line_10), //&WindowLine0f,
    MAN_OK(Zooming_steps_sizes_Line_11), //&WindowLine0f,
    MAN_OK(Uplink_video_image__small__Line_1),
    MAN_OK(Uplink_video_image__small__Line_2),
    MAN_OK(Uplink_video_image__small__Line_3),
    MAN_OK(Limits), // &Uplink_video_image__small__Limits,
    MAN_OK(WindowTable0f), // &Uplink_video_image__small_,
    NOT_SUPP(Downlink_video_image_Line_4),
    MAN_OK(downlink_stream_area),
    NOT_USED(MIDP_text_elements_Line_1),
    NOT_USED(MIDP_text_elements_Line_2),
    NOT_USED(MIDP_texts_Line_1),
    NOT_USED(MultiLineTextLine1f),
    MAN_OK(Camcorder_Zooming_factor_pane_elements_v2_Line_1), //	&WindowLine0f,
    MAN_OK(Camcorder_Zooming_factor_pane_elements_v2_Line_2), //	&WindowLine0f,
    MAN_OK(Camcorder_Zooming_factor_pane_elements_v2_Line_3), //	&WindowLine0f,
    MAN_OK(Camcorder_Zooming_factor_pane_elements_v2_Line_4), //	&WindowLine0f,
    IMPL_OK(Limits), // &Camcorder_Zooming_factor_pane_elements_v2_Limits, //	
    IMPL_OK(WindowTable1f), // &Camcorder_Zooming_factor_pane_elements_v2, //	
    IMPL_OK(cell_radio_pane), // &WindowLine1f,
    NOT_USED(FM_Radio_cell_elements_Line_1), // &WindowLine0f,
    IMPL_OK(grid_radio_pane), // &WindowLine0f,
    IMPL_OK(FM_Radio_elements_Line_2), // &WindowLine0f,
    IMPL_OK(FM_Radio_elements_Line_3), // &WindowLine0f,
    IMPL_OK(FM_Radio_elements_Line_4), // &WindowLine0f,
    IMPL_OK(FM_Radio_elements_Line_5), // &WindowLine0f,
    IMPL_OK(Limits),
    IMPL_OK(WindowTable0f),
    IMPL_OK(FM_Radio_texts_Line_1), // &TextLine0f,
    IMPL_OK(FM_Radio_texts_Line_2), // &TextLine0f,
    IMPL_OK(FM_Radio_texts_Line_3), // &TextLine0f,
    IMPL_OK(FM_Radio_texts_Line_4), // &TextLine0f,
    IMPL_OK(FM_Radio_texts_Line_5), // &TextLine0f,
    IMPL_OK(Limits),
    IMPL_OK(TextTable0f),
    IMPL_OK(aid_cams_cif_uncrop_pane), // &WindowLine0f,
    IMPL_OK(video_down_subqcif_pane)// &WindowLine0f,
	};

} // end of namespace AppLayout_Elaf
