/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/

// It contains the client API.
// It should not be modified manually.

#ifndef AKNLAYOUTSCALABLE_APPS_CDL
#define AKNLAYOUTSCALABLE_APPS_CDL

#include <CdlEngine.h>
#include <AknLayoutScalable_Apps.cdl.common.h>

namespace AknLayoutScalable_Apps
{

class CInstance;

// Standard interface functions 
inline void LoadCustomisationL(const TCdlRef& aRef)                          { CdlEngine::LoadCustomisationL(aRef); }
inline void LoadCustomisationL(const TDesC& aLibName, TInt aInstId)          { TCdlRef ref = { aInstId, { KCdlInterfaceUidValue }, &aLibName }; LoadCustomisationL(ref); }
inline void RequireCustomisationL()                                          { CdlEngine::RequireCustomisationL(&KCdlInterface); }
inline TBool IsCustomisationStarted()                                        { return CdlEngine::IsCustomisationStarted(&KCdlInterface); }
inline const CInstance& CustomisationInstance()                              { return (const CInstance&)(CdlEngine::CustomisationInstance(KCdlInterfaceUid)); }
inline void SetCustomisationChangeObserverL(MCdlChangeObserver* aObserver)   { CdlEngine::SetCustomisationChangeObserverL(aObserver, KCdlInterfaceUid); }

inline const TCdlRef& LastAccessedRef()                                      { return CdlEngine::LastAccessedRef(KCdlInterfaceUid); }
inline void FileNameRelativeToLastAccessedInstance(TFileName& aFileName)     { CdlEngine::FileNameRelativeToLastAccessedInstance(KCdlInterfaceUid, aFileName); }


// CDL API functions, as defined in aknlayoutscalable_apps.cdl

// LAF Table : Screen Contents
inline TAknWindowComponentLayout Screen(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(TScreen_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_Screen)))(aVariety, aCol, aRow); }

// LAF Table : Screen
inline TAknWindowComponentLayout application_window(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tapplication_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_application_window)))(aVariety, aCol, aRow); }

// LAF Table : application_window
inline TAknLayoutScalableParameterLimits area_bottom_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tarea_bottom_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_bottom_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout area_bottom_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tarea_bottom_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_bottom_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits area_top_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tarea_top_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_top_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout area_top_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tarea_top_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_top_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits call_video_uplink_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcall_video_uplink_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_video_uplink_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout call_video_uplink_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_video_uplink_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_video_uplink_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane)))(aVariety, aCol, aRow); }

// LAF Table : status_pane
inline TAknWindowComponentLayout context_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontext_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_context_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_cale_events_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_cale_events_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_events_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_cale_events_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_cale_events_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_events_window)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_mup_playback_window(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_mup_playback_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_mup_playback_window)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout signal_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsignal_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_signal_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_browser_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_browser_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_browser_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_burst_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_burst_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_burst_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_calc_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_calc_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_calc_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_cale_day_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cale_day_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cale_day_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_cale_month_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cale_month_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cale_month_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_cale_week_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cale_week_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cale_week_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_call_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_call_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_call_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_call_poc_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_call_poc_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_call_poc_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_camera_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_chi_dic_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_chi_dic_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_chi_dic_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_clock_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_clock_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_clock_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_fmradio_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_fmradio_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_fmradio_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_graph_messa_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_graph_messa_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_graph_messa_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_help_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_help_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_help_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_im_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_im_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_im_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_image_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_image_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_image_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_image_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_location2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_location2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_location2_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_location_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_location_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_location_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_messa_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_messa_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_messa_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_mp2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp2_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_mp_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_msg_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_msg_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_msg_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_mup_eq_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_eq_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_eq_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_mup_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_notes_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_notes_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_notes_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_pec_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_pec_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pec_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_phob_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_phob_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_phob_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_pinb_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_pinb_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pinb_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_postcard_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_postcard_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_postcard_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_qdial_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_qdial_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_qdial_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_skin_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_skin_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_skin_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_smil2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_smil2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_smil2_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_smil_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_smil_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_smil_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_video_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_video_tele_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video_tele_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_tele_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_viewer_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_viewer_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_viewer_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_viewer_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_viewer_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_viewer_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_vorec_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_vorec_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vorec_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_blid_sat_info_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_blid_sat_info_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_blid_sat_info_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_blid_sat_info_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_blid_sat_info_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_blid_sat_info_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_dyc_status_message_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_dyc_status_message_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_dyc_status_message_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_dyc_status_message_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_dyc_status_message_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_dyc_status_message_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_grid_large_graphic_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_grid_large_graphic_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_grid_large_graphic_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_grid_large_graphic_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_grid_large_graphic_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_grid_large_graphic_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_loc_request_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_loc_request_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_loc_request_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_loc_request_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_loc_request_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_loc_request_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_wml_address_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_wml_address_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_wml_address_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_wml_address_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_wml_address_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_wml_address_window)))(aVariety, aCol, aRow); }

// LAF Table : main_call_pane
inline TAknWindowComponentLayout call_muted_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_muted_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_muted_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_conf_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_conf_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_conf_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call_audio_conf_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_conf_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_conf_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_first_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_first_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_first_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call_audio_first_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_first_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_first_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_in_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_in_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_in_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call_audio_in_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_in_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_in_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_out_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_out_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_out_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call_audio_out_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_out_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_out_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_second_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_second_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_second_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call_audio_second_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_second_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_second_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_wait_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_wait_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_wait_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call_audio_wait_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_wait_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_wait_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_number_entry_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_number_entry_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_number_entry_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_number_entry_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_number_entry_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_number_entry_window)))(aVariety, aCol, aRow); }

// LAF Table : popup_number_entry_window
inline TAknLayoutScalableParameterLimits bg_popup_call_pane_cp05_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_call_pane_cp05_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_pane_cp05_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_call_pane_cp05(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_pane_cp05_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_pane_cp05)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_number_entry_window_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_number_entry_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_number_entry_window_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_number_entry_window_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_number_entry_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_number_entry_window_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_number_entry_window_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_number_entry_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_number_entry_window_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_number_entry_window_t_Limits()		{ return (*(Tpopup_number_entry_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_number_entry_window_t_Limits)))(); }

inline TAknTextComponentLayout popup_number_entry_window_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_number_entry_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_number_entry_window_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout text_title_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttext_title_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_text_title_cp2)))(aVariety, aCol, aRow); }

// LAF Table : popup_call_audio_in_window
inline TAknLayoutScalableParameterLimits bg_popup_call_pane_cp_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_call_pane_cp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_pane_cp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_call_pane_cp(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_pane_cp)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout call_thumbnail_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_thumbnail_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_thumbnail_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_in_window_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_in_window_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_in_window_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call_audio_in_window_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_in_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_in_window_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_in_window_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_in_window_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_in_window_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call_audio_in_window_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_in_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_in_window_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_in_window_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_in_window_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_in_window_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call_audio_in_window_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_in_window_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_in_window_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_call_audio_in_window_g_Limits()		{ return (*(Tpopup_call_audio_in_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_in_window_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_call_audio_in_window_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_call_audio_in_window_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_in_window_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout popup_call_audio_in_window_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_in_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_in_window_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_in_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_in_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_in_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call_audio_in_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_in_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_in_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_in_window_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_in_window_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_in_window_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call_audio_in_window_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_in_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_in_window_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_in_window_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_in_window_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_in_window_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call_audio_in_window_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_in_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_in_window_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_call_audio_in_window_t_Limits()		{ return (*(Tpopup_call_audio_in_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_in_window_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_call_audio_in_window_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_call_audio_in_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_in_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_call_audio_in_window_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_in_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_in_window_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_call_audio_out_window
inline TAknLayoutScalableParameterLimits bg_popup_call_pane_cp01_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_call_pane_cp01_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_pane_cp01_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_call_pane_cp01(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_pane_cp01)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout call_thumbnail_pane_cp02(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_thumbnail_pane_cp02_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_thumbnail_pane_cp02)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout call_type_pane_cp022(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_type_pane_cp022_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_type_pane_cp022)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_out_window_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_out_window_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_out_window_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call_audio_out_window_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_out_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_out_window_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_out_window_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_out_window_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_out_window_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call_audio_out_window_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_out_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_out_window_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_out_window_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_out_window_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_out_window_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call_audio_out_window_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_out_window_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_out_window_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_call_audio_out_window_g_Limits()		{ return (*(Tpopup_call_audio_out_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_out_window_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_call_audio_out_window_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_call_audio_out_window_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_out_window_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout popup_call_audio_out_window_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_out_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_out_window_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_out_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_out_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_out_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call_audio_out_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_out_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_out_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_out_window_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_out_window_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_out_window_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call_audio_out_window_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_out_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_out_window_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_call_audio_out_window_t_Limits()		{ return (*(Tpopup_call_audio_out_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_out_window_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_call_audio_out_window_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_call_audio_out_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_out_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_call_audio_out_window_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_out_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_out_window_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_call_audio_first_window
inline TAknLayoutScalableParameterLimits bg_popup_call_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_call_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_call_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits call_thumbnail_pane_cp_ParamLimits(TInt aVariety = 0)		{ return (*(Tcall_thumbnail_pane_cp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_thumbnail_pane_cp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout call_thumbnail_pane_cp(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_thumbnail_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_thumbnail_pane_cp)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits call_type_pane_cp01_ParamLimits(TInt aVariety = 0)		{ return (*(Tcall_type_pane_cp01_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_type_pane_cp01_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout call_type_pane_cp01(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_type_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_type_pane_cp01)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_first_window_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_first_window_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_first_window_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call_audio_first_window_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_first_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_first_window_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_first_window_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_first_window_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_first_window_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call_audio_first_window_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_first_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_first_window_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_call_audio_first_window_g_Limits()		{ return (*(Tpopup_call_audio_first_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_first_window_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_call_audio_first_window_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_call_audio_first_window_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_first_window_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout popup_call_audio_first_window_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_first_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_first_window_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_first_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_first_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_first_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call_audio_first_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_first_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_first_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_first_window_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_first_window_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_first_window_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call_audio_first_window_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_first_window_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_first_window_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_first_window_t5_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_first_window_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_first_window_t5_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call_audio_first_window_t5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_first_window_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_first_window_t5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_call_audio_first_window_t_Limits()		{ return (*(Tpopup_call_audio_first_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_first_window_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_call_audio_first_window_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_call_audio_first_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_first_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_call_audio_first_window_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_first_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_first_window_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_call_audio_wait_window
inline TAknWindowComponentLayout bg_popup_call_pane_cp02(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_pane_cp02_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_pane_cp02)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout call_type_pane_cp023(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_type_pane_cp023_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_type_pane_cp023)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_call_audio_wait_window_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_wait_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_wait_window_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_call_audio_wait_window_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_wait_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_wait_window_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_call_audio_wait_window_g_Limits()		{ return (*(Tpopup_call_audio_wait_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_wait_window_g_Limits)))(); }

inline TAknWindowComponentLayout popup_call_audio_wait_window_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_wait_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_wait_window_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_call_audio_wait_window_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_wait_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_wait_window_t3)))(aVariety, aCol, aRow); }

// LAF Table : popup_call_audio_second_window
inline TAknLayoutScalableParameterLimits bg_popup_call_pane_cp03_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_call_pane_cp03_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_pane_cp03_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_call_pane_cp03(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_pane_cp03_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_pane_cp03)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits call_thumbnail_pane_cp011_ParamLimits(TInt aVariety = 0)		{ return (*(Tcall_thumbnail_pane_cp011_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_thumbnail_pane_cp011_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout call_thumbnail_pane_cp011(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_thumbnail_pane_cp011_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_thumbnail_pane_cp011)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits call_type_pane_cp034_ParamLimits(TInt aVariety = 0)		{ return (*(Tcall_type_pane_cp034_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_type_pane_cp034_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout call_type_pane_cp034(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_type_pane_cp034_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_type_pane_cp034)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_second_window_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_second_window_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_second_window_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call_audio_second_window_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_second_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_second_window_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_second_window_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_second_window_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_second_window_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call_audio_second_window_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_second_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_second_window_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_call_audio_second_window_g_Limits()		{ return (*(Tpopup_call_audio_second_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_second_window_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_call_audio_second_window_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_call_audio_second_window_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_second_window_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout popup_call_audio_second_window_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_second_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_second_window_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_second_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_second_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_second_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call_audio_second_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_second_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_second_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_second_window_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_second_window_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_second_window_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call_audio_second_window_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_second_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_second_window_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_audio_second_window_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_audio_second_window_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_second_window_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call_audio_second_window_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_second_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_second_window_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_call_audio_second_window_t_Limits()		{ return (*(Tpopup_call_audio_second_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_second_window_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_call_audio_second_window_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_call_audio_second_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_second_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_call_audio_second_window_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_second_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_second_window_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_call_audio_conf_window
inline TAknWindowComponentLayout bg_popup_call_pane_cp04(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_pane_cp04_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_pane_cp04)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_conf_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_conf_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_conf_pane)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_call_audio_conf_window_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_audio_conf_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_audio_conf_window_t1)))(aVariety, aCol, aRow); }

// LAF Table : call_thumbnail_pane
inline TAknWindowComponentLayout call_thumbnail_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_thumbnail_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_thumbnail_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : main_pinb_pane
inline TAknLayoutScalableParameterLimits bg_pinb_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_pinb_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_pinb_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_pinb_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_pinb_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_pinb_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout find_pinb_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfind_pinb_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_pinb_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits listscroll_pinb_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlistscroll_pinb_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_pinb_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout listscroll_pinb_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_pinb_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_pinb_pane)))(aVariety, aCol, aRow); }

// LAF Table : bg_pinb_pane
inline TAknWindowComponentLayout pinb_bg_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpinb_bg_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_pinb_bg_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout pinb_bg_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpinb_bg_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_pinb_bg_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout pinb_bg_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpinb_bg_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_pinb_bg_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout pinb_bg_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpinb_bg_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_pinb_bg_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout pinb_bg_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpinb_bg_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_pinb_bg_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout pinb_bg_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpinb_bg_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_pinb_bg_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout pinb_bg_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpinb_bg_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_pinb_bg_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout pinb_bg_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpinb_bg_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_pinb_bg_pane_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout pinb_bg_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpinb_bg_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_pinb_bg_pane_g9)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout pinb_bg_pane_g10(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpinb_bg_pane_g10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_pinb_bg_pane_g10)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits pinb_bg_pane_g_Limits()		{ return (*(Tpinb_bg_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_pinb_bg_pane_g_Limits)))(); }

inline TAknWindowComponentLayout pinb_bg_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpinb_bg_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_pinb_bg_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : listscroll_pinb_pane
inline TAknWindowComponentLayout grid_pinb_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_pinb_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_pinb_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_pinb_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_pinb_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_pinb_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits scroll_pane_cp01_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_pane_cp01_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp01_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout scroll_pane_cp01(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp01)))(aVariety, aCol, aRow); }

// LAF Table : find_pinb_pane
inline TAknLayoutScalableParameterLimits find_pinb_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tfind_pinb_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_pinb_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout find_pinb_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfind_pinb_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_pinb_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout find_pinb_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfind_pinb_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_pinb_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout find_pinb_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfind_pinb_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_pinb_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits find_pinb_pane_t_Limits()		{ return (*(Tfind_pinb_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_pinb_pane_t_Limits)))(); }

inline TAknTextComponentLayout find_pinb_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfind_pinb_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_pinb_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits input_focus_pane_cp01_ParamLimits(TInt aVariety = 0)		{ return (*(Tinput_focus_pane_cp01_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp01_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout input_focus_pane_cp01(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp01)))(aVariety, aCol, aRow); }

// LAF Table : grid_pinb_pane
inline TAknLayoutScalableParameterLimits cell_pinb_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_pinb_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_pinb_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_pinb_pane(TInt aCol, TInt aRow, TInt aVariety = 0)		{ return (*(Tcell_pinb_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_pinb_pane)))(aCol, aRow, aVariety); }

// LAF Table : cell_pinb_pane
inline TAknLayoutScalableParameterLimits cell_pinb_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_pinb_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_pinb_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_pinb_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_pinb_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_pinb_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_pinb_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_pinb_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_pinb_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_pinb_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_pinb_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_pinb_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_pinb_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_pinb_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_pinb_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_pinb_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_pinb_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_pinb_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_pinb_pane_g_Limits()		{ return (*(Tcell_pinb_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_pinb_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits cell_pinb_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tcell_pinb_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_pinb_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout cell_pinb_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_pinb_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_pinb_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_highlight_pane_cp01(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp01)))(aVariety, aCol, aRow); }

// LAF Table : list_pinb_pane
inline TAknLayoutScalableParameterLimits list_pinb_item_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_pinb_item_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_pinb_item_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_pinb_item_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_pinb_item_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_pinb_item_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_pinb_item_pane
inline TAknWindowComponentLayout list_highlight_pane_cp02(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_cp02_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp02)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_pinb_item_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_pinb_item_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_pinb_item_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_pinb_item_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_pinb_item_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_pinb_item_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_pinb_item_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_pinb_item_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_pinb_item_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_pinb_item_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_pinb_item_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_pinb_item_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_pinb_item_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_pinb_item_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_pinb_item_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_pinb_item_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_pinb_item_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_pinb_item_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_pinb_item_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_pinb_item_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_pinb_item_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_pinb_item_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_pinb_item_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_pinb_item_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_pinb_item_pane_g_Limits()		{ return (*(Tlist_pinb_item_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_pinb_item_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_pinb_item_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_pinb_item_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_pinb_item_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_pinb_item_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_pinb_item_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_pinb_item_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_pinb_item_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_pinb_item_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_pinb_item_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_pinb_item_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_pinb_item_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_pinb_item_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : main_calc_pane
inline TAknWindowComponentLayout calc_display_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcalc_display_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_calc_display_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout calc_paper_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcalc_paper_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_calc_paper_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_calc_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_calc_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_calc_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_clock_pane
inline TAknWindowComponentLayout bg_list_pane_cp01(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_list_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_list_pane_cp01)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout clock_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout clock_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits clock_g_Limits()		{ return (*(Tclock_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_g_Limits)))(); }

inline TAknWindowComponentLayout clock_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits clock_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tclock_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout clock_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits clock_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tclock_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout clock_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits clock_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tclock_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout clock_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits clock_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tclock_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout clock_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits clock_t5_ParamLimits(TInt aVariety = 0)		{ return (*(Tclock_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_t5_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout clock_t5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_t5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits clock_t6_ParamLimits(TInt aVariety = 0)		{ return (*(Tclock_t6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_t6_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout clock_t6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_t6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_t6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits clock_t7_ParamLimits(TInt aVariety = 0)		{ return (*(Tclock_t7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_t7_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout clock_t7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_t7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_t7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits clock_t8_ParamLimits(TInt aVariety = 0)		{ return (*(Tclock_t8_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_t8_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout clock_t8(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_t8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_t8)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits clock_t9_ParamLimits(TInt aVariety = 0)		{ return (*(Tclock_t9_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_t9_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout clock_t9(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_t9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_t9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits clock_t_Limits()		{ return (*(Tclock_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits clock_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tclock_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout clock_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_clock_analogue_window_cp02(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_analogue_window_cp02_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_cp02)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_clock_digital_window_cp01(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_digital_window_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_digital_window_cp01)))(aVariety, aCol, aRow); }

// LAF Table : main_help_pane
inline TAknWindowComponentLayout listscroll_help_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_help_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_help_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_phob_pane
inline TAknWindowComponentLayout phob_pre_status_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tphob_pre_status_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_phob_pre_status_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_qdial_pane
inline TAknWindowComponentLayout grid_qdial_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_qdial_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_qdial_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_messa_pane
inline TAknWindowComponentLayout listscroll_mce_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_mce_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_mce_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_notes_pane
inline TAknWindowComponentLayout bg_notes_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_notes_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_notes_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_notes_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_notes_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_notes_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp06(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp06_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp06)))(aVariety, aCol, aRow); }

// LAF Table : calc_paper_pane
inline TAknWindowComponentLayout bg_calc_paper_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_calc_paper_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_paper_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_calc_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_calc_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_calc_pane)))(aVariety, aCol, aRow); }

// LAF Table : calc_display_pane
inline TAknWindowComponentLayout bg_calc_display_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_calc_display_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_display_pane)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout calc_display_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcalc_display_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_calc_display_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout calc_display_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcalc_display_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_calc_display_pane_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout calc_display_pane_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcalc_display_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_calc_display_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits calc_display_pane_t_Limits()		{ return (*(Tcalc_display_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_calc_display_pane_t_Limits)))(); }

inline TAknTextComponentLayout calc_display_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcalc_display_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_calc_display_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : grid_calc_pane
inline TAknLayoutScalableParameterLimits cell_calc_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_calc_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_calc_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_calc_pane(TInt aCol, TInt aRow, TInt aVariety = 0)		{ return (*(Tcell_calc_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_calc_pane)))(aCol, aRow, aVariety); }

// LAF Table : bg_calc_paper_pane
inline TAknWindowComponentLayout bg_calc_paper_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_calc_paper_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_paper_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_calc_paper_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_calc_paper_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_paper_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_calc_paper_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_calc_paper_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_paper_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_calc_paper_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_calc_paper_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_paper_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_calc_paper_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_calc_paper_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_paper_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_calc_paper_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_calc_paper_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_paper_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_calc_paper_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_calc_paper_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_paper_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_calc_paper_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_calc_paper_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_paper_pane_g8)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits bg_calc_paper_pane_g_Limits()		{ return (*(Tbg_calc_paper_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_paper_pane_g_Limits)))(); }

inline TAknWindowComponentLayout bg_calc_paper_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_calc_paper_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_paper_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout calc_bg_paper_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcalc_bg_paper_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_calc_bg_paper_pane_g9)))(aVariety, aCol, aRow); }

// LAF Table : list_calc_pane
inline TAknLayoutScalableParameterLimits list_calc_item_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_calc_item_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_calc_item_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_calc_item_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_calc_item_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_calc_item_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_calc_item_pane
inline TAknWindowComponentLayout list_calc_item_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_calc_item_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_calc_item_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_calc_item_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_calc_item_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_calc_item_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_calc_item_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_calc_item_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_calc_item_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_calc_item_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_calc_item_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_calc_item_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_calc_item_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_calc_item_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_calc_item_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_calc_item_pane_t_Limits()		{ return (*(Tlist_calc_item_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_calc_item_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_calc_item_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_calc_item_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_calc_item_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_calc_item_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_calc_item_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_calc_item_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : cell_calc_pane
inline TAknWindowComponentLayout cell_calc_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_calc_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_calc_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_highlight_pane_cp02(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_cp02_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp02)))(aVariety, aCol, aRow); }

// LAF Table : bg_calc_display_pane
inline TAknWindowComponentLayout bg_calc_display_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_calc_display_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_display_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_calc_display_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_calc_display_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_display_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_calc_display_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_calc_display_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_display_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits bg_calc_display_pane_g_Limits()		{ return (*(Tbg_calc_display_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_display_pane_g_Limits)))(); }

inline TAknWindowComponentLayout bg_calc_display_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_calc_display_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_display_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : grid_qdial_pane
inline TAknLayoutScalableParameterLimits cell_qdial_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_qdial_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_qdial_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_qdial_pane(TInt aCol, TInt aRow, TInt aVariety = 0)		{ return (*(Tcell_qdial_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_qdial_pane)))(aCol, aRow, aVariety); }

// LAF Table : cell_qdial_pane
inline TAknLayoutScalableParameterLimits cell_qdial_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_qdial_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_qdial_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_qdial_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_qdial_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_qdial_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_qdial_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_qdial_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_qdial_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_qdial_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_qdial_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_qdial_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_qdial_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_qdial_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_qdial_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_qdial_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_qdial_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_qdial_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_qdial_pane_g_Limits()		{ return (*(Tcell_qdial_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_qdial_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits cell_qdial_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tcell_qdial_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_qdial_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout cell_qdial_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_qdial_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_qdial_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_qdial_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_qdial_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_qdial_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout cell_qdial_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_qdial_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_qdial_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_qdial_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_qdial_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_qdial_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout cell_qdial_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_qdial_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_qdial_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_qdial_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_qdial_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_qdial_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout cell_qdial_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_qdial_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_qdial_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_qdial_pane_t_Limits()		{ return (*(Tcell_qdial_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_qdial_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits cell_qdial_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tcell_qdial_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_qdial_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout cell_qdial_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_qdial_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_qdial_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_highlight_pane_cp04(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_cp04_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp04)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits thumbnail_qdial_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tthumbnail_qdial_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_thumbnail_qdial_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout thumbnail_qdial_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tthumbnail_qdial_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_thumbnail_qdial_pane)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_help_pane
inline TAknWindowComponentLayout list_help_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_help_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_help_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp02(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp02_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp02)))(aVariety, aCol, aRow); }

// LAF Table : list_help_pane
inline TAknLayoutScalableParameterLimits help_list_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Thelp_list_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_help_list_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout help_list_pane_t1(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Thelp_list_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_help_list_pane_t1)))(aRow, aVariety, aCol); }

// LAF Table : bg_notes_pane
inline TAknWindowComponentLayout bg_notes_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_notes_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_notes_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_notes_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_notes_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_notes_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout notes_bg_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnotes_bg_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_notes_bg_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout notes_bg_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnotes_bg_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_notes_bg_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout notes_bg_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnotes_bg_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_notes_bg_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout notes_bg_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnotes_bg_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_notes_bg_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout notes_bg_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnotes_bg_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_notes_bg_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout notes_bg_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnotes_bg_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_notes_bg_pane_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout notes_bg_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnotes_bg_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_notes_bg_pane_g9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits notes_bg_pane_g_Limits()		{ return (*(Tnotes_bg_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_notes_bg_pane_g_Limits)))(); }

inline TAknWindowComponentLayout notes_bg_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnotes_bg_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_notes_bg_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_notes_pane
inline TAknLayoutScalableParameterLimits list_notes_text_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_notes_text_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_notes_text_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_notes_text_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_notes_text_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_notes_text_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_notes_text_pane
inline TAknWindowComponentLayout list_notes_text_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_notes_text_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_notes_text_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout list_notes_text_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_notes_text_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_notes_text_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : main_cale_week_pane
inline TAknWindowComponentLayout listscroll_cale_week_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_cale_week_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_cale_week_pane)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_cale_week_pane
inline TAknWindowComponentLayout bg_cale_heading_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_heading_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_heading_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cale_pane_cp01(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_pane_cp01)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_week_corner_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_corner_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_corner_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_week_day_heading_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_day_heading_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_day_heading_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_week_scroll_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_scroll_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_week_scroll_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_scroll_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_week_scroll_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_scroll_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_week_scroll_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_scroll_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_week_scroll_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_scroll_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_week_scroll_pane_g6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_scroll_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_week_scroll_pane_g7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_scroll_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_week_scroll_pane_g8(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_scroll_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_week_scroll_pane_g9(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_scroll_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g9)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_week_scroll_pane_g10(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_scroll_pane_g10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g10)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_week_scroll_pane_g11(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_scroll_pane_g11_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g11)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_week_scroll_pane_g12(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_scroll_pane_g12_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g12)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_week_scroll_pane_g13(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_scroll_pane_g13_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g13)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_week_scroll_pane_g14(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_scroll_pane_g14_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g14)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_week_scroll_pane_g15(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_scroll_pane_g15_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g15)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cale_week_scroll_pane_g_Limits()		{ return (*(Tcale_week_scroll_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g_Limits)))(); }

inline TAknWindowComponentLayout cale_week_scroll_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_scroll_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_week_time_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_time_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_time_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_cale_week_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_cale_week_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_cale_week_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp08(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp08_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp08)))(aVariety, aCol, aRow); }

// LAF Table : grid_cale_week_pane
inline TAknLayoutScalableParameterLimits cell_cale_week_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_cale_week_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_cale_week_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_cale_week_pane(TInt aCol, TInt aRow, TInt aVariety = 0)		{ return (*(Tcell_cale_week_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_cale_week_pane)))(aCol, aRow, aVariety); }

// LAF Table : cale_week_day_heading_pane
inline TAknTextComponentLayout cale_week_day_heading_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_day_heading_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_day_heading_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cale_week_day_heading_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_day_heading_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_day_heading_pane_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cale_week_day_heading_pane_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_day_heading_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_day_heading_pane_t3)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cale_week_day_heading_pane_t4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_day_heading_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_day_heading_pane_t4)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cale_week_day_heading_pane_t5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_day_heading_pane_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_day_heading_pane_t5)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cale_week_day_heading_pane_t6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_day_heading_pane_t6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_day_heading_pane_t6)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cale_week_day_heading_pane_t7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_day_heading_pane_t7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_day_heading_pane_t7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cale_week_day_heading_pane_t_Limits()		{ return (*(Tcale_week_day_heading_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_day_heading_pane_t_Limits)))(); }

inline TAknTextComponentLayout cale_week_day_heading_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_day_heading_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_day_heading_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : cale_week_time_pane
inline TAknWindowComponentLayout bg_cale_side_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_side_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_side_pane)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cale_week_time_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_time_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_time_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cale_week_time_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_time_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_time_pane_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cale_week_time_pane_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_time_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_time_pane_t3)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cale_week_time_pane_t4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_time_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_time_pane_t4)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cale_week_time_pane_t5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_time_pane_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_time_pane_t5)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cale_week_time_pane_t6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_time_pane_t6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_time_pane_t6)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cale_week_time_pane_t7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_time_pane_t7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_time_pane_t7)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cale_week_time_pane_t8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_time_pane_t8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_time_pane_t8)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cale_week_time_pane_t_Limits()		{ return (*(Tcale_week_time_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_time_pane_t_Limits)))(); }

inline TAknTextComponentLayout cale_week_time_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_week_time_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_time_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : cell_cale_week_pane
inline TAknWindowComponentLayout cell_cale_week_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_cale_week_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_cale_week_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_cale_week_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_cale_week_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_cale_week_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_cale_week_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_cale_week_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_cale_week_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_highlight_pane_cp07(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_cp07_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp07)))(aVariety, aCol, aRow); }

// LAF Table : main_graph_messa_pane
inline TAknWindowComponentLayout listscroll_gms_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_gms_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_gms_pane)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_gms_pane
inline TAknWindowComponentLayout grid_gms_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_gms_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_gms_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout listscroll_gms_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_gms_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_gms_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout listscroll_gms_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_gms_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_gms_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits listscroll_gms_pane_g_Limits()		{ return (*(Tlistscroll_gms_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_gms_pane_g_Limits)))(); }

inline TAknWindowComponentLayout listscroll_gms_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_gms_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_gms_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp010(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp010_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp010)))(aVariety, aCol, aRow); }

// LAF Table : grid_gms_pane
inline TAknLayoutScalableParameterLimits cell_gms_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_gms_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gms_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_gms_pane(TInt aCol, TInt aRow, TInt aVariety = 0)		{ return (*(Tcell_gms_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gms_pane)))(aCol, aRow, aVariety); }

// LAF Table : cell_gms_pane
inline TAknWindowComponentLayout cell_gms_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_gms_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gms_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_gms_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_gms_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gms_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_gms_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_gms_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gms_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_gms_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_gms_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gms_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_gms_pane_g_Limits()		{ return (*(Tcell_gms_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gms_pane_g_Limits)))(); }

inline TAknWindowComponentLayout cell_gms_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_gms_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gms_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_highlight_pane_cp09(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_cp09_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp09)))(aVariety, aCol, aRow); }

// LAF Table : phob_pre_status_pane
inline TAknWindowComponentLayout phob_pre_status_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tphob_pre_status_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_phob_pre_status_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout phob_pre_status_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tphob_pre_status_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_phob_pre_status_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout phob_pre_status_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tphob_pre_status_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_phob_pre_status_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout phob_pre_status_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tphob_pre_status_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_phob_pre_status_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits phob_pre_status_pane_g_Limits()		{ return (*(Tphob_pre_status_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_phob_pre_status_pane_g_Limits)))(); }

inline TAknWindowComponentLayout phob_pre_status_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tphob_pre_status_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_phob_pre_status_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout phob_pre_status_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tphob_pre_status_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_phob_pre_status_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout phob_pre_status_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tphob_pre_status_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_phob_pre_status_pane_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout phob_pre_status_pane_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tphob_pre_status_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_phob_pre_status_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits phob_pre_status_pane_t_Limits()		{ return (*(Tphob_pre_status_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_phob_pre_status_pane_t_Limits)))(); }

inline TAknTextComponentLayout phob_pre_status_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tphob_pre_status_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_phob_pre_status_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_vorec_pane
inline TAknWindowComponentLayout bg_list_pane_cp05(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_list_pane_cp05_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_list_pane_cp05)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_vorec_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_vorec_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_vorec_pane)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout vorec_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvorec_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vorec_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout vorec_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvorec_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vorec_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout vorec_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvorec_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vorec_t3)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout vorec_t4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvorec_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vorec_t4)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout vorec_t5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvorec_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vorec_t5)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout vorec_t6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvorec_t6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vorec_t6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits vorec_t_Limits()		{ return (*(Tvorec_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vorec_t_Limits)))(); }

inline TAknTextComponentLayout vorec_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvorec_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vorec_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wait_bar_pane_cp01(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twait_bar_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_bar_pane_cp01)))(aVariety, aCol, aRow); }

// LAF Table : grid_vorec_pane
inline TAknLayoutScalableParameterLimits cell_vorec_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_vorec_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vorec_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_vorec_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tcell_vorec_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vorec_pane)))(aRow, aVariety, aCol); }

// LAF Table : cell_vorec_pane
inline TAknWindowComponentLayout cell_vorec_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vorec_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vorec_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_highlight_pane_cp05(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_cp05_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp05)))(aVariety, aCol, aRow); }

// LAF Table : main_camera_pane
inline TAknWindowComponentLayout cams_zoom_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcams_zoom_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams_zoom_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout image_vga_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Timage_vga_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_image_vga_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_camera_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_camera_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_camera_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_camera_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_camera_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_camera_pane_g6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_camera_pane_g7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane_g7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_camera_pane_g_Limits()		{ return (*(Tmain_camera_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane_g_Limits)))(); }

inline TAknWindowComponentLayout main_camera_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_camera_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_camera_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_camera_pane_t_Limits()		{ return (*(Tmain_camera_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane_t_Limits)))(); }

inline TAknTextComponentLayout main_camera_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_video_pane
inline TAknLayoutScalableParameterLimits cams_zoom_pane_cp_ParamLimits(TInt aVariety = 0)		{ return (*(Tcams_zoom_pane_cp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams_zoom_pane_cp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cams_zoom_pane_cp(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcams_zoom_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams_zoom_pane_cp)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits image_cif_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Timage_cif_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_image_cif_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout image_cif_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Timage_cif_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_image_cif_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout image_subqcif_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Timage_subqcif_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_image_subqcif_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_video_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_video_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_video_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_video_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_video_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_video_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_video_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_video_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_video_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_video_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_video_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_video_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_video_pane_g5_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_video_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_video_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_video_pane_g6_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_video_pane_g6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_pane_g6_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_video_pane_g6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_pane_g6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_video_pane_g_Limits()		{ return (*(Tmain_video_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_video_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmain_video_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout main_video_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_video_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_video_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_video_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : cams_zoom_pane
inline TAknWindowComponentLayout cams_zoom_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcams_zoom_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams_zoom_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cams_zoom_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcams_zoom_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams_zoom_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cams_zoom_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcams_zoom_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams_zoom_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cams_zoom_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcams_zoom_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams_zoom_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cams_zoom_pane_g_Limits()		{ return (*(Tcams_zoom_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams_zoom_pane_g_Limits)))(); }

inline TAknWindowComponentLayout cams_zoom_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcams_zoom_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams_zoom_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_burst_pane
inline TAknWindowComponentLayout grid_cams_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_cams_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_cams_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout linegrid_cams_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlinegrid_cams_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cams_pane)))(aVariety, aCol, aRow); }

// LAF Table : grid_cams_pane
inline TAknLayoutScalableParameterLimits cell_cams_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_cams_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_cams_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_cams_pane(TInt aVariety, TInt aCol, TInt aRow)		{ return (*(Tcell_cams_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_cams_pane)))(aVariety, aCol, aRow); }

// LAF Table : cell_cams_pane
inline TAknWindowComponentLayout cams_burst_image_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcams_burst_image_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams_burst_image_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_cams_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_cams_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_cams_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_highlight_pane_cp03(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_cp03_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp03)))(aVariety, aCol, aRow); }

// LAF Table : bg_mp_pane
inline TAknWindowComponentLayout mp_bg_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmp_bg_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mp_bg_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : main_mp_pane
inline TAknWindowComponentLayout bg_list_pane_cp03(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_list_pane_cp03_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_list_pane_cp03)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_mp_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_mp_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_mp_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_mp_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_mp_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_mp_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout media_player_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmedia_player_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_media_player_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout media_player_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmedia_player_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_media_player_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout media_player_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmedia_player_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_media_player_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout media_player_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmedia_player_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_media_player_t3)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout media_player_t4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmedia_player_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_media_player_t4)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout media_player_t5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmedia_player_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_media_player_t5)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout media_player_t6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmedia_player_t6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_media_player_t6)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout media_player_t7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmedia_player_t7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_media_player_t7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits media_player_t_Limits()		{ return (*(Tmedia_player_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_media_player_t_Limits)))(); }

inline TAknTextComponentLayout media_player_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmedia_player_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_media_player_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wait_bar_pane_cp02(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twait_bar_pane_cp02_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_bar_pane_cp02)))(aVariety, aCol, aRow); }

// LAF Table : main_usb_pane
inline TAknTextComponentLayout main_usb_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_usb_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_usb_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : grid_mp_pane
inline TAknWindowComponentLayout cell_mp_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_mp_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_mp_pane)))(aVariety, aCol, aRow); }

// LAF Table : cell_mp_pane
inline TAknWindowComponentLayout cell_mp_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_mp_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_mp_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_highlight_pane_cp06(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_cp06_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp06)))(aVariety, aCol, aRow); }

// LAF Table : main_skin_pane
inline TAknWindowComponentLayout grid_skin_colour_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_skin_colour_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_skin_colour_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_highlight_pane_cp03(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_cp03_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp03)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout skin_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tskin_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_skin_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout skin_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tskin_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_skin_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout skin_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tskin_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_skin_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits skin_t_Limits()		{ return (*(Tskin_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_skin_t_Limits)))(); }

inline TAknTextComponentLayout skin_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tskin_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_skin_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : grid_skin_colour_pane
inline TAknLayoutScalableParameterLimits cell_skin_colour_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_skin_colour_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_skin_colour_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_skin_colour_pane(TInt aCol, TInt aRow, TInt aVariety = 0)		{ return (*(Tcell_skin_colour_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_skin_colour_pane)))(aCol, aRow, aVariety); }

// LAF Table : cell_skin_colour_pane
inline TAknWindowComponentLayout cell_skin_colour_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_skin_colour_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_skin_colour_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : main_video_tele_pane
inline TAknLayoutScalableParameterLimits call_video_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcall_video_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_video_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout call_video_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_video_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_video_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits call_video_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tcall_video_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_video_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout call_video_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_video_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_video_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits call_video_g_Limits()		{ return (*(Tcall_video_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_video_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits call_video_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tcall_video_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_video_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout call_video_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_video_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_video_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits call_video_uplink_pane_cp1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcall_video_uplink_pane_cp1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_video_uplink_pane_cp1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout call_video_uplink_pane_cp1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_video_uplink_pane_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_video_uplink_pane_cp1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout call_video_uplink_pane_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_video_uplink_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_video_uplink_pane_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits video_down_crop_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tvideo_down_crop_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_video_down_crop_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout video_down_crop_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvideo_down_crop_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_video_down_crop_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits video_down_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tvideo_down_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_video_down_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout video_down_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvideo_down_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_video_down_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits video_down_subqcif_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tvideo_down_subqcif_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_video_down_subqcif_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout video_down_subqcif_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvideo_down_subqcif_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_video_down_subqcif_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits video_down_subqcif_pane_cp_ParamLimits(TInt aVariety = 0)		{ return (*(Tvideo_down_subqcif_pane_cp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_video_down_subqcif_pane_cp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout video_down_subqcif_pane_cp(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvideo_down_subqcif_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_video_down_subqcif_pane_cp)))(aVariety, aCol, aRow); }

// LAF Table : main_im_pane
inline TAknLayoutScalableParameterLimits im_reading_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tim_reading_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_im_reading_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout im_reading_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tim_reading_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_im_reading_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits im_writing_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tim_writing_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_im_writing_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout im_writing_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tim_writing_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_im_writing_pane)))(aVariety, aCol, aRow); }

// LAF Table : im_reading_pane
inline TAknTextComponentLayout im_reading_pane_t1(TInt aVariety, TInt aRow = 0, TInt aCol = 0)		{ return (*(Tim_reading_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_im_reading_pane_t1)))(aVariety, aRow, aCol); }

inline TAknWindowComponentLayout list_im_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_im_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_im_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp07(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp07_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp07)))(aVariety, aCol, aRow); }

// LAF Table : im_writing_pane
inline TAknLayoutScalableParameterLimits im_writing_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tim_writing_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_im_writing_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout im_writing_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tim_writing_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_im_writing_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits im_writing_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tim_writing_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_im_writing_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout im_writing_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tim_writing_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_im_writing_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits im_writing_pane_t_Limits()		{ return (*(Tim_writing_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_im_writing_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits im_writing_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tim_writing_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_im_writing_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout im_writing_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tim_writing_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_im_writing_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_cp04(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp04_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp04)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_cp05(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp05_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp05)))(aVariety, aCol, aRow); }

// LAF Table : list_im_pane
inline TAknLayoutScalableParameterLimits list_im_single_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_im_single_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_im_single_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_im_single_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_im_single_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_im_single_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_im_single_pane
inline TAknTextComponentLayout list_single_im_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_im_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_im_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : main_location_pane
inline TAknWindowComponentLayout blid_accuracy_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid_accuracy_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid_accuracy_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout blid_compass_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid_compass_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid_compass_pane)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_location_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_location_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_location_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_location_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_location_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_location_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_location_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_location_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_location_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_location_t_Limits()		{ return (*(Tmain_location_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_location_t_Limits)))(); }

inline TAknTextComponentLayout main_location_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_location_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_location_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : blid_accuracy_pane
inline TAknWindowComponentLayout aid_levels_location(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_levels_location_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_levels_location)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout blid_accuracy_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid_accuracy_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid_accuracy_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout blid_accuracy_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid_accuracy_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid_accuracy_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits blid_accuracy_pane_g_Limits()		{ return (*(Tblid_accuracy_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid_accuracy_pane_g_Limits)))(); }

inline TAknWindowComponentLayout blid_accuracy_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid_accuracy_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid_accuracy_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_browser_pane
inline TAknWindowComponentLayout wml_content_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_content_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_content_pane)))(aVariety, aCol, aRow); }

// LAF Table : wml_content_pane
inline TAknLayoutScalableParameterLimits wml_button_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Twml_button_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_button_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout wml_button_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_button_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_button_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits wml_list_single_large_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Twml_list_single_large_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_list_single_large_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout wml_list_single_large_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Twml_list_single_large_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_list_single_large_pane)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits wml_list_single_medium_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Twml_list_single_medium_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_list_single_medium_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout wml_list_single_medium_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Twml_list_single_medium_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_list_single_medium_pane)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits wml_list_single_small_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Twml_list_single_small_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_list_single_small_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout wml_list_single_small_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Twml_list_single_small_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_list_single_small_pane)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits wml_selection_box_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Twml_selection_box_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_selection_box_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout wml_selection_box_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_selection_box_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_selection_box_pane)))(aVariety, aCol, aRow); }

// LAF Table : wml_list_single_small_pane
inline TAknTextComponentLayout wml_list_single_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_list_single_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_list_single_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : wml_list_single_medium_pane
inline TAknTextComponentLayout wml_list_single_medium_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_list_single_medium_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_list_single_medium_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : wml_list_single_large_pane
inline TAknTextComponentLayout wml_list_single_large_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_list_single_large_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_list_single_large_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : wml_selection_box_pane
inline TAknLayoutScalableParameterLimits input_focus_pane_cp02_ParamLimits(TInt aVariety = 0)		{ return (*(Tinput_focus_pane_cp02_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp02_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout input_focus_pane_cp02(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp02_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp02)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wml_selection_box_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_selection_box_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_selection_box_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits wml_selection_box_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Twml_selection_box_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_selection_box_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout wml_selection_box_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_selection_box_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_selection_box_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : wml_button_pane
inline TAknLayoutScalableParameterLimits bg_wml_button_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_wml_button_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_wml_button_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_wml_button_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_wml_button_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_wml_button_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wml_button_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_button_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_button_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout wml_button_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_button_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_button_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : bg_wml_button_pane
inline TAknWindowComponentLayout wml_button_bg_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_button_bg_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_button_bg_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wml_button_bg_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_button_bg_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_button_bg_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wml_button_bg_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_button_bg_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_button_bg_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wml_button_bg_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_button_bg_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_button_bg_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wml_button_bg_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_button_bg_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_button_bg_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wml_button_bg_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_button_bg_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_button_bg_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wml_button_bg_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_button_bg_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_button_bg_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wml_button_bg_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_button_bg_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_button_bg_pane_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wml_button_bg_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_button_bg_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_button_bg_pane_g9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits wml_button_bg_pane_g_Limits()		{ return (*(Twml_button_bg_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_button_bg_pane_g_Limits)))(); }

inline TAknWindowComponentLayout wml_button_bg_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_button_bg_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_button_bg_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : listscroll_mce_pane
inline TAknWindowComponentLayout bg_list_pane_cp02(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_list_pane_cp02_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_list_pane_cp02)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits mce_header_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmce_header_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mce_header_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mce_header_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmce_header_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mce_header_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mce_icon_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmce_icon_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mce_icon_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mce_image_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmce_image_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mce_image_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits mce_text_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmce_text_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mce_text_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mce_text_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmce_text_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mce_text_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp03(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp03_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp03)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp04(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp04_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp04)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits scroll_pane_cp05_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_pane_cp05_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp05_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout scroll_pane_cp05(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp05_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp05)))(aVariety, aCol, aRow); }

// LAF Table : mce_header_pane
inline TAknLayoutScalableParameterLimits mce_header_field_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmce_header_field_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mce_header_field_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mce_header_field_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmce_header_field_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mce_header_field_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits mce_header_field_pane_2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmce_header_field_pane_2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mce_header_field_pane_2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mce_header_field_pane_2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmce_header_field_pane_2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mce_header_field_pane_2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mce_header_field_pane_3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmce_header_field_pane_3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mce_header_field_pane_3)))(aVariety, aCol, aRow); }

// LAF Table : mce_text_pane
inline TAknLayoutScalableParameterLimits list_single_mce_message_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_mce_message_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_mce_message_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_mce_message_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_mce_message_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_mce_message_pane)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_single_mce_smart_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_mce_smart_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_mce_smart_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_mce_smart_pane(TInt aVariety, TInt aRow, TInt aCol = 0)		{ return (*(Tlist_single_mce_smart_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_mce_smart_pane)))(aVariety, aRow, aCol); }

// LAF Table : mce_header_field_pane
inline TAknWindowComponentLayout input_focus_pane_cp03(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp03_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp03)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_header_data_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_header_data_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_header_data_pane)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout mce_header_field_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmce_header_field_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mce_header_field_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : list_header_data_pane
inline TAknLayoutScalableParameterLimits list_single_mce_header_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_mce_header_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_mce_header_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_mce_header_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_mce_header_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_mce_header_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_single_mce_header_pane
inline TAknTextComponentLayout list_single_mce_header_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_mce_header_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_mce_header_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : list_single_mce_message_pane
inline TAknWindowComponentLayout list_single_mce_message_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_mce_message_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_mce_message_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout list_single_mce_message_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_mce_message_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_mce_message_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : main_cale_month_pane
inline TAknLayoutScalableParameterLimits bg_cale_heading_pane_cp01_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_cale_heading_pane_cp01_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_heading_pane_cp01_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_cale_heading_pane_cp01(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_heading_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_heading_pane_cp01)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits bg_cale_pane_cp02_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_cale_pane_cp02_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_pane_cp02_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_cale_pane_cp02(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_pane_cp02_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_pane_cp02)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_month_corner_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_corner_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_corner_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cale_month_day_heading_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_day_heading_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_day_heading_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cale_month_day_heading_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_day_heading_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_day_heading_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cale_month_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cale_month_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cale_month_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cale_month_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cale_month_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cale_month_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cale_month_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cale_month_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cale_month_pane_g5_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cale_month_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cale_month_pane_g6_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_pane_g6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g6_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cale_month_pane_g6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cale_month_pane_g7_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_pane_g7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g7_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cale_month_pane_g7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cale_month_pane_g8_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_pane_g8_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g8_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cale_month_pane_g8(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g8)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cale_month_pane_g9_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_pane_g9_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g9_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cale_month_pane_g9(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cale_month_pane_g10_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_pane_g10_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g10_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cale_month_pane_g10(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_pane_g10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g10)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cale_month_pane_g11_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_pane_g11_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g11_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cale_month_pane_g11(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_pane_g11_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g11)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cale_month_pane_g12_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_pane_g12_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g12_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cale_month_pane_g12(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_pane_g12_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g12)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cale_month_pane_g13_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_pane_g13_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g13_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cale_month_pane_g13(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_pane_g13_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g13)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cale_month_pane_g_Limits()		{ return (*(Tcale_month_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits cale_month_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tcale_month_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout cale_month_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_month_week_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_week_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_week_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_cale_month_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_cale_month_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_cale_month_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_cale_month_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_cale_month_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_cale_month_pane)))(aVariety, aCol, aRow); }

// LAF Table : cale_month_day_heading_pane
inline TAknTextComponentLayout cale_month_day_heading_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_day_heading_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_day_heading_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cale_month_day_heading_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_day_heading_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_day_heading_pane_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cale_month_day_heading_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_day_heading_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_day_heading_pane_t3)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cale_month_day_heading_pane_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_day_heading_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_day_heading_pane_t4)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cale_month_day_heading_pane_t5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_day_heading_pane_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_day_heading_pane_t5)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cale_month_day_heading_pane_t6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_day_heading_pane_t6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_day_heading_pane_t6)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cale_month_day_heading_pane_t7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_day_heading_pane_t7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_day_heading_pane_t7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cale_month_day_heading_pane_t_Limits()		{ return (*(Tcale_month_day_heading_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_day_heading_pane_t_Limits)))(); }

inline TAknTextComponentLayout cale_month_day_heading_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_day_heading_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_day_heading_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : cale_month_week_pane
inline TAknWindowComponentLayout bg_cale_side_pane_cp01(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_side_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_side_pane_cp01)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cale_month_week_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_week_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_week_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cale_month_week_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_week_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_week_pane_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cale_month_week_pane_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_week_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_week_pane_t3)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cale_month_week_pane_t4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_week_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_week_pane_t4)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cale_month_week_pane_t5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_week_pane_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_week_pane_t5)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cale_month_week_pane_t6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_week_pane_t6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_week_pane_t6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cale_month_week_pane_t_Limits()		{ return (*(Tcale_month_week_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_week_pane_t_Limits)))(); }

inline TAknTextComponentLayout cale_month_week_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_week_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_week_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : grid_cale_month_pane
inline TAknLayoutScalableParameterLimits cell_cale_month_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_cale_month_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_cale_month_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_cale_month_pane(TInt aVariety, TInt aCol, TInt aRow)		{ return (*(Tcell_cale_month_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_cale_month_pane)))(aVariety, aCol, aRow); }

// LAF Table : cell_cale_month_pane
inline TAknWindowComponentLayout cell_cale_month_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_cale_month_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_cale_month_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_cale_month_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_cale_month_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_cale_month_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout cell_cale_month_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_cale_month_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_cale_month_pane_t1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_highlight_pane_cp08(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_cp08_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp08)))(aVariety, aCol, aRow); }

// LAF Table : main_smil_pane
inline TAknWindowComponentLayout main_smil_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_smil_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_smil_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout smil_status_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil_status_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil_status_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout smil_text_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil_text_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil_text_pane)))(aVariety, aCol, aRow); }

// LAF Table : bg_popup_call3_rect_pane
inline TAknWindowComponentLayout bg_popup_call3_rect_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call3_rect_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call3_rect_pane_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call3_rect_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call3_rect_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call3_rect_pane_g9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits bg_popup_call3_rect_pane_g_Limits()		{ return (*(Tbg_popup_call3_rect_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call3_rect_pane_g_Limits)))(); }

inline TAknWindowComponentLayout bg_popup_call3_rect_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call3_rect_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call3_rect_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : smil_status_volume_pane
inline TAknWindowComponentLayout smil_status_volume_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil_status_volume_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil_status_volume_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : smil_status_pane
inline TAknTextComponentLayout smil_status_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil_status_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil_status_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : smil_status_volume_pane
inline TAknWindowComponentLayout volume_smil_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_smil_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_smil_pane)))(aVariety, aCol, aRow); }

// LAF Table : smil_text_pane
inline TAknWindowComponentLayout list_smil_text_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_smil_text_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_smil_text_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp011(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp011_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp011)))(aVariety, aCol, aRow); }

// LAF Table : list_smil_text_pane
inline TAknLayoutScalableParameterLimits smil_text_list_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tsmil_text_list_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil_text_list_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout smil_text_list_pane_t1(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tsmil_text_list_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil_text_list_pane_t1)))(aRow, aVariety, aCol); }

// LAF Table : volume_smil_pane
inline TAknLayoutScalableParameterLimits aid_volume_smil_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_volume_smil_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_volume_smil_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_volume_smil(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_volume_smil_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_volume_smil)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout smil_volume_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil_volume_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil_volume_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout smil_volume_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil_volume_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil_volume_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits smil_volume_pane_g_Limits()		{ return (*(Tsmil_volume_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil_volume_pane_g_Limits)))(); }

inline TAknWindowComponentLayout smil_volume_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil_volume_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil_volume_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_cale_day_pane
inline TAknWindowComponentLayout listscroll_cale_day_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_cale_day_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_cale_day_pane)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_cale_day_pane
inline TAknWindowComponentLayout bg_cale_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_cale_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_cale_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp09(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp09_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp09)))(aVariety, aCol, aRow); }

// LAF Table : bg_cale_pane
inline TAknWindowComponentLayout cale_bg_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_bg_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_bg_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_bg_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_bg_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_bg_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_bg_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_bg_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_bg_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_bg_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_bg_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_bg_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_bg_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_bg_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_bg_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_bg_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_bg_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_bg_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_bg_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_bg_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_bg_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_bg_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_bg_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_bg_pane_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cale_bg_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_bg_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_bg_pane_g9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cale_bg_pane_g_Limits()		{ return (*(Tcale_bg_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_bg_pane_g_Limits)))(); }

inline TAknWindowComponentLayout cale_bg_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_bg_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_bg_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_cale_pane
inline TAknLayoutScalableParameterLimits list_cale_time_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_cale_time_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_time_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_cale_time_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_cale_time_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_time_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_cale_time_pane
inline TAknLayoutScalableParameterLimits list_cale_time_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_cale_time_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_time_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_cale_time_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_cale_time_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_time_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_cale_time_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_cale_time_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_time_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_cale_time_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_cale_time_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_time_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_cale_time_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_cale_time_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_time_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_cale_time_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_cale_time_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_time_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_cale_time_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_cale_time_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_time_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_cale_time_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_cale_time_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_time_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_cale_time_pane_g5_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_cale_time_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_time_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_cale_time_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_cale_time_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_time_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_cale_time_pane_g_Limits()		{ return (*(Tlist_cale_time_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_time_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_cale_time_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_cale_time_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_time_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_cale_time_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_cale_time_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_time_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_cale_time_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_cale_time_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_time_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_cale_time_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_cale_time_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_time_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_cale_time_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_cale_time_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_time_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_cale_time_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_cale_time_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_time_pane_t2)))(aVariety, aCol, aRow); }

// LAF Table : compass_pane
inline TAknWindowComponentLayout aid_blid_cardinal_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_blid_cardinal_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_blid_cardinal_pane)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout compass_pane_t4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcompass_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_compass_pane_t4)))(aVariety, aCol, aRow); }

// LAF Table : list_cale_time_pane
inline TAknLayoutScalableParameterLimits list_cale_time_pane_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_cale_time_pane_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_time_pane_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_cale_time_pane_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_cale_time_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_time_pane_t4)))(aVariety, aCol, aRow); }

// LAF Table : compass_pane
inline TAknTextComponentLayout compass_pane_t5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcompass_pane_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_compass_pane_t5)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout compass_pane_t6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcompass_pane_t6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_compass_pane_t6)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout compass_pane_t7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcompass_pane_t7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_compass_pane_t7)))(aVariety, aCol, aRow); }

// LAF Table : navi_pane
inline TAknTextComponentLayout navi_pane_cc_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_cc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_cc_t1)))(aVariety, aCol, aRow); }

// LAF Table : popup_phob_thumbnail_window
inline TAknWindowComponentLayout aid_phob_thumbnail_center_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_phob_thumbnail_center_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_phob_thumbnail_center_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_postcard_pane
inline TAknLayoutScalableParameterLimits main_postcard_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_postcard_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_postcard_pane_g4_ParamLimits)))(aVariety); }

// LAF Table : list_cale_time_pane
inline TAknLayoutScalableTableLimits list_cale_time_pane_t_Limits()		{ return (*(Tlist_cale_time_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_time_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_cale_time_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_cale_time_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_time_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_cale_time_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_cale_time_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_time_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_loc_request_window
inline TAknLayoutScalableParameterLimits bg_popup_window_pane_cp02_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_cp02_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp02_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_cp02(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp02_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp02)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits heading_pane_cp01_ParamLimits(TInt aVariety = 0)		{ return (*(Theading_pane_cp01_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_pane_cp01_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout heading_pane_cp01(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_pane_cp01)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits loc_req_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tloc_req_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_loc_req_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout loc_req_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tloc_req_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_loc_req_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits loc_type_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tloc_type_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_loc_type_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout loc_type_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tloc_type_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_loc_type_pane)))(aVariety, aCol, aRow); }

// LAF Table : loc_type_pane
inline TAknLayoutScalableParameterLimits loc_type_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tloc_type_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_loc_type_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout loc_type_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tloc_type_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_loc_type_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits loc_type_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tloc_type_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_loc_type_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout loc_type_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tloc_type_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_loc_type_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits loc_type_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tloc_type_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_loc_type_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout loc_type_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tloc_type_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_loc_type_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits loc_type_pane_t_Limits()		{ return (*(Tloc_type_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_loc_type_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits loc_type_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tloc_type_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_loc_type_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout loc_type_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tloc_type_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_loc_type_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : loc_req_pane
inline TAknWindowComponentLayout list_loc_req_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_loc_req_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_loc_req_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp012(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp012_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp012)))(aVariety, aCol, aRow); }

// LAF Table : list_loc_req_pane
inline TAknLayoutScalableParameterLimits list_single_loc_request_popup_menu_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_loc_request_popup_menu_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_loc_request_popup_menu_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_loc_request_popup_menu_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_loc_request_popup_menu_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_loc_request_popup_menu_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_single_loc_request_popup_menu_pane
inline TAknLayoutScalableParameterLimits list_single_loc_request_popup_menu_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_loc_request_popup_menu_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_loc_request_popup_menu_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_loc_request_popup_menu_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_loc_request_popup_menu_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_loc_request_popup_menu_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_loc_request_popup_menu_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_loc_request_popup_menu_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_loc_request_popup_menu_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_loc_request_popup_menu_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_loc_request_popup_menu_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_loc_request_popup_menu_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_loc_request_popup_menu_pane_g_Limits()		{ return (*(Tlist_single_loc_request_popup_menu_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_loc_request_popup_menu_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_loc_request_popup_menu_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_loc_request_popup_menu_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_loc_request_popup_menu_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_single_loc_request_popup_menu_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_loc_request_popup_menu_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_loc_request_popup_menu_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_loc_request_popup_menu_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_loc_request_popup_menu_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_loc_request_popup_menu_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_loc_request_popup_menu_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_loc_request_popup_menu_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_loc_request_popup_menu_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : popup_dyc_status_message_window
inline TAknLayoutScalableParameterLimits bg_popup_window_pane_cp03_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_cp03_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp03_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_cp03(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp03_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp03)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits heading_loc_req_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Theading_loc_req_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_loc_req_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout heading_loc_req_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_loc_req_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_loc_req_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_dyc_status_message_window_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_dyc_status_message_window_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_dyc_status_message_window_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_dyc_status_message_window_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_dyc_status_message_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_dyc_status_message_window_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_dyc_status_message_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_dyc_status_message_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_dyc_status_message_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_dyc_status_message_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_dyc_status_message_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_dyc_status_message_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_dyc_status_message_window_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_dyc_status_message_window_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_dyc_status_message_window_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_dyc_status_message_window_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_dyc_status_message_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_dyc_status_message_window_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_dyc_status_message_window_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_dyc_status_message_window_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_dyc_status_message_window_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_dyc_status_message_window_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_dyc_status_message_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_dyc_status_message_window_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_dyc_status_message_window_t_Limits()		{ return (*(Tpopup_dyc_status_message_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_dyc_status_message_window_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_dyc_status_message_window_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_dyc_status_message_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_dyc_status_message_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_dyc_status_message_window_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_dyc_status_message_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_dyc_status_message_window_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : heading_loc_req_pane
inline TAknWindowComponentLayout bg_heading_pane_cp01(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_heading_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_heading_pane_cp01)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout heading_loc_req_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_loc_req_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_loc_req_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout heading_loc_req_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_loc_req_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_loc_req_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout heading_loc_req_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_loc_req_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_loc_req_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits heading_loc_req_pane_g_Limits()		{ return (*(Theading_loc_req_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_loc_req_pane_g_Limits)))(); }

inline TAknWindowComponentLayout heading_loc_req_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_loc_req_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_loc_req_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout heading_loc_req_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_loc_req_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_loc_req_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : popup_cale_events_window
inline TAknLayoutScalableParameterLimits bg_popup_sub_pane_cp01_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_sub_pane_cp01_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp01_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_sub_pane_cp01(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp01)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_cale_events_window_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_cale_events_window_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_events_window_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_cale_events_window_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_cale_events_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_events_window_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_cale_events_window_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_cale_events_window_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_events_window_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_cale_events_window_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_cale_events_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_events_window_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_cale_events_window_g_Limits()		{ return (*(Tpopup_cale_events_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_events_window_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_cale_events_window_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_cale_events_window_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_events_window_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout popup_cale_events_window_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_cale_events_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_events_window_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_cale_events_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_cale_events_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_events_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_cale_events_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_cale_events_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_events_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_cale_events_window_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_cale_events_window_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_events_window_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_cale_events_window_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_cale_events_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_events_window_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_cale_events_window_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_cale_events_window_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_events_window_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_cale_events_window_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_cale_events_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_events_window_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_cale_events_window_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_cale_events_window_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_events_window_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_cale_events_window_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_cale_events_window_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_events_window_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_cale_events_window_t_Limits()		{ return (*(Tpopup_cale_events_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_events_window_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_cale_events_window_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_cale_events_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_events_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_cale_events_window_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_cale_events_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_events_window_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_call_status_window
inline TAknWindowComponentLayout call_type_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_type_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_type_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_call_status_window_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_status_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_status_window_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_call_status_window_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_status_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_status_window_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_call_status_window_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_status_window_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_status_window_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_call_status_window_g_Limits()		{ return (*(Tpopup_call_status_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_status_window_g_Limits)))(); }

inline TAknWindowComponentLayout popup_call_status_window_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_status_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_status_window_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : call_type_pane
inline TAknWindowComponentLayout call_type_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_type_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_type_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout call_type_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_type_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_type_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits call_type_pane_g_Limits()		{ return (*(Tcall_type_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_type_pane_g_Limits)))(); }

inline TAknWindowComponentLayout call_type_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_type_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_type_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_wml_address_window
inline TAknWindowComponentLayout bg_popup_sub_pane_cp02(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp02_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp02)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout listscroll_popup_wml_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_popup_wml_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_wml_pane)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_popup_wml_pane
inline TAknWindowComponentLayout list_wml_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_wml_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_wml_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp013(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp013_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp013)))(aVariety, aCol, aRow); }

// LAF Table : list_wml_pane
inline TAknLayoutScalableParameterLimits list_single_graphic_popup_wml_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_popup_wml_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_wml_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_popup_wml_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_graphic_popup_wml_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_wml_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_single_graphic_popup_wml_pane
inline TAknWindowComponentLayout list_single_graphic_popup_wml_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_popup_wml_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_wml_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_single_graphic_popup_wml_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_popup_wml_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_wml_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_graphic_popup_wml_pane_g_Limits()		{ return (*(Tlist_single_graphic_popup_wml_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_wml_pane_g_Limits)))(); }

inline TAknWindowComponentLayout list_single_graphic_popup_wml_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_popup_wml_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_wml_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout list_single_graphic_popup_wml_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_popup_wml_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_wml_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : popup_clock_analogue_window
inline TAknWindowComponentLayout aid_call_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_call_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_call_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_clock_analogue_window_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_analogue_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_clock_analogue_window_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_analogue_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_clock_analogue_window_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_analogue_window_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_clock_analogue_window_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_analogue_window_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_clock_analogue_window_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_analogue_window_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_clock_analogue_window_g_Limits()		{ return (*(Tpopup_clock_analogue_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_g_Limits)))(); }

inline TAknWindowComponentLayout popup_clock_analogue_window_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_analogue_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_clock_analogue_window_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_analogue_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_t1)))(aVariety, aCol, aRow); }

// LAF Table : popup_clock_digital_window
inline TAknLayoutScalableParameterLimits clock_digital_number_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tclock_digital_number_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout clock_digital_number_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_number_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits clock_digital_number_pane_cp02_ParamLimits(TInt aVariety = 0)		{ return (*(Tclock_digital_number_pane_cp02_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_cp02_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout clock_digital_number_pane_cp02(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_number_pane_cp02_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_cp02)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits clock_digital_number_pane_cp03_ParamLimits(TInt aVariety = 0)		{ return (*(Tclock_digital_number_pane_cp03_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_cp03_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout clock_digital_number_pane_cp03(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_number_pane_cp03_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_cp03)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits clock_digital_number_pane_cp04_ParamLimits(TInt aVariety = 0)		{ return (*(Tclock_digital_number_pane_cp04_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_cp04_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout clock_digital_number_pane_cp04(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_number_pane_cp04_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_cp04)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits clock_digital_separator_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tclock_digital_separator_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_separator_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout clock_digital_separator_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_separator_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_separator_pane)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_clock_digital_window_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_digital_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_digital_window_t1)))(aVariety, aCol, aRow); }

// LAF Table : clock_digital_number_pane
inline TAknWindowComponentLayout clock_digital_number_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_number_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout clock_digital_number_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_number_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits clock_digital_number_pane_g_Limits()		{ return (*(Tclock_digital_number_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_g_Limits)))(); }

inline TAknWindowComponentLayout clock_digital_number_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_number_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : clock_digital_separator_pane
inline TAknWindowComponentLayout clock_digital_separator_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_separator_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_separator_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout clock_digital_separator_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_separator_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_separator_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits clock_digital_separator_pane_g_Limits()		{ return (*(Tclock_digital_separator_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_separator_pane_g_Limits)))(); }

inline TAknWindowComponentLayout clock_digital_separator_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_separator_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_separator_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_grid_large_graphic_window
inline TAknWindowComponentLayout bg_popup_window_pane_cp04(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp04_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp04)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout heading_pane_cp03(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_pane_cp03_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_pane_cp03)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout listscroll_popup_gms_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_popup_gms_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_gms_pane)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_popup_gms_pane
inline TAknWindowComponentLayout grid_large_graphic_popup_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_large_graphic_popup_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_large_graphic_popup_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout listscroll_popup_gms_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_popup_gms_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_gms_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout listscroll_popup_gms_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_popup_gms_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_gms_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits listscroll_popup_gms_pane_g_Limits()		{ return (*(Tlistscroll_popup_gms_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_gms_pane_g_Limits)))(); }

inline TAknWindowComponentLayout listscroll_popup_gms_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_popup_gms_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_gms_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp014(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp014_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp014)))(aVariety, aCol, aRow); }

// LAF Table : grid_large_graphic_popup_pane
inline TAknLayoutScalableParameterLimits cell_large_graphic_popup_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_large_graphic_popup_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_large_graphic_popup_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_large_graphic_popup_pane(TInt aCol, TInt aRow, TInt aVariety = 0)		{ return (*(Tcell_large_graphic_popup_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_large_graphic_popup_pane)))(aCol, aRow, aVariety); }

// LAF Table : cell_large_graphic_popup_pane
inline TAknLayoutScalableParameterLimits cell_large_graphic_popup_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_large_graphic_popup_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_large_graphic_popup_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_large_graphic_popup_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_large_graphic_popup_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_large_graphic_popup_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_large_graphic_popup_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_large_graphic_popup_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_large_graphic_popup_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_large_graphic_popup_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_large_graphic_popup_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_large_graphic_popup_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_large_graphic_popup_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_large_graphic_popup_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_large_graphic_popup_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_large_graphic_popup_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_large_graphic_popup_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_large_graphic_popup_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_large_graphic_popup_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_large_graphic_popup_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_large_graphic_popup_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_large_graphic_popup_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_large_graphic_popup_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_large_graphic_popup_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_large_graphic_popup_pane_g_Limits()		{ return (*(Tcell_large_graphic_popup_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_large_graphic_popup_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits cell_large_graphic_popup_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tcell_large_graphic_popup_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_large_graphic_popup_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout cell_large_graphic_popup_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_large_graphic_popup_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_large_graphic_popup_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_highlight_pane_cp010(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_cp010_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp010)))(aVariety, aCol, aRow); }

// LAF Table : bg_popup_call_pane
inline TAknWindowComponentLayout bg_popup_call_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : list_conf_pane
inline TAknLayoutScalableParameterLimits list_single_graphic_popup_conf_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_popup_conf_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_conf_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_popup_conf_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_graphic_popup_conf_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_conf_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_single_graphic_popup_conf_pane
inline TAknWindowComponentLayout list_highlight_pane_cp01(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp01)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_single_graphic_popup_conf_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_popup_conf_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_conf_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_single_graphic_popup_conf_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_popup_conf_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_conf_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_graphic_popup_conf_pane_g_Limits()		{ return (*(Tlist_single_graphic_popup_conf_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_conf_pane_g_Limits)))(); }

inline TAknWindowComponentLayout list_single_graphic_popup_conf_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_popup_conf_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_conf_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout list_single_graphic_popup_conf_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_popup_conf_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_conf_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : linegrid_cams_pane
inline TAknWindowComponentLayout linegrid_cams_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlinegrid_cams_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cams_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout linegrid_cams_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlinegrid_cams_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cams_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout linegrid_cams_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlinegrid_cams_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cams_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout linegrid_cams_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlinegrid_cams_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cams_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout linegrid_cams_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlinegrid_cams_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cams_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout linegrid_cams_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlinegrid_cams_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cams_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout linegrid_cams_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlinegrid_cams_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cams_pane_g7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits linegrid_cams_pane_g_Limits()		{ return (*(Tlinegrid_cams_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cams_pane_g_Limits)))(); }

inline TAknWindowComponentLayout linegrid_cams_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlinegrid_cams_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cams_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : context_pane
inline TAknWindowComponentLayout popup_clock_analogue_window(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_analogue_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_clock_digital_window(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_digital_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_digital_window)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_phob_thumbnail_window(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_phob_thumbnail_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_phob_thumbnail_window)))(aVariety, aCol, aRow); }

// LAF Table : call_video_uplink_pane
inline TAknWindowComponentLayout call_video_uplink_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_video_uplink_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_video_uplink_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout call_video_uplink_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_video_uplink_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_video_uplink_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits call_video_uplink_pane_g_Limits()		{ return (*(Tcall_video_uplink_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_video_uplink_pane_g_Limits)))(); }

inline TAknWindowComponentLayout call_video_uplink_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_video_uplink_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_video_uplink_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout video_uplink_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvideo_uplink_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_video_uplink_pane)))(aVariety, aCol, aRow); }

// LAF Table : mce_image_pane
inline TAknWindowComponentLayout mce_image_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmce_image_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mce_image_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mce_image_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmce_image_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mce_image_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mce_image_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmce_image_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mce_image_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mce_image_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmce_image_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mce_image_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mce_image_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmce_image_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mce_image_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits mce_image_pane_g_Limits()		{ return (*(Tmce_image_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mce_image_pane_g_Limits)))(); }

inline TAknWindowComponentLayout mce_image_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmce_image_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mce_image_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : stacon_top_pane
inline TAknLayoutScalableParameterLimits control_top_pane_stacon_cp01_ParamLimits(TInt aVariety = 0)		{ return (*(Tcontrol_top_pane_stacon_cp01_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_top_pane_stacon_cp01_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout control_top_pane_stacon_cp01(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_top_pane_stacon_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_top_pane_stacon_cp01)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits uni_indicator_pane_stacon_cp01_ParamLimits(TInt aVariety = 0)		{ return (*(Tuni_indicator_pane_stacon_cp01_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_uni_indicator_pane_stacon_cp01_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout uni_indicator_pane_stacon_cp01(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tuni_indicator_pane_stacon_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_uni_indicator_pane_stacon_cp01)))(aVariety, aCol, aRow); }

// LAF Table : main_chi_dic_pane
inline TAknWindowComponentLayout bg_popup_sub_pane_cp03(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp03_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp03)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout chi_dic_find_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tchi_dic_find_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_chi_dic_find_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout listscroll_chi_dic_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_chi_dic_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_chi_dic_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_pane_chidic_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_pane_chidic_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_chidic_g1)))(aVariety, aCol, aRow); }

// LAF Table : chi_dic_find_pane
inline TAknTextComponentLayout chi_dic_find_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tchi_dic_find_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_chi_dic_find_pane_t1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout find_chidic_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfind_chidic_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_chidic_pane)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_chi_dic_pane
inline TAknLayoutScalableParameterLimits chi_dic_list_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tchi_dic_list_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_chi_dic_list_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout chi_dic_list_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tchi_dic_list_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_chi_dic_list_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp020(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp020_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp020)))(aVariety, aCol, aRow); }

// LAF Table : find_chidic_pane
inline TAknTextComponentLayout find_chidic_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfind_chidic_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_chidic_pane_t1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_cp06(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp06_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp06)))(aVariety, aCol, aRow); }

// LAF Table : chi_dic_list_pane
inline TAknLayoutScalableParameterLimits list_chi_dic_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_chi_dic_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_chi_dic_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_chi_dic_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_chi_dic_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_chi_dic_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_chi_dic_pane
inline TAknLayoutScalableParameterLimits list_chi_dic_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_chi_dic_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_chi_dic_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_chi_dic_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_chi_dic_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_chi_dic_pane_t1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_highlight_pane_cp020(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_cp020_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp020)))(aVariety, aCol, aRow); }

// LAF Table : bg_cale_heading_pane
inline TAknWindowComponentLayout bg_cale_heading_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_heading_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_heading_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cale_heading_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_heading_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_heading_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cale_heading_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_heading_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_heading_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cale_heading_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_heading_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_heading_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cale_heading_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_heading_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_heading_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cale_heading_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_heading_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_heading_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cale_heading_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_heading_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_heading_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cale_heading_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_heading_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_heading_pane_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cale_heading_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_heading_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_heading_pane_g9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits bg_cale_heading_pane_g_Limits()		{ return (*(Tbg_cale_heading_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_heading_pane_g_Limits)))(); }

inline TAknWindowComponentLayout bg_cale_heading_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_heading_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_heading_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : bg_cale_side_pane
inline TAknWindowComponentLayout bg_cale_side_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_side_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_side_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cale_side_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_side_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_side_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cale_side_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_side_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_side_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cale_side_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_side_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_side_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cale_side_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_side_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_side_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cale_side_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_side_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_side_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cale_side_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_side_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_side_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cale_side_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_side_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_side_pane_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cale_side_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_side_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_side_pane_g9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits bg_cale_side_pane_g_Limits()		{ return (*(Tbg_cale_side_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_side_pane_g_Limits)))(); }

inline TAknWindowComponentLayout bg_cale_side_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cale_side_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_side_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : area_top_pane
inline TAknLayoutScalableParameterLimits popup_call_status_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_status_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_status_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call_status_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_status_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_status_window)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout stacon_top_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstacon_top_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_stacon_top_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits status_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tstatus_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout status_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout status_small_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_small_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane)))(aVariety, aCol, aRow); }

// LAF Table : area_bottom_pane
inline TAknWindowComponentLayout control_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout stacon_bottom_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstacon_bottom_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_stacon_bottom_pane)))(aVariety, aCol, aRow); }

// LAF Table : list_single_mce_smart_pane
inline TAknLayoutScalableParameterLimits list_single_mce_smart_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_mce_smart_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_mce_smart_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_mce_smart_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_mce_smart_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_mce_smart_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_mce_smart_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_mce_smart_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_mce_smart_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_mce_smart_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_mce_smart_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_mce_smart_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_mce_smart_pane_t_Limits()		{ return (*(Tlist_single_mce_smart_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_mce_smart_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_mce_smart_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_mce_smart_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_mce_smart_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_single_mce_smart_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_mce_smart_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_mce_smart_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_location2_pane
inline TAknWindowComponentLayout compass_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcompass_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_compass_pane)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_location2_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_location2_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_location2_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_location2_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_location2_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_location2_pane_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_location2_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_location2_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_location2_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_location2_pane_t_Limits()		{ return (*(Tmain_location2_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_location2_pane_t_Limits)))(); }

inline TAknTextComponentLayout main_location2_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_location2_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_location2_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : compass_pane
inline TAknLayoutScalableParameterLimits compass_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcompass_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_compass_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout compass_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcompass_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_compass_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout compass_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcompass_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_compass_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout compass_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcompass_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_compass_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits compass_pane_t_Limits()		{ return (*(Tcompass_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_compass_pane_t_Limits)))(); }

inline TAknTextComponentLayout compass_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcompass_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_compass_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout text_secondary_cp61(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttext_secondary_cp61_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_text_secondary_cp61)))(aVariety, aCol, aRow); }

// LAF Table : navi_pane
inline TAknWindowComponentLayout navi_pane_cams_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_cams_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_cams_g5)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout navi_pane_im_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_im_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_im_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits navi_pane_mp_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tnavi_pane_mp_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_mp_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout navi_pane_mp_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_mp_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_mp_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits navi_pane_mp_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tnavi_pane_mp_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_mp_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout navi_pane_mp_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_mp_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_mp_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits navi_pane_mp_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tnavi_pane_mp_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_mp_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout navi_pane_mp_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_mp_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_mp_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits navi_pane_mp_g_Limits()		{ return (*(Tnavi_pane_mp_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_mp_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits navi_pane_mp_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tnavi_pane_mp_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_mp_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout navi_pane_mp_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_mp_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_mp_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout navi_pane_mp_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_mp_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_mp_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout navi_pane_mp_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_mp_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_mp_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits navi_pane_mp_t_Limits()		{ return (*(Tnavi_pane_mp_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_mp_t_Limits)))(); }

inline TAknTextComponentLayout navi_pane_mp_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_mp_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_mp_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_pane_vt_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_vt_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_vt_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout navi_pane_vt_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_vt_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_vt_t1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_slider_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_slider_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_slider_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout zooming_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tzooming_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_zooming_pane)))(aVariety, aCol, aRow); }

// LAF Table : navi_slider_pane
inline TAknWindowComponentLayout navi_slider_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_slider_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_slider_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_slider_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_slider_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_slider_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits navi_slider_pane_g_Limits()		{ return (*(Tnavi_slider_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_slider_pane_g_Limits)))(); }

inline TAknWindowComponentLayout navi_slider_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_slider_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_slider_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : zooming_pane
inline TAknWindowComponentLayout aid_levels_zoom(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_levels_zoom_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_levels_zoom)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout zooming_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tzooming_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_zooming_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout zooming_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tzooming_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_zooming_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout zooming_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tzooming_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_zooming_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits zooming_pane_g_Limits()		{ return (*(Tzooming_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_zooming_pane_g_Limits)))(); }

inline TAknWindowComponentLayout zooming_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tzooming_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_zooming_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : aid_levels_zoom
inline TAknWindowComponentLayout level_10_zoom(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_10_zoom_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_10_zoom)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_11_zoom(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_11_zoom_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_11_zoom)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_1_zoom(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_1_zoom_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_1_zoom)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_2_zoom(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_2_zoom_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_2_zoom)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_3_zoom(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_3_zoom_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_3_zoom)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_4_zoom(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_4_zoom_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_4_zoom)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_5_zoom(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_5_zoom_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_5_zoom)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_6_zoom(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_6_zoom_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_6_zoom)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_7_zoom(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_7_zoom_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_7_zoom)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_8_zoom(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_8_zoom_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_8_zoom)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_9_zoom(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_9_zoom_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_9_zoom)))(aVariety, aCol, aRow); }

// LAF Table : popup_phob_thumbnail_window
inline TAknWindowComponentLayout popup_phob_thumbnail_window_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_phob_thumbnail_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_phob_thumbnail_window_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_phob_thumbnail_window_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_phob_thumbnail_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_phob_thumbnail_window_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_phob_thumbnail_window_g_Limits()		{ return (*(Tpopup_phob_thumbnail_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_phob_thumbnail_window_g_Limits)))(); }

inline TAknWindowComponentLayout popup_phob_thumbnail_window_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_phob_thumbnail_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_phob_thumbnail_window_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : aid_levels_location
inline TAknWindowComponentLayout level_1_location(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_1_location_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_1_location)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_2_location(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_2_location_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_2_location)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_3_location(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_3_location_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_3_location)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_4_location(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_4_location_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_4_location)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_5_location(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_5_location_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_5_location)))(aVariety, aCol, aRow); }

// LAF Table : mce_icon_pane
inline TAknWindowComponentLayout mce_icon_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmce_icon_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mce_icon_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mce_icon_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmce_icon_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mce_icon_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits mce_icon_pane_g_Limits()		{ return (*(Tmce_icon_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mce_icon_pane_g_Limits)))(); }

inline TAknWindowComponentLayout mce_icon_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmce_icon_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mce_icon_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_mup_pane
inline TAknLayoutScalableParameterLimits main_mup_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_pane_g5_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_pane_g6_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_pane_g6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g6_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup_pane_g6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_pane_g7_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_pane_g7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g7_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup_pane_g7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_pane_g8_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_pane_g8_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g8_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup_pane_g8(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g8)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_pane_g9_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_pane_g9_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g9_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup_pane_g9(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_pane_g10_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_pane_g10_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g10_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup_pane_g10(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_pane_g10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g10)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_pane_g11_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_pane_g11_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g11_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup_pane_g11(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_pane_g11_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g11)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_pane_g12_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_pane_g12_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g12_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup_pane_g12(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_pane_g12_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g12)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_pane_g13_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_pane_g13_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g13_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup_pane_g13(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_pane_g13_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g13)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_mup_pane_g_Limits()		{ return (*(Tmain_mup_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_mup_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmain_mup_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout main_mup_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_pane_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_pane_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup_pane_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_pane_t5_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_pane_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_t5_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup_pane_t5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_pane_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_t5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_pane_t6_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_pane_t6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_t6_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup_pane_t6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_pane_t6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_t6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_mup_pane_t_Limits()		{ return (*(Tmain_mup_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_mup_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmain_mup_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout main_mup_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits mup_progress_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup_progress_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_progress_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup_progress_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_progress_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_progress_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits mup_visualizer_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup_visualizer_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_visualizer_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup_visualizer_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_visualizer_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_visualizer_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits mup_volume_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup_volume_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_volume_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup_volume_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_volume_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_volume_pane)))(aVariety, aCol, aRow); }

// LAF Table : mup_visualizer_pane
inline TAknLayoutScalableParameterLimits mup_visualizer_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup_visualizer_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_visualizer_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup_visualizer_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_visualizer_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_visualizer_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits mup_visualizer_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup_visualizer_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_visualizer_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup_visualizer_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_visualizer_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_visualizer_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits mup_visualizer_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup_visualizer_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_visualizer_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup_visualizer_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_visualizer_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_visualizer_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits mup_visualizer_pane_g_Limits()		{ return (*(Tmup_visualizer_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_visualizer_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits mup_visualizer_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmup_visualizer_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_visualizer_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout mup_visualizer_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_visualizer_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_visualizer_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : mup_volume_pane
inline TAknWindowComponentLayout mup_volume_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_volume_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_volume_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup_volume_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_volume_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_volume_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits mup_volume_pane_g_Limits()		{ return (*(Tmup_volume_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_volume_pane_g_Limits)))(); }

inline TAknWindowComponentLayout mup_volume_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_volume_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_volume_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : mup_progress_pane
inline TAknWindowComponentLayout mup_progress_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_progress_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_progress_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup_progress_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_progress_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_progress_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup_progress_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_progress_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_progress_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits mup_progress_pane_g_Limits()		{ return (*(Tmup_progress_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_progress_pane_g_Limits)))(); }

inline TAknWindowComponentLayout mup_progress_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_progress_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_progress_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_blid_sat_info_window
inline TAknWindowComponentLayout bg_popup_window_pane_cp05(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp05_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp05)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits heading_pane_cp02_ParamLimits(TInt aVariety = 0)		{ return (*(Theading_pane_cp02_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_pane_cp02_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout heading_pane_cp02(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_pane_cp02_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_pane_cp02)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_popup_blid_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_popup_blid_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_popup_blid_pane)))(aVariety, aCol, aRow); }

// LAF Table : list_popup_blid_pane
inline TAknLayoutScalableParameterLimits list_blid_sat_info_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_blid_sat_info_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_blid_sat_info_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_blid_sat_info_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_blid_sat_info_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_blid_sat_info_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_blid_sat_info_pane
inline TAknWindowComponentLayout list_blid_sat_info_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_blid_sat_info_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_blid_sat_info_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout list_blid_sat_info_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_blid_sat_info_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_blid_sat_info_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : main_mup_eq_pane
inline TAknLayoutScalableParameterLimits mup_equalizer_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup_equalizer_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_equalizer_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup_equalizer_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_equalizer_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_equalizer_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits mup_equalizer_pane_cp1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup_equalizer_pane_cp1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_equalizer_pane_cp1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup_equalizer_pane_cp1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_equalizer_pane_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_equalizer_pane_cp1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits mup_equalizer_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup_equalizer_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_equalizer_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup_equalizer_pane_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_equalizer_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_equalizer_pane_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits mup_equalizer_pane_cp3_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup_equalizer_pane_cp3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_equalizer_pane_cp3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup_equalizer_pane_cp3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_equalizer_pane_cp3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_equalizer_pane_cp3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits mup_equalizer_pane_cp4_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup_equalizer_pane_cp4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_equalizer_pane_cp4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup_equalizer_pane_cp4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_equalizer_pane_cp4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_equalizer_pane_cp4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup_equalizer_pane_cp5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_equalizer_pane_cp5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_equalizer_pane_cp5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup_equalizer_pane_cp6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_equalizer_pane_cp6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_equalizer_pane_cp6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup_equalizer_pane_cp7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_equalizer_pane_cp7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_equalizer_pane_cp7)))(aVariety, aCol, aRow); }

// LAF Table : bg_popup_call_poc_act_pane
inline TAknWindowComponentLayout bg_popup_call_poc_act_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_poc_act_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_act_pane_g9)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call_poc_act_pane_g10(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_poc_act_pane_g10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_act_pane_g10)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call_poc_act_pane_g11(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_poc_act_pane_g11_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_act_pane_g11)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits bg_popup_call_poc_act_pane_g_Limits()		{ return (*(Tbg_popup_call_poc_act_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_act_pane_g_Limits)))(); }

// LAF Table : mup_equalizer_pane
inline TAknWindowComponentLayout mup_scale_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_scale_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_scale_pane)))(aVariety, aCol, aRow); }

// LAF Table : mup_scale_pane
inline TAknWindowComponentLayout mup_scale_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_scale_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_scale_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup_scale_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_scale_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_scale_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits mup_scale_pane_g_Limits()		{ return (*(Tmup_scale_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_scale_pane_g_Limits)))(); }

inline TAknWindowComponentLayout mup_scale_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_scale_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_scale_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_msg_pane
inline TAknWindowComponentLayout msg_data_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmsg_data_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_data_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp017(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp017_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp017)))(aVariety, aCol, aRow); }

// LAF Table : msg_data_pane
inline TAknLayoutScalableParameterLimits bg_list_pane_cp04_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_list_pane_cp04_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_list_pane_cp04_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_list_pane_cp04(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_list_pane_cp04_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_list_pane_cp04)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout msg_data_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmsg_data_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_data_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout msg_data_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmsg_data_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_data_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout msg_data_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmsg_data_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_data_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout msg_data_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmsg_data_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_data_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout msg_data_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmsg_data_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_data_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout msg_data_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmsg_data_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_data_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout msg_data_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmsg_data_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_data_pane_g7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits msg_data_pane_g_Limits()		{ return (*(Tmsg_data_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_data_pane_g_Limits)))(); }

inline TAknWindowComponentLayout msg_data_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmsg_data_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_data_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits msg_text_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmsg_text_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_text_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout msg_text_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tmsg_text_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_text_pane)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits qrid_highlight_pane_cp011_ParamLimits(TInt aVariety = 0)		{ return (*(Tqrid_highlight_pane_cp011_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_qrid_highlight_pane_cp011_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout qrid_highlight_pane_cp011(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tqrid_highlight_pane_cp011_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_qrid_highlight_pane_cp011)))(aVariety, aCol, aRow); }

// LAF Table : msg_text_pane
inline TAknWindowComponentLayout msg_body_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmsg_body_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_body_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout msg_header_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmsg_header_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_header_pane)))(aVariety, aCol, aRow); }

// LAF Table : msg_header_pane
inline TAknWindowComponentLayout input_focus_pane_cp07(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp07_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp07)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits msg_header_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmsg_header_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_header_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout msg_header_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmsg_header_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_header_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits msg_header_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmsg_header_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_header_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout msg_header_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmsg_header_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_header_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits msg_header_pane_t_Limits()		{ return (*(Tmsg_header_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_header_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits msg_header_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmsg_header_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_header_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout msg_header_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmsg_header_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_header_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : msg_body_pane
inline TAknWindowComponentLayout msg_body_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmsg_body_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_body_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits msg_body_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmsg_body_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_body_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout msg_body_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmsg_body_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_body_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits msg_body_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmsg_body_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_body_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout msg_body_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmsg_body_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_body_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits msg_body_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tmsg_body_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_body_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout msg_body_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmsg_body_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_body_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits msg_body_pane_t_Limits()		{ return (*(Tmsg_body_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_body_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits msg_body_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmsg_body_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_body_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout msg_body_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmsg_body_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_body_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_viewer_pane
inline TAknLayoutScalableParameterLimits main_viewer_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_viewer_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_viewer_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_viewer_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_viewer_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_viewer_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_viewer_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_viewer_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_viewer_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_viewer_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_viewer_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_viewer_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_viewer_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_viewer_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_viewer_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_viewer_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_viewer_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_viewer_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_viewer_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_viewer_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_viewer_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_viewer_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_viewer_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_viewer_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_viewer_pane_g5_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_viewer_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_viewer_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_viewer_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_viewer_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_viewer_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_viewer_pane_g7_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_viewer_pane_g7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_viewer_pane_g7_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_viewer_pane_g7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_viewer_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_viewer_pane_g7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_viewer_pane_g8_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_viewer_pane_g8_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_viewer_pane_g8_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_viewer_pane_g8(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_viewer_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_viewer_pane_g8)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_viewer_pane_g_Limits()		{ return (*(Tmain_viewer_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_viewer_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_viewer_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmain_viewer_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_viewer_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout main_viewer_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_viewer_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_viewer_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits viewer_content_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tviewer_content_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_viewer_content_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout viewer_content_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tviewer_content_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_viewer_content_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_postcard_pane
inline TAknLayoutScalableParameterLimits main_postcard_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_postcard_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_postcard_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_postcard_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_postcard_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_postcard_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_postcard_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_postcard_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_postcard_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_postcard_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_postcard_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_postcard_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_postcard_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_postcard_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_postcard_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_postcard_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_postcard_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_postcard_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_postcard_pane_g_Limits()		{ return (*(Tmain_postcard_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_postcard_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_postcard_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmain_postcard_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_postcard_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout main_postcard_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_postcard_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_postcard_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_postcard_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_postcard_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_postcard_pane_g4)))(aVariety, aCol, aRow); }

// LAF Table : smil_status_volume_pane
inline TAknWindowComponentLayout smil_status_volume_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil_status_volume_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil_status_volume_pane_g2)))(aVariety, aCol, aRow); }

// LAF Table : main_postcard_pane
inline TAknLayoutScalableParameterLimits postcard_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tpostcard_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout postcard_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpostcard_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_pane)))(aVariety, aCol, aRow); }

// LAF Table : postcard_pane
inline TAknLayoutScalableParameterLimits postcard_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpostcard_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout postcard_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpostcard_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits postcard_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpostcard_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout postcard_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpostcard_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits postcard_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpostcard_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout postcard_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpostcard_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits postcard_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tpostcard_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout postcard_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpostcard_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits postcard_pane_g5_ParamLimits(TInt aVariety = 0)		{ return (*(Tpostcard_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout postcard_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpostcard_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits postcard_pane_g6_ParamLimits(TInt aVariety = 0)		{ return (*(Tpostcard_pane_g6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_pane_g6_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout postcard_pane_g6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpostcard_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_pane_g6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits postcard_pane_g7_ParamLimits(TInt aVariety = 0)		{ return (*(Tpostcard_pane_g7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_pane_g7_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout postcard_pane_g7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpostcard_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_pane_g7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits postcard_pane_g_Limits()		{ return (*(Tpostcard_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits postcard_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpostcard_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout postcard_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpostcard_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_mp2_pane
inline TAknLayoutScalableParameterLimits main_mp2_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mp2_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp2_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mp2_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp2_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp2_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mp2_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mp2_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp2_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mp2_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp2_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp2_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mp2_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mp2_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp2_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mp2_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp2_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp2_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_mp2_pane_g_Limits()		{ return (*(Tmain_mp2_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp2_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_mp2_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmain_mp2_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp2_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout main_mp2_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp2_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp2_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mp2_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mp2_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp2_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mp2_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp2_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp2_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mp2_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mp2_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp2_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mp2_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp2_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp2_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mp2_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mp2_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp2_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mp2_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp2_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp2_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_mp2_pane_t_Limits()		{ return (*(Tmain_mp2_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp2_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_mp2_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmain_mp2_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp2_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout main_mp2_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp2_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp2_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_pec_pane
inline TAknLayoutScalableParameterLimits pec_content_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tpec_content_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_pec_content_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout pec_content_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpec_content_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_pec_content_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp015(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp015_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp015)))(aVariety, aCol, aRow); }

// LAF Table : pec_content_pane
inline TAknLayoutScalableParameterLimits pec_attribute_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tpec_attribute_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_pec_attribute_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout pec_attribute_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpec_attribute_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_pec_attribute_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits pec_content_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpec_content_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_pec_content_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout pec_content_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpec_content_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_pec_content_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits pec_content_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpec_content_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_pec_content_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout pec_content_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpec_content_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_pec_content_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits pec_content_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpec_content_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_pec_content_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout pec_content_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpec_content_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_pec_content_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits pec_content_pane_t_Limits()		{ return (*(Tpec_content_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_pec_content_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits pec_content_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpec_content_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_pec_content_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout pec_content_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpec_content_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_pec_content_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : pec_attribute_pane
inline TAknLayoutScalableParameterLimits list_single_graphic_pane_cp01_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_pane_cp01_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_cp01_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_pane_cp01(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_graphic_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_cp01)))(aRow, aVariety, aCol); }

// LAF Table : popup_mup_playback_window
inline TAknWindowComponentLayout bg_popup_sub_pane_cp04(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp04_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp04)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_mup_playback_window_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_mup_playback_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_mup_playback_window_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_mup_playback_window_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_mup_playback_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_mup_playback_window_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_mup_playback_window_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_mup_playback_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_mup_playback_window_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_mup_playback_window_t_Limits()		{ return (*(Tpopup_mup_playback_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_mup_playback_window_t_Limits)))(); }

inline TAknTextComponentLayout popup_mup_playback_window_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_mup_playback_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_mup_playback_window_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_image_pane
inline TAknLayoutScalableParameterLimits main_image_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_image_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_image_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_image_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits scroll_pane_cp018_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_pane_cp018_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp018_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout scroll_pane_cp018(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp018_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp018)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits scroll_pane_cp016_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_pane_cp016_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp016_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout scroll_pane_cp016(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp016_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp016)))(aVariety, aCol, aRow); }

// LAF Table : main_smil2_pane
inline TAknLayoutScalableParameterLimits smil2_image_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tsmil2_image_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil2_image_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout smil2_image_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil2_image_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil2_image_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits smil2_root_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tsmil2_root_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil2_root_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout smil2_root_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil2_root_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil2_root_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits smil2_text_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tsmil2_text_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil2_text_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout smil2_text_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil2_text_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil2_text_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_fmradio_pane
inline TAknWindowComponentLayout bg_list_pane_cp06(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_list_pane_cp06_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_list_pane_cp06)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_radio_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_radio_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_radio_pane)))(aVariety, aCol, aRow); }

// LAF Table : popup_cale_lunar_info_window
inline TAknWindowComponentLayout bg_popup_window_pane_cp06(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp06_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp06)))(aVariety, aCol, aRow); }

// LAF Table : main_fmradio_pane
inline TAknTextComponentLayout main_fmradio_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_fmradio_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_fmradio_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : popup_cale_lunar_info_window
inline TAknWindowComponentLayout heading_pane_cp04(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_pane_cp04_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_pane_cp04)))(aVariety, aCol, aRow); }

// LAF Table : main_fmradio_pane
inline TAknTextComponentLayout main_fmradio_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_fmradio_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_fmradio_pane_t2)))(aVariety, aCol, aRow); }

// LAF Table : popup_cale_lunar_info_window
inline TAknWindowComponentLayout popup_cale_lunar_info_window_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_cale_lunar_info_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_lunar_info_window_g1)))(aVariety, aCol, aRow); }

// LAF Table : main_fmradio_pane
inline TAknTextComponentLayout main_fmradio_pane_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_fmradio_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_fmradio_pane_t3)))(aVariety, aCol, aRow); }

// LAF Table : popup_cale_lunar_info_window
inline TAknWindowComponentLayout popup_cale_lunar_info_window_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_cale_lunar_info_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_lunar_info_window_g2)))(aVariety, aCol, aRow); }

// LAF Table : main_fmradio_pane
inline TAknTextComponentLayout main_fmradio_pane_t4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_fmradio_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_fmradio_pane_t4)))(aVariety, aCol, aRow); }

// LAF Table : popup_cale_lunar_info_window
inline TAknLayoutScalableTableLimits popup_cale_lunar_info_window_g_Limits()		{ return (*(Tpopup_cale_lunar_info_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_lunar_info_window_g_Limits)))(); }

// LAF Table : main_fmradio_pane
inline TAknTextComponentLayout main_fmradio_pane_t5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_fmradio_pane_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_fmradio_pane_t5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_fmradio_pane_t_Limits()		{ return (*(Tmain_fmradio_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_fmradio_pane_t_Limits)))(); }

// LAF Table : popup_cale_lunar_info_window
inline TAknWindowComponentLayout popup_cale_lunar_info_window_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_cale_lunar_info_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_lunar_info_window_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_fmradio_pane
inline TAknTextComponentLayout main_fmradio_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_fmradio_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_fmradio_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wait_bar_pane_cp03(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twait_bar_pane_cp03_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_bar_pane_cp03)))(aVariety, aCol, aRow); }

// LAF Table : grid_radio_pane
inline TAknLayoutScalableParameterLimits cell_fmradio_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_fmradio_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_fmradio_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_fmradio_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tcell_fmradio_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_fmradio_pane)))(aRow, aVariety, aCol); }

// LAF Table : cell_fmradio_pane
inline TAknLayoutScalableParameterLimits cell_fmradio_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_fmradio_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_fmradio_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_fmradio_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_fmradio_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_fmradio_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_highlight_pane_cp011(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_cp011_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp011)))(aVariety, aCol, aRow); }

// LAF Table : main_call_poc_pane
inline TAknLayoutScalableParameterLimits poc_content_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tpoc_content_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_poc_content_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout poc_content_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpoc_content_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_poc_content_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp019(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp019_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp019)))(aVariety, aCol, aRow); }

// LAF Table : poc_content_pane
inline TAknLayoutScalableParameterLimits popup_call_poc_act_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_poc_act_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_poc_act_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call_poc_act_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_poc_act_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_poc_act_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_poc_inact_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_poc_inact_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_poc_inact_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call_poc_inact_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_poc_inact_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_poc_inact_window)))(aVariety, aCol, aRow); }

// LAF Table : bg_popup_call_poc_act_pane
inline TAknWindowComponentLayout bg_popup_call_poc_act_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_poc_act_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_act_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : bg_popup_call_poc_inact_pane
inline TAknWindowComponentLayout bg_popup_call_poc_inact_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_poc_inact_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_inact_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call_poc_inact_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_poc_inact_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_inact_pane_g2)))(aVariety, aCol, aRow); }

// LAF Table : popup_call_poc_act_window
inline TAknWindowComponentLayout popup_call_poc_act_window_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_poc_act_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_poc_act_window_g2)))(aVariety, aCol, aRow); }

// LAF Table : bg_popup_call_poc_inact_pane
inline TAknWindowComponentLayout bg_popup_call_poc_inact_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_poc_inact_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_inact_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call_poc_inact_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_poc_inact_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_inact_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call_poc_inact_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_poc_inact_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_inact_pane_g5)))(aVariety, aCol, aRow); }

// LAF Table : popup_call_poc_act_window
inline TAknLayoutScalableParameterLimits popup_call_poc_act_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_poc_act_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_poc_act_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call_poc_act_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_poc_act_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_poc_act_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_poc_act_window_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_poc_act_window_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_poc_act_window_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call_poc_act_window_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_poc_act_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_poc_act_window_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_poc_act_window_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_poc_act_window_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_poc_act_window_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call_poc_act_window_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_poc_act_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_poc_act_window_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_poc_act_window_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_poc_act_window_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_poc_act_window_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call_poc_act_window_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_poc_act_window_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_poc_act_window_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_call_poc_act_window_t_Limits()		{ return (*(Tpopup_call_poc_act_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_poc_act_window_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_call_poc_act_window_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_call_poc_act_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_poc_act_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_call_poc_act_window_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_poc_act_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_poc_act_window_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : bg_popup_call_poc_inact_pane
inline TAknWindowComponentLayout bg_popup_call_poc_inact_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_poc_inact_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_inact_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call_poc_inact_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_poc_inact_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_inact_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call_poc_inact_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_poc_inact_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_inact_pane_g8)))(aVariety, aCol, aRow); }

// LAF Table : popup_call_poc_inact_window
inline TAknWindowComponentLayout popup_call_poc_inact_window_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_poc_inact_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_poc_inact_window_g2)))(aVariety, aCol, aRow); }

// LAF Table : bg_popup_call_poc_inact_pane
inline TAknWindowComponentLayout bg_popup_call_poc_inact_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_poc_inact_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_inact_pane_g9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits bg_popup_call_poc_inact_pane_g_Limits()		{ return (*(Tbg_popup_call_poc_inact_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_inact_pane_g_Limits)))(); }

inline TAknWindowComponentLayout bg_popup_call_poc_inact_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_poc_inact_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_inact_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_call_poc_inact_window
inline TAknLayoutScalableParameterLimits popup_call_poc_inact_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_poc_inact_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_poc_inact_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call_poc_inact_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_poc_inact_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_poc_inact_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_poc_inact_window_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_poc_inact_window_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_poc_inact_window_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call_poc_inact_window_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_poc_inact_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_poc_inact_window_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call_poc_inact_window_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_poc_inact_window_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_poc_inact_window_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call_poc_inact_window_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_poc_inact_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_poc_inact_window_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_call_poc_inact_window_t_Limits()		{ return (*(Tpopup_call_poc_inact_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_poc_inact_window_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_call_poc_inact_window_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_call_poc_inact_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_poc_inact_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_call_poc_inact_window_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call_poc_inact_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_poc_inact_window_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : status_pane
inline TAknLayoutScalableParameterLimits context_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcontext_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_context_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits signal_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tsignal_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_signal_pane_ParamLimits)))(aVariety); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_call2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_call2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_call2_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_phob_thumbnail2_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_phob_thumbnail2_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_phob_thumbnail2_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_phob_thumbnail2_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_phob_thumbnail2_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_phob_thumbnail2_window)))(aVariety, aCol, aRow); }

// LAF Table : main_viewer_pane
inline TAknWindowComponentLayout aid_hotspot_pointer_arrow_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_hotspot_pointer_arrow_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_hotspot_pointer_arrow_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout aid_hotspot_pointer_hand_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_hotspot_pointer_hand_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_hotspot_pointer_hand_pane)))(aVariety, aCol, aRow); }

// LAF Table : phob_pre_status_pane
inline TAknWindowComponentLayout phob_pre_status_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tphob_pre_status_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_phob_pre_status_pane_g5)))(aVariety, aCol, aRow); }

// LAF Table : main_camera_pane
inline TAknLayoutScalableParameterLimits cams_zoom_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcams_zoom_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams_zoom_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits image_vga_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Timage_vga_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_image_vga_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits main_camera_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_camera_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane_g1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits main_camera_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_camera_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane_g2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits main_camera_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_camera_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane_g3_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits main_camera_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_camera_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane_g4_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits main_camera_pane_g5_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_camera_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane_g5_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits main_camera_pane_g6_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_camera_pane_g6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane_g6_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits main_camera_pane_g7_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_camera_pane_g7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane_g7_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits main_camera_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmain_camera_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknLayoutScalableParameterLimits main_camera_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_camera_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane_t1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits main_camera_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_camera_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane_t2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits main_camera_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmain_camera_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane_t_ParamLimits)))(aLineIndex, aVariety); }

// LAF Table : popup_phob_thumbnail2_window
inline TAknLayoutScalableParameterLimits bg_popup_preview_window_pane_cp01_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_preview_window_pane_cp01_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_preview_window_pane_cp01_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_preview_window_pane_cp01(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_preview_window_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_preview_window_pane_cp01)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_phob_thumbnail2_window_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_phob_thumbnail2_window_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_phob_thumbnail2_window_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_phob_thumbnail2_window_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_phob_thumbnail2_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_phob_thumbnail2_window_g1)))(aVariety, aCol, aRow); }

// LAF Table : main_call2_pane
inline TAknWindowComponentLayout call2_cli_visual_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall2_cli_visual_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call2_cli_visual_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_conf_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_conf_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_conf_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call2_audio_conf_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_conf_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_conf_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_first_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_first_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_first_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call2_audio_first_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_first_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_first_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_in_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_in_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call2_audio_in_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_in_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_out_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_out_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call2_audio_out_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_out_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_second_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_second_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_second_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call2_audio_second_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_second_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_second_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_wait_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_wait_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_wait_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call2_audio_wait_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_wait_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_wait_window)))(aVariety, aCol, aRow); }

// LAF Table : popup_call2_audio_conf_window
inline TAknWindowComponentLayout bg_popup_call2_act_pane_cp03(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_act_pane_cp03_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_act_pane_cp03)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_conf_pane_cp(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_conf_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_conf_pane_cp)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_call2_audio_conf_window_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_conf_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_conf_window_t1)))(aVariety, aCol, aRow); }

// LAF Table : list_conf_pane_cp
inline TAknLayoutScalableParameterLimits list_single_graphic_popup_conf2_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_popup_conf2_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_conf2_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_popup_conf2_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_graphic_popup_conf2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_conf2_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_single_graphic_popup_conf2_pane
inline TAknWindowComponentLayout list_highlight_pane_cp04(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_cp04_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp04)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_single_graphic_popup_conf2_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_popup_conf2_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_conf2_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_single_graphic_popup_conf2_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_popup_conf2_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_conf2_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_graphic_popup_conf2_pane_g_Limits()		{ return (*(Tlist_single_graphic_popup_conf2_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_conf2_pane_g_Limits)))(); }

inline TAknWindowComponentLayout list_single_graphic_popup_conf2_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_popup_conf2_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_conf2_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout list_single_graphic_popup_conf2_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_popup_conf2_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_conf2_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : popup_call2_audio_second_window
inline TAknLayoutScalableParameterLimits bg_popup_call2_act_pane_cp01_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_call2_act_pane_cp01_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_act_pane_cp01_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_call2_act_pane_cp01(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_act_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_act_pane_cp01)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits call_type_pane_cp05_ParamLimits(TInt aVariety = 0)		{ return (*(Tcall_type_pane_cp05_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_type_pane_cp05_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout call_type_pane_cp05(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_type_pane_cp05_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_type_pane_cp05)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_second_window_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_second_window_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_second_window_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call2_audio_second_window_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_second_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_second_window_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_second_window_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_second_window_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_second_window_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call2_audio_second_window_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_second_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_second_window_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_call2_audio_second_window_g_Limits()		{ return (*(Tpopup_call2_audio_second_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_second_window_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_second_window_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_second_window_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_second_window_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout popup_call2_audio_second_window_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_second_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_second_window_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_second_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_second_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_second_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call2_audio_second_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_second_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_second_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_second_window_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_second_window_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_second_window_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call2_audio_second_window_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_second_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_second_window_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_second_window_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_second_window_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_second_window_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call2_audio_second_window_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_second_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_second_window_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_call2_audio_second_window_t_Limits()		{ return (*(Tpopup_call2_audio_second_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_second_window_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_second_window_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_second_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_second_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_call2_audio_second_window_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_second_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_second_window_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_call2_audio_wait_window
inline TAknWindowComponentLayout bg_popup_call2_in_pane_cp02(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_in_pane_cp02_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_in_pane_cp02)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout call_type_pane_cp04(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_type_pane_cp04_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_type_pane_cp04)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_call2_audio_wait_window_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_wait_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_wait_window_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_call2_audio_wait_window_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_wait_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_wait_window_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_call2_audio_wait_window_g_Limits()		{ return (*(Tpopup_call2_audio_wait_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_wait_window_g_Limits)))(); }

inline TAknWindowComponentLayout popup_call2_audio_wait_window_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_wait_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_wait_window_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_call2_audio_wait_window_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_wait_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_wait_window_t3)))(aVariety, aCol, aRow); }

// LAF Table : popup_call2_audio_first_window
inline TAknLayoutScalableParameterLimits bg_popup_call2_act_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_call2_act_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_act_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_call2_act_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_act_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_act_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits call_type_pane_cp03_ParamLimits(TInt aVariety = 0)		{ return (*(Tcall_type_pane_cp03_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_type_pane_cp03_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout call_type_pane_cp03(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_type_pane_cp03_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_type_pane_cp03)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_first_window_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_first_window_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_first_window_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call2_audio_first_window_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_first_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_first_window_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_first_window_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_first_window_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_first_window_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call2_audio_first_window_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_first_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_first_window_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_first_window_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_first_window_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_first_window_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call2_audio_first_window_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_first_window_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_first_window_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_call2_audio_first_window_g_Limits()		{ return (*(Tpopup_call2_audio_first_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_first_window_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_first_window_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_first_window_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_first_window_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout popup_call2_audio_first_window_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_first_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_first_window_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_first_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_first_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_first_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call2_audio_first_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_first_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_first_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_first_window_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_first_window_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_first_window_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call2_audio_first_window_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_first_window_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_first_window_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_first_window_t5_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_first_window_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_first_window_t5_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call2_audio_first_window_t5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_first_window_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_first_window_t5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_call2_audio_first_window_t_Limits()		{ return (*(Tpopup_call2_audio_first_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_first_window_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_first_window_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_first_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_first_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_call2_audio_first_window_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_first_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_first_window_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : bg_popup_call2_act_pane
inline TAknWindowComponentLayout bg_popup_call2_act_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_act_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_act_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : popup_cale_lunar_info_window
inline TAknTextComponentLayout popup_cale_lunar_info_window_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_cale_lunar_info_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_lunar_info_window_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_cale_lunar_info_window_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_cale_lunar_info_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_lunar_info_window_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_cale_lunar_info_window_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_cale_lunar_info_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_lunar_info_window_t3)))(aVariety, aCol, aRow); }

// LAF Table : bg_popup_call2_act_pane
inline TAknWindowComponentLayout bg_popup_call2_bubble_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_bubble_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_bubble_pane)))(aVariety, aCol, aRow); }

// LAF Table : popup_call2_audio_out_window
inline TAknLayoutScalableParameterLimits bg_popup_call2_in_pane_cp01_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_call2_in_pane_cp01_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_in_pane_cp01_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_call2_in_pane_cp01(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_in_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_in_pane_cp01)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout call_type_pane_cp02(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_type_pane_cp02_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_type_pane_cp02)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_out_window_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_out_window_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call2_audio_out_window_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_out_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_out_window_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_out_window_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call2_audio_out_window_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_out_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_out_window_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_out_window_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call2_audio_out_window_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_out_window_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_call2_audio_out_window_g_Limits()		{ return (*(Tpopup_call2_audio_out_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_out_window_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_out_window_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout popup_call2_audio_out_window_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_out_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_out_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_out_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call2_audio_out_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_out_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_out_window_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_out_window_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call2_audio_out_window_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_out_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_out_window_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_out_window_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call2_audio_out_window_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_out_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_out_window_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_out_window_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call2_audio_out_window_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_out_window_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_out_window_t5_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_out_window_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_t5_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call2_audio_out_window_t5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_out_window_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_t5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_call2_audio_out_window_t_Limits()		{ return (*(Tpopup_call2_audio_out_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_out_window_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_out_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_call2_audio_out_window_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_out_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_call2_audio_in_window
inline TAknLayoutScalableParameterLimits bg_popup_call2_in_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_call2_in_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_in_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_call2_in_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_in_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_in_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_in_window_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_in_window_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call2_audio_in_window_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_in_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_in_window_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_in_window_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call2_audio_in_window_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_in_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_in_window_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_in_window_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call2_audio_in_window_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_in_window_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_call2_audio_in_window_g_Limits()		{ return (*(Tpopup_call2_audio_in_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_in_window_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_in_window_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout popup_call2_audio_in_window_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_in_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_in_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_in_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call2_audio_in_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_in_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_in_window_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_in_window_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call2_audio_in_window_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_in_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_in_window_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_in_window_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call2_audio_in_window_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_in_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_in_window_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_in_window_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call2_audio_in_window_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_in_window_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_in_window_t5_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_in_window_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_t5_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call2_audio_in_window_t5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_in_window_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_t5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_in_window_t6_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_in_window_t6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_t6_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call2_audio_in_window_t6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_in_window_t6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_t6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_call2_audio_in_window_t_Limits()		{ return (*(Tpopup_call2_audio_in_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_call2_audio_in_window_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_call2_audio_in_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_call2_audio_in_window_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_in_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : bg_popup_call2_in_pane
inline TAknWindowComponentLayout bg_popup_call2_in_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_in_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_in_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : popup_cale_lunar_info_window
inline TAknTextComponentLayout popup_cale_lunar_info_window_t4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_cale_lunar_info_window_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_lunar_info_window_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_cale_lunar_info_window_t_Limits()		{ return (*(Tpopup_cale_lunar_info_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_lunar_info_window_t_Limits)))(); }

inline TAknTextComponentLayout popup_cale_lunar_info_window_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_cale_lunar_info_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_lunar_info_window_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : bg_popup_call2_in_pane
inline TAknLayoutScalableParameterLimits bg_popup_call2_rect_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_call2_rect_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_rect_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_call2_rect_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_rect_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_rect_pane)))(aVariety, aCol, aRow); }

// LAF Table : call2_cli_visual_pane
inline TAknWindowComponentLayout call2_cli_visual_graphic_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall2_cli_visual_graphic_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call2_cli_visual_graphic_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout call2_cli_visual_text_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall2_cli_visual_text_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call2_cli_visual_text_pane)))(aVariety, aCol, aRow); }

// LAF Table : smil_status_volume_pane
inline TAknWindowComponentLayout smil_status_volume_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil_status_volume_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil_status_volume_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits smil_status_volume_pane_g_Limits()		{ return (*(Tsmil_status_volume_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil_status_volume_pane_g_Limits)))(); }

// LAF Table : call2_cli_visual_graphic_pane
inline TAknWindowComponentLayout call2_cli_visual_graphic_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall2_cli_visual_graphic_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call2_cli_visual_graphic_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout call2_cli_visual_graphic_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall2_cli_visual_graphic_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call2_cli_visual_graphic_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout call2_cli_visual_graphic_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall2_cli_visual_graphic_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call2_cli_visual_graphic_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits call2_cli_visual_graphic_pane_g_Limits()		{ return (*(Tcall2_cli_visual_graphic_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call2_cli_visual_graphic_pane_g_Limits)))(); }

inline TAknWindowComponentLayout call2_cli_visual_graphic_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall2_cli_visual_graphic_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call2_cli_visual_graphic_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : bg_popup_call2_rect_pane
inline TAknWindowComponentLayout bg_popup_call2_rect_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_rect_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_rect_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call2_rect_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_rect_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_rect_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call2_rect_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_rect_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_rect_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call2_rect_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_rect_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_rect_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call2_rect_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_rect_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_rect_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call2_rect_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_rect_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_rect_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call2_rect_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_rect_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_rect_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call2_rect_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_rect_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_rect_pane_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call2_rect_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_rect_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_rect_pane_g9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits bg_popup_call2_rect_pane_g_Limits()		{ return (*(Tbg_popup_call2_rect_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_rect_pane_g_Limits)))(); }

inline TAknWindowComponentLayout bg_popup_call2_rect_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_rect_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_rect_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : bg_popup_call2_bubble_pane
inline TAknWindowComponentLayout bg_popup_call2_bubble_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_bubble_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_bubble_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call2_bubble_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_bubble_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_bubble_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call2_bubble_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_bubble_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_bubble_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call2_bubble_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_bubble_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_bubble_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call2_bubble_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_bubble_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_bubble_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call2_bubble_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_bubble_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_bubble_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call2_bubble_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_bubble_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_bubble_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call2_bubble_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_bubble_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_bubble_pane_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call2_bubble_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_bubble_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_bubble_pane_g9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits bg_popup_call2_bubble_pane_g_Limits()		{ return (*(Tbg_popup_call2_bubble_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_bubble_pane_g_Limits)))(); }

inline TAknWindowComponentLayout bg_popup_call2_bubble_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_bubble_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_bubble_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : listscroll_cale_week_pane
inline TAknWindowComponentLayout aid_cale_week_size_cell_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_cale_week_size_cell_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_cale_week_size_cell_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_video_pane
inline TAknLayoutScalableParameterLimits aid_cams_cif_uncrop_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_cams_cif_uncrop_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_cams_cif_uncrop_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_cams_cif_uncrop_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_cams_cif_uncrop_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_cams_cif_uncrop_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_burst_pane
inline TAknLayoutScalableParameterLimits aid_cams_size_cell_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_cams_size_cell_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_cams_size_cell_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_cams_size_cell(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_cams_size_cell_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_cams_size_cell)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_cams_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_cams_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_cams_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits linegrid_cams_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlinegrid_cams_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cams_pane_ParamLimits)))(aVariety); }

// LAF Table : main_video_tele_pane
inline TAknTextComponentLayout call_video_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_video_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_video_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout call_video_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_video_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_video_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits call_video_pane_t_Limits()		{ return (*(Tcall_video_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_video_pane_t_Limits)))(); }

inline TAknTextComponentLayout call_video_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_video_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_video_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_cale_month_pane
inline TAknLayoutScalableParameterLimits aid_cale_month_size_cell_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_cale_month_size_cell_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_cale_month_size_cell_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_cale_month_size_cell_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_cale_month_size_cell_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_cale_month_size_cell_pane)))(aVariety, aCol, aRow); }

// LAF Table : smil_status_volume_pane
inline TAknWindowComponentLayout smil_status_volume_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil_status_volume_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil_status_volume_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits volume_smil_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tvolume_smil_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_smil_pane_ParamLimits)))(aVariety); }

// LAF Table : application_window
inline TAknWindowComponentLayout aid_popup2_width_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_popup2_width_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_popup2_width_pane)))(aVariety, aCol, aRow); }

// LAF Table : cell_qdial_pane
inline TAknLayoutScalableParameterLimits cell_qdial_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_qdial_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_qdial_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_qdial_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_qdial_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_qdial_pane_g4)))(aVariety, aCol, aRow); }

// LAF Table : compass_pane
inline TAknLayoutScalableParameterLimits aid_blid_cardinal_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_blid_cardinal_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_blid_cardinal_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits aid_blid_destination_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_blid_destination_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_blid_destination_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_blid_destination_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_blid_destination_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_blid_destination_pane)))(aVariety, aCol, aRow); }

// LAF Table : popup_call_poc_act_window
inline TAknLayoutScalableParameterLimits bg_popup_call_poc_act_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_call_poc_act_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_act_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_call_poc_act_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_poc_act_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_act_pane)))(aVariety, aCol, aRow); }

// LAF Table : popup_call_poc_inact_window
inline TAknLayoutScalableParameterLimits bg_popup_call_poc_inact_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_call_poc_inact_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_inact_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_call_poc_inact_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_poc_inact_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_inact_pane)))(aVariety, aCol, aRow); }

// LAF Table : bg_popup_call_poc_act_pane
inline TAknWindowComponentLayout bg_popup_call_poc_act_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_poc_act_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_act_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call_poc_act_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_poc_act_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_act_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call_poc_act_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_poc_act_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_act_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call_poc_act_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_poc_act_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_act_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call_poc_act_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_poc_act_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_act_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call_poc_act_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_poc_act_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_act_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call_poc_act_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_poc_act_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_act_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call_poc_act_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_poc_act_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_poc_act_pane_g8)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_usb_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_usb_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_usb_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_cale_lunar_info_window(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_cale_lunar_info_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_cale_lunar_info_window)))(aVariety, aCol, aRow); }

// LAF Table : im_reading_pane
inline TAknLayoutScalableParameterLimits im_reading_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tim_reading_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_im_reading_pane_t1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits list_im_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_im_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_im_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits scroll_pane_cp07_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_pane_cp07_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp07_ParamLimits)))(aVariety); }

// LAF Table : mup_equalizer_pane
inline TAknWindowComponentLayout grid_highlight_pane_cp012(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_cp012_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp012)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits mup_scale_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup_scale_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_scale_pane_ParamLimits)))(aVariety); }

// LAF Table : main_usb_pane
inline TAknLayoutScalableParameterLimits main_usb_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_usb_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_usb_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_usb_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_usb_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_usb_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_usb_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_usb_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_usb_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_usb_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_usb_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_usb_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_usb_pane_g_Limits()		{ return (*(Tmain_usb_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_usb_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_usb_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmain_usb_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_usb_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout main_usb_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_usb_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_usb_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_usb_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_usb_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_usb_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_usb_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_usb_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_usb_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_usb_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_usb_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_usb_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_usb_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_usb_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_usb_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_usb_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_usb_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_usb_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_usb_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_usb_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_usb_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_usb_pane_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_usb_pane_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_usb_pane_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_usb_pane_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_usb_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_usb_pane_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_usb_pane_t5_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_usb_pane_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_usb_pane_t5_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_usb_pane_t5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_usb_pane_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_usb_pane_t5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_usb_pane_t6_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_usb_pane_t6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_usb_pane_t6_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_usb_pane_t6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_usb_pane_t6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_usb_pane_t6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_usb_pane_t_Limits()		{ return (*(Tmain_usb_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_usb_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_usb_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmain_usb_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_usb_pane_t_ParamLimits)))(aLineIndex, aVariety); }

// LAF Table : main_location2_pane
inline TAknWindowComponentLayout aid_text_placing(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_text_placing_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_text_placing)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_location2_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_location2_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_location2_pane_t1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits main_location2_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_location2_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_location2_pane_t2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits main_location2_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_location2_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_location2_pane_t3_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits main_location2_pane_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_location2_pane_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_location2_pane_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_location2_pane_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_location2_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_location2_pane_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_location2_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmain_location2_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_location2_pane_t_ParamLimits)))(aLineIndex, aVariety); }

// LAF Table : find_pinb_pane
inline TAknLayoutScalableParameterLimits find_pinb_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tfind_pinb_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_pinb_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout find_pinb_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfind_pinb_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_pinb_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits find_pinb_pane_g_Limits()		{ return (*(Tfind_pinb_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_pinb_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits find_pinb_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tfind_pinb_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_pinb_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout find_pinb_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfind_pinb_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_pinb_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits find_pinb_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tfind_pinb_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_pinb_pane_t1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits find_pinb_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tfind_pinb_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_pinb_pane_t2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits find_pinb_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tfind_pinb_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_pinb_pane_t_ParamLimits)))(aLineIndex, aVariety); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_call3_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_call3_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_call3_pane)))(aVariety, aCol, aRow); }

// LAF Table : cale_month_day_heading_pane
inline TAknLayoutScalableParameterLimits cale_month_day_heading_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_day_heading_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_day_heading_pane_t1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_month_day_heading_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_day_heading_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_day_heading_pane_t2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_month_day_heading_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_day_heading_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_day_heading_pane_t3_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_month_day_heading_pane_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_day_heading_pane_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_day_heading_pane_t4_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_month_day_heading_pane_t5_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_day_heading_pane_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_day_heading_pane_t5_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_month_day_heading_pane_t6_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_day_heading_pane_t6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_day_heading_pane_t6_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_month_day_heading_pane_t7_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_day_heading_pane_t7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_day_heading_pane_t7_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_month_day_heading_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tcale_month_day_heading_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_day_heading_pane_t_ParamLimits)))(aLineIndex, aVariety); }

// LAF Table : smil_status_pane
inline TAknWindowComponentLayout smil_status_volume_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil_status_volume_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil_status_volume_pane)))(aVariety, aCol, aRow); }

// LAF Table : postcard_pane
inline TAknLayoutScalableParameterLimits postcard_address_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tpostcard_address_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_address_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout postcard_address_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpostcard_address_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_address_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits postcard_message_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tpostcard_message_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_message_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout postcard_message_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpostcard_message_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_message_pane)))(aVariety, aCol, aRow); }

// LAF Table : call2_cli_visual_text_pane
inline TAknLayoutScalableParameterLimits call2_cli_visual_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcall2_cli_visual_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call2_cli_visual_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout call2_cli_visual_pane_t1(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tcall2_cli_visual_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call2_cli_visual_pane_t1)))(aRow, aVariety, aCol); }

// LAF Table : postcard_message_pane
inline TAknLayoutScalableParameterLimits postcard_message_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpostcard_message_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_message_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout postcard_message_pane_t1(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tpostcard_message_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_message_pane_t1)))(aRow, aVariety, aCol); }

// LAF Table : postcard_address_pane
inline TAknLayoutScalableParameterLimits postcard_address_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpostcard_address_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_address_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout postcard_address_pane_t1(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tpostcard_address_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_address_pane_t1)))(aRow, aVariety, aCol); }

// LAF Table : main_call3_pane
inline TAknLayoutScalableParameterLimits popup_call3_audio_in_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call3_audio_in_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call3_audio_in_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call3_audio_in_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call3_audio_in_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call3_audio_in_window)))(aVariety, aCol, aRow); }

// LAF Table : popup_call3_audio_in_window
inline TAknLayoutScalableParameterLimits bg_popup_call3_in_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_call3_in_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call3_in_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_call3_in_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call3_in_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call3_in_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call3_audio_in_window_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call3_audio_in_window_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call3_audio_in_window_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call3_audio_in_window_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call3_audio_in_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call3_audio_in_window_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call3_audio_in_window_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call3_audio_in_window_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call3_audio_in_window_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call3_audio_in_window_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call3_audio_in_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call3_audio_in_window_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call3_audio_in_window_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call3_audio_in_window_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call3_audio_in_window_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call3_audio_in_window_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call3_audio_in_window_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call3_audio_in_window_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_call3_audio_in_window_g_Limits()		{ return (*(Tpopup_call3_audio_in_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call3_audio_in_window_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_call3_audio_in_window_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_call3_audio_in_window_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call3_audio_in_window_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout popup_call3_audio_in_window_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call3_audio_in_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call3_audio_in_window_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call3_audio_in_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call3_audio_in_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call3_audio_in_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call3_audio_in_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call3_audio_in_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call3_audio_in_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call3_audio_in_window_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call3_audio_in_window_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call3_audio_in_window_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call3_audio_in_window_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call3_audio_in_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call3_audio_in_window_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call3_audio_in_window_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call3_audio_in_window_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call3_audio_in_window_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call3_audio_in_window_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call3_audio_in_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call3_audio_in_window_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_call3_audio_in_window_t_Limits()		{ return (*(Tpopup_call3_audio_in_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call3_audio_in_window_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_call3_audio_in_window_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_call3_audio_in_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call3_audio_in_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_call3_audio_in_window_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call3_audio_in_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call3_audio_in_window_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : bg_popup_call3_in_pane
inline TAknWindowComponentLayout bg_popup_call3_rect_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call3_rect_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call3_rect_pane)))(aVariety, aCol, aRow); }

// LAF Table : bg_popup_call3_rect_pane
inline TAknWindowComponentLayout bg_popup_call3_rect_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call3_rect_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call3_rect_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call3_rect_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call3_rect_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call3_rect_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call3_rect_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call3_rect_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call3_rect_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call3_rect_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call3_rect_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call3_rect_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call3_rect_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call3_rect_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call3_rect_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call3_rect_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call3_rect_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call3_rect_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_call3_rect_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call3_rect_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call3_rect_pane_g7)))(aVariety, aCol, aRow); }

// LAF Table : mup_visualizer_pane
inline TAknWindowComponentLayout mup_visualizer_osc_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_visualizer_osc_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_visualizer_osc_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup_visualizer_spec_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_visualizer_spec_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_visualizer_spec_pane)))(aVariety, aCol, aRow); }

// LAF Table : popup_call3_audio_in_window
inline TAknLayoutScalableParameterLimits call3_video_qcif_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcall3_video_qcif_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call3_video_qcif_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout call3_video_qcif_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall3_video_qcif_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call3_video_qcif_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits call3_video_qcif_uncrop_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcall3_video_qcif_uncrop_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call3_video_qcif_uncrop_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout call3_video_qcif_uncrop_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall3_video_qcif_uncrop_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call3_video_qcif_uncrop_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits call3_video_subqcif_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcall3_video_subqcif_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call3_video_subqcif_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout call3_video_subqcif_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall3_video_subqcif_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call3_video_subqcif_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits call3_video_subqcif_uncrop_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcall3_video_subqcif_uncrop_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call3_video_subqcif_uncrop_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout call3_video_subqcif_uncrop_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall3_video_subqcif_uncrop_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call3_video_subqcif_uncrop_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call3_audio_in_window_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call3_audio_in_window_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call3_audio_in_window_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call3_audio_in_window_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call3_audio_in_window_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call3_audio_in_window_g4)))(aVariety, aCol, aRow); }

// LAF Table : mup_visualizer_spec_pane
inline TAknWindowComponentLayout mup_spec_half_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_spec_half_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_spec_half_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup_spec_half_pane_cp(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_spec_half_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_spec_half_pane_cp)))(aVariety, aCol, aRow); }

// LAF Table : mup_visualizer_osc_pane
inline TAknWindowComponentLayout mup_osc_middle_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_osc_middle_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_osc_middle_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup_visualizer_osc_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_visualizer_osc_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_visualizer_osc_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : mup_spec_half_pane
inline TAknLayoutScalableParameterLimits mup_spec_bar_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup_spec_bar_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_spec_bar_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup_spec_bar_pane(TInt aCol, TInt aVariety = 0, TInt aRow = 0)		{ return (*(Tmup_spec_bar_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_spec_bar_pane)))(aCol, aVariety, aRow); }

// LAF Table : mup_spec_bar_pane
inline TAknWindowComponentLayout mup_spec_bar_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_spec_bar_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_spec_bar_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup_spec_bar_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_spec_bar_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_spec_bar_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits mup_spec_bar_pane_g_Limits()		{ return (*(Tmup_spec_bar_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_spec_bar_pane_g_Limits)))(); }

inline TAknWindowComponentLayout mup_spec_bar_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_spec_bar_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_spec_bar_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : listscroll_cale_week_pane
inline TAknLayoutScalableParameterLimits aid_cale_week_size_cell_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_cale_week_size_cell_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_cale_week_size_cell_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits bg_cale_heading_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_cale_heading_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_heading_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits bg_cale_pane_cp01_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_cale_pane_cp01_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_pane_cp01_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_corner_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_corner_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_corner_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_day_heading_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_day_heading_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_day_heading_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_scroll_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_scroll_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_scroll_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_scroll_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_scroll_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_scroll_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g3_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_scroll_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_scroll_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g4_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_scroll_pane_g5_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_scroll_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g5_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_scroll_pane_g6_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_scroll_pane_g6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g6_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_scroll_pane_g7_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_scroll_pane_g7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g7_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_scroll_pane_g8_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_scroll_pane_g8_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g8_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_scroll_pane_g9_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_scroll_pane_g9_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g9_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_scroll_pane_g10_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_scroll_pane_g10_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g10_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_scroll_pane_g11_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_scroll_pane_g11_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g11_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_scroll_pane_g12_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_scroll_pane_g12_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g12_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_scroll_pane_g13_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_scroll_pane_g13_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g13_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_scroll_pane_g14_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_scroll_pane_g14_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g14_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_scroll_pane_g15_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_scroll_pane_g15_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g15_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_scroll_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tcale_week_scroll_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_scroll_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_time_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_time_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_time_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits grid_cale_week_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_cale_week_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_cale_week_pane_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout listscroll_cale_week_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_cale_week_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_cale_week_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits scroll_pane_cp08_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_pane_cp08_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp08_ParamLimits)))(aVariety); }

// LAF Table : main_cale_month_pane
inline TAknLayoutScalableParameterLimits cale_month_corner_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_corner_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_corner_pane_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout cale_month_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcale_month_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cale_month_week_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_week_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_week_pane_ParamLimits)))(aVariety); }

// LAF Table : popup_call_status_window
inline TAknLayoutScalableParameterLimits popup_call_status_window_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_status_window_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_status_window_g1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits popup_call_status_window_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_status_window_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_status_window_g2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits popup_call_status_window_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call_status_window_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_status_window_g3_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits popup_call_status_window_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_call_status_window_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call_status_window_g_ParamLimits)))(aLineIndex, aVariety); }

// LAF Table : popup_clock_analogue_window
inline TAknWindowComponentLayout aid_call2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_call2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_call2_pane)))(aVariety, aCol, aRow); }

// LAF Table : msg_header_pane
inline TAknWindowComponentLayout msg_header_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmsg_header_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_msg_header_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : postcard_pane
inline TAknLayoutScalableParameterLimits postcard_address2_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tpostcard_address2_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_address2_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout postcard_address2_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpostcard_address2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_address2_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits postcard_message2_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tpostcard_message2_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_message2_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout postcard_message2_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpostcard_message2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_message2_pane)))(aVariety, aCol, aRow); }

// LAF Table : postcard_message2_pane
inline TAknLayoutScalableParameterLimits message2_row_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmessage2_row_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_message2_row_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout message2_row_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tmessage2_row_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_message2_row_pane)))(aRow, aVariety, aCol); }

// LAF Table : postcard_address2_pane
inline TAknLayoutScalableParameterLimits address2_row_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Taddress2_row_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_address2_row_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout address2_row_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Taddress2_row_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_address2_row_pane)))(aRow, aVariety, aCol); }

// LAF Table : message2_row_pane
inline TAknWindowComponentLayout postcard_message2_row_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpostcard_message2_row_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_message2_row_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout postcard_message2_row_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpostcard_message2_row_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_postcard_message2_row_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : address2_row_pane
inline TAknWindowComponentLayout address2_row_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taddress2_row_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_address2_row_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout address2_row_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taddress2_row_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_address2_row_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : main_vorec_pane
inline TAknWindowComponentLayout aid_size_cell_vorec(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_vorec_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_vorec)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_rss_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_rss_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_rss_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_rss_pane
inline TAknLayoutScalableParameterLimits rss_list_single_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Trss_list_single_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_rss_list_single_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout rss_list_single_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Trss_list_single_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_rss_list_single_pane)))(aRow, aVariety, aCol); }

// LAF Table : rss_list_single_pane
inline TAknTextComponentLayout rss_list_single_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Trss_list_single_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_rss_list_single_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout rss_list_single_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Trss_list_single_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_rss_list_single_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits rss_list_single_pane_t_Limits()		{ return (*(Trss_list_single_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_rss_list_single_pane_t_Limits)))(); }

inline TAknTextComponentLayout rss_list_single_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Trss_list_single_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_rss_list_single_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_camera2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_video2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video2_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_camera2_pane
inline TAknLayoutScalableParameterLimits cams_zoom_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tcams_zoom_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams_zoom_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cams_zoom_pane_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcams_zoom_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams_zoom_pane_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits image2_vga_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Timage2_vga_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_image2_vga_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout image2_vga_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Timage2_vga_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_image2_vga_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_camera2_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_camera2_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_camera2_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera2_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_camera2_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_camera2_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_camera2_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera2_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_camera2_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_camera2_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_camera2_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera2_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_camera2_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_camera2_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_camera2_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera2_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_camera2_pane_g5_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_camera2_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_camera2_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera2_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_camera2_pane_g6_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_camera2_pane_g6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_g6_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_camera2_pane_g6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera2_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_g6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_camera2_pane_g7_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_camera2_pane_g7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_g7_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_camera2_pane_g7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera2_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_g7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_camera2_pane_g8_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_camera2_pane_g8_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_g8_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_camera2_pane_g8(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera2_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_g8)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_camera2_pane_g_Limits()		{ return (*(Tmain_camera2_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_camera2_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmain_camera2_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout main_camera2_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera2_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_camera2_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_camera2_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_camera2_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera2_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_camera2_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_camera2_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_camera2_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera2_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_camera2_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_camera2_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_camera2_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera2_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_camera2_pane_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_camera2_pane_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_camera2_pane_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera2_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_camera2_pane_t_Limits()		{ return (*(Tmain_camera2_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_camera2_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmain_camera2_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout main_camera2_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera2_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_video2_pane
inline TAknLayoutScalableParameterLimits cams_zoom_pane_cp4_ParamLimits(TInt aVariety = 0)		{ return (*(Tcams_zoom_pane_cp4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams_zoom_pane_cp4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cams_zoom_pane_cp4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcams_zoom_pane_cp4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams_zoom_pane_cp4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits image2_cif_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Timage2_cif_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_image2_cif_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout image2_cif_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Timage2_cif_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_image2_cif_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits image2_subqcif_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Timage2_subqcif_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_image2_subqcif_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout image2_subqcif_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Timage2_subqcif_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_image2_subqcif_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_video2_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_video2_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video2_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_video2_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video2_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video2_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_video2_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_video2_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video2_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_video2_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video2_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video2_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_video2_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_video2_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video2_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_video2_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video2_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video2_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_video2_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_video2_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video2_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_video2_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video2_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video2_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_video2_pane_g5_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_video2_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video2_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_video2_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video2_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video2_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_video2_pane_g6_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_video2_pane_g6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video2_pane_g6_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_video2_pane_g6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video2_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video2_pane_g6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_video2_pane_g_Limits()		{ return (*(Tmain_video2_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video2_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_video2_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmain_video2_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video2_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout main_video2_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video2_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video2_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_video2_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_video2_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video2_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_video2_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video2_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video2_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_video2_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_video2_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video2_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_video2_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video2_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video2_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_video2_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_video2_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video2_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_video2_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video2_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video2_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_video2_pane_t_Limits()		{ return (*(Tmain_video2_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video2_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_video2_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmain_video2_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video2_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout main_video2_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video2_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video2_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_call_pane
inline TAknWindowComponentLayout call_muted_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_muted_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_muted_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits call_muted_g_Limits()		{ return (*(Tcall_muted_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_muted_g_Limits)))(); }

inline TAknWindowComponentLayout call_muted_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall_muted_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call_muted_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_mup2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_mup2_pane
inline TAknLayoutScalableParameterLimits main_mup2_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup2_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup2_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup2_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup2_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup2_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup2_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup2_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_g2)))(aVariety, aCol, aRow); }

// LAF Table : mup_volume_cont_pane
inline TAknWindowComponentLayout main_mup_pane_g13_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_pane_g13_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_pane_g13_cp1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup_volume_pane_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_volume_pane_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_volume_pane_cp1)))(aVariety, aCol, aRow); }

// LAF Table : main_mup2_pane
inline TAknLayoutScalableParameterLimits main_mup2_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup2_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup2_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup2_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup2_pane_g5_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup2_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup2_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup2_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup2_pane_g6_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup2_pane_g6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_g6_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup2_pane_g6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup2_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_g6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup2_pane_g7_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup2_pane_g7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_g7_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup2_pane_g7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup2_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_g7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_mup2_pane_g_Limits()		{ return (*(Tmain_mup2_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_mup2_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmain_mup2_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout main_mup2_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup2_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup2_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup2_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup2_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup2_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup2_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup2_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup2_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup2_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup2_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup2_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup2_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup2_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup2_pane_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup2_pane_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup2_pane_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup2_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup2_pane_t5_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup2_pane_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_t5_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup2_pane_t5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup2_pane_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_t5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup2_pane_t6_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup2_pane_t6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_t6_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup2_pane_t6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup2_pane_t6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_t6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_mup2_pane_t_Limits()		{ return (*(Tmain_mup2_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_mup2_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmain_mup2_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout main_mup2_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup2_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits mup2_visualizer_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup2_visualizer_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_visualizer_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup2_visualizer_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup2_visualizer_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_visualizer_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits mup_progress_pane_cp_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup_progress_pane_cp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_progress_pane_cp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup_progress_pane_cp(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_progress_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_progress_pane_cp)))(aVariety, aCol, aRow); }

// LAF Table : mup2_volume_cont_pane
inline TAknLayoutScalableParameterLimits mup_volume_pane_cp_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup_volume_pane_cp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_volume_pane_cp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup_volume_pane_cp(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_volume_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_volume_pane_cp)))(aVariety, aCol, aRow); }

// LAF Table : mup2_visualizer_pane
inline TAknLayoutScalableParameterLimits mup2_visualizer_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup2_visualizer_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_visualizer_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup2_visualizer_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup2_visualizer_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_visualizer_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits mup2_visualizer_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup2_visualizer_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_visualizer_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup2_visualizer_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup2_visualizer_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_visualizer_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits mup2_visualizer_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup2_visualizer_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_visualizer_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup2_visualizer_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup2_visualizer_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_visualizer_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits mup2_visualizer_pane_g_Limits()		{ return (*(Tmup2_visualizer_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_visualizer_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits mup2_visualizer_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmup2_visualizer_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_visualizer_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout mup2_visualizer_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup2_visualizer_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_visualizer_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_fmradio_pane
inline TAknWindowComponentLayout aid_size_cell_fmradio(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_fmradio_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_fmradio)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout aid_height_parent_landcape(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_height_parent_landcape_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_height_parent_landcape)))(aVariety, aCol, aRow); }

// LAF Table : main_browser_pane
inline TAknWindowComponentLayout wml_content_pane_cp(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_content_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_content_pane_cp)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wml_tabs_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_tabs_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_tabs_pane)))(aVariety, aCol, aRow); }

// LAF Table : wml_content_pane
inline TAknWindowComponentLayout popup_wml_miniature_window(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_wml_miniature_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_wml_miniature_window)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp021(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp021_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp021)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wml_content_pane_comp8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_content_pane_comp8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_content_pane_comp8)))(aVariety, aCol, aRow); }

// LAF Table : popup_wml_miniature_window
inline TAknWindowComponentLayout bg_popup_sub_pane_cp05(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp05_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp05)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_wml_miniature_window_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_wml_miniature_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_wml_miniature_window_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wml_miniature_view_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_miniature_view_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_miniature_view_pane)))(aVariety, aCol, aRow); }

// LAF Table : wml_miniature_view_pane
inline TAknWindowComponentLayout aid_size_wml_view(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_wml_view_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_wml_view)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wml_miniature_view_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_miniature_view_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_miniature_view_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wml_miniature_view_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_miniature_view_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_miniature_view_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wml_miniature_view_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_miniature_view_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_miniature_view_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wml_miniature_view_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_miniature_view_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_miniature_view_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wml_miniature_view_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_miniature_view_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_miniature_view_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wml_miniature_view_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_miniature_view_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_miniature_view_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wml_miniature_view_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_miniature_view_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_miniature_view_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wml_miniature_view_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_miniature_view_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_miniature_view_pane_g8)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits wml_miniature_view_pane_g_Limits()		{ return (*(Twml_miniature_view_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_miniature_view_pane_g_Limits)))(); }

inline TAknWindowComponentLayout wml_miniature_view_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_miniature_view_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_miniature_view_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : wml_tabs_pane
inline TAknLayoutScalableParameterLimits background_graphic_ParamLimits(TInt aVariety = 0)		{ return (*(Tbackground_graphic_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_background_graphic_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout background_graphic(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbackground_graphic_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_background_graphic)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wml_tabs_2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_tabs_2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_tabs_2_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits wml_tabs_3_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Twml_tabs_3_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_tabs_3_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout wml_tabs_3_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_tabs_3_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_tabs_3_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits wml_tabs_4_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Twml_tabs_4_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_tabs_4_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout wml_tabs_4_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_tabs_4_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_tabs_4_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits wml_tabs_5_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Twml_tabs_5_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_tabs_5_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout wml_tabs_5_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_tabs_5_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_tabs_5_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits wml_tabs_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Twml_tabs_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_tabs_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout wml_tabs_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_tabs_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_tabs_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits wml_tabs_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Twml_tabs_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_tabs_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout wml_tabs_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_tabs_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_tabs_pane_g3)))(aVariety, aCol, aRow); }

// LAF Table : wml_tabs_2_pane
inline TAknLayoutScalableParameterLimits wml_tabs_2_active_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Twml_tabs_2_active_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_tabs_2_active_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout wml_tabs_2_active_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_tabs_2_active_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_tabs_2_active_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits wml_tabs_2_passive_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Twml_tabs_2_passive_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_tabs_2_passive_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout wml_tabs_2_passive_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_tabs_2_passive_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_tabs_2_passive_pane)))(aVariety, aCol, aRow); }

// LAF Table : wml_tabs_3_pane
inline TAknLayoutScalableParameterLimits wml_tabs_3_active_pane_cp_ParamLimits(TInt aVariety = 0)		{ return (*(Twml_tabs_3_active_pane_cp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_tabs_3_active_pane_cp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout wml_tabs_3_active_pane_cp(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_tabs_3_active_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_tabs_3_active_pane_cp)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits wml_tabs_3_passive_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Twml_tabs_3_passive_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_tabs_3_passive_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout wml_tabs_3_passive_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_tabs_3_passive_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_tabs_3_passive_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits wml_tabs_3_passive_pane_cp_ParamLimits(TInt aVariety = 0)		{ return (*(Twml_tabs_3_passive_pane_cp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_tabs_3_passive_pane_cp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout wml_tabs_3_passive_pane_cp(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twml_tabs_3_passive_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_tabs_3_passive_pane_cp)))(aVariety, aCol, aRow); }

// LAF Table : wml_tabs_4_pane
inline TAknWindowComponentLayout tabs_4_active_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_4_active_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_active_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout tabs_4_passive_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_4_passive_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_passive_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout tabs_4_passive_pane_cp(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_4_passive_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_passive_pane_cp)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout tabs_4_passive_pane_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_4_passive_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_passive_pane_cp2)))(aVariety, aCol, aRow); }

// LAF Table : aid_cale_month_size_cell_pane
inline TAknWindowComponentLayout aid_height_text(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_height_text_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_height_text)))(aVariety, aCol, aRow); }

// LAF Table : main_mup_pane
inline TAknLayoutScalableParameterLimits mup_volume_cont_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup_volume_cont_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_volume_cont_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup_volume_cont_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_volume_cont_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_volume_cont_pane)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_pinb_pane
inline TAknWindowComponentLayout aid_size_cell_pinb(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_pinb_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_pinb)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout aid_size_list_pinb(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_list_pinb_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_list_pinb)))(aVariety, aCol, aRow); }

// LAF Table : main_mup2_pane
inline TAknLayoutScalableParameterLimits mup2_volume_cont_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup2_volume_cont_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_volume_cont_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup2_volume_cont_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup2_volume_cont_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_volume_cont_pane)))(aVariety, aCol, aRow); }

// LAF Table : mup2_volume_cont_pane
inline TAknLayoutScalableParameterLimits mup2_volume_cont_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup2_volume_cont_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_volume_cont_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup2_volume_cont_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup2_volume_cont_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_volume_cont_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : application_window
inline TAknLayoutScalableParameterLimits aid_size_cell_touch_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_size_cell_touch_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_touch_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_size_cell_touch(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_touch_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_touch)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits touch_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Ttouch_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_touch_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout touch_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttouch_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_touch_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_rss2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_rss2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_rss2_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_rss2_pane
inline TAknWindowComponentLayout listscroll_rss2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_rss2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_rss2_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout rss2_navigation_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Trss2_navigation_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_rss2_navigation_pane)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_rss2_pane
inline TAknWindowComponentLayout list_rss2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_rss2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_rss2_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp22(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp22_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp22)))(aVariety, aCol, aRow); }

// LAF Table : rss2_navigation_pane
inline TAknWindowComponentLayout rss2_navigation_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Trss2_navigation_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_rss2_navigation_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout rss2_navigation_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Trss2_navigation_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_rss2_navigation_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout rss2_navigation_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Trss2_navigation_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_rss2_navigation_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits rss2_navigation_pane_g_Limits()		{ return (*(Trss2_navigation_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_rss2_navigation_pane_g_Limits)))(); }

inline TAknWindowComponentLayout rss2_navigation_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Trss2_navigation_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_rss2_navigation_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout rss2_navigation_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Trss2_navigation_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_rss2_navigation_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : list_rss2_pane
inline TAknLayoutScalableParameterLimits rss2_list_single_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Trss2_list_single_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_rss2_list_single_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout rss2_list_single_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Trss2_list_single_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_rss2_list_single_pane)))(aRow, aVariety, aCol); }

// LAF Table : rss2_list_single_pane
inline TAknTextComponentLayout rss2_list_single_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Trss2_list_single_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_rss2_list_single_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits rss2_list_single_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Trss2_list_single_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_rss2_list_single_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout rss2_list_single_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Trss2_list_single_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_rss2_list_single_pane_t3)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout rss2_list_single_pane_t4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Trss2_list_single_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_rss2_list_single_pane_t4)))(aVariety, aCol, aRow); }

// LAF Table : smil_status_pane
inline TAknWindowComponentLayout smil_status_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil_status_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil_status_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknLayoutScalableParameterLimits main_image2_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_image2_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image2_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_image2_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_image2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image2_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_camera2_pane
inline TAknLayoutScalableParameterLimits main_camera2_pane_g9_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_camera2_pane_g9_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_g9_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_camera2_pane_g9(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera2_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_g9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_camera2_pane_t5_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_camera2_pane_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_t5_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_camera2_pane_t5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera2_pane_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_t5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_camera2_pane_t6_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_camera2_pane_t6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_t6_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_camera2_pane_t6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera2_pane_t6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_t6)))(aVariety, aCol, aRow); }

// LAF Table : main_image2_pane
inline TAknLayoutScalableParameterLimits main_image2_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_image2_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image2_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_image2_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_image2_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image2_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : main_smil2_pane
inline TAknLayoutScalableParameterLimits smil2_video_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tsmil2_video_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil2_video_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout smil2_video_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil2_video_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil2_video_pane)))(aVariety, aCol, aRow); }

// LAF Table : application_window
inline TAknWindowComponentLayout aid_zoom_text_primary_cp(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_zoom_text_primary_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_zoom_text_primary_cp)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_preview_fixed_window(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_preview_fixed_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_fixed_window)))(aVariety, aCol, aRow); }

// LAF Table : im_reading_pane
inline TAknWindowComponentLayout im_reading_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tim_reading_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_im_reading_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : main_camera2_pane
inline TAknLayoutScalableParameterLimits cams2_bc_adjust_pane_cp_ParamLimits(TInt aVariety = 0)		{ return (*(Tcams2_bc_adjust_pane_cp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams2_bc_adjust_pane_cp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cams2_bc_adjust_pane_cp(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcams2_bc_adjust_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams2_bc_adjust_pane_cp)))(aVariety, aCol, aRow); }

// LAF Table : main_video2_pane
inline TAknLayoutScalableParameterLimits cams2_bc_adjust_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcams2_bc_adjust_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams2_bc_adjust_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cams2_bc_adjust_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcams2_bc_adjust_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams2_bc_adjust_pane)))(aVariety, aCol, aRow); }

// LAF Table : cams2_bc_adjust_pane
inline TAknWindowComponentLayout cams2_bc_adjust_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcams2_bc_adjust_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams2_bc_adjust_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cams2_slider_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcams2_slider_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams2_slider_pane)))(aVariety, aCol, aRow); }

// LAF Table : cams2_slider_pane
inline TAknWindowComponentLayout cams2_slider_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcams2_slider_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams2_slider_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cams2_slider_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcams2_slider_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams2_slider_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cams2_slider_pane_g_Limits()		{ return (*(Tcams2_slider_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams2_slider_pane_g_Limits)))(); }

inline TAknWindowComponentLayout cams2_slider_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcams2_slider_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams2_slider_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_calc_pane
inline TAknLayoutScalableParameterLimits calc_display_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcalc_display_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_calc_display_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits calc_paper_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcalc_paper_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_calc_paper_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits grid_calc_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_calc_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_calc_pane_ParamLimits)))(aVariety); }

// LAF Table : popup_clock_digital_window
inline TAknLayoutScalableParameterLimits popup_clock_digital_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_clock_digital_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_digital_window_t1_ParamLimits)))(aVariety); }

// LAF Table : main_image_pane
inline TAknTextComponentLayout main_image_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_image_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : main_calc_pane
inline TAknLayoutScalableParameterLimits aid_size_cell_calc_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_size_cell_calc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_calc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_size_cell_calc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_calc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_calc)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknLayoutScalableParameterLimits popup_blid_sat_info2_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_blid_sat_info2_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_blid_sat_info2_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_blid_sat_info2_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_blid_sat_info2_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_blid_sat_info2_window)))(aVariety, aCol, aRow); }

// LAF Table : popup_blid_sat_info2_window
inline TAknWindowComponentLayout aid_size_cell_blid(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_blid_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_blid)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_window_pane_cp07(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp07_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp07)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_popup_blid_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_popup_blid_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_popup_blid_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits heading_pane_cp05_ParamLimits(TInt aVariety = 0)		{ return (*(Theading_pane_cp05_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_pane_cp05_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout heading_pane_cp05(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_pane_cp05_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_pane_cp05)))(aVariety, aCol, aRow); }

// LAF Table : grid_popup_blid_pane
inline TAknLayoutScalableParameterLimits cell_popup_blid_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_popup_blid_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_popup_blid_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_popup_blid_pane(TInt aCol, TInt aRow, TInt aVariety = 0)		{ return (*(Tcell_popup_blid_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_popup_blid_pane)))(aCol, aRow, aVariety); }

// LAF Table : cell_popup_blid_pane
inline TAknWindowComponentLayout cell_popup_blid_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_popup_blid_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_popup_blid_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cell_popup_blid_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_popup_blid_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_popup_blid_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : main_mup2_pane
inline TAknLayoutScalableParameterLimits mup2_indicator_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup2_indicator_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_indicator_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup2_indicator_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup2_indicator_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_indicator_pane)))(aVariety, aCol, aRow); }

// LAF Table : mup2_visualizer_pane
inline TAknWindowComponentLayout mup2_visualizer_osc_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup2_visualizer_osc_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_visualizer_osc_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits mup2_visualizer_spec_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup2_visualizer_spec_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_visualizer_spec_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup2_visualizer_spec_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup2_visualizer_spec_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_visualizer_spec_pane)))(aVariety, aCol, aRow); }

// LAF Table : mup2_visualizer_spec_pane
inline TAknWindowComponentLayout mup2_spec_half_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup2_spec_half_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_spec_half_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup2_spec_half_pane_cp(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup2_spec_half_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_spec_half_pane_cp)))(aVariety, aCol, aRow); }

// LAF Table : mup2_spec_half_pane
inline TAknLayoutScalableParameterLimits mup2_spec_bar_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup2_spec_bar_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_spec_bar_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup2_spec_bar_pane(TInt aCol, TInt aVariety = 0, TInt aRow = 0)		{ return (*(Tmup2_spec_bar_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_spec_bar_pane)))(aCol, aVariety, aRow); }

// LAF Table : mup2_spec_bar_pane
inline TAknWindowComponentLayout mup2_spec_bar_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup2_spec_bar_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_spec_bar_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup2_spec_bar_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup2_spec_bar_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_spec_bar_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits mup2_spec_bar_pane_g_Limits()		{ return (*(Tmup2_spec_bar_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_spec_bar_pane_g_Limits)))(); }

inline TAknWindowComponentLayout mup2_spec_bar_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup2_spec_bar_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_spec_bar_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : mup2_visualizer_osc_pane
inline TAknWindowComponentLayout mup2_osc_middle_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup2_osc_middle_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_osc_middle_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup2_visualizer_osc_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup2_visualizer_osc_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup2_visualizer_osc_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : popup_number_entry_window
inline TAknLayoutScalableParameterLimits popup_number_entry_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_number_entry_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_number_entry_window_t1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits popup_number_entry_window_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_number_entry_window_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_number_entry_window_t2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits popup_number_entry_window_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_number_entry_window_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_number_entry_window_t3_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits popup_number_entry_window_t5_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_number_entry_window_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_number_entry_window_t5_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_number_entry_window_t5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_number_entry_window_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_number_entry_window_t5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_number_entry_window_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_number_entry_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_number_entry_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknLayoutScalableParameterLimits text_title_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Ttext_title_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_text_title_cp2_ParamLimits)))(aVariety); }

// LAF Table : main_viewer_pane
inline TAknWindowComponentLayout aid_hotspot_pointer_text2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_hotspot_pointer_text2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_hotspot_pointer_text2_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_viewer_pane_g9_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_viewer_pane_g9_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_viewer_pane_g9_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_viewer_pane_g9(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_viewer_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_viewer_pane_g9)))(aVariety, aCol, aRow); }

// LAF Table : main_cale_month_pane
inline TAknLayoutScalableParameterLimits cale_month_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_pane_t1_ParamLimits)))(aVariety); }

// LAF Table : listscroll_cale_day_pane
inline TAknLayoutScalableParameterLimits bg_cale_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_cale_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits list_cale_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_cale_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_pane_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout listscroll_cale_day_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_cale_day_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_cale_day_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits scroll_pane_cp09_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_pane_cp09_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp09_ParamLimits)))(aVariety); }

// LAF Table : main_mup_eq_pane
inline TAknLayoutScalableParameterLimits main_mup_eq_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_eq_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_eq_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup_eq_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_eq_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_eq_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_eq_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_eq_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_eq_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup_eq_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_eq_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_eq_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_eq_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_eq_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_eq_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup_eq_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_eq_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_eq_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_eq_pane_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_eq_pane_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_eq_pane_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup_eq_pane_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_eq_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_eq_pane_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_eq_pane_t5_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_eq_pane_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_eq_pane_t5_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup_eq_pane_t5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_eq_pane_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_eq_pane_t5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_eq_pane_t6_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_eq_pane_t6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_eq_pane_t6_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup_eq_pane_t6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_eq_pane_t6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_eq_pane_t6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_eq_pane_t7_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_eq_pane_t7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_eq_pane_t7_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup_eq_pane_t7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_eq_pane_t7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_eq_pane_t7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_eq_pane_t8_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_eq_pane_t8_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_eq_pane_t8_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup_eq_pane_t8(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_eq_pane_t8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_eq_pane_t8)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_eq_pane_t9_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_eq_pane_t9_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_eq_pane_t9_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup_eq_pane_t9(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_eq_pane_t9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_eq_pane_t9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup_eq_pane_t10_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_mup_eq_pane_t10_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_eq_pane_t10_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup_eq_pane_t10(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_eq_pane_t10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_eq_pane_t10)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_mup_eq_pane_t_Limits()		{ return (*(Tmain_mup_eq_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_eq_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_mup_eq_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmain_mup_eq_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_eq_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout main_mup_eq_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup_eq_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup_eq_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits mup_equalizer_pane_cp5_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup_equalizer_pane_cp5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_equalizer_pane_cp5_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits mup_equalizer_pane_cp6_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup_equalizer_pane_cp6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_equalizer_pane_cp6_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits mup_equalizer_pane_cp7_ParamLimits(TInt aVariety = 0)		{ return (*(Tmup_equalizer_pane_cp7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_equalizer_pane_cp7_ParamLimits)))(aVariety); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_gallery_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_gallery_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_gallery_pane)))(aVariety, aCol, aRow); }

// LAF Table : smil_status_volume_pane
inline TAknWindowComponentLayout smil2_volume_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil2_volume_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil2_volume_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits smil_status_volume_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tsmil_status_volume_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil_status_volume_pane_g1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits smil_status_volume_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tsmil_status_volume_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil_status_volume_pane_g2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits smil_status_volume_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tsmil_status_volume_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil_status_volume_pane_g3_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits smil_status_volume_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tsmil_status_volume_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil_status_volume_pane_g_ParamLimits)))(aLineIndex, aVariety); }

// LAF Table : popup_blid_sat_info2_window
inline TAknLayoutScalableParameterLimits bg_popup_window_pane_cp07_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_cp07_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp07_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout blid_firmament_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid_firmament_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid_firmament_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_gallery_pane
inline TAknLayoutScalableParameterLimits aid_size_cell_gallery_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_size_cell_gallery_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_gallery_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_size_cell_gallery(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_gallery_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_gallery)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_gallery_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_gallery_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_gallery_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_gallery_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_gallery_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_gallery_pane)))(aVariety, aCol, aRow); }

// LAF Table : grid_gallery_pane
inline TAknLayoutScalableParameterLimits cell_gallery_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_gallery_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gallery_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_gallery_pane(TInt aVariety, TInt aCol, TInt aRow)		{ return (*(Tcell_gallery_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gallery_pane)))(aVariety, aCol, aRow); }

// LAF Table : cell_gallery_pane
inline TAknLayoutScalableParameterLimits bg_cell_gallery_focus_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_cell_gallery_focus_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cell_gallery_focus_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_cell_gallery_focus_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cell_gallery_focus_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cell_gallery_focus_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_gallery_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_gallery_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gallery_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_gallery_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_gallery_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gallery_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_gallery_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_gallery_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gallery_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_gallery_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_gallery_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gallery_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_gallery_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_gallery_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gallery_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_gallery_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_gallery_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gallery_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_gallery_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_gallery_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gallery_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_gallery_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_gallery_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gallery_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_gallery_pane_g_Limits()		{ return (*(Tcell_gallery_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gallery_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits cell_gallery_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tcell_gallery_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gallery_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout cell_gallery_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_gallery_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gallery_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : bg_cell_gallery_focus_pane
inline TAknWindowComponentLayout bg_cell_gallery_focus_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cell_gallery_focus_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cell_gallery_focus_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cell_gallery_focus_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cell_gallery_focus_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cell_gallery_focus_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cell_gallery_focus_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cell_gallery_focus_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cell_gallery_focus_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cell_gallery_focus_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cell_gallery_focus_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cell_gallery_focus_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cell_gallery_focus_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cell_gallery_focus_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cell_gallery_focus_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cell_gallery_focus_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cell_gallery_focus_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cell_gallery_focus_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cell_gallery_focus_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cell_gallery_focus_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cell_gallery_focus_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cell_gallery_focus_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cell_gallery_focus_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cell_gallery_focus_pane_g8)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits bg_cell_gallery_focus_pane_g_Limits()		{ return (*(Tbg_cell_gallery_focus_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cell_gallery_focus_pane_g_Limits)))(); }

inline TAknWindowComponentLayout bg_cell_gallery_focus_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cell_gallery_focus_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cell_gallery_focus_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : blid_firmament_pane
inline TAknWindowComponentLayout aid_firma_cardinal(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_firma_cardinal_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_firma_cardinal)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout blid_firmament_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid_firmament_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid_firmament_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout blid_firmament_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid_firmament_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid_firmament_pane_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout blid_firmament_pane_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid_firmament_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid_firmament_pane_t3)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout blid_firmament_pane_t4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid_firmament_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid_firmament_pane_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits blid_firmament_pane_t_Limits()		{ return (*(Tblid_firmament_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid_firmament_pane_t_Limits)))(); }

inline TAknTextComponentLayout blid_firmament_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid_firmament_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid_firmament_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout blid_sat_info_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid_sat_info_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid_sat_info_pane)))(aVariety, aCol, aRow); }

// LAF Table : blid_sat_info_pane
inline TAknWindowComponentLayout blid_sat_info_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid_sat_info_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid_sat_info_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout blid_sat_info_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid_sat_info_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid_sat_info_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits blid_sat_info_pane_g_Limits()		{ return (*(Tblid_sat_info_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid_sat_info_pane_g_Limits)))(); }

inline TAknWindowComponentLayout blid_sat_info_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid_sat_info_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid_sat_info_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout blid_sat_info_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid_sat_info_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid_sat_info_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : smil2_volume_pane
inline TAknWindowComponentLayout smil2_volume_content_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil2_volume_content_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil2_volume_content_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout smil2_volume_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil2_volume_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil2_volume_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : smil2_volume_content_pane
inline TAknWindowComponentLayout smil2_volume_content_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil2_volume_content_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil2_volume_content_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout smil2_volume_content_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil2_volume_content_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil2_volume_content_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout smil2_volume_content_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil2_volume_content_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil2_volume_content_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout smil2_volume_content_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil2_volume_content_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil2_volume_content_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout smil2_volume_content_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil2_volume_content_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil2_volume_content_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout smil2_volume_content_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil2_volume_content_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil2_volume_content_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout smil2_volume_content_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil2_volume_content_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil2_volume_content_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout smil2_volume_content_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil2_volume_content_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil2_volume_content_pane_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout smil2_volume_content_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil2_volume_content_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil2_volume_content_pane_g9)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout smil2_volume_content_pane_g10(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil2_volume_content_pane_g10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil2_volume_content_pane_g10)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits smil2_volume_content_pane_g_Limits()		{ return (*(Tsmil2_volume_content_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil2_volume_content_pane_g_Limits)))(); }

inline TAknWindowComponentLayout smil2_volume_content_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmil2_volume_content_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_smil2_volume_content_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : cale_week_day_heading_pane
inline TAknLayoutScalableParameterLimits cale_week_day_heading_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_day_heading_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_day_heading_pane_t1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_day_heading_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_day_heading_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_day_heading_pane_t2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_day_heading_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_day_heading_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_day_heading_pane_t3_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_day_heading_pane_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_day_heading_pane_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_day_heading_pane_t4_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_day_heading_pane_t5_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_day_heading_pane_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_day_heading_pane_t5_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_day_heading_pane_t6_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_day_heading_pane_t6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_day_heading_pane_t6_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_day_heading_pane_t7_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_day_heading_pane_t7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_day_heading_pane_t7_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_day_heading_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tcale_week_day_heading_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_day_heading_pane_t_ParamLimits)))(aLineIndex, aVariety); }

// LAF Table : cale_week_time_pane
inline TAknLayoutScalableParameterLimits bg_cale_side_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_cale_side_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_side_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_time_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_time_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_time_pane_t1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_time_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_time_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_time_pane_t2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_time_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_time_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_time_pane_t3_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_time_pane_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_time_pane_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_time_pane_t4_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_time_pane_t5_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_time_pane_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_time_pane_t5_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_time_pane_t6_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_time_pane_t6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_time_pane_t6_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_time_pane_t7_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_time_pane_t7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_time_pane_t7_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_time_pane_t8_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_week_time_pane_t8_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_time_pane_t8_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_week_time_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tcale_week_time_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_week_time_pane_t_ParamLimits)))(aLineIndex, aVariety); }

// LAF Table : cell_cale_week_pane
inline TAknLayoutScalableParameterLimits cell_cale_week_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_cale_week_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_cale_week_pane_g2_ParamLimits)))(aVariety); }

// LAF Table : cale_month_week_pane
inline TAknLayoutScalableParameterLimits bg_cale_side_pane_cp01_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_cale_side_pane_cp01_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cale_side_pane_cp01_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_month_week_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_week_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_week_pane_t1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_month_week_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_week_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_week_pane_t2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_month_week_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_week_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_week_pane_t3_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_month_week_pane_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_week_pane_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_week_pane_t4_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_month_week_pane_t5_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_week_pane_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_week_pane_t5_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_month_week_pane_t6_ParamLimits(TInt aVariety = 0)		{ return (*(Tcale_month_week_pane_t6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_week_pane_t6_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cale_month_week_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tcale_month_week_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cale_month_week_pane_t_ParamLimits)))(aLineIndex, aVariety); }

// LAF Table : cell_cale_month_pane
inline TAknLayoutScalableParameterLimits cell_cale_month_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_cale_month_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_cale_month_pane_g1_ParamLimits)))(aVariety); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_cale_event_viewer_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cale_event_viewer_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cale_event_viewer_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_cale_event_viewer_pane
inline TAknWindowComponentLayout listscroll_cale_event_viewer_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_cale_event_viewer_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_cale_event_viewer_pane)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_cale_event_viewer_pane
inline TAknWindowComponentLayout list_cale_ev_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_cale_ev_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_ev_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp023(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp023_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp023)))(aVariety, aCol, aRow); }

// LAF Table : list_cale_ev_pane
inline TAknLayoutScalableParameterLimits field_cale_ev_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tfield_cale_ev_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout field_cale_ev_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfield_cale_ev_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev_pane)))(aVariety, aCol, aRow); }

// LAF Table : field_cale_ev_pane
inline TAknLayoutScalableParameterLimits field_cale_ev_content_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tfield_cale_ev_content_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev_content_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout field_cale_ev_content_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfield_cale_ev_content_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev_content_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits field_cale_ev_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tfield_cale_ev_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout field_cale_ev_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfield_cale_ev_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits field_cale_ev_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tfield_cale_ev_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout field_cale_ev_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfield_cale_ev_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits field_cale_ev_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tfield_cale_ev_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout field_cale_ev_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfield_cale_ev_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits field_cale_ev_pane_g_Limits()		{ return (*(Tfield_cale_ev_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits field_cale_ev_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tfield_cale_ev_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout field_cale_ev_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfield_cale_ev_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits field_cale_ev_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tfield_cale_ev_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout field_cale_ev_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfield_cale_ev_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : field_cale_ev_content_pane
inline TAknLayoutScalableParameterLimits field_cale_ev_content_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tfield_cale_ev_content_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev_content_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout field_cale_ev_content_pane_t1(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tfield_cale_ev_content_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev_content_pane_t1)))(aRow, aVariety, aCol); }

// LAF Table : msg_header_pane
inline TAknWindowComponentLayout bg_button_pane_cp01(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp01)))(aVariety, aCol, aRow); }

// LAF Table : main_cale_week_pane
inline TAknLayoutScalableParameterLimits listscroll_cale_week_pane_ParamLimits(TInt aVariety)		{ return (*(Tlistscroll_cale_week_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_cale_week_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_toolbar_window_cp01(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_toolbar_window_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_toolbar_window_cp01)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_cale_week_pane
inline TAknLayoutScalableParameterLimits listscroll_cale_week_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tlistscroll_cale_week_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_cale_week_pane_t1_ParamLimits)))(aVariety); }

// LAF Table : main_cale_day_pane
inline TAknLayoutScalableParameterLimits listscroll_cale_day_pane_ParamLimits(TInt aVariety)		{ return (*(Tlistscroll_cale_day_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_cale_day_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_toolbar_window_cp02(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_toolbar_window_cp02_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_toolbar_window_cp02)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_cale_day_pane
inline TAknLayoutScalableParameterLimits listscroll_cale_day_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tlistscroll_cale_day_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_cale_day_pane_t1_ParamLimits)))(aVariety); }

// LAF Table : main_pane
inline TAknLayoutScalableParameterLimits main_cale_month_pane_ParamLimits(TInt aVariety)		{ return (*(Tmain_cale_month_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cale_month_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits popup_toolbar_window_cp03_ParamLimits(TInt aVariety)		{ return (*(Tpopup_toolbar_window_cp03_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_toolbar_window_cp03_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_toolbar_window_cp03(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_toolbar_window_cp03_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_toolbar_window_cp03)))(aVariety, aCol, aRow); }

// LAF Table : main_image_pane
inline TAknLayoutScalableParameterLimits main_image_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Tmain_image_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_image_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_image_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_image_pane_g3_ParamLimits(TInt aVariety)		{ return (*(Tmain_image_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_image_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_image_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_image_pane_g_Limits()		{ return (*(Tmain_image_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_image_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmain_image_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout main_image_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_image_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_image_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tmain_image_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image_pane_t1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits main_image_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tmain_image_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_image_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_image_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_image_pane_t3_ParamLimits(TInt aVariety)		{ return (*(Tmain_image_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_image_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_image_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_image_pane_t4_ParamLimits(TInt aVariety)		{ return (*(Tmain_image_pane_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image_pane_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_image_pane_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_image_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image_pane_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_image_pane_t_Limits()		{ return (*(Tmain_image_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_image_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmain_image_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout main_image_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_image_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_image_details_window_cp01(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image_details_window_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image_details_window_cp01)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_toobar_trans_pane_cp01_ParamLimits(TInt aVariety)		{ return (*(Tpopup_toobar_trans_pane_cp01_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_toobar_trans_pane_cp01_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_toobar_trans_pane_cp01(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_toobar_trans_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_toobar_trans_pane_cp01)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknLayoutScalableParameterLimits popup_image_details_window_ParamLimits(TInt aVariety)		{ return (*(Tpopup_image_details_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image_details_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_image_details_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image_details_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image_details_window)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_image_focus_window(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image_focus_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image_focus_window)))(aVariety, aCol, aRow); }

// LAF Table : main_camera2_pane
inline TAknLayoutScalableParameterLimits camera2_autofocus_pane_ParamLimits(TInt aVariety)		{ return (*(Tcamera2_autofocus_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_camera2_autofocus_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout camera2_autofocus_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcamera2_autofocus_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_camera2_autofocus_pane)))(aVariety, aCol, aRow); }

// LAF Table : popup_image_focus_window
inline TAknWindowComponentLayout bg_popup_sub_pane_cp06(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp06_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp06)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_image_focus_window_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image_focus_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image_focus_window_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_image_focus_window_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image_focus_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image_focus_window_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_image_focus_window_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image_focus_window_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image_focus_window_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_image_focus_window_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image_focus_window_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image_focus_window_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_image_focus_window_g_Limits()		{ return (*(Tpopup_image_focus_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image_focus_window_g_Limits)))(); }

inline TAknWindowComponentLayout popup_image_focus_window_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image_focus_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image_focus_window_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_image_focus_window_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image_focus_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image_focus_window_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_image_focus_window_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image_focus_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image_focus_window_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_image_focus_window_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image_focus_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image_focus_window_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_image_focus_window_t_Limits()		{ return (*(Tpopup_image_focus_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image_focus_window_t_Limits)))(); }

inline TAknTextComponentLayout popup_image_focus_window_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image_focus_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image_focus_window_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : camera2_autofocus_pane
inline TAknWindowComponentLayout camera2_autofocus_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcamera2_autofocus_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_camera2_autofocus_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : popup_image_details_window
inline TAknWindowComponentLayout bg_tb_trans_pane_cp01(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_tb_trans_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_tb_trans_pane_cp01)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_image_details_window_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image_details_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image_details_window_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_image_details_window_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image_details_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image_details_window_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_image_details_window_g_Limits()		{ return (*(Tpopup_image_details_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image_details_window_g_Limits)))(); }

inline TAknWindowComponentLayout popup_image_details_window_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image_details_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image_details_window_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_image_details_window_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image_details_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image_details_window_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_image_details_window_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image_details_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image_details_window_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_image_details_window_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image_details_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image_details_window_t3)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_image_details_window_t4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image_details_window_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image_details_window_t4)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_image_details_window_t5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image_details_window_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image_details_window_t5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_image_details_window_t_Limits()		{ return (*(Tpopup_image_details_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image_details_window_t_Limits)))(); }

inline TAknTextComponentLayout popup_image_details_window_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image_details_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image_details_window_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : calc_paper_pane
inline TAknLayoutScalableParameterLimits bg_calc_paper_pane_ParamLimits(TInt aVariety)		{ return (*(Tbg_calc_paper_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_paper_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_highlight_pane_cp013(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_cp013_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp013)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_calc_pane_ParamLimits(TInt aVariety)		{ return (*(Tlist_calc_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_calc_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout scroll_pane_cp024(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp024_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp024)))(aVariety, aCol, aRow); }

// LAF Table : calc_display_pane
inline TAknLayoutScalableParameterLimits bg_calc_display_pane_ParamLimits(TInt aVariety)		{ return (*(Tbg_calc_display_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_display_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits calc_display_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tcalc_display_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_calc_display_pane_t1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits calc_display_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tcalc_display_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_calc_display_pane_t2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits calc_display_pane_t3_ParamLimits(TInt aVariety)		{ return (*(Tcalc_display_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_calc_display_pane_t3_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits calc_display_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tcalc_display_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_calc_display_pane_t_ParamLimits)))(aLineIndex, aVariety); }

// LAF Table : cell_calc_pane
inline TAknWindowComponentLayout cell_calc_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_calc_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_calc_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_calc_pane_g_Limits()		{ return (*(Tcell_calc_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_calc_pane_g_Limits)))(); }

inline TAknWindowComponentLayout cell_calc_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_calc_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_calc_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout cell_calc_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_calc_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_calc_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_highlight_pane_cp02_ParamLimits(TInt aVariety)		{ return (*(Tgrid_highlight_pane_cp02_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp02_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits toolbar_button_pane_cp01_ParamLimits(TInt aVariety)		{ return (*(Ttoolbar_button_pane_cp01_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_toolbar_button_pane_cp01_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout toolbar_button_pane_cp01(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttoolbar_button_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_toolbar_button_pane_cp01)))(aVariety, aCol, aRow); }

// LAF Table : main_image_pane
inline TAknLayoutScalableParameterLimits temp_image_control_pane_ParamLimits(TInt aVariety)		{ return (*(Ttemp_image_control_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_temp_image_control_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout temp_image_control_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttemp_image_control_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_temp_image_control_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_mp3_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp3_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane)))(aVariety, aCol, aRow); }

// LAF Table : temp_image_control_pane
inline TAknLayoutScalableParameterLimits temp_image_control_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Ttemp_image_control_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_temp_image_control_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout temp_image_control_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttemp_image_control_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_temp_image_control_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits temp_image_control_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Ttemp_image_control_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_temp_image_control_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout temp_image_control_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttemp_image_control_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_temp_image_control_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits temp_image_control_pane_g3_ParamLimits(TInt aVariety)		{ return (*(Ttemp_image_control_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_temp_image_control_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout temp_image_control_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttemp_image_control_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_temp_image_control_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits temp_image_control_pane_g4_ParamLimits(TInt aVariety)		{ return (*(Ttemp_image_control_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_temp_image_control_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout temp_image_control_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttemp_image_control_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_temp_image_control_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits temp_image_control_pane_g_Limits()		{ return (*(Ttemp_image_control_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_temp_image_control_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits temp_image_control_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Ttemp_image_control_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_temp_image_control_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout temp_image_control_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttemp_image_control_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_temp_image_control_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_mp3_pane
inline TAknWindowComponentLayout main_mp3_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp3_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_mp3_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp3_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_mp3_pane_g_Limits()		{ return (*(Tmain_mp3_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_g_Limits)))(); }

inline TAknWindowComponentLayout main_mp3_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp3_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_mp3_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp3_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : main_camera_pane
inline TAknLayoutScalableParameterLimits main_camera_pane_g8_ParamLimits(TInt aVariety)		{ return (*(Tmain_camera_pane_g8_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane_g8_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_camera_pane_g8(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera_pane_g8)))(aVariety, aCol, aRow); }

// LAF Table : main_video_pane
inline TAknLayoutScalableParameterLimits main_video_pane_g7_ParamLimits(TInt aVariety)		{ return (*(Tmain_video_pane_g7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_pane_g7_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_video_pane_g7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_pane_g7)))(aVariety, aCol, aRow); }

// LAF Table : main_camera2_pane
inline TAknLayoutScalableParameterLimits main_camera2_pane_t7_ParamLimits(TInt aVariety)		{ return (*(Tmain_camera2_pane_t7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_t7_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_camera2_pane_t7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera2_pane_t7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera2_pane_t7)))(aVariety, aCol, aRow); }

// LAF Table : main_browser_pane
inline TAknLayoutScalableParameterLimits scroll_pane_cp025_ParamLimits(TInt aVariety)		{ return (*(Tscroll_pane_cp025_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp025_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout scroll_pane_cp025(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp025_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp025)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits scroll_pane_cp026_ParamLimits(TInt aVariety)		{ return (*(Tscroll_pane_cp026_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp026_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout scroll_pane_cp026(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp026_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp026)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits wml_content_pane_ParamLimits(TInt aVariety)		{ return (*(Twml_content_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wml_content_pane_ParamLimits)))(aVariety); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_touch_calib_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_touch_calib_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_touch_calib_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_touch_calib_pane
inline TAknWindowComponentLayout main_touch_calib_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_touch_calib_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_touch_calib_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_touch_calib_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_touch_calib_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_touch_calib_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_touch_calib_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_touch_calib_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_touch_calib_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_touch_calib_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_touch_calib_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_touch_calib_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_touch_calib_pane_g_Limits()		{ return (*(Tmain_touch_calib_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_touch_calib_pane_g_Limits)))(); }

inline TAknWindowComponentLayout main_touch_calib_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_touch_calib_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_touch_calib_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_touch_calib_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_touch_calib_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_touch_calib_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_touch_calib_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_touch_calib_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_touch_calib_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_touch_calib_pane_t_Limits()		{ return (*(Tmain_touch_calib_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_touch_calib_pane_t_Limits)))(); }

inline TAknTextComponentLayout main_touch_calib_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_touch_calib_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_touch_calib_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : navi_pane
inline TAknWindowComponentLayout mup_progress_pane_cp02(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_progress_pane_cp02_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_progress_pane_cp02)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout navi_pane_mp_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_mp_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_mp_t3)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknLayoutScalableParameterLimits main_mp3_pane_ParamLimits(TInt aVariety)		{ return (*(Tmain_mp3_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_ParamLimits)))(aVariety); }

// LAF Table : status_pane
inline TAknLayoutScalableParameterLimits navi_pane_ParamLimits(TInt aVariety)		{ return (*(Tnavi_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_ParamLimits)))(aVariety); }

// LAF Table : main_mp3_pane
inline TAknLayoutScalableParameterLimits main_mp3_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tmain_mp3_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_g1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits main_mp3_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Tmain_mp3_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_g2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits main_mp3_pane_g3_ParamLimits(TInt aVariety)		{ return (*(Tmain_mp3_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mp3_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp3_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mp3_pane_g4_ParamLimits(TInt aVariety)		{ return (*(Tmain_mp3_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mp3_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp3_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mp3_pane_g5_ParamLimits(TInt aVariety)		{ return (*(Tmain_mp3_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mp3_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp3_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mp3_pane_g6_ParamLimits(TInt aVariety)		{ return (*(Tmain_mp3_pane_g6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_g6_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mp3_pane_g6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp3_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_g6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mp3_pane_g7_ParamLimits(TInt aVariety)		{ return (*(Tmain_mp3_pane_g7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_g7_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mp3_pane_g7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp3_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_g7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mp3_pane_g8_ParamLimits(TInt aVariety)		{ return (*(Tmain_mp3_pane_g8_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_g8_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mp3_pane_g8(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp3_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_g8)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mp3_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tmain_mp3_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout main_mp3_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp3_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_mp3_pane_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp3_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_t3)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_mp3_pane_t4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp3_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_t4)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_mp3_pane_t5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp3_pane_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_t5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_mp3_pane_t_Limits()		{ return (*(Tmain_mp3_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_t_Limits)))(); }

inline TAknTextComponentLayout main_mp3_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp3_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp3_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup_progress_pane_cp01(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_progress_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_progress_pane_cp01)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout aid_zoom_text_secondary2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_zoom_text_secondary2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_zoom_text_secondary2)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_cale_event_viewer_pane
inline TAknWindowComponentLayout list_cale_ev2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_cale_ev2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_cale_ev2_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits scroll_pane_cp023_ParamLimits(TInt aVariety)		{ return (*(Tscroll_pane_cp023_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp023_ParamLimits)))(aVariety); }

// LAF Table : list_cale_ev2_pane
inline TAknLayoutScalableParameterLimits field_cale_ev2_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tfield_cale_ev2_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev2_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout field_cale_ev2_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tfield_cale_ev2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev2_pane)))(aRow, aVariety, aCol); }

// LAF Table : field_cale_ev2_pane
inline TAknLayoutScalableParameterLimits field_cale_ev2_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tfield_cale_ev2_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev2_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout field_cale_ev2_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfield_cale_ev2_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev2_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits field_cale_ev2_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Tfield_cale_ev2_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev2_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout field_cale_ev2_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfield_cale_ev2_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev2_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits field_cale_ev2_pane_g3_ParamLimits(TInt aVariety)		{ return (*(Tfield_cale_ev2_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev2_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout field_cale_ev2_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfield_cale_ev2_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev2_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits field_cale_ev2_pane_g_Limits()		{ return (*(Tfield_cale_ev2_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev2_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits field_cale_ev2_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tfield_cale_ev2_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev2_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout field_cale_ev2_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfield_cale_ev2_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev2_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits field_cale_ev2_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tfield_cale_ev2_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev2_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout field_cale_ev2_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfield_cale_ev2_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev2_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits field_cale_ev2_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tfield_cale_ev2_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev2_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout field_cale_ev2_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfield_cale_ev2_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev2_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits field_cale_ev2_pane_t_Limits()		{ return (*(Tfield_cale_ev2_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev2_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits field_cale_ev2_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tfield_cale_ev2_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev2_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout field_cale_ev2_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfield_cale_ev2_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_cale_ev2_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_postcard_pane
inline TAknLayoutScalableParameterLimits main_postcard_pane_g5_ParamLimits(TInt aVariety)		{ return (*(Tmain_postcard_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_postcard_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_postcard_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_postcard_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_postcard_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_postcard_pane_g6_ParamLimits(TInt aVariety)		{ return (*(Tmain_postcard_pane_g6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_postcard_pane_g6_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_postcard_pane_g6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_postcard_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_postcard_pane_g6)))(aVariety, aCol, aRow); }

// LAF Table : main_camera_pane
inline TAknLayoutScalableParameterLimits camera2_autofocus_pane_cp_ParamLimits(TInt aVariety)		{ return (*(Tcamera2_autofocus_pane_cp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_camera2_autofocus_pane_cp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout camera2_autofocus_pane_cp(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcamera2_autofocus_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_camera2_autofocus_pane_cp)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_mup3_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup3_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_mup3_pane
inline TAknLayoutScalableParameterLimits main_mup3_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tmain_mup3_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup3_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup3_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup3_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Tmain_mup3_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup3_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup3_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup3_pane_g3_ParamLimits(TInt aVariety)		{ return (*(Tmain_mup3_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup3_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup3_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup3_pane_g4_ParamLimits(TInt aVariety)		{ return (*(Tmain_mup3_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup3_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup3_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup3_pane_g5_ParamLimits(TInt aVariety)		{ return (*(Tmain_mup3_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup3_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup3_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup3_pane_g6_ParamLimits(TInt aVariety)		{ return (*(Tmain_mup3_pane_g6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_g6_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup3_pane_g6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup3_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_g6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup3_pane_g7_ParamLimits(TInt aVariety)		{ return (*(Tmain_mup3_pane_g7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_g7_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup3_pane_g7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup3_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_g7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_mup3_pane_g_Limits()		{ return (*(Tmain_mup3_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_mup3_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tmain_mup3_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout main_mup3_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup3_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup3_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tmain_mup3_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup3_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup3_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup3_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tmain_mup3_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup3_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup3_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup3_pane_t4_ParamLimits(TInt aVariety)		{ return (*(Tmain_mup3_pane_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup3_pane_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup3_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup3_pane_t5_ParamLimits(TInt aVariety)		{ return (*(Tmain_mup3_pane_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_t5_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup3_pane_t5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup3_pane_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_t5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mup3_pane_t6_ParamLimits(TInt aVariety)		{ return (*(Tmain_mup3_pane_t6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_t6_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mup3_pane_t6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup3_pane_t6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_t6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_mup3_pane_t_Limits()		{ return (*(Tmain_mup3_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_mup3_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tmain_mup3_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout main_mup3_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup3_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits mup3_progress_pane_ParamLimits(TInt aVariety)		{ return (*(Tmup3_progress_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_progress_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup3_progress_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup3_progress_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_progress_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_mup3_control_window_ParamLimits(TInt aVariety)		{ return (*(Tpopup_mup3_control_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_mup3_control_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_mup3_control_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_mup3_control_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_mup3_control_window)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_mup3_text_window(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_mup3_text_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_mup3_text_window)))(aVariety, aCol, aRow); }

// LAF Table : mup3_progress_pane
inline TAknTextComponentLayout mup3_progress_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup3_progress_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_progress_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout mup3_progress_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup3_progress_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_progress_pane_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout mup3_progress_pane_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup3_progress_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_progress_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits mup3_progress_pane_t_Limits()		{ return (*(Tmup3_progress_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_progress_pane_t_Limits)))(); }

inline TAknTextComponentLayout mup3_progress_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup3_progress_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_progress_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup_progress_pane_cp03(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_progress_pane_cp03_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_progress_pane_cp03)))(aVariety, aCol, aRow); }

// LAF Table : popup_mup3_control_window
inline TAknWindowComponentLayout bg_tb_trans_pane_cp04(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_tb_trans_pane_cp04_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_tb_trans_pane_cp04)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup3_volume_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup3_volume_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_volume_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_mup3_control_window_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_mup3_control_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_mup3_control_window_g1)))(aVariety, aCol, aRow); }

// LAF Table : mup3_volume_pane
inline TAknWindowComponentLayout mup3_volume_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup3_volume_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_volume_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup3_volume_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup3_volume_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_volume_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup3_volume_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup3_volume_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_volume_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits mup3_volume_pane_g_Limits()		{ return (*(Tmup3_volume_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_volume_pane_g_Limits)))(); }

inline TAknWindowComponentLayout mup3_volume_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup3_volume_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_volume_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_mup3_text_window
inline TAknWindowComponentLayout bg_tb_trans_pane_cp03(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_tb_trans_pane_cp03_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_tb_trans_pane_cp03)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_mup3_text_window_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_mup3_text_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_mup3_text_window_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_mup3_text_window_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_mup3_text_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_mup3_text_window_t1)))(aVariety, aCol, aRow); }

// LAF Table : list_calc_item_pane
inline TAknLayoutScalableParameterLimits list_calc_item_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tlist_calc_item_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_calc_item_pane_g1_ParamLimits)))(aVariety); }

// LAF Table : mup_volume_pane_cp
inline TAknWindowComponentLayout mup_volume_pane_cp_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_volume_pane_cp_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_volume_pane_cp_g1)))(aVariety, aCol, aRow); }

// LAF Table : main_touch_calib_pane
inline TAknTextComponentLayout main_touch_calib_pane_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_touch_calib_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_touch_calib_pane_t3)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_touch_calib_pane_t4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_touch_calib_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_touch_calib_pane_t4)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_touch_calib_pane_t5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_touch_calib_pane_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_touch_calib_pane_t5)))(aVariety, aCol, aRow); }

// LAF Table : application_window
inline TAknWindowComponentLayout aid_cell_size_toolbar2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_cell_size_toolbar2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_cell_size_toolbar2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout aid_popup3_width_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_popup3_width_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_popup3_width_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout aid_zoom_text_msg_primary(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_zoom_text_msg_primary_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_zoom_text_msg_primary)))(aVariety, aCol, aRow); }

// LAF Table : main_vorec_pane
inline TAknTextComponentLayout vorec_t7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvorec_t7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vorec_t7)))(aVariety, aCol, aRow); }

// LAF Table : bg_calc_paper_pane
inline TAknLayoutScalableParameterLimits bg_calc_paper_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tbg_calc_paper_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_paper_pane_g1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits bg_calc_paper_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Tbg_calc_paper_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_paper_pane_g2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits bg_calc_paper_pane_g3_ParamLimits(TInt aVariety)		{ return (*(Tbg_calc_paper_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_paper_pane_g3_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits bg_calc_paper_pane_g4_ParamLimits(TInt aVariety)		{ return (*(Tbg_calc_paper_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_paper_pane_g4_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits bg_calc_paper_pane_g5_ParamLimits(TInt aVariety)		{ return (*(Tbg_calc_paper_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_paper_pane_g5_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits bg_calc_paper_pane_g6_ParamLimits(TInt aVariety)		{ return (*(Tbg_calc_paper_pane_g6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_paper_pane_g6_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits bg_calc_paper_pane_g7_ParamLimits(TInt aVariety)		{ return (*(Tbg_calc_paper_pane_g7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_paper_pane_g7_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits bg_calc_paper_pane_g8_ParamLimits(TInt aVariety)		{ return (*(Tbg_calc_paper_pane_g8_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_paper_pane_g8_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits bg_calc_paper_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tbg_calc_paper_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_calc_paper_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknLayoutScalableParameterLimits calc_bg_paper_pane_g9_ParamLimits(TInt aVariety)		{ return (*(Tcalc_bg_paper_pane_g9_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_calc_bg_paper_pane_g9_ParamLimits)))(aVariety); }

// LAF Table : main_video_pane
inline TAknLayoutScalableParameterLimits image_qvga_pane_ParamLimits(TInt aVariety)		{ return (*(Timage_qvga_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_image_qvga_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout image_qvga_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Timage_qvga_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_image_qvga_pane)))(aVariety, aCol, aRow); }

// LAF Table : popup_mup_playback_window
inline TAknLayoutScalableParameterLimits bg_popup_sub_pane_cp04_ParamLimits(TInt aVariety)		{ return (*(Tbg_popup_sub_pane_cp04_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp04_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits popup_mup_playback_window_g1_ParamLimits(TInt aVariety)		{ return (*(Tpopup_mup_playback_window_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_mup_playback_window_g1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits popup_mup_playback_window_t1_ParamLimits(TInt aVariety)		{ return (*(Tpopup_mup_playback_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_mup_playback_window_t1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits popup_mup_playback_window_t2_ParamLimits(TInt aVariety)		{ return (*(Tpopup_mup_playback_window_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_mup_playback_window_t2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits popup_mup_playback_window_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tpopup_mup_playback_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_mup_playback_window_t_ParamLimits)))(aLineIndex, aVariety); }

// LAF Table : main_mup2_pane
inline TAknLayoutScalableParameterLimits main_mup2_pane_g3_ParamLimits(TInt aVariety)		{ return (*(Tmain_mup2_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup2_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup2_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup2_pane_g3)))(aVariety, aCol, aRow); }

// LAF Table : main_video_tele_pane
inline TAknWindowComponentLayout popup_toolbar_window_cp04(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_toolbar_window_cp04_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_toolbar_window_cp04)))(aVariety, aCol, aRow); }

// LAF Table : popup_call2_audio_second_window
inline TAknLayoutScalableParameterLimits popup_call2_audio_second_window_g3_ParamLimits(TInt aVariety)		{ return (*(Tpopup_call2_audio_second_window_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_second_window_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call2_audio_second_window_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_second_window_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_second_window_g3)))(aVariety, aCol, aRow); }

// LAF Table : popup_call2_audio_first_window
inline TAknLayoutScalableParameterLimits popup_call2_audio_first_window_g4_ParamLimits(TInt aVariety)		{ return (*(Tpopup_call2_audio_first_window_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_first_window_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call2_audio_first_window_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_first_window_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_first_window_g4)))(aVariety, aCol, aRow); }

// LAF Table : popup_call2_audio_in_window
inline TAknLayoutScalableParameterLimits popup_call2_audio_in_window_g4_ParamLimits(TInt aVariety)		{ return (*(Tpopup_call2_audio_in_window_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call2_audio_in_window_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_in_window_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_in_window_g4)))(aVariety, aCol, aRow); }

// LAF Table : main_image_pane
inline TAknLayoutScalableParameterLimits aid_area_sk_bg_cut_ParamLimits(TInt aVariety)		{ return (*(Taid_area_sk_bg_cut_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_area_sk_bg_cut_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_area_sk_bg_cut(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_area_sk_bg_cut_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_area_sk_bg_cut)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits aid_area_sk_bg_cut_2_ParamLimits(TInt aVariety)		{ return (*(Taid_area_sk_bg_cut_2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_area_sk_bg_cut_2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_area_sk_bg_cut_2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_area_sk_bg_cut_2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_area_sk_bg_cut_2)))(aVariety, aCol, aRow); }

// LAF Table : cell_gallery_pane
inline TAknWindowComponentLayout aid_placing_details_win(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_placing_details_win_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_placing_details_win)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout aid_placing_details_win_2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_placing_details_win_2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_placing_details_win_2)))(aVariety, aCol, aRow); }

// LAF Table : camera2_autofocus_pane
inline TAknLayoutScalableParameterLimits camera2_autofocus_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tcamera2_autofocus_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_camera2_autofocus_pane_g1_ParamLimits)))(aVariety); }

// LAF Table : application_window
inline TAknLayoutScalableParameterLimits popup_fixed_preview_cale_window_ParamLimits(TInt aVariety)		{ return (*(Tpopup_fixed_preview_cale_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fixed_preview_cale_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_fixed_preview_cale_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_fixed_preview_cale_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fixed_preview_cale_window)))(aVariety, aCol, aRow); }

// LAF Table : navi_slider_pane
inline TAknWindowComponentLayout navi_slider_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_slider_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_slider_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_slider_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_slider_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_slider_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_slider_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_slider_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_slider_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_slider_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_slider_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_slider_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_slider_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_slider_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_slider_pane_g7)))(aVariety, aCol, aRow); }

// LAF Table : mup_scale_pane
inline TAknWindowComponentLayout mup_scale_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_scale_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_scale_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup_scale_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_scale_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_scale_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup_scale_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_scale_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_scale_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup_scale_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_scale_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_scale_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup_scale_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_scale_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_scale_pane_g7)))(aVariety, aCol, aRow); }

// LAF Table : cams2_slider_pane
inline TAknWindowComponentLayout cams2_slider_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcams2_slider_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams2_slider_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cams2_slider_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcams2_slider_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams2_slider_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cams2_slider_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcams2_slider_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams2_slider_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cams2_slider_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcams2_slider_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams2_slider_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cams2_slider_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcams2_slider_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams2_slider_pane_g7)))(aVariety, aCol, aRow); }

// LAF Table : camera2_autofocus_pane_cp
inline TAknWindowComponentLayout camera2_autofocus_pane_cp_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcamera2_autofocus_pane_cp_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_camera2_autofocus_pane_cp_g1)))(aVariety, aCol, aRow); }

// LAF Table : popup_fixed_preview_cale_window
inline TAknLayoutScalableParameterLimits bg_popup_preview_window_pane_cp02_ParamLimits(TInt aVariety)		{ return (*(Tbg_popup_preview_window_pane_cp02_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_preview_window_pane_cp02_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_preview_window_pane_cp02(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_preview_window_pane_cp02_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_preview_window_pane_cp02)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_fp_cale_pane_ParamLimits(TInt aVariety)		{ return (*(Tlist_fp_cale_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_fp_cale_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_fp_cale_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_fp_cale_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_fp_cale_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_fixed_preview_cale_window_t1_ParamLimits(TInt aVariety)		{ return (*(Tpopup_fixed_preview_cale_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fixed_preview_cale_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_fixed_preview_cale_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_fixed_preview_cale_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fixed_preview_cale_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_fixed_preview_cale_window_t2_ParamLimits(TInt aVariety)		{ return (*(Tpopup_fixed_preview_cale_window_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fixed_preview_cale_window_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_fixed_preview_cale_window_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_fixed_preview_cale_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fixed_preview_cale_window_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_fixed_preview_cale_window_t3_ParamLimits(TInt aVariety)		{ return (*(Tpopup_fixed_preview_cale_window_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fixed_preview_cale_window_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_fixed_preview_cale_window_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_fixed_preview_cale_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fixed_preview_cale_window_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_fixed_preview_cale_window_t_Limits()		{ return (*(Tpopup_fixed_preview_cale_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fixed_preview_cale_window_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_fixed_preview_cale_window_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tpopup_fixed_preview_cale_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fixed_preview_cale_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_fixed_preview_cale_window_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_fixed_preview_cale_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fixed_preview_cale_window_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_fp_cale_pane
inline TAknLayoutScalableParameterLimits list_single_fp_cale_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_fp_cale_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_fp_cale_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_fp_cale_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_fp_cale_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_fp_cale_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_single_fp_cale_pane
inline TAknLayoutScalableParameterLimits list_single_fp_cale_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tlist_single_fp_cale_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_fp_cale_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_fp_cale_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_fp_cale_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_fp_cale_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_fp_cale_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Tlist_single_fp_cale_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_fp_cale_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_fp_cale_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_fp_cale_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_fp_cale_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_fp_cale_pane_g_Limits()		{ return (*(Tlist_single_fp_cale_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_fp_cale_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_fp_cale_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tlist_single_fp_cale_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_fp_cale_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_single_fp_cale_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_fp_cale_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_fp_cale_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_fp_cale_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tlist_single_fp_cale_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_fp_cale_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_fp_cale_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_fp_cale_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_fp_cale_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_fp_cale_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tlist_single_fp_cale_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_fp_cale_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_fp_cale_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_fp_cale_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_fp_cale_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_fp_cale_pane_t_Limits()		{ return (*(Tlist_single_fp_cale_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_fp_cale_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_fp_cale_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tlist_single_fp_cale_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_fp_cale_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_single_fp_cale_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_fp_cale_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_fp_cale_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// Generic API
inline TAknLayoutScalableComponentType GetComponentTypeById(TInt aComponentId)		{ return (*(TGetComponentTypeById_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_GetComponentTypeById)))(aComponentId); }

inline TAknLayoutScalableParameterLimits GetParamLimitsById(TInt aComponentId, TInt aVariety)		{ return (*(TGetParamLimitsById_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_GetParamLimitsById)))(aComponentId, aVariety); }

inline TAknWindowComponentLayout GetWindowComponentById(TInt aComponentId, TInt aVariety, TInt aCol, TInt aRow)		{ return (*(TGetWindowComponentById_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_GetWindowComponentById)))(aComponentId, aVariety, aCol, aRow); }

inline TAknTextComponentLayout GetTextComponentById(TInt aComponentId, TInt aVariety, TInt aCol, TInt aRow)		{ return (*(TGetTextComponentById_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_GetTextComponentById)))(aComponentId, aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_dialer_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_dialer_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_dialer_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_dialer_pane
inline TAknWindowComponentLayout aid_cell_size_keypad(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_cell_size_keypad_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_cell_size_keypad)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout dialer_ne_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tdialer_ne_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_dialer_ne_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_dialer_command_1_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_dialer_command_1_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_dialer_command_1_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_dialer_command_2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_dialer_command_2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_dialer_command_2_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_dialer_keypad_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_dialer_keypad_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_dialer_keypad_pane)))(aVariety, aCol, aRow); }

// LAF Table : dialer_ne_pane
inline TAknLayoutScalableParameterLimits bg_popup_call_pane_cp06_ParamLimits(TInt aVariety)		{ return (*(Tbg_popup_call_pane_cp06_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_pane_cp06_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_call_pane_cp06(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_pane_cp06_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_pane_cp06)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits dialer_ne_clear_pane_ParamLimits(TInt aVariety)		{ return (*(Tdialer_ne_clear_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_dialer_ne_clear_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout dialer_ne_clear_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tdialer_ne_clear_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_dialer_ne_clear_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout dialer_ne_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tdialer_ne_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_dialer_ne_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits dialer_ne_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tdialer_ne_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_dialer_ne_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout dialer_ne_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tdialer_ne_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_dialer_ne_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits dialer_ne_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tdialer_ne_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_dialer_ne_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout dialer_ne_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tdialer_ne_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_dialer_ne_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits dialer_ne_pane_t3_ParamLimits(TInt aVariety)		{ return (*(Tdialer_ne_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_dialer_ne_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout dialer_ne_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tdialer_ne_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_dialer_ne_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits dialer_ne_pane_t_Limits()		{ return (*(Tdialer_ne_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_dialer_ne_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits dialer_ne_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tdialer_ne_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_dialer_ne_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout dialer_ne_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tdialer_ne_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_dialer_ne_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits dialer_ne_pane_t3_copy1_ParamLimits(TInt aVariety)		{ return (*(Tdialer_ne_pane_t3_copy1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_dialer_ne_pane_t3_copy1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout dialer_ne_pane_t3_copy1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tdialer_ne_pane_t3_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_dialer_ne_pane_t3_copy1)))(aVariety, aCol, aRow); }

// LAF Table : grid_dialer_keypad_pane
inline TAknLayoutScalableParameterLimits cell_dialer_keypad_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_dialer_keypad_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_dialer_keypad_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_dialer_keypad_pane(TInt aCol, TInt aRow, TInt aVariety = 0)		{ return (*(Tcell_dialer_keypad_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_dialer_keypad_pane)))(aCol, aRow, aVariety); }

// LAF Table : grid_dialer_command_1_pane
inline TAknLayoutScalableParameterLimits cell_dialer_command_1_pane_ParamLimits(TInt aVariety)		{ return (*(Tcell_dialer_command_1_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_dialer_command_1_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_dialer_command_1_pane(TInt aVariety, TInt aRow, TInt aCol = 0)		{ return (*(Tcell_dialer_command_1_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_dialer_command_1_pane)))(aVariety, aRow, aCol); }

// LAF Table : grid_dialer_command_2_pane
inline TAknLayoutScalableParameterLimits cell_dialer_command_2_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_dialer_command_2_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_dialer_command_2_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_dialer_command_2_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tcell_dialer_command_2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_dialer_command_2_pane)))(aRow, aVariety, aCol); }

// LAF Table : cell_dialer_keypad_pane
inline TAknLayoutScalableParameterLimits bg_button_pane_cp02_ParamLimits(TInt aVariety)		{ return (*(Tbg_button_pane_cp02_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp02_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_button_pane_cp02(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_cp02_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp02)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_dialer_keypad_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tcell_dialer_keypad_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_dialer_keypad_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_dialer_keypad_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_dialer_keypad_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_dialer_keypad_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : cell_dialer_command_1_pane
inline TAknLayoutScalableParameterLimits bg_button_pane_cp03_ParamLimits(TInt aVariety)		{ return (*(Tbg_button_pane_cp03_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp03_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_button_pane_cp03(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_cp03_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp03)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_dialer_command_1_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tcell_dialer_command_1_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_dialer_command_1_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_dialer_command_1_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_dialer_command_1_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_dialer_command_1_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : cell_dialer_command_2_pane
inline TAknWindowComponentLayout bg_button_pane_cp04(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_cp04_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp04)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_dialer_command_2_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_dialer_command_2_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_dialer_command_2_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : dialer_ne_clear_pane
inline TAknWindowComponentLayout bg_button_pane_cp06(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_cp06_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp06)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout dialer_ne_clear_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tdialer_ne_clear_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_dialer_ne_clear_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : navi_pane
inline TAknWindowComponentLayout navi_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits navi_pane_g_Limits()		{ return (*(Tnavi_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_g_Limits)))(); }

inline TAknWindowComponentLayout navi_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_pane_mv_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_mv_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_mv_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_pane_mv_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_mv_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_mv_g5)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout navi_pane_mv_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_mv_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_mv_t1)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_clock2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_clock2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_clock2_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_clock2_pane
inline TAknLayoutScalableParameterLimits main_clock2_list_pane_ParamLimits(TInt aVariety)		{ return (*(Tmain_clock2_list_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_clock2_list_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_clock2_list_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_clock2_list_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_clock2_list_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_clock2_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tmain_clock2_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_clock2_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_clock2_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_clock2_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_clock2_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_clock2_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tmain_clock2_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_clock2_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_clock2_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_clock2_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_clock2_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_clock2_pane_t_Limits()		{ return (*(Tmain_clock2_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_clock2_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_clock2_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tmain_clock2_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_clock2_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout main_clock2_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_clock2_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_clock2_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_clock_analogue_window_cp03_ParamLimits(TInt aVariety)		{ return (*(Tpopup_clock_analogue_window_cp03_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_cp03_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_clock_analogue_window_cp03(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_analogue_window_cp03_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_cp03)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_clock_digital_window_cp02_ParamLimits(TInt aVariety)		{ return (*(Tpopup_clock_digital_window_cp02_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_digital_window_cp02_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_clock_digital_window_cp02(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_digital_window_cp02_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_digital_window_cp02)))(aVariety, aCol, aRow); }

// LAF Table : main_clock2_list_pane
inline TAknLayoutScalableParameterLimits main_clock2_list_single_pane_ParamLimits(TInt aVariety)		{ return (*(Tmain_clock2_list_single_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_clock2_list_single_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_clock2_list_single_pane(TInt aVariety, TInt aRow, TInt aCol = 0)		{ return (*(Tmain_clock2_list_single_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_clock2_list_single_pane)))(aVariety, aRow, aCol); }

// LAF Table : main_clock2_list_single_pane
inline TAknWindowComponentLayout list_highlight_pane_cp05(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_cp05_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp05)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_clock2_list_single_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_clock2_list_single_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_clock2_list_single_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : main_video_tele_pane
inline TAknLayoutScalableParameterLimits popup_toolbar_window_cp04_ParamLimits(TInt aVariety)		{ return (*(Tpopup_toolbar_window_cp04_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_toolbar_window_cp04_ParamLimits)))(aVariety); }

// LAF Table : camera2_autofocus_pane
inline TAknLayoutScalableParameterLimits camera2_autofocus_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Tcamera2_autofocus_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_camera2_autofocus_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout camera2_autofocus_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcamera2_autofocus_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_camera2_autofocus_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits camera2_autofocus_pane_g3_ParamLimits(TInt aVariety)		{ return (*(Tcamera2_autofocus_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_camera2_autofocus_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout camera2_autofocus_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcamera2_autofocus_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_camera2_autofocus_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits camera2_autofocus_pane_g4_ParamLimits(TInt aVariety)		{ return (*(Tcamera2_autofocus_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_camera2_autofocus_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout camera2_autofocus_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcamera2_autofocus_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_camera2_autofocus_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits camera2_autofocus_pane_g5_ParamLimits(TInt aVariety)		{ return (*(Tcamera2_autofocus_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_camera2_autofocus_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout camera2_autofocus_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcamera2_autofocus_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_camera2_autofocus_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits camera2_autofocus_pane_g_Limits()		{ return (*(Tcamera2_autofocus_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_camera2_autofocus_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits camera2_autofocus_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tcamera2_autofocus_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_camera2_autofocus_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout camera2_autofocus_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcamera2_autofocus_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_camera2_autofocus_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : camera2_autofocus_pane_cp
inline TAknWindowComponentLayout camera2_autofocus_pane_cp_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcamera2_autofocus_pane_cp_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_camera2_autofocus_pane_cp_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout camera2_autofocus_pane_cp_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcamera2_autofocus_pane_cp_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_camera2_autofocus_pane_cp_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout camera2_autofocus_pane_cp_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcamera2_autofocus_pane_cp_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_camera2_autofocus_pane_cp_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout camera2_autofocus_pane_cp_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcamera2_autofocus_pane_cp_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_camera2_autofocus_pane_cp_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits camera2_autofocus_pane_cp_g_Limits()		{ return (*(Tcamera2_autofocus_pane_cp_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_camera2_autofocus_pane_cp_g_Limits)))(); }

inline TAknWindowComponentLayout camera2_autofocus_pane_cp_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcamera2_autofocus_pane_cp_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_camera2_autofocus_pane_cp_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_dialer_pane
inline TAknWindowComponentLayout popup_dialer_spcha_window(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_dialer_spcha_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_dialer_spcha_window)))(aVariety, aCol, aRow); }

// LAF Table : popup_dialer_spcha_window
inline TAknWindowComponentLayout bg_popup_sub_pane_cp07(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp07_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp07)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_spcha_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_spcha_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_spcha_pane)))(aVariety, aCol, aRow); }

// LAF Table : list_spcha_pane
inline TAknLayoutScalableParameterLimits list_single_spcha_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_spcha_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_spcha_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_spcha_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_spcha_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_spcha_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_single_spcha_pane
inline TAknWindowComponentLayout list_highlight_pane_cp06(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_cp06_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp06)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout list_single_spcha_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_spcha_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_spcha_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : popup_call2_audio_out_window
inline TAknLayoutScalableParameterLimits popup_call2_audio_out_window_g4_ParamLimits(TInt aVariety)		{ return (*(Tpopup_call2_audio_out_window_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call2_audio_out_window_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_out_window_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_g4)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_imed2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_imed2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_imed2_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_imed_adjust2_window(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_imed_adjust2_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_imed_adjust2_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_imed_trans_window_ParamLimits(TInt aVariety)		{ return (*(Tpopup_imed_trans_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_imed_trans_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_imed_trans_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_imed_trans_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_imed_trans_window)))(aVariety, aCol, aRow); }

// LAF Table : popup_blid_sat_info2_window
inline TAknTextComponentLayout popup_blid_sat_info2_window_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_blid_sat_info2_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_blid_sat_info2_window_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_blid_sat_info2_window_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_blid_sat_info2_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_blid_sat_info2_window_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_blid_sat_info2_window_t_Limits()		{ return (*(Tpopup_blid_sat_info2_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_blid_sat_info2_window_t_Limits)))(); }

inline TAknTextComponentLayout popup_blid_sat_info2_window_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_blid_sat_info2_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_blid_sat_info2_window_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_imed_trans_window
inline TAknWindowComponentLayout aid_size_cell_colour_35(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_colour_35_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_colour_35)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout aid_size_cell_colour_112(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_colour_112_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_colour_112)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout aid_size_cell_effect(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_effect_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_effect)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_tb_trans_pane_cp02(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_tb_trans_pane_cp02_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_tb_trans_pane_cp02)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout heading_imed_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_imed_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_imed_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout listscroll_imed_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_imed_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_imed_pane)))(aVariety, aCol, aRow); }

// LAF Table : heading_imed_pane
inline TAknWindowComponentLayout heading_imed_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_imed_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_imed_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout heading_imed_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_imed_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_imed_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_imed_pane
inline TAknLayoutScalableParameterLimits grid_imed_colour_35_pane_ParamLimits(TInt aVariety)		{ return (*(Tgrid_imed_colour_35_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_imed_colour_35_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_imed_colour_35_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_imed_colour_35_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_imed_colour_35_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_imed_effect_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_imed_effect_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_imed_effect_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_imed_aspect_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_imed_aspect_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_imed_aspect_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits scroll_pane_cp027_ParamLimits(TInt aVariety)		{ return (*(Tscroll_pane_cp027_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp027_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout scroll_pane_cp027(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp027_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp027)))(aVariety, aCol, aRow); }

// LAF Table : grid_imed_effect_pane
inline TAknLayoutScalableParameterLimits cell_imed_effect_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_imed_effect_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_imed_effect_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_imed_effect_pane(TInt aCol, TInt aRow, TInt aVariety = 0)		{ return (*(Tcell_imed_effect_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_imed_effect_pane)))(aCol, aRow, aVariety); }

// LAF Table : grid_imed_colour_35_pane
inline TAknLayoutScalableParameterLimits cell_imed_colour_pane_ParamLimits(TInt aVariety)		{ return (*(Tcell_imed_colour_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_imed_colour_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_imed_colour_pane(TInt aVariety, TInt aCol, TInt aRow)		{ return (*(Tcell_imed_colour_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_imed_colour_pane)))(aVariety, aCol, aRow); }

// LAF Table : cell_imed_colour_pane
inline TAknLayoutScalableParameterLimits cell_imed_colour_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tcell_imed_colour_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_imed_colour_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_imed_colour_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_imed_colour_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_imed_colour_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits hgihlgiht_grid_pane_cp016_ParamLimits(TInt aVariety)		{ return (*(Thgihlgiht_grid_pane_cp016_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hgihlgiht_grid_pane_cp016_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout hgihlgiht_grid_pane_cp016(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thgihlgiht_grid_pane_cp016_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hgihlgiht_grid_pane_cp016)))(aVariety, aCol, aRow); }

// LAF Table : cell_imed_effect_pane
inline TAknWindowComponentLayout cell_imed_effect_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_imed_effect_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_imed_effect_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_highlight_pane_cp017(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_cp017_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp017)))(aVariety, aCol, aRow); }

// LAF Table : list_imed_aspect_pane
inline TAknLayoutScalableParameterLimits list_imed_single_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_imed_single_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_imed_single_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_imed_single_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_imed_single_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_imed_single_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_imed_single_pane
inline TAknWindowComponentLayout list_highlight_pane_cp07(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_cp07_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp07)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout list_imed_aspect_pane_comp1_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_imed_aspect_pane_comp1_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_imed_aspect_pane_comp1_t1)))(aVariety, aCol, aRow); }

// LAF Table : popup_imed_adjust2_window
inline TAknWindowComponentLayout bg_tb_trans_pane_cp05(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_tb_trans_pane_cp05_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_tb_trans_pane_cp05)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_imed_adjust2_window_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_imed_adjust2_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_imed_adjust2_window_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_imed_adjust2_window_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_imed_adjust2_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_imed_adjust2_window_t1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout slider_imed_adjust_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_imed_adjust_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_imed_adjust_pane)))(aVariety, aCol, aRow); }

// LAF Table : slider_imed_adjust_pane
inline TAknWindowComponentLayout slider_imed_adjust_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_imed_adjust_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_imed_adjust_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout slider_imed_adjust_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_imed_adjust_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_imed_adjust_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout slider_imed_adjust_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_imed_adjust_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_imed_adjust_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout slider_imed_adjust_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_imed_adjust_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_imed_adjust_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits slider_imed_adjust_pane_g_Limits()		{ return (*(Tslider_imed_adjust_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_imed_adjust_pane_g_Limits)))(); }

inline TAknWindowComponentLayout slider_imed_adjust_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_imed_adjust_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_imed_adjust_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_imed2_pane
inline TAknWindowComponentLayout aid_size_cell_clipart2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_clipart2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_clipart2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_imed_clipart_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_imed_clipart_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_imed_clipart_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp031(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp031_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp031)))(aVariety, aCol, aRow); }

// LAF Table : grid_imed_clipart_pane
inline TAknLayoutScalableParameterLimits cell_imed_clipart_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_imed_clipart_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_imed_clipart_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_imed_clipart_pane(TInt aCol, TInt aRow, TInt aVariety = 0)		{ return (*(Tcell_imed_clipart_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_imed_clipart_pane)))(aCol, aRow, aVariety); }

// LAF Table : cell_imed_clipart_pane
inline TAknWindowComponentLayout cell_imed_clipart_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_imed_clipart_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_imed_clipart_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_highlight_pane_cp014(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_cp014_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp014)))(aVariety, aCol, aRow); }

// LAF Table : main_clock2_pane
inline TAknLayoutScalableParameterLimits main_clock2_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tmain_clock2_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_clock2_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_clock2_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_clock2_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_clock2_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : popup_clock_analogue_window_cp03
inline TAknWindowComponentLayout aid_call2_pane_cp10(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_call2_pane_cp10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_call2_pane_cp10)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout aid_call_pane_cp10(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_call_pane_cp10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_call_pane_cp10)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_clock_analogue_window_cp10_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_analogue_window_cp10_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_cp10_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_clock_analogue_window_cp10_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_analogue_window_cp10_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_cp10_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_clock_analogue_window_cp10_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_analogue_window_cp10_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_cp10_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_clock_analogue_window_cp10_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_analogue_window_cp10_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_cp10_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_clock_analogue_window_cp10_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_analogue_window_cp10_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_cp10_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_clock_analogue_window_cp10_g_Limits()		{ return (*(Tpopup_clock_analogue_window_cp10_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_cp10_g_Limits)))(); }

inline TAknWindowComponentLayout popup_clock_analogue_window_cp10_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_analogue_window_cp10_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_cp10_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_clock_analogue_window_cp10_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_analogue_window_cp10_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_cp10_t1)))(aVariety, aCol, aRow); }

// LAF Table : popup_clock_digital_window_cp02
inline TAknLayoutScalableParameterLimits clock_digital_number_pane_cp10_ParamLimits(TInt aVariety)		{ return (*(Tclock_digital_number_pane_cp10_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_cp10_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout clock_digital_number_pane_cp10(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_number_pane_cp10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_cp10)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits clock_digital_number_pane_cp11_ParamLimits(TInt aVariety)		{ return (*(Tclock_digital_number_pane_cp11_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_cp11_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout clock_digital_number_pane_cp11(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_number_pane_cp11_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_cp11)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits clock_digital_number_pane_cp12_ParamLimits(TInt aVariety)		{ return (*(Tclock_digital_number_pane_cp12_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_cp12_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout clock_digital_number_pane_cp12(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_number_pane_cp12_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_cp12)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits clock_digital_number_pane_cp13_ParamLimits(TInt aVariety)		{ return (*(Tclock_digital_number_pane_cp13_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_cp13_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout clock_digital_number_pane_cp13(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_number_pane_cp13_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_cp13)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits clock_digital_separator_pane_cp10_ParamLimits(TInt aVariety)		{ return (*(Tclock_digital_separator_pane_cp10_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_separator_pane_cp10_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout clock_digital_separator_pane_cp10(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_separator_pane_cp10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_separator_pane_cp10)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_clock_digital_window_cp02_t1_ParamLimits(TInt aVariety)		{ return (*(Tpopup_clock_digital_window_cp02_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_digital_window_cp02_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_clock_digital_window_cp02_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_digital_window_cp02_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_digital_window_cp02_t1)))(aVariety, aCol, aRow); }

// LAF Table : clock_digital_number_pane_cp10
inline TAknWindowComponentLayout clock_digital_number_pane_cp10_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_number_pane_cp10_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_cp10_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout clock_digital_number_pane_cp10_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_number_pane_cp10_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_cp10_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits clock_digital_number_pane_cp10_g_Limits()		{ return (*(Tclock_digital_number_pane_cp10_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_cp10_g_Limits)))(); }

inline TAknWindowComponentLayout clock_digital_number_pane_cp10_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_number_pane_cp10_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_cp10_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : clock_digital_separator_pane_cp10
inline TAknWindowComponentLayout clock_digital_separator_pane_cp10_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_separator_pane_cp10_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_separator_pane_cp10_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout clock_digital_separator_pane_g2_cp10(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_separator_pane_g2_cp10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_separator_pane_g2_cp10)))(aVariety, aCol, aRow); }

// LAF Table : navi_pane
inline TAknWindowComponentLayout navi_pane_vded_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_vded_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_vded_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_pane_vded_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_vded_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_vded_g5)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout navi_pane_vded_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_vded_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_vded_t1)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_vded_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_vded_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vded_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_vded_pane
inline TAknWindowComponentLayout main_vded_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_vded_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vded_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_vded_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_vded_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vded_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_vded_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_vded_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vded_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_vded_pane_g_Limits()		{ return (*(Tmain_vded_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vded_pane_g_Limits)))(); }

inline TAknWindowComponentLayout main_vded_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_vded_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vded_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_vded_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_vded_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vded_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_vded_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_vded_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vded_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_vded_pane_t_Limits()		{ return (*(Tmain_vded_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vded_pane_t_Limits)))(); }

inline TAknTextComponentLayout main_vded_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_vded_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vded_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vded_slider_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvded_slider_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded_slider_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vded_video_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvded_video_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded_video_pane)))(aVariety, aCol, aRow); }

// LAF Table : vded_video_pane
inline TAknWindowComponentLayout vded_video_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvded_video_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded_video_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vded_video_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvded_video_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded_video_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vded_video_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvded_video_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded_video_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits vded_video_pane_g_Limits()		{ return (*(Tvded_video_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded_video_pane_g_Limits)))(); }

inline TAknWindowComponentLayout vded_video_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvded_video_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded_video_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : vded_slider_pane
inline TAknWindowComponentLayout vded_slider_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvded_slider_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded_slider_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vded_slider_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvded_slider_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded_slider_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vded_slider_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvded_slider_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded_slider_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vded_slider_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvded_slider_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded_slider_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vded_slider_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvded_slider_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded_slider_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits vded_slider_pane_g_Limits()		{ return (*(Tvded_slider_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded_slider_pane_g_Limits)))(); }

inline TAknWindowComponentLayout vded_slider_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvded_slider_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded_slider_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_mup3_pane
inline TAknLayoutScalableParameterLimits mup3_rocker_pane_ParamLimits(TInt aVariety)		{ return (*(Tmup3_rocker_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_rocker_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup3_rocker_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup3_rocker_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_rocker_pane)))(aVariety, aCol, aRow); }

// LAF Table : mup3_rocker_pane
inline TAknWindowComponentLayout mup3_control_keys_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup3_control_keys_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_control_keys_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup3_control_keys_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup3_control_keys_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_control_keys_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup3_control_keys_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup3_control_keys_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_control_keys_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup3_control_keys_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup3_control_keys_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_control_keys_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits mup3_control_keys_pane_g_Limits()		{ return (*(Tmup3_control_keys_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_control_keys_pane_g_Limits)))(); }

inline TAknWindowComponentLayout mup3_control_keys_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup3_control_keys_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_control_keys_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : application_window
inline TAknLayoutScalableParameterLimits popup_toolbar2_fixed_window_cp01_ParamLimits(TInt aVariety)		{ return (*(Tpopup_toolbar2_fixed_window_cp01_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_toolbar2_fixed_window_cp01_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_toolbar2_fixed_window_cp01(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_toolbar2_fixed_window_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_toolbar2_fixed_window_cp01)))(aVariety, aCol, aRow); }

// LAF Table : main_mup3_pane
inline TAknLayoutScalableParameterLimits popup_toolbar2_fixed_window_cp02_ParamLimits(TInt aVariety)		{ return (*(Tpopup_toolbar2_fixed_window_cp02_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_toolbar2_fixed_window_cp02_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_toolbar2_fixed_window_cp02(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_toolbar2_fixed_window_cp02_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_toolbar2_fixed_window_cp02)))(aVariety, aCol, aRow); }

// LAF Table : popup_call2_audio_second_window
inline TAknLayoutScalableParameterLimits popup_call2_audio_second_window_t4_ParamLimits(TInt aVariety)		{ return (*(Tpopup_call2_audio_second_window_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_second_window_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call2_audio_second_window_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_second_window_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_second_window_t4)))(aVariety, aCol, aRow); }

// LAF Table : popup_call2_audio_first_window
inline TAknLayoutScalableParameterLimits popup_call2_audio_first_window_t6_ParamLimits(TInt aVariety)		{ return (*(Tpopup_call2_audio_first_window_t6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_first_window_t6_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call2_audio_first_window_t6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_first_window_t6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_first_window_t6)))(aVariety, aCol, aRow); }

// LAF Table : popup_call2_audio_out_window
inline TAknLayoutScalableParameterLimits popup_call2_audio_out_window_t6_ParamLimits(TInt aVariety)		{ return (*(Tpopup_call2_audio_out_window_t6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_t6_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_call2_audio_out_window_t6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_out_window_t6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_out_window_t6)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_vitu_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_vitu_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vitu_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_vitu_pane
inline TAknLayoutScalableParameterLimits aid_size_cell_itu_ParamLimits(TInt aVariety)		{ return (*(Taid_size_cell_itu_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_itu_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_size_cell_itu(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_itu_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_itu)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits bg_popup_window_pane_cp08_ParamLimits(TInt aVariety)		{ return (*(Tbg_popup_window_pane_cp08_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp08_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_cp08(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp08_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp08)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits field_vitu_entry_pane_ParamLimits(TInt aVariety)		{ return (*(Tfield_vitu_entry_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu_entry_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout field_vitu_entry_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfield_vitu_entry_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu_entry_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_vitu_function_pane_ParamLimits(TInt aVariety)		{ return (*(Tgrid_vitu_function_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_vitu_function_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_vitu_function_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_vitu_function_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_vitu_function_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_vitu_itu_pane_ParamLimits(TInt aVariety)		{ return (*(Tgrid_vitu_itu_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_vitu_itu_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_vitu_itu_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_vitu_itu_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_vitu_itu_pane)))(aVariety, aCol, aRow); }

// LAF Table : grid_vitu_itu_pane
inline TAknLayoutScalableParameterLimits cell_vitu_itu_pane_ParamLimits(TInt aVariety)		{ return (*(Tcell_vitu_itu_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu_itu_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_vitu_itu_pane(TInt aVariety, TInt aCol, TInt aRow)		{ return (*(Tcell_vitu_itu_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu_itu_pane)))(aVariety, aCol, aRow); }

// LAF Table : grid_vitu_function_pane
inline TAknLayoutScalableParameterLimits cell_vitu_function_pane_ParamLimits(TInt aVariety)		{ return (*(Tcell_vitu_function_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu_function_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_vitu_function_pane(TInt aVariety, TInt aCol, TInt aRow)		{ return (*(Tcell_vitu_function_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu_function_pane)))(aVariety, aCol, aRow); }

// LAF Table : field_vitu_entry_pane
inline TAknLayoutScalableParameterLimits bg_popup_sub_pane_cp08_ParamLimits(TInt aVariety)		{ return (*(Tbg_popup_sub_pane_cp08_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp08_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_sub_pane_cp08(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp08_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp08)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits field_vitu_entry_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tfield_vitu_entry_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu_entry_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout field_vitu_entry_pane_t1(TInt aVariety, TInt aRow, TInt aCol = 0)		{ return (*(Tfield_vitu_entry_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu_entry_pane_t1)))(aVariety, aRow, aCol); }

inline TAknLayoutScalableParameterLimits field_vitu_entry_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tfield_vitu_entry_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu_entry_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout field_vitu_entry_pane_t2(TInt aVariety, TInt aRow, TInt aCol = 0)		{ return (*(Tfield_vitu_entry_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu_entry_pane_t2)))(aVariety, aRow, aCol); }

inline TAknLayoutScalableTableLimits field_vitu_entry_pane_t_Limits()		{ return (*(Tfield_vitu_entry_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu_entry_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits field_vitu_entry_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tfield_vitu_entry_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu_entry_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout field_vitu_entry_pane_t(TInt aLineIndex, TInt aVariety, TInt aRow, TInt aCol = 0)		{ return (*(Tfield_vitu_entry_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu_entry_pane_t)))(aLineIndex, aVariety, aRow, aCol); }

// LAF Table : cell_vitu_itu_pane
inline TAknLayoutScalableParameterLimits bg_button_pane_cp05_ParamLimits(TInt aVariety)		{ return (*(Tbg_button_pane_cp05_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp05_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_button_pane_cp05(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_cp05_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp05)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_vitu_itu_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu_itu_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu_itu_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_vitu_itu_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tcell_vitu_itu_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu_itu_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout cell_vitu_itu_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu_itu_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu_itu_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_vitu_itu_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tcell_vitu_itu_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu_itu_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout cell_vitu_itu_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu_itu_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu_itu_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_vitu_itu_pane_t_Limits()		{ return (*(Tcell_vitu_itu_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu_itu_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits cell_vitu_itu_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tcell_vitu_itu_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu_itu_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout cell_vitu_itu_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu_itu_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu_itu_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : cell_vitu_function_pane
inline TAknWindowComponentLayout bg_button_pane_cp07(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_cp07_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp07)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_vitu_function_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu_function_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu_function_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : main_calc_pane
inline TAknWindowComponentLayout main_calc_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_calc_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_calc_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : application_window
inline TAknWindowComponentLayout aid_visual_content_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_visual_content_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_visual_content_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_vradio_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_vradio_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vradio_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_vradio_pane
inline TAknLayoutScalableParameterLimits main_vradio_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tmain_vradio_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vradio_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_vradio_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_vradio_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vradio_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_vradio_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Tmain_vradio_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vradio_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_vradio_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_vradio_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vradio_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_vradio_pane_g_Limits()		{ return (*(Tmain_vradio_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vradio_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_vradio_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tmain_vradio_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vradio_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout main_vradio_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_vradio_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vradio_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_vradio_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tmain_vradio_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vradio_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_vradio_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_vradio_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vradio_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_vradio_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tmain_vradio_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vradio_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_vradio_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_vradio_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vradio_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_vradio_pane_t3_ParamLimits(TInt aVariety)		{ return (*(Tmain_vradio_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vradio_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_vradio_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_vradio_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vradio_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_vradio_pane_t_Limits()		{ return (*(Tmain_vradio_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vradio_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_vradio_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tmain_vradio_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vradio_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout main_vradio_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_vradio_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vradio_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits vradio_rocker_control_pane_ParamLimits(TInt aVariety)		{ return (*(Tvradio_rocker_control_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_rocker_control_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout vradio_rocker_control_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvradio_rocker_control_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_rocker_control_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits vradio_station_info_pane_ParamLimits(TInt aVariety)		{ return (*(Tvradio_station_info_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_station_info_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout vradio_station_info_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvradio_station_info_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_station_info_pane)))(aVariety, aCol, aRow); }

// LAF Table : vradio_station_info_pane
inline TAknLayoutScalableParameterLimits vradio_frequency_info_pane_ParamLimits(TInt aVariety)		{ return (*(Tvradio_frequency_info_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_frequency_info_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout vradio_frequency_info_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvradio_frequency_info_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_frequency_info_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vradio_station_info_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvradio_station_info_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_station_info_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits vradio_station_info_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tvradio_station_info_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_station_info_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout vradio_station_info_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvradio_station_info_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_station_info_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits vradio_station_info_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tvradio_station_info_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_station_info_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout vradio_station_info_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvradio_station_info_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_station_info_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits vradio_station_info_pane_t_Limits()		{ return (*(Tvradio_station_info_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_station_info_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits vradio_station_info_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tvradio_station_info_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_station_info_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout vradio_station_info_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvradio_station_info_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_station_info_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vradio_tuning_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvradio_tuning_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_tuning_pane)))(aVariety, aCol, aRow); }

// LAF Table : vradio_rocker_control_pane
inline TAknWindowComponentLayout vradio_rocker_control_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvradio_rocker_control_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_rocker_control_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vradio_rocker_control_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvradio_rocker_control_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_rocker_control_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vradio_rocker_control_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvradio_rocker_control_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_rocker_control_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vradio_rocker_control_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvradio_rocker_control_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_rocker_control_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vradio_rocker_control_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvradio_rocker_control_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_rocker_control_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits vradio_rocker_control_pane_g_Limits()		{ return (*(Tvradio_rocker_control_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_rocker_control_pane_g_Limits)))(); }

inline TAknWindowComponentLayout vradio_rocker_control_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvradio_rocker_control_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_rocker_control_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : vradio_frequency_info_pane
inline TAknWindowComponentLayout vradio_frequency_info_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvradio_frequency_info_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_frequency_info_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits vradio_frequency_info_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tvradio_frequency_info_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_frequency_info_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout vradio_frequency_info_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvradio_frequency_info_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_frequency_info_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : vradio_tuning_pane
inline TAknWindowComponentLayout vradio_tuning_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvradio_tuning_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_tuning_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout vradio_tuning_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvradio_tuning_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vradio_tuning_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : application_window
inline TAknLayoutScalableParameterLimits area_side_right_pane_ParamLimits(TInt aVariety)		{ return (*(Tarea_side_right_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_side_right_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout area_side_right_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tarea_side_right_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_side_right_pane)))(aVariety, aCol, aRow); }

// LAF Table : status_small_pane
inline TAknWindowComponentLayout status_small_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_small_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout status_small_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_small_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout status_small_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_small_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout status_small_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_small_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits status_small_pane_g_Limits()		{ return (*(Tstatus_small_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_g_Limits)))(); }

inline TAknWindowComponentLayout status_small_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_small_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout status_small_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_small_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_video3_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video3_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video3_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_video3_pane
inline TAknWindowComponentLayout cams_zoom_vslider_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcams_zoom_vslider_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams_zoom_vslider_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits image3_wide_pane_ParamLimits(TInt aVariety)		{ return (*(Timage3_wide_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_image3_wide_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout image3_wide_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Timage3_wide_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_image3_wide_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout image3_wide_small_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Timage3_wide_small_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_image3_wide_small_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_video3_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tmain_video3_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video3_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_video3_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video3_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video3_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_video3_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Tmain_video3_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video3_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_video3_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video3_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video3_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_video3_pane_g_Limits()		{ return (*(Tmain_video3_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video3_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_video3_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tmain_video3_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video3_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout main_video3_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video3_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video3_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_video3_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tmain_video3_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video3_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_video3_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video3_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video3_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_video3_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tmain_video3_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video3_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_video3_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video3_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video3_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_video3_pane_t3_ParamLimits(TInt aVariety)		{ return (*(Tmain_video3_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video3_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_video3_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video3_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video3_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_video3_pane_t_Limits()		{ return (*(Tmain_video3_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video3_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_video3_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tmain_video3_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video3_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout main_video3_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video3_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video3_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : cams_zoom_vslider_pane
inline TAknWindowComponentLayout cams_zoom_vslider_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcams_zoom_vslider_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams_zoom_vslider_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cams_zoom_vslider_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcams_zoom_vslider_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams_zoom_vslider_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cams_zoom_vslider_pane_g_Limits()		{ return (*(Tcams_zoom_vslider_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams_zoom_vslider_pane_g_Limits)))(); }

inline TAknWindowComponentLayout cams_zoom_vslider_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcams_zoom_vslider_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cams_zoom_vslider_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout small_slider_vertical_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmall_slider_vertical_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_small_slider_vertical_pane)))(aVariety, aCol, aRow); }

// LAF Table : small_slider_vertical_pane
inline TAknWindowComponentLayout small_slider_vertical_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmall_slider_vertical_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_small_slider_vertical_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout small_slider_vertical_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmall_slider_vertical_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_small_slider_vertical_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout small_slider_vertical_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmall_slider_vertical_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_small_slider_vertical_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits small_slider_vertical_pane_g_Limits()		{ return (*(Tsmall_slider_vertical_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_small_slider_vertical_pane_g_Limits)))(); }

inline TAknWindowComponentLayout small_slider_vertical_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsmall_slider_vertical_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_small_slider_vertical_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_hwr_training_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_hwr_training_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_hwr_training_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_hwr_training_pane
inline TAknLayoutScalableParameterLimits hwr_training_instruct_pane_ParamLimits(TInt aVariety)		{ return (*(Thwr_training_instruct_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_instruct_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout hwr_training_instruct_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thwr_training_instruct_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_instruct_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits hwr_training_navi_pane_ParamLimits(TInt aVariety)		{ return (*(Thwr_training_navi_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_navi_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout hwr_training_navi_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thwr_training_navi_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_navi_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits hwr_training_write_pane_ParamLimits(TInt aVariety)		{ return (*(Thwr_training_write_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_write_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout hwr_training_write_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thwr_training_write_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_write_pane)))(aVariety, aCol, aRow); }

// LAF Table : hwr_training_write_pane
inline TAknWindowComponentLayout bg_frame_shadow_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_frame_shadow_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_frame_shadow_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout hwr_training_write_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thwr_training_write_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_write_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout hwr_training_write_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thwr_training_write_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_write_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout hwr_training_write_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thwr_training_write_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_write_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout hwr_training_write_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thwr_training_write_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_write_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout hwr_training_write_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thwr_training_write_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_write_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout hwr_training_write_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thwr_training_write_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_write_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout hwr_training_write_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thwr_training_write_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_write_pane_g7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits hwr_training_write_pane_g_Limits()		{ return (*(Thwr_training_write_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_write_pane_g_Limits)))(); }

inline TAknWindowComponentLayout hwr_training_write_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thwr_training_write_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_write_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : hwr_training_navi_pane
inline TAknLayoutScalableParameterLimits hwr_training_navi_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Thwr_training_navi_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_navi_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout hwr_training_navi_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thwr_training_navi_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_navi_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits hwr_training_navi_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Thwr_training_navi_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_navi_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout hwr_training_navi_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thwr_training_navi_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_navi_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits hwr_training_navi_pane_g3_ParamLimits(TInt aVariety)		{ return (*(Thwr_training_navi_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_navi_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout hwr_training_navi_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thwr_training_navi_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_navi_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits hwr_training_navi_pane_g4_ParamLimits(TInt aVariety)		{ return (*(Thwr_training_navi_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_navi_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout hwr_training_navi_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thwr_training_navi_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_navi_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits hwr_training_navi_pane_g_Limits()		{ return (*(Thwr_training_navi_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_navi_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits hwr_training_navi_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Thwr_training_navi_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_navi_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout hwr_training_navi_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thwr_training_navi_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_navi_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout hwr_training_navi_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thwr_training_navi_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_navi_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : hwr_training_instruct_pane
inline TAknLayoutScalableParameterLimits list_single_hwr_training_instruct_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_hwr_training_instruct_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_hwr_training_instruct_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_hwr_training_instruct_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_hwr_training_instruct_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_hwr_training_instruct_pane)))(aVariety, aCol, aRow); }

// LAF Table : list_single_hwr_training_instruct_pane
inline TAknTextComponentLayout list_single_hwr_training_instruct_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_hwr_training_instruct_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_hwr_training_instruct_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : bg_frame_shadow_pane
inline TAknWindowComponentLayout bg_frame_shadow_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_frame_shadow_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_frame_shadow_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_frame_shadow_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_frame_shadow_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_frame_shadow_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_frame_shadow_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_frame_shadow_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_frame_shadow_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_frame_shadow_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_frame_shadow_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_frame_shadow_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_frame_shadow_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_frame_shadow_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_frame_shadow_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_frame_shadow_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_frame_shadow_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_frame_shadow_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_frame_shadow_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_frame_shadow_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_frame_shadow_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_frame_shadow_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_frame_shadow_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_frame_shadow_pane_g8)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits bg_frame_shadow_pane_g_Limits()		{ return (*(Tbg_frame_shadow_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_frame_shadow_pane_g_Limits)))(); }

inline TAknWindowComponentLayout bg_frame_shadow_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_frame_shadow_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_frame_shadow_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_video_tele_dialer_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video_tele_dialer_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_tele_dialer_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_video_tele_dialer_pane
inline TAknLayoutScalableParameterLimits aid_size_cell_video_keypad_ParamLimits(TInt aVariety)		{ return (*(Taid_size_cell_video_keypad_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_video_keypad_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_size_cell_video_keypad(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_video_keypad_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_video_keypad)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_video_dialer_keypad_pane_ParamLimits(TInt aVariety)		{ return (*(Tgrid_video_dialer_keypad_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_video_dialer_keypad_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_video_dialer_keypad_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_video_dialer_keypad_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_video_dialer_keypad_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits video_down_pane_cp_ParamLimits(TInt aVariety)		{ return (*(Tvideo_down_pane_cp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_video_down_pane_cp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout video_down_pane_cp(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvideo_down_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_video_down_pane_cp)))(aVariety, aCol, aRow); }

// LAF Table : grid_video_dialer_keypad_pane
inline TAknLayoutScalableParameterLimits cell_video_dialer_keypad_pane_ParamLimits(TInt aVariety)		{ return (*(Tcell_video_dialer_keypad_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_video_dialer_keypad_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_video_dialer_keypad_pane(TInt aVariety, TInt aCol, TInt aRow)		{ return (*(Tcell_video_dialer_keypad_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_video_dialer_keypad_pane)))(aVariety, aCol, aRow); }

// LAF Table : cell_video_dialer_keypad_pane
inline TAknLayoutScalableParameterLimits bg_button_pane_cp08_ParamLimits(TInt aVariety)		{ return (*(Tbg_button_pane_cp08_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp08_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_button_pane_cp08(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_cp08_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp08)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_video_dialer_keypad_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tcell_video_dialer_keypad_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_video_dialer_keypad_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_video_dialer_keypad_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_video_dialer_keypad_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_video_dialer_keypad_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : main_mup3_pane
inline TAknLayoutScalableParameterLimits mup3_rocker2_pane_ParamLimits(TInt aVariety)		{ return (*(Tmup3_rocker2_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_rocker2_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mup3_rocker2_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup3_rocker2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_rocker2_pane)))(aVariety, aCol, aRow); }

// LAF Table : mup3_rocker2_pane
inline TAknWindowComponentLayout mup3_rocker2_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup3_rocker2_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_rocker2_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_dialer2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_dialer2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_dialer2_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_mp4_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp4_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp4_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_mp4_pane
inline TAknLayoutScalableParameterLimits main_mp4_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tmain_mp4_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp4_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mp4_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp4_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp4_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mp4_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Tmain_mp4_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp4_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mp4_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp4_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp4_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mp4_pane_g3_ParamLimits(TInt aVariety)		{ return (*(Tmain_mp4_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp4_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mp4_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp4_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp4_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mp4_pane_g4_ParamLimits(TInt aVariety)		{ return (*(Tmain_mp4_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp4_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mp4_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp4_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp4_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mp4_pane_g5_ParamLimits(TInt aVariety)		{ return (*(Tmain_mp4_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp4_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mp4_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp4_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp4_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_mp4_pane_g_Limits()		{ return (*(Tmain_mp4_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp4_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_mp4_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tmain_mp4_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp4_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout main_mp4_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp4_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp4_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mp4_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tmain_mp4_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp4_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mp4_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp4_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp4_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mp4_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tmain_mp4_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp4_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mp4_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp4_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp4_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mp4_pane_t3_ParamLimits(TInt aVariety)		{ return (*(Tmain_mp4_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp4_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mp4_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp4_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp4_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_mp4_pane_t4_ParamLimits(TInt aVariety)		{ return (*(Tmain_mp4_pane_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp4_pane_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_mp4_pane_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp4_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp4_pane_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_mp4_pane_t_Limits()		{ return (*(Tmain_mp4_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp4_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_mp4_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tmain_mp4_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp4_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout main_mp4_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mp4_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mp4_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits mp4_progress_pane_ParamLimits(TInt aVariety)		{ return (*(Tmp4_progress_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mp4_progress_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mp4_progress_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmp4_progress_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mp4_progress_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits mp4_rocker_pane_ParamLimits(TInt aVariety)		{ return (*(Tmp4_rocker_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mp4_rocker_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mp4_rocker_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmp4_rocker_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mp4_rocker_pane)))(aVariety, aCol, aRow); }

// LAF Table : mp4_progress_pane
inline TAknTextComponentLayout mp4_progress_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmp4_progress_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mp4_progress_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout mp4_progress_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmp4_progress_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mp4_progress_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits mp4_progress_pane_t_Limits()		{ return (*(Tmp4_progress_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mp4_progress_pane_t_Limits)))(); }

inline TAknTextComponentLayout mp4_progress_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmp4_progress_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mp4_progress_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mup_progress_pane_cp04(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup_progress_pane_cp04_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_progress_pane_cp04)))(aVariety, aCol, aRow); }

// LAF Table : mp4_rocker_pane
inline TAknWindowComponentLayout mp4_rocker_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmp4_rocker_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mp4_rocker_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : main_dialer2_pane
inline TAknLayoutScalableParameterLimits aid_cell_size_keypad2_ParamLimits(TInt aVariety)		{ return (*(Taid_cell_size_keypad2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_cell_size_keypad2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_cell_size_keypad2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_cell_size_keypad2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_cell_size_keypad2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits dialer2_ne_pane_ParamLimits(TInt aVariety)		{ return (*(Tdialer2_ne_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_dialer2_ne_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout dialer2_ne_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tdialer2_ne_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_dialer2_ne_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_dialer2_keypad_pane_ParamLimits(TInt aVariety)		{ return (*(Tgrid_dialer2_keypad_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_dialer2_keypad_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_dialer2_keypad_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_dialer2_keypad_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_dialer2_keypad_pane)))(aVariety, aCol, aRow); }

// LAF Table : dialer2_ne_pane
inline TAknLayoutScalableParameterLimits bg_popup_call_pane_cp07_ParamLimits(TInt aVariety)		{ return (*(Tbg_popup_call_pane_cp07_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_pane_cp07_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_call_pane_cp07(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_pane_cp07_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_pane_cp07)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits dialer2_ne_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tdialer2_ne_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_dialer2_ne_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout dialer2_ne_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tdialer2_ne_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_dialer2_ne_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : grid_dialer2_keypad_pane
inline TAknLayoutScalableParameterLimits cell_dialer2_keypad_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_dialer2_keypad_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_dialer2_keypad_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_dialer2_keypad_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_dialer2_keypad_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_dialer2_keypad_pane)))(aVariety, aCol, aRow); }

// LAF Table : cell_dialer2_keypad_pane
inline TAknLayoutScalableParameterLimits bg_button_pane_pane_cp04_ParamLimits(TInt aVariety)		{ return (*(Tbg_button_pane_pane_cp04_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_pane_cp04_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_button_pane_pane_cp04(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_pane_cp04_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_pane_cp04)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_dialer2_keypad_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tcell_dialer2_keypad_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_dialer2_keypad_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_dialer2_keypad_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_dialer2_keypad_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_dialer2_keypad_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : main_video_tele_pane
inline TAknLayoutScalableParameterLimits aid_placing_vt_set_content_ParamLimits(TInt aVariety)		{ return (*(Taid_placing_vt_set_content_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_placing_vt_set_content_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_placing_vt_set_content(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_placing_vt_set_content_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_placing_vt_set_content)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits aid_placing_vt_set_title_ParamLimits(TInt aVariety)		{ return (*(Taid_placing_vt_set_title_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_placing_vt_set_title_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_placing_vt_set_title(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_placing_vt_set_title_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_placing_vt_set_title)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_image3_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_image3_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image3_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_image3_pane
inline TAknLayoutScalableParameterLimits area_side_right_pane_cp01_ParamLimits(TInt aVariety)		{ return (*(Tarea_side_right_pane_cp01_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_side_right_pane_cp01_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout area_side_right_pane_cp01(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tarea_side_right_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_side_right_pane_cp01)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_image3_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tmain_image3_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image3_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_image3_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_image3_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image3_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_image3_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Tmain_image3_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image3_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_image3_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_image3_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image3_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_image3_pane_g3_ParamLimits(TInt aVariety)		{ return (*(Tmain_image3_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image3_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_image3_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_image3_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image3_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_image3_pane_g4_ParamLimits(TInt aVariety)		{ return (*(Tmain_image3_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image3_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_image3_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_image3_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image3_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_image3_pane_g_Limits()		{ return (*(Tmain_image3_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image3_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_image3_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tmain_image3_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image3_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout main_image3_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_image3_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image3_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_image3_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tmain_image3_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image3_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_image3_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_image3_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image3_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_image3_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tmain_image3_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image3_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_image3_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_image3_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image3_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_image3_pane_t3_ParamLimits(TInt aVariety)		{ return (*(Tmain_image3_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image3_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_image3_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_image3_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image3_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_image3_pane_t_Limits()		{ return (*(Tmain_image3_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image3_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_image3_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tmain_image3_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image3_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout main_image3_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_image3_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_image3_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : area_side_right_pane_cp01
inline TAknLayoutScalableParameterLimits grid_sctrl_middle_pane_cp01_ParamLimits(TInt aVariety)		{ return (*(Tgrid_sctrl_middle_pane_cp01_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_sctrl_middle_pane_cp01_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_sctrl_middle_pane_cp01(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_sctrl_middle_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_sctrl_middle_pane_cp01)))(aVariety, aCol, aRow); }

// LAF Table : grid_sctrl_middle_pane_cp01
inline TAknLayoutScalableParameterLimits cell_sctrl_middle_pane_cp01_ParamLimits(TInt aVariety)		{ return (*(Tcell_sctrl_middle_pane_cp01_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_sctrl_middle_pane_cp01_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_sctrl_middle_pane_cp01(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_sctrl_middle_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_sctrl_middle_pane_cp01)))(aVariety, aCol, aRow); }

// LAF Table : cell_sctrl_middle_pane_cp01
inline TAknLayoutScalableParameterLimits cell_sctrl_middle_pane_cp01_g1_ParamLimits(TInt aVariety)		{ return (*(Tcell_sctrl_middle_pane_cp01_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_sctrl_middle_pane_cp01_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_sctrl_middle_pane_cp01_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_sctrl_middle_pane_cp01_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_sctrl_middle_pane_cp01_g1)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_call4_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_call4_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_call4_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_call4_pane
inline TAknLayoutScalableParameterLimits aid_size_button_call4_ParamLimits(TInt aVariety)		{ return (*(Taid_size_button_call4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_button_call4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_size_button_call4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_button_call4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_button_call4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits call4_windows_pane_ParamLimits(TInt aVariety)		{ return (*(Tcall4_windows_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call4_windows_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout call4_windows_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall4_windows_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call4_windows_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_call4_button_pane_ParamLimits(TInt aVariety)		{ return (*(Tgrid_call4_button_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_call4_button_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_call4_button_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_call4_button_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_call4_button_pane)))(aVariety, aCol, aRow); }

// LAF Table : call4_windows_pane
inline TAknWindowComponentLayout call4_windows_conf_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall4_windows_conf_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call4_windows_conf_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call4_audio_first_window_ParamLimits(TInt aVariety)		{ return (*(Tpopup_call4_audio_first_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call4_audio_first_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call4_audio_first_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call4_audio_first_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call4_audio_first_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call4_audio_second_window_ParamLimits(TInt aVariety)		{ return (*(Tpopup_call4_audio_second_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call4_audio_second_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call4_audio_second_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call4_audio_second_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call4_audio_second_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_call4_audio_wait_window_ParamLimits(TInt aVariety)		{ return (*(Tpopup_call4_audio_wait_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call4_audio_wait_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call4_audio_wait_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call4_audio_wait_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call4_audio_wait_window)))(aVariety, aCol, aRow); }

// LAF Table : grid_call4_button_pane
inline TAknLayoutScalableParameterLimits cell_call4_button_pane_ParamLimits(TInt aVariety)		{ return (*(Tcell_call4_button_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_call4_button_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_call4_button_pane(TInt aVariety, TInt aCol, TInt aRow)		{ return (*(Tcell_call4_button_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_call4_button_pane)))(aVariety, aCol, aRow); }

// LAF Table : cell_call4_button_pane
inline TAknLayoutScalableParameterLimits bg_button_pane_cp09_ParamLimits(TInt aVariety)		{ return (*(Tbg_button_pane_cp09_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp09_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_button_pane_cp09(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_cp09_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp09)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_call4_button_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tcell_call4_button_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_call4_button_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_call4_button_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_call4_button_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_call4_button_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_call4_button_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tcell_call4_button_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_call4_button_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout cell_call4_button_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_call4_button_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_call4_button_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : call4_windows_conf_pane
inline TAknLayoutScalableParameterLimits popup_call4_audio_conf_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_call4_audio_conf_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call4_audio_conf_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call4_audio_conf_window(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call4_audio_conf_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call4_audio_conf_window)))(aVariety, aCol, aRow); }

// LAF Table : mup3_progress_pane
inline TAknLayoutScalableParameterLimits mup3_progress_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tmup3_progress_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_progress_pane_t1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits mup3_progress_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tmup3_progress_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_progress_pane_t2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits mup3_progress_pane_t3_ParamLimits(TInt aVariety)		{ return (*(Tmup3_progress_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_progress_pane_t3_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits mup3_progress_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tmup3_progress_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_progress_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknLayoutScalableParameterLimits mup_progress_pane_cp03_ParamLimits(TInt aVariety)		{ return (*(Tmup_progress_pane_cp03_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_progress_pane_cp03_ParamLimits)))(aVariety); }

// LAF Table : mup3_rocker_pane
inline TAknWindowComponentLayout mup3_control_keys_pane_g4_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmup3_control_keys_pane_g4_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup3_control_keys_pane_g4_copy1)))(aVariety, aCol, aRow); }

// LAF Table : main_mp4_pane
inline TAknLayoutScalableParameterLimits mp4_rocker2_pane_ParamLimits(TInt aVariety)		{ return (*(Tmp4_rocker2_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mp4_rocker2_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout mp4_rocker2_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmp4_rocker2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mp4_rocker2_pane)))(aVariety, aCol, aRow); }

// LAF Table : mp4_rocker2_pane
inline TAknWindowComponentLayout mp4_rocker2_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmp4_rocker2_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mp4_rocker2_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mp4_rocker2_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmp4_rocker2_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mp4_rocker2_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mp4_rocker2_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmp4_rocker2_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mp4_rocker2_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mp4_rocker2_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmp4_rocker2_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mp4_rocker2_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout mp4_rocker2_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmp4_rocker2_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mp4_rocker2_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits mp4_rocker2_pane_g_Limits()		{ return (*(Tmp4_rocker2_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mp4_rocker2_pane_g_Limits)))(); }

inline TAknWindowComponentLayout mp4_rocker2_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmp4_rocker2_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mp4_rocker2_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_camera4_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera4_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera4_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_video4_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video4_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video4_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_video_tele_dialer_pane
inline TAknLayoutScalableParameterLimits main_video_tele_dialer_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tmain_video_tele_dialer_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_tele_dialer_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_video_tele_dialer_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video_tele_dialer_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_tele_dialer_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_video_tele_dialer_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tmain_video_tele_dialer_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_tele_dialer_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_video_tele_dialer_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video_tele_dialer_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_tele_dialer_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_video_tele_dialer_pane_t_Limits()		{ return (*(Tmain_video_tele_dialer_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_tele_dialer_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_video_tele_dialer_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tmain_video_tele_dialer_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_tele_dialer_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout main_video_tele_dialer_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video_tele_dialer_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video_tele_dialer_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_camera4_pane
inline TAknLayoutScalableParameterLimits cam4_autofocus_pane_ParamLimits(TInt aVariety)		{ return (*(Tcam4_autofocus_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_autofocus_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cam4_autofocus_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcam4_autofocus_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_autofocus_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cam4_image_uncrop_pane_ParamLimits(TInt aVariety)		{ return (*(Tcam4_image_uncrop_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_image_uncrop_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cam4_image_uncrop_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcam4_image_uncrop_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_image_uncrop_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cam4_indicators_pane_ParamLimits(TInt aVariety)		{ return (*(Tcam4_indicators_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_indicators_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cam4_indicators_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcam4_indicators_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_indicators_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_camera4_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tmain_camera4_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera4_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_camera4_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera4_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera4_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_camera4_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Tmain_camera4_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera4_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_camera4_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera4_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera4_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_camera4_pane_g3_ParamLimits(TInt aVariety)		{ return (*(Tmain_camera4_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera4_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_camera4_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera4_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera4_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_camera4_pane_g4_ParamLimits(TInt aVariety)		{ return (*(Tmain_camera4_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera4_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_camera4_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera4_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera4_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_camera4_pane_g5_ParamLimits(TInt aVariety)		{ return (*(Tmain_camera4_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera4_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_camera4_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera4_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera4_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_camera4_pane_g_Limits()		{ return (*(Tmain_camera4_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera4_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_camera4_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tmain_camera4_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera4_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout main_camera4_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera4_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera4_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_camera4_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tmain_camera4_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera4_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_camera4_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera4_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera4_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : cam4_indicators_pane
inline TAknWindowComponentLayout bg_tb_trans_pane_cp06(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_tb_trans_pane_cp06_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_tb_trans_pane_cp06)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cam4_indicators_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcam4_indicators_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_indicators_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cam4_indicators_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcam4_indicators_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_indicators_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cam4_indicators_pane_g_Limits()		{ return (*(Tcam4_indicators_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_indicators_pane_g_Limits)))(); }

inline TAknWindowComponentLayout cam4_indicators_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcam4_indicators_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_indicators_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout cam4_indicators_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcam4_indicators_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_indicators_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : main_video4_pane
inline TAknLayoutScalableParameterLimits main_video4_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tmain_video4_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video4_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_video4_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video4_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video4_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_video4_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Tmain_video4_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video4_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_video4_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video4_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video4_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_video4_pane_g3_ParamLimits(TInt aVariety)		{ return (*(Tmain_video4_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video4_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_video4_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video4_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video4_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_video4_pane_g4_ParamLimits(TInt aVariety)		{ return (*(Tmain_video4_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video4_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_video4_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video4_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video4_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_video4_pane_g_Limits()		{ return (*(Tmain_video4_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video4_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_video4_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tmain_video4_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video4_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout main_video4_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video4_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video4_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits vid4_indicators_pane_ParamLimits(TInt aVariety)		{ return (*(Tvid4_indicators_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vid4_indicators_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout vid4_indicators_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvid4_indicators_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vid4_indicators_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits video4_image_uncrop_cif_pane_ParamLimits(TInt aVariety)		{ return (*(Tvideo4_image_uncrop_cif_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_video4_image_uncrop_cif_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout video4_image_uncrop_cif_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvideo4_image_uncrop_cif_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_video4_image_uncrop_cif_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits video4_image_uncrop_nhd_pane_ParamLimits(TInt aVariety)		{ return (*(Tvideo4_image_uncrop_nhd_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_video4_image_uncrop_nhd_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout video4_image_uncrop_nhd_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvideo4_image_uncrop_nhd_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_video4_image_uncrop_nhd_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits video4_image_uncrop_vga_pane_ParamLimits(TInt aVariety)		{ return (*(Tvideo4_image_uncrop_vga_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_video4_image_uncrop_vga_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout video4_image_uncrop_vga_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvideo4_image_uncrop_vga_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_video4_image_uncrop_vga_pane)))(aVariety, aCol, aRow); }

// LAF Table : vid4_indicators_pane
inline TAknWindowComponentLayout bg_tb_trans_pane_cp07(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_tb_trans_pane_cp07_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_tb_trans_pane_cp07)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vid4_indicators_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvid4_indicators_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vid4_indicators_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vid4_indicators_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvid4_indicators_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vid4_indicators_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vid4_indicators_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvid4_indicators_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vid4_indicators_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits vid4_indicators_pane_g_Limits()		{ return (*(Tvid4_indicators_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vid4_indicators_pane_g_Limits)))(); }

inline TAknWindowComponentLayout vid4_indicators_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvid4_indicators_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vid4_indicators_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout vid4_indicators_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvid4_indicators_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vid4_indicators_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : cam4_autofocus_pane
inline TAknWindowComponentLayout cam4_autofocus_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcam4_autofocus_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_autofocus_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cam4_autofocus_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcam4_autofocus_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_autofocus_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cam4_autofocus_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcam4_autofocus_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_autofocus_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cam4_autofocus_pane_g_Limits()		{ return (*(Tcam4_autofocus_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_autofocus_pane_g_Limits)))(); }

inline TAknWindowComponentLayout cam4_autofocus_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcam4_autofocus_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_autofocus_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cam4_autofocus_pane_g3_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcam4_autofocus_pane_g3_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_autofocus_pane_g3_copy1)))(aVariety, aCol, aRow); }

// LAF Table : video_down_pane_cp
inline TAknTextComponentLayout video_down_pane_cp_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvideo_down_pane_cp_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_video_down_pane_cp_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout video_down_pane_cp_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvideo_down_pane_cp_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_video_down_pane_cp_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits video_down_pane_cp_t_Limits()		{ return (*(Tvideo_down_pane_cp_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_video_down_pane_cp_t_Limits)))(); }

inline TAknTextComponentLayout video_down_pane_cp_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvideo_down_pane_cp_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_video_down_pane_cp_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : application_window
inline TAknLayoutScalableParameterLimits popup_vitu2_window_ParamLimits(TInt aVariety)		{ return (*(Tpopup_vitu2_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vitu2_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_vitu2_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_vitu2_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vitu2_window)))(aVariety, aCol, aRow); }

// LAF Table : popup_vitu2_window
inline TAknLayoutScalableParameterLimits aid_size_cell2_itu2_ParamLimits(TInt aVariety)		{ return (*(Taid_size_cell2_itu2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell2_itu2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_size_cell2_itu2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell2_itu2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell2_itu2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits aid_size_cell_itu2_ParamLimits(TInt aVariety)		{ return (*(Taid_size_cell_itu2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_itu2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_size_cell_itu2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_itu2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_itu2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits bg_popup_window_pane_cp09_ParamLimits(TInt aVariety)		{ return (*(Tbg_popup_window_pane_cp09_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp09_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_cp09(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp09_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp09)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits field_vitu2_entry_pane_ParamLimits(TInt aVariety)		{ return (*(Tfield_vitu2_entry_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu2_entry_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout field_vitu2_entry_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfield_vitu2_entry_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu2_entry_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_vitu2_function_pane_ParamLimits(TInt aVariety)		{ return (*(Tgrid_vitu2_function_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_vitu2_function_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_vitu2_function_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_vitu2_function_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_vitu2_function_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_vitu2_itu_pane_ParamLimits(TInt aVariety)		{ return (*(Tgrid_vitu2_itu_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_vitu2_itu_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_vitu2_itu_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_vitu2_itu_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_vitu2_itu_pane)))(aVariety, aCol, aRow); }

// LAF Table : grid_vitu2_itu_pane
inline TAknLayoutScalableParameterLimits cell_vitu2_itu_pane_ParamLimits(TInt aVariety)		{ return (*(Tcell_vitu2_itu_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_itu_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_vitu2_itu_pane(TInt aVariety, TInt aCol, TInt aRow)		{ return (*(Tcell_vitu2_itu_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_itu_pane)))(aVariety, aCol, aRow); }

// LAF Table : grid_vitu2_function_pane
inline TAknLayoutScalableParameterLimits cell_vitu2_function_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_vitu2_function_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_function_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_vitu2_function_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu2_function_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_function_pane)))(aVariety, aCol, aRow); }

// LAF Table : field_vitu2_entry_pane
inline TAknLayoutScalableParameterLimits bg_popup_call_pane_cp08_ParamLimits(TInt aVariety)		{ return (*(Tbg_popup_call_pane_cp08_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_pane_cp08_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_call_pane_cp08(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call_pane_cp08_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call_pane_cp08)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout field_vitu2_entry_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfield_vitu2_entry_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu2_entry_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout field_vitu2_entry_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfield_vitu2_entry_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu2_entry_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits field_vitu2_entry_pane_g_Limits()		{ return (*(Tfield_vitu2_entry_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu2_entry_pane_g_Limits)))(); }

inline TAknWindowComponentLayout field_vitu2_entry_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfield_vitu2_entry_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu2_entry_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits field_vitu2_entry_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tfield_vitu2_entry_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu2_entry_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout field_vitu2_entry_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfield_vitu2_entry_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu2_entry_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits field_vitu2_entry_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tfield_vitu2_entry_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu2_entry_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout field_vitu2_entry_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfield_vitu2_entry_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu2_entry_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits field_vitu2_entry_pane_t_Limits()		{ return (*(Tfield_vitu2_entry_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu2_entry_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits field_vitu2_entry_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tfield_vitu2_entry_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu2_entry_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout field_vitu2_entry_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfield_vitu2_entry_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu2_entry_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : cell_vitu2_itu_pane
inline TAknLayoutScalableParameterLimits bg_button_pane_cp010_ParamLimits(TInt aVariety)		{ return (*(Tbg_button_pane_cp010_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp010_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_button_pane_cp010(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_cp010_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp010)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_vitu2_itu_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu2_itu_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_itu_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_vitu2_itu_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tcell_vitu2_itu_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_itu_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout cell_vitu2_itu_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu2_itu_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_itu_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_vitu2_itu_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tcell_vitu2_itu_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_itu_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout cell_vitu2_itu_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu2_itu_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_itu_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_vitu2_itu_pane_t_Limits()		{ return (*(Tcell_vitu2_itu_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_itu_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits cell_vitu2_itu_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tcell_vitu2_itu_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_itu_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout cell_vitu2_itu_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu2_itu_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_itu_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : cell_vitu2_function_pane
inline TAknWindowComponentLayout bg_button_pane_cp011(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_cp011_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp011)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_vitu2_function_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu2_function_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_function_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_myfav_hc_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_myfav_hc_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_myfav_hc_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_image3_pane
inline TAknLayoutScalableParameterLimits popup_image3_note_pane_ParamLimits(TInt aVariety)		{ return (*(Tpopup_image3_note_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image3_note_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_image3_note_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image3_note_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image3_note_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_image3_tool_bar_pane_ParamLimits(TInt aVariety)		{ return (*(Tpopup_image3_tool_bar_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image3_tool_bar_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_image3_tool_bar_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image3_tool_bar_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image3_tool_bar_pane)))(aVariety, aCol, aRow); }

// LAF Table : cell_vitu2_itu_pane
inline TAknLayoutScalableParameterLimits cell_vitu2_itu_pane_t3_ParamLimits(TInt aVariety)		{ return (*(Tcell_vitu2_itu_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_itu_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout cell_vitu2_itu_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu2_itu_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_itu_pane_t3)))(aVariety, aCol, aRow); }

// LAF Table : popup_image3_tool_bar_pane
inline TAknWindowComponentLayout bg_popup_trans_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_trans_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_trans_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_image3_tool_bar_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_image3_tool_bar_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_image3_tool_bar_pane)))(aVariety, aCol, aRow); }

// LAF Table : bg_popup_trans_pane
inline TAknWindowComponentLayout bg_popup_trans_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_trans_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_trans_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_trans_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_trans_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_trans_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_trans_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_trans_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_trans_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_trans_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_trans_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_trans_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_trans_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_trans_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_trans_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_trans_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_trans_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_trans_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_trans_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_trans_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_trans_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_trans_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_trans_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_trans_pane_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_trans_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_trans_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_trans_pane_g9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits bg_popup_trans_pane_g_Limits()		{ return (*(Tbg_popup_trans_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_trans_pane_g_Limits)))(); }

inline TAknWindowComponentLayout bg_popup_trans_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_trans_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_trans_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : grid_image3_tool_bar_pane
inline TAknLayoutScalableParameterLimits cell_image3_tool_bar_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_image3_tool_bar_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_image3_tool_bar_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_image3_tool_bar_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_image3_tool_bar_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_image3_tool_bar_pane)))(aVariety, aCol, aRow); }

// LAF Table : cell_image3_tool_bar_pane
inline TAknWindowComponentLayout cell_image3_tool_bar_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_image3_tool_bar_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_image3_tool_bar_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : popup_image3_note_pane
inline TAknWindowComponentLayout bg_popup_trans_pane_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_trans_pane_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_trans_pane_cp1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_image3_note_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image3_note_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image3_note_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_image3_note_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image3_note_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image3_note_pane_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_image3_note_pane_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image3_note_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image3_note_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_image3_note_pane_t_Limits()		{ return (*(Tpopup_image3_note_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image3_note_pane_t_Limits)))(); }

inline TAknTextComponentLayout popup_image3_note_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image3_note_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image3_note_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_image3_note_pane_t3_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_image3_note_pane_t3_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_image3_note_pane_t3_copy1)))(aVariety, aCol, aRow); }

// LAF Table : main_myfav_hc_pane
inline TAknLayoutScalableParameterLimits bg_myfav_hc_instruction_pane_ParamLimits(TInt aVariety)		{ return (*(Tbg_myfav_hc_instruction_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_myfav_hc_instruction_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_myfav_hc_instruction_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_myfav_hc_instruction_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_myfav_hc_instruction_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_myfav_contact_pane_ParamLimits(TInt aVariety)		{ return (*(Tcell_myfav_contact_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_myfav_contact_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_myfav_contact_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_myfav_contact_pane_cp1_ParamLimits(TInt aVariety)		{ return (*(Tcell_myfav_contact_pane_cp1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_cp1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_myfav_contact_pane_cp1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_myfav_contact_pane_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_cp1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_myfav_contact_pane_cp2_ParamLimits(TInt aVariety)		{ return (*(Tcell_myfav_contact_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_myfav_contact_pane_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_myfav_contact_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_myfav_contact_pane_cp3_ParamLimits(TInt aVariety)		{ return (*(Tcell_myfav_contact_pane_cp3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_cp3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_myfav_contact_pane_cp3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_myfav_contact_pane_cp3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_cp3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_myfav_contact_pane_cp4_ParamLimits(TInt aVariety)		{ return (*(Tcell_myfav_contact_pane_cp4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_cp4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_myfav_contact_pane_cp4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_myfav_contact_pane_cp4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_cp4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_myfav_contact_pane_cp5_ParamLimits(TInt aVariety)		{ return (*(Tcell_myfav_contact_pane_cp5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_cp5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_myfav_contact_pane_cp5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_myfav_contact_pane_cp5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_cp5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_myfav_contact_pane_cp6_ParamLimits(TInt aVariety)		{ return (*(Tcell_myfav_contact_pane_cp6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_cp6_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_myfav_contact_pane_cp6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_myfav_contact_pane_cp6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_cp6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_myfav_contact_pane_cp7_ParamLimits(TInt aVariety)		{ return (*(Tcell_myfav_contact_pane_cp7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_cp7_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_myfav_contact_pane_cp7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_myfav_contact_pane_cp7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_cp7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout listscroll_gen_pane_cp05(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_gen_pane_cp05_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_gen_pane_cp05)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_myfav_hc_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tmain_myfav_hc_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_myfav_hc_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_myfav_hc_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_myfav_hc_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_myfav_hc_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_myfav_hc_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Tmain_myfav_hc_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_myfav_hc_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_myfav_hc_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_myfav_hc_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_myfav_hc_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_myfav_hc_pane_g_Limits()		{ return (*(Tmain_myfav_hc_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_myfav_hc_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_myfav_hc_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tmain_myfav_hc_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_myfav_hc_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout main_myfav_hc_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_myfav_hc_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_myfav_hc_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_myfav_hc_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tmain_myfav_hc_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_myfav_hc_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_myfav_hc_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_myfav_hc_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_myfav_hc_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_myfav_hc_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tmain_myfav_hc_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_myfav_hc_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_myfav_hc_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_myfav_hc_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_myfav_hc_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_myfav_hc_pane_t3_ParamLimits(TInt aVariety)		{ return (*(Tmain_myfav_hc_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_myfav_hc_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_myfav_hc_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_myfav_hc_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_myfav_hc_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_myfav_hc_pane_t4_ParamLimits(TInt aVariety)		{ return (*(Tmain_myfav_hc_pane_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_myfav_hc_pane_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_myfav_hc_pane_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_myfav_hc_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_myfav_hc_pane_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_myfav_hc_pane_t_Limits()		{ return (*(Tmain_myfav_hc_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_myfav_hc_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_myfav_hc_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tmain_myfav_hc_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_myfav_hc_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout main_myfav_hc_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_myfav_hc_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_myfav_hc_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : bg_myfav_hc_instruction_pane
inline TAknWindowComponentLayout bg_myfav_hc_instruction_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_myfav_hc_instruction_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_myfav_hc_instruction_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : cell_myfav_contact_pane
inline TAknLayoutScalableParameterLimits cell_myfav_contact_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tcell_myfav_contact_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_myfav_contact_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_myfav_contact_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_myfav_contact_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Tcell_myfav_contact_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_myfav_contact_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_myfav_contact_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_myfav_contact_pane_g3_ParamLimits(TInt aVariety)		{ return (*(Tcell_myfav_contact_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_myfav_contact_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_myfav_contact_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_myfav_contact_pane_g4_ParamLimits(TInt aVariety)		{ return (*(Tcell_myfav_contact_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_myfav_contact_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_myfav_contact_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_myfav_contact_pane_g5_ParamLimits(TInt aVariety)		{ return (*(Tcell_myfav_contact_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_myfav_contact_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_myfav_contact_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_myfav_contact_pane_g_Limits()		{ return (*(Tcell_myfav_contact_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits cell_myfav_contact_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tcell_myfav_contact_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout cell_myfav_contact_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_myfav_contact_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_myfav_contact_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_myfav_hc_pane
inline TAknLayoutScalableParameterLimits main_myfav_hc_pane_g3_ParamLimits(TInt aVariety)		{ return (*(Tmain_myfav_hc_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_myfav_hc_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_myfav_hc_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_myfav_hc_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_myfav_hc_pane_g3)))(aVariety, aCol, aRow); }

// LAF Table : application_window
inline TAknWindowComponentLayout popup_adpt_find_window(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_adpt_find_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_adpt_find_window)))(aVariety, aCol, aRow); }

// LAF Table : popup_adpt_find_window
inline TAknLayoutScalableParameterLimits afind_page_pane_ParamLimits(TInt aVariety)		{ return (*(Tafind_page_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_afind_page_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout afind_page_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tafind_page_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_afind_page_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits aid_size_cell_afind_ParamLimits(TInt aVariety)		{ return (*(Taid_size_cell_afind_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_afind_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_size_cell_afind(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_afind_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_afind)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits bg_popup_sub_pane_cp09_ParamLimits(TInt aVariety)		{ return (*(Tbg_popup_sub_pane_cp09_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp09_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_sub_pane_cp09(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp09_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp09)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits find_pane_cp01_ParamLimits(TInt aVariety)		{ return (*(Tfind_pane_cp01_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_pane_cp01_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout find_pane_cp01(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfind_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_pane_cp01)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_afind_control_pane_ParamLimits(TInt aVariety)		{ return (*(Tgrid_afind_control_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_afind_control_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_afind_control_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_afind_control_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_afind_control_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_afind_pane_ParamLimits(TInt aVariety)		{ return (*(Tgrid_afind_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_afind_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_afind_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_afind_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_afind_pane)))(aVariety, aCol, aRow); }

// LAF Table : grid_afind_pane
inline TAknLayoutScalableParameterLimits cell_afind_pane_ParamLimits(TInt aVariety)		{ return (*(Tcell_afind_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_afind_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_afind_pane(TInt aVariety, TInt aCol, TInt aRow)		{ return (*(Tcell_afind_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_afind_pane)))(aVariety, aCol, aRow); }

// LAF Table : afind_page_pane
inline TAknWindowComponentLayout afind_page_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tafind_page_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_afind_page_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout afind_page_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tafind_page_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_afind_page_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout afind_page_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tafind_page_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_afind_page_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits afind_page_pane_g_Limits()		{ return (*(Tafind_page_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_afind_page_pane_g_Limits)))(); }

inline TAknWindowComponentLayout afind_page_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tafind_page_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_afind_page_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout afind_page_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tafind_page_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_afind_page_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : grid_afind_control_pane
inline TAknLayoutScalableParameterLimits cell_afind_grid_control_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_afind_grid_control_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_afind_grid_control_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_afind_grid_control_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_afind_grid_control_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_afind_grid_control_pane)))(aVariety, aCol, aRow); }

// LAF Table : cell_afind_pane
inline TAknLayoutScalableParameterLimits bg_button_pane_cp69_ParamLimits(TInt aVariety)		{ return (*(Tbg_button_pane_cp69_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp69_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_button_pane_cp69(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_cp69_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp69)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_afind_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tcell_afind_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_afind_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_afind_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_afind_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_afind_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_afind_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tcell_afind_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_afind_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout cell_afind_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_afind_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_afind_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : cell_afind_grid_control_pane
inline TAknWindowComponentLayout bg_button_pane_cp72(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_cp72_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp72)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_afind_grid_control_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_afind_grid_control_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_afind_grid_control_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : main_call2_pane
inline TAknLayoutScalableParameterLimits aid_image_placing_area_ParamLimits(TInt aVariety)		{ return (*(Taid_image_placing_area_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_image_placing_area_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_image_placing_area(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_image_placing_area_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_image_placing_area)))(aVariety, aCol, aRow); }

// LAF Table : field_vitu_entry_pane
inline TAknLayoutScalableParameterLimits field_vitu_entry_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tfield_vitu_entry_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu_entry_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout field_vitu_entry_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfield_vitu_entry_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu_entry_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits field_vitu_entry_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Tfield_vitu_entry_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu_entry_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout field_vitu_entry_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfield_vitu_entry_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu_entry_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits field_vitu_entry_pane_g_Limits()		{ return (*(Tfield_vitu_entry_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu_entry_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits field_vitu_entry_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tfield_vitu_entry_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu_entry_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout field_vitu_entry_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfield_vitu_entry_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_field_vitu_entry_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : cell_vitu_itu_pane
inline TAknLayoutScalableParameterLimits cell_vitu_itu_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tcell_vitu_itu_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu_itu_pane_g1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cell_vitu_itu_pane_t3_ParamLimits(TInt aVariety)		{ return (*(Tcell_vitu_itu_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu_itu_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout cell_vitu_itu_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu_itu_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu_itu_pane_t3)))(aVariety, aCol, aRow); }

// LAF Table : mp4_progress_pane
inline TAknLayoutScalableParameterLimits mp4_progress_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tmp4_progress_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mp4_progress_pane_t1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits mp4_progress_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tmp4_progress_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mp4_progress_pane_t2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits mp4_progress_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tmp4_progress_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mp4_progress_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknLayoutScalableParameterLimits mup_progress_pane_cp04_ParamLimits(TInt aVariety)		{ return (*(Tmup_progress_pane_cp04_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_mup_progress_pane_cp04_ParamLimits)))(aVariety); }

// LAF Table : main_myfav_hc_pane
inline TAknLayoutScalableParameterLimits main_myfav_hc_pane_t5_ParamLimits(TInt aVariety)		{ return (*(Tmain_myfav_hc_pane_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_myfav_hc_pane_t5_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_myfav_hc_pane_t5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_myfav_hc_pane_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_myfav_hc_pane_t5)))(aVariety, aCol, aRow); }

// LAF Table : application_window
inline TAknWindowComponentLayout aid_zoom_text_primary(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_zoom_text_primary_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_zoom_text_primary)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_adpt_find_window_ParamLimits(TInt aVariety)		{ return (*(Tpopup_adpt_find_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_adpt_find_window_ParamLimits)))(aVariety); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_cam_set_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cam_set_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam_set_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_camera4_pane
inline TAknLayoutScalableParameterLimits cam4_zoom_pane_ParamLimits(TInt aVariety)		{ return (*(Tcam4_zoom_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_zoom_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cam4_zoom_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcam4_zoom_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_zoom_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_cam_set_pane
inline TAknLayoutScalableParameterLimits main_cam_set_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tmain_cam_set_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam_set_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_cam_set_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cam_set_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam_set_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cam_set_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Tmain_cam_set_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam_set_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_cam_set_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cam_set_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam_set_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_cam_set_pane_g_Limits()		{ return (*(Tmain_cam_set_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam_set_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_cam_set_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tmain_cam_set_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam_set_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout main_cam_set_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cam_set_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam_set_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cam_set_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tmain_cam_set_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam_set_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_cam_set_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cam_set_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam_set_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cset_listscroll_pane_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_listscroll_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_listscroll_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_cset_listscroll_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_listscroll_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_listscroll_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_cset_slider_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_cset_listscroll_pane
inline TAknLayoutScalableParameterLimits main_cset_list_pane_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_list_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_list_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_cset_list_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_list_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_list_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp028(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp028_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp028)))(aVariety, aCol, aRow); }

// LAF Table : main_cset_slider_pane
inline TAknWindowComponentLayout aid_area_touch_slider(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_area_touch_slider_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_area_touch_slider)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cset_slider_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcset_slider_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cset_slider_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_cset_slider_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_cset_slider_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_cset_slider_pane_g_Limits()		{ return (*(Tmain_cset_slider_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g_Limits)))(); }

inline TAknWindowComponentLayout main_cset_slider_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_cset_slider_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_cset_slider_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_cset_slider_pane_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t3)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_cset_slider_pane_t4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t4)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_cset_slider_pane_t5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t5)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_cset_slider_pane_t6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_t6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t6)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_cset_slider_pane_t7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_t7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_cset_slider_pane_t_Limits()		{ return (*(Tmain_cset_slider_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t_Limits)))(); }

inline TAknTextComponentLayout main_cset_slider_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_cset_list_pane
inline TAknLayoutScalableParameterLimits cset_list_set_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcset_list_set_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cset_list_set_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cset_list_set_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcset_list_set_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cset_list_set_pane)))(aVariety, aCol, aRow); }

// LAF Table : cset_list_set_pane
inline TAknWindowComponentLayout aid_position_infowindow_above(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_position_infowindow_above_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_position_infowindow_above)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout aid_position_infowindow_below(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_position_infowindow_below_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_position_infowindow_below)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cset_list_set_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tcset_list_set_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cset_list_set_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cset_list_set_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcset_list_set_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cset_list_set_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cset_list_set_pane_g3_ParamLimits(TInt aVariety)		{ return (*(Tcset_list_set_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cset_list_set_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cset_list_set_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcset_list_set_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cset_list_set_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cset_list_set_pane_g_Limits()		{ return (*(Tcset_list_set_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cset_list_set_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits cset_list_set_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tcset_list_set_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cset_list_set_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout cset_list_set_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcset_list_set_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cset_list_set_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cset_list_set_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tcset_list_set_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cset_list_set_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout cset_list_set_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcset_list_set_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cset_list_set_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_highlight_pane_cp021_ParamLimits(TInt aVariety)		{ return (*(Tlist_highlight_pane_cp021_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp021_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_highlight_pane_cp021(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_cp021_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp021)))(aVariety, aCol, aRow); }

// LAF Table : cset_slider_pane
inline TAknWindowComponentLayout cset_slider_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcset_slider_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cset_slider_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cset_slider_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcset_slider_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cset_slider_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cset_slider_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcset_slider_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cset_slider_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cset_slider_pane_g_Limits()		{ return (*(Tcset_slider_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cset_slider_pane_g_Limits)))(); }

inline TAknWindowComponentLayout cset_slider_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcset_slider_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cset_slider_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : cam4_zoom_pane
inline TAknWindowComponentLayout aid_area_touch_cam4_zoom(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_area_touch_cam4_zoom_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_area_touch_cam4_zoom)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cam4_zoom_cont_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcam4_zoom_cont_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_zoom_cont_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cam4_zoom_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcam4_zoom_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_zoom_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cam4_zoom_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcam4_zoom_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_zoom_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cam4_zoom_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcam4_zoom_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_zoom_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cam4_zoom_pane_g_Limits()		{ return (*(Tcam4_zoom_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_zoom_pane_g_Limits)))(); }

inline TAknWindowComponentLayout cam4_zoom_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcam4_zoom_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_zoom_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : cam4_zoom_cont_pane
inline TAknWindowComponentLayout cam4_zoom_cont_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcam4_zoom_cont_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_zoom_cont_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cam4_zoom_cont_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcam4_zoom_cont_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_zoom_cont_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cam4_zoom_cont_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcam4_zoom_cont_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_zoom_cont_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cam4_zoom_cont_pane_g_Limits()		{ return (*(Tcam4_zoom_cont_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_zoom_cont_pane_g_Limits)))(); }

inline TAknWindowComponentLayout cam4_zoom_cont_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcam4_zoom_cont_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cam4_zoom_cont_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_call4_pane
inline TAknLayoutScalableParameterLimits call4_image_pane_ParamLimits(TInt aVariety)		{ return (*(Tcall4_image_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call4_image_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout call4_image_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall4_image_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call4_image_pane)))(aVariety, aCol, aRow); }

// LAF Table : call4_windows_pane
inline TAknLayoutScalableParameterLimits call4_windows_conf_pane_ParamLimits(TInt aVariety)		{ return (*(Tcall4_windows_conf_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call4_windows_conf_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits popup_call4_audio_in_window_ParamLimits(TInt aVariety)		{ return (*(Tpopup_call4_audio_in_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call4_audio_in_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call4_audio_in_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call4_audio_in_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call4_audio_in_window)))(aVariety, aCol, aRow); }

// LAF Table : call4_windows_conf_pane
inline TAknWindowComponentLayout bg_popup_call2_act_pane_cp02(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_call2_act_pane_cp02_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_call2_act_pane_cp02)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout call4_list_conf_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall4_list_conf_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call4_list_conf_pane)))(aVariety, aCol, aRow); }

// LAF Table : call4_image_pane
inline TAknWindowComponentLayout call4_image_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall4_image_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call4_image_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout call4_image_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall4_image_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call4_image_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits call4_image_pane_g_Limits()		{ return (*(Tcall4_image_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call4_image_pane_g_Limits)))(); }

inline TAknWindowComponentLayout call4_image_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcall4_image_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_call4_image_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : call4_list_conf_pane
inline TAknLayoutScalableParameterLimits list_single_graphic_popup_conf4_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_popup_conf4_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_conf4_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_popup_conf4_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_popup_conf4_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_conf4_pane)))(aVariety, aCol, aRow); }

// LAF Table : list_single_graphic_popup_conf4_pane
inline TAknWindowComponentLayout list_highlight_pane_cp022(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_cp022_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp022)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_single_graphic_popup_conf4_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_popup_conf4_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_conf4_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_single_graphic_popup_conf4_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_popup_conf4_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_conf4_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_graphic_popup_conf4_pane_g_Limits()		{ return (*(Tlist_single_graphic_popup_conf4_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_conf4_pane_g_Limits)))(); }

inline TAknWindowComponentLayout list_single_graphic_popup_conf4_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_popup_conf4_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_conf4_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout list_single_graphic_popup_conf4_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_popup_conf4_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_popup_conf4_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : main_video_tele_pane
inline TAknLayoutScalableParameterLimits popup_vtel_slider_window_ParamLimits(TInt aVariety)		{ return (*(Tpopup_vtel_slider_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vtel_slider_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_vtel_slider_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_vtel_slider_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vtel_slider_window)))(aVariety, aCol, aRow); }

// LAF Table : dialer2_ne_pane
inline TAknLayoutScalableParameterLimits dialer2_ne_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tdialer2_ne_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_dialer2_ne_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout dialer2_ne_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tdialer2_ne_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_dialer2_ne_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits dialer2_ne_pane_t_Limits()		{ return (*(Tdialer2_ne_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_dialer2_ne_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits dialer2_ne_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tdialer2_ne_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_dialer2_ne_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout dialer2_ne_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tdialer2_ne_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_dialer2_ne_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_vtel_slider_window
inline TAknLayoutScalableParameterLimits bg_popup_sub_pane_cp010_ParamLimits(TInt aVariety)		{ return (*(Tbg_popup_sub_pane_cp010_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp010_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_sub_pane_cp010(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp010_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp010)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_vtel_slider_window_g1_ParamLimits(TInt aVariety)		{ return (*(Tpopup_vtel_slider_window_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vtel_slider_window_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_vtel_slider_window_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_vtel_slider_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vtel_slider_window_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_vtel_slider_window_g2_ParamLimits(TInt aVariety)		{ return (*(Tpopup_vtel_slider_window_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vtel_slider_window_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_vtel_slider_window_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_vtel_slider_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vtel_slider_window_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_vtel_slider_window_g_Limits()		{ return (*(Tpopup_vtel_slider_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vtel_slider_window_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_vtel_slider_window_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tpopup_vtel_slider_window_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vtel_slider_window_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout popup_vtel_slider_window_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_vtel_slider_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vtel_slider_window_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits vtel_slider_pane_ParamLimits(TInt aVariety)		{ return (*(Tvtel_slider_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vtel_slider_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout vtel_slider_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvtel_slider_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vtel_slider_pane)))(aVariety, aCol, aRow); }

// LAF Table : vtel_slider_pane
inline TAknLayoutScalableParameterLimits vtel_slider_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tvtel_slider_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vtel_slider_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout vtel_slider_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvtel_slider_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vtel_slider_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits vtel_slider_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Tvtel_slider_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vtel_slider_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout vtel_slider_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvtel_slider_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vtel_slider_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits vtel_slider_pane_g3_ParamLimits(TInt aVariety)		{ return (*(Tvtel_slider_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vtel_slider_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout vtel_slider_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvtel_slider_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vtel_slider_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits vtel_slider_pane_g4_ParamLimits(TInt aVariety)		{ return (*(Tvtel_slider_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vtel_slider_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout vtel_slider_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvtel_slider_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vtel_slider_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits vtel_slider_pane_g5_ParamLimits(TInt aVariety)		{ return (*(Tvtel_slider_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vtel_slider_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout vtel_slider_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvtel_slider_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vtel_slider_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits vtel_slider_pane_g_Limits()		{ return (*(Tvtel_slider_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vtel_slider_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits vtel_slider_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tvtel_slider_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vtel_slider_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout vtel_slider_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvtel_slider_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vtel_slider_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_gallery2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_gallery2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_gallery2_pane)))(aVariety, aCol, aRow); }

// LAF Table : popup_vitu2_window
inline TAknLayoutScalableParameterLimits aid_size_row_itut2_dropdow_list_ParamLimits(TInt aVariety)		{ return (*(Taid_size_row_itut2_dropdow_list_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_row_itut2_dropdow_list_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_size_row_itut2_dropdow_list(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_row_itut2_dropdow_list_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_row_itut2_dropdow_list)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_vitu2_function_top_pane_ParamLimits(TInt aVariety)		{ return (*(Tgrid_vitu2_function_top_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_vitu2_function_top_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_vitu2_function_top_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_vitu2_function_top_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_vitu2_function_top_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_vitu2_dropdown_list_window_ParamLimits(TInt aVariety)		{ return (*(Tpopup_vitu2_dropdown_list_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vitu2_dropdown_list_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_vitu2_dropdown_list_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_vitu2_dropdown_list_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vitu2_dropdown_list_window)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_vitu2_match_list_window(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_vitu2_match_list_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vitu2_match_list_window)))(aVariety, aCol, aRow); }

// LAF Table : grid_vitu2_function_top_pane
inline TAknLayoutScalableParameterLimits cell_vitu2_function_top_pane_ParamLimits(TInt aVariety)		{ return (*(Tcell_vitu2_function_top_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_function_top_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_vitu2_function_top_pane(TInt aVariety, TInt aCol, TInt aRow = 0)		{ return (*(Tcell_vitu2_function_top_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_function_top_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_vitu2_function_top_pane_cp01_ParamLimits(TInt aVariety)		{ return (*(Tcell_vitu2_function_top_pane_cp01_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_function_top_pane_cp01_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_vitu2_function_top_pane_cp01(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu2_function_top_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_function_top_pane_cp01)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_vitu2_function_top_wide_pane_ParamLimits(TInt aVariety)		{ return (*(Tcell_vitu2_function_top_wide_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_function_top_wide_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_vitu2_function_top_wide_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu2_function_top_wide_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_function_top_wide_pane)))(aVariety, aCol, aRow); }

// LAF Table : cell_vitu2_function_top_pane
inline TAknWindowComponentLayout bg_button_pane_cp012(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_cp012_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp012)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_vitu2_function_top_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu2_function_top_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_function_top_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : cell_vitu2_function_top_wide_pane
inline TAknLayoutScalableParameterLimits bg_button_pane_cp013_ParamLimits(TInt aVariety)		{ return (*(Tbg_button_pane_cp013_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp013_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_button_pane_cp013(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_cp013_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp013)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_vitu2_function_top_wide_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tcell_vitu2_function_top_wide_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_function_top_wide_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_vitu2_function_top_wide_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu2_function_top_wide_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_function_top_wide_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : popup_vitu2_match_list_window
inline TAknWindowComponentLayout bg_popup_sub_pane_cp20(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp20_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp20)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_vitu2_match_list_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_vitu2_match_list_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_vitu2_match_list_pane)))(aVariety, aCol, aRow); }

// LAF Table : bg_popup_sub_pane_cp20
inline TAknWindowComponentLayout bg_popup_sub_pane_cp20_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp20_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp20_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_sub_pane_cp20_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp20_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp20_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_sub_pane_cp20_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp20_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp20_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_sub_pane_cp20_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp20_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp20_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_sub_pane_cp20_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp20_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp20_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_sub_pane_cp20_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp20_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp20_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_sub_pane_cp20_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp20_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp20_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_sub_pane_cp20_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp20_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp20_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_sub_pane_cp20_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp20_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp20_g9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits bg_popup_sub_pane_cp20_g_Limits()		{ return (*(Tbg_popup_sub_pane_cp20_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp20_g_Limits)))(); }

inline TAknWindowComponentLayout bg_popup_sub_pane_cp20_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp20_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp20_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_vitu2_match_list_pane
inline TAknLayoutScalableParameterLimits list_vitu2_match_list_item_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_vitu2_match_list_item_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_vitu2_match_list_item_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_vitu2_match_list_item_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_vitu2_match_list_item_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_vitu2_match_list_item_pane)))(aVariety, aCol, aRow); }

// LAF Table : list_vitu2_match_list_item_pane
inline TAknTextComponentLayout list_vitu2_match_list_item_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_vitu2_match_list_item_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_vitu2_match_list_item_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : popup_vitu2_dropdown_list_window
inline TAknWindowComponentLayout bg_popup_sub_pane_cp21(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp21_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp21)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_vitu2_dropdown_list_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_vitu2_dropdown_list_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_vitu2_dropdown_list_pane)))(aVariety, aCol, aRow); }

// LAF Table : grid_vitu2_dropdown_list_pane
inline TAknLayoutScalableParameterLimits cell_vitu2_dropdown_list_char_pane_ParamLimits(TInt aVariety)		{ return (*(Tcell_vitu2_dropdown_list_char_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_dropdown_list_char_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_vitu2_dropdown_list_char_pane(TInt aVariety, TInt aCol, TInt aRow)		{ return (*(Tcell_vitu2_dropdown_list_char_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_dropdown_list_char_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_vitu2_dropdown_list_ctrl_pane_ParamLimits(TInt aVariety)		{ return (*(Tcell_vitu2_dropdown_list_ctrl_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_dropdown_list_ctrl_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_vitu2_dropdown_list_ctrl_pane(TInt aVariety, TInt aCol, TInt aRow)		{ return (*(Tcell_vitu2_dropdown_list_ctrl_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_dropdown_list_ctrl_pane)))(aVariety, aCol, aRow); }

// LAF Table : cell_vitu2_dropdown_list_char_pane
inline TAknWindowComponentLayout cell_vitu2_dropdown_list_char_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu2_dropdown_list_char_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_dropdown_list_char_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_vitu2_dropdown_list_char_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu2_dropdown_list_char_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_dropdown_list_char_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_vitu2_dropdown_list_char_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu2_dropdown_list_char_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_dropdown_list_char_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_vitu2_dropdown_list_char_pane_g_Limits()		{ return (*(Tcell_vitu2_dropdown_list_char_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_dropdown_list_char_pane_g_Limits)))(); }

inline TAknWindowComponentLayout cell_vitu2_dropdown_list_char_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu2_dropdown_list_char_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_dropdown_list_char_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout cell_vitu2_dropdown_list_char_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu2_dropdown_list_char_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_dropdown_list_char_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : cell_vitu2_dropdown_list_ctrl_pane
inline TAknLayoutScalableParameterLimits cell_vitu2_dropdown_list_ctrl_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tcell_vitu2_dropdown_list_ctrl_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_dropdown_list_ctrl_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_vitu2_dropdown_list_ctrl_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu2_dropdown_list_ctrl_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_dropdown_list_ctrl_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_vitu2_dropdown_list_ctrl_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Tcell_vitu2_dropdown_list_ctrl_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_dropdown_list_ctrl_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_vitu2_dropdown_list_ctrl_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu2_dropdown_list_ctrl_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_dropdown_list_ctrl_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_vitu2_dropdown_list_ctrl_pane_g3_ParamLimits(TInt aVariety)		{ return (*(Tcell_vitu2_dropdown_list_ctrl_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_dropdown_list_ctrl_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_vitu2_dropdown_list_ctrl_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu2_dropdown_list_ctrl_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_dropdown_list_ctrl_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_vitu2_dropdown_list_ctrl_pane_g4_ParamLimits(TInt aVariety)		{ return (*(Tcell_vitu2_dropdown_list_ctrl_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_dropdown_list_ctrl_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_vitu2_dropdown_list_ctrl_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu2_dropdown_list_ctrl_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_dropdown_list_ctrl_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_vitu2_dropdown_list_ctrl_pane_g5_ParamLimits(TInt aVariety)		{ return (*(Tcell_vitu2_dropdown_list_ctrl_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_dropdown_list_ctrl_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_vitu2_dropdown_list_ctrl_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu2_dropdown_list_ctrl_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_dropdown_list_ctrl_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_vitu2_dropdown_list_ctrl_pane_g_Limits()		{ return (*(Tcell_vitu2_dropdown_list_ctrl_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_dropdown_list_ctrl_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits cell_vitu2_dropdown_list_ctrl_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tcell_vitu2_dropdown_list_ctrl_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_dropdown_list_ctrl_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout cell_vitu2_dropdown_list_ctrl_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu2_dropdown_list_ctrl_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_dropdown_list_ctrl_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_gallery2_pane
inline TAknLayoutScalableParameterLimits aid_size_cell_gallery2_ParamLimits(TInt aVariety)		{ return (*(Taid_size_cell_gallery2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_gallery2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_size_cell_gallery2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_gallery2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_gallery2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_gallery2_pane_ParamLimits(TInt aVariety)		{ return (*(Tgrid_gallery2_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_gallery2_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_gallery2_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_gallery2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_gallery2_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits scroll_pane_cp029_ParamLimits(TInt aVariety)		{ return (*(Tscroll_pane_cp029_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp029_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout scroll_pane_cp029(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp029_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp029)))(aVariety, aCol, aRow); }

// LAF Table : grid_gallery2_pane
inline TAknLayoutScalableParameterLimits cell_gallery2_pane_ParamLimits(TInt aVariety)		{ return (*(Tcell_gallery2_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gallery2_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_gallery2_pane(TInt aVariety, TInt aCol, TInt aRow)		{ return (*(Tcell_gallery2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gallery2_pane)))(aVariety, aCol, aRow); }

// LAF Table : cell_gallery2_pane
inline TAknWindowComponentLayout cell_gallery2_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_gallery2_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gallery2_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_gallery2_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_gallery2_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gallery2_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_gallery2_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_gallery2_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gallery2_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_gallery2_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_gallery2_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_gallery2_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_highlight_pane_cp10(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_cp10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp10)))(aVariety, aCol, aRow); }

// LAF Table : popup_vitu2_window
inline TAknLayoutScalableParameterLimits popup_vitu2_match_list_window_ParamLimits(TInt aVariety)		{ return (*(Tpopup_vitu2_match_list_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vitu2_match_list_window_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits popup_vitu2_query_window_ParamLimits(TInt aVariety)		{ return (*(Tpopup_vitu2_query_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vitu2_query_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_vitu2_query_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_vitu2_query_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vitu2_query_window)))(aVariety, aCol, aRow); }

// LAF Table : list_vitu2_match_list_item_pane
inline TAknWindowComponentLayout bg_vitu2_candi_button_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_vitu2_candi_button_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_vitu2_candi_button_pane)))(aVariety, aCol, aRow); }

// LAF Table : bg_vitu2_candi_button_pane
inline TAknWindowComponentLayout cell_vitu2_dropdown_list_char_pane_g1_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu2_dropdown_list_char_pane_g1_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_dropdown_list_char_pane_g1_copy1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_vitu2_dropdown_list_char_pane_g2_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu2_dropdown_list_char_pane_g2_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_dropdown_list_char_pane_g2_copy1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_vitu2_dropdown_list_char_pane_g2_copy2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vitu2_dropdown_list_char_pane_g2_copy2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vitu2_dropdown_list_char_pane_g2_copy2)))(aVariety, aCol, aRow); }

// LAF Table : popup_vitu2_query_window
inline TAknWindowComponentLayout bg_button_pane_cp015(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_cp015_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp015)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_button_pane_cp016(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_cp016_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp016)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_button_pane_cp017(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_cp017_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp017)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_sub_pane_cp22(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp22_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp22)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_vitu2_query_window_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_vitu2_query_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vitu2_query_window_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_vitu2_query_window_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_vitu2_query_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vitu2_query_window_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_vitu2_query_window_g_Limits()		{ return (*(Tpopup_vitu2_query_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vitu2_query_window_g_Limits)))(); }

inline TAknWindowComponentLayout popup_vitu2_query_window_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_vitu2_query_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vitu2_query_window_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_vitu2_query_window_t1_ParamLimits(TInt aVariety)		{ return (*(Tpopup_vitu2_query_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vitu2_query_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_vitu2_query_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_vitu2_query_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vitu2_query_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_vitu2_query_window_t2_ParamLimits(TInt aVariety)		{ return (*(Tpopup_vitu2_query_window_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vitu2_query_window_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_vitu2_query_window_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_vitu2_query_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vitu2_query_window_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_vitu2_query_window_t3_ParamLimits(TInt aVariety)		{ return (*(Tpopup_vitu2_query_window_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vitu2_query_window_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_vitu2_query_window_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_vitu2_query_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vitu2_query_window_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_vitu2_query_window_t4_ParamLimits(TInt aVariety)		{ return (*(Tpopup_vitu2_query_window_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vitu2_query_window_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_vitu2_query_window_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_vitu2_query_window_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vitu2_query_window_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_vitu2_query_window_t5_ParamLimits(TInt aVariety)		{ return (*(Tpopup_vitu2_query_window_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vitu2_query_window_t5_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_vitu2_query_window_t5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_vitu2_query_window_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vitu2_query_window_t5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_vitu2_query_window_t_Limits()		{ return (*(Tpopup_vitu2_query_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vitu2_query_window_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_vitu2_query_window_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tpopup_vitu2_query_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vitu2_query_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_vitu2_query_window_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_vitu2_query_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vitu2_query_window_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_cam_set_pane
inline TAknWindowComponentLayout main_cset_text_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_text_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_text_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_cset_slider_pane
inline TAknLayoutScalableParameterLimits aid_area_touch_slider_ParamLimits(TInt aVariety)		{ return (*(Taid_area_touch_slider_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_area_touch_slider_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cset_slider_pane_ParamLimits(TInt aVariety)		{ return (*(Tcset_slider_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cset_slider_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_g3_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_cset_slider_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_g4_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_cset_slider_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_g5_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_cset_slider_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_g6_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_g6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g6_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_cset_slider_pane_g6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tmain_cset_slider_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_t3_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t3_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_t4_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t4_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_t5_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t5_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_t6_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_t6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t6_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_t7_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_t7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t7_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_t8_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_t8_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t8_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_cset_slider_pane_t8(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_t8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t8)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_t9_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_t9_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t9_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_cset_slider_pane_t9(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_t9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_t10_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_t10_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t10_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_cset_slider_pane_t10(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_t10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t10)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_t11_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_t11_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t11_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_cset_slider_pane_t11(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_t11_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t11)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_t12_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_t12_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t12_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_cset_slider_pane_t12(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_t12_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t12)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_t13_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_t13_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t13_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_cset_slider_pane_t13(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_t13_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t13)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tmain_cset_slider_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t_ParamLimits)))(aLineIndex, aVariety); }

// LAF Table : main_cset_text_pane
inline TAknWindowComponentLayout bg_popup_sub_pane_cp011(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp011_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp011)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_cset_text_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_text_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_text_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_cset_text_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_text_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_text_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_cset_text_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_text_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_text_pane_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_cset_text_pane_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_text_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_text_pane_t3)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_cset_text_pane_t4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_text_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_text_pane_t4)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_cset_text_pane_t5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_text_pane_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_text_pane_t5)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_cset_text_pane_t6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_text_pane_t6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_text_pane_t6)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout main_cset_text_pane_t7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_text_pane_t7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_text_pane_t7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_cset_text_pane_t_Limits()		{ return (*(Tmain_cset_text_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_text_pane_t_Limits)))(); }

inline TAknTextComponentLayout main_cset_text_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_text_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_text_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_cam4_burst_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cam4_burst_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam4_burst_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_cam5_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cam5_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane)))(aVariety, aCol, aRow); }

// LAF Table : afind_page_pane
inline TAknWindowComponentLayout bg_button_pane_cp019(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_cp019_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp019)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_button_pane_cp020(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_cp020_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp020)))(aVariety, aCol, aRow); }

// LAF Table : main_cset_slider_pane
inline TAknLayoutScalableParameterLimits main_cset_slider_pane_g7_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_g7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g7_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_cset_slider_pane_g7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_g8_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_g8_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g8_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_cset_slider_pane_g8(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g8)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_g9_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_g9_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g9_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_cset_slider_pane_g9(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_g10_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_g10_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g10_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_cset_slider_pane_g10(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_g10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g10)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_g11_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_g11_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g11_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_cset_slider_pane_g11(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_g11_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g11)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_g12_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_g12_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g12_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_cset_slider_pane_g12(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_g12_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g12)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_g13_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_g13_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g13_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_cset_slider_pane_g13(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_g13_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g13)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_g14_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_g14_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g14_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_cset_slider_pane_g14(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_g14_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g14)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_g15_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_g15_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g15_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_cset_slider_pane_g15(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_g15_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g15)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_t14_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_t14_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t14_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_cset_slider_pane_t14(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_t14_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t14)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_t15_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_t15_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t15_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_cset_slider_pane_t15(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_t15_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_t15)))(aVariety, aCol, aRow); }

// LAF Table : main_cam4_burst_pane
inline TAknLayoutScalableParameterLimits aid_cam4_burst_size_cell_ParamLimits(TInt aVariety)		{ return (*(Taid_cam4_burst_size_cell_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_cam4_burst_size_cell_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_cam4_burst_size_cell(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_cam4_burst_size_cell_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_cam4_burst_size_cell)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_cam4_burst_pane_ParamLimits(TInt aVariety)		{ return (*(Tgrid_cam4_burst_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_cam4_burst_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_cam4_burst_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_cam4_burst_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_cam4_burst_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits linegrid_cam4_burst_pane_ParamLimits(TInt aVariety)		{ return (*(Tlinegrid_cam4_burst_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cam4_burst_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout linegrid_cam4_burst_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlinegrid_cam4_burst_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cam4_burst_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits scroll_pane_cp30_ParamLimits(TInt aVariety)		{ return (*(Tscroll_pane_cp30_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp30_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout scroll_pane_cp30(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp30_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp30)))(aVariety, aCol, aRow); }

// LAF Table : grid_cam4_burst_pane
inline TAknLayoutScalableParameterLimits cell_cam4_burst_pane_ParamLimits(TInt aVariety)		{ return (*(Tcell_cam4_burst_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_cam4_burst_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_cam4_burst_pane(TInt aVariety, TInt aCol, TInt aRow)		{ return (*(Tcell_cam4_burst_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_cam4_burst_pane)))(aVariety, aCol, aRow); }

// LAF Table : linegrid_cam4_burst_pane
inline TAknLayoutScalableParameterLimits linegrid_cam4_burst_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tlinegrid_cam4_burst_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cam4_burst_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout linegrid_cam4_burst_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlinegrid_cam4_burst_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cam4_burst_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits linegrid_cam4_burst_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Tlinegrid_cam4_burst_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cam4_burst_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout linegrid_cam4_burst_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlinegrid_cam4_burst_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cam4_burst_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits linegrid_cam4_burst_pane_g3_ParamLimits(TInt aVariety)		{ return (*(Tlinegrid_cam4_burst_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cam4_burst_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout linegrid_cam4_burst_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlinegrid_cam4_burst_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cam4_burst_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits linegrid_cam4_burst_pane_g_Limits()		{ return (*(Tlinegrid_cam4_burst_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cam4_burst_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits linegrid_cam4_burst_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tlinegrid_cam4_burst_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cam4_burst_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout linegrid_cam4_burst_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlinegrid_cam4_burst_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cam4_burst_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits linegrid_cam4_burst_pane_g3_copy1_ParamLimits(TInt aVariety)		{ return (*(Tlinegrid_cam4_burst_pane_g3_copy1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cam4_burst_pane_g3_copy1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout linegrid_cam4_burst_pane_g3_copy1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlinegrid_cam4_burst_pane_g3_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cam4_burst_pane_g3_copy1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits linegrid_cam4_burst_pane_g4_ParamLimits(TInt aVariety)		{ return (*(Tlinegrid_cam4_burst_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cam4_burst_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout linegrid_cam4_burst_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlinegrid_cam4_burst_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cam4_burst_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits linegrid_cam4_burst_pane_g5_ParamLimits(TInt aVariety)		{ return (*(Tlinegrid_cam4_burst_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cam4_burst_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout linegrid_cam4_burst_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlinegrid_cam4_burst_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cam4_burst_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits linegrid_cam4_burst_pane_g6_ParamLimits(TInt aVariety)		{ return (*(Tlinegrid_cam4_burst_pane_g6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cam4_burst_pane_g6_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout linegrid_cam4_burst_pane_g6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlinegrid_cam4_burst_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cam4_burst_pane_g6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits linegrid_cam4_burst_pane_g7_ParamLimits(TInt aVariety)		{ return (*(Tlinegrid_cam4_burst_pane_g7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cam4_burst_pane_g7_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout linegrid_cam4_burst_pane_g7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlinegrid_cam4_burst_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_cam4_burst_pane_g7)))(aVariety, aCol, aRow); }

// LAF Table : cell_cam4_burst_pane
inline TAknWindowComponentLayout cell_cam4_burst_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_cam4_burst_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_cam4_burst_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : main_cam5_pane
inline TAknLayoutScalableParameterLimits main_cam5_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_cam5_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_cam5_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cam5_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cam5_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_cam5_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_cam5_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cam5_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cam5_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_cam5_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_cam5_pane_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cam5_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cam5_pane_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_cam5_pane_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_cam5_pane_t4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cam5_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cam5_pane_t5_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_cam5_pane_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t5_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_cam5_pane_t5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cam5_pane_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cam5_pane_t6_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_cam5_pane_t6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t6_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_cam5_pane_t6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cam5_pane_t6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cam5_pane_t7_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_cam5_pane_t7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t7_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_cam5_pane_t7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cam5_pane_t7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cam5_pane_t8_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_cam5_pane_t8_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t8_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_cam5_pane_t8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cam5_pane_t8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t8)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cam5_pane_t9_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_cam5_pane_t9_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t9_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_cam5_pane_t9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cam5_pane_t9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cam5_pane_t10_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_cam5_pane_t10_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t10_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_cam5_pane_t10(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cam5_pane_t10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t10)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cam5_pane_t11_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_cam5_pane_t11_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t11_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_cam5_pane_t11(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cam5_pane_t11_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t11)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cam5_pane_t12_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_cam5_pane_t12_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t12_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_cam5_pane_t12(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cam5_pane_t12_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t12)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cam5_pane_t13_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_cam5_pane_t13_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t13_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_cam5_pane_t13(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cam5_pane_t13_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t13)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_cam5_pane_t_Limits()		{ return (*(Tmain_cam5_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_cam5_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmain_cam5_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout main_cam5_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cam5_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam5_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : application_window
inline TAknLayoutScalableParameterLimits popup_scut_keymap_window_ParamLimits(TInt aVariety)		{ return (*(Tpopup_scut_keymap_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_scut_keymap_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_scut_keymap_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_scut_keymap_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_scut_keymap_window)))(aVariety, aCol, aRow); }

// LAF Table : popup_scut_keymap_window
inline TAknWindowComponentLayout aid_size_cell_brow_shortcut(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_brow_shortcut_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_brow_shortcut)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_window_pane_cp010(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp010_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp010)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_scut_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_scut_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_scut_pane)))(aVariety, aCol, aRow); }

// LAF Table : grid_scut_pane
inline TAknLayoutScalableParameterLimits cell_scut_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_scut_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_scut_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_scut_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_scut_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_scut_pane)))(aVariety, aCol, aRow); }

// LAF Table : cell_scut_pane
inline TAknWindowComponentLayout cell_scut_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_scut_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_scut_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cell_scut_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_scut_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_scut_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cell_scut_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_scut_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_scut_pane_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cell_scut_pane_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_scut_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_scut_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_scut_pane_t_Limits()		{ return (*(Tcell_scut_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_scut_pane_t_Limits)))(); }

inline TAknTextComponentLayout cell_scut_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_scut_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_scut_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_mup3_pane
inline TAknLayoutScalableParameterLimits main_mup3_pane_g8_ParamLimits(TInt aVariety)		{ return (*(Tmain_mup3_pane_g8_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_g8_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_mup3_pane_g8(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_mup3_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_mup3_pane_g8)))(aVariety, aCol, aRow); }

// LAF Table : popup_vitu2_window
inline TAknLayoutScalableParameterLimits area_vitu2_query_pane_ParamLimits(TInt aVariety)		{ return (*(Tarea_vitu2_query_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_vitu2_query_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout area_vitu2_query_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tarea_vitu2_query_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_vitu2_query_pane)))(aVariety, aCol, aRow); }

// LAF Table : popup_vitu2_query_window
inline TAknWindowComponentLayout input_focus_pane_cp08(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp08_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp08)))(aVariety, aCol, aRow); }

// LAF Table : area_vitu2_query_pane
inline TAknWindowComponentLayout area_vitu2_query_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tarea_vitu2_query_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_vitu2_query_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout area_vitu2_query_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tarea_vitu2_query_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_vitu2_query_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits area_vitu2_query_pane_g_Limits()		{ return (*(Tarea_vitu2_query_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_vitu2_query_pane_g_Limits)))(); }

inline TAknWindowComponentLayout area_vitu2_query_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tarea_vitu2_query_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_vitu2_query_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits area_vitu2_query_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tarea_vitu2_query_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_vitu2_query_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout area_vitu2_query_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tarea_vitu2_query_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_vitu2_query_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits area_vitu2_query_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tarea_vitu2_query_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_vitu2_query_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout area_vitu2_query_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tarea_vitu2_query_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_vitu2_query_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits area_vitu2_query_pane_t3_ParamLimits(TInt aVariety)		{ return (*(Tarea_vitu2_query_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_vitu2_query_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout area_vitu2_query_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tarea_vitu2_query_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_vitu2_query_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits area_vitu2_query_pane_t4_ParamLimits(TInt aVariety)		{ return (*(Tarea_vitu2_query_pane_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_vitu2_query_pane_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout area_vitu2_query_pane_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tarea_vitu2_query_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_vitu2_query_pane_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits area_vitu2_query_pane_t5_ParamLimits(TInt aVariety)		{ return (*(Tarea_vitu2_query_pane_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_vitu2_query_pane_t5_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout area_vitu2_query_pane_t5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tarea_vitu2_query_pane_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_vitu2_query_pane_t5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits area_vitu2_query_pane_t6_ParamLimits(TInt aVariety)		{ return (*(Tarea_vitu2_query_pane_t6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_vitu2_query_pane_t6_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout area_vitu2_query_pane_t6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tarea_vitu2_query_pane_t6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_vitu2_query_pane_t6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits area_vitu2_query_pane_t_Limits()		{ return (*(Tarea_vitu2_query_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_vitu2_query_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits area_vitu2_query_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tarea_vitu2_query_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_vitu2_query_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout area_vitu2_query_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tarea_vitu2_query_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_vitu2_query_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_button_pane_cp018(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_cp018_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp018)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_button_pane_cp021(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_cp021_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp021)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_button_pane_cp022(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_cp022_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp022)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_cp09(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp09_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp09)))(aVariety, aCol, aRow); }

// LAF Table : navi_pane
inline TAknWindowComponentLayout aid_size_touch_mv_arrow_left(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_touch_mv_arrow_left_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_touch_mv_arrow_left)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout aid_size_touch_mv_arrow_right(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_touch_mv_arrow_right_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_touch_mv_arrow_right)))(aVariety, aCol, aRow); }

// LAF Table : main_cset_slider_pane
inline TAknLayoutScalableParameterLimits main_cset_slider_pane_g16_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_g16_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g16_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_cset_slider_pane_g16(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_g16_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g16)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_cset_slider_pane_g17_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_g17_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g17_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_cset_slider_pane_g17(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_g17_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g17)))(aVariety, aCol, aRow); }

// LAF Table : cell_cam4_burst_pane
inline TAknLayoutScalableParameterLimits cell_cam4_burst_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tcell_cam4_burst_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_cam4_burst_pane_g1_ParamLimits)))(aVariety); }

// LAF Table : Screen
inline TAknWindowComponentLayout compa_mode_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcompa_mode_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_compa_mode_pane)))(aVariety, aCol, aRow); }

// LAF Table : popup_vtel_slider_window
inline TAknLayoutScalableParameterLimits popup_vtel_slider_window_g3_ParamLimits(TInt aVariety)		{ return (*(Tpopup_vtel_slider_window_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vtel_slider_window_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_vtel_slider_window_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_vtel_slider_window_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vtel_slider_window_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_vtel_slider_window_g4_ParamLimits(TInt aVariety)		{ return (*(Tpopup_vtel_slider_window_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vtel_slider_window_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_vtel_slider_window_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_vtel_slider_window_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vtel_slider_window_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_vtel_slider_window_t1_ParamLimits(TInt aVariety)		{ return (*(Tpopup_vtel_slider_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vtel_slider_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_vtel_slider_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_vtel_slider_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_vtel_slider_window_t1)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_cl_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cl_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cl_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_imed_adjust2_window_ParamLimits(TInt aVariety)		{ return (*(Tpopup_imed_adjust2_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_imed_adjust2_window_ParamLimits)))(aVariety); }

// LAF Table : popup_imed_adjust2_window
inline TAknLayoutScalableParameterLimits bg_tb_trans_pane_cp05_ParamLimits(TInt aVariety)		{ return (*(Tbg_tb_trans_pane_cp05_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_tb_trans_pane_cp05_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits popup_imed_adjust2_window_g1_ParamLimits(TInt aVariety)		{ return (*(Tpopup_imed_adjust2_window_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_imed_adjust2_window_g1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits popup_imed_adjust2_window_g2_ParamLimits(TInt aVariety)		{ return (*(Tpopup_imed_adjust2_window_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_imed_adjust2_window_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_imed_adjust2_window_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_imed_adjust2_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_imed_adjust2_window_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_imed_adjust2_window_g3_ParamLimits(TInt aVariety)		{ return (*(Tpopup_imed_adjust2_window_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_imed_adjust2_window_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_imed_adjust2_window_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_imed_adjust2_window_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_imed_adjust2_window_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_imed_adjust2_window_g_Limits()		{ return (*(Tpopup_imed_adjust2_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_imed_adjust2_window_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_imed_adjust2_window_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tpopup_imed_adjust2_window_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_imed_adjust2_window_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout popup_imed_adjust2_window_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_imed_adjust2_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_imed_adjust2_window_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_imed_adjust2_window_t1_ParamLimits(TInt aVariety)		{ return (*(Tpopup_imed_adjust2_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_imed_adjust2_window_t1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits slider_imed_adjust_pane_ParamLimits(TInt aVariety)		{ return (*(Tslider_imed_adjust_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_imed_adjust_pane_ParamLimits)))(aVariety); }

// LAF Table : slider_imed_adjust_pane
inline TAknLayoutScalableParameterLimits slider_imed_adjust_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tslider_imed_adjust_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_imed_adjust_pane_g1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits slider_imed_adjust_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Tslider_imed_adjust_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_imed_adjust_pane_g2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits slider_imed_adjust_pane_g3_ParamLimits(TInt aVariety)		{ return (*(Tslider_imed_adjust_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_imed_adjust_pane_g3_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits slider_imed_adjust_pane_g4_ParamLimits(TInt aVariety)		{ return (*(Tslider_imed_adjust_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_imed_adjust_pane_g4_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits slider_imed_adjust_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tslider_imed_adjust_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_imed_adjust_pane_g_ParamLimits)))(aLineIndex, aVariety); }

// LAF Table : main_camera4_pane
inline TAknLayoutScalableParameterLimits aid_touch_area_cam4_ParamLimits(TInt aVariety)		{ return (*(Taid_touch_area_cam4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_touch_area_cam4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_touch_area_cam4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_touch_area_cam4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_touch_area_cam4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout battery_pane_cp01(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbattery_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_battery_pane_cp01)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_camera4_pane_g6_ParamLimits(TInt aVariety)		{ return (*(Tmain_camera4_pane_g6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera4_pane_g6_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_camera4_pane_g6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera4_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera4_pane_g6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_camera4_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tmain_camera4_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera4_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_camera4_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera4_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera4_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_camera4_pane_t_Limits()		{ return (*(Tmain_camera4_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera4_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_camera4_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tmain_camera4_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera4_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout main_camera4_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_camera4_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_camera4_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_video4_pane
inline TAknLayoutScalableParameterLimits aid_touch_area_vid4_ParamLimits(TInt aVariety)		{ return (*(Taid_touch_area_vid4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_touch_area_vid4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_touch_area_vid4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_touch_area_vid4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_touch_area_vid4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_video4_pane_g5_ParamLimits(TInt aVariety)		{ return (*(Tmain_video4_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video4_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_video4_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_video4_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_video4_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits vid4_progress_pane_ParamLimits(TInt aVariety)		{ return (*(Tvid4_progress_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vid4_progress_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout vid4_progress_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvid4_progress_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vid4_progress_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_cset_slider_pane
inline TAknLayoutScalableParameterLimits main_cset_slider_pane_g18_ParamLimits(TInt aVariety)		{ return (*(Tmain_cset_slider_pane_g18_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g18_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_cset_slider_pane_g18(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_cset_slider_pane_g18_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cset_slider_pane_g18)))(aVariety, aCol, aRow); }

// LAF Table : cell_cam4_burst_pane
inline TAknLayoutScalableParameterLimits cell_cam4_burst_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Tcell_cam4_burst_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_cam4_burst_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_cam4_burst_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_cam4_burst_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_cam4_burst_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_cam4_burst_pane_g_Limits()		{ return (*(Tcell_cam4_burst_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_cam4_burst_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits cell_cam4_burst_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tcell_cam4_burst_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_cam4_burst_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout cell_cam4_burst_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_cam4_burst_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_cam4_burst_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_cl_pane
inline TAknLayoutScalableParameterLimits bg_cl_pane_ParamLimits(TInt aVariety)		{ return (*(Tbg_cl_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cl_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_cl_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cl_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cl_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cl_header_pane_ParamLimits(TInt aVariety)		{ return (*(Tcl_header_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cl_header_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cl_header_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcl_header_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cl_header_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cl_listscroll_pane_ParamLimits(TInt aVariety)		{ return (*(Tcl_listscroll_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cl_listscroll_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cl_listscroll_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcl_listscroll_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cl_listscroll_pane)))(aVariety, aCol, aRow); }

// LAF Table : bg_cl_pane
inline TAknWindowComponentLayout bg_cl_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cl_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cl_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cl_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cl_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cl_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cl_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cl_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cl_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cl_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cl_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cl_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cl_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cl_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cl_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cl_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cl_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cl_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cl_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cl_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cl_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cl_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cl_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cl_pane_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cl_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cl_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cl_pane_g9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits bg_cl_pane_g_Limits()		{ return (*(Tbg_cl_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cl_pane_g_Limits)))(); }

inline TAknWindowComponentLayout bg_cl_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cl_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cl_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : cl_header_pane
inline TAknLayoutScalableParameterLimits aid_height_cl_leading_ParamLimits(TInt aVariety)		{ return (*(Taid_height_cl_leading_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_height_cl_leading_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_height_cl_leading(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_height_cl_leading_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_height_cl_leading)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits aid_height_cl_text_ParamLimits(TInt aVariety)		{ return (*(Taid_height_cl_text_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_height_cl_text_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_height_cl_text(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_height_cl_text_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_height_cl_text)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits bg_cl_header_pane_ParamLimits(TInt aVariety)		{ return (*(Tbg_cl_header_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cl_header_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_cl_header_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cl_header_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cl_header_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cl_header_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tcl_header_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cl_header_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cl_header_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcl_header_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cl_header_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cl_header_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tcl_header_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cl_header_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout cl_header_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcl_header_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cl_header_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : cl_listscroll_pane
inline TAknWindowComponentLayout cl_list_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcl_list_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cl_list_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout hc_scroll_pane_cp01(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thc_scroll_pane_cp01_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_scroll_pane_cp01)))(aVariety, aCol, aRow); }

// LAF Table : bg_cl_header_pane
inline TAknWindowComponentLayout bg_cl_header_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cl_header_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cl_header_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cl_header_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cl_header_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cl_header_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cl_header_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cl_header_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cl_header_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cl_header_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cl_header_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cl_header_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cl_header_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cl_header_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cl_header_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cl_header_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cl_header_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cl_header_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cl_header_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cl_header_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cl_header_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cl_header_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cl_header_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cl_header_pane_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_cl_header_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cl_header_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cl_header_pane_g9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits bg_cl_header_pane_g_Limits()		{ return (*(Tbg_cl_header_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cl_header_pane_g_Limits)))(); }

inline TAknWindowComponentLayout bg_cl_header_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_cl_header_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_cl_header_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : cl_list_pane
inline TAknLayoutScalableParameterLimits hc_cl_list_double_graphic_heading_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Thc_cl_list_double_graphic_heading_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_double_graphic_heading_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout hc_cl_list_double_graphic_heading_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thc_cl_list_double_graphic_heading_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_double_graphic_heading_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits hc_cl_list_single_graphic_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Thc_cl_list_single_graphic_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_single_graphic_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout hc_cl_list_single_graphic_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thc_cl_list_single_graphic_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_single_graphic_pane)))(aVariety, aCol, aRow); }

// LAF Table : hc_cl_list_single_graphic_pane
inline TAknLayoutScalableParameterLimits hc_cl_list_single_graphic_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Thc_cl_list_single_graphic_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_single_graphic_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout hc_cl_list_single_graphic_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thc_cl_list_single_graphic_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_single_graphic_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits hc_cl_list_single_graphic_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Thc_cl_list_single_graphic_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_single_graphic_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout hc_cl_list_single_graphic_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thc_cl_list_single_graphic_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_single_graphic_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits hc_cl_list_single_graphic_pane_g_Limits()		{ return (*(Thc_cl_list_single_graphic_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_single_graphic_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits hc_cl_list_single_graphic_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Thc_cl_list_single_graphic_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_single_graphic_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout hc_cl_list_single_graphic_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thc_cl_list_single_graphic_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_single_graphic_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits hc_cl_list_single_graphic_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Thc_cl_list_single_graphic_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_single_graphic_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout hc_cl_list_single_graphic_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thc_cl_list_single_graphic_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_single_graphic_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : hc_cl_list_double_graphic_heading_pane
inline TAknLayoutScalableParameterLimits hc_cl_list_double_graphic_heading_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Thc_cl_list_double_graphic_heading_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_double_graphic_heading_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout hc_cl_list_double_graphic_heading_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thc_cl_list_double_graphic_heading_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_double_graphic_heading_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits hc_cl_list_double_graphic_heading_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Thc_cl_list_double_graphic_heading_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_double_graphic_heading_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout hc_cl_list_double_graphic_heading_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thc_cl_list_double_graphic_heading_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_double_graphic_heading_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits hc_cl_list_double_graphic_heading_pane_g3_ParamLimits(TInt aVariety)		{ return (*(Thc_cl_list_double_graphic_heading_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_double_graphic_heading_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout hc_cl_list_double_graphic_heading_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thc_cl_list_double_graphic_heading_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_double_graphic_heading_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits hc_cl_list_double_graphic_heading_pane_g_Limits()		{ return (*(Thc_cl_list_double_graphic_heading_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_double_graphic_heading_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits hc_cl_list_double_graphic_heading_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Thc_cl_list_double_graphic_heading_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_double_graphic_heading_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout hc_cl_list_double_graphic_heading_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thc_cl_list_double_graphic_heading_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_double_graphic_heading_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits hc_cl_list_double_graphic_heading_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Thc_cl_list_double_graphic_heading_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_double_graphic_heading_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout hc_cl_list_double_graphic_heading_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thc_cl_list_double_graphic_heading_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_double_graphic_heading_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits hc_cl_list_double_graphic_heading_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Thc_cl_list_double_graphic_heading_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_double_graphic_heading_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout hc_cl_list_double_graphic_heading_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thc_cl_list_double_graphic_heading_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_double_graphic_heading_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits hc_cl_list_double_graphic_heading_pane_t_Limits()		{ return (*(Thc_cl_list_double_graphic_heading_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_double_graphic_heading_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits hc_cl_list_double_graphic_heading_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Thc_cl_list_double_graphic_heading_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_double_graphic_heading_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout hc_cl_list_double_graphic_heading_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thc_cl_list_double_graphic_heading_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hc_cl_list_double_graphic_heading_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : vid4_progress_pane
inline TAknWindowComponentLayout vid4_progress_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvid4_progress_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vid4_progress_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vid4_progress_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvid4_progress_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vid4_progress_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vid4_progress_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvid4_progress_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vid4_progress_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vid4_progress_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvid4_progress_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vid4_progress_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits vid4_progress_pane_g_Limits()		{ return (*(Tvid4_progress_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vid4_progress_pane_g_Limits)))(); }

inline TAknWindowComponentLayout vid4_progress_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvid4_progress_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vid4_progress_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout vid4_progress_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvid4_progress_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vid4_progress_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout vid4_progress_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvid4_progress_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vid4_progress_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits vid4_progress_pane_t_Limits()		{ return (*(Tvid4_progress_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vid4_progress_pane_t_Limits)))(); }

inline TAknTextComponentLayout vid4_progress_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvid4_progress_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vid4_progress_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wait_bar_pane_cp07(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twait_bar_pane_cp07_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_bar_pane_cp07)))(aVariety, aCol, aRow); }

// LAF Table : popup_blid_sat_info2_window
inline TAknLayoutScalableParameterLimits blid_firmament_pane_ParamLimits(TInt aVariety)		{ return (*(Tblid_firmament_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid_firmament_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_blid_sat_info2_window_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_blid_sat_info2_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_blid_sat_info2_window_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_blid_sat_info2_window_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_blid_sat_info2_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_blid_sat_info2_window_t3)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_blid_sat_info2_window_t4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_blid_sat_info2_window_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_blid_sat_info2_window_t4)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_blid_sat_info2_window_t5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_blid_sat_info2_window_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_blid_sat_info2_window_t5)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_blid_sat_info2_window_t6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_blid_sat_info2_window_t6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_blid_sat_info2_window_t6)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_blid_sat_info2_window_t7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_blid_sat_info2_window_t7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_blid_sat_info2_window_t7)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_blid_sat_info2_window_t8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_blid_sat_info2_window_t8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_blid_sat_info2_window_t8)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_blid_sat_info2_window_t9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_blid_sat_info2_window_t9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_blid_sat_info2_window_t9)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_blid_sat_info2_window_t10(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_blid_sat_info2_window_t10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_blid_sat_info2_window_t10)))(aVariety, aCol, aRow); }

// LAF Table : blid_firmament_pane
inline TAknLayoutScalableParameterLimits aid_firma_cardinal_ParamLimits(TInt aVariety)		{ return (*(Taid_firma_cardinal_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_firma_cardinal_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits blid_firmament_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tblid_firmament_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid_firmament_pane_t1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits blid_firmament_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tblid_firmament_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid_firmament_pane_t2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits blid_firmament_pane_t3_ParamLimits(TInt aVariety)		{ return (*(Tblid_firmament_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid_firmament_pane_t3_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits blid_firmament_pane_t4_ParamLimits(TInt aVariety)		{ return (*(Tblid_firmament_pane_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid_firmament_pane_t4_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits blid_firmament_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tblid_firmament_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid_firmament_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknLayoutScalableParameterLimits blid_sat_info_pane_ParamLimits(TInt aVariety)		{ return (*(Tblid_sat_info_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid_sat_info_pane_ParamLimits)))(aVariety); }

// LAF Table : main_pane
inline TAknLayoutScalableParameterLimits main_cam_set_pane_ParamLimits(TInt aVariety)		{ return (*(Tmain_cam_set_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_cam_set_pane_ParamLimits)))(aVariety); }

// LAF Table : popup_imed_trans_window
inline TAknLayoutScalableParameterLimits aid_size_cell_colour_35_ParamLimits(TInt aVariety)		{ return (*(Taid_size_cell_colour_35_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_colour_35_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits aid_size_cell_colour_112_ParamLimits(TInt aVariety)		{ return (*(Taid_size_cell_colour_112_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_colour_112_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits aid_size_cell_effect_ParamLimits(TInt aVariety)		{ return (*(Taid_size_cell_effect_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_effect_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits bg_tb_trans_pane_cp02_ParamLimits(TInt aVariety)		{ return (*(Tbg_tb_trans_pane_cp02_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_tb_trans_pane_cp02_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits heading_imed_pane_ParamLimits(TInt aVariety)		{ return (*(Theading_imed_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_imed_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits listscroll_imed_pane_ParamLimits(TInt aVariety)		{ return (*(Tlistscroll_imed_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_imed_pane_ParamLimits)))(aVariety); }

// LAF Table : popup_call2_audio_first_window
inline TAknLayoutScalableParameterLimits popup_call2_audio_first_window_g5_ParamLimits(TInt aVariety)		{ return (*(Tpopup_call2_audio_first_window_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_first_window_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_call2_audio_first_window_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_call2_audio_first_window_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_call2_audio_first_window_g5)))(aVariety, aCol, aRow); }

// LAF Table : main_image3_pane
inline TAknLayoutScalableParameterLimits aid_size_touch_image3_arrow_left_ParamLimits(TInt aVariety)		{ return (*(Taid_size_touch_image3_arrow_left_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_touch_image3_arrow_left_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_size_touch_image3_arrow_left(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_touch_image3_arrow_left_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_touch_image3_arrow_left)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits aid_size_touch_image3_arrow_right_ParamLimits(TInt aVariety)		{ return (*(Taid_size_touch_image3_arrow_right_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_touch_image3_arrow_right_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_size_touch_image3_arrow_right(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_touch_image3_arrow_right_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_touch_image3_arrow_right)))(aVariety, aCol, aRow); }

// LAF Table : vid4_progress_pane
inline TAknTextComponentLayout vid4_progress_pane_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvid4_progress_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vid4_progress_pane_t3)))(aVariety, aCol, aRow); }

// LAF Table : main_hwr_training_pane
inline TAknLayoutScalableParameterLimits main_hwr_training_symbol_option_pane_ParamLimits(TInt aVariety)		{ return (*(Tmain_hwr_training_symbol_option_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_hwr_training_symbol_option_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_hwr_training_symbol_option_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_hwr_training_symbol_option_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_hwr_training_symbol_option_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_hwr_training_preview_window_ParamLimits(TInt aVariety)		{ return (*(Tpopup_hwr_training_preview_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_hwr_training_preview_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_hwr_training_preview_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_hwr_training_preview_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_hwr_training_preview_window)))(aVariety, aCol, aRow); }

// LAF Table : hwr_training_navi_pane
inline TAknLayoutScalableParameterLimits hwr_training_navi_pane_g5_ParamLimits(TInt aVariety)		{ return (*(Thwr_training_navi_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_navi_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout hwr_training_navi_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Thwr_training_navi_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_hwr_training_navi_pane_g5)))(aVariety, aCol, aRow); }

// LAF Table : field_vitu2_entry_pane
inline TAknWindowComponentLayout popup_char_count_window(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_char_count_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_char_count_window)))(aVariety, aCol, aRow); }

// LAF Table : popup_vitu2_match_list_window
inline TAknLayoutScalableParameterLimits bg_popup_sub_pane_cp20_ParamLimits(TInt aVariety)		{ return (*(Tbg_popup_sub_pane_cp20_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp20_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits list_vitu2_match_list_pane_ParamLimits(TInt aVariety)		{ return (*(Tlist_vitu2_match_list_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_vitu2_match_list_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits vitu2_page_scroll_pane_ParamLimits(TInt aVariety)		{ return (*(Tvitu2_page_scroll_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vitu2_page_scroll_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout vitu2_page_scroll_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvitu2_page_scroll_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vitu2_page_scroll_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_hwr_training_symbol_option_pane
inline TAknLayoutScalableParameterLimits list_single_hwr_training_symbol_option_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_hwr_training_symbol_option_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_hwr_training_symbol_option_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_hwr_training_symbol_option_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_hwr_training_symbol_option_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_hwr_training_symbol_option_pane)))(aVariety, aCol, aRow); }

// LAF Table : list_single_hwr_training_symbol_option_pane
inline TAknWindowComponentLayout list_single_hwr_training_symbol_option_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_hwr_training_symbol_option_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_hwr_training_symbol_option_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout list_single_hwr_training_symbol_option_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_hwr_training_symbol_option_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_hwr_training_symbol_option_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : vitu2_page_scroll_pane
inline TAknWindowComponentLayout bg_button_pane_cp023(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_cp023_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp023)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_button_pane_cp024(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_cp024_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp024)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vitu2_page_scroll_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvitu2_page_scroll_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vitu2_page_scroll_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vitu2_page_scroll_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvitu2_page_scroll_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vitu2_page_scroll_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits vitu2_page_scroll_pane_g_Limits()		{ return (*(Tvitu2_page_scroll_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vitu2_page_scroll_pane_g_Limits)))(); }

inline TAknWindowComponentLayout vitu2_page_scroll_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvitu2_page_scroll_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vitu2_page_scroll_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout vitu2_page_scroll_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvitu2_page_scroll_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vitu2_page_scroll_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : popup_char_count_window
inline TAknWindowComponentLayout popup_char_count_window_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_char_count_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_char_count_window_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_char_count_window_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_char_count_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_char_count_window_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_char_count_window_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_char_count_window_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_char_count_window_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_char_count_window_g_Limits()		{ return (*(Tpopup_char_count_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_char_count_window_g_Limits)))(); }

inline TAknWindowComponentLayout popup_char_count_window_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_char_count_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_char_count_window_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_char_count_window_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_char_count_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_char_count_window_t1)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_vded2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_vded2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vded2_pane)))(aVariety, aCol, aRow); }

// LAF Table : popup_imed_adjust2_window
inline TAknWindowComponentLayout aid_size_cell_imed_line(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_imed_line_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_imed_line)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_imed_line_width_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_imed_line_width_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_imed_line_width_pane)))(aVariety, aCol, aRow); }

// LAF Table : vid4_indicators_pane
inline TAknWindowComponentLayout vid4_indicators_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvid4_indicators_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vid4_indicators_pane_g4)))(aVariety, aCol, aRow); }

// LAF Table : grid_imed_line_width_pane
inline TAknLayoutScalableParameterLimits cell_imed_line_width_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_imed_line_width_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_imed_line_width_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_imed_line_width_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_imed_line_width_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_imed_line_width_pane)))(aVariety, aCol, aRow); }

// LAF Table : cell_imed_line_width_pane
inline TAknWindowComponentLayout cell_imed_line_width_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_imed_line_width_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_imed_line_width_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_imed_line_width_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_imed_line_width_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_imed_line_width_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_imed_line_width_pane_g_Limits()		{ return (*(Tcell_imed_line_width_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_imed_line_width_pane_g_Limits)))(); }

inline TAknWindowComponentLayout cell_imed_line_width_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_imed_line_width_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_imed_line_width_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_vded2_pane
inline TAknLayoutScalableParameterLimits main_vded2_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tmain_vded2_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vded2_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_vded2_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_vded2_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vded2_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_vded2_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Tmain_vded2_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vded2_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_vded2_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_vded2_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vded2_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_vded2_pane_g_Limits()		{ return (*(Tmain_vded2_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vded2_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_vded2_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tmain_vded2_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vded2_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout main_vded2_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_vded2_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_vded2_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits vded2_slider_pane_ParamLimits(TInt aVariety)		{ return (*(Tvded2_slider_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded2_slider_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout vded2_slider_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvded2_slider_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded2_slider_pane)))(aVariety, aCol, aRow); }

// LAF Table : vded2_slider_pane
inline TAknWindowComponentLayout aid_size_touch_vded2_end(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_touch_vded2_end_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_touch_vded2_end)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout aid_size_touch_vded2_playhead(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_touch_vded2_playhead_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_touch_vded2_playhead)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout aid_size_touch_vded2_start(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_touch_vded2_start_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_touch_vded2_start)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vded2_slider_bg_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvded2_slider_bg_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded2_slider_bg_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vded2_slider_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvded2_slider_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded2_slider_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vded2_slider_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvded2_slider_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded2_slider_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vded2_slider_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvded2_slider_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded2_slider_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits vded2_slider_pane_g_Limits()		{ return (*(Tvded2_slider_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded2_slider_pane_g_Limits)))(); }

inline TAknWindowComponentLayout vded2_slider_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvded2_slider_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded2_slider_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : vded2_slider_bg_pane
inline TAknWindowComponentLayout vded2_slider_bg_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvded2_slider_bg_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded2_slider_bg_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vded2_slider_bg_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvded2_slider_bg_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded2_slider_bg_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout vded2_slider_bg_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvded2_slider_bg_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded2_slider_bg_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits vded2_slider_bg_pane_g_Limits()		{ return (*(Tvded2_slider_bg_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded2_slider_bg_pane_g_Limits)))(); }

inline TAknWindowComponentLayout vded2_slider_bg_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvded2_slider_bg_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_vded2_slider_bg_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_postcard_pane
inline TAknLayoutScalableParameterLimits aid_postcard_touch_down_pane_ParamLimits(TInt aVariety)		{ return (*(Taid_postcard_touch_down_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_postcard_touch_down_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_postcard_touch_down_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_postcard_touch_down_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_postcard_touch_down_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits aid_postcard_touch_up_pane_ParamLimits(TInt aVariety)		{ return (*(Taid_postcard_touch_up_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_postcard_touch_up_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_postcard_touch_up_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_postcard_touch_up_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_postcard_touch_up_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_blid2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_blid2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_blid2_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_blid2_search_window(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_blid2_search_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_blid2_search_window)))(aVariety, aCol, aRow); }

// LAF Table : main_blid2_pane
inline TAknWindowComponentLayout blid2_gps_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid2_gps_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_gps_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout blid2_navig_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid2_navig_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_navig_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout blid2_search_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid2_search_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_search_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout blid2_tripm_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid2_tripm_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_tripm_pane)))(aVariety, aCol, aRow); }

// LAF Table : blid2_search_pane
inline TAknLayoutScalableParameterLimits blid2_search_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tblid2_search_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_search_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout blid2_search_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid2_search_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_search_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits blid2_search_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tblid2_search_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_search_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout blid2_search_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid2_search_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_search_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : blid2_gps_pane
inline TAknLayoutScalableParameterLimits aid_size_cell_blid2_gps_ParamLimits(TInt aVariety)		{ return (*(Taid_size_cell_blid2_gps_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_blid2_gps_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_size_cell_blid2_gps(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_blid2_gps_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_blid2_gps)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits blid2_gps_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tblid2_gps_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_gps_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout blid2_gps_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid2_gps_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_gps_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_blid2_satellite_pane_ParamLimits(TInt aVariety)		{ return (*(Tgrid_blid2_satellite_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_blid2_satellite_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_blid2_satellite_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_blid2_satellite_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_blid2_satellite_pane)))(aVariety, aCol, aRow); }

// LAF Table : blid2_navig_pane
inline TAknLayoutScalableParameterLimits blid2_navig_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tblid2_navig_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_navig_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout blid2_navig_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid2_navig_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_navig_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits blid2_navig_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tblid2_navig_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_navig_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout blid2_navig_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid2_navig_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_navig_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits blid2_navig_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tblid2_navig_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_navig_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout blid2_navig_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid2_navig_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_navig_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits blid2_navig_pane_t_Limits()		{ return (*(Tblid2_navig_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_navig_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits blid2_navig_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tblid2_navig_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_navig_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout blid2_navig_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid2_navig_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_navig_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits blid2_navig_ring_pane_ParamLimits(TInt aVariety)		{ return (*(Tblid2_navig_ring_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_navig_ring_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout blid2_navig_ring_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid2_navig_ring_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_navig_ring_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits blid2_speed_pane_ParamLimits(TInt aVariety)		{ return (*(Tblid2_speed_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_speed_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout blid2_speed_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid2_speed_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_speed_pane)))(aVariety, aCol, aRow); }

// LAF Table : blid2_tripm_pane
inline TAknLayoutScalableParameterLimits blid2_tripm_pane_g1_ParamLimits(TInt aVariety)		{ return (*(Tblid2_tripm_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_tripm_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout blid2_tripm_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid2_tripm_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_tripm_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits blid2_tripm_pane_g2_ParamLimits(TInt aVariety)		{ return (*(Tblid2_tripm_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_tripm_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout blid2_tripm_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid2_tripm_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_tripm_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits blid2_tripm_pane_g3_ParamLimits(TInt aVariety)		{ return (*(Tblid2_tripm_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_tripm_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout blid2_tripm_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid2_tripm_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_tripm_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits blid2_tripm_pane_g4_ParamLimits(TInt aVariety)		{ return (*(Tblid2_tripm_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_tripm_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout blid2_tripm_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid2_tripm_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_tripm_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits blid2_tripm_pane_g5_ParamLimits(TInt aVariety)		{ return (*(Tblid2_tripm_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_tripm_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout blid2_tripm_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid2_tripm_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_tripm_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits blid2_tripm_pane_g_Limits()		{ return (*(Tblid2_tripm_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_tripm_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits blid2_tripm_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tblid2_tripm_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_tripm_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout blid2_tripm_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid2_tripm_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_tripm_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits blid2_tripm_pane_t1_ParamLimits(TInt aVariety)		{ return (*(Tblid2_tripm_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_tripm_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout blid2_tripm_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid2_tripm_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_tripm_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits blid2_tripm_pane_t2_ParamLimits(TInt aVariety)		{ return (*(Tblid2_tripm_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_tripm_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout blid2_tripm_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid2_tripm_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_tripm_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits blid2_tripm_pane_t3_ParamLimits(TInt aVariety)		{ return (*(Tblid2_tripm_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_tripm_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout blid2_tripm_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid2_tripm_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_tripm_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits blid2_tripm_pane_t_Limits()		{ return (*(Tblid2_tripm_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_tripm_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits blid2_tripm_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety)		{ return (*(Tblid2_tripm_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_tripm_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout blid2_tripm_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid2_tripm_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_tripm_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : grid_blid2_satellite_pane
inline TAknLayoutScalableParameterLimits cell_blid2_satellite_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_blid2_satellite_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_blid2_satellite_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_blid2_satellite_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_blid2_satellite_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_blid2_satellite_pane)))(aVariety, aCol, aRow); }

// LAF Table : cell_blid2_satellite_pane
inline TAknWindowComponentLayout cell_blid2_satellite_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_blid2_satellite_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_blid2_satellite_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cell_blid2_satellite_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_blid2_satellite_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_blid2_satellite_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : blid2_speed_pane
inline TAknWindowComponentLayout blid2_speed_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tblid2_speed_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_blid2_speed_pane_g1)))(aVar