/*
* Copyright (c) 2002 - 2007 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  test funtions for graphic_configuration_api
*
*/



#ifndef C_TESTDOMGRAPHICCFG_H
#define C_TESTDOMGRAPHICCFG_H

//  INCLUDES
#include <stiflogger.h>
#include <testscripterinternal.h>
#include <stiftestmodule.h>
#include <testclassassert.h>

// MACROS
#define TEST_CLASS_VERSION_MAJOR 0
#define TEST_CLASS_VERSION_MINOR 0
#define TEST_CLASS_VERSION_BUILD 0

// Logging path
_LIT( KtestdomgraphiccfgLogPath, "\\logs\\testframework\\testdomgraphiccfg\\" ); 
// Log file
_LIT( KtestdomgraphiccfgLogFile, "testdomgraphiccfg.txt" ); 
_LIT( KtestdomgraphiccfgLogFileWithTitle, "testdomgraphiccfg_[%S].txt" );

/**
*  CTestDomGraphicCfg test class for STIF Test Framework TestScripter.
*  @since S60 5.0
*/
NONSHARABLE_CLASS( CTestDomGraphicCfg ) : public CScriptBase
    {
public:  // Constructors and destructor

    /**
    * Two-phased constructor.
    */
    static CTestDomGraphicCfg* NewL( CTestModuleIf& aTestModuleIf );

    /**
    * Destructor.
    */
    virtual ~CTestDomGraphicCfg();

public: // Functions from base classes

    /**
    * From CScriptBase Runs a script line.
    * @since S60 5.0
    * @param aItem Script line containing method name and parameters
    * @return Symbian OS error code
    */
    virtual TInt RunMethodL( CStifItemParser& aItem );

private:

    /**
    * C++ default constructor.
    */
    CTestDomGraphicCfg( CTestModuleIf& aTestModuleIf );

    /**
    * By default Symbian 2nd phase constructor is private.
    */
    void ConstructL();
    
    /**
     * Method used to log version of test class
     */
    void SendTestClassVersion();

private: // [TestMethods]
    /**
    * TestAICPreferredDisplayMode tests PreferredDisplayMode
    * of AknIconConfig in akniconconfig.h.
    * @since S60 5.0
    * @param aItem is not used.
    * @return Symbian OS error code.
    */
    virtual TInt TestAICPreferredDisplayMode( CStifItemParser& aItem );

    /**
    * TestAICCompressIfPreferredL tests CompressIfPreferred
    * of AknIconConfig in akniconconfig.h.
    * @since S60 5.0
    * @param aItem is not used.
    * @return Symbian OS error code.
    */
    virtual TInt TestAICCompressIfPreferredL( CStifItemParser& aItem );

    /**
    * TestAICCompressIfPreferredWithMaskL tests CompressIfPreferred
    * of AknIconConfig in akniconconfig.h.
    * @since S60 5.0
    * @param aItem is not used.
    * @return Symbian OS error code.
    */
    virtual TInt TestAICCompressIfPreferredWithMaskL( CStifItemParser& aItem );

    /**
    * TestAICEnableAknIconSrvCache tests EnableAknIconSrvCache
    * of AknIconConfig in akniconconfig.h.
    * @since S60 5.0
    * @param aItem is not used.
    * @return Symbian OS error code.
    */
    virtual TInt TestAICEnableAknIconSrvCache( CStifItemParser& aItem );

private:    // Data

    /**
     * ScreenSaver Property
     */
    TInt iOldScreenSaverProperty;
    
    };

#endif      // C_TESTDOMGRAPHICCFG_H

// End of File
