/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/

// It contains the client API.
// It should not be modified manually.

#ifndef AKNLAYOUTSCALABLE_AVKON_CDL
#define AKNLAYOUTSCALABLE_AVKON_CDL

#include <CdlEngine.h>
#include <aknlayoutscalable_avkon.cdl.common.h>

namespace AknLayoutScalable_Avkon
{

class CInstance;

// Standard interface functions 
inline void LoadCustomisationL(const TCdlRef& aRef)                          { CdlEngine::LoadCustomisationL(aRef); }
inline void LoadCustomisationL(const TDesC& aLibName, TInt aInstId)          { TCdlRef ref = { aInstId, { KCdlInterfaceUidValue }, &aLibName }; LoadCustomisationL(ref); }
inline void RequireCustomisationL()                                          { CdlEngine::RequireCustomisationL(&KCdlInterface); }
inline TBool IsCustomisationStarted()                                        { return CdlEngine::IsCustomisationStarted(&KCdlInterface); }
inline const CInstance& CustomisationInstance()                              { return (const CInstance&)(CdlEngine::CustomisationInstance(KCdlInterfaceUid)); }
inline void SetCustomisationChangeObserverL(MCdlChangeObserver* aObserver)   { CdlEngine::SetCustomisationChangeObserverL(aObserver, KCdlInterfaceUid); }

inline const TCdlRef& LastAccessedRef()                                      { return CdlEngine::LastAccessedRef(KCdlInterfaceUid); }
inline void FileNameRelativeToLastAccessedInstance(TFileName& aFileName)     { CdlEngine::FileNameRelativeToLastAccessedInstance(KCdlInterfaceUid, aFileName); }


// CDL API functions, as defined in aknlayoutscalable_avkon.cdl

// LAF Table : Screen Contents
inline TAknWindowComponentLayout Screen(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(TScreen_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_Screen)))(aVariety, aCol, aRow); }

// LAF Table : Screen
inline TAknLayoutScalableParameterLimits application_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tapplication_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_application_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout application_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tapplication_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_application_window)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout screen_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscreen_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_screen_g1)))(aVariety, aCol, aRow); }

// LAF Table : application_window
inline TAknLayoutScalableParameterLimits area_bottom_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tarea_bottom_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_bottom_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout area_bottom_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tarea_bottom_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_bottom_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits area_top_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tarea_top_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_top_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout area_top_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tarea_top_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_area_top_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout misc_graphics(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmisc_graphics_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_misc_graphics)))(aVariety, aCol, aRow); }

// LAF Table : status_pane
inline TAknLayoutScalableParameterLimits battery_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tbattery_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_battery_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout battery_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbattery_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_battery_pane)))(aVariety, aCol, aRow); }

// LAF Table : bg_status_flat_pane
inline TAknWindowComponentLayout bg_status_flat_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_status_flat_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_status_flat_pane_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_status_flat_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_status_flat_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_status_flat_pane_g9)))(aVariety, aCol, aRow); }

// LAF Table : status_pane
inline TAknLayoutScalableParameterLimits context_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcontext_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_context_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout context_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontext_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_context_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits navi_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tnavi_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout navi_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits signal_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tsignal_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_signal_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout signal_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsignal_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_signal_pane)))(aVariety, aCol, aRow); }

// LAF Table : bg_status_flat_pane
inline TAknLayoutScalableTableLimits bg_status_flat_pane_g_Limits()		{ return (*(Tbg_status_flat_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_status_flat_pane_g_Limits)))(); }

inline TAknWindowComponentLayout bg_status_flat_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_status_flat_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_status_flat_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : status_pane
inline TAknLayoutScalableParameterLimits status_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tstatus_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout status_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits status_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tstatus_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout status_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits status_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tstatus_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout status_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits status_pane_g_Limits()		{ return (*(Tstatus_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits status_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tstatus_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout status_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits title_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Ttitle_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout title_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttitle_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits uni_indicator_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tuni_indicator_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_uni_indicator_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout uni_indicator_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tuni_indicator_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_uni_indicator_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknLayoutScalableParameterLimits bg_list_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_list_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_list_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_list_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_list_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_list_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout find_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfind_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits listscroll_app_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlistscroll_app_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_app_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout listscroll_app_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_app_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_app_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout listscroll_form_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_form_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_form_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits listscroll_gen_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlistscroll_gen_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_gen_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout listscroll_gen_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_gen_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_gen_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout listscroll_set_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_set_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_set_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_idle_act_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_idle_act_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_idle_act_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_idle_trad_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_idle_trad_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_idle_trad_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_list_empty_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_list_empty_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_list_empty_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout main_midp_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_midp_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_midp_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_ai_message_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_ai_message_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_ai_message_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_ai_message_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_ai_message_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_ai_message_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_fep_china_uni_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_fep_china_uni_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fep_china_uni_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_fep_china_uni_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_fep_china_uni_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fep_china_uni_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_fep_japan_candidate_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_fep_japan_candidate_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fep_japan_candidate_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_fep_japan_candidate_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_fep_japan_candidate_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fep_japan_candidate_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_fep_japan_predictive_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_fep_japan_predictive_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fep_japan_predictive_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_fep_japan_predictive_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_fep_japan_predictive_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fep_japan_predictive_window)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_find_window(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_find_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_find_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_grid_graphic_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_grid_graphic_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_grid_graphic_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_grid_graphic_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_grid_graphic_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_grid_graphic_window)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_large_graphic_colour_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_large_graphic_colour_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_large_graphic_colour_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_menu_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_menu_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_menu_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_menu_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_menu_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_menu_window)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_note_image_window(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_image_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_image_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_note_wait_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_note_wait_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_wait_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_note_wait_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_wait_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_wait_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_note_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_note_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_note_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_query_code_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_query_code_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_code_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_query_code_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_query_code_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_code_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_query_data_code_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_query_data_code_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_data_code_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_query_data_code_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_query_data_code_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_data_code_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_query_data_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_query_data_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_data_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_query_data_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_query_data_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_data_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_query_sat_info_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_query_sat_info_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_sat_info_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_query_sat_info_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_query_sat_info_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_sat_info_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_snote_single_graphic_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_snote_single_graphic_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_graphic_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_snote_single_graphic_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_snote_single_graphic_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_graphic_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_snote_single_text_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_snote_single_text_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_text_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_snote_single_text_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_snote_single_text_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_text_window)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_sub_window_general(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_sub_window_general_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_sub_window_general)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_window_general_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_window_general_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_window_general_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_window_general(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_window_general_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_window_general)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout power_save_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpower_save_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_power_save_pane)))(aVariety, aCol, aRow); }

// LAF Table : control_pane
inline TAknLayoutScalableParameterLimits control_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcontrol_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout control_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits control_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tcontrol_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout control_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits control_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tcontrol_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout control_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits control_pane_g_Limits()		{ return (*(Tcontrol_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits control_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tcontrol_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout control_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits control_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcontrol_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout control_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits control_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tcontrol_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout control_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits control_pane_t_Limits()		{ return (*(Tcontrol_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits control_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tcontrol_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout control_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : status_small_pane
inline TAknWindowComponentLayout navi_navi_volume_pane_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_navi_volume_pane_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_volume_pane_cp1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout status_small_icon_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_small_icon_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_icon_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits status_small_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tstatus_small_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout status_small_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_small_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits status_small_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tstatus_small_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout status_small_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_small_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits status_small_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tstatus_small_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout status_small_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_small_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits status_small_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tstatus_small_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout status_small_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_small_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits status_small_pane_g5_ParamLimits(TInt aVariety = 0)		{ return (*(Tstatus_small_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout status_small_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_small_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits status_small_pane_g6_ParamLimits(TInt aVariety = 0)		{ return (*(Tstatus_small_pane_g6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_g6_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout status_small_pane_g6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_small_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_g6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits status_small_pane_g_Limits()		{ return (*(Tstatus_small_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits status_small_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tstatus_small_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout status_small_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_small_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout status_small_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_small_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits status_small_wait_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tstatus_small_wait_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_wait_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout status_small_wait_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_small_wait_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_wait_pane)))(aVariety, aCol, aRow); }

// LAF Table : signal_pane
inline TAknLayoutScalableParameterLimits aid_levels_signal_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_levels_signal_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_levels_signal_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_levels_signal(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_levels_signal_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_levels_signal)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits signal_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tsignal_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_signal_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout signal_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsignal_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_signal_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits signal_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tsignal_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_signal_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout signal_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsignal_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_signal_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits signal_pane_g_Limits()		{ return (*(Tsignal_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_signal_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits signal_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tsignal_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_signal_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout signal_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsignal_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_signal_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : context_pane
inline TAknWindowComponentLayout context_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontext_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_context_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : title_pane
inline TAknWindowComponentLayout title_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttitle_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout title_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttitle_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout title_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttitle_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout title_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttitle_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits title_pane_t_Limits()		{ return (*(Ttitle_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_t_Limits)))(); }

inline TAknTextComponentLayout title_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttitle_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : battery_pane
inline TAknLayoutScalableParameterLimits aid_levels_battery_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_levels_battery_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_levels_battery_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_levels_battery(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_levels_battery_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_levels_battery)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits battery_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tbattery_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_battery_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout battery_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbattery_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_battery_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits battery_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tbattery_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_battery_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout battery_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbattery_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_battery_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits battery_pane_g_Limits()		{ return (*(Tbattery_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_battery_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits battery_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tbattery_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_battery_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout battery_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbattery_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_battery_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : uni_indicator_pane
inline TAknWindowComponentLayout uni_indicator_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tuni_indicator_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_uni_indicator_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout uni_indicator_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tuni_indicator_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_uni_indicator_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout uni_indicator_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tuni_indicator_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_uni_indicator_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits uni_indicator_pane_g_Limits()		{ return (*(Tuni_indicator_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_uni_indicator_pane_g_Limits)))(); }

inline TAknWindowComponentLayout uni_indicator_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tuni_indicator_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_uni_indicator_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : navi_pane
inline TAknLayoutScalableParameterLimits navi_icon_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tnavi_icon_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_icon_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout navi_icon_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_icon_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_icon_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_midp_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_midp_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_midp_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_navi_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_navi_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits navi_text_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tnavi_text_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_text_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout navi_text_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_text_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_text_pane)))(aVariety, aCol, aRow); }

// LAF Table : status_small_wait_pane
inline TAknWindowComponentLayout status_small_wait_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_small_wait_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_wait_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout status_small_wait_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_small_wait_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_wait_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits status_small_wait_pane_g_Limits()		{ return (*(Tstatus_small_wait_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_wait_pane_g_Limits)))(); }

inline TAknWindowComponentLayout status_small_wait_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_small_wait_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_wait_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : navi_navi_pane
inline TAknWindowComponentLayout navi_navi_icon_text_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_navi_icon_text_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_icon_text_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits navi_navi_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tnavi_navi_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout navi_navi_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_navi_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits navi_navi_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tnavi_navi_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout navi_navi_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_navi_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits navi_navi_pane_g_Limits()		{ return (*(Tnavi_navi_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits navi_navi_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tnavi_navi_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout navi_navi_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_navi_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_navi_tabs_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_navi_tabs_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_tabs_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_navi_text_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_navi_text_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_text_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_navi_volume_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_navi_volume_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_volume_pane)))(aVariety, aCol, aRow); }

// LAF Table : navi_text_pane
inline TAknTextComponentLayout navi_text_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_text_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_text_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : navi_icon_pane
inline TAknWindowComponentLayout navi_icon_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_icon_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_icon_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : navi_navi_text_pane
inline TAknTextComponentLayout navi_navi_text_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_navi_text_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_text_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : navi_navi_volume_pane
inline TAknWindowComponentLayout navi_navi_volume_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_navi_volume_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_volume_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane)))(aVariety, aCol, aRow); }

// LAF Table : navi_navi_icon_text_pane
inline TAknWindowComponentLayout navi_navi_icon_text_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_navi_icon_text_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_icon_text_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout navi_navi_icon_text_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_navi_icon_text_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_icon_text_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : navi_navi_tabs_pane
inline TAknWindowComponentLayout navi_tabs_2_long_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_tabs_2_long_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_tabs_2_long_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_tabs_2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_tabs_2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_tabs_2_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_tabs_3_long_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_tabs_3_long_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_tabs_3_long_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_tabs_3_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_tabs_3_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_tabs_3_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_tabs_4_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_tabs_4_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_tabs_4_pane)))(aVariety, aCol, aRow); }

// LAF Table : navi_tabs_2_pane
inline TAknLayoutScalableParameterLimits tabs_2_active_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_2_active_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_active_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_2_active_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_2_active_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_active_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits tabs_2_passive_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_2_passive_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_passive_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_2_passive_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_2_passive_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_passive_pane)))(aVariety, aCol, aRow); }

// LAF Table : navi_tabs_3_pane
inline TAknLayoutScalableParameterLimits tabs_3_active_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_3_active_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_active_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_3_active_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_3_active_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_active_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits tabs_3_passive_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_3_passive_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_passive_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_3_passive_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_3_passive_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_passive_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits tabs_3_passive_pane_cp_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_3_passive_pane_cp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_passive_pane_cp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_3_passive_pane_cp(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_3_passive_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_passive_pane_cp)))(aVariety, aCol, aRow); }

// LAF Table : navi_tabs_4_pane
inline TAknLayoutScalableParameterLimits tabs_4_active_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_4_active_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_active_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_4_active_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_4_active_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_active_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits tabs_4_passive_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_4_passive_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_passive_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_4_passive_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_4_passive_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_passive_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits tabs_4_passive_pane_cp_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_4_passive_pane_cp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_passive_pane_cp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_4_passive_pane_cp(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_4_passive_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_passive_pane_cp)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits tabs_4_passive_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_4_passive_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_passive_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_4_passive_pane_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_4_passive_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_passive_pane_cp2)))(aVariety, aCol, aRow); }

// LAF Table : navi_tabs_2_long_pane
inline TAknLayoutScalableParameterLimits tabs_2_long_active_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_2_long_active_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_long_active_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_2_long_active_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_2_long_active_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_long_active_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits tabs_2_long_passive_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_2_long_passive_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_long_passive_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_2_long_passive_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_2_long_passive_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_long_passive_pane)))(aVariety, aCol, aRow); }

// LAF Table : navi_tabs_3_long_pane
inline TAknLayoutScalableParameterLimits tabs_3_long_active_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_3_long_active_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_long_active_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_3_long_active_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_3_long_active_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_long_active_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits tabs_3_long_passive_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_3_long_passive_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_long_passive_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_3_long_passive_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_3_long_passive_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_long_passive_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits tabs_3_long_passive_pane_cp_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_3_long_passive_pane_cp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_long_passive_pane_cp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_3_long_passive_pane_cp(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_3_long_passive_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_long_passive_pane_cp)))(aVariety, aCol, aRow); }

// LAF Table : volume_small_pane
inline TAknWindowComponentLayout volume_small_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_g9)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small_pane_g10(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_g10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_g10)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits volume_small_pane_g_Limits()		{ return (*(Tvolume_small_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_g_Limits)))(); }

inline TAknWindowComponentLayout volume_small_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : tabs_3_active_pane
inline TAknLayoutScalableParameterLimits bg_active_tab_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_active_tab_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_active_tab_pane_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout tabs_3_active_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_3_active_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_active_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout tabs_3_active_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_3_active_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_active_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : tabs_3_passive_pane
inline TAknLayoutScalableParameterLimits bg_passive_tab_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_passive_tab_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_passive_tab_pane_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout tabs_3_passive_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_3_passive_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_passive_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout tabs_3_passive_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_3_passive_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_passive_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : tabs_4_active_pane
inline TAknLayoutScalableParameterLimits bg_active_tab_pane_cp3_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_active_tab_pane_cp3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_cp3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_active_tab_pane_cp3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_cp3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_cp3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout tabs_4_active_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_4_active_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_active_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout tabs_4_active_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_4_active_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_active_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : tabs_4_passive_pane
inline TAknLayoutScalableParameterLimits bg_passive_tab_pane_cp3_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_passive_tab_pane_cp3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_cp3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_passive_tab_pane_cp3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_cp3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_cp3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout tabs_4_1_passive_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_4_1_passive_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_1_passive_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout tabs_4_1_passive_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_4_1_passive_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_1_passive_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : set_content_pane
inline TAknWindowComponentLayout list_highlight_pane_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_set_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_set_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_set_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_set_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_set_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_set_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_pane_set_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_pane_set_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_set_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_pane_set_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_pane_set_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_set_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_pane_set_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_pane_set_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_set_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_pane_set_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_pane_set_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_set_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_pane_set_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_pane_set_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_set_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_pane_set_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_pane_set_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_set_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_pane_set_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_pane_set_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_set_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_pane_set_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_pane_set_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_set_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_pane_set_t_Limits()		{ return (*(Tmain_pane_set_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_set_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_pane_set_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmain_pane_set_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_set_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout main_pane_set_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_pane_set_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_set_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout setting_code_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_code_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_code_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout setting_slider_graphic_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_slider_graphic_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_slider_graphic_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout setting_slider_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_slider_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_slider_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout setting_text_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_text_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_text_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout setting_volume_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_volume_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_volume_pane)))(aVariety, aCol, aRow); }

// LAF Table : setting_volume_pane
inline TAknWindowComponentLayout volume_set_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_set_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_set_pane)))(aVariety, aCol, aRow); }

// LAF Table : setting_slider_pane
inline TAknWindowComponentLayout bg_set_opt_pane_cp(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_set_opt_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_set_opt_pane_cp)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout setting_slider_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_slider_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_slider_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout setting_slider_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_slider_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_slider_pane_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout setting_slider_pane_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_slider_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_slider_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits setting_slider_pane_t_Limits()		{ return (*(Tsetting_slider_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_slider_pane_t_Limits)))(); }

inline TAknTextComponentLayout setting_slider_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_slider_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_slider_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout slider_set_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_set_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_set_pane)))(aVariety, aCol, aRow); }

// LAF Table : setting_slider_graphic_pane
inline TAknWindowComponentLayout bg_set_opt_pane_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_set_opt_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_set_opt_pane_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout setting_slider_graphic_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_slider_graphic_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_slider_graphic_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout setting_slider_graphic_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_slider_graphic_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_slider_graphic_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout setting_slider_graphic_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_slider_graphic_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_slider_graphic_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits setting_slider_graphic_pane_t_Limits()		{ return (*(Tsetting_slider_graphic_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_slider_graphic_pane_t_Limits)))(); }

inline TAknTextComponentLayout setting_slider_graphic_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_slider_graphic_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_slider_graphic_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout slider_set_pane_cp(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_set_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_set_pane_cp)))(aVariety, aCol, aRow); }

// LAF Table : setting_text_pane
inline TAknWindowComponentLayout input_focus_pane_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_set_text_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_set_text_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_set_text_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout setting_text_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_text_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_text_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : setting_code_pane
inline TAknWindowComponentLayout input_focus_pane_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout setting_code_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_code_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_code_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout setting_code_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_code_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_code_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : list_set_text_pane
inline TAknLayoutScalableParameterLimits set_text_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tset_text_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_text_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout set_text_pane_t1(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tset_text_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_text_pane_t1)))(aRow, aVariety, aCol); }

// LAF Table : bg_set_opt_pane_cp
inline TAknWindowComponentLayout set_opt_bg_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_opt_bg_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_opt_bg_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout set_opt_bg_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_opt_bg_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_opt_bg_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout set_opt_bg_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_opt_bg_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_opt_bg_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout set_opt_bg_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_opt_bg_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_opt_bg_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout set_opt_bg_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_opt_bg_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_opt_bg_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout set_opt_bg_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_opt_bg_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_opt_bg_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout set_opt_bg_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_opt_bg_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_opt_bg_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout set_opt_bg_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_opt_bg_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_opt_bg_pane_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout set_opt_bg_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_opt_bg_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_opt_bg_pane_g9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits set_opt_bg_pane_g_Limits()		{ return (*(Tset_opt_bg_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_opt_bg_pane_g_Limits)))(); }

inline TAknWindowComponentLayout set_opt_bg_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_opt_bg_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_opt_bg_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : slider_set_pane
inline TAknWindowComponentLayout slider_set_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_set_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_set_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout slider_set_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_set_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_set_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits slider_set_pane_g_Limits()		{ return (*(Tslider_set_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_set_pane_g_Limits)))(); }

inline TAknWindowComponentLayout slider_set_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_set_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_set_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : volume_set_pane
inline TAknWindowComponentLayout volume_set_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_set_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_set_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_set_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_set_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_set_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_set_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_set_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_set_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_set_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_set_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_set_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_set_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_set_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_set_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_set_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_set_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_set_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_set_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_set_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_set_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_set_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_set_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_set_pane_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_set_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_set_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_set_pane_g9)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_set_pane_g10(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_set_pane_g10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_set_pane_g10)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits volume_set_pane_g_Limits()		{ return (*(Tvolume_set_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_set_pane_g_Limits)))(); }

inline TAknWindowComponentLayout volume_set_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_set_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_set_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : main_idle_trad_pane
inline TAknLayoutScalableParameterLimits indicator_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tindicator_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_indicator_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout indicator_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tindicator_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_indicator_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_idle_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_idle_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_idle_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_idle_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_idle_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_idle_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_pane_idle_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_pane_idle_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_idle_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_pane_idle_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_pane_idle_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_idle_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_clock_digital_analogue_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_clock_digital_analogue_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_digital_analogue_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_clock_digital_analogue_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_digital_analogue_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_digital_analogue_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits soft_indicator_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tsoft_indicator_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_soft_indicator_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout soft_indicator_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsoft_indicator_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_soft_indicator_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits wallpaper_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Twallpaper_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wallpaper_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout wallpaper_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twallpaper_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wallpaper_pane)))(aVariety, aCol, aRow); }

// LAF Table : wallpaper_pane
inline TAknWindowComponentLayout wallpaper_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twallpaper_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wallpaper_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : indicator_pane
inline TAknLayoutScalableParameterLimits indicator_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tindicator_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_indicator_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout indicator_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tindicator_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_indicator_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : navi_navi_icon_text_pane_srt
inline TAknWindowComponentLayout navi_navi_icon_text_pane_srt_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_navi_icon_text_pane_srt_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_icon_text_pane_srt_g1)))(aVariety, aCol, aRow); }

// LAF Table : soft_indicator_pane
inline TAknTextComponentLayout soft_indicator_pane_t1(TInt aRow = 0, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tsoft_indicator_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_soft_indicator_pane_t1)))(aRow, aVariety, aCol); }

// LAF Table : power_save_pane
inline TAknWindowComponentLayout aid_ps_area_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_ps_area_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_ps_area_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout aid_ps_clock_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_ps_clock_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_ps_clock_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout aid_ps_indicator_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_ps_indicator_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_ps_indicator_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits indicator_ps_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tindicator_ps_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_indicator_ps_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout indicator_ps_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tindicator_ps_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_indicator_ps_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits power_save_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpower_save_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_power_save_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout power_save_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpower_save_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_power_save_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits power_save_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpower_save_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_power_save_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout power_save_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpower_save_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_power_save_pane_g2)))(aVariety, aCol, aRow); }

// LAF Table : application_window
inline TAknWindowComponentLayout aid_navinavi_width_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_navinavi_width_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_navinavi_width_pane)))(aVariety, aCol, aRow); }

// LAF Table : power_save_pane
inline TAknLayoutScalableParameterLimits aid_ps_area_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_ps_area_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_ps_area_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableTableLimits power_save_pane_g_Limits()		{ return (*(Tpower_save_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_power_save_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits power_save_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpower_save_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_power_save_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout power_save_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpower_save_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_power_save_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits power_save_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpower_save_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_power_save_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout power_save_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpower_save_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_power_save_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits aid_ps_clock_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_ps_clock_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_ps_clock_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits aid_ps_indicator_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_ps_indicator_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_ps_indicator_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits power_save_pane_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tpower_save_pane_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_power_save_pane_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout power_save_pane_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpower_save_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_power_save_pane_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits power_save_pane_t_Limits()		{ return (*(Tpower_save_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_power_save_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits power_save_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpower_save_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_power_save_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout power_save_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpower_save_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_power_save_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits power_save_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpower_save_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_power_save_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout power_save_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpower_save_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_power_save_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits power_save_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpower_save_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_power_save_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout power_save_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpower_save_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_power_save_t2)))(aVariety, aCol, aRow); }

// LAF Table : indicator_ps_pane
inline TAknWindowComponentLayout indicator_ps_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tindicator_ps_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_indicator_ps_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : main_idle_act_pane
inline TAknLayoutScalableParameterLimits ai_gene_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tai_gene_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_gene_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout ai_gene_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai_gene_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_gene_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits ai_links_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tai_links_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_links_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout ai_links_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai_links_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_links_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits indicator_pane_cp1_ParamLimits(TInt aVariety = 0)		{ return (*(Tindicator_pane_cp1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_indicator_pane_cp1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout indicator_pane_cp1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tindicator_pane_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_indicator_pane_cp1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_pane_idle_g1_cp_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_pane_idle_g1_cp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_idle_g1_cp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_pane_idle_g1_cp(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_pane_idle_g1_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_idle_g1_cp)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_ai_links_title_window(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_ai_links_title_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_ai_links_title_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits soft_indicator_pane_cp1_ParamLimits(TInt aVariety = 0)		{ return (*(Tsoft_indicator_pane_cp1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_soft_indicator_pane_cp1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout soft_indicator_pane_cp1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsoft_indicator_pane_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_soft_indicator_pane_cp1)))(aVariety, aCol, aRow); }

// LAF Table : ai_links_pane
inline TAknWindowComponentLayout ai_links_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai_links_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_links_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_ai_links_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_ai_links_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_ai_links_pane)))(aVariety, aCol, aRow); }

// LAF Table : ai_gene_pane
inline TAknWindowComponentLayout ai_gene_pane_1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai_gene_pane_1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_gene_pane_1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout ai_gene_pane_2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai_gene_pane_2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_gene_pane_2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_highlight_pane_cp4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_cp4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp4)))(aVariety, aCol, aRow); }

// LAF Table : grid_ai_links_pane
inline TAknLayoutScalableParameterLimits cell_ai_link_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_ai_link_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_ai_link_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_ai_link_pane(TInt aCol, TInt aVariety = 0, TInt aRow = 0)		{ return (*(Tcell_ai_link_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_ai_link_pane)))(aCol, aVariety, aRow); }

// LAF Table : cell_ai_link_pane
inline TAknWindowComponentLayout cell_ai_link_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_ai_link_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_ai_link_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_ai_link_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_ai_link_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_ai_link_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_ai_link_pane_g_Limits()		{ return (*(Tcell_ai_link_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_ai_link_pane_g_Limits)))(); }

inline TAknWindowComponentLayout cell_ai_link_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_ai_link_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_ai_link_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_highlight_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_cp2)))(aVariety, aCol, aRow); }

// LAF Table : popup_ai_links_title_window
inline TAknWindowComponentLayout bg_popup_sub_pane_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_ai_links_title_window_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_ai_links_title_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_ai_links_title_window_t1)))(aVariety, aCol, aRow); }

// LAF Table : ai_gene_pane_1
inline TAknLayoutScalableParameterLimits ai_gene_pane_1_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tai_gene_pane_1_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_gene_pane_1_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout ai_gene_pane_1_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai_gene_pane_1_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_gene_pane_1_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits ai_gene_pane_1_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tai_gene_pane_1_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_gene_pane_1_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout ai_gene_pane_1_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai_gene_pane_1_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_gene_pane_1_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits ai_gene_pane_1_g_Limits()		{ return (*(Tai_gene_pane_1_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_gene_pane_1_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits ai_gene_pane_1_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tai_gene_pane_1_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_gene_pane_1_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout ai_gene_pane_1_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai_gene_pane_1_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_gene_pane_1_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits ai_gene_pane_1_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tai_gene_pane_1_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_gene_pane_1_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout ai_gene_pane_1_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai_gene_pane_1_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_gene_pane_1_t1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_ai_soft_ind_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_ai_soft_ind_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_ai_soft_ind_pane)))(aVariety, aCol, aRow); }

// LAF Table : ai_gene_pane_2
inline TAknLayoutScalableParameterLimits ai_gene_pane_2_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tai_gene_pane_2_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_gene_pane_2_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout ai_gene_pane_2_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai_gene_pane_2_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_gene_pane_2_t1)))(aVariety, aCol, aRow); }

// LAF Table : main_list_empty_pane
inline TAknLayoutScalableParameterLimits main_pane_empty_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_pane_empty_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_empty_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_pane_empty_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_pane_empty_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_empty_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_pane_empty_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_pane_empty_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_empty_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_pane_empty_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_pane_empty_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_empty_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_pane_empty_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_pane_empty_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_empty_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_pane_empty_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_pane_empty_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_empty_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_pane_empty_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_pane_empty_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_empty_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_pane_empty_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_pane_empty_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_empty_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_pane_empty_t5_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_pane_empty_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_empty_t5_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_pane_empty_t5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_pane_empty_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_empty_t5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_pane_empty_t_Limits()		{ return (*(Tmain_pane_empty_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_empty_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_pane_empty_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmain_pane_empty_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_empty_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout main_pane_empty_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_pane_empty_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_empty_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_window_general
inline TAknLayoutScalableParameterLimits bg_popup_window_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits find_popup_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tfind_popup_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_popup_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout find_popup_pane_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfind_popup_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_popup_pane_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits heading_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Theading_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout heading_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_pane)))(aVariety, aCol, aRow); }

// LAF Table : popup_sub_window_general
inline TAknWindowComponentLayout bg_popup_sub_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane)))(aVariety, aCol, aRow); }

// LAF Table : bg_popup_window_pane
inline TAknLayoutScalableParameterLimits bg_popup_window_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits bg_popup_window_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits bg_popup_window_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits bg_popup_window_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits bg_popup_window_pane_g5_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits bg_popup_window_pane_g6_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_g6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_g6_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_g6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_g6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits bg_popup_window_pane_g7_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_g7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_g7_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_g7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_g7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits bg_popup_window_pane_g8_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_g8_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_g8_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_g8(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_g8)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits bg_popup_window_pane_g9_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_g9_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_g9_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_g9(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_g9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits bg_popup_window_pane_g10_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_g10_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_g10_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_g10(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_g10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_g10)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits bg_popup_window_pane_g_Limits()		{ return (*(Tbg_popup_window_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits bg_popup_window_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : heading_pane
inline TAknLayoutScalableParameterLimits bg_popup_heading_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_heading_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_heading_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_heading_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_heading_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_heading_pane)))(aVariety, aCol, aRow); }

// LAF Table : navi_tabs_4_pane_srt
inline TAknLayoutScalableParameterLimits tabs_4_passive_pane_cp_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_4_passive_pane_cp_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_passive_pane_cp_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_4_passive_pane_cp_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_4_passive_pane_cp_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_passive_pane_cp_srt)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits tabs_4_passive_pane_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_4_passive_pane_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_passive_pane_srt_ParamLimits)))(aVariety); }

// LAF Table : heading_pane
inline TAknWindowComponentLayout heading_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_pane_g2)))(aVariety, aCol, aRow); }

// LAF Table : navi_tabs_4_pane_srt
inline TAknWindowComponentLayout tabs_4_passive_pane_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_4_passive_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_passive_pane_srt)))(aVariety, aCol, aRow); }

// LAF Table : tabs_4_passive_pane_srt
inline TAknLayoutScalableParameterLimits bg_passive_tab_pane_cp3_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_passive_tab_pane_cp3_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_cp3_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_passive_tab_pane_cp3_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_cp3_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_cp3_srt)))(aVariety, aCol, aRow); }

// LAF Table : heading_pane
inline TAknLayoutScalableParameterLimits heading_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Theading_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout heading_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits heading_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Theading_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout heading_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits heading_pane_t_Limits()		{ return (*(Theading_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits heading_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Theading_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout heading_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : bg_popup_heading_pane
inline TAknWindowComponentLayout bg_popup_heading_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_heading_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_heading_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_heading_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_heading_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_heading_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_heading_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_heading_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_heading_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_heading_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_heading_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_heading_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_heading_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_heading_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_heading_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_heading_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_heading_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_heading_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_heading_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_heading_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_heading_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_heading_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_heading_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_heading_pane_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_heading_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_heading_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_heading_pane_g9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits bg_popup_heading_pane_g_Limits()		{ return (*(Tbg_popup_heading_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_heading_pane_g_Limits)))(); }

inline TAknWindowComponentLayout bg_popup_heading_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_heading_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_heading_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : bg_popup_sub_pane
inline TAknWindowComponentLayout bg_popup_sub_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_sub_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_sub_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_sub_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_sub_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_sub_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_sub_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_sub_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_sub_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_g9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits bg_popup_sub_pane_g_Limits()		{ return (*(Tbg_popup_sub_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_g_Limits)))(); }

inline TAknWindowComponentLayout bg_popup_sub_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_note_window
inline TAknLayoutScalableParameterLimits bg_popup_window_pane_cp5_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_cp5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_cp5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_note_window_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_note_window_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_window_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_note_window_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_window_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_note_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_note_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_note_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_note_window_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_note_window_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_window_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_note_window_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_window_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_note_window_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_note_window_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_window_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_note_window_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_window_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_note_window_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_note_window_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_window_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_note_window_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_window_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_window_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_note_window_t5_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_note_window_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_window_t5_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_note_window_t5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_window_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_window_t5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_note_window_t_Limits()		{ return (*(Tpopup_note_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_window_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_note_window_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_note_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_note_window_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_window_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_note_image_window
inline TAknLayoutScalableParameterLimits bg_popup_window_pane_cp6_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_cp6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp6_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_cp6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_note_image_window_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_note_image_window_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_image_window_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_note_image_window_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_image_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_image_window_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_note_image_window_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_note_image_window_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_image_window_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_note_image_window_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_image_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_image_window_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_note_image_window_g_Limits()		{ return (*(Tpopup_note_image_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_image_window_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_note_image_window_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_note_image_window_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_image_window_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout popup_note_image_window_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_image_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_image_window_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_note_image_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_note_image_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_image_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_note_image_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_image_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_image_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_note_image_window_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_note_image_window_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_image_window_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_note_image_window_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_image_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_image_window_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_note_image_window_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_note_image_window_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_image_window_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_note_image_window_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_image_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_image_window_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_note_image_window_t_Limits()		{ return (*(Tpopup_note_image_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_image_window_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_note_image_window_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_note_image_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_image_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_note_image_window_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_image_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_image_window_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_note_wait_window
inline TAknLayoutScalableParameterLimits bg_popup_window_pane_cp7_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_cp7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp7_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_cp7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_note_wait_window_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_note_wait_window_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_wait_window_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_note_wait_window_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_wait_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_wait_window_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_note_wait_window_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_note_wait_window_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_wait_window_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_note_wait_window_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_wait_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_wait_window_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_note_wait_window_g_Limits()		{ return (*(Tpopup_note_wait_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_wait_window_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_note_wait_window_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_note_wait_window_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_wait_window_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout popup_note_wait_window_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_wait_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_wait_window_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_note_wait_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_note_wait_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_wait_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_note_wait_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_wait_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_wait_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_note_wait_window_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_note_wait_window_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_wait_window_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_note_wait_window_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_wait_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_wait_window_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_note_wait_window_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_note_wait_window_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_wait_window_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_note_wait_window_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_wait_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_wait_window_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_note_wait_window_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_note_wait_window_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_wait_window_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_note_wait_window_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_wait_window_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_wait_window_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_note_wait_window_t_Limits()		{ return (*(Tpopup_note_wait_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_wait_window_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_note_wait_window_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_note_wait_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_wait_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_note_wait_window_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_wait_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_wait_window_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits wait_bar_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Twait_bar_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_bar_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout wait_bar_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twait_bar_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_bar_pane)))(aVariety, aCol, aRow); }

// LAF Table : wait_bar_pane
inline TAknWindowComponentLayout wait_anim_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twait_anim_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_anim_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wait_border_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twait_border_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_border_pane)))(aVariety, aCol, aRow); }

// LAF Table : wait_anim_pane
inline TAknWindowComponentLayout wait_anim_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twait_anim_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_anim_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wait_anim_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twait_anim_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_anim_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits wait_anim_pane_g_Limits()		{ return (*(Twait_anim_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_anim_pane_g_Limits)))(); }

inline TAknWindowComponentLayout wait_anim_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twait_anim_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_anim_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : wait_border_pane
inline TAknWindowComponentLayout wait_border_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twait_border_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_border_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wait_border_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twait_border_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_border_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wait_border_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twait_border_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_border_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits wait_border_pane_g_Limits()		{ return (*(Twait_border_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_border_pane_g_Limits)))(); }

inline TAknWindowComponentLayout wait_border_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twait_border_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_border_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_query_data_window
inline TAknLayoutScalableParameterLimits bg_popup_window_pane_cp16_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_cp16_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp16_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_cp16(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp16_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp16)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits indicator_popup_pane_cp4_ParamLimits(TInt aVariety = 0)		{ return (*(Tindicator_popup_pane_cp4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_indicator_popup_pane_cp4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout indicator_popup_pane_cp4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tindicator_popup_pane_cp4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_indicator_popup_pane_cp4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_query_data_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_query_data_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_data_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_query_data_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_query_data_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_data_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_query_data_window_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_query_data_window_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_data_window_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_query_data_window_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_query_data_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_data_window_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_query_data_window_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_query_data_window_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_data_window_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_query_data_window_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_query_data_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_data_window_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_query_data_window_t_Limits()		{ return (*(Tpopup_query_data_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_data_window_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_query_data_window_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_query_data_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_data_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_query_data_window_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_query_data_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_data_window_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits query_popup_data_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tquery_popup_data_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_query_popup_data_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout query_popup_data_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tquery_popup_data_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_query_popup_data_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits query_popup_data_pane_cp1_ParamLimits(TInt aVariety = 0)		{ return (*(Tquery_popup_data_pane_cp1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_query_popup_data_pane_cp1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout query_popup_data_pane_cp1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tquery_popup_data_pane_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_query_popup_data_pane_cp1)))(aVariety, aCol, aRow); }

// LAF Table : popup_query_code_window
inline TAknLayoutScalableParameterLimits bg_popup_window_pane_cp10_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_cp10_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp10_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_cp10(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp10)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits indicator_popup_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tindicator_popup_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_indicator_popup_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout indicator_popup_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tindicator_popup_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_indicator_popup_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_query_code_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_query_code_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_code_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_query_code_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_query_code_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_code_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_query_code_window_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_query_code_window_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_code_window_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_query_code_window_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_query_code_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_code_window_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_query_code_window_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_query_code_window_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_code_window_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_query_code_window_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_query_code_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_code_window_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_query_code_window_t_Limits()		{ return (*(Tpopup_query_code_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_code_window_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_query_code_window_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_query_code_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_code_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_query_code_window_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_query_code_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_code_window_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits query_popup_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tquery_popup_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_query_popup_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout query_popup_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tquery_popup_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_query_popup_pane)))(aVariety, aCol, aRow); }

// LAF Table : popup_query_data_code_window
inline TAknLayoutScalableParameterLimits bg_popup_window_pane_cp15_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_cp15_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp15_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_cp15(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp15_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp15)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits indicator_popup_pane_cp1_ParamLimits(TInt aVariety = 0)		{ return (*(Tindicator_popup_pane_cp1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_indicator_popup_pane_cp1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout indicator_popup_pane_cp1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tindicator_popup_pane_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_indicator_popup_pane_cp1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits indicator_popup_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tindicator_popup_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_indicator_popup_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout indicator_popup_pane_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tindicator_popup_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_indicator_popup_pane_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_query_data_code_window_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_query_data_code_window_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_data_code_window_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_query_data_code_window_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_query_data_code_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_data_code_window_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_query_data_code_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_query_data_code_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_data_code_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_query_data_code_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_query_data_code_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_data_code_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_query_data_code_window_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_query_data_code_window_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_data_code_window_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_query_data_code_window_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_query_data_code_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_data_code_window_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_query_data_code_window_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_query_data_code_window_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_data_code_window_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_query_data_code_window_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_query_data_code_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_data_code_window_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_query_data_code_window_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_query_data_code_window_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_data_code_window_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_query_data_code_window_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_query_data_code_window_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_data_code_window_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_query_data_code_window_t_Limits()		{ return (*(Tpopup_query_data_code_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_data_code_window_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_query_data_code_window_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_query_data_code_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_data_code_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_query_data_code_window_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_query_data_code_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_query_data_code_window_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_single_midp_graphic_pane
inline TAknWindowComponentLayout list_single_midp_graphic_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_midp_graphic_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_midp_graphic_pane_g3)))(aVariety, aCol, aRow); }

// LAF Table : popup_query_data_code_window
inline TAknLayoutScalableParameterLimits query_popup_data_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tquery_popup_data_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_query_popup_data_pane_cp2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits query_popup_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tquery_popup_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_query_popup_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout query_popup_pane_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tquery_popup_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_query_popup_pane_cp2)))(aVariety, aCol, aRow); }

// LAF Table : popup_query_sat_info_window
inline TAknWindowComponentLayout bg_popup_window_pane_cp11(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp11_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp11)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout heading_pane_cp5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_pane_cp5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_pane_cp5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout listscroll_popup_info_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_popup_info_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_info_pane)))(aVariety, aCol, aRow); }

// LAF Table : query_popup_pane
inline TAknWindowComponentLayout input_focus_pane_cp3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp3)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout query_popup_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tquery_popup_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_query_popup_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_popup_info_pane
inline TAknLayoutScalableParameterLimits list_popup_info_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_popup_info_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_popup_info_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_popup_info_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_popup_info_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_popup_info_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout listscroll_popup_info_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_popup_info_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_info_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp7)))(aVariety, aCol, aRow); }

// LAF Table : list_popup_info_pane
inline TAknLayoutScalableParameterLimits popup_info_list_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_info_list_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_info_list_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_info_list_pane_t1(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tpopup_info_list_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_info_list_pane_t1)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits popup_info_list_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_info_list_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_info_list_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_info_list_pane_t2(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tpopup_info_list_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_info_list_pane_t2)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableTableLimits popup_info_list_pane_t_Limits()		{ return (*(Tpopup_info_list_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_info_list_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_info_list_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_info_list_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_info_list_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_info_list_pane_t(TInt aLineIndex, TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tpopup_info_list_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_info_list_pane_t)))(aLineIndex, aRow, aVariety, aCol); }

// LAF Table : popup_find_window
inline TAknWindowComponentLayout bg_popup_window_pane_cp12(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp12_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp12)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout find_popup_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfind_popup_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_popup_pane)))(aVariety, aCol, aRow); }

// LAF Table : popup_grid_graphic_window
inline TAknWindowComponentLayout bg_popup_window_pane_cp3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout heading_pane_cp3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_pane_cp3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_pane_cp3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout listscroll_popup_graphic_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_popup_graphic_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_graphic_pane)))(aVariety, aCol, aRow); }

// LAF Table : popup_large_graphic_colour_window
inline TAknWindowComponentLayout bg_popup_window_pane_cp4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout heading_pane_cp4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_pane_cp4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_pane_cp4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout listscroll_popup_colour_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_popup_colour_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_colour_pane)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_popup_colour_pane
inline TAknLayoutScalableParameterLimits cell_large_graphic_colour_none_popup_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_large_graphic_colour_none_popup_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_large_graphic_colour_none_popup_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_large_graphic_colour_none_popup_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_large_graphic_colour_none_popup_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_large_graphic_colour_none_popup_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_large_graphic_colour_popup_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_large_graphic_colour_popup_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_large_graphic_colour_popup_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_large_graphic_colour_popup_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_large_graphic_colour_popup_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_large_graphic_colour_popup_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits listscroll_popup_colour_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlistscroll_popup_colour_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_colour_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout listscroll_popup_colour_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_popup_colour_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_colour_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits listscroll_popup_colour_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlistscroll_popup_colour_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_colour_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout listscroll_popup_colour_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_popup_colour_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_colour_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits listscroll_popup_colour_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlistscroll_popup_colour_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_colour_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout listscroll_popup_colour_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_popup_colour_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_colour_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits listscroll_popup_colour_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tlistscroll_popup_colour_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_colour_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout listscroll_popup_colour_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_popup_colour_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_colour_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits listscroll_popup_colour_pane_g_Limits()		{ return (*(Tlistscroll_popup_colour_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_colour_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits listscroll_popup_colour_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlistscroll_popup_colour_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_colour_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout listscroll_popup_colour_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_popup_colour_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_colour_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits scroll_pane_cp6_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_pane_cp6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp6_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout scroll_pane_cp6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp6)))(aVariety, aCol, aRow); }

// LAF Table : grid_large_graphic_colour_popup_pane
inline TAknLayoutScalableParameterLimits cell_large_graphic_colour_popup_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_large_graphic_colour_popup_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_large_graphic_colour_popup_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_large_graphic_colour_popup_pane(TInt aVariety, TInt aCol, TInt aRow)		{ return (*(Tcell_large_graphic_colour_popup_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_large_graphic_colour_popup_pane)))(aVariety, aCol, aRow); }

// LAF Table : cell_large_graphic_colour_none_popup_pane
inline TAknTextComponentLayout cell_large_graphic_colour_none_popup_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_large_graphic_colour_none_popup_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_large_graphic_colour_none_popup_pane_t1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_highlight_pane_cp5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_cp5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp5)))(aVariety, aCol, aRow); }

// LAF Table : cell_large_graphic_colour_popup_pane
inline TAknWindowComponentLayout cell_large_graphic_colour_popup_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_large_graphic_colour_popup_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_large_graphic_colour_popup_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_large_graphic_colour_popup_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_large_graphic_colour_popup_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_large_graphic_colour_popup_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_large_graphic_colour_popup_pane_g_Limits()		{ return (*(Tcell_large_graphic_colour_popup_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_large_graphic_colour_popup_pane_g_Limits)))(); }

inline TAknWindowComponentLayout cell_large_graphic_colour_popup_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_large_graphic_colour_popup_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_large_graphic_colour_popup_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_large_graphic_colour_popup_pane_g2_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_large_graphic_colour_popup_pane_g2_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_large_graphic_colour_popup_pane_g2_copy1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_highlight_pane_cp4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_cp4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp4)))(aVariety, aCol, aRow); }

// LAF Table : popup_snote_single_text_window
inline TAknLayoutScalableParameterLimits bg_popup_window_pane_cp8_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_cp8_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp8_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_cp8(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp8)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_snote_single_text_window_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_snote_single_text_window_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_text_window_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_snote_single_text_window_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_snote_single_text_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_text_window_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_snote_single_text_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_snote_single_text_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_text_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_snote_single_text_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_snote_single_text_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_text_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_snote_single_text_window_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_snote_single_text_window_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_text_window_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_snote_single_text_window_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_snote_single_text_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_text_window_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_snote_single_text_window_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_snote_single_text_window_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_text_window_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_snote_single_text_window_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_snote_single_text_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_text_window_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_snote_single_text_window_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_snote_single_text_window_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_text_window_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_snote_single_text_window_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_snote_single_text_window_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_text_window_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_snote_single_text_window_t5_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_snote_single_text_window_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_text_window_t5_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_snote_single_text_window_t5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_snote_single_text_window_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_text_window_t5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_snote_single_text_window_t_Limits()		{ return (*(Tpopup_snote_single_text_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_text_window_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_snote_single_text_window_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_snote_single_text_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_text_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_snote_single_text_window_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_snote_single_text_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_text_window_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_snote_single_graphic_window
inline TAknLayoutScalableParameterLimits bg_popup_window_pane_cp9_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_cp9_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp9_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_cp9(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_snote_single_graphic_window_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_snote_single_graphic_window_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_graphic_window_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_snote_single_graphic_window_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_snote_single_graphic_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_graphic_window_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_snote_single_graphic_window_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_snote_single_graphic_window_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_graphic_window_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_snote_single_graphic_window_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_snote_single_graphic_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_graphic_window_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_snote_single_graphic_window_g_Limits()		{ return (*(Tpopup_snote_single_graphic_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_graphic_window_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_snote_single_graphic_window_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_snote_single_graphic_window_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_graphic_window_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout popup_snote_single_graphic_window_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_snote_single_graphic_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_graphic_window_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_snote_single_graphic_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_snote_single_graphic_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_graphic_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_snote_single_graphic_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_snote_single_graphic_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_graphic_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_snote_single_graphic_window_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_snote_single_graphic_window_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_graphic_window_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_snote_single_graphic_window_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_snote_single_graphic_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_graphic_window_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_snote_single_graphic_window_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_snote_single_graphic_window_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_graphic_window_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_snote_single_graphic_window_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_snote_single_graphic_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_graphic_window_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_snote_single_graphic_window_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_snote_single_graphic_window_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_graphic_window_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_snote_single_graphic_window_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_snote_single_graphic_window_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_graphic_window_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_snote_single_graphic_window_t5_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_snote_single_graphic_window_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_graphic_window_t5_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_snote_single_graphic_window_t5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_snote_single_graphic_window_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_graphic_window_t5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_snote_single_graphic_window_t_Limits()		{ return (*(Tpopup_snote_single_graphic_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_graphic_window_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_snote_single_graphic_window_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_snote_single_graphic_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_graphic_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_snote_single_graphic_window_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_snote_single_graphic_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_snote_single_graphic_window_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : listscroll_popup_graphic_pane
inline TAknLayoutScalableParameterLimits grid_graphic_popup_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_graphic_popup_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_graphic_popup_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_graphic_popup_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_graphic_popup_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_graphic_popup_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits listscroll_popup_graphic_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlistscroll_popup_graphic_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_graphic_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout listscroll_popup_graphic_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_popup_graphic_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_graphic_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits listscroll_popup_graphic_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlistscroll_popup_graphic_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_graphic_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout listscroll_popup_graphic_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_popup_graphic_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_graphic_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits listscroll_popup_graphic_pane_g_Limits()		{ return (*(Tlistscroll_popup_graphic_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_graphic_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits listscroll_popup_graphic_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlistscroll_popup_graphic_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_graphic_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout listscroll_popup_graphic_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_popup_graphic_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_graphic_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp5)))(aVariety, aCol, aRow); }

// LAF Table : grid_graphic_popup_pane
inline TAknLayoutScalableParameterLimits cell_graphic_popup_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_graphic_popup_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_graphic_popup_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_graphic_popup_pane(TInt aVariety, TInt aCol, TInt aRow)		{ return (*(Tcell_graphic_popup_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_graphic_popup_pane)))(aVariety, aCol, aRow); }

// LAF Table : cell_graphic_popup_pane
inline TAknWindowComponentLayout cell_graphic_popup_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_graphic_popup_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_graphic_popup_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_graphic_popup_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_graphic_popup_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_graphic_popup_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_graphic_popup_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_graphic_popup_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_graphic_popup_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_graphic_popup_pane_g_Limits()		{ return (*(Tcell_graphic_popup_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_graphic_popup_pane_g_Limits)))(); }

inline TAknWindowComponentLayout cell_graphic_popup_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_graphic_popup_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_graphic_popup_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout cell_graphic_popup_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_graphic_popup_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_graphic_popup_pane_t2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_highlight_pane_cp3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_cp3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp3)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_gen_pane
inline TAknLayoutScalableParameterLimits list_gen_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_gen_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_gen_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_gen_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_gen_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_gen_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane)))(aVariety, aCol, aRow); }

// LAF Table : bg_list_pane
inline TAknLayoutScalableParameterLimits bg_list_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_list_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_list_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_list_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_list_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_list_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits bg_list_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_list_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_list_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_list_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_list_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_list_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits bg_list_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_list_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_list_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_list_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_list_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_list_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits bg_list_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_list_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_list_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_list_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_list_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_list_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits bg_list_pane_g5_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_list_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_list_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_list_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_list_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_list_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits bg_list_pane_g_Limits()		{ return (*(Tbg_list_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_list_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits bg_list_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tbg_list_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_list_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout bg_list_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_list_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_list_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_gen_pane
inline TAknLayoutScalableParameterLimits list_double2_graphic_large_graphic_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_large_graphic_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_large_graphic_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_graphic_large_graphic_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double2_graphic_large_graphic_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_large_graphic_pane)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_double2_graphic_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_graphic_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double2_graphic_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_double2_large_graphic_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_large_graphic_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_large_graphic_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double2_large_graphic_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_double2_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_double_graphic_heading_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_heading_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_graphic_heading_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double_graphic_heading_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_double_graphic_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_graphic_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double_graphic_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_double_heading_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_heading_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_heading_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double_heading_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_double_large_graphic_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_large_graphic_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_large_graphic_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double_large_graphic_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_double_number_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_number_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_number_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double_number_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_double_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_double_time_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_time_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_time_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double_time_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_setting_number_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_setting_number_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_setting_number_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_setting_number_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_setting_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_setting_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_setting_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_setting_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_single_2graphic_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_2graphic_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_2graphic_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_2graphic_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_heading_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_graphic_heading_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_single_graphic_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_graphic_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_single_heading_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_heading_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_heading_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_heading_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_single_large_graphic_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_large_graphic_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_large_graphic_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_large_graphic_pane(TInt aVariety, TInt aRow, TInt aCol = 0)		{ return (*(Tlist_single_large_graphic_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_large_graphic_pane)))(aVariety, aRow, aCol); }

inline TAknLayoutScalableParameterLimits list_single_number_heading_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_number_heading_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_number_heading_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_number_heading_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_single_number_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_number_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_number_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_number_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_pane)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_single_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_single_pane
inline TAknWindowComponentLayout list_highlight_pane_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_pane_g_Limits()		{ return (*(Tlist_single_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_single_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : list_single_number_pane
inline TAknLayoutScalableParameterLimits list_single_number_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_number_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_number_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_number_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_number_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_number_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_number_pane_g_Limits()		{ return (*(Tlist_single_number_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_number_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_number_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_single_number_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_number_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_number_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_number_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_number_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_number_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_number_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_number_pane_t_Limits()		{ return (*(Tlist_single_number_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_number_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_number_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_single_number_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_single_graphic_pane
inline TAknLayoutScalableParameterLimits list_single_graphic_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_graphic_pane_g_Limits()		{ return (*(Tlist_single_graphic_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_graphic_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_graphic_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_single_graphic_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_graphic_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : list_single_heading_pane
inline TAknLayoutScalableParameterLimits list_single_heading_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_heading_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_heading_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_heading_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_heading_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_heading_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_heading_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_heading_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_heading_pane_g_Limits()		{ return (*(Tlist_single_heading_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_heading_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_heading_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_single_heading_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_heading_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_heading_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_heading_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_heading_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_heading_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_heading_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_heading_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_heading_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_heading_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_heading_pane_t_Limits()		{ return (*(Tlist_single_heading_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_heading_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_heading_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_single_heading_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_heading_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_single_number_heading_pane
inline TAknLayoutScalableParameterLimits list_single_number_heading_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_number_heading_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_number_heading_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_heading_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_number_heading_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_number_heading_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_number_heading_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_heading_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_number_heading_pane_g_Limits()		{ return (*(Tlist_single_number_heading_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_number_heading_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_number_heading_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_single_number_heading_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_heading_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_number_heading_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_number_heading_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_number_heading_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_heading_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_number_heading_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_number_heading_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_number_heading_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_heading_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_number_heading_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_number_heading_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_number_heading_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_heading_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_number_heading_pane_t_Limits()		{ return (*(Tlist_single_number_heading_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_number_heading_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_number_heading_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_single_number_heading_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_heading_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_single_graphic_heading_pane
inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_heading_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_heading_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_g5_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_heading_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_graphic_heading_pane_g_Limits()		{ return (*(Tlist_single_graphic_heading_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_single_graphic_heading_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_graphic_heading_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_graphic_heading_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_graphic_heading_pane_t_Limits()		{ return (*(Tlist_single_graphic_heading_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_single_graphic_heading_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_single_large_graphic_pane
inline TAknLayoutScalableParameterLimits list_single_large_graphic_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_large_graphic_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_large_graphic_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_large_graphic_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_large_graphic_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_large_graphic_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_large_graphic_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_large_graphic_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_large_graphic_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_large_graphic_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_large_graphic_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_large_graphic_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_large_graphic_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_large_graphic_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_large_graphic_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_large_graphic_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_large_graphic_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_large_graphic_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_large_graphic_pane_g_Limits()		{ return (*(Tlist_single_large_graphic_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_large_graphic_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_large_graphic_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_large_graphic_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_large_graphic_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_single_large_graphic_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_large_graphic_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_large_graphic_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : wait_border_pane_copy1
inline TAknWindowComponentLayout wait_border_pane_g2_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twait_border_pane_g2_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_border_pane_g2_copy1)))(aVariety, aCol, aRow); }

// LAF Table : list_single_large_graphic_pane
inline TAknWindowComponentLayout list_single_large_graphic_pane_g4_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_large_graphic_pane_g4_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_large_graphic_pane_g4_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_large_graphic_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_large_graphic_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_large_graphic_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_large_graphic_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_large_graphic_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_large_graphic_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : list_double_pane
inline TAknLayoutScalableParameterLimits list_double_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_pane_g_Limits()		{ return (*(Tlist_double_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_double_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_pane_t_Limits()		{ return (*(Tlist_double_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_double_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_double2_pane
inline TAknLayoutScalableParameterLimits list_double2_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double2_pane_g_Limits()		{ return (*(Tlist_double2_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double2_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double2_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_double2_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double2_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double2_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double2_pane_t_Limits()		{ return (*(Tlist_double2_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double2_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double2_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_double2_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_double_number_pane
inline TAknLayoutScalableParameterLimits list_double_number_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_number_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_number_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_number_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_number_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_number_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_number_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_number_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_number_pane_g_Limits()		{ return (*(Tlist_double_number_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_number_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_number_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_double_number_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_number_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_number_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_number_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_number_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_number_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_number_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_number_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_number_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_number_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_number_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_number_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_number_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_number_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_number_pane_t_Limits()		{ return (*(Tlist_double_number_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_number_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_number_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_double_number_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_number_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_double_graphic_pane
inline TAknLayoutScalableParameterLimits list_double_graphic_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_graphic_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_graphic_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_graphic_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_graphic_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_graphic_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_graphic_pane_g_Limits()		{ return (*(Tlist_double_graphic_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_graphic_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_graphic_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_double_graphic_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_graphic_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_graphic_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_graphic_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_graphic_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_graphic_pane_t_Limits()		{ return (*(Tlist_double_graphic_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_graphic_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_graphic_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_double_graphic_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_double2_graphic_pane
inline TAknLayoutScalableParameterLimits list_double2_graphic_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_graphic_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_graphic_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_graphic_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_graphic_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_graphic_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_graphic_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_graphic_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_graphic_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double2_graphic_pane_g_Limits()		{ return (*(Tlist_double2_graphic_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double2_graphic_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_double2_graphic_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_graphic_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_graphic_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double2_graphic_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_graphic_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_graphic_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double2_graphic_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_graphic_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double2_graphic_pane_t_Limits()		{ return (*(Tlist_double2_graphic_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double2_graphic_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_double2_graphic_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_graphic_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_double_large_graphic_pane
inline TAknLayoutScalableParameterLimits list_double_large_graphic_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_large_graphic_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_large_graphic_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_large_graphic_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_large_graphic_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_large_graphic_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_large_graphic_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_large_graphic_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_large_graphic_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_large_graphic_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_large_graphic_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_large_graphic_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_large_graphic_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_large_graphic_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_large_graphic_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_large_graphic_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_large_graphic_pane_g_Limits()		{ return (*(Tlist_double_large_graphic_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_large_graphic_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_large_graphic_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_double_large_graphic_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_large_graphic_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_large_graphic_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_large_graphic_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_large_graphic_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_large_graphic_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_large_graphic_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_large_graphic_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_large_graphic_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_large_graphic_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_large_graphic_pane_t_Limits()		{ return (*(Tlist_double_large_graphic_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_large_graphic_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_large_graphic_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_double_large_graphic_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_large_graphic_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_double2_large_graphic_pane
inline TAknLayoutScalableParameterLimits list_double2_large_graphic_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_large_graphic_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_large_graphic_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_large_graphic_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_large_graphic_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_large_graphic_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_large_graphic_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_large_graphic_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_large_graphic_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_large_graphic_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_large_graphic_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_large_graphic_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double2_large_graphic_pane_g_Limits()		{ return (*(Tlist_double2_large_graphic_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double2_large_graphic_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double2_large_graphic_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_double2_large_graphic_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_large_graphic_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_large_graphic_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_large_graphic_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double2_large_graphic_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_large_graphic_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_large_graphic_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_large_graphic_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double2_large_graphic_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_large_graphic_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double2_large_graphic_pane_t_Limits()		{ return (*(Tlist_double2_large_graphic_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double2_large_graphic_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double2_large_graphic_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_double2_large_graphic_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_large_graphic_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_double_heading_pane
inline TAknLayoutScalableParameterLimits list_double_heading_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_heading_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_heading_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_heading_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_heading_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_heading_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_heading_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_heading_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_heading_pane_g_Limits()		{ return (*(Tlist_double_heading_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_heading_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_heading_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_double_heading_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_heading_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_heading_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_heading_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_heading_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_heading_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_heading_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_heading_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_heading_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_heading_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_heading_pane_t_Limits()		{ return (*(Tlist_double_heading_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_heading_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_heading_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_double_heading_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_heading_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_double_graphic_heading_pane
inline TAknLayoutScalableParameterLimits list_double_graphic_heading_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_heading_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_graphic_heading_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_heading_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_graphic_heading_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_heading_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_graphic_heading_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_heading_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_graphic_heading_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_heading_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_graphic_heading_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_heading_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_graphic_heading_pane_g_Limits()		{ return (*(Tlist_double_graphic_heading_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_graphic_heading_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_graphic_heading_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_double_graphic_heading_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_heading_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_graphic_heading_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_heading_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_graphic_heading_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_heading_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_graphic_heading_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_heading_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_graphic_heading_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_heading_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_graphic_heading_pane_t_Limits()		{ return (*(Tlist_double_graphic_heading_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_graphic_heading_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_graphic_heading_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_double_graphic_heading_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_heading_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_double_time_pane
inline TAknLayoutScalableParameterLimits list_double_time_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_time_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_time_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_time_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_time_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_time_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_time_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_time_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_time_pane_g_Limits()		{ return (*(Tlist_double_time_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_time_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_time_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_double_time_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_time_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_time_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_time_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_time_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_time_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_time_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_time_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_time_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_time_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_time_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_time_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_time_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_time_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_time_pane_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_time_pane_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_time_pane_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_time_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_time_pane_t_Limits()		{ return (*(Tlist_double_time_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_time_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_time_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_double_time_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_time_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_setting_pane
inline TAknLayoutScalableParameterLimits list_setting_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_setting_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_setting_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_setting_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_setting_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_setting_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_setting_pane_g_Limits()		{ return (*(Tlist_setting_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_setting_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_setting_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_setting_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_setting_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_setting_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_setting_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_setting_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_setting_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_setting_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_setting_pane_t_Limits()		{ return (*(Tlist_setting_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_setting_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_setting_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_setting_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits set_value_pane_cp_ParamLimits(TInt aVariety = 0)		{ return (*(Tset_value_pane_cp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_value_pane_cp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout set_value_pane_cp(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_value_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_value_pane_cp)))(aVariety, aCol, aRow); }

// LAF Table : list_setting_number_pane
inline TAknLayoutScalableParameterLimits list_setting_number_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_setting_number_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_setting_number_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_number_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_setting_number_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_setting_number_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_setting_number_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_number_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_setting_number_pane_g_Limits()		{ return (*(Tlist_setting_number_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_setting_number_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_setting_number_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_setting_number_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_number_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_setting_number_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_setting_number_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_setting_number_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_number_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_setting_number_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_setting_number_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_setting_number_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_number_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_setting_number_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_setting_number_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_setting_number_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_number_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_setting_number_pane_t_Limits()		{ return (*(Tlist_setting_number_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_setting_number_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_setting_number_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_setting_number_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_number_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits set_value_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tset_value_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_value_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout set_value_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_value_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_value_pane)))(aVariety, aCol, aRow); }

// LAF Table : set_value_pane
inline TAknLayoutScalableParameterLimits bg_set_opt_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_set_opt_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_set_opt_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_set_opt_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_set_opt_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_set_opt_pane)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout set_value_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_value_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_value_pane_t1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout slider_set_pane_cp3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_set_pane_cp3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_set_pane_cp3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small_pane_cp(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_cp)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_form_pane
inline TAknWindowComponentLayout list_form_gen_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_form_gen_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_form_gen_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp8)))(aVariety, aCol, aRow); }

// LAF Table : list_form_gen_pane
inline TAknLayoutScalableParameterLimits form_field_data_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_data_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_data_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout form_field_data_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_data_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_data_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_field_data_wide_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_data_wide_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_data_wide_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout form_field_data_wide_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_data_wide_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_data_wide_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_field_popup_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_popup_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_popup_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout form_field_popup_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_popup_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_popup_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_field_popup_wide_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_popup_wide_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_popup_wide_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout form_field_popup_wide_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_popup_wide_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_popup_wide_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_field_slider_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_slider_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout form_field_slider_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_slider_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_field_slider_wide_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_slider_wide_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_wide_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout form_field_slider_wide_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_slider_wide_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_wide_pane)))(aVariety, aCol, aRow); }

// LAF Table : form_field_data_pane
inline TAknWindowComponentLayout data_form_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tdata_form_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_data_form_pane)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout form_field_data_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_data_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_data_pane_t1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane)))(aVariety, aCol, aRow); }

// LAF Table : form_field_data_wide_pane
inline TAknWindowComponentLayout data_form_wide_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tdata_form_wide_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_data_form_wide_pane)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout form_field_data_wide_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_data_wide_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_data_wide_pane_t1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_cp6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp6)))(aVariety, aCol, aRow); }

// LAF Table : form_field_popup_pane
inline TAknTextComponentLayout form_field_popup_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_popup_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_popup_pane_t1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_cp7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_form_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_form_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_form_pane)))(aVariety, aCol, aRow); }

// LAF Table : form_field_popup_wide_pane
inline TAknTextComponentLayout form_field_popup_wide_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_popup_wide_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_popup_wide_pane_t1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_cp8(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_form_wide_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_form_wide_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_form_wide_pane)))(aVariety, aCol, aRow); }

// LAF Table : form_field_slider_pane
inline TAknLayoutScalableParameterLimits form_field_slider_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_slider_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout form_field_slider_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_slider_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_field_slider_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_slider_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout form_field_slider_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_slider_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits form_field_slider_pane_t_Limits()		{ return (*(Tform_field_slider_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits form_field_slider_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tform_field_slider_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout form_field_slider_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_slider_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits input_focus_pane_cp9_ParamLimits(TInt aVariety = 0)		{ return (*(Tinput_focus_pane_cp9_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp9_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout input_focus_pane_cp9(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits slider_cont_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tslider_cont_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_cont_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout slider_cont_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_cont_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_cont_pane)))(aVariety, aCol, aRow); }

// LAF Table : form_field_slider_wide_pane
inline TAknLayoutScalableParameterLimits form_field_slider_wide_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_slider_wide_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_wide_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout form_field_slider_wide_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_slider_wide_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_wide_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_field_slider_wide_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_slider_wide_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_wide_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout form_field_slider_wide_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_slider_wide_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_wide_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits form_field_slider_wide_pane_t_Limits()		{ return (*(Tform_field_slider_wide_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_wide_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits form_field_slider_wide_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tform_field_slider_wide_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_wide_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout form_field_slider_wide_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_slider_wide_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_wide_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits input_focus_pane_cp10_ParamLimits(TInt aVariety = 0)		{ return (*(Tinput_focus_pane_cp10_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp10_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout input_focus_pane_cp10(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp10)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits slider_cont_pane_cp1_ParamLimits(TInt aVariety = 0)		{ return (*(Tslider_cont_pane_cp1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_cont_pane_cp1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout slider_cont_pane_cp1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_cont_pane_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_cont_pane_cp1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout slider_form_pane_cp(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_form_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_form_pane_cp)))(aVariety, aCol, aRow); }

// LAF Table : input_focus_pane
inline TAknWindowComponentLayout input_focus_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_g9)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_g10(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_g10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_g10)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits input_focus_pane_g_Limits()		{ return (*(Tinput_focus_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_g_Limits)))(); }

inline TAknWindowComponentLayout input_focus_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : wait_border_pane_copy1
inline TAknWindowComponentLayout wait_border_pane_g3_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twait_border_pane_g3_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_border_pane_g3_copy1)))(aVariety, aCol, aRow); }

// LAF Table : data_form_pane
inline TAknTextComponentLayout data_form_pane_t1(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tdata_form_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_data_form_pane_t1)))(aRow, aVariety, aCol); }

// LAF Table : wait_anim_pane_copy1
inline TAknWindowComponentLayout wait_anim_pane_g1_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twait_anim_pane_g1_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_anim_pane_g1_copy1)))(aVariety, aCol, aRow); }

// LAF Table : data_form_wide_pane
inline TAknTextComponentLayout data_form_wide_pane_t1(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tdata_form_wide_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_data_form_wide_pane_t1)))(aRow, aVariety, aCol); }

// LAF Table : list_form_wide_pane
inline TAknLayoutScalableParameterLimits list_form_graphic_pane_cp_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_form_graphic_pane_cp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_form_graphic_pane_cp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_form_graphic_pane_cp(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_form_graphic_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_form_graphic_pane_cp)))(aRow, aVariety, aCol); }

// LAF Table : slider_form_pane
inline TAknWindowComponentLayout slider_form_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_form_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_form_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout slider_form_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_form_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_form_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits slider_form_pane_g_Limits()		{ return (*(Tslider_form_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_form_pane_g_Limits)))(); }

inline TAknWindowComponentLayout slider_form_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_form_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_form_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_form_pane
inline TAknLayoutScalableParameterLimits list_form_graphic_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_form_graphic_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_form_graphic_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_form_graphic_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_form_graphic_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_form_graphic_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_form_graphic_pane
inline TAknWindowComponentLayout list_form_graphic_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_form_graphic_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_form_graphic_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_form_graphic_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_form_graphic_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_form_graphic_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_form_graphic_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_form_graphic_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_form_graphic_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_highlight_pane_cp5_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_highlight_pane_cp5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_highlight_pane_cp5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_cp5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp5)))(aVariety, aCol, aRow); }

// LAF Table : find_pane
inline TAknWindowComponentLayout find_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfind_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_find_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_find_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_find_pane)))(aVariety, aCol, aRow); }

// LAF Table : input_find_pane
inline TAknLayoutScalableParameterLimits input_find_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tinput_find_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_find_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout input_find_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_find_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_find_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits input_find_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tinput_find_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_find_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout input_find_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_find_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_find_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits input_find_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tinput_find_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_find_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout input_find_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_find_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_find_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits input_find_pane_t_Limits()		{ return (*(Tinput_find_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_find_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits input_find_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tinput_find_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_find_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout input_find_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_find_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_find_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits input_focus_pane_cp5_ParamLimits(TInt aVariety = 0)		{ return (*(Tinput_focus_pane_cp5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout input_focus_pane_cp5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp5)))(aVariety, aCol, aRow); }

// LAF Table : popup_menu_window
inline TAknLayoutScalableParameterLimits bg_popup_window_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits listscroll_menu_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlistscroll_menu_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_menu_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout listscroll_menu_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_menu_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_menu_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_submenu_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_submenu_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_submenu_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_submenu_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_submenu_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_submenu_window)))(aVariety, aCol, aRow); }

// LAF Table : find_popup_pane
inline TAknWindowComponentLayout find_popup_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfind_popup_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_popup_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_popup_find_pane_cp(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_popup_find_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_popup_find_pane_cp)))(aVariety, aCol, aRow); }

// LAF Table : input_popup_find_pane_cp
inline TAknLayoutScalableParameterLimits input_focus_pane_cp4_ParamLimits(TInt aVariety = 0)		{ return (*(Tinput_focus_pane_cp4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout input_focus_pane_cp4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits input_popup_find_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tinput_popup_find_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_popup_find_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout input_popup_find_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_popup_find_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_popup_find_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : popup_submenu_window
inline TAknWindowComponentLayout bg_popup_sub_pane_cp(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout listscroll_popup_sub_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_popup_sub_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_sub_pane)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_popup_sub_pane
inline TAknLayoutScalableParameterLimits list_submenu_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_submenu_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_submenu_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_submenu_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_submenu_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_submenu_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp4)))(aVariety, aCol, aRow); }

// LAF Table : list_submenu_pane
inline TAknLayoutScalableParameterLimits list_single_popup_submenu_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_popup_submenu_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_popup_submenu_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_popup_submenu_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_popup_submenu_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_popup_submenu_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_single_popup_submenu_pane
inline TAknWindowComponentLayout list_single_popup_submenu_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_popup_submenu_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_popup_submenu_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_popup_submenu_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_popup_submenu_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_popup_submenu_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_popup_submenu_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_popup_submenu_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_popup_submenu_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : tabs_2_active_pane
inline TAknLayoutScalableParameterLimits bg_active_tab_pane_cp1_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_active_tab_pane_cp1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_cp1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_active_tab_pane_cp1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_cp1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout tabs_2_active_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_2_active_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_active_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout tabs_2_active_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_2_active_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_active_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : tabs_2_passive_pane
inline TAknLayoutScalableParameterLimits bg_passive_tab_pane_cp1_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_passive_tab_pane_cp1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_cp1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_passive_tab_pane_cp1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_cp1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout tabs_2_passive_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_2_passive_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_passive_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout tabs_2_passive_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_2_passive_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_passive_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : tabs_2_long_active_pane
inline TAknWindowComponentLayout bg_active_tab_pane_cp4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_cp4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_cp4)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout tabs_2_long_active_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_2_long_active_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_long_active_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : tabs_2_long_passive_pane
inline TAknWindowComponentLayout bg_passive_tab_pane_cp4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_cp4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_cp4)))(aVariety, aCol, aRow); }

// LAF Table : list_single_midp_graphic_pane
inline TAknLayoutScalableParameterLimits list_single_midp_graphic_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_midp_graphic_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_midp_graphic_pane_g4_ParamLimits)))(aVariety); }

// LAF Table : tabs_3_long_active_pane
inline TAknWindowComponentLayout bg_active_tab_pane_cp5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_cp5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_cp5)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout tabs_3_long_active_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_3_long_active_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_long_active_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : tabs_3_long_passive_pane
inline TAknWindowComponentLayout bg_passive_tab_pane_cp5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_cp5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_cp5)))(aVariety, aCol, aRow); }

// LAF Table : list_single_midp_graphic_pane
inline TAknWindowComponentLayout list_single_midp_graphic_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_midp_graphic_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_midp_graphic_pane_g4)))(aVariety, aCol, aRow); }

// LAF Table : popup_fast_swap_window
inline TAknLayoutScalableParameterLimits bg_popup_window_pane_cp13_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_cp13_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp13_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_cp13(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp13_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp13)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits listscroll_popup_fast_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlistscroll_popup_fast_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_fast_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout listscroll_popup_fast_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_popup_fast_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_fast_pane)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_popup_fast_pane
inline TAknLayoutScalableParameterLimits grid_popup_fast_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_popup_fast_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_popup_fast_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_popup_fast_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_popup_fast_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_popup_fast_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits scroll_pane_cp9_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_pane_cp9_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp9_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout scroll_pane_cp9(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp9)))(aVariety, aCol, aRow); }

// LAF Table : list_single_graphic_hl_pane_cp2
inline TAknLayoutScalableParameterLimits list_single_graphic_hl_pane_t1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_hl_pane_t1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_t1_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_graphic_hl_pane_t1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_hl_pane_t1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_t1_cp2)))(aVariety, aCol, aRow); }

// LAF Table : query_popup_data_pane
inline TAknLayoutScalableParameterLimits input_focus_pane_cp20_ParamLimits(TInt aVariety = 0)		{ return (*(Tinput_focus_pane_cp20_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp20_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout input_focus_pane_cp20(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp20_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp20)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits query_popup_data_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tquery_popup_data_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_query_popup_data_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout query_popup_data_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tquery_popup_data_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_query_popup_data_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits query_popup_data_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tquery_popup_data_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_query_popup_data_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout query_popup_data_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tquery_popup_data_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_query_popup_data_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits query_popup_data_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tquery_popup_data_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_query_popup_data_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout query_popup_data_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tquery_popup_data_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_query_popup_data_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits query_popup_data_pane_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tquery_popup_data_pane_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_query_popup_data_pane_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout query_popup_data_pane_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tquery_popup_data_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_query_popup_data_pane_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits query_popup_data_pane_t5_ParamLimits(TInt aVariety = 0)		{ return (*(Tquery_popup_data_pane_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_query_popup_data_pane_t5_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout query_popup_data_pane_t5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tquery_popup_data_pane_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_query_popup_data_pane_t5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits query_popup_data_pane_t_Limits()		{ return (*(Tquery_popup_data_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_query_popup_data_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits query_popup_data_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tquery_popup_data_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_query_popup_data_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout query_popup_data_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tquery_popup_data_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_query_popup_data_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : bg_set_opt_pane
inline TAknWindowComponentLayout bg_set_opt_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_set_opt_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_set_opt_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_set_opt_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_set_opt_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_set_opt_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_set_opt_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_set_opt_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_set_opt_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_set_opt_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_set_opt_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_set_opt_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_set_opt_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_set_opt_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_set_opt_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_set_opt_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_set_opt_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_set_opt_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_set_opt_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_set_opt_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_set_opt_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_set_opt_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_set_opt_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_set_opt_pane_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_set_opt_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_set_opt_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_set_opt_pane_g9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits bg_set_opt_pane_g_Limits()		{ return (*(Tbg_set_opt_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_set_opt_pane_g_Limits)))(); }

inline TAknWindowComponentLayout bg_set_opt_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_set_opt_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_set_opt_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : stacon_top_pane
inline TAknLayoutScalableParameterLimits control_top_pane_stacon_ParamLimits(TInt aVariety = 0)		{ return (*(Tcontrol_top_pane_stacon_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_top_pane_stacon_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout control_top_pane_stacon(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_top_pane_stacon_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_top_pane_stacon)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits signal_pane_stacon_ParamLimits(TInt aVariety = 0)		{ return (*(Tsignal_pane_stacon_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_signal_pane_stacon_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout signal_pane_stacon(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsignal_pane_stacon_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_signal_pane_stacon)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits stacon_top_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tstacon_top_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_stacon_top_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout stacon_top_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstacon_top_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_stacon_top_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits title_pane_stacon_ParamLimits(TInt aVariety = 0)		{ return (*(Ttitle_pane_stacon_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_stacon_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout title_pane_stacon(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttitle_pane_stacon_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_stacon)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits uni_indicator_pane_stacon_ParamLimits(TInt aVariety = 0)		{ return (*(Tuni_indicator_pane_stacon_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_uni_indicator_pane_stacon_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout uni_indicator_pane_stacon(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tuni_indicator_pane_stacon_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_uni_indicator_pane_stacon)))(aVariety, aCol, aRow); }

// LAF Table : stacon_bottom_pane
inline TAknLayoutScalableParameterLimits battery_pane_stacon_ParamLimits(TInt aVariety = 0)		{ return (*(Tbattery_pane_stacon_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_battery_pane_stacon_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout battery_pane_stacon(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbattery_pane_stacon_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_battery_pane_stacon)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits control_bottom_pane_stacon_ParamLimits(TInt aVariety = 0)		{ return (*(Tcontrol_bottom_pane_stacon_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_bottom_pane_stacon_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout control_bottom_pane_stacon(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_bottom_pane_stacon_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_bottom_pane_stacon)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits navi_pane_stacon_ParamLimits(TInt aVariety = 0)		{ return (*(Tnavi_pane_stacon_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_stacon_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout navi_pane_stacon(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_stacon_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_stacon)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits stacon_bottom_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tstacon_bottom_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_stacon_bottom_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout stacon_bottom_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstacon_bottom_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_stacon_bottom_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : signal_pane_stacon
inline TAknLayoutScalableParameterLimits aid_levels_signal_lsc_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_levels_signal_lsc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_levels_signal_lsc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_levels_signal_lsc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_levels_signal_lsc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_levels_signal_lsc)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits signal_pane_stacon_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tsignal_pane_stacon_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_signal_pane_stacon_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout signal_pane_stacon_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsignal_pane_stacon_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_signal_pane_stacon_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits signal_pane_stacon_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tsignal_pane_stacon_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_signal_pane_stacon_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout signal_pane_stacon_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsignal_pane_stacon_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_signal_pane_stacon_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits signal_pane_stacon_g_Limits()		{ return (*(Tsignal_pane_stacon_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_signal_pane_stacon_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits signal_pane_stacon_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tsignal_pane_stacon_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_signal_pane_stacon_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout signal_pane_stacon_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsignal_pane_stacon_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_signal_pane_stacon_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : title_pane_stacon
inline TAknLayoutScalableParameterLimits title_pane_stacon_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Ttitle_pane_stacon_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_stacon_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout title_pane_stacon_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttitle_pane_stacon_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_stacon_t1)))(aVariety, aCol, aRow); }

// LAF Table : uni_indicator_pane_stacon
inline TAknWindowComponentLayout uni_indicator_pane_stacon_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tuni_indicator_pane_stacon_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_uni_indicator_pane_stacon_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout uni_indicator_pane_stacon_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tuni_indicator_pane_stacon_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_uni_indicator_pane_stacon_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout uni_indicator_pane_stacon_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tuni_indicator_pane_stacon_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_uni_indicator_pane_stacon_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout uni_indicator_pane_stacon_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tuni_indicator_pane_stacon_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_uni_indicator_pane_stacon_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits uni_indicator_pane_stacon_g_Limits()		{ return (*(Tuni_indicator_pane_stacon_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_uni_indicator_pane_stacon_g_Limits)))(); }

inline TAknWindowComponentLayout uni_indicator_pane_stacon_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tuni_indicator_pane_stacon_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_uni_indicator_pane_stacon_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : control_top_pane_stacon
inline TAknWindowComponentLayout control_top_pane_stacon_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_top_pane_stacon_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_top_pane_stacon_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits control_top_pane_stacon_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcontrol_top_pane_stacon_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_top_pane_stacon_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout control_top_pane_stacon_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_top_pane_stacon_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_top_pane_stacon_t1)))(aVariety, aCol, aRow); }

// LAF Table : battery_pane_stacon
inline TAknLayoutScalableParameterLimits aid_levels_battery_lsc_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_levels_battery_lsc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_levels_battery_lsc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_levels_battery_lsc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_levels_battery_lsc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_levels_battery_lsc)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits battery_pane_stacon_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tbattery_pane_stacon_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_battery_pane_stacon_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout battery_pane_stacon_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbattery_pane_stacon_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_battery_pane_stacon_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits battery_pane_stacon_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tbattery_pane_stacon_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_battery_pane_stacon_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout battery_pane_stacon_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbattery_pane_stacon_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_battery_pane_stacon_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits battery_pane_stacon_g_Limits()		{ return (*(Tbattery_pane_stacon_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_battery_pane_stacon_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits battery_pane_stacon_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tbattery_pane_stacon_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_battery_pane_stacon_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout battery_pane_stacon_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbattery_pane_stacon_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_battery_pane_stacon_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : navi_pane_stacon
inline TAknWindowComponentLayout navi_icon_pane_stacon(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_icon_pane_stacon_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_icon_pane_stacon)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_navi_pane_stacon(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_navi_pane_stacon_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_pane_stacon)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_text_pane_stacon(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_text_pane_stacon_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_text_pane_stacon)))(aVariety, aCol, aRow); }

// LAF Table : control_bottom_pane_stacon
inline TAknWindowComponentLayout control_bottom_pane_stacon_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_bottom_pane_stacon_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_bottom_pane_stacon_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits control_bottom_pane_stacon_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcontrol_bottom_pane_stacon_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_bottom_pane_stacon_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout control_bottom_pane_stacon_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_bottom_pane_stacon_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_bottom_pane_stacon_t1)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_app_pane
inline TAknLayoutScalableParameterLimits grid_app_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_app_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_app_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_app_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_app_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_app_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits scroll_pane_cp15_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_pane_cp15_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp15_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout scroll_pane_cp15(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp15_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp15)))(aVariety, aCol, aRow); }

// LAF Table : grid_app_pane
inline TAknLayoutScalableParameterLimits cell_app_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_app_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_app_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_app_pane(TInt aVariety, TInt aCol, TInt aRow)		{ return (*(Tcell_app_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_app_pane)))(aVariety, aCol, aRow); }

// LAF Table : cell_app_pane
inline TAknLayoutScalableParameterLimits cell_app_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_app_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_app_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_app_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_app_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_app_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_app_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_app_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_app_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_app_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_app_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_app_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_app_pane_g_Limits()		{ return (*(Tcell_app_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_app_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits cell_app_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tcell_app_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_app_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout cell_app_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_app_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_app_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_app_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_app_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_app_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout cell_app_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_app_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_app_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_highlight_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_highlight_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_highlight_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane)))(aVariety, aCol, aRow); }

// LAF Table : grid_highlight_pane
inline TAknWindowComponentLayout cell_highlight_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_highlight_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_highlight_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_highlight_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_highlight_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_highlight_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_highlight_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_highlight_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_highlight_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_highlight_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_highlight_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_highlight_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_highlight_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_highlight_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_highlight_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_highlight_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_highlight_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_highlight_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_highlight_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_highlight_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_highlight_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_highlight_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_highlight_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_highlight_pane_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_highlight_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_highlight_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_highlight_pane_g9)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_highlight_pane_g10(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_highlight_pane_g10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_highlight_pane_g10)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_highlight_pane_g_Limits()		{ return (*(Tcell_highlight_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_highlight_pane_g_Limits)))(); }

inline TAknWindowComponentLayout cell_highlight_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_highlight_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_highlight_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : scroll_pane
inline TAknWindowComponentLayout bg_scroll_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_scroll_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_scroll_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_handle_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_handle_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_handle_pane)))(aVariety, aCol, aRow); }

// LAF Table : bg_scroll_pane
inline TAknWindowComponentLayout scroll_bg_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_bg_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_bg_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_bg_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_bg_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_bg_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_bg_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_bg_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_bg_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits scroll_bg_pane_g_Limits()		{ return (*(Tscroll_bg_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_bg_pane_g_Limits)))(); }

inline TAknWindowComponentLayout scroll_bg_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_bg_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_bg_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : scroll_handle_pane
inline TAknLayoutScalableParameterLimits scroll_handle_focus_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_handle_focus_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_handle_focus_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout scroll_handle_focus_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_handle_focus_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_handle_focus_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_handle_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_handle_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_handle_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_handle_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_handle_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_handle_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_handle_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_handle_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_handle_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits scroll_handle_pane_g_Limits()		{ return (*(Tscroll_handle_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_handle_pane_g_Limits)))(); }

inline TAknWindowComponentLayout scroll_handle_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_handle_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_handle_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_fep_japan_predictive_window
inline TAknLayoutScalableParameterLimits bg_popup_sub_pane_cp21_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_sub_pane_cp21_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp21_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_sub_pane_cp21(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp21_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp21)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_fep_japan_predictive_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_fep_japan_predictive_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fep_japan_predictive_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_fep_japan_predictive_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_fep_japan_predictive_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fep_japan_predictive_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_fep_japan_predictive_window_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_fep_japan_predictive_window_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fep_japan_predictive_window_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_fep_japan_predictive_window_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_fep_japan_predictive_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fep_japan_predictive_window_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_fep_japan_predictive_window_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_fep_japan_predictive_window_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fep_japan_predictive_window_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_fep_japan_predictive_window_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_fep_japan_predictive_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fep_japan_predictive_window_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_fep_japan_predictive_window_t_Limits()		{ return (*(Tpopup_fep_japan_predictive_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fep_japan_predictive_window_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_fep_japan_predictive_window_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_fep_japan_predictive_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fep_japan_predictive_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_fep_japan_predictive_window_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_fep_japan_predictive_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fep_japan_predictive_window_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_fep_japan_candidate_window
inline TAknWindowComponentLayout bg_popup_sub_pane_cp23(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp23_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp23)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout listscroll_japin_cand_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_japin_cand_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_japin_cand_pane)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_fep_japan_candidate_window_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_fep_japan_candidate_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fep_japan_candidate_window_t1)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_japin_cand_pane
inline TAknLayoutScalableParameterLimits candidate_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcandidate_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_candidate_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout candidate_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcandidate_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_candidate_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp30(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp30_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp30)))(aVariety, aCol, aRow); }

// LAF Table : candidate_pane
inline TAknLayoutScalableParameterLimits list_single_popup_jap_candidate_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_popup_jap_candidate_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_popup_jap_candidate_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_popup_jap_candidate_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_popup_jap_candidate_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_popup_jap_candidate_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_single_popup_jap_candidate_pane
inline TAknWindowComponentLayout list_highlight_pane_cp30(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_cp30_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp30)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout list_single_popup_jap_candidate_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_popup_jap_candidate_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_popup_jap_candidate_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : aid_levels_signal
inline TAknWindowComponentLayout level_1_signal(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_1_signal_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_1_signal)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_2_signal(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_2_signal_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_2_signal)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_3_signal(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_3_signal_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_3_signal)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_4_signal(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_4_signal_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_4_signal)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_5_signal(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_5_signal_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_5_signal)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_6_signal(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_6_signal_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_6_signal)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_7_signal(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_7_signal_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_7_signal)))(aVariety, aCol, aRow); }

// LAF Table : aid_levels_battery
inline TAknWindowComponentLayout level_1_battery(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_1_battery_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_1_battery)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_2_battery(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_2_battery_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_2_battery)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_3_battery(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_3_battery_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_3_battery)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_4_battery(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_4_battery_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_4_battery)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_5_battery(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_5_battery_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_5_battery)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_6_battery(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_6_battery_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_6_battery)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_7_battery(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_7_battery_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_7_battery)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_menu_pane
inline TAknLayoutScalableParameterLimits list_menu_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_menu_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_menu_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_menu_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_menu_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_menu_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits scroll_pane_cp25_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_pane_cp25_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp25_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout scroll_pane_cp25(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp25_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp25)))(aVariety, aCol, aRow); }

// LAF Table : list_menu_pane
inline TAknLayoutScalableParameterLimits list_double2_graphic_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_graphic_pane_cp2(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double2_graphic_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_cp2)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_double2_large_graphic_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_large_graphic_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_large_graphic_pane_cp2(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double2_large_graphic_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_cp2)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_double2_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_pane_cp2(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double2_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_cp2)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_double_graphic_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_graphic_pane_cp2(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double_graphic_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_cp2)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_double_large_graphic_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_large_graphic_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_large_graphic_pane_cp2(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double_large_graphic_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_cp2)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_double_number_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_number_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_number_pane_cp2(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double_number_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_cp2)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_double_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_pane_cp2(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_cp2)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_single_2graphic_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_2graphic_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_2graphic_pane_cp2(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_2graphic_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_cp2)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_heading_pane_cp2(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_graphic_heading_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_cp2)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_single_graphic_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_pane_cp2(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_graphic_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_cp2)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_single_heading_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_heading_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_heading_pane_cp2(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_heading_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_cp2)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_single_large_graphic_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_large_graphic_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_large_graphic_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_large_graphic_pane_cp2(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_large_graphic_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_large_graphic_pane_cp2)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_single_number_heading_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_number_heading_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_number_heading_pane_cp2(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_number_heading_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_cp2)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_single_number_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_number_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_number_pane_cp2(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_number_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_pane_cp2)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_single_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_pane_cp2(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_cp2)))(aRow, aVariety, aCol); }

// LAF Table : popup_side_volume_key_window
inline TAknWindowComponentLayout bg_popup_sub_pane_cp22(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp22_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp22)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_side_volume_key_window_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_side_volume_key_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_side_volume_key_window_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_side_volume_key_window_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_side_volume_key_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_side_volume_key_window_t1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small_pane_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_cp1)))(aVariety, aCol, aRow); }

// LAF Table : popup_fep_china_uni_window
inline TAknLayoutScalableParameterLimits bg_popup_sub_pane_cp24_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_sub_pane_cp24_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp24_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_sub_pane_cp24(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp24_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp24)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_china_uni_candidate_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_china_uni_candidate_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_china_uni_candidate_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_china_uni_candidate_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_china_uni_candidate_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_china_uni_candidate_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout fep_china_uni_entry_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_china_uni_entry_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_china_uni_entry_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_fep_china_uni_window_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_fep_china_uni_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fep_china_uni_window_g1)))(aVariety, aCol, aRow); }

// LAF Table : fep_china_uni_entry_pane
inline TAknWindowComponentLayout fep_china_uni_entry_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_china_uni_entry_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_china_uni_entry_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout fep_china_uni_entry_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_china_uni_entry_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_china_uni_entry_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits fep_china_uni_entry_pane_g_Limits()		{ return (*(Tfep_china_uni_entry_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_china_uni_entry_pane_g_Limits)))(); }

inline TAknWindowComponentLayout fep_china_uni_entry_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_china_uni_entry_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_china_uni_entry_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout fep_entry_item_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_entry_item_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_entry_item_pane)))(aVariety, aCol, aRow); }

// LAF Table : fep_china_uni_candidate_pane
inline TAknWindowComponentLayout fep_candidate_item_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_candidate_item_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_candidate_item_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout fep_china_uni_candidate_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_china_uni_candidate_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_china_uni_candidate_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout fep_china_uni_candidate_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_china_uni_candidate_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_china_uni_candidate_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout fep_china_uni_candidate_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_china_uni_candidate_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_china_uni_candidate_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout fep_china_uni_candidate_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_china_uni_candidate_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_china_uni_candidate_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits fep_china_uni_candidate_pane_g_Limits()		{ return (*(Tfep_china_uni_candidate_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_china_uni_candidate_pane_g_Limits)))(); }

inline TAknWindowComponentLayout fep_china_uni_candidate_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_china_uni_candidate_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_china_uni_candidate_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : fep_entry_item_pane
inline TAknWindowComponentLayout fep_entry_item_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_entry_item_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_entry_item_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_entry_item_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_entry_item_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_entry_item_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout fep_entry_item_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_entry_item_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_entry_item_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : fep_candidate_item_pane
inline TAknLayoutScalableParameterLimits fep_candidate_item_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_candidate_item_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_candidate_item_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout fep_candidate_item_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_candidate_item_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_candidate_item_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_candidate_item_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_candidate_item_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_candidate_item_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout fep_candidate_item_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_candidate_item_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_candidate_item_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits fep_candidate_item_pane_t_Limits()		{ return (*(Tfep_candidate_item_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_candidate_item_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits fep_candidate_item_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tfep_candidate_item_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_candidate_item_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout fep_candidate_item_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_candidate_item_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_candidate_item_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_highlight_pane_cp31_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_highlight_pane_cp31_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp31_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_highlight_pane_cp31(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_cp31_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp31)))(aVariety, aCol, aRow); }

// LAF Table : aid_levels_signal_lsc
inline TAknWindowComponentLayout level_1_signal_lsc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_1_signal_lsc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_1_signal_lsc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_2_signal_lsc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_2_signal_lsc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_2_signal_lsc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_3_signal_lsc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_3_signal_lsc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_3_signal_lsc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_4_signal_lsc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_4_signal_lsc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_4_signal_lsc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_5_signal_lsc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_5_signal_lsc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_5_signal_lsc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_6_signal_lsc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_6_signal_lsc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_6_signal_lsc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_7_signal_lsc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_7_signal_lsc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_7_signal_lsc)))(aVariety, aCol, aRow); }

// LAF Table : aid_levels_battery_lsc
inline TAknWindowComponentLayout level_1_battery_lsc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_1_battery_lsc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_1_battery_lsc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_2_battery_lsc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_2_battery_lsc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_2_battery_lsc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_3_battery_lsc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_3_battery_lsc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_3_battery_lsc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_4_battery_lsc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_4_battery_lsc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_4_battery_lsc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_5_battery_lsc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_5_battery_lsc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_5_battery_lsc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_6_battery_lsc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_6_battery_lsc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_6_battery_lsc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout level_7_battery_lsc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlevel_7_battery_lsc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_7_battery_lsc)))(aVariety, aCol, aRow); }

// LAF Table : scroll_handle_focus_pane
inline TAknWindowComponentLayout scroll_handle_focus_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_handle_focus_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_handle_focus_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_handle_focus_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_handle_focus_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_handle_focus_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_handle_focus_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_handle_focus_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_handle_focus_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits scroll_handle_focus_pane_g_Limits()		{ return (*(Tscroll_handle_focus_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_handle_focus_pane_g_Limits)))(); }

inline TAknWindowComponentLayout scroll_handle_focus_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_handle_focus_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_handle_focus_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_single_2graphic_pane
inline TAknLayoutScalableParameterLimits list_single_2graphic_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_2graphic_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_2graphic_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_2graphic_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_2graphic_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_2graphic_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_2graphic_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_2graphic_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_2graphic_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_2graphic_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_2graphic_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_2graphic_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_2graphic_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_2graphic_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_2graphic_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_2graphic_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_2graphic_pane_g_Limits()		{ return (*(Tlist_single_2graphic_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_2graphic_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_2graphic_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_single_2graphic_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_2graphic_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_2graphic_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_2graphic_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_2graphic_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_2graphic_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : list_double2_graphic_large_graphic_pane
inline TAknLayoutScalableParameterLimits list_double2_graphic_large_graphic_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_large_graphic_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_large_graphic_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_graphic_large_graphic_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_graphic_large_graphic_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_large_graphic_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_graphic_large_graphic_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_large_graphic_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_large_graphic_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_graphic_large_graphic_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_graphic_large_graphic_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_large_graphic_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_graphic_large_graphic_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_large_graphic_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_large_graphic_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_graphic_large_graphic_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_graphic_large_graphic_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_large_graphic_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_graphic_large_graphic_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_large_graphic_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_large_graphic_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_graphic_large_graphic_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_graphic_large_graphic_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_large_graphic_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double2_graphic_large_graphic_pane_g_Limits()		{ return (*(Tlist_double2_graphic_large_graphic_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_large_graphic_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double2_graphic_large_graphic_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_large_graphic_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_large_graphic_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_double2_graphic_large_graphic_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_graphic_large_graphic_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_large_graphic_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_graphic_large_graphic_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_large_graphic_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_large_graphic_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double2_graphic_large_graphic_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_graphic_large_graphic_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_large_graphic_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_graphic_large_graphic_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_large_graphic_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_large_graphic_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double2_graphic_large_graphic_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_graphic_large_graphic_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_large_graphic_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double2_graphic_large_graphic_pane_t_Limits()		{ return (*(Tlist_double2_graphic_large_graphic_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_large_graphic_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double2_graphic_large_graphic_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_large_graphic_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_large_graphic_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_double2_graphic_large_graphic_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_graphic_large_graphic_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_large_graphic_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : area_top_pane
inline TAknLayoutScalableParameterLimits popup_fast_swap_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_fast_swap_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fast_swap_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_fast_swap_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_fast_swap_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fast_swap_window)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_side_volume_key_window(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_side_volume_key_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_side_volume_key_window)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout stacon_top_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstacon_top_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_stacon_top_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits status_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tstatus_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout status_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout status_small_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_small_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane)))(aVariety, aCol, aRow); }

// LAF Table : area_bottom_pane
inline TAknWindowComponentLayout control_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout stacon_bottom_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstacon_bottom_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_stacon_bottom_pane)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_set_pane
inline TAknWindowComponentLayout scroll_pane_cp121(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp121_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp121)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout set_content_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_content_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_content_pane)))(aVariety, aCol, aRow); }

// LAF Table : bg_active_tab_pane_cp1
inline TAknWindowComponentLayout bg_active_tab_pane_g1_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g1_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g1_cp1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_active_tab_pane_g2_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g2_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g2_cp1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_active_tab_pane_g3_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g3_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g3_cp1)))(aVariety, aCol, aRow); }

// LAF Table : bg_passive_tab_pane_cp1
inline TAknWindowComponentLayout bg_passive_tab_pane_g1_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g1_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g1_cp1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_passive_tab_pane_g2_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g2_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g2_cp1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_passive_tab_pane_g3_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g3_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g3_cp1)))(aVariety, aCol, aRow); }

// LAF Table : bg_active_tab_pane_cp2
inline TAknWindowComponentLayout bg_active_tab_pane_g1_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g1_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_active_tab_pane_g2_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g2_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_active_tab_pane_g3_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g3_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g3_cp2)))(aVariety, aCol, aRow); }

// LAF Table : bg_passive_tab_pane_cp2
inline TAknWindowComponentLayout bg_passive_tab_pane_g1_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g1_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_passive_tab_pane_g2_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g2_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_passive_tab_pane_g3_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g3_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g3_cp2)))(aVariety, aCol, aRow); }

// LAF Table : bg_active_tab_pane_cp3
inline TAknWindowComponentLayout bg_active_tab_pane_g1_cp3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g1_cp3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g1_cp3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_active_tab_pane_g2_cp3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g2_cp3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g2_cp3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_active_tab_pane_g3_cp3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g3_cp3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g3_cp3)))(aVariety, aCol, aRow); }

// LAF Table : bg_passive_tab_pane_cp3
inline TAknWindowComponentLayout bg_passive_tab_pane_g1_cp3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g1_cp3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g1_cp3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_passive_tab_pane_g2_cp3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g2_cp3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g2_cp3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_passive_tab_pane_g3_cp3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g3_cp3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g3_cp3)))(aVariety, aCol, aRow); }

// LAF Table : bg_active_tab_pane_cp4
inline TAknWindowComponentLayout bg_active_tab_pane_g1_cp4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g1_cp4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g1_cp4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_active_tab_pane_g2_cp4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g2_cp4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g2_cp4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_active_tab_pane_g3_cp4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g3_cp4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g3_cp4)))(aVariety, aCol, aRow); }

// LAF Table : bg_passive_tab_pane_cp4
inline TAknWindowComponentLayout bg_passive_tab_pane_g1_cp4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g1_cp4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g1_cp4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_passive_tab_pane_g2_cp4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g2_cp4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g2_cp4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_passive_tab_pane_g3_cp4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g3_cp4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g3_cp4)))(aVariety, aCol, aRow); }

// LAF Table : bg_active_tab_pane_cp5
inline TAknWindowComponentLayout bg_active_tab_pane_g1_cp5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g1_cp5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g1_cp5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_active_tab_pane_g2_cp5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g2_cp5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g2_cp5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_active_tab_pane_g3_cp5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g3_cp5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g3_cp5)))(aVariety, aCol, aRow); }

// LAF Table : bg_passive_tab_pane_cp5
inline TAknWindowComponentLayout bg_passive_tab_pane_g1_cp5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g1_cp5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g1_cp5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_passive_tab_pane_g2_cp5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g2_cp5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g2_cp5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_passive_tab_pane_g3_cp5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g3_cp5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g3_cp5)))(aVariety, aCol, aRow); }

// LAF Table : list_set_pane
inline TAknLayoutScalableParameterLimits list_set_graphic_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_set_graphic_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_set_graphic_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_set_graphic_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_set_graphic_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_set_graphic_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_set_graphic_pane
inline TAknWindowComponentLayout bg_set_opt_pane_cp4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_set_opt_pane_cp4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_set_opt_pane_cp4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_set_graphic_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_set_graphic_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_set_graphic_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_set_graphic_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_set_graphic_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_set_graphic_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_set_graphic_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_set_graphic_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_set_graphic_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_set_graphic_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_set_graphic_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_set_graphic_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_set_graphic_pane_g_Limits()		{ return (*(Tlist_set_graphic_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_set_graphic_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_set_graphic_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_set_graphic_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_set_graphic_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_set_graphic_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_set_graphic_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_set_graphic_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : volume_small_pane_cp
inline TAknLayoutScalableTableLimits volume_small_pane_cp_g_Limits()		{ return (*(Tvolume_small_pane_cp_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_cp_g_Limits)))(); }

inline TAknWindowComponentLayout volume_small_pane_cp_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_cp_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_cp_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_double2_large_graphic_pane_cp2
inline TAknLayoutScalableParameterLimits list_double2_large_graphic_pane_g1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_large_graphic_pane_g1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_g1_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_large_graphic_pane_g1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_large_graphic_pane_g1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_g1_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_large_graphic_pane_g2_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_large_graphic_pane_g2_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_g2_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_large_graphic_pane_g2_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_large_graphic_pane_g2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_g2_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_double2_large_graphic_pane_g3_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_large_graphic_pane_g3_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_g3_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_large_graphic_pane_t1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_large_graphic_pane_t1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_t1_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double2_large_graphic_pane_t1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_large_graphic_pane_t1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_t1_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_large_graphic_pane_t2_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_large_graphic_pane_t2_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_t2_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double2_large_graphic_pane_t2_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_large_graphic_pane_t2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_t2_cp2)))(aVariety, aCol, aRow); }

// LAF Table : list_double_large_graphic_pane_cp2
inline TAknLayoutScalableParameterLimits list_double_large_graphic_pane_g1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_large_graphic_pane_g1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_g1_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_large_graphic_pane_g1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_large_graphic_pane_g1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_g1_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_large_graphic_pane_g2_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_large_graphic_pane_g2_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_g2_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_large_graphic_pane_g2_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_large_graphic_pane_g2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_g2_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_double_large_graphic_pane_g3_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_large_graphic_pane_g3_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_g3_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_double_large_graphic_pane_g4_cp(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_large_graphic_pane_g4_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_g4_cp)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_large_graphic_pane_t1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_large_graphic_pane_t1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_t1_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_large_graphic_pane_t1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_large_graphic_pane_t1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_t1_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_large_graphic_pane_t2_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_large_graphic_pane_t2_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_t2_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_large_graphic_pane_t2_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_large_graphic_pane_t2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_t2_cp2)))(aVariety, aCol, aRow); }

// LAF Table : list_double2_graphic_pane_cp2
inline TAknLayoutScalableParameterLimits list_double2_graphic_pane_g1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_pane_g1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_g1_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_graphic_pane_g1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_graphic_pane_g1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_g1_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_graphic_pane_g2_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_pane_g2_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_g2_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_graphic_pane_g2_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_graphic_pane_g2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_g2_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_double2_graphic_pane_g3_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_graphic_pane_g3_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_g3_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_graphic_pane_t1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_pane_t1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_t1_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double2_graphic_pane_t1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_graphic_pane_t1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_t1_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_graphic_pane_t2_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_pane_t2_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_t2_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double2_graphic_pane_t2_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_graphic_pane_t2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_t2_cp2)))(aVariety, aCol, aRow); }

// LAF Table : list_single_number_heading_pane_cp2
inline TAknLayoutScalableParameterLimits list_single_number_heading_pane_g1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_number_heading_pane_g1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_g1_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_number_heading_pane_g1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_heading_pane_g1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_g1_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_single_number_heading_pane_g2_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_heading_pane_g2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_g2_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_number_heading_pane_t1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_number_heading_pane_t1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_t1_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_number_heading_pane_t1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_heading_pane_t1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_t1_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_number_heading_pane_t2_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_number_heading_pane_t2_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_t2_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_number_heading_pane_t2_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_heading_pane_t2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_t2_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_number_heading_pane_t3_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_number_heading_pane_t3_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_t3_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_number_heading_pane_t3_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_heading_pane_t3_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_t3_cp2)))(aVariety, aCol, aRow); }

// LAF Table : list_single_heading_pane_cp2
inline TAknLayoutScalableParameterLimits list_single_heading_pane_g1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_heading_pane_g1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_g1_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_heading_pane_g1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_heading_pane_g1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_g1_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_single_heading_pane_g2_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_heading_pane_g2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_g2_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_heading_pane_t1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_heading_pane_t1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_t1_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_heading_pane_t1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_heading_pane_t1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_t1_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_heading_pane_t2_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_heading_pane_t2_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_t2_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_heading_pane_t2_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_heading_pane_t2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_t2_cp2)))(aVariety, aCol, aRow); }

// LAF Table : list_double_graphic_pane_cp2
inline TAknLayoutScalableParameterLimits list_double_graphic_pane_g1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_pane_g1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_g1_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_graphic_pane_g1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_pane_g1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_g1_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_graphic_pane_g2_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_pane_g2_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_g2_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_graphic_pane_g2_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_pane_g2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_g2_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_double_graphic_pane_g3_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_pane_g3_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_g3_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_graphic_pane_t1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_pane_t1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_t1_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_graphic_pane_t1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_pane_t1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_t1_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_graphic_pane_t2_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_pane_t2_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_t2_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_graphic_pane_t2_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_pane_t2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_t2_cp2)))(aVariety, aCol, aRow); }

// LAF Table : list_double_number_pane_cp2
inline TAknLayoutScalableParameterLimits list_double_number_pane_g1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_number_pane_g1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_g1_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_number_pane_g1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_number_pane_g1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_g1_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_double_number_pane_g2_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_number_pane_g2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_g2_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_number_pane_t1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_number_pane_t1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_t1_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_number_pane_t1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_number_pane_t1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_t1_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_number_pane_t2_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_number_pane_t2_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_t2_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_number_pane_t2_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_number_pane_t2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_t2_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_number_pane_t3_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_number_pane_t3_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_t3_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_number_pane_t3_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_number_pane_t3_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_t3_cp2)))(aVariety, aCol, aRow); }

// LAF Table : list_single_graphic_pane_cp2
inline TAknLayoutScalableParameterLimits list_single_graphic_pane_g1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_pane_g1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_g1_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_pane_g1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_pane_g1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_g1_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_pane_g2_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_pane_g2_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_g2_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_pane_g2_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_pane_g2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_g2_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_single_graphic_pane_g3_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_pane_g3_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_g3_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_pane_t1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_pane_t1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_t1_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_graphic_pane_t1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_pane_t1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_t1_cp2)))(aVariety, aCol, aRow); }

// LAF Table : list_single_number_pane_cp2
inline TAknLayoutScalableParameterLimits list_single_number_pane_g1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_number_pane_g1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_pane_g1_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_number_pane_g1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_pane_g1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_pane_g1_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_single_number_pane_g2_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_pane_g2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_pane_g2_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_number_pane_t1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_number_pane_t1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_pane_t1_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_number_pane_t1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_pane_t1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_pane_t1_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_number_pane_t2_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_number_pane_t2_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_pane_t2_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_number_pane_t2_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_pane_t2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_pane_t2_cp2)))(aVariety, aCol, aRow); }

// LAF Table : list_double2_pane_cp2
inline TAknLayoutScalableParameterLimits list_double2_pane_g1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_pane_g1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_g1_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_pane_g1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_pane_g1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_g1_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_double2_pane_g2_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_pane_g2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_g2_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_pane_t1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_pane_t1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_t1_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double2_pane_t1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_pane_t1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_t1_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_pane_t2_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_pane_t2_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_t2_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double2_pane_t2_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_pane_t2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_t2_cp2)))(aVariety, aCol, aRow); }

// LAF Table : list_double_pane_cp2
inline TAknLayoutScalableParameterLimits list_double_pane_g1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_pane_g1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_g1_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_pane_g1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_pane_g1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_g1_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_double_pane_g2_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_pane_g2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_g2_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_pane_t1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_pane_t1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_t1_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_pane_t1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_pane_t1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_t1_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_pane_t2_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_pane_t2_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_t2_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_pane_t2_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_pane_t2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_t2_cp2)))(aVariety, aCol, aRow); }

// LAF Table : list_single_pane_cp2
inline TAknWindowComponentLayout list_single_pane_cp2_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_pane_cp2_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_cp2_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_pane_g1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_pane_g1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_g1_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_pane_g1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_pane_g1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_g1_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_single_pane_g2_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_pane_g2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_g2_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_pane_t1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_pane_t1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_t1_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_pane_t1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_pane_t1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_t1_cp2)))(aVariety, aCol, aRow); }

// LAF Table : list_single_large_graphic_pane_cp2
inline TAknLayoutScalableParameterLimits list_single_large_graphic_pane_g1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_large_graphic_pane_g1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_large_graphic_pane_g1_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_large_graphic_pane_g1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_large_graphic_pane_g1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_large_graphic_pane_g1_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_large_graphic_pane_g2_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_large_graphic_pane_g2_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_large_graphic_pane_g2_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_large_graphic_pane_g2_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_large_graphic_pane_g2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_large_graphic_pane_g2_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_single_large_graphic_pane_g3_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_large_graphic_pane_g3_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_large_graphic_pane_g3_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_large_graphic_pane_g4_cp1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_large_graphic_pane_g4_cp1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_large_graphic_pane_g4_cp1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_large_graphic_pane_g4_cp1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_large_graphic_pane_g4_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_large_graphic_pane_g4_cp1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_large_graphic_pane_t1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_large_graphic_pane_t1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_large_graphic_pane_t1_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_large_graphic_pane_t1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_large_graphic_pane_t1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_large_graphic_pane_t1_cp2)))(aVariety, aCol, aRow); }

// LAF Table : list_single_graphic_heading_pane_cp2
inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_g1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_g1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_g1_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_heading_pane_g1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_g1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_g1_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_g4_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_g4_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_g4_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_heading_pane_g4_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_g4_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_g4_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_single_graphic_heading_pane_g5_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_g5_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_g5_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_t1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_t1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_t1_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_graphic_heading_pane_t1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_t1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_t1_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_t2_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_t2_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_t2_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_graphic_heading_pane_t2_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_t2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_t2_cp2)))(aVariety, aCol, aRow); }

// LAF Table : list_single_2graphic_pane_cp2
inline TAknLayoutScalableParameterLimits list_single_2graphic_pane_g1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_2graphic_pane_g1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g1_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_2graphic_pane_g1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_2graphic_pane_g1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g1_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_2graphic_pane_g2_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_2graphic_pane_g2_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g2_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_2graphic_pane_g2_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_2graphic_pane_g2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g2_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_single_2graphic_pane_g3_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_2graphic_pane_g3_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g3_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_2graphic_pane_g4_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_2graphic_pane_g4_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g4_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_2graphic_pane_g4_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_2graphic_pane_g4_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g4_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_2graphic_pane_t1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_2graphic_pane_t1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_t1_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_2graphic_pane_t1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_2graphic_pane_t1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_t1_cp2)))(aVariety, aCol, aRow); }

// LAF Table : list_highlight_pane_cp1
inline TAknWindowComponentLayout list_highlight_pane_g10_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_g10_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_g10_cp1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_highlight_pane_g1_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_g1_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_g1_cp1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_highlight_pane_g2_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_g2_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_g2_cp1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_highlight_pane_g3_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_g3_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_g3_cp1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_highlight_pane_g4_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_g4_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_g4_cp1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_highlight_pane_g5_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_g5_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_g5_cp1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_highlight_pane_g6_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_g6_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_g6_cp1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_highlight_pane_g7_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_g7_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_g7_cp1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_highlight_pane_g8_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_g8_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_g8_cp1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_highlight_pane_g9_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_g9_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_g9_cp1)))(aVariety, aCol, aRow); }

// LAF Table : slider_cont_pane
inline TAknTextComponentLayout form_field_slider_pane_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_slider_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_pane_t3)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout form_field_slider_pane_t4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_slider_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_pane_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits slider_form_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tslider_form_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_form_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout slider_form_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_form_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_form_pane)))(aVariety, aCol, aRow); }

// LAF Table : misc_graphics
inline TAknWindowComponentLayout control_abbreviations(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_abbreviations_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_abbreviations)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout control_conventions(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_conventions_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_conventions)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout control_definitions(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_definitions_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_definitions)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout format_table_attribute(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tformat_table_attribute_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_format_table_attribute)))(aVariety, aCol, aRow); }

// LAF Table : bg_popup_preview_window_pane
inline TAknWindowComponentLayout bg_popup_preview_window_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_preview_window_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_preview_window_pane_g9)))(aVariety, aCol, aRow); }

// LAF Table : misc_graphics
inline TAknWindowComponentLayout format_table_data2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tformat_table_data2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_format_table_data2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout format_table_data3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tformat_table_data3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_format_table_data3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout format_table_data_example(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tformat_table_data_example_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_format_table_data_example)))(aVariety, aCol, aRow); }

// LAF Table : bg_popup_preview_window_pane
inline TAknLayoutScalableTableLimits bg_popup_preview_window_pane_g_Limits()		{ return (*(Tbg_popup_preview_window_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_preview_window_pane_g_Limits)))(); }

// LAF Table : misc_graphics
inline TAknWindowComponentLayout intro_purpose(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tintro_purpose_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_intro_purpose)))(aVariety, aCol, aRow); }

// LAF Table : bg_popup_preview_window_pane
inline TAknWindowComponentLayout bg_popup_preview_window_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_preview_window_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_preview_window_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : misc_graphics
inline TAknWindowComponentLayout texts_category(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttexts_category_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_texts_category)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout texts_graphics(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttexts_graphics_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_texts_graphics)))(aVariety, aCol, aRow); }

// LAF Table : texts_category
inline TAknTextComponentLayout text_digital(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttext_digital_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_text_digital)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout text_primary(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttext_primary_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_text_primary)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout text_primary_small(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttext_primary_small_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_text_primary_small)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout text_secondary(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttext_secondary_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_text_secondary)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout text_title(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttext_title_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_text_title)))(aVariety, aCol, aRow); }

// LAF Table : bg_passive_tab_pane_cp3_srt
inline TAknWindowComponentLayout bg_passive_tab_pane_g1_cp3_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g1_cp3_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g1_cp3_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_passive_tab_pane_g2_cp3_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g2_cp3_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g2_cp3_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_passive_tab_pane_g3_cp3_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g3_cp3_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g3_cp3_srt)))(aVariety, aCol, aRow); }

// LAF Table : tabs_4_active_pane_srt
inline TAknLayoutScalableParameterLimits bg_active_tab_pane_cp3_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_active_tab_pane_cp3_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_cp3_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_active_tab_pane_cp3_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_cp3_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_cp3_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout tabs_4_active_pane_srt_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_4_active_pane_srt_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_active_pane_srt_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits tabs_4_active_pane_srt_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_4_active_pane_srt_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_active_pane_srt_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout tabs_4_active_pane_srt_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_4_active_pane_srt_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_active_pane_srt_t1)))(aVariety, aCol, aRow); }

// LAF Table : bg_active_tab_pane_cp3_srt
inline TAknWindowComponentLayout bg_active_tab_pane_g1_cp3_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g1_cp3_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g1_cp3_copy1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_active_tab_pane_g2_cp3_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g2_cp3_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g2_cp3_copy1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_active_tab_pane_g3_cp3_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g3_cp3_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g3_cp3_copy1)))(aVariety, aCol, aRow); }

// LAF Table : navi_tabs_2_long_pane_srt
inline TAknLayoutScalableParameterLimits tabs_2_long_active_pane_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_2_long_active_pane_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_long_active_pane_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_2_long_active_pane_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_2_long_active_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_long_active_pane_srt)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits tabs_2_long_passive_pane_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_2_long_passive_pane_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_long_passive_pane_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_2_long_passive_pane_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_2_long_passive_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_long_passive_pane_srt)))(aVariety, aCol, aRow); }

// LAF Table : tabs_2_long_passive_pane_srt
inline TAknLayoutScalableParameterLimits bg_passive_tab_pane_cp4_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_passive_tab_pane_cp4_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_cp4_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_passive_tab_pane_cp4_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_cp4_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_cp4_srt)))(aVariety, aCol, aRow); }

// LAF Table : bg_passive_tab_pane_cp4_srt
inline TAknWindowComponentLayout bg_passive_tab_pane_g1_cp4_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g1_cp4_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g1_cp4_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_passive_tab_pane_g2_cp4_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g2_cp4_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g2_cp4_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_passive_tab_pane_g3_cp4_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g3_cp4_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g3_cp4_srt)))(aVariety, aCol, aRow); }

// LAF Table : tabs_2_long_active_pane_srt
inline TAknLayoutScalableParameterLimits bg_active_tab_pane_cp4_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_active_tab_pane_cp4_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_cp4_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_active_tab_pane_cp4_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_cp4_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_cp4_srt)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits tabs_2_long_active_pane_srt_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_2_long_active_pane_srt_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_long_active_pane_srt_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout tabs_2_long_active_pane_srt_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_2_long_active_pane_srt_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_long_active_pane_srt_t1)))(aVariety, aCol, aRow); }

// LAF Table : bg_active_tab_pane_cp4_srt
inline TAknWindowComponentLayout bg_active_tab_pane_g1_cp4_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g1_cp4_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g1_cp4_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_active_tab_pane_g2_cp4_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g2_cp4_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g2_cp4_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_active_tab_pane_g3_cp4_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g3_cp4_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g3_cp4_srt)))(aVariety, aCol, aRow); }

// LAF Table : navi_tabs_3_long_pane_srt
inline TAknLayoutScalableParameterLimits tabs_3_long_active_pane_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_3_long_active_pane_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_long_active_pane_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_3_long_active_pane_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_3_long_active_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_long_active_pane_srt)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits tabs_3_long_passive_pane_cp_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_3_long_passive_pane_cp_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_long_passive_pane_cp_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_3_long_passive_pane_cp_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_3_long_passive_pane_cp_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_long_passive_pane_cp_srt)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits tabs_3_long_passive_pane_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_3_long_passive_pane_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_long_passive_pane_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_3_long_passive_pane_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_3_long_passive_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_long_passive_pane_srt)))(aVariety, aCol, aRow); }

// LAF Table : tabs_3_long_passive_pane_srt
inline TAknLayoutScalableParameterLimits bg_passive_tab_pane_cp5_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_passive_tab_pane_cp5_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_cp5_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_passive_tab_pane_cp5_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_cp5_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_cp5_srt)))(aVariety, aCol, aRow); }

// LAF Table : bg_passive_tab_pane_cp5_srt
inline TAknWindowComponentLayout bg_passive_tab_pane_g1_cp5_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g1_cp5_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g1_cp5_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_passive_tab_pane_g2_cp5_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g2_cp5_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g2_cp5_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_passive_tab_pane_g3_cp5_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g3_cp5_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g3_cp5_srt)))(aVariety, aCol, aRow); }

// LAF Table : tabs_3_long_active_pane_srt
inline TAknLayoutScalableParameterLimits bg_active_tab_pane_cp5_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_active_tab_pane_cp5_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_cp5_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_active_tab_pane_cp5_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_cp5_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_cp5_srt)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits tabs_3_long_active_pane_srt_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_3_long_active_pane_srt_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_long_active_pane_srt_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout tabs_3_long_active_pane_srt_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_3_long_active_pane_srt_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_long_active_pane_srt_t1)))(aVariety, aCol, aRow); }

// LAF Table : bg_active_tab_pane_cp5_srt
inline TAknWindowComponentLayout bg_active_tab_pane_g1_cp5_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g1_cp5_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g1_cp5_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_active_tab_pane_g2_cp5_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g2_cp5_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g2_cp5_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_active_tab_pane_g3_cp5_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g3_cp5_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g3_cp5_srt)))(aVariety, aCol, aRow); }

// LAF Table : navi_text_pane_srt
inline TAknTextComponentLayout navi_text_pane_srt_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_text_pane_srt_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_text_pane_srt_t1)))(aVariety, aCol, aRow); }

// LAF Table : navi_icon_pane_srt
inline TAknWindowComponentLayout navi_icon_pane_srt_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_icon_pane_srt_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_icon_pane_srt_g1)))(aVariety, aCol, aRow); }

// LAF Table : navi_midp_pane_srt
inline TAknWindowComponentLayout midp_editing_number_pane_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmidp_editing_number_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_editing_number_pane_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout midp_ticker_pane_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmidp_ticker_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_ticker_pane_srt)))(aVariety, aCol, aRow); }

// LAF Table : midp_ticker_pane_srt
inline TAknWindowComponentLayout midp_ticker_pane_srt_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmidp_ticker_pane_srt_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_ticker_pane_srt_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout midp_ticker_pane_srt_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmidp_ticker_pane_srt_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_ticker_pane_srt_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits midp_ticker_pane_srt_g_Limits()		{ return (*(Tmidp_ticker_pane_srt_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_ticker_pane_srt_g_Limits)))(); }

inline TAknWindowComponentLayout midp_ticker_pane_srt_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmidp_ticker_pane_srt_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_ticker_pane_srt_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout midp_ticker_pane_srt_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmidp_ticker_pane_srt_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_ticker_pane_srt_t1)))(aVariety, aCol, aRow); }

// LAF Table : midp_editing_number_pane_srt
inline TAknTextComponentLayout midp_editing_number_pane_t1_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmidp_editing_number_pane_t1_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_editing_number_pane_t1_copy1)))(aVariety, aCol, aRow); }

// LAF Table : main_midp_pane
inline TAknWindowComponentLayout listscroll_midp_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_midp_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_midp_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout midp_form_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmidp_form_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_form_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits midp_info_popup_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tmidp_info_popup_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_info_popup_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout midp_info_popup_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmidp_info_popup_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_info_popup_window)))(aVariety, aCol, aRow); }

// LAF Table : midp_info_popup_window
inline TAknLayoutScalableParameterLimits bg_popup_sub_pane_cp50_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_sub_pane_cp50_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp50_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_sub_pane_cp50(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp50_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp50)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits listscroll_midp_info_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlistscroll_midp_info_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_midp_info_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout listscroll_midp_info_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_midp_info_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_midp_info_pane)))(aVariety, aCol, aRow); }

// LAF Table : midp_form_pane
inline TAknLayoutScalableParameterLimits listscroll_form_midp_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlistscroll_form_midp_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_form_midp_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout listscroll_form_midp_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_form_midp_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_form_midp_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_bar_cp050(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_bar_cp050_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_bar_cp050)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_midp_pane
inline TAknWindowComponentLayout list_midp_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_midp_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_midp_pane)))(aVariety, aCol, aRow); }

// LAF Table : midp_canvas_pane
inline TAknWindowComponentLayout signal_pane_g2_cp(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsignal_pane_g2_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_signal_pane_g2_cp)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_midp_info_pane
inline TAknLayoutScalableParameterLimits listscroll_midp_info_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlistscroll_midp_info_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_midp_info_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout listscroll_midp_info_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_midp_info_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_midp_info_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits listscroll_midp_info_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlistscroll_midp_info_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_midp_info_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout listscroll_midp_info_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_midp_info_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_midp_info_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits listscroll_midp_info_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlistscroll_midp_info_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_midp_info_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout listscroll_midp_info_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_midp_info_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_midp_info_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits listscroll_midp_info_pane_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tlistscroll_midp_info_pane_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_midp_info_pane_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout listscroll_midp_info_pane_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_midp_info_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_midp_info_pane_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits listscroll_midp_info_pane_t_Limits()		{ return (*(Tlistscroll_midp_info_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_midp_info_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits listscroll_midp_info_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlistscroll_midp_info_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_midp_info_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout listscroll_midp_info_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_midp_info_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_midp_info_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp21(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp21_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp21)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_form_midp_pane
inline TAknWindowComponentLayout form_midp_field_choice_group_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_midp_field_choice_group_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_field_choice_group_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout form_midp_field_text_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_midp_field_text_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_field_text_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout form_midp_field_time_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_midp_field_time_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_field_time_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout form_midp_gauge_slider_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_midp_gauge_slider_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_gauge_slider_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout form_midp_gauge_wait_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_midp_gauge_wait_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_gauge_wait_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout form_midp_image_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_midp_image_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_image_pane)))(aVariety, aCol, aRow); }

// LAF Table : list_midp_pane
inline TAknLayoutScalableParameterLimits list_single_midp_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_midp_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_midp_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_midp_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_midp_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_midp_pane)))(aRow, aVariety, aCol); }

// LAF Table : form_midp_field_text_pane
inline TAknTextComponentLayout form_midp_field_text_pane_t1(TInt aVariety, TInt aRow = 0, TInt aCol = 0)		{ return (*(Tform_midp_field_text_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_field_text_pane_t1)))(aVariety, aRow, aCol); }

inline TAknWindowComponentLayout input_focus_pane_cp050(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp050_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp050)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_midp_form_text_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_midp_form_text_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_midp_form_text_pane)))(aVariety, aCol, aRow); }

// LAF Table : form_midp_field_choice_group_pane
inline TAknTextComponentLayout form_midp_field_choice_group_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_midp_field_choice_group_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_field_choice_group_pane_t1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_cp051(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp051_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp051)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_midp_choice_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_midp_choice_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_midp_choice_pane)))(aVariety, aCol, aRow); }

// LAF Table : area_top_pane
inline TAknWindowComponentLayout status_idle_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_idle_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_idle_pane)))(aVariety, aCol, aRow); }

// LAF Table : form_midp_field_time_pane
inline TAknTextComponentLayout form_midp_field_time_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_midp_field_time_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_field_time_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : wait_anim_pane_copy1
inline TAknWindowComponentLayout wait_anim_pane_g2_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twait_anim_pane_g2_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_anim_pane_g2_copy1)))(aVariety, aCol, aRow); }

// LAF Table : form_midp_field_time_pane
inline TAknTextComponentLayout form_midp_field_time_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_midp_field_time_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_field_time_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits form_midp_field_time_pane_t_Limits()		{ return (*(Tform_midp_field_time_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_field_time_pane_t_Limits)))(); }

// LAF Table : aid_navinavi_width_pane
inline TAknWindowComponentLayout aid_navinavi_width_2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_navinavi_width_2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_navinavi_width_2_pane)))(aVariety, aCol, aRow); }

// LAF Table : form_midp_field_time_pane
inline TAknTextComponentLayout form_midp_field_time_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_midp_field_time_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_field_time_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_cp052(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp052_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp052)))(aVariety, aCol, aRow); }

// LAF Table : form_midp_gauge_slider_pane
inline TAknWindowComponentLayout bg_input_focus_pane_cp040(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_input_focus_pane_cp040_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_input_focus_pane_cp040)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout form_midp_gauge_slider_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_midp_gauge_slider_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_gauge_slider_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout form_midp_gauge_slider_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_midp_gauge_slider_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_gauge_slider_pane_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout form_midp_gauge_slider_pane_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_midp_gauge_slider_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_gauge_slider_pane_t3)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout form_midp_gauge_slider_pane_t4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_midp_gauge_slider_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_gauge_slider_pane_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits form_midp_gauge_slider_pane_t_Limits()		{ return (*(Tform_midp_gauge_slider_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_gauge_slider_pane_t_Limits)))(); }

inline TAknTextComponentLayout form_midp_gauge_slider_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_midp_gauge_slider_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_gauge_slider_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout form_midp_slider_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_midp_slider_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_slider_pane)))(aVariety, aCol, aRow); }

// LAF Table : form_midp_gauge_wait_pane
inline TAknLayoutScalableParameterLimits bg_input_focus_pane_cp041_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_input_focus_pane_cp041_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_input_focus_pane_cp041_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_input_focus_pane_cp041(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_input_focus_pane_cp041_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_input_focus_pane_cp041)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_midp_gauge_wait_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_midp_gauge_wait_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_gauge_wait_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout form_midp_gauge_wait_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_midp_gauge_wait_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_gauge_wait_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_midp_gauge_wait_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_midp_gauge_wait_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_gauge_wait_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout form_midp_gauge_wait_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_midp_gauge_wait_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_gauge_wait_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits form_midp_gauge_wait_pane_t_Limits()		{ return (*(Tform_midp_gauge_wait_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_gauge_wait_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits form_midp_gauge_wait_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tform_midp_gauge_wait_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_gauge_wait_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout form_midp_gauge_wait_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_midp_gauge_wait_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_gauge_wait_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_midp_wait_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_midp_wait_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_wait_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout form_midp_wait_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_midp_wait_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_wait_pane)))(aVariety, aCol, aRow); }

// LAF Table : form_midp_image_pane
inline TAknWindowComponentLayout form_midp_image_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_midp_image_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_image_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout form_midp_image_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_midp_image_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_image_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout form_midp_image_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_midp_image_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_image_pane_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout form_midp_image_pane_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_midp_image_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_image_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits form_midp_image_pane_t_Limits()		{ return (*(Tform_midp_image_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_image_pane_t_Limits)))(); }

inline TAknTextComponentLayout form_midp_image_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_midp_image_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_image_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_single_midp_pane
inline TAknWindowComponentLayout list_single_midp_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_midp_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_midp_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout list_single_midp_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_midp_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_midp_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : list_midp_form_text_pane
inline TAknLayoutScalableParameterLimits list_midp_form_item_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_midp_form_item_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_midp_form_item_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_midp_form_item_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_midp_form_item_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_midp_form_item_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_midp_form_item_pane
inline TAknTextComponentLayout list_midp_form_item_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_midp_form_item_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_midp_form_item_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : midp_ticker_pane
inline TAknWindowComponentLayout midp_ticker_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmidp_ticker_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_ticker_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout midp_ticker_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmidp_ticker_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_ticker_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits midp_ticker_pane_g_Limits()		{ return (*(Tmidp_ticker_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_ticker_pane_g_Limits)))(); }

inline TAknWindowComponentLayout midp_ticker_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmidp_ticker_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_ticker_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout midp_ticker_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmidp_ticker_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_ticker_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : midp_editing_number_pane
inline TAknTextComponentLayout midp_editing_number_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmidp_editing_number_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_editing_number_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : navi_midp_pane
inline TAknWindowComponentLayout midp_editing_number_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmidp_editing_number_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_editing_number_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout midp_ticker_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmidp_ticker_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_ticker_pane)))(aVariety, aCol, aRow); }

// LAF Table : popup_ai_message_window
inline TAknWindowComponentLayout ai_message_heading_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai_message_heading_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_message_heading_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_window_pane_cp14(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp14_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp14)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout listscroll_ai_message_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_ai_message_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_ai_message_pane)))(aVariety, aCol, aRow); }

// LAF Table : ai_message_heading_pane
inline TAknLayoutScalableParameterLimits ai_message_heading_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tai_message_heading_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_message_heading_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout ai_message_heading_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai_message_heading_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_message_heading_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits ai_message_heading_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tai_message_heading_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_message_heading_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout ai_message_heading_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai_message_heading_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_message_heading_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits ai_message_heading_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tai_message_heading_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_message_heading_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout ai_message_heading_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai_message_heading_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_message_heading_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits ai_message_heading_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tai_message_heading_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_message_heading_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout ai_message_heading_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai_message_heading_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_message_heading_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits ai_message_heading_pane_g_Limits()		{ return (*(Tai_message_heading_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_message_heading_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits ai_message_heading_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tai_message_heading_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_message_heading_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout ai_message_heading_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai_message_heading_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_message_heading_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits ai_message_heading_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tai_message_heading_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_message_heading_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout ai_message_heading_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai_message_heading_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_message_heading_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits ai_message_heading_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tai_message_heading_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_message_heading_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout ai_message_heading_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai_message_heading_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_message_heading_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits ai_message_heading_pane_t_Limits()		{ return (*(Tai_message_heading_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_message_heading_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits ai_message_heading_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tai_message_heading_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_message_heading_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout ai_message_heading_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai_message_heading_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_message_heading_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits bg_popup_heading_pane_cp1_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_heading_pane_cp1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_heading_pane_cp1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_heading_pane_cp1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_heading_pane_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_heading_pane_cp1)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_ai_message_pane
inline TAknLayoutScalableParameterLimits list_ai_message_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_ai_message_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_ai_message_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_ai_message_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_ai_message_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_ai_message_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp10(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp10)))(aVariety, aCol, aRow); }

// LAF Table : list_ai_message_pane
inline TAknWindowComponentLayout list_ai_message_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_ai_message_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_ai_message_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_ai_message_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_ai_message_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_ai_message_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_ai_message_pane_g_Limits()		{ return (*(Tlist_ai_message_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_ai_message_pane_g_Limits)))(); }

inline TAknWindowComponentLayout list_ai_message_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_ai_message_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_ai_message_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_ai_message_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_ai_message_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_ai_message_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_ai_message_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_ai_message_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_ai_message_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_ai_message_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_ai_message_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_ai_message_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_ai_message_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_ai_message_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_ai_message_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_ai_message_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_ai_message_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_ai_message_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_ai_message_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_ai_message_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_ai_message_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_ai_message_pane_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_ai_message_pane_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_ai_message_pane_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_ai_message_pane_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_ai_message_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_ai_message_pane_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_ai_message_pane_t_Limits()		{ return (*(Tlist_ai_message_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_ai_message_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_ai_message_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_ai_message_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_ai_message_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_ai_message_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_ai_message_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_ai_message_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : grid_ai_soft_ind_pane
inline TAknLayoutScalableParameterLimits cell_ai_soft_ind_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_ai_soft_ind_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_ai_soft_ind_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_ai_soft_ind_pane(TInt aCol, TInt aVariety = 0, TInt aRow = 0)		{ return (*(Tcell_ai_soft_ind_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_ai_soft_ind_pane)))(aCol, aVariety, aRow); }

// LAF Table : cell_ai_soft_ind_pane
inline TAknLayoutScalableParameterLimits cell_ai_soft_ind_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_ai_soft_ind_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_ai_soft_ind_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_ai_soft_ind_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_ai_soft_ind_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_ai_soft_ind_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_highlight_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_cp1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits text_secondary_cp56_ParamLimits(TInt aVariety = 0)		{ return (*(Ttext_secondary_cp56_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_text_secondary_cp56_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout text_secondary_cp56(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttext_secondary_cp56_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_text_secondary_cp56)))(aVariety, aCol, aRow); }

// LAF Table : format_table_data_example
inline TAknLayoutScalableParameterLimits example_general_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Texample_general_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_example_general_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout example_general_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Texample_general_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_example_general_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits example_parent_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Texample_parent_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_example_parent_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout example_parent_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Texample_parent_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_example_parent_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits example_parent_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Texample_parent_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_example_parent_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout example_parent_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Texample_parent_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_example_parent_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknLayoutScalableParameterLimits popup_preview_text_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_preview_text_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_text_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_preview_text_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_preview_text_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_text_window)))(aVariety, aCol, aRow); }

// LAF Table : list_single_pane_cp2
inline TAknWindowComponentLayout list_single_pane_cp2_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_pane_cp2_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_cp2_g4)))(aVariety, aCol, aRow); }

// LAF Table : popup_preview_text_window
inline TAknLayoutScalableParameterLimits bg_popup_preview_window_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_preview_window_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_preview_window_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_preview_window_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_preview_window_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_preview_window_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_preview_text_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_preview_text_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_text_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_preview_text_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_preview_text_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_text_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_preview_text_window_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_preview_text_window_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_text_window_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_preview_text_window_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_preview_text_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_text_window_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_preview_text_window_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_preview_text_window_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_text_window_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_preview_text_window_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_preview_text_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_text_window_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_preview_text_window_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_preview_text_window_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_text_window_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_preview_text_window_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_preview_text_window_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_text_window_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_preview_text_window_t_Limits()		{ return (*(Tpopup_preview_text_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_text_window_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_preview_text_window_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_preview_text_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_text_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_preview_text_window_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_preview_text_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_text_window_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp11(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp11_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp11)))(aVariety, aCol, aRow); }

// LAF Table : bg_popup_preview_window_pane
inline TAknWindowComponentLayout bg_popup_preview_window_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_preview_window_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_preview_window_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_preview_window_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_preview_window_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_preview_window_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_preview_window_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_preview_window_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_preview_window_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_preview_window_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_preview_window_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_preview_window_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_preview_window_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_preview_window_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_preview_window_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_preview_window_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_preview_window_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_preview_window_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_preview_window_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_preview_window_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_preview_window_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_preview_window_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_preview_window_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_preview_window_pane_g8)))(aVariety, aCol, aRow); }

// LAF Table : application_window
inline TAknWindowComponentLayout aid_popup_width_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_popup_width_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_popup_width_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknLayoutScalableParameterLimits popup_midp_note_alarm_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_midp_note_alarm_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_midp_note_alarm_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_midp_note_alarm_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window)))(aVariety, aCol, aRow); }

// LAF Table : form_field_data_pane
inline TAknLayoutScalableParameterLimits data_form_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tdata_form_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_data_form_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout form_field_data_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_data_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_data_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_field_data_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_data_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_data_pane_t1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits input_focus_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tinput_focus_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_ParamLimits)))(aVariety); }

// LAF Table : form_field_data_wide_pane
inline TAknLayoutScalableParameterLimits data_form_wide_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tdata_form_wide_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_data_form_wide_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout form_field_data_wide_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_data_wide_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_data_wide_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_field_data_wide_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_data_wide_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_data_wide_pane_t1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits input_focus_pane_cp6_ParamLimits(TInt aVariety = 0)		{ return (*(Tinput_focus_pane_cp6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp6_ParamLimits)))(aVariety); }

// LAF Table : input_popup_find_pane_cp
inline TAknLayoutScalableParameterLimits input_popup_find_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tinput_popup_find_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_popup_find_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout input_popup_find_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_popup_find_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_popup_find_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : navi_pane_stacon
inline TAknWindowComponentLayout aid_navi_side_left_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_navi_side_left_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_navi_side_left_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout aid_navi_side_right_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_navi_side_right_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_navi_side_right_pane)))(aVariety, aCol, aRow); }

// LAF Table : popup_midp_note_alarm_window
inline TAknLayoutScalableParameterLimits bg_popup_window_pane_cp30_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_cp30_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp30_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_cp30(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp30_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp30)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_midp_note_alarm_window_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_midp_note_alarm_window_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_midp_note_alarm_window_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_midp_note_alarm_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_midp_note_alarm_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_midp_note_alarm_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_midp_note_alarm_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_midp_note_alarm_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_midp_note_alarm_window_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_midp_note_alarm_window_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_midp_note_alarm_window_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_midp_note_alarm_window_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_midp_note_alarm_window_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_midp_note_alarm_window_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_midp_note_alarm_window_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_midp_note_alarm_window_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_midp_note_alarm_window_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_midp_note_alarm_window_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_midp_note_alarm_window_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_midp_note_alarm_window_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_midp_note_alarm_window_t5_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_midp_note_alarm_window_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_t5_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_midp_note_alarm_window_t5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_midp_note_alarm_window_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_t5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_midp_note_alarm_window_t_Limits()		{ return (*(Tpopup_midp_note_alarm_window_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_midp_note_alarm_window_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_midp_note_alarm_window_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout popup_midp_note_alarm_window_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_midp_note_alarm_window_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits wait_bar_pane_cp1_ParamLimits(TInt aVariety = 0)		{ return (*(Twait_bar_pane_cp1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_bar_pane_cp1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout wait_bar_pane_cp1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twait_bar_pane_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_bar_pane_cp1)))(aVariety, aCol, aRow); }

// LAF Table : wait_bar_pane_cp1
inline TAknWindowComponentLayout wait_anim_pane_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twait_anim_pane_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_anim_pane_copy1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout wait_border_pane_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twait_border_pane_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_border_pane_copy1)))(aVariety, aCol, aRow); }

// LAF Table : wait_border_pane_copy1
inline TAknWindowComponentLayout wait_border_pane_g1_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twait_border_pane_g1_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_border_pane_g1_copy1)))(aVariety, aCol, aRow); }

// LAF Table : form_field_popup_pane
inline TAknWindowComponentLayout form_field_popup_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_popup_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_popup_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_field_popup_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_popup_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_popup_pane_t1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits input_focus_pane_cp7_ParamLimits(TInt aVariety = 0)		{ return (*(Tinput_focus_pane_cp7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp7_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits list_form_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_form_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_form_pane_ParamLimits)))(aVariety); }

// LAF Table : form_field_popup_wide_pane
inline TAknWindowComponentLayout form_field_popup_wide_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_popup_wide_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_popup_wide_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_field_popup_wide_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_popup_wide_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_popup_wide_pane_t1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits input_focus_pane_cp8_ParamLimits(TInt aVariety = 0)		{ return (*(Tinput_focus_pane_cp8_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp8_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits list_form_wide_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_form_wide_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_form_wide_pane_ParamLimits)))(aVariety); }

// LAF Table : listscroll_popup_graphic_pane
inline TAknWindowComponentLayout aid_size_cell_graphic_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_graphic_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_graphic_pane)))(aVariety, aCol, aRow); }

// LAF Table : data_form_pane
inline TAknLayoutScalableParameterLimits data_form_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tdata_form_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_data_form_pane_t1_ParamLimits)))(aVariety); }

// LAF Table : data_form_wide_pane
inline TAknLayoutScalableParameterLimits data_form_wide_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tdata_form_wide_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_data_form_wide_pane_t1_ParamLimits)))(aVariety); }

// LAF Table : status_pane
inline TAknWindowComponentLayout bg_status_flat_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_status_flat_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_status_flat_pane)))(aVariety, aCol, aRow); }

// LAF Table : title_pane
inline TAknLayoutScalableParameterLimits title_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Ttitle_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_t1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits title_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Ttitle_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_t2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits title_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Ttitle_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_t3_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits title_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Ttitle_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_t_ParamLimits)))(aLineIndex, aVariety); }

// LAF Table : aid_levels_signal
inline TAknLayoutScalableParameterLimits level_1_signal_ParamLimits(TInt aVariety = 0)		{ return (*(Tlevel_1_signal_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_1_signal_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits level_2_signal_ParamLimits(TInt aVariety = 0)		{ return (*(Tlevel_2_signal_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_2_signal_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits level_3_signal_ParamLimits(TInt aVariety = 0)		{ return (*(Tlevel_3_signal_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_3_signal_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits level_4_signal_ParamLimits(TInt aVariety = 0)		{ return (*(Tlevel_4_signal_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_4_signal_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits level_5_signal_ParamLimits(TInt aVariety = 0)		{ return (*(Tlevel_5_signal_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_5_signal_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits level_6_signal_ParamLimits(TInt aVariety = 0)		{ return (*(Tlevel_6_signal_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_6_signal_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits level_7_signal_ParamLimits(TInt aVariety = 0)		{ return (*(Tlevel_7_signal_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_7_signal_ParamLimits)))(aVariety); }

// LAF Table : aid_levels_battery
inline TAknLayoutScalableParameterLimits level_1_battery_ParamLimits(TInt aVariety = 0)		{ return (*(Tlevel_1_battery_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_1_battery_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits level_2_battery_ParamLimits(TInt aVariety = 0)		{ return (*(Tlevel_2_battery_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_2_battery_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits level_3_battery_ParamLimits(TInt aVariety = 0)		{ return (*(Tlevel_3_battery_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_3_battery_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits level_4_battery_ParamLimits(TInt aVariety = 0)		{ return (*(Tlevel_4_battery_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_4_battery_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits level_5_battery_ParamLimits(TInt aVariety = 0)		{ return (*(Tlevel_5_battery_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_5_battery_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits level_6_battery_ParamLimits(TInt aVariety = 0)		{ return (*(Tlevel_6_battery_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_6_battery_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits level_7_battery_ParamLimits(TInt aVariety = 0)		{ return (*(Tlevel_7_battery_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_level_7_battery_ParamLimits)))(aVariety); }

// LAF Table : bg_status_flat_pane
inline TAknWindowComponentLayout bg_status_flat_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_status_flat_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_status_flat_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_status_flat_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_status_flat_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_status_flat_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_status_flat_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_status_flat_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_status_flat_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_status_flat_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_status_flat_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_status_flat_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_status_flat_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_status_flat_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_status_flat_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_status_flat_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_status_flat_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_status_flat_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_status_flat_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_status_flat_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_status_flat_pane_g7)))(aVariety, aCol, aRow); }

// LAF Table : tabs_3_active_pane
inline TAknLayoutScalableParameterLimits tabs_3_active_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_3_active_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_active_pane_t1_ParamLimits)))(aVariety); }

// LAF Table : tabs_3_passive_pane
inline TAknLayoutScalableParameterLimits tabs_3_passive_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_3_passive_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_passive_pane_t1_ParamLimits)))(aVariety); }

// LAF Table : tabs_4_active_pane
inline TAknLayoutScalableParameterLimits tabs_4_active_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_4_active_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_active_pane_t1_ParamLimits)))(aVariety); }

// LAF Table : tabs_4_passive_pane
inline TAknLayoutScalableParameterLimits tabs_4_1_passive_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_4_1_passive_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_1_passive_pane_t1_ParamLimits)))(aVariety); }

// LAF Table : tabs_2_active_pane
inline TAknLayoutScalableParameterLimits tabs_2_active_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_2_active_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_active_pane_t1_ParamLimits)))(aVariety); }

// LAF Table : tabs_2_passive_pane
inline TAknLayoutScalableParameterLimits tabs_2_passive_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_2_passive_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_passive_pane_t1_ParamLimits)))(aVariety); }

// LAF Table : tabs_2_long_active_pane
inline TAknLayoutScalableParameterLimits bg_active_tab_pane_cp4_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_active_tab_pane_cp4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_cp4_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits tabs_2_long_active_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_2_long_active_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_long_active_pane_t1_ParamLimits)))(aVariety); }

// LAF Table : tabs_2_long_passive_pane
inline TAknLayoutScalableParameterLimits bg_passive_tab_pane_cp4_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_passive_tab_pane_cp4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_cp4_ParamLimits)))(aVariety); }

// LAF Table : list_single_midp_graphic_pane
inline TAknLayoutScalableParameterLimits list_single_midp_graphic_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_midp_graphic_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_midp_graphic_pane_t1_ParamLimits)))(aVariety); }

// LAF Table : tabs_3_long_active_pane
inline TAknLayoutScalableParameterLimits bg_active_tab_pane_cp5_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_active_tab_pane_cp5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_cp5_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits tabs_3_long_active_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_3_long_active_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_long_active_pane_t1_ParamLimits)))(aVariety); }

// LAF Table : tabs_3_long_passive_pane
inline TAknLayoutScalableParameterLimits bg_passive_tab_pane_cp5_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_passive_tab_pane_cp5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_cp5_ParamLimits)))(aVariety); }

// LAF Table : list_single_midp_graphic_pane
inline TAknTextComponentLayout list_single_midp_graphic_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_midp_graphic_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_midp_graphic_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : status_pane
inline TAknLayoutScalableParameterLimits bg_status_flat_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_status_flat_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_status_flat_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits indicator_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tindicator_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_indicator_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout indicator_pane_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tindicator_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_indicator_pane_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits navi_pane_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Tnavi_pane_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout navi_pane_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_pane_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_clock_digital_analogue_window_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_digital_analogue_window_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_digital_analogue_window_cp1)))(aVariety, aCol, aRow); }

// LAF Table : indicator_pane
inline TAknTextComponentLayout indicator_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tindicator_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_indicator_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : texts_graphics
inline TAknWindowComponentLayout copy_highlight_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcopy_highlight_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_copy_highlight_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cursor_graphics_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcursor_graphics_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cursor_graphics_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout graphic_within_text_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgraphic_within_text_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_within_text_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout link_highlight_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlink_highlight_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_link_highlight_pane)))(aVariety, aCol, aRow); }

// LAF Table : popup_preview_text_window
inline TAknLayoutScalableParameterLimits popup_preview_text_window_t5_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_preview_text_window_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_text_window_t5_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_preview_text_window_t5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_preview_text_window_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_text_window_t5)))(aVariety, aCol, aRow); }

// LAF Table : cursor_graphics_pane
inline TAknWindowComponentLayout cursor_digital_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcursor_digital_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cursor_digital_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cursor_primary_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcursor_primary_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cursor_primary_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cursor_primary_small_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcursor_primary_small_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cursor_primary_small_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cursor_secondary_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcursor_secondary_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cursor_secondary_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cursor_title_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcursor_title_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cursor_title_pane)))(aVariety, aCol, aRow); }

// LAF Table : link_highlight_pane
inline TAknWindowComponentLayout link_highlight_digital_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlink_highlight_digital_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_link_highlight_digital_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout link_highlight_primary_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlink_highlight_primary_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_link_highlight_primary_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout link_highlight_primary_small_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlink_highlight_primary_small_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_link_highlight_primary_small_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout link_highlight_secondary_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlink_highlight_secondary_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_link_highlight_secondary_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout link_highlight_title_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlink_highlight_title_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_link_highlight_title_pane)))(aVariety, aCol, aRow); }

// LAF Table : copy_highlight_pane
inline TAknWindowComponentLayout copy_highlight_digital_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcopy_highlight_digital_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_copy_highlight_digital_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout copy_highlight_primary_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcopy_highlight_primary_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_copy_highlight_primary_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout copy_highlight_primary_small_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcopy_highlight_primary_small_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_copy_highlight_primary_small_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout copy_highlight_secondary_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcopy_highlight_secondary_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_copy_highlight_secondary_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout copy_highlight_title_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcopy_highlight_title_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_copy_highlight_title_pane)))(aVariety, aCol, aRow); }

// LAF Table : graphic_within_text_pane
inline TAknWindowComponentLayout graphic_text_digital_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgraphic_text_digital_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_digital_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout graphic_text_primary_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgraphic_text_primary_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_primary_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout graphic_text_primary_small_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgraphic_text_primary_small_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_primary_small_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout graphic_text_secondary_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgraphic_text_secondary_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_secondary_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout graphic_text_title_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgraphic_text_title_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_title_pane)))(aVariety, aCol, aRow); }

// LAF Table : cursor_primary_pane
inline TAknWindowComponentLayout cursor_primary_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcursor_primary_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cursor_primary_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cursor_text_primary_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcursor_text_primary_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cursor_text_primary_t1)))(aVariety, aCol, aRow); }

// LAF Table : cursor_primary_small_pane
inline TAknWindowComponentLayout cursor_primary_small_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcursor_primary_small_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cursor_primary_small_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cursor_text_primary_small_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcursor_text_primary_small_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cursor_text_primary_small_t1)))(aVariety, aCol, aRow); }

// LAF Table : cursor_secondary_pane
inline TAknWindowComponentLayout cursor_primary_small_pane_g1_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcursor_primary_small_pane_g1_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cursor_primary_small_pane_g1_copy1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cursor_text_primary_small_t1_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcursor_text_primary_small_t1_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cursor_text_primary_small_t1_copy1)))(aVariety, aCol, aRow); }

// LAF Table : cursor_title_pane
inline TAknTextComponentLayout cursor_text_title_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcursor_text_title_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cursor_text_title_t1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cursor_title_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcursor_title_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cursor_title_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : cursor_digital_pane
inline TAknWindowComponentLayout cursor_digital_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcursor_digital_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cursor_digital_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cursor_text_digital_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcursor_text_digital_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cursor_text_digital_t1)))(aVariety, aCol, aRow); }

// LAF Table : link_highlight_primary_pane
inline TAknWindowComponentLayout link_highlight_primary_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlink_highlight_primary_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_link_highlight_primary_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout link_highlight_primary_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlink_highlight_primary_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_link_highlight_primary_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : link_highlight_primary_small_pane
inline TAknWindowComponentLayout link_highlight_primary_small_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlink_highlight_primary_small_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_link_highlight_primary_small_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout link_highlight_primary_small_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlink_highlight_primary_small_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_link_highlight_primary_small_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : link_highlight_secondary_pane
inline TAknWindowComponentLayout link_highlight_secondary_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlink_highlight_secondary_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_link_highlight_secondary_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout link_highlight_secondary_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlink_highlight_secondary_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_link_highlight_secondary_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : link_highlight_title_pane
inline TAknWindowComponentLayout link_highlight_title_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlink_highlight_title_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_link_highlight_title_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout link_highlight_title_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlink_highlight_title_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_link_highlight_title_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : link_highlight_digital_pane
inline TAknWindowComponentLayout link_highlight_digital_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlink_highlight_digital_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_link_highlight_digital_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout link_highlight_digital_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlink_highlight_digital_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_link_highlight_digital_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : copy_highlight_primary_pane
inline TAknWindowComponentLayout copy_highlight_primary_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcopy_highlight_primary_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_copy_highlight_primary_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout copy_highlight_primary_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcopy_highlight_primary_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_copy_highlight_primary_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : copy_highlight_primary_small_pane
inline TAknWindowComponentLayout copy_highlight_primary_small_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcopy_highlight_primary_small_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_copy_highlight_primary_small_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout copy_highlight_primary_small_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcopy_highlight_primary_small_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_copy_highlight_primary_small_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : copy_highlight_secondary_pane
inline TAknWindowComponentLayout copy_highlight_secondary_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcopy_highlight_secondary_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_copy_highlight_secondary_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout copy_highlight_secondary_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcopy_highlight_secondary_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_copy_highlight_secondary_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : copy_highlight_title_pane
inline TAknWindowComponentLayout copy_highlight_title_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcopy_highlight_title_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_copy_highlight_title_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout copy_highlight_title_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcopy_highlight_title_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_copy_highlight_title_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : copy_highlight_digital_pane
inline TAknWindowComponentLayout copy_highlight_digital_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcopy_highlight_digital_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_copy_highlight_digital_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout copy_highlight_digital_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcopy_highlight_digital_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_copy_highlight_digital_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : graphic_text_primary_pane
inline TAknWindowComponentLayout graphic_text_primary_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgraphic_text_primary_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_primary_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout graphic_text_primary_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgraphic_text_primary_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_primary_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout graphic_text_primary_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgraphic_text_primary_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_primary_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits graphic_text_primary_pane_t_Limits()		{ return (*(Tgraphic_text_primary_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_primary_pane_t_Limits)))(); }

inline TAknTextComponentLayout graphic_text_primary_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgraphic_text_primary_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_primary_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : graphic_text_primary_small_pane
inline TAknWindowComponentLayout graphic_text_primary_small_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgraphic_text_primary_small_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_primary_small_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout graphic_text_primary_small_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgraphic_text_primary_small_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_primary_small_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout graphic_text_primary_small_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgraphic_text_primary_small_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_primary_small_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits graphic_text_primary_small_pane_t_Limits()		{ return (*(Tgraphic_text_primary_small_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_primary_small_pane_t_Limits)))(); }

inline TAknTextComponentLayout graphic_text_primary_small_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgraphic_text_primary_small_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_primary_small_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : graphic_text_secondary_pane
inline TAknWindowComponentLayout graphic_text_secondary_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgraphic_text_secondary_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_secondary_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout graphic_text_secondary_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgraphic_text_secondary_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_secondary_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout graphic_text_secondary_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgraphic_text_secondary_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_secondary_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits graphic_text_secondary_pane_t_Limits()		{ return (*(Tgraphic_text_secondary_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_secondary_pane_t_Limits)))(); }

inline TAknTextComponentLayout graphic_text_secondary_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgraphic_text_secondary_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_secondary_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : graphic_text_title_pane
inline TAknWindowComponentLayout graphic_text_title_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgraphic_text_title_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_title_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout graphic_text_title_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgraphic_text_title_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_title_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout graphic_text_title_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgraphic_text_title_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_title_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits graphic_text_title_pane_t_Limits()		{ return (*(Tgraphic_text_title_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_title_pane_t_Limits)))(); }

inline TAknTextComponentLayout graphic_text_title_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgraphic_text_title_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_title_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : graphic_text_digital_pane
inline TAknWindowComponentLayout graphic_text_digital_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgraphic_text_digital_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_digital_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout graphic_text_digital_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgraphic_text_digital_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_digital_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout graphic_text_digital_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgraphic_text_digital_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_digital_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits graphic_text_digital_pane_t_Limits()		{ return (*(Tgraphic_text_digital_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_digital_pane_t_Limits)))(); }

inline TAknTextComponentLayout graphic_text_digital_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgraphic_text_digital_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_graphic_text_digital_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : navi_pane_srt
inline TAknLayoutScalableParameterLimits navi_icon_pane_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Tnavi_icon_pane_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_icon_pane_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout navi_icon_pane_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_icon_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_icon_pane_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_midp_pane_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_midp_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_midp_pane_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_navi_pane_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_navi_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_pane_srt)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits navi_text_pane_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Tnavi_text_pane_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_text_pane_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout navi_text_pane_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_text_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_text_pane_srt)))(aVariety, aCol, aRow); }

// LAF Table : navi_navi_pane_srt
inline TAknWindowComponentLayout navi_navi_icon_text_pane_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_navi_icon_text_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_icon_text_pane_srt)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits navi_navi_pane_srt_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tnavi_navi_pane_srt_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_pane_srt_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout navi_navi_pane_srt_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_navi_pane_srt_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_pane_srt_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits navi_navi_pane_srt_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tnavi_navi_pane_srt_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_pane_srt_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout navi_navi_pane_srt_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_navi_pane_srt_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_pane_srt_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits navi_navi_pane_srt_g_Limits()		{ return (*(Tnavi_navi_pane_srt_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_pane_srt_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits navi_navi_pane_srt_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tnavi_navi_pane_srt_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_pane_srt_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout navi_navi_pane_srt_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_navi_pane_srt_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_pane_srt_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_navi_tabs_pane_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_navi_tabs_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_tabs_pane_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_navi_text_pane_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_navi_text_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_text_pane_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_navi_volume_pane_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_navi_volume_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_volume_pane_srt)))(aVariety, aCol, aRow); }

// LAF Table : navi_navi_text_pane_srt
inline TAknTextComponentLayout navi_navi_text_pane_srt_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_navi_text_pane_srt_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_text_pane_srt_t1)))(aVariety, aCol, aRow); }

// LAF Table : navi_navi_volume_pane_srt
inline TAknWindowComponentLayout navi_navi_volume_pane_srt_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_navi_volume_pane_srt_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_volume_pane_srt_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits volume_small_pane_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Tvolume_small_pane_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout volume_small_pane_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_srt)))(aVariety, aCol, aRow); }

// LAF Table : volume_small_pane_srt
inline TAknLayoutScalableParameterLimits volume_small_pane_srt_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tvolume_small_pane_srt_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_srt_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout volume_small_pane_srt_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_srt_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_srt_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits volume_small_pane_srt_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tvolume_small_pane_srt_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_srt_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout volume_small_pane_srt_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_srt_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_srt_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits volume_small_pane_srt_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tvolume_small_pane_srt_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_srt_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout volume_small_pane_srt_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_srt_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_srt_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits volume_small_pane_srt_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tvolume_small_pane_srt_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_srt_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout volume_small_pane_srt_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_srt_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_srt_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits volume_small_pane_srt_g5_ParamLimits(TInt aVariety = 0)		{ return (*(Tvolume_small_pane_srt_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_srt_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout volume_small_pane_srt_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_srt_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_srt_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits volume_small_pane_srt_g6_ParamLimits(TInt aVariety = 0)		{ return (*(Tvolume_small_pane_srt_g6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_srt_g6_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout volume_small_pane_srt_g6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_srt_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_srt_g6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits volume_small_pane_srt_g7_ParamLimits(TInt aVariety = 0)		{ return (*(Tvolume_small_pane_srt_g7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_srt_g7_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout volume_small_pane_srt_g7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_srt_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_srt_g7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits volume_small_pane_srt_g8_ParamLimits(TInt aVariety = 0)		{ return (*(Tvolume_small_pane_srt_g8_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_srt_g8_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout volume_small_pane_srt_g8(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_srt_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_srt_g8)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits volume_small_pane_srt_g9_ParamLimits(TInt aVariety = 0)		{ return (*(Tvolume_small_pane_srt_g9_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_srt_g9_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout volume_small_pane_srt_g9(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_srt_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_srt_g9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits volume_small_pane_srt_g10_ParamLimits(TInt aVariety = 0)		{ return (*(Tvolume_small_pane_srt_g10_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_srt_g10_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout volume_small_pane_srt_g10(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_srt_g10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_srt_g10)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits volume_small_pane_srt_g_Limits()		{ return (*(Tvolume_small_pane_srt_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_srt_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits volume_small_pane_srt_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tvolume_small_pane_srt_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_srt_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout volume_small_pane_srt_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_srt_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_srt_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_query_data_code_window
inline TAknWindowComponentLayout query_popup_data_pane_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tquery_popup_data_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_query_popup_data_pane_cp2)))(aVariety, aCol, aRow); }

// LAF Table : navi_navi_icon_text_pane_srt
inline TAknLayoutScalableParameterLimits navi_navi_icon_text_pane_srt_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tnavi_navi_icon_text_pane_srt_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_icon_text_pane_srt_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout navi_navi_icon_text_pane_srt_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_navi_icon_text_pane_srt_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_icon_text_pane_srt_t1)))(aVariety, aCol, aRow); }

// LAF Table : navi_navi_tabs_pane_srt
inline TAknWindowComponentLayout navi_tabs_2_long_pane_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_tabs_2_long_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_tabs_2_long_pane_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_tabs_2_pane_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_tabs_2_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_tabs_2_pane_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_tabs_3_long_pane_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_tabs_3_long_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_tabs_3_long_pane_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_tabs_3_pane_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_tabs_3_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_tabs_3_pane_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout navi_tabs_4_pane_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_tabs_4_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_tabs_4_pane_srt)))(aVariety, aCol, aRow); }

// LAF Table : navi_tabs_2_pane_srt
inline TAknLayoutScalableParameterLimits tabs_2_active_pane_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_2_active_pane_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_active_pane_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_2_active_pane_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_2_active_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_active_pane_srt)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits tabs_2_passive_pane_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_2_passive_pane_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_passive_pane_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_2_passive_pane_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_2_passive_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_passive_pane_srt)))(aVariety, aCol, aRow); }

// LAF Table : tabs_2_passive_pane_srt
inline TAknLayoutScalableParameterLimits bg_passive_tab_pane_cp1_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_passive_tab_pane_cp1_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_cp1_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_passive_tab_pane_cp1_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_cp1_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_cp1_srt)))(aVariety, aCol, aRow); }

// LAF Table : bg_passive_tab_pane_cp1_srt
inline TAknWindowComponentLayout bg_passive_tab_pane_g1_cp1_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g1_cp1_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g1_cp1_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_passive_tab_pane_g2_cp1_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g2_cp1_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g2_cp1_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_passive_tab_pane_g3_cp1_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g3_cp1_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g3_cp1_srt)))(aVariety, aCol, aRow); }

// LAF Table : tabs_2_active_pane_srt
inline TAknLayoutScalableParameterLimits bg_active_tab_pane_cp1_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_active_tab_pane_cp1_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_cp1_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_active_tab_pane_cp1_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_cp1_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_cp1_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout tabs_2_active_pane_srt_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_2_active_pane_srt_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_active_pane_srt_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits tabs_2_active_pane_srt_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_2_active_pane_srt_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_active_pane_srt_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout tabs_2_active_pane_srt_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_2_active_pane_srt_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_2_active_pane_srt_t1)))(aVariety, aCol, aRow); }

// LAF Table : bg_active_tab_pane_cp1_srt
inline TAknWindowComponentLayout bg_active_tab_pane_g1_cp1_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g1_cp1_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g1_cp1_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_active_tab_pane_g2_cp1_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g2_cp1_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g2_cp1_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_active_tab_pane_g3_cp1_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g3_cp1_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g3_cp1_srt)))(aVariety, aCol, aRow); }

// LAF Table : navi_tabs_3_pane_srt
inline TAknLayoutScalableParameterLimits tabs_3_active_pane_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_3_active_pane_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_active_pane_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_3_active_pane_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_3_active_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_active_pane_srt)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits tabs_3_passive_pane_cp_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_3_passive_pane_cp_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_passive_pane_cp_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_3_passive_pane_cp_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_3_passive_pane_cp_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_passive_pane_cp_srt)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits tabs_3_passive_pane_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_3_passive_pane_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_passive_pane_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_3_passive_pane_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_3_passive_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_passive_pane_srt)))(aVariety, aCol, aRow); }

// LAF Table : tabs_3_passive_pane_srt
inline TAknLayoutScalableParameterLimits bg_passive_tab_pane_cp2_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_passive_tab_pane_cp2_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_cp2_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_passive_tab_pane_cp2_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_cp2_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_cp2_srt)))(aVariety, aCol, aRow); }

// LAF Table : bg_passive_tab_pane_cp2_srt
inline TAknWindowComponentLayout bg_passive_tab_pane_g1_cp2_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g1_cp2_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g1_cp2_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_passive_tab_pane_g2_cp2_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g2_cp2_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g2_cp2_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_passive_tab_pane_g3_cp2_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_passive_tab_pane_g3_cp2_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_passive_tab_pane_g3_cp2_srt)))(aVariety, aCol, aRow); }

// LAF Table : tabs_3_active_pane_srt
inline TAknLayoutScalableParameterLimits bg_active_tab_pane_cp2_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_active_tab_pane_cp2_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_cp2_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_active_tab_pane_cp2_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_cp2_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_cp2_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout tabs_3_active_pane_srt_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_3_active_pane_srt_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_active_pane_srt_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits tabs_3_active_pane_srt_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_3_active_pane_srt_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_active_pane_srt_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout tabs_3_active_pane_srt_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_3_active_pane_srt_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_3_active_pane_srt_t1)))(aVariety, aCol, aRow); }

// LAF Table : bg_active_tab_pane_cp2_srt
inline TAknWindowComponentLayout bg_active_tab_pane_g1_cp2_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g1_cp2_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g1_cp2_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_active_tab_pane_g2_cp2_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g2_cp2_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g2_cp2_srt)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_active_tab_pane_g3_cp2_srt(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_active_tab_pane_g3_cp2_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_active_tab_pane_g3_cp2_srt)))(aVariety, aCol, aRow); }

// LAF Table : navi_tabs_4_pane_srt
inline TAknLayoutScalableParameterLimits tabs_4_active_pane_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_4_active_pane_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_active_pane_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_4_active_pane_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_4_active_pane_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_active_pane_srt)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits tabs_4_passive_pane_cp2_srt_ParamLimits(TInt aVariety = 0)		{ return (*(Ttabs_4_passive_pane_cp2_srt_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_passive_pane_cp2_srt_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout tabs_4_passive_pane_cp2_srt(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttabs_4_passive_pane_cp2_srt_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_tabs_4_passive_pane_cp2_srt)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout aid_size_cell_toolbar(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_toolbar_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_toolbar)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_idle_act_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_idle_act_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_idle_act_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits popup_large_graphic_colour_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_large_graphic_colour_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_large_graphic_colour_window_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits popup_toolbar_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_toolbar_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_toolbar_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_toolbar_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_toolbar_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_toolbar_window)))(aVariety, aCol, aRow); }

// LAF Table : list_gen_pane
inline TAknLayoutScalableParameterLimits list_single_graphic_2heading_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_2heading_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_2heading_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_2heading_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_graphic_2heading_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_2heading_pane)))(aRow, aVariety, aCol); }

// LAF Table : listscroll_app_pane
inline TAknWindowComponentLayout aid_size_cell_apps_grid_lsc_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_apps_grid_lsc_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_apps_grid_lsc_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout aid_size_cell_apps_grid_prt_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_apps_grid_prt_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_apps_grid_prt_pane)))(aVariety, aCol, aRow); }

// LAF Table : form_midp_field_text_pane
inline TAknLayoutScalableParameterLimits bg_wml_button_pane_cp1_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_wml_button_pane_cp1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_wml_button_pane_cp1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_wml_button_pane_cp1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_wml_button_pane_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_wml_button_pane_cp1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_midp_field_text_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_midp_field_text_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_field_text_pane_t1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits input_focus_pane_cp050_ParamLimits(TInt aVariety = 0)		{ return (*(Tinput_focus_pane_cp050_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp050_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits list_midp_form_text_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_midp_form_text_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_midp_form_text_pane_ParamLimits)))(aVariety); }

// LAF Table : form_midp_field_choice_group_pane
inline TAknLayoutScalableParameterLimits input_focus_pane_cp051_ParamLimits(TInt aVariety = 0)		{ return (*(Tinput_focus_pane_cp051_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp051_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits list_midp_choice_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_midp_choice_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_midp_choice_pane_ParamLimits)))(aVariety); }

// LAF Table : list_midp_choice_pane
inline TAknLayoutScalableParameterLimits list_single_2graphic_pane_cp3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_2graphic_pane_cp3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_cp3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_2graphic_pane_cp3(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_2graphic_pane_cp3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_cp3)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_single_midp_graphic_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_midp_graphic_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_midp_graphic_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_midp_graphic_pane(TInt aVariety, TInt aRow, TInt aCol = 0)		{ return (*(Tlist_single_midp_graphic_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_midp_graphic_pane)))(aVariety, aRow, aCol); }

// LAF Table : list_single_graphic_2heading_pane
inline TAknLayoutScalableParameterLimits list_single_graphic_2heading_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_2heading_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_2heading_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_2heading_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_2heading_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_2heading_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_2heading_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_2heading_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_2heading_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_2heading_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_2heading_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_2heading_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_2heading_pane_g5_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_2heading_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_2heading_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_2heading_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_2heading_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_2heading_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_graphic_2heading_pane_g_Limits()		{ return (*(Tlist_single_graphic_2heading_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_2heading_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_graphic_2heading_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_graphic_2heading_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_2heading_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_single_graphic_2heading_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_2heading_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_2heading_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_2heading_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_2heading_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_2heading_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_graphic_2heading_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_2heading_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_2heading_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_2heading_pane_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_2heading_pane_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_2heading_pane_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_graphic_2heading_pane_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_2heading_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_2heading_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_2heading_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_2heading_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_2heading_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_graphic_2heading_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_2heading_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_2heading_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_graphic_2heading_pane_t_Limits()		{ return (*(Tlist_single_graphic_2heading_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_2heading_pane_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_graphic_2heading_pane_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_graphic_2heading_pane_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_2heading_pane_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_single_graphic_2heading_pane_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_2heading_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_2heading_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_toolbar_window
inline TAknWindowComponentLayout bg_popup_sub_pane_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_toobar_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_toobar_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_toobar_pane)))(aVariety, aCol, aRow); }

// LAF Table : grid_toobar_pane
inline TAknLayoutScalableParameterLimits cell_toolbar_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_toolbar_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_toolbar_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_toolbar_pane(TInt aCol, TInt aVariety = 0, TInt aRow = 0)		{ return (*(Tcell_toolbar_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_toolbar_pane)))(aCol, aVariety, aRow); }

// LAF Table : cell_toolbar_pane
inline TAknLayoutScalableParameterLimits cell_toolbar_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_toolbar_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_toolbar_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_toolbar_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_toolbar_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_toolbar_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_toolbar_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_toolbar_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_toolbar_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_toolbar_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_toolbar_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_toolbar_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_toolbar_pane_g_Limits()		{ return (*(Tcell_toolbar_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_toolbar_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits cell_toolbar_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tcell_toolbar_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_toolbar_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout cell_toolbar_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_toolbar_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_toolbar_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_highlight_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_highlight_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_highlight_pane_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout toolbar_button_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttoolbar_button_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_toolbar_button_pane)))(aVariety, aCol, aRow); }

// LAF Table : toolbar_button_pane
inline TAknWindowComponentLayout toolbar_button_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttoolbar_button_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_toolbar_button_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout toolbar_button_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttoolbar_button_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_toolbar_button_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout toolbar_button_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttoolbar_button_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_toolbar_button_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout toolbar_button_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttoolbar_button_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_toolbar_button_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout toolbar_button_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttoolbar_button_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_toolbar_button_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout toolbar_button_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttoolbar_button_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_toolbar_button_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout toolbar_button_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttoolbar_button_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_toolbar_button_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout toolbar_button_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttoolbar_button_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_toolbar_button_pane_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout toolbar_button_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttoolbar_button_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_toolbar_button_pane_g9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits toolbar_button_pane_g_Limits()		{ return (*(Ttoolbar_button_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_toolbar_button_pane_g_Limits)))(); }

inline TAknWindowComponentLayout toolbar_button_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttoolbar_button_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_toolbar_button_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_single_2graphic_pane_cp3
inline TAknLayoutScalableParameterLimits list_single_2graphic_pane_g1_cp3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_2graphic_pane_g1_cp3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g1_cp3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_2graphic_pane_g1_cp3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_2graphic_pane_g1_cp3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g1_cp3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_2graphic_pane_g2_cp3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_2graphic_pane_g2_cp3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g2_cp3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_2graphic_pane_g2_cp3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_2graphic_pane_g2_cp3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g2_cp3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_single_2graphic_pane_g3_cp3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_2graphic_pane_g3_cp3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g3_cp3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_2graphic_pane_g4_cp3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_2graphic_pane_g4_cp3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g4_cp3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_2graphic_pane_g4_cp3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_2graphic_pane_g4_cp3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g4_cp3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_2graphic_pane_t1_cp3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_2graphic_pane_t1_cp3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_t1_cp3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_2graphic_pane_t1_cp3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_2graphic_pane_t1_cp3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_t1_cp3)))(aVariety, aCol, aRow); }

// LAF Table : list_single_midp_graphic_pane
inline TAknLayoutScalableParameterLimits list_single_midp_graphic_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_midp_graphic_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_midp_graphic_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_midp_graphic_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_midp_graphic_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_midp_graphic_pane_g2)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout aid_zoom_text_primary(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_zoom_text_primary_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_zoom_text_primary)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout aid_zoom_text_secondary(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_zoom_text_secondary_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_zoom_text_secondary)))(aVariety, aCol, aRow); }

// LAF Table : status_small_pane
inline TAknLayoutScalableParameterLimits status_small_pane_g7_ParamLimits(TInt aVariety = 0)		{ return (*(Tstatus_small_pane_g7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_g7_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout status_small_pane_g7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_small_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_g7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits status_small_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tstatus_small_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_t1_ParamLimits)))(aVariety); }

// LAF Table : title_pane
inline TAknWindowComponentLayout title_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttitle_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits title_pane_g_Limits()		{ return (*(Ttitle_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_g_Limits)))(); }

inline TAknWindowComponentLayout title_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttitle_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_large_graphic_colour_window
inline TAknLayoutScalableParameterLimits aid_size_cell_colour_1_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_size_cell_colour_1_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_colour_1_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_size_cell_colour_1_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_colour_1_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_colour_1_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits aid_size_cell_colour_2_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_size_cell_colour_2_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_colour_2_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_size_cell_colour_2_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_colour_2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_colour_2_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits aid_size_cell_colour_3_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_size_cell_colour_3_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_colour_3_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_size_cell_colour_3_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_colour_3_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_colour_3_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits aid_size_cell_colour_4_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_size_cell_colour_4_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_colour_4_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_size_cell_colour_4_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_colour_4_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_colour_4_pane)))(aVariety, aCol, aRow); }

// LAF Table : title_pane_stacon
inline TAknLayoutScalableParameterLimits title_pane_stacon_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Ttitle_pane_stacon_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_stacon_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout title_pane_stacon_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttitle_pane_stacon_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_stacon_g1)))(aVariety, aCol, aRow); }

// LAF Table : popup_note_wait_window
inline TAknLayoutScalableParameterLimits popup_note_wait_window_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_note_wait_window_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_wait_window_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_note_wait_window_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_wait_window_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_wait_window_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_note_wait_window_t5_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_note_wait_window_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_wait_window_t5_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_note_wait_window_t5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_note_wait_window_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_wait_window_t5)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_feb_china_hwr_fs_writing_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_feb_china_hwr_fs_writing_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_feb_china_hwr_fs_writing_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_feb_china_hwr_fs_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_feb_china_hwr_fs_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_feb_china_hwr_fs_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_feb_china_hwr_fs_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_feb_china_hwr_fs_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_feb_china_hwr_fs_window)))(aVariety, aCol, aRow); }

// LAF Table : popup_feb_china_hwr_fs_window
inline TAknLayoutScalableParameterLimits aid_size_cell_hwr_fs_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_size_cell_hwr_fs_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_hwr_fs_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_size_cell_hwr_fs(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_hwr_fs_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_hwr_fs)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits bg_popup_sub_pane_cp3_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_sub_pane_cp3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_sub_pane_cp3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_hwr_fs_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_hwr_fs_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_hwr_fs_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_hwr_fs_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_hwr_fs_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_hwr_fs_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits linegrid_hwr_fs_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlinegrid_hwr_fs_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_hwr_fs_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout linegrid_hwr_fs_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlinegrid_hwr_fs_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_hwr_fs_pane)))(aVariety, aCol, aRow); }

// LAF Table : grid_hwr_fs_pane
inline TAknLayoutScalableParameterLimits cell_hwr_fs_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_hwr_fs_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_fs_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_hwr_fs_pane(TInt aVariety, TInt aCol, TInt aRow)		{ return (*(Tcell_hwr_fs_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_fs_pane)))(aVariety, aCol, aRow); }

// LAF Table : linegrid_hwr_fs_pane
inline TAknLayoutScalableParameterLimits linegrid_hwr_fs_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlinegrid_hwr_fs_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_hwr_fs_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout linegrid_hwr_fs_pane_g1(TInt aVariety, TInt aCol, TInt aRow = 0)		{ return (*(Tlinegrid_hwr_fs_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_hwr_fs_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits linegrid_hwr_fs_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlinegrid_hwr_fs_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_hwr_fs_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout linegrid_hwr_fs_pane_g2(TInt aVariety, TInt aCol, TInt aRow = 0)		{ return (*(Tlinegrid_hwr_fs_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_hwr_fs_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits linegrid_hwr_fs_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlinegrid_hwr_fs_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_hwr_fs_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout linegrid_hwr_fs_pane_g3(TInt aVariety, TInt aCol, TInt aRow = 0)		{ return (*(Tlinegrid_hwr_fs_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_hwr_fs_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits linegrid_hwr_fs_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tlinegrid_hwr_fs_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_hwr_fs_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout linegrid_hwr_fs_pane_g4(TInt aVariety, TInt aCol, TInt aRow = 0)		{ return (*(Tlinegrid_hwr_fs_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_hwr_fs_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits linegrid_hwr_fs_pane_g5_ParamLimits(TInt aVariety = 0)		{ return (*(Tlinegrid_hwr_fs_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_hwr_fs_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout linegrid_hwr_fs_pane_g5(TInt aVariety, TInt aCol, TInt aRow = 0)		{ return (*(Tlinegrid_hwr_fs_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_hwr_fs_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits linegrid_hwr_fs_pane_g_Limits()		{ return (*(Tlinegrid_hwr_fs_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_hwr_fs_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits linegrid_hwr_fs_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlinegrid_hwr_fs_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_hwr_fs_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout linegrid_hwr_fs_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol, TInt aRow = 0)		{ return (*(Tlinegrid_hwr_fs_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_linegrid_hwr_fs_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : cell_hwr_fs_pane
inline TAknLayoutScalableParameterLimits cell_hwr_fs_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_hwr_fs_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_fs_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_hwr_fs_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_hwr_fs_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_fs_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_hwr_fs_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_hwr_fs_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_fs_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_hwr_fs_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_hwr_fs_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_fs_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_hwr_fs_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_hwr_fs_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_fs_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_hwr_fs_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_hwr_fs_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_fs_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_hwr_fs_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_hwr_fs_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_fs_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_hwr_fs_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_hwr_fs_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_fs_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_hwr_fs_pane_g_Limits()		{ return (*(Tcell_hwr_fs_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_fs_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits cell_hwr_fs_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tcell_hwr_fs_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_fs_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout cell_hwr_fs_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_hwr_fs_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_fs_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout cell_hwr_fs_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_hwr_fs_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_fs_pane_t1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_highlight_pane_cp6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_cp6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp6)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_idle_act2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_idle_act2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_idle_act2_pane)))(aVariety, aCol, aRow); }

// LAF Table : bg_popup_sub_pane
inline TAknWindowComponentLayout aid_inside_area_popup_secondary(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_inside_area_popup_secondary_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_inside_area_popup_secondary)))(aVariety, aCol, aRow); }

// LAF Table : bg_popup_window_pane
inline TAknLayoutScalableParameterLimits aid_inside_area_window_primary_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_inside_area_window_primary_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_inside_area_window_primary_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_inside_area_window_primary(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_inside_area_window_primary_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_inside_area_window_primary)))(aVariety, aCol, aRow); }

// LAF Table : main_idle_act2_pane
inline TAknWindowComponentLayout ai2_news_ticker_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai2_news_ticker_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_news_ticker_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits aid_size_cell_ai1_link_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_size_cell_ai1_link_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_ai1_link_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_size_cell_ai1_link(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_ai1_link_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_ai1_link)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_ai2_data_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_ai2_data_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_ai2_data_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_ai2_data_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_ai2_data_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_ai2_data_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_ai2_link_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_ai2_link_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_ai2_link_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_ai2_link_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_ai2_link_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_ai2_link_window)))(aVariety, aCol, aRow); }

// LAF Table : popup_ai2_link_window
inline TAknLayoutScalableParameterLimits bg_popup_sub_pane_cp4_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_sub_pane_cp4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_sub_pane_cp4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_ai2_link_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_ai2_link_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_ai2_link_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_ai2_link_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_ai2_link_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_ai2_link_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_ai2_link_window_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_ai2_link_window_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_ai2_link_window_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_ai2_link_window_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_ai2_link_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_ai2_link_window_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_ai2_link_window_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_ai2_link_window_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_ai2_link_window_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_ai2_link_window_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_ai2_link_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_ai2_link_window_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_ai2_link_window_g_Limits()		{ return (*(Tpopup_ai2_link_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_ai2_link_window_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_ai2_link_window_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_ai2_link_window_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_ai2_link_window_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout popup_ai2_link_window_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_ai2_link_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_ai2_link_window_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_ai2_data_window
inline TAknWindowComponentLayout ai2_mp_button_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai2_mp_button_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_mp_button_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout ai2_mp_volume_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai2_mp_volume_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_mp_volume_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits bg_popup_sub_pane_cp5_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_sub_pane_cp5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_sub_pane_cp5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits heading_ai2_gene_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Theading_ai2_gene_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_ai2_gene_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout heading_ai2_gene_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_ai2_gene_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_ai2_gene_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_ai2_gene_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_ai2_gene_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_ai2_gene_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_ai2_gene_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_ai2_gene_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_ai2_gene_pane)))(aVariety, aCol, aRow); }

// LAF Table : grid_ai2_link_pane
inline TAknLayoutScalableParameterLimits cell_ai2_link_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_ai2_link_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_ai2_link_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_ai2_link_pane(TInt aVariety, TInt aRow, TInt aCol = 0)		{ return (*(Tcell_ai2_link_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_ai2_link_pane)))(aVariety, aRow, aCol); }

// LAF Table : cell_ai2_link_pane
inline TAknWindowComponentLayout cell_ai2_link_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_ai2_link_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_ai2_link_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_highlight_pane_cp7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_cp7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp7)))(aVariety, aCol, aRow); }

// LAF Table : ai2_mp_volume_pane
inline TAknWindowComponentLayout ai2_mp_volume_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai2_mp_volume_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_mp_volume_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout ai2_mp_volume_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai2_mp_volume_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_mp_volume_pane_g2)))(aVariety, aCol, aRow); }

// LAF Table : list_ai2_gene_pane
inline TAknTextComponentLayout list_ai2_gene_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_ai2_gene_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_ai2_gene_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : ai2_mp_volume_pane
inline TAknWindowComponentLayout ai2_mp_volume_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai2_mp_volume_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_mp_volume_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits ai2_mp_volume_pane_g_Limits()		{ return (*(Tai2_mp_volume_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_mp_volume_pane_g_Limits)))(); }

inline TAknWindowComponentLayout ai2_mp_volume_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai2_mp_volume_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_mp_volume_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small_pane_cp3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_cp3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_cp3)))(aVariety, aCol, aRow); }

// LAF Table : ai2_mp_button_pane
inline TAknWindowComponentLayout aid_size_cell_ai2_button(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_ai2_button_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_ai2_button)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_ai2_button_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_ai2_button_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_ai2_button_pane)))(aVariety, aCol, aRow); }

// LAF Table : grid_ai2_button_pane
inline TAknLayoutScalableParameterLimits cell_ai2_button_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_ai2_button_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_ai2_button_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_ai2_button_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tcell_ai2_button_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_ai2_button_pane)))(aRow, aVariety, aCol); }

// LAF Table : cell_ai2_button_pane
inline TAknWindowComponentLayout cell_ai2_button_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_ai2_button_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_ai2_button_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_highlight_pane_cp8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_cp8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp8)))(aVariety, aCol, aRow); }

// LAF Table : ai2_gene_pane
inline TAknLayoutScalableParameterLimits ai2_gene_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tai2_gene_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_gene_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout ai2_gene_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai2_gene_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_gene_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout aid_height_parent_landscape(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_height_parent_landscape_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_height_parent_landscape)))(aVariety, aCol, aRow); }

// LAF Table : set_content_pane
inline TAknWindowComponentLayout aid_height_set_list(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_height_set_list_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_height_set_list)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout aid_size_parent(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_parent_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_parent)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_popup_graphic_pane
inline TAknLayoutScalableParameterLimits aid_size_cell_graphic_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_size_cell_graphic_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_graphic_pane_ParamLimits)))(aVariety); }

// LAF Table : popup_ai2_data_window
inline TAknLayoutScalableParameterLimits popup_ai2_data_window_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_ai2_data_window_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_ai2_data_window_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_ai2_data_window_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_ai2_data_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_ai2_data_window_g1)))(aVariety, aCol, aRow); }

// LAF Table : ai2_news_ticker_pane
inline TAknWindowComponentLayout ai2_news_ticker_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai2_news_ticker_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_news_ticker_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout ai2_news_ticker_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai2_news_ticker_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_news_ticker_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits ai2_news_ticker_pane_g_Limits()		{ return (*(Tai2_news_ticker_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_news_ticker_pane_g_Limits)))(); }

inline TAknWindowComponentLayout ai2_news_ticker_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai2_news_ticker_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_news_ticker_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout ai2_news_ticker_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai2_news_ticker_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_news_ticker_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout ai2_news_ticker_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai2_news_ticker_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_news_ticker_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits ai2_news_ticker_pane_t_Limits()		{ return (*(Tai2_news_ticker_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_news_ticker_pane_t_Limits)))(); }

inline TAknTextComponentLayout ai2_news_ticker_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai2_news_ticker_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_news_ticker_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : heading_ai2_gene_pane
inline TAknWindowComponentLayout heading_ai2_gene_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_ai2_gene_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_ai2_gene_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits heading_ai2_gene_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Theading_ai2_gene_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_ai2_gene_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout heading_ai2_gene_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_ai2_gene_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_ai2_gene_pane_t1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_highlight_pane_cp6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_cp6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp6)))(aVariety, aCol, aRow); }

// LAF Table : list_ai2_gene_pane
inline TAknLayoutScalableParameterLimits ai2_gene_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tai2_gene_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_gene_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout ai2_gene_pane(TInt aVariety, TInt aRow = 0, TInt aCol = 0)		{ return (*(Tai2_gene_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_gene_pane)))(aVariety, aRow, aCol); }

inline TAknTextComponentLayout list_ai2_gene_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_ai2_gene_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_ai2_gene_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_ai2_gene_pane_t_Limits()		{ return (*(Tlist_ai2_gene_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_ai2_gene_pane_t_Limits)))(); }

inline TAknTextComponentLayout list_ai2_gene_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_ai2_gene_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_ai2_gene_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_highlight_pane_cp8_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_highlight_pane_cp8_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp8_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_highlight_pane_cp8(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_cp8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp8)))(aVariety, aCol, aRow); }

// LAF Table : ai2_gene_pane
inline TAknLayoutScalableParameterLimits ai2_gene_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tai2_gene_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_gene_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout ai2_gene_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai2_gene_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_gene_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits ai2_gene_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tai2_gene_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_gene_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout ai2_gene_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai2_gene_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_gene_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits ai2_gene_pane_g_Limits()		{ return (*(Tai2_gene_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_gene_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits ai2_gene_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tai2_gene_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_gene_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout ai2_gene_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai2_gene_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai2_gene_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : listscroll_gen_pane
inline TAknWindowComponentLayout scroll_pane_cp12(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp12_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp12)))(aVariety, aCol, aRow); }

// LAF Table : control_pane
inline TAknLayoutScalableParameterLimits control_pane_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tcontrol_pane_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_pane_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout control_pane_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_pane_t3)))(aVariety, aCol, aRow); }

// LAF Table : status_small_pane
inline TAknLayoutScalableParameterLimits status_small_pane_g8_ParamLimits(TInt aVariety = 0)		{ return (*(Tstatus_small_pane_g8_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_g8_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout status_small_pane_g8(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_small_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_pane_g8)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknLayoutScalableParameterLimits popup_find_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_find_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_find_window_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits popup_note_image_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_note_image_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_note_image_window_ParamLimits)))(aVariety); }

// LAF Table : list_double2_graphic_pane_vc
inline TAknLayoutScalableParameterLimits list_double2_graphic_pane_vc_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_pane_vc_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_vc_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_graphic_pane_vc_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_graphic_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_vc_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_graphic_pane_vc_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_pane_vc_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_vc_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_graphic_pane_vc_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_graphic_pane_vc_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_vc_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_graphic_pane_vc_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_pane_vc_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_vc_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_graphic_pane_vc_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_graphic_pane_vc_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_vc_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double2_graphic_pane_vc_g_Limits()		{ return (*(Tlist_double2_graphic_pane_vc_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_vc_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double2_graphic_pane_vc_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_pane_vc_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_vc_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_double2_graphic_pane_vc_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_graphic_pane_vc_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_vc_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_graphic_pane_vc_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_pane_vc_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_vc_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double2_graphic_pane_vc_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_graphic_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_vc_t1)))(aVariety, aCol, aRow); }

// LAF Table : list_single_heading_pane_vc
inline TAknLayoutScalableParameterLimits list_single_heading_pane_vc_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_heading_pane_vc_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_vc_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_heading_pane_vc_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_heading_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_vc_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_heading_pane_vc_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_heading_pane_vc_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_vc_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_heading_pane_vc_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_heading_pane_vc_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_vc_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_heading_pane_vc_g_Limits()		{ return (*(Tlist_single_heading_pane_vc_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_vc_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_heading_pane_vc_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_heading_pane_vc_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_vc_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_single_heading_pane_vc_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_heading_pane_vc_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_vc_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_heading_pane_vc_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_heading_pane_vc_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_vc_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_heading_pane_vc_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_heading_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_vc_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_heading_pane_vc_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_heading_pane_vc_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_vc_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_heading_pane_vc_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_heading_pane_vc_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_vc_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_heading_pane_vc_t_Limits()		{ return (*(Tlist_single_heading_pane_vc_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_vc_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_heading_pane_vc_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_heading_pane_vc_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_vc_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_single_heading_pane_vc_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_heading_pane_vc_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_vc_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_setting_number_pane_vc
inline TAknLayoutScalableParameterLimits list_setting_number_pane_vc_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_setting_number_pane_vc_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_vc_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_setting_number_pane_vc_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_number_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_vc_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_setting_number_pane_vc_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_setting_number_pane_vc_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_vc_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_setting_number_pane_vc_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_number_pane_vc_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_vc_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_setting_number_pane_vc_g_Limits()		{ return (*(Tlist_setting_number_pane_vc_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_vc_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_setting_number_pane_vc_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_setting_number_pane_vc_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_vc_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_setting_number_pane_vc_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_number_pane_vc_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_vc_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_setting_number_pane_vc_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_setting_number_pane_vc_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_vc_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_setting_number_pane_vc_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_number_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_vc_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_setting_number_pane_vc_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_setting_number_pane_vc_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_vc_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_setting_number_pane_vc_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_number_pane_vc_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_vc_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_setting_number_pane_vc_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_setting_number_pane_vc_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_vc_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_setting_number_pane_vc_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_number_pane_vc_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_vc_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_setting_number_pane_vc_t_Limits()		{ return (*(Tlist_setting_number_pane_vc_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_vc_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_setting_number_pane_vc_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_setting_number_pane_vc_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_vc_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_setting_number_pane_vc_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_number_pane_vc_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_vc_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits set_value_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tset_value_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_value_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout set_value_pane_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_value_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_value_pane_vc)))(aVariety, aCol, aRow); }

// LAF Table : list_gen_pane
inline TAknLayoutScalableParameterLimits list_double2_graphic_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_graphic_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_graphic_pane_vc(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double2_graphic_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_graphic_pane_vc)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_double2_large_graphic_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_large_graphic_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_large_graphic_pane_vc(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double2_large_graphic_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_vc)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_double2_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_pane_vc(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double2_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_vc)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_double_graphic_heading_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_heading_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_graphic_heading_pane_vc(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double_graphic_heading_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_vc)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_double_graphic_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_graphic_pane_vc(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double_graphic_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_vc)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_double_heading_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_heading_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_heading_pane_vc(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double_heading_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_vc)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_double_large_graphic_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_large_graphic_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_large_graphic_pane_vc(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double_large_graphic_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_vc)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_double_number_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_number_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_number_pane_vc(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double_number_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_vc)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_double_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_pane_vc(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_vc)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_double_time_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_time_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_time_pane_vc(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double_time_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_vc)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_setting_number_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_setting_number_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_setting_number_pane_vc(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_setting_number_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_vc)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_setting_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_setting_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_setting_pane_vc(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_setting_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_vc)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_heading_pane_vc(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_graphic_heading_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_vc)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_single_heading_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_heading_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_heading_pane_vc(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_heading_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_vc)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_single_number_heading_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_number_heading_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_number_heading_pane_vc(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_number_heading_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_vc)))(aRow, aVariety, aCol); }

// LAF Table : list_double_graphic_heading_pane_vc
inline TAknLayoutScalableParameterLimits list_double_graphic_heading_pane_vc_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_heading_pane_vc_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_vc_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_graphic_heading_pane_vc_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_heading_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_vc_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_graphic_heading_pane_vc_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_heading_pane_vc_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_vc_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_graphic_heading_pane_vc_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_heading_pane_vc_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_vc_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_graphic_heading_pane_vc_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_heading_pane_vc_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_vc_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_graphic_heading_pane_vc_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_heading_pane_vc_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_vc_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_graphic_heading_pane_vc_g_Limits()		{ return (*(Tlist_double_graphic_heading_pane_vc_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_vc_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_graphic_heading_pane_vc_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_graphic_heading_pane_vc_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_vc_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_double_graphic_heading_pane_vc_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_heading_pane_vc_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_vc_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_graphic_heading_pane_vc_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_heading_pane_vc_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_vc_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_graphic_heading_pane_vc_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_heading_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_vc_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_graphic_heading_pane_vc_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_heading_pane_vc_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_vc_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_graphic_heading_pane_vc_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_heading_pane_vc_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_vc_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_graphic_heading_pane_vc_t_Limits()		{ return (*(Tlist_double_graphic_heading_pane_vc_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_vc_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_graphic_heading_pane_vc_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_graphic_heading_pane_vc_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_vc_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_double_graphic_heading_pane_vc_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_heading_pane_vc_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_heading_pane_vc_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_setting_pane_vc
inline TAknLayoutScalableParameterLimits list_setting_pane_vc_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_setting_pane_vc_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_vc_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_setting_pane_vc_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_vc_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_setting_pane_vc_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_setting_pane_vc_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_vc_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_setting_pane_vc_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_pane_vc_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_vc_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_setting_pane_vc_g_Limits()		{ return (*(Tlist_setting_pane_vc_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_vc_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_setting_pane_vc_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_setting_pane_vc_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_vc_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_setting_pane_vc_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_pane_vc_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_vc_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_setting_pane_vc_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_setting_pane_vc_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_vc_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_setting_pane_vc_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_vc_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_setting_pane_vc_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_setting_pane_vc_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_vc_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_setting_pane_vc_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_pane_vc_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_vc_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_setting_pane_vc_t_Limits()		{ return (*(Tlist_setting_pane_vc_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_vc_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_setting_pane_vc_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_setting_pane_vc_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_vc_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_setting_pane_vc_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_pane_vc_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_vc_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits set_value_pane_cp_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tset_value_pane_cp_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_value_pane_cp_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout set_value_pane_cp_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_value_pane_cp_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_value_pane_cp_vc)))(aVariety, aCol, aRow); }

// LAF Table : list_single_number_heading_pane_vc
inline TAknLayoutScalableParameterLimits list_single_number_heading_pane_vc_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_number_heading_pane_vc_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_vc_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_number_heading_pane_vc_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_heading_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_vc_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_number_heading_pane_vc_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_number_heading_pane_vc_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_vc_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_number_heading_pane_vc_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_heading_pane_vc_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_vc_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_number_heading_pane_vc_g_Limits()		{ return (*(Tlist_single_number_heading_pane_vc_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_vc_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_number_heading_pane_vc_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_number_heading_pane_vc_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_vc_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_single_number_heading_pane_vc_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_heading_pane_vc_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_vc_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_number_heading_pane_vc_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_number_heading_pane_vc_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_vc_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_number_heading_pane_vc_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_heading_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_vc_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_number_heading_pane_vc_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_number_heading_pane_vc_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_vc_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_number_heading_pane_vc_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_heading_pane_vc_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_vc_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_number_heading_pane_vc_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_number_heading_pane_vc_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_vc_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_number_heading_pane_vc_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_heading_pane_vc_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_vc_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_number_heading_pane_vc_t_Limits()		{ return (*(Tlist_single_number_heading_pane_vc_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_vc_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_number_heading_pane_vc_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_number_heading_pane_vc_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_vc_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_single_number_heading_pane_vc_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_number_heading_pane_vc_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_number_heading_pane_vc_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_single_graphic_heading_pane_vc
inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_vc_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_vc_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_vc_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_heading_pane_vc_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_vc_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_vc_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_vc_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_vc_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_heading_pane_vc_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_vc_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_vc_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_vc_g5_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_vc_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_vc_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_heading_pane_vc_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_vc_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_vc_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_graphic_heading_pane_vc_g_Limits()		{ return (*(Tlist_single_graphic_heading_pane_vc_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_vc_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_vc_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_vc_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_vc_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_single_graphic_heading_pane_vc_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_vc_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_vc_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_vc_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_vc_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_vc_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_graphic_heading_pane_vc_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_vc_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_vc_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_vc_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_vc_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_graphic_heading_pane_vc_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_vc_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_vc_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_graphic_heading_pane_vc_t_Limits()		{ return (*(Tlist_single_graphic_heading_pane_vc_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_vc_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_vc_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_vc_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_vc_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_single_graphic_heading_pane_vc_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_vc_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_vc_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_double2_pane_vc
inline TAknLayoutScalableParameterLimits list_double2_pane_vc_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_pane_vc_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_vc_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_pane_vc_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_vc_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_pane_vc_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_pane_vc_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_vc_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_pane_vc_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_pane_vc_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_vc_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double2_pane_vc_g_Limits()		{ return (*(Tlist_double2_pane_vc_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_vc_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double2_pane_vc_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double2_pane_vc_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_vc_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_double2_pane_vc_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_pane_vc_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_vc_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_pane_vc_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_pane_vc_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_vc_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double2_pane_vc_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_pane_vc_t1)))(aVariety, aCol, aRow); }

// LAF Table : list_double2_large_graphic_pane_vc
inline TAknLayoutScalableParameterLimits list_double2_large_graphic_pane_vc_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_large_graphic_pane_vc_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_vc_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_large_graphic_pane_vc_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_large_graphic_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_vc_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_large_graphic_pane_vc_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_large_graphic_pane_vc_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_vc_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_large_graphic_pane_vc_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_large_graphic_pane_vc_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_vc_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_large_graphic_pane_vc_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_large_graphic_pane_vc_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_vc_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double2_large_graphic_pane_vc_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_large_graphic_pane_vc_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_vc_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double2_large_graphic_pane_vc_g_Limits()		{ return (*(Tlist_double2_large_graphic_pane_vc_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_vc_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double2_large_graphic_pane_vc_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double2_large_graphic_pane_vc_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_vc_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_double2_large_graphic_pane_vc_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_large_graphic_pane_vc_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_vc_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double2_large_graphic_pane_vc_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double2_large_graphic_pane_vc_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_vc_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double2_large_graphic_pane_vc_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double2_large_graphic_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double2_large_graphic_pane_vc_t1)))(aVariety, aCol, aRow); }

// LAF Table : list_double_time_pane_vc
inline TAknLayoutScalableParameterLimits list_double_time_pane_vc_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_time_pane_vc_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_vc_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_time_pane_vc_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_time_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_vc_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_time_pane_vc_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_time_pane_vc_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_vc_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_time_pane_vc_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_time_pane_vc_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_vc_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_time_pane_vc_g_Limits()		{ return (*(Tlist_double_time_pane_vc_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_vc_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_time_pane_vc_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_time_pane_vc_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_vc_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_double_time_pane_vc_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_time_pane_vc_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_vc_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_time_pane_vc_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_time_pane_vc_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_vc_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_time_pane_vc_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_time_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_vc_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_time_pane_vc_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_time_pane_vc_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_vc_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_time_pane_vc_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_time_pane_vc_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_vc_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_time_pane_vc_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_time_pane_vc_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_vc_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_time_pane_vc_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_time_pane_vc_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_vc_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_time_pane_vc_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_time_pane_vc_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_vc_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_time_pane_vc_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_time_pane_vc_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_vc_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_time_pane_vc_t_Limits()		{ return (*(Tlist_double_time_pane_vc_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_vc_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_time_pane_vc_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_time_pane_vc_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_vc_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_double_time_pane_vc_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_time_pane_vc_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_time_pane_vc_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_double_pane_vc
inline TAknLayoutScalableParameterLimits list_double_pane_vc_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_pane_vc_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_vc_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_pane_vc_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_vc_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_pane_vc_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_pane_vc_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_vc_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_pane_vc_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_pane_vc_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_vc_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_pane_vc_g_Limits()		{ return (*(Tlist_double_pane_vc_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_vc_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_pane_vc_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_pane_vc_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_vc_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_double_pane_vc_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_pane_vc_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_vc_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_pane_vc_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_pane_vc_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_vc_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_pane_vc_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_vc_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_pane_vc_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_pane_vc_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_vc_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_pane_vc_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_pane_vc_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_vc_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_pane_vc_t_Limits()		{ return (*(Tlist_double_pane_vc_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_vc_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_pane_vc_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_pane_vc_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_vc_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_double_pane_vc_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_pane_vc_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_pane_vc_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_double_number_pane_vc
inline TAknLayoutScalableParameterLimits list_double_number_pane_vc_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_number_pane_vc_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_vc_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_number_pane_vc_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_number_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_vc_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_number_pane_vc_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_number_pane_vc_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_vc_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_number_pane_vc_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_number_pane_vc_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_vc_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_number_pane_vc_g_Limits()		{ return (*(Tlist_double_number_pane_vc_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_vc_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_number_pane_vc_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_number_pane_vc_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_vc_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_double_number_pane_vc_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_number_pane_vc_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_vc_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_number_pane_vc_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_number_pane_vc_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_vc_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_number_pane_vc_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_number_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_vc_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_number_pane_vc_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_number_pane_vc_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_vc_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_number_pane_vc_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_number_pane_vc_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_vc_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_number_pane_vc_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_number_pane_vc_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_vc_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_number_pane_vc_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_number_pane_vc_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_vc_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_number_pane_vc_t_Limits()		{ return (*(Tlist_double_number_pane_vc_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_vc_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_number_pane_vc_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_number_pane_vc_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_vc_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_double_number_pane_vc_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_number_pane_vc_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_number_pane_vc_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_double_large_graphic_pane_vc
inline TAknLayoutScalableParameterLimits list_double_large_graphic_pane_vc_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_large_graphic_pane_vc_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_vc_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_large_graphic_pane_vc_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_large_graphic_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_vc_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_large_graphic_pane_vc_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_large_graphic_pane_vc_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_vc_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_large_graphic_pane_vc_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_large_graphic_pane_vc_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_vc_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_large_graphic_pane_vc_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_large_graphic_pane_vc_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_vc_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_large_graphic_pane_vc_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_large_graphic_pane_vc_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_vc_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_large_graphic_pane_vc_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_large_graphic_pane_vc_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_vc_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_large_graphic_pane_vc_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_large_graphic_pane_vc_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_vc_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_large_graphic_pane_vc_g_Limits()		{ return (*(Tlist_double_large_graphic_pane_vc_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_vc_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_large_graphic_pane_vc_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_large_graphic_pane_vc_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_vc_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_double_large_graphic_pane_vc_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_large_graphic_pane_vc_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_vc_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_large_graphic_pane_vc_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_large_graphic_pane_vc_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_vc_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_large_graphic_pane_vc_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_large_graphic_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_vc_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_large_graphic_pane_vc_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_large_graphic_pane_vc_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_vc_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_large_graphic_pane_vc_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_large_graphic_pane_vc_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_vc_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_large_graphic_pane_vc_t_Limits()		{ return (*(Tlist_double_large_graphic_pane_vc_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_vc_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_large_graphic_pane_vc_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_large_graphic_pane_vc_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_vc_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_double_large_graphic_pane_vc_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_large_graphic_pane_vc_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_vc_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_double_heading_pane_vc
inline TAknLayoutScalableParameterLimits list_double_heading_pane_vc_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_heading_pane_vc_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_vc_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_heading_pane_vc_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_heading_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_vc_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_heading_pane_vc_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_heading_pane_vc_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_vc_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_heading_pane_vc_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_heading_pane_vc_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_vc_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_heading_pane_vc_g_Limits()		{ return (*(Tlist_double_heading_pane_vc_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_vc_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_heading_pane_vc_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_heading_pane_vc_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_vc_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_double_heading_pane_vc_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_heading_pane_vc_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_vc_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_heading_pane_vc_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_heading_pane_vc_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_vc_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_heading_pane_vc_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_heading_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_vc_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_heading_pane_vc_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_heading_pane_vc_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_vc_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_heading_pane_vc_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_heading_pane_vc_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_vc_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_heading_pane_vc_t_Limits()		{ return (*(Tlist_double_heading_pane_vc_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_vc_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_heading_pane_vc_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_heading_pane_vc_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_vc_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_double_heading_pane_vc_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_heading_pane_vc_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_vc_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_double_graphic_pane_vc
inline TAknLayoutScalableParameterLimits list_double_graphic_pane_vc_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_pane_vc_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_vc_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_graphic_pane_vc_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_vc_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_graphic_pane_vc_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_pane_vc_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_vc_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_graphic_pane_vc_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_pane_vc_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_vc_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_graphic_pane_vc_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_pane_vc_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_vc_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_graphic_pane_vc_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_pane_vc_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_vc_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_graphic_pane_vc_g_Limits()		{ return (*(Tlist_double_graphic_pane_vc_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_vc_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_graphic_pane_vc_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_graphic_pane_vc_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_vc_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_double_graphic_pane_vc_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_pane_vc_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_vc_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_graphic_pane_vc_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_pane_vc_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_vc_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_graphic_pane_vc_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_vc_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_graphic_pane_vc_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_graphic_pane_vc_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_vc_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_graphic_pane_vc_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_pane_vc_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_vc_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_double_graphic_pane_vc_t_Limits()		{ return (*(Tlist_double_graphic_pane_vc_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_vc_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_double_graphic_pane_vc_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_double_graphic_pane_vc_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_vc_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_double_graphic_pane_vc_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_graphic_pane_vc_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_graphic_pane_vc_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : application_window
inline TAknWindowComponentLayout aid_size_cell_fastswap(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_fastswap_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_fastswap)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits aid_size_cell_touch_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_size_cell_touch_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_touch_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_size_cell_touch(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_touch_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_touch)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_fast_swap_wide_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_fast_swap_wide_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fast_swap_wide_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_fast_swap_wide_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_fast_swap_wide_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fast_swap_wide_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits touch_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Ttouch_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_touch_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout touch_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttouch_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_touch_pane)))(aVariety, aCol, aRow); }

// LAF Table : list_form_gen_pane
inline TAknWindowComponentLayout button_value_adjust_pane_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbutton_value_adjust_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_button_value_adjust_pane_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout button_value_adjust_pane_cp4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbutton_value_adjust_pane_cp4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_button_value_adjust_pane_cp4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout form_field_data_pane_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_data_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_data_pane_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout form_field_data_wide_pane_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_data_wide_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_data_wide_pane_cp2)))(aVariety, aCol, aRow); }

// LAF Table : scroll_pane
inline TAknLayoutScalableParameterLimits bg_scroll_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_scroll_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_scroll_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits scroll_handle_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_handle_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_handle_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits scroll_sc2_down_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_sc2_down_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_sc2_down_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout scroll_sc2_down_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_sc2_down_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_sc2_down_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits scroll_sc2_up_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_sc2_up_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_sc2_up_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout scroll_sc2_up_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_sc2_up_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_sc2_up_pane)))(aVariety, aCol, aRow); }

// LAF Table : grid_wheel_folder_pane
inline TAknLayoutScalableParameterLimits grid_wheel_folder_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_wheel_folder_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_wheel_folder_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_wheel_folder_pane_g1(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tgrid_wheel_folder_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_wheel_folder_pane_g1)))(aRow, aVariety, aCol); }

// LAF Table : stacon_bottom_pane
inline TAknLayoutScalableParameterLimits clock_nsta_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tclock_nsta_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_nsta_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout clock_nsta_pane_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_nsta_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_nsta_pane_cp2)))(aVariety, aCol, aRow); }

// LAF Table : main_midp_pane
inline TAknLayoutScalableParameterLimits listscroll_midp_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlistscroll_midp_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_midp_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout midp_canvas_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmidp_canvas_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_canvas_pane)))(aVariety, aCol, aRow); }

// LAF Table : control_pane
inline TAknWindowComponentLayout nsta_clock_indic_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnsta_clock_indic_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_nsta_clock_indic_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout listscroll_form_pane_vc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_form_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_form_pane_vc)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits listscroll_set_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tlistscroll_set_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_set_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout listscroll_set_pane_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_set_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_set_pane_vc)))(aVariety, aCol, aRow); }

// LAF Table : status_pane
inline TAknWindowComponentLayout clock_nsta_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_nsta_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_nsta_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout indicator_nsta_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tindicator_nsta_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_indicator_nsta_pane)))(aVariety, aCol, aRow); }

// LAF Table : popup_toolbar_window
inline TAknLayoutScalableParameterLimits bg_popup_sub_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_sub_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits find_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tfind_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout find_pane_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfind_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_find_pane_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_toobar_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_toobar_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_toobar_pane_ParamLimits)))(aVariety); }

// LAF Table : listscroll_form_pane_vc
inline TAknLayoutScalableParameterLimits list_form_gen_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_form_gen_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_form_gen_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_form_gen_pane_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_form_gen_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_form_gen_pane_vc)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits scroll_pane_cp8_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_pane_cp8_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp8_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout scroll_pane_cp8_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp8_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp8_vc)))(aVariety, aCol, aRow); }

// LAF Table : form_field_data_wide_pane_vc
inline TAknLayoutScalableParameterLimits data_form_wide_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tdata_form_wide_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_data_form_wide_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout data_form_wide_pane_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tdata_form_wide_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_data_form_wide_pane_vc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout form_field_data_wide_pane_vc_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_data_wide_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_data_wide_pane_vc_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_field_data_wide_pane_vc_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_data_wide_pane_vc_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_data_wide_pane_vc_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout form_field_data_wide_pane_vc_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_data_wide_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_data_wide_pane_vc_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits input_focus_pane_cp6_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tinput_focus_pane_cp6_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp6_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout input_focus_pane_cp6_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp6_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp6_vc)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_midp_pane
inline TAknLayoutScalableParameterLimits list_midp_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_midp_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_midp_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits scroll_pane_cp16_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_pane_cp16_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp16_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout scroll_pane_cp16(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp16_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp16)))(aVariety, aCol, aRow); }

// LAF Table : popup_query_code_window
inline TAknLayoutScalableParameterLimits button_value_adjust_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tbutton_value_adjust_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_button_value_adjust_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout button_value_adjust_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbutton_value_adjust_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_button_value_adjust_pane)))(aVariety, aCol, aRow); }

// LAF Table : set_content_pane
inline TAknLayoutScalableParameterLimits button_value_adjust_pane_cp6_ParamLimits(TInt aVariety = 0)		{ return (*(Tbutton_value_adjust_pane_cp6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_button_value_adjust_pane_cp6_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout button_value_adjust_pane_cp6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbutton_value_adjust_pane_cp6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_button_value_adjust_pane_cp6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits settings_code_pane_cp_ParamLimits(TInt aVariety = 0)		{ return (*(Tsettings_code_pane_cp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_settings_code_pane_cp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout settings_code_pane_cp(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsettings_code_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_settings_code_pane_cp)))(aVariety, aCol, aRow); }

// LAF Table : cell_touch_pane
inline TAknWindowComponentLayout cell_touch_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_touch_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_touch_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_touch_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_touch_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_touch_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_touch_pane_g_Limits()		{ return (*(Tcell_touch_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_touch_pane_g_Limits)))(); }

inline TAknWindowComponentLayout cell_touch_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_touch_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_touch_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : grid_touch_1_pane
inline TAknLayoutScalableParameterLimits cell_touch_pane_cp_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_touch_pane_cp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_touch_pane_cp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_touch_pane_cp(TInt aVariety, TInt aCol, TInt aRow)		{ return (*(Tcell_touch_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_touch_pane_cp)))(aVariety, aCol, aRow); }

// LAF Table : grid_touch_2_pane
inline TAknLayoutScalableParameterLimits cell_touch_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_touch_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_touch_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_touch_pane(TInt aVariety, TInt aCol, TInt aRow)		{ return (*(Tcell_touch_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_touch_pane)))(aVariety, aCol, aRow); }

// LAF Table : scroll_sc2_down_pane
inline TAknWindowComponentLayout scroll_sc2_down_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_sc2_down_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_sc2_down_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : scroll_sc2_up_pane
inline TAknWindowComponentLayout scroll_sc2_up_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_sc2_up_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_sc2_up_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : list_set_graphic_pane_vc
inline TAknWindowComponentLayout bg_set_opt_pane_cp4_vc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_set_opt_pane_cp4_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_set_opt_pane_cp4_vc)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_set_graphic_pane_vc_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_set_graphic_pane_vc_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_set_graphic_pane_vc_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_set_graphic_pane_vc_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_set_graphic_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_set_graphic_pane_vc_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_set_graphic_pane_vc_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_set_graphic_pane_vc_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_set_graphic_pane_vc_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_set_graphic_pane_vc_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_set_graphic_pane_vc_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_set_graphic_pane_vc_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_set_graphic_pane_vc_g_Limits()		{ return (*(Tlist_set_graphic_pane_vc_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_set_graphic_pane_vc_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_set_graphic_pane_vc_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_set_graphic_pane_vc_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_set_graphic_pane_vc_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_set_graphic_pane_vc_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_set_graphic_pane_vc_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_set_graphic_pane_vc_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits text_primary_small_cp13_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Ttext_primary_small_cp13_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_text_primary_small_cp13_vc_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout text_primary_small_cp13_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttext_primary_small_cp13_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_text_primary_small_cp13_vc)))(aVariety, aCol, aRow); }

// LAF Table : list_set_pane_vc
inline TAknLayoutScalableParameterLimits list_set_graphic_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_set_graphic_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_set_graphic_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_set_graphic_pane_vc(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_set_graphic_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_set_graphic_pane_vc)))(aRow, aVariety, aCol); }

// LAF Table : setting_code_pane_vc
inline TAknWindowComponentLayout input_focus_pane_cp2_vc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp2_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp2_vc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout setting_code_pane_vc_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_code_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_code_pane_vc_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout setting_code_pane_vc_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_code_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_code_pane_vc_t1)))(aVariety, aCol, aRow); }

// LAF Table : list_set_text_pane_vc
inline TAknLayoutScalableParameterLimits set_text_pane_vc_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tset_text_pane_vc_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_text_pane_vc_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout set_text_pane_vc_t1(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tset_text_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_text_pane_vc_t1)))(aRow, aVariety, aCol); }

// LAF Table : setting_text_pane_vc
inline TAknWindowComponentLayout input_focus_pane_cp1_vc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp1_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp1_vc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_set_text_pane_vc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_set_text_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_set_text_pane_vc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout setting_text_pane_vc_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_text_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_text_pane_vc_g1)))(aVariety, aCol, aRow); }

// LAF Table : setting_slider_graphic_pane_vc
inline TAknWindowComponentLayout bg_set_opt_pane_cp2_vc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_set_opt_pane_cp2_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_set_opt_pane_cp2_vc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout setting_slider_graphic_pane_vc_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_slider_graphic_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_slider_graphic_pane_vc_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout setting_slider_graphic_pane_vc_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_slider_graphic_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_slider_graphic_pane_vc_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout setting_slider_graphic_pane_vc_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_slider_graphic_pane_vc_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_slider_graphic_pane_vc_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits setting_slider_graphic_pane_vc_t_Limits()		{ return (*(Tsetting_slider_graphic_pane_vc_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_slider_graphic_pane_vc_t_Limits)))(); }

inline TAknTextComponentLayout setting_slider_graphic_pane_vc_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_slider_graphic_pane_vc_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_slider_graphic_pane_vc_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout slider_set_pane_cp_vc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_set_pane_cp_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_set_pane_cp_vc)))(aVariety, aCol, aRow); }

// LAF Table : slider_set_pane_vc
inline TAknWindowComponentLayout slider_set_pane_vc_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_set_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_set_pane_vc_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout slider_set_pane_vc_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_set_pane_vc_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_set_pane_vc_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits slider_set_pane_vc_g_Limits()		{ return (*(Tslider_set_pane_vc_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_set_pane_vc_g_Limits)))(); }

inline TAknWindowComponentLayout slider_set_pane_vc_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_set_pane_vc_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_set_pane_vc_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : bg_set_opt_pane_cp_vc
inline TAknWindowComponentLayout set_opt_bg_pane_g1_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_opt_bg_pane_g1_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_opt_bg_pane_g1_copy1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout set_opt_bg_pane_g2_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_opt_bg_pane_g2_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_opt_bg_pane_g2_copy1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout set_opt_bg_pane_g3_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_opt_bg_pane_g3_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_opt_bg_pane_g3_copy1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout set_opt_bg_pane_g4_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_opt_bg_pane_g4_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_opt_bg_pane_g4_copy1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout set_opt_bg_pane_g5_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_opt_bg_pane_g5_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_opt_bg_pane_g5_copy1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout set_opt_bg_pane_g6_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_opt_bg_pane_g6_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_opt_bg_pane_g6_copy1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout set_opt_bg_pane_g7_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_opt_bg_pane_g7_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_opt_bg_pane_g7_copy1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout set_opt_bg_pane_g8_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_opt_bg_pane_g8_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_opt_bg_pane_g8_copy1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout set_opt_bg_pane_g9_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_opt_bg_pane_g9_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_opt_bg_pane_g9_copy1)))(aVariety, aCol, aRow); }

// LAF Table : setting_slider_pane_vc
inline TAknWindowComponentLayout bg_set_opt_pane_cp_vc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_set_opt_pane_cp_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_set_opt_pane_cp_vc)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout setting_slider_pane_vc_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_slider_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_slider_pane_vc_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout setting_slider_pane_vc_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_slider_pane_vc_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_slider_pane_vc_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout setting_slider_pane_vc_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_slider_pane_vc_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_slider_pane_vc_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits setting_slider_pane_vc_t_Limits()		{ return (*(Tsetting_slider_pane_vc_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_slider_pane_vc_t_Limits)))(); }

inline TAknTextComponentLayout setting_slider_pane_vc_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_slider_pane_vc_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_slider_pane_vc_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout slider_set_pane_vc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_set_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_set_pane_vc)))(aVariety, aCol, aRow); }

// LAF Table : volume_set_pane_vc
inline TAknWindowComponentLayout volume_set_pane_vc_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_set_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_set_pane_vc_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_set_pane_vc_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_set_pane_vc_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_set_pane_vc_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_set_pane_vc_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_set_pane_vc_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_set_pane_vc_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_set_pane_vc_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_set_pane_vc_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_set_pane_vc_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_set_pane_vc_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_set_pane_vc_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_set_pane_vc_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_set_pane_vc_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_set_pane_vc_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_set_pane_vc_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_set_pane_vc_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_set_pane_vc_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_set_pane_vc_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_set_pane_vc_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_set_pane_vc_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_set_pane_vc_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_set_pane_vc_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_set_pane_vc_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_set_pane_vc_g9)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_set_pane_vc_g10(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_set_pane_vc_g10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_set_pane_vc_g10)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits volume_set_pane_vc_g_Limits()		{ return (*(Tvolume_set_pane_vc_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_set_pane_vc_g_Limits)))(); }

inline TAknWindowComponentLayout volume_set_pane_vc_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_set_pane_vc_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_set_pane_vc_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : setting_volume_pane_vc
inline TAknWindowComponentLayout volume_set_pane_vc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_set_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_set_pane_vc)))(aVariety, aCol, aRow); }

// LAF Table : set_content_pane_vc
inline TAknWindowComponentLayout button_value_adjust_pane_cp1_vc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbutton_value_adjust_pane_cp1_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_button_value_adjust_pane_cp1_vc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_highlight_pane_cp2_vc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_cp2_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp2_vc)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_set_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_set_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_set_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_set_pane_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_set_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_set_pane_vc)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_pane_set_vc_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_pane_set_vc_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_set_vc_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_pane_set_vc_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_pane_set_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_set_vc_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_pane_set_vc_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_pane_set_vc_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_set_vc_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_pane_set_vc_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_pane_set_vc_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_set_vc_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_pane_set_vc_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_pane_set_vc_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_set_vc_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_pane_set_vc_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_pane_set_vc_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_set_vc_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_pane_set_vc_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_pane_set_vc_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_set_vc_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_pane_set_vc_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_pane_set_vc_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_set_vc_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_pane_set_vc_t_Limits()		{ return (*(Tmain_pane_set_vc_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_set_vc_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_pane_set_vc_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmain_pane_set_vc_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_set_vc_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout main_pane_set_vc_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_pane_set_vc_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_pane_set_vc_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits setting_code_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tsetting_code_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_code_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout setting_code_pane_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_code_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_code_pane_vc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout setting_slider_graphic_pane_vc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_slider_graphic_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_slider_graphic_pane_vc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout setting_slider_pane_vc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_slider_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_slider_pane_vc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout setting_text_pane_vc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_text_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_text_pane_vc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout setting_volume_pane_vc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsetting_volume_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_setting_volume_pane_vc)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_set_pane_vc
inline TAknWindowComponentLayout scroll_pane_cp121_vc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp121_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp121_vc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout set_content_pane_vc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_content_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_content_pane_vc)))(aVariety, aCol, aRow); }

// LAF Table : button_value_adjust_pane
inline TAknWindowComponentLayout button_value_adjust_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbutton_value_adjust_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_button_value_adjust_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout button_value_adjust_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbutton_value_adjust_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_button_value_adjust_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits button_value_adjust_pane_g_Limits()		{ return (*(Tbutton_value_adjust_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_button_value_adjust_pane_g_Limits)))(); }

inline TAknWindowComponentLayout button_value_adjust_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbutton_value_adjust_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_button_value_adjust_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : form_field_slider_wide_pane_vc
inline TAknLayoutScalableParameterLimits form_field_slider_wide_pane_vc_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_slider_wide_pane_vc_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_wide_pane_vc_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout form_field_slider_wide_pane_vc_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_slider_wide_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_wide_pane_vc_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_field_slider_wide_pane_vc_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_slider_wide_pane_vc_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_wide_pane_vc_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout form_field_slider_wide_pane_vc_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_slider_wide_pane_vc_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_wide_pane_vc_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits form_field_slider_wide_pane_vc_t_Limits()		{ return (*(Tform_field_slider_wide_pane_vc_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_wide_pane_vc_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits form_field_slider_wide_pane_vc_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tform_field_slider_wide_pane_vc_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_wide_pane_vc_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout form_field_slider_wide_pane_vc_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_slider_wide_pane_vc_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_wide_pane_vc_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits input_focus_pane_cp10_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tinput_focus_pane_cp10_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp10_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout input_focus_pane_cp10_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp10_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp10_vc)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits slider_cont_pane_cp1_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tslider_cont_pane_cp1_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_cont_pane_cp1_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout slider_cont_pane_cp1_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_cont_pane_cp1_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_cont_pane_cp1_vc)))(aVariety, aCol, aRow); }

// LAF Table : slider_form_pane_vc
inline TAknWindowComponentLayout slider_form_pane_g1_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_form_pane_g1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_form_pane_g1_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout slider_form_pane_g2_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_form_pane_g2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_form_pane_g2_cp2)))(aVariety, aCol, aRow); }

// LAF Table : slider_cont_pane_vc
inline TAknTextComponentLayout form_field_slider_pane_vc_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_slider_pane_vc_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_pane_vc_t3)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout form_field_slider_pane_vc_t4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_slider_pane_vc_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_pane_vc_t4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits slider_form_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tslider_form_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_form_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout slider_form_pane_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_form_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_form_pane_vc)))(aVariety, aCol, aRow); }

// LAF Table : form_field_slider_pane_vc
inline TAknLayoutScalableParameterLimits form_field_slider_pane_vc_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_slider_pane_vc_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_pane_vc_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout form_field_slider_pane_vc_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_slider_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_pane_vc_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_field_slider_pane_vc_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_slider_pane_vc_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_pane_vc_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout form_field_slider_pane_vc_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_slider_pane_vc_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_pane_vc_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits form_field_slider_pane_vc_t_Limits()		{ return (*(Tform_field_slider_pane_vc_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_pane_vc_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits form_field_slider_pane_vc_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tform_field_slider_pane_vc_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_pane_vc_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout form_field_slider_pane_vc_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_slider_pane_vc_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_pane_vc_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits input_focus_pane_cp9_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tinput_focus_pane_cp9_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp9_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout input_focus_pane_cp9_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp9_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp9_vc)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits slider_cont_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tslider_cont_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_cont_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout slider_cont_pane_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tslider_cont_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_slider_cont_pane_vc)))(aVariety, aCol, aRow); }

// LAF Table : list_form_wide_pane_vc
inline TAknLayoutScalableParameterLimits list_form_graphic_pane_cp_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_form_graphic_pane_cp_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_form_graphic_pane_cp_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_form_graphic_pane_cp_vc(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_form_graphic_pane_cp_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_form_graphic_pane_cp_vc)))(aRow, aVariety, aCol); }

// LAF Table : form_field_popup_wide_pane_vc
inline TAknWindowComponentLayout form_field_popup_wide_pane_vc_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_popup_wide_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_popup_wide_pane_vc_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_field_popup_wide_pane_vc_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_popup_wide_pane_vc_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_popup_wide_pane_vc_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout form_field_popup_wide_pane_vc_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_popup_wide_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_popup_wide_pane_vc_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits input_focus_pane_cp8_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tinput_focus_pane_cp8_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp8_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout input_focus_pane_cp8_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp8_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp8_vc)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_form_wide_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_form_wide_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_form_wide_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_form_wide_pane_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_form_wide_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_form_wide_pane_vc)))(aVariety, aCol, aRow); }

// LAF Table : list_form_graphic_pane_vc
inline TAknWindowComponentLayout list_form_graphic_pane_vc_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_form_graphic_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_form_graphic_pane_vc_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_form_graphic_pane_vc_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_form_graphic_pane_vc_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_form_graphic_pane_vc_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_form_graphic_pane_vc_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_form_graphic_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_form_graphic_pane_vc_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_highlight_pane_cp5_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_highlight_pane_cp5_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp5_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_highlight_pane_cp5_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_cp5_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp5_vc)))(aVariety, aCol, aRow); }

// LAF Table : list_form_pane_vc
inline TAknLayoutScalableParameterLimits list_form_graphic_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_form_graphic_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_form_graphic_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_form_graphic_pane_vc(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_form_graphic_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_form_graphic_pane_vc)))(aRow, aVariety, aCol); }

// LAF Table : form_field_popup_pane_vc
inline TAknWindowComponentLayout form_field_popup_pane_vc_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_popup_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_popup_pane_vc_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_field_popup_pane_vc_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_popup_pane_vc_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_popup_pane_vc_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout form_field_popup_pane_vc_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_popup_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_popup_pane_vc_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits input_focus_pane_cp7_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tinput_focus_pane_cp7_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp7_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout input_focus_pane_cp7_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp7_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp7_vc)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_form_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_form_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_form_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_form_pane_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_form_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_form_pane_vc)))(aVariety, aCol, aRow); }

// LAF Table : data_form_pane_vc
inline TAknLayoutScalableParameterLimits data_form_pane_vc_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tdata_form_pane_vc_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_data_form_pane_vc_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout data_form_pane_vc_t1(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tdata_form_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_data_form_pane_vc_t1)))(aRow, aVariety, aCol); }

// LAF Table : input_focus_pane_vc
inline TAknWindowComponentLayout input_focus_pane_vc_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_vc_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_vc_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_vc_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_vc_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_vc_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_vc_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_vc_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_vc_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_vc_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_vc_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_vc_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_vc_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_vc_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_vc_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_vc_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_vc_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_vc_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_vc_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_vc_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_vc_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_vc_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_vc_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_vc_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_vc_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_vc_g9)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_vc_g10(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_vc_g10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_vc_g10)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits input_focus_pane_vc_g_Limits()		{ return (*(Tinput_focus_pane_vc_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_vc_g_Limits)))(); }

inline TAknWindowComponentLayout input_focus_pane_vc_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_vc_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_vc_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : form_field_data_pane_vc
inline TAknLayoutScalableParameterLimits data_form_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tdata_form_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_data_form_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout data_form_pane_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tdata_form_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_data_form_pane_vc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout form_field_data_pane_vc_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_data_pane_vc_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_data_pane_vc_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_field_data_pane_vc_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_data_pane_vc_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_data_pane_vc_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout form_field_data_pane_vc_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_data_pane_vc_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_data_pane_vc_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits input_focus_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tinput_focus_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout input_focus_pane_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_vc)))(aVariety, aCol, aRow); }

// LAF Table : list_form_gen_pane_vc
inline TAknWindowComponentLayout button_value_adjust_pane_cp3_vc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbutton_value_adjust_pane_cp3_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_button_value_adjust_pane_cp3_vc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout button_value_adjust_pane_cp5_vc(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbutton_value_adjust_pane_cp5_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_button_value_adjust_pane_cp5_vc)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_field_data_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_data_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_data_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout form_field_data_pane_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_data_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_data_pane_vc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout form_field_data_pane_vc_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_data_pane_vc_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_data_pane_vc_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_field_data_wide_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_data_wide_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_data_wide_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout form_field_data_wide_pane_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_data_wide_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_data_wide_pane_vc)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout form_field_data_wide_pane_vc_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_data_wide_pane_vc_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_data_wide_pane_vc_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_field_popup_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_popup_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_popup_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout form_field_popup_pane_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_popup_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_popup_pane_vc)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_field_popup_wide_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_popup_wide_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_popup_wide_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout form_field_popup_wide_pane_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_popup_wide_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_popup_wide_pane_vc)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_field_slider_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_slider_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout form_field_slider_pane_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_slider_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_pane_vc)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form_field_slider_wide_pane_vc_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_field_slider_wide_pane_vc_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_wide_pane_vc_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout form_field_slider_wide_pane_vc(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform_field_slider_wide_pane_vc_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_field_slider_wide_pane_vc)))(aVariety, aCol, aRow); }

// LAF Table : touch_pane
inline TAknLayoutScalableParameterLimits grid_touch_1_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_touch_1_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_touch_1_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_touch_1_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_touch_1_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_touch_1_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_touch_2_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_touch_2_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_touch_2_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_touch_2_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_touch_2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_touch_2_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits touch_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Ttouch_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_touch_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout touch_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttouch_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_touch_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : grid_popup_fast_wide_pane
inline TAknLayoutScalableParameterLimits cell_app_pane_cp_wide_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_app_pane_cp_wide_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_app_pane_cp_wide_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_app_pane_cp_wide(TInt aCol, TInt aVariety = 0, TInt aRow = 0)		{ return (*(Tcell_app_pane_cp_wide_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_app_pane_cp_wide)))(aCol, aVariety, aRow); }

// LAF Table : listscroll_popup_fast_wide_pane
inline TAknLayoutScalableParameterLimits grid_popup_fast_wide_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_popup_fast_wide_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_popup_fast_wide_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_popup_fast_wide_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_popup_fast_wide_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_popup_fast_wide_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits scroll_pane_cp19_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_pane_cp19_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp19_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout scroll_pane_cp19(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp19_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp19)))(aVariety, aCol, aRow); }

// LAF Table : popup_fast_swap_wide_window
inline TAknWindowComponentLayout bg_popup_window_pane_cp20(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp20_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp20)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout listscroll_popup_fast_wide_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_popup_fast_wide_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_popup_fast_wide_pane)))(aVariety, aCol, aRow); }

// LAF Table : indicator_nsta_pane
inline TAknWindowComponentLayout grid_indicator_nsta_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_indicator_nsta_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_indicator_nsta_pane)))(aVariety, aCol, aRow); }

// LAF Table : clock_nsta_pane
inline TAknWindowComponentLayout clock_nsta_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_nsta_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_nsta_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout clock_nsta_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_nsta_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_nsta_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : grid_indicator_nsta_pane
inline TAknLayoutScalableParameterLimits cell_indicator_nsta_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_indicator_nsta_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_indicator_nsta_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_indicator_nsta_pane(TInt aCol, TInt aVariety = 0, TInt aRow = 0)		{ return (*(Tcell_indicator_nsta_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_indicator_nsta_pane)))(aCol, aVariety, aRow); }

// LAF Table : cell_indicator_nsta_pane
inline TAknWindowComponentLayout cell_indicator_nsta_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_indicator_nsta_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_indicator_nsta_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_indicator_nsta_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_indicator_nsta_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_indicator_nsta_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_indicator_nsta_pane_g_Limits()		{ return (*(Tcell_indicator_nsta_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_indicator_nsta_pane_g_Limits)))(); }

inline TAknWindowComponentLayout cell_indicator_nsta_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_indicator_nsta_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_indicator_nsta_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : nsta_clock_indic_pane
inline TAknWindowComponentLayout clock_nsta_pane_cp(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_nsta_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_nsta_pane_cp)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout indicator_nsta_pane_cp(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tindicator_nsta_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_indicator_nsta_pane_cp)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout nsta_clock_indic_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnsta_clock_indic_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_nsta_clock_indic_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : indicator_pane
inline TAknWindowComponentLayout grid_indicator_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_indicator_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_indicator_pane)))(aVariety, aCol, aRow); }

// LAF Table : popup_fep_japan_predictive_window
inline TAknWindowComponentLayout scroll_pane_cp29(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp29_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp29)))(aVariety, aCol, aRow); }

// LAF Table : stacon_top_pane
inline TAknLayoutScalableParameterLimits indicator_nsta_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tindicator_nsta_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_indicator_nsta_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout indicator_nsta_pane_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tindicator_nsta_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_indicator_nsta_pane_cp2)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_apps_wheel_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_apps_wheel_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_apps_wheel_pane)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_form_midp_pane
inline TAknLayoutScalableParameterLimits form_midp_field_text_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tform_midp_field_text_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form_midp_field_text_pane_ParamLimits)))(aVariety); }

// LAF Table : midp_form_pane
inline TAknLayoutScalableParameterLimits scroll_bar_cp050_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_bar_cp050_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_bar_cp050_ParamLimits)))(aVariety); }

// LAF Table : grid_indicator_pane
inline TAknLayoutScalableParameterLimits cell_indicator_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_indicator_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_indicator_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_indicator_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tcell_indicator_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_indicator_pane)))(aRow, aVariety, aCol); }

// LAF Table : cell_indicator_pane
inline TAknWindowComponentLayout cell_indicator_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_indicator_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_indicator_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : main_apps_wheel_pane
inline TAknLayoutScalableParameterLimits grid_wheel_folder_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_wheel_folder_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_wheel_folder_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_wheel_folder_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_wheel_folder_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_wheel_folder_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_wheel_apps_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_wheel_apps_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_wheel_apps_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_wheel_apps_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_wheel_apps_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_wheel_apps_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_apps_wheel_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_apps_wheel_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_apps_wheel_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_apps_wheel_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_apps_wheel_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_apps_wheel_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_apps_wheel_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_apps_wheel_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_apps_wheel_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_apps_wheel_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_apps_wheel_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_apps_wheel_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits main_apps_wheel_pane_g_Limits()		{ return (*(Tmain_apps_wheel_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_apps_wheel_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits main_apps_wheel_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmain_apps_wheel_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_apps_wheel_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout main_apps_wheel_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_apps_wheel_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_apps_wheel_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits main_apps_wheel_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_apps_wheel_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_apps_wheel_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout main_apps_wheel_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_apps_wheel_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_apps_wheel_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : list_wheel_apps_pane
inline TAknWindowComponentLayout list_wheel_apps_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_wheel_apps_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_wheel_apps_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_wheel_apps_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_wheel_apps_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_wheel_apps_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_wheel_apps_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_wheel_apps_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_wheel_apps_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_wheel_apps_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_wheel_apps_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_wheel_apps_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_wheel_apps_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_wheel_apps_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_wheel_apps_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_wheel_apps_pane_g_Limits()		{ return (*(Tlist_wheel_apps_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_wheel_apps_pane_g_Limits)))(); }

inline TAknWindowComponentLayout list_wheel_apps_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_wheel_apps_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_wheel_apps_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : navi_pane
inline TAknWindowComponentLayout navi_icon_text_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_icon_text_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_icon_text_pane)))(aVariety, aCol, aRow); }

// LAF Table : status_pane
inline TAknWindowComponentLayout aid_fill_nsta(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_fill_nsta_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_fill_nsta)))(aVariety, aCol, aRow); }

// LAF Table : navi_icon_text_pane
inline TAknWindowComponentLayout navi_icon_text_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_icon_text_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_icon_text_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout navi_icon_text_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tnavi_icon_text_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_icon_text_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : list_set_graphic_pane
inline TAknLayoutScalableParameterLimits list_set_graphic_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_set_graphic_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_set_graphic_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_set_graphic_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_set_graphic_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_set_graphic_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : popup_midp_note_alarm_window
inline TAknLayoutScalableParameterLimits popup_midp_note_alarm_window_t6_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_midp_note_alarm_window_t6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_t6_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_midp_note_alarm_window_t6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_midp_note_alarm_window_t6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_t6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_midp_note_alarm_window_t7_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_midp_note_alarm_window_t7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_t7_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_midp_note_alarm_window_t7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_midp_note_alarm_window_t7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_t7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_midp_note_alarm_window_t8_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_midp_note_alarm_window_t8_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_t8_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_midp_note_alarm_window_t8(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_midp_note_alarm_window_t8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_t8)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_midp_note_alarm_window_t9_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_midp_note_alarm_window_t9_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_t9_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_midp_note_alarm_window_t9(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_midp_note_alarm_window_t9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_t9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_midp_note_alarm_window_t10_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_midp_note_alarm_window_t10_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_t10_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_midp_note_alarm_window_t10(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_midp_note_alarm_window_t10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_t10)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_midp_note_alarm_window_t11_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_midp_note_alarm_window_t11_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_t11_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_midp_note_alarm_window_t11(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_midp_note_alarm_window_t11_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_midp_note_alarm_window_t11)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits scroll_pane_cp17_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_pane_cp17_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp17_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout scroll_pane_cp17(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp17_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp17)))(aVariety, aCol, aRow); }

// LAF Table : volume_small_pane_cp
inline TAknWindowComponentLayout volume_small_pane_cp_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_cp_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_cp_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small_pane_cp_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_cp_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_cp_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small_pane_cp_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_cp_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_cp_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small_pane_cp_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_cp_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_cp_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small_pane_cp_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_cp_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_cp_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small_pane_cp_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_cp_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_cp_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small_pane_cp_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_cp_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_cp_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small_pane_cp_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_cp_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_cp_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small_pane_cp_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_cp_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_cp_g9)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small_pane_cp_g10(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small_pane_cp_g10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small_pane_cp_g10)))(aVariety, aCol, aRow); }

// LAF Table : midp_ticker_pane
inline TAknLayoutScalableParameterLimits midp_ticker_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmidp_ticker_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_ticker_pane_g1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits midp_ticker_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tmidp_ticker_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_ticker_pane_g2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits midp_ticker_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tmidp_ticker_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_ticker_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknLayoutScalableParameterLimits midp_ticker_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tmidp_ticker_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_ticker_pane_t1_ParamLimits)))(aVariety); }

// LAF Table : status_pane
inline TAknWindowComponentLayout aid_fill_nsta_2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_fill_nsta_2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_fill_nsta_2)))(aVariety, aCol, aRow); }

// LAF Table : midp_form_pane
inline TAknWindowComponentLayout list_form2_midp_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_form2_midp_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_form2_midp_pane)))(aVariety, aCol, aRow); }

// LAF Table : navi_midp_pane
inline TAknLayoutScalableParameterLimits midp_editing_number_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmidp_editing_number_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_editing_number_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits midp_ticker_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmidp_ticker_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_ticker_pane_ParamLimits)))(aVariety); }

// LAF Table : list_form2_midp_pane
inline TAknWindowComponentLayout form2_midp_field_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform2_midp_field_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_field_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp51(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp51_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp51)))(aVariety, aCol, aRow); }

// LAF Table : form2_midp_field_pane
inline TAknLayoutScalableParameterLimits form2_midp_button_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tform2_midp_button_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_button_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout form2_midp_button_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform2_midp_button_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_button_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form2_midp_content_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tform2_midp_content_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_content_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout form2_midp_content_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform2_midp_content_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_content_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout form2_midp_field_choice_group_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform2_midp_field_choice_group_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_field_choice_group_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout form2_midp_field_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform2_midp_field_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_field_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout form2_midp_field_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform2_midp_field_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_field_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout form2_midp_field_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform2_midp_field_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_field_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout form2_midp_field_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform2_midp_field_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_field_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits form2_midp_field_pane_g_Limits()		{ return (*(Tform2_midp_field_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_field_pane_g_Limits)))(); }

inline TAknWindowComponentLayout form2_midp_field_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform2_midp_field_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_field_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout form2_midp_gauge_slider_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform2_midp_gauge_slider_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_gauge_slider_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout form2_midp_gauge_wait_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform2_midp_gauge_wait_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_gauge_wait_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form2_midp_image_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tform2_midp_image_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_image_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout form2_midp_image_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform2_midp_image_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_image_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form2_midp_label_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tform2_midp_label_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_label_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout form2_midp_label_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform2_midp_label_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_label_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form2_midp_label_pane_cp_ParamLimits(TInt aVariety = 0)		{ return (*(Tform2_midp_label_pane_cp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_label_pane_cp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout form2_midp_label_pane_cp(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform2_midp_label_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_label_pane_cp)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form2_midp_string_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tform2_midp_string_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_string_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout form2_midp_string_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform2_midp_string_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_string_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form2_midp_text_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tform2_midp_text_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_text_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout form2_midp_text_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform2_midp_text_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_text_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout form2_midp_time_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform2_midp_time_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_time_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits input_focus_pane_cp51_ParamLimits(TInt aVariety = 0)		{ return (*(Tinput_focus_pane_cp51_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp51_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout input_focus_pane_cp51(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp51_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp51)))(aVariety, aCol, aRow); }

// LAF Table : form2_midp_label_pane
inline TAknLayoutScalableParameterLimits form2_midp_label_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tform2_midp_label_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_label_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout form2_midp_label_pane_t1(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tform2_midp_label_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_label_pane_t1)))(aRow, aVariety, aCol); }

// LAF Table : form2_midp_text_pane
inline TAknLayoutScalableParameterLimits form2_mdip_text_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tform2_mdip_text_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_mdip_text_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout form2_mdip_text_pane_t1(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tform2_mdip_text_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_mdip_text_pane_t1)))(aRow, aVariety, aCol); }

// LAF Table : form2_midp_time_pane
inline TAknTextComponentLayout form2_midp_time_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform2_midp_time_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_time_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : form2_midp_gauge_slider_pane
inline TAknTextComponentLayout form2_midp_gauge_slider_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform2_midp_gauge_slider_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_gauge_slider_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout form2_midp_gauge_slider_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform2_midp_gauge_slider_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_gauge_slider_pane_t2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout form2_midp_gauge_slider_pane_t3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform2_midp_gauge_slider_pane_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_gauge_slider_pane_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits form2_midp_gauge_slider_pane_t_Limits()		{ return (*(Tform2_midp_gauge_slider_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_gauge_slider_pane_t_Limits)))(); }

inline TAknTextComponentLayout form2_midp_gauge_slider_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform2_midp_gauge_slider_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_gauge_slider_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout form2_midp_slider_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform2_midp_slider_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_slider_pane)))(aVariety, aCol, aRow); }

// LAF Table : form2_midp_gauge_wait_pane
inline TAknTextComponentLayout form2_midp_gauge_wait_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform2_midp_gauge_wait_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_gauge_wait_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits form2_midp_wait_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tform2_midp_wait_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_wait_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout form2_midp_wait_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform2_midp_wait_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_wait_pane)))(aVariety, aCol, aRow); }

// LAF Table : form2_midp_field_choice_group_pane
inline TAknLayoutScalableParameterLimits list_single_2graphic_pane_cp4_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_2graphic_pane_cp4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_cp4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_2graphic_pane_cp4(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_2graphic_pane_cp4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_cp4)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_single_midp_graphic_pane_cp_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_midp_graphic_pane_cp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_midp_graphic_pane_cp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_midp_graphic_pane_cp(TInt aVariety, TInt aRow, TInt aCol = 0)		{ return (*(Tlist_single_midp_graphic_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_midp_graphic_pane_cp)))(aVariety, aRow, aCol); }

// LAF Table : list_single_2graphic_pane_cp4
inline TAknWindowComponentLayout list_highlight_pane_cp20(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_cp20_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp20)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_single_2graphic_pane_g1_cp4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_2graphic_pane_g1_cp4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g1_cp4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_single_2graphic_pane_g2_cp4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_2graphic_pane_g2_cp4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_g2_cp4)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout list_single_2graphic_pane_t1_cp4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_2graphic_pane_t1_cp4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_2graphic_pane_t1_cp4)))(aVariety, aCol, aRow); }

// LAF Table : list_single_midp_graphic_pane_cp
inline TAknWindowComponentLayout list_highlight_pane_cp21(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_cp21_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp21)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_single_midp_graphic_pane_g4_cp(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_midp_graphic_pane_g4_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_midp_graphic_pane_g4_cp)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout list_single_midp_graphic_pane_t1_cp(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_midp_graphic_pane_t1_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_midp_graphic_pane_t1_cp)))(aVariety, aCol, aRow); }

// LAF Table : form2_midp_string_pane
inline TAknLayoutScalableParameterLimits form2_mdip_string_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tform2_mdip_string_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_mdip_string_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout form2_mdip_string_pane_t1(TInt aVariety, TInt aRow, TInt aCol = 0)		{ return (*(Tform2_mdip_string_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_mdip_string_pane_t1)))(aVariety, aRow, aCol); }

// LAF Table : form2_midp_button_pane
inline TAknWindowComponentLayout bg_wml_button_pane_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_wml_button_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_wml_button_pane_cp2)))(aVariety, aCol, aRow); }

// LAF Table : form2_midp_image_pane
inline TAknWindowComponentLayout form2_midp_image_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tform2_midp_image_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_form2_midp_image_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : list_double_large_graphic_pane
inline TAknLayoutScalableParameterLimits list_double_large_graphic_pane_g5_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_large_graphic_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_large_graphic_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_large_graphic_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_large_graphic_pane_g5)))(aVariety, aCol, aRow); }

// LAF Table : main_midp_pane
inline TAknLayoutScalableParameterLimits midp_form_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmidp_form_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_midp_form_pane_ParamLimits)))(aVariety); }

// LAF Table : main_pane
inline TAknLayoutScalableParameterLimits main_apps_wheel_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_apps_wheel_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_apps_wheel_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits popup_preview_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_preview_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_preview_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_preview_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_touch_info_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_touch_info_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_touch_info_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_touch_info_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_touch_info_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_touch_info_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_touch_menu_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_touch_menu_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_touch_menu_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_touch_menu_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_touch_menu_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_touch_menu_window)))(aVariety, aCol, aRow); }

// LAF Table : popup_touch_menu_window
inline TAknWindowComponentLayout bg_popup_sub_pane_cp6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_touch_menu_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_touch_menu_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_touch_menu_pane)))(aVariety, aCol, aRow); }

// LAF Table : list_touch_menu_pane
inline TAknLayoutScalableParameterLimits list_single_touch_menu_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_touch_menu_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_touch_menu_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_touch_menu_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_touch_menu_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_touch_menu_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_single_touch_menu_pane
inline TAknTextComponentLayout list_single_touch_menu_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_touch_menu_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_touch_menu_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : popup_touch_info_window
inline TAknLayoutScalableParameterLimits bg_popup_sub_pane_cp7_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_sub_pane_cp7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp7_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_sub_pane_cp7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout heading_sub_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_sub_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_sub_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_touch_info_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_touch_info_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_touch_info_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_touch_info_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_touch_info_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_touch_info_pane)))(aVariety, aCol, aRow); }

// LAF Table : list_touch_info_pane
inline TAknLayoutScalableParameterLimits list_single_touch_info_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_touch_info_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_touch_info_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_touch_info_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_touch_info_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_touch_info_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_single_touch_info_pane
inline TAknTextComponentLayout list_single_touch_info_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_touch_info_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_touch_info_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout list_single_touch_info_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_touch_info_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_touch_info_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_touch_info_pane_t_Limits()		{ return (*(Tlist_single_touch_info_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_touch_info_pane_t_Limits)))(); }

inline TAknTextComponentLayout list_single_touch_info_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_touch_info_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_touch_info_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : heading_sub_pane
inline TAknWindowComponentLayout bg_popup_heading_pane_cp(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_heading_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_heading_pane_cp)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout heading_sub_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_sub_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_sub_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : popup_preview_window
inline TAknLayoutScalableParameterLimits bg_popup_preview_window_pane_cp_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_preview_window_pane_cp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_preview_window_pane_cp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_preview_window_pane_cp(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_preview_window_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_preview_window_pane_cp)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout heading_preview_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_preview_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_preview_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_preview_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_preview_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_preview_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_preview_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_preview_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_preview_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_preview_window_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_preview_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_window_g1)))(aVariety, aCol, aRow); }

// LAF Table : list_preview_pane
inline TAknLayoutScalableParameterLimits list_single_preview_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_preview_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_preview_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_preview_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_preview_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_preview_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_single_preview_pane
inline TAknWindowComponentLayout list_single_preview_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_preview_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_preview_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout list_single_preview_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_preview_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_preview_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout list_single_preview_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_preview_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_preview_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_preview_pane_t_Limits()		{ return (*(Tlist_single_preview_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_preview_pane_t_Limits)))(); }

inline TAknTextComponentLayout list_single_preview_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_preview_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_preview_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : heading_preview_pane
inline TAknLayoutScalableParameterLimits bg_popup_heading_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_heading_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_heading_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_heading_pane_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_heading_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_heading_pane_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout heading_preview_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_preview_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_preview_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits heading_preview_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Theading_preview_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_preview_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout heading_preview_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_preview_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_preview_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : soft_indicator_pane
inline TAknLayoutScalableParameterLimits soft_indicator_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tsoft_indicator_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_soft_indicator_pane_t1_ParamLimits)))(aVariety); }

// LAF Table : listscroll_gen_pane
inline TAknLayoutScalableParameterLimits scroll_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_ParamLimits)))(aVariety); }

// LAF Table : scroll_pane
inline TAknWindowComponentLayout scroll_sc2_left_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_sc2_left_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_sc2_left_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_sc2_right_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_sc2_right_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_sc2_right_pane)))(aVariety, aCol, aRow); }

// LAF Table : bg_scroll_pane
inline TAknLayoutScalableParameterLimits scroll_bg_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_bg_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_bg_pane_g1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits scroll_bg_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_bg_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_bg_pane_g2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits scroll_bg_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_bg_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_bg_pane_g3_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits scroll_bg_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tscroll_bg_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_bg_pane_g_ParamLimits)))(aLineIndex, aVariety); }

// LAF Table : scroll_handle_pane
inline TAknLayoutScalableParameterLimits scroll_handle_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_handle_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_handle_pane_g1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits scroll_handle_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_handle_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_handle_pane_g2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits scroll_handle_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_handle_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_handle_pane_g3_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits scroll_handle_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tscroll_handle_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_handle_pane_g_ParamLimits)))(aLineIndex, aVariety); }

// LAF Table : main_pane
inline TAknLayoutScalableParameterLimits popup_choice_list_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_choice_list_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_choice_list_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_choice_list_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_choice_list_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_choice_list_window)))(aVariety, aCol, aRow); }

// LAF Table : popup_toolbar_window
inline TAknWindowComponentLayout choice_list_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tchoice_list_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_choice_list_pane)))(aVariety, aCol, aRow); }

// LAF Table : cell_toolbar_pane
inline TAknTextComponentLayout cell_toolbar_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_toolbar_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_toolbar_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits toolbar_button_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Ttoolbar_button_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_toolbar_button_pane_ParamLimits)))(aVariety); }

// LAF Table : ai_gene_pane_1
inline TAknLayoutScalableParameterLimits ai_gene_pane_1_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tai_gene_pane_1_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_gene_pane_1_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout ai_gene_pane_1_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai_gene_pane_1_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_gene_pane_1_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits ai_gene_pane_1_t_Limits()		{ return (*(Tai_gene_pane_1_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_gene_pane_1_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits ai_gene_pane_1_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tai_gene_pane_1_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_gene_pane_1_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout ai_gene_pane_1_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tai_gene_pane_1_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ai_gene_pane_1_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : scroll_sc2_left_pane
inline TAknWindowComponentLayout scroll_sc2_left_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_sc2_left_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_sc2_left_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : scroll_sc2_right_pane
inline TAknWindowComponentLayout scroll_sc2_right_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_sc2_right_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_sc2_right_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : popup_choice_list_window
inline TAknWindowComponentLayout bg_popup_sub_pane_cp10(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_sub_pane_cp10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp10)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_choice_list_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_choice_list_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_choice_list_pane)))(aVariety, aCol, aRow); }

// LAF Table : list_choice_list_pane
inline TAknLayoutScalableParameterLimits list_single_choice_list_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_choice_list_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_choice_list_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_choice_list_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_choice_list_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_choice_list_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_single_choice_list_pane
inline TAknWindowComponentLayout list_single_choice_list_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_choice_list_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_choice_list_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_choice_list_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_choice_list_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_choice_list_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_choice_list_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_choice_list_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_choice_list_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : choice_list_pane
inline TAknWindowComponentLayout choice_list_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tchoice_list_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_choice_list_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout choice_list_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tchoice_list_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_choice_list_pane_t1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_cp11(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp11_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp11)))(aVariety, aCol, aRow); }

// LAF Table : title_pane_stacon
inline TAknLayoutScalableParameterLimits title_pane_stacon_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Ttitle_pane_stacon_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_stacon_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout title_pane_stacon_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttitle_pane_stacon_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_stacon_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits title_pane_stacon_g_Limits()		{ return (*(Ttitle_pane_stacon_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_stacon_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits title_pane_stacon_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Ttitle_pane_stacon_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_stacon_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout title_pane_stacon_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Ttitle_pane_stacon_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_stacon_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : texts_graphics
inline TAknWindowComponentLayout cursor_press_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcursor_press_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cursor_press_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknLayoutScalableParameterLimits popup_fep_hwr_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_fep_hwr_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fep_hwr_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_fep_hwr_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_fep_hwr_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fep_hwr_window)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_fep_vkb_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_fep_vkb_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fep_vkb_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_fep_vkb_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_fep_vkb_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fep_vkb_window)))(aVariety, aCol, aRow); }

// LAF Table : cursor_press_pane
inline TAknWindowComponentLayout cursor_press_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcursor_press_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cursor_press_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : fep_vkb_side_pane
inline TAknLayoutScalableTableLimits fep_vkb_side_pane_g_Limits()		{ return (*(Tfep_vkb_side_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_side_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits fep_vkb_side_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tfep_vkb_side_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_side_pane_g_ParamLimits)))(aLineIndex, aVariety); }

// LAF Table : popup_fep_hwr_window
inline TAknLayoutScalableParameterLimits fep_hwr_candidate_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_hwr_candidate_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_hwr_candidate_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_candidate_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_hwr_side_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_hwr_side_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_side_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_hwr_side_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_side_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_side_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_hwr_top_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_hwr_top_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_top_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_hwr_top_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_top_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_top_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_hwr_write_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_hwr_write_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_write_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_hwr_write_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_write_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_write_pane)))(aVariety, aCol, aRow); }

// LAF Table : fep_vkb_side_pane
inline TAknWindowComponentLayout fep_vkb_side_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_side_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_side_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : fep_hwr_top_pane
inline TAknWindowComponentLayout fep_hwr_top_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_top_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_top_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout fep_hwr_top_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_top_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_top_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout fep_hwr_top_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_top_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_top_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits fep_hwr_top_pane_g_Limits()		{ return (*(Tfep_hwr_top_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_top_pane_g_Limits)))(); }

inline TAknWindowComponentLayout fep_hwr_top_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_top_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_top_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout fep_hwr_top_text_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_top_text_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_top_text_pane)))(aVariety, aCol, aRow); }

// LAF Table : fep_hwr_top_text_pane
inline TAknWindowComponentLayout fep_hwr_top_text_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_top_text_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_top_text_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout fep_hwr_top_text_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_top_text_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_top_text_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : fep_hwr_candidate_pane
inline TAknWindowComponentLayout fep_hwr_candidate_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_candidate_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : fep_vkb_keypad_pane
inline TAknLayoutScalableParameterLimits fep_vkb_keypad_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_keypad_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_keypad_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_keypad_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_keypad_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_keypad_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_vkb_keypad_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_keypad_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_keypad_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_keypad_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_keypad_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_keypad_pane_g4)))(aVariety, aCol, aRow); }

// LAF Table : fep_vkb_bottom_pane
inline TAknLayoutScalableParameterLimits fep_vkb_bottom_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_bottom_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_bottom_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_bottom_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_bottom_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_bottom_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits fep_vkb_bottom_pane_g_Limits()		{ return (*(Tfep_vkb_bottom_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_bottom_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits fep_vkb_bottom_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tfep_vkb_bottom_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_bottom_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout fep_vkb_bottom_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_bottom_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_bottom_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : cell_vkb_side_pane
inline TAknWindowComponentLayout cell_vkb_side_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vkb_side_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_side_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_vkb_side_pane_g_Limits()		{ return (*(Tcell_vkb_side_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_side_pane_g_Limits)))(); }

inline TAknWindowComponentLayout cell_vkb_side_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vkb_side_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_side_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout cell_vkb_side_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vkb_side_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_side_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cell_vkb_side_pane_t1_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vkb_side_pane_t1_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_side_pane_t1_copy1)))(aVariety, aCol, aRow); }

// LAF Table : fep_vkb_candidate_pane
inline TAknWindowComponentLayout bg_fep_vkb_candidate_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_fep_vkb_candidate_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_fep_vkb_candidate_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_vkb_candidate_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_vkb_candidate_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_candidate_pane_ParamLimits)))(aVariety); }

// LAF Table : popup_fep_vkb_window
inline TAknLayoutScalableParameterLimits aid_size_cell_vkb_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_size_cell_vkb_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_vkb_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_size_cell_vkb(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_vkb_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_vkb)))(aVariety, aCol, aRow); }

// LAF Table : fep_vkb_candidate_pane
inline TAknWindowComponentLayout cell_vkb_candidate_pane(TInt aCol, TInt aVariety = 0, TInt aRow = 0)		{ return (*(Tcell_vkb_candidate_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_candidate_pane)))(aCol, aVariety, aRow); }

// LAF Table : bg_popup_fep_shadow_pane
inline TAknWindowComponentLayout bg_popup_fep_shadow_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_fep_shadow_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_fep_shadow_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : popup_fep_vkb_window
inline TAknLayoutScalableParameterLimits fep_vkb_bottom_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_bottom_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_bottom_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_bottom_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_bottom_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_bottom_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_vkb_candidate_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_candidate_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_candidate_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_candidate_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_vkb_keypad_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_keypad_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_keypad_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_keypad_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_keypad_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_keypad_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_vkb_side_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_side_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_side_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_side_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_side_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_side_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_vkb_top_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_top_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_top_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_top_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_top_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_top_pane)))(aVariety, aCol, aRow); }

// LAF Table : fep_vkb_top_pane
inline TAknLayoutScalableParameterLimits fep_vkb_top_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_top_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_top_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_top_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_top_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_top_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_vkb_top_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_top_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_top_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_top_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_top_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_top_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_vkb_top_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_top_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_top_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_top_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_top_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_top_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits fep_vkb_top_pane_g_Limits()		{ return (*(Tfep_vkb_top_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_top_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits fep_vkb_top_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tfep_vkb_top_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_top_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout fep_vkb_top_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_top_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_top_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_vkb_top_text_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_top_text_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_top_text_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_top_text_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_top_text_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_top_text_pane)))(aVariety, aCol, aRow); }

// LAF Table : fep_vkb_side_pane
inline TAknLayoutScalableParameterLimits fep_vkb_side_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_side_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_side_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_side_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_side_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_side_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_vkb_side_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_vkb_side_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_vkb_side_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_vkb_side_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_vkb_side_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_vkb_side_pane)))(aVariety, aCol, aRow); }

// LAF Table : bg_popup_fep_shadow_pane
inline TAknWindowComponentLayout bg_popup_fep_shadow_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_fep_shadow_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_fep_shadow_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_fep_shadow_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_fep_shadow_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_fep_shadow_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_fep_shadow_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_fep_shadow_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_fep_shadow_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_fep_shadow_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_fep_shadow_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_fep_shadow_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_fep_shadow_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_fep_shadow_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_fep_shadow_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_fep_shadow_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_fep_shadow_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_fep_shadow_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_fep_shadow_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_fep_shadow_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_fep_shadow_pane_g8)))(aVariety, aCol, aRow); }

// LAF Table : fep_vkb_keypad_pane
inline TAknLayoutScalableParameterLimits grid_vkb_keypad_number_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_vkb_keypad_number_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_vkb_keypad_number_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_vkb_keypad_number_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_vkb_keypad_number_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_vkb_keypad_number_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_vkb_keypad_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_vkb_keypad_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_vkb_keypad_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_vkb_keypad_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_vkb_keypad_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_vkb_keypad_pane)))(aVariety, aCol, aRow); }

// LAF Table : fep_vkb_bottom_pane
inline TAknLayoutScalableParameterLimits fep_vkb_bottom_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_bottom_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_bottom_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_bottom_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_bottom_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_bottom_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_vkb_keypad_bottom_left_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_vkb_keypad_bottom_left_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_vkb_keypad_bottom_left_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_vkb_keypad_bottom_left_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_vkb_keypad_bottom_left_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_vkb_keypad_bottom_left_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_vkb_keypad_bottom_right_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_vkb_keypad_bottom_right_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_vkb_keypad_bottom_right_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_vkb_keypad_bottom_right_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_vkb_keypad_bottom_right_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_vkb_keypad_bottom_right_pane)))(aVariety, aCol, aRow); }

// LAF Table : fep_vkb_top_text_pane
inline TAknWindowComponentLayout fep_vkb_top_text_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_top_text_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_top_text_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout fep_vkb_top_text_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_top_text_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_top_text_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : grid_vkb_side_pane
inline TAknLayoutScalableParameterLimits cell_vkb_side_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_vkb_side_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_side_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_vkb_side_pane(TInt aVariety, TInt aRow, TInt aCol = 0)		{ return (*(Tcell_vkb_side_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_side_pane)))(aVariety, aRow, aCol); }

// LAF Table : cell_vkb_side_pane
inline TAknWindowComponentLayout cell_vkb_side_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vkb_side_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_side_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : grid_vkb_keypad_pane
inline TAknLayoutScalableParameterLimits cell_vkb_keypad_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_vkb_keypad_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_keypad_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_vkb_keypad_pane(TInt aVariety, TInt aCol, TInt aRow)		{ return (*(Tcell_vkb_keypad_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_keypad_pane)))(aVariety, aCol, aRow); }

// LAF Table : cell_vkb_keypad_pane
inline TAknWindowComponentLayout cell_vkb_keypad_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vkb_keypad_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_keypad_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : bg_popup_fep_shadow_pane
inline TAknLayoutScalableTableLimits bg_popup_fep_shadow_pane_g_Limits()		{ return (*(Tbg_popup_fep_shadow_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_fep_shadow_pane_g_Limits)))(); }

inline TAknWindowComponentLayout bg_popup_fep_shadow_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_fep_shadow_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_fep_shadow_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : cell_hwr_side_pane
inline TAknWindowComponentLayout cell_hwr_side_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_hwr_side_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_side_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_hwr_side_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_hwr_side_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_side_pane_g2)))(aVariety, aCol, aRow); }

// LAF Table : cell_vkb_keypad_pane
inline TAknTextComponentLayout cell_vkb_keypad_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vkb_keypad_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_keypad_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : grid_vkb_keypad_bottom_left_pane
inline TAknLayoutScalableParameterLimits cell_vkb_keypad_bottom_left_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_vkb_keypad_bottom_left_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_keypad_bottom_left_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_vkb_keypad_bottom_left_pane(TInt aVariety, TInt aCol, TInt aRow = 0)		{ return (*(Tcell_vkb_keypad_bottom_left_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_keypad_bottom_left_pane)))(aVariety, aCol, aRow); }

// LAF Table : grid_vkb_keypad_bottom_right_pane
inline TAknLayoutScalableParameterLimits cell_vkb_keypad_bottom_right_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_vkb_keypad_bottom_right_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_keypad_bottom_right_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_vkb_keypad_bottom_right_pane(TInt aVariety, TInt aCol, TInt aRow = 0)		{ return (*(Tcell_vkb_keypad_bottom_right_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_keypad_bottom_right_pane)))(aVariety, aCol, aRow); }

// LAF Table : cell_vkb_keypad_bottom_left_pane
inline TAknWindowComponentLayout cell_vkb_keypad_bottom_left_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vkb_keypad_bottom_left_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_keypad_bottom_left_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : cell_vkb_keypad_bottom_right_pane
inline TAknWindowComponentLayout cell_vkb_keypad_bottom_right_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vkb_keypad_bottom_right_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_keypad_bottom_right_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : grid_vkb_keypad_number_pane
inline TAknLayoutScalableParameterLimits cell_vkb_keypad_number_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_vkb_keypad_number_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_keypad_number_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_vkb_keypad_number_pane(TInt aVariety, TInt aCol, TInt aRow)		{ return (*(Tcell_vkb_keypad_number_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_keypad_number_pane)))(aVariety, aCol, aRow); }

// LAF Table : cell_vkb_keypad_number_pane
inline TAknWindowComponentLayout cell_vkb_keypad_number_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vkb_keypad_number_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_keypad_number_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_vkb_keypad_number_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vkb_keypad_number_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_keypad_number_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_vkb_keypad_number_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vkb_keypad_number_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_keypad_number_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_vkb_keypad_number_pane_g_Limits()		{ return (*(Tcell_vkb_keypad_number_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_keypad_number_pane_g_Limits)))(); }

inline TAknWindowComponentLayout cell_vkb_keypad_number_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vkb_keypad_number_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_keypad_number_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout cell_vkb_keypad_number_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vkb_keypad_number_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_keypad_number_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : fep_vkb_candidate_pane
inline TAknWindowComponentLayout fep_vkb_candidate_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_candidate_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : cell_hwr_side_pane
inline TAknLayoutScalableTableLimits cell_hwr_side_pane_g_Limits()		{ return (*(Tcell_hwr_side_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_side_pane_g_Limits)))(); }

inline TAknWindowComponentLayout cell_hwr_side_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_hwr_side_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_side_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout cell_hwr_side_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_hwr_side_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_side_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cell_hwr_side_pane_t1_copy1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_hwr_side_pane_t1_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_side_pane_t1_copy1)))(aVariety, aCol, aRow); }

// LAF Table : cell_hwr_candidate_pane
inline TAknWindowComponentLayout cell_hwr_candidate_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_hwr_candidate_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_candidate_pane_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cell_hwr_candidate_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_hwr_candidate_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_candidate_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : cell_vkb_candidate_pane
inline TAknWindowComponentLayout cell_vkb_candidate_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vkb_candidate_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_candidate_pane_g2)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout cell_vkb_candidate_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vkb_candidate_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_candidate_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : popup_fep_hwr_window
inline TAknLayoutScalableParameterLimits bg_popup_fep_shadow_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_fep_shadow_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_fep_shadow_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_fep_shadow_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_fep_shadow_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_fep_shadow_pane)))(aVariety, aCol, aRow); }

// LAF Table : fep_hwr_top_pane
inline TAknWindowComponentLayout bg_fep_hwr_top_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_fep_hwr_top_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_fep_hwr_top_pane_g4)))(aVariety, aCol, aRow); }

// LAF Table : fep_hwr_side_pane
inline TAknLayoutScalableParameterLimits bg_hwr_side_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_hwr_side_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_hwr_side_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_hwr_side_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_hwr_side_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_hwr_side_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_hwr_side_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_hwr_side_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_side_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_hwr_side_pane(TInt aVariety, TInt aRow, TInt aCol = 0)		{ return (*(Tcell_hwr_side_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_side_pane)))(aVariety, aRow, aCol); }

// LAF Table : fep_hwr_write_pane
inline TAknLayoutScalableParameterLimits fep_hwr_write_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_hwr_write_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_write_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_hwr_write_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_write_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_write_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_hwr_write_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_hwr_write_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_write_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_hwr_write_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_write_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_write_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_hwr_write_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_hwr_write_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_write_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_hwr_write_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_write_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_write_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_hwr_write_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_hwr_write_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_write_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_hwr_write_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_write_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_write_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits fep_hwr_write_pane_g_Limits()		{ return (*(Tfep_hwr_write_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_write_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits fep_hwr_write_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tfep_hwr_write_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_write_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout fep_hwr_write_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_write_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_write_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : fep_hwr_candidate_pane
inline TAknLayoutScalableParameterLimits bg_fep_hwr_candidate_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_fep_hwr_candidate_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_fep_hwr_candidate_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_fep_hwr_candidate_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_fep_hwr_candidate_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_fep_hwr_candidate_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_hwr_candidate_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_hwr_candidate_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_candidate_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_hwr_candidate_pane(TInt aVariety, TInt aCol, TInt aRow = 0)		{ return (*(Tcell_hwr_candidate_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_candidate_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_hwr_candidate_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_hwr_candidate_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_pane_g1_ParamLimits)))(aVariety); }

// LAF Table : popup_fep_vkb_window
inline TAknLayoutScalableParameterLimits bg_popup_fep_shadow_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_fep_shadow_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_fep_shadow_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_fep_shadow_pane_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_fep_shadow_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_fep_shadow_pane_cp2)))(aVariety, aCol, aRow); }

// LAF Table : fep_vkb_top_pane
inline TAknLayoutScalableParameterLimits fep_vkb_top_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_top_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_top_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_top_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_top_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_top_pane_g4)))(aVariety, aCol, aRow); }

// LAF Table : fep_vkb_side_pane
inline TAknLayoutScalableParameterLimits fep_vkb_side_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_side_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_side_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_side_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_side_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_side_pane_g2)))(aVariety, aCol, aRow); }

// LAF Table : list_setting_pane
inline TAknLayoutScalableParameterLimits list_setting_pane_t4_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_setting_pane_t4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_t4_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_setting_pane_t4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_pane_t4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_pane_t4)))(aVariety, aCol, aRow); }

// LAF Table : list_setting_number_pane
inline TAknLayoutScalableParameterLimits list_setting_number_pane_t5_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_setting_number_pane_t5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_t5_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_setting_number_pane_t5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_setting_number_pane_t5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_setting_number_pane_t5)))(aVariety, aCol, aRow); }

// LAF Table : list_menu_pane
inline TAknLayoutScalableParameterLimits list_double_heading_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_heading_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_heading_pane_cp2(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_double_heading_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_cp2)))(aRow, aVariety, aCol); }

// LAF Table : list_double_heading_pane_cp2
inline TAknLayoutScalableParameterLimits list_double_heading_pane_g1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_heading_pane_g1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_g1_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_heading_pane_g1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_heading_pane_g1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_g1_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_heading_pane_g2_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_heading_pane_g2_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_g2_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_double_heading_pane_g2_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_heading_pane_g2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_g2_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_heading_pane_t1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_heading_pane_t1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_t1_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_heading_pane_t1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_heading_pane_t1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_t1_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_double_heading_pane_t2_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_double_heading_pane_t2_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_t2_cp2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_double_heading_pane_t2_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_double_heading_pane_t2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_double_heading_pane_t2_cp2)))(aVariety, aCol, aRow); }

// LAF Table : Screen
inline TAknWindowComponentLayout aid_value_unit2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_value_unit2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_value_unit2)))(aVariety, aCol, aRow); }

// LAF Table : application_window
inline TAknWindowComponentLayout popup_preview_fixed_window(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_preview_fixed_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_fixed_window)))(aVariety, aCol, aRow); }

// LAF Table : popup_preview_fixed_window
inline TAknWindowComponentLayout bg_popup_preview_window_pane_cp02(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_preview_window_pane_cp02_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_preview_window_pane_cp02)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout list_preview_fixed_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_preview_fixed_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_preview_fixed_pane)))(aVariety, aCol, aRow); }

// LAF Table : list_preview_fixed_pane
inline TAknLayoutScalableParameterLimits list_empty_pane_fp_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_empty_pane_fp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_empty_pane_fp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_empty_pane_fp(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_empty_pane_fp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_empty_pane_fp)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_single_cale_day_pane_fp_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_cale_day_pane_fp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_cale_day_pane_fp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_cale_day_pane_fp(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_cale_day_pane_fp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_cale_day_pane_fp)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_fp_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_fp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_fp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_heading_pane_fp(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_graphic_heading_pane_fp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_fp)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_single_graphic_pane_fp_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_pane_fp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_fp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_pane_fp(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_graphic_pane_fp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_fp)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_single_heading_pane_fp_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_heading_pane_fp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_fp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_heading_pane_fp(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_heading_pane_fp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_fp)))(aRow, aVariety, aCol); }

inline TAknLayoutScalableParameterLimits list_single_pane_fp_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_pane_fp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_fp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_pane_fp(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_pane_fp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_fp)))(aRow, aVariety, aCol); }

// LAF Table : list_single_pane_fp
inline TAknLayoutScalableParameterLimits list_single_pane_fp_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_pane_fp_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_fp_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_pane_fp_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_pane_fp_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_fp_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_pane_fp_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_pane_fp_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_fp_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_pane_fp_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_pane_fp_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_fp_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_pane_fp_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_pane_fp_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_fp_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_pane_fp_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_pane_fp_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_fp_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_pane_fp_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_pane_fp_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_fp_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_pane_fp_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_pane_fp_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_fp_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_pane_fp_g_Limits()		{ return (*(Tlist_single_pane_fp_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_fp_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_pane_fp_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_pane_fp_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_fp_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_single_pane_fp_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_pane_fp_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_fp_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_pane_fp_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_pane_fp_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_fp_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_pane_fp_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_pane_fp_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_pane_fp_t1)))(aVariety, aCol, aRow); }

// LAF Table : list_single_graphic_pane_fp
inline TAknLayoutScalableParameterLimits list_single_graphic_pane_fp_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_pane_fp_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_fp_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_pane_fp_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_pane_fp_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_fp_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_pane_fp_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_pane_fp_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_fp_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_pane_fp_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_pane_fp_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_fp_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_pane_fp_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_pane_fp_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_fp_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_pane_fp_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_pane_fp_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_fp_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_pane_fp_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_pane_fp_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_fp_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_pane_fp_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_pane_fp_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_fp_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_pane_fp_g5_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_pane_fp_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_fp_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_pane_fp_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_pane_fp_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_fp_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_graphic_pane_fp_g_Limits()		{ return (*(Tlist_single_graphic_pane_fp_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_fp_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_graphic_pane_fp_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_graphic_pane_fp_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_fp_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_single_graphic_pane_fp_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_pane_fp_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_fp_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_pane_fp_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_pane_fp_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_fp_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_graphic_pane_fp_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_pane_fp_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_pane_fp_t1)))(aVariety, aCol, aRow); }

// LAF Table : list_single_graphic_heading_pane_fp
inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_fp_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_fp_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_fp_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_heading_pane_fp_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_fp_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_fp_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_fp_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_fp_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_fp_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_heading_pane_fp_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_fp_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_fp_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_fp_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_fp_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_fp_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_heading_pane_fp_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_fp_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_fp_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_fp_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_fp_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_fp_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_heading_pane_fp_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_fp_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_fp_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_fp_g5_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_fp_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_fp_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_heading_pane_fp_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_fp_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_fp_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_graphic_heading_pane_fp_g_Limits()		{ return (*(Tlist_single_graphic_heading_pane_fp_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_fp_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_fp_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_fp_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_fp_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_single_graphic_heading_pane_fp_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_fp_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_fp_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_fp_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_fp_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_fp_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_graphic_heading_pane_fp_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_fp_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_fp_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_fp_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_fp_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_fp_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_graphic_heading_pane_fp_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_fp_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_fp_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_graphic_heading_pane_fp_t_Limits()		{ return (*(Tlist_single_graphic_heading_pane_fp_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_fp_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_graphic_heading_pane_fp_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_graphic_heading_pane_fp_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_fp_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_single_graphic_heading_pane_fp_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_heading_pane_fp_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_heading_pane_fp_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_single_cale_day_pane_fp
inline TAknLayoutScalableParameterLimits list_single_cale_day_pane_fp_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_cale_day_pane_fp_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_cale_day_pane_fp_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_cale_day_pane_fp_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_cale_day_pane_fp_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_cale_day_pane_fp_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_cale_day_pane_fp_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_cale_day_pane_fp_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_cale_day_pane_fp_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_cale_day_pane_fp_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_cale_day_pane_fp_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_cale_day_pane_fp_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_cale_day_pane_fp_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_cale_day_pane_fp_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_cale_day_pane_fp_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_cale_day_pane_fp_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_cale_day_pane_fp_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_cale_day_pane_fp_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_cale_day_pane_fp_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_cale_day_pane_fp_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_cale_day_pane_fp_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_cale_day_pane_fp_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_cale_day_pane_fp_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_cale_day_pane_fp_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_cale_day_pane_fp_g5_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_cale_day_pane_fp_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_cale_day_pane_fp_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_cale_day_pane_fp_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_cale_day_pane_fp_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_cale_day_pane_fp_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_cale_day_pane_fp_g_Limits()		{ return (*(Tlist_single_cale_day_pane_fp_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_cale_day_pane_fp_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_cale_day_pane_fp_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_cale_day_pane_fp_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_cale_day_pane_fp_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_single_cale_day_pane_fp_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_cale_day_pane_fp_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_cale_day_pane_fp_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_cale_day_pane_fp_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_cale_day_pane_fp_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_cale_day_pane_fp_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_cale_day_pane_fp_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_cale_day_pane_fp_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_cale_day_pane_fp_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_cale_day_pane_fp_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_cale_day_pane_fp_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_cale_day_pane_fp_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_cale_day_pane_fp_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_cale_day_pane_fp_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_cale_day_pane_fp_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_cale_day_pane_fp_t3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_cale_day_pane_fp_t3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_cale_day_pane_fp_t3_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_cale_day_pane_fp_t3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_cale_day_pane_fp_t3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_cale_day_pane_fp_t3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_cale_day_pane_fp_t_Limits()		{ return (*(Tlist_single_cale_day_pane_fp_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_cale_day_pane_fp_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_cale_day_pane_fp_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_cale_day_pane_fp_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_cale_day_pane_fp_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_single_cale_day_pane_fp_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_cale_day_pane_fp_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_cale_day_pane_fp_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_empty_pane_fp
inline TAknLayoutScalableParameterLimits list_empty_pane_fp_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_empty_pane_fp_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_empty_pane_fp_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_empty_pane_fp_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_empty_pane_fp_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_empty_pane_fp_g1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout list_empty_pane_fp_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_empty_pane_fp_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_empty_pane_fp_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout list_empty_pane_fp_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_empty_pane_fp_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_empty_pane_fp_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_empty_pane_fp_t_Limits()		{ return (*(Tlist_empty_pane_fp_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_empty_pane_fp_t_Limits)))(); }

inline TAknTextComponentLayout list_empty_pane_fp_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_empty_pane_fp_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_empty_pane_fp_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : list_single_heading_pane_fp
inline TAknLayoutScalableParameterLimits list_single_heading_pane_fp_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_heading_pane_fp_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_fp_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_heading_pane_fp_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_heading_pane_fp_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_fp_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_heading_pane_fp_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_heading_pane_fp_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_fp_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_heading_pane_fp_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_heading_pane_fp_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_fp_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_heading_pane_fp_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_heading_pane_fp_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_fp_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_heading_pane_fp_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_heading_pane_fp_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_fp_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_heading_pane_fp_g_Limits()		{ return (*(Tlist_single_heading_pane_fp_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_fp_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_heading_pane_fp_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_heading_pane_fp_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_fp_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_single_heading_pane_fp_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_heading_pane_fp_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_fp_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_heading_pane_fp_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_heading_pane_fp_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_fp_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_heading_pane_fp_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_heading_pane_fp_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_fp_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_heading_pane_fp_t2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_heading_pane_fp_t2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_fp_t2_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_heading_pane_fp_t2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_heading_pane_fp_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_fp_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_heading_pane_fp_t_Limits()		{ return (*(Tlist_single_heading_pane_fp_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_fp_t_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_heading_pane_fp_t_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_heading_pane_fp_t_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_fp_t_ParamLimits)))(aLineIndex, aVariety); }

inline TAknTextComponentLayout list_single_heading_pane_fp_t(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_heading_pane_fp_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_heading_pane_fp_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_fast_swap_window
inline TAknWindowComponentLayout aid_size_cell_fast(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_fast_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_fast)))(aVariety, aCol, aRow); }

// LAF Table : soft_indicator_pane_cp1
inline TAknTextComponentLayout soft_indicator_pane_cp1_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tsoft_indicator_pane_cp1_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_soft_indicator_pane_cp1_t1)))(aVariety, aCol, aRow); }

// LAF Table : grid_popup_fast_pane
inline TAknLayoutScalableParameterLimits cell_app_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_app_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_app_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_app_pane_cp2(TInt aRow = 0, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tcell_app_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_app_pane_cp2)))(aRow, aVariety, aCol); }

// LAF Table : popup_fep_hwr_window
inline TAknWindowComponentLayout fep_hwr_candidate_drop_down_list_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_candidate_drop_down_list_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_drop_down_list_pane)))(aVariety, aCol, aRow); }

// LAF Table : fep_hwr_candidate_pane
inline TAknLayoutScalableParameterLimits fep_hwr_candidate_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_hwr_candidate_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_hwr_candidate_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_candidate_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_hwr_candidate_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_hwr_candidate_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_hwr_candidate_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_candidate_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits fep_hwr_candidate_pane_g_Limits()		{ return (*(Tfep_hwr_candidate_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits fep_hwr_candidate_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tfep_hwr_candidate_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout fep_hwr_candidate_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_candidate_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_fep_vkb_window
inline TAknLayoutScalableParameterLimits fep_vkb_candidate_drop_down_list_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_candidate_drop_down_list_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_pane)))(aVariety, aCol, aRow); }

// LAF Table : fep_vkb_candidate_pane
inline TAknWindowComponentLayout fep_vkb_candidate_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_candidate_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout fep_vkb_candidate_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_candidate_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits fep_vkb_candidate_pane_g_Limits()		{ return (*(Tfep_vkb_candidate_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_pane_g_Limits)))(); }

inline TAknWindowComponentLayout fep_vkb_candidate_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_candidate_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : cell_hwr_candidate_pane
inline TAknLayoutScalableParameterLimits cell_hwr_candidate_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_hwr_candidate_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_candidate_pane_g1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits cell_hwr_candidate_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_hwr_candidate_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_candidate_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_hwr_candidate_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_hwr_candidate_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_candidate_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_hwr_candidate_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_hwr_candidate_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_candidate_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_hwr_candidate_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_hwr_candidate_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_candidate_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_hwr_candidate_pane_g_Limits()		{ return (*(Tcell_hwr_candidate_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_candidate_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits cell_hwr_candidate_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tcell_hwr_candidate_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_candidate_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout cell_hwr_candidate_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_hwr_candidate_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_candidate_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : cell_vkb_candidate_pane
inline TAknLayoutScalableParameterLimits cell_vkb_candidate_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_vkb_candidate_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_candidate_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_vkb_candidate_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vkb_candidate_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_candidate_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_vkb_candidate_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_vkb_candidate_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_candidate_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_vkb_candidate_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_vkb_candidate_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_candidate_pane_g4)))(aVariety, aCol, aRow); }

// LAF Table : cell_app_pane_cp2
inline TAknLayoutScalableParameterLimits cell_app_pane_cp2_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_app_pane_cp2_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_app_pane_cp2_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_app_pane_cp2_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_app_pane_cp2_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_app_pane_cp2_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_app_pane_cp2_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_app_pane_cp2_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_app_pane_cp2_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_app_pane_cp2_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_app_pane_cp2_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_app_pane_cp2_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_app_pane_cp2_g_Limits()		{ return (*(Tcell_app_pane_cp2_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_app_pane_cp2_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits cell_app_pane_cp2_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tcell_app_pane_cp2_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_app_pane_cp2_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout cell_app_pane_cp2_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_app_pane_cp2_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_app_pane_cp2_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_app_pane_cp2_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_app_pane_cp2_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_app_pane_cp2_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout cell_app_pane_cp2_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_app_pane_cp2_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_app_pane_cp2_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_highlight_pane_cp1_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_highlight_pane_cp1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_highlight_pane_cp1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp1)))(aVariety, aCol, aRow); }

// LAF Table : fep_hwr_candidate_drop_down_list_pane
inline TAknLayoutScalableParameterLimits cell_hwr_candidate_pane_cp1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_hwr_candidate_pane_cp1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_candidate_pane_cp1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_hwr_candidate_pane_cp1(TInt aCol, TInt aRow, TInt aVariety = 0)		{ return (*(Tcell_hwr_candidate_pane_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_hwr_candidate_pane_cp1)))(aCol, aRow, aVariety); }

inline TAknWindowComponentLayout fep_hwr_candidate_drop_down_list_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_candidate_drop_down_list_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_drop_down_list_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout fep_hwr_candidate_drop_down_list_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_candidate_drop_down_list_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_drop_down_list_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout fep_hwr_candidate_drop_down_list_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_candidate_drop_down_list_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_drop_down_list_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits fep_hwr_candidate_drop_down_list_pane_g_Limits()		{ return (*(Tfep_hwr_candidate_drop_down_list_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_drop_down_list_pane_g_Limits)))(); }

inline TAknWindowComponentLayout fep_hwr_candidate_drop_down_list_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_candidate_drop_down_list_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_drop_down_list_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout fep_hwr_candidate_drop_down_list_scroll_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_candidate_drop_down_list_scroll_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_drop_down_list_scroll_pane)))(aVariety, aCol, aRow); }

// LAF Table : fep_hwr_candidate_drop_down_list_scroll_pane
inline TAknLayoutScalableParameterLimits fep_hwr_candidate_drop_down_list_scroll_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_hwr_candidate_drop_down_list_scroll_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_drop_down_list_scroll_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_hwr_candidate_drop_down_list_scroll_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_candidate_drop_down_list_scroll_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_drop_down_list_scroll_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_hwr_candidate_drop_down_list_scroll_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_hwr_candidate_drop_down_list_scroll_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_drop_down_list_scroll_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_hwr_candidate_drop_down_list_scroll_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_candidate_drop_down_list_scroll_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_drop_down_list_scroll_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_hwr_candidate_drop_down_list_scroll_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_hwr_candidate_drop_down_list_scroll_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_drop_down_list_scroll_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_hwr_candidate_drop_down_list_scroll_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_candidate_drop_down_list_scroll_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_drop_down_list_scroll_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_hwr_candidate_drop_down_list_scroll_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_hwr_candidate_drop_down_list_scroll_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_drop_down_list_scroll_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_hwr_candidate_drop_down_list_scroll_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_candidate_drop_down_list_scroll_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_drop_down_list_scroll_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_hwr_candidate_drop_down_list_scroll_pane_g5_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_hwr_candidate_drop_down_list_scroll_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_drop_down_list_scroll_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_hwr_candidate_drop_down_list_scroll_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_candidate_drop_down_list_scroll_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_drop_down_list_scroll_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_hwr_candidate_drop_down_list_scroll_pane_g6_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_hwr_candidate_drop_down_list_scroll_pane_g6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_drop_down_list_scroll_pane_g6_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_hwr_candidate_drop_down_list_scroll_pane_g6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_candidate_drop_down_list_scroll_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_drop_down_list_scroll_pane_g6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_hwr_candidate_drop_down_list_scroll_pane_g7_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_hwr_candidate_drop_down_list_scroll_pane_g7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_drop_down_list_scroll_pane_g7_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_hwr_candidate_drop_down_list_scroll_pane_g7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_candidate_drop_down_list_scroll_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_drop_down_list_scroll_pane_g7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_hwr_candidate_drop_down_list_scroll_pane_g8_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_hwr_candidate_drop_down_list_scroll_pane_g8_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_drop_down_list_scroll_pane_g8_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_hwr_candidate_drop_down_list_scroll_pane_g8(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_candidate_drop_down_list_scroll_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_drop_down_list_scroll_pane_g8)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits fep_hwr_candidate_drop_down_list_scroll_pane_g_Limits()		{ return (*(Tfep_hwr_candidate_drop_down_list_scroll_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_drop_down_list_scroll_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits fep_hwr_candidate_drop_down_list_scroll_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tfep_hwr_candidate_drop_down_list_scroll_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_drop_down_list_scroll_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout fep_hwr_candidate_drop_down_list_scroll_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_hwr_candidate_drop_down_list_scroll_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_hwr_candidate_drop_down_list_scroll_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : fep_vkb_candidate_drop_down_list_pane
inline TAknLayoutScalableParameterLimits cell_vkb_candidate_pane_cp1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_vkb_candidate_pane_cp1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_candidate_pane_cp1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_vkb_candidate_pane_cp1(TInt aVariety, TInt aCol, TInt aRow)		{ return (*(Tcell_vkb_candidate_pane_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_vkb_candidate_pane_cp1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_vkb_candidate_drop_down_list_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_candidate_drop_down_list_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_vkb_candidate_drop_down_list_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_candidate_drop_down_list_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_vkb_candidate_drop_down_list_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_candidate_drop_down_list_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits fep_vkb_candidate_drop_down_list_pane_g_Limits()		{ return (*(Tfep_vkb_candidate_drop_down_list_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits fep_vkb_candidate_drop_down_list_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout fep_vkb_candidate_drop_down_list_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_vkb_candidate_drop_down_list_scroll_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_scroll_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_scroll_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_candidate_drop_down_list_scroll_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_scroll_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_scroll_pane)))(aVariety, aCol, aRow); }

// LAF Table : fep_vkb_candidate_drop_down_list_scroll_pane
inline TAknLayoutScalableParameterLimits fep_vkb_candidate_drop_down_list_scroll_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_scroll_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_scroll_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_candidate_drop_down_list_scroll_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_scroll_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_scroll_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_vkb_candidate_drop_down_list_scroll_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_scroll_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_scroll_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_candidate_drop_down_list_scroll_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_scroll_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_scroll_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_vkb_candidate_drop_down_list_scroll_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_scroll_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_scroll_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_candidate_drop_down_list_scroll_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_scroll_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_scroll_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_vkb_candidate_drop_down_list_scroll_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_scroll_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_scroll_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_candidate_drop_down_list_scroll_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_scroll_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_scroll_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_vkb_candidate_drop_down_list_scroll_pane_g5_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_scroll_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_scroll_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_candidate_drop_down_list_scroll_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_scroll_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_scroll_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_vkb_candidate_drop_down_list_scroll_pane_g6_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_scroll_pane_g6_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_scroll_pane_g6_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_candidate_drop_down_list_scroll_pane_g6(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_scroll_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_scroll_pane_g6)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_vkb_candidate_drop_down_list_scroll_pane_g7_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_scroll_pane_g7_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_scroll_pane_g7_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_candidate_drop_down_list_scroll_pane_g7(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_scroll_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_scroll_pane_g7)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits fep_vkb_candidate_drop_down_list_scroll_pane_g8_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_scroll_pane_g8_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_scroll_pane_g8_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout fep_vkb_candidate_drop_down_list_scroll_pane_g8(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_scroll_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_scroll_pane_g8)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits fep_vkb_candidate_drop_down_list_scroll_pane_g_Limits()		{ return (*(Tfep_vkb_candidate_drop_down_list_scroll_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_scroll_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits fep_vkb_candidate_drop_down_list_scroll_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_scroll_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_scroll_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout fep_vkb_candidate_drop_down_list_scroll_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tfep_vkb_candidate_drop_down_list_scroll_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_candidate_drop_down_list_scroll_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : title_pane
inline TAknLayoutScalableParameterLimits title_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Ttitle_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_g1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits title_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Ttitle_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_g2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits title_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Ttitle_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_title_pane_g_ParamLimits)))(aLineIndex, aVariety); }

// LAF Table : popup_clock_analogue_window
inline TAknWindowComponentLayout aid_call2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_call2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_call2_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout aid_call_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_call_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_call_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_clock_analogue_window_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_analogue_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_clock_analogue_window_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_analogue_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_clock_analogue_window_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_analogue_window_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_clock_analogue_window_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_analogue_window_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_clock_analogue_window_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_analogue_window_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_clock_analogue_window_g_Limits()		{ return (*(Tpopup_clock_analogue_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_g_Limits)))(); }

inline TAknWindowComponentLayout popup_clock_analogue_window_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_analogue_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_clock_analogue_window_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_analogue_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window_t1)))(aVariety, aCol, aRow); }

// LAF Table : popup_clock_digital_window
inline TAknLayoutScalableParameterLimits clock_digital_number_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tclock_digital_number_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout clock_digital_number_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_number_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits clock_digital_number_pane_cp02_ParamLimits(TInt aVariety = 0)		{ return (*(Tclock_digital_number_pane_cp02_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_cp02_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout clock_digital_number_pane_cp02(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_number_pane_cp02_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_cp02)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits clock_digital_number_pane_cp03_ParamLimits(TInt aVariety = 0)		{ return (*(Tclock_digital_number_pane_cp03_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_cp03_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout clock_digital_number_pane_cp03(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_number_pane_cp03_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_cp03)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits clock_digital_number_pane_cp04_ParamLimits(TInt aVariety = 0)		{ return (*(Tclock_digital_number_pane_cp04_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_cp04_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout clock_digital_number_pane_cp04(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_number_pane_cp04_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_cp04)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits clock_digital_separator_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tclock_digital_separator_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_separator_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout clock_digital_separator_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_separator_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_separator_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_clock_digital_window_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_clock_digital_window_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_digital_window_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout popup_clock_digital_window_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_digital_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_digital_window_t1)))(aVariety, aCol, aRow); }

// LAF Table : clock_digital_number_pane
inline TAknWindowComponentLayout clock_digital_number_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_number_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout clock_digital_number_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_number_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits clock_digital_number_pane_g_Limits()		{ return (*(Tclock_digital_number_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_g_Limits)))(); }

inline TAknWindowComponentLayout clock_digital_number_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_number_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_number_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : clock_digital_separator_pane
inline TAknWindowComponentLayout clock_digital_separator_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_separator_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_separator_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout clock_digital_separator_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_separator_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_separator_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits clock_digital_separator_pane_g_Limits()		{ return (*(Tclock_digital_separator_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_separator_pane_g_Limits)))(); }

inline TAknWindowComponentLayout clock_digital_separator_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_digital_separator_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_digital_separator_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : status_pane
inline TAknLayoutScalableParameterLimits aid_fill_nsta_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_fill_nsta_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_fill_nsta_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits indicator_nsta_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tindicator_nsta_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_indicator_nsta_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_clock_analogue_window(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_analogue_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_analogue_window)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_clock_digital_window(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_clock_digital_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_clock_digital_window)))(aVariety, aCol, aRow); }

// LAF Table : indicator_nsta_pane
inline TAknLayoutScalableParameterLimits grid_indicator_nsta_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_indicator_nsta_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_indicator_nsta_pane_ParamLimits)))(aVariety); }

// LAF Table : clock_nsta_pane
inline TAknTextComponentLayout clock_nsta_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_nsta_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_nsta_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits clock_nsta_pane_t_Limits()		{ return (*(Tclock_nsta_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_nsta_pane_t_Limits)))(); }

inline TAknTextComponentLayout clock_nsta_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tclock_nsta_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_clock_nsta_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : scroll_pane
inline TAknWindowComponentLayout aid_size_max_handle(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_max_handle_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_max_handle)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout aid_size_min_handle(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_min_handle_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_min_handle)))(aVariety, aCol, aRow); }

// LAF Table : texts_graphics
inline TAknWindowComponentLayout editor_scroll_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teditor_scroll_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_editor_scroll_pane)))(aVariety, aCol, aRow); }

// LAF Table : editor_scroll_pane
inline TAknWindowComponentLayout ex_editor_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tex_editor_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_ex_editor_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp13(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp13_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp13)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_gen_pane
inline TAknWindowComponentLayout scroll_pane_cp14(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp14_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp14)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_menu_pane
inline TAknWindowComponentLayout scroll_pane_cp36(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp36_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp36)))(aVariety, aCol, aRow); }

// LAF Table : list_menu_pane
inline TAknLayoutScalableParameterLimits list_single_graphic_hl_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_hl_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_hl_pane_cp2(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_graphic_hl_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_cp2)))(aRow, aVariety, aCol); }

// LAF Table : list_gen_pane
inline TAknLayoutScalableParameterLimits list_single_graphic_hl_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_hl_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_hl_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_graphic_hl_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_single_graphic_hl_pane
inline TAknWindowComponentLayout aid_size_min_hl_cp1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_min_hl_cp1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_min_hl_cp1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_highlight_pane_cp34_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_highlight_pane_cp34_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp34_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_highlight_pane_cp34(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_cp34_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp34)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_hl_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_hl_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_hl_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_hl_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_hl_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_hl_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_hl_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_hl_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_hl_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_hl_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_hl_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_hl_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_hl_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_hl_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_hl_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_hl_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_hl_pane_g5_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_hl_pane_g5_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_g5_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_hl_pane_g5(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_hl_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_g5)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_graphic_hl_pane_g_Limits()		{ return (*(Tlist_single_graphic_hl_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_graphic_hl_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_graphic_hl_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_single_graphic_hl_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_hl_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_hl_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_hl_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_graphic_hl_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_hl_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : list_single_graphic_hl_pane_cp2
inline TAknWindowComponentLayout aid_size_min_hl_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_min_hl_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_min_hl_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_highlight_pane_cp34_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_highlight_pane_cp34_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp34_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_highlight_pane_cp34_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_highlight_pane_cp34_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp34_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_hl_pane_g1_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_hl_pane_g1_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_g1_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_hl_pane_g1_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_hl_pane_g1_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_g1_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_hl_pane_g2_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_hl_pane_g2_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_g2_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_hl_pane_g2_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_hl_pane_g2_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_g2_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_hl_pane_g3_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_hl_pane_g3_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_g3_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_hl_pane_g3_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_hl_pane_g3_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_g3_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_hl_pane_g4_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_hl_pane_g4_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_g4_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_hl_pane_g4_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_hl_pane_g4_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_g4_cp2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_graphic_hl_pane_g5_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_graphic_hl_pane_g5_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_g5_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_graphic_hl_pane_g5_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_graphic_hl_pane_g5_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_graphic_hl_pane_g5_cp2)))(aVariety, aCol, aRow); }

// LAF Table : control_pane
inline TAknLayoutScalableParameterLimits control_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Tcontrol_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout control_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_pane_g4)))(aVariety, aCol, aRow); }

// LAF Table : popup_choice_list_window
inline TAknLayoutScalableParameterLimits bg_popup_sub_pane_cp10_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_sub_pane_cp10_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_sub_pane_cp10_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits list_choice_list_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_choice_list_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_choice_list_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout scroll_pane_cp23(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp23_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp23)))(aVariety, aCol, aRow); }

// LAF Table : popup_preview_fixed_window
inline TAknLayoutScalableParameterLimits bg_popup_preview_window_pane_cp02_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_preview_window_pane_cp02_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_preview_window_pane_cp02_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits list_preview_fixed_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_preview_fixed_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_preview_fixed_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits list_preview_fixed_pane_cp_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_preview_fixed_pane_cp_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_preview_fixed_pane_cp_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_preview_fixed_pane_cp(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_preview_fixed_pane_cp_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_preview_fixed_pane_cp)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_preview_fixed_window_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_preview_fixed_window_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_fixed_window_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_preview_fixed_window_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_preview_fixed_window_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_fixed_window_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_preview_fixed_window_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_preview_fixed_window_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_fixed_window_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_preview_fixed_window_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_preview_fixed_window_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_fixed_window_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits popup_preview_fixed_window_g_Limits()		{ return (*(Tpopup_preview_fixed_window_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_fixed_window_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits popup_preview_fixed_window_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tpopup_preview_fixed_window_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_fixed_window_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout popup_preview_fixed_window_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_preview_fixed_window_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_fixed_window_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : navi_pane_stacon
inline TAknLayoutScalableParameterLimits aid_navi_side_left_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_navi_side_left_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_navi_side_left_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits aid_navi_side_right_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_navi_side_right_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_navi_side_right_pane_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits navi_icon_pane_stacon_ParamLimits(TInt aVariety = 0)		{ return (*(Tnavi_icon_pane_stacon_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_icon_pane_stacon_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits navi_navi_pane_stacon_ParamLimits(TInt aVariety = 0)		{ return (*(Tnavi_navi_pane_stacon_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_navi_pane_stacon_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits navi_text_pane_stacon_ParamLimits(TInt aVariety = 0)		{ return (*(Tnavi_text_pane_stacon_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_navi_text_pane_stacon_ParamLimits)))(aVariety); }

// LAF Table : main_pane
inline TAknWindowComponentLayout main_text_info_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_text_info_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_text_info_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_text_info_pane
inline TAknWindowComponentLayout listscroll_text_info_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_text_info_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_text_info_pane)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_text_info_pane
inline TAknLayoutScalableParameterLimits list_text_info_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_text_info_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_text_info_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_text_info_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_text_info_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_text_info_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits scroll_pane_cp24_ParamLimits(TInt aVariety = 0)		{ return (*(Tscroll_pane_cp24_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp24_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout scroll_pane_cp24(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp24_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp24)))(aVariety, aCol, aRow); }

// LAF Table : list_text_info_pane
inline TAknLayoutScalableParameterLimits list_text_info_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_text_info_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_text_info_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_text_info_pane_t1(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_text_info_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_text_info_pane_t1)))(aRow, aVariety, aCol); }

// LAF Table : main_pane
inline TAknLayoutScalableParameterLimits popup_fast_swap2_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_fast_swap2_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fast_swap2_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_fast_swap2_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_fast_swap2_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_fast_swap2_window)))(aVariety, aCol, aRow); }

// LAF Table : popup_fast_swap2_window
inline TAknWindowComponentLayout aid_size_cell_fast2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_fast2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_fast2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_popup_window_pane_cp17(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp17_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp17)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout heading_pane_cp2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Theading_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_heading_pane_cp2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout listscroll_fast2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_fast2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_fast2_pane)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_fast2_pane
inline TAknWindowComponentLayout grid_fast2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_fast2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_fast2_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout listscroll_fast2_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_fast2_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_fast2_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout listscroll_fast2_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_fast2_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_fast2_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits listscroll_fast2_pane_g_Limits()		{ return (*(Tlistscroll_fast2_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_fast2_pane_g_Limits)))(); }

inline TAknWindowComponentLayout listscroll_fast2_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_fast2_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_fast2_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp26(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp26_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp26)))(aVariety, aCol, aRow); }

// LAF Table : grid_fast2_pane
inline TAknLayoutScalableParameterLimits cell_fast2_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_fast2_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_fast2_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_fast2_pane(TInt aCol, TInt aRow, TInt aVariety = 0)		{ return (*(Tcell_fast2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_fast2_pane)))(aCol, aRow, aVariety); }

// LAF Table : cell_fast2_pane
inline TAknWindowComponentLayout cell_fast2_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_fast2_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_fast2_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_fast2_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_fast2_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_fast2_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_fast2_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_fast2_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_fast2_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_fast2_pane_g_Limits()		{ return (*(Tcell_fast2_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_fast2_pane_g_Limits)))(); }

inline TAknWindowComponentLayout cell_fast2_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_fast2_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_fast2_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_highlight_pane_cp9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_cp9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp9)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknLayoutScalableParameterLimits main_eswt_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tmain_eswt_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_eswt_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout main_eswt_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tmain_eswt_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_main_eswt_pane)))(aVariety, aCol, aRow); }

// LAF Table : list_text_info_pane
inline TAknWindowComponentLayout list_single_text_info_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_text_info_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_text_info_pane)))(aVariety, aCol, aRow); }

// LAF Table : main_eswt_pane
inline TAknWindowComponentLayout eswt_ctrl_button_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_ctrl_button_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_ctrl_button_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout eswt_ctrl_canvas_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_ctrl_canvas_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_ctrl_canvas_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout eswt_ctrl_combo_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_ctrl_combo_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_ctrl_combo_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout eswt_ctrl_default_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_ctrl_default_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_ctrl_default_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout eswt_ctrl_label_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_ctrl_label_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_ctrl_label_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout eswt_ctrl_wait_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_ctrl_wait_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_ctrl_wait_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout eswt_shell_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_shell_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_shell_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout listscroll_eswt_app_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlistscroll_eswt_app_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_listscroll_eswt_app_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits popup_eswt_tasktip_window_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_eswt_tasktip_window_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_eswt_tasktip_window_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_eswt_tasktip_window(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_eswt_tasktip_window_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_eswt_tasktip_window)))(aVariety, aCol, aRow); }

// LAF Table : eswt_shell_pane
inline TAknWindowComponentLayout bg_popup_window_pane_cp18(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp18_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp18)))(aVariety, aCol, aRow); }

// LAF Table : common_borders_pane
inline TAknLayoutScalableParameterLimits eswt_control_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Teswt_control_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout eswt_control_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_control_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits eswt_control_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Teswt_control_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout eswt_control_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_control_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits eswt_control_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Teswt_control_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout eswt_control_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_control_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits eswt_control_pane_g4_ParamLimits(TInt aVariety = 0)		{ return (*(Teswt_control_pane_g4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout eswt_control_pane_g4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_control_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits eswt_control_pane_g_Limits()		{ return (*(Teswt_control_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits eswt_control_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Teswt_control_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout eswt_control_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_control_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : eswt_ctrl_button_pane
inline TAknLayoutScalableParameterLimits bg_button_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_button_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_button_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits common_borders_pane_copy2_ParamLimits(TInt aVariety = 0)		{ return (*(Tcommon_borders_pane_copy2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_common_borders_pane_copy2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout common_borders_pane_copy2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcommon_borders_pane_copy2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_common_borders_pane_copy2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits control_button_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcontrol_button_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_button_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout control_button_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_button_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_button_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits control_button_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tcontrol_button_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_button_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout control_button_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_button_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_button_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits control_button_pane_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tcontrol_button_pane_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_button_pane_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout control_button_pane_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_button_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_button_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits control_button_pane_g_Limits()		{ return (*(Tcontrol_button_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_button_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits control_button_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tcontrol_button_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_button_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout control_button_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_button_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_button_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknTextComponentLayout control_button_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_button_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_button_pane_t1)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout control_button_pane_t2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_button_pane_t2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_button_pane_t2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits control_button_pane_t_Limits()		{ return (*(Tcontrol_button_pane_t_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_button_pane_t_Limits)))(); }

inline TAknTextComponentLayout control_button_pane_t(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcontrol_button_pane_t_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_control_button_pane_t)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : bg_button_pane
inline TAknWindowComponentLayout bg_button_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_button_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_button_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_button_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_button_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_button_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_button_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_button_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_button_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_g9)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits bg_button_pane_g_Limits()		{ return (*(Tbg_button_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_g_Limits)))(); }

inline TAknWindowComponentLayout bg_button_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : eswt_ctrl_default_pane
inline TAknLayoutScalableParameterLimits common_borders_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcommon_borders_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_common_borders_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout common_borders_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcommon_borders_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_common_borders_pane)))(aVariety, aCol, aRow); }

// LAF Table : common_borders_pane_cp2
inline TAknLayoutScalableParameterLimits eswt_control_pane_g1_copy1_ParamLimits(TInt aVariety = 0)		{ return (*(Teswt_control_pane_g1_copy1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g1_copy1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout eswt_control_pane_g1_copy1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_control_pane_g1_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g1_copy1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits eswt_control_pane_g2_copy1_ParamLimits(TInt aVariety = 0)		{ return (*(Teswt_control_pane_g2_copy1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g2_copy1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout eswt_control_pane_g2_copy1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_control_pane_g2_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g2_copy1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits eswt_control_pane_g3_copy1_ParamLimits(TInt aVariety = 0)		{ return (*(Teswt_control_pane_g3_copy1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g3_copy1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout eswt_control_pane_g3_copy1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_control_pane_g3_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g3_copy1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits eswt_control_pane_g4_copy1_ParamLimits(TInt aVariety = 0)		{ return (*(Teswt_control_pane_g4_copy1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g4_copy1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout eswt_control_pane_g4_copy1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_control_pane_g4_copy1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g4_copy1)))(aVariety, aCol, aRow); }

// LAF Table : eswt_ctrl_canvas_pane
inline TAknWindowComponentLayout bg_eswt_ctrl_canvas_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_eswt_ctrl_canvas_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_eswt_ctrl_canvas_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits common_borders_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tcommon_borders_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_common_borders_pane_cp2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout common_borders_pane_cp2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcommon_borders_pane_cp2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_common_borders_pane_cp2)))(aVariety, aCol, aRow); }

// LAF Table : eswt_ctrl_label_pane
inline TAknLayoutScalableParameterLimits common_borders_pane_cp3_ParamLimits(TInt aVariety = 0)		{ return (*(Tcommon_borders_pane_cp3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_common_borders_pane_cp3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout common_borders_pane_cp3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcommon_borders_pane_cp3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_common_borders_pane_cp3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout separator_horizontal_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tseparator_horizontal_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_separator_horizontal_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout separator_vertical_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tseparator_vertical_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_separator_vertical_pane)))(aVariety, aCol, aRow); }

// LAF Table : common_borders_pane_cp3
inline TAknLayoutScalableParameterLimits eswt_control_pane_g1_copy2_ParamLimits(TInt aVariety = 0)		{ return (*(Teswt_control_pane_g1_copy2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g1_copy2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout eswt_control_pane_g1_copy2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_control_pane_g1_copy2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g1_copy2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits eswt_control_pane_g2_copy2_ParamLimits(TInt aVariety = 0)		{ return (*(Teswt_control_pane_g2_copy2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g2_copy2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout eswt_control_pane_g2_copy2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_control_pane_g2_copy2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g2_copy2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits eswt_control_pane_g3_copy2_ParamLimits(TInt aVariety = 0)		{ return (*(Teswt_control_pane_g3_copy2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g3_copy2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout eswt_control_pane_g3_copy2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_control_pane_g3_copy2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g3_copy2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits eswt_control_pane_g4_copy2_ParamLimits(TInt aVariety = 0)		{ return (*(Teswt_control_pane_g4_copy2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g4_copy2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout eswt_control_pane_g4_copy2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_control_pane_g4_copy2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g4_copy2)))(aVariety, aCol, aRow); }

// LAF Table : separator_horizontal_pane
inline TAknWindowComponentLayout common_borders_pane_cp4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcommon_borders_pane_cp4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_common_borders_pane_cp4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout separator_horizontal_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tseparator_horizontal_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_separator_horizontal_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout separator_horizontal_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tseparator_horizontal_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_separator_horizontal_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout separator_horizontal_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tseparator_horizontal_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_separator_horizontal_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits separator_horizontal_pane_g_Limits()		{ return (*(Tseparator_horizontal_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_separator_horizontal_pane_g_Limits)))(); }

inline TAknWindowComponentLayout separator_horizontal_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tseparator_horizontal_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_separator_horizontal_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : common_borders_pane_cp4
inline TAknLayoutScalableParameterLimits eswt_control_pane_g1_copy3_ParamLimits(TInt aVariety = 0)		{ return (*(Teswt_control_pane_g1_copy3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g1_copy3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout eswt_control_pane_g1_copy3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_control_pane_g1_copy3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g1_copy3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits eswt_control_pane_g2_copy3_ParamLimits(TInt aVariety = 0)		{ return (*(Teswt_control_pane_g2_copy3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g2_copy3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout eswt_control_pane_g2_copy3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_control_pane_g2_copy3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g2_copy3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits eswt_control_pane_g3_copy3_ParamLimits(TInt aVariety = 0)		{ return (*(Teswt_control_pane_g3_copy3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g3_copy3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout eswt_control_pane_g3_copy3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_control_pane_g3_copy3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g3_copy3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits eswt_control_pane_g4_copy3_ParamLimits(TInt aVariety = 0)		{ return (*(Teswt_control_pane_g4_copy3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g4_copy3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout eswt_control_pane_g4_copy3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_control_pane_g4_copy3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g4_copy3)))(aVariety, aCol, aRow); }

// LAF Table : separator_vertical_pane
inline TAknWindowComponentLayout common_borders_pane_cp5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcommon_borders_pane_cp5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_common_borders_pane_cp5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout separator_vertical_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tseparator_vertical_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_separator_vertical_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout separator_vertical_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tseparator_vertical_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_separator_vertical_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout separator_vertical_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tseparator_vertical_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_separator_vertical_pane_g3)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits separator_vertical_pane_g_Limits()		{ return (*(Tseparator_vertical_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_separator_vertical_pane_g_Limits)))(); }

inline TAknWindowComponentLayout separator_vertical_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tseparator_vertical_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_separator_vertical_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : common_borders_pane_cp5
inline TAknLayoutScalableParameterLimits eswt_control_pane_g1_copy4_ParamLimits(TInt aVariety = 0)		{ return (*(Teswt_control_pane_g1_copy4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g1_copy4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout eswt_control_pane_g1_copy4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_control_pane_g1_copy4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g1_copy4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits eswt_control_pane_g2_copy4_ParamLimits(TInt aVariety = 0)		{ return (*(Teswt_control_pane_g2_copy4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g2_copy4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout eswt_control_pane_g2_copy4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_control_pane_g2_copy4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g2_copy4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits eswt_control_pane_g3_copy4_ParamLimits(TInt aVariety = 0)		{ return (*(Teswt_control_pane_g3_copy4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g3_copy4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout eswt_control_pane_g3_copy4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_control_pane_g3_copy4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g3_copy4)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits eswt_control_pane_g4_copy4_ParamLimits(TInt aVariety = 0)		{ return (*(Teswt_control_pane_g4_copy4_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g4_copy4_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout eswt_control_pane_g4_copy4(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_control_pane_g4_copy4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_control_pane_g4_copy4)))(aVariety, aCol, aRow); }

// LAF Table : eswt_ctrl_combo_pane
inline TAknWindowComponentLayout eswt_ctrl_combo_button_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_ctrl_combo_button_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_ctrl_combo_button_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout eswt_ctrl_input_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_ctrl_input_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_ctrl_input_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout popup_choice_list_window_cp70(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_choice_list_window_cp70_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_choice_list_window_cp70)))(aVariety, aCol, aRow); }

// LAF Table : eswt_ctrl_input_pane
inline TAknTextComponentLayout eswt_ctrl_input_pane_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_ctrl_input_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_ctrl_input_pane_t1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout input_focus_pane_cp70(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tinput_focus_pane_cp70_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_input_focus_pane_cp70)))(aVariety, aCol, aRow); }

// LAF Table : eswt_ctrl_combo_button_pane
inline TAknLayoutScalableParameterLimits bg_button_pane_cp70_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_button_pane_cp70_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp70_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_button_pane_cp70(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_button_pane_cp70_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_button_pane_cp70)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout eswt_ctrl_combo_button_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Teswt_ctrl_combo_button_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_eswt_ctrl_combo_button_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : eswt_ctrl_wait_pane
inline TAknWindowComponentLayout wait_bar_pane_cp70(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twait_bar_pane_cp70_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_bar_pane_cp70)))(aVariety, aCol, aRow); }

// LAF Table : popup_eswt_tasktip_window
inline TAknLayoutScalableParameterLimits bg_popup_window_pane_cp70_ParamLimits(TInt aVariety = 0)		{ return (*(Tbg_popup_window_pane_cp70_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp70_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout bg_popup_window_pane_cp70(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_popup_window_pane_cp70_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_popup_window_pane_cp70)))(aVariety, aCol, aRow); }

inline TAknTextComponentLayout popup_eswt_tasktip_window_t1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_eswt_tasktip_window_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_eswt_tasktip_window_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits wait_bar_pane_cp71_ParamLimits(TInt aVariety = 0)		{ return (*(Twait_bar_pane_cp71_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_bar_pane_cp71_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout wait_bar_pane_cp71(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Twait_bar_pane_cp71_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_wait_bar_pane_cp71)))(aVariety, aCol, aRow); }

// LAF Table : listscroll_eswt_app_pane
inline TAknWindowComponentLayout grid_eswt_app_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_eswt_app_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_eswt_app_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout scroll_pane_cp70(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tscroll_pane_cp70_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_scroll_pane_cp70)))(aVariety, aCol, aRow); }

// LAF Table : grid_eswt_app_pane
inline TAknLayoutScalableParameterLimits cell_eswt_app_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_eswt_app_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_eswt_app_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_eswt_app_pane(TInt aVariety, TInt aCol, TInt aRow)		{ return (*(Tcell_eswt_app_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_eswt_app_pane)))(aVariety, aCol, aRow); }

// LAF Table : cell_eswt_app_pane
inline TAknLayoutScalableParameterLimits cell_eswt_app_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_eswt_app_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_eswt_app_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_eswt_app_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_eswt_app_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_eswt_app_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_eswt_app_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_eswt_app_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_eswt_app_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_eswt_app_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_eswt_app_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_eswt_app_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_eswt_app_pane_g_Limits()		{ return (*(Tcell_eswt_app_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_eswt_app_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits cell_eswt_app_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tcell_eswt_app_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_eswt_app_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout cell_eswt_app_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_eswt_app_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_eswt_app_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits cell_eswt_app_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_eswt_app_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_eswt_app_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout cell_eswt_app_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_eswt_app_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_eswt_app_pane_t1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_highlight_pane_cp70_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_highlight_pane_cp70_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp70_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_highlight_pane_cp70(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_highlight_pane_cp70_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_highlight_pane_cp70)))(aVariety, aCol, aRow); }

// LAF Table : set_content_pane
inline TAknWindowComponentLayout set_content_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tset_content_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_content_pane_g1)))(aVariety, aCol, aRow); }

// LAF Table : status_small_pane
inline TAknWindowComponentLayout status_small_volume_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_small_volume_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_volume_pane)))(aVariety, aCol, aRow); }

// LAF Table : status_small_volume_pane
inline TAknWindowComponentLayout status_small_volume_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tstatus_small_volume_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_status_small_volume_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small2_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small2_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small2_pane)))(aVariety, aCol, aRow); }

// LAF Table : volume_small2_pane
inline TAknWindowComponentLayout volume_small2_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small2_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small2_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small2_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small2_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small2_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small2_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small2_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small2_pane_g3)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small2_pane_g4(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small2_pane_g4_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small2_pane_g4)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small2_pane_g5(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small2_pane_g5_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small2_pane_g5)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small2_pane_g6(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small2_pane_g6_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small2_pane_g6)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small2_pane_g7(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small2_pane_g7_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small2_pane_g7)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small2_pane_g8(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small2_pane_g8_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small2_pane_g8)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small2_pane_g9(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small2_pane_g9_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small2_pane_g9)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout volume_small2_pane_g10(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small2_pane_g10_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small2_pane_g10)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits volume_small2_pane_g_Limits()		{ return (*(Tvolume_small2_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small2_pane_g_Limits)))(); }

inline TAknWindowComponentLayout volume_small2_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tvolume_small2_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_volume_small2_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : fep_vkb_top_text_pane
inline TAknLayoutScalableParameterLimits fep_vkb_top_text_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_top_text_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_top_text_pane_g1_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits fep_vkb_top_text_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tfep_vkb_top_text_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_fep_vkb_top_text_pane_t1_ParamLimits)))(aVariety); }

// LAF Table : popup_preview_fixed_window
inline TAknLayoutScalableParameterLimits popup_preview_fixed_window_g3_ParamLimits(TInt aVariety = 0)		{ return (*(Tpopup_preview_fixed_window_g3_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_fixed_window_g3_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout popup_preview_fixed_window_g3(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_preview_fixed_window_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_preview_fixed_window_g3)))(aVariety, aCol, aRow); }

// LAF Table : main_pane
inline TAknWindowComponentLayout popup_toolbar_trans_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tpopup_toolbar_trans_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_popup_toolbar_trans_pane)))(aVariety, aCol, aRow); }

// LAF Table : set_content_pane
inline TAknLayoutScalableParameterLimits aid_height_set_list_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_height_set_list_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_height_set_list_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits aid_size_parent_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_size_parent_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_parent_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits list_highlight_pane_cp2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_highlight_pane_cp2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_highlight_pane_cp2_ParamLimits)))(aVariety); }

inline TAknLayoutScalableParameterLimits set_content_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tset_content_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_set_content_pane_g1_ParamLimits)))(aVariety); }

// LAF Table : list_gen_pane
inline TAknLayoutScalableParameterLimits list_single_image_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_image_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_image_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_image_pane(TInt aRow, TInt aVariety = 0, TInt aCol = 0)		{ return (*(Tlist_single_image_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_image_pane)))(aRow, aVariety, aCol); }

// LAF Table : list_single_image_pane
inline TAknLayoutScalableParameterLimits aid_size_cell_image_ParamLimits(TInt aVariety = 0)		{ return (*(Taid_size_cell_image_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_image_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout aid_size_cell_image(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_image_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_image)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits grid_single_image_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tgrid_single_image_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_single_image_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout grid_single_image_pane(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_single_image_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_single_image_pane)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_image_pane_g1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_image_pane_g1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_image_pane_g1_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_image_pane_g1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_image_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_image_pane_g1)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_image_pane_g2_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_image_pane_g2_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_image_pane_g2_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout list_single_image_pane_g2(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_image_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_image_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits list_single_image_pane_g_Limits()		{ return (*(Tlist_single_image_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_image_pane_g_Limits)))(); }

inline TAknLayoutScalableParameterLimits list_single_image_pane_g_ParamLimits(TInt aLineIndex, TInt aVariety = 0)		{ return (*(Tlist_single_image_pane_g_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_image_pane_g_ParamLimits)))(aLineIndex, aVariety); }

inline TAknWindowComponentLayout list_single_image_pane_g(TInt aLineIndex, TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_image_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_image_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

inline TAknLayoutScalableParameterLimits list_single_image_pane_t1_ParamLimits(TInt aVariety = 0)		{ return (*(Tlist_single_image_pane_t1_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_image_pane_t1_ParamLimits)))(aVariety); }

inline TAknTextComponentLayout list_single_image_pane_t1(TInt aVariety, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tlist_single_image_pane_t1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_list_single_image_pane_t1)))(aVariety, aCol, aRow); }

// LAF Table : grid_single_image_pane
inline TAknLayoutScalableParameterLimits cell_image_list_pane_ParamLimits(TInt aVariety = 0)		{ return (*(Tcell_image_list_pane_ParamLimits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_image_list_pane_ParamLimits)))(aVariety); }

inline TAknWindowComponentLayout cell_image_list_pane(TInt aCol, TInt aVariety = 0, TInt aRow = 0)		{ return (*(Tcell_image_list_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_image_list_pane)))(aCol, aVariety, aRow); }

// LAF Table : cell_image_list_pane
inline TAknWindowComponentLayout cell_image_list_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_image_list_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_image_list_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout cell_image_list_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_image_list_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_image_list_pane_g2)))(aVariety, aCol, aRow); }

inline TAknLayoutScalableTableLimits cell_image_list_pane_g_Limits()		{ return (*(Tcell_image_list_pane_g_Limits_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_image_list_pane_g_Limits)))(); }

inline TAknWindowComponentLayout cell_image_list_pane_g(TInt aLineIndex, TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tcell_image_list_pane_g_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_cell_image_list_pane_g)))(aLineIndex, aVariety, aCol, aRow); }

// LAF Table : popup_toolbar_trans_pane
inline TAknWindowComponentLayout aid_size_cell_tb_trans_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Taid_size_cell_tb_trans_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_aid_size_cell_tb_trans_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_tb_trans_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_tb_trans_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_tb_trans_pane)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout grid_tb_trans_pane(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tgrid_tb_trans_pane_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_grid_tb_trans_pane)))(aVariety, aCol, aRow); }

// LAF Table : bg_tb_trans_pane
inline TAknWindowComponentLayout bg_tb_trans_pane_g1(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_tb_trans_pane_g1_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_tb_trans_pane_g1)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_tb_trans_pane_g2(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_tb_trans_pane_g2_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_tb_trans_pane_g2)))(aVariety, aCol, aRow); }

inline TAknWindowComponentLayout bg_tb_trans_pane_g3(TInt aVariety = 0, TInt aCol = 0, TInt aRow = 0)		{ return (*(Tbg_tb_trans_pane_g3_sig*)(CdlEngine::GetFunction(KCdlInterfaceUid, EApiId_bg_t