/*
* Copyright (c) 2002-2004 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/



// This header file contains the customisation implementation identity for Adaptation_Layer_AknApacLayout
// It was generated by hand, not by layout compiler.
// This file may be manually modified.
// This customisation implements the interface defined in AknApacLayout.cdl

// ___Instructions___
// 1. use Adaptation_Layer_AknLayout_Elaf as an example
// 2. fill in the implementations for the global methods (see section "Adaptation Layer Implementation" below")
// 3. do not modify KDataLookup
// 4. then remove the "NULL, //" from the lines in KCdlImpl at the BOTTOM of this file
//
// Notes:
// - if there is NULL in the bottom table, then the implementation in other CDL instance will be used (the ones generated from LAY files)
// - ensure that the instances are in the packs in the correct order in packages.mk (with adaptation layer after LAY file instances)


#include "Adaptation_Layer_AknApacLayout.h"
#include "AknLayout2AdaptationDecode.h"
#include "AknLayoutScalable_Avkon.cdl.h"

//
// panic
//

enum TAdaptation_Layer_AknApacLayout_Panic
	{
	EParamsOutsideKnownRange,
    ELayoutLineMissing
    };

void Panic(TAdaptation_Layer_AknApacLayout_Panic aCode)
	{
	_LIT(KLayoutPanic, "Layout Avkon Apac Adaptation Layer panic");
	User::Panic(KLayoutPanic, aCode);
	}

namespace Adaptation_Layer_AknApacLayout
{

extern const TUint KDataLookup[AknApacLayout::E_TApiId_TableSize];


//
// Helper Methods
//

TAknLayoutTableLimits Limits() { return AknLayoutAdaptationDecode::TableLimits(KDataLookup); }

TAknWindowLineLayout WindowLine0f() { return AknLayoutAdaptationDecode::WindowLine0f(KDataLookup); }
TAknWindowLineLayout WindowLine1f(TInt aParam0) { return AknLayoutAdaptationDecode::WindowLine1f(KDataLookup, aParam0); }
TAknWindowLineLayout WindowLine2f(TInt aParam0,TInt aParam1) { return AknLayoutAdaptationDecode::WindowLine2f(KDataLookup, aParam0, aParam1); }
TAknWindowLineLayout WindowLine3f(TInt aParam0,TInt aParam1,TInt aParam2) { return AknLayoutAdaptationDecode::WindowLine3f(KDataLookup, aParam0, aParam1, aParam2); }

TAknWindowLineLayout WindowLine0t(const TRect& aParentRect) { return AknLayoutAdaptationDecode::WindowLine0t(KDataLookup, aParentRect); }
TAknWindowLineLayout WindowLine1t(const TRect& aParentRect,TInt aParam0) { return AknLayoutAdaptationDecode::WindowLine1t(KDataLookup, aParentRect, aParam0); }

TAknTextLineLayout TextLine0f() { return AknLayoutAdaptationDecode::TextLine0f(KDataLookup); }
TAknTextLineLayout TextLine1f(TInt aParam0) { return AknLayoutAdaptationDecode::TextLine1f(KDataLookup, aParam0); }
TAknTextLineLayout TextLine2f(TInt aParam0,TInt aParam1) { return AknLayoutAdaptationDecode::TextLine2f(KDataLookup, aParam0, aParam1); }

TAknWindowLineLayout WindowTable0t(TInt aLineIndex, const TRect& aParentRect) { return AknLayoutAdaptationDecode::WindowTable0t(KDataLookup, aLineIndex, aParentRect); }
TAknWindowLineLayout WindowTable1t(TInt aLineIndex, const TRect& aParentRect, TInt aParam0) { return AknLayoutAdaptationDecode::WindowTable1t(KDataLookup, aLineIndex, aParentRect, aParam0); }
TAknWindowLineLayout WindowTable0f(TInt aLineIndex) { return AknLayoutAdaptationDecode::WindowTable0f(KDataLookup, aLineIndex); }
TAknWindowLineLayout WindowTable1f(TInt aLineIndex, TInt aParam0) { return AknLayoutAdaptationDecode::WindowTable1f(KDataLookup, aLineIndex, aParam0); }

TAknTextLineLayout TextTable0f(TInt aLineIndex) { return AknLayoutAdaptationDecode::TextTable0f(KDataLookup, aLineIndex); }

TAknMultiLineTextLayout MultiLineTextLine2f(TInt aParam0,TInt aParam1) { return AknLayoutAdaptationDecode::MultiLineTextLine2f(KDataLookup, aParam0, aParam1); }


inline TAknWindowComponentLayout DoCompose(TAknWindowComponentLayout aLine1, TAknWindowComponentLayout aLine2) 
    { 
    return TAknWindowComponentLayout::Compose(aLine1, aLine2); 
    }

inline TAknTextComponentLayout DoComposeText(TAknWindowComponentLayout aLine1, TAknTextComponentLayout aLine2) 
    { 
    return TAknWindowComponentLayout::ComposeText(aLine1, aLine2); 
    }

inline TAknWindowComponentLayout DoIntersect(TAknWindowComponentLayout aLine, TAknWindowComponentLayout aLine2) 
    { 
    return TAknWindowComponentLayout::Intersect(aLine, aLine2);
    }

inline TAknWindowComponentLayout DoMinus(TAknWindowComponentLayout aLine, TAknWindowComponentLayout aParentDiff)
    {
    return TAknWindowComponentLayout::Minus(aLine, aParentDiff);
    }



//
// This method returns empty TAknWindowLineLayout instance. (Filled with zeroes)
//
const TAknWindowLineLayoutImp KEmptyWindowLayout = {ELayoutEmpty,0,0,0,0,ELayoutEmpty,ELayoutEmpty};
inline const TAknWindowLineLayout& EmptyWindowLayout()
    {
    return *(TAknWindowLineLayout*)&KEmptyWindowLayout;
    }

//
// This method returns empty TAknTextLineLayout instance. (Filled with zeroes)
//
const TAknTextLineLayoutImp KEmptyTextLayout = {ELayoutEmpty,0,0,0,0,ELayoutEmpty,ELayoutEmpty,0,0};
inline const TAknTextLineLayout& EmptyTextLayout()
    {
    return *(TAknTextLineLayout*)&KEmptyTextLayout;
    }

//
// Adaptation Layer Implementation
//


// LAF Table : Find pane elements
// C= H=32 W=58 b= l=56 r= t=16 
// Remark                    : Search icons of find pane.
// Parent                    : find_pane
// Parent API                : find_pane
// Scale API match    ( 47%) : find_popup_pane_cp2_ParamLimits
// Scale parent match (100%) : find_pane
TAknWindowLineLayout Find_pane_elements_Line_6() 
    {
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Avkon::input_find_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::input_find_pane_g1(0);
    return DoCompose(layout1, layout2).LayoutLine();
    }

// LAF Table : Pop-up windows (main pane as parent)
// C= H={58, 54}[aIsShownWithPopupWindows] W=352 b=0 l= r=0 t= 
// Remark                    : Chinese character entry and candidate selection window NOTE the parent is control_pane (made height variable in case of popup being used with query).
// Parent                    : 
// Parent API                : 
// Scale API match    ( 95%) : popup_fep_china_uni_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_fep_china_window(TInt /*aIsShownWithPopupWindows*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }

// C= H={74, 104, 134, 164, 194} W=102 b=10 l=6 r= t= 
// Remark                    : Pinyin T9 candidate selection pop up window. Note The parent is popup_feb_china_window.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 70%) : popup_fep_china_uni_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_fep_china_pinyin_window(TInt /*aIndex_H*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }

// LAF Table : Cursor graphics (16)
// C=210 H=36 W=2 b=-2 l= r= t= 
// Remark                    : Cursor graphics.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 36%) : setting_slider_graphic_pane_t_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout Cursor_graphics__16__Line_1() 
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// LAF Table : Cut copy and paste highlight graphics (16)
// C=210 H=36 W= b= l=-2 r=-2 t=-2 
// Remark                    : Selection highlight (i.e. marked text) for the cutcopypaste functions.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 25%) : cell_highlight_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout Cut_copy_and_paste_highlight_graphics__16__Line_1() 
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// LAF Table : Time and date entry graphics (16)
// C=210 H= W= b=-2 l=-2 r=-0 t=-2 
// Remark                    : Inversion rectangle.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Time_and_date_entry_graphics__16__Line_1() 
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// LAF Table : Pop up window grid pane descendants (APAC character)
// C= H=40 W=40 b= l={0, 42, 84, 126, 168, 210, 252, 0, 42, 84, 126, 168, 210, 252, 0, 42, 84, 126, 168, 210, 252, 0, 42, 84, 126, 168, 210, 252, 0, 42, 84, 126, 168, 210, 252, 0, 42, 84, 126, 168, 210, 252, 0, 42, 84, 126, 168, 210, 252}[aCommon1] r= t={0, , , , , , , 42, , , , , , , 84, , , , , , , 126, , , , , , , 168, , , , , , , 210, , , , , , , 252, , , , , , }[aCommon1] 
// Remark                    : 16 pixel font special characters.
// Parent                    : grid_apac_character_popup_pane
// Parent API                : grid_apac_character_popup_pane
// Scale API match    ( 53%) : cell_large_graphic_colour_popup_pane_ParamLimits
// Scale parent match ( 53%) : grid_large_graphic_colour_popup_pane_ParamLimits
TAknWindowLineLayout cell_apac_character_popup_pane(TInt aCommon1) 
    {
	TInt varietyIndex = 0; // stick to variety 0 for now, variety 1 seems to be shorter. [LMB 12/04/2005]
    TInt rowIndex = aCommon1 % 7;
    TInt columnIndex = aCommon1 / 7;
    return AknLayoutScalable_Avkon::cell_graphic_popup_pane(varietyIndex, rowIndex, columnIndex).LayoutLine();
    }

// LAF Table : Cell pane texts (pop-up APAC character)
// B=34 C=215 Font=EApacPlain16_Scaled J=ELayoutAlignCenter W=34 l=4 r=2 
// Remark                    : E.g. a special character.
// Parent                    : cell_apac_character_popup_pane
// Parent API                : cell_apac_character_popup_pane
// Scale API match    ( 29%) : cell_large_graphic_colour_none_popup_pane_ParamLimits
// Scale parent match ( 53%) : cell_large_graphic_colour_popup_pane_ParamLimits
TAknTextLineLayout Cell_pane_texts__pop_up_APAC_character__Line_1() 
    {
    // NOT USED
    return EmptyTextLayout();
    }

// LAF Table : APAC character selection pop-up window descendants
// C= H= W= b= l=6 r= t={12, 14} 
// Remark                    : For the dimensions see reference 1.
// Parent                    : popup_grid_apac_character_window
// Parent API                : popup_grid_apac_character_window
// Scale API match    (  0%) : 
// Scale parent match ( 50%) : popup_grid_graphic_window_ParamLimits
TAknWindowLineLayout APAC_character_selection_pop_up_window_descendants_Line_1(TInt /*aIndex_t*/) 
    {
    // NOT USED
    return EmptyWindowLayout();
    }
// C= H={292, 250, 208, 166, 124, 82, 40} W=292 b= l=28 r= t={60, 62} 
// Remark                    : 16 pixel special character selection grid.
// Parent                    : popup_grid_apac_character_window
// Parent API                : popup_grid_apac_character_window
// Scale API match    ( 53%) : grid_large_graphic_colour_popup_pane_ParamLimits
// Scale parent match ( 50%) : popup_grid_graphic_window_ParamLimits
TAknWindowLineLayout grid_apac_character_popup_pane(TInt /*aIndex_t*/, TInt /*aIndex_H*/) 
    {
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Avkon::listscroll_popup_graphic_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::grid_graphic_popup_pane(0);
    return DoCompose(layout1, layout2).LayoutLine();
    }

// LAF Table : APAC character selection pop-up window elements
// C=219 H=2 W=296 b= l=12 r= t={58, 100, 142, 184, 226, 268, 310, 352} 
// Remark                    : Horizontal lines between grid elements.
// Parent                    : popup_grid_apac_character_window
// Parent API                : popup_grid_apac_character_window
// Scale API match    ( 26%) : popup_fep_japan_predictive_window_ParamLimits
// Scale parent match ( 50%) : popup_grid_graphic_window_ParamLimits
TAknWindowLineLayout APAC_character_selection_pop_up_window_elements_Line_1(TInt /*aIndex_t*/) 
    {
    // NOT USED
    return EmptyWindowLayout();
    }
    
// C=219 H={40, 82, 124, 166, 208, 250, 292} W=2 b= l={12, 54, 96, 138, 180, 222, 264, 306} r= t=60 
// Remark                    : Vertical lines between grid elements.
// Parent                    : popup_grid_apac_character_window
// Parent API                : popup_grid_apac_character_window
// Scale API match    ( 26%) : popup_fep_japan_predictive_window_ParamLimits
// Scale parent match ( 50%) : popup_grid_graphic_window_ParamLimits
TAknWindowLineLayout APAC_character_selection_pop_up_window_elements_Line_2(TInt /*aIndex_l*/, TInt /*aIndex_H*/) 
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// LAF Table : APAC character selection pop-up window graphics
// C=0 H=p W=352 b= l=0 r= t=0 
// Remark                    : A rectangle to cover the main pane elements below.
// Parent                    : popup_grid_apac_character_window
// Parent API                : popup_grid_apac_character_window
// Scale API match    ( 34%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match ( 50%) : popup_grid_graphic_window_ParamLimits
TAknWindowLineLayout APAC_character_selection_pop_up_window_graphics_Line_1(const TRect& /*aParentRect*/) 
    {
    // NOT USED
    return EmptyWindowLayout();
    }
    
// C=86 H=p-20 W= b= l=12 r= t={12, 14} 
// Remark                    : Second shadow.
// Parent                    : popup_grid_apac_character_window
// Parent API                : popup_grid_apac_character_window
// Scale API match    ( 34%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match ( 50%) : popup_grid_graphic_window_ParamLimits
TAknWindowLineLayout APAC_character_selection_pop_up_window_graphics_Line_2(const TRect& /*aParentRect*/, TInt /*aIndex_t*/) 
    {
    // NOT USED
    return EmptyWindowLayout();
    }
    
// C=221 H=p-18 W= b= l=8 r= t={8, 10} 
// Remark                    : First shadow.
// Parent                    : popup_grid_apac_character_window
// Parent API                : popup_grid_apac_character_window
// Scale API match    ( 34%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match ( 50%) : popup_grid_graphic_window_ParamLimits
TAknWindowLineLayout APAC_character_selection_pop_up_window_graphics_Line_3(const TRect& /*aParentRect*/, TInt /*aIndex_t*/) 
    {
    // NOT USED
    return EmptyWindowLayout();
    }
    
// C=215 H=p-16 W= b= l=4 r= t={4, 6} 
// Remark                    : Outline frame.
// Parent                    : popup_grid_apac_character_window
// Parent API                : popup_grid_apac_character_window
// Scale API match    ( 34%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match ( 50%) : popup_grid_graphic_window_ParamLimits
TAknWindowLineLayout APAC_character_selection_pop_up_window_graphics_Line_4(const TRect& /*aParentRect*/, TInt /*aIndex_t*/) 
    {
    // NOT USED
    return EmptyWindowLayout();
    }
    
// C=0 H=p-20 W= b= l=6 r= t={6, 8} 
// Remark                    : Inside area.
// Parent                    : popup_grid_apac_character_window
// Parent API                : popup_grid_apac_character_window
// Scale API match    ( 34%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match ( 50%) : popup_grid_graphic_window_ParamLimits
TAknWindowLineLayout APAC_character_selection_pop_up_window_graphics_Line_5(const TRect& /*aParentRect*/, TInt /*aIndex_t*/) 
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// LAF Table : Chinese FEP pop-up window elements and descendants panes
// C=219 H=42 W={2, 2, 0}[aPaneLayout] b=10 l={124, 94, 4}[aPaneLayout] r= t= 
// Remark                    : Line between fields (replaced t with b as parent is relative to bottom).
// Parent                    : popup_fep_china_window
// Parent API                : popup_fep_china_window
// Scale API match    ( 25%) : popup_fep_china_uni_window_ParamLimits
// Scale parent match ( 95%) : popup_fep_china_uni_window_ParamLimits
TAknWindowLineLayout Chinese_FEP_pop_up_window_elements_and_descendants_panes_Line_1(TInt /*aPaneLayout*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C= H=38 W={116, 86, 0}[aPaneLayout] b=12 l=8 r= t= 
// Remark                    : Character entry field (replaced t with b as parent is relative to bottom).
// Parent                    : popup_fep_china_window
// Parent API                : popup_fep_china_window
// Scale API match    ( 94%) : fep_china_uni_entry_pane
// Scale parent match ( 95%) : popup_fep_china_uni_window_ParamLimits
TAknWindowLineLayout fep_china_entry_pane(TInt /*aPaneLayout*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C= H=38 W={212, 242, 332}[aPaneLayout] b=12 l={128, 98, 8}[aPaneLayout] r= t= 
// Remark                    : Candidate selection area (added a new value for only showing 6 candidates - corresponds to zhuyin or stroke mode and replaced t with b as parent is relative to bottom)).
// Parent                    : popup_fep_china_window
// Parent API                : popup_fep_china_window
// Scale API match    ( 95%) : fep_china_uni_candidate_pane_ParamLimits
// Scale parent match ( 95%) : popup_fep_china_uni_window_ParamLimits
TAknWindowLineLayout fep_china_candidate_pane(TInt /*aPaneLayout*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }

// LAF Table : Chinese FEP entry pane texts
// B=24 C={215, 0, 219, 230} Font=EApacPlain12_Scaled J=ELayoutAlignLeft W={114, 84, 0}[aPaneLayout] l=2 r=0 
// Remark                    : Character entry (maybe the highlighted color should be 35 like in the candidate pane and the width needs to vary with the layout of the container) and add in some values for invalid tonemark text.
// Parent                    : fep_china_entry_pane
// Parent API                : fep_china_entry_pane
// Scale API match    ( 51%) : fep_china_uni_entry_pane_g1
// Scale parent match ( 94%) : fep_china_uni_entry_pane
TAknTextLineLayout Chinese_FEP_entry_pane_texts_Line_1(TInt /*aIndex_C*/, TInt /*aPaneLayout*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyTextLayout();
    }

// LAF Table : Chinese FEP candidate pane elements
// C= H=14 W=8 b= l={2, }[aLeftRight] r={, 2}[aLeftRight] t={12, 12}[aLeftRight] 
// Remark                    : More candidates available by leftscrolling indication (had to fix it manually as the carriage returns in the html were not parsed consistently with what they were meant to represent and also the indicator arrows need to be further away from the canidate selection highlight so -1 not -2).
// Parent                    : fep_china_candidate_pane
// Parent API                : fep_china_candidate_pane
// Scale API match    ( 55%) : fep_china_uni_candidate_pane_ParamLimits
// Scale parent match ( 95%) : fep_china_uni_candidate_pane_ParamLimits
TAknWindowLineLayout Chinese_FEP_candidate_pane_elements_Line_1(TInt /*aLeftRight*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C= H=6 W=10 b= l= r=2 t=4 
// Remark                    : Candidates page by page scrolling up available indication used only with stroke method (the indicator arrows need to be further away from the canidate selection highlight so -1 not -2).
// Parent                    : fep_china_candidate_pane
// Parent API                : fep_china_candidate_pane
// Scale API match    ( 55%) : fep_china_uni_candidate_pane_ParamLimits
// Scale parent match ( 95%) : fep_china_uni_candidate_pane_ParamLimits
TAknWindowLineLayout Chinese_FEP_candidate_pane_elements_Line_2() 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C= H=6 W=10 b= l= r=2 t=28 
// Remark                    : Candidates page by page scrolling down available indication used only with stroke method (the indicator arrows need to be further away from the canidate selection highlight so -1 not -2).
// Parent                    : fep_china_candidate_pane
// Parent API                : fep_china_candidate_pane
// Scale API match    ( 55%) : fep_china_uni_candidate_pane_ParamLimits
// Scale parent match ( 95%) : fep_china_uni_candidate_pane_ParamLimits
TAknWindowLineLayout Chinese_FEP_candidate_pane_elements_Line_3() 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C= H=38 W=36 b= l={12, 42, 72, 102, 132, 162, 192, 222, 252, 282, , } r= t=0 
// Remark                    : Candidate highlight (added width and height that were missing but height needs to be 19 so that it covers bottom shadow as well and width needs to be 18 so that it doesn't overlap adjacent characters).
// Parent                    : fep_china_candidate_pane
// Parent API                : fep_china_candidate_pane
// Scale API match    ( 59%) : list_highlight_pane_cp2
// Scale parent match ( 95%) : fep_china_uni_candidate_pane_ParamLimits
TAknWindowLineLayout fep_china_highlight_pane(TInt /*aIndex_l*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }

// LAF Table : Chinese FEP candidate pane texts
// B=34 C={215, 35} Font=EApacPlain12_Scaled J=ELayoutAlignCenter W=24 l={18, 48, 78, 108, 138, 168, 198, 228, 258, 288, , }[aCommon1] r= 
// Remark                    : Candidates (now only 10 numbers not 11 and the values have been recalculated to make sense and the right margins are not correct if the candidate pane is not 166 so the comment about the first four being not shown is wrong it should be the last four that are not shown).
// Parent                    : fep_china_candidate_pane
// Parent API                : fep_china_candidate_pane
// Scale API match    ( 61%) : fep_china_uni_candidate_pane_ParamLimits
// Scale parent match ( 95%) : fep_china_uni_candidate_pane_ParamLimits
TAknTextLineLayout Chinese_FEP_candidate_pane_texts_Line_1(TInt /*aIndex_C*/, TInt /*aCommon1*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyTextLayout();
    }
    
// B=8 C=210 Font=ENumberPlain5_Scaled J=ELayoutAlignCenter W=8 l={26, 56, 86, 116, 146, 176, 206, 236, 266, 296, , }[aCommon1] r= 
// Remark                    : Candidate oridinal numbers (need to all be one to the left so that they are centered relative to the candidate selection highlight).
// Parent                    : fep_china_candidate_pane
// Parent API                : fep_china_candidate_pane
// Scale API match    ( 61%) : fep_china_uni_candidate_pane_ParamLimits
// Scale parent match ( 95%) : fep_china_uni_candidate_pane_ParamLimits
TAknTextLineLayout Chinese_FEP_candidate_pane_texts_Line_2(TInt /*aCommon1*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyTextLayout();
    }

// LAF Table : Chinese FEP pop up window graphics
// C=0 H={p, p-8}[aIsShownWithPopupWindows] W=352 b=0 l=0 r= t= 
// Remark                    : A rectangle to cover the main pane elements below (replaced t with b as parent is relative to bottom).
// Parent                    : popup_fep_china_window
// Parent API                : popup_fep_china_window
// Scale API match    ( 45%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match ( 95%) : popup_fep_china_uni_window_ParamLimits
TAknWindowLineLayout Chinese_FEP_pop_up_window_graphics_Line_1(const TRect& /*aParentRect*/, TInt /*aIsShownWithPopupWindows*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C=86 H={p-16, p-10}[aIsShownWithPopupWindows] W=338 b=4 l=10 r= t= 
// Remark                    : Second shadow (width was missing in spec and it needs to be only one to the right of the first shadow so 5 not 6 and replaced t with b as parent is relative to bottom).
// Parent                    : popup_fep_china_window
// Parent API                : popup_fep_china_window
// Scale API match    ( 45%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match ( 95%) : popup_fep_china_uni_window_ParamLimits
TAknWindowLineLayout Chinese_FEP_pop_up_window_graphics_Line_2(const TRect& /*aParentRect*/, TInt /*aIsShownWithPopupWindows*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C=221 H={p-14, p-10}[aIsShownWithPopupWindows] W=338 b=6 l=8 r= t= 
// Remark                    : First shadow (width was missing in spec and replaced t with b as parent is relative to bottom and need different height with popup).
// Parent                    : popup_fep_china_window
// Parent API                : popup_fep_china_window
// Scale API match    ( 45%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match ( 95%) : popup_fep_china_uni_window_ParamLimits
TAknWindowLineLayout Chinese_FEP_pop_up_window_graphics_Line_3(const TRect& /*aParentRect*/, TInt /*aIsShownWithPopupWindows*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C=215 H={p-12, p-8}[aIsShownWithPopupWindows] W=340 b=8 l=4 r= t= 
// Remark                    : Outline frame (width was missing in spec and replaced t with b as parent is relative to bottom and need different height with popup).
// Parent                    : popup_fep_china_window
// Parent API                : popup_fep_china_window
// Scale API match    ( 45%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match ( 95%) : popup_fep_china_uni_window_ParamLimits
TAknWindowLineLayout Chinese_FEP_pop_up_window_graphics_Line_4(const TRect& /*aParentRect*/, TInt /*aIsShownWithPopupWindows*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C=0 H={p-16, p-12}[aIsShownWithPopupWindows] W=336 b=10 l=6 r= t= 
// Remark                    : Inside area (width was missing in spec and replaced t with b as parent is relative to bottom and need different height with popup).
// Parent                    : popup_fep_china_window
// Parent API                : popup_fep_china_window
// Scale API match    ( 45%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match ( 95%) : popup_fep_china_uni_window_ParamLimits
TAknWindowLineLayout Chinese_FEP_pop_up_window_graphics_Line_5(const TRect& /*aParentRect*/, TInt /*aIsShownWithPopupWindows*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }

// LAF Table : Chinese FEP highlight elements
// C=0 H=38 W=36 b= l=0 r= t=0 
// Remark                    : White background (height must be 19 not 18 to cover bottom of shadow as well and width must be 18 so that is doesn't overlap adjacent characters).
// Parent                    : fep_china_highlight_pane
// Parent API                : fep_china_highlight_pane
// Scale API match    ( 31%) : list_highlight_pane_cp2
// Scale parent match ( 59%) : list_highlight_pane_cp2
TAknWindowLineLayout Chinese_FEP_highlight_elements_Line_1() 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C=222 H=36 W=34 b= l=2 r= t=2 
// Remark                    : Shadow (left is now 1 not 2 as the parent is now 18 wide not 20).
// Parent                    : fep_china_highlight_pane
// Parent API                : fep_china_highlight_pane
// Scale API match    ( 31%) : list_highlight_pane_cp2
// Scale parent match ( 59%) : list_highlight_pane_cp2
TAknWindowLineLayout Chinese_FEP_highlight_elements_Line_2() 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C=244 H=36 W=34 b= l=0 r= t=0 
// Remark                    : Highlight (left is now 0 not 1 as the parent is now 18 wide not 20).
// Parent                    : fep_china_highlight_pane
// Parent API                : fep_china_highlight_pane
// Scale API match    ( 31%) : list_highlight_pane_cp2
// Scale parent match ( 59%) : list_highlight_pane_cp2
TAknWindowLineLayout Chinese_FEP_highlight_elements_Line_3() 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }

// LAF Table : Chinese FEP highlight texts
// B=32 C={215, 35} Font=EApacPlain16_Scaled J=ELayoutAlignCenter W=32 l=2 r=2 
// Remark                    : Highlighted candidates (l and r are now 1 not 2 as parent is now 18 wide not 20).
// Parent                    : fep_china_highlight_pane
// Parent API                : fep_china_highlight_pane
// Scale API match    ( 34%) : list_highlight_pane_cp2
// Scale parent match ( 59%) : list_highlight_pane_cp2
TAknTextLineLayout Chinese_FEP_highlight_texts_Line_1(TInt /*aIndex_C*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyTextLayout();
    }

// LAF Table : Unselected string highlight
// C=243 H=30 W={114, 84, 0}[aPaneLayout] b= l=0 r= t=0 
// Remark                    : Highlight (width needs to vary with the layout of the container).
// Parent                    : fep_china_entry_pane
// Parent API                : fep_china_entry_pane
// Scale API match    ( 30%) : list_highlight_pane_cp2
// Scale parent match ( 94%) : fep_china_uni_entry_pane
TAknWindowLineLayout Unselected_string_highlight_Line_1(TInt /*aPaneLayout*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }

// LAF Table : Pinyin T9 candidate pop up window descendants panes
// C= H=30 W=88 b= l=6 r= t={6, 36, 66, 96, 126, 156} 
// Remark                    : Pinyin T9 candidates (width is 44 not 41 to fill the area).
// Parent                    : popup_fep_china_pinyin_window
// Parent API                : popup_fep_china_pinyin_window
// Scale API match    ( 45%) : list_single_popup_jap_candidate_pane_ParamLimits
// Scale parent match ( 70%) : popup_fep_china_uni_window_ParamLimits
TAknWindowLineLayout list_single_fep_china_pinyin_pane(TInt /*aIndex_t*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }

// LAF Table : List pane texts (fep china)
// B=24 C={215, 0, 219, 230} Font=EApacPlain12_Scaled J=ELayoutAlignLeft W=88 l=4 r=2 
// Remark                    : Pinyin T9 candidates (width is 44 not 41 to fill the area).
// Parent                    : list_single_fep_china_pinyin_pane
// Parent API                : list_single_fep_china_pinyin_pane
// Scale API match    ( 43%) : fep_china_uni_entry_pane_g_Limits
// Scale parent match ( 45%) : list_single_popup_jap_candidate_pane_ParamLimits
TAknTextLineLayout List_pane_texts__fep_china__Line_1(TInt /*aIndex_C*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyTextLayout();
    }

// LAF Table : Pinyin T9 candidate pop up window graphics
// C=0 H=p W=102 b= l=0 r= t=0 
// Remark                    : A rectangle to cover the main pane elements below.
// Parent                    : popup_fep_china_pinyin_window
// Parent API                : popup_fep_china_pinyin_window
// Scale API match    ( 41%) : popup_fep_japan_candidate_window_ParamLimits
// Scale parent match ( 70%) : popup_fep_china_uni_window_ParamLimits
TAknWindowLineLayout Pinyin_T9_candidate_pop_up_window_graphics_Line_1(const TRect& /*aParentRect*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C=221 H=p-8 W=94 b= l=6 r= t=6 
// Remark                    : Shadow.
// Parent                    : popup_fep_china_pinyin_window
// Parent API                : popup_fep_china_pinyin_window
// Scale API match    ( 41%) : popup_fep_japan_candidate_window_ParamLimits
// Scale parent match ( 70%) : popup_fep_china_uni_window_ParamLimits
TAknWindowLineLayout Pinyin_T9_candidate_pop_up_window_graphics_Line_2(const TRect& /*aParentRect*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C=215 H=p-6 W=96 b= l=2 r= t=2 
// Remark                    : Outline frame.
// Parent                    : popup_fep_china_pinyin_window
// Parent API                : popup_fep_china_pinyin_window
// Scale API match    ( 41%) : popup_fep_japan_candidate_window_ParamLimits
// Scale parent match ( 70%) : popup_fep_china_uni_window_ParamLimits
TAknWindowLineLayout Pinyin_T9_candidate_pop_up_window_graphics_Line_3(const TRect& /*aParentRect*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C=0 H=p-10 W=92 b= l=4 r= t=4 
// Remark                    : Inside area (W is 46 not 45 H is p-5 not p-8).
// Parent                    : popup_fep_china_pinyin_window
// Parent API                : popup_fep_china_pinyin_window
// Scale API match    ( 41%) : popup_fep_japan_candidate_window_ParamLimits
// Scale parent match ( 70%) : popup_fep_china_uni_window_ParamLimits
TAknWindowLineLayout Pinyin_T9_candidate_pop_up_window_graphics_Line_4(const TRect& /*aParentRect*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }

// LAF Table : Pinyin T9 candidate highlight
// C=243 H=p W=p b= l=0 r= t=0 
// Remark                    : Highlight.
// Parent                    : list_single_fep_china_pinyin_pane
// Parent API                : list_single_fep_china_pinyin_pane
// Scale API match    ( 32%) : popup_fep_japan_candidate_window_ParamLimits
// Scale parent match ( 45%) : list_single_popup_jap_candidate_pane_ParamLimits
TAknWindowLineLayout Pinyin_T9_candidate_highlight_Line_1(const TRect& /*aParentRect*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }

// From LAF Table : Pop-up windows (main pane as parent)
// C= H={122, 164, 206, 248, 290, 332, 376, } W=352 b=0 l= r=0 t= 
// Remark                    : 16-pixel special  character selection window. p_height_popup_grid_apac_ character_window
// Parent                    : 
// Parent API                : 
// Scale API match    ( 50%) : popup_grid_graphic_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_grid_apac_character_window(TInt aIndex_H) 
    {
    TInt option = 0;
    if (aIndex_H == 0) option = 6;
    else if (aIndex_H == 1) option = 5;
    else if (aIndex_H == 2) option = 4;
    else if (aIndex_H == 3) option = 3;
    else if (aIndex_H == 4) option = 2;
    else if (aIndex_H == 5) option = 1;
    else if (aIndex_H == 6) option = 0;
    
    return AknLayoutScalable_Avkon::popup_grid_graphic_window(option).LayoutLine();
    }
    
// C= H={46, 76, 106} W=284 b= l={34, 56} r= t= 
// Remark                    : Predictive  candidate popup window.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : popup_fep_japan_predictive_window
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_fep_japan_predictive_window(TInt /*aIndex_l*/, TInt aIndex_H) 
    {
    // AsM: OK
    return AknLayoutScalable_Avkon::popup_fep_japan_predictive_window(aIndex_H).LayoutLine();
    }

// C= H={120, 150, 180, 210, 240} W={92, 116, 140, 164, 188, 212, 236, 260} b= l={-2, 34, 56} r= t= 
// Remark                    : Candidate selection popup window.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : popup_fep_japan_candidate_window
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_fep_japan_candidate_window(TInt /*aIndex_l*/, TInt /*aIndex_W*/, TInt aIndex_H) 
    {
    // AsM: Not sure
    TInt variety = aIndex_H + 3;
    return AknLayoutScalable_Avkon::popup_fep_japan_candidate_window(variety).LayoutLine();
    }

// LAF Table : Candidateselection descendant panes
// C= H={90, 120, 150, 180, 210} W={82, 106, 130, 154, 178, 202, 226, 250, 274} b= l=4 r= t=22 
// Remark                    : Candidate selection list.
// Parent                    : popup_fep_japan_candidate_window
// Parent API                : popup_fep_japan_candidate_window
// Scale API match    (100%) : candidate_pane
// Scale parent match (100%) : popup_fep_japan_candidate_window
TAknWindowLineLayout candidate_pane(TInt /*aIndex_W*/, TInt /*aIndex_H*/) 
    {
    // This method returns candidate pane without scroll pane because list code
    // puts the scroll pane inside candidate pane even it should be outside.
    TInt varietyIndex = 1; 
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Avkon::listscroll_japin_cand_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::candidate_pane(varietyIndex);
    return DoCompose(layout1, layout2).LayoutLine();
    }

// LAF Table : APAC specific list pane placing
// C= H=30 W={82, 106, 130, 154, 178, 202, 226, 250, 274} b= l=0 r= t={0, 30, 60, 90, 120, 150, 180} 
// Remark                    : Candidate list  pane.
// Parent                    : candidate_pane
// Parent API                : candidate_pane
// Scale API match    (100%) : list_single_popup_jap_candidate_pane
// Scale parent match (100%) : candidate_pane
TAknWindowLineLayout list_single_popup_jap_candidate_pane(TInt /*aIndex_t*/, TInt /*aIndex_W*/) 
    {
    return AknLayoutScalable_Avkon::list_single_popup_jap_candidate_pane(0).LayoutLine();
    }


// LAF Table : Listpane text (single japan fep)
// B=24 C=215 Font=EApacPlain12_Scaled J=ELayoutAlignLeft W={72, 96, 120, 144, 168, 192, 216, 240, 264} l=6 r=4 
// Remark                    : Submenu item.
// Parent                    : list_single_popup_jap_candidate_pane
// Parent API                : list_single_popup_jap_candidate_pane
// Scale API match    ( 47%) : list_single_popup_jap_candidate_pane_t1
// Scale parent match (100%) : list_single_popup_jap_candidate_pane
TAknTextLineLayout List_pane_text__single_japan_fep__Line_1(TInt /*aIndex_W*/) 
    {
    return AknLayoutScalable_Avkon::list_single_popup_jap_candidate_pane_t1().LayoutLine();
    }


// LAF Table : Predictive candidate selection list texts
// B={32, 62, 92} C={215, 215} Font=EApacPlain12_Scaled J=ELayoutAlignLeft W=264 l=10 r=10 
// Remark                    : Conversion texts.
// Parent                    : popup_fep_japan_predictive_window
// Parent API                : popup_fep_japan_predictive_window
// Scale API match    ( 30%) : list_single_popup_jap_candidate_pane_ParamLimits
// Scale parent match (100%) : popup_fep_japan_predictive_window
TAknTextLineLayout Predictive_candidate_selection_list_texts_Line_1(TInt /*aIndex_C*/, TInt aIndex_B) 
    {
    return AknLayoutScalable_Avkon::popup_fep_japan_predictive_window_t(aIndex_B, 2).LayoutLine();
    }

// TAknMultiLineTextLayout Multiline_Predictive_candidate_selection_list_texts_Line_1(TInt /*aIndex_C*/, TInt /*aNumberOfLinesShown*/) { }

// LAF Table : Predictive candidate selection highlight
// C=210 H=28 W=0 b= l=-2 r= t=-2 
// Remark                    : Highlight.
// Parent                    : popup_fep_japan_predictive_window
// Parent API                : popup_fep_japan_predictive_window
// Scale API match    ( 25%) : popup_fep_japan_predictive_window_ParamLimits
// Scale parent match (100%) : popup_fep_japan_predictive_window
TAknWindowLineLayout Predictive_candidate_selection_highlight_Line_1() 
    {
    return AknLayoutScalable_Avkon::grid_highlight_pane_cp6().LayoutLine();
    }

// LAF Table : Predictive candidate selection popup window graphics
// C=0 H=p W=284 b= l=0 r= t=0 
// Remark                    : A rectangle to cover the main pane items.
// Parent                    : popup_fep_japan_predictive_window
// Parent API                : popup_fep_japan_predictive_window
// Scale API match    ( 41%) : popup_fep_japan_predictive_window_ParamLimits
// Scale parent match (100%) : popup_fep_japan_predictive_window
TAknWindowLineLayout Predictive_candidate_selection_popup_window_graphics_Line_1(const TRect& /*aParentRect*/) 
    {
    return AknLayoutScalable_Avkon::popup_fep_japan_candidate_window(2).LayoutLine();
    }
    
// C=86 H=p-8 W=276 b= l=6 r= t=6 
// Remark                    : First shadow.
// Parent                    : popup_fep_japan_predictive_window
// Parent API                : popup_fep_japan_predictive_window
// Scale API match    ( 41%) : popup_fep_japan_predictive_window_ParamLimits
// Scale parent match (100%) : popup_fep_japan_predictive_window
TAknWindowLineLayout Predictive_candidate_selection_popup_window_graphics_Line_2(const TRect& /*aParentRect*/) 
    {
    return AknLayoutScalable_Avkon::bg_popup_sub_pane_cp21(2).LayoutLine();
    }
    
// C=210 H=p-6 W=278 b= l=2 r= t=2 
// Remark                    : Outline frame.
// Parent                    : popup_fep_japan_predictive_window
// Parent API                : popup_fep_japan_predictive_window
// Scale API match    ( 41%) : popup_fep_japan_predictive_window_ParamLimits
// Scale parent match (100%) : popup_fep_japan_predictive_window
TAknWindowLineLayout Predictive_candidate_selection_popup_window_graphics_Line_3(const TRect& /*aParentRect*/) 
    {
    return AknLayoutScalable_Avkon::bg_popup_sub_pane_cp21(2).LayoutLine();
    }
    
// C=8 H=p-10 W=274 b= l=4 r= t=4 
// Remark                    : Inside area.
// Parent                    : popup_fep_japan_predictive_window
// Parent API                : popup_fep_japan_predictive_window
// Scale API match    ( 41%) : popup_fep_japan_predictive_window_ParamLimits
// Scale parent match (100%) : popup_fep_japan_predictive_window
TAknWindowLineLayout Predictive_candidate_selection_popup_window_graphics_Line_4(const TRect& /*aParentRect*/) 
    {
    return AknLayoutScalable_Avkon::bg_popup_sub_pane_cp21(2).LayoutLine();
    }

// LAF Table : Candidate selection list texts
// B=16 C=215 Font=ENumberPlain5_Scaled J=ELayoutAlignRight W=44 l=230 r=10 
// Remark                    : Candidate ordinal numbers.
// Parent                    : popup_fep_japan_candidate_window
// Parent API                : popup_fep_japan_candidate_window
// Scale API match    ( 37%) : list_single_popup_jap_candidate_pane_ParamLimits
// Scale parent match (100%) : popup_fep_japan_candidate_window
TAknTextLineLayout Candidate_selection_list_texts_Line_1() 
    {
    return AknLayoutScalable_Avkon::popup_fep_japan_candidate_window_t1().LayoutLine();
    }

// LAF Table : Candidate selection pop-up window graphics
// C=0 H=p W=284 b= l=0 r= t=0 
// Remark                    : A rectangle to cover the main pane items.
// Parent                    : popup_fep_japan_candidate_window
// Parent API                : popup_fep_japan_candidate_window
// Scale API match    ( 41%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_fep_japan_candidate_window
TAknWindowLineLayout Candidate_selection_pop_up_window_graphics_Line_1(const TRect& /*aParentRect*/) 
    {
    return AknLayoutScalable_Avkon::popup_fep_japan_candidate_window(7).LayoutLine();
    }
    
// C=86 H=p-8 W=276 b= l=6 r= t=6 
// Remark                    : First shadow.
// Parent                    : popup_fep_japan_candidate_window
// Parent API                : popup_fep_japan_candidate_window
// Scale API match    ( 41%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_fep_japan_candidate_window
TAknWindowLineLayout Candidate_selection_pop_up_window_graphics_Line_2(const TRect& /*aParentRect*/) 
    {
    return AknLayoutScalable_Avkon::bg_popup_sub_pane_cp23().LayoutLine();
    }
    
// C=215 H=p-6 W=278 b= l=2 r= t=2 
// Remark                    : Outline frame.
// Parent                    : popup_fep_japan_candidate_window
// Parent API                : popup_fep_japan_candidate_window
// Scale API match    ( 41%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_fep_japan_candidate_window
TAknWindowLineLayout Candidate_selection_pop_up_window_graphics_Line_3(const TRect& /*aParentRect*/) 
    {
    return AknLayoutScalable_Avkon::bg_popup_sub_pane_cp23().LayoutLine();
    }
    
// C=0 H=p-10 W=274 b= l=4 r= t=4 
// Remark                    : Inside area.
// Parent                    : popup_fep_japan_candidate_window
// Parent API                : popup_fep_japan_candidate_window
// Scale API match    ( 41%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_fep_japan_candidate_window
TAknWindowLineLayout Candidate_selection_pop_up_window_graphics_Line_4(const TRect& /*aParentRect*/) 
    {
	return AknLayoutScalable_Avkon::listscroll_japin_cand_pane().LayoutLine();
    }

// LAF Table : Chinese FEP Zi popup window elements and descendants panes
// C=219 H=2 W=336 b= l=6 r= t=40 
// Remark                    : Horizontal line between window parts.
// Parent                    : popup_fep_china_zi_window
// Parent API                : popup_fep_china_zi_window
// Scale API match    ( 28%) : popup_fep_china_uni_window_ParamLimits
// Scale parent match ( 86%) : popup_fep_china_uni_window_ParamLimits
TAknWindowLineLayout Chinese_FEP_Zi_popup_window_elements_and_descendants_panes_Line_1() 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C= H=34 W={36, 336} b= l=6 r= t=6 
// Remark                    : Character entry field.
// Parent                    : popup_fep_china_zi_window
// Parent API                : popup_fep_china_zi_window
// Scale API match    ( 85%) : fep_china_uni_entry_pane
// Scale parent match ( 86%) : popup_fep_china_uni_window_ParamLimits
TAknWindowLineLayout fep_china_zi_entry_pane(TInt /*aIndex_W*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C= H=42 W=336 b= l=6 r= t={42, 6} 
// Remark                    : Candidate selection area.
// Parent                    : popup_fep_china_zi_window
// Parent API                : popup_fep_china_zi_window
// Scale API match    ( 88%) : fep_china_uni_candidate_pane_ParamLimits
// Scale parent match ( 86%) : popup_fep_china_uni_window_ParamLimits
TAknWindowLineLayout fep_china_zi_candidate_pane(TInt /*aIndex_t*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }

// LAF Table : Chinese FEP Zi entry pane elements
// C= H=14 W=8 b= l=4 r= t=10 
// Remark                    : More candidates available by scrolling left indication.
// Parent                    : fep_china_zi_entry_pane
// Parent API                : fep_china_zi_entry_pane
// Scale API match    ( 48%) : fep_china_uni_entry_pane_g1
// Scale parent match ( 85%) : fep_china_uni_entry_pane
TAknWindowLineLayout Chinese_FEP_Zi_entry_pane_elements_Line_1() 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C= H=14 W=8 b= l=324 r= t=10 
// Remark                    : More candidates available by scrolling right indication.
// Parent                    : fep_china_zi_entry_pane
// Parent API                : fep_china_zi_entry_pane
// Scale API match    ( 48%) : fep_china_uni_entry_pane_g1
// Scale parent match ( 85%) : fep_china_uni_entry_pane
TAknWindowLineLayout Chinese_FEP_Zi_entry_pane_elements_Line_2() 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }

// LAF Table : Chinese FEP Zi entry pane texts
// B=22 C={215, 0} Font=EApacPlain12_Scaled J=ELayoutAlignLeft W=302 l=18 r=16 
// Remark                    : Character entry.
// Parent                    : fep_china_zi_entry_pane
// Parent API                : fep_china_zi_entry_pane
// Scale API match    ( 50%) : fep_china_uni_entry_pane_g1
// Scale parent match ( 85%) : fep_china_uni_entry_pane
TAknTextLineLayout Chinese_FEP_Zi_entry_pane_texts_Line_1(TInt /*aIndex_C*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyTextLayout();
    }

// LAF Table : Chinese FEP Zi candidate pane elements
// C= H=14 W=8 b= l=4 r= t=12 
// Remark                    : More candidates available by scrolling left indication.
// Parent                    : fep_china_zi_candidate_pane
// Parent API                : fep_china_zi_candidate_pane
// Scale API match    ( 51%) : fep_china_uni_candidate_pane_ParamLimits
// Scale parent match ( 88%) : fep_china_uni_candidate_pane_ParamLimits
TAknWindowLineLayout Chinese_FEP_Zi_candidate_pane_elements_Line_1() 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C= H=14 W=8 b= l=324 r= t=12 
// Remark                    : More candidates available by scrolling right indication.
// Parent                    : fep_china_zi_candidate_pane
// Parent API                : fep_china_zi_candidate_pane
// Scale API match    ( 51%) : fep_china_uni_candidate_pane_ParamLimits
// Scale parent match ( 88%) : fep_china_uni_candidate_pane_ParamLimits
TAknWindowLineLayout Chinese_FEP_Zi_candidate_pane_elements_Line_2() 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C= H=6 W=10 b= l=322 r= t=4 
// Remark                    : Candidates page by page scrolling up available indication.
// Parent                    : fep_china_zi_candidate_pane
// Parent API                : fep_china_zi_candidate_pane
// Scale API match    ( 51%) : fep_china_uni_candidate_pane_ParamLimits
// Scale parent match ( 88%) : fep_china_uni_candidate_pane_ParamLimits
TAknWindowLineLayout Chinese_FEP_Zi_candidate_pane_elements_Line_3() 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C= H=6 W=10 b= l=322 r= t=28 
// Remark                    : Candidates page by page scrolling down available  indication.
// Parent                    : fep_china_zi_candidate_pane
// Parent API                : fep_china_zi_candidate_pane
// Scale API match    ( 51%) : fep_china_uni_candidate_pane_ParamLimits
// Scale parent match ( 88%) : fep_china_uni_candidate_pane_ParamLimits
TAknWindowLineLayout Chinese_FEP_Zi_candidate_pane_elements_Line_4() 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C= H=38 W=4 b= l=-2 r= t=2 
// Remark                    : Candidate highlight.
// Parent                    : fep_china_zi_candidate_pane
// Parent API                : fep_china_zi_candidate_pane
// Scale API match    ( 52%) : list_highlight_pane_cp2
// Scale parent match ( 88%) : fep_china_uni_candidate_pane_ParamLimits
TAknWindowLineLayout fep_china_zi_highlight_pane() 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }

// LAF Table : Chinese FEP Zi candidate pane texts
// B=36 C=215 Font=EApacPlain12_Scaled J=ELayoutAlignLeft W=296 l=20 r=20 
// Remark                    : Candidate list.
// Parent                    : fep_china_zi_candidate_pane
// Parent API                : fep_china_zi_candidate_pane
// Scale API match    ( 55%) : fep_china_uni_candidate_pane_ParamLimits
// Scale parent match ( 88%) : fep_china_uni_candidate_pane_ParamLimits
TAknTextLineLayout Chinese_FEP_Zi_candidate_pane_texts_Line_1() 
    {
    // Not needed because not used. Deprecated API.
    return EmptyTextLayout();
    }
    
// B=28 C=215 Font=EApacPlain12_Scaled J=ELayoutAlignLeft W=300 l=18 r=18 
// Remark                    : Candidate list.
// Parent                    : fep_china_zi_candidate_pane
// Parent API                : fep_china_zi_candidate_pane
// Scale API match    ( 55%) : fep_china_uni_candidate_pane_ParamLimits
// Scale parent match ( 88%) : fep_china_uni_candidate_pane_ParamLimits
TAknTextLineLayout Chinese_FEP_Zi_candidate_pane_texts_Line_2() 
    {
    // Not needed because not used. Deprecated API.
    return EmptyTextLayout();
    }
    
// B=10 C=210 Font=ENumberPlain5_Scaled J=ELayoutAlignCenter W=296 l=20 r=20 
// Remark                    : Candidate numbers.
// Parent                    : fep_china_zi_candidate_pane
// Parent API                : fep_china_zi_candidate_pane
// Scale API match    ( 55%) : fep_china_uni_candidate_pane_ParamLimits
// Scale parent match ( 88%) : fep_china_uni_candidate_pane_ParamLimits
TAknTextLineLayout Chinese_FEP_Zi_candidate_pane_texts_Line_3() 
    {
    // Not needed because not used. Deprecated API.
    return EmptyTextLayout();
    }

// LAF Table : Chinese FEP Zi popup window graphics (part 1)
// C=0 H=40 W=16 b= l=0 r= t=0 
// Remark                    : A rectangle to cover the main pane elements below.
// Parent                    : popup_fep_china_zi_window
// Parent API                : popup_fep_china_zi_window
// Scale API match    ( 38%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match ( 86%) : popup_fep_china_uni_window_ParamLimits
TAknWindowLineLayout Chinese_FEP_Zi_popup_window_graphics__part_1__Line_1() 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C=86 H=36 W=0 b= l=12 r= t={12, 10} 
// Remark                    : Second shadow.
// Parent                    : popup_fep_china_zi_window
// Parent API                : popup_fep_china_zi_window
// Scale API match    ( 38%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match ( 86%) : popup_fep_china_uni_window_ParamLimits
TAknWindowLineLayout Chinese_FEP_Zi_popup_window_graphics__part_1__Line_2(TInt /*aIndex_t*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C=221 H=36 W=2 b= l=8 r= t={8, 6} 
// Remark                    : First shadow.
// Parent                    : popup_fep_china_zi_window
// Parent API                : popup_fep_china_zi_window
// Scale API match    ( 38%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match ( 86%) : popup_fep_china_uni_window_ParamLimits
TAknWindowLineLayout Chinese_FEP_Zi_popup_window_graphics__part_1__Line_3(TInt /*aIndex_t*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C=215 H=38 W=4 b= l=4 r= t=4 
// Remark                    : Outline frame.
// Parent                    : popup_fep_china_zi_window
// Parent API                : popup_fep_china_zi_window
// Scale API match    ( 38%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match ( 86%) : popup_fep_china_uni_window_ParamLimits
TAknWindowLineLayout Chinese_FEP_Zi_popup_window_graphics__part_1__Line_4() 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C=0 H=34 W=0 b= l=6 r= t=6 
// Remark                    : Inside area.
// Parent                    : popup_fep_china_zi_window
// Parent API                : popup_fep_china_zi_window
// Scale API match    ( 38%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match ( 86%) : popup_fep_china_uni_window_ParamLimits
TAknWindowLineLayout Chinese_FEP_Zi_popup_window_graphics__part_1__Line_5() 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }

// LAF Table : Chinese FEP Zi popup window graphics (part 2)
// C=0 H=58 W=352 b= l=0 r= t={36, 0} 
// Remark                    : A rectangle to cover the main pane elements below.
// Parent                    : popup_fep_china_zi_window
// Parent API                : popup_fep_china_zi_window
// Scale API match    ( 38%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match ( 86%) : popup_fep_china_uni_window_ParamLimits
TAknWindowLineLayout Chinese_FEP_Zi_popup_window_graphics__part_2__Line_1(TInt /*aIndex_t*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C=86 H=42 W=336 b= l=12 r= t={48, 12} 
// Remark                    : Second shadow.
// Parent                    : popup_fep_china_zi_window
// Parent API                : popup_fep_china_zi_window
// Scale API match    ( 38%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match ( 86%) : popup_fep_china_uni_window_ParamLimits
TAknWindowLineLayout Chinese_FEP_Zi_popup_window_graphics__part_2__Line_2(TInt /*aIndex_t*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C=221 H=44 W=338 b= l=8 r= t={44, 8} 
// Remark                    : First shadow.
// Parent                    : popup_fep_china_zi_window
// Parent API                : popup_fep_china_zi_window
// Scale API match    ( 38%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match ( 86%) : popup_fep_china_uni_window_ParamLimits
TAknWindowLineLayout Chinese_FEP_Zi_popup_window_graphics__part_2__Line_3(TInt /*aIndex_t*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C=215 H=46 W=340 b= l=4 r= t={40, 4} 
// Remark                    : Outline frame.
// Parent                    : popup_fep_china_zi_window
// Parent API                : popup_fep_china_zi_window
// Scale API match    ( 38%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match ( 86%) : popup_fep_china_uni_window_ParamLimits
TAknWindowLineLayout Chinese_FEP_Zi_popup_window_graphics__part_2__Line_4(TInt /*aIndex_t*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }
    
// C=0 H=42 W=336 b= l=6 r= t={42, 6} 
// Remark                    : Inside area.
// Parent                    : popup_fep_china_zi_window
// Parent API                : popup_fep_china_zi_window
// Scale API match    ( 38%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match ( 86%) : popup_fep_china_uni_window_ParamLimits
TAknWindowLineLayout Chinese_FEP_Zi_popup_window_graphics__part_2__Line_5(TInt /*aIndex_t*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }

// LAF Table : Input highlight elements
// C=210 H=30 W=6 b= l=-4 r= t=-2 
// Remark                    : Input highlight.
// Parent                    : fep_china_zi_entry_pane
// Parent API                : fep_china_zi_entry_pane
// Scale API match    ( 43%) : list_highlight_pane_cp2
// Scale parent match ( 85%) : fep_china_uni_entry_pane
TAknWindowLineLayout Input_highlight_elements_Line_1() 
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// LAF Table : Candidate selection
// C=222 H=36 W=p-2 b= l=2 r= t=2 
// Remark                    : Shadow.
// Parent                    : fep_china_zi_highlight_pane
// Parent API                : fep_china_zi_highlight_pane
// Scale API match    ( 44%) : popup_fep_japan_candidate_window_ParamLimits
// Scale parent match ( 52%) : list_highlight_pane_cp2
TAknWindowLineLayout Candidate_selection_Line_1(const TRect& /*aParentRect*/) 
    {
    // NOT USED
    return EmptyWindowLayout();
    }
    
// C=244 H=36 W=p-2 b= l=0 r= t=0 
// Remark                    : Highlight.
// Parent                    : fep_china_zi_highlight_pane
// Parent API                : fep_china_zi_highlight_pane
// Scale API match    ( 44%) : popup_fep_japan_candidate_window_ParamLimits
// Scale parent match ( 52%) : list_highlight_pane_cp2
TAknWindowLineLayout Candidate_selection_Line_2(const TRect& /*aParentRect*/) 
    {
    // NOT USED
    return EmptyWindowLayout();
    }

// From LAF Table : Pop-up windows (main pane as parent)
// C= H={94, 58}[aCommon1] W=352 b= l=0 r= t={322, 358}[aCommon1] 
// Remark                    : Chinese Zi input  pop-up window.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 86%) : popup_fep_china_uni_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_fep_china_zi_window(TInt /*aCommon1*/) 
    {
    // Not needed because not used. Deprecated API.
    return EmptyWindowLayout();
    }

// LAF Table : Find pop-up window elements
// C= H=32 W=58 b= l=66 r= t=22 
// Remark                    : Search icons of find pane.
// Parent                    : popup_find_window
// Parent API                : popup_find_window
// Scale API match    ( 42%) : bg_popup_window_pane_ParamLimits
// Scale parent match (100%) : popup_find_window
TAknWindowLineLayout Find_pop_up_window_elements_Line_5() 
    {
	TInt varietyIndex = 0; // assume large text
    TAknWindowComponentLayout layout0 = AknLayoutScalable_Avkon::find_popup_pane();
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Avkon::input_popup_find_pane_cp();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::input_popup_find_pane_g1(varietyIndex).LayoutLine();
    return DoCompose(layout0, DoCompose(layout1, layout2)).LayoutLine();
    }

TAknWindowLineLayout Chinese_universal_FEP_pop_up_window_elements_and_descendants_panes_Line_1()
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::popup_fep_china_uni_window_g1();
    return layout.LayoutLine();
    }

TAknWindowLineLayout fep_china_uni_entry_pane()
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::fep_china_uni_entry_pane();
    return layout.LayoutLine();
    }

TAknWindowLineLayout fep_china_uni_candidate_pane(TInt aIndex_t)
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::fep_china_uni_candidate_pane(aIndex_t);
    return layout.LayoutLine();
    }

/*
   TAknLayoutTableLimits Chinese_universal_FEP_pop_up_window_elements_and_descendants_panes_SUB_TABLE_0_Limits();
   TAknWindowLineLayout Chinese_universal_FEP_pop_up_window_elements_and_descendants_panes_SUB_TABLE_0(TInt aLineIndex);
   */

TAknWindowLineLayout Chinese_universal_FEP_entry_pane_elements_Line_1()
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::fep_china_uni_entry_pane_g1();
    return layout.LayoutLine();
    }

TAknWindowLineLayout Chinese_universal_FEP_entry_pane_elements_Line_2()
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::fep_china_uni_entry_pane_g2();
    return layout.LayoutLine();
    }

TAknWindowLineLayout fep_entry_item_pane()
    {
    return AknLayoutScalable_Avkon::fep_entry_item_pane().LayoutLine();
    }

/*
   TAknLayoutTableLimits Chinese_universal_FEP_entry_pane_elements_Limits();
   TAknWindowLineLayout Chinese_universal_FEP_entry_pane_elements(TInt aLineIndex);
   */

TAknTextLineLayout Chinese_universal_FEP_entry_pane_texts_Line_1(TInt aIndex_C)
    {
	__ASSERT_ALWAYS(0 <= aIndex_C && aIndex_C <= 1, Panic(EParamsOutsideKnownRange));
	
    return AknLayoutScalable_Avkon::fep_entry_item_pane_t1( 1-aIndex_C ).LayoutLine();
    }

TAknWindowLineLayout Chinese_universal_FEPcandidate_pane_elements_Line_1()
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::fep_china_uni_candidate_pane_g1();
    return layout.LayoutLine();
    }

TAknWindowLineLayout Chinese_universal_FEPcandidate_pane_elements_Line_2()
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::fep_china_uni_candidate_pane_g2();
    return layout.LayoutLine();
    }

TAknWindowLineLayout Chinese_universal_FEPcandidate_pane_elements_Line_3()
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::fep_china_uni_candidate_pane_g3();
    return layout.LayoutLine();
    }

TAknWindowLineLayout Chinese_universal_FEPcandidate_pane_elements_Line_4()
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::fep_china_uni_candidate_pane_g4();
    return layout.LayoutLine();
    }

TAknWindowLineLayout fep_candidate_item_pane()
    {
    return AknLayoutScalable_Avkon::fep_candidate_item_pane().LayoutLine();
    }

/*
   TAknLayoutTableLimits Chinese_universal_FEPcandidate_pane_elements_Limits();
   TAknWindowLineLayout Chinese_universal_FEPcandidate_pane_elements(TInt aLineIndex);
   */

TAknTextLineLayout Chinese_universal_FEP_candidate_pane_texts_Line_1()
    {
    return AknLayoutScalable_Avkon::fep_candidate_item_pane_t1(0).LayoutLine();
    }

TAknTextLineLayout Chinese_universal_FEP_candidate_pane_texts_Line_2()
    {
    return AknLayoutScalable_Avkon::fep_candidate_item_pane_t1(1).LayoutLine();
    }

TAknTextLineLayout Chinese_universal_FEP_candidate_pane_texts_Line_3()
    {
    return AknLayoutScalable_Avkon::fep_candidate_item_pane_t2(0).LayoutLine();
    }

/* 
   TAknLayoutTableLimits Chinese_universal_FEP_candidate_pane_texts_Limits();
   TAknTextLineLayout Chinese_universal_FEP_candidate_pane_texts(TInt aLineIndex);
   */

TAknWindowLineLayout Chinese_universal_FEP_pop_up_window_graphics_Line_1(const TRect& /*aParentRect*/)
    {
    return AknLayoutScalable_Avkon::popup_fep_china_uni_window(0).LayoutLine();
    }

TAknWindowLineLayout Chinese_universal_FEP_pop_up_window_graphics_Line_2(const TRect& /*aParentRect*/)
    {
    return AknLayoutScalable_Avkon::popup_fep_china_uni_window(0).LayoutLine();
    }

TAknWindowLineLayout Chinese_universal_FEP_pop_up_window_graphics_Line_3(const TRect& /*aParentRect*/)
    {
    return AknLayoutScalable_Avkon::bg_popup_sub_pane_cp24(0).LayoutLine();
    }

TAknWindowLineLayout Chinese_universal_FEP_pop_up_window_graphics_Line_4(const TRect& /*aParentRect*/)
    {
    return AknLayoutScalable_Avkon::bg_popup_sub_pane_cp24(0).LayoutLine();
    }

/* 
   TAknLayoutTableLimits Chinese_universal_FEP_pop_up_window_graphics_Limits();
   TAknWindowLineLayout Chinese_universal_FEP_pop_up_window_graphics(TInt aLineIndex, const TRect& aParentRect);
   */

TAknWindowLineLayout Input_highlight_Line_1(const TRect& /*aParentRect*/)
    {
    return AknLayoutScalable_Avkon::fep_entry_item_pane_g1().LayoutLine();
    }

TAknWindowLineLayout Candidate_selection_highlight_Line_1(const TRect& /*aParentRect*/)
    {
    return AknLayoutScalable_Avkon::list_highlight_pane_cp31(0).LayoutLine();
    }

TAknWindowLineLayout Candidate_selection_highlight_Line_2(const TRect& /*aParentRect*/)
    {
    return AknLayoutScalable_Avkon::list_highlight_pane_cp31(0).LayoutLine();
    }

/* TAknLayoutTableLimits Candidate_selection_highlight_Limits();
   TAknWindowLineLayout Candidate_selection_highlight(TInt aLineIndex, const TRect& aParentRect);
   */

TAknWindowLineLayout popup_fep_china_uni_window(TInt /*aIndex_l*/, TInt aIndex_H)
    {
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Avkon::popup_fep_china_uni_window(aIndex_H);
    return layout1.LayoutLine();
    }




//
// Lookup Table
// This is needed for multiline texts and table decoding
// Do not modify
//

const TUint KDataLookup[AknApacLayout::E_TApiId_TableSize] =
	{
(TUint)&Find_pane_elements_Line_6,

(TUint)&popup_fep_china_window,

(TUint)&popup_fep_china_pinyin_window,

(TUint)&Cursor_graphics__16__Line_1,

(TUint)&Cut_copy_and_paste_highlight_graphics__16__Line_1,

(TUint)&Time_and_date_entry_graphics__16__Line_1,

(TUint)&cell_apac_character_popup_pane,

(TUint)&Cell_pane_texts__pop_up_APAC_character__Line_1,

(TUint)&APAC_character_selection_pop_up_window_descendants_Line_1,

(TUint)&grid_apac_character_popup_pane,

(TUint)&APAC_character_selection_pop_up_window_elements_Line_1,

(TUint)&APAC_character_selection_pop_up_window_elements_Line_2,

(TUint)&APAC_character_selection_pop_up_window_graphics_Line_1,

(TUint)&APAC_character_selection_pop_up_window_graphics_Line_2,

(TUint)&APAC_character_selection_pop_up_window_graphics_Line_3,

(TUint)&APAC_character_selection_pop_up_window_graphics_Line_4,

(TUint)&APAC_character_selection_pop_up_window_graphics_Line_5,

0x0104,

(TUint)AknApacLayout::EApiId_APAC_character_selection_pop_up_window_graphics_Line_1,

(TUint)&Chinese_FEP_pop_up_window_elements_and_descendants_panes_Line_1,

(TUint)&fep_china_entry_pane,

(TUint)&fep_china_candidate_pane,

(TUint)&Chinese_FEP_entry_pane_texts_Line_1,

(TUint)&Chinese_FEP_candidate_pane_elements_Line_1,

(TUint)&Chinese_FEP_candidate_pane_elements_Line_2,

(TUint)&Chinese_FEP_candidate_pane_elements_Line_3,

(TUint)&fep_china_highlight_pane,

0x0102,

(TUint)AknApacLayout::EApiId_Chinese_FEP_candidate_pane_elements_Line_1,

(TUint)&Chinese_FEP_candidate_pane_texts_Line_1,

(TUint)&Chinese_FEP_candidate_pane_texts_Line_2,

(TUint)&Chinese_FEP_pop_up_window_graphics_Line_1,

(TUint)&Chinese_FEP_pop_up_window_graphics_Line_2,

(TUint)&Chinese_FEP_pop_up_window_graphics_Line_3,

(TUint)&Chinese_FEP_pop_up_window_graphics_Line_4,

(TUint)&Chinese_FEP_pop_up_window_graphics_Line_5,

0x0004,

(TUint)AknApacLayout::EApiId_Chinese_FEP_pop_up_window_graphics_Line_1,

(TUint)&Chinese_FEP_highlight_elements_Line_1,

(TUint)&Chinese_FEP_highlight_elements_Line_2,

(TUint)&Chinese_FEP_highlight_elements_Line_3,

0x0002,

(TUint)AknApacLayout::EApiId_Chinese_FEP_highlight_elements_Line_1,

(TUint)&Chinese_FEP_highlight_texts_Line_1,

(TUint)&Unselected_string_highlight_Line_1,

(TUint)&list_single_fep_china_pinyin_pane,

(TUint)&List_pane_texts__fep_china__Line_1,

(TUint)&Pinyin_T9_candidate_pop_up_window_graphics_Line_1,

(TUint)&Pinyin_T9_candidate_pop_up_window_graphics_Line_2,

(TUint)&Pinyin_T9_candidate_pop_up_window_graphics_Line_3,

(TUint)&Pinyin_T9_candidate_pop_up_window_graphics_Line_4,

0x0003,

(TUint)AknApacLayout::EApiId_Pinyin_T9_candidate_pop_up_window_graphics_Line_1,

(TUint)&Pinyin_T9_candidate_highlight_Line_1,

(TUint)&popup_grid_apac_character_window,

(TUint)&popup_fep_japan_predictive_window,

(TUint)&popup_fep_japan_candidate_window,

(TUint)&candidate_pane,

(TUint)&list_single_popup_jap_candidate_pane,

(TUint)&List_pane_text__single_japan_fep__Line_1,

(TUint)&Predictive_candidate_selection_list_texts_Line_1,

0x0101,	// Multiline_Predictive_candidate_selection_list_texts_Line_1

(TUint)&Predictive_candidate_selection_highlight_Line_1,

(TUint)&Predictive_candidate_selection_popup_window_graphics_Line_1,

(TUint)&Predictive_candidate_selection_popup_window_graphics_Line_2,

(TUint)&Predictive_candidate_selection_popup_window_graphics_Line_3,

(TUint)&Predictive_candidate_selection_popup_window_graphics_Line_4,

0x0003,

(TUint)AknApacLayout::EApiId_Predictive_candidate_selection_popup_window_graphics_Line_1,

(TUint)&Candidate_selection_list_texts_Line_1,

(TUint)&Candidate_selection_pop_up_window_graphics_Line_1,

(TUint)&Candidate_selection_pop_up_window_graphics_Line_2,

(TUint)&Candidate_selection_pop_up_window_graphics_Line_3,

(TUint)&Candidate_selection_pop_up_window_graphics_Line_4,

0x0003,

(TUint)AknApacLayout::EApiId_Candidate_selection_pop_up_window_graphics_Line_1,

(TUint)&Chinese_FEP_Zi_popup_window_elements_and_descendants_panes_Line_1,

(TUint)&fep_china_zi_entry_pane,

(TUint)&fep_china_zi_candidate_pane,

(TUint)&Chinese_FEP_Zi_entry_pane_elements_Line_1,

(TUint)&Chinese_FEP_Zi_entry_pane_elements_Line_2,

0x0001,

(TUint)AknApacLayout::EApiId_Chinese_FEP_Zi_entry_pane_elements_Line_1,

(TUint)&Chinese_FEP_Zi_entry_pane_texts_Line_1,

(TUint)&Chinese_FEP_Zi_candidate_pane_elements_Line_1,

(TUint)&Chinese_FEP_Zi_candidate_pane_elements_Line_2,

(TUint)&Chinese_FEP_Zi_candidate_pane_elements_Line_3,

(TUint)&Chinese_FEP_Zi_candidate_pane_elements_Line_4,

(TUint)&fep_china_zi_highlight_pane,

0x0004,

(TUint)AknApacLayout::EApiId_Chinese_FEP_Zi_candidate_pane_elements_Line_1,

(TUint)&Chinese_FEP_Zi_candidate_pane_texts_Line_1,

(TUint)&Chinese_FEP_Zi_candidate_pane_texts_Line_2,

(TUint)&Chinese_FEP_Zi_candidate_pane_texts_Line_3,

0x0002,

(TUint)AknApacLayout::EApiId_Chinese_FEP_Zi_candidate_pane_texts_Line_1,

(TUint)&Chinese_FEP_Zi_popup_window_graphics__part_1__Line_1,

(TUint)&Chinese_FEP_Zi_popup_window_graphics__part_1__Line_2,

(TUint)&Chinese_FEP_Zi_popup_window_graphics__part_1__Line_3,

(TUint)&Chinese_FEP_Zi_popup_window_graphics__part_1__Line_4,

(TUint)&Chinese_FEP_Zi_popup_window_graphics__part_1__Line_5,

0x0102,

(TUint)AknApacLayout::EApiId_Chinese_FEP_Zi_popup_window_graphics__part_1__Line_1,

0x0304,

(TUint)AknApacLayout::EApiId_Chinese_FEP_Zi_popup_window_graphics__part_1__Line_1,

(TUint)&Chinese_FEP_Zi_popup_window_graphics__part_2__Line_1,

(TUint)&Chinese_FEP_Zi_popup_window_graphics__part_2__Line_2,

(TUint)&Chinese_FEP_Zi_popup_window_graphics__part_2__Line_3,

(TUint)&Chinese_FEP_Zi_popup_window_graphics__part_2__Line_4,

(TUint)&Chinese_FEP_Zi_popup_window_graphics__part_2__Line_5,

0x0004,

(TUint)AknApacLayout::EApiId_Chinese_FEP_Zi_popup_window_graphics__part_2__Line_1,

(TUint)&Input_highlight_elements_Line_1,

(TUint)&Candidate_selection_Line_1,

(TUint)&Candidate_selection_Line_2,

0x0001,

(TUint)AknApacLayout::EApiId_Candidate_selection_Line_1,

(TUint)&popup_fep_china_zi_window,

(TUint)&Find_pop_up_window_elements_Line_5,

(TUint)&Chinese_universal_FEP_pop_up_window_elements_and_descendants_panes_Line_1,

(TUint)&fep_china_uni_entry_pane,

(TUint)&fep_china_uni_candidate_pane,

0x0001,

(TUint16)AknApacLayout::EApiId_Chinese_universal_FEP_pop_up_window_elements_and_descendants_panes_Line_1,

(TUint)&Chinese_universal_FEP_entry_pane_elements_Line_1,

(TUint)&Chinese_universal_FEP_entry_pane_elements_Line_2,

(TUint)&fep_entry_item_pane,

0x0002,

(TUint16)AknApacLayout::EApiId_Chinese_universal_FEP_entry_pane_elements_Line_1,

(TUint)&Chinese_universal_FEP_entry_pane_texts_Line_1,

(TUint)&Chinese_universal_FEPcandidate_pane_elements_Line_1,

(TUint)&Chinese_universal_FEPcandidate_pane_elements_Line_2,

(TUint)&Chinese_universal_FEPcandidate_pane_elements_Line_3,

(TUint)&Chinese_universal_FEPcandidate_pane_elements_Line_4,

(TUint)&fep_candidate_item_pane,

0x0004,

(TUint16)AknApacLayout::EApiId_Chinese_universal_FEPcandidate_pane_elements_Line_1,

(TUint)&Chinese_universal_FEP_candidate_pane_texts_Line_1,

(TUint)&Chinese_universal_FEP_candidate_pane_texts_Line_2,

(TUint)&Chinese_universal_FEP_candidate_pane_texts_Line_3,

0x0002,

(TUint16)AknApacLayout::EApiId_Chinese_universal_FEP_candidate_pane_texts_Line_1,

(TUint)&Chinese_universal_FEP_pop_up_window_graphics_Line_1,

(TUint)&Chinese_universal_FEP_pop_up_window_graphics_Line_2,

(TUint)&Chinese_universal_FEP_pop_up_window_graphics_Line_3,

(TUint)&Chinese_universal_FEP_pop_up_window_graphics_Line_4,

0x0003,

(TUint16)AknApacLayout::EApiId_Chinese_universal_FEP_pop_up_window_graphics_Line_1,

(TUint)&Input_highlight_Line_1,

(TUint)&Candidate_selection_highlight_Line_1,

(TUint)&Candidate_selection_highlight_Line_2,

0x0001,

(TUint16)AknApacLayout::EApiId_Candidate_selection_highlight_Line_1,

(TUint)&popup_fep_china_uni_window,

};

#define IMPL_OK(x) &x


#define NOT_NEEDED(x) &x
#define NOT_DONE(x) &x
#define DO_NOT_WORK(x) &x

//
// Implementation
// - if there is NULL in this table, then the implementation in other CDL instance will be used (the ones generated from LAY files)
//

const AknApacLayout::SCdlImpl KCdlImpl = 
    {
    IMPL_OK(Find_pane_elements_Line_6),  //&WindowLine0f,
    NOT_NEEDED(popup_fep_china_window),   //&WindowLine1f,
    NOT_NEEDED(popup_fep_china_pinyin_window),    //&WindowLine1f,
    NOT_NEEDED(Cursor_graphics__16__Line_1),  //&WindowLine0f,
    NOT_NEEDED(Cut_copy_and_paste_highlight_graphics__16__Line_1),    //&WindowLine0f,
    NOT_NEEDED(Time_and_date_entry_graphics__16__Line_1), //&WindowLine0f,
    IMPL_OK(cell_apac_character_popup_pane),   //&WindowLine1f,
    NOT_NEEDED(Cell_pane_texts__pop_up_APAC_character__Line_1),   //&TextLine0f,
    NOT_NEEDED(APAC_character_selection_pop_up_window_descendants_Line_1),    //&WindowLine1f,
    IMPL_OK(grid_apac_character_popup_pane),   //&WindowLine2f,
    NOT_NEEDED(APAC_character_selection_pop_up_window_elements_Line_1),   //&WindowLine1f,
    NOT_NEEDED(APAC_character_selection_pop_up_window_elements_Line_2),   //&WindowLine2f,
    NOT_NEEDED(APAC_character_selection_pop_up_window_graphics_Line_1),   //&WindowLine0t,
    NOT_NEEDED(APAC_character_selection_pop_up_window_graphics_Line_2),   //&WindowLine1t,
    NOT_NEEDED(APAC_character_selection_pop_up_window_graphics_Line_3),   //&WindowLine1t,
    NOT_NEEDED(APAC_character_selection_pop_up_window_graphics_Line_4),   //&WindowLine1t,
    NOT_NEEDED(APAC_character_selection_pop_up_window_graphics_Line_5),   //&WindowLine1t,
    NOT_NEEDED(Limits),
    NOT_NEEDED(WindowTable1t),
    NOT_NEEDED(Chinese_FEP_pop_up_window_elements_and_descendants_panes_Line_1),  //&WindowLine1f,
    NOT_NEEDED(fep_china_entry_pane), //&WindowLine1f,
    NOT_NEEDED(fep_china_candidate_pane), //&WindowLine1f,
    NOT_NEEDED(Chinese_FEP_entry_pane_texts_Line_1),  //&TextLine2f,
    NOT_NEEDED(Chinese_FEP_candidate_pane_elements_Line_1),   //&WindowLine1f,
    NOT_NEEDED(Chinese_FEP_candidate_pane_elements_Line_2),   //&WindowLine0f,
    NOT_NEEDED(Chinese_FEP_candidate_pane_elements_Line_3),   //&WindowLine0f,
    NOT_NEEDED(fep_china_highlight_pane), //&WindowLine1f,
    NOT_NEEDED(Limits),
    NOT_NEEDED(WindowTable0f),
    NOT_NEEDED(Chinese_FEP_candidate_pane_texts_Line_1),  //&TextLine2f,
    NOT_NEEDED(Chinese_FEP_candidate_pane_texts_Line_2),  //&TextLine1f,
    NOT_NEEDED(Chinese_FEP_pop_up_window_graphics_Line_1),    //&WindowLine1t,
    NOT_NEEDED(Chinese_FEP_pop_up_window_graphics_Line_2),    //&WindowLine1t,
    NOT_NEEDED(Chinese_FEP_pop_up_window_graphics_Line_3),    //&WindowLine1t,
    NOT_NEEDED(Chinese_FEP_pop_up_window_graphics_Line_4),    //&WindowLine1t,
    NOT_NEEDED(Chinese_FEP_pop_up_window_graphics_Line_5),    //&WindowLine1t,
    NOT_NEEDED(Limits),
    NOT_NEEDED(WindowTable1t),
    NOT_NEEDED(Chinese_FEP_highlight_elements_Line_1),    //&WindowLine0f,
    NOT_NEEDED(Chinese_FEP_highlight_elements_Line_2),    //&WindowLine0f,
    NOT_NEEDED(Chinese_FEP_highlight_elements_Line_3),    //&WindowLine0f,
    NOT_NEEDED(Limits),
    NOT_NEEDED(WindowTable0f),
    NOT_NEEDED(Chinese_FEP_highlight_texts_Line_1),   //&TextLine1f,
    NOT_NEEDED(Unselected_string_highlight_Line_1),   //&WindowLine1f,
    NOT_NEEDED(list_single_fep_china_pinyin_pane),    //&WindowLine1f,
    NOT_NEEDED(List_pane_texts__fep_china__Line_1),   //&TextLine1f,
    NOT_NEEDED(Pinyin_T9_candidate_pop_up_window_graphics_Line_1),    //&WindowLine0t,
    NOT_NEEDED(Pinyin_T9_candidate_pop_up_window_graphics_Line_2),    //&WindowLine0t,
    NOT_NEEDED(Pinyin_T9_candidate_pop_up_window_graphics_Line_3),    //&WindowLine0t,
    NOT_NEEDED(Pinyin_T9_candidate_pop_up_window_graphics_Line_4),    //&WindowLine0t,
    NOT_NEEDED(Limits),
    NOT_NEEDED(WindowTable0t),
    NOT_NEEDED(Pinyin_T9_candidate_highlight_Line_1), //&WindowLine0t,
    IMPL_OK(popup_grid_apac_character_window), //&WindowLine1f,
    DO_NOT_WORK(popup_fep_japan_predictive_window),    //&WindowLine2f,
    IMPL_OK(popup_fep_japan_candidate_window), //&WindowLine3f,
    IMPL_OK(candidate_pane),   //&WindowLine2f,
    IMPL_OK(list_single_popup_jap_candidate_pane), //&WindowLine2f,
    IMPL_OK(List_pane_text__single_japan_fep__Line_1), //&TextLine1f,
    DO_NOT_WORK(Predictive_candidate_selection_list_texts_Line_1), //&TextLine2f,
    DO_NOT_WORK(MultiLineTextLine2f),   //&MultiLineTextLine2f,
    IMPL_OK(Predictive_candidate_selection_highlight_Line_1),  //&WindowLine0f,
    DO_NOT_WORK(Predictive_candidate_selection_popup_window_graphics_Line_1),  //&WindowLine0t,
    DO_NOT_WORK(Predictive_candidate_selection_popup_window_graphics_Line_2),  //&WindowLine0t,
    DO_NOT_WORK(Predictive_candidate_selection_popup_window_graphics_Line_3),  //&WindowLine0t,
    DO_NOT_WORK(Predictive_candidate_selection_popup_window_graphics_Line_4),  //&WindowLine0t,
    NOT_NEEDED(Limits),
    NOT_NEEDED(WindowTable0t),
    IMPL_OK(Candidate_selection_list_texts_Line_1),    //&TextLine0f,
    DO_NOT_WORK(Candidate_selection_pop_up_window_graphics_Line_1),    //&WindowLine0t,
    DO_NOT_WORK(Candidate_selection_pop_up_window_graphics_Line_2),    //&WindowLine0t,
    DO_NOT_WORK(Candidate_selection_pop_up_window_graphics_Line_3),    //&WindowLine0t,
    DO_NOT_WORK(Candidate_selection_pop_up_window_graphics_Line_4),    //&WindowLine0t,
    NOT_NEEDED(Limits),
    NOT_NEEDED(WindowTable0t),
    NOT_NEEDED(Chinese_FEP_Zi_popup_window_elements_and_descendants_panes_Line_1),    //&WindowLine0f,
    NOT_NEEDED(fep_china_zi_entry_pane),  //&WindowLine1f,
    NOT_NEEDED(fep_china_zi_candidate_pane),  //&WindowLine1f,
    NOT_NEEDED(Chinese_FEP_Zi_entry_pane_elements_Line_1),    //&WindowLine0f,
    NOT_NEEDED(Chinese_FEP_Zi_entry_pane_elements_Line_2),    //&WindowLine0f,
    NOT_NEEDED(Limits),
    NOT_NEEDED(WindowTable0f),
    NOT_NEEDED(Chinese_FEP_Zi_entry_pane_texts_Line_1),   //&TextLine1f,
    NOT_NEEDED(Chinese_FEP_Zi_candidate_pane_elements_Line_1),    //&WindowLine0f,
    NOT_NEEDED(Chinese_FEP_Zi_candidate_pane_elements_Line_2),    //&WindowLine0f,
    NOT_NEEDED(Chinese_FEP_Zi_candidate_pane_elements_Line_3),    //&WindowLine0f,
    NOT_NEEDED(Chinese_FEP_Zi_candidate_pane_elements_Line_4),    //&WindowLine0f,
    NOT_NEEDED(fep_china_zi_highlight_pane),  //&WindowLine0f,
    NOT_NEEDED(Limits),
    NOT_NEEDED(WindowTable0f),
    NOT_NEEDED(Chinese_FEP_Zi_candidate_pane_texts_Line_1),   //&TextLine0f,
    NOT_NEEDED(Chinese_FEP_Zi_candidate_pane_texts_Line_2),   //&TextLine0f,
    NOT_NEEDED(Chinese_FEP_Zi_candidate_pane_texts_Line_3),   //&TextLine0f,
    NOT_NEEDED(Limits),
    NOT_NEEDED(TextTable0f),
    NOT_NEEDED(Chinese_FEP_Zi_popup_window_graphics__part_1__Line_1), //&WindowLine0f,
    NOT_NEEDED(Chinese_FEP_Zi_popup_window_graphics__part_1__Line_2), //&WindowLine1f,
    NOT_NEEDED(Chinese_FEP_Zi_popup_window_graphics__part_1__Line_3), //&WindowLine1f,
    NOT_NEEDED(Chinese_FEP_Zi_popup_window_graphics__part_1__Line_4), //&WindowLine0f,
    NOT_NEEDED(Chinese_FEP_Zi_popup_window_graphics__part_1__Line_5), //&WindowLine0f,
    NOT_NEEDED(Limits),
    NOT_NEEDED(WindowTable1f),
    NOT_NEEDED(Limits),
    NOT_NEEDED(WindowTable0f),
    NOT_NEEDED(Chinese_FEP_Zi_popup_window_graphics__part_2__Line_1), //&WindowLine1f,
    NOT_NEEDED(Chinese_FEP_Zi_popup_window_graphics__part_2__Line_2), //&WindowLine1f,
    NOT_NEEDED(Chinese_FEP_Zi_popup_window_graphics__part_2__Line_3), //&WindowLine1f,
    NOT_NEEDED(Chinese_FEP_Zi_popup_window_graphics__part_2__Line_4), //&WindowLine1f,
    NOT_NEEDED(Chinese_FEP_Zi_popup_window_graphics__part_2__Line_5), //&WindowLine1f,
    NOT_NEEDED(Limits),
    NOT_NEEDED(WindowTable1f),
    NOT_NEEDED(Input_highlight_elements_Line_1),  //&WindowLine0f,
    NOT_NEEDED(Candidate_selection_Line_1),   //&WindowLine0t,
    NOT_NEEDED(Candidate_selection_Line_2),   //&WindowLine0t,
    NOT_NEEDED(Limits),
    NOT_NEEDED(WindowTable0t),
    NOT_NEEDED(popup_fep_china_zi_window),    //&WindowLine1f,
    IMPL_OK(Find_pop_up_window_elements_Line_5),   //&WindowLine0f,
	IMPL_OK(Chinese_universal_FEP_pop_up_window_elements_and_descendants_panes_Line_1), // &WindowLine0f,
	IMPL_OK(fep_china_uni_entry_pane), // &WindowLine0f,
	IMPL_OK(fep_china_uni_candidate_pane), // &WindowLine1f,
	IMPL_OK(Limits),
	IMPL_OK(WindowTable0f),
	IMPL_OK(Chinese_universal_FEP_entry_pane_elements_Line_1), // &WindowLine0f,
	IMPL_OK(Chinese_universal_FEP_entry_pane_elements_Line_2), // &WindowLine0f,
	IMPL_OK(fep_entry_item_pane), // &WindowLine0f,
	IMPL_OK(Limits),
	IMPL_OK(WindowTable0f),
	IMPL_OK(Chinese_universal_FEP_entry_pane_texts_Line_1), // &TextLine1f,
	IMPL_OK(Chinese_universal_FEPcandidate_pane_elements_Line_1), // &WindowLine0f,
	IMPL_OK(Chinese_universal_FEPcandidate_pane_elements_Line_2), // &WindowLine0f,
	IMPL_OK(Chinese_universal_FEPcandidate_pane_elements_Line_3), // &WindowLine0f,
	IMPL_OK(Chinese_universal_FEPcandidate_pane_elements_Line_4), // &WindowLine0f,
	IMPL_OK(fep_candidate_item_pane), // &WindowLine0f,
	IMPL_OK(Limits),
	IMPL_OK(WindowTable0f),
	IMPL_OK(Chinese_universal_FEP_candidate_pane_texts_Line_1), // &TextLine0f,
	IMPL_OK(Chinese_universal_FEP_candidate_pane_texts_Line_2), // &TextLine0f,
	IMPL_OK(Chinese_universal_FEP_candidate_pane_texts_Line_3), // &TextLine0f,
	IMPL_OK(Limits),
	IMPL_OK(TextTable0f),
	DO_NOT_WORK(Chinese_universal_FEP_pop_up_window_graphics_Line_1), // &WindowLine0t,
	DO_NOT_WORK(Chinese_universal_FEP_pop_up_window_graphics_Line_2), // &WindowLine0t,
	DO_NOT_WORK(Chinese_universal_FEP_pop_up_window_graphics_Line_3), // &WindowLine0t,
	DO_NOT_WORK(Chinese_universal_FEP_pop_up_window_graphics_Line_4), // &WindowLine0t,
	NOT_NEEDED(Limits),
	NOT_NEEDED(WindowTable0t),
	IMPL_OK(Input_highlight_Line_1), // &WindowLine0t,
	IMPL_OK(Candidate_selection_highlight_Line_1), // &WindowLine0t,
	IMPL_OK(Candidate_selection_highlight_Line_2), // &WindowLine0t,
	IMPL_OK(Limits),
	IMPL_OK(WindowTable0t),
	IMPL_OK(popup_fep_china_uni_window), // &WindowLine2f,
    };

} // end of namespace Adaptation_Layer_AknApacLayout

