/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/
// This header file contains the customisation implementation identity for Adaptation_Layer_AknLayout_Elaf
// It was generated by hand, not by layout compiler.
// This file may be manually modified.
// This customisation implements the interface defined in AknLayout.cdl

#include "adaptation_layer_aknlayout_elaf.h"
#include "AknLayout2AdaptationDecode.h"
#include "aknlayoutscalable_avkon.cdl.h"
#include "layoutmetadata.cdl.h"

enum TAdaptation_Layer_AknLayout_Elaf_Panic
	{
	EParamsOutsideKnownRange,
    ELayoutLineMissing
    };

void Panic(TAdaptation_Layer_AknLayout_Elaf_Panic aCode)
	{
	_LIT(KLayoutPanic, "Layout Adaptation Layer panic");
	User::Panic(KLayoutPanic, aCode);
	}

namespace AknLayout { extern const TUint8 KByteCodedData[]; }

namespace Adaptation_Layer_AknLayout_Elaf
{

extern const TUint KDataLookup[AknLayout::E_TApiId_TableSize];

TAknLayoutTableLimits Limits() { return AknLayoutAdaptationDecode::TableLimits(KDataLookup); }

TAknWindowLineLayout WindowTable0f(TInt aLineIndex) { return AknLayoutAdaptationDecode::WindowTable0f(KDataLookup, aLineIndex); }
TAknWindowLineLayout WindowTable1f(TInt aLineIndex, TInt aParam0) { return AknLayoutAdaptationDecode::WindowTable1f(KDataLookup, aLineIndex, aParam0); }
TAknWindowLineLayout WindowTable2f(TInt aLineIndex, TInt aParam0, TInt aParam1) { return AknLayoutAdaptationDecode::WindowTable2f(KDataLookup, aLineIndex, aParam0, aParam1); }

TAknWindowLineLayout WindowTable0t(TInt aLineIndex, const TRect& aParentRect) { return AknLayoutAdaptationDecode::WindowTable0t(KDataLookup, aLineIndex, aParentRect); }
TAknWindowLineLayout WindowTable1t(TInt aLineIndex, const TRect& aParentRect, TInt aParam0) { return AknLayoutAdaptationDecode::WindowTable1t(KDataLookup, aLineIndex, aParentRect, aParam0); }

TAknTextLineLayout TextTable0f(TInt aLineIndex) { return AknLayoutAdaptationDecode::TextTable0f(KDataLookup, aLineIndex); }
TAknTextLineLayout TextTable1f(TInt aLineIndex, TInt aParam0) { return AknLayoutAdaptationDecode::TextTable1f(KDataLookup, aLineIndex, aParam0); }

TAknMultiLineTextLayout MultiLineTextLine1f(TInt aParam0) { return AknLayoutAdaptationDecode::MultiLineTextLine1f(KDataLookup, aParam0); }
TAknMultiLineTextLayout MultiLineTextLine2f(TInt aParam0,TInt aParam1) { return AknLayoutAdaptationDecode::MultiLineTextLine2f(KDataLookup, aParam0, aParam1); }
TAknMultiLineTextLayout MultiLineTextLine3f(TInt aParam0,TInt aParam1,TInt aParam2) { return AknLayoutAdaptationDecode::MultiLineTextLine3f(KDataLookup, aParam0, aParam1, aParam2); }
TAknMultiLineTextLayout MultiLineTextLine4f(TInt aParam0,TInt aParam1,TInt aParam2,TInt aParam3) { return AknLayoutAdaptationDecode::MultiLineTextLine4f(KDataLookup, aParam0, aParam1, aParam2, aParam3); }

inline TAknWindowComponentLayout DoCompose(TAknWindowComponentLayout aLine1, TAknWindowComponentLayout aLine2) 
    { 
    return TAknWindowComponentLayout::Compose(aLine1, aLine2); 
    }

inline TAknTextComponentLayout DoComposeText(TAknWindowComponentLayout aLine1, TAknTextComponentLayout aLine2) 
    { 
    return TAknWindowComponentLayout::ComposeText(aLine1, aLine2); 
    }

inline TAknWindowComponentLayout DoIntersect(TAknWindowComponentLayout aLine, TAknWindowComponentLayout aLine2) 
    { 
    return TAknWindowComponentLayout::Intersect(aLine, aLine2);
    }

inline TAknWindowComponentLayout DoMinus(TAknWindowComponentLayout aLine, TAknWindowComponentLayout aParentDiff)
    {
    return TAknWindowComponentLayout::Minus(aLine, aParentDiff);
    }

inline TAknWindowComponentLayout DoSplit(TAknWindowComponentLayout aLine, TInt aPart)
    {
    return TAknWindowComponentLayout::Split(aLine, aPart);
    }

//
// This method returns empty TAknWindowLineLayout instance. (Filled with zeroes)
//
const TAknWindowLineLayoutImp KEmptyWindowLayout = {ELayoutEmpty,0,0,0,0,ELayoutEmpty,ELayoutEmpty};
inline const TAknWindowLineLayout& EmptyWindowLayout()
    {
    return *(TAknWindowLineLayout*)&KEmptyWindowLayout;
    }

//
// This method returns empty TAknTextLineLayout instance. (Filled with zeroes)
//
const TAknTextLineLayoutImp KEmptyTextLayout = {ELayoutEmpty,0,0,0,0,ELayoutEmpty,ELayoutEmpty,0,0};
inline const TAknTextLineLayout& EmptyTextLayout()
    {
    return *(TAknTextLineLayout*)&KEmptyTextLayout;
    }

// 0x3559,	// screen
TAknWindowLineLayout WindowLine0f() 
{
	TAknWindowLineLayout line = AknLayoutScalable_Avkon::Screen().LayoutLine();
	return line;
}

// C= H=416 W=352 b= l=0 r= t=0 
// Remark                    : 
// Parent                    : 
// Parent API                : Title_pane_texts_Line_1
// Scale API match    (100%) : Screen
// Scale parent match ( 66%) : title_pane_t1
TAknWindowLineLayout screen() 
	{
	TAknWindowLineLayout line = AknLayoutScalable_Avkon::Screen().LayoutLine();
	// old layout data specified screen by l and r, and client implementation relies on Rect() API, 
	// therefore we need to hack the values 
	line.il = 0;
	line.it = 0;
	return line;
	}

//0x0007,	// application_window
// C= H=p W=p b= l=0 r= t=0 
// Remark                    : 
// Parent                    : screen
// Parent API                : screen
// Scale API match    (100%) : application_window
// Scale parent match (100%) : Screen
TAknWindowLineLayout application_window(const TRect& /*aParentRect*/) 
	{ 
	return AknLayoutScalable_Avkon::application_window(0).LayoutLine();
	}

//0x3564,	// status_pane
// C= H={88, 112} W=p b= l=0 r= t=0 
// Remark                    : qpn_height_status_pane
// Parent                    : application_window
// Parent API                : application_window
// Scale API match    (100%) : status_pane
// Scale parent match (100%) : application_window
TAknWindowLineLayout status_pane( const TRect& /*aParentRect*/, TInt aIndex_H ) 
	{ 
	// known signatures 
    // (0) -> ok
    // (1) -> no know scalable layout
    __ASSERT_ALWAYS(0 <= aIndex_H && aIndex_H <= 1, Panic(EParamsOutsideKnownRange));
    TAknWindowLineLayout line;
    
    TBool isLandscape( Layout_Meta_Data::IsLandscapeOrientation() );
    
	// 0 = classic, 1 = idle
    if ( aIndex_H == 0 )
        {
        TAknWindowComponentLayout topArea( AknLayoutScalable_Avkon::area_top_pane( isLandscape ? 2 : 0 ) );
        TAknWindowComponentLayout status_pane( AknLayoutScalable_Avkon::status_pane( isLandscape ? 1 : 0 ) );
        line = DoCompose( topArea, status_pane ).LayoutLine();
        }
    else
        {
        TAknWindowComponentLayout area_top_pane( AknLayoutScalable_Avkon::area_top_pane( isLandscape ? 2 : 7 ) );
        TAknWindowComponentLayout status_pane_idle( AknLayoutScalable_Avkon::status_idle_pane() );
        line = DoCompose( area_top_pane, status_pane_idle ).LayoutLine();
        }

    return line;
    }

//0x356f,	// main_pane
// C= H= W={p, , , p-2}[aCommon1] b={0, 40} l={0, , , 2}[aCommon1] r= t={0, +88, +112, +90} 
// Remark                    : 
// Parent                    : application_window
// Parent API                : application_window
// Scale API match    (100%) : main_pane
// Scale parent match (100%) : application_window
TAknWindowLineLayout main_pane(const TRect& /*aParentRect*/, TInt /*aCommon1*/, TInt aIndex_t, TInt aIndex_b)
	{
	// {main_pane, , {0, , , 1}[aCommon1], {0, +44, +56, +45}, , {0, 20}, {p, , , p-1}[aCommon1], , },

	// known signatures 
    // (0, 1, 1) -> (0, 44, 20, p), i.e. status pane on, control pane on (classic)
    // (0, 1, 0) -> (0, 44, 0, p), i.e. status pane on, control pane off
    // (0, 0, 1) -> (0, 0, 20, p) , top = 0, i.e. status pane off, control pane on 
    // (0, 0, 0) -> (0, 0, 0, p) , top = 0, i.e. status pane off, bottom = 0, i.e. control pane off
    
    /*
       __ASSERT_ALWAYS(aCommon1 == 0, Panic(EParamsOutsideKnownRange));
       __ASSERT_ALWAYS(0 <= aIndex_t && aIndex_t <= 1, Panic(EParamsOutsideKnownRange));
       __ASSERT_ALWAYS(0 <= aIndex_b && aIndex_b <= 1, Panic(EParamsOutsideKnownRange));
       */
    
    TAknWindowLineLayout line = AknLayoutScalable_Avkon::main_pane(3).LayoutLine();  // classic
    if(aIndex_t == 0 && aIndex_b == 0)
        {
        // this one works for both landscape and portrait
        // whole screen area. status pane off, control pane off.
        line = AknLayoutScalable_Avkon::main_pane(2).LayoutLine();
        }
    else if(!Layout_Meta_Data::IsLandscapeOrientation())
        {
        /* 
        TAknWindowComponentLayout status_small_control_off = AknLayoutScalable_Avkon::main_pane(0); // not used 
        */
        if(aIndex_t == 0 && aIndex_b == 1)
            {
            // Status pane off, control pane on.
            line =  AknLayoutScalable_Avkon::main_pane(1).LayoutLine();
            }
        if(aIndex_t == 1 && aIndex_b == 0)
            {
            // Status pane on, control pane off.
            line = AknLayoutScalable_Avkon::main_pane(5).LayoutLine();
            }
        if(aIndex_t == 1 && aIndex_b == 1)
            {
            // Status pane on, control pane on.
            line = AknLayoutScalable_Avkon::main_pane(3).LayoutLine(); // classic
            }
        }
    else
        {
        // used only in landscape mode
        TAknWindowComponentLayout land_top_on_bottom_on = AknLayoutScalable_Avkon::main_pane(4); 
        line = land_top_on_bottom_on.LayoutLine();
        }
    
    return line;
    }

//0x3588,	// control_pane
// C= H=40 W=p b=0 l=0 r= t= 
// Remark                    : qpn_height_control_pane
// Parent                    : application_window
// Parent API                : application_window
// Scale API match    (100%) : control_pane
// Scale parent match (100%) : application_window
TAknWindowLineLayout control_pane(const TRect& /*aParentRect*/)
	{
	// MAN: Changed landscape index to 6 (= landscape bottom softkeys, with thin statuspane)
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 6 : 0;
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::area_bottom_pane(varietyIndex);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::control_pane();

	TAknWindowLineLayout line = DoCompose(l1,l2).LayoutLine();
	return line;
	}

//0x3590,	// signal_pane
// C= H=p W=24 b= l=0 r= t=0 
// Remark                    : 
// Parent                    : status_pane
// Parent API                : status_pane
// Scale API match    (100%) : signal_pane
// Scale parent match (100%) : status_pane
TAknWindowLineLayout signal_pane(const TRect& /*aParentRect*/)
	{
	return AknLayoutScalable_Avkon::signal_pane(0).LayoutLine();
	}

//0x3598,	// context_pane
// C= H=p W={88, 102} b= l=24 r= t=0 
// Remark                    : 
// Parent                    : status_pane
// Parent API                : status_pane
// Scale API match    (100%) : context_pane
// Scale parent match (100%) : status_pane
TAknWindowLineLayout context_pane(const TRect& /*aParentRect*/, TInt aIndex_W)
	{
	// known signatures
	// 0 -> 0
	// 1 -> 1 (idle)
	__ASSERT_ALWAYS(0 <= aIndex_W && aIndex_W <= 1, Panic(EParamsOutsideKnownRange));
	return AknLayoutScalable_Avkon::context_pane(aIndex_W).LayoutLine();
	}

//0x35a3,	// title_pane
// C= H=56 W={216, 202}[aCommon1] b= l={112, 126}[aCommon1] r= t=0 
// Remark                    : 
// Parent                    : status_pane
// Parent API                : status_pane
// Scale API match    (100%) : title_pane
// Scale parent match (100%) : status_pane
TAknWindowLineLayout title_pane(TInt aCommon1)
	{
	// known signatures
	// 0 -> 0
	// 1-> 1 (idle)
	__ASSERT_ALWAYS(0 <= aCommon1 && aCommon1 <= 1, Panic(EParamsOutsideKnownRange));
	return AknLayoutScalable_Avkon::title_pane(aCommon1).LayoutLine();
	}

//0x35ae,	// battery_pane
// C= H=p W=24 b= l= r=0 t=0 
// Remark                    : Used in the Idle state and during call handling.
// Parent                    : status_pane
// Parent API                : status_pane
// Scale API match    (100%) : battery_pane
// Scale parent match (100%) : status_pane
TAknWindowLineLayout battery_pane(const TRect& /*aParentRect*/)
	{
	return AknLayoutScalable_Avkon::battery_pane(0).LayoutLine(); // not different in idle
	}

//0x35b6,	// uni_indicator_pane
// C= H=p-32 W=24 b= l= r=0 t=0 
// Remark                    : Used in other contexts than the Idle state or during call handling.
// Parent                    : status_pane
// Parent API                : status_pane
// Scale API match    (100%) : uni_indicator_pane
// Scale parent match (100%) : status_pane
TAknWindowLineLayout uni_indicator_pane(const TRect& /*aParentRect*/)
	{
	// 0 = classic, 1 = flat
	return AknLayoutScalable_Avkon::uni_indicator_pane(0).LayoutLine();
	}

//0x35be,	// navi_pane
// C= H=32 W={240, 202}[aCommon1] b=0 l={112, 126}[aCommon1] r= t= 
// Remark                    : 
// Parent                    : status_pane
// Parent API                : status_pane
// Scale API match    (100%) : navi_pane
// Scale parent match (100%) : status_pane
TAknWindowLineLayout navi_pane(TInt aCommon1)
	{
	// known signatures
	// 0 -> 0 
	// 1 -> 1 (idle)
	__ASSERT_ALWAYS(0 <= aCommon1 && aCommon1 <= 1, Panic(EParamsOutsideKnownRange));
	return AknLayoutScalable_Avkon::navi_pane(aCommon1).LayoutLine();
	}

//0x35c9,	// Status_pane_elements_Line_1
// C=237 H=30 W=348 b= l=2 r= t=58 
// Remark                    : Navi pane background graphics.
// Parent                    : status_pane
// Parent API                : status_pane
// Scale API match    ( 52%) : status_pane_g1_ParamLimits
// Scale parent match (100%) : status_pane
TAknWindowLineLayout Status_pane_elements_Line_1()
	{
	return AknLayoutScalable_Avkon::status_pane_g1(0).LayoutLine();
	}

//0x35d2,	// Status_pane_elements_Line_2
// C= H=30 W=348 b= l=2 r= t=58 
// Remark                    : Navi pane background graphics when the navi pane is not used to display information.
// Parent                    : status_pane
// Parent API                : status_pane
// Scale API match    ( 52%) : status_pane_g1_ParamLimits
// Scale parent match (100%) : status_pane
TAknWindowLineLayout Status_pane_elements_Line_2()
	{
	// line 2 is "Navi pane background graphics when the navi pane is not used to display information."
	// so is not the same as option2 (idle), but the data is the same anyway.
	return AknLayoutScalable_Avkon::status_pane_g1(0).LayoutLine();
	}

/*
TAknLayoutTableLimits Status_pane_elements_Limits()

TAknWindowLineLayout Status_pane_elements()
*/

//0x35db,	// Signal_pane_elements_Line_1
// C= H=58 W=24 b= l=0 r= t=0 
// Remark                    : Cellular signal strength indication.
// Parent                    : signal_pane
// Parent API                : signal_pane
// Scale API match    ( 52%) : signal_pane_ParamLimits
// Scale parent match (100%) : signal_pane
TAknWindowLineLayout Signal_pane_elements_Line_1()
	{
	// 0 = classic, 1 = flat
	return AknLayoutScalable_Avkon::signal_pane_g1(0).LayoutLine();
	}

//0x35e2,	// Signal_pane_elements_Line_2
// C= H=30 W=24 b= l=0 r= t=58 
// Remark                    : Antenna icon. GPRS state indications.
// Parent                    : signal_pane
// Parent API                : signal_pane
// Scale API match    ( 52%) : signal_pane_ParamLimits
// Scale parent match (100%) : signal_pane
TAknWindowLineLayout Signal_pane_elements_Line_2()
	{
	return AknLayoutScalable_Avkon::signal_pane_g2(0).LayoutLine();
	}

/*
TAknLayoutTableLimits Signal_pane_elements_Limits()

TAknWindowLineLayout Signal_pane_elements()
*/

//0x0091,	// Signal_strength_area_values_Line_1
// C= H= W= b= l= r= t= 
// Remark                    : No signal coverage.
// Parent                    : signal_pane
// Parent API                : signal_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : signal_pane
TAknWindowLineLayout Signal_strength_area_values_Line_1()
	{
	// NOT USED
	return EmptyWindowLayout();
	}

//0x35e9,	// Signal_strength_area_values_Line_2
// C= H= W= b=54 l=2 r=20 t=50 
// Remark                    : 
// Parent                    : signal_pane
// Parent API                : signal_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : signal_pane
TAknWindowLineLayout Signal_strength_area_values_Line_2()
	{
	return AknLayoutScalable_Avkon::level_1_signal(0).LayoutLine();
	}

//0x35f0,	// Signal_strength_area_values_Line_3
// C= H= W= b=54 l=2 r=20 t=42 
// Remark                    : 
// Parent                    : signal_pane
// Parent API                : signal_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : signal_pane
TAknWindowLineLayout Signal_strength_area_values_Line_3()
	{
	return AknLayoutScalable_Avkon::level_2_signal(0).LayoutLine();
	}

//0x35f7,	// Signal_strength_area_values_Line_4
// C= H= W= b=54 l=2 r=20 t=34 
// Remark                    : 
// Parent                    : signal_pane
// Parent API                : signal_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : signal_pane
TAknWindowLineLayout Signal_strength_area_values_Line_4()
	{
	return AknLayoutScalable_Avkon::level_3_signal(0).LayoutLine();
	}

//0x35fe,	// Signal_strength_area_values_Line_5
// C= H= W= b=54 l=2 r=20 t=26 
// Remark                    : 
// Parent                    : signal_pane
// Parent API                : signal_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : signal_pane
TAknWindowLineLayout Signal_strength_area_values_Line_5()
	{
	return AknLayoutScalable_Avkon::level_4_signal(0).LayoutLine();
	}

//0x3605,	// Signal_strength_area_values_Line_6
// C= H= W= b=54 l=2 r=20 t=18 
// Remark                    : 
// Parent                    : signal_pane
// Parent API                : signal_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : signal_pane
TAknWindowLineLayout Signal_strength_area_values_Line_6()
	{
	return AknLayoutScalable_Avkon::level_5_signal(0).LayoutLine();
	}

//0x360c,	// Signal_strength_area_values_Line_7
// C= H= W= b=54 l=2 r=20 t=10 
// Remark                    : 
// Parent                    : signal_pane
// Parent API                : signal_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : signal_pane
TAknWindowLineLayout Signal_strength_area_values_Line_7()
	{
	return AknLayoutScalable_Avkon::level_6_signal(0).LayoutLine();
	}

//0x3613,	// Signal_strength_area_values_Line_8
// C= H= W= b=54 l=2 r=20 t=2 
// Remark                    : Full signal coverage.
// Parent                    : signal_pane
// Parent API                : signal_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : signal_pane
TAknWindowLineLayout Signal_strength_area_values_Line_8()
	{
	return AknLayoutScalable_Avkon::level_7_signal(0).LayoutLine();
	}

// LAF Table : Battery pane elements

// C= H=58 W=24 b= l= r=0 t=0 
// Remark                    : Battery strength indication.
// Parent                    : battery_pane
// Parent API                : battery_pane
// Scale API match    ( 55%) : battery_pane_ParamLimits
// Scale parent match (100%) : battery_pane
TAknWindowLineLayout Battery_pane_elements_Line_1()
	{
	// 0 = classic, 1 = flat
   	return AknLayoutScalable_Avkon::battery_pane_g1(0).LayoutLine();
	}


// C= H=30 W=24 b= l= r=0 t=58 
// Remark                    : Battery icon.
// Parent                    : battery_pane
// Parent API                : battery_pane
// Scale API match    ( 55%) : battery_pane_ParamLimits
// Scale parent match (100%) : battery_pane
TAknWindowLineLayout Battery_pane_elements_Line_2()
	{
   	return AknLayoutScalable_Avkon::battery_pane_g2(0).LayoutLine();
	}

/*
TAknLayoutTableLimits Battery_pane_elements_Limits();

TAknWindowLineLayout Battery_pane_elements(TInt aLineIndex);
*/

// LAF Table : Battery strength area values
// C= H= W= b= l= r= t= 
// Remark                    : Battery empty.
// Parent                    : battery_pane
// Parent API                : battery_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : battery_pane
TAknWindowLineLayout Battery_strength_area_values_Line_1()
	{
	return EmptyWindowLayout(); // NOT FOUND IN SPECS (not used)
	}

// C= H= W= b=54 l=2 r=20 t=50 
// Remark                    : 
// Parent                    : battery_pane
// Parent API                : battery_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : battery_pane
TAknWindowLineLayout Battery_strength_area_values_Line_2()
	{
	// 0 = classic, 1 = flat
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::aid_levels_battery(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::level_1_battery(0);
	return DoCompose(l1,l2).LayoutLine();
	}

// C= H= W= b=54 l=2 r=20 t=42 
// Remark                    : 
// Parent                    : battery_pane
// Parent API                : battery_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : battery_pane
TAknWindowLineLayout Battery_strength_area_values_Line_3()
	{
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::aid_levels_battery(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::level_2_battery(0);
	return DoCompose(l1,l2).LayoutLine();
	}

// C= H= W= b=54 l=2 r=20 t=34 
// Remark                    : 
// Parent                    : battery_pane
// Parent API                : battery_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : battery_pane
TAknWindowLineLayout Battery_strength_area_values_Line_4()
	{
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::aid_levels_battery(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::level_3_battery(0);
	return DoCompose(l1,l2).LayoutLine();
	}

// C= H= W= b=54 l=2 r=20 t=26 
// Remark                    : 
// Parent                    : battery_pane
// Parent API                : battery_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : battery_pane
TAknWindowLineLayout Battery_strength_area_values_Line_5()
	{
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::aid_levels_battery(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::level_4_battery(0);
	return DoCompose(l1,l2).LayoutLine();
	}

// C= H= W= b=54 l=2 r=20 t=18 
// Remark                    : 
// Parent                    : battery_pane
// Parent API                : battery_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : battery_pane
TAknWindowLineLayout Battery_strength_area_values_Line_6()
	{
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::aid_levels_battery(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::level_5_battery(0);
	return DoCompose(l1,l2).LayoutLine();
	}

// C= H= W= b=54 l=2 r=20 t=10 
// Remark                    : 
// Parent                    : battery_pane
// Parent API                : battery_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : battery_pane
TAknWindowLineLayout Battery_strength_area_values_Line_7()
	{
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::aid_levels_battery(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::level_6_battery(0);
	return DoCompose(l1,l2).LayoutLine();
	}

// C= H= W= b=54 l=2 r=20 t=2 
// Remark                    : Battery full.
// Parent                    : battery_pane
// Parent API                : battery_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : battery_pane
TAknWindowLineLayout Battery_strength_area_values_Line_8()
	{
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::aid_levels_battery(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::level_7_battery(0);
	return DoCompose(l1,l2).LayoutLine();
	}
/*
TAknLayoutTableLimits Battery_strength_area_values_Limits();

TAknWindowLineLayout Battery_strength_area_values(TInt aLineIndex);
*/

// LAF Table : Context pane elements
// C= H=88 W=88 b= l=0 r= t=0 
// Remark                    : Application indication.
// Parent                    : context_pane
// Parent API                : context_pane
// Scale API match    ( 55%) : context_pane_ParamLimits
// Scale parent match (100%) : context_pane
TAknWindowLineLayout Context_pane_elements_Line_1()
	{
	return AknLayoutScalable_Avkon::context_pane_g1().LayoutLine();
	}

// LAF Table : Title pane texts
// B=44 C=215 Font=ELatinBold19_Scaled J=ELayoutAlignLeft W={208, 194} l={2, 2} r=6 
// Remark                    : Primary title font.
// Parent                    : title_pane
// Parent API                : title_pane
// Scale API match    ( 66%) : title_pane_t1
// Scale parent match (100%) : title_pane
TAknTextLineLayout Title_pane_texts_Line_1(TInt /*aIndex_l*/, TInt /*aIndex_W*/)
	{
	return AknLayoutScalable_Avkon::title_pane_t1(0).LayoutLine();
	}

// B={22, 50, } C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={208, 194} l=2 r=6 
// Remark                    : An alternative font for long texts that cannot be typed with the primarytitle font. Two lines of text.
// Parent                    : title_pane
// Parent API                : title_pane
// Scale API match    ( 66%) : title_pane_t1
// Scale parent match (100%) : title_pane
TAknTextLineLayout Title_pane_texts_Line_2(TInt aIndex_B, TInt /*aIndex_W*/)
	{
	if (aIndex_B == 0)
		{
		return AknLayoutScalable_Avkon::title_pane_t2(0).LayoutLine();
		}
	else
		{
		return AknLayoutScalable_Avkon::title_pane_t3(0).LayoutLine();
		}
	}

/*
TAknMultiLineTextLayout Multiline_Title_pane_texts_Line_2(TInt aIndex_W, TInt aNumberOfLinesShown);
=> AknLayoutScalable_Avkon::title_pane_t2 & AknLayoutScalable_Avkon::title_pane_t3
*/

// LAF Table : Title pane elements
// C= H=50 W=194 b= l=4 r= t=4 
// Remark                    : Graphical operator logo image.
// Parent                    : title_pane
// Parent API                : title_pane
// Scale API match    ( 50%) : title_pane_ParamLimits
// Scale parent match (100%) : title_pane
TAknWindowLineLayout Title_pane_elements_Line_1() 
	{
	return AknLayoutScalable_Avkon::title_pane_g1().LayoutLine();
	}
	
// LAF Table : Universal indicator pane elements
// C= H=16 W=24 b=0 l= r= t={0, 16, 32} 
// Remark                    : Status indicator icons.
// Parent                    : uni_indicator_pane
// Parent API                : uni_indicator_pane
// Scale API match    ( 46%) : uni_indicator_pane_g1
// Scale parent match (100%) : uni_indicator_pane
TAknWindowLineLayout Universal_indicator_pane_elements_Line_1(TInt aIndex_t)
    {
	__ASSERT_ALWAYS(0 <= aIndex_t && aIndex_t <= 2, Panic(EParamsOutsideKnownRange));
    TAknWindowLineLayout layout;
    switch(aIndex_t)
        {
        case 0:
            layout = AknLayoutScalable_Avkon::uni_indicator_pane_g1().LayoutLine();
            break;
        case 1:
            layout = AknLayoutScalable_Avkon::uni_indicator_pane_g2().LayoutLine();
            break;
        case 2:
            layout = AknLayoutScalable_Avkon::uni_indicator_pane_g3().LayoutLine();
            break;
        }
    return layout;        
    }

// LAF Table : Navi pane arrow elements
// C= H=32 W=8 b= l=0 r= t=0 
// Remark                    : Left direction indication.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    ( 34%) : navi_pane_ParamLimits
// Scale parent match (100%) : navi_pane
TAknWindowLineLayout Navi_pane_arrow_elements_Line_1()
    {
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::navi_navi_pane();
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::navi_navi_pane_g1(0); // option 0 = tabs
	return DoCompose(l1,l2).LayoutLine();
    }

// C= H=32 W=8 b=0 l={, } r={10, 2} t= 
// Remark                    : Right direction indication.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    ( 34%) : navi_pane_ParamLimits
// Scale parent match (100%) : navi_pane
TAknWindowLineLayout Navi_pane_arrow_elements_Line_2(TInt /*aIndex_l*/, TInt /*aIndex_r*/)
    {
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::navi_navi_pane();
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::navi_navi_pane_g2(0); // option 0 = tabs
	return DoCompose(l1,l2).LayoutLine();
    }

TAknWindowComponentLayout Navi_pane_tab_elements_Line_xx(TAknWindowComponentLayout aLayout)
    {
    // Note that the content of this line is no longer a bitmap, instead it should be a pane
    // which has other layout lines attached to it.

    // DEFECT: Current avkon code does not use AknLayoutUtils in CAknTabGroup::Draw().
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::navi_navi_pane();
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::navi_navi_tabs_pane();
    TAknWindowComponentLayout l3 = aLayout;

    return DoCompose(DoCompose(l1,l2), l3);
    }


// LAF Table : Navi pane tab elements
// C= H=32 W=214 b= l=8 r= t=0 
// Remark                    : Left tab active of two tabs.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    ( 38%) : navi_pane_ParamLimits
// Scale parent match (100%) : navi_pane
TAknWindowLineLayout Navi_pane_tab_elements_Line_1()
    {
    return Navi_pane_tab_elements_Line_xx(AknLayoutScalable_Avkon::navi_tabs_2_pane()).LayoutLine();
    }

// Navi_pane_tab_elements_Line_2() points to Line_1, so no implementation needed.

// C= H=32 W=214 b= l=8 r= t=0 
// Remark                    : Left tab active of two long tabs.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    ( 38%) : navi_pane_ParamLimits
// Scale parent match (100%) : navi_pane
TAknWindowLineLayout Navi_pane_tab_elements_Line_3()
    {
    return Navi_pane_tab_elements_Line_xx(AknLayoutScalable_Avkon::navi_tabs_2_long_pane()).LayoutLine();
    }

// Navi_pane_tab_elements_Line_4() points to Line_3, so no implementation needed.


// C= H=32 W=214 b= l=8 r= t=0 
// Remark                    : Left tab active of three tabs.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    ( 38%) : navi_pane_ParamLimits
// Scale parent match (100%) : navi_pane
TAknWindowLineLayout Navi_pane_tab_elements_Line_5()
    {
    return Navi_pane_tab_elements_Line_xx(AknLayoutScalable_Avkon::navi_tabs_3_pane()).LayoutLine();
    }

// Navi_pane_tab_elements_Line_6() points to Line_5, so no implementation needed.

// Navi_pane_tab_elements_Line_7() points to Line_5, so no implementation needed.


// C= H=32 W=214 b= l=8 r= t=0 
// Remark                    : Left tab active of three long tabs.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    ( 38%) : navi_pane_ParamLimits
// Scale parent match (100%) : navi_pane
TAknWindowLineLayout Navi_pane_tab_elements_Line_8()
    {
    return Navi_pane_tab_elements_Line_xx(AknLayoutScalable_Avkon::navi_tabs_3_long_pane()).LayoutLine();
    }

// Navi_pane_tab_elements_Line_9() points to Line_8, so no implementation needed.

// Navi_pane_tab_elements_Line_10() points to Line_8, so no implementation needed.


// C= H=32 W=214 b= l=8 r= t=0 
// Remark                    : Left tab active of four tabs.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    ( 36%) : navi_pane_ParamLimits
// Scale parent match (100%) : navi_pane
TAknWindowLineLayout Navi_pane_tab_elements_Line_11()
    {
    return Navi_pane_tab_elements_Line_xx(AknLayoutScalable_Avkon::navi_tabs_4_pane()).LayoutLine();
    }

// Navi_pane_tab_elements_Line_12() points to Line_11, so no implementation needed.

// Navi_pane_tab_elements_Line_13() points to Line_11, so no implementation needed.

// Navi_pane_tab_elements_Line_14() points to Line_11, so no implementation needed.


/*
TAknLayoutTableLimits Navi_pane_tab_elements_Limits();

TAknWindowLineLayout Navi_pane_tab_elements(TInt aLineIndex);
*/

// LAF Table : Elements on the tabs
// C= H=22 W=70 b= l={34, 126} r= t=6 
// Remark                    : Active icons in the two tabs.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : navi_pane
TAknWindowLineLayout Elements_on_the_tabs_Line_1(TInt aIndex_l)
	{
    // We have a big gap here -- this line needs extra parameter to decide whether to use left or right tab.
   	TAknWindowComponentLayout layout = Navi_pane_tab_elements_Line_xx(AknLayoutScalable_Avkon::navi_tabs_2_pane());
   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::tabs_2_active_pane(aIndex_l);
   	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::tabs_2_active_pane_g1();
   	// Note, passive pane not used, even though it should be used. We dont have enough information to do that.
   	return DoCompose(DoCompose(layout, l2), l3).LayoutLine();
	}

// C= H=22 W=44 b= l={32, 94, 156} r= t=6 
// Remark                    : Active icons in the three tabs.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : navi_pane
TAknWindowLineLayout Elements_on_the_tabs_Line_2(TInt aIndex_l)
    {
    // We have a big gap here -- this line needs extra parameter to decide whether to use left or right tab.
   	TAknWindowComponentLayout layout = Navi_pane_tab_elements_Line_xx(AknLayoutScalable_Avkon::navi_tabs_3_pane());
   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::tabs_3_active_pane(aIndex_l);
   	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::tabs_3_active_pane_g1();
   	// Note, passive pane not used, even though it should be used. We dont have enough information to do that.
   	return DoCompose(DoCompose(layout, l2), l3).LayoutLine();
   	}

// C= H=22 W=36 b= l={28, 74, 120, 166} r= t=6 
// Remark                    : Active icons in the four tabs.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    (  0%) : 
// Scale parent match (100%) : navi_pane
TAknWindowLineLayout Elements_on_the_tabs_Line_3(TInt aIndex_l)
    {
   	TAknWindowComponentLayout layout = Navi_pane_tab_elements_Line_xx(AknLayoutScalable_Avkon::navi_tabs_4_pane());
   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::tabs_4_active_pane(aIndex_l);
   	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::tabs_4_active_pane_g1();
   	// Note, passive pane not used, even though it should be used. We dont have enough information to do that.
   	return DoCompose(DoCompose(layout, l2), l3).LayoutLine();
    }

 /*
TAknLayoutTableLimits Elements_on_the_tabs_Limits();

TAknWindowLineLayout Elements_on_the_tabs(TInt aLineIndex, TInt aIndex_l);
*/

// LAF Table : Texts on the tabs

// B=24 C=215 Font=ELatinBold12_Scaled J=ELayoutAlignCenter W=72 l={34, 126}[aCommon1] r={132, 40}[aCommon1] 
// Remark                    : Active texts in the two tabs.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    ( 31%) : navi_navi_icon_text_pane_t1
// Scale parent match (100%) : navi_pane
TAknTextLineLayout Texts_on_the_tabs_Line_1(TInt aCommon1)
    {
   	TAknWindowComponentLayout layout = Navi_pane_tab_elements_Line_xx(AknLayoutScalable_Avkon::navi_tabs_2_pane());
   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::tabs_2_active_pane(aCommon1);
   
   	// MAN 23.5.2005: Added variety for landscape/portrait. Actually we should check here if tabs are 
   	// mirrored/flipped instead of landscape/portrait check. B
   	TInt tabTextVarietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;   
   	TAknTextComponentLayout l3 = AknLayoutScalable_Avkon::tabs_2_active_pane_t1(tabTextVarietyIndex);
   	// Note, passive pane not used, even though it should be used. We dont have enough information to do that.
   	return DoComposeText(DoCompose(layout, l2), l3).LayoutLine();
    }

// B=24 C=215 Font=ELatinBold12_Scaled J=ELayoutAlignCenter W=42 l={34, 96, 158}[aCommon1] r={162, 100, 38}[aCommon1] 
// Remark                    : Active texts in the three tabs.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    ( 31%) : navi_navi_icon_text_pane_t1
// Scale parent match (100%) : navi_pane
TAknTextLineLayout Texts_on_the_tabs_Line_2(TInt aCommon1)
    {
   	TAknWindowComponentLayout layout = Navi_pane_tab_elements_Line_xx(AknLayoutScalable_Avkon::navi_tabs_3_pane());
   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::tabs_3_active_pane(aCommon1);
   	// MAN 23.5.2005: Added variety for landscape/portrait. Actually we should check here if tabs are 
   	// mirrored/flipped instead of landscape/portrait check. B
   	TInt tabTextVarietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;   
   	TAknTextComponentLayout l3 = AknLayoutScalable_Avkon::tabs_3_active_pane_t1(tabTextVarietyIndex); 
   	// Note, passive pane not used, even though it should be used. We dont have enough information to do that.
   	return DoComposeText(DoCompose(layout, l2), l3).LayoutLine();
    }

// B=24 C=215 Font=ELatinBold12_Scaled J=ELayoutAlignCenter W=26 l={34, 80, 126, 172}[aCommon1] r={178, 132, 86, 40}[aCommon1] 
// Remark                    : Active texts in the four tabs.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    ( 31%) : navi_navi_icon_text_pane_t1
// Scale parent match (100%) : navi_pane
TAknTextLineLayout Texts_on_the_tabs_Line_3(TInt aCommon1)
    {
   	TAknWindowComponentLayout layout = Navi_pane_tab_elements_Line_xx(AknLayoutScalable_Avkon::navi_tabs_4_pane());
   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::tabs_4_active_pane(aCommon1);
   	// MAN 23.5.2005: Added variety for landscape/portrait. Actually we should check here if tabs are 
   	// mirrored/flipped instead of landscape/portrait check. B
   	TInt tabTextVarietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;   
   	TAknTextComponentLayout l3 = AknLayoutScalable_Avkon::tabs_4_active_pane_t1(tabTextVarietyIndex);
   	// Note, passive pane not used, even though it should be used. We dont have enough information to do that.
   	return DoComposeText(DoCompose(layout, l2), l3).LayoutLine();
    }

// B=24 C=215 Font=ELatinBold12_Scaled J=ELayoutAlignCenter W=148 l={34, 48}[aCommon1] r={58, 44}[aCommon1] 
// Remark                    : Active texts in the two long tabs.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    ( 31%) : navi_navi_icon_text_pane_t1
// Scale parent match (100%) : navi_pane
TAknTextLineLayout Texts_on_the_tabs_Line_4(TInt aCommon1)
	{
   	TAknWindowComponentLayout layout = Navi_pane_tab_elements_Line_xx(AknLayoutScalable_Avkon::navi_tabs_2_long_pane());
   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::tabs_2_long_active_pane(aCommon1);
   	// MAN 23.5.2005: Added variety for landscape/portrait. Actually we should check here if tabs are 
   	// mirrored/flipped instead of landscape/portrait check. B
   	TInt tabTextVarietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;   
   	TAknTextComponentLayout l3 = AknLayoutScalable_Avkon::tabs_2_long_active_pane_t1(tabTextVarietyIndex);
   	// Note, passive pane not used, even though it should be used. We dont have enough information to do that.
   	return DoComposeText(DoCompose(layout, l2), l3).LayoutLine();
    }

// B=24 C=215 Font=ELatinBold12_Scaled J=ELayoutAlignCenter W=134 l={34, 48, 62}[aCommon1] r={72, 58, 44}[aCommon1] 
// Remark                    : Active texts in the three long tabs.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    ( 31%) : navi_navi_icon_text_pane_t1
// Scale parent match (100%) : navi_pane
TAknTextLineLayout Texts_on_the_tabs_Line_5(TInt aCommon1)
    {
   	TAknWindowComponentLayout layout = Navi_pane_tab_elements_Line_xx(AknLayoutScalable_Avkon::navi_tabs_3_long_pane());
   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::tabs_3_long_active_pane(aCommon1);
   	// MAN 23.5.2005: Added variety for landscape/portrait. Actually we should check here if tabs are 
   	// mirrored/flipped instead of landscape/portrait check. B
   	TInt tabTextVarietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;   
   	TAknTextComponentLayout l3 = AknLayoutScalable_Avkon::tabs_3_long_active_pane_t1(tabTextVarietyIndex);
   	// Note, passive pane not used, even though it should be used. We dont have enough information to do that.
   	return DoComposeText(DoCompose(layout, l2), l3).LayoutLine();
    }

/*
TAknLayoutTableLimits Texts_on_the_tabs_Limits();

TAknTextLineLayout Texts_on_the_tabs(TInt aLineIndex, TInt aCommon1);
*/

// C= H=22 W=70 b=4 l=30 r= t=6 
// Remark                    : Icons to indicate the scrolled list type.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    ( 71%) : navi_icon_pane_ParamLimits
// Scale parent match (100%) : navi_pane
TAknWindowLineLayout Navi_pane_icons_Line_1()
	{
	TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::navi_navi_pane();
   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::navi_navi_icon_text_pane();
   	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::navi_navi_icon_text_pane_g1();
   	return DoCompose(DoCompose(layout, l2), l3).LayoutLine();
   	}

// C= H=22 W=32 b=4 l={12, 58, 98, 138, 178}[aCommon1] r={196, 150, 110, 70, 30}[aCommon1] t=6 
// Remark                    : The used memory icon (PhoneMMC) and folders.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    ( 71%) : navi_icon_pane_ParamLimits
// Scale parent match (100%) : navi_pane
TAknWindowLineLayout Navi_pane_icons_Line_2(TInt aCommon1)
    {
    // JH: IMPLEMENTED 27.1.2006. Does not exist in the LAF, so this hack is needed
    // in order to make the folder icons visible in file manager. A change to file manager
    // code or to LAF is necessary for a proper implementation.
    TAknWindowLineLayout layout = AknLayoutScalable_Avkon::navi_icon_text_pane_g1();
	
		layout.it = 6;
		layout.ib = 4;
		layout.iW = 32;
		layout.iH = 22;
		
		switch( aCommon1 )
			{
			case 0:
				layout.ir = 196;
				layout.il = 12;
				break;
			case 1:
				layout.ir = 150;
				layout.il = 58;
				break;
			case 2:
				layout.ir = 110;
				layout.il = 98;
				break;
			case 3:
				layout.ir = 70;
				layout.il = 138;
				break;
			case 4:
			default:
				layout.ir = 30;
				layout.il = 178;
				break;		
			}
			
    return layout;
    }

// LAF Table : Navi pane texts
// B=24 C=0 Font=ELatinBold12_Scaled J=ELayoutAlignCenter W={200, 200}[aCommon1] l=16 r={24, 24}[aCommon1] 
// Remark                    : Navigational information.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    ( 78%) : navi_text_pane_t1
// Scale parent match (100%) : navi_pane
TAknTextLineLayout Navi_pane_texts_Line_1(TInt /*aCommon1*/)
	{
   	/* parameter aCommon1 ignored, because new spec does not anymore make two variants,
       To be checked with specifiers for APAC. (apac.lay has different values)  
    */ 
   	TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::navi_navi_pane();
   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::navi_navi_text_pane();
   	TAknTextComponentLayout l3 = AknLayoutScalable_Avkon::navi_navi_text_pane_t1();
   	return DoComposeText(DoCompose(layout, l2), l3).LayoutLine();
    }

// B=24 C=0 Font=ELatinPlain12_Scaled J={ELayoutAlignLeft, ELayoutAlignRight} W=184 l=12 r=6 
// Remark                    : Additional information.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    ( 78%) : navi_text_pane_t1
// Scale parent match (100%) : navi_pane
TAknTextLineLayout Navi_pane_texts_Line_2(TInt /*aIndex_J*/)
    {
    // MAN: IMPLEMENTED
   	TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::navi_text_pane(0);
   	TAknTextComponentLayout l2 = AknLayoutScalable_Avkon::navi_text_pane_t1();
   	return DoComposeText(layout, l2).LayoutLine();
    }

// B=24 C={0, 229} Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=220 l=12 r=8 
// Remark                    : Miscellanous texts.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    ( 78%) : navi_text_pane_t1
// Scale parent match (100%) : navi_pane
TAknTextLineLayout Navi_pane_texts_Line_3(TInt /*aIndex_C*/)
    {
    // MAN: IMPLEMENTED
   	TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::navi_text_pane(0);
   	TAknTextComponentLayout l2 = AknLayoutScalable_Avkon::navi_text_pane_t1();
   	return DoComposeText(layout, l2).LayoutLine();
    }

// B=24 C=0 Font=ELatinBold12_Scaled J=ELayoutAlignCenter W=106 l=108 r=26 
// Remark                    : Item ordinal number or number of total items.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    ( 78%) : navi_text_pane_t1
// Scale parent match (100%) : navi_pane
TAknTextLineLayout Navi_pane_texts_Line_4()
    {
   	TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::navi_navi_pane();
   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::navi_navi_icon_text_pane();
   	TAknTextComponentLayout l3 = AknLayoutScalable_Avkon::navi_navi_icon_text_pane_t1();
   	return DoComposeText(DoCompose(layout, l2), l3).LayoutLine();
   	}

// B=24 C=0 Font=ELatinBold12_Scaled J=ELayoutAlignRight W=142 l=88 r=10 
// Remark                    : Media Player spent time and time left.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    ( 78%) : navi_text_pane_t1
// Scale parent match (100%) : navi_pane
TAknTextLineLayout Navi_pane_texts_Line_5()
    {
	//=> VIDEOPLAYER, SPEND TIME/TIME LEFT DO NOT EXISTS ANYMORE (not used)
    return EmptyTextLayout();
    }

// B=26 C=0 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=8 l={50, 90, 130, 170} r= 
// Remark                    : Separator between folders.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    ( 78%) : navi_text_pane_t1
// Scale parent match (100%) : navi_pane
TAknTextLineLayout Navi_pane_texts_Line_6(TInt aIndex_l)
    {
    // JH: IMPLEMENTED 27.1.2006. Does not exist in the LAF, so this hack is needed
    // in order to make the folder separator lines visible in file manager. A change to file manager
    // code or to LAF is necessary for a proper implementation.
    TAknTextLineLayout layout = AknLayoutScalable_Avkon::navi_icon_text_pane_t1();

	layout.iW = 8;
	layout.ir = ELayoutEmpty;
		
	switch( aIndex_l )
		{
		case 0:
			layout.il = 50; 
			break;
		case 1:
			layout.il = 90;
			break;
		case 2:
			layout.il = 130;
			break;
		case 3:
			layout.il = 170;
			break;
		default:
			layout.il = ELayoutEmpty;
			layout.ir = ELayoutEmpty;
			break;			
		}
    
    return layout;
    }

// B=24 C={234, 232, 230, 228, 226, 0, 226, 227, 228, 229} Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W={192, 108} l=40 r=8 
// Remark                    : Fading hint text.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    ( 78%) : navi_text_pane_t1
// Scale parent match (100%) : navi_pane
TAknTextLineLayout Navi_pane_texts_Line_7(TInt /*aIndex_C*/, TInt /*aIndex_W*/)
    {
	// 0 in the parameter is nothing
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::navi_text_pane(0);
	TAknTextComponentLayout l2 = AknLayoutScalable_Avkon::navi_text_pane_t1();
	return DoComposeText(l1,l2).LayoutLine();
    }

// LAF Table : Navi pane area for editing status icons
// C= H=18 W=220 b= l=12 r= t=8 
// Remark                    : Editing state icons.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    ( 28%) : status_small_icon_pane
// Scale parent match (100%) : navi_pane
TAknWindowLineLayout Navi_pane_area_for_editing_status_icons_Line_1()
    {
    // MAN: IMPLEMENTED
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::navi_icon_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::navi_icon_pane_g1();
	return DoCompose(l1,l2).LayoutLine();    
    }

// LAF Table : Volume glider elements (one)
// C= H=32 W=34 b= l={18, 26} r= t=0 
// Remark                    : Icon to indicate a measured item.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    ( 27%) : volume_small_pane_g_Limits
// Scale parent match (100%) : navi_pane
TAknWindowLineLayout Volume_glider_elements__one__Line_1(TInt /*aIndex_l*/)
    {
   	TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::navi_navi_pane();
   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::navi_navi_volume_pane();
   	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::navi_navi_volume_pane_g1();
   	return DoCompose(DoCompose(layout, l2), l3).LayoutLine();
    }

// C= H=32 W=118 b= l={62, 76} r= t=0 
// Remark                    : Volume indicator graphics.
// Parent                    : navi_pane
// Parent API                : navi_pane
// Scale API match    ( 85%) : navi_navi_volume_pane
// Scale parent match (100%) : navi_pane
TAknWindowLineLayout volume_navi_pane(TInt /*aIndex_l*/)
    {
   TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::navi_navi_pane();
   TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::navi_navi_volume_pane();
   TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::volume_small_pane();
   return DoCompose(DoCompose(layout, l2), l3).LayoutLine();
    }
    
/*
TAknLayoutTableLimits Volume_glider_elements__one__Limits();

TAknWindowLineLayout Volume_glider_elements__one_(TInt aLineIndex, TInt aIndex_l);
*/

// LAF Table : Volume pane elements (one)
// C={243, 0} H=4 W=10 b= l=0 r= t=24 
// Remark                    : 1. volume strength indicator.
// Parent                    : volume_navi_pane
// Parent API                : volume_navi_pane
// Scale API match    ( 38%) : navi_navi_volume_pane_g1
// Scale parent match ( 85%) : navi_navi_volume_pane
TAknWindowLineLayout Volume_pane_elements__one__Line_1(TInt /*aIndex_C*/)
	{
  	// Note, needs avkon code changes so that rect drawing from code is replaced by bitmaps.
  	return AknLayoutScalable_Avkon::volume_small_pane_g1().LayoutLine();
	}

// C={243, 0} H=6 W=10 b= l=12 r= t=22 
// Remark                    : 2. volume strength indicator.
// Parent                    : volume_navi_pane
// Parent API                : volume_navi_pane
// Scale API match    ( 38%) : navi_navi_volume_pane_g1
// Scale parent match ( 85%) : navi_navi_volume_pane
TAknWindowLineLayout Volume_pane_elements__one__Line_2(TInt /*aIndex_C*/)
	{
  	// Note, needs avkon code changes so that rect drawing from code is replaced by bitmaps.
  	return AknLayoutScalable_Avkon::volume_small_pane_g2().LayoutLine();
	}

// C={243, 0} H=8 W=10 b= l=24 r= t=20 
// Remark                    : 3. volume strength indicator.
// Parent                    : volume_navi_pane
// Parent API                : volume_navi_pane
// Scale API match    ( 38%) : navi_navi_volume_pane_g1
// Scale parent match ( 85%) : navi_navi_volume_pane
TAknWindowLineLayout Volume_pane_elements__one__Line_3(TInt /*aIndex_C*/)
	{
  	// Note, needs avkon code changes so that rect drawing from code is replaced by bitmaps.
  	return AknLayoutScalable_Avkon::volume_small_pane_g3().LayoutLine();
	}

// C={243, 0} H=10 W=10 b= l=36 r= t=18 
// Remark                    : 4. volume strength indicator.
// Parent                    : volume_navi_pane
// Parent API                : volume_navi_pane
// Scale API match    ( 38%) : navi_navi_volume_pane_g1
// Scale parent match ( 85%) : navi_navi_volume_pane
TAknWindowLineLayout Volume_pane_elements__one__Line_4(TInt /*aIndex_C*/)
	{
  	// Note, needs avkon code changes so that rect drawing from code is replaced by bitmaps.
  	return AknLayoutScalable_Avkon::volume_small_pane_g4().LayoutLine();
	}

// C={243, 0} H=12 W=10 b= l=48 r= t=16 
// Remark                    : 5. volume strength indicator.
// Parent                    : volume_navi_pane
// Parent API                : volume_navi_pane
// Scale API match    ( 38%) : navi_navi_volume_pane_g1
// Scale parent match ( 85%) : navi_navi_volume_pane
TAknWindowLineLayout Volume_pane_elements__one__Line_5(TInt /*aIndex_C*/)
	{
  	// Note, needs avkon code changes so that rect drawing from code is replaced by bitmaps.
  	return AknLayoutScalable_Avkon::volume_small_pane_g5().LayoutLine();
	}
	
// C={243, 0} H=14 W=10 b= l=60 r= t=14 
// Remark                    : 6. volume strength indicator.
// Parent                    : volume_navi_pane
// Parent API                : volume_navi_pane
// Scale API match    ( 38%) : navi_navi_volume_pane_g1
// Scale parent match ( 85%) : navi_navi_volume_pane
TAknWindowLineLayout Volume_pane_elements__one__Line_6(TInt /*aIndex_C*/)
	{
  	// Note, needs avkon code changes so that rect drawing from code is replaced by bitmaps.
  	return AknLayoutScalable_Avkon::volume_small_pane_g6().LayoutLine();
	}
	
// C={243, 0} H=16 W=10 b= l=72 r= t=12 
// Remark                    : 7. volume strength indicator.
// Parent                    : volume_navi_pane
// Parent API                : volume_navi_pane
// Scale API match    ( 38%) : navi_navi_volume_pane_g1
// Scale parent match ( 85%) : navi_navi_volume_pane
TAknWindowLineLayout Volume_pane_elements__one__Line_7(TInt /*aIndex_C*/)
	{
  	// Note, needs avkon code changes so that rect drawing from code is replaced by bitmaps.
  	return AknLayoutScalable_Avkon::volume_small_pane_g7().LayoutLine();
	}
	
// C={243, 0} H=18 W=10 b= l=84 r= t=10 
// Remark                    : 8. volume strength indicator.
// Parent                    : volume_navi_pane
// Parent API                : volume_navi_pane
// Scale API match    ( 38%) : navi_navi_volume_pane_g1
// Scale parent match ( 85%) : navi_navi_volume_pane
TAknWindowLineLayout Volume_pane_elements__one__Line_8(TInt /*aIndex_C*/)
	{
  	// Note, needs avkon code changes so that rect drawing from code is replaced by bitmaps.
  	return AknLayoutScalable_Avkon::volume_small_pane_g8().LayoutLine();
	}
	
// C={243, 0} H=20 W=10 b= l=96 r= t=8 
// Remark                    : 9. volume strength indicator.
// Parent                    : volume_navi_pane
// Parent API                : volume_navi_pane
// Scale API match    ( 38%) : navi_navi_volume_pane_g1
// Scale parent match ( 85%) : navi_navi_volume_pane
TAknWindowLineLayout Volume_pane_elements__one__Line_9(TInt /*aIndex_C*/)
	{
  	// Note, needs avkon code changes so that rect drawing from code is replaced by bitmaps.
  	return AknLayoutScalable_Avkon::volume_small_pane_g9().LayoutLine();
	}
	
// C={243, 0} H=22 W=10 b= l=108 r= t=6 
// Remark                    : 10. volume strength indicator.
// Parent                    : volume_navi_pane
// Parent API                : volume_navi_pane
// Scale API match    ( 37%) : navi_navi_volume_pane_g1
// Scale parent match ( 85%) : navi_navi_volume_pane
TAknWindowLineLayout Volume_pane_elements__one__Line_10(TInt /*aIndex_C*/)
	{
  	// Note, needs avkon code changes so that rect drawing from code is replaced by bitmaps.
  	return AknLayoutScalable_Avkon::volume_small_pane_g10().LayoutLine();
	}

/*
TAknLayoutTableLimits Volume_pane_elements__one__Limits();

TAknWindowLineLayout Volume_pane_elements__one_(TInt aLineIndex, TInt aIndex_C);
*/

// LAF Table : Main pane descendants
// C= H={288, 226} W=352 b= l=0 r= t=0 
// Remark                    : General list pane.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : list_gen_pane
// Scale parent match (100%) : main_pane
TAknWindowLineLayout list_gen_pane(TInt aIndex_H)
    {
	/* Note, list_gen_pane is implemented in strange way because changing this to do
	   the correct thing would require large amount of changes to all applications
	   using list_gen_pane; thus we make it look like how it was in 2.0 -- i.e.
	   the size of the list_gen_pane will be the same as main_pane and we'll adjust
	   the list panes accordingly so that the position of the list items are correct. 
	   So, this method returns numbers you cannot find from any specification directly.
	 */

    /*
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_gen_pane(aIndex_H);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::listscroll_gen_pane(0);
	TAknWindowComponentLayout delta = TAknWindowComponentLayout::SiblingAsChild(l2, l1);
    return delta.LayoutLine();
    */
    
	// MAN: Fixed 25.4.2005
    // This works better ok but is ugly and hackish solution but there does not seem to
    // exist better one for now...
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_gen_pane(aIndex_H);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::listscroll_gen_pane(0);
	TAknWindowComponentLayout delta = TAknWindowComponentLayout::SiblingAsChild(l2, l1);
    TAknWindowLineLayout line = delta.LayoutLine();
    if (aIndex_H == 1)
        {
        line.ib = l1.LayoutLine().ib; // Force b value to the top of findpane as SibllingAsChild calculates wrong value to it
        }

    return line;  
    }
  
// C= H=62 W=352 b=0 l= r=0 t= 
// Remark                    : Find box indication.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : find_pane
// Scale parent match (100%) : main_pane
TAknWindowLineLayout find_pane()
   	{
   	return AknLayoutScalable_Avkon::find_pane().LayoutLine();
	}

// C= H=286 W=348 b= l=2 r= t=2 
// Remark                    : Wallpaper image.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : wallpaper_pane
// Scale parent match (100%) : main_pane
TAknWindowLineLayout wallpaper_pane()
    {
	// there are other landscape options available, but not enough semantics in this API to decide which to use
	// therefore assume it's the portrait version
	TInt varietyIndex = 0; // no clock
   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::main_idle_trad_pane();
   	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::wallpaper_pane(varietyIndex); 
   	return DoCompose(l2, l3).LayoutLine();
    }
    
// C= H=24 W=226 b= l=126 r= t=0 
// Remark                    : Status icon indicators.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : indicator_pane
// Scale parent match (100%) : main_pane
TAknWindowLineLayout indicator_pane()
    {
	// there are other landscape options available, but not enough semantics in this API to decide which to use
	// therefore assume it's the portrait version
	TInt varietyIndex = 0; // no clock
   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::main_idle_trad_pane();
   	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::indicator_pane(varietyIndex);
   	return DoCompose(l2, l3).LayoutLine();
    }

// C= H={34, 62, 90, 118, 146, 174, 202} W=286 b= l=66 r= t=24 
// Remark                    : Pane for textual soft indicators. Seven lines of text.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : soft_indicator_pane
// Scale parent match (100%) : main_pane
TAknWindowLineLayout soft_indicator_pane(TInt /*aIndex_H*/)
    {
    // Looks like the height of the soft indicator pane is always the same, so ignore aIndex_H
	// there are other landscape options available, but not enough semantics in this API to decide which to use
	// therefore assume it's the portrait version
	TInt varietyIndex = 0; // no clock
   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::main_idle_trad_pane();
   	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::soft_indicator_pane(varietyIndex);
   	return DoCompose(l2, l3).LayoutLine();
    }

// LAF Table : List pane column division
// C= H=288 W=40 b= l=0 r= t=0 
// Remark                    : Used generally to display small sized graphics or heading texts.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 33%) : popup_large_graphic_colour_window
// Scale parent match (100%) : main_pane
TAknWindowLineLayout A_column()
    {
    return AknLayoutScalable_Avkon::bg_list_pane_g1(1).LayoutLine();
    }
    
// C= H=288 W=62 b= l=40 r= t=0 
// Remark                    : Used generally to display large sized icons or heading texts.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 33%) : popup_large_graphic_colour_window
// Scale parent match (100%) : main_pane
TAknWindowLineLayout B_column()
    {   
    /*
    // NOT IMPLEMENTED
    //=> NOT FOUND
    TAknWindowComponentLayout bgB = AknLayoutScalable_Avkon::bg_list_pane_g1(2);
    TAknWindowComponentLayout bgA = AknLayoutScalable_Avkon::bg_list_pane_g1(1);

    TAknWindowComponentLayout sub = bgB;
    sub.Setl( bgA.l() + bgA.W() );
    // NOTE, this assumes that bg.l() and bgB.l() are the same
    // NOTE, this also assumes that bgA.t() and bgB.t() are the same
    // NOTE, this also assumes that bgA.b() and bgB.b() are the same
    return sub;
    */
    return EmptyWindowLayout(); // NOT USED
    }

// C= H=288 W=250 b= l=102 r= t=0 
// Remark                    : Used generally to display data entered by the user. Overlaps with the D column.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 50%) : popup_large_graphic_colour_window
// Scale parent match (100%) : main_pane
TAknWindowLineLayout C_column()
    {
    // JH: IMPLEMENTED 29.12.2005. Variety 2 is the C column specified in old LAF.
    return AknLayoutScalable_Avkon::bg_list_pane_g2(2).LayoutLine();
    }
    
// C= H=288 W=60 b= l=292 r= t=0 
// Remark                    : Used generally to display additionalicons. Overlaps with the C column.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 33%) : popup_large_graphic_colour_window
// Scale parent match (100%) : main_pane
TAknWindowLineLayout D_column()
    {
    // NOT IMPLEMENTED
    // => NOT FOUND
    return EmptyWindowLayout(); // NOT USED
    }

/*
TAknLayoutTableLimits List_pane_column_division_Limits();

TAknWindowLineLayout List_pane_column_division(TInt aLineIndex);
*/

// LAF Table : General list pane descendants
// C= H=42 W=352 b= l=0 r= t={16, 58, 100, 142, 184, 226} 
// Remark                    : Plain text list item. A line in the A column.
// Parent                    : list_gen_pane
// Parent API                : list_gen_pane
// Scale API match    (100%) : list_single_pane
// Scale parent match (100%) : list_gen_pane
TAknWindowLineLayout list_single_pane(TInt aIndex_t)
    {
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_gen_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_gen_pane(0);
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_single_pane(aIndex_t);
	return DoCompose(l1, DoCompose(l2,l3)).LayoutLine();
    }

// C= H=42 W=352 b= l=0 r= t={16, 58, 100, 142, 184, 226} 
// Remark                    : A list item with an ordinal number in the A column. A line between the A and B columns.
// Parent                    : list_gen_pane
// Parent API                : list_gen_pane
// Scale API match    (100%) : list_single_number_pane
// Scale parent match (100%) : list_gen_pane
TAknWindowLineLayout list_single_number_pane(TInt aIndex_t)
    {
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_gen_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_gen_pane(0);
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_single_number_pane(aIndex_t);
	return DoCompose(l1, DoCompose(l2,l3)).LayoutLine();
    }

// C= H=42 W=352 b= l=0 r= t={16, 58, 100, 142, 184, 226} 
// Remark                    : A list item with a heading in the AB column. A line between the B and C columns.
// Parent                    : list_gen_pane
// Parent API                : list_gen_pane
// Scale API match    (100%) : list_single_heading_pane
// Scale parent match (100%) : list_gen_pane
TAknWindowLineLayout list_single_heading_pane(TInt aIndex_t)
    {
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_gen_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_gen_pane(0);
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_single_heading_pane(aIndex_t);
	return DoCompose(l1, DoCompose(l2,l3)).LayoutLine();
    }

// C= H=42 W=352 b= l=0 r= t={16, 58, 100, 142, 184, 226} 
// Remark                    : A list item with a small graphic in the A column. A line between the A and B columns.
// Parent                    : list_gen_pane
// Parent API                : list_gen_pane
// Scale API match    (100%) : list_single_graphic_pane
// Scale parent match (100%) : list_gen_pane
TAknWindowLineLayout list_single_graphic_pane(TInt aIndex_t)
    {
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_gen_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_gen_pane(0);
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_single_graphic_pane(aIndex_t);
	return DoCompose(l1,DoCompose(l2,l3)).LayoutLine();
    }

// C= H=42 W=352 b= l=0 r= t={16, 58, 100, 142, 184, 226} 
// Remark                    : A list item with a small graphic in the A column. A heading in the B column. A line between the B and C columns.
// Parent                    : list_gen_pane
// Parent API                : list_gen_pane
// Scale API match    (100%) : list_single_graphic_heading_pane
// Scale parent match (100%) : list_gen_pane
TAknWindowLineLayout list_single_graphic_heading_pane(TInt aIndex_t)
    {
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_gen_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_gen_pane(0);
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_single_graphic_heading_pane(aIndex_t);
	return DoCompose(l1, DoCompose(l2,l3)).LayoutLine();
    }

// C= H=42 W=352 b= l=0 r= t={16, 58, 100, 142, 184, 226} 
// Remark                    : A list item with an ordinal number in the A column. A heading in the B column. A line between the B and C columns.
// Parent                    : list_gen_pane
// Parent API                : list_gen_pane
// Scale API match    (100%) : list_single_number_heading_pane
// Scale parent match (100%) : list_gen_pane
TAknWindowLineLayout list_single_number_heading_pane(TInt aIndex_t)
    {
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_gen_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_gen_pane(0);
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_single_number_heading_pane(aIndex_t);
	return DoCompose(l1, DoCompose(l2,l3)).LayoutLine();
    }

// C= H=66 W=352 b= l=0 r= t={10, 76, 142, 208} 
// Remark                    : A list item with a large graphic in the AB column. A line between the B and C columns.
// Parent                    : list_gen_pane
// Parent API                : list_gen_pane
// Scale API match    (100%) : list_single_large_graphic_pane
// Scale parent match (100%) : list_gen_pane
TAknWindowLineLayout list_single_large_graphic_pane(TInt aIndex_t)
    {
    TInt variety = 0;
    if ( aIndex_t >= 0x1000 )
        {
        aIndex_t -= 0x1000;
        variety = 1;
        }
	TInt lastRow = AknLayoutScalable_Avkon::list_single_large_graphic_pane_ParamLimits().LastRow();
	__ASSERT_ALWAYS(0 <= aIndex_t && aIndex_t <= lastRow , Panic(EParamsOutsideKnownRange));

	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_gen_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_gen_pane(0);
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_single_large_graphic_pane(variety, aIndex_t);
	return DoCompose(l1, DoCompose(l2,l3)).LayoutLine();
    }

// C= H=88 W=352 b= l=0 r= t={12, 100, 188} 
// Remark                    : A double text item. A line in the A column.
// Parent                    : list_gen_pane
// Parent API                : list_gen_pane
// Scale API match    (100%) : list_double_pane
// Scale parent match (100%) : list_gen_pane
TAknWindowLineLayout list_double_pane(TInt aIndex_t)
    {
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_gen_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_gen_pane(0);
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_double_pane(aIndex_t);
	return DoCompose(l1, DoCompose(l2,l3)).LayoutLine();
    }

// C= H=88 W=352 b= l=0 r= t={12, 100, 188} 
// Remark                    : A double text item. A line in the A column. Both lines of text in the same font.
// Parent                    : list_gen_pane
// Parent API                : list_gen_pane
// Scale API match    (100%) : list_double2_pane
// Scale parent match (100%) : list_gen_pane
TAknWindowLineLayout list_double2_pane(TInt aIndex_t)
    {
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_gen_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_gen_pane(0);
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_double2_pane(aIndex_t);
	return DoCompose(l1, DoCompose(l2,l3)).LayoutLine();
    }

// C= H=88 W=352 b= l=0 r= t={12, 100, 188} 
// Remark                    : A list item with an ordinal number in the A column. A line between the A and B columns.
// Parent                    : list_gen_pane
// Parent API                : list_gen_pane
// Scale API match    ( 75%) : list_single_number_pane_g_Limits
// Scale parent match (100%) : list_gen_pane
TAknWindowLineLayout list_double_number_pane_list_single_big_number_pane(TInt aIndex_t)
    {
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_gen_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_gen_pane(0);
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_double_number_pane(aIndex_t);
	return DoCompose(l1, DoCompose(l2,l3)).LayoutLine();
    }

// C= H=88 W=352 b= l=0 r= t={12, 100, 188} 
// Remark                    : A list item with numbers in the AB column. A line between the B and C columns.
// Parent                    : list_gen_pane
// Parent API                : list_gen_pane
// Scale API match    (100%) : list_double_time_pane
// Scale parent match (100%) : list_gen_pane
TAknWindowLineLayout list_double_time_pane(TInt aIndex_t)
    {
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_gen_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_gen_pane(0);
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_double_time_pane(aIndex_t);
	return DoCompose(l1, DoCompose(l2,l3)).LayoutLine();
    }

// C= H=88 W=352 b= l=0 r= t={12, 100, 188} 
// Remark                    : A list item with a large graphic in the AB column. A line between the B and C columns.
// Parent                    : list_gen_pane
// Parent API                : list_gen_pane
// Scale API match    ( 86%) : list_double_large_graphic_pane_g_Limits
// Scale parent match (100%) : list_gen_pane
TAknWindowLineLayout list_double_large_graphic_pane_list_double2_large_graphic_pane_list_single_big_large_graphic_pane(TInt aIndex_t)
    {
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_gen_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_gen_pane(0);
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_double_large_graphic_pane(aIndex_t);
	return DoCompose(l1, DoCompose(l2,l3)).LayoutLine();
    }

// C= H=88 W=352 b= l=0 r= t={12, 100, 188} 
// Remark                    : A list item with a graphic in the A column. A line between the A and B columns.
// Parent                    : list_gen_pane
// Parent API                : list_gen_pane
// Scale API match    ( 95%) : list_double2_graphic_pane_g_Limits
// Scale parent match (100%) : list_gen_pane
TAknWindowLineLayout list_double_graphic_pane_list_double2_graphic_pane(TInt aIndex_t)
    {
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_gen_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_gen_pane(0);
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_double_graphic_pane(aIndex_t);
	return DoCompose(l1, DoCompose(l2,l3)).LayoutLine();
    }

// C= H=88 W=352 b= l=0 r= t={12, 100, 190} 
// Remark                    : A list item with a graphic in the A column. A line between the A and B columns. First line heading second line item.
// Parent                    : list_gen_pane
// Parent API                : list_gen_pane
// Scale API match    ( 79%) : list_single_graphic_heading_pane_ParamLimits
// Scale parent match (100%) : list_gen_pane
TAknWindowLineLayout list_single_big_heading_graphic_pane(TInt aIndex_t)
    {
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_gen_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_gen_pane(0);
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_double_graphic_pane(aIndex_t);
	return DoCompose(l1, DoCompose(l2,l3)).LayoutLine();
    }

// C= H=88 W=352 b= l=0 r= t={12, 100, 190} 
// Remark                    : A list item. A line between the A and B columns. First line heading second line item.
// Parent                    : list_gen_pane
// Parent API                : list_gen_pane
// Scale API match    ( 80%) : list_single_graphic_heading_pane_ParamLimits
// Scale parent match (100%) : list_gen_pane
TAknWindowLineLayout list_single_big_heading_pane(TInt aIndex_t)
    {
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_gen_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_gen_pane(0);
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_double_heading_pane(aIndex_t);
	return DoCompose(l1, DoCompose(l2,l3)).LayoutLine();
    }

// C= H=90 W=352 b= l=0 r= t={6, 100, 190} 
// Remark                    : A setting item. A line in the A column.
// Parent                    : list_gen_pane
// Parent API                : list_gen_pane
// Scale API match    ( 83%) : list_setting_pane_g_Limits
// Scale parent match (100%) : list_gen_pane
TAknWindowLineLayout list_setting_pane_list_big_setting_pane(TInt aIndex_t)
    {
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_gen_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_gen_pane(0);
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_setting_pane(aIndex_t);
	return DoCompose(l1, DoCompose(l2,l3)).LayoutLine();
    }

// C= H=90 W=352 b= l=0 r= t={6, 100, 190} 
// Remark                    : A list item with an ordinal number in the A column. A line between the A and B columns.
// Parent                    : list_gen_pane
// Parent API                : list_gen_pane
// Scale API match    ( 88%) : list_setting_number_pane_g_Limits
// Scale parent match (100%) : list_gen_pane
TAknWindowLineLayout list_setting_number_pane_list_big_setting_number_pane(TInt aIndex_t)
    {
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_gen_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_gen_pane(0);
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_setting_number_pane(aIndex_t);
	return DoCompose(l1, DoCompose(l2,l3)).LayoutLine();
    }

// C= H=90 W=352 b= l=0 r= t={6, 100, 190} 
// Remark                    : A setting item. A line between the A and B columns.
// Parent                    : list_gen_pane
// Parent API                : list_gen_pane
// Scale API match    ( 65%) : list_setting_pane_g2_ParamLimits
// Scale parent match (100%) : list_gen_pane
TAknWindowLineLayout list_setting_double2_pane(TInt aIndex_t)
{
    return list_double2_pane(aIndex_t);
}

// C= H=88 W=352 b= l=0 r= t={12, 100, 188} 
// Remark                    : List item with graphic on A column a line between A and B columns.
// Parent                    : list_gen_pane
// Parent API                : list_gen_pane
// Scale API match    (100%) : list_double2_graphic_pane
// Scale parent match (100%) : list_gen_pane
TAknWindowLineLayout list_double2_graphic_pane(TInt aIndex_t)
    {
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_gen_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_gen_pane(0);
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_double2_graphic_pane(aIndex_t);
	return DoCompose(l1, DoCompose(l2,l3)).LayoutLine();
    }

// C= H=88 W=352 b= l=0 r= t={12, 100, 188} 
// Remark                    : List item with large graphic on AB column a line between AB and C columns.
// Parent                    : list_gen_pane
// Parent API                : list_gen_pane
// Scale API match    (100%) : list_double2_large_graphic_pane
// Scale parent match (100%) : list_gen_pane
TAknWindowLineLayout list_double2_large_graphic_pane(TInt aIndex_t)
    {
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_gen_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_gen_pane(0);
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_double2_large_graphic_pane(aIndex_t);
	return DoCompose(l1, DoCompose(l2,l3)).LayoutLine();
    }

// C= H=42 W=352 b= l=0 r= t={16, 58, 100, 142, 184, 226} 
// Remark                    : List item with graphic on A and B columns a line between AB and C columns.
// Parent                    : list_gen_pane
// Parent API                : list_gen_pane
// Scale API match    (100%) : list_single_2graphic_pane
// Scale parent match (100%) : list_gen_pane
TAknWindowLineLayout list_single_2graphic_pane(TInt aIndex_t)
    {
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_gen_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_gen_pane(0);
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_single_2graphic_pane(aIndex_t);
	return DoCompose(l1, DoCompose(l2,l3)).LayoutLine();
    }

// C= H=88 W=352 b= l=0 r= t={12, 100, 188} 
// Remark                    : List item with graphic on A column and large graphic BC column a line between AB and C columns.
// Parent                    : list_gen_pane
// Parent API                : list_gen_pane
// Scale API match    (100%) : list_double2_graphic_large_graphic_pane
// Scale parent match (100%) : list_gen_pane
TAknWindowLineLayout list_double2_graphic_large_graphic_pane(TInt aIndex_t)
    {
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_gen_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_gen_pane(0);
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_double2_graphic_large_graphic_pane(aIndex_t);
	return DoCompose(l1, DoCompose(l2,l3)).LayoutLine();
    }

/*
TAknLayoutTableLimits General_list_pane_descendants_Limits();

TAknWindowLineLayout General_list_pane_descendants(TInt aLineIndex, TInt aIndex_t);
*/

TAknWindowLineLayout ListLine(TAknWindowComponentLayout aListPane, TAknWindowComponentLayout aLine)
	{
   	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_gen_pane(0);
   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_gen_pane(0);
   	TAknWindowComponentLayout l3 = aListPane;
   	TAknWindowComponentLayout combined = DoCompose(DoCompose(l1, l2), l3);

   	TAknWindowComponentLayout bg1 = AknLayoutScalable_Avkon::bg_list_pane(0);
   	TAknWindowComponentLayout bg2 = aLine;
   	TAknWindowComponentLayout bg_combined = DoCompose(bg1,bg2);

   	TAknWindowComponentLayout intersect = DoIntersect(bg_combined, combined);

   	return DoMinus(intersect,combined).LayoutLine();
    }

// LAF Table : List pane elements (single)
// C=215 H=42 W=2 b= l=12 r= t=0 
// Remark                    : A vertical line in the A column.
// Parent                    : list_single_pane
// Parent API                : list_single_pane
// Scale API match    ( 46%) : list_single_pane_g_Limits
// Scale parent match (100%) : list_single_pane
TAknWindowLineLayout List_pane_elements__single__Line_1()
	{
   	return ListLine(AknLayoutScalable_Avkon::list_single_pane(0), 
                   AknLayoutScalable_Avkon::bg_list_pane_g4(0));
	/*
   	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_gen_pane(0);
   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::list_gen_pane(0);
   	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_single_pane(0);
   	TAknWindowComponentLayout combined = DoCompose(DoCompose(l1, l2), l3);

   	TAknWindowComponentLayout bg1 = AknLayoutScalable_Avkon::bg_list_pane(0);
   	TAknWindowComponentLayout bg2 = AknLayoutScalable_Avkon::bg_list_pane_g4(0);
   	TAknWindowComponentLayout bg_combined = DoCompose(bg1,bg2);

   	TAknWindowComponentLayout intersect = DoIntersect(bg_combined, combined);

   	return DoMinus(intersect,combined).LayoutLine();
	*/
	//=> let b = list_scroll_gen_pane + list_gen_pane + list_single_pane
  	// let a = DoIntersect(bg_list_pane + bg_list_pane_g4, b)
  	// return a - b;
  	}
  	
// C= H=26 W=26 b= l={318, 292} r= t=8 
// Remark                    : Additional icons.
// Parent                    : list_single_pane
// Parent API                : list_single_pane
// Scale API match    ( 50%) : list_single_2graphic_pane_g_Limits
// Scale parent match (100%) : list_single_pane
TAknWindowLineLayout List_pane_elements__single__Line_2(TInt aIndex_l)
	{
   	if (aIndex_l == 0)
    	{
       	return AknLayoutScalable_Avkon::list_single_pane_g1(1).LayoutLine(); // 1 = old spec always has 2 items
       	}
	else
    	{
       	return AknLayoutScalable_Avkon::list_single_pane_g2(0).LayoutLine();        
        }
	}

// LAF Table : List pane texts (single)
// B=30 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={316, 284, 258} l=26 r={10, 42, 68} 
// Remark                    : Item text.
// Parent                    : list_single_pane
// Parent API                : list_single_pane
// Scale API match    ( 55%) : list_single_number_pane_t_Limits
// Scale parent match (100%) : list_single_pane
TAknTextLineLayout List_pane_texts__single__Line_1(TInt aIndex_r, TInt /*aIndex_W*/)
    {
    // NOTE, aIndex_W should probably always be the same as aIndex_r
    return AknLayoutScalable_Avkon::list_single_pane_t1(aIndex_r).LayoutLine();
    }

// LAF Table : List pane elements (single number)
// C=215 H=42 W=2 b= l=38 r= t=0 
// Remark                    : A vertical line between the A and B columns.
// Parent                    : list_single_number_pane
// Parent API                : list_single_number_pane
// Scale API match    ( 56%) : list_single_number_pane_g_Limits
// Scale parent match (100%) : list_single_number_pane
TAknWindowLineLayout List_pane_elements__single_number__Line_1()
	{
   	return ListLine(AknLayoutScalable_Avkon::list_single_number_pane(0), 
                   AknLayoutScalable_Avkon::bg_list_pane_g4(1));
	//  => let b = list_scroll_gen_pane + list_gen_pane + list_single_number_pane
	//   let a = DoIntersect(bg_list_pane + bg_list_pane_g4, b)
	//   return a - b;
	}

// C= H=26 W=26 b= l={318, 292} r= t=8 
// Remark                    : Additional icons.
// Parent                    : list_single_number_pane
// Parent API                : list_single_number_pane
// Scale API match    ( 56%) : list_single_number_pane_g_Limits
// Scale parent match (100%) : list_single_number_pane
TAknWindowLineLayout List_pane_elements__single_number__Line_2(TInt aIndex_l)
	{
	__ASSERT_ALWAYS(0 <= aIndex_l && aIndex_l <= 1, Panic(EParamsOutsideKnownRange));
    TAknWindowLineLayout layout;
    switch(aIndex_l)
        {
        case 0:
            layout = AknLayoutScalable_Avkon::list_single_number_pane_g1(1).LayoutLine();
            break;
        case 1:
            layout = AknLayoutScalable_Avkon::list_single_number_pane_g2(0).LayoutLine();
            break;
        }
    return layout;     
  	}

// LAF Table : List pane texts (single number)
// B=30 C=215 Font=ELatinBold12_Scaled J=ELayoutAlignCenter W=32 l=4 r=316 
// Remark                    : Ordinal numbers.
// Parent                    : list_single_number_pane
// Parent API                : list_single_number_pane
// Scale API match    ( 63%) : list_single_number_pane_t_Limits
// Scale parent match (100%) : list_single_number_pane
TAknTextLineLayout List_pane_texts__single_number__Line_1()
	{
	//=> list_single_number_pane_t2 + attrs
	return AknLayoutScalable_Avkon::list_single_number_pane_t2(0).LayoutLine();
	}

// B=30 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={290, 258, 232} l=52 r={10, 42, 68} 
// Remark                    : Item text.
// Parent                    : list_single_number_pane
// Parent API                : list_single_number_pane
// Scale API match    ( 63%) : list_single_number_pane_t_Limits
// Scale parent match (100%) : list_single_number_pane
TAknTextLineLayout List_pane_texts__single_number__Line_2(TInt aIndex_r, TInt /*aIndex_W*/)
    {
    //=> list_single_number_pane_t1 + attrs
    return AknLayoutScalable_Avkon::list_single_number_pane_t1(aIndex_r).LayoutLine();
    }

// LAF Table : List pane elements (single heading)
// C=215 H=42 W=2 b= l=100 r= t=0 
// Remark                    : A vertical line between the B and C columns.
// Parent                    : list_single_heading_pane
// Parent API                : list_single_heading_pane
// Scale API match    ( 57%) : list_single_heading_pane_g_Limits
// Scale parent match (100%) : list_single_heading_pane
TAknWindowLineLayout List_pane_elements__single_heading__Line_1()
	{
   	//  => list_line(list_single_heading_pane)
   	return ListLine(AknLayoutScalable_Avkon::list_single_heading_pane(0), 
                   AknLayoutScalable_Avkon::bg_list_pane_g4(2));
	}

//// C=215 H=2 W=98 b= l=2 r= t=2 
// Remark                    : A horizontal line to separate list items e.g. the current days items.
// Parent                    : list_single_heading_pane
// Parent API                : list_single_heading_pane
// Scale API match    ( 57%) : list_single_heading_pane_g_Limits
// Scale parent match (100%) : list_single_heading_pane
TAknWindowLineLayout List_pane_elements__single_heading__Line_2()
    {
    // NOT IMPLEMENTED
    //=> NOT THERE...
    return EmptyWindowLayout();
    }

// C= H=26 W=26 b= l={318, 292} r= t=8 
// Remark                    : Additional icons.
// Parent                    : list_single_heading_pane
// Parent API                : list_single_heading_pane
// Scale API match    ( 57%) : list_single_heading_pane_g_Limits
// Scale parent match (100%) : list_single_heading_pane
TAknWindowLineLayout List_pane_elements__single_heading__Line_3(TInt aIndex_l)
	{
	__ASSERT_ALWAYS(0 <= aIndex_l && aIndex_l <= 1, Panic(EParamsOutsideKnownRange));
    TAknWindowLineLayout layout;
    switch(aIndex_l)
        {
        case 0:
            layout = AknLayoutScalable_Avkon::list_single_heading_pane_g1(1).LayoutLine();
            break;
        case 1:
            layout = AknLayoutScalable_Avkon::list_single_heading_pane_g2(0).LayoutLine();
            break;
        }
    return layout;     
  	}
  	
/*
TAknLayoutTableLimits List_pane_elements__single_heading__SUB_TABLE_0_Limits();

TAknWindowLineLayout List_pane_elements__single_heading__SUB_TABLE_0(TInt aLineIndex);
*/

// LAF Table : List pane texts (single heading)
// B=30 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignRight W={88, 92}[aCommon1] l=8 r={256, 252}[aCommon1] 
// Remark                    : Heading text.
// Parent                    : list_single_heading_pane
// Parent API                : list_single_heading_pane
// Scale API match    ( 64%) : list_single_heading_pane_t_Limits
// Scale parent match (100%) : list_single_heading_pane
TAknTextLineLayout List_pane_texts__single_heading__Line_1(TInt aCommon1)
    {
    return AknLayoutScalable_Avkon::list_single_heading_pane_t2(aCommon1).LayoutLine();
    }

// B=30 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={228, 196, 170}[aCommon1] l=114 r={10, 42, 68}[aCommon1] 
// Remark                    : Item text.
// Parent                    : list_single_heading_pane
// Parent API                : list_single_heading_pane
// Scale API match    ( 64%) : list_single_heading_pane_t_Limits
// Scale parent match (100%) : list_single_heading_pane
TAknTextLineLayout List_pane_texts__single_heading__Line_2(TInt aCommon1)
    {
    return AknLayoutScalable_Avkon::list_single_heading_pane_t1(aCommon1).LayoutLine();
    }

/*
TAknLayoutTableLimits List_pane_texts__single_heading__Limits();

TAknTextLineLayout List_pane_texts__single_heading_(TInt aLineIndex, TInt aCommon1);

*/

// LAF Table : List pane elements (single graphic)
// C= H=26 W=26 b= l=6 r= t=8 
// Remark                    : E.g. number type icons message type icons and inout icons.
// Parent                    : list_single_graphic_pane
// Parent API                : list_single_graphic_pane
// Scale API match    ( 57%) : list_single_graphic_pane_g_Limits
// Scale parent match (100%) : list_single_graphic_pane
TAknWindowLineLayout List_pane_elements__single_graphic__Line_1()
    {
    return AknLayoutScalable_Avkon::list_single_graphic_pane_g1(0).LayoutLine();
    }

// C=215 H=42 W=2 b= l=38 r= t=0 
// Remark                    : A vertical line between the A and B columns.
// Parent                    : list_single_graphic_pane
// Parent API                : list_single_graphic_pane
// Scale API match    ( 57%) : list_single_graphic_pane_g_Limits
// Scale parent match (100%) : list_single_graphic_pane
TAknWindowLineLayout List_pane_elements__single_graphic__Line_2()
	{
   	return ListLine(AknLayoutScalable_Avkon::list_single_graphic_pane(0), 
                   AknLayoutScalable_Avkon::bg_list_pane_g4(1));
	}

// C= H=26 W=26 b= l={318, 292} r= t=8 
// Remark                    : Additional icons.
// Parent                    : list_single_graphic_pane
// Parent API                : list_single_graphic_pane
// Scale API match    ( 57%) : list_single_graphic_pane_g_Limits
// Scale parent match (100%) : list_single_graphic_pane
TAknWindowLineLayout List_pane_elements__single_graphic__Line_3(TInt aIndex_l)
	{
	__ASSERT_ALWAYS(0 <= aIndex_l && aIndex_l <= 1, Panic(EParamsOutsideKnownRange));
    TAknWindowLineLayout layout;
    switch(aIndex_l)
        {
        case 0:
            layout = AknLayoutScalable_Avkon::list_single_graphic_pane_g2(1).LayoutLine();
            break;
        case 1:
            layout = AknLayoutScalable_Avkon::list_single_graphic_pane_g3(0).LayoutLine();
            break;
        }
    return layout;     
  	}

/*
TAknLayoutTableLimits List_pane_elements__single_graphic__SUB_TABLE_0_Limits();

TAknWindowLineLayout List_pane_elements__single_graphic__SUB_TABLE_0(TInt aLineIndex);
*/

// LAF Table : List pane texts (single graphic)
// B=30 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={290, 258, 232} l=52 r={10, 42, 68} 
// Remark                    : Item text.
// Parent                    : list_single_graphic_pane
// Parent API                : list_single_graphic_pane
// Scale API match    ( 64%) : list_single_graphic_heading_pane_t_Limits
// Scale parent match (100%) : list_single_graphic_pane
TAknTextLineLayout List_pane_texts__single_graphic__Line_1(TInt aIndex_r, TInt /*aIndex_W*/)
    {
    return AknLayoutScalable_Avkon::list_single_graphic_pane_t1(aIndex_r).LayoutLine();
    }

// LAF Table : List pane elements (single graphic heading)
// C= H=26 W=26 b= l=6 r= t=8 
// Remark                    : E.g. number type icons message type icons and inout icons.
// Parent                    : list_single_graphic_heading_pane
// Parent API                : list_single_graphic_heading_pane
// Scale API match    ( 64%) : list_single_graphic_heading_pane_g_Limits
// Scale parent match (100%) : list_single_graphic_heading_pane
TAknWindowLineLayout List_pane_elements__single_graphic_heading__Line_1()
    {
    return AknLayoutScalable_Avkon::list_single_graphic_heading_pane_g1(0).LayoutLine();
    }

// C=215 H=42 W=2 b= l=100 r= t=0 
// Remark                    : A vertical line between the A and B columns.
// Parent                    : list_single_graphic_heading_pane
// Parent API                : list_single_graphic_heading_pane
// Scale API match    ( 64%) : list_single_graphic_heading_pane_g_Limits
// Scale parent match (100%) : list_single_graphic_heading_pane
TAknWindowLineLayout List_pane_elements__single_graphic_heading__Line_2()
	{
   	return ListLine(AknLayoutScalable_Avkon::list_single_graphic_heading_pane(0), 
                   AknLayoutScalable_Avkon::bg_list_pane_g4(2));
	}

// C=215 H=2 W=98 b= l=2 r= t=2 
// Remark                    : A horizontal line to separate list items e.g. the current days items.
// Parent                    : list_single_graphic_heading_pane
// Parent API                : list_single_graphic_heading_pane
// Scale API match    ( 64%) : list_single_graphic_heading_pane_g_Limits
// Scale parent match (100%) : list_single_graphic_heading_pane
TAknWindowLineLayout List_pane_elements__single_graphic_heading__Line_3()
	{
	return EmptyWindowLayout(); // NOT USED
	// => NOT THERE
	}

// C= H=26 W=26 b= l={318, 292} r= t=8 
// Remark                    : Additional icons.
// Parent                    : list_single_graphic_heading_pane
// Parent API                : list_single_graphic_heading_pane
// Scale API match    ( 64%) : list_single_graphic_heading_pane_g_Limits
// Scale parent match (100%) : list_single_graphic_heading_pane
TAknWindowLineLayout List_pane_elements__single_graphic_heading__Line_4(TInt aIndex_l)
	{
	__ASSERT_ALWAYS(0 <= aIndex_l && aIndex_l <= 1, Panic(EParamsOutsideKnownRange));
    TAknWindowLineLayout layout;
    switch(aIndex_l)
        {
        case 0:
            layout = AknLayoutScalable_Avkon::list_single_graphic_heading_pane_g4(1).LayoutLine();
            break;
        case 1:
            layout = AknLayoutScalable_Avkon::list_single_graphic_heading_pane_g5(0).LayoutLine();
            break;
        }
    return layout;     
  	}

/*
TAknLayoutTableLimits List_pane_elements__single_graphic_heading__SUB_TABLE_0_Limits();

TAknWindowLineLayout List_pane_elements__single_graphic_heading__SUB_TABLE_0(TInt aLineIndex);
*/

// LAF Table : List pane texts (single graphic heading)
// B=30 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W={60, 64}[aCommon1] l=36 r={256, 252}[aCommon1] 
// Remark                    : Heading.
// Parent                    : list_single_graphic_heading_pane
// Parent API                : list_single_graphic_heading_pane
// Scale API match    ( 71%) : list_single_graphic_heading_pane_t_Limits
// Scale parent match (100%) : list_single_graphic_heading_pane
TAknTextLineLayout List_pane_texts__single_graphic_heading__Line_1(TInt aCommon1)
    {
    return AknLayoutScalable_Avkon::list_single_graphic_heading_pane_t2(aCommon1).LayoutLine();
    }

// B=30 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={228, 196, 170}[aCommon1] l=114 r={10, 42, 68}[aCommon1] 
// Remark                    : Item text.
// Parent                    : list_single_graphic_heading_pane
// Parent API                : list_single_graphic_heading_pane
// Scale API match    ( 71%) : list_single_graphic_heading_pane_t_Limits
// Scale parent match (100%) : list_single_graphic_heading_pane
TAknTextLineLayout List_pane_texts__single_graphic_heading__Line_2(TInt aCommon1)
    {
    return AknLayoutScalable_Avkon::list_single_graphic_heading_pane_t1(aCommon1).LayoutLine();
    }

/*
TAknLayoutTableLimits List_pane_texts__single_graphic_heading__Limits();

TAknTextLineLayout List_pane_texts__single_graphic_heading_(TInt aLineIndex, TInt aCommon1);
*/

// LAF Table : List pane elements (single number heading)
// C=215 H=42 W=2 b= l=100 r= t=0 
// Remark                    : A vertical line between the A and B columns.
// Parent                    : list_single_number_heading_pane
// Parent API                : list_single_number_heading_pane
// Scale API match    ( 63%) : list_single_number_heading_pane_g_Limits
// Scale parent match (100%) : list_single_number_heading_pane
TAknWindowLineLayout List_pane_elements__single_number_heading__Line_1()
	{
   	return ListLine(AknLayoutScalable_Avkon::list_single_number_heading_pane(0), 
                   AknLayoutScalable_Avkon::bg_list_pane_g4(2));
	}

// C=215 H=2 W=98 b= l=2 r= t=2 
// Remark                    : A horizontal line to separate list items e.g. the current days items.
// Parent                    : list_single_number_heading_pane
// Parent API                : list_single_number_heading_pane
// Scale API match    ( 63%) : list_single_number_heading_pane_g_Limits
// Scale parent match (100%) : list_single_number_heading_pane
TAknWindowLineLayout List_pane_elements__single_number_heading__Line_2()
	{
	return EmptyWindowLayout(); // NOT USED
	//=> NOT THERE
	}

// C= H=26 W=26 b= l={318, 292} r= t=8 
// Remark                    : Additional icons.
// Parent                    : list_single_number_heading_pane
// Parent API                : list_single_number_heading_pane
// Scale API match    ( 63%) : list_single_number_heading_pane_g_Limits
// Scale parent match (100%) : list_single_number_heading_pane
TAknWindowLineLayout List_pane_elements__single_number_heading__Line_3(TInt aIndex_l)
	{
	__ASSERT_ALWAYS(0 <= aIndex_l && aIndex_l <= 1, Panic(EParamsOutsideKnownRange));
    TAknWindowLineLayout layout;
    switch(aIndex_l)
        {
        case 0:
            layout = AknLayoutScalable_Avkon::list_single_number_heading_pane_g1(1).LayoutLine();
            break;
        case 1:
            layout = AknLayoutScalable_Avkon::list_single_number_heading_pane_g2(0).LayoutLine();
            break;
        }
    return layout;     
  	}

/*
TAknLayoutTableLimits List_pane_elements__single_number_heading__SUB_TABLE_0_Limits();

TAknWindowLineLayout List_pane_elements__single_number_heading__SUB_TABLE_0(TInt aLineIndex);
*/

// LAF Table : List pane texts (single number heading)
// B=30 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignRight W={32, 28}[aCommon1] l=4 r={316, 320}[aCommon1] 
// Remark                    : Ordinal number. Two numbers and a full stop.
// Parent                    : list_single_number_heading_pane
// Parent API                : list_single_number_heading_pane
// Scale API match    ( 70%) : list_single_number_heading_pane_t_Limits
// Scale parent match (100%) : list_single_number_heading_pane
TAknTextLineLayout List_pane_texts__single_number_heading__Line_1(TInt aCommon1)
    {
    return AknLayoutScalable_Avkon::list_single_number_heading_pane_t3(aCommon1).LayoutLine();
    }

// B=30 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W={60, 64}[aCommon1] l=36 r={256, 252}[aCommon1] 
// Remark                    : Heading.
// Parent                    : list_single_number_heading_pane
// Parent API                : list_single_number_heading_pane
// Scale API match    ( 70%) : list_single_number_heading_pane_t_Limits
// Scale parent match (100%) : list_single_number_heading_pane
TAknTextLineLayout List_pane_texts__single_number_heading__Line_2(TInt aCommon1)
    {
    return AknLayoutScalable_Avkon::list_single_number_heading_pane_t2(aCommon1).LayoutLine();
    }

// B=30 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={228, 196, 170}[aCommon1] l=114 r={10, 42, 68}[aCommon1] 
// Remark                    : Item text.
// Parent                    : list_single_number_heading_pane
// Parent API                : list_single_number_heading_pane
// Scale API match    ( 70%) : list_single_number_heading_pane_t_Limits
// Scale parent match (100%) : list_single_number_heading_pane
TAknTextLineLayout List_pane_texts__single_number_heading__Line_3(TInt aCommon1)
    {
    return AknLayoutScalable_Avkon::list_single_number_heading_pane_t1(aCommon1).LayoutLine();
    }

/*
TAknLayoutTableLimits List_pane_texts__single_number_heading__Limits();

TAknTextLineLayout List_pane_texts__single_number_heading_(TInt aLineIndex, TInt aCommon1);
=> ?????????????
*/

// LAF Table : List pane elements (single large graphic)
// C= H=58 W=84 b= l=14 r= t=4 
// Remark                    : Applicationsubmenu list icons.
// Parent                    : list_single_large_graphic_pane
// Parent API                : list_single_large_graphic_pane
// Scale API match    ( 63%) : list_single_large_graphic_pane_g_Limits
// Scale parent match (100%) : list_single_large_graphic_pane
TAknWindowLineLayout List_pane_elements__single_large_graphic__Line_1()
    {
    return AknLayoutScalable_Avkon::list_single_large_graphic_pane_g1(0).LayoutLine();
    }

// C=215 H=66 W=2 b= l=100 r= t=0 
// Remark                    : A vertical line between the B and C columns.
// Parent                    : list_single_large_graphic_pane
// Parent API                : list_single_large_graphic_pane
// Scale API match    ( 63%) : list_single_large_graphic_pane_g_Limits
// Scale parent match (100%) : list_single_large_graphic_pane
TAknWindowLineLayout List_pane_elements__single_large_graphic__Line_2(TInt aIndex_t)
	{
	TInt line = 1; // = line 2 with zero based index
    return ListLine(AknLayoutScalable_Avkon::list_single_large_graphic_pane(aIndex_t, line), 
                    AknLayoutScalable_Avkon::bg_list_pane_g4(2));
	}

// C= H=26 W=26 b= l={318, 292} r= t=18 
// Remark                    : Additional icons.
// Parent                    : list_single_large_graphic_pane
// Parent API                : list_single_large_graphic_pane
// Scale API match    ( 63%) : list_single_large_graphic_pane_g_Limits
// Scale parent match (100%) : list_single_large_graphic_pane
TAknWindowLineLayout List_pane_elements__single_large_graphic__Line_3(TInt aIndex_l)
	{
	__ASSERT_ALWAYS(0 <= aIndex_l && aIndex_l <= 1, Panic(EParamsOutsideKnownRange));
    TAknWindowLineLayout layout;
    switch(aIndex_l)
        {
        case 0:
            layout = AknLayoutScalable_Avkon::list_single_large_graphic_pane_g2(1).LayoutLine();
            break;
        case 1:
            layout = AknLayoutScalable_Avkon::list_single_large_graphic_pane_g3(0).LayoutLine();
            break;
        }
    return layout;     
  	}


TAknWindowLineLayout do_not_use_empty_pane1()
    {
    return EmptyWindowLayout();
    }

TAknWindowLineLayout do_not_use_empty_pane2()
    {
    return EmptyWindowLayout();
    }

/*
TAknLayoutTableLimits List_pane_elements__single_large_graphic__SUB_TABLE_0_Limits();

TAknWindowLineLayout List_pane_elements__single_large_graphic__SUB_TABLE_0(TInt aLineIndex);
*/

// LAF Table : List pane texts (single large graphic)
// B=42 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={228, 196, 170}[aCommon1] l=114 r={10, 42, 68}[aCommon1] 
// Remark                    : Item text e.g. an application title.
// Parent                    : list_single_large_graphic_pane
// Parent API                : list_single_large_graphic_pane
// Scale API match    ( 67%) : list_single_large_graphic_pane_g_Limits
// Scale parent match (100%) : list_single_large_graphic_pane
TAknTextLineLayout List_pane_texts__single_large_graphic__Line_1(TInt aCommon1)
    {
    return AknLayoutScalable_Avkon::list_single_large_graphic_pane_t1(aCommon1).LayoutLine();
    }

// LAF Table : List pane elements (double)
// C=215 H=88 W=2 b= l=12 r= t=0 
// Remark                    : A vertical line in the A column.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 46%) : list_double_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__double__Line_1()
	{
   	return ListLine(AknLayoutScalable_Avkon::list_double_pane(0), 
                   AknLayoutScalable_Avkon::bg_list_pane_g4(0));
	}

// C= H=26 W=26 b= l={318, 292} r= t=14 
// Remark                    : Additional icons.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 46%) : list_double_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__double__Line_2(TInt aIndex_l)
	{
	__ASSERT_ALWAYS(0 <= aIndex_l && aIndex_l <= 1, Panic(EParamsOutsideKnownRange));
    TAknWindowLineLayout layout;
    switch(aIndex_l)
        {
        case 0:
            layout = AknLayoutScalable_Avkon::list_double_pane_g1(1).LayoutLine();
            break;
        case 1:
            layout = AknLayoutScalable_Avkon::list_double_pane_g2(0).LayoutLine();
            break;
        }
    return layout;     
  	}

// LAF Table : List pane texts (double)
// B=36 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={316, 284, 258}[aCommon1] l=26 r={10, 42, 68}[aCommon1] 
// Remark                    : Item text.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 55%) : list_double_pane_t_Limits
// Scale parent match (  0%) : 
TAknTextLineLayout List_pane_texts__double__Line_1(TInt aCommon1)
    {
    return AknLayoutScalable_Avkon::list_double_pane_t1(aCommon1).LayoutLine();
    }

// B=68 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=306 l=36 r=10 
// Remark                    : Additional item info.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 55%) : list_double_pane_t_Limits
// Scale parent match (  0%) : 
TAknTextLineLayout List_pane_texts__double__Line_2()
    {
	TInt varietyIndex = 0;
    return AknLayoutScalable_Avkon::list_double_pane_t2(varietyIndex).LayoutLine();
    }

// LAF Table : List pane text (double2)
// B=36 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={316, 284, 258}[aCommon1] l=26 r={10, 42, 68}[aCommon1] 
// Remark                    : Item text.
// Parent                    : list_double2_pane
// Parent API                : list_double2_pane
// Scale API match    ( 58%) : list_double2_pane_t_Limits
// Scale parent match (100%) : list_double2_pane
TAknTextLineLayout List_pane_text__double2__Line_1(TInt aCommon1)
    {
    return AknLayoutScalable_Avkon::list_double2_pane_t1(aCommon1).LayoutLine();
    }

// B=72 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=306 l=36 r=10 
// Remark                    : Second line of item text.
// Parent                    : list_double2_pane
// Parent API                : list_double2_pane
// Scale API match    ( 58%) : list_double2_pane_t_Limits
// Scale parent match (100%) : list_double2_pane
TAknTextLineLayout List_pane_text__double2__Line_2()
    {
	TInt varietyIndex = 0;
    return AknLayoutScalable_Avkon::list_double2_pane_t2(varietyIndex).LayoutLine();
    }

// LAF Table : List pane elements (double number)
// C=215 H=88 W=2 b= l=38 r= t=0 
// Remark                    : Vertical line between the A and B columns.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 56%) : list_double_number_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__double_number__Line_1()
	{
   	return ListLine(AknLayoutScalable_Avkon::list_double_number_pane(0), 
                   AknLayoutScalable_Avkon::bg_list_pane_g4(1));
	}

// C= H=26 W=26 b= l={318, 292} r= t=14 
// Remark                    : Additional icons.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 56%) : list_double_number_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__double_number__Line_2(TInt aIndex_l)
	{
	__ASSERT_ALWAYS(0 <= aIndex_l && aIndex_l <= 1, Panic(EParamsOutsideKnownRange));
    TAknWindowLineLayout layout;
    switch(aIndex_l)
        {
        case 0:
            layout = AknLayoutScalable_Avkon::list_double_number_pane_g1(1).LayoutLine();
            break;
        case 1:
            layout = AknLayoutScalable_Avkon::list_double_number_pane_g2(0).LayoutLine();
            break;
        }
    return layout;     
  	}

// LAF Table : List pane texts (double number)
// B=36 C=215 Font=ELatinBold12_Scaled J=ELayoutAlignCenter W=32 l=4 r=316 
// Remark                    : Ordinal numbers.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 63%) : list_double_number_pane_t_Limits
// Scale parent match (  0%) : 
TAknTextLineLayout List_pane_texts__double_number__Line_1()
    {
    return AknLayoutScalable_Avkon::list_double_number_pane_t1(0).LayoutLine();
    }

// B=36 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={290, 258, 232}[aCommon1] l=52 r={10, 42, 68}[aCommon1] 
// Remark                    : Item text.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 63%) : list_double_number_pane_t_Limits
// Scale parent match (  0%) : 
TAknTextLineLayout List_pane_texts__double_number__Line_2(TInt aCommon1)
    {
    return AknLayoutScalable_Avkon::list_double_number_pane_t2(aCommon1).LayoutLine();
    }

// B=68 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=280 l=62 r=10 
// Remark                    : Additional item info.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 63%) : list_double_number_pane_t_Limits
// Scale parent match (  0%) : 
TAknTextLineLayout List_pane_texts__double_number__Line_3()
    {
    return AknLayoutScalable_Avkon::list_double_number_pane_t3(0).LayoutLine();
    }

// LAF Table : List pane elements (double graphic)
// C=215 H=88 W=2 b= l=38 r= t=0 
// Remark                    : Vertical line between the B and C columns.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 57%) : list_double_graphic_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__double_graphic__Line_1()
	{
   	return ListLine(AknLayoutScalable_Avkon::list_double_graphic_pane(0), 
                   AknLayoutScalable_Avkon::bg_list_pane_g4(1));
	}

// C= H=26 W=26 b= l=8 r= t=14 
// Remark                    : Icon.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 57%) : list_double_graphic_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__double_graphic__Line_2()
    {
    return AknLayoutScalable_Avkon::list_double_graphic_pane_g1(0).LayoutLine();
    }

// C= H=26 W=26 b= l={318, 292} r= t=14 
// Remark                    : Additional icons.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 57%) : list_double_graphic_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__double_graphic__Line_3(TInt aIndex_l)
	{
	__ASSERT_ALWAYS(0 <= aIndex_l && aIndex_l <= 1, Panic(EParamsOutsideKnownRange));
    TAknWindowLineLayout layout;
    switch(aIndex_l)
        {
        case 0:
            layout = AknLayoutScalable_Avkon::list_double_graphic_pane_g3(0).LayoutLine();
            break;
        case 1:
            layout = AknLayoutScalable_Avkon::list_double_graphic_pane_g2(1).LayoutLine();
            break;
        }
    return layout;     
  	}

/*
TAknLayoutTableLimits List_pane_elements__double_graphic__SUB_TABLE_0_Limits();

TAknWindowLineLayout List_pane_elements__double_graphic__SUB_TABLE_0(TInt aLineIndex);
*/

// LAF Table : List pane texts (double graphic)
// B=36 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={290, 258, 232}[aCommon1] l=52 r={10, 42, 68}[aCommon1] 
// Remark                    : Item text.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 64%) : list_double_graphic_pane_t_Limits
// Scale parent match (  0%) : 
TAknTextLineLayout List_pane_texts__double_graphic__Line_1(TInt aCommon1)
    {
    return AknLayoutScalable_Avkon::list_double_graphic_pane_t1(aCommon1).LayoutLine();
    }

// B=68 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=280 l=62 r=10 
// Remark                    : Additional item info.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 64%) : list_double_graphic_pane_t_Limits
// Scale parent match (  0%) : 
TAknTextLineLayout List_pane_texts__double_graphic__Line_2()
    {
    return AknLayoutScalable_Avkon::list_double_graphic_pane_t2(0).LayoutLine();
    }

// LAF Table : List pane elements (double2 graphic)
// C= H=26 W=26 b= l=6 r= t=14 
// Remark                    : 
// Parent                    : list_double2_graphic_pane
// Parent API                : list_double2_graphic_pane
// Scale API match    ( 58%) : list_double2_graphic_pane_g_Limits
// Scale parent match (100%) : list_double2_graphic_pane
TAknWindowLineLayout List_pane_elements__double2_graphic__Line_1()
    {
    return AknLayoutScalable_Avkon::list_double2_graphic_pane_g1(0).LayoutLine();
    }

// C=215 H=88 W=2 b= l=38 r= t= 
// Remark                    : A line between the A and B columns
// Parent                    : list_double2_graphic_pane
// Parent API                : list_double2_graphic_pane
// Scale API match    ( 58%) : list_double2_graphic_pane_g_Limits
// Scale parent match (100%) : list_double2_graphic_pane
TAknWindowLineLayout List_pane_elements__double2_graphic__Line_2()
	{
	//  => list_line(list_double2_graphic_pane)
   	return ListLine(AknLayoutScalable_Avkon::list_double2_graphic_pane(0), 
                   AknLayoutScalable_Avkon::bg_list_pane_g4(1));
	}

// C= H=26 W=26 b= l={318, 292} r= t=14 
// Remark                    : Additional icons.
// Parent                    : list_double2_graphic_pane
// Parent API                : list_double2_graphic_pane
// Scale API match    ( 58%) : list_double2_graphic_pane_g_Limits
// Scale parent match (100%) : list_double2_graphic_pane
TAknWindowLineLayout List_pane_elements__double2_graphic__Line_3(TInt aIndex_l)
	{
	__ASSERT_ALWAYS(0 <= aIndex_l && aIndex_l <= 1, Panic(EParamsOutsideKnownRange));
    TAknWindowLineLayout layout;
    switch(aIndex_l)
        {
        case 0:
            layout = AknLayoutScalable_Avkon::list_double2_graphic_pane_g2(1).LayoutLine();
            break;
        case 1:
            layout = AknLayoutScalable_Avkon::list_double2_graphic_pane_g3(0).LayoutLine();
            break;
        }
    return layout;     
  	}

/*
TAknLayoutTableLimits List_pane_elements__double2_graphic__SUB_TABLE_0_Limits();

TAknWindowLineLayout List_pane_elements__double2_graphic__SUB_TABLE_0(TInt aLineIndex);
*/

// LAF Table : List pane texts (double2 graphic)
// B=34 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={290, 258, 232}[aCommon1] l=52 r={10, 42, 68}[aCommon1] 
// Remark                    : 1. line. Location layout ID list_double2_graphic_pane_1.
// Parent                    : list_double2_graphic_pane
// Parent API                : list_double2_graphic_pane
// Scale API match    ( 65%) : list_double2_graphic_pane_t_Limits
// Scale parent match (100%) : list_double2_graphic_pane
TAknTextLineLayout List_pane_texts__double2_graphic__Line_1(TInt aCommon1)
    {
    return AknLayoutScalable_Avkon::list_double2_graphic_pane_t1(aCommon1).LayoutLine();
    }

// B=70 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=280 l=62 r=10 
// Remark                    : 2. line. Location layout ID list_double2_graphic_pane_2.
// Parent                    : list_double2_graphic_pane
// Parent API                : list_double2_graphic_pane
// Scale API match    ( 65%) : list_double2_graphic_pane_t_Limits
// Scale parent match (100%) : list_double2_graphic_pane
TAknTextLineLayout List_pane_texts__double2_graphic__Line_2()
    {
    return AknLayoutScalable_Avkon::list_double2_graphic_pane_t2(0).LayoutLine();
    }

// LAF Table : List pane elements (double2 large graphic)
// C= H=60 W=80 b= l=12 r= t=12 
// Remark                    : 
// Parent                    : list_double2_large_graphic_pane
// Parent API                : list_double2_large_graphic_pane
// Scale API match    ( 63%) : list_double2_large_graphic_pane_g_Limits
// Scale parent match (100%) : list_double2_large_graphic_pane
TAknWindowLineLayout List_pane_elements__double2_large_graphic__Line_1()
    {
    return AknLayoutScalable_Avkon::list_double2_large_graphic_pane_g1(0).LayoutLine();
    }

// C=215 H=88 W=2 b= l=100 r= t=0 
// Remark                    : A line between the A and B columns.
// Parent                    : list_double2_large_graphic_pane
// Parent API                : list_double2_large_graphic_pane
// Scale API match    ( 63%) : list_double2_large_graphic_pane_g_Limits
// Scale parent match (100%) : list_double2_large_graphic_pane
TAknWindowLineLayout List_pane_elements__double2_large_graphic__Line_2()
{
   return ListLine(AknLayoutScalable_Avkon::list_double2_large_graphic_pane(0), 
                   AknLayoutScalable_Avkon::bg_list_pane_g4(2));
}

// C= H=26 W=26 b= l={318, 292} r= t=14 
// Remark                    : Additional icons.
// Parent                    : list_double2_large_graphic_pane
// Parent API                : list_double2_large_graphic_pane
// Scale API match    ( 63%) : list_double2_large_graphic_pane_g_Limits
// Scale parent match (100%) : list_double2_large_graphic_pane
TAknWindowLineLayout List_pane_elements__double2_large_graphic__Line_3(TInt aIndex_l)
{
	__ASSERT_ALWAYS(0 <= aIndex_l && aIndex_l <= 1, Panic(EParamsOutsideKnownRange));
    TAknWindowLineLayout layout;
    switch(aIndex_l)
        {
        case 0:
            layout = AknLayoutScalable_Avkon::list_double2_large_graphic_pane_g2(1).LayoutLine();
            break;
        case 1:
            layout = AknLayoutScalable_Avkon::list_double2_large_graphic_pane_g3(0).LayoutLine();
            break;
        }
    return layout;     
  }

/*
TAknLayoutTableLimits List_pane_elements__double2_large_graphic__SUB_TABLE_0_Limits();

TAknWindowLineLayout List_pane_elements__double2_large_graphic__SUB_TABLE_0(TInt aLineIndex);
*/

// LAF Table : List pane texts (double2 large graphic)
// B=32 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={228, 196, 170}[aCommon1] l=114 r={10, 42, 68}[aCommon1] 
// Remark                    : 1. line. Location layout ID list_double2_large_graphic_pane_1.
// Parent                    : list_double2_large_graphic_pane
// Parent API                : list_double2_large_graphic_pane
// Scale API match    ( 70%) : list_double2_large_graphic_pane_t_Limits
// Scale parent match (100%) : list_double2_large_graphic_pane
TAknTextLineLayout List_pane_texts__double2_large_graphic__Line_1(TInt aCommon1)
    {
    return AknLayoutScalable_Avkon::list_double2_large_graphic_pane_t1(aCommon1).LayoutLine();
    }

// B=70 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=218 l=124 r=10 
// Remark                    : 2. line. Location layout ID list_double2_large_graphic_pane_2.
// Parent                    : list_double2_large_graphic_pane
// Parent API                : list_double2_large_graphic_pane
// Scale API match    ( 70%) : list_double2_large_graphic_pane_t_Limits
// Scale parent match (100%) : list_double2_large_graphic_pane
TAknTextLineLayout List_pane_texts__double2_large_graphic__Line_2()
    {
    return AknLayoutScalable_Avkon::list_double2_large_graphic_pane_t2(0).LayoutLine();
    }

// LAF Table : List pane elements (large single heading graphic)

// C=215 H=88 W=2 b= l=38 r= t=0 
// Remark                    : A vertical line between the B and C columns.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 53%) : list_single_graphic_heading_pane_g_Limits
// Scale parent match (  0%) : 
    TAknWindowLineLayout List_pane_elements__large_single_heading_graphic__Line_1()
	{
	// JH: NOT USED 21.12.2005 & NOT IN SPEC 
	return EmptyWindowLayout();
	}

// C= H=26 W=26 b= l=8 r= t=14 
// Remark                    : Icon.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 53%) : list_single_graphic_heading_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__large_single_heading_graphic__Line_2()
	{
	// JH: NOT USED 21.12.2005 & NOT IN SPEC
	return EmptyWindowLayout();
	}

// C= H=26 W=26 b= l={318, 292} r= t=14 
// Remark                    : Additional icons.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 53%) : list_single_graphic_heading_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__large_single_heading_graphic__Line_3(TInt /*aIndex_l*/)
	{
	// JH: NOT USED 21.12.2005 & NOT IN SPEC
	return EmptyWindowLayout();
	}

/*
TAknLayoutTableLimits List_pane_elements__large_single_heading_graphic__SUB_TABLE_0_Limits()

TAknWindowLineLayout List_pane_elements__large_single_heading_graphic__SUB_TABLE_0(TInt aLineIndex)
*/

 // LAF Table : List pane texts (large single heading graphic)
// B=36 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W={290, 258, 232}[aCommon1] l=52 r={10, 42, 68}[aCommon1] 
// Remark                    : Heading text.
// Parent                    : list_single_big_heading_graphic_pane
// Parent API                : list_single_big_heading_graphic_pane
// Scale API match    ( 58%) : list_single_graphic_heading_pane_t_Limits
// Scale parent match ( 79%) : list_single_graphic_heading_pane_ParamLimits
TAknTextLineLayout List_pane_texts__large_single_heading_graphic__Line_1(TInt aCommon1)
    {
    return AknLayoutScalable_Avkon::list_double_graphic_heading_pane_t1(aCommon1).LayoutLine();
    }

// B=72 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=280 l=62 r=10 
// Remark                    : Item text.
// Parent                    : list_single_big_heading_graphic_pane
// Parent API                : list_single_big_heading_graphic_pane
// Scale API match    ( 58%) : list_single_graphic_heading_pane_t_Limits
// Scale parent match ( 79%) : list_single_graphic_heading_pane_ParamLimits
TAknTextLineLayout List_pane_texts__large_single_heading_graphic__Line_2()
    {
    return AknLayoutScalable_Avkon::list_double_graphic_heading_pane_t2(0).LayoutLine();
    }

// LAF Table : List pane elements (large single heading)
// C=215 H=88 W=2 b= l=12 r= t=0 
// Remark                    : Vertical line in the A column.
// Parent                    : list_single_big_heading_pane
// Parent API                : list_single_big_heading_pane
// Scale API match    ( 50%) : list_single_heading_pane_g_Limits
// Scale parent match ( 80%) : list_single_graphic_heading_pane_ParamLimits
TAknWindowLineLayout List_pane_elements__large_single_heading__Line_1()
	{
	// JH: NOT USED 21.12.2005 & NOT IN SPEC
	return EmptyWindowLayout();
	}

// LAF Table : List pane texts (large single heading)
// B=36 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=316 l=26 r=10 
// Remark                    : Heading text.
// Parent                    : list_single_big_heading_pane
// Parent API                : list_single_big_heading_pane
// Scale API match    ( 55%) : list_single_heading_pane_t_Limits
// Scale parent match ( 80%) : list_single_graphic_heading_pane_ParamLimits
TAknTextLineLayout List_pane_texts__large_single_heading__Line_1()
    {
    return AknLayoutScalable_Avkon::list_double_heading_pane_t1(0).LayoutLine();
    }
 
// B=72 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=306 l=36 r=10 
// Remark                    : Item text.
// Parent                    : list_single_big_heading_pane
// Parent API                : list_single_big_heading_pane
// Scale API match    ( 55%) : list_single_heading_pane_t_Limits
// Scale parent match ( 80%) : list_single_graphic_heading_pane_ParamLimits
TAknTextLineLayout List_pane_texts__large_single_heading__Line_2()
    {
    return AknLayoutScalable_Avkon::list_double_heading_pane_t2(0).LayoutLine();
    }

/*
TAknLayoutTableLimits List_pane_texts__large_single_heading__Limits();

TAknTextLineLayout List_pane_texts__large_single_heading_(TInt aLineIndex);
*/

// LAF Table : List pane elements (double time)
// C=215 H=88 W=2 b= l=100 r= t=0 
// Remark                    : A vertical line between the B and C columns.
// Parent                    : list_double_time_pane
// Parent API                : list_double_time_pane
// Scale API match    ( 54%) : list_double_time_pane_g_Limits
// Scale parent match (100%) : list_double_time_pane
TAknWindowLineLayout List_pane_elements__double_time__Line_1()
	{
   return ListLine(AknLayoutScalable_Avkon::list_double_time_pane(0), 
                   AknLayoutScalable_Avkon::bg_list_pane_g4(2));
	}

//  => list_line(list_double_time_pane)

// LAF Table : List pane texts (double time)
// B=40 C=215 Font=ELatinClock14_Scaled J=ELayoutAlignRight W=78 l=14 r=260 
// Remark                    : Alarm time.
// Parent                    : list_double_time_pane
// Parent API                : list_double_time_pane
// Scale API match    ( 61%) : list_double_time_pane_g_Limits
// Scale parent match (100%) : list_double_time_pane
TAknTextLineLayout List_pane_texts__double_time__Line_1()
    {
    return AknLayoutScalable_Avkon::list_double_time_pane_t4(0).LayoutLine();
    }

// B=68 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignRight W=40 l=52 r=260 
// Remark                    : A.m.p.m. indication.
// Parent                    : list_double_time_pane
// Parent API                : list_double_time_pane
// Scale API match    ( 61%) : list_double_time_pane_g_Limits
// Scale parent match (100%) : list_double_time_pane
TAknTextLineLayout List_pane_texts__double_time__Line_2()
    {
    return AknLayoutScalable_Avkon::list_double_time_pane_t3(0).LayoutLine();
    }

// B=36 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=228 l=114 r=10 
// Remark                    : Alarm title.
// Parent                    : list_double_time_pane
// Parent API                : list_double_time_pane
// Scale API match    ( 61%) : list_double_time_pane_g_Limits
// Scale parent match (100%) : list_double_time_pane
TAknTextLineLayout List_pane_texts__double_time__Line_3()
    {
    //=> list_double_time_pane_t1 // NOTE, NOT ENOUGH PARAMETERS.
    return AknLayoutScalable_Avkon::list_double_time_pane_t1(0).LayoutLine();
    }

// B=68 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=218 l=124 r=10 
// Remark                    : Additional item info.
// Parent                    : list_double_time_pane
// Parent API                : list_double_time_pane
// Scale API match    ( 61%) : list_double_time_pane_g_Limits
// Scale parent match (100%) : list_double_time_pane
TAknTextLineLayout List_pane_texts__double_time__Line_4()
    {
    return AknLayoutScalable_Avkon::list_double_time_pane_t2(0).LayoutLine();
    }

/*
TAknLayoutTableLimits List_pane_texts__double_time__Limits();

TAknTextLineLayout List_pane_texts__double_time_(TInt aLineIndex);
*/

// LAF Table : List pane elements (double large graphic)
// C= H=74 W=82 b= l=10 r= t=6 
// Remark                    : E.g. a time indication.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 63%) : list_double_large_graphic_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__double_large_graphic__Line_1()
    {
    return AknLayoutScalable_Avkon::list_double_large_graphic_pane_g1(0).LayoutLine();
    }

// C=215 H=88 W=2 b= l=100 r= t=0 
// Remark                    : A vertical line between the B and C columns.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 63%) : list_double_large_graphic_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__double_large_graphic__Line_2()
	{
   	return ListLine(AknLayoutScalable_Avkon::list_double_large_graphic_pane(0), 
                   AknLayoutScalable_Avkon::bg_list_pane_g4(2));
	}

// C= H=60 W=80 b= l=12 r= t=14 
// Remark                    : tnVGA (40x30)
// Parent                    : 
// Parent API                : 
// Scale API match    ( 63%) : list_double_large_graphic_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__double_large_graphic__Line_3()
    {
    return AknLayoutScalable_Avkon::list_double_large_graphic_pane_g1(0).LayoutLine();
    }

// C= H=72 W=60 b= l=24 r= t=8 
// Remark                    : tnVGA90 (30x40)
// Parent                    : 
// Parent API                : 
// Scale API match    ( 63%) : list_double_large_graphic_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__double_large_graphic__Line_4()
    {
    return AknLayoutScalable_Avkon::list_double_large_graphic_pane_g1(0).LayoutLine();
    }

// C= H=72 W=72 b= l=12 r= t=8 
// Remark                    : tnCIF90 (36x44)
// Parent                    : 
// Parent API                : 
// Scale API match    ( 63%) : list_double_large_graphic_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__double_large_graphic__Line_5()
    {
    return AknLayoutScalable_Avkon::list_double_large_graphic_pane_g1(0).LayoutLine();
    }

// C= H=72 W=84 b= l=8 r= t=8 
// Remark                    : tnCIF (44x36)
// Parent                    : 
// Parent API                : 
// Scale API match    ( 63%) : list_double_large_graphic_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__double_large_graphic__Line_6()
    {
    return AknLayoutScalable_Avkon::list_double_large_graphic_pane_g1(0).LayoutLine();
    }

// C= H=72 W=80 b= l=12 r= t=8 
// Remark                    : tnCOM (40x48)
// Parent                    : 
// Parent API                : 
// Scale API match    ( 63%) : list_double_large_graphic_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__double_large_graphic__Line_7()
    {
    return AknLayoutScalable_Avkon::list_double_large_graphic_pane_g1(0).LayoutLine();
    }

// C= H=72 W=84 b= l=8 r= t=8 
// Remark                    : Any other size.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 63%) : list_double_large_graphic_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__double_large_graphic__Line_8()
    {
    return AknLayoutScalable_Avkon::list_double_large_graphic_pane_g1(0).LayoutLine();
    }

// C= H=26 W=26 b= l={318, 292} r= t=14 
// Remark                    : Additional icons.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 63%) : list_double_large_graphic_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__double_large_graphic__Line_9(TInt aIndex_l)
	{
	__ASSERT_ALWAYS(0 <= aIndex_l && aIndex_l <= 1, Panic(EParamsOutsideKnownRange));
    TAknWindowLineLayout layout;
    switch(aIndex_l)
        {
        case 0:
            layout = AknLayoutScalable_Avkon::list_double_large_graphic_pane_g2(1).LayoutLine();
            break;
        case 1:
            layout = AknLayoutScalable_Avkon::list_double_large_graphic_pane_g3(0).LayoutLine();
            break;
        }
    return layout;     
  	}
//=> list_double_large_gtaphic_pane_g2 & list_double_large_graphic_pane_g3

// C=219 H=2 W=240 b= l=106 r= t=86 
// Remark                    : Used to separate attachments in MMS.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 61%) : list_double_large_graphic_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__double_large_graphic__Line_10()
	{
	return EmptyWindowLayout();
	//=> NOT THERE (listbox horizontal line)
	}

// LAF Table : List pane texts (double large graphic)
// B=36 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={228, 196, 170}[aCommon1] l=114 r={10, 42, 68}[aCommon1] 
// Remark                    : Item title text.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 69%) : list_double_large_graphic_pane_t_Limits
// Scale parent match (  0%) : 
TAknTextLineLayout List_pane_texts__double_large_graphic__Line_1(TInt aCommon1)
    {
    return AknLayoutScalable_Avkon::list_double_large_graphic_pane_t1(aCommon1).LayoutLine();
    }

// B=68 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=218 l=124 r=10 
// Remark                    : Additional item info.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 69%) : list_double_large_graphic_pane_t_Limits
// Scale parent match (  0%) : 
TAknTextLineLayout List_pane_texts__double_large_graphic__Line_2()
    {
    return AknLayoutScalable_Avkon::list_double_large_graphic_pane_t2(0).LayoutLine();
    }

// LAF Table : List pane elements (setting)
// C=215 H=90 W=2 b= l=12 r= t=0 
// Remark                    : A vertical line in the A column.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 48%) : list_setting_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__setting__Line_1()
{
   return ListLine(AknLayoutScalable_Avkon::list_setting_pane(0), 
                   AknLayoutScalable_Avkon::bg_list_pane_g4(0));
}


// C=215 H=2 W=336 b= l=14 r= t=2 
// Remark                    : A horizontal line to separate list items.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 48%) : list_setting_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__setting__Line_2()
    {
    // => NOT FOUND (horizontal line)
    return EmptyWindowLayout();
    }

// C=243 H=32 W=264 b= l=80 r= t=52 
// Remark                    : Setting item background.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 48%) : list_setting_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__setting__Line_3()
{
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::set_value_pane_cp(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::bg_set_opt_pane(0);

    // AsM: TODO: Remove below lines when implementation for setting lists backgroung image is made.
    TAknWindowLineLayout line = DoCompose(l1,l2).LayoutLine();
    line.iC = 243;  // Magic number from 2.6 LAF.
    return line;
}

// C= H=32 W=264 b= l=80 r= t=52 
// Remark                    : Setting item volume graphic.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 48%) : list_setting_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__setting__Line_4()
    {
    //  => set_value_pane_cp (SLIDER VALUE NOT INCLUDED)
    return AknLayoutScalable_Avkon::set_value_pane_cp(0).LayoutLine();
    }

// C= H=32 W=264 b= l=80 r= t=52 
// Remark                    : Setting item slider graphic.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 48%) : list_setting_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__setting__Line_5()
    {
    //  => set_value_pane_cp (VOLUME VALUE NOT INCLUDED)
    return AknLayoutScalable_Avkon::set_value_pane_cp(0).LayoutLine();
    }

// C= H=26 W=26 b=8 l=314 r=12 t=56 
// Remark                    : Additional icon.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 48%) : list_setting_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__setting__Line_6()
    {
    //=> list_setting_pane_g1 & list_setting_pane_g2 (NOT ENOUGH PARAMETERS)
    return AknLayoutScalable_Avkon::list_setting_pane_g1(0).LayoutLine();
    }

/*
TAknLayoutTableLimits List_pane_elements__setting__Limits();

TAknWindowLineLayout List_pane_elements__setting_(TInt aLineIndex);
*/

// LAF Table : List pane texts (setting)
// B=36 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=316 l=26 r=10 
// Remark                    : Setting item title. Static part.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 56%) : list_setting_pane_t_Limits
// Scale parent match (  0%) : 
TAknTextLineLayout List_pane_texts__setting__Line_1()
    {
    //  => list_setting_pane_t1  ( NOT ENOUGH PARAMETERS)
    return AknLayoutScalable_Avkon::list_setting_pane_t1(0).LayoutLine();
    }

// B=76 C=0 Font=ELatinBold12_Scaled J=ELayoutAlignCenter W=254 l=86 r=12 
// Remark                    : Setting value text. Dynamic part.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 56%) : list_setting_pane_t_Limits
// Scale parent match (  0%) : 
TAknTextLineLayout List_pane_texts__setting__Line_2()
    {
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::set_value_pane_cp(0);
	TAknTextComponentLayout l2 = AknLayoutScalable_Avkon::set_value_pane_t1();
	return DoComposeText(l1,l2).LayoutLine();
    }

// B=76 C=20 Font=ELatinBold13_Scaled J=ELayoutAlignRight W=32 l=40 r=280 
// Remark                    : Compulsory indication.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 56%) : list_setting_pane_t_Limits
// Scale parent match (  0%) : 
TAknTextLineLayout List_pane_texts__setting__Line_3()
    {
    return AknLayoutScalable_Avkon::list_setting_pane_t2(0).LayoutLine();
    }

// B=76 C=0 Font=ELatinBold12_Scaled J=ELayoutAlignRight W=226 l=86 r=40 
// Remark                    : Setting value text. Dynamic part.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 56%) : list_setting_pane_t_Limits
// Scale parent match (  0%) : 
TAknTextLineLayout List_pane_texts__setting__Line_4()
	{
	// NOT USED
	return EmptyTextLayout();

	}

/*
TAknLayoutTableLimits List_pane_texts__setting__Limits()

TAknTextLineLayout List_pane_texts__setting_(TInt aLineIndex);
*/

// LAF Table : List pane elements (setting number)
// C=215 H=90 W=2 b= l=38 r= t=0 
// Remark                    : Vertical line between the A and B columns.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 57%) : list_setting_number_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__setting_number__Line_1()
	{
   return ListLine(AknLayoutScalable_Avkon::list_setting_number_pane(0), 
                   AknLayoutScalable_Avkon::bg_list_pane_g4(1));
	}

// C=215 H=2 W=310 b= l=2 r= t=40 
// Remark                    : Horizontal line to separate list items.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 57%) : list_setting_number_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__setting_number__Line_2()
	{
	return EmptyWindowLayout();
	//=> NOT THERE (listbox horizontal line)
	}

// C=243 H=32 W=264 b= l=80 r= t=52 
// Remark                    : Setting item background.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 57%) : list_setting_number_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__setting_number__Line_3()
	{
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::set_value_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::bg_set_opt_pane(0);
	return DoCompose(l1,l2).LayoutLine();
	}

// C= H=32 W=264 b= l=80 r= t=52 
// Remark                    : Setting item volume graphic.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 57%) : list_setting_number_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__setting_number__Line_4()
	{
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::set_value_pane(0);
	return l1.LayoutLine();
	}

// C= H=32 W=264 b= l=80 r= t=52 
// Remark                    : Setting item slider graphic.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 57%) : list_setting_number_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__setting_number__Line_5()
	{
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::set_value_pane(0);
	return l1.LayoutLine();
	}

/*
TAknLayoutTableLimits List_pane_elements__setting_number__Limits();

TAknWindowLineLayout List_pane_elements__setting_number_(TInt aLineIndex);
*/

// LAF Table : List pane texts (setting number)
// B=36 C=215 Font=ELatinBold12_Scaled J=ELayoutAlignCenter W=32 l=4 r=316 
// Remark                    : Ordinal numbers.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 64%) : list_setting_number_pane_t_Limits
// Scale parent match (  0%) : 
TAknTextLineLayout List_pane_texts__setting_number__Line_1()
	{
    return AknLayoutScalable_Avkon::list_setting_number_pane_t1(0).LayoutLine();
	}

// B=36 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=290 l=52 r=10 
// Remark                    : Setting item title. Static part.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 64%) : list_setting_number_pane_t_Limits
// Scale parent match (  0%) : 
TAknTextLineLayout List_pane_texts__setting_number__Line_2()
	{
    return AknLayoutScalable_Avkon::list_setting_number_pane_t2(0).LayoutLine();
	}

// B=76 C=0 Font=ELatinBold12_Scaled J=ELayoutAlignCenter W=254 l=86 r=12 
// Remark                    : Setting value text. Dynamic part.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 64%) : list_setting_number_pane_t_Limits
// Scale parent match (  0%) : 
TAknTextLineLayout List_pane_texts__setting_number__Line_3()
	{
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::set_value_pane(0);
	TAknTextComponentLayout l2 = AknLayoutScalable_Avkon::set_value_pane_t1();
	return DoComposeText(l1,l2).LayoutLine();
	}

// B=76 C=20 Font=ELatinBold13_Scaled J=ELayoutAlignRight W=32 l=40 r=280 
// Remark                    : Compulsory indication.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 64%) : list_setting_number_pane_t_Limits
// Scale parent match (  0%) : 
TAknTextLineLayout List_pane_texts__setting_number__Line_4()
	{
    return AknLayoutScalable_Avkon::list_setting_number_pane_t3(0).LayoutLine();
	}

/*
TAknLayoutTableLimits List_pane_texts__setting_number__Limits();

TAknTextLineLayout List_pane_texts__setting_number_(TInt aLineIndex);
*/

// LAF Table : Setting volume elements
// C={244, 0} H=4 W=12 b= l=134 r= t=76 
// Remark                    : 1. volume strength indicator.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 59%) : setting_volume_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Setting_volume_elements_Line_1(TInt /*aIndex_C*/)
    {
    // JH: IMPLEMENTED 22.12.2005
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::set_value_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::volume_small_pane_cp();
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::volume_small_pane_g1();
	return (DoCompose( DoCompose(l1,l2), l3)).LayoutLine();
    // set_value_pane + volume_small_pane_cp + volume_small_pane_g1 (NOTE, BITMAP CHOICE)
    }

// C={244, 0} H=6 W=12 b= l=150 r= t=74 
// Remark                    : 2. volume strength indicator.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 59%) : setting_volume_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Setting_volume_elements_Line_2(TInt /*aIndex_C*/)
    {
    // JH: IMPLEMENTED 22.12.2005
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::set_value_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::volume_small_pane_cp();
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::volume_small_pane_g2();
	return (DoCompose( DoCompose(l1,l2), l3)).LayoutLine();
    // set_value_pane + volume_small_pane_cp + volume_small_pane_g2
    }

// C={244, 0} H=8 W=12 b= l=166 r= t=72 
// Remark                    : 3. volume strength indicator.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 59%) : setting_volume_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Setting_volume_elements_Line_3(TInt /*aIndex_C*/)
    {
    // JH: IMPLEMENTED 22.12.2005
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::set_value_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::volume_small_pane_cp();
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::volume_small_pane_g3();
	return (DoCompose( DoCompose(l1,l2), l3)).LayoutLine();
    // set_value_pane + volume_small_pane_cp + volume_small_pane_g3
    }

// C={244, 0} H=10 W=12 b= l=182 r= t=70 
// Remark                    : 4. volume strength indicator.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 59%) : setting_volume_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Setting_volume_elements_Line_4(TInt /*aIndex_C*/)
    {
    // JH: IMPLEMENTED 22.12.2005
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::set_value_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::volume_small_pane_cp();
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::volume_small_pane_g4();
	return (DoCompose( DoCompose(l1,l2), l3)).LayoutLine();
    // set_value_pane + volume_small_pane_cp + volume_small_pane_g4
    }

// C={244, 0} H=12 W=12 b= l=198 r= t=68 
// Remark                    : 5. volume strength indicator.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 59%) : setting_volume_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Setting_volume_elements_Line_5(TInt /*aIndex_C*/)
    {
    // JH: IMPLEMENTED 22.12.2005
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::set_value_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::volume_small_pane_cp();
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::volume_small_pane_g5();
	return (DoCompose( DoCompose(l1,l2), l3)).LayoutLine();
    // set_value_pane + volume_small_pane_cp + volume_small_pane_g5
    }

// C={244, 0} H=14 W=12 b= l=214 r= t=66 
// Remark                    : 6. volume strength indicator.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 59%) : setting_volume_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Setting_volume_elements_Line_6(TInt /*aIndex_C*/)
    {
    // JH: IMPLEMENTED 22.12.2005
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::set_value_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::volume_small_pane_cp();
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::volume_small_pane_g6();
	return (DoCompose( DoCompose(l1,l2), l3)).LayoutLine();
    // set_value_pane + volume_small_pane_cp + volume_small_pane_g6
    }

// C={244, 0} H=16 W=12 b= l=230 r= t=64 
// Remark                    : 7. volume strength indicator.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 59%) : setting_volume_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Setting_volume_elements_Line_7(TInt /*aIndex_C*/)
    {
    // JH: IMPLEMENTED 22.12.2005
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::set_value_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::volume_small_pane_cp();
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::volume_small_pane_g7();
	return (DoCompose( DoCompose(l1,l2), l3)).LayoutLine();
    // set_value_pane + volume_small_pane_cp + volume_small_pane_g7
    }

// C={244, 0} H=18 W=12 b= l=246 r= t=62 
// Remark                    : 8. volume strength indicator.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 59%) : setting_volume_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Setting_volume_elements_Line_8(TInt /*aIndex_C*/)
    {
    // JH: IMPLEMENTED 22.12.2005
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::set_value_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::volume_small_pane_cp();
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::volume_small_pane_g8();
	return (DoCompose( DoCompose(l1,l2), l3)).LayoutLine();
    // set_value_pane + volume_small_pane_cp + volume_small_pane_g8
    }

// C={244, 0} H=20 W=12 b= l=262 r= t=60 
// Remark                    : 9. volume strength indicator.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 59%) : setting_volume_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Setting_volume_elements_Line_9(TInt /*aIndex_C*/)
    {
    // JH: IMPLEMENTED 22.12.2005
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::set_value_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::volume_small_pane_cp();
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::volume_small_pane_g9();
	return (DoCompose( DoCompose(l1,l2), l3)).LayoutLine();
    // set_value_pane + volume_small_pane_cp + volume_small_pane_g9
    }

// C={244, 0} H=22 W=12 b= l=278 r= t=58 
// Remark                    : 10. volume strength indicator.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 56%) : setting_volume_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Setting_volume_elements_Line_10(TInt /*aIndex_C*/)
    {
    // JH: IMPLEMENTED 22.12.2005
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::set_value_pane(0);
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::volume_small_pane_cp();
	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::volume_small_pane_g10();
	return (DoCompose( DoCompose(l1,l2), l3)).LayoutLine();
    // set_value_pane + volume_small_pane_cp + volume_small_pane_g10
    }

/*
TAknLayoutTableLimits Setting_volume_elements_Limits();

TAknWindowLineLayout Setting_volume_elements(TInt aLineIndex, TInt aIndex_C);
*/

// LAF Table : Setting slider elements
// C= H=22 W=236 b= l=14 r= t=6 
// Remark                    : Slider graphics.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 59%) : setting_slider_graphic_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout Setting_slider_elements_Line_1()
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::slider_set_pane_cp3();
    return layout.LayoutLine();    
    }

// C=215 H=90 W=2 b= l=38 r= t=0 
// Remark                    : Vertical line between the A and B columns.
// Parent                    : list_setting_double2_pane
// Parent API                : list_setting_double2_pane
// Scale API match    ( 39%) : list_double2_pane_g_Limits
// Scale parent match ( 65%) : list_setting_pane_g2_ParamLimits
TAknWindowLineLayout List_pane_elements__setting_double2__Line_1()
    {
    return List_pane_elements__double__Line_1();
    }

// C=215 H=2 W=310 b= l=2 r= t=40 
// Remark                    : Horizontal line to separate list items.
// Parent                    : list_setting_double2_pane
// Parent API                : list_setting_double2_pane
// Scale API match    ( 39%) : list_double2_pane_g_Limits
// Scale parent match ( 65%) : list_setting_pane_g2_ParamLimits
TAknWindowLineLayout List_pane_elements__setting_double2__Line_2()
    {
    // JH: NOT USED 21.12.2005 & NOT IN SPEC
    return EmptyWindowLayout();
    }
    
// C= H=26 W=26 b= l=314 r=12 t=38 
// Remark                    : Settings protected icons.
// Parent                    : list_setting_double2_pane
// Parent API                : list_setting_double2_pane
// Scale API match    ( 39%) : list_double2_pane_g_Limits
// Scale parent match ( 65%) : list_setting_pane_g2_ParamLimits
TAknWindowLineLayout List_pane_elements__setting_double2__Line_3()
    {
    return List_pane_elements__double__Line_2(0);
    }

/*
TAknLayoutTableLimits List_pane_elements__setting_double2__Limits();

TAknWindowLineLayout List_pane_elements__setting_double2_(TInt aLineIndex);
*/

TAknWindowLineLayout ListTopBottomLine(TInt aCommon1, TAknWindowComponentLayout aLine)
	{
   	TInt pos = -1; // value for DoSplit() method.
   	if (aCommon1 == 0) // top part of lines
		{
		pos = 1;
		}
	if (aCommon1 == 1) // bottom part of lines
		{
		pos = 7;
		}
	if (aCommon1 == 2) // top part of lines, list_setting_pane
		{
		pos = 1;
		}
	if (aCommon1 == 3) // bottom part of lines, list_setting_pane
		{
		pos = 7;
		}
	if (aCommon1 == 4) // top part of lines, list_setting_pane
		{
		pos = 1;
		}
	if (aCommon1 == 5) // bottom part of lines, list_setting_pane
		{
		pos = 7;
		}

	
   	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::bg_list_pane(0);
   	TAknWindowComponentLayout l4 = aLine; 

   	TAknWindowComponentLayout sp = AknLayoutScalable_Avkon::listscroll_gen_pane(0);
   	TAknWindowComponentLayout part = DoSplit(sp, pos);
   
   	TAknWindowComponentLayout line = DoCompose(l3,l4);
   	TAknWindowComponentLayout lineInArea = DoIntersect(line, part);
   	return lineInArea.LayoutLine();
	}

// LAF Table : List pane lines (A column)
// C=215 H={16, 12, 6, 4}[aCommon1] W=2 b= l=12 r= t={0, 268, 0, 276}[aCommon1] 
// Remark                    : Vertical lines on the list pane.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 35%) : bg_list_pane_ParamLimits
// Scale parent match (100%) : main_pane
TAknWindowLineLayout List_pane_lines__A_column__Line_1(TInt aCommon1)
   {
   return ListTopBottomLine(aCommon1, AknLayoutScalable_Avkon::bg_list_pane_g4(0));
	}

// C=215 H=2 W=336 b= l=14 r= t=278 
// Remark                    : Horizontal line at the bottom of the pane.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 35%) : bg_list_pane_ParamLimits
// Scale parent match (100%) : main_pane
TAknWindowLineLayout List_pane_lines__A_column__Line_2()
	{
	// JH: IMPLEMENTED 11.1.2006
	TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::bg_list_pane_g5(0);
	return layout.LayoutLine();
	}

// LAF Table : List pane lines (AB columns)
// C=215 H={16, 12, 6, 4, 12, 4}[aCommon1] W=2 b= l=38 r= t={0, 268, 0, 276, 0, 274}[aCommon1] 
// Remark                    : Vertical lines on the list pane.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 33%) : bg_list_pane_ParamLimits
// Scale parent match (100%) : main_pane
TAknWindowLineLayout List_pane_lines__AB_columns__Line_1(TInt aCommon1)
   	{
   	return ListTopBottomLine(aCommon1, AknLayoutScalable_Avkon::bg_list_pane_g4(1));
	/*
   	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::bg_list_pane(aCommon1);
    return DoCompose(l3,l4).LayoutLine();
    return DoCompose(DoCompose(layout, DoCompose(l3,l4)).LayoutLine();
	}
	*/
	}

//=> bg_list_pane + bg_list_pane_g4(1)
//=> lists + main_pane_cp11 + bg_list_pane + bg_list_pane_g4(1)

// C=215 H=2 W=312 b= l=38 r= t=278 
// Remark                    : Horizontal line at the bottom of the pane.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 33%) : bg_list_pane_ParamLimits
// Scale parent match (100%) : main_pane
TAknWindowLineLayout List_pane_lines__AB_columns__Line_2()
	{
	// JH: IMPLEMENTED 11.1.2006
	TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::bg_list_pane_g5(1);
	return layout.LayoutLine();
	}
	
// LAF Table : List pane lines (BC columns)
// C=215 H={16, 12, 10, 4, 12, 4}[aCommon1] W=2 b= l=100 r= t={0, 268, 0, 274, 0, 274}[aCommon1] 
// Remark                    : Vertical line on the list pane.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 33%) : bg_list_pane_ParamLimits
// Scale parent match (100%) : main_pane
TAknWindowLineLayout List_pane_lines__BC_columns__Line_1(TInt aCommon1)
   	{
   	return ListTopBottomLine(aCommon1, AknLayoutScalable_Avkon::bg_list_pane_g4(2));
	/*
   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::main_pane_cp11();
   	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::bg_list_pane(aCommon1);
    return DoCompose(l3,l4).LayoutLine();
    return DoCompose(DoCompose(layout, l2), DoCompose(l3,l4)).LayoutLine();
	*/
	}

// C=215 H=2 W=250 b= l=100 r= t=278 
// Remark                    : Horizontal line at the bottom of the pane.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 33%) : bg_list_pane_ParamLimits
// Scale parent match (100%) : main_pane
TAknWindowLineLayout List_pane_lines__BC_columns__Line_2()
	{
	// JH: IMPLEMENTED 11.1.2006
	TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::bg_list_pane_g5(2);
	return layout.LayoutLine();
	}

// LAF Table : List pane highlight graphics (various)
// C=222 H=p-6 W=p-8 b= l=6 r= t=6 
// Remark                    : Shadow.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 41%) : list_highlight_pane_cp2
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_highlight_graphics__various__Line_1(const TRect& /*aParentRect*/)
	{
	return EmptyWindowLayout();
	// => NOT POSSIBLE
	}

// C=244 H=p-4 W=p-6 b= l=2 r= t=2 
// Remark                    : Highlight.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 41%) : list_highlight_pane_cp2
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_highlight_graphics__various__Line_2(const TRect& /*aParentRect*/)
	{
	// JH: Does not exist in LAF. Aknlists uses only the colour attribute; hence this hack.
	/* TAknWindowLineLayout layout = AknLayoutScalable_Avkon::list_highlight_pane_cp1(); */
	TAknWindowLineLayout layout = EmptyWindowLayout();
	layout.iC = 244;
	return layout;
	}

// C=215 H=2 W=2 b= l={12, 38, 100} r= t=0 
// Remark                    : Small line between the A and B or the B and C columns.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 41%) : list_highlight_pane_cp2
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_highlight_graphics__various__Line_3(TInt /*aIndex_l*/)
	{
	// NOT possible, need to know which list type is used. About the same code as in "list_line(list_xxx_pane)".
    // except that need to subtract size of highlight.
	return EmptyWindowLayout();
	}

/*
TAknLayoutTableLimits List_pane_highlight_graphics__various__SUB_TABLE_0_Limits()

TAknWindowLineLayout List_pane_highlight_graphics__various__SUB_TABLE_0(TInt aLineIndex, const TRect& aParentRect)
*/

// LAF Table : List pane highlight graphics (setting number)
// C=222 H=p-10 W=p-8 b= l=6 r= t=10 
// Remark                    : Shadow.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 46%) : list_setting_number_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_highlight_graphics__setting_number__Line_1(const TRect& /*aParentRect*/)
	{
	return EmptyWindowLayout();
	// not possible
	}

// C=244 H=p-8 W=p-6 b= l=2 r= t=6 
// Remark                    : Highlight.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 46%) : list_setting_number_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_highlight_graphics__setting_number__Line_2(const TRect& /*aParentRect*/)
	{
	return EmptyWindowLayout();
	// not possible
	}

// C=215 H=6 W=2 b= l=38 r= t=0 
// Remark                    : Small line between the A and B columns.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 46%) : list_setting_number_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_highlight_graphics__setting_number__Line_3()
	{
	return EmptyWindowLayout();
	// maybe possible, but not done.
	}

/*
TAknLayoutTableLimits List_pane_highlight_graphics__setting_number__SUB_TABLE_0_Limits()

TAknWindowLineLayout List_pane_highlight_graphics__setting_number__SUB_TABLE_0(TInt aLineIndex, const TRect& aParentRect)
*/

// LAF Table : Find pane elements
// C=221 H=42 W=2 b= l=40 r= t=12 
// Remark                    : Vertical shadow inside the find box frame.
// Parent                    : find_pane
// Parent API                : find_pane
// Scale API match    ( 47%) : find_popup_pane_cp2_ParamLimits
// Scale parent match (100%) : find_pane
TAknWindowLineLayout Find_pane_elements_Line_1()
	{
	return EmptyWindowLayout();
	// NOT THERE
	}

// C=221 H=2 W=306 b= l=42 r= t=12 
// Remark                    : Horizontal shadow inside the find box frame.
// Parent                    : find_pane
// Parent API                : find_pane
// Scale API match    ( 47%) : find_popup_pane_cp2_ParamLimits
// Scale parent match (100%) : find_pane
TAknWindowLineLayout Find_pane_elements_Line_2()
	{
	return EmptyWindowLayout();
	// NOT THERE
	}

// C=215 H=10 W=2 b= l=38 r= t=0 
// Remark                    : Vertical line extension.
// Parent                    : find_pane
// Parent API                : find_pane
// Scale API match    ( 47%) : find_popup_pane_cp2_ParamLimits
// Scale parent match (100%) : find_pane
TAknWindowLineLayout Find_pane_elements_Line_3()
	{
	return EmptyWindowLayout();
	// NOT THERE
	}

// C=215 H=46 W=312 b= l=38 r= t=10 
// Remark                    : Outline frame.
// Parent                    : find_pane
// Parent API                : find_pane
// Scale API match    ( 47%) : find_popup_pane_cp2_ParamLimits
// Scale parent match (100%) : find_pane
TAknWindowLineLayout Find_pane_elements_Line_4()
    {
    return AknLayoutScalable_Avkon::input_find_pane().LayoutLine();
    }

// C= H=52 W=48 b= l=4 r= t=4 
// Remark                    : Magnifying glass icon.
// Parent                    : find_pane
// Parent API                : find_pane
// Scale API match    ( 47%) : find_popup_pane_cp2_ParamLimits
// Scale parent match (100%) : find_pane
TAknWindowLineLayout Find_pane_elements_Line_5()
    {
    return AknLayoutScalable_Avkon::find_pane_g1().LayoutLine();
    }

/*
TAknLayoutTableLimits Find_pane_elements_Limits();

TAknWindowLineLayout Find_pane_elements(TInt aLineIndex);
*/

// LAF Table : Find pane texts
// B=40 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=286 l=56 r=10 
// Remark                    : Search string.
// Parent                    : find_pane
// Parent API                : find_pane
// Scale API match    ( 64%) : input_find_pane_t1_ParamLimits
// Scale parent match (100%) : find_pane
TAknTextLineLayout Find_pane_texts_Line_1()
   {
   TInt varietyIndex = Layout_Meta_Data::IsAPAC() ? 1 : 0;
   TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::input_find_pane();
   TAknTextComponentLayout l2 = AknLayoutScalable_Avkon::input_find_pane_t1(varietyIndex);
   return DoComposeText(layout,l2).LayoutLine();
   }

// LAF Table : Form descendant panes
// C= H={46, 88, 130, 172, 214, 256} W=348 b= l=2 r= t={14, 56, 98, 140, 182, 224} 
// Remark                    : Form pane for editing and entering new data.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : form_field_data_pane
// Scale parent match (100%) : main_pane
TAknWindowLineLayout form_field_data_pane(TInt aIndex_t, TInt aIndex_H)
	{
	TInt lastVariety = AknLayoutScalable_Avkon::form_field_data_pane_ParamLimits().LastVariety();
	__ASSERT_ALWAYS(0 == aIndex_t, Panic(EParamsOutsideKnownRange));
	__ASSERT_ALWAYS(0 <= aIndex_H && aIndex_H <= lastVariety, Panic(EParamsOutsideKnownRange));

	TInt varietyIndex = aIndex_H;
   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::listscroll_form_pane();
   	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_form_gen_pane();
   	TAknWindowComponentLayout::FormFieldHack(l3);
   	TAknWindowComponentLayout l4 = AknLayoutScalable_Avkon::form_field_data_pane(varietyIndex);
    return DoCompose(l2, DoCompose(l3,l4)).LayoutLine();
   	}

// C= H={88, 130, 172, 214, 256} W=348 b= l=2 r= t={14, 56, 98, 140, 182, 224} 
// Remark                    : Form pane for editing and entering new data.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : form_field_data_wide_pane
// Scale parent match (100%) : main_pane
TAknWindowLineLayout form_field_data_wide_pane(TInt aIndex_t, TInt aIndex_H)
	{
	TInt lastVariety = AknLayoutScalable_Avkon::form_field_data_wide_pane_ParamLimits().LastVariety();
	__ASSERT_ALWAYS(0 == aIndex_t, Panic(EParamsOutsideKnownRange));
	__ASSERT_ALWAYS(0 <= aIndex_H && aIndex_H <= lastVariety, Panic(EParamsOutsideKnownRange)); 

	TInt varietyIndex = aIndex_H;
	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::listscroll_form_pane();
   	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_form_gen_pane();
   	TAknWindowComponentLayout l4 = AknLayoutScalable_Avkon::form_field_data_wide_pane(varietyIndex);
    return DoCompose(l2, DoCompose(l3,l4)).LayoutLine();
	}

// C= H={46, 88, 130, 172, 214, 256} W=348 b= l=2 r= t={14, 56, 98, 140, 182, 224} 
// Remark                    : Form pop-up pane for option selection.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : form_field_popup_pane
// Scale parent match (100%) : main_pane
TAknWindowLineLayout form_field_popup_pane(TInt aIndex_t, TInt aIndex_H)
	{
	TInt lastVariety = AknLayoutScalable_Avkon::form_field_popup_pane_ParamLimits().LastVariety();
	__ASSERT_ALWAYS(0 == aIndex_t, Panic(EParamsOutsideKnownRange));
	__ASSERT_ALWAYS(0 <= aIndex_H && aIndex_H <= lastVariety, Panic(EParamsOutsideKnownRange));

	TInt varietyIndex = aIndex_H;
   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::listscroll_form_pane();
   	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_form_gen_pane();
   	TAknWindowComponentLayout l4 = AknLayoutScalable_Avkon::form_field_popup_pane(varietyIndex);
    return DoCompose(l2, DoCompose(l3,l4)).LayoutLine();
	}

// C= H={88, 130, 172, 214, 256} W=348 b= l=2 r= t={14, 56, 98, 140, 182, 224} 
// Remark                    : Form popup pane for option selection.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : form_field_popup_wide_pane
// Scale parent match (100%) : main_pane
TAknWindowLineLayout form_field_popup_wide_pane(TInt aIndex_t, TInt aIndex_H)
	{
	TInt lastVariety = AknLayoutScalable_Avkon::form_field_popup_wide_pane_ParamLimits().LastVariety();
	__ASSERT_ALWAYS(0 == aIndex_t, Panic(EParamsOutsideKnownRange));
	__ASSERT_ALWAYS(0 <= aIndex_H && aIndex_H <= lastVariety, Panic(EParamsOutsideKnownRange));

	TInt varietyIndex = aIndex_H;
   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::listscroll_form_pane();
   	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_form_gen_pane();

   	TAknWindowComponentLayout l4 = AknLayoutScalable_Avkon::form_field_popup_wide_pane(varietyIndex);
    return DoCompose(l2, DoCompose(l3,l4)).LayoutLine();
	}

// C= H={88, 130} W=348 b= l=2 r= t={14, 56, 98, 140, 182, 224} 
// Remark                    : Form slider indication.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : form_field_slider_pane
// Scale parent match (100%) : main_pane
TAknWindowLineLayout form_field_slider_pane(TInt aIndex_t, TInt aIndex_H)
	{
	TInt lastVariety = AknLayoutScalable_Avkon::form_field_slider_pane_ParamLimits().LastVariety();
	__ASSERT_ALWAYS(0 == aIndex_t, Panic(EParamsOutsideKnownRange));
	__ASSERT_ALWAYS(0 <= aIndex_H && aIndex_H <= lastVariety, Panic(EParamsOutsideKnownRange));

	// LAY: H = {88, 130}
	// SCALABLE: H= {122, 82, 86}
	TInt varietyIndex = 0;
	switch(aIndex_H)
		{
		case 0:
			varietyIndex = 2; // slider with numeric value
			break;
		case 1:
			varietyIndex = 0; // slider with numeric value and min/max values
			break;
		case 2: // extend the old API to allow access to the new value
			varietyIndex = 1; // slider with min/max values
			break;
		}

   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::listscroll_form_pane();
   	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_form_gen_pane();

   	TAknWindowComponentLayout l4 = AknLayoutScalable_Avkon::form_field_slider_pane(varietyIndex);
    return DoCompose(l2, DoCompose(l3,l4)).LayoutLine();
	}

// C= H={130, 172} W=348 b= l=2 r= t={14, 56, 98, 140, 182, 224} 
// Remark                    : Form slider indication.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : form_field_slider_wide_pane
// Scale parent match (100%) : main_pane
TAknWindowLineLayout form_field_slider_wide_pane(TInt aIndex_t, TInt aIndex_H)
	{
	TInt lastVariety = AknLayoutScalable_Avkon::form_field_slider_wide_pane_ParamLimits().LastVariety();
	__ASSERT_ALWAYS(0 == aIndex_t, Panic(EParamsOutsideKnownRange));
	__ASSERT_ALWAYS(0 <= aIndex_H && aIndex_H <= lastVariety, Panic(EParamsOutsideKnownRange));

	// LAY: H = {130, 172}
	// SCALABLE: H= {156, 120, 120}
	TInt varietyIndex = 0;
	switch(aIndex_H)
		{
		case 0:
			varietyIndex = 2; // value with min/max values
			break;
		case 1:
			varietyIndex = 0; // value, slider, and min/max values
			break;
		case 2: // extend the old API to allow access to the new value
			varietyIndex = 1; // slider with min/max values
			break;
		}

   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::listscroll_form_pane();
   	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_form_gen_pane();

   	TAknWindowComponentLayout l4 = AknLayoutScalable_Avkon::form_field_slider_wide_pane(varietyIndex);
    return DoCompose(l2, DoCompose(l3,l4)).LayoutLine();
	}
	
/*
TAknLayoutTableLimits Form_descendant_panes_Limits();

TAknWindowLineLayout Form_descendant_panes(TInt aLineIndex, TInt aIndex_t, TInt aIndex_H);
*/

// LAF Table : Form data field elements
// C=221 H={42, 84, 126, 168, 210, 252} W=2 b= l=2 r= t=2 
// Remark                    : Vertical shadow inside the editing frame.
// Parent                    : form_field_data_pane
// Parent API                : form_field_data_pane
// Scale API match    ( 52%) : form_field_data_pane_ParamLimits
// Scale parent match (100%) : form_field_data_pane
TAknWindowLineLayout Form_data_field_elements_Line_1(TInt /*aIndex_H*/)
    {
    // NOT THERE
    return EmptyWindowLayout();
    }

// C=221 H=2 W=342 b= l=4 r= t=2 
// Remark                    : Horizontal shadow inside the editing frame.
// Parent                    : form_field_data_pane
// Parent API                : form_field_data_pane
// Scale API match    ( 52%) : form_field_data_pane_ParamLimits
// Scale parent match (100%) : form_field_data_pane
TAknWindowLineLayout Form_data_field_elements_Line_2()
    {
    // NOT THERE
    return EmptyWindowLayout();
    }

// C=215 H={46, 88, 130, 172, 214, 256} W=348 b= l=0 r= t=0 
// Remark                    : Outline frame.
// Parent                    : form_field_data_pane
// Parent API                : form_field_data_pane
// Scale API match    ( 52%) : form_field_data_pane_ParamLimits
// Scale parent match (100%) : form_field_data_pane
TAknWindowLineLayout Form_data_field_elements_Line_3(TInt aIndex_H)
    {
    return AknLayoutScalable_Avkon::data_form_pane(aIndex_H).LayoutLine();
    }

// C= H=26 W=26 b= l=4 r= t=10 
// Remark                    : Icon.
// Parent                    : form_field_data_pane
// Parent API                : form_field_data_pane
// Scale API match    ( 52%) : form_field_data_pane_ParamLimits
// Scale parent match (100%) : form_field_data_pane
TAknWindowLineLayout Form_data_field_elements_Line_4()
    {
    // JH: IMPLEMENTED 23.12.2005
    return AknLayoutScalable_Avkon::form_field_data_pane_g1().LayoutLine();
    }

// LAF Table : Form data field texts
// B={32, 74, 116, 158, 200, 242} C=215 Font=ELatinPlain12_Scaled J={ELayoutAlignRight, ELayoutAlignLeft}[aCommon1] W={92, 64}[aCommon1] l={6, 34}[aCommon1] r=252 
// Remark                    : Heading text (i.e. label).
// Parent                    : form_field_data_pane
// Parent API                : form_field_data_pane
// Scale API match    ( 60%) : form_field_data_pane_ParamLimits
// Scale parent match (100%) : form_field_data_pane
TAknTextLineLayout Form_data_field_texts_Line_1(TInt aCommon1, TInt /*aIndex_B*/)
	{
	TInt varietyIndex = aCommon1;
    return AknLayoutScalable_Avkon::form_field_data_pane_t1(varietyIndex).LayoutLine();
	}
	
/*
TAknMultiLineTextLayout Multiline_Form_data_field_texts_Line_1(TInt aCommon1, TInt aNumberOfLinesShown)
*/

// B={32, 74, 116, 158, 200, 242} C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=228 l=112 r=8 
// Remark                    : Entered or edited data.
// Parent                    : form_field_data_pane
// Parent API                : form_field_data_pane
// Scale API match    ( 60%) : form_field_data_pane_ParamLimits
// Scale parent match (100%) : form_field_data_pane
TAknTextLineLayout Form_data_field_texts_Line_2(TInt aIndex_B)
	{
	TInt varietyIndex = 0; // all options of data_form_pane have same data [LMB 21/03/2005]
   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::data_form_pane(varietyIndex);
	TInt rowIndex = aIndex_B;
   	TAknTextComponentLayout l4 = AknLayoutScalable_Avkon::data_form_pane_t1(rowIndex);
    return DoComposeText(l2,l4).LayoutLine();
	}


TAknMultiLineTextLayout Multiline_Form_data_field_texts_Line_2(TInt aNumberOfLinesShown)
	{ // The default multiline version does NOT work here. (because iB needs to be parent relative)
	/* TInt lastRow = AknLayoutScalable_Avkon::data_form_pane_t1_ParamLimits().LastRow(); */
	TInt varietyIndex = 0; // all options of data_form_pane have same data [LMB 21/03/2005]
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::data_form_pane(varietyIndex);
	TInt rowIndex = 0; // top row
    TAknTextComponentLayout l2 = AknLayoutScalable_Avkon::data_form_pane_t1(rowIndex);
	TAknTextComponentLayout::FormDataHack2(l2);
	TAknMultiLineTextLayout result;
    TAknTextLineLayout &l = result;
	TAknTextComponentLayout l3 = DoComposeText(l1,l2);
    l = l3.LayoutLine();
	// need to get the baseline separation from the container [LMB 21/03/2005]
	TAknWindowLineLayout l4 = AknLayoutScalable_Avkon::form_field_data_pane(0).LayoutLine();
	TAknWindowLineLayout l4a = AknLayoutScalable_Avkon::form_field_data_pane(1).LayoutLine();
	result.iBaselineSkip = l4a.iH - l4.iH;
	result.iB = (TInt16)TAknTextComponentLayout::FormDataHack(l3);
	result.iNumberOfLinesShown = aNumberOfLinesShown;
	return result;
	}

// LAF Table : Form data wide field elements
// C=221 H={84, 126, 168, 210, 252} W=2 b= l=2 r= t=2 
// Remark                    : Vertical shadow inside the editing frame.
// Parent                    : form_field_data_wide_pane
// Parent API                : form_field_data_wide_pane
// Scale API match    ( 60%) : form_field_data_wide_pane_ParamLimits
// Scale parent match (100%) : form_field_data_wide_pane
TAknWindowLineLayout Form_data_wide_field_elements_Line_1(TInt /*aIndex_H*/)
    {
    // NOT FOUND
    return EmptyWindowLayout();
    }

// C=221 H=2 W=342 b= l=4 r= t=2 
// Remark                    : Horizontal shadow inside the editing frame.
// Parent                    : form_field_data_wide_pane
// Parent API                : form_field_data_wide_pane
// Scale API match    ( 60%) : form_field_data_wide_pane_ParamLimits
// Scale parent match (100%) : form_field_data_wide_pane
TAknWindowLineLayout Form_data_wide_field_elements_Line_2()
    {
    // NOT FOUND
    return EmptyWindowLayout();
    }

// C=215 H={88, 130, 172, 214, 256} W=348 b= l=0 r= t=0 
// Remark                    : Outline frame.
// Parent                    : form_field_data_wide_pane
// Parent API                : form_field_data_wide_pane
// Scale API match    ( 60%) : form_field_data_wide_pane_ParamLimits
// Scale parent match (100%) : form_field_data_wide_pane
TAknWindowLineLayout Form_data_wide_field_elements_Line_3(TInt /*aIndex_H*/)
    {
    // NOT FOUND
    return EmptyWindowLayout();
    }

// C= H=26 W=26 b= l=6 r= t=10 
// Remark                    : Icon.
// Parent                    : form_field_data_wide_pane
// Parent API                : form_field_data_wide_pane
// Scale API match    ( 60%) : form_field_data_wide_pane_ParamLimits
// Scale parent match (100%) : form_field_data_wide_pane
TAknWindowLineLayout Form_data_wide_field_elements_Line_4()
    {
    return AknLayoutScalable_Avkon::form_field_data_wide_pane_g1().LayoutLine();
    }

// LAF Table : Form data wide field texts
// B=38 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=290 l=50 r=8 
// Remark                    : Heading text (i.e. label).
// Parent                    : form_field_data_wide_pane
// Parent API                : form_field_data_wide_pane
// Scale API match    ( 68%) : form_field_data_wide_pane_ParamLimits
// Scale parent match (100%) : form_field_data_wide_pane
TAknTextLineLayout Form_data_wide_field_texts_Line_1()
    {
	TInt varietyIndex = 0; // variety 1 doesn't seem to correspond to anything in laf spec [LMB 21/03/2005]
    return AknLayoutScalable_Avkon::form_field_data_wide_pane_t1(varietyIndex).LayoutLine();
    }

// B={74, 116, 158, 200, 242} C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=280 l=60 r=8 
// Remark                    : Entered or edited data.
// Parent                    : form_field_data_wide_pane
// Parent API                : form_field_data_wide_pane
// Scale API match    ( 68%) : form_field_data_wide_pane_ParamLimits
// Scale parent match (100%) : form_field_data_wide_pane
TAknTextLineLayout Form_data_wide_field_texts_Line_2(TInt aIndex_B)
   	{
	TInt varietyIndex = 0; // all options of data_form_wide_pane have same data [LMB 21/03/2005]
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::data_form_wide_pane(varietyIndex);
	TInt rowIndex = aIndex_B;
	TAknTextComponentLayout l2 = AknLayoutScalable_Avkon::data_form_wide_pane_t1(rowIndex);
   	return DoComposeText(l1,l2).LayoutLine();
   	}

// MISSING
TAknMultiLineTextLayout Multiline_Form_data_wide_field_texts_Line_2(TInt aNumberOfLinesShown)
	{ // The default multiline version does NOT work here. (because iB needs to be parent relative)
	/*  TInt lastRow = AknLayoutScalable_Avkon::data_form_wide_pane_t1_ParamLimits().LastRow(); */
	TInt varietyIndex = 0; // all options of data_form_pane have same data [LMB 21/03/2005]
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::data_form_wide_pane(varietyIndex);
	TInt rowIndex = 0; // first row
    TAknTextComponentLayout l2 = AknLayoutScalable_Avkon::data_form_wide_pane_t1(rowIndex);
	TAknTextComponentLayout::FormDataHack2(l2);
	TAknMultiLineTextLayout result;
    TAknTextLineLayout &l = result;
	TAknTextComponentLayout l3 = DoComposeText(l1,l2);
    l = l3.LayoutLine();
	// need to get the baseline separation from the container [LMB 21/03/2005]
	TAknWindowLineLayout l4 = AknLayoutScalable_Avkon::form_field_data_wide_pane(0).LayoutLine();
	TAknWindowLineLayout l4a = AknLayoutScalable_Avkon::form_field_data_wide_pane(1).LayoutLine();
	result.iBaselineSkip = l4a.iH - l4.iH;
	result.iB = (TInt16)TAknTextComponentLayout::FormDataHack(l3);
	result.iNumberOfLinesShown = aNumberOfLinesShown;
	return result;
	}

/* 
TAknMultiLineTextLayout Multiline_Form_data_wide_field_texts_Line_2(TInt aNumberOfLinesShown);
*/

// LAF Table : Form pop-up field elements and descendants
// C=221 H={42, 84, 126, 168, 210, 252} W=2 b= l=2 r= t=2 
// Remark                    : Vertical shadow inside the editing frame.
// Parent                    : form_field_popup_pane
// Parent API                : form_field_popup_pane
// Scale API match    ( 26%) : form_field_popup_pane_ParamLimits
// Scale parent match (100%) : form_field_popup_pane
TAknWindowLineLayout Form_pop_up_field_elements_and_descendants_Line_1(TInt /*aIndex_H*/)
    {
    // NOT FOUND
    return EmptyWindowLayout();
    }

// C=221 H=2 W=342 b= l=4 r= t=2 
// Remark                    : Horizontal shadow inside the editing frame.
// Parent                    : form_field_popup_pane
// Parent API                : form_field_popup_pane
// Scale API match    ( 26%) : form_field_popup_pane_ParamLimits
// Scale parent match (100%) : form_field_popup_pane
TAknWindowLineLayout Form_pop_up_field_elements_and_descendants_Line_2()
    {
    // NOT FOUND
    return EmptyWindowLayout();
    }

// C=215 H={46, 88, 130, 172, 214, 256} W=348 b= l=0 r= t=0 
// Remark                    : Outline frame.
// Parent                    : form_field_popup_pane
// Parent API                : form_field_popup_pane
// Scale API match    ( 26%) : form_field_popup_pane_ParamLimits
// Scale parent match (100%) : form_field_popup_pane
TAknWindowLineLayout Form_pop_up_field_elements_and_descendants_Line_3(TInt /*aIndex_H*/)
    {
    // NOT FOUND
    return EmptyWindowLayout();
    }

// C= H=34 W=2 b= l=346 r= t=2 
// Remark                    : Indication that the edited item continues upwards.
// Parent                    : form_field_popup_pane
// Parent API                : form_field_popup_pane
// Scale API match    ( 26%) : form_field_popup_pane_ParamLimits
// Scale parent match (100%) : form_field_popup_pane
TAknWindowLineLayout Form_pop_up_field_elements_and_descendants_Line_4()
    {
    // NOT FOUND
    return EmptyWindowLayout();
    }

// C= H=34 W=2 b=2 l=346 r= t= 
// Remark                    : Indication that the edited item continues downwards.
// Parent                    : form_field_popup_pane
// Parent API                : form_field_popup_pane
// Scale API match    ( 26%) : form_field_popup_pane_ParamLimits
// Scale parent match (100%) : form_field_popup_pane
TAknWindowLineLayout Form_pop_up_field_elements_and_descendants_Line_5()
    {
    // NOT FOUND
    return EmptyWindowLayout();
    }

// C= H={36, 78, 120, 162, 204, 246} W=244 b= l=100 r= t=6 
// Remark                    : Form option item pop-up list.
// Parent                    : form_field_popup_pane
// Parent API                : form_field_popup_pane
// Scale API match    (100%) : list_form_pane
// Scale parent match (100%) : form_field_popup_pane
TAknWindowLineLayout list_form_pane(TInt /*aIndex_H*/)
	{
    return AknLayoutScalable_Avkon::list_form_pane(0).LayoutLine();
	}

// LAF Table : List pane elements (form pop-up)
// C= H=36 W=244 b= l=0 r= t={0, 42, 84, 126, 168, 210} 
// Remark                    : Single list item with a check box or a radio button.
// Parent                    : list_form_pane
// Parent API                : list_form_pane
// Scale API match    (100%) : list_form_graphic_pane
// Scale parent match (100%) : list_form_pane
TAknWindowLineLayout list_form_graphic_pane(TInt aIndex_t)
	{
    return AknLayoutScalable_Avkon::list_form_graphic_pane(aIndex_t).LayoutLine();
	}

// LAF Table : List pane elements (form graphic)
// C={0, 243} H=36 W=244 b= l=0 r= t=0 
// Remark                    : Value item background.
// Parent                    : list_form_graphic_pane
// Parent API                : list_form_graphic_pane
// Scale API match    ( 52%) : list_form_graphic_pane_cp_ParamLimits
// Scale parent match (100%) : list_form_graphic_pane
TAknWindowLineLayout List_pane_elements__form_graphic__Line_1(TInt aIndex_C)
	{
    return AknLayoutScalable_Avkon::list_highlight_pane_cp5(aIndex_C).LayoutLine();
	}
  // => list_highlight_pane_cp5

// C= H=34 W=20 b= l=12 r= t=2 
// Remark                    : Value item graphic marked unmarked radio button onoff.
// Parent                    : list_form_graphic_pane
// Parent API                : list_form_graphic_pane
// Scale API match    ( 52%) : list_form_graphic_pane_cp_ParamLimits
// Scale parent match (100%) : list_form_graphic_pane
TAknWindowLineLayout List_pane_elements__form_graphic__Line_2()
	{
    return AknLayoutScalable_Avkon::list_form_graphic_pane_g1().LayoutLine();
	}

// LAF Table : List pane texts (form graphic)
// B=26 C={215, 0} Font=ELatinBold12_Scaled J=ELayoutAlignLeft W={196, 226}[aCommon1] l={42, 12}[aCommon1] r=6 
// Remark                    : Form option item text.
// Parent                    : list_form_graphic_pane
// Parent API                : list_form_graphic_pane
// Scale API match    ( 60%) : list_form_graphic_pane_t1_ParamLimits
// Scale parent match (100%) : list_form_graphic_pane
TAknTextLineLayout List_pane_texts__form_graphic__Line_1(TInt /*aIndex_C*/, TInt aCommon1)
    {
    return AknLayoutScalable_Avkon::list_form_graphic_pane_t1(aCommon1).LayoutLine();
    }
// => list_form_graphic_pane_t1 


// LAF Table : Form pop-up wide field elements and descendants
// C=221 H={42, 84, 126, 168, 210, 252} W=2 b= l=2 r= t=2 
// Remark                    : Vertical shadow inside the editing frame.
// Parent                    : form_field_popup_pane
// Parent API                : form_field_popup_pane
// Scale API match    ( 34%) : form_field_popup_wide_pane_ParamLimits
// Scale parent match (100%) : form_field_popup_pane
TAknWindowLineLayout Form_pop_up_wide_field_elements_and_descendants_Line_1(TInt /*aIndex_H*/)
    {
    // NOT THERE
    return EmptyWindowLayout();
    }

// C=221 H=2 W=342 b= l=4 r= t=2 
// Remark                    : Horizontal shadow inside the editing frame.
// Parent                    : form_field_popup_pane
// Parent API                : form_field_popup_pane
// Scale API match    ( 34%) : form_field_popup_wide_pane_ParamLimits
// Scale parent match (100%) : form_field_popup_pane
TAknWindowLineLayout Form_pop_up_wide_field_elements_and_descendants_Line_2()
    {
    // NOT THERE
    return EmptyWindowLayout();
    }

// C=215 H={46, 88, 130, 172, 214, 256} W=348 b= l=0 r= t=0 
// Remark                    : Outline frame.
// Parent                    : form_field_popup_pane
// Parent API                : form_field_popup_pane
// Scale API match    ( 34%) : form_field_popup_wide_pane_ParamLimits
// Scale parent match (100%) : form_field_popup_pane
TAknWindowLineLayout Form_pop_up_wide_field_elements_and_descendants_Line_3(TInt /*aIndex_H*/)
    {
    // NOT THERE
    return EmptyWindowLayout();
    }

// C= H=34 W=2 b= l=346 r= t=2 
// Remark                    : Indication that the edited item continues upwards.
// Parent                    : form_field_popup_pane
// Parent API                : form_field_popup_pane
// Scale API match    ( 34%) : form_field_popup_wide_pane_ParamLimits
// Scale parent match (100%) : form_field_popup_pane
TAknWindowLineLayout Form_pop_up_wide_field_elements_and_descendants_Line_4()
    {
    // NOT THERE
    return EmptyWindowLayout();
    }

// C= H=34 W=2 b=2 l=346 r= t= 
// Remark                    : Indication that the edited item continues downwards.
// Parent                    : form_field_popup_pane
// Parent API                : form_field_popup_pane
// Scale API match    ( 34%) : form_field_popup_wide_pane_ParamLimits
// Scale parent match (100%) : form_field_popup_pane
TAknWindowLineLayout Form_pop_up_wide_field_elements_and_descendants_Line_5()
    {
    // NOT THERE
    return EmptyWindowLayout();
    }


// C= H={36, 78, 120, 162, 204, 246} W={320, 288}[aCommon1] b= l={24, 48}[aCommon1] r= t=48 
// Remark                    : Form option wide item pop-up list.
// Parent                    : form_field_popup_pane
// Parent API                : form_field_popup_pane
// Scale API match    (100%) : list_form_wide_pane
// Scale parent match (100%) : form_field_popup_pane
TAknWindowLineLayout list_form_wide_pane(TInt /*aCommon1*/, TInt /*aIndex_H*/)
	{
    return AknLayoutScalable_Avkon::list_form_wide_pane(0).LayoutLine();
	}

// LAF Table : List pane elements (form pop-up wide)
// C= H=36 W=320 b= l=0 r= t={0, 42, 84, 126, 168, 210} 
// Remark                    : Single list item with a check box or a radio button.
// Parent                    : list_form_wide_pane
// Parent API                : list_form_wide_pane
// Scale API match    ( 80%) : list_form_graphic_pane_ParamLimits
// Scale parent match (100%) : list_form_wide_pane
TAknWindowLineLayout list_form_graphic_wide_pane(TInt aIndex_t)
	{
    return AknLayoutScalable_Avkon::list_form_graphic_pane_cp(aIndex_t).LayoutLine();
	}

// LAF Table : List pane elements (form graphic wide)
// C={0, 243} H=36 W=320 b= l=0 r= t=0 
// Remark                    : Value item background.
// Parent                    : list_form_graphic_wide_pane
// Parent API                : list_form_graphic_wide_pane
// Scale API match    ( 46%) : list_form_graphic_pane_cp_ParamLimits
// Scale parent match ( 80%) : list_form_graphic_pane_ParamLimits
TAknWindowLineLayout List_pane_elements__form_graphic_wide__Line_1(TInt aIndex_C)
	{
	// => list_highlight_pane_cp5 (NOTE, THIS REQUIRES PARENT RELATIVE COORDINATES IN list_Form_graphic_pane -table)
    return AknLayoutScalable_Avkon::list_highlight_pane_cp5(aIndex_C).LayoutLine();
	}

// C= H=34 W=20 b= l=10 r= t=2 
// Remark                    : Value item graphic marked unmarked radio button onoff.
// Parent                    : list_form_graphic_wide_pane
// Parent API                : list_form_graphic_wide_pane
// Scale API match    ( 46%) : list_form_graphic_pane_cp_ParamLimits
// Scale parent match ( 80%) : list_form_graphic_pane_ParamLimits
TAknWindowLineLayout List_pane_elements__form_graphic_wide__Line_2()
	{
	// => list_form_graphic_pane_g1  (NOTE, THIS REQUIRES PARENT RELATIVE COORDINATES IN list_Form_graphic_pane -table)
    return AknLayoutScalable_Avkon::list_form_graphic_pane_g1().LayoutLine();
	}

// LAF Table : List pane texts (form graphic wide)
// B=26 C={215, 0} Font=ELatinBold12_Scaled J=ELayoutAlignLeft W={274, 304, } l={40, 10} r={6, 34} 
// Remark                    : Form option item text.
// Parent                    : list_form_graphic_wide_pane
// Parent API                : list_form_graphic_wide_pane
// Scale API match    ( 52%) : list_form_graphic_pane_t1_ParamLimits
// Scale parent match ( 80%) : list_form_graphic_pane_ParamLimits
TAknTextLineLayout List_pane_texts__form_graphic_wide__Line_1(TInt /*aIndex_C*/, TInt /*aIndex_l*/, TInt /*aIndex_r*/, TInt aIndex_W)
	{
	// => list_form_graphic_pane_t1 (NOTE, THIS REQUIRES PARENT RELATIVE COORDINATES IN list_Form_graphic_pane -table)
    return AknLayoutScalable_Avkon::list_form_graphic_pane_t1(aIndex_W).LayoutLine();
	}

// LAF Table : Form slider field elements and descendants
// C=221 H={42, 84, 126} W=2 b= l=2 r= t=2 
// Remark                    : Vertical shadow inside the slider frame.
// Parent                    : form_field_slider_pane
// Parent API                : form_field_slider_pane
// Scale API match    ( 34%) : form_field_slider_pane_ParamLimits
// Scale parent match (100%) : form_field_slider_pane
TAknWindowLineLayout Form_slider_field_elements_and_descendants_Line_1(TInt /*aIndex_H*/)
    {
    // NOT THERE
    return EmptyWindowLayout();
    }

// C=221 H=2 W=342 b= l=4 r= t=2 
// Remark                    : Horizontal shadow inside the slider frame.
// Parent                    : form_field_slider_pane
// Parent API                : form_field_slider_pane
// Scale API match    ( 34%) : form_field_slider_pane_ParamLimits
// Scale parent match (100%) : form_field_slider_pane
TAknWindowLineLayout Form_slider_field_elements_and_descendants_Line_2()
    {
    // NOT THERE
    return EmptyWindowLayout();
    }

// C=215 H={46, 88, 130} W=348 b= l=0 r= t=0 
// Remark                    : Outline frame.
// Parent                    : form_field_slider_pane
// Parent API                : form_field_slider_pane
// Scale API match    ( 34%) : form_field_slider_pane_ParamLimits
// Scale parent match (100%) : form_field_slider_pane
TAknWindowLineLayout Form_slider_field_elements_and_descendants_Line_3(TInt aIndex_H)
    {
    // JH: IMPLEMENTED 23.12.2005
    return AknLayoutScalable_Avkon::form_field_slider_pane(aIndex_H).LayoutLine();
    }

// C= H=34 W=2 b= l=346 r= t=2 
// Remark                    : Indication that the edited item continues. The item is not shown fully on the display.
// Parent                    : form_field_slider_pane
// Parent API                : form_field_slider_pane
// Scale API match    ( 34%) : form_field_slider_pane_ParamLimits
// Scale parent match (100%) : form_field_slider_pane
TAknWindowLineLayout Form_slider_field_elements_and_descendants_Line_4()
    {
    // NOT THERE
    return EmptyWindowLayout();
    }

// C= H=34 W=2 b=2 l=346 r= t= 
// Remark                    : Indication that the edited item continues. The item is not shown fully on the display.
// Parent                    : form_field_slider_pane
// Parent API                : form_field_slider_pane
// Scale API match    ( 34%) : form_field_slider_pane_ParamLimits
// Scale parent match (100%) : form_field_slider_pane
TAknWindowLineLayout Form_slider_field_elements_and_descendants_Line_5()
    {
    // NOT THERE
    return EmptyWindowLayout();
    }

// C= H=22 W=222 b= l=110 r= t={14, 52} 
// Remark                    : Slider graphics.
// Parent                    : form_field_slider_pane
// Parent API                : form_field_slider_pane
// Scale API match    ( 34%) : form_field_slider_pane_ParamLimits
// Scale parent match (100%) : form_field_slider_pane
TAknWindowLineLayout Form_slider_field_elements_and_descendants_Line_6(TInt aIndex_t)
	{
    return AknLayoutScalable_Avkon::slider_form_pane(aIndex_t).LayoutLine();
	}

// LAF Table : Slider pane elements (form)
// C=215 H=2 W=218 b= l=2 r= t=10 
// Remark                    : Horizontal slider line.
// Parent                    : slider_form_pane
// Parent API                : Form_slider_field_elements_and_descendants_Line_6
// Scale API match    ( 46%) : form_field_slider_pane_t_Limits
// Scale parent match ( 34%) : form_field_slider_pane_ParamLimits
TAknWindowLineLayout Slider_pane_elements__form__Line_1()
	{
    return AknLayoutScalable_Avkon::slider_form_pane_g1().LayoutLine();
	}

// C= H=22 W=22 b= l= r= t=0 
// Remark                    : Slider current value indication.
// Parent                    : slider_form_pane
// Parent API                : Form_slider_field_elements_and_descendants_Line_6
// Scale API match    ( 46%) : form_field_slider_pane_t_Limits
// Scale parent match ( 34%) : form_field_slider_pane_ParamLimits
TAknWindowLineLayout Slider_pane_elements__form__Line_2()
	{
    return AknLayoutScalable_Avkon::slider_form_pane_g2().LayoutLine();
	}

/*
TAknLayoutTableLimits Slider_pane_elements__form__Limits();

TAknWindowLineLayout Slider_pane_elements__form_(TInt aLineIndex);
*/

// LAF Table : Form slider field texts
// B=32 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignRight W=88 l=6 r=252 
// Remark                    : Heading text.
// Parent                    : form_field_slider_pane
// Parent API                : form_field_slider_pane
// Scale API match    ( 63%) : form_field_slider_pane_ParamLimits
// Scale parent match (100%) : form_field_slider_pane
TAknTextLineLayout Form_slider_field_texts_Line_1()
	{
    return AknLayoutScalable_Avkon::form_field_slider_pane_t1(0).LayoutLine();
	}

// B=32 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=228 l=112 r=8 
// Remark                    : Slider value.
// Parent                    : form_field_slider_pane
// Parent API                : form_field_slider_pane
// Scale API match    ( 63%) : form_field_slider_pane_ParamLimits
// Scale parent match (100%) : form_field_slider_pane
TAknTextLineLayout Form_slider_field_texts_Line_2()
	{
    return AknLayoutScalable_Avkon::form_field_slider_pane_t2(0).LayoutLine();
	}

// B={68, 108, 68, 108} C={215, , 215}[aCommon1] Font=ELatinBold13_Scaled J={ELayoutAlignLeft, , ELayoutAlignRight}[aCommon1] W={110, , 110}[aCommon1] l={112, , 224}[aCommon1] r={126, , 14}[aCommon1] 
// Remark                    : Slider minimum value.  Slider maximum value.
// Parent                    : form_field_slider_pane
// Parent API                : form_field_slider_pane
// Scale API match    ( 63%) : form_field_slider_pane_ParamLimits
// Scale parent match (100%) : form_field_slider_pane
TAknTextLineLayout Form_slider_field_texts_Line_3(TInt aCommon1, TInt /*aIndex_B*/)
	{ 
  	// TInt currentSlider = 0;
  	TInt minimumOrMaximum = 0;
  	if (aCommon1 == 0 || aCommon1 == 1) { minimumOrMaximum = 0; } 
  	if (aCommon1 == 2 || aCommon1 == 3) { minimumOrMaximum = 1; }
  	// if (aCommon1 == 0 || aCommon1 == 2) { currentSlider = 0; }
  	// if (aCommon1 == 1 || aCommon1 == 3) { currentSlider = 1; }
  	// current slider no longer used [LMB 11/11/2004]

  	if (minimumOrMaximum == 0)
	  	{
	  	return AknLayoutScalable_Avkon::form_field_slider_pane_t3().LayoutLine();
	  	}
  	else
	  	{
      	return AknLayoutScalable_Avkon::form_field_slider_pane_t4().LayoutLine();
      	}
	}

/*
TAknMultiLineTextLayout Multiline_Form_slider_field_texts_Line_3(TInt aCommon1, TInt aNumberOfLinesShown)
*/

/*
TAknLayoutTableLimits Form_slider_field_texts_SUB_TABLE_0_Limits()

TAknTextLineLayout Form_slider_field_texts_SUB_TABLE_0(TInt aLineIndex)
*/

// LAF Table : Form slider field elements and descendants_dup
// C=221 H={84, 126, 168} W=2 b= l=2 r= t=2 
// Remark                    : Vertical shadow inside the slider frame.
// Parent                    : form_field_slider_pane
// Parent API                : form_field_slider_pane
// Scale API match    ( 31%) : form_field_slider_pane_ParamLimits
// Scale parent match (100%) : form_field_slider_pane
TAknWindowLineLayout Form_slider_field_elements_and_descendants_dup_Line_1(TInt /*aIndex_H*/)
    {
    // NOT FOUND
    return EmptyWindowLayout();
    }

// C=221 H=2 W=342 b= l=4 r= t=2 
// Remark                    : Horizontal shadow inside the slider frame.
// Parent                    : form_field_slider_pane
// Parent API                : form_field_slider_pane
// Scale API match    ( 31%) : form_field_slider_pane_ParamLimits
// Scale parent match (100%) : form_field_slider_pane
TAknWindowLineLayout Form_slider_field_elements_and_descendants_dup_Line_2()
    {
    // NOT FOUND
    return EmptyWindowLayout();
    }

// C=215 H={88, 130, 172} W=348 b= l=0 r= t=0 
// Remark                    : Outline frame.
// Parent                    : form_field_slider_pane
// Parent API                : form_field_slider_pane
// Scale API match    ( 31%) : form_field_slider_pane_ParamLimits
// Scale parent match (100%) : form_field_slider_pane
TAknWindowLineLayout Form_slider_field_elements_and_descendants_dup_Line_3(TInt /*aIndex_H*/)
    {
    // NOT FOUND
    return EmptyWindowLayout();
    }

// C= H=34 W=2 b= l=346 r= t=2 
// Remark                    : Indication that the edited item continues. The item is not shown fully on the display.
// Parent                    : form_field_slider_pane
// Parent API                : form_field_slider_pane
// Scale API match    ( 31%) : form_field_slider_pane_ParamLimits
// Scale parent match (100%) : form_field_slider_pane
TAknWindowLineLayout Form_slider_field_elements_and_descendants_dup_Line_4()
    {
    // NOT FOUND
    return EmptyWindowLayout();
    }

// C= H=34 W=2 b=2 l=346 r= t= 
// Remark                    : Indication that the edited item continues. The item is not shown fully on the display.
// Parent                    : form_field_slider_pane
// Parent API                : form_field_slider_pane
// Scale API match    ( 31%) : form_field_slider_pane_ParamLimits
// Scale parent match (100%) : form_field_slider_pane
TAknWindowLineLayout Form_slider_field_elements_and_descendants_dup_Line_5()
    {
    // NOT FOUND
    return EmptyWindowLayout();
    }

// C= H=22 W=298 b= l=34 r= t={56, 94} 
// Remark                    : Slider graphics.
// Parent                    : form_field_slider_pane
// Parent API                : form_field_slider_pane
// Scale API match    ( 31%) : form_field_slider_pane_ParamLimits
// Scale parent match (100%) : form_field_slider_pane
TAknWindowLineLayout Form_slider_field_elements_and_descendants_dup_Line_6(TInt aIndex_t)
  {
  return AknLayoutScalable_Avkon::slider_form_pane(aIndex_t).LayoutLine();
  }

// LAF Table : Slider pane elements (form)_dup
// C=215 H=2 W=294 b= l=2 r= t=10 
// Remark                    : Horizontal slider line.
// Parent                    : slider_form_pane
// Parent API                : Form_slider_field_elements_and_descendants_Line_6
// Scale API match    ( 43%) : form_field_slider_pane_ParamLimits
// Scale parent match ( 34%) : form_field_slider_pane_ParamLimits
TAknWindowLineLayout Slider_pane_elements__form__dup_Line_1()
  {
  return AknLayoutScalable_Avkon::slider_form_pane_g1().LayoutLine();
  }

// C= H=22 W=22 b= l= r= t=0 
// Remark                    : Slider current value indication.
// Parent                    : slider_form_pane
// Parent API                : Form_slider_field_elements_and_descendants_Line_6
// Scale API match    ( 43%) : form_field_slider_pane_ParamLimits
// Scale parent match ( 34%) : form_field_slider_pane_ParamLimits
TAknWindowLineLayout Slider_pane_elements__form__dup_Line_2()
  {
  return AknLayoutScalable_Avkon::slider_form_pane_g2().LayoutLine();
  }
  
/*
TAknLayoutTableLimits Slider_pane_elements__form__dup_Limits();

TAknWindowLineLayout Slider_pane_elements__form__dup(TInt aLineIndex);
*/

// LAF Table : Form slider field texts_dup
// B=36 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=314 l=26 r=8 
// Remark                    : Heading text.
// Parent                    : form_field_slider_pane
// Parent API                : form_field_slider_pane
// Scale API match    ( 53%) : form_field_slider_pane_ParamLimits
// Scale parent match (100%) : form_field_slider_pane
TAknTextLineLayout Form_slider_field_texts_dup_Line_1()
  {
  return AknLayoutScalable_Avkon::form_field_slider_pane_t1(0).LayoutLine();
  }

// B=76 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=304 l=36 r=8 
// Remark                    : Slider value.
// Parent                    : form_field_slider_pane
// Parent API                : form_field_slider_pane
// Scale API match    ( 53%) : form_field_slider_pane_ParamLimits
// Scale parent match (100%) : form_field_slider_pane
TAknTextLineLayout Form_slider_field_texts_dup_Line_2()
  {
  return AknLayoutScalable_Avkon::form_field_slider_pane_t2(0).LayoutLine();
  }

// B={112, 152, 112, 152} C={215, , 215}[aCommon1] Font=ELatinBold13_Scaled J={ELayoutAlignLeft, , ELayoutAlignRight}[aCommon1] W={148, , 148}[aCommon1] l={36, , 186}[aCommon1] r={164, , 14}[aCommon1] 
// Remark                    : Slider minimum value.  Slider maximum value.
// Parent                    : form_field_slider_pane
// Parent API                : form_field_slider_pane
// Scale API match    ( 53%) : form_field_slider_pane_ParamLimits
// Scale parent match (100%) : form_field_slider_pane
TAknTextLineLayout Form_slider_field_texts_dup_Line_3(TInt aCommon1, TInt /*aIndex_B*/)
	{
  	// TInt currentSlider = 0;
  	TInt minimumOrMaximum = 0;
  	if (aCommon1 == 0 || aCommon1 == 1) { minimumOrMaximum = 0; } 
  	if (aCommon1 == 2 || aCommon1 == 3) { minimumOrMaximum = 1; }
  	// if (aCommon1 == 0 || aCommon1 == 2) { currentSlider = 0; }
  	// if (aCommon1 == 1 || aCommon1 == 3) { currentSlider = 1; }
  	// current slider no longer used [LMB 11/11/2004]

  	if (minimumOrMaximum == 0)
	  	{
	  	return AknLayoutScalable_Avkon::form_field_slider_pane_t3().LayoutLine();
	  	}
 	else
	  	{
      	return AknLayoutScalable_Avkon::form_field_slider_pane_t4().LayoutLine();
      	}
	}

/*
TAknMultiLineTextLayout Multiline_Form_slider_field_texts_dup_Line_3(TInt aCommon1, TInt aNumberOfLinesShown)

TAknLayoutTableLimits Form_slider_field_texts_dup_SUB_TABLE_0_Limits()

TAknTextLineLayout Form_slider_field_texts_dup_SUB_TABLE_0(TInt aLineIndex)
*/

// LAF Table : Cursor graphics (13)
// C= H=30 W=4 b=6 l= r= t= 
// Remark                    : Cursor graphics.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 36%) : setting_slider_graphic_pane_t_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout Cursor_graphics__13__Line_1()
    {
    // => NOT FOUND
    return EmptyWindowLayout();
    }

// LAF Table : Predictive text input graphics (13)
// C= H=30 W=4 b=6 l= r= t= 
// Remark                    : Cursor graphics.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 25%) : popup_fep_japan_predictive_window_t_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout Predictive_text_input_graphics__13__Line_1()
    {
    // => NOT FOUND
    return EmptyWindowLayout();
    }

// C=210 H=2 W= b=4 l= r=4 t= 
// Remark                    : Predictive text input indication.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 25%) : popup_fep_japan_predictive_window_t_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout Predictive_text_input_graphics__13__Line_2()
    {
    // => NOT FOUND
    return EmptyWindowLayout();
    }
/*
TAknLayoutTableLimits Predictive_text_input_graphics__13__Limits();

TAknWindowLineLayout Predictive_text_input_graphics__13_(TInt aLineIndex);
*/

// LAF Table : Cut copy and paste highlight graphics (13)
// C= H=30 W= b= l=-2 r=2 t=-2 
// Remark                    : Selection highlight (i.e. marked text) for the cut copy and paste functions.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 25%) : cell_highlight_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout Cut_copy_and_paste_highlight_graphics__13__Line_1()
    {  
    // => NOT FOUND 
    return EmptyWindowLayout();
    }

// LAF Table : Time and date entry graphics (13)
// C= H= W= b=6 l=-2 r=2 t=-4 
// Remark                    : Inversion rectangle.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Time_and_date_entry_graphics__13__Line_1()
    {
    // => NOT FOUND 
    return EmptyWindowLayout();
    }

// LAF Table : Cursor graphics (12)
// C= H=28 W=2 b=6 l= r= t= 
// Remark                    : Cursor graphics.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 36%) : setting_slider_graphic_pane_t_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout Cursor_graphics__12__Line_1()
    {
    // => NOT FOUND 
    return EmptyWindowLayout();
    }

// LAF Table : Predictive text input graphics (12)
// C= H=28 W=2 b=6 l= r= t= 
// Remark                    : Cursor graphics.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 25%) : popup_fep_japan_predictive_window_t_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout Predictive_text_input_graphics__12__Line_1()
    {
    // => NOT FOUND 
    return EmptyWindowLayout();
    }

// C=210 H=2 W= b=4 l= r=2 t= 
// Remark                    : Predictive text input indication.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 25%) : popup_fep_japan_predictive_window_t_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout Predictive_text_input_graphics__12__Line_2()
    { 
    // => NOT FOUND 
    return EmptyWindowLayout();
    }

/*
TAknLayoutTableLimits Predictive_text_input_graphics__12__Limits();
=> NOT FOUND

TAknWindowLineLayout Predictive_text_input_graphics__12_(TInt aLineIndex);
=> NOT FOUND
*/

// LAF Table : Cut copy and paste highlight graphics (12)
// C= H=28 W= b= l=-2 r=0 t=-2 
// Remark                    : Selection highlight (i.e. marked text) for the cut copy and paste functions.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 25%) : cell_highlight_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout Cut_copy_and_paste_highlight_graphics__12__Line_1()
    {
    //=> NOT FOUND
    return EmptyWindowLayout();
    }

// LAF Table : Time and date entry graphics (12)
// C= H= W= b=4 l=-2 r=0 t=-4 
// Remark                    : Inversion rectangle.
// Parent                    : 
// Parent API                : 
// Scale API match    (  0%) : 
// Scale parent match (  0%) : 
TAknWindowLineLayout Time_and_date_entry_graphics__12__Line_1()
    {
    // => NOT FOUND
    return EmptyWindowLayout();
    }

// LAF Table : AVKON specific list pane
// C= H=34 W=264 b= l=0 r= t={0, 34, 68, 102, 136, 170} 
// Remark                    : List pane for setting item editing.
// Parent                    : list_set_pane
// Parent API                : list_set_pane
// Scale API match    (100%) : list_set_graphic_pane
// Scale parent match (100%) : list_set_pane
TAknWindowLineLayout list_set_graphic_pane(TInt aIndex_t)
  	{
  	return AknLayoutScalable_Avkon::list_set_graphic_pane(aIndex_t).LayoutLine();
  	}

// LAF Table : List pane elements (set graphic)
// C={0, 243} H=34 W=264 b= l= r= t= 
// Remark                    : Setting value item background.
// Parent                    : list_set_graphic_pane
// Parent API                : list_set_graphic_pane
// Scale API match    ( 54%) : list_set_graphic_pane_g_Limits
// Scale parent match (100%) : list_set_graphic_pane
TAknWindowLineLayout List_pane_elements__set_graphic__Line_1(TInt /*aIndex_C*/)
  	{
  	return AknLayoutScalable_Avkon::bg_set_opt_pane_cp4().LayoutLine();
  	}

// C= H=34 W=20 b= l=28 r= t=0 
// Remark                    : Setting value item graphic marked unmarked radio button onoff.
// Parent                    : list_set_graphic_pane
// Parent API                : list_set_graphic_pane
// Scale API match    ( 54%) : list_set_graphic_pane_g_Limits
// Scale parent match (100%) : list_set_graphic_pane
TAknWindowLineLayout List_pane_elements__set_graphic__Line_2()
	{
  	return AknLayoutScalable_Avkon::list_set_graphic_pane_g1(0).LayoutLine();
  	}

// C= H=26 W=26 b=4 l=238 r=4 t=4 
// Remark                    : Additional icon.
// Parent                    : list_set_graphic_pane
// Parent API                : list_set_graphic_pane
// Scale API match    ( 54%) : list_set_graphic_pane_g_Limits
// Scale parent match (100%) : list_set_graphic_pane
TAknWindowLineLayout List_pane_elements__set_graphic__Line_3()
	{
  	return AknLayoutScalable_Avkon::list_set_graphic_pane_g2(0).LayoutLine();
  	}

/*
TAknLayoutTableLimits List_pane_elements__set_graphic__SUB_TABLE_0_Limits();

TAknWindowLineLayout List_pane_elements__set_graphic__SUB_TABLE_0(TInt aLineIndex);
*/

// LAF Table : List pane texts (set graphic)
// B=24 C={215, 0} Font=ELatinBold12_Scaled J=ELayoutAlignLeft W={206, 232, 176} l={54, 28} r=4 
// Remark                    : Setting value item text.
// Parent                    : list_set_graphic_pane
// Parent API                : list_set_graphic_pane
// Scale API match    ( 58%) : list_set_graphic_pane_g_Limits
// Scale parent match (100%) : list_set_graphic_pane
TAknTextLineLayout List_pane_texts__set_graphic__Line_1(TInt /*aIndex_C*/, TInt /*aIndex_l*/, TInt aIndex_W)
	{
	__ASSERT_ALWAYS(0 <= aIndex_W && aIndex_W <= 2, Panic(EParamsOutsideKnownRange));

	// LAY W={206, 232, 176}
	// 	The focused value item text is shown in color index 0.
	// **: The values are used if there is no value item graphic shown.
	// ***: The value is used when the Settings protected icon is shown.

	// SCALABLE W = {p-50, p-36, p-80}
	// so 
	// 0 = 206 = middle = p-50 = 0
	// 1 = 232 = large = p-36 = 1
	// 2 = 176 = small = p-80 = 2

	TInt variety = aIndex_W;
  	//return AknLayoutScalable_Avkon::text_primary_small_cp13(variety).LayoutLine();
  	// MAN: 9.11.2005 Layout data v1.90 name has been changed 
  	return AknLayoutScalable_Avkon::list_set_graphic_pane_t1(variety).LayoutLine();
  	}

// LAF Table : Application grid descendant
// C= H=94 W=116 b= l={0, , , 116, , , 232} r= t={0, 94, 188, 0, 94, 188, 0, 94, 188} 
// Remark                    : Application selection 3x3 grid.
// Parent                    : grid_app_pane
// Parent API                : grid_app_pane
// Scale API match    ( 38%) : application_window_ParamLimits
// Scale parent match (100%) : grid_app_pane
TAknWindowLineLayout Application_grid_descendant_Line_1(TInt aIndex_l, TInt aIndex_t)
  	{
  	// 0 = 3x3, 1 = 3x4, 2 = 4x3
  	// but not enough info to select the correct option here
  	return AknLayoutScalable_Avkon::cell_app_pane(0, aIndex_l, aIndex_t).LayoutLine();
  	}

// LAF Table : Cell pane elements (app)
// C= H=58 W=84 b= l=16 r= t=4 
// Remark                    : E.g. an application list icon.
// Parent                    : cell_app_pane
// Parent API                : Application_grid_descendant_Line_1
// Scale API match    ( 41%) : cell_app_pane_g_Limits
// Scale parent match ( 38%) : application_window_ParamLimits
TAknWindowLineLayout Cell_pane_elements__app__Line_1()
  	{
  	return AknLayoutScalable_Avkon::cell_app_pane_g1(0).LayoutLine();
  	}

// C= H=26 W=26 b= l=88 r= t=2 
// Remark                    : Marked item indication.
// Parent                    : cell_app_pane
// Parent API                : Application_grid_descendant_Line_1
// Scale API match    ( 41%) : cell_app_pane_g_Limits
// Scale parent match ( 38%) : application_window_ParamLimits
TAknWindowLineLayout Cell_pane_elements__app__Line_2()
  	{
  	return AknLayoutScalable_Avkon::cell_app_pane_g2(0).LayoutLine();
  	}
  
/*
TAknLayoutTableLimits Cell_pane_elements__app__Limits();

TAknWindowLineLayout Cell_pane_elements__app_(TInt aLineIndex);
*/

// LAF Table : Cell pane texts (app)
// B=82 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignCenter W=106 l=6 r=4 
// Remark                    : Application title.
// Parent                    : cell_app_pane
// Parent API                : Application_grid_descendant_Line_1
// Scale API match    ( 46%) : cell_app_pane_g_Limits
// Scale parent match ( 38%) : application_window_ParamLimits
TAknTextLineLayout Cell_pane_texts__app__Line_1()
  	{
  	return AknLayoutScalable_Avkon::cell_app_pane_t1(0).LayoutLine();
  	}

// LAF Table : Cell pane highlight elements (various)
// C=215 H=p W=p b= l=p r= t=p 
// Remark                    : 
// Parent                    : cell_app_pane
// Parent API                : Application_grid_descendant_Line_1
// Scale API match    ( 41%) : cell_highlight_pane_g_Limits
// Scale parent match ( 38%) : application_window_ParamLimits
TAknWindowLineLayout Cell_pane_highlight_elements__various__Line_1(const TRect& /*aParentRect*/)
  	{
  	return AknLayoutScalable_Avkon::grid_highlight_pane(0).LayoutLine();
  	}

// LAF Table : Wallpaper pane element
// C= H=p W=p b= l=0 r= t=0 
// Remark                    : User selectable wallpaper image.
// Parent                    : wallpaper_pane
// Parent API                : wallpaper_pane
// Scale API match    ( 61%) : wallpaper_pane_g1
// Scale parent match (100%) : wallpaper_pane
TAknWindowLineLayout Wallpaper_pane_element_Line_1(const TRect& /*aParentRect*/)
  	{
  	return AknLayoutScalable_Avkon::wallpaper_pane_g1().LayoutLine();
  	}

// LAF Table : Indicator pane elements
// C= H=18 W= b= l=12 r=6 t=4 
// Remark                    : Status icons.
// Parent                    : indicator_pane
// Parent API                : indicator_pane
// Scale API match    ( 59%) : uni_indicator_pane_g1
// Scale parent match (100%) : indicator_pane
TAknWindowLineLayout Indicator_pane_elements_Line_1()
  	{
  	// right aligned in portrait only
  	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
  	return AknLayoutScalable_Avkon::indicator_pane_g1(varietyIndex).LayoutLine();
  	}

// LAF Table : Soft indicator pane elements
// C= H={20, p} W=286 b= l=66 r= t={2, 24} 
// Remark                    : Faded background for soft indicators.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 66%) : soft_indicator_pane_t1_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Soft_indicator_pane_elements_Line_1(const TRect& /*aParentRect*/, TInt /*aIndex_t*/, TInt /*aIndex_H*/)
    {
    // NOT FOUND
    return EmptyWindowLayout();
    }

// LAF Table : Soft indicator pane texts
// B={48, 76, 104, 132, 132, 188, 216} C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignRight W=278 l=70 r=4 
// Remark                    : Soft indicator texts. Seven lines of text.
// Parent                    : soft_indicator_pane
// Parent API                : soft_indicator_pane
// Scale API match    ( 79%) : soft_indicator_pane_t1_ParamLimits
// Scale parent match (100%) : soft_indicator_pane
TAknTextLineLayout Soft_indicator_pane_texts_Line_1(TInt /*aIndex_B*/)
  	{
   	// MAN: FIXED 16.2.2005 
    
   	// there are other landscape options available, but not enough semantics in this API to decide which to use
   	// therefore assume it's the portrait version
  	TInt varietyIndex = 0; // no clock
  	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::main_idle_trad_pane();
  	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::soft_indicator_pane(varietyIndex);
  	TAknTextComponentLayout l3 = AknLayoutScalable_Avkon::soft_indicator_pane_t1(/*aIndex_B*/); // AsM 24082005: no longer multi row
  	return DoComposeText(DoCompose(l1,l2),l3).LayoutLine(); 
  	//return AknLayoutScalable_Avkon::soft_indicator_pane_t1(aIndex_B).LayoutLine();
  	}
  
/*
TAknMultiLineTextLayout Multiline_Soft_indicator_pane_texts_Line_1(TInt aNumberOfLinesShown);
*/

// LAF Table : Idle power save state descendant
// C= H=48 W=352 b= l=0 r= t={8, 16, 24, , 328} 
// Remark                    : 
// Parent                    : screen
// Parent API                : screen
// Scale API match    (100%) : power_save_pane
// Scale parent match (100%) : Screen
TAknWindowLineLayout power_save_pane(TInt /*aIndex_t*/)
   	{
   	TAknWindowComponentLayout layout1 = AknLayoutScalable_Avkon::power_save_pane();
   	TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::main_pane(2);
   	TAknWindowComponentLayout layout3 = AknLayoutScalable_Avkon::application_window(0);

   	return DoCompose(DoCompose(layout1, layout2), layout3).LayoutLine();
   	}

// LAF Table : Power save pane descendants
// C= H=48 W=348 b= l=2 r= t= 
// Remark                    : 
// Parent                    : power_save_pane
// Parent API                : power_save_pane
// Scale API match    ( 53%) : power_save_pane_g1
// Scale parent match (100%) : power_save_pane
TAknWindowLineLayout Power_save_pane_descendants_Line_1()
	{
  	return AknLayoutScalable_Avkon::power_save_pane().LayoutLine();
	}

// C=215 H=18 W=352 b= l=0 r= t=56 
// Remark                    : Idle state status indicators.
// Parent                    : power_save_pane
// Parent API                : power_save_pane
// Scale API match    ( 53%) : power_save_pane_g1
// Scale parent match (100%) : power_save_pane
TAknWindowLineLayout Power_save_pane_descendants_Line_2()
	{
  	return AknLayoutScalable_Avkon::indicator_ps_pane(0).LayoutLine();
	}

// C=215 H=24 W=346 b= l=0 r= t=52 
// Remark                    : Power save state specific status indicators.
// Parent                    : power_save_pane
// Parent API                : power_save_pane
// Scale API match    ( 53%) : power_save_pane_g1
// Scale parent match (100%) : power_save_pane
TAknWindowLineLayout Power_save_pane_descendants_Line_3()
	{
  	return AknLayoutScalable_Avkon::indicator_ps_pane(0).LayoutLine();
	}

/*
TAknLayoutTableLimits Power_save_pane_descendants_Limits();

TAknWindowLineLayout Power_save_pane_descendants(TInt aLineIndex);
*/

// LAF Table : Idle power save state texts
// B=36 C= Font=ELatinBold19_Scaled J=ELayoutAlignCenter W=332 l=12 r=8 
// Remark                    : Text shadow.
// Parent                    : power_save_pane
// Parent API                : power_save_pane
// Scale API match    ( 42%) : power_save_pane_t1
// Scale parent match (100%) : power_save_pane
TAknTextLineLayout Idle_power_save_state_texts_Line_1()
    {
    // NOT THERE (NEEDS CODE CHANGES)
    return EmptyTextLayout();
    }

// B=34 C=0 Font=ELatinBold19_Scaled J=ELayoutAlignCenter W=332 l=14 r=6 
// Remark                    : User text default text date time.
// Parent                    : power_save_pane
// Parent API                : power_save_pane
// Scale API match    ( 42%) : power_save_pane_t1
// Scale parent match (100%) : power_save_pane
TAknTextLineLayout Idle_power_save_state_texts_Line_2()
    {
  	return AknLayoutScalable_Avkon::power_save_pane_t1(0).LayoutLine();
    }

// B=72 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=338 l=10 r=4 
// Remark                    : Profile indication.
// Parent                    : power_save_pane
// Parent API                : power_save_pane
// Scale API match    ( 42%) : power_save_pane_t1
// Scale parent match (100%) : power_save_pane
TAknTextLineLayout Idle_power_save_state_texts_Line_3()
	{
    // old LAF spec comment is "Profile indication"
    // seems to match up with layout tool "Status Indicator Numerals"
    // [LMB 16/03/2005]
  	return AknLayoutScalable_Avkon::power_save_pane_t4(0).LayoutLine();
	}

// B=72 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignRight W= l=12 r=0 
// Remark                    : The number of items (i.e. missed calls or new messages).
// Parent                    : power_save_pane
// Parent API                : power_save_pane
// Scale API match    ( 42%) : power_save_pane_t1
// Scale parent match (100%) : power_save_pane
TAknTextLineLayout Idle_power_save_state_texts_Line_4()
    {
    return EmptyTextLayout();
    }


/*
TAknLayoutTableLimits Idle_power_save_state_texts_Limits();

TAknTextLineLayout Idle_power_save_state_texts(TInt aLineIndex);
*/

// LAF Table : Application selection grid elements
// C= H=282 W=348 b= l=2 r= t=2 
// Remark                    : Application selection grid.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : grid_app_pane
// Scale parent match (100%) : main_pane
TAknWindowLineLayout grid_app_pane()
    {
    // 0 = normal, 1 = 3x4
    // not enough info here to choose
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Avkon::listscroll_app_pane(0);
    
    TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::grid_app_pane(varietyIndex);
    
    return DoCompose(layout1, layout2).LayoutLine();
    }

// LAF Table : Empty list texts
// B={88, 130} C=215 Font=ELatinBold13_Scaled J=ELayoutAlignCenter W=300 l=28 r=24 
// Remark                    : Textual no list content indication. Max. two lines of text.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 53%) : main_list_empty_pane
// Scale parent match (100%) : main_pane
TAknTextLineLayout Empty_list_texts_Line_1(TInt aIndex_B)
	{
   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::main_list_empty_pane();
   	TAknTextComponentLayout l3;
   	if (aIndex_B == 0) 
		{ 
		l3 = AknLayoutScalable_Avkon::main_pane_empty_t1(0);
		}
   	else 
		{
		l3 = AknLayoutScalable_Avkon::main_pane_empty_t2(0);
	   }
   	TAknTextComponentLayout l4 = DoComposeText(l2, l3);
   	return l4.LayoutLine();
	}

/*
TAknMultiLineTextLayout Multiline_Empty_list_texts_Line_1(TInt aNumberOfLinesShown)
*/

// LAF Table : Empty list texts (find)
// B={88, 130} C=215 Font=ELatinBold13_Scaled J=ELayoutAlignCenter W=252 l=52 r=48 
// Remark                    : Textual no list content indication. Max. two lines of text.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 32%) : main_list_empty_pane
// Scale parent match (100%) : main_pane
TAknTextLineLayout Empty_list_texts__find__Line_1(TInt aIndex_B)
	{
   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::main_list_empty_pane();
   	TAknTextComponentLayout l3;
   	if (aIndex_B == 0) 
		{ 
		l3 = AknLayoutScalable_Avkon::main_pane_empty_t1(1);
		}
   	else 
		{
		l3 = AknLayoutScalable_Avkon::main_pane_empty_t2(1);
	   }
   	return DoComposeText(l2, l3).LayoutLine();
	}

/*
TAknMultiLineTextLayout Multiline_Empty_list_texts__find__Line_1(TInt aNumberOfLinesShown);
*/

// LAF Table : List pane elements and descendants (settings edited)
// NOT FOUND // settings_editing + set_content_pane + list_highlight_pane_cp2
// NOT FOUND // settings_editing + main_pane_cp1 + list_highlight_pane_cp2
TAknWindowLineLayout List_pane_elements_and_descendants__settings_edited__Line_1()
	{
    return EmptyWindowLayout();
	}
	
// C=244 H=262 W=346 b= l=2 r= t=12 
// Remark                    : Highlight.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 26%) : list_setting_pane_g_Limits
// Scale parent match (100%) : main_pane
TAknWindowLineLayout List_pane_elements_and_descendants__settings_edited__Line_2()
	{
   	TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::set_content_pane();
   	TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_highlight_pane_cp2();
    return DoCompose(l2, l3).LayoutLine();
	}
	
// set_content_pane + list_highlight_pane_cp2
// settings_editing + main_pane_cp1 + list_highlight_pane_cp2

// C= H={34, 68, 102, 136, 178, 212}[aCommon1] W=264 b= l=80 r= t={160, 160, 126, 92, 92, 58}[aCommon1] 
// Remark                    : Setting value items.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : list_set_pane
// Scale parent match (100%) : main_pane
TAknWindowLineLayout list_set_pane(TInt aCommon1)
    {
    TInt varietyNumber = aCommon1;
    if (varietyNumber < 0)
        {
        varietyNumber = 0;
        }

    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_set_pane(); // pos of 
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::set_content_pane();
    TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::list_set_pane(varietyNumber); // scrollbar shown
    return DoCompose(l1, DoCompose(l2,l3)).LayoutLine();
    }

// C=0 H=8 W=264 b= l=80 r= t=262 
// Remark                    : Area extension.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 26%) : list_setting_pane_g_Limits
// Scale parent match (100%) : main_pane
TAknWindowLineLayout List_pane_elements_and_descendants__settings_edited__Line_4()
	{
	// NOT FOUND
	return EmptyWindowLayout();
	}

// C= H=212 W=264 b= l=80 r= t=58 
// Remark                    : Volume strength adjustment.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : setting_volume_pane
// Scale parent match (100%) : main_pane
TAknWindowLineLayout setting_volume_pane()
    {
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::set_content_pane();
    TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::setting_volume_pane();
    return DoCompose(l2, l3).LayoutLine();
    }

// C= H=212 W=264 b= l=80 r= t=58 
// Remark                    : Slider adjustment.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : setting_slider_pane
// Scale parent match (100%) : main_pane
TAknWindowLineLayout setting_slider_pane()
    {
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::set_content_pane();
    TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::setting_slider_pane();
    return DoCompose(l2, l3).LayoutLine();
    }

// C= H=212 W=264 b= l=80 r= t=58 
// Remark                    : Contrast adjustment.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : setting_slider_graphic_pane
// Scale parent match (100%) : main_pane
TAknWindowLineLayout setting_slider_graphic_pane()
    {
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::set_content_pane();
    TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::setting_slider_graphic_pane();
    return DoCompose(l2, l3).LayoutLine();
    }

// C= H=212 W=264 b= l=80 r= t=58 
// Remark                    : Text entry field.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : setting_text_pane
// Scale parent match (100%) : main_pane
TAknWindowLineLayout setting_text_pane()
    {
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::set_content_pane();
    TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::setting_text_pane();
    return DoCompose(l2, l3).LayoutLine();
    }

// C= H=42 W=264 b= l=80 r= t=154 
// Remark                    : Code time and date entry field.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : setting_code_pane
// Scale parent match (100%) : main_pane
TAknWindowLineLayout setting_code_pane()
    {
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::set_content_pane();
    TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::setting_code_pane();
    return DoCompose(l2, l3).LayoutLine();
    }

// LAF Table : Setting item texts
// B=42 C=215 Font=ELatinBold12_Scaled J=ELayoutAlignCenter W=28 l=6 r=318 
// Remark                    : Ordinal numbers.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 52%) : setting_text_pane
// Scale parent match (100%) : main_pane
TAknTextLineLayout Setting_item_texts_Line_1()
    {
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_set_pane();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::set_content_pane();
    TAknTextComponentLayout l3 = AknLayoutScalable_Avkon::main_pane_set_t2(0);
    return DoComposeText(DoCompose(l1, l2), l3).LayoutLine();
    }

// B=42 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={290, 316}[aCommon1] l={52, 26}[aCommon1] r=10 
// Remark                    : Setting item title.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 52%) : setting_text_pane
// Scale parent match (100%) : main_pane
TAknTextLineLayout Setting_item_texts_Line_2(TInt aCommon1)
    {
    TInt variety = 1;
    if (aCommon1 == 1) 
        {
        variety = 0;
        }

    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_set_pane();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::set_content_pane();
    TAknTextComponentLayout l3 = AknLayoutScalable_Avkon::main_pane_set_t1(variety);
    return DoComposeText(DoCompose(l1, l2), l3).LayoutLine();
    }


// LAF Table : Setting volume pane elements
// C=0 H=212 W=264 b= l=0 r= t=0 
// Remark                    : Background graphics.
// Parent                    : setting_volume_pane
// Parent API                : setting_volume_pane
// Scale API match    ( 62%) : setting_volume_pane
// Scale parent match (100%) : setting_volume_pane
TAknWindowLineLayout Setting_volume_pane_elements_Line_1()
	{
	// JH: IMPLEMENTED 16.12.2005
	TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::setting_volume_pane();
	return layout.LayoutLine();
	}

// C={244, 243} H=14 W=12 b= l=54 r= t=166 
// Remark                    : 1. volume strength indicator.
// Parent                    : setting_volume_pane
// Parent API                : setting_volume_pane
// Scale API match    ( 62%) : setting_volume_pane
// Scale parent match (100%) : setting_volume_pane
TAknWindowLineLayout Setting_volume_pane_elements_Line_2(TInt /*aIndex_C*/)
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::volume_set_pane();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::volume_set_pane_g1();
    return DoCompose(layout, l2).LayoutLine();
    }

// C={244, 243} H=28 W=12 b= l=70 r= t=152 
// Remark                    : 2. volume strength indicator.
// Parent                    : setting_volume_pane
// Parent API                : setting_volume_pane
// Scale API match    ( 62%) : setting_volume_pane
// Scale parent match (100%) : setting_volume_pane
TAknWindowLineLayout Setting_volume_pane_elements_Line_3(TInt /*aIndex_C*/)
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::volume_set_pane();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::volume_set_pane_g2();
    return DoCompose(layout, l2).LayoutLine();
    }

// C={244, 243} H=42 W=12 b= l=86 r= t=138 
// Remark                    : 3. volume strength indicator.
// Parent                    : setting_volume_pane
// Parent API                : setting_volume_pane
// Scale API match    ( 62%) : setting_volume_pane
// Scale parent match (100%) : setting_volume_pane
TAknWindowLineLayout Setting_volume_pane_elements_Line_4(TInt /*aIndex_C*/)
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::volume_set_pane();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::volume_set_pane_g3();
    return DoCompose(layout, l2).LayoutLine();
    }

// C={244, 243} H=56 W=12 b= l=102 r= t=124 
// Remark                    : 4. volume strength indicator.
// Parent                    : setting_volume_pane
// Parent API                : setting_volume_pane
// Scale API match    ( 62%) : setting_volume_pane
// Scale parent match (100%) : setting_volume_pane
TAknWindowLineLayout Setting_volume_pane_elements_Line_5(TInt /*aIndex_C*/)
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::volume_set_pane();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::volume_set_pane_g4();
    return DoCompose(layout, l2).LayoutLine();
    }

// C={244, 243} H=70 W=12 b= l=118 r= t=110 
// Remark                    : 5. volume strength indicator.
// Parent                    : setting_volume_pane
// Parent API                : setting_volume_pane
// Scale API match    ( 62%) : setting_volume_pane
// Scale parent match (100%) : setting_volume_pane
TAknWindowLineLayout Setting_volume_pane_elements_Line_6(TInt /*aIndex_C*/)
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::volume_set_pane();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::volume_set_pane_g5();
    return DoCompose(layout, l2).LayoutLine();
    }

// C={244, 243} H=84 W=12 b= l=134 r= t=96 
// Remark                    : 6. volume strength indicator.
// Parent                    : setting_volume_pane
// Parent API                : setting_volume_pane
// Scale API match    ( 62%) : setting_volume_pane
// Scale parent match (100%) : setting_volume_pane
TAknWindowLineLayout Setting_volume_pane_elements_Line_7(TInt /*aIndex_C*/)
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::volume_set_pane();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::volume_set_pane_g6();
    return DoCompose(layout, l2).LayoutLine();
    }

// C={244, 243} H=98 W=12 b= l=150 r= t=82 
// Remark                    : 7. volume strength indicator.
// Parent                    : setting_volume_pane
// Parent API                : setting_volume_pane
// Scale API match    ( 62%) : setting_volume_pane
// Scale parent match (100%) : setting_volume_pane
TAknWindowLineLayout Setting_volume_pane_elements_Line_8(TInt /*aIndex_C*/)
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::volume_set_pane();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::volume_set_pane_g7();
    return DoCompose(layout, l2).LayoutLine();
    }

// C={244, 243} H=112 W=12 b= l=166 r= t=68 
// Remark                    : 8. volume strength indicator.
// Parent                    : setting_volume_pane
// Parent API                : setting_volume_pane
// Scale API match    ( 62%) : setting_volume_pane
// Scale parent match (100%) : setting_volume_pane
TAknWindowLineLayout Setting_volume_pane_elements_Line_9(TInt /*aIndex_C*/)
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::volume_set_pane();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::volume_set_pane_g8();
    return DoCompose(layout, l2).LayoutLine();
    }

// C={244, 243} H=126 W=12 b= l=182 r= t=54 
// Remark                    : 9. volume strength indicator.
// Parent                    : setting_volume_pane
// Parent API                : setting_volume_pane
// Scale API match    ( 60%) : setting_volume_pane
// Scale parent match (100%) : setting_volume_pane
TAknWindowLineLayout Setting_volume_pane_elements_Line_10(TInt /*aIndex_C*/)
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::volume_set_pane();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::volume_set_pane_g9();
    return DoCompose(layout, l2).LayoutLine();
    }

// C={244, 243} H=140 W=12 b= l=198 r= t=40 
// Remark                    : 10. volume strength indicator.
// Parent                    : setting_volume_pane
// Parent API                : setting_volume_pane
// Scale API match    ( 60%) : setting_volume_pane
// Scale parent match (100%) : setting_volume_pane
TAknWindowLineLayout Setting_volume_pane_elements_Line_11(TInt /*aIndex_C*/)
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::volume_set_pane();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::volume_set_pane_g10();
    return DoCompose(layout, l2).LayoutLine();
    }

/*
TAknLayoutTableLimits Setting_volume_pane_elements_SUB_TABLE_0_Limits();

TAknWindowLineLayout Setting_volume_pane_elements_SUB_TABLE_0(TInt aLineIndex, TInt aIndex_C);
*/

// LAF Table : Setting slider pane elements and descendants
// C=0 H=212 W=264 b= l=0 r= t=0 
// Remark                    : Background graphics.
// Parent                    : setting_slider_pane
// Parent API                : setting_slider_pane
// Scale API match    ( 41%) : setting_slider_pane_t1
// Scale parent match (100%) : setting_slider_pane
TAknWindowLineLayout Setting_slider_pane_elements_and_descendants_Line_1()
	{
	TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::bg_set_opt_pane_cp();
	return layout.LayoutLine();
	}

// C= H=22 W=236 b= l=14 r= t=124 
// Remark                    : Slider graphics.
// Parent                    : setting_slider_pane
// Parent API                : setting_slider_pane
// Scale API match    ( 41%) : setting_slider_pane_t1
// Scale parent match (100%) : setting_slider_pane
TAknWindowLineLayout Setting_slider_pane_elements_and_descendants_Line_2()
	{
	TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::slider_set_pane();
	return layout.LayoutLine();
	}

/*
TAknLayoutTableLimits Setting_slider_pane_elements_and_descendants_Limits();

TAknWindowLineLayout Setting_slider_pane_elements_and_descendants(TInt aLineIndex);
*/

// LAF Table : Slider pane elements
// C=215 H=2 W=232 b= l=2 r= t=10 
// Remark                    : Slider bar.
// Parent                    : slider_set_pane
// Parent API                : Setting_slider_elements_Line_1
// Scale API match    ( 52%) : setting_slider_pane_t1
// Scale parent match ( 59%) : setting_slider_graphic_pane
TAknWindowLineLayout Slider_pane_elements_Line_1()
	{
	TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::slider_set_pane_g1();
	return layout.LayoutLine();
	}

// C= H=22 W=22 b= l= r= t=0 
// Remark                    : Current slider value indication.
// Parent                    : slider_set_pane
// Parent API                : Setting_slider_elements_Line_1
// Scale API match    ( 52%) : setting_slider_pane_t1
// Scale parent match ( 59%) : setting_slider_graphic_pane
TAknWindowLineLayout Slider_pane_elements_Line_2()
	{
	TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::slider_set_pane_g2();
	return layout.LayoutLine();
	}
	
/*
TAknLayoutTableLimits Slider_pane_elements_Limits();

TAknWindowLineLayout Slider_pane_elements(TInt aLineIndex);
*/

// LAF Table : Slider texts (set)
// B=52 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=180 l=36 r=16 
// Remark                    : Slider value.
// Parent                    : slider_set_pane
// Parent API                : Setting_slider_elements_Line_1
// Scale API match    ( 43%) : slider_set_pane_g_Limits
// Scale parent match ( 59%) : setting_slider_graphic_pane
TAknTextLineLayout Slider_texts__set__Line_1()
	{
	// JH: IMPLEMENTED 16.12.2005
	TAknTextComponentLayout layout = AknLayoutScalable_Avkon::setting_slider_pane_t1();
	return layout.LayoutLine();
	}

// B={172, 172}[aCommon1] C=215 Font=ELatinBold12_Scaled J={ELayoutAlignLeft, ELayoutAlignRight}[aCommon1] W={114, 114}[aCommon1] l={16, 136}[aCommon1] r={134, 14}[aCommon1] 
// Remark                    : Slider minimum value. Slider maximum value.
// Parent                    : slider_set_pane
// Parent API                : Setting_slider_elements_Line_1
// Scale API match    ( 43%) : slider_set_pane_g_Limits
// Scale parent match ( 59%) : setting_slider_graphic_pane
TAknTextLineLayout Slider_texts__set__Line_2(TInt /*aCommon1*/)
	{
	return EmptyTextLayout();
	/*
	let a = setting_slider_pane + (setting_slider_pane_t1 & setting_slider_pane_t2)
  	let b = listscroll_set_pane + list_set_pane
  	let c = DoIntersect(a,b);
  	let d = c - b;
  	return d;
  	*/
	}

/*
TAknMultiLineTextLayout Multiline_Slider_texts__set__Line_2(TInt aCommon1, TInt aNumberOfLinesShown);
*/

// LAF Table : Setting slider pane (graphic) elements and descendants
// C=0 H=212 W=264 b= l=0 r= t=0 
// Remark                    : Background graphics.
// Parent                    : setting_slider_pane
// Parent API                : setting_slider_pane
// Scale API match    ( 45%) : setting_slider_graphic_pane_g1
// Scale parent match (100%) : setting_slider_pane
TAknWindowLineLayout Setting_slider_pane__graphic__elements_and_descendants_Line_1()
	{
	TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::bg_set_opt_pane_cp2();
	return layout.LayoutLine();
	}

// C= H=136 W=264 b= l=0 r= t=0 
// Remark                    : Contrast control image.
// Parent                    : setting_slider_pane
// Parent API                : setting_slider_pane
// Scale API match    ( 45%) : setting_slider_graphic_pane_g1
// Scale parent match (100%) : setting_slider_pane
TAknWindowLineLayout Setting_slider_pane__graphic__elements_and_descendants_Line_2()
	{
	TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::setting_slider_graphic_pane_g1();
	return layout.LayoutLine();
	}

// C= H=22 W=236 b= l=14 r= t=152 
// Remark                    : Slider graphics.
// Parent                    : setting_slider_pane
// Parent API                : setting_slider_pane
// Scale API match    ( 45%) : setting_slider_graphic_pane_g1
// Scale parent match (100%) : setting_slider_pane
TAknWindowLineLayout Setting_slider_pane__graphic__elements_and_descendants_Line_3()
	{
	TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::slider_set_pane_cp();
	return layout.LayoutLine();
	}

/*
TAknLayoutTableLimits Setting_slider_pane__graphic__elements_and_descendants_Limits();

TAknWindowLineLayout Setting_slider_pane__graphic__elements_and_descendants(TInt aLineIndex);
*/

// LAF Table : Slider with graphic texts (set)
// B={202, 202}[aCommon1] C=215 Font=ELatinBold12_Scaled J={ELayoutAlignLeft, ELayoutAlignRight}[aCommon1] W={116, 116}[aCommon1] l={14, 136}[aCommon1] r={134, 12}[aCommon1] 
// Remark                    : Slider minimum value. Slider maximum value.
// Parent                    : slider_set_pane
// Parent API                : Setting_slider_elements_Line_1
// Scale API match    ( 41%) : setting_slider_graphic_pane_t_Limits
// Scale parent match ( 59%) : setting_slider_graphic_pane
TAknTextLineLayout Slider_with_graphic_texts__set__Line_1(TInt /*aCommon1*/)
	{
	return EmptyTextLayout();
	/*
	let a = setting_slider_pane + (setting_slider_graphic_pane_t1 & setting_slider_graphic_pane_t2)
  	let b = listscroll_set_pane + list_set_pane
  	let c = DoIntersect(a,b);
  	let d = c - b;
  	return d;
  	*/
	}

/*
TAknMultiLineTextLayout Multiline_Slider_with_graphic_texts__set__Line_1(TInt aCommon1, TInt aNumberOfLinesShown);
*/

// LAF Table : Setting text pane elements
// C=221 H=2 W=260 b= l=2 r= t=2 
// Remark                    : Horizontal shadow line.
// Parent                    : setting_text_pane
// Parent API                : setting_text_pane
// Scale API match    ( 64%) : setting_text_pane_g1
// Scale parent match (100%) : setting_text_pane
TAknWindowLineLayout Setting_text_pane_elements_Line_1()
	{
	// NOT THERE
	return EmptyWindowLayout();
	}

// C=221 H=206 W=2 b= l=2 r= t=4 
// Remark                    : Vertical shadow line.
// Parent                    : setting_text_pane
// Parent API                : setting_text_pane
// Scale API match    ( 64%) : setting_text_pane_g1
// Scale parent match (100%) : setting_text_pane
TAknWindowLineLayout Setting_text_pane_elements_Line_2()
	{
	// NOT THERE
	return EmptyWindowLayout();
	}

// C=215 H=212 W=264 b= l=0 r= t=0 
// Remark                    : Outline frame.
// Parent                    : setting_text_pane
// Parent API                : setting_text_pane
// Scale API match    ( 64%) : setting_text_pane_g1
// Scale parent match (100%) : setting_text_pane
TAknWindowLineLayout Setting_text_pane_elements_Line_3()
	{
	// JH: IMPLEMENTED 2.1.2006
	TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::setting_text_pane();
	return layout.LayoutLine();
	}

// C=215 H=28 W=2 b=6 l= r= t= 
// Remark                    : Cursor graphics for 12 pixel text.
// Parent                    : setting_text_pane
// Parent API                : setting_text_pane
// Scale API match    ( 64%) : setting_text_pane_g1
// Scale parent match (100%) : setting_text_pane
TAknWindowLineLayout Setting_text_pane_elements_Line_4()
	{
	// NOT THERE
	return EmptyWindowLayout();
	}

/*
TAknLayoutTableLimits Setting_text_pane_elements_Limits()

TAknWindowLineLayout Setting_text_pane_elements(TInt aLineIndex)
*/

// LAF Table : Setting text pane texts
// B={30, 62, 94, 126, 158, 190} C=215 Font=ELatinBold12_Scaled J={ELayoutAlignLeft, ELayoutAlignCenter} W=244 l=12 r=8 
// Remark                    : Entry text.
// Parent                    : setting_text_pane
// Parent API                : setting_text_pane
// Scale API match    ( 86%) : setting_text_pane_g1
// Scale parent match (100%) : setting_text_pane
TAknTextLineLayout Setting_text_pane_texts_Line_1(TInt aIndex_B, TInt /*aIndex_J*/)
	{
	// JH: IMPLEMENTED 2.1.2006
	__ASSERT_ALWAYS(0 <= aIndex_B && aIndex_B <= 5, Panic(EParamsOutsideKnownRange));
	TAknWindowComponentLayout layout1 = AknLayoutScalable_Avkon::list_set_text_pane();
	TAknTextComponentLayout layout2 = AknLayoutScalable_Avkon::set_text_pane_t1(aIndex_B);
	return DoComposeText(layout1, layout2).LayoutLine();
	}

/*
TAknMultiLineTextLayout Multiline_Setting_text_pane_texts_Line_1(TInt aIndex_J, TInt aNumberOfLinesShown)
*/

// LAF Table : Code time and date entry pane elements
// C=221 H=2 W=260 b= l=2 r= t=2 
// Remark                    : Horizontal shadow line.
// Parent                    : setting_code_pane
// Parent API                : setting_code_pane
// Scale API match    ( 29%) : fep_china_uni_entry_pane_g1
// Scale parent match (100%) : setting_code_pane
TAknWindowLineLayout Code_time_and_date_entry_pane_elements_Line_1()
	{
	// NOT FOUND, horiz shadow line
	return EmptyWindowLayout();
	}

// C=221 H=36 W=2 b= l=2 r= t=4 
// Remark                    : Vertical shadow line.
// Parent                    : setting_code_pane
// Parent API                : setting_code_pane
// Scale API match    ( 29%) : fep_china_uni_entry_pane_g1
// Scale parent match (100%) : setting_code_pane
TAknWindowLineLayout Code_time_and_date_entry_pane_elements_Line_2()
	{
	// not found, vertical shadow
	return EmptyWindowLayout();
	}

// C=215 H=42 W=264 b= l=0 r= t=0 
// Remark                    : Outline frame.
// Parent                    : setting_code_pane
// Parent API                : setting_code_pane
// Scale API match    ( 29%) : fep_china_uni_entry_pane_g1
// Scale parent match (100%) : setting_code_pane
TAknWindowLineLayout Code_time_and_date_entry_pane_elements_Line_3()
	{
	// not found, outline rectangle
	return EmptyWindowLayout();
	}

/*
TAknLayoutTableLimits Code_time_and_date_entry_pane_elements_Limits()

TAknWindowLineLayout Code_time_and_date_entry_pane_elements(TInt aLineIndex)
*/

// LAF Table : Code time and date entry pane texts
// B=30 C=215 Font=ELatinBold12_Scaled J=ELayoutAlignCenter W=244 l=12 r=8 
// Remark                    : Code time and date entry.
// Parent                    : setting_text_pane
// Parent API                : setting_text_pane
// Scale API match    ( 32%) : fep_entry_item_pane_t1_ParamLimits
// Scale parent match (100%) : setting_text_pane
TAknTextLineLayout Code_time_and_date_entry_pane_texts_Line_1()
	{
	TAknTextComponentLayout layout = AknLayoutScalable_Avkon::setting_code_pane_t1();
	return layout.LayoutLine();
	}

// LAF Table : Control pane elements
// C= H=20 W=18 b= l=168 r= t=0 
// Remark                    : Up scrolling indicator.
// Parent                    : control_pane
// Parent API                : control_pane
// Scale API match    ( 55%) : control_pane_g1_ParamLimits
// Scale parent match (100%) : control_pane
TAknWindowLineLayout Control_pane_elements_Line_1()
	{
	// Arrowhead scrolling indicator is no longer in the LAF, so this hack
	// is needed in case it is still used somewhere.
	TAknWindowComponentLayout parent = AknLayoutScalable_Avkon::area_bottom_pane(0);
	TAknWindowComponentLayout widthHeightLayout = AknLayoutScalable_Avkon::application_window(0);
	TAknWindowComponentLayout layout = parent;
	TAknWindowComponentLayout::ScrollIndicatorHack( widthHeightLayout, parent, layout, 0 );
	return layout.LayoutLine();
	}

// C= H=20 W=18 b= l=168 r= t=20 
// Remark                    : Down scrolling indicator.
// Parent                    : control_pane
// Parent API                : control_pane
// Scale API match    ( 55%) : control_pane_g1_ParamLimits
// Scale parent match (100%) : control_pane
TAknWindowLineLayout Control_pane_elements_Line_2()
	{
	// Arrowhead scrolling indicator is no longer in the LAF, so this hack
	// is needed in case it is still used somewhere.
	TAknWindowComponentLayout parent = AknLayoutScalable_Avkon::area_bottom_pane(0);
	TAknWindowComponentLayout widthHeightLayout = AknLayoutScalable_Avkon::application_window(0);
	TAknWindowComponentLayout layout = parent;
	TAknWindowComponentLayout::ScrollIndicatorHack( widthHeightLayout, parent, layout, 1 );
	return layout.LayoutLine();
	}

// C= H=34 W=160 b= l=2 r= t=4 
// Remark                    : left softkey bitmap
// Parent                    : control_pane
// Parent API                : control_pane
// Scale API match    ( 55%) : control_pane_g1_ParamLimits
// Scale parent match (100%) : control_pane
TAknWindowLineLayout Control_pane_elements_Line_3()
	{
	// MAN: added landscape variety
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 2 : 1;
	TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::control_pane_g1(varietyIndex);
	return layout.LayoutLine();
	}

// C= H=34 W=160 b= l=190 r= t=4 
// Remark                    : right softkey bitmap
// Parent                    : control_pane
// Parent API                : control_pane
// Scale API match    ( 55%) : control_pane_g1_ParamLimits
// Scale parent match (100%) : control_pane
TAknWindowLineLayout Control_pane_elements_Line_4()
	{
	// MAN: added landscape variety
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 2 : 1;
	TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::control_pane_g2(varietyIndex);
	return layout.LayoutLine();
	}
	
/*
TAknLayoutTableLimits Control_pane_elements_Limits();
*/

TAknWindowLineLayout Control_pane_elements(TInt aLineIndex)
    {
    if (aLineIndex == 0)
    	{
    	return Control_pane_elements_Line_1();
    	}
    else if (aLineIndex == 1)
    	{
    	return Control_pane_elements_Line_2();
    	}
    	
	return EmptyWindowLayout();
    }

// LAF Table : Control pane texts
// B=30 C=215 Font=ELatinBold17_Scaled J=ELayoutAlignLeft W=160 l=4 r=188 
// Remark                    : Left softkey text.
// Parent                    : control_pane
// Parent API                : control_pane
// Scale API match    ( 70%) : control_pane_t1_ParamLimits
// Scale parent match (100%) : control_pane
TAknTextLineLayout Control_pane_texts_Line_1()
	{
	// MAN: added landscape variety
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 2 : 0;
	TAknTextComponentLayout layout = AknLayoutScalable_Avkon::control_pane_t1(varietyIndex);
	return layout.LayoutLine();
	}

// B=30 C=215 Font=ELatinBold17_Scaled J=ELayoutAlignRight W=160 l=192 r=0 
// Remark                    : Right softkey text.
// Parent                    : control_pane
// Parent API                : control_pane
// Scale API match    ( 70%) : control_pane_t1_ParamLimits
// Scale parent match (100%) : control_pane
TAknTextLineLayout Control_pane_texts_Line_2()
	{
	// MAN: added landscape variety
	TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 2 : 0;
	TAknTextComponentLayout layout = AknLayoutScalable_Avkon::control_pane_t2(varietyIndex);
	return layout.LayoutLine();
	}
	
/*
TAknLayoutTableLimits Control_pane_texts_Limits();

TAknTextLineLayout Control_pane_texts(TInt aLineIndex);
*/

// LAF Table : Pop-up windows (main pane as parent)
// C= H={68, 108, 148, 188, 228, 268} W=352 b=0 l= r=0 t= 
// Remark                    : Optionsmenu. p_height_popup_menu_window
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : popup_menu_window
// Scale parent match (100%) : main_pane
TAknWindowLineLayout popup_menu_window(TInt aIndex_H)
    {
    __ASSERT_ALWAYS(0 <= aIndex_H && aIndex_H <= 5, Panic(EParamsOutsideKnownRange));

	// type 			variety
	// double 1			0 
	// double 2			1
	// double 3			2
	//
	// single large 1	4
	// single large 2	5
	// single large 3	6
	// single large 4	7
	// single 1				8
	// single 2				9
	// single 3				10	
	// single 4				11
	// single 5				12
	// single 6				13

    TInt varietyIndex = 8 + aIndex_H;
    return AknLayoutScalable_Avkon::popup_menu_window(varietyIndex).LayoutLine();
    }

// C= H={54, 90, 126, 162, 198, 234}[aCommon1] W={88, 130, 172, 214, 256, 298}[aCommon1] b= l= r= t= 
// Remark                    : Options submenu p_height_popup_submenu_window.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 36%) : bg_popup_window_pane_ParamLimits
// Scale parent match (100%) : main_pane
TAknWindowLineLayout Pop_up_windows__main_pane_as_parent__Line_2(TInt aCommon1)
    {
    __ASSERT_ALWAYS(0 <= aCommon1 && aCommon1 <= 5, Panic(EParamsOutsideKnownRange));

    TInt varietyIndex;
	switch(aCommon1)
		{
		case 4:
			// there is no option corresponding to 5 list items
			varietyIndex = 4; // this index gives the wrong value, but it is the best we can do
			break;
		case 5:
			varietyIndex = 4; // this is the wrong index due to error in layout, but it gives the correct value
			break;
		default:
			varietyIndex = aCommon1;
			break;
		}

    return AknLayoutScalable_Avkon::popup_submenu_window(varietyIndex).LayoutLine();
	/*
    TInt option = 0;
    if (aCommon1 == 0) { option = 5; }
    else if (aCommon1 == 1) { option = 4; }
    else if (aCommon1 == 2) { option = 3; }
    else if (aCommon1 == 3) { option = 2; }
    else if (aCommon1 == 4) { option = 1; }
    
    return AknLayoutScalable_Avkon::popup_submenu_window(option).LayoutLine();
	*/
    }

// C= H={68, 108, 148, 188, 228, 268} W=352 b=0 l= r=0 t= 
// Remark                    : Single item with a graphic menu. p_height_popup_menu_graphic_window
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 73%) : popup_grid_graphic_window_ParamLimits
// Scale parent match (100%) : main_pane
TAknWindowLineLayout popup_menu_graphic_window(TInt aIndex_H)
    {
    __ASSERT_ALWAYS(0 <= aIndex_H && aIndex_H <= 5, Panic(EParamsOutsideKnownRange));

	// type 			variety
	// double 1			0 
	// double 2			1
	// double 3			2
	//
	// single large 1	4
	// single large 2	5
	// single large 3	6
	// single large 4	7
	// single 1				8
	// single 2				9
	// single 3				10	
	// single 4				11
	// single 5				12
	// single 6				13

    TInt varietyIndex = 8 + aIndex_H;
    return AknLayoutScalable_Avkon::popup_menu_window(varietyIndex).LayoutLine();
    }

// C= H={68, 108, 148, 188, 228, 268} W=352 b=0 l= r=0 t= 
// Remark                    : Single item with a graphic and a heading menu. p_height_popup_menu_graphic_heading_window
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 54%) : popup_snote_single_graphic_window_ParamLimits
// Scale parent match (100%) : main_pane
TAknWindowLineLayout popup_menu_graphic_heading_window(TInt aIndex_H)
    {
    __ASSERT_ALWAYS(0 <= aIndex_H && aIndex_H <= 5, Panic(EParamsOutsideKnownRange));

	// type 			variety
	// double 1			0 
	// double 2			1
	// double 3			2
	//
	// single large 1	4
	// single large 2	5
	// single large 3	6
	// single large 4	7
	// single 1				8
	// single 2				9
	// single 3				10	
	// single 4				11
	// single 5				12
	// single 6				13

    TInt varietyIndex = 8 + aIndex_H;
    return AknLayoutScalable_Avkon::popup_menu_window(varietyIndex).LayoutLine();
    }

// C= H={102, 176, 250} W=352 b=0 l= r=0 t= 
// Remark                    : Double item menu. p_height_popup_menu_double_window
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 63%) : popup_menu_window_ParamLimits
// Scale parent match (100%) : main_pane
TAknWindowLineLayout popup_menu_double_window(TInt aIndex_H)
    {
    return AknLayoutScalable_Avkon::popup_menu_window(aIndex_H).LayoutLine();
    }


// C= H={102, 176, 250} W=352 b=0 l= r=0 t= 
// Remark                    : Double item with a large graphic menu. p_height_popup_menu_doublelarge_graphic_window
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 61%) : popup_large_graphic_colour_window
// Scale parent match (100%) : main_pane
TAknWindowLineLayout popup_menu_double_large_graphic_window(TInt aIndex_H)
    {
    return AknLayoutScalable_Avkon::popup_menu_window(aIndex_H).LayoutLine();
    }

// C= H={156, 190, 226} W=352 b=0 l= r=0 t= 
// Remark                    : General note indication. p_height_popup_note_window
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : popup_note_window
// Scale parent match (100%) : main_pane
TAknWindowLineLayout popup_note_window(TInt aIndex_H)
    {
    return AknLayoutScalable_Avkon::popup_note_window(aIndex_H).LayoutLine();
    }

// C= H={156, 190, 226} W=352 b=0 l= r=0 t= 
// Remark                    : Wait and Progress note indication. p_height_popup_note_window
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : popup_note_wait_window
// Scale parent match (100%) : main_pane
TAknWindowLineLayout popup_note_wait_window(TInt aIndex_H)
    {
    return AknLayoutScalable_Avkon::popup_note_wait_window(aIndex_H).LayoutLine();
    }

// C= H=156 W=352 b=0 l= r=0 t= 
// Remark                    : Note with a thumbnail image indication.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : popup_note_image_window
// Scale parent match (100%) : main_pane
TAknWindowLineLayout popup_note_image_window()
    {
    return AknLayoutScalable_Avkon::popup_note_image_window().LayoutLine();
    }


// C= H={156, 190, 192, 226, 228, 230, 262, 264, 298, 300, 336} W=352 b=0 l= r=0 t= 
// Remark                    : Alphanumeric query p_height_popup_query_data_window.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : popup_query_data_window
// Scale parent match (100%) : main_pane
TAknWindowLineLayout popup_query_data_window(TInt aIndex_H)
    {
    TInt option = 6; // 8 lines   aIndex_H == 11
    if (aIndex_H == 0) option = 0; // 2 lines
    else if (aIndex_H == 1 || (aIndex_H == 2))  option = 1; // 3 lines
    else if (aIndex_H == 3 || aIndex_H == 4 || aIndex_H == 5) option = 2; // 4 lines
    else if (aIndex_H == 6 || aIndex_H == 7) option = 3; // 5 lines
    else if (aIndex_H == 8 || aIndex_H == 9) option = 4; // 6 lines 
    else if (aIndex_H == 10) option = 5; // 7 lines

    return AknLayoutScalable_Avkon::popup_query_data_window(option).LayoutLine();
    }

// C= H={156, 192, 230} W=352 b=0 l= r=0 t= 
// Remark                    : Code query. p_height_popup_query_code_window
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : popup_query_code_window
// Scale parent match (100%) : main_pane
TAknWindowLineLayout popup_query_code_window(TInt aIndex_H)
    {
    return AknLayoutScalable_Avkon::popup_query_code_window(aIndex_H).LayoutLine();
    }

// C= H={156, 192, 230} W=352 b=0 l= r=0 t= 
// Remark                    : Time query. p_height_popup_query_code_window
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 76%) : popup_query_code_window_ParamLimits
// Scale parent match (100%) : main_pane

TAknWindowLineLayout popup_query_time_window(TInt aIndex_H)
    {

    return popup_query_code_window(aIndex_H);
    }

// C= H={156, 192, 230} W=352 b=0 l= r=0 t= 
// Remark                    : Date query. p_height_popup_query_code_window
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 90%) : popup_query_data_code_window_ParamLimits
// Scale parent match (100%) : main_pane
TAknWindowLineLayout popup_query_date_window(TInt aIndex_H)
    {
    return popup_query_code_window(aIndex_H);
    }


// C= H={290, 328, 376} W=352 b=0 l= r=0 t= 
// Remark                    : Combined Data and Code query. p_height_popup_query_combined_window
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : popup_query_data_code_window
// Scale parent match (100%) : main_pane
TAknWindowLineLayout popup_query_data_code_window(TInt aIndex_H)
    {
    return AknLayoutScalable_Avkon::popup_query_data_code_window(aIndex_H).LayoutLine();
    }

// C= H=82 W=352 b=0 l= r=0 t= 
// Remark                    : Find pop-up window.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : popup_find_window
// Scale parent match (100%) : main_pane
TAknWindowLineLayout popup_find_window()
    {
    return AknLayoutScalable_Avkon::popup_find_window().LayoutLine();
    }

// C= H={118, 154, 190, 226} W=352 b=0 l= r=0 t= 
// Remark                    : Textual notification. p_height_popup_notification_window
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : popup_snote_single_text_window
// Scale parent match (100%) : main_pane
TAknWindowLineLayout popup_snote_single_text_window(TInt aIndex_H)
    {
    return AknLayoutScalable_Avkon::popup_snote_single_text_window(aIndex_H).LayoutLine();
    }


// C= H={118, 154, 190, 226} W=352 b=0 l= r=0 t= 
// Remark                    : Notification with graphics. p_height_popup_notification_window
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : popup_snote_single_graphic_window
// Scale parent match (100%) : main_pane
TAknWindowLineLayout popup_snote_single_graphic_window(TInt aIndex_H)
    {
    return AknLayoutScalable_Avkon::popup_snote_single_graphic_window(aIndex_H).LayoutLine();
    }


// C= H={122, 160, 198, 236} W=352 b=0 l= r=0 t= 
// Remark                    : Grouped notifications. p_height_popup_snote_window
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 81%) : popup_snote_single_graphic_window_ParamLimits
// Scale parent match (100%) : main_pane
TAknWindowLineLayout popup_snote_group_window(TInt /*aIndex_H*/)
	{
	// NOT FOUND
	return EmptyWindowLayout();
	}

// C= H={116, 152, 180, 224, 260, 296, 332, 376} W=352 b=0 l= r=0 t= 
// Remark                    : Identifier icon selection pop-up window. p_height_popup_grid_graphic_window
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : popup_grid_graphic_window
// Scale parent match (100%) : main_pane
TAknWindowLineLayout popup_grid_graphic_window(TInt aIndex_H)
    {
    TInt option = 0;
    if (aIndex_H == 0) option = 6;
    else if (aIndex_H == 1) option = 5;
    else if (aIndex_H == 2) option = 4;
    else if (aIndex_H == 3) option = 3;
    else if (aIndex_H == 4) option = 2;
    else if (aIndex_H == 5) option = 1;
    else if (aIndex_H == 6 || aIndex_H == 7) option = 0;
    
    return AknLayoutScalable_Avkon::popup_grid_graphic_window(option).LayoutLine();
    }

// C= H={176, 250} W=352 b=0 l= r=0 t= 
// Remark                    : Double item menu. p_height_popup_menu_double2_window
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 60%) : popup_menu_window_ParamLimits
// Scale parent match (100%) : main_pane
TAknWindowLineLayout popup_menu_double2_window(TInt aIndex_H)
    {    
    return AknLayoutScalable_Avkon::popup_menu_window(aIndex_H).LayoutLine();
    }

// C= H=312 W=352 b=0 l= r=0 t= 
// Remark                    : Color selection pop-up window.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 86%) : popup_large_graphic_colour_window
// Scale parent match (100%) : main_pane
TAknWindowLineLayout popup_grid_large_graphic_colour_window()
    {
    TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    return AknLayoutScalable_Avkon::popup_large_graphic_colour_window(varietyIndex).LayoutLine(); // AsM16062005
    }


// LAF Table : Pop-up windows (status pane as parent)
// C= H={112, 206, 300, 330} W={136, 136} b= l=0 r= t=0 
// Remark                    : p_height_popup_fast_swap_window
// Parent                    : status_pane
// Parent API                : status_pane
// Scale API match    (100%) : popup_fast_swap_window
// Scale parent match (100%) : status_pane
TAknWindowLineLayout popup_fast_swap_window(TInt /*aIndex_W*/, TInt aIndex_H)
	// popup_fast_swap_window
	// NOTE, this does NOT follow status_pane_cp2
    {
    TInt option = 0;
    if (aIndex_H == 0) option = 3;
    if (aIndex_H == 1) option = 2;
    if (aIndex_H == 2) option = 1;
    if (aIndex_H == 3) option = 0;
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::popup_fast_swap_window(option);
    return layout.LayoutLine();
    }

// LAF Table : Pop-up window list pane descendants
// C= H=40 W=336 b= l=0 r= t={0, 40, 80, 120, 160, 200} 
// Remark                    : Parent list_menu_pane.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 92%) : list_single_popup_submenu_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout list_single_popup_menu_pane(TInt aIndex_t)
    {
    TAknWindowComponentLayout layout = TAknWindowComponentLayout::MultiLineY( AknLayoutScalable_Avkon::list_single_pane_cp2(0), aIndex_t, 0);
    return layout.LayoutLine();
    }

// C= H=40 W=336 b= l=0 r= t={0, 40, 80, 120, 160, 200} 
// Remark                    : Parent list_menu_heading_pane.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 69%) : list_single_popup_submenu_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout list_single_heading_popup_menu_pane(TInt aIndex_t)
    {
    TAknWindowComponentLayout layout = TAknWindowComponentLayout::MultiLineY( AknLayoutScalable_Avkon::list_single_heading_pane_cp2(0), aIndex_t, 0);
    return layout.LayoutLine();
    }

// C= H=40 W=336 b= l=0 r= t={0, 40, 80, 120, 160, 200} 
// Remark                    : Parent list_menu_graphic_pane.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 69%) : list_single_popup_submenu_pane_g1
// Scale parent match (  0%) : 
TAknWindowLineLayout list_single_graphic_popup_menu_pane(TInt aIndex_t)
    {
    TAknWindowComponentLayout layout = TAknWindowComponentLayout::MultiLineY( AknLayoutScalable_Avkon::list_single_graphic_pane_cp2(0), aIndex_t, 0);
    return layout.LayoutLine();
    }

// C= H=40 W=336 b= l=0 r= t={0, 40, 80, 120, 160, 200} 
// Remark                    : Parent list_menu_graphic_heading_pane.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 73%) : list_single_graphic_heading_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout list_single_graphic_heading_popup_menu_pane(TInt aIndex_t)
    {
    TAknWindowComponentLayout layout = TAknWindowComponentLayout::MultiLineY( AknLayoutScalable_Avkon::list_single_graphic_heading_pane_cp2(0), aIndex_t, 0);
    return layout.LayoutLine();
    }

// C= H=74 W=336 b= l=0 r= t={0, 74, 148} 
// Remark                    : Parent list_menu_double_pane.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 66%) : list_single_popup_submenu_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout list_menu_double_popup_menu_pane(TInt aIndex_t)
    {
    TAknWindowComponentLayout layout = TAknWindowComponentLayout::MultiLineY( AknLayoutScalable_Avkon::list_double_pane_cp2(0), aIndex_t, 0);
    return layout.LayoutLine();
    }

// C= H=36 W={120, 162, 204, 246, 288} b= l=0 r= t={0, 36, 72, 108, 144, 180} 
// Remark                    : Parent list_submenu_pane.
// Parent                    : 
// Parent API                : 
// Scale API match    (100%) : list_single_popup_submenu_pane
// Scale parent match (  0%) : 
TAknWindowLineLayout list_single_popup_submenu_pane(TInt aIndex_t, TInt /*aIndex_W*/)
    {
    TAknWindowComponentLayout layout = TAknWindowComponentLayout::MultiLineY( AknLayoutScalable_Avkon::list_single_popup_submenu_pane(0), aIndex_t, 0);
    return layout.LayoutLine();
    }


// C= H=74 W=336 b= l=0 r= t={0, 74, 148} 
// Remark                    : Parent list_menu_large_graphic_pane.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 71%) : list_double_large_graphic_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout list_double_large_graphic_popup_menu_pane(TInt aIndex_t)
    {
    TAknWindowComponentLayout layout = TAknWindowComponentLayout::MultiLineY( AknLayoutScalable_Avkon::list_double_large_graphic_pane_cp2(0), aIndex_t, 0);
    return layout.LayoutLine();
    }

// C= H=46 W=336 b= l= r= t= 
// Remark                    : Parents various pop-up windows.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 41%) : bg_popup_window_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout Pop_up_window_list_pane_descendants_Line_8()
    {
    return AknLayoutScalable_Avkon::heading_pane(0).LayoutLine(); 
    }

// C= H=74 W=336 b= l=0 r= t={0, 74, 148} 
// Remark                    : Parent list_menu_double_pane.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 57%) : list_double2_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout list_double2_popup_menu_pane(TInt aIndex_t)
    {
    TAknWindowComponentLayout layout = TAknWindowComponentLayout::MultiLineY( AknLayoutScalable_Avkon::list_double2_pane_cp2(0), aIndex_t, 0);
    return layout.LayoutLine();
    }

    

// LAF Table : List pane elements (menu single)
// C=219 H=2 W=328 b= l=4 r= t=0 
// Remark                    : Horizontal line dividing the menu contents e.g. context dependent options application options general options.
// Parent                    : list_single_popup_menu_pane
// Parent API                : list_single_popup_menu_pane
// Scale API match    ( 48%) : list_single_popup_submenu_pane_ParamLimits
// Scale parent match ( 92%) : list_single_popup_submenu_pane_ParamLimits
TAknWindowLineLayout List_pane_elements__menu_single__Line_1()
	{
	// JH: IMPLEMENTED 22.12.2005
	TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::list_single_pane_cp2_g4();
  	return layout.LayoutLine();
	}

  
// C=215 H=40 W=18 b= l=318 r= t=0 
// Remark                    : Submenu indication arrow.
// Parent                    : list_single_popup_menu_pane
// Parent API                : list_single_popup_menu_pane
// Scale API match    ( 48%) : list_single_popup_submenu_pane_ParamLimits
// Scale parent match ( 92%) : list_single_popup_submenu_pane_ParamLimits
TAknWindowLineLayout List_pane_elements__menu_single__Line_2()
    {
    return AknLayoutScalable_Avkon::list_single_pane_cp2_g3().LayoutLine();  
    }

// C= H=26 W=26 b= l={302, 276} r= t=6 
// Remark                    : Additional icons.
// Parent                    : list_single_popup_menu_pane
// Parent API                : list_single_popup_menu_pane
// Scale API match    ( 48%) : list_single_popup_submenu_pane_ParamLimits
// Scale parent match ( 92%) : list_single_popup_submenu_pane_ParamLimits
TAknWindowLineLayout List_pane_elements__menu_single__Line_3(TInt aIndex_l)
    {
    TAknWindowComponentLayout layout;
    if ( aIndex_l == 0 )
        {
        layout = AknLayoutScalable_Avkon::list_single_pane_g1_cp2(1);
        }
    else
        {
        layout = AknLayoutScalable_Avkon::list_single_pane_g2_cp2();
        }
    return layout.LayoutLine();  
    }


/*
TAknLayoutTableLimits List_pane_elements__menu_single__SUB_TABLE_0_Limits();

TAknWindowLineLayout List_pane_elements__menu_single__SUB_TABLE_0(TInt aLineIndex);

*/
// LAF Table : List pane texts (menu single)
// B=28 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={310, 298, 278, 252}[aCommon1] l=16 r={10, 22, 42, 68}[aCommon1] 
// Remark                    : Menu item text.
// Parent                    : list_single_popup_menu_pane
// Parent API                : list_single_popup_menu_pane
// Scale API match    ( 52%) : list_single_popup_submenu_pane_t1_ParamLimits
// Scale parent match ( 92%) : list_single_popup_submenu_pane_ParamLimits
TAknTextLineLayout List_pane_texts__menu_single__Line_1(TInt aCommon1)
    {
    TInt option = 0;
    switch (aCommon1)
        {
        case 0:
            option = 0;
            break;
        case 1:
            option = 1;
            break;
        case 2:
            option = 1;
            break;
        case 3:
            option = 2;
            break;
        default:
            break;
        }
    return AknLayoutScalable_Avkon::list_single_pane_t1_cp2(option).LayoutLine();
    }

// LAF Table : List pane text (submenu single)
// B=24 C=215 Font=ELatinBold12_Scaled J=ELayoutAlignLeft W={92, 134, 176, 218, 260} l=16 r=12 
// Remark                    : Submenu item.
// Parent                    : list_single_popup_submenu_pane
// Parent API                : list_single_popup_submenu_pane
// Scale API match    ( 61%) : list_single_popup_submenu_pane_t1_ParamLimits
// Scale parent match (100%) : list_single_popup_submenu_pane
TAknTextLineLayout List_pane_text__submenu_single__Line_1(TInt aIndex_W)
    {
    // JH: IMPLEMENTED 22.12.2005
    TAknTextComponentLayout layout = AknLayoutScalable_Avkon::list_single_popup_submenu_pane_t1(aIndex_W);
    return layout.LayoutLine();
    }

// LAF Table : List pane elements (menu single graphic)
// C= H=26 W=26 b= l=8 r= t=6 
// Remark                    : Notification type indication.
// Parent                    : list_single_graphic_popup_menu_pane
// Parent API                : list_single_graphic_popup_menu_pane
// Scale API match    ( 51%) : list_single_graphic_pane_g_Limits
// Scale parent match ( 69%) : list_single_popup_submenu_pane_g1
TAknWindowLineLayout List_pane_elements__menu_single_graphic__Line_1()
    {
    return AknLayoutScalable_Avkon::list_single_graphic_pane_g1_cp2(0).LayoutLine();
    }

// C= H=26 W=26 b= l={302, 276} r= t=6 
// Remark                    : Additional icons.
// Parent                    : list_single_graphic_popup_menu_pane
// Parent API                : list_single_graphic_popup_menu_pane
// Scale API match    ( 51%) : list_single_graphic_pane_g_Limits
// Scale parent match ( 69%) : list_single_popup_submenu_pane_g1
TAknWindowLineLayout List_pane_elements__menu_single_graphic__Line_2(TInt aIndex_l)
    {
    TAknWindowComponentLayout layout;
    if (aIndex_l == 1)
        {
        layout = AknLayoutScalable_Avkon::list_single_graphic_pane_g3_cp2();
        }
    else
        {
        layout = AknLayoutScalable_Avkon::list_single_graphic_pane_g2_cp2(0);
        }
    return layout.LayoutLine();
    }

// LAF Table : List pane texts (menu single graphic)
// B=28 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={284, 252, 226}[aCommon1] l=44 r={8, 40, 66}[aCommon1] 
// Remark                    : Notification item text.
// Parent                    : list_single_graphic_popup_menu_pane
// Parent API                : list_single_graphic_popup_menu_pane
// Scale API match    ( 57%) : list_single_graphic_heading_pane_t_Limits
// Scale parent match ( 69%) : list_single_popup_submenu_pane_g1
TAknTextLineLayout List_pane_texts__menu_single_graphic__Line_1(TInt aCommon1)
    {
    return AknLayoutScalable_Avkon::list_single_graphic_pane_t1_cp2(aCommon1).LayoutLine();
    }

// LAF Table : List pane elements (menu single heading)
// Vertical line
// C=219 H=40 W=2 b= l=100 r= t=0 
// Remark                    : Vertical line between the AB and C columns.
// Parent                    : list_single_heading_popup_menu_pane
// Parent API                : list_single_heading_popup_menu_pane
// Scale API match    ( 51%) : list_single_heading_pane_g_Limits
// Scale parent match ( 69%) : list_single_popup_submenu_pane_ParamLimits
TAknWindowLineLayout List_pane_elements__menu_single_heading__Line_1()
    {
    return EmptyWindowLayout();
    // Vertical line between AB and C columns.
    }

// C= H=26 W=26 b= l={302, 276} r= t=6 
// Remark                    : Additional icons.
// Parent                    : list_single_heading_popup_menu_pane
// Parent API                : list_single_heading_popup_menu_pane
// Scale API match    ( 51%) : list_single_heading_pane_g_Limits
// Scale parent match ( 69%) : list_single_popup_submenu_pane_ParamLimits
TAknWindowLineLayout List_pane_elements__menu_single_heading__Line_2(TInt aIndex_l)
    {
    TAknWindowComponentLayout layout;
    if (aIndex_l == 0)
        {
        layout = AknLayoutScalable_Avkon::list_single_heading_pane_g1_cp2(0);
        }
    else
        {
        layout = AknLayoutScalable_Avkon::list_single_heading_pane_g2_cp2();
        }
    return layout.LayoutLine();
    }
    
// LAF Table : List pane texts (menu single heading)
// B=28 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignRight W=88 l=8 r=240 
// Remark                    : Heading item text.
// Parent                    : list_single_heading_popup_menu_pane
// Parent API                : list_single_heading_popup_menu_pane
// Scale API match    ( 57%) : list_single_heading_pane_t_Limits
// Scale parent match ( 69%) : list_single_popup_submenu_pane_ParamLimits
TAknTextLineLayout List_pane_texts__menu_single_heading__Line_1()
    {
    return AknLayoutScalable_Avkon::list_single_heading_pane_t2_cp2(0).LayoutLine();
    }

// B=28 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={214, 182, 156}[aCommon1] l=114 r={8, 40, 66}[aCommon1] 
// Remark                    : Item text.
// Parent                    : list_single_heading_popup_menu_pane
// Parent API                : list_single_heading_popup_menu_pane
// Scale API match    ( 57%) : list_single_heading_pane_t_Limits
// Scale parent match ( 69%) : list_single_popup_submenu_pane_ParamLimits
TAknTextLineLayout List_pane_texts__menu_single_heading__Line_2(TInt aCommon1)
    {
    return AknLayoutScalable_Avkon::list_single_heading_pane_t1_cp2(aCommon1).LayoutLine();
    }

// LAF Table : List pane elements (menu single graphic heading)
// C= H=26 W=26 b= l=6 r= t=4 
// Remark                    : Icon.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 58%) : list_single_graphic_heading_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__menu_single_graphic_heading__Line_1()
    {
    return AknLayoutScalable_Avkon::list_single_graphic_heading_pane_g1_cp2(0).LayoutLine();
    }


// C=219 H=40 W=2 b= l=100 r= t=0 
// Remark                    : Vertical line between the AB and C columns.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 58%) : list_single_graphic_heading_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__menu_single_graphic_heading__Line_2()
	{
	// NOT IN SPEC
	return EmptyWindowLayout();
	}

// C= H=26 W=26 b= l={302, 276} r= t=6 
// Remark                    : Additional icons.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 58%) : list_single_graphic_heading_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__menu_single_graphic_heading__Line_3(TInt aIndex_l)
    {
    TAknWindowComponentLayout layout;
    if (aIndex_l == 0)
        {
        layout = AknLayoutScalable_Avkon::list_single_graphic_heading_pane_g4_cp2(0);
        }
    else
        {
        layout = AknLayoutScalable_Avkon::list_single_graphic_heading_pane_g5_cp2();
        }
    return layout.LayoutLine();
    }

// LAF Table : List pane texts (menu single graphic heading)
// B=28 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W={60, 64}[aCommon1] l=36 r={240, 236}[aCommon1] 
// Remark                    : Heading item text.
// Parent                    : list_single_graphic_heading_popup_menu_pane
// Parent API                : list_single_graphic_heading_popup_menu_pane
// Scale API match    ( 64%) : list_single_graphic_heading_pane_t_Limits
// Scale parent match ( 73%) : list_single_graphic_heading_pane_ParamLimits
TAknTextLineLayout List_pane_texts__menu_single_graphic_heading__Line_1(TInt /*aCommon1*/)
    {
    return AknLayoutScalable_Avkon::list_single_graphic_heading_pane_t2_cp2(0).LayoutLine();
    }

// B=28 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={214, 182, 156}[aCommon1] l=114 r={8, 40, 66}[aCommon1] 
// Remark                    : Item text.
// Parent                    : list_single_graphic_heading_popup_menu_pane
// Parent API                : list_single_graphic_heading_popup_menu_pane
// Scale API match    ( 64%) : list_single_graphic_heading_pane_t_Limits
// Scale parent match ( 73%) : list_single_graphic_heading_pane_ParamLimits
TAknTextLineLayout List_pane_texts__menu_single_graphic_heading__Line_2(TInt aCommon1)
    {
    return AknLayoutScalable_Avkon::list_single_graphic_heading_pane_t1_cp2(aCommon1).LayoutLine();
    }

/*
TAknLayoutTableLimits List_pane_texts__menu_single_graphic_heading__Limits();

TAknTextLineLayout List_pane_texts__menu_single_graphic_heading_(TInt aLineIndex, TInt aCommon1);
*/

// LAF Table : List pane elements (menu double)
// C= H=26 W=26 b= l={302, 276} r= t=10 
// Remark                    : Additional icons.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 40%) : list_double_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout List_pane_elements__menu_double__Line_1(TInt aIndex_l)
    {
    TAknWindowComponentLayout layout;
    if (aIndex_l == 0)
        {
        layout = AknLayoutScalable_Avkon::list_double_pane_g1_cp2(0);
        }
    else
        {
        layout = AknLayoutScalable_Avkon::list_double_pane_g2_cp2();
        }
    return layout.LayoutLine();
    }

// LAF Table : List pane texts (menu double)
// B=30 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={312, 280, 254}[aCommon1] l=16 r={8, 40, 66}[aCommon1] 
// Remark                    : Item title text.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 47%) : list_double_pane_t_Limits
// Scale parent match (  0%) : 
TAknTextLineLayout List_pane_texts__menu_double__Line_1(TInt aCommon1)
    {
    return AknLayoutScalable_Avkon::list_double_pane_t1_cp2(aCommon1).LayoutLine();
    }

// B=60 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=300 l=26 r=10 
// Remark                    : Additional item info.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 47%) : list_double_pane_t_Limits
// Scale parent match (  0%) : 
TAknTextLineLayout List_pane_texts__menu_double__Line_2()
    {
    return AknLayoutScalable_Avkon::list_double_pane_t2_cp2(0).LayoutLine();
    }

// LAF Table : List pane elements (menu double2)
// C= H=26 W=26 b= l={302, 276} r= t=10 
// Remark                    : Additional icon.
// Parent                    : list_double2_popup_menu_pane
// Parent API                : list_double2_popup_menu_pane
// Scale API match    ( 42%) : list_double2_pane_g_Limits
// Scale parent match ( 57%) : list_double2_pane_ParamLimits
TAknWindowLineLayout List_pane_elements__menu_double2__Line_1(TInt aIndex_l)
    {
    TAknWindowComponentLayout layout;
    if (aIndex_l == 0)
        {
        layout = AknLayoutScalable_Avkon::list_double2_pane_g1_cp2(0);
        }
    else
        {
        layout = AknLayoutScalable_Avkon::list_double2_pane_g2_cp2();
        }
    return layout.LayoutLine();
    }

// LAF Table : List pane texts (menu double2)
// B=30 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W={312, 280, 254}[aCommon1] l=16 r={8, 40, 66}[aCommon1] 
// Remark                    : Item heading text.
// Parent                    : list_double2_popup_menu_pane
// Parent API                : list_double2_popup_menu_pane
// Scale API match    ( 48%) : list_double2_pane_t_Limits
// Scale parent match ( 57%) : list_double2_pane_ParamLimits
TAknTextLineLayout List_pane_texts__menu_double2__Line_1(TInt aCommon1)
    {
    return AknLayoutScalable_Avkon::list_double2_pane_t1_cp2(aCommon1).LayoutLine();
    }

// B=60 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=300 l=26 r=10 
// Remark                    : Item text.
// Parent                    : list_double2_popup_menu_pane
// Parent API                : list_double2_popup_menu_pane
// Scale API match    ( 48%) : list_double2_pane_t_Limits
// Scale parent match ( 57%) : list_double2_pane_ParamLimits
TAknTextLineLayout List_pane_texts__menu_double2__Line_2()
    {
    return AknLayoutScalable_Avkon::list_double2_pane_t2_cp2(0).LayoutLine();
    }

// LAF Table : List pane elements (menu double large graphic)
// C= H=64 W=84 b= l=8 r= t=4 
// Remark                    : Maximum area for any image size.
// Parent                    : list_double_large_graphic_popup_menu_pane
// Parent API                : list_double_large_graphic_popup_menu_pane
// Scale API match    ( 56%) : list_double_large_graphic_pane_g_Limits
// Scale parent match ( 71%) : list_double_large_graphic_pane_ParamLimits
TAknWindowLineLayout List_pane_elements__menu_double_large_graphic__Line_1()
    {
    return AknLayoutScalable_Avkon::list_double_large_graphic_pane_g1_cp2(0).LayoutLine();
    }

// C= H=26 W=26 b= l={302, 276} r= t=10 
// Remark                    : Additional icons.
// Parent                    : list_double_large_graphic_popup_menu_pane
// Parent API                : list_double_large_graphic_popup_menu_pane
// Scale API match    ( 56%) : list_double_large_graphic_pane_g_Limits
// Scale parent match ( 71%) : list_double_large_graphic_pane_ParamLimits
TAknWindowLineLayout List_pane_elements__menu_double_large_graphic__Line_2(TInt aIndex_l)
    {
    TAknWindowComponentLayout layout;
    if (aIndex_l == 0)
        {
        layout = AknLayoutScalable_Avkon::list_double_large_graphic_pane_g2_cp2(0);
        }
    else
        {
        layout = AknLayoutScalable_Avkon::list_double_large_graphic_pane_g3_cp2();
        }
    return layout.LayoutLine();
    }

// LAF Table : List pane texts (menu double large graphic)
// B=30 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={224, 192, 166}[aCommon1] l=104 r={8, 40, 66}[aCommon1] 
// Remark                    : Item text.
// Parent                    : list_double_large_graphic_popup_menu_pane
// Parent API                : list_double_large_graphic_popup_menu_pane
// Scale API match    ( 62%) : list_double_large_graphic_pane_t_Limits
// Scale parent match ( 71%) : list_double_large_graphic_pane_ParamLimits
TAknTextLineLayout List_pane_texts__menu_double_large_graphic__Line_1(TInt aCommon1)
    {
    return AknLayoutScalable_Avkon::list_double_large_graphic_pane_t1_cp2(aCommon1).LayoutLine();
    }

// B=60 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=212 l=114 r=10 
// Remark                    : Secondary item text.
// Parent                    : list_double_large_graphic_popup_menu_pane
// Parent API                : list_double_large_graphic_popup_menu_pane
// Scale API match    ( 62%) : list_double_large_graphic_pane_t_Limits
// Scale parent match ( 71%) : list_double_large_graphic_pane_ParamLimits
TAknTextLineLayout List_pane_texts__menu_double_large_graphic__Line_2()
    {
    return AknLayoutScalable_Avkon::list_double_large_graphic_pane_t2_cp2(0).LayoutLine();
    }

// LAF Table : Highlight graphics (various)
// C=222 H=p-4 W=p-8 b= l=6 r= t=4 
// Remark                    : Shadow.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 30%) : cell_highlight_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout Highlight_graphics__various__Line_1(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

// C=244 H=p-2 W=p-6 b= l=2 r= t=0 
// Remark                    : Highlight.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 30%) : cell_highlight_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout Highlight_graphics__various__Line_2(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

/*
TAknLayoutTableLimits Highlight_graphics__various__Limits();

TAknWindowLineLayout Highlight_graphics__various_(TInt aLineIndex, const TRect& aParentRect);
*/

// LAF Table : Pop-up window grid pane descendants (graphic)
// C= H=34 W=34 b= l={0, 36, 72, 108, 144, 180, 216, 252, 288, 0, 36, 72, 108, 144, 180, 216, 252, 288, 0, 36, 72, 108, 144, 180, 216, 252, 288, 0, 36, 72, 108, 144, 180, 216, 252, 288, 0, 36, 72, 108, 144, 180, 216, 252, 288, 0, 36, 72, 108, 144, 180, 216, 252, 288, 0, 36, 72, 108, 144, 180, 216, 252, 288, 0, 36, 72, 108, 144, 180, 216, 252, 288, , , , , , , , } r= t={0, , , , , , , , , 36, , , , , , , , , 72, , , , , , , , , 108, , , , , , , , , 144, , , , , , , , , 180, , , , , , , , , 216, , , , , , , , , 252, , , , , , , , , , , , , , , , } 
// Remark                    : E.g. identifier icons.
// Parent                    : grid_graphic_popup_pane
// Parent API                : grid_graphic_popup_pane
// Scale API match    (100%) : cell_graphic_popup_pane
// Scale parent match (100%) : grid_graphic_popup_pane
TAknWindowLineLayout cell_graphic_popup_pane(TInt aIndex_l, TInt aIndex_t)
    {
	TInt varietyIndex = 0; // stick to variety 0 for now, variety 1 seems to be shorter [LMB 12/04/2005]
    TInt leftIndex = aIndex_l % 9;
    TInt topIndex = aIndex_t / 9;
    if (leftIndex > 6)
        {
        leftIndex = 6;
        }
    if (topIndex > 6)
        {
        topIndex = 6;
        }
    return AknLayoutScalable_Avkon::cell_graphic_popup_pane(varietyIndex, leftIndex, topIndex).LayoutLine();
    }

// LAF Table : Cell pane elements (pop-up graphic)
// C= H=26 W=26 b= l=4 r= t=4 
// Remark                    : Identifier icon.
// Parent                    : cell_graphic_popup_pane
// Parent API                : cell_graphic_popup_pane
// Scale API match    ( 47%) : cell_large_graphic_colour_popup_pane_g_Limits
// Scale parent match (100%) : cell_graphic_popup_pane
TAknWindowLineLayout Cell_pane_elements__pop_up_graphic__Line_1()
    {
    // JH: IMPLEMENTED 2.1.2005
    return AknLayoutScalable_Avkon::cell_graphic_popup_pane_g1().LayoutLine();
    }

// LAF Table : Cell pane texts (pop-up graphic)
// B=24 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignCenter W=28 l=4 r=2 
// Remark                    : E.g. a special character.
// Parent                    : cell_graphic_popup_pane
// Parent API                : cell_graphic_popup_pane
// Scale API match    ( 51%) : cell_large_graphic_colour_none_popup_pane_t1
// Scale parent match (100%) : cell_graphic_popup_pane
TAknTextLineLayout Cell_pane_texts__pop_up_graphic__Line_1()
    {
    // JH: IMPLEMENTED 13.12.2005
    TAknTextComponentLayout layout = AknLayoutScalable_Avkon::cell_graphic_popup_pane_t2();
    return layout.LayoutLine();
    }

// LAF Table : Pop-up window grid pane descendants (large graphic colour)
// C= H={44, 56, , , , , , , , , , , , } W=78 b= l={0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, 0, 80, 160, 240, , , , , , , , , , , , , , , , , } r= t={0, , , , 46, 58, , , 92, 116, , , 138, 174, , , , , , , , , , , , , , , , , , } 
// Remark                    : Filled color rectangles.
// Parent                    : grid_large_graphic_colour_popup_pane
// Parent API                : grid_large_graphic_colour_popup_pane
// Scale API match    (100%) : cell_large_graphic_colour_popup_pane
// Scale parent match (100%) : grid_large_graphic_colour_popup_pane
TAknWindowLineLayout cell_large_graphic_colour_popup_pane(TInt aIndex_l, TInt aIndex_t, TInt aIndex_H)
    {
	TInt varietyIndex = (aIndex_H == 0 ? 1 : 0); // in LAF spec, index 1 means "none not shown"; in scalable layout, variety 1 means "with none option" so must flip value
    TInt leftIndex = aIndex_l % 4;
    TInt topIndex = aIndex_t / 4;
    return AknLayoutScalable_Avkon::cell_large_graphic_colour_popup_pane(varietyIndex, leftIndex, topIndex).LayoutLine();
    }

// LAF Table : Cell pane elements (pop-up large graphic colour)
// C= H={32, 44} W=66 b= l=6 r= t=6 
// Remark                    : Colour content.
// Parent                    : cell_large_graphic_colour_popup_pane
// Parent API                : cell_large_graphic_colour_popup_pane
// Scale API match    (100%) : popup_large_graphic_colour_window
// Scale parent match (100%) : cell_large_graphic_colour_popup_pane
TAknWindowLineLayout colour(TInt /*aIndex_H*/)
    {
	// can't work this out relative to the parent height, need to do that in client
	return AknLayoutScalable_Avkon::cell_large_graphic_colour_popup_pane_g1().LayoutLine();
    }

// LAF Table : Pop-up window cell pane (large graphic colour none)
// C= H=44 W=318 b= l= r= t= 
// Remark                    : 
// Parent                    : popup_grid_large_graphic_colour_window
// Parent API                : popup_grid_large_graphic_colour_window
// Scale API match    ( 62%) : cell_large_graphic_colour_none_popup_pane_ParamLimits
// Scale parent match ( 86%) : popup_large_graphic_colour_window
TAknWindowLineLayout Pop_up_window_cell_pane__large_graphic_colour_none__Line_1()
    {
	// this is cell_large_graphic_colour_none_popup_pane
	TInt varietyIndex = Layout_Meta_Data::IsScrollbarEnabled(); // scroll bar present
	TAknWindowComponentLayout listScroll = AknLayoutScalable_Avkon::listscroll_popup_colour_pane();
	TAknWindowComponentLayout pane = AknLayoutScalable_Avkon::cell_large_graphic_colour_none_popup_pane(varietyIndex);
	return DoCompose(listScroll, pane).LayoutLine();
    }

// LAF Table : Cell pane texts (pop-up large graphic colour none)
// B=30 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignCenter W=298 l=12 r=8 
// Remark                    : No colourtext.
// Parent                    : cell_large_graphic_colour_none_popup_pane
// Parent API                : Pop_up_window_cell_pane__large_graphic_colour_none__Line_1
// Scale API match    ( 67%) : cell_large_graphic_colour_none_popup_pane_t1
// Scale parent match ( 62%) : cell_large_graphic_colour_none_popup_pane_ParamLimits
TAknTextLineLayout Cell_pane_texts__pop_up_large_graphic_colour_none__Line_1()
    {
    return AknLayoutScalable_Avkon::cell_large_graphic_colour_none_popup_pane_t1().LayoutLine();
    }

// LAF Table : Highlight elements (grid pop-up)
// C=215 H=p W=p b= l=p r= t=p 
// Remark                    : 
// Parent                    : 
// Parent API                : 
// Scale API match    ( 32%) : grid_highlight_pane_cp5
// Scale parent match (  0%) : 
TAknWindowLineLayout Highlight_elements__grid_pop_up__Line_1(const TRect& /*aParentRect*/)
    {
    return AknLayoutScalable_Avkon::grid_highlight_pane_cp5().LayoutLine();
    }

// C=210 H=p-4 W=p-4 b= l=p+2 r= t=p+2 
// Remark                    : Character inversion.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 32%) : grid_highlight_pane_cp5
// Scale parent match (  0%) : 
TAknWindowLineLayout Highlight_elements__grid_pop_up__Line_2(const TRect& /*aParentRect*/)
    {
    return AknLayoutScalable_Avkon::grid_highlight_pane_cp5().LayoutLine();
    }

/*
TAknLayoutTableLimits Highlight_elements__grid_pop_up__Limits();

TAknWindowLineLayout Highlight_elements__grid_pop_up_(TInt aLineIndex, const TRect& aParentRect);
*/

// LAF Table : List heading pane elements
// C=215 H=2 W=336 b= l=0 r= t=40 
// Remark                    : A horizontal line dividing the menu into the heading and the list items.
// Parent                    : popup_list_heading_pane
// Parent API                : popup_list_heading_pane
// Scale API match    ( 60%) : list_double_graphic_heading_pane_ParamLimits
// Scale parent match ( 76%) : bg_popup_heading_pane_g_Limits
TAknWindowLineLayout List_heading_pane_elements_Line_1()
    {
    // heading_pane_g1
    // TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::heading_pane_g1();  
    // return layout;
    return EmptyWindowLayout(); // NOT USED
    }

// C= H=20 W=120 b= l=206 r= t=8 
// Remark                    : Wait or Progress bar animation.
// Parent                    : popup_list_heading_pane
// Parent API                : popup_list_heading_pane
// Scale API match    ( 60%) : list_double_graphic_heading_pane_ParamLimits
// Scale parent match ( 76%) : bg_popup_heading_pane_g_Limits
TAknWindowLineLayout List_heading_pane_elements_Line_2()
    {
    // NOT THERE
    return EmptyWindowLayout();
    }

/*
TAknLayoutTableLimits List_heading_pane_elements_Limits();

TAknWindowLineLayout List_heading_pane_elements(TInt aLineIndex);
*/

// LAF Table : List heading pane texts
// B=28 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={276, 304} l=16 r=16 
// Remark                    : Menu heading text.
// Parent                    : popup_list_heading_pane
// Parent API                : popup_list_heading_pane
// Scale API match    ( 72%) : list_single_heading_pane_t1_ParamLimits
// Scale parent match ( 76%) : bg_popup_heading_pane_g_Limits
TAknTextLineLayout List_heading_pane_texts_Line_1(TInt aIndex_W)
    {
    TInt variety = 0;
    if (aIndex_W == 0)
        {
        variety = 2;
        }
    TAknTextComponentLayout layout = AknLayoutScalable_Avkon::heading_pane_t1(variety);  
    return layout.LayoutLine();
    }

// LAF Table : Pop-up menu with heading window graphics
// C=0 H=p+46 W=352 b= l=0 r= t=0 
// Remark                    : A rectangle to cover the main pane items.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 43%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Pop_up_menu_with_heading_window_graphics_Line_1(const TRect& /*aParentRect*/)
    {
	TAknWindowComponentLayout layoutWithoutHeading = AknLayoutScalable_Avkon::popup_window_general(0); // without heading pane
	TAknWindowComponentLayout layoutWithHeading = AknLayoutScalable_Avkon::popup_window_general(1); // with heading pane
	return TAknWindowComponentLayout::SiblingAsChild(layoutWithoutHeading, layoutWithHeading).LayoutLine();
    }


// C=86 H=p+26 W=336 b= l=12 r= t=12 
// Remark                    : Second shadow.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 43%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Pop_up_menu_with_heading_window_graphics_Line_2(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

// C=221 H=p+28 W=338 b= l=8 r= t=8 
// Remark                    : First shadow.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 43%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Pop_up_menu_with_heading_window_graphics_Line_3(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

// C=215 H=p+30 W=340 b= l=4 r= t=4 
// Remark                    : Outline frame.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 43%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Pop_up_menu_with_heading_window_graphics_Line_4(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

// C=0 H=p+26 W=336 b= l=6 r= t=6 
// Remark                    : Inside area.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 43%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Pop_up_menu_with_heading_window_graphics_Line_5(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }
    
/*
TAknLayoutTableLimits Pop_up_menu_with_heading_window_graphics_Limits();

TAknWindowLineLayout Pop_up_menu_with_heading_window_graphics(TInt aLineIndex, const TRect& aParentRect);
*/

// LAF Table : Menu pop-up window descendants
// C= H={40, 80, 120, 160, 200, 240} W=336 b= l=6 r= t={10, 56} 
// Remark                    : Menu option items.
// Parent                    : popup_menu_window
// Parent API                : popup_menu_window
// Scale API match    (100%) : list_menu_pane
// Scale parent match (100%) : popup_menu_window
TAknWindowLineLayout list_menu_pane(TInt aIndex_t, TInt /*aIndex_H*/)
    {
	TAknWindowComponentLayout heading;
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::listscroll_menu_pane(0);
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::list_menu_pane(0);
	TAknWindowComponentLayout layout3 = layout;

	if (aIndex_t == 1)
		{ // heading enabled
		TAknWindowComponentLayout layoutWithoutHeading = AknLayoutScalable_Avkon::popup_window_general(0); // without heading pane
		TAknWindowComponentLayout layoutWithHeading = AknLayoutScalable_Avkon::popup_window_general(1); // with heading pane
		heading = TAknWindowComponentLayout::SiblingAsChild(layoutWithHeading, layoutWithoutHeading);	
		layout3 = DoCompose(heading, layout);
		}
    return DoCompose(layout3, layout2).LayoutLine();
    }


// C= H= W= b= l=6 r= t=10 
// Remark                    : For the dimensions refer to Table 4.1.
// Parent                    : popup_menu_window
// Parent API                : popup_menu_window
// Scale API match    ( 37%) : popup_menu_window_ParamLimits
// Scale parent match (100%) : popup_menu_window
TAknWindowLineLayout Menu_pop_up_window_descendants_Line_2()
    {
    // JH: IMPLEMENTED 22.12.2005, Menu pop-up window with heading
    return list_menu_pane(1,0);
    }

// LAF Table : Menu pop-up window graphics
// C=0 H=p W=352 b= l=0 r= t=0 
// Remark                    : A rectangle to cover the main pane items.
// Parent                    : popup_menu_window
// Parent API                : popup_menu_window
// Scale API match    ( 57%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_menu_window
TAknWindowLineLayout Menu_pop_up_window_graphics_Line_1(const TRect& /*aParentRect*/)
    {
    // JH: IMPLEMENTED 13.12.2005
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::bg_popup_window_pane_cp2(0);
    return layout.LayoutLine();
    }

// C=86 H=p-20 W=336 b= l=12 r= t=12 
// Remark                    : Second shadow.
// Parent                    : popup_menu_window
// Parent API                : popup_menu_window
// Scale API match    ( 57%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_menu_window
TAknWindowLineLayout Menu_pop_up_window_graphics_Line_2(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

// C=221 H=p-18 W=338 b= l=8 r= t=8 
// Remark                    : First shadow.
// Parent                    : popup_menu_window
// Parent API                : popup_menu_window
// Scale API match    ( 57%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_menu_window
TAknWindowLineLayout Menu_pop_up_window_graphics_Line_3(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

// C=215 H=p-16 W=340 b= l=4 r= t=4 
// Remark                    : Outline frame.
// Parent                    : popup_menu_window
// Parent API                : popup_menu_window
// Scale API match    ( 57%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_menu_window
TAknWindowLineLayout Menu_pop_up_window_graphics_Line_4(const TRect& /*aParentRect*/)
    {
    // JH: IMPLEMENTED 13.12.2005
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::listscroll_menu_pane(0);
    return layout.LayoutLine();
    }

// C=0 H=p-20 W=336 b= l=6 r= t=6 
// Remark                    : Inside area.
// Parent                    : popup_menu_window
// Parent API                : popup_menu_window
// Scale API match    ( 57%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_menu_window
TAknWindowLineLayout Menu_pop_up_window_graphics_Line_5(const TRect& /*aParentRect*/)
    {
    // JH: IMPLEMENTED 13.12.2005
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::list_menu_pane(0);
    return layout.LayoutLine();
    }

/*
TAknLayoutTableLimits Menu_pop_up_window_graphics_Limits();

TAknWindowLineLayout Menu_pop_up_window_graphics(TInt aLineIndex, const TRect& aParentRect);
*/

// LAF Table : Submenu pop-up window descendants
// C= H={36, 72, 108, 144, 180, 216} W={120, 162, 204, 246, 288} b= l=4 r= t=8 
// Remark                    : Submenu option items.
// Parent                    : popup_submenu_window
// Parent API                : Pop_up_windows__main_pane_as_parent__Line_2
// Scale API match    (100%) : list_submenu_pane
// Scale parent match ( 36%) : bg_popup_window_pane_ParamLimits
TAknWindowLineLayout list_submenu_pane(TInt /*aIndex_W*/, TInt /*aIndex_H*/)
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::listscroll_popup_sub_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::list_submenu_pane(0);
    return DoCompose(layout, layout2).LayoutLine();
    }


// LAF Table : Submenu pop-up window graphics
// C=0 H=p W=p b= l=0 r= t=0 
// Remark                    : A rectangle to cover the main pane items.
// Parent                    : popup_submenu_window
// Parent API                : Pop_up_windows__main_pane_as_parent__Line_2
// Scale API match    ( 51%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match ( 36%) : bg_popup_window_pane_ParamLimits
TAknWindowLineLayout Submenu_pop_up_window_graphics_Line_1(const TRect& /*aParentRect*/)
    {
    // JH: IMPLEMENTED 13.12.2005
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::bg_popup_sub_pane_cp();
    return layout.LayoutLine();
    }

// C=221 H=p-8 W=p-8 b= l=6 r= t=6 
// Remark                    : Shadow.
// Parent                    : popup_submenu_window
// Parent API                : Pop_up_windows__main_pane_as_parent__Line_2
// Scale API match    ( 51%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match ( 36%) : bg_popup_window_pane_ParamLimits
TAknWindowLineLayout Submenu_pop_up_window_graphics_Line_2(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

// C=215 H=p-6 W=p-6 b= l=2 r= t=2 
// Remark                    : Outline frame.
// Parent                    : popup_submenu_window
// Parent API                : Pop_up_windows__main_pane_as_parent__Line_2
// Scale API match    ( 51%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match ( 36%) : bg_popup_window_pane_ParamLimits
TAknWindowLineLayout Submenu_pop_up_window_graphics_Line_3(const TRect& /*aParentRect*/)
    {
    // JH: IMPLEMENTED 13.12.2005
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::listscroll_popup_sub_pane();
    return layout.LayoutLine();
    }

// C=0 H=p-10 W=p-10 b= l=4 r= t=4 
// Remark                    : Inside area.
// Parent                    : popup_submenu_window
// Parent API                : Pop_up_windows__main_pane_as_parent__Line_2
// Scale API match    ( 51%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match ( 36%) : bg_popup_window_pane_ParamLimits
TAknWindowLineLayout Submenu_pop_up_window_graphics_Line_4(const TRect& /*aParentRect*/)
    {
    // JH: IMPLEMENTED 13.12.2005
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::bg_popup_sub_pane_cp();
    return layout.LayoutLine();
    }

/*
TAknLayoutTableLimits Submenu_pop_up_window_graphics_Limits();

TAknWindowLineLayout Submenu_pop_up_window_graphics(TInt aLineIndex, const TRect& aParentRect);
*/

// LAF Table : Submenu pop-up window positioning
// C= H={54, 90, 126, 162, 198, 234} W={130, 172, 214, 256, 298} b=16 l= r=12 t= 
// Remark                    : Parent popup_menu_window.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 46%) : popup_submenu_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Submenu_pop_up_window_positioning_Line_1(TInt /*aIndex_W*/, TInt /*aIndex_H*/)
    {
    return EmptyWindowLayout();
    }

// C= H={54, 90, 126, 162, 198, 234} W={130, 172, 214, 256, 298} b= l= r=0 t=-4 
// Remark                    : Parent list_single_popup_menu_pane. The original list pane.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 46%) : popup_submenu_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Submenu_pop_up_window_positioning_Line_2(TInt /*aIndex_W*/, TInt /*aIndex_H*/)
    {
    return EmptyWindowLayout();
    }
    
/*
TAknLayoutTableLimits Submenu_pop_up_window_positioning_Limits();

TAknWindowLineLayout Submenu_pop_up_window_positioning(TInt aLineIndex, TInt aIndex_W, TInt aIndex_H);
*/

// LAF Table : Menu pop-up window descendant (single graphic)
// C= H={40, 80, 120, 160, 200, 240} W=336 b= l=6 r= t={10, 56} 
// Remark                    : List items.
// Parent                    : popup_menu_graphic_window
// Parent API                : popup_menu_graphic_window
// Scale API match    ( 70%) : list_double2_graphic_large_graphic_pane_ParamLimits
// Scale parent match ( 73%) : popup_grid_graphic_window_ParamLimits
TAknWindowLineLayout list_menu_graphic_pane(TInt aIndex_t, TInt /*aIndex_H*/)
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::listscroll_menu_pane(0);
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::list_menu_pane(0);
	TAknWindowComponentLayout layout3 = layout;

	if (aIndex_t == 1)
		{ // heading enabled
		TAknWindowComponentLayout layoutWithoutHeading = AknLayoutScalable_Avkon::popup_window_general(0); // without heading pane
		TAknWindowComponentLayout layoutWithHeading = AknLayoutScalable_Avkon::popup_window_general(1); // with heading pane
		TAknWindowComponentLayout heading = TAknWindowComponentLayout::SiblingAsChild(layoutWithHeading, layoutWithoutHeading);	
		layout3 = DoCompose(heading, layout);
		}

    return DoCompose(layout3, layout2).LayoutLine();
    }

// LAF Table : Menu pop-up window descendants (single heading)
// C= H={40, 80, 120, 160, 200, 240} W=336 b= l=6 r= t={10, 56} 
// Remark                    : List items.
// Parent                    : popup_menu_graphic_window
// Parent API                : popup_menu_graphic_window
// Scale API match    ( 70%) : list_double_graphic_heading_pane_ParamLimits
// Scale parent match ( 73%) : popup_grid_graphic_window_ParamLimits
TAknWindowLineLayout list_menu_heading_pane(TInt aIndex_t, TInt /*aIndex_H*/)
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::listscroll_menu_pane(0);
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::list_menu_pane(0);
	TAknWindowComponentLayout layout3 = layout;

	if (aIndex_t == 1)
		{ // heading enabled
		TAknWindowComponentLayout layoutWithoutHeading = AknLayoutScalable_Avkon::popup_window_general(0); // without heading pane
		TAknWindowComponentLayout layoutWithHeading = AknLayoutScalable_Avkon::popup_window_general(1); // with heading pane
		TAknWindowComponentLayout heading = TAknWindowComponentLayout::SiblingAsChild(layoutWithHeading, layoutWithoutHeading);	
		layout3 = DoCompose(heading, layout);
		}

    return DoCompose(layout3, layout2).LayoutLine();
    }

// C= H= W= b= l=6 r= t=10 
// Remark                    : For the dimensions refer to Table 4.1.
// Parent                    : popup_menu_graphic_window
// Parent API                : popup_menu_graphic_window
// Scale API match    ( 30%) : popup_snote_single_text_window_t_Limits
// Scale parent match ( 73%) : popup_grid_graphic_window_ParamLimits
TAknWindowLineLayout Menu_pop_up_window_descendants__single_heading__Line_2()
    {
    return EmptyWindowLayout();
    }

// C=219 H=4 W=2 b=18 l= r={6, 52} t=100 
// Remark                    : Vertical line extensions.
// Parent                    : popup_menu_graphic_window
// Parent API                : popup_menu_graphic_window
// Scale API match    ( 30%) : popup_snote_single_text_window_t_Limits
// Scale parent match ( 73%) : popup_grid_graphic_window_ParamLimits
TAknWindowLineLayout Menu_pop_up_window_descendants__single_heading__Line_3(TInt /*aIndex_r*/)
    {
    return EmptyWindowLayout();
    }

// LAF Table : Menu pop-up window descendants and elements (single graphic heading)
// C= H={40, 80, 120, 160, 200, 240} W=336 b= l=6 r= t={10, 56} 
// Remark                    : List pane items.
// Parent                    : popup_menu_graphic_heading_window
// Parent API                : popup_menu_graphic_heading_window
// Scale API match    ( 78%) : list_double_graphic_heading_pane_ParamLimits
// Scale parent match ( 54%) : popup_snote_single_graphic_window_ParamLimits
TAknWindowLineLayout list_menu_graphic_heading_pane(TInt aIndex_t, TInt /*aIndex_H*/)
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::listscroll_menu_pane(0);
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::list_menu_pane(0);
	TAknWindowComponentLayout layout3 = layout;

	if (aIndex_t == 1)
		{ // heading enabled
		TAknWindowComponentLayout layoutWithoutHeading = AknLayoutScalable_Avkon::popup_window_general(0); // without heading pane
		TAknWindowComponentLayout layoutWithHeading = AknLayoutScalable_Avkon::popup_window_general(1); // with heading pane
		TAknWindowComponentLayout heading = TAknWindowComponentLayout::SiblingAsChild(layoutWithHeading, layoutWithoutHeading);	
		layout3 = DoCompose(heading, layout);
		}

    return DoCompose(layout3, layout2).LayoutLine();
    }


// C= H= W= b= l=6 r= t=10 
// Remark                    : For the dimensions refer to Table 4.1.
// Parent                    : popup_menu_graphic_heading_window
// Parent API                : popup_menu_graphic_heading_window
// Scale API match    ( 32%) : popup_snote_single_graphic_window_g_Limits
// Scale parent match ( 54%) : popup_snote_single_graphic_window_ParamLimits
TAknWindowLineLayout Menu_pop_up_window_descendants_and_elements__single_graphic_heading__Line_2()
    {
    return EmptyWindowLayout();
    }

// C=219 H=4 W=2 b=18 l= r={6, 52} t=100 
// Remark                    : Vertical line extensions.
// Parent                    : popup_menu_graphic_heading_window
// Parent API                : popup_menu_graphic_heading_window
// Scale API match    ( 32%) : popup_snote_single_graphic_window_g_Limits
// Scale parent match ( 54%) : popup_snote_single_graphic_window_ParamLimits
TAknWindowLineLayout Menu_pop_up_window_descendants_and_elements__single_graphic_heading__Line_3(TInt /*aIndex_r*/)
    {
    return EmptyWindowLayout();
    }

// LAF Table : Menu pop-up window descendants (double double2)
// C= H={74, 148, 222} W=336 b= l=6 r= t={10, 56} 
// Remark                    : Menu option items.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 64%) : list_double2_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout list_menu_double_pane_list_menu_double2_pane(TInt aIndex_t, TInt /*aIndex_H*/)
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::listscroll_menu_pane(0);
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::list_menu_pane(0);
	TAknWindowComponentLayout layout3 = layout;

	if (aIndex_t == 1)
		{ // heading enabled
		TAknWindowComponentLayout layoutWithoutHeading = AknLayoutScalable_Avkon::popup_window_general(0); // without heading pane
		TAknWindowComponentLayout layoutWithHeading = AknLayoutScalable_Avkon::popup_window_general(1); // with heading pane
		TAknWindowComponentLayout heading = TAknWindowComponentLayout::SiblingAsChild(layoutWithHeading, layoutWithoutHeading);	
		layout3 = DoCompose(heading, layout);
		}
    return DoCompose(layout3, layout2).LayoutLine();
    }

// C= H= W= b= l=6 r= t=10 
// Remark                    : For the dimensions refer to Table 4.1.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 26%) : list_double2_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout Menu_pop_up_window_descendants__double_double2__Line_2()
    {
    return EmptyWindowLayout();
    }

// LAF Table : Menu pop-up window descendants (double)
// C= H={74, 148, 222} W=336 b= l=6 r= t={10, 56} 
// Remark                    : Menu option items.
// Parent                    : popup_menu_double_large_graphic_window
// Parent API                : popup_menu_double_large_graphic_window
// Scale API match    ( 81%) : list_double_large_graphic_pane_ParamLimits
// Scale parent match ( 61%) : popup_large_graphic_colour_window
TAknWindowLineLayout list_menu_double_large_graphic_pane(TInt aIndex_t, TInt /*aIndex_H*/)
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::listscroll_menu_pane(0);
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::list_menu_pane(0);
	TAknWindowComponentLayout layout3 = layout;

	if (aIndex_t == 1)
		{ // heading enabled
		TAknWindowComponentLayout layoutWithoutHeading = AknLayoutScalable_Avkon::popup_window_general(0); // without heading pane
		TAknWindowComponentLayout layoutWithHeading = AknLayoutScalable_Avkon::popup_window_general(1); // with heading pane
		TAknWindowComponentLayout heading = TAknWindowComponentLayout::SiblingAsChild(layoutWithHeading, layoutWithoutHeading);	
		layout3 = DoCompose(heading, layout);
		}

    return DoCompose(layout3, layout2).LayoutLine();
    }


// C= H= W= b= l=6 r= t=10 
// Remark                    : For the dimensions refer to Table 4.1.
// Parent                    : popup_menu_double_large_graphic_window
// Parent API                : popup_menu_double_large_graphic_window
// Scale API match    ( 27%) : bg_popup_window_pane_g_Limits
// Scale parent match ( 61%) : popup_large_graphic_colour_window
TAknWindowLineLayout Menu_pop_up_window_descendants__double__Line_2()
    {
    return EmptyWindowLayout();
    }

// LAF Table : Note pop-up window elements
// C= H=80 W=60 b= l=280 r= t=8 
// Remark                    : Note icon.
// Parent                    : popup_note_window
// Parent API                : popup_note_window
// Scale API match    ( 42%) : popup_note_wait_window_ParamLimits
// Scale parent match (100%) : popup_note_window
TAknWindowLineLayout Note_pop_up_window_elements_Line_1()
    {
    TAknWindowComponentLayout layout;
    layout = AknLayoutScalable_Avkon::popup_note_window_g1(2);
    return layout.LayoutLine();
    }

// LAF Table : Note pop-up window texts
// B={44, 80, 116, 152, 188}[aCommon1] C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={248, 248, 310, 310, 310}[aCommon1] l={22, 22, 22, 22, 22}[aCommon1] r={82, 82, 20, 20, 20}[aCommon1] 
// Remark                    : Note text. Five lines of text.
// Parent                    : popup_note_window
// Parent API                : popup_note_window
// Scale API match    ( 65%) : popup_snote_single_text_window_t1_ParamLimits
// Scale parent match (100%) : popup_note_window
TAknTextLineLayout Note_pop_up_window_texts_Line_1(TInt aCommon1)
    {
    TAknTextComponentLayout textLayout;
    switch (aCommon1)
        {
        case 0:
            textLayout = AknLayoutScalable_Avkon::popup_note_window_t1(2);
            break;
        case 1:
            textLayout = AknLayoutScalable_Avkon::popup_note_window_t2(2);
            break;
        case 2:
            textLayout = AknLayoutScalable_Avkon::popup_note_window_t3(2);
            break;
        case 3:
            textLayout = AknLayoutScalable_Avkon::popup_note_window_t4(2);
            break;
        case 4:
            textLayout = AknLayoutScalable_Avkon::popup_note_window_t5(2);
            break;
        default:
            textLayout = AknLayoutScalable_Avkon::popup_note_window_t1(2);
            break;
        }

    return textLayout.LayoutLine();
    }

/*
TAknMultiLineTextLayout Multiline_Note_pop_up_window_texts_Line_1(TInt aCommon1, TInt aNumberOfLinesShown);
*/

// LAF Table : Note pop-up window graphics
// C=0 H=p W=352 b= l=0 r= t=0 
// Remark                    : A rectangle to cover the main pane items.
// Parent                    : popup_note_window
// Parent API                : popup_note_window
// Scale API match    ( 69%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_note_window
TAknWindowLineLayout Note_pop_up_window_graphics_Line_1(const TRect& /*aParentRect*/)
    {
    // NOT SUPPORTED
    return EmptyWindowLayout();
    }


// C=86 H=p-22 W=336 b= l=12 r= t=12 
// Remark                    : Second shadow.
// Parent                    : popup_note_window
// Parent API                : popup_note_window
// Scale API match    ( 69%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_note_window
TAknWindowLineLayout Note_pop_up_window_graphics_Line_2(const TRect& /*aParentRect*/)
    {
    // NOT SUPPORTED
    return EmptyWindowLayout();
    }

// C=221 H=p-20 W=338 b= l=8 r= t=8 
// Remark                    : First shadow.
// Parent                    : popup_note_window
// Parent API                : popup_note_window
// Scale API match    ( 69%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_note_window
TAknWindowLineLayout Note_pop_up_window_graphics_Line_3(const TRect& /*aParentRect*/)
    {
    // NOT SUPPORTED
    return EmptyWindowLayout();
    }

// C=215 H=p-18 W=340 b= l=4 r= t=4 
// Remark                    : Outline frame.
// Parent                    : popup_note_window
// Parent API                : popup_note_window
// Scale API match    ( 69%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_note_window
TAknWindowLineLayout Note_pop_up_window_graphics_Line_4(const TRect& /*aParentRect*/)
    {
    // NOT SUPPORTED
    return EmptyWindowLayout();
    }

// C=0 H=p-22 W=336 b= l=6 r= t=6 
// Remark                    : Inside area.
// Parent                    : popup_note_window
// Parent API                : popup_note_window
// Scale API match    ( 69%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_note_window
TAknWindowLineLayout Note_pop_up_window_graphics_Line_5(const TRect& /*aParentRect*/)
    {
    // JH: IMPLEMENTED 13.12.2005
    TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Avkon::bg_popup_window_pane_cp5(1);
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::aid_inside_area_window_primary(varietyIndex);
    return DoCompose(layout1, layout2).LayoutLine();
    }

/*
TAknLayoutTableLimits Note_pop_up_window_graphics_Limits();

TAknWindowLineLayout Note_pop_up_window_graphics(TInt aLineIndex, const TRect& aParentRect);
*/

// LAF Table : Wait or progress note pop-up window elements
// C= H=80 W=60 b= l=280 r= t=8 
// Remark                    : Wait or Progress note icon.
// Parent                    : popup_note_wait_window
// Parent API                : popup_note_wait_window
// Scale API match    ( 34%) : popup_note_wait_window_ParamLimits
// Scale parent match (100%) : popup_note_wait_window
TAknWindowLineLayout Wait_or_progress_note_pop_up_window_elements_Line_1()
    {
    TAknWindowComponentLayout layout;
    layout = AknLayoutScalable_Avkon::popup_note_wait_window_g1(0);
    return layout.LayoutLine();
    }

// C= H=20 W=240 b= l=22 r= t={26, 26, 26} 
// Remark                    : Wait or Progress bar background graphics.
// Parent                    : popup_note_wait_window
// Parent API                : popup_note_wait_window
// Scale API match    ( 34%) : popup_note_wait_window_ParamLimits
// Scale parent match (100%) : popup_note_wait_window
TAknWindowLineLayout Wait_or_progress_note_pop_up_window_elements_Line_2(TInt aIndex_t)
    {
    TAknWindowComponentLayout layout;
    switch (aIndex_t)
        {
        case 0:
            layout = AknLayoutScalable_Avkon::wait_bar_pane(3);
            break;
        case 1:
            layout = AknLayoutScalable_Avkon::wait_bar_pane(2);
            break;
        case 2:
            layout = AknLayoutScalable_Avkon::wait_bar_pane(0);
            break;
        default:
            break;
        }
    return layout.LayoutLine();
    }

// C= H=16 W=38 b= l=22 r= t=26 
// Remark                    : Wait or Progress bar animation.
// Parent                    : popup_note_wait_window
// Parent API                : popup_note_wait_window
// Scale API match    ( 34%) : popup_note_wait_window_ParamLimits
// Scale parent match (100%) : popup_note_wait_window
TAknWindowLineLayout Wait_or_progress_note_pop_up_window_elements_Line_3()
    {
    return Wait_or_progress_note_pop_up_window_elements_Line_2(0);
    /* TODO: Check above line!!
    TAknWindowComponentLayout layout;
    layout = AknLayoutScalable_Avkon::popup_note_window_g1(0);
    return layout.LayoutLine();
    */
    }

// C= H=26 W=26 b= l=22 r= t=94 
// Remark                    : Number type indication.
// Parent                    : popup_note_wait_window
// Parent API                : popup_note_wait_window
// Scale API match    ( 34%) : popup_note_wait_window_ParamLimits
// Scale parent match (100%) : popup_note_wait_window
TAknWindowLineLayout Wait_or_progress_note_pop_up_window_elements_Line_4()
    {
    TAknWindowComponentLayout layout;
    layout = AknLayoutScalable_Avkon::popup_note_wait_window_g2(0);
    return layout.LayoutLine();
    }

/*
// Couple lines removed and these two lines moved from the bottom to keep BC.
TAknLayoutTableLimits First_general_event_elements_Limits();

TAknWindowLineLayout First_general_event_elements(TInt aLineIndex);
  */

// LAF Table : Wait or progress note pop-up window texts
// B={80, 116, 152, 188} C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={248, 310, 310, 310, 280}[aCommon1] l={22, 22, 22, 22, 52}[aCommon1] r={82, 20, 20, 20}[aNotCommon] 
// Remark                    : Note text 1stline 2ndline 3rdline 4thline. Last line.
// Parent                    : popup_note_wait_window
// Parent API                : popup_note_wait_window
// Scale API match    ( 40%) : popup_note_wait_window_t1_ParamLimits
// Scale parent match (100%) : popup_note_wait_window
TAknTextLineLayout Wait_or_progress_note_pop_up_window_texts_Line_1(TInt aCommon1, TInt /*aNotCommon*/, TInt /*aIndex_B*/)
    {
    TAknTextComponentLayout textLayout;
    switch (aCommon1)
        {
        case 0:
            textLayout = AknLayoutScalable_Avkon::popup_note_wait_window_t1(0);
            break;
        case 1:
            textLayout = AknLayoutScalable_Avkon::popup_note_wait_window_t2(0);
            break;
        case 2:
            textLayout = AknLayoutScalable_Avkon::popup_note_wait_window_t3(0);
            break;
        case 3:
            textLayout = AknLayoutScalable_Avkon::popup_note_wait_window_t4(0);
            break;
        case 4:
            textLayout = AknLayoutScalable_Avkon::popup_note_wait_window_t2(1);
            break;
        default:
            break;
        }
    return textLayout.LayoutLine();
    }


/*
TAknMultiLineTextLayout Multiline_Wait_or_progress_note_pop_up_window_texts_Line_1(TInt aCommon1, TInt aNotCommon, TInt aNumberOfLinesShown);
*/

// LAF Table : Note with an image pop-up window elements

// C=221 H=88 W=72 b= l=262 r= t=16 
// Remark                    : Shadow for tnCIF90.
// Parent                    : popup_note_image_window
// Parent API                : popup_note_image_window
// Scale API match    ( 45%) : popup_note_image_window_g1_ParamLimits
// Scale parent match (100%) : popup_note_image_window
TAknWindowLineLayout Note_with_an_image_pop_up_window_elements_Line_1()
    {
    return AknLayoutScalable_Avkon::popup_note_image_window_g2(2).LayoutLine();
    }

// C= H=88 W=72 b= l=260 r= t=14 
// Remark                    : tnCIF90 (36x44)
// Parent                    : popup_note_image_window
// Parent API                : popup_note_image_window
// Scale API match    ( 45%) : popup_note_image_window_g1_ParamLimits
// Scale parent match (100%) : popup_note_image_window
TAknWindowLineLayout Note_with_an_image_pop_up_window_elements_Line_2()
    {
    return AknLayoutScalable_Avkon::popup_note_image_window_g2(2).LayoutLine();
    }

// C=221 H=72 W=88 b= l=246 r= t=16 
// Remark                    : Shadow for tnCIF.
// Parent                    : popup_note_image_window
// Parent API                : popup_note_image_window
// Scale API match    ( 45%) : popup_note_image_window_g1_ParamLimits
// Scale parent match (100%) : popup_note_image_window
TAknWindowLineLayout Note_with_an_image_pop_up_window_elements_Line_3()
    {
    return AknLayoutScalable_Avkon::popup_note_image_window_g2(1).LayoutLine();
    }

// C= H=72 W=88 b= l=244 r= t=14 
// Remark                    : tnCIF (44x36)
// Parent                    : popup_note_image_window
// Parent API                : popup_note_image_window
// Scale API match    ( 45%) : popup_note_image_window_g1_ParamLimits
// Scale parent match (100%) : popup_note_image_window
TAknWindowLineLayout Note_with_an_image_pop_up_window_elements_Line_4()
    {
    return AknLayoutScalable_Avkon::popup_note_image_window_g2(1).LayoutLine();
    }

// C=221 H=80 W=60 b= l=274 r= t=16 
// Remark                    : Shadow for tnVGA90.
// Parent                    : popup_note_image_window
// Parent API                : popup_note_image_window
// Scale API match    ( 45%) : popup_note_image_window_g1_ParamLimits
// Scale parent match (100%) : popup_note_image_window
TAknWindowLineLayout Note_with_an_image_pop_up_window_elements_Line_5()
    {
    return AknLayoutScalable_Avkon::popup_note_image_window_g2(1).LayoutLine();
    }

// C= H=80 W=60 b= l=272 r= t=14 
// Remark                    : tnVGA90 30x40
// Parent                    : popup_note_image_window
// Parent API                : popup_note_image_window
// Scale API match    ( 45%) : popup_note_image_window_g1_ParamLimits
// Scale parent match (100%) : popup_note_image_window
TAknWindowLineLayout Note_with_an_image_pop_up_window_elements_Line_6()
    {
    return AknLayoutScalable_Avkon::popup_note_image_window_g2(1).LayoutLine();
    }

// C=221 H=60 W=80 b= l=254 r= t=16 
// Remark                    : Shadow for tnVGA.
// Parent                    : popup_note_image_window
// Parent API                : popup_note_image_window
// Scale API match    ( 45%) : popup_note_image_window_g1_ParamLimits
// Scale parent match (100%) : popup_note_image_window
TAknWindowLineLayout Note_with_an_image_pop_up_window_elements_Line_7()
    {
    return AknLayoutScalable_Avkon::popup_note_image_window_g2(1).LayoutLine();
    }

// C= H=60 W=80 b= l=252 r= t=14 
// Remark                    : tnVGA (40x30)
// Parent                    : popup_note_image_window
// Parent API                : popup_note_image_window
// Scale API match    ( 45%) : popup_note_image_window_g1_ParamLimits
// Scale parent match (100%) : popup_note_image_window
TAknWindowLineLayout Note_with_an_image_pop_up_window_elements_Line_8()
    {
    return AknLayoutScalable_Avkon::popup_note_image_window_g2(1).LayoutLine();
    }

// C=221 H=96 W=80 b= l=254 r= t=16 
// Remark                    : Shadow for tnCOM.
// Parent                    : popup_note_image_window
// Parent API                : popup_note_image_window
// Scale API match    ( 45%) : popup_note_image_window_g1_ParamLimits
// Scale parent match (100%) : popup_note_image_window
TAknWindowLineLayout Note_with_an_image_pop_up_window_elements_Line_9()
    {
    return AknLayoutScalable_Avkon::popup_note_image_window_g2(2).LayoutLine();
    }

// C= H=96 W=80 b= l=252 r= t=14 
// Remark                    : tnCOM (40x48)
// Parent                    : popup_note_image_window
// Parent API                : popup_note_image_window
// Scale API match    ( 43%) : popup_note_image_window_g1_ParamLimits
// Scale parent match (100%) : popup_note_image_window
TAknWindowLineLayout Note_with_an_image_pop_up_window_elements_Line_10()
    {
    return AknLayoutScalable_Avkon::popup_note_image_window_g2(2).LayoutLine();
    }

// C=221 H= W= b= l= r=18 t=16 
// Remark                    : Shadow for any other size.
// Parent                    : popup_note_image_window
// Parent API                : popup_note_image_window
// Scale API match    ( 43%) : popup_note_image_window_g1_ParamLimits
// Scale parent match (100%) : popup_note_image_window
TAknWindowLineLayout Note_with_an_image_pop_up_window_elements_Line_11()
    {
    return AknLayoutScalable_Avkon::popup_note_image_window_g2(2).LayoutLine();
    }

// C= H=96 W=88 b= l= r=20 t=14 
// Remark                    : Any other size.
// Parent                    : popup_note_image_window
// Parent API                : popup_note_image_window
// Scale API match    ( 43%) : popup_note_image_window_g1_ParamLimits
// Scale parent match (100%) : popup_note_image_window
TAknWindowLineLayout Note_with_an_image_pop_up_window_elements_Line_12()
    {
    return AknLayoutScalable_Avkon::popup_note_image_window_g2(2).LayoutLine();
    }

// C= H=26 W=26 b= l=22 r= t=94 
// Remark                    : Number type indication.
// Parent                    : popup_note_image_window
// Parent API                : popup_note_image_window
// Scale API match    ( 43%) : popup_note_image_window_g1_ParamLimits
// Scale parent match (100%) : popup_note_image_window
TAknWindowLineLayout Note_with_an_image_pop_up_window_elements_Line_13()
    {
    return AknLayoutScalable_Avkon::popup_note_image_window_g1(0).LayoutLine();
    }

/*
TAknLayoutTableLimits Note_with_an_image_pop_up_window_elements_Limits();

TAknWindowLineLayout Note_with_an_image_pop_up_window_elements(TInt aLineIndex);
*/
// LAF Table : Note with an image pop-up window texts
// B={44, 80, 116} C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={310, 310, 280, 240, 210, 228, 198, 220, 190, 212, 182} l={22, 22, 52} r={20, 20, 20, 90, 90, 102, 102, 110, 110, 118} 
// Remark                    : Note text. 1stline. 2ndline. 3rdline. Image width is 30.  Image width is 36.  Image width is 40.  Image width is 44.
// Parent                    : popup_note_image_window
// Parent API                : popup_note_image_window
// Scale API match    ( 51%) : popup_note_image_window_t1_ParamLimits
// Scale parent match (100%) : popup_note_image_window
TAknTextLineLayout Note_with_an_image_pop_up_window_texts_Line_1(TInt aIndex_l, TInt aIndex_r, TInt aIndex_B, TInt aIndex_W)
    {
    TAknTextComponentLayout textLayout;
    if (aIndex_B == 2)
        {
        // Third line
        if (aIndex_l==2)
            {
            // Third line & Number type icon is shown.
            if (aIndex_W <= 2)
                {
                // Icon height is small enough. Text fits under the icon.
                textLayout = AknLayoutScalable_Avkon::popup_note_image_window_t3(0);
                }
            else
                {
                textLayout = AknLayoutScalable_Avkon::popup_note_image_window_t3(2);
                }
            }
        else
            {
            // Third line & Number type icon is not shown.
            if (aIndex_W <= 2)
                {
                // Icon height is small enough. Text fits under the icon.
                textLayout = AknLayoutScalable_Avkon::popup_note_image_window_t3(1);
                }
            else
                {
                textLayout = AknLayoutScalable_Avkon::popup_note_image_window_t3(4);
                }
            }
        }
    else if (aIndex_B == 1)
        {
        // Second line.
        if (aIndex_r <= 2)
            {
            // No thumbnail image
            textLayout = AknLayoutScalable_Avkon::popup_note_image_window_t2(0);
            }
        else
            {
            // Thumbnail image is shown.
            textLayout = AknLayoutScalable_Avkon::popup_note_image_window_t2(2);
            }
        }
    else
        {
        // First line.
        if (aIndex_r <= 2)
            {
            // No thumbnail image
            textLayout = AknLayoutScalable_Avkon::popup_note_image_window_t1(0);
            }
        else
            {
            // Thumbnail image is shown.
            textLayout = AknLayoutScalable_Avkon::popup_note_image_window_t1(2);
            }
        }
    return textLayout.LayoutLine();
    }
    
/*
TAknMultiLineTextLayout Multiline_Note_with_an_image_pop_up_window_texts_Line_1(TInt aIndex_l, TInt aIndex_r, TInt aIndex_W, TInt aNumberOfLinesShown);
*/

// LAF Table : Query with heading window graphics
// C=0 H=p+46 W=352 b= l=0 r= t=p-46 
// Remark                    : A rectangle to cover the main pane items.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 45%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Query_with_heading_window_graphics_Line_1(const TRect& /*aParentRect*/)
    {
    // JH: IMPLEMENTED 09.12.2005
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::bg_popup_window_pane_cp10(0);  
    return layout.LayoutLine();
    }
// C=86 H=p+26 W=336 b= l=12 r= t=p-34 
// Remark                    : Second shadow.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 45%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Query_with_heading_window_graphics_Line_2(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

// C=221 H=p+28 W=338 b= l=8 r= t=p-38 
// Remark                    : First shadow.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 45%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Query_with_heading_window_graphics_Line_3(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

// C=215 H=p+30 W=340 b= l=4 r= t=p-42 
// Remark                    : Outline frame.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 45%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Query_with_heading_window_graphics_Line_4(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

// C=0 H=p+26 W=336 b= l=6 r= t=p-40 
// Remark                    : Inside area.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 45%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Query_with_heading_window_graphics_Line_5(const TRect& /*aParentRect*/)
    {
    // JH: IMPLEMENTED 13.12.2005
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::bg_popup_window_pane(1);
    return layout.LayoutLine();
    }

/*
TAknLayoutTableLimits Query_with_heading_window_graphics_Limits();

TAknWindowLineLayout Query_with_heading_window_graphics(TInt aLineIndex, const TRect& aParentRect);
*/
// LAF Table : Query with heading window descendants
// C= H=46 W=336 b= l=6 r= t=p-40 
// Remark                    : For the dimensions refer to Table 6.3.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 76%) : bg_popup_heading_pane_g_Limits
// Scale parent match (  0%) : 
TAknWindowLineLayout popup_list_heading_pane(const TRect& /*aParentRect*/)
    {
    // JH: IMPLEMENTED 16.12.2005
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::heading_pane(0);
    return layout.LayoutLine();
    }

// LAF Table : Heading pane elements
// C=215 H=2 W=336 b= l=0 r= t=44 
// Remark                    : Horizontal line dividing the window into the heading and the query.
// Parent                    : popup_list_heading_pane
// Parent API                : popup_list_heading_pane
// Scale API match    ( 55%) : heading_pane_ParamLimits
// Scale parent match ( 76%) : bg_popup_heading_pane_g_Limits
TAknWindowLineLayout Heading_pane_elements_Line_1()
    {
    // JH: NOT USED 22.12.2005 & NOT IN SPEC
    return EmptyWindowLayout();
    }

// C= H=32 W=32 b= l=298 r= t={6, 2} 
// Remark                    : 
// Parent                    : popup_list_heading_pane
// Parent API                : popup_list_heading_pane
// Scale API match    (100%) : status_small_icon_pane
// Scale parent match ( 76%) : bg_popup_heading_pane_g_Limits
TAknWindowLineLayout Icon(TInt /*aIndex_t*/)
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::heading_pane_g2();  
    return layout.LayoutLine();
    }

/*
TAknLayoutTableLimits Heading_pane_elements_SUB_TABLE_0_Limits();

TAknLayoutTableLimits Heading_pane_elements_Limits();

TAknWindowLineLayout Heading_pane_elements_SUB_TABLE_0(TInt aLineIndex);

TAknWindowLineLayout Heading_pane_elements_(TInt aLineIndex);
*/

// LAF Table : Heading pane texts
// B=32 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={276, 304, 240} l=16 r=16 
// Remark                    : Query heading text
// Parent                    : popup_list_heading_pane
// Parent API                : popup_list_heading_pane
// Scale API match    ( 70%) : heading_pane_t1_ParamLimits
// Scale parent match ( 76%) : bg_popup_heading_pane_g_Limits
TAknTextLineLayout Heading_pane_texts_Line_1(TInt aIndex_W)
    {
    TInt variety = 0;
    if (aIndex_W == 0)
        {
        variety = 2;
        }
    else if (aIndex_W == 2)
        {
        variety = 1;
        }
    TAknTextComponentLayout layout = AknLayoutScalable_Avkon::heading_pane_t1(variety);  
    return layout.LayoutLine();
    }

// LAF Table : Data query pop-up window elements
// C=221 H=2 W=300 b= l=24 r= t={78, 116, 154} 
// Remark                    : Horizontal shadow inside the editing frame.
// Parent                    : popup_query_data_window
// Parent API                : popup_query_data_window
// Scale API match    ( 50%) : popup_query_data_code_window_ParamLimits
// Scale parent match (100%) : popup_query_data_window
TAknWindowLineLayout Data_query_pop_up_window_elements_Line_1(TInt /*aIndex_t*/)
    {
    // USED 08.11.2005
    // Horizontal shadow. Implementation is not needed.
    return EmptyWindowLayout();
    }

// C=221 H={p-114, p-152, p-190}[aCommon1] W=2 b= l=24 r= t={80, 118, 156}[aCommon1] 
// Remark                    : Vertical shadow inside the editing frame.
// Parent                    : popup_query_data_window
// Parent API                : popup_query_data_window
// Scale API match    ( 50%) : popup_query_data_code_window_ParamLimits
// Scale parent match (100%) : popup_query_data_window
TAknWindowLineLayout Data_query_pop_up_window_elements_Line_2(const TRect& /*aParentRect*/, TInt /*aCommon1*/)
    {
    // USED 08.11.2005
    // Vertical shadow. Implementation is not needed.
    return EmptyWindowLayout();
    }

// C=215 H={p-108, p-146, p-184}[aCommon1] W=304 b= l=22 r= t={76, 114, 152}[aCommon1] 
// Remark                    : Outline for the editing frame.
// Parent                    : popup_query_data_window
// Parent API                : popup_query_data_window
// Scale API match    ( 50%) : popup_query_data_code_window_ParamLimits
// Scale parent match (100%) : popup_query_data_window
TAknWindowLineLayout Data_query_pop_up_window_elements_Line_3(const TRect& /*aParentRect*/, TInt aCommon1)
    {
    // Checked 29.11.2005
    TInt variety = 2 - aCommon1;
    return AknLayoutScalable_Avkon::query_popup_data_pane_cp1( variety ).LayoutLine();
    }

// C= H=18 W=180 b= l=140 r= t={54, 92, 130} 
// Remark                    : Editing state icons.
// Parent                    : popup_query_data_window
// Parent API                : popup_query_data_window
// Scale API match    ( 50%) : popup_query_data_code_window_ParamLimits
// Scale parent match (100%) : popup_query_data_window
TAknWindowLineLayout Data_query_pop_up_window_elements_Line_4(TInt aIndex_t)
    {
    __ASSERT_ALWAYS(0 <= aIndex_t && aIndex_t <= 2, Panic(EParamsOutsideKnownRange));
    TAknWindowComponentLayout layout;
    switch (aIndex_t)
        {
        case 0:
            layout = AknLayoutScalable_Avkon::indicator_popup_pane_cp4(2);
            break;
        case 1:
            layout = AknLayoutScalable_Avkon::indicator_popup_pane_cp4(1);
            break;
        case 2:
            layout = AknLayoutScalable_Avkon::indicator_popup_pane_cp4(0);
            break;
        default:
            break;
        }     
    return layout.LayoutLine();
    }

// C=215 H=30 W=4 b= l= r= t= 
// Remark                    : Cursor graphics.
// Parent                    : popup_query_data_window
// Parent API                : popup_query_data_window
// Scale API match    ( 50%) : popup_query_data_code_window_ParamLimits
// Scale parent match (100%) : popup_query_data_window
TAknWindowLineLayout Data_query_pop_up_window_elements_Line_5()
    {
    return EmptyWindowLayout();
    }

// LAF Table : Data query pop-up window texts
// B={44, 82, 120} C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=304 l=22 r=26 
// Remark                    : Prompt text. One two or three lines.
// Parent                    : popup_query_data_window
// Parent API                : popup_query_data_window
// Scale API match    ( 58%) : popup_query_data_window_t1_ParamLimits
// Scale parent match (100%) : popup_query_data_window
TAknTextLineLayout Data_query_pop_up_window_texts_Line_1(TInt aIndex_B)
    {
    __ASSERT_ALWAYS(0 <= aIndex_B && aIndex_B <= 2, Panic(EParamsOutsideKnownRange));
    TAknTextComponentLayout textLayout;
    switch (aIndex_B)
        {
        case 0:
            textLayout = AknLayoutScalable_Avkon::popup_query_data_window_t1(0);
            break;
        case 1:
            textLayout = AknLayoutScalable_Avkon::popup_query_data_window_t2(0);
            break;
        case 2:
            textLayout = AknLayoutScalable_Avkon::popup_query_data_window_t3(0);
            break;
        default:
            break;
        }     
    return textLayout.LayoutLine();
    }

/*
TAknMultiLineTextLayout Multiline_Data_query_pop_up_window_texts_Line_1(TInt aNumberOfLinesShown);
*/

// B={108, 144, 180, 216, 252, 146, 182, 218, 254, 290, 184} C=215 Font=ELatinBold13_Scaled J={ELayoutAlignLeft, ELayoutAlignRight} W=286 l=34 r=32 
// Remark                    : Alphanumeric data. From one to five lines of text.
// Parent                    : popup_query_data_window
// Parent API                : popup_query_data_window
// Scale API match    ( 58%) : popup_query_data_window_t1_ParamLimits
// Scale parent match (100%) : popup_query_data_window
TAknTextLineLayout Data_query_pop_up_window_texts_Line_2(TInt aIndex_B, TInt /*aIndex_J*/)
    {
    __ASSERT_ALWAYS(0 <= aIndex_B && aIndex_B <= 10, Panic(EParamsOutsideKnownRange));

	// LAY: B= {108, 144, 180, 216, 252,      146, 182, 218, 254, 290,      184}
	// font = 26, 
	// so T = {82, 118, 154, 190, 226,            120, 156, 192, 228, 264,      158}
	// height 
	// SCALABLE T= {152,	116,	80,		152,	152,	152,	152}
	// SCALABLE: H={46,		46,		46,		82,			118,	154,	190}

	// lines of text -> variety
	//				1 -> 2
	//				2 -> 1
	//				3 -> 0

    TInt popupDataPaneOption = 2;
    if (aIndex_B >= 5 && aIndex_B <= 9)
        {
        popupDataPaneOption = 1;
        }
    else if (aIndex_B == 10)
        {
        popupDataPaneOption = 0;
        }
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::query_popup_data_pane_cp1(popupDataPaneOption);

    TInt textIndex = aIndex_B % 5;
	
	// don't have enough information here to know how many lines there are
	// but they are all specified relative to the top, so can use the case of 5 lines
	TInt numLines = 4; // 5 with zero based index 

    TAknTextComponentLayout textLayout = AknLayoutScalable_Avkon::query_popup_data_pane_t(textIndex, numLines);
    return DoComposeText(layout, textLayout).LayoutLine();
    }
    
/*
TAknMultiLineTextLayout Multiline_Data_query_pop_up_window_texts_Line_2(TInt aIndex_J, TInt aNumberOfLinesShown);
*/

// LAF Table : Data query pop-up window graphics
// C=0 H=p W=352 b= l=0 r= t=0 
// Remark                    : A rectangle to cover the main pane items.
// Parent                    : popup_query_data_window
// Parent API                : popup_query_data_window
// Scale API match    ( 53%) : popup_query_data_code_window_g1_ParamLimits
// Scale parent match (100%) : popup_query_data_window
TAknWindowLineLayout Data_query_pop_up_window_graphics_Line_1(const TRect& /*aParentRect*/)
    {
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::bg_popup_window_pane_cp16(0);
    return layout.LayoutLine();
    }

// C=86 H=p-20 W=336 b= l=12 r= t=12 
// Remark                    : Second shadow.
// Parent                    : popup_query_data_window
// Parent API                : popup_query_data_window
// Scale API match    ( 53%) : popup_query_data_code_window_g1_ParamLimits
// Scale parent match (100%) : popup_query_data_window
TAknWindowLineLayout Data_query_pop_up_window_graphics_Line_2(const TRect& /*aParentRect*/)
    {
    // NOT SUPPORTED
    return EmptyWindowLayout();
    }

// C=221 H=p-18 W=338 b= l=8 r= t=8 
// Remark                    : First shadow.
// Parent                    : popup_query_data_window
// Parent API                : popup_query_data_window
// Scale API match    ( 53%) : popup_query_data_code_window_g1_ParamLimits
// Scale parent match (100%) : popup_query_data_window
TAknWindowLineLayout Data_query_pop_up_window_graphics_Line_3(const TRect& /*aParentRect*/)
    {
    // NOT SUPPORTED
    return EmptyWindowLayout();
    }

// C=215 H=p-16 W=340 b= l=4 r= t=4 
// Remark                    : Outline frame.
// Parent                    : popup_query_data_window
// Parent API                : popup_query_data_window
// Scale API match    ( 53%) : popup_query_data_code_window_g1_ParamLimits
// Scale parent match (100%) : popup_query_data_window
TAknWindowLineLayout Data_query_pop_up_window_graphics_Line_4(const TRect& /*aParentRect*/)
    {
    // NOT SUPPORTED
    return EmptyWindowLayout();
    }

// C=0 H=p-20 W=336 b= l=6 r= t=6 
// Remark                    : Inside area.
// Parent                    : popup_query_data_window
// Parent API                : popup_query_data_window
// Scale API match    ( 53%) : popup_query_data_code_window_g1_ParamLimits
// Scale parent match (100%) : popup_query_data_window
TAknWindowLineLayout Data_query_pop_up_window_graphics_Line_5(const TRect& /*aParentRect*/)
    {
    TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Avkon::bg_popup_window_pane_cp16(0);
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::aid_inside_area_window_primary(varietyIndex);
    return DoCompose(layout1, layout2).LayoutLine();
    }
/*
TAknLayoutTableLimits Data_query_pop_up_window_graphics_Limits();

TAknWindowLineLayout Data_query_pop_up_window_graphics(TInt aLineIndex, const TRect& aParentRect);
*/

// LAF Table : Code query pop-up window elements
// C=221 H=2 W=300 b= l=24 r= t={78, 116, 154} 
// Remark                    : Horizontal shadow inside the editing frame.
// Parent                    : popup_query_code_window
// Parent API                : popup_query_code_window
// Scale API match    ( 50%) : popup_query_code_window_ParamLimits
// Scale parent match (100%) : popup_query_code_window
TAknWindowLineLayout Code_query_pop_up_window_elements_Line_1(TInt /*aIndex_t*/)
    {
    // NOT SUPPORTED
    return EmptyWindowLayout();
    }

// C=221 H=40 W=2 b= l=24 r= t={80, 118, 156} 
// Remark                    : Vertical shadow inside the editing frame.
// Parent                    : popup_query_code_window
// Parent API                : popup_query_code_window
// Scale API match    ( 50%) : popup_query_code_window_ParamLimits
// Scale parent match (100%) : popup_query_code_window
TAknWindowLineLayout Code_query_pop_up_window_elements_Line_2(TInt /*aIndex_t*/)
    {
    // NOT SUPPORTED
    return EmptyWindowLayout();
    }

// C=215 H=46 W=304 b= l=22 r= t={76, 114, 152} 
// Remark                    : Outline for the editing frame.
// Parent                    : popup_query_code_window
// Parent API                : popup_query_code_window
// Scale API match    ( 50%) : popup_query_code_window_ParamLimits
// Scale parent match (100%) : popup_query_code_window
TAknWindowLineLayout Code_query_pop_up_window_elements_Line_3(TInt aIndex_t)
    {
    // NOT SUPPORTED
    return AknLayoutScalable_Avkon::query_popup_pane(aIndex_t);
    }

// C= H=18 W=180 b= l=140 r= t={54, 92, 130} 
// Remark                    : Editing state icons.
// Parent                    : popup_query_code_window
// Parent API                : popup_query_code_window
// Scale API match    ( 50%) : popup_query_code_window_ParamLimits
// Scale parent match (100%) : popup_query_code_window
TAknWindowLineLayout Code_query_pop_up_window_elements_Line_4(TInt aIndex_t)
    {
    __ASSERT_ALWAYS(0 <= aIndex_t && aIndex_t <= 2, Panic(EParamsOutsideKnownRange));
    TAknWindowComponentLayout layout;
    switch (aIndex_t)
        {
        case 0:
            layout = AknLayoutScalable_Avkon::indicator_popup_pane(0);
            break;
        case 1:
            layout = AknLayoutScalable_Avkon::indicator_popup_pane(1);
            break;
        case 2:
            layout = AknLayoutScalable_Avkon::indicator_popup_pane(2);
            break;
        default:
            break;
        }     
    return layout.LayoutLine();
    }

/*
TAknLayoutTableLimits Code_query_pop_up_window_elements_Limits();

TAknWindowLineLayout Code_query_pop_up_window_elements(TInt aLineIndex, TInt aIndex_t);
*/

// LAF Table : Code query pop-up window texts
// B={44, 82, 120} C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=304 l=22 r=26 
// Remark                    : Prompt text. One two or three lines.
// Parent                    : popup_query_code_window
// Parent API                : popup_query_code_window
// Scale API match    ( 58%) : popup_query_code_window_t1_ParamLimits
// Scale parent match (100%) : popup_query_code_window
TAknTextLineLayout Code_query_pop_up_window_texts_Line_1(TInt aIndex_B)
    {
    __ASSERT_ALWAYS(0 <= aIndex_B && aIndex_B <= 2, Panic(EParamsOutsideKnownRange));
    TAknTextComponentLayout textLayout;
    switch (aIndex_B)
        {
        case 0:
            textLayout = AknLayoutScalable_Avkon::popup_query_code_window_t1(2);
            break;
        case 1:
            textLayout = AknLayoutScalable_Avkon::popup_query_code_window_t2(2);
            break;
        case 2:
            textLayout = AknLayoutScalable_Avkon::popup_query_code_window_t3(2);
            break;
        default:
            break;
        }     
    return textLayout.LayoutLine();
    }

/*
TAknMultiLineTextLayout Multiline_Code_query_pop_up_window_texts_Line_1(TInt aNumberOfLinesShown);
*/

// B={108, 146, 184} C=215 Font=ELatinBold13_Scaled J=ELayoutAlignCenter W=286 l=34 r=32 
// Remark                    : Code entry.
// Parent                    : popup_query_code_window
// Parent API                : popup_query_code_window
// Scale API match    ( 58%) : popup_query_code_window_t1_ParamLimits
// Scale parent match (100%) : popup_query_code_window
TAknTextLineLayout Code_query_pop_up_window_texts_Line_2(TInt aIndex_B)
    {
    __ASSERT_ALWAYS(0 <= aIndex_B && aIndex_B <= 2, Panic(EParamsOutsideKnownRange));
    TAknWindowComponentLayout layout;
    switch (aIndex_B)
        {
        case 0:
            layout = AknLayoutScalable_Avkon::query_popup_pane(0);
            break;
        case 1:
            layout = AknLayoutScalable_Avkon::query_popup_pane(1);
            break;
        case 2:
            layout = AknLayoutScalable_Avkon::query_popup_pane(2);
            break;
        default:
            break;
        }     
    TAknTextComponentLayout textLayout = AknLayoutScalable_Avkon::query_popup_pane_t1();
    return DoComposeText(layout, textLayout).LayoutLine();
    }
    
/*
TAknMultiLineTextLayout Multiline_Code_query_pop_up_window_texts_Line_2(TInt aNumberOfLinesShown)

TAknLayoutTableLimits Code_query_pop_up_window_texts_Limits();

TAknTextLineLayout Code_query_pop_up_window_texts(TInt aLineIndex, TInt aIndex_B);
*/

// LAF Table : Combined data and code query pop-up window elements
// C={221, 0} H=2 W=300 b= l=24 r= t={78, 214, 116, 252, 78, 252, 126, 300} 
// Remark                    : Horizontal shadows inside the editing frames.
// Parent                    : popup_query_data_code_window
// Parent API                : popup_query_data_code_window
// Scale API match    ( 42%) : popup_query_data_code_window_ParamLimits
// Scale parent match (100%) : popup_query_data_code_window
TAknWindowLineLayout Combined_data_and_code_query_pop_up_window_elements_Line_1(TInt /*aIndex_C*/, TInt /*aIndex_t*/)
    {
    return EmptyWindowLayout();
    }

// C={221, 0} H=40 W=2 b= l=24 r= t={80, 216, 118, 254, 80, 254, 128, 302} 
// Remark                    : Vertical shadows inside the editing frames.
// Parent                    : popup_query_data_code_window
// Parent API                : popup_query_data_code_window
// Scale API match    ( 42%) : popup_query_data_code_window_ParamLimits
// Scale parent match (100%) : popup_query_data_code_window
TAknWindowLineLayout Combined_data_and_code_query_pop_up_window_elements_Line_2(TInt /*aIndex_C*/, TInt /*aIndex_t*/)
    {
    return EmptyWindowLayout();
    }

// C=219 H=2 W=328 b= l=10 r= t={140, 178, 140, 188} 
// Remark                    : Line between entry fields.
// Parent                    : popup_query_data_code_window
// Parent API                : popup_query_data_code_window
// Scale API match    ( 42%) : popup_query_data_code_window_ParamLimits
// Scale parent match (100%) : popup_query_data_code_window
TAknWindowLineLayout Combined_data_and_code_query_pop_up_window_elements_Line_3(TInt aIndex_t)
    {
    __ASSERT_ALWAYS(0 <= aIndex_t && aIndex_t <= 3, Panic(EParamsOutsideKnownRange));
    TAknWindowComponentLayout layout;
    switch (aIndex_t)
        {
        case 0:
            layout = AknLayoutScalable_Avkon::popup_query_data_code_window_g1(3);
            break;
        case 1:
            layout = AknLayoutScalable_Avkon::popup_query_data_code_window_g1(1);
            break;
        case 2:
            layout = AknLayoutScalable_Avkon::popup_query_data_code_window_g1(2);
            break;
        case 3:
            layout = AknLayoutScalable_Avkon::popup_query_data_code_window_g1(0);
            break;
        default:
            break;
        }     
    return layout.LayoutLine();    
    }



// C=215 H=46 W=304 b= l=22 r= t={76, 212, 114, 250, 76, 250, 124, 298} 
// Remark                    : Outlines for the editing frames.
// Parent                    : popup_query_data_code_window
// Parent API                : popup_query_data_code_window
// Scale API match    ( 42%) : popup_query_data_code_window_ParamLimits
// Scale parent match (100%) : popup_query_data_code_window
TAknWindowLineLayout Combined_data_and_code_query_pop_up_window_elements_Line_4(TInt aIndex_t)
    {
    TAknWindowComponentLayout layout;
    switch (aIndex_t)
        {
        case 0:
            layout = AknLayoutScalable_Avkon::query_popup_data_pane_cp2(3);
            break;
        case 1:
            layout = AknLayoutScalable_Avkon::query_popup_pane_cp2(3);
            break;
        case 2:
            layout = AknLayoutScalable_Avkon::query_popup_data_pane_cp2(1);
            break;
        case 3:
            layout = AknLayoutScalable_Avkon::query_popup_pane_cp2(1);
            break;
        case 4:
            layout = AknLayoutScalable_Avkon::query_popup_data_pane_cp2(2);
            break;
        case 5:
            layout = AknLayoutScalable_Avkon::query_popup_pane_cp2(2);
            break;
        case 6:
            layout = AknLayoutScalable_Avkon::query_popup_data_pane_cp2(0);
            break;
        case 7:
            layout = AknLayoutScalable_Avkon::query_popup_pane_cp2(0);
            break;
        default:
            break;
        }
    return layout.LayoutLine();    
    }


// C= H=18 W=180 b= l=140 r= t={54, 190, 92, 228, 54, 228, 102, 276} 
// Remark                    : Editing state icons.
// Parent                    : popup_query_data_code_window
// Parent API                : popup_query_data_code_window
// Scale API match    ( 42%) : popup_query_data_code_window_ParamLimits
// Scale parent match (100%) : popup_query_data_code_window
TAknWindowLineLayout Combined_data_and_code_query_pop_up_window_elements_Line_5(TInt aIndex_t)
    {
    __ASSERT_ALWAYS(0 <= aIndex_t && aIndex_t <= 7, Panic(EParamsOutsideKnownRange));
    TAknWindowComponentLayout layout;
    switch (aIndex_t)
        {
        case 0:
            layout = AknLayoutScalable_Avkon::indicator_popup_pane_cp1(3);
            break;
        case 1:
            layout = AknLayoutScalable_Avkon::indicator_popup_pane_cp2(3);
            break;
        case 2:
            layout = AknLayoutScalable_Avkon::indicator_popup_pane_cp1(1);
            break;
        case 3:
            layout = AknLayoutScalable_Avkon::indicator_popup_pane_cp2(1);
            break;
        case 4:
            layout = AknLayoutScalable_Avkon::indicator_popup_pane_cp1(2);
            break;
        case 5:
            layout = AknLayoutScalable_Avkon::indicator_popup_pane_cp2(2);
            break;
        case 6:
            layout = AknLayoutScalable_Avkon::indicator_popup_pane_cp1(0);
            break;
        case 7:
            layout = AknLayoutScalable_Avkon::indicator_popup_pane_cp2(0);
            break;
        default:
            break;
        }     
    return layout.LayoutLine();    
    }

// LAF Table : Combined data and code query pop-up window texts
// B={44, 82, 54, 92} C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=304 l=22 r=26 
// Remark                    : Data prompt text. One or two lines.
// Parent                    : popup_query_data_code_window
// Parent API                : popup_query_data_code_window
// Scale API match    ( 46%) : popup_query_data_code_window_t1_ParamLimits
// Scale parent match (100%) : popup_query_data_code_window
TAknTextLineLayout Combined_data_and_code_query_pop_up_window_texts_Line_1(TInt aIndex_B)
    {
    __ASSERT_ALWAYS(0 <= aIndex_B && aIndex_B <= 3, Panic(EParamsOutsideKnownRange));
    TAknTextComponentLayout textLayout;
    switch (aIndex_B)
        {
        case 0:
            textLayout = AknLayoutScalable_Avkon::popup_query_data_code_window_t1(1);
            break;
        case 1:
            textLayout = AknLayoutScalable_Avkon::popup_query_data_code_window_t2(1);
            break;
        case 2:
            textLayout = AknLayoutScalable_Avkon::popup_query_data_code_window_t1(0);
            break;
        case 3:
            textLayout = AknLayoutScalable_Avkon::popup_query_data_code_window_t2(0);
            break;
        default:
            break;
        }     
    return textLayout.LayoutLine();
    }

/*
TAknMultiLineTextLayout Multiline_Combined_data_and_code_query_pop_up_window_texts_Line_1(TInt aNumberOfLinesShown);
*/

// B={108, 146, 156} C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=286 l=34 r=32 
// Remark                    : Data entry.
// Parent                    : popup_query_data_code_window
// Parent API                : popup_query_data_code_window
// Scale API match    ( 46%) : popup_query_data_code_window_t1_ParamLimits
// Scale parent match (100%) : popup_query_data_code_window
TAknTextLineLayout Combined_data_and_code_query_pop_up_window_texts_Line_2(TInt aIndex_B)
    {
    __ASSERT_ALWAYS(0 <= aIndex_B && aIndex_B <= 2, Panic(EParamsOutsideKnownRange));
    TAknWindowComponentLayout layout;
    switch (aIndex_B)
        {
        case 0:
            layout = AknLayoutScalable_Avkon::query_popup_data_pane_cp2(3);
            break;
        case 1:
            layout = AknLayoutScalable_Avkon::query_popup_data_pane_cp2(1);
            break;
        case 2:
            layout = AknLayoutScalable_Avkon::query_popup_data_pane_cp2(0);
            break;
        default:
            break;
        }     
    TAknTextComponentLayout textLayout = AknLayoutScalable_Avkon::query_popup_data_pane_t1(0); // AsM 24082005
    return DoComposeText(layout, textLayout).LayoutLine();
    }

/*
TAknMultiLineTextLayout Multiline_Combined_data_and_code_query_pop_up_window_texts_Line_2(TInt aNumberOfLinesShown);
*/

// B={180, 218, 218, 228, 266} C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=304 l=22 r=26 
// Remark                    : Code prompt text. One or two lines.
// Parent                    : popup_query_data_code_window
// Parent API                : popup_query_data_code_window
// Scale API match    ( 46%) : popup_query_data_code_window_t1_ParamLimits
// Scale parent match (100%) : popup_query_data_code_window
TAknTextLineLayout Combined_data_and_code_query_pop_up_window_texts_Line_3(TInt aIndex_B)
    {
    __ASSERT_ALWAYS(0 <= aIndex_B && aIndex_B <= 4, Panic(EParamsOutsideKnownRange));
    TAknTextComponentLayout textLayout;
    switch (aIndex_B)
        {
        case 0:
            textLayout = AknLayoutScalable_Avkon::popup_query_data_code_window_t3(2);
            break;
        case 1:
            textLayout = AknLayoutScalable_Avkon::popup_query_data_code_window_t4(1);
            break;
        case 2:
            textLayout = AknLayoutScalable_Avkon::popup_query_data_code_window_t3(1);
            break;
        case 3:
            textLayout = AknLayoutScalable_Avkon::popup_query_data_code_window_t3(0);
            break;
        case 4:
            textLayout = AknLayoutScalable_Avkon::popup_query_data_code_window_t4(0);
            break;
        default:
            break;
        }     
    return textLayout.LayoutLine();
    }
/*
TAknMultiLineTextLayout Multiline_Combined_data_and_code_query_pop_up_window_texts_Line_3(TInt aNumberOfLinesShown);
*/

// B={244, 282, 330} C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=286 l=34 r=32 
// Remark                    : Code entry.
// Parent                    : popup_query_data_code_window
// Parent API                : popup_query_data_code_window
// Scale API match    ( 46%) : popup_query_data_code_window_t1_ParamLimits
// Scale parent match (100%) : popup_query_data_code_window
TAknTextLineLayout Combined_data_and_code_query_pop_up_window_texts_Line_4(TInt aIndex_B)
    {
    __ASSERT_ALWAYS(0 <= aIndex_B && aIndex_B <= 2, Panic(EParamsOutsideKnownRange));
    TAknWindowComponentLayout layout;
    switch (aIndex_B)
        {
        case 0:
            layout = AknLayoutScalable_Avkon::query_popup_pane_cp2(3);
            break;
        case 1:
            layout = AknLayoutScalable_Avkon::query_popup_pane_cp2(1);
            break;
        case 2:
            layout = AknLayoutScalable_Avkon::query_popup_pane_cp2(0);
            break;
        default:
            break;
        }     
    TAknTextComponentLayout textLayout = AknLayoutScalable_Avkon::query_popup_pane_t1();
    return DoComposeText(layout, textLayout).LayoutLine();
    }

/*
TAknMultiLineTextLayout Multiline_Combined_data_and_code_query_pop_up_window_texts_Line_4(TInt aNumberOfLinesShown)

TAknLayoutTableLimits Combined_data_and_code_query_pop_up_window_texts_Limits();

TAknTextLineLayout Combined_data_and_code_query_pop_up_window_texts(TInt aLineIndex, TInt aIndex_B);
*/

// LAF Table : Combined data and code query pop-up window graphics
// C=0 H=p W=352 b= l=0 r= t=0 
// Remark                    : A rectangle to cover the main pane items.
// Parent                    : popup_query_data_code_window
// Parent API                : popup_query_data_code_window
// Scale API match    ( 44%) : popup_query_data_code_window_g1_ParamLimits
// Scale parent match (100%) : popup_query_data_code_window
TAknWindowLineLayout Combined_data_and_code_query_pop_up_window_graphics_Line_1(const TRect& /*aParentRect*/)
    {
    // JH: IMPLEMENTED 09.12.2005
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::bg_popup_window_pane_cp15(0);
    return layout.LayoutLine();
    }

// C=86 H={p-20, p-30} W=336 b= l=12 r= t=12 
// Remark                    : Second shadow.
// Parent                    : popup_query_data_code_window
// Parent API                : popup_query_data_code_window
// Scale API match    ( 44%) : popup_query_data_code_window_g1_ParamLimits
// Scale parent match (100%) : popup_query_data_code_window
TAknWindowLineLayout Combined_data_and_code_query_pop_up_window_graphics_Line_2(const TRect& /*aParentRect*/, TInt /*aIndex_H*/)
    {
    return EmptyWindowLayout();
    }

// C=221 H={p-18, p-28} W=338 b= l=8 r= t=8 
// Remark                    : First shadow.
// Parent                    : popup_query_data_code_window
// Parent API                : popup_query_data_code_window
// Scale API match    ( 44%) : popup_query_data_code_window_g1_ParamLimits
// Scale parent match (100%) : popup_query_data_code_window
TAknWindowLineLayout Combined_data_and_code_query_pop_up_window_graphics_Line_3(const TRect& /*aParentRect*/, TInt /*aIndex_H*/)
    {
    return EmptyWindowLayout();
    }

// C=215 H={p-16, p-26} W=340 b= l=4 r= t=4 
// Remark                    : Outline frame.
// Parent                    : popup_query_data_code_window
// Parent API                : popup_query_data_code_window
// Scale API match    ( 44%) : popup_query_data_code_window_g1_ParamLimits
// Scale parent match (100%) : popup_query_data_code_window
TAknWindowLineLayout Combined_data_and_code_query_pop_up_window_graphics_Line_4(const TRect& /*aParentRect*/, TInt /*aIndex_H*/)
    {
    return EmptyWindowLayout();
    }

// C=0 H={p-20, p-30} W=336 b= l=6 r= t=6 
// Remark                    : Inside area.
// Parent                    : popup_query_data_code_window
// Parent API                : popup_query_data_code_window
// Scale API match    ( 44%) : popup_query_data_code_window_g1_ParamLimits
// Scale parent match (100%) : popup_query_data_code_window
TAknWindowLineLayout Combined_data_and_code_query_pop_up_window_graphics_Line_5(const TRect& /*aParentRect*/, TInt aIndex_H)
    {
    // JH: IMPLEMENTED 23.12.2005
    TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Avkon::bg_popup_window_pane(aIndex_H);
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::aid_inside_area_window_primary(varietyIndex);
    return DoCompose(layout1, layout2).LayoutLine();
    }
    
/*
TAknLayoutTableLimits Combined_data_and_code_query_pop_up_window_graphics_SUB_TABLE_0_Limits();

TAknWindowLineLayout Combined_data_and_code_query_pop_up_window_graphics_SUB_TABLE_0(TInt aLineIndex, const TRect& aParentRect, TInt aIndex_H);
*/

// LAF Table : Find pop-up window elements
// C=221 H=42 W=2 b= l=50 r= t=16 
// Remark                    : Vertical shadow inside the find box frame.
// Parent                    : popup_find_window
// Parent API                : popup_find_window
// Scale API match    ( 42%) : bg_popup_window_pane_ParamLimits
// Scale parent match (100%) : popup_find_window
TAknWindowLineLayout Find_pop_up_window_elements_Line_1()
    {
    // Vertical shadow
    return EmptyWindowLayout();
    }


// C=221 H=2 W=280 b= l=52 r= t=16 
// Remark                    : Horizontal shadow inside the find box frame.
// Parent                    : popup_find_window
// Parent API                : popup_find_window
// Scale API match    ( 42%) : bg_popup_window_pane_ParamLimits
// Scale parent match (100%) : popup_find_window
TAknWindowLineLayout Find_pop_up_window_elements_Line_2()
    {
    // Horizontal shadow
    return EmptyWindowLayout();
    }


// C=215 H=46 W=286 b= l=48 r= t=14 
// Remark                    : Outline frame.
// Parent                    : popup_find_window
// Parent API                : popup_find_window
// Scale API match    ( 42%) : bg_popup_window_pane_ParamLimits
// Scale parent match (100%) : popup_find_window
TAknWindowLineLayout Find_pop_up_window_elements_Line_3()
    {
    // Outline frame
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Avkon::find_popup_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::input_popup_find_pane_cp();
    return DoCompose(layout1, layout2).LayoutLine();
    }



// C= H=52 W=48 b= l=14 r= t=10 
// Remark                    : Magnifying glass icon.
// Parent                    : popup_find_window
// Parent API                : popup_find_window
// Scale API match    ( 42%) : bg_popup_window_pane_ParamLimits
// Scale parent match (100%) : popup_find_window
TAknWindowLineLayout Find_pop_up_window_elements_Line_4()
    {
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Avkon::find_popup_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::find_popup_pane_g1();
    return DoCompose(layout1, layout2).LayoutLine();
    }

/*
TAknLayoutTableLimits Find_pop_up_window_elements_Limits();

TAknWindowLineLayout Find_pop_up_window_elements(TInt aLineIndex);
*/

// LAF Table : Find pop-up window texts
// B=46 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=260 l=66 r=26 
// Remark                    : Search string.
// Parent                    : popup_find_window
// Parent API                : popup_find_window
// Scale API match    ( 56%) : popup_snote_single_text_window_t1_ParamLimits
// Scale parent match (100%) : popup_find_window
TAknTextLineLayout Find_pop_up_window_texts_Line_1()
    {
    // Empty space is left for find pane editor indicator in 'APAC variants' if 
    // this layout is called.
    // Large text is assumed.
    TInt varietyIndex = Layout_Meta_Data::IsAPAC() ? 2 : 0; 
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Avkon::find_popup_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::input_popup_find_pane_cp();
    TAknTextComponentLayout layout3 = AknLayoutScalable_Avkon::input_popup_find_pane_t1(varietyIndex);
    return DoComposeText( DoCompose(layout1, layout2), layout3 ).LayoutLine();
    }


// LAF Table : Find pop-up window graphics
// C=0 H=82 W=352 b= l=0 r= t=0 
// Remark                    : A rectangle to cover the main pane items.
// Parent                    : popup_find_window
// Parent API                : popup_find_window
// Scale API match    ( 61%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_find_window
TAknWindowLineLayout Find_pop_up_window_graphics_Line_1()
    {
    // JH: IMPLEMENTED 19.12.2005
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::bg_popup_window_pane_cp12();
    return layout.LayoutLine();
    }


// C=86 H=62 W=336 b= l=12 r= t=12 
// Remark                    : Second shadow.
// Parent                    : popup_find_window
// Parent API                : popup_find_window
// Scale API match    ( 61%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_find_window
TAknWindowLineLayout Find_pop_up_window_graphics_Line_2()
    {
    return EmptyWindowLayout();
    }


// C=221 H=64 W=338 b= l=8 r= t=8 
// Remark                    : First shadow.
// Parent                    : popup_find_window
// Parent API                : popup_find_window
// Scale API match    ( 61%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_find_window
TAknWindowLineLayout Find_pop_up_window_graphics_Line_3()
    {
    return EmptyWindowLayout();
    }

// C=215 H=66 W=340 b= l=4 r= t=4 
// Remark                    : Outline frame.
// Parent                    : popup_find_window
// Parent API                : popup_find_window
// Scale API match    ( 61%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_find_window
TAknWindowLineLayout Find_pop_up_window_graphics_Line_4()
    {
    return EmptyWindowLayout();
    }

// C=0 H=62 W=336 b= l=6 r= t=6 
// Remark                    : Inside area.
// Parent                    : popup_find_window
// Parent API                : popup_find_window
// Scale API match    ( 61%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_find_window
TAknWindowLineLayout Find_pop_up_window_graphics_Line_5()
    {
    // JH: IMPLEMENTED 19.12.2005
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::find_popup_pane();
    return layout.LayoutLine();
    }

/*
TAknLayoutTableLimits Find_pop_up_window_graphics_Limits();

TAknWindowLineLayout Find_pop_up_window_graphics(TInt aLineIndex);
*/

// LAF Table : Pop-up menu with find pane graphics
// C=0 H=p+58 W=352 b= l=0 r= t=0 
// Remark                    : A rectangle to cover the main pane items.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 38%) : cell_large_graphic_colour_none_popup_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Pop_up_menu_with_find_pane_graphics_Line_1(const TRect& /*aParentRect*/)
    {
	// TPTODO
	TAknWindowComponentLayout layoutWithoutFind = AknLayoutScalable_Avkon::popup_window_general(0); // without find pane
	TAknWindowComponentLayout layoutWithFind = AknLayoutScalable_Avkon::popup_window_general(3); // with find pane
	return TAknWindowComponentLayout::SiblingAsChild(layoutWithoutFind, layoutWithFind).LayoutLine();
    }


// C=86 H=p+58 W=336 b= l=12 r= t=12 
// Remark                    : Second shadow.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 38%) : cell_large_graphic_colour_none_popup_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Pop_up_menu_with_find_pane_graphics_Line_2(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }


// C=221 H=p+58 W=338 b= l=8 r= t=8 
// Remark                    : First shadow.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 38%) : cell_large_graphic_colour_none_popup_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Pop_up_menu_with_find_pane_graphics_Line_3(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }


// C=215 H=p+58 W=340 b= l=4 r= t=4 
// Remark                    : Outline frame.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 38%) : cell_large_graphic_colour_none_popup_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Pop_up_menu_with_find_pane_graphics_Line_4(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }


// C=0 H=p+58 W=336 b= l=6 r= t=6 
// Remark                    : Inside area.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 38%) : cell_large_graphic_colour_none_popup_pane_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Pop_up_menu_with_find_pane_graphics_Line_5(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }


/*
TAknLayoutTableLimits Pop_up_menu_with_find_pane_graphics_Limits();

TAknWindowLineLayout Pop_up_menu_with_find_pane_graphics(TInt aLineIndex, const TRect& aParentRect);
*/

// LAF Table : Notification pop-up window elements (text)
// C= H=14 W=352 b= l=0 r= t=0 
// Remark                    : 2ndand 3rd(etc.) notification indication.
// Parent                    : popup_snote_single_text_window
// Parent API                : popup_snote_single_text_window
// Scale API match    ( 29%) : popup_snote_single_text_window_t_Limits
// Scale parent match (100%) : popup_snote_single_text_window
TAknWindowLineLayout Notification_pop_up_window_elements__text__Line_1()
    {
    return AknLayoutScalable_Avkon::popup_snote_single_text_window_g1(0).LayoutLine();
    }

// LAF Table : Notification pop-up window texts (text)
// B={56, 92, 128, 164, 200} C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=310 l=22 r=20 
// Remark                    : Notification text. Max. five rows of text.
// Parent                    : popup_snote_single_text_window
// Parent API                : popup_snote_single_text_window
// Scale API match    ( 40%) : popup_snote_single_text_window_t_Limits
// Scale parent match (100%) : popup_snote_single_text_window
TAknTextLineLayout Notification_pop_up_window_texts__text__Line_1(TInt aIndex_B)
    {
    TAknTextComponentLayout textLayout;
    switch (aIndex_B)
        {
        case 0:
            textLayout = AknLayoutScalable_Avkon::popup_snote_single_text_window_t1(0);
            break;
        case 1:
            textLayout = AknLayoutScalable_Avkon::popup_snote_single_text_window_t2(0);
            break;
        case 2:
            textLayout = AknLayoutScalable_Avkon::popup_snote_single_text_window_t3(1); // AsM 22082005
            break;
        case 3:
            textLayout = AknLayoutScalable_Avkon::popup_snote_single_text_window_t4(2); // AsM 22082005
            break;
        case 4:
            textLayout = AknLayoutScalable_Avkon::popup_snote_single_text_window_t5(3); // AsM 22082005
            break;
        default:
            textLayout = AknLayoutScalable_Avkon::popup_snote_single_text_window_t1(0);
            break;
        }
    return textLayout.LayoutLine();
    }

/*
TAknMultiLineTextLayout Multiline_Notification_pop_up_window_texts__text__Line_1(TInt aNumberOfLinesShown);
*/

// LAF Table : Notification pop-up window graphics (text)
// C=0 H=p-12 W=352 b= l=0 r= t=12 
// Remark                    : A rectangle to cover the main pane items.
// Parent                    : popup_snote_single_text_window
// Parent API                : popup_snote_single_text_window
// Scale API match    ( 36%) : popup_snote_single_graphic_window_g_Limits
// Scale parent match (100%) : popup_snote_single_text_window
TAknWindowLineLayout Notification_pop_up_window_graphics__text__Line_1(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

// C=86 H=p-32 W=336 b= l=12 r= t=24 
// Remark                    : Second shadow.
// Parent                    : popup_snote_single_text_window
// Parent API                : popup_snote_single_text_window
// Scale API match    ( 36%) : popup_snote_single_graphic_window_g_Limits
// Scale parent match (100%) : popup_snote_single_text_window
TAknWindowLineLayout Notification_pop_up_window_graphics__text__Line_2(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

// C=221 H=p-30 W=338 b= l=8 r= t=20 
// Remark                    : First shadow.
// Parent                    : popup_snote_single_text_window
// Parent API                : popup_snote_single_text_window
// Scale API match    ( 36%) : popup_snote_single_graphic_window_g_Limits
// Scale parent match (100%) : popup_snote_single_text_window
TAknWindowLineLayout Notification_pop_up_window_graphics__text__Line_3(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

// C=215 H=p-28 W=340 b= l=4 r= t=16 
// Remark                    : Outline frame.
// Parent                    : popup_snote_single_text_window
// Parent API                : popup_snote_single_text_window
// Scale API match    ( 36%) : popup_snote_single_graphic_window_g_Limits
// Scale parent match (100%) : popup_snote_single_text_window
TAknWindowLineLayout Notification_pop_up_window_graphics__text__Line_4(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

// C=0 H=p-32 W=336 b= l=6 r= t=18 
// Remark                    : Inside area.
// Parent                    : popup_snote_single_text_window
// Parent API                : popup_snote_single_text_window
// Scale API match    ( 36%) : popup_snote_single_graphic_window_g_Limits
// Scale parent match (100%) : popup_snote_single_text_window
TAknWindowLineLayout Notification_pop_up_window_graphics__text__Line_5(const TRect& /*aParentRect*/)
    {
    TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Avkon::bg_popup_window_pane_cp8(0);
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::aid_inside_area_window_primary(varietyIndex);
    return DoCompose(layout1, layout2).LayoutLine();
    }

/*
TAknLayoutTableLimits Notification_pop_up_window_graphics__text__Limits();

TAknWindowLineLayout Notification_pop_up_window_graphics__text_(TInt aLineIndex, const TRect& aParentRect);

*/
// LAF Table : Notification pop-up window elements (graphic)
// C= H=14 W=352 b= l=0 r= t=0 
// Remark                    : 2ndand 3rd(etc.) notification indication.
// Parent                    : popup_snote_single_graphic_window
// Parent API                : popup_snote_single_graphic_window
// Scale API match    ( 34%) : popup_snote_single_graphic_window_g_Limits
// Scale parent match (100%) : popup_snote_single_graphic_window
TAknWindowLineLayout Notification_pop_up_window_elements__graphic__Line_1()
    {
    return AknLayoutScalable_Avkon::popup_snote_single_graphic_window_g1(0).LayoutLine();
    }

// C= H=80 W=60 b= l=280 r= t=20 
// Remark                    : Notification icon.
// Parent                    : popup_snote_single_graphic_window
// Parent API                : popup_snote_single_graphic_window
// Scale API match    ( 34%) : popup_snote_single_graphic_window_g_Limits
// Scale parent match (100%) : popup_snote_single_graphic_window
TAknWindowLineLayout Notification_pop_up_window_elements__graphic__Line_2()
    {
    return AknLayoutScalable_Avkon::popup_snote_single_graphic_window_g2(0).LayoutLine();
    }

/*
TAknLayoutTableLimits Notification_pop_up_window_elements__graphic__Limits();

TAknWindowLineLayout Notification_pop_up_window_elements__graphic_(TInt aLineIndex);
*/

// LAF Table : Notification pop-up window texts (graphic)
// B={56, 92, 128, 164, 200}[aCommon1] C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={248, 248, 310, 310, 310}[aCommon1] l=22 r={82, 82, 20, 20, 20}[aCommon1] 
// Remark                    : Notification text. Max. five rows of text.
// Parent                    : popup_snote_single_graphic_window
// Parent API                : popup_snote_single_graphic_window
// Scale API match    ( 38%) : popup_snote_single_graphic_window_t_Limits
// Scale parent match (100%) : popup_snote_single_graphic_window
TAknTextLineLayout Notification_pop_up_window_texts__graphic__Line_1(TInt aCommon1)
    {
    TAknTextComponentLayout textLayout;
    switch (aCommon1)
        {
        case 0:
            textLayout = AknLayoutScalable_Avkon::popup_snote_single_graphic_window_t1(0);
            break;
        case 1:
            textLayout = AknLayoutScalable_Avkon::popup_snote_single_graphic_window_t2(0);
            break;
        case 2:
            textLayout = AknLayoutScalable_Avkon::popup_snote_single_graphic_window_t3(1);
            break;
        case 3:
            textLayout = AknLayoutScalable_Avkon::popup_snote_single_graphic_window_t4(2);
            break;
        case 4:
            textLayout = AknLayoutScalable_Avkon::popup_snote_single_graphic_window_t5(3);
            break;
        default:
            textLayout = AknLayoutScalable_Avkon::popup_snote_single_graphic_window_t1(0);
            break;
        }
    return textLayout.LayoutLine();
    }

/*
TAknMultiLineTextLayout Multiline_Notification_pop_up_window_texts__graphic__Line_1(TInt aCommon1, TInt aNumberOfLinesShown);
*/

// LAF Table : Identifier icon selection pop-up window descendants
// C= H= W= b= l=6 r= t={12, 20} 
// Remark                    : For dimensions refer to Table 4.1.
// Parent                    : popup_grid_graphic_window
// Parent API                : popup_grid_graphic_window
// Scale API match    (  0%) : 
// Scale parent match (100%) : popup_grid_graphic_window
TAknWindowLineLayout Identifier_icon_selection_pop_up_window_descendants_Line_1(TInt /*aIndex_t*/)
    {
    TAknWindowComponentLayout windowLayout;
    windowLayout = AknLayoutScalable_Avkon::heading_pane_cp3(); //Vesa
    return windowLayout.LayoutLine();
    }

// C= H={286, 250, 214, 178, 142, 106, 70, 34} W=322 b= l={14, 14}[aCommon1] r= t={60, 68}[aCommon1] 
// Remark                    : Identifier icon or special character grid.
// Parent                    : popup_grid_graphic_window
// Parent API                : popup_grid_graphic_window
// Scale API match    (100%) : grid_graphic_popup_pane
// Scale parent match (100%) : popup_grid_graphic_window
TAknWindowLineLayout grid_graphic_popup_pane(TInt /*aCommon1*/, TInt /*aIndex_H*/)
    {
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Avkon::listscroll_popup_graphic_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::grid_graphic_popup_pane(0);
    return DoCompose(layout1, layout2).LayoutLine();
    }

// LAF Table : Identifier icon selection pop-up window elements
// C=219 H=2 W=326 b= l=12 r= t={58, 94, 130, 166, 202, 238, 274, 310, 346, 66, 102, 138, 174, 210, 246, 282, 318, 354}[aCommon1] 
// Remark                    : Horizontal line between grid elements.
// Parent                    : popup_grid_graphic_window
// Parent API                : popup_grid_graphic_window
// Scale API match    (  0%) : 
// Scale parent match (100%) : popup_grid_graphic_window
TAknWindowLineLayout Identifier_icon_selection_pop_up_window_elements_Line_1(TInt /*aCommon1*/)
    {
    return EmptyWindowLayout();
    }

// C=219 H={34, 70, 106, 142, 178, 214, 250, 286, 322} W=2 b= l={12, 48, 84, 120, 156, 192, 228, 264, 300, 336} r= t={60, 68} 
// Remark                    : Vertical line between grid elements.
// Parent                    : popup_grid_graphic_window
// Parent API                : popup_grid_graphic_window
// Scale API match    (  0%) : 
// Scale parent match (100%) : popup_grid_graphic_window
TAknWindowLineLayout Identifier_icon_selection_pop_up_window_elements_Line_2(TInt /*aIndex_l*/, TInt /*aIndex_t*/, TInt /*aIndex_H*/)
    {
    return EmptyWindowLayout();
    }

// LAF Table : Identifier icon selection pop-up window graphics
// C=0 H=p W=352 b= l=0 r= t=0 
// Remark                    : A rectangle to cover the main pane items.
// Parent                    : popup_grid_graphic_window
// Parent API                : popup_grid_graphic_window
// Scale API match    ( 31%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_grid_graphic_window
TAknWindowLineLayout Identifier_icon_selection_pop_up_window_graphics_Line_1(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

// C=86 H=p-20 W=338 b= l=12 r= t={12, 20} 
// Remark                    : Second shadow.
// Parent                    : popup_grid_graphic_window
// Parent API                : popup_grid_graphic_window
// Scale API match    ( 31%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_grid_graphic_window
TAknWindowLineLayout Identifier_icon_selection_pop_up_window_graphics_Line_2(const TRect& /*aParentRect*/, TInt /*aIndex_t*/)
    {
    return EmptyWindowLayout();
    }

// C=221 H=p-18 W=340 b= l=8 r= t={8, 16} 
// Remark                    : First shadow.
// Parent                    : popup_grid_graphic_window
// Parent API                : popup_grid_graphic_window
// Scale API match    ( 31%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_grid_graphic_window
TAknWindowLineLayout Identifier_icon_selection_pop_up_window_graphics_Line_3(const TRect& /*aParentRect*/, TInt /*aIndex_t*/)
    {
    return EmptyWindowLayout();
    }

// C=215 H=p-16 W=342 b= l=4 r= t={4, 12} 
// Remark                    : Outline frame.
// Parent                    : popup_grid_graphic_window
// Parent API                : popup_grid_graphic_window
// Scale API match    ( 31%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_grid_graphic_window
TAknWindowLineLayout Identifier_icon_selection_pop_up_window_graphics_Line_4(const TRect& /*aParentRect*/, TInt /*aIndex_t*/)
    {
    return EmptyWindowLayout();
    }

// C=0 H=p-20 W=338 b= l=6 r= t={6, 14} 
// Remark                    : Inside area.
// Parent                    : popup_grid_graphic_window
// Parent API                : popup_grid_graphic_window
// Scale API match    ( 31%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_grid_graphic_window
TAknWindowLineLayout Identifier_icon_selection_pop_up_window_graphics_Line_5(const TRect& /*aParentRect*/, TInt /*aIndex_t*/)
    {
    return EmptyWindowLayout();
    }

/*
TAknLayoutTableLimits Identifier_icon_selection_pop_up_window_graphics_SUB_TABLE_0_Limits();

TAknWindowLineLayout Identifier_icon_selection_pop_up_window_graphics_SUB_TABLE_0(TInt aLineIndex, const TRect& aParentRect, TInt aIndex_t);
*/

// LAF Table : Colour selection pop-up window descendants
// C= H= W= b= l=6 r= t=12 
// Remark                    : For the dimensions refer to Section 6.4.
// Parent                    : popup_grid_large_graphic_colour_window
// Parent API                : popup_grid_large_graphic_colour_window
// Scale API match    ( 29%) : popup_large_graphic_colour_window
// Scale parent match ( 86%) : popup_large_graphic_colour_window
TAknWindowLineLayout Colour_selection_pop_up_window_descendants_Line_1()
    {
    TAknWindowComponentLayout windowLayout;
    windowLayout = AknLayoutScalable_Avkon::heading_pane_cp4();
    return windowLayout.LayoutLine();
    }

// LAF Table : Colour selection pop-up window descendants

// C= H=44 W=318 b= l=16 r= t=60 
// Remark                    : Cell pane for the No colourselection.
// Parent                    : popup_grid_large_graphic_colour_window
// Parent API                : popup_grid_large_graphic_colour_window
// Scale API match    ( 29%) : popup_large_graphic_colour_window
// Scale parent match ( 86%) : popup_large_graphic_colour_window
TAknWindowLineLayout Colour_selection_pop_up_window_descendants_Line_2()
    {
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_popup_colour_pane();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::cell_large_graphic_colour_none_popup_pane(1); 
	return DoCompose(l1,l2).LayoutLine();
    }

// LAF Table : Colour selection pop-up window descendants
// C= H={182, 230}[aCommon1] W=318 b= l=16 r= t={106, 60}[aCommon1] 
// Remark                    : Color selection grid.
// Parent                    : popup_grid_large_graphic_colour_window
// Parent API                : popup_grid_large_graphic_colour_window
// Scale API match    (100%) : grid_large_graphic_colour_popup_pane
// Scale parent match ( 86%) : popup_large_graphic_colour_window
TAknWindowLineLayout grid_large_graphic_colour_popup_pane(TInt aCommon1)
    {
    TInt option = 1;
    if (aCommon1 == 0)
        {
        option = 1;
        }
    else if (aCommon1 == 1)
        {
        option = 0;
        }

	if(Layout_Meta_Data::IsScrollbarEnabled())
		option += 2;

	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_popup_colour_pane();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::grid_large_graphic_colour_popup_pane(option);
    //return l2.LayoutLine();
	return DoCompose(l1,l2).LayoutLine();
    }

// LAF Table : Composer symbol selection pop-up window elements
// C=219 H=2 W=322 b= l=14 r= t={58, 104, 150, 196, 242, 288, 58, 116, 174, 232, 290} 
// Remark                    : Horizontal line between grid elements.
// Parent                    : popup_grid_large_graphic_colour_window
// Parent API                : popup_grid_large_graphic_colour_window
// Scale API match    (  0%) : 
// Scale parent match ( 86%) : popup_large_graphic_colour_window
TAknWindowLineLayout Composer_symbol_selection_pop_up_window_elements_Line_1(TInt /*aIndex_t*/)
    {
	// horizontal lines
    /*
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::listscroll_popup_colour_pane();
    TAknWindowComponentLayout l0 = AknLayoutScalable_Avkon::cell_large_graphic_colour_popup_pane();
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::cell_large_graphic_colour_popup_pane_g2();
	return DoCompose(l0, DoCompose(l1, l2)).LayoutLine();
    */
    return EmptyWindowLayout();
    }

// C=219 H={232, 234, 186, 234, } W={2, , 2} b= l={14, 334, 94, 174, 254, , , , , } r= t={58, , 104, 58} 
// Remark                    : Vertical line between grid elements.
// Parent                    : popup_grid_large_graphic_colour_window
// Parent API                : popup_grid_large_graphic_colour_window
// Scale API match    (  0%) : 
// Scale parent match ( 86%) : popup_large_graphic_colour_window
TAknWindowLineLayout Composer_symbol_selection_pop_up_window_elements_Line_2(TInt /*aIndex_l*/, TInt /*aIndex_t*/, TInt /*aIndex_W*/, TInt /*aIndex_H*/)
    {
    /*
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::cell_large_graphic_colour_popup_pane_g2_copy1();
    return l1.LayoutLine();
    */
    return EmptyWindowLayout();
    }

// LAF Table : Colour selection pop-up window graphics
// C=0 H=p W=352 b= l=0 r= t=0 
// Remark                    : A rectangle to cover the main pane items.
// Parent                    : popup_grid_large_graphic_colour_window
// Parent API                : popup_grid_large_graphic_colour_window
// Scale API match    ( 47%) : popup_large_graphic_colour_window
// Scale parent match ( 86%) : popup_large_graphic_colour_window
TAknWindowLineLayout Colour_selection_pop_up_window_graphics_Line_1(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

// C=86 H=p-20 W=338 b= l=12 r= t=12 
// Remark                    : Second shadow.
// Parent                    : popup_grid_large_graphic_colour_window
// Parent API                : popup_grid_large_graphic_colour_window
// Scale API match    ( 47%) : popup_large_graphic_colour_window
// Scale parent match ( 86%) : popup_large_graphic_colour_window
TAknWindowLineLayout Colour_selection_pop_up_window_graphics_Line_2(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

// C=221 H=p-18 W=340 b= l=8 r= t=8 
// Remark                    : First shadow.
// Parent                    : popup_grid_large_graphic_colour_window
// Parent API                : popup_grid_large_graphic_colour_window
// Scale API match    ( 47%) : popup_large_graphic_colour_window
// Scale parent match ( 86%) : popup_large_graphic_colour_window
TAknWindowLineLayout Colour_selection_pop_up_window_graphics_Line_3(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

// C=215 H=p-16 W=342 b= l=4 r= t=4 
// Remark                    : Outline frame.
// Parent                    : popup_grid_large_graphic_colour_window
// Parent API                : popup_grid_large_graphic_colour_window
// Scale API match    ( 47%) : popup_large_graphic_colour_window
// Scale parent match ( 86%) : popup_large_graphic_colour_window
TAknWindowLineLayout Colour_selection_pop_up_window_graphics_Line_4(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

// C=0 H=p-20 W=338 b= l=6 r= t=6 
// Remark                    : Inside area.
// Parent                    : popup_grid_large_graphic_colour_window
// Parent API                : popup_grid_large_graphic_colour_window
// Scale API match    ( 47%) : popup_large_graphic_colour_window
// Scale parent match ( 86%) : popup_large_graphic_colour_window
TAknWindowLineLayout Colour_selection_pop_up_window_graphics_Line_5(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

/*
TAknLayoutTableLimits Colour_selection_pop_up_window_graphics_Limits();

TAknWindowLineLayout Colour_selection_pop_up_window_graphics(TInt aLineIndex, const TRect& aParentRect);
*/

// LAF Table : Fast application swapping pop-up window descendants
// C= H=94 W=116 b= l=8 r= t={6, 100, 194} 
// Remark                    : Pop-up window item.
// Parent                    : popup_fast_swap_window
// Parent API                : popup_fast_swap_window
// Scale API match    ( 34%) : application_window_ParamLimits
// Scale parent match (100%) : popup_fast_swap_window
TAknWindowLineLayout Fast_application_swapping_pop_up_window_descendants_Line_1(TInt /*aIndex_t*/)
    {
    return EmptyWindowLayout();
    // return AknLayoutScalable_Avkon::cell_app_pane_cp(aIndex_t).LayoutLine(); //Vesa
    }

// LAF Table : Fast application swapping pop-up window graphics
// C=0 H=p W=p b= l=0 r= t=0 
// Remark                    : A rectangle to cover the main pane items.
// Parent                    : popup_fast_swap_window
// Parent API                : popup_fast_swap_window
// Scale API match    ( 36%) : application_window_ParamLimits
// Scale parent match (100%) : popup_fast_swap_window
TAknWindowLineLayout Fast_application_swapping_pop_up_window_graphics_Line_1(const TRect& /*aParentRect*/)
    {
    // JH: IMPLEMENTED 13.12.2005
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::bg_popup_window_pane_cp13(1); 
	return layout.LayoutLine();
    }

// C=86 H=p-14 W=p-16 b= l=12 r= t=10 
// Remark                    : Second shadow.
// Parent                    : popup_fast_swap_window
// Parent API                : popup_fast_swap_window
// Scale API match    ( 36%) : application_window_ParamLimits
// Scale parent match (100%) : popup_fast_swap_window
TAknWindowLineLayout Fast_application_swapping_pop_up_window_graphics_Line_2(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

// C=221 H=p-12 W=p-14 b= l=8 r= t=6 
// Remark                    : First shadow.
// Parent                    : popup_fast_swap_window
// Parent API                : popup_fast_swap_window
// Scale API match    ( 36%) : application_window_ParamLimits
// Scale parent match (100%) : popup_fast_swap_window
TAknWindowLineLayout Fast_application_swapping_pop_up_window_graphics_Line_3(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

// C=215 H=p-10 W=p-12 b= l=4 r= t=2 
// Remark                    : Outline frame.
// Parent                    : popup_fast_swap_window
// Parent API                : popup_fast_swap_window
// Scale API match    ( 36%) : application_window_ParamLimits
// Scale parent match (100%) : popup_fast_swap_window
TAknWindowLineLayout Fast_application_swapping_pop_up_window_graphics_Line_4(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

// C=0 H=p-14 W=p-16 b= l=6 r= t=4 
// Remark                    : Inside area.
// Parent                    : popup_fast_swap_window
// Parent API                : popup_fast_swap_window
// Scale API match    ( 36%) : application_window_ParamLimits
// Scale parent match (100%) : popup_fast_swap_window
TAknWindowLineLayout Fast_application_swapping_pop_up_window_graphics_Line_5(const TRect& /*aParentRect*/)
    {
    // JH: IMPLEMENTED 13.12.2005
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::listscroll_popup_fast_pane(1); 
	return layout.LayoutLine();
    }

// C= H=40 W=136 b= l=0 r= t=290 
// Remark                    : Pop-up window extension bitmap.
// Parent                    : popup_fast_swap_window
// Parent API                : popup_fast_swap_window
// Scale API match    ( 36%) : application_window_ParamLimits
// Scale parent match (100%) : popup_fast_swap_window
TAknWindowLineLayout Fast_application_swapping_pop_up_window_graphics_Line_6()
    {
    return EmptyWindowLayout();
    }

/*
TAknLayoutTableLimits Fast_application_swapping_pop_up_window_graphics_SUB_TABLE_0_Limits();

TAknWindowLineLayout Fast_application_swapping_pop_up_window_graphics_SUB_TABLE_0(TInt aLineIndex, const TRect& aParentRect);
*/

// LAF Table : List pane texts (setting, double2)
// B=36 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=316 l=26 r=10 
// Remark                    : Settings value.
// Parent                    : list_setting_double2_pane
// Parent API                : list_setting_double2_pane
// Scale API match    ( 43%) : list_double2_pane_t_Limits
// Scale parent match ( 65%) : list_setting_pane_g2_ParamLimits
TAknTextLineLayout List_pane_texts__setting__double2__Line_1()
    {
    return List_pane_text__double2__Line_1(0);
    }

// B=76 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=306 l=36 r=10 
// Remark                    : Settings value.
// Parent                    : list_setting_double2_pane
// Parent API                : list_setting_double2_pane
// Scale API match    ( 43%) : list_double2_pane_t_Limits
// Scale parent match ( 65%) : list_setting_pane_g2_ParamLimits
TAknTextLineLayout List_pane_texts__setting__double2__Line_2()
    {
    return List_pane_text__double2__Line_2();
    }
    
/*
TAknLayoutTableLimits List_pane_texts__setting__double2__Limits();

TAknTextLineLayout List_pane_texts__setting__double2_(TInt aLineIndex);
*/

// LAF Table : List pane elements (single 2graphic)
// C= H=26 W=26 b= l=6 r= t=8 
// Remark                    : 
// Parent                    : list_single_2graphic_pane
// Parent API                : list_single_2graphic_pane
// Scale API match    ( 58%) : list_single_2graphic_pane_g_Limits
// Scale parent match (100%) : list_single_2graphic_pane
TAknWindowLineLayout List_pane_elements__single_2graphic__Line_1()
    {
    return EmptyWindowLayout();
    }

// C= H=26 W=26 b= l=46 r= t=8 
// Remark                    : 
// Parent                    : list_single_2graphic_pane
// Parent API                : list_single_2graphic_pane
// Scale API match    ( 60%) : list_single_2graphic_pane_g_Limits
// Scale parent match (100%) : list_single_2graphic_pane
TAknWindowLineLayout List_pane_elements__single_2graphic__Line_2()
    {
    return EmptyWindowLayout();
    }

// C=215 H=42 W=2 b= l=38 r= t=0 
// Remark                    : A line between A and B columns.
// Parent                    : list_single_2graphic_pane
// Parent API                : list_single_2graphic_pane
// Scale API match    ( 58%) : list_single_2graphic_pane_g_Limits
// Scale parent match (100%) : list_single_2graphic_pane
TAknWindowLineLayout List_pane_elements__single_2graphic__Line_3()
    {
    return EmptyWindowLayout();
    }

// C= H=26 W=26 b= l={318, 292} r= t=14 
// Remark                    : Additional icons.
// Parent                    : list_single_2graphic_pane
// Parent API                : list_single_2graphic_pane
// Scale API match    ( 58%) : list_single_2graphic_pane_g_Limits
// Scale parent match (100%) : list_single_2graphic_pane
TAknWindowLineLayout List_pane_elements__single_2graphic__Line_4(TInt /*aIndex_l*/)
    {
    return EmptyWindowLayout();
    }

/*
TAknLayoutTableLimits List_pane_elements__single_2graphic__SUB_TABLE_0_Limits();

TAknWindowLineLayout List_pane_elements__single_2graphic__SUB_TABLE_0(TInt aLineIndex);
*/
// LAF Table : List pane texts (single 2graphic)
// B=30 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={262, 230, 204} l=80 r={10, 42, 68} 
// Remark                    : 
// Parent                    : list_single_2graphic_pane
// Parent API                : list_single_2graphic_pane
// Scale API match    ( 63%) : list_single_2graphic_pane_g_Limits
// Scale parent match (100%) : list_single_2graphic_pane
TAknTextLineLayout List_pane_texts__single_2graphic__Line_1(TInt /*aIndex_r*/, TInt /*aIndex_W*/)
    {
    return EmptyTextLayout();
    }

// LAF Table : List pane elements (double2 graphic large graphic)
// C= H=26 W=26 b= l=6 r= t=14 
// Remark                    : Icon.
// Parent                    : list_double2_graphic_large_graphic_pane
// Parent API                : list_double2_graphic_large_graphic_pane
// Scale API match    ( 69%) : list_double2_graphic_large_graphic_pane_g_Limits
// Scale parent match (100%) : list_double2_graphic_large_graphic_pane
TAknWindowLineLayout List_pane_elements__double2_graphic_large_graphic__Line_1()
    {
    return EmptyWindowLayout();
    }

// C= H=60 W=80 b= l=48 r= t=14 
// Remark                    : Graphic.
// Parent                    : list_double2_graphic_large_graphic_pane
// Parent API                : list_double2_graphic_large_graphic_pane
// Scale API match    ( 69%) : list_double2_graphic_large_graphic_pane_g_Limits
// Scale parent match (100%) : list_double2_graphic_large_graphic_pane
TAknWindowLineLayout List_pane_elements__double2_graphic_large_graphic__Line_2()
    {
    return EmptyWindowLayout();
    }

// C=215 H=88 W=2 b= l=38 r= t=0 
// Remark                    : A line between A and B columns.
// Parent                    : list_double2_graphic_large_graphic_pane
// Parent API                : list_double2_graphic_large_graphic_pane
// Scale API match    ( 69%) : list_double2_graphic_large_graphic_pane_g_Limits
// Scale parent match (100%) : list_double2_graphic_large_graphic_pane
TAknWindowLineLayout List_pane_elements__double2_graphic_large_graphic__Line_3()
    {
    return EmptyWindowLayout();
    }

// C= H=26 W=26 b= l={318, 292} r= t=14 
// Remark                    : Additional icons.
// Parent                    : list_double2_graphic_large_graphic_pane
// Parent API                : list_double2_graphic_large_graphic_pane
// Scale API match    ( 69%) : list_double2_graphic_large_graphic_pane_g_Limits
// Scale parent match (100%) : list_double2_graphic_large_graphic_pane
TAknWindowLineLayout List_pane_elements__double2_graphic_large_graphic__Line_4(TInt /*aIndex_l*/)
    {
    return EmptyWindowLayout();
    }

/*
TAknLayoutTableLimits List_pane_elements__double2_graphic_large_graphic__SUB_TABLE_0_Limits();

TAknWindowLineLayout List_pane_elements__double2_graphic_large_graphic__SUB_TABLE_0(TInt aLineIndex);
*/

// LAF Table : List pane texts (double2 graphic large graphic)
// B=32 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=206 l=136 r={10, 42, 68}[aCommon1] 
// Remark                    : 1. line.
// Parent                    : list_double2_graphic_large_graphic_pane
// Parent API                : list_double2_graphic_large_graphic_pane
// Scale API match    ( 75%) : list_double2_graphic_large_graphic_pane_t_Limits
// Scale parent match (100%) : list_double2_graphic_large_graphic_pane
TAknTextLineLayout List_pane_texts__double2_graphic_large_graphic__Line_1(TInt /*aCommon1*/)
    {
    return EmptyTextLayout();
    }

// B=70 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=196 l=146 r=10 
// Remark                    : 2. line.
// Parent                    : list_double2_graphic_large_graphic_pane
// Parent API                : list_double2_graphic_large_graphic_pane
// Scale API match    ( 75%) : list_double2_graphic_large_graphic_pane_t_Limits
// Scale parent match (100%) : list_double2_graphic_large_graphic_pane
TAknTextLineLayout List_pane_texts__double2_graphic_large_graphic__Line_2()
    {
    return EmptyTextLayout();
    }

// LAF Table : Form data wide graphic field texts
// B=38 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=316 l=24 r=8 
// Remark                    : Heading text (i.e. label).
// Parent                    : form_field_data_wide_pane
// Parent API                : form_field_data_wide_pane
// Scale API match    ( 51%) : form_field_data_wide_pane_ParamLimits
// Scale parent match (100%) : form_field_data_wide_pane
TAknTextLineLayout Form_data_wide_graphic_field_texts_Line_1()
    {
	TInt varietyIndex = 1; // don't seem to have the parameters needed to differentiate the different columns [LMB 21/03/2005]
    return AknLayoutScalable_Avkon::form_field_data_wide_pane_t1(varietyIndex).LayoutLine();
    }

// B={74, 116, 158, 200, 242} C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W=306 l=34 r=8 
// Remark                    : Enterededited data.
// Parent                    : form_field_data_wide_pane
// Parent API                : form_field_data_wide_pane
// Scale API match    ( 51%) : form_field_data_wide_pane_ParamLimits
// Scale parent match (100%) : form_field_data_wide_pane
TAknTextLineLayout Form_data_wide_graphic_field_texts_Line_2(TInt aIndex_B)
    {
	TInt varietyIndex = 1; // all options of data_form_wide_pane have same data [LMB 21/03/2005]
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::data_form_wide_pane(varietyIndex);
	TInt rowIndex = aIndex_B;
    TAknTextComponentLayout l2 = AknLayoutScalable_Avkon::data_form_wide_pane_t1(rowIndex);
    TAknTextLineLayout l = DoComposeText(l1,l2).LayoutLine();
    // ESLI-6CNHQT removed hack
	//l.iB = ELayoutEmpty; // Hack
	return l;
    }

// MISSING
TAknMultiLineTextLayout Multiline_Form_data_wide_graphic_field_texts_Line_2(TInt aNumberOfLinesShown)
	{ // The default multiline version does NOT work here. (because iB needs to be parent relative)
	/* TInt lastRow = AknLayoutScalable_Avkon::data_form_wide_pane_t1_ParamLimits().LastRow(); */
	TInt varietyIndex = 1; // all options of data_form_wide_pane have same data [LMB 21/03/2005]
	TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::data_form_wide_pane(varietyIndex);
	TInt rowIndex = 0; // first row
    TAknTextComponentLayout l2 = AknLayoutScalable_Avkon::data_form_wide_pane_t1(rowIndex);
	TAknTextComponentLayout::FormDataHack2(l2);
	TAknMultiLineTextLayout result;
    TAknTextLineLayout &l = result;
	TAknTextComponentLayout l3 = DoComposeText(l1,l2);
    l = l3.LayoutLine();
	// need to get the baseline separation from the container [LMB 21/03/2005]
	TAknWindowLineLayout l4 = AknLayoutScalable_Avkon::form_field_data_wide_pane(0).LayoutLine();
	TAknWindowLineLayout l4a = AknLayoutScalable_Avkon::form_field_data_wide_pane(1).LayoutLine();
	result.iBaselineSkip = l4a.iH - l4.iH;
    //result.iB = ELayoutP - (l2.it + l2.iH); 
	result.iB = (TInt16)TAknTextComponentLayout::FormDataHack(l3);
	result.iNumberOfLinesShown = aNumberOfLinesShown;
	return result;
	}

// LAF Table : Application window descendants 2.1
// C= H=30 W=352 b= l=0 r= t=0 
// Remark                    : 
// Parent                    : application_window
// Parent API                : application_window
// Scale API match    (100%) : status_small_pane
// Scale parent match (100%) : application_window
TAknWindowLineLayout status_small_pane()
    {
    // MAN: IMPLEMENTED
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::area_top_pane(1);
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::status_small_pane();
    return DoCompose(l1, l2).LayoutLine();
    }

// LAF Table : Small status pane descendants and elements
// C=237 H=30 W=352 b= l=0 r= t=0 
// Remark                    : Background colour.
// Parent                    : status_small_pane
// Parent API                : status_small_pane
// Scale API match    ( 31%) : status_small_pane_g1_ParamLimits
// Scale parent match (100%) : status_small_pane
TAknWindowLineLayout Small_status_pane_descendants_and_elements_Line_1()
    {
    // MAN: IMPLEMENTED
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::area_top_pane(1);
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::status_small_pane();
    return DoCompose(l1, l2).LayoutLine();
    }

// C= H=18 W=342 b= l=4 r= t=6 
// Remark                    : Status icons.
// Parent                    : status_small_pane
// Parent API                : status_small_pane
// Scale API match    (100%) : status_small_icon_pane
// Scale parent match (100%) : status_small_pane
TAknWindowLineLayout status_small_icon_pane()
    {
    // MAN: IMPLEMENTED
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::area_top_pane(1);
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::status_small_pane();
    TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::status_small_icon_pane();
    return DoCompose(l1, DoCompose(l2,l3)).LayoutLine();
    }

// C= H=18 W=154 b= l=6 r= t=6 
// Remark                    : Waiting or progress bar.
// Parent                    : status_small_pane
// Parent API                : status_small_pane
// Scale API match    (100%) : status_small_wait_pane
// Scale parent match (100%) : status_small_pane
TAknWindowLineLayout status_small_wait_pane()
    {
    // MAN: IMPLEMENTED
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::area_top_pane(1);
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::status_small_pane();
    TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::status_small_wait_pane(0);
    return DoCompose(l1, DoCompose(l2,l3)).LayoutLine();
    }

// C=0 H=30 W=24 b= l=0 r= t=0 
// Remark                    : GPRS state indication.
// Parent                    : status_small_pane
// Parent API                : status_small_pane
// Scale API match    ( 31%) : status_small_pane_g1_ParamLimits
// Scale parent match (100%) : status_small_pane
TAknWindowLineLayout Small_status_pane_descendants_and_elements_Line_4()
    {
    // MAN: IMPLEMENTED
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::area_top_pane(1);
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::status_small_pane();
    TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::status_small_pane_g2(0);
    return DoCompose(l1, DoCompose(l2,l3)).LayoutLine();
    }

// C=0 H=18 W=20 b= l=24 r= t=8 
// Remark                    : Secured connection indication.
// Parent                    : status_small_pane
// Parent API                : status_small_pane
// Scale API match    ( 31%) : status_small_pane_g1_ParamLimits
// Scale parent match (100%) : status_small_pane
TAknWindowLineLayout Small_status_pane_descendants_and_elements_Line_5()
    {
    // MAN: IMPLEMENTED
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::area_top_pane(1);
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::status_small_pane();
    TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::status_small_pane_g3(0);
    return DoCompose(l1, DoCompose(l2,l3)).LayoutLine();
    }

// C= H=30 W=30 b= l=162 r= t=0 
// Remark                    : WML browser waiting animation.
// Parent                    : status_small_pane
// Parent API                : status_small_pane
// Scale API match    ( 31%) : status_small_pane_g1_ParamLimits
// Scale parent match (100%) : status_small_pane
TAknWindowLineLayout Small_status_pane_descendants_and_elements_Line_6()
    {
    // MAN: IMPLEMENTED
    TAknWindowComponentLayout l1 = AknLayoutScalable_Avkon::area_top_pane(1);
    TAknWindowComponentLayout l2 = AknLayoutScalable_Avkon::status_small_pane();
    TAknWindowComponentLayout l3 = AknLayoutScalable_Avkon::status_small_pane_g4(0);
    return DoCompose(l1, DoCompose(l2,l3)).LayoutLine();
    }

/*
TAknLayoutTableLimits Small_status_pane_descendants_and_elements_Limits();

TAknWindowLineLayout Small_status_pane_descendants_and_elements(TInt aLineIndex);
*/

// LAF Table : Small status pane texts
// B=22 C=0 Font=ELatinPlain12_Scaled J={ELayoutAlignLeft, ELayoutAlignCenter, ELayoutAlignRight} W=348 l=4 r=2 
// Remark                    : Various texts
// Parent                    : status_small_pane
// Parent API                : status_small_pane
// Scale API match    ( 63%) : status_small_pane_t1
// Scale parent match (100%) : status_small_pane
TAknTextLineLayout Small_status_pane_texts_Line_1(TInt /*aIndex_J*/)
    {
    // MAN: IMPLEMENTED
    TInt varietyIndex = 0; // should be 1 if there is an indicator on the right hand side [LMB 24/8/2005]
    TAknTextLineLayout line = AknLayoutScalable_Avkon::status_small_pane_t1(varietyIndex).LayoutLine(); 
    return line;
    }

// LAF Table : Small status waiting pane components
// C=0 H=18 W=154 b= l=0 r= t=0 
// Remark                    : Background colour.
// Parent                    : status_small_wait_pane
// Parent API                : status_small_wait_pane
// Scale API match    ( 45%) : status_small_wait_pane_ParamLimits
// Scale parent match (100%) : status_small_wait_pane
TAknWindowLineLayout Small_status_waiting_pane_components_Line_1()
    {
    TAknWindowLineLayout line = AknLayoutScalable_Avkon::Screen().LayoutLine(); // NOT IMPLEMENTED
    return line;
    }

// C=237 H=14 W=150 b= l=2 r= t=2 
// Remark                    : Area border colour border width one (1) pixel.
// Parent                    : status_small_wait_pane
// Parent API                : status_small_wait_pane
// Scale API match    ( 45%) : status_small_wait_pane_ParamLimits
// Scale parent match (100%) : status_small_wait_pane
TAknWindowLineLayout Small_status_waiting_pane_components_Line_2()
    {
    TAknWindowLineLayout line = AknLayoutScalable_Avkon::Screen().LayoutLine(); // NOT IMPLEMENTED
    return line;
    }

// C=0 H=10 W=146 b= l=4 r= t=4 
// Remark                    : Inside area.
// Parent                    : status_small_wait_pane
// Parent API                : status_small_wait_pane
// Scale API match    ( 45%) : status_small_wait_pane_ParamLimits
// Scale parent match (100%) : status_small_wait_pane
TAknWindowLineLayout Small_status_waiting_pane_components_Line_3()
    {
    TAknWindowLineLayout line = AknLayoutScalable_Avkon::Screen().LayoutLine(); // NOT IMPLEMENTED
    return line;
    }

// C= H=10 W=146 b= l=4 r= t=4 
// Remark                    : Progress or waiting bar animation.
// Parent                    : status_small_wait_pane
// Parent API                : status_small_wait_pane
// Scale API match    ( 45%) : status_small_wait_pane_ParamLimits
// Scale parent match (100%) : status_small_wait_pane
TAknWindowLineLayout Small_status_waiting_pane_components_Line_4()
    {
    // MAN: IMPLEMENTED
    TAknWindowLineLayout line = AknLayoutScalable_Avkon::status_small_wait_pane_g2().LayoutLine(); 
    return line;
    }
/*
TAknLayoutTableLimits Small_status_waiting_pane_components_Limits();

TAknWindowLineLayout Small_status_waiting_pane_components(TInt aLineIndex);
*/

// Layouts for AknPopupForm
// C= H=80 W=60 b= l=280 r= t=8 
// Remark                    : Note icon.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 30%) : midp_info_popup_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Note_with_additional_information_popup_window_elements_Line_1()
    {
    TAknWindowLineLayout line = AknLayoutScalable_Avkon::popup_midp_note_alarm_window_g1( 0 );    
    return line;
    }

// C= H=20 W={240, 306} b= l=20 r= t=26 
// Remark                    : Wait or progress bar animation.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 30%) : midp_info_popup_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Note_with_additional_information_popup_window_elements_Line_2(TInt aIndex_W)
    {
    // JH: IMPLEMENTED 22.12.2005
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::wait_bar_pane(aIndex_W);
    return layout.LayoutLine();
    }

// C= H=20 W={240, 306} b= l=20 r= t=26 
// Remark                    : Wait or progress bar frame graphics.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 30%) : midp_info_popup_window_ParamLimits
// Scale parent match (  0%) : 
TAknWindowLineLayout Note_with_additional_information_popup_window_elements_Line_3(TInt aIndex_W)
    {
    // JH: IMPLEMENTED 22.12.2005
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::wait_bar_pane(aIndex_W);
    return layout.LayoutLine();
    }


// B={44, 80, 116, 152, 188} C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={248, 310}[aCommon1] l=22 r={82, 20}[aCommon1] 
// Remark                    : Note text.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 36%) : popup_snote_single_text_window_t1_ParamLimits
// Scale parent match (  0%) : 
TAknTextLineLayout Note_with_additional_information_popup_window_texts_Line_1(TInt /*aIndex_r*/, TInt /*aIndexB, TInt aCommon1, TInt aIndexW*/)
    {
    return EmptyTextLayout();
    }

/*
TAknMultiLineTextLayout Multiline_Note_with_additional_information_popup_window_texts_Line_1(TInt aIndex_r, TInt aCommon1, TInt aIndex_W, TInt aNumberOfLinesShown)
*/

// B={44, 76, 108, 140, 172, 204} C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=306 l=22 r=24 
// Remark                    : Note text.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 36%) : popup_snote_single_text_window_t1_ParamLimits
// Scale parent match (  0%) : 
TAknTextLineLayout Note_with_additional_information_popup_window_texts_Line_2(TInt /*aIndex_B , TInt aCommon1, TInt aIndex_W*/)
    {
    return EmptyTextLayout();
    }

/*
TAknMultiLineTextLayout Multiline_Note_with_additional_information_popup_window_texts_Line_2(TInt aCommon1, TInt aIndex_W, TInt aNumberOfLinesShown)
*/
    
TAknTextLineLayout Note_with_additional_information_popup_window_texts_Line_3(TInt /*aIndex_B*/, TInt /*aCommon1 , TInt aIndex_W*/)
    {
    return EmptyTextLayout();
    }

/*
TAknMultiLineTextLayout Multiline_Note_with_additional_information_popup_window_texts_Line_3(TInt aCommon1, TInt aIndex_W, TInt aNumberOfLinesShown)
*/

// B=24 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignRight W=56 l=274 r=6 
// Remark                    : Page number.
// Parent                    : popup_list_heading_pane
// Parent API                : popup_list_heading_pane
// Scale API match    ( 70%) : heading_pane_t1_ParamLimits
// Scale parent match ( 76%) : bg_popup_heading_pane_g_Limits
TAknTextLineLayout Heading_pane_texts_Line_2()
    {
    TAknTextComponentLayout layout = AknLayoutScalable_Avkon::heading_pane_t2(0);  
    return layout.LayoutLine();
    }

// C= H=32 W=34 b= l=48 r= t=12 
// Remark                    : Audio indication.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 66%) : popup_side_volume_key_window_g1
// Scale parent match (  0%) : 
TAknWindowLineLayout Side_volume_key_popup_window_elements_Line_1()
    {
    // JH: IMPLEMENTED 16.12.2005
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::popup_side_volume_key_window_g1();  
    return layout.LayoutLine();
    }

// C= H=32 W=118 b= l=92 r= t=14 
// Remark                    : Volume level indication.
// Parent                    : 
// Parent API                : 
// Scale API match    ( 66%) : popup_side_volume_key_window_g1
// Scale parent match (  0%) : 
TAknWindowLineLayout Side_volume_key_popup_window_elements_Line_2()
    {
    // JH: IMPLEMENTED 16.12.2005
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::volume_small_pane_cp1();  
    return layout.LayoutLine();
    }

// B=74 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=246 l=10 r=12 
// Remark                    : font
// Parent                    : 
// Parent API                : 
// Scale API match    ( 75%) : popup_side_volume_key_window_t1
// Scale parent match (  0%) : 
TAknTextLineLayout Side_volume_key_popup_window_texts_Line_1()
    {
    // JH: IMPLEMENTED 16.12.2005
    TAknTextComponentLayout layout = AknLayoutScalable_Avkon::popup_side_volume_key_window_t1();  
    return layout.LayoutLine();
    }

// B=40 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=164 l=92 r=12 
// Remark                    : font
// Parent                    : 
// Parent API                : 
// Scale API match    ( 75%) : popup_side_volume_key_window_t1
// Scale parent match (  0%) : 
TAknTextLineLayout Side_volume_key_popup_window_texts_Line_2()
    {
    return EmptyTextLayout();
    }

// C=0 H=p W=268 b= l=0 r= t=0 
// Remark                    : A rect to cover main pane items
// Parent                    : 
// Parent API                : 
// Scale API match    ( 63%) : popup_side_volume_key_window_g1
// Scale parent match (  0%) : 
TAknWindowLineLayout Side_volume_key_popup_window_background_Line_1(const TRect& /*aParentRect*/)
    {
    // JH: IMPLEMENTED 16.12.2005
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::bg_popup_sub_pane_cp22();
    return layout.LayoutLine();
    }

// C=221 H=p-6 W=262 b= l=4 r= t=4 
// Remark                    : shadow
// Parent                    : 
// Parent API                : 
// Scale API match    ( 63%) : popup_side_volume_key_window_g1
// Scale parent match (  0%) : 
TAknWindowLineLayout Side_volume_key_popup_window_background_Line_2(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

// C=215 H=p-6 W=262 b= l=2 r= t=2 
// Remark                    : outline frame
// Parent                    : 
// Parent API                : 
// Scale API match    ( 63%) : popup_side_volume_key_window_g1
// Scale parent match (  0%) : 
TAknWindowLineLayout Side_volume_key_popup_window_background_Line_3(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

// C=0 H=p-10 W=258 b= l=4 r= t=4 
// Remark                    : inside area
// Parent                    : 
// Parent API                : 
// Scale API match    ( 63%) : popup_side_volume_key_window_g1
// Scale parent match (  0%) : 
TAknWindowLineLayout Side_volume_key_popup_window_background_Line_4(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

// LAF Table : Transparent setting item texts
// B=44 C=215 Font=ELatinBold12_Scaled J=ELayoutAlignCenter W=28 l=8 r=320 
// Remark                    : Ordinal numbers.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 31%) : setting_text_pane
// Scale parent match (100%) : main_pane
TAknTextLineLayout Transparent_setting_item_texts_Line_1()
    {
    return Setting_item_texts_Line_1();
    }

// B=42 C=0 Font=ELatinBold12_Scaled J=ELayoutAlignCenter W=28 l=6 r=318 
// Remark                    : Ordinal numbers.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 31%) : setting_text_pane
// Scale parent match (100%) : main_pane
TAknTextLineLayout Transparent_setting_item_texts_Line_2()
    {
    return Setting_item_texts_Line_1();
    }

// B=44 C=215 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={290, 316}[aCommon1] l={54, 28}[aCommon1] r=8 
// Remark                    : Setting item title.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 31%) : setting_text_pane
// Scale parent match (100%) : main_pane
TAknTextLineLayout Transparent_setting_item_texts_Line_3(TInt aCommon1)
    {
    return Setting_item_texts_Line_2(aCommon1);
    }

// B=42 C=0 Font=ELatinBold13_Scaled J=ELayoutAlignLeft W={290, 316}[aCommon1] l={52, 26}[aCommon1] r=10 
// Remark                    : Setting item title.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 31%) : setting_text_pane
// Scale parent match (100%) : main_pane
TAknTextLineLayout Transparent_setting_item_texts_Line_4(TInt aCommon1)
    {
    return Setting_item_texts_Line_2(aCommon1);
    }

// LAF Table : List pane texts (set trans graphic)
// B=26 C=215 Font=ELatinBold12_Scaled J=ELayoutAlignLeft W={260, 286, 230} l={56, 30} r=2 
// Remark                    : Setting value item text shadow.
// Parent                    : list_set_graphic_pane
// Parent API                : list_set_graphic_pane
// Scale API match    ( 47%) : list_set_graphic_pane_g_Limits
// Scale parent match (100%) : list_set_graphic_pane
TAknTextLineLayout List_pane_texts__set_trans_graphic__Line_1(TInt /*aIndex_l*/, TInt /*aIndex_W*/)
    {
    return EmptyTextLayout();
    }

// B=24 C=0 Font=ELatinBold12_Scaled J=ELayoutAlignLeft W={260, 286, 230} l={54, 28} r=4 
// Remark                    : Setting value item text.
// Parent                    : list_set_graphic_pane
// Parent API                : list_set_graphic_pane
// Scale API match    ( 47%) : list_set_graphic_pane_g_Limits
// Scale parent match (100%) : list_set_graphic_pane
TAknTextLineLayout List_pane_texts__set_trans_graphic__Line_2(TInt /*aIndex_l*/, TInt /*aIndex_W*/)
    {
    return EmptyTextLayout();
    }

// LAF Table : List pane elements and descendants (settings edited)
// C= H={102, 136, 178, 212} W=318 b= l=26 r= t=58 
// Remark                    : Transparent setting value items.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 64%) : list_set_text_pane
// Scale parent match (100%) : main_pane
TAknWindowLineLayout list_set_trans_pane(TInt aIndex_H)
    {
    TInt variety = aIndex_H + 6;
    return list_set_pane(variety);
    }

// LAF Table : AVKON specific list pane
// C= H=34 W=318 b= l=0 r= t={0, 34, 68, 102, 136, 170} 
// Remark                    : Transparent list pane for setting item editing.
// Parent                    : list_set_pane
// Parent API                : list_set_pane
// Scale API match    ( 72%) : list_set_graphic_pane_ParamLimits
// Scale parent match (100%) : list_set_pane
TAknWindowLineLayout list_set_trans_graphic_pane(TInt aIndex_t)
    {
    return list_set_graphic_pane(aIndex_t);
    }

// LAF Table : List pane elements (set trans graphic)
// C=243 H=34 W=318 b= l= r= t= 
// Remark                    : Setting value item background.
// Parent                    : list_set_trans_graphic_pane
// Parent API                : list_set_trans_graphic_pane
// Scale API match    ( 44%) : list_set_graphic_pane_g_Limits
// Scale parent match ( 72%) : list_set_graphic_pane_ParamLimits
TAknWindowLineLayout List_pane_elements__set_trans_graphic__Line_1()
    {
    return AknLayoutScalable_Avkon::bg_set_opt_pane_cp4().LayoutLine();
    }
    
// C=215 H=34 W=20 b= l=30 r= t=2 
// Remark                    : Setting value item graphic shadow.
// Parent                    : list_set_trans_graphic_pane
// Parent API                : list_set_trans_graphic_pane
// Scale API match    ( 44%) : list_set_graphic_pane_g_Limits
// Scale parent match ( 72%) : list_set_graphic_pane_ParamLimits
TAknWindowLineLayout List_pane_elements__set_trans_graphic__Line_2()
    {
    return EmptyWindowLayout();
    }

// C=0 H=34 W=20 b= l=28 r= t=0 
// Remark                    : Setting value item graphic marked unmarked radio button onoff.
// Parent                    : list_set_trans_graphic_pane
// Parent API                : list_set_trans_graphic_pane
// Scale API match    ( 44%) : list_set_graphic_pane_g_Limits
// Scale parent match ( 72%) : list_set_graphic_pane_ParamLimits
TAknWindowLineLayout List_pane_elements__set_trans_graphic__Line_3()
    {
    return AknLayoutScalable_Avkon::list_set_graphic_pane_g1(0).LayoutLine();
    }

// C=215 H=26 W=26 b= l=240 r= t=6 
// Remark                    : Additional icon shadow.
// Parent                    : list_set_trans_graphic_pane
// Parent API                : list_set_trans_graphic_pane
// Scale API match    ( 44%) : list_set_graphic_pane_g_Limits
// Scale parent match ( 72%) : list_set_graphic_pane_ParamLimits
TAknWindowLineLayout List_pane_elements__set_trans_graphic__Line_4()
    {
    return EmptyWindowLayout();
    }

// C=0 H=26 W=26 b= l=238 r= t=4 
// Remark                    : Additional icon.
// Parent                    : list_set_trans_graphic_pane
// Parent API                : list_set_trans_graphic_pane
// Scale API match    ( 44%) : list_set_graphic_pane_g_Limits
// Scale parent match ( 72%) : list_set_graphic_pane_ParamLimits
TAknWindowLineLayout List_pane_elements__set_trans_graphic__Line_5()
    {
    // JH: IMPLEMENTED 28.12.2005
    return AknLayoutScalable_Avkon::list_setting_pane_g1(0).LayoutLine();
    }

// Active idle state layouts
// B=20 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignRight W=240 l=110 r=2 
// Remark                    : Soft indicator texts.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    ( 68%) : soft_indicator_pane
// Scale parent match (100%) : main_pane
TAknTextLineLayout Soft_indicator_texts_Line_1()
    {
    // JH: IMPLEMENTED 16.12.2005
    TAknTextComponentLayout layout = AknLayoutScalable_Avkon::soft_indicator_pane_t1();
    return layout.LayoutLine();
    }

// C= H=64 W=352 b= l=0 r= t=26 
// Remark                    : Link shortcut area.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : ai_links_pane
// Scale parent match (100%) : main_pane
TAknWindowLineLayout ai_links_pane()
    {
    TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::main_idle_act_pane(varietyIndex);
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::ai_links_pane(varietyIndex);
    return DoCompose(layout, layout2).LayoutLine();
    }

// C= H={36, 64, 92, 120, 148} W=352 b= l=0 r= t=0 
// Remark                    : General pane used to display calendar  events todo items player and operator specific items.
// Parent                    : main_pane
// Parent API                : main_pane
// Scale API match    (100%) : ai_gene_pane
// Scale parent match (100%) : main_pane
TAknWindowLineLayout ai_gene_pane(TInt /*aIndex_H*/)
    {
    TInt varietyIndex = Layout_Meta_Data::IsLandscapeOrientation() ? 1 : 0;
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::main_idle_act_pane(varietyIndex);
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::ai_gene_pane(varietyIndex);
    return DoCompose(layout, layout2).LayoutLine();
    }

// C=215 H=2 W=352 b= l=0 r= t=0 
// Remark                    : Horisontal separator line.
// Parent                    : ai_links_pane
// Parent API                : ai_links_pane
// Scale API match    ( 28%) : cell_ai_link_pane_ParamLimits
// Scale parent match (100%) : ai_links_pane
TAknWindowLineLayout Link_pane_elements_and_descendant_panes_Line_1()
    {
    // NOT NEEDED: Horizontal line.
    return EmptyWindowLayout();
    }

// C= H=58 W=338 b= l=6 r= t=4 
// Remark                    : Links.
// Parent                    : ai_links_pane
// Parent API                : ai_links_pane
// Scale API match    (100%) : grid_ai_links_pane
// Scale parent match (100%) : ai_links_pane
TAknWindowLineLayout grid_ai_links_pane()
    {
    return AknLayoutScalable_Avkon::grid_ai_links_pane().LayoutLine();
    }

/*
TAknLayoutTableLimits Link_pane_elements_and_descendant_panes_Limits();

TAknWindowLineLayout Link_pane_elements_and_descendant_panes(TInt aLineIndex);
*/

// C= H=50 W=58 b= l={0, 68, 134, 204, 272} r= t=0 
// Remark                    : Link cells.
// Parent                    : grid_ai_links_pane
// Parent API                : grid_ai_links_pane
// Scale API match    (100%) : cell_ai_link_pane
// Scale parent match (100%) : grid_ai_links_pane
TAknWindowLineLayout cell_ai_link_pane(TInt aIndex_l)
    {
    return AknLayoutScalable_Avkon::cell_ai_link_pane(aIndex_l).LayoutLine();
    }

// C= H=42 W=50 b= l=-4 r= t=4 
// Remark                    : Application shortcut image.
// Parent                    : cell_ai_link_pane
// Parent API                : cell_ai_link_pane
// Scale API match    ( 32%) : cell_ai_link_pane_ParamLimits
// Scale parent match (100%) : cell_ai_link_pane
TAknWindowLineLayout Link_shortcut_cell_pane_elements_Line_1()
    {
    return AknLayoutScalable_Avkon::cell_ai_link_pane_g1().LayoutLine();
    }

// C= H=50 W=58 b= l=4 r= t=4 
// Remark                    : Other shortcut image.
// Parent                    : cell_ai_link_pane
// Parent API                : cell_ai_link_pane
// Scale API match    ( 32%) : cell_ai_link_pane_ParamLimits
// Scale parent match (100%) : cell_ai_link_pane
TAknWindowLineLayout Link_shortcut_cell_pane_elements_Line_2()
    {
    return AknLayoutScalable_Avkon::cell_ai_link_pane_g2().LayoutLine();
    }

// C=247 H=50 W=58 b= l=4 r= t=4 
// Remark                    : Outside border.
// Parent                    : cell_ai_link_pane
// Parent API                : cell_ai_link_pane
// Scale API match    ( 32%) : cell_ai_link_pane_ParamLimits
// Scale parent match (100%) : cell_ai_link_pane
TAknWindowLineLayout Link_shortcut_cell_pane_elements_Line_3()
    {
    return AknLayoutScalable_Avkon::grid_highlight_cp2().LayoutLine();
    }

// C=0 H=46 W=54 b= l=6 r= t=6 
// Remark                    : Inside border.
// Parent                    : cell_ai_link_pane
// Parent API                : cell_ai_link_pane
// Scale API match    ( 32%) : cell_ai_link_pane_ParamLimits
// Scale parent match (100%) : cell_ai_link_pane
TAknWindowLineLayout Link_shortcut_cell_pane_elements_Line_4()
    {
    return AknLayoutScalable_Avkon::grid_highlight_cp2().LayoutLine();
    }

/*
TAknLayoutTableLimits Link_shortcut_cell_pane_elements_Limits();

TAknWindowLineLayout Link_shortcut_cell_pane_elements(TInt aLineIndex);
*/

// C= H=42 W=20 b= l=22 r= t=44 
// Remark                    : 
// Parent                    : cell_ai_link_pane
// Parent API                : cell_ai_link_pane
// Scale API match    (100%) : popup_ai_links_title_window
// Scale parent match (100%) : cell_ai_link_pane
TAknWindowLineLayout popup_ai_links_title_window()
    {
    // JH: IMPLEMENTED 3.1.2006
    return AknLayoutScalable_Avkon::popup_ai_links_title_window().LayoutLine();
    }

// B=24 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W=326 l=10 r=10 
// Remark                    : Link shortcut title text.
// Parent                    : popup_ai_links_title_window
// Parent API                : popup_ai_links_title_window
// Scale API match    ( 37%) : text_title_t1_ParamLimits
// Scale parent match (100%) : popup_ai_links_title_window
TAknTextLineLayout Link_shortcut_title_texts_Line_1()
    {
    return AknLayoutScalable_Avkon::popup_ai_links_title_window_t1().LayoutLine();
    }

// C=0 H=42 W=p b= l=0 r= t=0 
// Remark                    : A rectangle to cover the main pane items.
// Parent                    : popup_ai_links_title_window
// Parent API                : popup_ai_links_title_window
// Scale API match    ( 39%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_ai_links_title_window
TAknWindowLineLayout Link_shortcut_title_pop_up_window_graphics_Line_1(const TRect& /*aParentRect*/)
    {
    // NOT NEEDED: 
    return EmptyWindowLayout();
    }

// C=221 H=34 W=p-8 b= l=6 r= t=6 
// Remark                    : Shadow.
// Parent                    : popup_ai_links_title_window
// Parent API                : popup_ai_links_title_window
// Scale API match    ( 39%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_ai_links_title_window
TAknWindowLineLayout Link_shortcut_title_pop_up_window_graphics_Line_2(const TRect& /*aParentRect*/)
    {
    // NOT NEEDED: Shadow
    return EmptyWindowLayout();
    }

// C=215 H=36 W=p-6 b= l=2 r= t=2 
// Remark                    : Outline frame.
// Parent                    : popup_ai_links_title_window
// Parent API                : popup_ai_links_title_window
// Scale API match    ( 39%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_ai_links_title_window
TAknWindowLineLayout Link_shortcut_title_pop_up_window_graphics_Line_3(const TRect& /*aParentRect*/)
    {
    // NOT NEEDED: Outline frame
    return EmptyWindowLayout();
    }

// C=3 H=32 W=p-10 b= l=4 r= t=4 
// Remark                    : Inside area.
// Parent                    : popup_ai_links_title_window
// Parent API                : popup_ai_links_title_window
// Scale API match    ( 39%) : popup_snote_single_graphic_window_g1_ParamLimits
// Scale parent match (100%) : popup_ai_links_title_window
TAknWindowLineLayout Link_shortcut_title_pop_up_window_graphics_Line_4(const TRect& /*aParentRect*/)
    {
    // NOT NEEDED: Inside area
    return EmptyWindowLayout();
    }

/*
TAknLayoutTableLimits Link_shortcut_title_pop_up_window_graphics_Limits();

TAknWindowLineLayout Link_shortcut_title_pop_up_window_graphics(TInt aLineIndex, const TRect& aParentRect);
*/
// C= H=36 W=352 b= l=0 r= t=0 
// Remark                    : 
// Parent                    : ai_gene_pane
// Parent API                : ai_gene_pane
// Scale API match    (100%) : ai_gene_pane_1
// Scale parent match (100%) : ai_gene_pane
TAknWindowLineLayout ai_gene_pane_1()
    {
    return AknLayoutScalable_Avkon::ai_gene_pane_1().LayoutLine();
    }

// C= H=28 W=352 b= l=0 r= t={36, 64, 92, 120, 148} 
// Remark                    : 
// Parent                    : ai_gene_pane
// Parent API                : ai_gene_pane
// Scale API match    (100%) : ai_gene_pane_2
// Scale parent match (100%) : ai_gene_pane
TAknWindowLineLayout ai_gene_pane_2(TInt /*aIndex_t*/)
    {
    return AknLayoutScalable_Avkon::ai_gene_pane_2().LayoutLine();
    }

// C=215 H=2 W=352 b= l=0 r= t=0 
// Remark                    : Horisontal separator line.
// Parent                    : ai_gene_pane_1
// Parent API                : ai_gene_pane_1
// Scale API match    ( 25%) : popup_window_general_ParamLimits
// Scale parent match (100%) : ai_gene_pane_1
TAknWindowLineLayout First_general_event_elements_Line_1()
    {
    return AknLayoutScalable_Avkon::ai_gene_pane_1_g2(0).LayoutLine();
    }

// C= H=26 W=26 b= l=6 r= t=6 
// Remark                    : Event type indication.
// Parent                    : ai_gene_pane_1
// Parent API                : ai_gene_pane_1
// Scale API match    ( 25%) : popup_window_general_ParamLimits
// Scale parent match (100%) : ai_gene_pane_1
TAknWindowLineLayout First_general_event_elements_Line_2()
    {
    return AknLayoutScalable_Avkon::ai_gene_pane_1_g1(0).LayoutLine();
    }

// B=26 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W={308, 340}[aCommon1] l={38, 6}[aCommon1] r=6 
// Remark                    : Event text.
// Parent                    : ai_gene_pane_1
// Parent API                : ai_gene_pane_1
// Scale API match    ( 29%) : popup_window_general_ParamLimits
// Scale parent match (100%) : ai_gene_pane_1
TAknTextLineLayout First_general_event_texts_Line_1(TInt aCommon1)
    {
    return AknLayoutScalable_Avkon::ai_gene_pane_1_t1(aCommon1).LayoutLine();
    }

// B=18 C=215 Font=ELatinPlain12_Scaled J=ELayoutAlignLeft W={308, 340}[aCommon1] l={38, 6}[aCommon1] r=6 
// Remark                    : Event text.
// Parent                    : ai_gene_pane_2
// Parent API                : ai_gene_pane_2
// Scale API match    ( 33%) : navi_navi_icon_text_pane_t1
// Scale parent match (100%) : ai_gene_pane_2
TAknTextLineLayout Second_general_event_pane_texts_Line_1(TInt aCommon1)
    {
    return AknLayoutScalable_Avkon::ai_gene_pane_2_t1(aCommon1).LayoutLine();
    }

// C= H=p W=p b= l=0 r= t=0 
// Remark                    : Grid highlight.
// Parent                    : cell_ai_link_pane
// Parent API                : cell_ai_link_pane
// Scale API match    ( 40%) : cell_highlight_pane_g_Limits
// Scale parent match (100%) : cell_ai_link_pane
TAknWindowLineLayout Shortcut_link_highlight_Line_1(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

// C= H=p-2 W=p b= l=0 r= t=2 
// Remark                    : List highlight.
// Parent                    : ai_gene_pane
// Parent API                : ai_gene_pane
// Scale API match    ( 25%) : highlight_inv_title_g1
// Scale parent match (100%) : ai_gene_pane
TAknWindowLineLayout Highlight_for_other_Active_Idle_items_Line_1(const TRect& /*aParentRect*/)
    {
    // JH: IMPLEMENTED 13.12.2005
    TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::grid_highlight_cp2();
    return layout.LayoutLine();
    }

TAknTextLineLayout Find_pop_up_window_texts_Line_2()
    {
    // No space is left for find pane editor inficators when this layout is called.
    // Large text is assumed.
    TInt varietyIndex = 0; // AsM 27.06.2005
    TAknWindowComponentLayout layout1 = AknLayoutScalable_Avkon::find_popup_pane();
    TAknWindowComponentLayout layout2 = AknLayoutScalable_Avkon::input_popup_find_pane_cp();
    TAknTextComponentLayout layout3 = AknLayoutScalable_Avkon::input_popup_find_pane_t1(varietyIndex);
    return DoComposeText( DoCompose(layout1, layout2), layout3 ).LayoutLine();
    }

/*
    TAknLayoutTableLimits Find_pop_up_window_texts_Limits();
    TAknTextLineLayout Find_pop_up_window_texts(TInt aLineIndex);
    */
TAknTextLineLayout Find_pane_texts_Line_2()
    {
   TAknWindowComponentLayout layout = AknLayoutScalable_Avkon::input_find_pane();
   TAknTextComponentLayout l2 = AknLayoutScalable_Avkon::input_find_pane_t1(0);
   return DoComposeText(layout,l2).LayoutLine();
    }

/*
TAknLayoutTableLimits Find_pane_texts_Limits();

TAknTextLineLayout Find_pane_texts(TInt aLineIndex)
*/

TAknWindowLineLayout ai_gene_pane_3()
    {
    // Implementation is not needed because 
    // active idle application uses new layout API
    // if scalable layout insterface is available.
    return EmptyWindowLayout();  
    }

TAknWindowLineLayout Third_general_event_elements_Line_1()
    {
    return EmptyWindowLayout();
    }

TAknWindowLineLayout Third_general_event_elements_Line_2()
    {
    return EmptyWindowLayout();
    }

/*
TAknLayoutTableLimits Third_general_event_elements_Limits()

TAknWindowLineLayout Third_general_event_elements(TInt aLineIndex)
*/

TAknWindowLineLayout popup_ai_message_window()
    {
    return EmptyWindowLayout();
    }

TAknWindowLineLayout Active_idle_message_pop_up_window_descendants_Line_1()
    {
    return EmptyWindowLayout();
    }

TAknWindowLineLayout Active_idle_message_pop_up_window_descendants_Line_2()
    {
    return EmptyWindowLayout();
    }

TAknWindowLineLayout Active_idle_message_pop_up_window_descendants_Line_3()
    {
    return EmptyWindowLayout();
    }

/*
TAknLayoutTableLimits Active_idle_message_pop_up_window_descendants_Limits();

TAknWindowLineLayout Active_idle_message_pop_up_window_descendants(TInt aLineIndex);
*/

TAknTextLineLayout Active_idle_message_popup_window_texts_Line_1(TInt /*aCommon1*/, TInt /*aIndex_B*/)
    {
    return EmptyTextLayout();
    }

/*
TAknMultiLineTextLayout Multiline_Active_idle_message_popup_window_texts_Line_1(TInt aCommon1, TInt aNumberOfLinesShown)
*/
  
TAknWindowLineLayout Active_idle_heading_pane_elements_Line_1()
    {
    return EmptyWindowLayout();
    }

TAknWindowLineLayout Active_idle_heading_pane_elements_Line_2()
    {
    return EmptyWindowLayout();
    }

TAknWindowLineLayout Active_idle_heading_pane_elements_Line_3()
    {
    return EmptyWindowLayout();
    }

TAknWindowLineLayout Active_idle_heading_pane_elements_Line_4()
    {
    return EmptyWindowLayout();
    }

/*
TAknLayoutTableLimits Active_idle_heading_pane_elements_Limits();
TAknWindowLineLayout Active_idle_heading_pane_elements(TInt aLineIndex);
*/

TAknTextLineLayout Active_idle_heading_pane_texts_Line_1(TInt /*aCommon1*/)
    {
    return EmptyTextLayout();
    }

TAknTextLineLayout Active_idle_heading_pane_texts_Line_2()
    {
    return EmptyTextLayout();
    }

TAknWindowLineLayout Active_idle_message_pop_up_window_graphics_Line_1(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

TAknWindowLineLayout Active_idle_message_pop_up_window_graphics_Line_2(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

TAknWindowLineLayout Active_idle_message_pop_up_window_graphics_Line_3(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

TAknWindowLineLayout Active_idle_message_pop_up_window_graphics_Line_4(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

TAknWindowLineLayout Active_idle_message_pop_up_window_graphics_Line_5(const TRect& /*aParentRect*/)
    {
    return EmptyWindowLayout();
    }

/*
TAknLayoutTableLimits Active_idle_message_pop_up_window_graphics_Limits();

TAknTextLineLayout Active_idle_message_pop_up_window_graphics(TInt aLineIndex, const TRect& aParentRect);
*/


// numbers (apart from table limits) in the following table have not been updated yet.

const TUint KDataLookup[AknLayout::E_TApiId_TableSize] =
	{
(TUint)&screen,

(TUint)&application_window,

(TUint)&status_pane,

(TUint)&main_pane,

(TUint)&control_pane,

(TUint)&signal_pane,

(TUint)&context_pane,

(TUint)&title_pane,

(TUint)&battery_pane,

(TUint)&uni_indicator_pane,

(TUint)&navi_pane,

(TUint)&Status_pane_elements_Line_1,

(TUint)&Status_pane_elements_Line_2,

0x0001,

(TUint)AknLayout::EApiId_Status_pane_elements_Line_1,

(TUint)&Signal_pane_elements_Line_1,

(TUint)&Signal_pane_elements_Line_2,

0x0001,

(TUint)AknLayout::EApiId_Signal_pane_elements_Line_1,

(TUint)&Signal_strength_area_values_Line_1,

(TUint)&Signal_strength_area_values_Line_2,

(TUint)&Signal_strength_area_values_Line_3,

(TUint)&Signal_strength_area_values_Line_4,

(TUint)&Signal_strength_area_values_Line_5,

(TUint)&Signal_strength_area_values_Line_6,

(TUint)&Signal_strength_area_values_Line_7,

(TUint)&Signal_strength_area_values_Line_8,

0x0007,

(TUint)AknLayout::EApiId_Signal_strength_area_values_Line_1,

(TUint)Battery_pane_elements_Line_1,

(TUint)Battery_pane_elements_Line_2,

0x0001,

(TUint)AknLayout::EApiId_Battery_pane_elements_Line_1,

(TUint)Battery_strength_area_values_Line_1,

(TUint)Battery_strength_area_values_Line_2,

(TUint)Battery_strength_area_values_Line_3,

(TUint)Battery_strength_area_values_Line_4,

(TUint)Battery_strength_area_values_Line_5,

(TUint)Battery_strength_area_values_Line_6,

(TUint)Battery_strength_area_values_Line_7,

(TUint)Battery_strength_area_values_Line_8,

0x0007,

(TUint)AknLayout::EApiId_Battery_strength_area_values_Line_1,

(TUint)Context_pane_elements_Line_1,

(TUint)Title_pane_texts_Line_1,

(TUint)Title_pane_texts_Line_2,

0x0001,	// Multiline_Title_pane_texts_Line_2

(TUint)Title_pane_elements_Line_1,

(TUint)Universal_indicator_pane_elements_Line_1,

(TUint)Navi_pane_arrow_elements_Line_1,

(TUint)Navi_pane_arrow_elements_Line_2,

(TUint)Navi_pane_tab_elements_Line_1,

(TUint)Navi_pane_tab_elements_Line_1,

(TUint)Navi_pane_tab_elements_Line_3,

(TUint)Navi_pane_tab_elements_Line_3,

(TUint)Navi_pane_tab_elements_Line_5,

(TUint)Navi_pane_tab_elements_Line_5,

(TUint)Navi_pane_tab_elements_Line_5,

(TUint)Navi_pane_tab_elements_Line_8,

(TUint)Navi_pane_tab_elements_Line_8,

(TUint)Navi_pane_tab_elements_Line_8,

(TUint)Navi_pane_tab_elements_Line_11,

(TUint)Navi_pane_tab_elements_Line_11,

(TUint)Navi_pane_tab_elements_Line_11,

(TUint)Navi_pane_tab_elements_Line_11,

0x000d,

(TUint)AknLayout::EApiId_Navi_pane_tab_elements_Line_1,

(TUint)Elements_on_the_tabs_Line_1,

(TUint)Elements_on_the_tabs_Line_2,

(TUint)Elements_on_the_tabs_Line_3,

0x0002,

(TUint)AknLayout::EApiId_Elements_on_the_tabs_Line_1,

(TUint)Texts_on_the_tabs_Line_1,

(TUint)Texts_on_the_tabs_Line_2,

(TUint)Texts_on_the_tabs_Line_3,

(TUint)Texts_on_the_tabs_Line_4,

(TUint)Texts_on_the_tabs_Line_5,

0x0004,

(TUint)AknLayout::EApiId_Texts_on_the_tabs_Line_1,

(TUint)Navi_pane_icons_Line_1,

(TUint)Navi_pane_icons_Line_2,

(TUint)Navi_pane_texts_Line_1,

(TUint)Navi_pane_texts_Line_2,

(TUint)Navi_pane_texts_Line_3,

(TUint)Navi_pane_texts_Line_4,

(TUint)Navi_pane_texts_Line_5,

(TUint)Navi_pane_texts_Line_6,

(TUint)Navi_pane_texts_Line_7,

(TUint)Navi_pane_area_for_editing_status_icons_Line_1,

(TUint)Volume_glider_elements__one__Line_1,

(TUint)volume_navi_pane,

0x0001,

(TUint)AknLayout::EApiId_Volume_glider_elements__one__Line_1,

(TUint)Volume_pane_elements__one__Line_1,

(TUint)Volume_pane_elements__one__Line_2,

(TUint)Volume_pane_elements__one__Line_3,

(TUint)Volume_pane_elements__one__Line_4,

(TUint)Volume_pane_elements__one__Line_5,

(TUint)Volume_pane_elements__one__Line_6,

(TUint)Volume_pane_elements__one__Line_7,

(TUint)Volume_pane_elements__one__Line_8,

(TUint)Volume_pane_elements__one__Line_9,

(TUint)Volume_pane_elements__one__Line_10,

0x0009,

(TUint)AknLayout::EApiId_Volume_pane_elements__one__Line_1,

(TUint)list_gen_pane,

(TUint)find_pane,

(TUint)wallpaper_pane,

(TUint)indicator_pane,

(TUint)soft_indicator_pane,

(TUint)A_column,

(TUint)B_column,

(TUint)C_column,

(TUint)D_column,

0x0003,

(TUint)AknLayout::EApiId_A_column,

(TUint)list_single_pane,

(TUint)list_single_number_pane,

(TUint)list_single_heading_pane,

(TUint)list_single_graphic_pane,

(TUint)list_single_graphic_heading_pane,

(TUint)list_single_number_heading_pane,

(TUint)list_single_large_graphic_pane,

(TUint)list_double_pane,

(TUint)list_double2_pane,

(TUint)list_double_number_pane_list_single_big_number_pane,

(TUint)list_double_time_pane,

(TUint)list_double_large_graphic_pane_list_double2_large_graphic_pane_list_single_big_large_graphic_pane,

(TUint)list_double_graphic_pane_list_double2_graphic_pane,

(TUint)list_single_big_heading_graphic_pane,

(TUint)list_single_big_heading_pane,

(TUint)list_setting_pane_list_big_setting_pane,

(TUint)list_setting_number_pane_list_big_setting_number_pane,

(TUint)list_setting_double2_pane,

(TUint)list_double2_graphic_pane,

(TUint)list_double2_large_graphic_pane,

(TUint)list_single_2graphic_pane,

(TUint)list_double2_graphic_large_graphic_pane,

(TUint)ListLine,//0x0015,

(TUint)AknLayout::EApiId_list_single_pane,

(TUint)List_pane_elements__single__Line_1,

(TUint)List_pane_elements__single__Line_2,

(TUint)List_pane_texts__single__Line_1,

(TUint)List_pane_elements__single_number__Line_1,

(TUint)List_pane_elements__single_number__Line_2,

(TUint)List_pane_texts__single_number__Line_1,

(TUint)List_pane_texts__single_number__Line_2,

(TUint)List_pane_elements__single_heading__Line_1,

(TUint)List_pane_elements__single_heading__Line_2,

(TUint)List_pane_elements__single_heading__Line_3,

0x0001,

(TUint)AknLayout::EApiId_List_pane_elements__single_heading__Line_1,

(TUint)List_pane_texts__single_heading__Line_1,

(TUint)List_pane_texts__single_heading__Line_2,

0x0001,

(TUint)AknLayout::EApiId_List_pane_texts__single_heading__Line_1,

(TUint)List_pane_elements__single_graphic__Line_1,

(TUint)List_pane_elements__single_graphic__Line_2,

(TUint)List_pane_elements__single_graphic__Line_3,

0x0001,

(TUint)AknLayout::EApiId_List_pane_elements__single_graphic__Line_1,

(TUint)List_pane_texts__single_graphic__Line_1,

(TUint)List_pane_elements__single_graphic_heading__Line_1,

(TUint)List_pane_elements__single_graphic_heading__Line_2,

(TUint)List_pane_elements__single_graphic_heading__Line_3,

(TUint)List_pane_elements__single_graphic_heading__Line_4,

0x0002,

(TUint)AknLayout::EApiId_List_pane_elements__single_graphic_heading__Line_1,

(TUint)List_pane_texts__single_graphic_heading__Line_1,

(TUint)List_pane_texts__single_graphic_heading__Line_2,

0x0001,

(TUint)AknLayout::EApiId_List_pane_texts__single_graphic_heading__Line_1,

(TUint)List_pane_elements__single_number_heading__Line_1,

(TUint)List_pane_elements__single_number_heading__Line_2,

(TUint)List_pane_elements__single_number_heading__Line_3,

0x0001,

(TUint)AknLayout::EApiId_List_pane_elements__single_number_heading__Line_1,

(TUint)List_pane_texts__single_number_heading__Line_1,

(TUint)List_pane_texts__single_number_heading__Line_2,

(TUint)List_pane_texts__single_number_heading__Line_3,

0x0002,

(TUint)AknLayout::EApiId_List_pane_texts__single_number_heading__Line_1,

(TUint)List_pane_elements__single_large_graphic__Line_1,

(TUint)List_pane_elements__single_large_graphic__Line_2,

(TUint)List_pane_elements__single_large_graphic__Line_3,

(TUint)do_not_use_empty_pane1,

(TUint)do_not_use_empty_pane2,

(TUint)List_pane_texts__single_large_graphic__Line_1,

(TUint)List_pane_elements__double__Line_1,

(TUint)List_pane_elements__double__Line_2,

(TUint)List_pane_texts__double__Line_1,

(TUint)List_pane_texts__double__Line_2,

(TUint)List_pane_text__double2__Line_1,

(TUint)List_pane_text__double2__Line_2,

(TUint)List_pane_elements__double_number__Line_1,

(TUint)List_pane_elements__double_number__Line_2,

(TUint)List_pane_texts__double_number__Line_1,

(TUint)List_pane_texts__double_number__Line_2,

(TUint)List_pane_texts__double_number__Line_3,

(TUint)List_pane_elements__double_graphic__Line_1,

(TUint)List_pane_elements__double_graphic__Line_2,

(TUint)List_pane_elements__double_graphic__Line_3,

0x0001,

(TUint)AknLayout::EApiId_List_pane_elements__double_graphic__Line_1,

(TUint)List_pane_texts__double_graphic__Line_1,

(TUint)List_pane_texts__double_graphic__Line_2,

(TUint)List_pane_elements__double2_graphic__Line_1,

(TUint)List_pane_elements__double2_graphic__Line_2,

(TUint)List_pane_elements__double2_graphic__Line_3,

0x0001,

(TUint)AknLayout::EApiId_List_pane_elements__double2_graphic__Line_1,

(TUint)List_pane_texts__double2_graphic__Line_1,

(TUint)List_pane_texts__double2_graphic__Line_2,

(TUint)List_pane_elements__double2_large_graphic__Line_1,

(TUint)List_pane_elements__double2_large_graphic__Line_2,

(TUint)List_pane_elements__double2_large_graphic__Line_3,

0x0001,

(TUint)AknLayout::EApiId_List_pane_elements__double2_large_graphic__Line_1,

(TUint)List_pane_texts__double2_large_graphic__Line_1,

(TUint)List_pane_texts__double2_large_graphic__Line_2,

(TUint)List_pane_elements__large_single_heading_graphic__Line_1,

(TUint)List_pane_elements__large_single_heading_graphic__Line_2,

(TUint)List_pane_elements__large_single_heading_graphic__Line_3,

0x0001,

(TUint)AknLayout::EApiId_List_pane_elements__large_single_heading_graphic__Line_1,

(TUint)List_pane_texts__large_single_heading_graphic__Line_1,

(TUint)List_pane_texts__large_single_heading_graphic__Line_2,

(TUint)List_pane_elements__large_single_heading__Line_1,

(TUint)List_pane_texts__large_single_heading__Line_1,

(TUint)List_pane_texts__large_single_heading__Line_2,

0x0001,

(TUint)AknLayout::EApiId_List_pane_texts__large_single_heading__Line_1,

(TUint)List_pane_elements__double_time__Line_1,

(TUint)List_pane_texts__double_time__Line_1,

(TUint)List_pane_texts__double_time__Line_2,

(TUint)List_pane_texts__double_time__Line_3,

(TUint)List_pane_texts__double_time__Line_4,

0x0003,

(TUint)AknLayout::EApiId_List_pane_texts__double_time__Line_1,

(TUint)List_pane_elements__double_large_graphic__Line_1,

(TUint)List_pane_elements__double_large_graphic__Line_2,

(TUint)List_pane_elements__double_large_graphic__Line_3,

(TUint)List_pane_elements__double_large_graphic__Line_4,

(TUint)List_pane_elements__double_large_graphic__Line_5,

(TUint)List_pane_elements__double_large_graphic__Line_6,

(TUint)List_pane_elements__double_large_graphic__Line_7,

(TUint)List_pane_elements__double_large_graphic__Line_8,

(TUint)List_pane_elements__double_large_graphic__Line_9,

(TUint)List_pane_elements__double_large_graphic__Line_10,

(TUint)List_pane_texts__double_large_graphic__Line_1,

(TUint)List_pane_texts__double_large_graphic__Line_2,

(TUint)List_pane_elements__setting__Line_1,

(TUint)List_pane_elements__setting__Line_2,

(TUint)List_pane_elements__setting__Line_3,

(TUint)List_pane_elements__setting__Line_4,

(TUint)List_pane_elements__setting__Line_5,

(TUint)List_pane_elements__setting__Line_6,

0x0005,

(TUint)AknLayout::EApiId_List_pane_elements__setting__Line_1,

(TUint)List_pane_texts__setting__Line_1,

(TUint)List_pane_texts__setting__Line_2,

(TUint)List_pane_texts__setting__Line_3,

(TUint)List_pane_texts__setting__Line_4,

0x0003,

(TUint)AknLayout::EApiId_List_pane_texts__setting__Line_1,

(TUint)List_pane_elements__setting_number__Line_1,

(TUint)List_pane_elements__setting_number__Line_2,

(TUint)List_pane_elements__setting_number__Line_3,

(TUint)List_pane_elements__setting_number__Line_4,

(TUint)List_pane_elements__setting_number__Line_5,

0x0004,

(TUint)AknLayout::EApiId_List_pane_elements__setting_number__Line_1,

(TUint)List_pane_texts__setting_number__Line_1,

(TUint)List_pane_texts__setting_number__Line_2,

(TUint)List_pane_texts__setting_number__Line_3,

(TUint)List_pane_texts__setting_number__Line_4,

0x0003,

(TUint)AknLayout::EApiId_List_pane_texts__setting_number__Line_1,

(TUint)Setting_volume_elements_Line_1,

(TUint)Setting_volume_elements_Line_2,

(TUint)Setting_volume_elements_Line_3,

(TUint)Setting_volume_elements_Line_4,

(TUint)Setting_volume_elements_Line_5,

(TUint)Setting_volume_elements_Line_6,

(TUint)Setting_volume_elements_Line_7,

(TUint)Setting_volume_elements_Line_8,

(TUint)Setting_volume_elements_Line_9,

(TUint)Setting_volume_elements_Line_10,

0x0009,

(TUint)AknLayout::EApiId_Setting_volume_elements_Line_1,

(TUint)Setting_slider_elements_Line_1,

(TUint)List_pane_elements__setting_double2__Line_1,

(TUint)List_pane_elements__setting_double2__Line_2,

(TUint)List_pane_elements__setting_double2__Line_3,

0x0002,

(TUint)AknLayout::EApiId_List_pane_elements__setting_double2__Line_1,

(TUint)List_pane_lines__A_column__Line_1,

(TUint)List_pane_lines__A_column__Line_2,

(TUint)List_pane_lines__AB_columns__Line_1,

(TUint)List_pane_lines__AB_columns__Line_2,

(TUint)List_pane_lines__BC_columns__Line_1,

(TUint)List_pane_lines__BC_columns__Line_2,

0x3b98,	// List_pane_highlight_graphics__various__Line_1

(TUint)List_pane_highlight_graphics__various__Line_2, //0x3ba1

0x3baa,	// List_pane_highlight_graphics__various__Line_3

0x0001,

(TUint)AknLayout::EApiId_List_pane_highlight_graphics__various__Line_1,

0x3bb5,	// List_pane_highlight_graphics__setting_number__Line_1

0x3bbe,	// List_pane_highlight_graphics__setting_number__Line_2

0x3bc7,	// List_pane_highlight_graphics__setting_number__Line_3

0x0001,

(TUint)AknLayout::EApiId_List_pane_highlight_graphics__setting_number__Line_1,

0x3bce,	// Find_pane_elements_Line_1

0x3bd5,	// Find_pane_elements_Line_2

0x3bde,	// Find_pane_elements_Line_3

(TUint)Find_pane_elements_Line_4,

(TUint)Find_pane_elements_Line_5,

0x0004,

(TUint)AknLayout::EApiId_Find_pane_elements_Line_1,

(TUint)Find_pane_texts_Line_1,

(TUint)form_field_data_pane,

(TUint)form_field_data_wide_pane,

(TUint)form_field_popup_pane,

(TUint)form_field_popup_wide_pane,

(TUint)form_field_slider_pane,

(TUint)form_field_slider_wide_pane,

0x0005,

(TUint)AknLayout::EApiId_form_field_data_pane,

(TUint)Form_data_field_elements_Line_1,

(TUint)Form_data_field_elements_Line_2,

(TUint)Form_data_field_elements_Line_3,

(TUint)Form_data_field_elements_Line_4,

(TUint)Form_data_field_texts_Line_1,

0x0001, // Multiline_Form_data_field_texts_Line_1,

(TUint)Form_data_field_texts_Line_2,

(TUint)Multiline_Form_data_field_texts_Line_2,

(TUint)Form_data_wide_field_elements_Line_1,

(TUint)Form_data_wide_field_elements_Line_2,

(TUint)Form_data_wide_field_elements_Line_3,

(TUint)Form_data_wide_field_elements_Line_4,

(TUint)Form_data_wide_field_texts_Line_1,

(TUint)Form_data_wide_field_texts_Line_2,

(TUint)Multiline_Form_data_wide_field_texts_Line_2,

(TUint)Form_pop_up_field_elements_and_descendants_Line_1,

(TUint)Form_pop_up_field_elements_and_descendants_Line_2,

(TUint)Form_pop_up_field_elements_and_descendants_Line_3,

(TUint)Form_pop_up_field_elements_and_descendants_Line_4,

(TUint)Form_pop_up_field_elements_and_descendants_Line_5,

(TUint)list_form_pane,

(TUint)list_form_graphic_pane,

(TUint)List_pane_elements__form_graphic__Line_1,

(TUint)List_pane_elements__form_graphic__Line_2,

(TUint)List_pane_texts__form_graphic__Line_1,

(TUint)Form_pop_up_wide_field_elements_and_descendants_Line_1,

(TUint)Form_pop_up_wide_field_elements_and_descendants_Line_2,

(TUint)Form_pop_up_wide_field_elements_and_descendants_Line_3,

(TUint)Form_pop_up_wide_field_elements_and_descendants_Line_4,

(TUint)Form_pop_up_wide_field_elements_and_descendants_Line_5,

(TUint)list_form_wide_pane,

(TUint)list_form_graphic_wide_pane,

(TUint)List_pane_elements__form_graphic_wide__Line_1,

(TUint)List_pane_elements__form_graphic_wide__Line_2,

(TUint)List_pane_texts__form_graphic_wide__Line_1,

(TUint)Form_slider_field_elements_and_descendants_Line_1,

(TUint)Form_slider_field_elements_and_descendants_Line_2,

(TUint)Form_slider_field_elements_and_descendants_Line_3,

(TUint)Form_slider_field_elements_and_descendants_Line_4,

(TUint)Form_slider_field_elements_and_descendants_Line_5,

(TUint)Form_slider_field_elements_and_descendants_Line_6,

(TUint)Slider_pane_elements__form__Line_1,

(TUint)Slider_pane_elements__form__Line_2,

0x0001,

(TUint)AknLayout::EApiId_Slider_pane_elements__form__Line_1,

(TUint)Form_slider_field_texts_Line_1,

(TUint)Form_slider_field_texts_Line_2,

(TUint)Form_slider_field_texts_Line_3,

0x0101,	// Multiline_Form_slider_field_texts_Line_3

0x0001,

(TUint)AknLayout::EApiId_Form_slider_field_texts_Line_1,

(TUint)Form_slider_field_elements_and_descendants_dup_Line_1,

(TUint)Form_slider_field_elements_and_descendants_dup_Line_2,

(TUint)Form_slider_field_elements_and_descendants_dup_Line_3,

(TUint)Form_slider_field_elements_and_descendants_dup_Line_4,

(TUint)Form_slider_field_elements_and_descendants_dup_Line_5,

(TUint)Form_slider_field_elements_and_descendants_dup_Line_6,

(TUint)Slider_pane_elements__form__dup_Line_1,

(TUint)Slider_pane_elements__form__dup_Line_2,

0x0001,

(TUint)AknLayout::EApiId_Slider_pane_elements__form__dup_Line_1,

(TUint)Form_slider_field_texts_dup_Line_1,

(TUint)Form_slider_field_texts_dup_Line_2,

(TUint)Form_slider_field_texts_dup_Line_3,

0x0101,	// Multiline_Form_slider_field_texts_dup_Line_3

0x0001,

(TUint)AknLayout::EApiId_Form_slider_field_texts_dup_Line_1,

(TUint)Cursor_graphics__13__Line_1,

(TUint)Predictive_text_input_graphics__13__Line_1,

(TUint)Predictive_text_input_graphics__13__Line_2,

0x0001,

(TUint)AknLayout::EApiId_Predictive_text_input_graphics__13__Line_1,

(TUint)Cut_copy_and_paste_highlight_graphics__13__Line_1,

(TUint)Time_and_date_entry_graphics__13__Line_1,

(TUint)Cursor_graphics__12__Line_1,

(TUint)Predictive_text_input_graphics__12__Line_1,

(TUint)Predictive_text_input_graphics__12__Line_2,

0x0001,

(TUint)AknLayout::EApiId_Predictive_text_input_graphics__12__Line_1,

(TUint)Cut_copy_and_paste_highlight_graphics__12__Line_1,

(TUint)Time_and_date_entry_graphics__12__Line_1,

(TUint)list_set_graphic_pane,

(TUint)List_pane_elements__set_graphic__Line_1,

(TUint)List_pane_elements__set_graphic__Line_2,

(TUint)List_pane_elements__set_graphic__Line_3,

0x0102,

(TUint)AknLayout::EApiId_List_pane_elements__set_graphic__Line_1,

(TUint)List_pane_texts__set_graphic__Line_1,

(TUint)Application_grid_descendant_Line_1,

(TUint)Cell_pane_elements__app__Line_1,

(TUint)Cell_pane_elements__app__Line_2,

0x0001,

(TUint)AknLayout::EApiId_Cell_pane_elements__app__Line_1,

(TUint)Cell_pane_texts__app__Line_1,

(TUint)Cell_pane_highlight_elements__various__Line_1,

(TUint)Wallpaper_pane_element_Line_1,

(TUint)Indicator_pane_elements_Line_1,

(TUint)Soft_indicator_pane_elements_Line_1,

(TUint)Soft_indicator_pane_texts_Line_1,

0x0000,	// Multiline_Soft_indicator_pane_texts_Line_1

(TUint)power_save_pane,

(TUint)Power_save_pane_descendants_Line_1,

(TUint)Power_save_pane_descendants_Line_2,

(TUint)Power_save_pane_descendants_Line_3,

0x0002,

(TUint)AknLayout::EApiId_Power_save_pane_descendants_Line_1,

(TUint)Idle_power_save_state_texts_Line_1,

(TUint)Idle_power_save_state_texts_Line_2,

(TUint)Idle_power_save_state_texts_Line_3,

(TUint)Idle_power_save_state_texts_Line_4,

0x0003,

(TUint)AknLayout::EApiId_Idle_power_save_state_texts_Line_1,

(TUint)grid_app_pane,

(TUint)Empty_list_texts_Line_1,

0x0000, // Multiline_Empty_list_texts_Line_1,

(TUint)Empty_list_texts__find__Line_1,

0x0000,	// Multiline_Empty_list_texts__find__Line_1

(TUint)List_pane_elements_and_descendants__settings_edited__Line_1,

(TUint)List_pane_elements_and_descendants__settings_edited__Line_2,

(TUint)list_set_pane,

(TUint)List_pane_elements_and_descendants__settings_edited__Line_4,

(TUint)setting_volume_pane,

(TUint)setting_slider_pane,

(TUint)setting_slider_graphic_pane,

(TUint)setting_text_pane,

(TUint)setting_code_pane,

(TUint)Setting_item_texts_Line_1,

(TUint)Setting_item_texts_Line_2,

(TUint)Setting_volume_pane_elements_Line_1,

(TUint)Setting_volume_pane_elements_Line_2,

(TUint)Setting_volume_pane_elements_Line_3,

(TUint)Setting_volume_pane_elements_Line_4,

(TUint)Setting_volume_pane_elements_Line_5,

(TUint)Setting_volume_pane_elements_Line_6,

(TUint)Setting_volume_pane_elements_Line_7,

(TUint)Setting_volume_pane_elements_Line_8,

(TUint)Setting_volume_pane_elements_Line_9,

(TUint)Setting_volume_pane_elements_Line_10,

(TUint)Setting_volume_pane_elements_Line_11,

0x010a,

(TUint)AknLayout::EApiId_Setting_volume_pane_elements_Line_1,

(TUint)Setting_slider_pane_elements_and_descendants_Line_1,

(TUint)Setting_slider_pane_elements_and_descendants_Line_2,

0x0001,

(TUint)AknLayout::EApiId_Setting_slider_pane_elements_and_descendants_Line_1,

(TUint)Slider_pane_elements_Line_1,

(TUint)Slider_pane_elements_Line_2,

0x0001,

(TUint)AknLayout::EApiId_Slider_pane_elements_Line_1,

(TUint)Slider_texts__set__Line_1, //0x4051

0x4058,	// Slider_texts__set__Line_2

0x0401,	// Multiline_Slider_texts__set__Line_2

(TUint)Setting_slider_pane__graphic__elements_and_descendants_Line_1,

(TUint)Setting_slider_pane__graphic__elements_and_descendants_Line_2,

(TUint)Setting_slider_pane__graphic__elements_and_descendants_Line_3,

0x0002,

(TUint)AknLayout::EApiId_Setting_slider_pane__graphic__elements_and_descendants_Line_1,

0x4076,	// Slider_with_graphic_texts__set__Line_1

0x0401,	// Multiline_Slider_with_graphic_texts__set__Line_1

0x4084,	// Setting_text_pane_elements_Line_1

0x408d,	// Setting_text_pane_elements_Line_2

(TUint)Setting_text_pane_elements_Line_3, //0x4094

0x409d,	// Setting_text_pane_elements_Line_4

0x0003,

(TUint)AknLayout::EApiId_Setting_text_pane_elements_Line_1,

(TUint)Setting_text_pane_texts_Line_1, //0x40a4

0x0001, //Multiline_Setting_text_pane_texts_Line_1

0x4084,	// Code_time_and_date_entry_pane_elements_Line_1

0x40b5,	// Code_time_and_date_entry_pane_elements_Line_2

0x40bc,	// Code_time_and_date_entry_pane_elements_Line_3

0x0002,

(TUint)AknLayout::EApiId_Code_time_and_date_entry_pane_elements_Line_1,

(TUint)Code_time_and_date_entry_pane_texts_Line_1,

(TUint)Control_pane_elements_Line_1, //0x40cc

(TUint)Control_pane_elements_Line_2, //0x40d3

(TUint)Control_pane_elements_Line_3,

(TUint)Control_pane_elements_Line_4,

0x0003,

(TUint)Control_pane_elements, //AknLayout::EApiId_Control_pane_elements_Line_1,

(TUint)Control_pane_texts_Line_1,

(TUint)Control_pane_texts_Line_2,

0x0001,

(TUint)AknLayout::EApiId_Control_pane_texts_Line_1,

(TUint)popup_menu_window,

(TUint)Pop_up_windows__main_pane_as_parent__Line_2,

(TUint)popup_menu_graphic_window,

(TUint)popup_menu_graphic_heading_window,

(TUint)popup_menu_double_window,

(TUint)popup_menu_double_large_graphic_window,

(TUint)popup_note_window,

(TUint)popup_note_wait_window,

(TUint)popup_note_image_window,

(TUint)popup_query_data_window,

(TUint)popup_query_code_window,

(TUint)popup_query_time_window,

(TUint)popup_query_date_window,

(TUint)popup_query_data_code_window,

(TUint)popup_find_window,

(TUint)popup_snote_single_text_window,

(TUint)popup_snote_single_graphic_window,

0x4198,	// popup_snote_group_window

(TUint)popup_grid_graphic_window,

(TUint)popup_menu_double2_window,

(TUint)popup_grid_large_graphic_colour_window,

(TUint)popup_fast_swap_window,

(TUint)list_single_popup_menu_pane,

(TUint)list_single_heading_popup_menu_pane,

(TUint)list_single_graphic_popup_menu_pane,

(TUint)list_single_graphic_heading_popup_menu_pane,

(TUint)list_menu_double_popup_menu_pane,

(TUint)list_single_popup_submenu_pane,

(TUint)list_double_large_graphic_popup_menu_pane,

(TUint)Pop_up_window_list_pane_descendants_Line_8,

(TUint)list_double2_popup_menu_pane,

(TUint)List_pane_elements__menu_single__Line_1, //0x4226

(TUint)List_pane_elements__menu_single__Line_2,

(TUint)List_pane_elements__menu_single__Line_3,

0x0001,

(TUint)AknLayout::EApiId_List_pane_elements__menu_single__Line_1,

(TUint)List_pane_texts__menu_single__Line_1,

0x425b,	// List_pane_text__submenu_single__Line_1

(TUint)List_pane_elements__menu_single_graphic__Line_1,

(TUint)List_pane_elements__menu_single_graphic__Line_2,

(TUint)List_pane_texts__menu_single_graphic__Line_1,

0x4280,	// List_pane_elements__menu_single_heading__Line_1

(TUint)List_pane_elements__menu_single_heading__Line_2,

(TUint)List_pane_texts__menu_single_heading__Line_1,

(TUint)List_pane_texts__menu_single_heading__Line_2,

(TUint)List_pane_elements__menu_single_graphic_heading__Line_1,

0x4280,	// List_pane_elements__menu_single_graphic_heading__Line_2

(TUint)List_pane_elements__menu_single_graphic_heading__Line_3,

(TUint)List_pane_texts__menu_single_graphic_heading__Line_1,

(TUint)List_pane_texts__menu_single_graphic_heading__Line_2,

0x0001,

(TUint)AknLayout::EApiId_List_pane_texts__menu_single_graphic_heading__Line_1,

(TUint)List_pane_elements__menu_double__Line_1,

(TUint)List_pane_texts__menu_double__Line_1,

(TUint)List_pane_texts__menu_double__Line_2,

(TUint)List_pane_elements__menu_double2__Line_1,

(TUint)List_pane_texts__menu_double2__Line_1,

(TUint)List_pane_texts__menu_double2__Line_2,

(TUint)List_pane_elements__menu_double_large_graphic__Line_1,

(TUint)List_pane_elements__menu_double_large_graphic__Line_2,

(TUint)List_pane_texts__menu_double_large_graphic__Line_1,

(TUint)List_pane_texts__menu_double_large_graphic__Line_2,

(TUint)Highlight_graphics__various__Line_1,

(TUint)Highlight_graphics__various__Line_2,

0x0001,

(TUint)AknLayout::EApiId_Highlight_graphics__various__Line_1,

(TUint)cell_graphic_popup_pane,

(TUint)Cell_pane_elements__pop_up_graphic__Line_1,

(TUint)Cell_pane_texts__pop_up_graphic__Line_1,

(TUint)cell_large_graphic_colour_popup_pane,

(TUint)colour,

(TUint)Pop_up_window_cell_pane__large_graphic_colour_none__Line_1,

(TUint)Cell_pane_texts__pop_up_large_graphic_colour_none__Line_1,

(TUint)Highlight_elements__grid_pop_up__Line_1,

(TUint)Highlight_elements__grid_pop_up__Line_2,

0x0001,

(TUint)AknLayout::EApiId_Highlight_elements__grid_pop_up__Line_1,

(TUint)List_heading_pane_elements_Line_1,

(TUint)List_heading_pane_elements_Line_2,

0x0001,

(TUint)AknLayout::EApiId_List_heading_pane_elements_Line_1,

(TUint)List_heading_pane_texts_Line_1,

(TUint)Pop_up_menu_with_heading_window_graphics_Line_1,

(TUint)Pop_up_menu_with_heading_window_graphics_Line_2,

(TUint)Pop_up_menu_with_heading_window_graphics_Line_3,

(TUint)Pop_up_menu_with_heading_window_graphics_Line_4,

(TUint)Pop_up_menu_with_heading_window_graphics_Line_5,

0x0004,

(TUint)AknLayout::EApiId_Pop_up_menu_with_heading_window_graphics_Line_1,

(TUint)list_menu_pane,

(TUint)Menu_pop_up_window_descendants_Line_2,

(TUint)Menu_pop_up_window_graphics_Line_1,

(TUint)Menu_pop_up_window_graphics_Line_2,

(TUint)Menu_pop_up_window_graphics_Line_3,

(TUint)Menu_pop_up_window_graphics_Line_4,

(TUint)Menu_pop_up_window_graphics_Line_5,

0x0004,

(TUint)AknLayout::EApiId_Menu_pop_up_window_graphics_Line_1,

(TUint)list_submenu_pane,

(TUint)Submenu_pop_up_window_graphics_Line_1,

(TUint)Submenu_pop_up_window_graphics_Line_2,

(TUint)Submenu_pop_up_window_graphics_Line_3,

(TUint)Submenu_pop_up_window_graphics_Line_4,

0x0003,

(TUint)AknLayout::EApiId_Submenu_pop_up_window_graphics_Line_1,

(TUint)Submenu_pop_up_window_positioning_Line_1,

(TUint)Submenu_pop_up_window_positioning_Line_2,

0x0001,

(TUint)AknLayout::EApiId_Submenu_pop_up_window_positioning_Line_1,

(TUint)list_menu_graphic_pane,

(TUint)list_menu_heading_pane,

(TUint)Menu_pop_up_window_descendants__single_heading__Line_2,

(TUint)Menu_pop_up_window_descendants__single_heading__Line_3,

(TUint)list_menu_graphic_heading_pane,

(TUint)Menu_pop_up_window_descendants_and_elements__single_graphic_heading__Line_2,

(TUint)Menu_pop_up_window_descendants_and_elements__single_graphic_heading__Line_3,

(TUint)list_menu_double_pane_list_menu_double2_pane,

(TUint)Menu_pop_up_window_descendants__double_double2__Line_2,

(TUint)list_menu_double_large_graphic_pane,

(TUint)Menu_pop_up_window_descendants__double__Line_2,

(TUint)Note_pop_up_window_elements_Line_1,

(TUint)Note_pop_up_window_texts_Line_1,

0x0401,	// Multiline_Note_pop_up_window_texts_Line_1

(TUint)Note_pop_up_window_graphics_Line_1,

(TUint)Note_pop_up_window_graphics_Line_2,

(TUint)Note_pop_up_window_graphics_Line_3,

(TUint)Note_pop_up_window_graphics_Line_4,

(TUint)Note_pop_up_window_graphics_Line_5,

0x0004,

(TUint)AknLayout::EApiId_Note_pop_up_window_graphics_Line_1,

(TUint)Wait_or_progress_note_pop_up_window_elements_Line_1,

(TUint)Wait_or_progress_note_pop_up_window_elements_Line_2,

(TUint)Wait_or_progress_note_pop_up_window_elements_Line_3,

(TUint)Wait_or_progress_note_pop_up_window_elements_Line_4,

0x0001,

(TUint)AknLayout::EApiId_First_general_event_elements_Line_1,

(TUint)Wait_or_progress_note_pop_up_window_texts_Line_1,

0x0202,	// Multiline_Wait_or_progress_note_pop_up_window_texts_Line_1

(TUint)Note_with_an_image_pop_up_window_elements_Line_1,

(TUint)Note_with_an_image_pop_up_window_elements_Line_2,

(TUint)Note_with_an_image_pop_up_window_elements_Line_3,

(TUint)Note_with_an_image_pop_up_window_elements_Line_4,

(TUint)Note_with_an_image_pop_up_window_elements_Line_5,

(TUint)Note_with_an_image_pop_up_window_elements_Line_6,

(TUint)Note_with_an_image_pop_up_window_elements_Line_7,

(TUint)Note_with_an_image_pop_up_window_elements_Line_8,

(TUint)Note_with_an_image_pop_up_window_elements_Line_9,

(TUint)Note_with_an_image_pop_up_window_elements_Line_10,

(TUint)Note_with_an_image_pop_up_window_elements_Line_11,

(TUint)Note_with_an_image_pop_up_window_elements_Line_12,

(TUint)Note_with_an_image_pop_up_window_elements_Line_13,

0x000c,

(TUint)AknLayout::EApiId_Note_with_an_image_pop_up_window_elements_Line_1,

(TUint)Note_with_an_image_pop_up_window_texts_Line_1,

0x0203,	// Multiline_Note_with_an_image_pop_up_window_texts_Line_1

(TUint)Query_with_heading_window_graphics_Line_1,

(TUint)Query_with_heading_window_graphics_Line_2,

(TUint)Query_with_heading_window_graphics_Line_3,

(TUint)Query_with_heading_window_graphics_Line_4,

(TUint)Query_with_heading_window_graphics_Line_5,

0x0004,

(TUint)AknLayout::EApiId_Query_with_heading_window_graphics_Line_1,

(TUint)popup_list_heading_pane,

(TUint)Heading_pane_elements_Line_1,

(TUint)Icon,

(TUint)Heading_pane_texts_Line_1,

(TUint)Data_query_pop_up_window_elements_Line_1,

(TUint)Data_query_pop_up_window_elements_Line_2,

(TUint)Data_query_pop_up_window_elements_Line_3,

(TUint)Data_query_pop_up_window_elements_Line_4,

(TUint)Data_query_pop_up_window_elements_Line_5,

(TUint)Data_query_pop_up_window_texts_Line_1,

0x0000,	// Multiline_Data_query_pop_up_window_texts_Line_1

(TUint)Data_query_pop_up_window_texts_Line_2,

0x0001,	// Multiline_Data_query_pop_up_window_texts_Line_2

(TUint)Data_query_pop_up_window_graphics_Line_1,

(TUint)Data_query_pop_up_window_graphics_Line_2,

(TUint)Data_query_pop_up_window_graphics_Line_3,

(TUint)Data_query_pop_up_window_graphics_Line_4,

(TUint)Data_query_pop_up_window_graphics_Line_5,

0x0004,

(TUint)AknLayout::EApiId_Data_query_pop_up_window_graphics_Line_1,

(TUint)Code_query_pop_up_window_elements_Line_1,

(TUint)Code_query_pop_up_window_elements_Line_2,

(TUint)Code_query_pop_up_window_elements_Line_3,

(TUint)Code_query_pop_up_window_elements_Line_4,

0x0003,

(TUint)AknLayout::EApiId_Code_query_pop_up_window_elements_Line_1,

(TUint)Code_query_pop_up_window_texts_Line_1,

0x0000,	// Multiline_Code_query_pop_up_window_texts_Line_1

(TUint)Code_query_pop_up_window_texts_Line_2,

0x0000,	// Multiline_Code_query_pop_up_window_texts_Line_2

0x0001,

(TUint)AknLayout::EApiId_Code_query_pop_up_window_texts_Line_1,

(TUint)Combined_data_and_code_query_pop_up_window_elements_Line_1,

(TUint)Combined_data_and_code_query_pop_up_window_elements_Line_2,

(TUint)Combined_data_and_code_query_pop_up_window_elements_Line_3,

(TUint)Combined_data_and_code_query_pop_up_window_elements_Line_4,

(TUint)Combined_data_and_code_query_pop_up_window_elements_Line_5,

(TUint)Combined_data_and_code_query_pop_up_window_texts_Line_1,

0x0000,	// Multiline_Combined_data_and_code_query_pop_up_window_texts_Line_1

(TUint)Combined_data_and_code_query_pop_up_window_texts_Line_2,

0x0000,	// Multiline_Combined_data_and_code_query_pop_up_window_texts_Line_2

(TUint)Combined_data_and_code_query_pop_up_window_texts_Line_3,

0x0000,	// Multiline_Combined_data_and_code_query_pop_up_window_texts_Line_3

(TUint)Combined_data_and_code_query_pop_up_window_texts_Line_4,

0x0000,	// Multiline_Combined_data_and_code_query_pop_up_window_texts_Line_4

0x0003,

(TUint)AknLayout::EApiId_Combined_data_and_code_query_pop_up_window_texts_Line_1,

(TUint)Combined_data_and_code_query_pop_up_window_graphics_Line_1,

(TUint)Combined_data_and_code_query_pop_up_window_graphics_Line_2,

(TUint)Combined_data_and_code_query_pop_up_window_graphics_Line_3,

(TUint)Combined_data_and_code_query_pop_up_window_graphics_Line_4,

(TUint)Combined_data_and_code_query_pop_up_window_graphics_Line_5,

0x0104,

(TUint)AknLayout::EApiId_Combined_data_and_code_query_pop_up_window_graphics_Line_1,

(TUint)Find_pop_up_window_elements_Line_1,

(TUint)Find_pop_up_window_elements_Line_2,

(TUint)Find_pop_up_window_elements_Line_3,

(TUint)Find_pop_up_window_elements_Line_4,

0x0003,

(TUint)AknLayout::EApiId_Find_pop_up_window_elements_Line_1,

(TUint)Find_pop_up_window_texts_Line_1,

(TUint)Find_pop_up_window_graphics_Line_1,

(TUint)Find_pop_up_window_graphics_Line_2,

(TUint)Find_pop_up_window_graphics_Line_3,

(TUint)Find_pop_up_window_graphics_Line_4,

(TUint)Find_pop_up_window_graphics_Line_5,

0x0004,

(TUint)AknLayout::EApiId_Find_pop_up_window_graphics_Line_1,

(TUint)Pop_up_menu_with_find_pane_graphics_Line_1,

(TUint)Pop_up_menu_with_find_pane_graphics_Line_2,

(TUint)Pop_up_menu_with_find_pane_graphics_Line_3,

(TUint)Pop_up_menu_with_find_pane_graphics_Line_4,

(TUint)Pop_up_menu_with_find_pane_graphics_Line_5,

0x0004,

(TUint)AknLayout::EApiId_Pop_up_menu_with_find_pane_graphics_Line_1,

(TUint)Notification_pop_up_window_elements__text__Line_1,

(TUint)Notification_pop_up_window_texts__text__Line_1,

0x0000,	// Multiline_Notification_pop_up_window_texts__text__Line_1

(TUint)Notification_pop_up_window_graphics__text__Line_1,

(TUint)Notification_pop_up_window_graphics__text__Line_2,

(TUint)Notification_pop_up_window_graphics__text__Line_3,

(TUint)Notification_pop_up_window_graphics__text__Line_4,

(TUint)Notification_pop_up_window_graphics__text__Line_5,

0x0004,

(TUint)AknLayout::EApiId_Notification_pop_up_window_graphics__text__Line_1,

(TUint)Notification_pop_up_window_elements__graphic__Line_1,

(TUint)Notification_pop_up_window_elements__graphic__Line_2,

0x0001,

(TUint)AknLayout::EApiId_Notification_pop_up_window_elements__graphic__Line_1,

(TUint)Notification_pop_up_window_texts__graphic__Line_1,

0x0401,	// Multiline_Notification_pop_up_window_texts__graphic__Line_1

(TUint)Identifier_icon_selection_pop_up_window_descendants_Line_1,

(TUint)grid_graphic_popup_pane,

(TUint)Identifier_icon_selection_pop_up_window_elements_Line_1,

(TUint)Identifier_icon_selection_pop_up_window_elements_Line_2,

(TUint)Identifier_icon_selection_pop_up_window_graphics_Line_1,

(TUint)Identifier_icon_selection_pop_up_window_graphics_Line_2,

(TUint)Identifier_icon_selection_pop_up_window_graphics_Line_3,

(TUint)Identifier_icon_selection_pop_up_window_graphics_Line_4,

(TUint)Identifier_icon_selection_pop_up_window_graphics_Line_5,

0x0104,

(TUint)AknLayout::EApiId_Identifier_icon_selection_pop_up_window_graphics_Line_1,

(TUint)Colour_selection_pop_up_window_descendants_Line_1,

(TUint)Colour_selection_pop_up_window_descendants_Line_2,

(TUint)grid_large_graphic_colour_popup_pane,

(TUint)Composer_symbol_selection_pop_up_window_elements_Line_1,

(TUint)Composer_symbol_selection_pop_up_window_elements_Line_2,

(TUint)Colour_selection_pop_up_window_graphics_Line_1,

(TUint)Colour_selection_pop_up_window_graphics_Line_2,

(TUint)Colour_selection_pop_up_window_graphics_Line_3,

(TUint)Colour_selection_pop_up_window_graphics_Line_4,

(TUint)Colour_selection_pop_up_window_graphics_Line_5,

0x0004,

(TUint)AknLayout::EApiId_Colour_selection_pop_up_window_graphics_Line_1,

(TUint)Fast_application_swapping_pop_up_window_descendants_Line_1,

(TUint)Fast_application_swapping_pop_up_window_graphics_Line_1,

(TUint)Fast_application_swapping_pop_up_window_graphics_Line_2,

(TUint)Fast_application_swapping_pop_up_window_graphics_Line_3,

(TUint)Fast_application_swapping_pop_up_window_graphics_Line_4,

(TUint)Fast_application_swapping_pop_up_window_graphics_Line_5,

(TUint)Fast_application_swapping_pop_up_window_graphics_Line_6,

0x0004,

(TUint)AknLayout::EApiId_Fast_application_swapping_pop_up_window_graphics_Line_1,

(TUint)List_pane_texts__setting__double2__Line_1,

(TUint)List_pane_texts__setting__double2__Line_2,

0x0001,

(TUint)AknLayout::EApiId_List_pane_texts__setting__double2__Line_1,

(TUint)List_pane_elements__single_2graphic__Line_1,

(TUint)List_pane_elements__single_2graphic__Line_2,

(TUint)List_pane_elements__single_2graphic__Line_3,

(TUint)List_pane_elements__single_2graphic__Line_4,

0x0002,

(TUint)AknLayout::EApiId_List_pane_elements__single_2graphic__Line_1,

(TUint)List_pane_texts__single_2graphic__Line_1,

(TUint)List_pane_elements__double2_graphic_large_graphic__Line_1,

(TUint)List_pane_elements__double2_graphic_large_graphic__Line_2,

(TUint)List_pane_elements__double2_graphic_large_graphic__Line_3,

(TUint)List_pane_elements__double2_graphic_large_graphic__Line_4,

0x0002,

(TUint)AknLayout::EApiId_List_pane_elements__double2_graphic_large_graphic__Line_1,

(TUint)List_pane_texts__double2_graphic_large_graphic__Line_1,

(TUint)List_pane_texts__double2_graphic_large_graphic__Line_2,

(TUint)Form_data_wide_graphic_field_texts_Line_1,

(TUint)Form_data_wide_graphic_field_texts_Line_2,

(TUint)Multiline_Form_data_wide_graphic_field_texts_Line_2,

(TUint)status_small_pane,

(TUint)Small_status_pane_descendants_and_elements_Line_1,

(TUint)status_small_icon_pane,

(TUint)status_small_wait_pane,

(TUint)Small_status_pane_descendants_and_elements_Line_4,

(TUint)Small_status_pane_descendants_and_elements_Line_5,

(TUint)Small_status_pane_descendants_and_elements_Line_6,

0x0005,

(TUint)AknLayout::EApiId_Small_status_pane_descendants_and_elements_Line_1,

(TUint)Small_status_pane_texts_Line_1,

(TUint)Small_status_waiting_pane_components_Line_1,

(TUint)Small_status_waiting_pane_components_Line_2,

(TUint)Small_status_waiting_pane_components_Line_3,

(TUint)Small_status_waiting_pane_components_Line_4,

0x0003,

(TUint)AknLayout::EApiId_Small_status_waiting_pane_components_Line_1,

(TUint)Note_with_additional_information_popup_window_elements_Line_1,

(TUint)Note_with_additional_information_popup_window_elements_Line_2,

(TUint)Note_with_additional_information_popup_window_elements_Line_3,

(TUint)Note_with_additional_information_popup_window_texts_Line_1,

0x0000, // Multiline_Note_with_additional_information_popup_window_texts_Line_1,

(TUint)Note_with_additional_information_popup_window_texts_Line_2,

0x0000, // Multiline_Note_with_additional_information_popup_window_texts_Line_2,

(TUint)Note_with_additional_information_popup_window_texts_Line_3,

0x0000, // Multiline_Note_with_additional_information_popup_window_texts_Line_3,

(TUint)Heading_pane_texts_Line_2,

(TUint)Side_volume_key_popup_window_elements_Line_1,

(TUint)Side_volume_key_popup_window_elements_Line_2,

(TUint)Side_volume_key_popup_window_texts_Line_1,

(TUint)Side_volume_key_popup_window_texts_Line_2,

(TUint)Side_volume_key_popup_window_background_Line_1,

(TUint)Side_volume_key_popup_window_background_Line_2,

(TUint)Side_volume_key_popup_window_background_Line_3,

(TUint)Side_volume_key_popup_window_background_Line_4,

(TUint)Transparent_setting_item_texts_Line_1,

(TUint)Transparent_setting_item_texts_Line_2,

(TUint)Transparent_setting_item_texts_Line_3,

(TUint)Transparent_setting_item_texts_Line_4,

(TUint)List_pane_texts__set_trans_graphic__Line_1,

(TUint)List_pane_texts__set_trans_graphic__Line_2,

(TUint)list_set_trans_pane,

(TUint)list_set_trans_graphic_pane,

(TUint)List_pane_elements__set_trans_graphic__Line_1,

(TUint)List_pane_elements__set_trans_graphic__Line_2,

(TUint)List_pane_elements__set_trans_graphic__Line_3,

(TUint)List_pane_elements__set_trans_graphic__Line_4,

(TUint)List_pane_elements__set_trans_graphic__Line_5,

(TUint)Soft_indicator_texts_Line_1,

(TUint)ai_links_pane,

(TUint)ai_gene_pane,

(TUint)Link_pane_elements_and_descendant_panes_Line_1,

(TUint)grid_ai_links_pane,

0x0001,

(TUint)AknLayout::EApiId_Link_pane_elements_and_descendant_panes_Line_1,

(TUint)cell_ai_link_pane,

(TUint)Link_shortcut_cell_pane_elements_Line_1,

(TUint)Link_shortcut_cell_pane_elements_Line_2,

(TUint)Link_shortcut_cell_pane_elements_Line_3,

(TUint)Link_shortcut_cell_pane_elements_Line_4,

0x0003,

(TUint)AknLayout::EApiId_Link_shortcut_cell_pane_elements_Line_1,

(TUint)popup_ai_links_title_window,

(TUint)Link_shortcut_title_texts_Line_1,

(TUint)Link_shortcut_title_pop_up_window_graphics_Line_1,

(TUint)Link_shortcut_title_pop_up_window_graphics_Line_2,

(TUint)Link_shortcut_title_pop_up_window_graphics_Line_3,

(TUint)Link_shortcut_title_pop_up_window_graphics_Line_4,

0x0003,

(TUint)AknLayout::EApiId_Link_shortcut_title_pop_up_window_graphics_Line_1,

(TUint)ai_gene_pane_1,

(TUint)ai_gene_pane_2,

(TUint)First_general_event_elements_Line_1,

(TUint)First_general_event_elements_Line_2,

(TUint)First_general_event_texts_Line_1,

(TUint)Second_general_event_pane_texts_Line_1,

(TUint)Shortcut_link_highlight_Line_1,

(TUint)Highlight_for_other_Active_Idle_items_Line_1,

(TUint)Find_pop_up_window_texts_Line_2,

0x0001,

(TUint16)AknLayout::EApiId_Find_pop_up_window_texts_Line_1,

(TUint)Find_pane_texts_Line_2,

0x0001,

(TUint16)AknLayout::EApiId_Find_pane_texts_Line_2,

(TUint)ai_gene_pane_3,

(TUint)Third_general_event_elements_Line_1,

(TUint)Third_general_event_elements_Line_2,

0x0001,

(TUint16)AknLayout::EApiId_Third_general_event_elements_Line_1,

(TUint)popup_ai_message_window,

(TUint)Active_idle_message_pop_up_window_descendants_Line_1,

(TUint)Active_idle_message_pop_up_window_descendants_Line_2,

(TUint)Active_idle_message_pop_up_window_descendants_Line_3,

0x0002,

(TUint16)AknLayout::EApiId_Active_idle_message_pop_up_window_descendants_Line_1,

(TUint)Active_idle_message_popup_window_texts_Line_1,

0x0101,	// Multiline_Active_idle_message_popup_window_texts_Line_1

(TUint)Active_idle_heading_pane_elements_Line_1,

(TUint)Active_idle_heading_pane_elements_Line_2,

(TUint)Active_idle_heading_pane_elements_Line_3,

(TUint)Active_idle_heading_pane_elements_Line_4,

0x0003,

(TUint16)AknLayout::EApiId_Active_idle_heading_pane_elements_Line_1,

(TUint)Active_idle_heading_pane_texts_Line_1,

(TUint)Active_idle_heading_pane_texts_Line_2,

(TUint)Active_idle_message_pop_up_window_graphics_Line_1,

(TUint)Active_idle_message_pop_up_window_graphics_Line_2,

(TUint)Active_idle_message_pop_up_window_graphics_Line_3,

(TUint)Active_idle_message_pop_up_window_graphics_Line_4,

(TUint)Active_idle_message_pop_up_window_graphics_Line_5,

0x0004,

(TUint16)AknLayout::EApiId_Active_idle_message_pop_up_window_graphics_Line_1,

};


#define IMPL_OK(x) &x

// NOT NEEDED means that skin elements or something else replaces the line so it's no longer needed
#define NOT_NEEDED(x) &x

#define NOT_SUPPORTED(x) &x
// NOT DONE means we have some work to do to get it working
#define NOT_DONE(x) &x
// CODE CHANGES REQUIRED means we've not enabled it because it breaks layouts
#define CODE_CHANGES_REQUIRED(x) &x

// all of forms seem to be a little unstable :)
#define FORMS_ENABLED(x) &x

#define LISTS_ENABLED(x) &x
#define FIND_ENABLED(x) &x
#define SETTING_PAGE_ENABLED(x) &x

// SETTING_PAGE_NOK() means that the line is NOT tested/probably does not work, but has been implemented in adaptation layer
#define SETTING_PAGE_NOK(x) &x
#define APPS_GRID_ENABLED(x) &x
#define IDLE_ENABLED(x) &x
#define IMPL_OK_POPUP_LISTS(x) &x
#define IMPL_OK_NOTES(x) &x
#define IMPL_OK_QUERIES(x) &x
#define NOT_IN_SPEC(x) &x
#define FAST_SWAP_WINDOW_NOT_OK(x) &x
#define IMPL_OK_AI(x) &x
#define TP_IN_PROGRESS(x) &x

const AknLayout::SCdlImpl KCdlImpl = 
	{
	IMPL_OK(screen),//	&WindowLine0f,
    IMPL_OK(application_window), //	&WindowLine0t,
    IMPL_OK(status_pane), //	&WindowLine1t,
    IMPL_OK(main_pane), //	&WindowLine3t,
    IMPL_OK(control_pane), //	&WindowLine0t,
    IMPL_OK(signal_pane), //	&WindowLine0t,
    IMPL_OK(context_pane), //	&WindowLine1t,
    IMPL_OK(title_pane), //	&WindowLine1f,
    IMPL_OK(battery_pane), //	&WindowLine0t,
    IMPL_OK(uni_indicator_pane), //	&WindowLine0t,
    IMPL_OK(navi_pane), //	&WindowLine1f,
    IMPL_OK(Status_pane_elements_Line_1), //	&WindowLine0f,
    IMPL_OK(Status_pane_elements_Line_2), //	&WindowLine0f,
    IMPL_OK(Limits), // &Status_pane_elements_Limits,
    IMPL_OK(WindowTable0f),	// &Status_pane_elements,
    IMPL_OK(Signal_pane_elements_Line_1), //	&WindowLine0f,
    IMPL_OK(Signal_pane_elements_Line_2), //	&WindowLine0f,
    IMPL_OK(Limits),	// &Signal_pane_elements_Limits,
    IMPL_OK(WindowTable0f),	// &Signal_pane_elements,
    NOT_NEEDED(Signal_strength_area_values_Line_1), //	&WindowLine0f,
    IMPL_OK(Signal_strength_area_values_Line_2), //	&WindowLine0f,
    IMPL_OK(Signal_strength_area_values_Line_3), //	&WindowLine0f,
    IMPL_OK(Signal_strength_area_values_Line_4), //	&WindowLine0f,
    IMPL_OK(Signal_strength_area_values_Line_5), //	&WindowLine0f,
    IMPL_OK(Signal_strength_area_values_Line_6), //	&WindowLine0f,
    IMPL_OK(Signal_strength_area_values_Line_7), //	&WindowLine0f,
    IMPL_OK(Signal_strength_area_values_Line_8), //	&WindowLine0f,
    IMPL_OK(Limits),	// &Signal_strength_area_values_Limits,
    IMPL_OK(WindowTable0f),	// &Signal_strength_area_values,
    IMPL_OK(Battery_pane_elements_Line_1),
    IMPL_OK(Battery_pane_elements_Line_2),
    IMPL_OK(Limits),	// &Battery_pane_elements_Limits,
    IMPL_OK(WindowTable0f),	// &Battery_pane_elements,
    IMPL_OK(Battery_strength_area_values_Line_1),
    IMPL_OK(Battery_strength_area_values_Line_2),
    IMPL_OK(Battery_strength_area_values_Line_3),
    IMPL_OK(Battery_strength_area_values_Line_4),
    IMPL_OK(Battery_strength_area_values_Line_5),
    IMPL_OK(Battery_strength_area_values_Line_6),
    IMPL_OK(Battery_strength_area_values_Line_7),
    IMPL_OK(Battery_strength_area_values_Line_8),
    IMPL_OK(Limits),	// &Battery_strength_area_values_Limits,
    IMPL_OK(WindowTable0f),	// &Battery_strength_area_values,
    IMPL_OK(Context_pane_elements_Line_1),
    IMPL_OK(Title_pane_texts_Line_1),
    IMPL_OK(Title_pane_texts_Line_2),
    IMPL_OK(MultiLineTextLine2f),	// &Multiline_Title_pane_texts_Line_2,
    IMPL_OK(Title_pane_elements_Line_1),
    IMPL_OK(Universal_indicator_pane_elements_Line_1),
    IMPL_OK(Navi_pane_arrow_elements_Line_1),	// &Navi_pane_arrow_elements_Line_1,
    IMPL_OK(Navi_pane_arrow_elements_Line_2),	// &Navi_pane_arrow_elements_Line_2,
    IMPL_OK(Navi_pane_tab_elements_Line_1),	// &Navi_pane_tab_elements_Line_1,
    IMPL_OK(Navi_pane_tab_elements_Line_1),	// &Navi_pane_tab_elements_Line_2,
    IMPL_OK(Navi_pane_tab_elements_Line_3),	// &Navi_pane_tab_elements_Line_3,
    IMPL_OK(Navi_pane_tab_elements_Line_3),	// &Navi_pane_tab_elements_Line_4,
    IMPL_OK(Navi_pane_tab_elements_Line_5),	// &Navi_pane_tab_elements_Line_5,
    IMPL_OK(Navi_pane_tab_elements_Line_5),	// &Navi_pane_tab_elements_Line_6,
    IMPL_OK(Navi_pane_tab_elements_Line_5),	// &Navi_pane_tab_elements_Line_7,
    IMPL_OK(Navi_pane_tab_elements_Line_8),	// &Navi_pane_tab_elements_Line_8,
    IMPL_OK(Navi_pane_tab_elements_Line_8),	// &Navi_pane_tab_elements_Line_9,
    IMPL_OK(Navi_pane_tab_elements_Line_8),	// &Navi_pane_tab_elements_Line_10,
    IMPL_OK(Navi_pane_tab_elements_Line_11),	// &Navi_pane_tab_elements_Line_11,
    IMPL_OK(Navi_pane_tab_elements_Line_11),	// &Navi_pane_tab_elements_Line_12,
    IMPL_OK(Navi_pane_tab_elements_Line_11),	// &Navi_pane_tab_elements_Line_13,
    IMPL_OK(Navi_pane_tab_elements_Line_11),	// &Navi_pane_tab_elements_Line_14,
    IMPL_OK(Limits),	// &Navi_pane_tab_elements_Limits,
    IMPL_OK(WindowTable0f),	// &Navi_pane_tab_elements,
    IMPL_OK(Elements_on_the_tabs_Line_1),
    IMPL_OK(Elements_on_the_tabs_Line_2),
    IMPL_OK(Elements_on_the_tabs_Line_3),
    IMPL_OK(Limits),	// &Elements_on_the_tabs_Limits,
    IMPL_OK(WindowTable1f),	// &Elements_on_the_tabs,
    IMPL_OK(Texts_on_the_tabs_Line_1),
    IMPL_OK(Texts_on_the_tabs_Line_2),
    IMPL_OK(Texts_on_the_tabs_Line_3),
    IMPL_OK(Texts_on_the_tabs_Line_4),
    IMPL_OK(Texts_on_the_tabs_Line_5),
    IMPL_OK(Limits),	// &Texts_on_the_tabs_Limits,
	IMPL_OK(TextTable1f),	// &Texts_on_the_tabs,
    IMPL_OK(Navi_pane_icons_Line_1),
	NOT_NEEDED(Navi_pane_icons_Line_2),
    IMPL_OK(Navi_pane_texts_Line_1),
	IMPL_OK(Navi_pane_texts_Line_2),
	IMPL_OK(Navi_pane_texts_Line_3),
    IMPL_OK(Navi_pane_texts_Line_4),
	NOT_NEEDED(Navi_pane_texts_Line_5),
	NOT_NEEDED(Navi_pane_texts_Line_6),
    IMPL_OK(Navi_pane_texts_Line_7),
	IMPL_OK(Navi_pane_area_for_editing_status_icons_Line_1),
    IMPL_OK(Volume_glider_elements__one__Line_1),
    IMPL_OK(volume_navi_pane),
	IMPL_OK(Limits),	// &Volume_glider_elements__one__Limits,
	IMPL_OK(WindowTable1f),	// &Volume_glider_elements__one_,
    CODE_CHANGES_REQUIRED(Volume_pane_elements__one__Line_1),
    CODE_CHANGES_REQUIRED(Volume_pane_elements__one__Line_2),
    CODE_CHANGES_REQUIRED(Volume_pane_elements__one__Line_3),
    CODE_CHANGES_REQUIRED(Volume_pane_elements__one__Line_4),
    CODE_CHANGES_REQUIRED(Volume_pane_elements__one__Line_5),
    CODE_CHANGES_REQUIRED(Volume_pane_elements__one__Line_6),
    CODE_CHANGES_REQUIRED(Volume_pane_elements__one__Line_7),
    CODE_CHANGES_REQUIRED(Volume_pane_elements__one__Line_8),
    CODE_CHANGES_REQUIRED(Volume_pane_elements__one__Line_9),
    CODE_CHANGES_REQUIRED(Volume_pane_elements__one__Line_10),
	CODE_CHANGES_REQUIRED(Limits),	// &Volume_pane_elements__one__Limits,
	CODE_CHANGES_REQUIRED(WindowTable1f),	// &Volume_pane_elements__one_,
    IMPL_OK(list_gen_pane),
    IMPL_OK(find_pane),
    IMPL_OK(wallpaper_pane),
    IMPL_OK(indicator_pane),
    IMPL_OK(soft_indicator_pane),
	IMPL_OK(A_column),
	NOT_DONE(WindowLine0f),	// &B_column,
	IMPL_OK(C_column),
	NOT_DONE(WindowLine0f),	// &D_column,
	NOT_DONE(Limits),	// &List_pane_column_division_Limits,
	NOT_DONE(WindowTable0f),	// &List_pane_column_division,
    LISTS_ENABLED(list_single_pane),	// &list_single_pane,
    LISTS_ENABLED(list_single_number_pane),
    LISTS_ENABLED(list_single_heading_pane),
    LISTS_ENABLED(list_single_graphic_pane),
    LISTS_ENABLED(list_single_graphic_heading_pane),
    LISTS_ENABLED(list_single_number_heading_pane),
    LISTS_ENABLED(list_single_large_graphic_pane),
    LISTS_ENABLED(list_double_pane),
    LISTS_ENABLED(list_double2_pane),
    LISTS_ENABLED(list_double_number_pane_list_single_big_number_pane),
    LISTS_ENABLED(list_double_time_pane),
    LISTS_ENABLED(list_double_large_graphic_pane_list_double2_large_graphic_pane_list_single_big_large_graphic_pane),
    LISTS_ENABLED(list_double_graphic_pane_list_double2_graphic_pane),
	LISTS_ENABLED(list_single_big_heading_graphic_pane),
	LISTS_ENABLED(list_single_big_heading_pane),
    LISTS_ENABLED(list_setting_pane_list_big_setting_pane),
    LISTS_ENABLED(list_setting_number_pane_list_big_setting_number_pane),
	LISTS_ENABLED(list_setting_double2_pane),
    LISTS_ENABLED(list_double2_graphic_pane),
    LISTS_ENABLED(list_double2_large_graphic_pane),
    LISTS_ENABLED(list_single_2graphic_pane),
    LISTS_ENABLED(list_double2_graphic_large_graphic_pane),
    LISTS_ENABLED(Limits),	// &General_list_pane_descendants_Limits,
    LISTS_ENABLED(WindowTable1f),	// &General_list_pane_descendants,
    LISTS_ENABLED(List_pane_elements__single__Line_1),
    LISTS_ENABLED(List_pane_elements__single__Line_2),
    LISTS_ENABLED(List_pane_texts__single__Line_1),
    LISTS_ENABLED(List_pane_elements__single_number__Line_1),
    LISTS_ENABLED(List_pane_elements__single_number__Line_2),
    LISTS_ENABLED(List_pane_texts__single_number__Line_1),
    LISTS_ENABLED(List_pane_texts__single_number__Line_2),
    LISTS_ENABLED(List_pane_elements__single_heading__Line_1),
	NOT_DONE(List_pane_elements__single_heading__Line_2),
    LISTS_ENABLED(List_pane_elements__single_heading__Line_3),
    LISTS_ENABLED(Limits),	// &List_pane_elements__single_heading__SUB_TABLE_0_Limits,
    LISTS_ENABLED(WindowTable0f),	// &List_pane_elements__single_heading__SUB_TABLE_0,
    LISTS_ENABLED(List_pane_texts__single_heading__Line_1),
    LISTS_ENABLED(List_pane_texts__single_heading__Line_2),
    LISTS_ENABLED(Limits),	// &List_pane_texts__single_heading__Limits,
    LISTS_ENABLED(TextTable1f),	// &List_pane_texts__single_heading_,
    LISTS_ENABLED(List_pane_elements__single_graphic__Line_1),
    LISTS_ENABLED(List_pane_elements__single_graphic__Line_2),
    LISTS_ENABLED(List_pane_elements__single_graphic__Line_3),
    LISTS_ENABLED(Limits),	// &List_pane_elements__single_graphic__SUB_TABLE_0_Limits,
    LISTS_ENABLED(WindowTable0f),	// &List_pane_elements__single_graphic__SUB_TABLE_0,
    LISTS_ENABLED(List_pane_texts__single_graphic__Line_1),
    LISTS_ENABLED(List_pane_elements__single_graphic_heading__Line_1),
    LISTS_ENABLED(List_pane_elements__single_graphic_heading__Line_2),
	NOT_IN_SPEC(List_pane_elements__single_graphic_heading__Line_3),
    LISTS_ENABLED(List_pane_elements__single_graphic_heading__Line_4),
    LISTS_ENABLED(Limits),	// &List_pane_elements__single_graphic_heading__SUB_TABLE_0_Limits,
    LISTS_ENABLED(WindowTable0f),	// &List_pane_elements__single_graphic_heading__SUB_TABLE_0,
    LISTS_ENABLED(List_pane_texts__single_graphic_heading__Line_1),
    LISTS_ENABLED(List_pane_texts__single_graphic_heading__Line_2),
    LISTS_ENABLED(Limits),	// &List_pane_texts__single_graphic_heading__Limits,
    LISTS_ENABLED(TextTable1f),	// &List_pane_texts__single_graphic_heading_,
    LISTS_ENABLED(List_pane_elements__single_number_heading__Line_1),
	NOT_IN_SPEC(List_pane_elements__single_number_heading__Line_2),
    LISTS_ENABLED(List_pane_elements__single_number_heading__Line_3),
    LISTS_ENABLED(Limits),	// &List_pane_elements__single_number_heading__SUB_TABLE_0_Limits,
    LISTS_ENABLED(WindowTable0f),	// &List_pane_elements__single_number_heading__SUB_TABLE_0,
    LISTS_ENABLED(List_pane_texts__single_number_heading__Line_1),
    LISTS_ENABLED(List_pane_texts__single_number_heading__Line_2),
    LISTS_ENABLED(List_pane_texts__single_number_heading__Line_3),
    LISTS_ENABLED(Limits),	// &List_pane_texts__single_number_heading__Limits,
    LISTS_ENABLED(TextTable1f),	// &List_pane_texts__single_number_heading_,
    LISTS_ENABLED(List_pane_elements__single_large_graphic__Line_1),
    LISTS_ENABLED(List_pane_elements__single_large_graphic__Line_2),
    LISTS_ENABLED(List_pane_elements__single_large_graphic__Line_3),
    NOT_IN_SPEC(do_not_use_empty_pane1),	// &List_pane_elements__single_large_graphic__SUB_TABLE_0_Limits,
    NOT_IN_SPEC(do_not_use_empty_pane2),	// &List_pane_elements__single_large_graphic__SUB_TABLE_0,
    LISTS_ENABLED(List_pane_texts__single_large_graphic__Line_1),
    LISTS_ENABLED(List_pane_elements__double__Line_1),
    LISTS_ENABLED(List_pane_elements__double__Line_2),
    LISTS_ENABLED(List_pane_texts__double__Line_1),
    LISTS_ENABLED(List_pane_texts__double__Line_2),
    LISTS_ENABLED(List_pane_text__double2__Line_1),
    LISTS_ENABLED(List_pane_text__double2__Line_2),
    LISTS_ENABLED(List_pane_elements__double_number__Line_1),
    LISTS_ENABLED(List_pane_elements__double_number__Line_2),
    LISTS_ENABLED(List_pane_texts__double_number__Line_1),
    LISTS_ENABLED(List_pane_texts__double_number__Line_2),
    LISTS_ENABLED(List_pane_texts__double_number__Line_3),
    LISTS_ENABLED(List_pane_elements__double_graphic__Line_1),
    LISTS_ENABLED(List_pane_elements__double_graphic__Line_2),
    LISTS_ENABLED(List_pane_elements__double_graphic__Line_3),
    LISTS_ENABLED(Limits),	// &List_pane_elements__double_graphic__SUB_TABLE_0_Limits,
    LISTS_ENABLED(WindowTable0f),	// &List_pane_elements__double_graphic__SUB_TABLE_0,
    LISTS_ENABLED(List_pane_texts__double_graphic__Line_1),
    LISTS_ENABLED(List_pane_texts__double_graphic__Line_2),
    LISTS_ENABLED(List_pane_elements__double2_graphic__Line_1),
    LISTS_ENABLED(List_pane_elements__double2_graphic__Line_2),
    LISTS_ENABLED(List_pane_elements__double2_graphic__Line_3),
    LISTS_ENABLED(Limits),	// &List_pane_elements__double2_graphic__SUB_TABLE_0_Limits,
    LISTS_ENABLED(WindowTable0f),	// &List_pane_elements__double2_graphic__SUB_TABLE_0,
    LISTS_ENABLED(List_pane_texts__double2_graphic__Line_1),
    LISTS_ENABLED(List_pane_texts__double2_graphic__Line_2),
    LISTS_ENABLED(List_pane_elements__double2_large_graphic__Line_1),
    LISTS_ENABLED(List_pane_elements__double2_large_graphic__Line_2),
    LISTS_ENABLED(List_pane_elements__double2_large_graphic__Line_3),
    LISTS_ENABLED(Limits),	// &List_pane_elements__double2_large_graphic__SUB_TABLE_0_Limits,
    LISTS_ENABLED(WindowTable0f),	// &List_pane_elements__double2_large_graphic__SUB_TABLE_0,
    LISTS_ENABLED(List_pane_texts__double2_large_graphic__Line_1),
    LISTS_ENABLED(List_pane_texts__double2_large_graphic__Line_2),
	NOT_NEEDED(List_pane_elements__large_single_heading_graphic__Line_1),
	NOT_NEEDED(List_pane_elements__large_single_heading_graphic__Line_2),
	NOT_NEEDED(List_pane_elements__large_single_heading_graphic__Line_3),
	NOT_NEEDED(Limits),	// &List_pane_elements__large_single_heading_graphic__SUB_TABLE_0_Limits,
	NOT_NEEDED(WindowTable0f),	// &List_pane_elements__large_single_heading_graphic__SUB_TABLE_0,
	LISTS_ENABLED(List_pane_texts__large_single_heading_graphic__Line_1),
	LISTS_ENABLED(List_pane_texts__large_single_heading_graphic__Line_2),
	NOT_NEEDED(List_pane_elements__large_single_heading__Line_1),
	LISTS_ENABLED(List_pane_texts__large_single_heading__Line_1),
	LISTS_ENABLED(List_pane_texts__large_single_heading__Line_2),
	NOT_NEEDED(Limits),	// &List_pane_texts__large_single_heading__Limits,
	NOT_NEEDED(TextTable0f),	// &List_pane_texts__large_single_heading_,
    LISTS_ENABLED(List_pane_elements__double_time__Line_1),
    LISTS_ENABLED(List_pane_texts__double_time__Line_1),
    LISTS_ENABLED(List_pane_texts__double_time__Line_2),
    LISTS_ENABLED(List_pane_texts__double_time__Line_3),
    LISTS_ENABLED(List_pane_texts__double_time__Line_4),
    LISTS_ENABLED(Limits),	// &List_pane_texts__double_time__Limits,
    LISTS_ENABLED(TextTable0f),	// &List_pane_texts__double_time_,
    LISTS_ENABLED(List_pane_elements__double_large_graphic__Line_1),	
    LISTS_ENABLED(List_pane_elements__double_large_graphic__Line_2),	
    LISTS_ENABLED(List_pane_elements__double_large_graphic__Line_3),	
    LISTS_ENABLED(List_pane_elements__double_large_graphic__Line_4),	
    LISTS_ENABLED(List_pane_elements__double_large_graphic__Line_5),
    LISTS_ENABLED(List_pane_elements__double_large_graphic__Line_6),
    LISTS_ENABLED(List_pane_elements__double_large_graphic__Line_7),
    LISTS_ENABLED(List_pane_elements__double_large_graphic__Line_8),
    LISTS_ENABLED(List_pane_elements__double_large_graphic__Line_9),
	NOT_IN_SPEC(List_pane_elements__double_large_graphic__Line_10),
    LISTS_ENABLED(List_pane_texts__double_large_graphic__Line_1),
    LISTS_ENABLED(List_pane_texts__double_large_graphic__Line_2),
    LISTS_ENABLED(List_pane_elements__setting__Line_1),
	NOT_IN_SPEC(List_pane_elements__setting__Line_2),
    LISTS_ENABLED(List_pane_elements__setting__Line_3),
    LISTS_ENABLED(List_pane_elements__setting__Line_4),
    LISTS_ENABLED(List_pane_elements__setting__Line_5),
    LISTS_ENABLED(List_pane_elements__setting__Line_6),
    LISTS_ENABLED(Limits),	// &List_pane_elements__setting__Limits,
    LISTS_ENABLED(WindowTable0f),	// &List_pane_elements__setting_,
    LISTS_ENABLED(List_pane_texts__setting__Line_1),
    LISTS_ENABLED(List_pane_texts__setting__Line_2),
    LISTS_ENABLED(List_pane_texts__setting__Line_3),
	NOT_IN_SPEC(List_pane_texts__setting__Line_4),
    LISTS_ENABLED(Limits),	// &List_pane_texts__setting__Limits,
    LISTS_ENABLED(TextTable0f),	// &List_pane_texts__setting_,
    LISTS_ENABLED(List_pane_elements__setting_number__Line_1),
	NOT_IN_SPEC(List_pane_elements__setting_number__Line_2),
    LISTS_ENABLED(List_pane_elements__setting_number__Line_3),
    LISTS_ENABLED(List_pane_elements__setting_number__Line_4),
    LISTS_ENABLED(List_pane_elements__setting_number__Line_5),
    LISTS_ENABLED(Limits),	// &List_pane_elements__setting_number__Limits,
    LISTS_ENABLED(WindowTable0f),	// &List_pane_elements__setting_number_,
    LISTS_ENABLED(List_pane_texts__setting_number__Line_1),
    LISTS_ENABLED(List_pane_texts__setting_number__Line_2),
    LISTS_ENABLED(List_pane_texts__setting_number__Line_3),
    LISTS_ENABLED(List_pane_texts__setting_number__Line_4),
    LISTS_ENABLED(Limits),	// &List_pane_texts__setting_number__Limits,
    LISTS_ENABLED(TextTable0f),	// &List_pane_texts__setting_number_,
	IMPL_OK(Setting_volume_elements_Line_1),
	IMPL_OK(Setting_volume_elements_Line_2),
	IMPL_OK(Setting_volume_elements_Line_3),
	IMPL_OK(Setting_volume_elements_Line_4),
	IMPL_OK(Setting_volume_elements_Line_5),
	IMPL_OK(Setting_volume_elements_Line_6),
	IMPL_OK(Setting_volume_elements_Line_7),
	IMPL_OK(Setting_volume_elements_Line_8),
	IMPL_OK(Setting_volume_elements_Line_9),
	IMPL_OK(Setting_volume_elements_Line_10),
	NOT_DONE(Limits),	// &Setting_volume_elements_Limits,
	NOT_DONE(WindowTable1f), // Setting_volume_elements
	LISTS_ENABLED(Setting_slider_elements_Line_1),
	LISTS_ENABLED(List_pane_elements__setting_double2__Line_1),
	NOT_IN_SPEC(List_pane_elements__setting_double2__Line_2),
	LISTS_ENABLED(List_pane_elements__setting_double2__Line_3),
	NOT_IN_SPEC(Limits),	// &List_pane_elements__setting_double2__Limits,
	NOT_IN_SPEC(WindowTable0f),	// &List_pane_elements__setting_double2_,
	IMPL_OK(List_pane_lines__A_column__Line_1),
	IMPL_OK(List_pane_lines__A_column__Line_2),
	IMPL_OK(List_pane_lines__AB_columns__Line_1),
	IMPL_OK(List_pane_lines__AB_columns__Line_2),
	IMPL_OK(List_pane_lines__BC_columns__Line_1),
	IMPL_OK(List_pane_lines__BC_columns__Line_2),
	NOT_NEEDED(List_pane_highlight_graphics__various__Line_1),
	IMPL_OK(List_pane_highlight_graphics__various__Line_2),
	NOT_NEEDED(List_pane_highlight_graphics__various__Line_3),
	NOT_DONE(Limits),	// &List_pane_highlight_graphics__various__SUB_TABLE_0_Limits,
	NOT_DONE(WindowTable0t),	// &List_pane_highlight_graphics__various__SUB_TABLE_0,
	NOT_NEEDED(List_pane_highlight_graphics__setting_number__Line_1),
	NOT_NEEDED(List_pane_highlight_graphics__setting_number__Line_2),
	NOT_NEEDED(List_pane_highlight_graphics__setting_number__Line_3),
	NOT_DONE(Limits),	// &List_pane_highlight_graphics__setting_number__SUB_TABLE_0_Limits,
	NOT_DONE(WindowTable0t),	// &List_pane_highlight_graphics__setting_number__SUB_TABLE_0,
	NOT_NEEDED(Find_pane_elements_Line_1),
	NOT_NEEDED(Find_pane_elements_Line_2),
	NOT_NEEDED(Find_pane_elements_Line_3),
	FIND_ENABLED(Find_pane_elements_Line_4),
	FIND_ENABLED(Find_pane_elements_Line_5),
	NOT_NEEDED(Limits),	// &Find_pane_elements_Limits,
	NOT_NEEDED(WindowTable0f),	// &Find_pane_elements,
	FIND_ENABLED(Find_pane_texts_Line_1),
	FORMS_ENABLED(form_field_data_pane),
	FORMS_ENABLED(form_field_data_wide_pane),
	FORMS_ENABLED(form_field_popup_pane),
	FORMS_ENABLED(form_field_popup_wide_pane),
	FORMS_ENABLED(form_field_slider_pane),
	FORMS_ENABLED(form_field_slider_wide_pane),
	FORMS_ENABLED(Limits),	// &Form_descendant_panes_Limits,
	FORMS_ENABLED(WindowTable2f),	// &Form_descendant_panes,
	NOT_NEEDED(Form_data_field_elements_Line_1),
	NOT_NEEDED(Form_data_field_elements_Line_2),
	NOT_NEEDED(Form_data_field_elements_Line_3),
	IMPL_OK(Form_data_field_elements_Line_4),
	FORMS_ENABLED(Form_data_field_texts_Line_1),
	FORMS_ENABLED(MultiLineTextLine2f),	// &Multiline_Form_data_field_texts_Line_1,
	FORMS_ENABLED(Form_data_field_texts_Line_2),
	FORMS_ENABLED(Multiline_Form_data_field_texts_Line_2),
	NOT_NEEDED(Form_data_wide_field_elements_Line_1),
	NOT_NEEDED(Form_data_wide_field_elements_Line_2),
	NOT_NEEDED(Form_data_wide_field_elements_Line_3),
	IMPL_OK(Form_data_wide_field_elements_Line_4),
	FORMS_ENABLED(Form_data_wide_field_texts_Line_1),
	FORMS_ENABLED(Form_data_wide_field_texts_Line_2),
	FORMS_ENABLED(Multiline_Form_data_wide_field_texts_Line_2),
	NOT_NEEDED(Form_pop_up_field_elements_and_descendants_Line_1),
	NOT_NEEDED(Form_pop_up_field_elements_and_descendants_Line_2),
	NOT_NEEDED(Form_pop_up_field_elements_and_descendants_Line_3),
	NOT_NEEDED(Form_pop_up_field_elements_and_descendants_Line_4),
	NOT_NEEDED(Form_pop_up_field_elements_and_descendants_Line_5),
	FORMS_ENABLED(list_form_pane),
	FORMS_ENABLED(list_form_graphic_pane),
	FORMS_ENABLED(List_pane_elements__form_graphic__Line_1),
	FORMS_ENABLED(List_pane_elements__form_graphic__Line_2),
	FORMS_ENABLED(List_pane_texts__form_graphic__Line_1),
	NOT_NEEDED(Form_pop_up_wide_field_elements_and_descendants_Line_1),
	NOT_NEEDED(Form_pop_up_wide_field_elements_and_descendants_Line_2),
	NOT_NEEDED(Form_pop_up_wide_field_elements_and_descendants_Line_3),
	NOT_NEEDED(Form_pop_up_wide_field_elements_and_descendants_Line_4),
	NOT_NEEDED(Form_pop_up_wide_field_elements_and_descendants_Line_5),
	FORMS_ENABLED(list_form_wide_pane),
	FORMS_ENABLED(list_form_graphic_wide_pane),
	FORMS_ENABLED(List_pane_elements__form_graphic_wide__Line_1),
	FORMS_ENABLED(List_pane_elements__form_graphic_wide__Line_2),
	FORMS_ENABLED(List_pane_texts__form_graphic_wide__Line_1),
	NOT_NEEDED(Form_slider_field_elements_and_descendants_Line_1),
	NOT_NEEDED(Form_slider_field_elements_and_descendants_Line_2),
	NOT_NEEDED(Form_slider_field_elements_and_descendants_Line_3),
	NOT_NEEDED(Form_slider_field_elements_and_descendants_Line_4),
	NOT_NEEDED(Form_slider_field_elements_and_descendants_Line_5),
	FORMS_ENABLED(Form_slider_field_elements_and_descendants_Line_6),
	FORMS_ENABLED(Slider_pane_elements__form__Line_1),
	FORMS_ENABLED(Slider_pane_elements__form__Line_2),
	FORMS_ENABLED(Limits),	// &Slider_pane_elements__form__Limits,
	FORMS_ENABLED(WindowTable0f),	// &Slider_pane_elements__form_,
	FORMS_ENABLED(Form_slider_field_texts_Line_1),
	FORMS_ENABLED(Form_slider_field_texts_Line_2),
	FORMS_ENABLED(Form_slider_field_texts_Line_3),
	FORMS_ENABLED(MultiLineTextLine2f),	// &Multiline_Form_slider_field_texts_Line_3,
	FORMS_ENABLED(Limits),	// &Form_slider_field_texts_SUB_TABLE_0_Limits,
	FORMS_ENABLED(TextTable0f),	// &Form_slider_field_texts_SUB_TABLE_0,
	NOT_NEEDED(Form_slider_field_elements_and_descendants_dup_Line_1),
	NOT_NEEDED(Form_slider_field_elements_and_descendants_dup_Line_2),
	NOT_NEEDED(Form_slider_field_elements_and_descendants_dup_Line_3),
	NOT_NEEDED(Form_slider_field_elements_and_descendants_dup_Line_4),
	NOT_NEEDED(Form_slider_field_elements_and_descendants_dup_Line_5),
	FORMS_ENABLED(Form_slider_field_elements_and_descendants_dup_Line_6),
	FORMS_ENABLED(Slider_pane_elements__form__dup_Line_1),
	FORMS_ENABLED(Slider_pane_elements__form__dup_Line_2),
	FORMS_ENABLED(Limits),	// &Slider_pane_elements__form__dup_Limits,
	FORMS_ENABLED(WindowTable0f),	// &Slider_pane_elements__form__dup,
	FORMS_ENABLED(Form_slider_field_texts_dup_Line_1),
	FORMS_ENABLED(Form_slider_field_texts_dup_Line_2),
	FORMS_ENABLED(Form_slider_field_texts_dup_Line_3),
	FORMS_ENABLED(MultiLineTextLine2f),	// &Multiline_Form_slider_field_texts_dup_Line_3,
	FORMS_ENABLED(Limits),	// &Form_slider_field_texts_dup_SUB_TABLE_0_Limits,
	FORMS_ENABLED(TextTable0f),	// &Form_slider_field_texts_dup_SUB_TABLE_0,
	NOT_NEEDED(Cursor_graphics__13__Line_1),
	NOT_NEEDED(Predictive_text_input_graphics__13__Line_1),
	NOT_NEEDED(Predictive_text_input_graphics__13__Line_2),
	NOT_NEEDED(Limits),	// &Predictive_text_input_graphics__13__Limits,
	NOT_NEEDED(WindowTable0f),	// &Predictive_text_input_graphics__13_,
	NOT_NEEDED(Cut_copy_and_paste_highlight_graphics__13__Line_1),
	NOT_NEEDED(Time_and_date_entry_graphics__13__Line_1),
	NOT_NEEDED(Cursor_graphics__12__Line_1),
	NOT_NEEDED(Predictive_text_input_graphics__12__Line_1),
	NOT_NEEDED(Predictive_text_input_graphics__12__Line_2),
	NOT_NEEDED(Limits),	// &Predictive_text_input_graphics__12__Limits,
	NOT_NEEDED(WindowTable0f),	// &Predictive_text_input_graphics__12_,
	NOT_NEEDED(Cut_copy_and_paste_highlight_graphics__12__Line_1),
	NOT_NEEDED(Time_and_date_entry_graphics__12__Line_1),
	SETTING_PAGE_ENABLED(list_set_graphic_pane),             
	SETTING_PAGE_ENABLED(List_pane_elements__set_graphic__Line_1),
	SETTING_PAGE_ENABLED(List_pane_elements__set_graphic__Line_2),
	SETTING_PAGE_ENABLED(List_pane_elements__set_graphic__Line_3),
	SETTING_PAGE_ENABLED(Limits),	// &List_pane_elements__set_graphic__SUB_TABLE_0_Limits,
	SETTING_PAGE_ENABLED(WindowTable0f),	// &List_pane_elements__set_graphic__SUB_TABLE_0,
	SETTING_PAGE_ENABLED(List_pane_texts__set_graphic__Line_1),
	APPS_GRID_ENABLED(Application_grid_descendant_Line_1),
	APPS_GRID_ENABLED(Cell_pane_elements__app__Line_1),
	APPS_GRID_ENABLED(Cell_pane_elements__app__Line_2),
	APPS_GRID_ENABLED(Limits),	// &Cell_pane_elements__app__Limits,
	APPS_GRID_ENABLED(WindowTable0f),	// &Cell_pane_elements__app_,
	APPS_GRID_ENABLED(Cell_pane_texts__app__Line_1),
	APPS_GRID_ENABLED(Cell_pane_highlight_elements__various__Line_1),
    IDLE_ENABLED(Wallpaper_pane_element_Line_1),
	IDLE_ENABLED(Indicator_pane_elements_Line_1),
	NOT_IN_SPEC(Soft_indicator_pane_elements_Line_1),
	IDLE_ENABLED(Soft_indicator_pane_texts_Line_1),
	IDLE_ENABLED(MultiLineTextLine1f),	// &Multiline_Soft_indicator_pane_texts_Line_1,
	IDLE_ENABLED(power_save_pane),
	IDLE_ENABLED(Power_save_pane_descendants_Line_1),
	IDLE_ENABLED(Power_save_pane_descendants_Line_2),
	CODE_CHANGES_REQUIRED(Power_save_pane_descendants_Line_3),  // Fix to screensaver application required
	IDLE_ENABLED(Limits),	// &Power_save_pane_descendants_Limits,
	IDLE_ENABLED(WindowTable0f),	// &Power_save_pane_descendants,
	NOT_DONE(Idle_power_save_state_texts_Line_1),
	IDLE_ENABLED(Idle_power_save_state_texts_Line_2),
	IDLE_ENABLED(Idle_power_save_state_texts_Line_3),
	NOT_DONE(Idle_power_save_state_texts_Line_4),
	IDLE_ENABLED(Limits),	// &Idle_power_save_state_texts_Limits,
	IDLE_ENABLED(TextTable0f),	// &Idle_power_save_state_texts,
	APPS_GRID_ENABLED(grid_app_pane),
	LISTS_ENABLED(Empty_list_texts_Line_1),
	LISTS_ENABLED(MultiLineTextLine1f),	// &Multiline_Empty_list_texts_Line_1,
	LISTS_ENABLED(Empty_list_texts__find__Line_1),
	LISTS_ENABLED(MultiLineTextLine1f),	// &Multiline_Empty_list_texts__find__Line_1,
	NOT_DONE(List_pane_elements_and_descendants__settings_edited__Line_1),
	LISTS_ENABLED(List_pane_elements_and_descendants__settings_edited__Line_2),
	LISTS_ENABLED(list_set_pane),
    NOT_IN_SPEC(List_pane_elements_and_descendants__settings_edited__Line_4),
	NOT_DONE(setting_volume_pane),
	NOT_DONE(setting_slider_pane),
	NOT_DONE(setting_slider_graphic_pane),
	NOT_DONE(setting_text_pane),
	NOT_DONE(setting_code_pane),
	SETTING_PAGE_ENABLED(Setting_item_texts_Line_1),
	SETTING_PAGE_ENABLED(Setting_item_texts_Line_2),
	NOT_DONE(Setting_volume_pane_elements_Line_1),
    CODE_CHANGES_REQUIRED(Setting_volume_pane_elements_Line_2),
	CODE_CHANGES_REQUIRED(Setting_volume_pane_elements_Line_3),
	CODE_CHANGES_REQUIRED(Setting_volume_pane_elements_Line_4),
	CODE_CHANGES_REQUIRED(Setting_volume_pane_elements_Line_5),
	CODE_CHANGES_REQUIRED(Setting_volume_pane_elements_Line_6),
	CODE_CHANGES_REQUIRED(Setting_volume_pane_elements_Line_7),
	CODE_CHANGES_REQUIRED(Setting_volume_pane_elements_Line_8),
	CODE_CHANGES_REQUIRED(Setting_volume_pane_elements_Line_9),
	CODE_CHANGES_REQUIRED(Setting_volume_pane_elements_Line_10),
	CODE_CHANGES_REQUIRED(Setting_volume_pane_elements_Line_11),
	CODE_CHANGES_REQUIRED(Limits),	// &Setting_volume_pane_elements_SUB_TABLE_0_Limits,
	CODE_CHANGES_REQUIRED(WindowTable1f),	// &Setting_volume_pane_elements_SUB_TABLE_0,
	SETTING_PAGE_NOK(Setting_slider_pane_elements_and_descendants_Line_1),
	SETTING_PAGE_NOK(Setting_slider_pane_elements_and_descendants_Line_2),
	SETTING_PAGE_NOK(Limits),	// &Setting_slider_pane_elements_and_descendants_Limits,
	SETTING_PAGE_NOK(WindowTable0f),	// &Setting_slider_pane_elements_and_descendants,
	SETTING_PAGE_NOK(Slider_pane_elements_Line_1),
	SETTING_PAGE_NOK(Slider_pane_elements_Line_2),
	SETTING_PAGE_NOK(Limits),	// &Slider_pane_elements_Limits,
	SETTING_PAGE_NOK(WindowTable0f),	// &Slider_pane_elements,
	NOT_DONE(Slider_texts__set__Line_1),
	NOT_DONE(Slider_texts__set__Line_2),
	NOT_DONE(MultiLineTextLine2f),	// &Multiline_Slider_texts__set__Line_2,
	SETTING_PAGE_NOK(Setting_slider_pane__graphic__elements_and_descendants_Line_1),
	SETTING_PAGE_NOK(Setting_slider_pane__graphic__elements_and_descendants_Line_2),
	SETTING_PAGE_NOK(Setting_slider_pane__graphic__elements_and_descendants_Line_3),
	SETTING_PAGE_NOK(Limits),	// &Setting_slider_pane__graphic__elements_and_descendants_Limits,
	SETTING_PAGE_NOK(WindowTable0f),	// &Setting_slider_pane__graphic__elements_and_descendants,
	NOT_DONE(Slider_with_graphic_texts__set__Line_1),
	NOT_DONE(MultiLineTextLine2f),	// &Multiline_Slider_with_graphic_texts__set__Line_1,
	NOT_NEEDED(Setting_text_pane_elements_Line_1),
	NOT_NEEDED(Setting_text_pane_elements_Line_2),
	NOT_NEEDED(Setting_text_pane_elements_Line_3),
	NOT_NEEDED(Setting_text_pane_elements_Line_4),
	NOT_NEEDED(Limits),	// &Setting_text_pane_elements_Limits,
	NOT_NEEDED(WindowTable0f),	// &Setting_text_pane_elements,
	NOT_DONE(Setting_text_pane_texts_Line_1),
	NOT_DONE(MultiLineTextLine2f),	// &Multiline_Setting_text_pane_texts_Line_1,
	NOT_NEEDED(Code_time_and_date_entry_pane_elements_Line_1),
	NOT_NEEDED(Code_time_and_date_entry_pane_elements_Line_2),
	NOT_NEEDED(Code_time_and_date_entry_pane_elements_Line_3),
	NOT_NEEDED(Limits),	// &Code_time_and_date_entry_pane_elements_Limits,
	NOT_NEEDED(WindowTable0f),	// &Code_time_and_date_entry_pane_elements,
	SETTING_PAGE_NOK(Code_time_and_date_entry_pane_texts_Line_1),
	NOT_NEEDED(Control_pane_elements_Line_1),
	NOT_NEEDED(Control_pane_elements_Line_2),
	IMPL_OK(Control_pane_elements_Line_3),
	IMPL_OK(Control_pane_elements_Line_4),
	IMPL_OK(Limits),	// &Control_pane_elements_Limits,
	NOT_NEEDED(Control_pane_elements),	// &Control_pane_elements, // THOUGH, THIS HAS A PROBLEM that CEikArrowHeadScrollbar::SetButtonPositionL() calls this method with index 0 and 1.
	IMPL_OK(Control_pane_texts_Line_1),
	IMPL_OK(Control_pane_texts_Line_2),
	IMPL_OK(Limits),	// &Control_pane_texts_Limits,
	IMPL_OK(TextTable0f),	// &Control_pane_texts,
	IMPL_OK_POPUP_LISTS(popup_menu_window),
    IMPL_OK_POPUP_LISTS(Pop_up_windows__main_pane_as_parent__Line_2),
    IMPL_OK_POPUP_LISTS(popup_menu_graphic_window),
    IMPL_OK_POPUP_LISTS(popup_menu_graphic_heading_window),
    IMPL_OK_POPUP_LISTS(popup_menu_double_window),
    IMPL_OK_POPUP_LISTS(popup_menu_double_large_graphic_window),
    IMPL_OK_POPUP_LISTS(popup_note_window),
    IMPL_OK_POPUP_LISTS(popup_note_wait_window),
    IMPL_OK_POPUP_LISTS(popup_note_image_window),
    IMPL_OK_POPUP_LISTS(popup_query_data_window),
    IMPL_OK_POPUP_LISTS(popup_query_code_window),
    IMPL_OK_POPUP_LISTS(popup_query_time_window),
    IMPL_OK_POPUP_LISTS(popup_query_date_window),
    IMPL_OK_POPUP_LISTS(popup_query_data_code_window),
    IMPL_OK_POPUP_LISTS(popup_find_window),
    IMPL_OK_POPUP_LISTS(popup_snote_single_text_window),
    IMPL_OK_POPUP_LISTS(popup_snote_single_graphic_window),
	NOT_IN_SPEC(popup_snote_group_window),
    IMPL_OK_POPUP_LISTS(popup_grid_graphic_window),
    IMPL_OK_POPUP_LISTS(popup_menu_double2_window),
    IMPL_OK_POPUP_LISTS(popup_grid_large_graphic_colour_window),
	FAST_SWAP_WINDOW_NOT_OK(popup_fast_swap_window), // TP.
    IMPL_OK_POPUP_LISTS(list_single_popup_menu_pane),
    IMPL_OK_POPUP_LISTS(list_single_heading_popup_menu_pane),
    IMPL_OK_POPUP_LISTS(list_single_graphic_popup_menu_pane),
    IMPL_OK_POPUP_LISTS(list_single_graphic_heading_popup_menu_pane),
    IMPL_OK_POPUP_LISTS(list_menu_double_popup_menu_pane),
    IMPL_OK_POPUP_LISTS(list_single_popup_submenu_pane),
    IMPL_OK_POPUP_LISTS(list_double_large_graphic_popup_menu_pane),
    IMPL_OK_POPUP_LISTS(Pop_up_window_list_pane_descendants_Line_8),
    IMPL_OK_POPUP_LISTS(list_double2_popup_menu_pane),
	NOT_IN_SPEC(List_pane_elements__menu_single__Line_1),
    IMPL_OK_POPUP_LISTS(List_pane_elements__menu_single__Line_2),
    IMPL_OK_POPUP_LISTS(List_pane_elements__menu_single__Line_3),
	IMPL_OK(Limits),	// &List_pane_elements__menu_single__SUB_TABLE_0_Limits,
	IMPL_OK(WindowTable0f),	// &List_pane_elements__menu_single__SUB_TABLE_0,
    IMPL_OK_POPUP_LISTS(List_pane_texts__menu_single__Line_1),
	NOT_DONE(List_pane_text__submenu_single__Line_1),
    IMPL_OK_POPUP_LISTS(List_pane_elements__menu_single_graphic__Line_1),
    IMPL_OK_POPUP_LISTS(List_pane_elements__menu_single_graphic__Line_2),
    IMPL_OK_POPUP_LISTS(List_pane_texts__menu_single_graphic__Line_1),
	NOT_DONE(List_pane_elements__menu_single_heading__Line_1),
    IMPL_OK_POPUP_LISTS(List_pane_elements__menu_single_heading__Line_2),
    IMPL_OK_POPUP_LISTS(List_pane_texts__menu_single_heading__Line_1),
    IMPL_OK_POPUP_LISTS(List_pane_texts__menu_single_heading__Line_2),
    IMPL_OK_POPUP_LISTS(List_pane_elements__menu_single_graphic_heading__Line_1),
	NOT_IN_SPEC(List_pane_elements__menu_single_graphic_heading__Line_2),
    IMPL_OK_POPUP_LISTS(List_pane_elements__menu_single_graphic_heading__Line_3),
    IMPL_OK_POPUP_LISTS(List_pane_texts__menu_single_graphic_heading__Line_1),
    IMPL_OK_POPUP_LISTS(List_pane_texts__menu_single_graphic_heading__Line_2),
	IMPL_OK(Limits),	// &List_pane_texts__menu_single_graphic_heading__Limits,
	IMPL_OK(TextTable1f),	// &List_pane_texts__menu_single_graphic_heading_,
    IMPL_OK_POPUP_LISTS(List_pane_elements__menu_double__Line_1),
    IMPL_OK_POPUP_LISTS(List_pane_texts__menu_double__Line_1),
    IMPL_OK_POPUP_LISTS(List_pane_texts__menu_double__Line_2),
    IMPL_OK_POPUP_LISTS(List_pane_elements__menu_double2__Line_1),
    IMPL_OK_POPUP_LISTS(List_pane_texts__menu_double2__Line_1),
    IMPL_OK_POPUP_LISTS(List_pane_texts__menu_double2__Line_2),
    IMPL_OK_POPUP_LISTS(List_pane_elements__menu_double_large_graphic__Line_1),
    IMPL_OK_POPUP_LISTS(List_pane_elements__menu_double_large_graphic__Line_2),
    IMPL_OK_POPUP_LISTS(List_pane_texts__menu_double_large_graphic__Line_1),
    IMPL_OK_POPUP_LISTS(List_pane_texts__menu_double_large_graphic__Line_2),
	NOT_IN_SPEC(Highlight_graphics__various__Line_1),
	NOT_IN_SPEC(Highlight_graphics__various__Line_2),
	NOT_IN_SPEC(Limits),	// &Highlight_graphics__various__Limits,
	NOT_IN_SPEC(WindowTable0t),	// &Highlight_graphics__various_,
	IMPL_OK(cell_graphic_popup_pane),
	NOT_DONE(Cell_pane_elements__pop_up_graphic__Line_1),
	IMPL_OK(Cell_pane_texts__pop_up_graphic__Line_1),
	IMPL_OK(cell_large_graphic_colour_popup_pane),
	IMPL_OK(colour),
	IMPL_OK(Pop_up_window_cell_pane__large_graphic_colour_none__Line_1),
	IMPL_OK(Cell_pane_texts__pop_up_large_graphic_colour_none__Line_1),
	IMPL_OK(Highlight_elements__grid_pop_up__Line_1),
	IMPL_OK(Highlight_elements__grid_pop_up__Line_2),
	IMPL_OK(Limits),	// &Highlight_elements__grid_pop_up__Limits,
	IMPL_OK(WindowTable0t),	// &Highlight_elements__grid_pop_up_,
	NOT_DONE(List_heading_pane_elements_Line_1),
	NOT_DONE(List_heading_pane_elements_Line_2),
	NOT_DONE(Limits),	// &List_heading_pane_elements_Limits,
	NOT_DONE(WindowTable0f),	// &List_heading_pane_elements,
	IMPL_OK(List_heading_pane_texts_Line_1),
	IMPL_OK(Pop_up_menu_with_heading_window_graphics_Line_1),
	NOT_NEEDED(Pop_up_menu_with_heading_window_graphics_Line_2),
	NOT_NEEDED(Pop_up_menu_with_heading_window_graphics_Line_3),
	NOT_NEEDED(Pop_up_menu_with_heading_window_graphics_Line_4),
	NOT_NEEDED(Pop_up_menu_with_heading_window_graphics_Line_5),
	NOT_NEEDED(Limits),	// &Pop_up_menu_with_heading_window_graphics_Limits,
	NOT_NEEDED(WindowTable0t),	// &Pop_up_menu_with_heading_window_graphics,
	IMPL_OK_POPUP_LISTS(list_menu_pane), 
	NOT_DONE(Menu_pop_up_window_descendants_Line_2),
	NOT_NEEDED(Menu_pop_up_window_graphics_Line_1),
	NOT_NEEDED(Menu_pop_up_window_graphics_Line_2),
	NOT_NEEDED(Menu_pop_up_window_graphics_Line_3),
	NOT_NEEDED(Menu_pop_up_window_graphics_Line_4),
	NOT_NEEDED(Menu_pop_up_window_graphics_Line_5),
	NOT_NEEDED(Limits),	// &Menu_pop_up_window_graphics_Limits,
	NOT_NEEDED(WindowTable0t),	// &Menu_pop_up_window_graphics,
	NOT_DONE(list_submenu_pane),
	NOT_NEEDED(Submenu_pop_up_window_graphics_Line_1),
	NOT_NEEDED(Submenu_pop_up_window_graphics_Line_2),
	NOT_NEEDED(Submenu_pop_up_window_graphics_Line_3),
	NOT_NEEDED(Submenu_pop_up_window_graphics_Line_4),
	NOT_NEEDED(Limits),	// &Submenu_pop_up_window_graphics_Limits,
	NOT_NEEDED(WindowTable0t),	// &Submenu_pop_up_window_graphics,
	NOT_DONE(Submenu_pop_up_window_positioning_Line_1),
	NOT_DONE(Submenu_pop_up_window_positioning_Line_2),
	NOT_DONE(Limits),	// &Submenu_pop_up_window_positioning_Limits,
	NOT_DONE(WindowTable2f),	// &Submenu_pop_up_window_positioning,
	IMPL_OK_POPUP_LISTS(list_menu_graphic_pane),
	IMPL_OK_POPUP_LISTS(list_menu_heading_pane),
	NOT_DONE(Menu_pop_up_window_descendants__single_heading__Line_2),
	NOT_DONE(Menu_pop_up_window_descendants__single_heading__Line_3),
	IMPL_OK_POPUP_LISTS(list_menu_graphic_heading_pane),
	NOT_DONE(Menu_pop_up_window_descendants_and_elements__single_graphic_heading__Line_2),
	NOT_DONE(Menu_pop_up_window_descendants_and_elements__single_graphic_heading__Line_3),
	IMPL_OK_POPUP_LISTS(list_menu_double_pane_list_menu_double2_pane),
	NOT_DONE(Menu_pop_up_window_descendants__double_double2__Line_2),
	IMPL_OK_POPUP_LISTS(list_menu_double_large_graphic_pane),
	NOT_DONE(Menu_pop_up_window_descendants__double__Line_2),
	IMPL_OK_NOTES(Note_pop_up_window_elements_Line_1),
	IMPL_OK_NOTES(Note_pop_up_window_texts_Line_1),
	IMPL_OK_NOTES(MultiLineTextLine2f),	// &Multiline_Note_pop_up_window_texts_Line_1,
	NOT_NEEDED(Note_pop_up_window_graphics_Line_1),
	NOT_NEEDED(Note_pop_up_window_graphics_Line_2),
	NOT_NEEDED(Note_pop_up_window_graphics_Line_3),
	NOT_NEEDED(Note_pop_up_window_graphics_Line_4),
	NOT_NEEDED(Note_pop_up_window_graphics_Line_5),
	NOT_NEEDED(Limits),	// &Note_pop_up_window_graphics_Limits,
	NOT_NEEDED(WindowTable0t),	// &Note_pop_up_window_graphics,
	IMPL_OK_NOTES(Wait_or_progress_note_pop_up_window_elements_Line_1),
	IMPL_OK_NOTES(Wait_or_progress_note_pop_up_window_elements_Line_2),
	IMPL_OK_NOTES(Wait_or_progress_note_pop_up_window_elements_Line_3),
	IMPL_OK_NOTES(Wait_or_progress_note_pop_up_window_elements_Line_4),
	IMPL_OK_NOTES(Limits),
	NOT_SUPPORTED(WindowTable0f), // &First_general_event_elements
	IMPL_OK_NOTES(Wait_or_progress_note_pop_up_window_texts_Line_1),
	IMPL_OK_NOTES(MultiLineTextLine3f),	// &Multiline_Wait_or_progress_note_pop_up_window_texts_Line_1,
	NOT_DONE(Note_with_an_image_pop_up_window_elements_Line_1),
	IMPL_OK_NOTES(Note_with_an_image_pop_up_window_elements_Line_2),
	NOT_DONE(Note_with_an_image_pop_up_window_elements_Line_3),
	IMPL_OK_NOTES(Note_with_an_image_pop_up_window_elements_Line_4),
	NOT_DONE(Note_with_an_image_pop_up_window_elements_Line_5),
	IMPL_OK_NOTES(Note_with_an_image_pop_up_window_elements_Line_6),
	NOT_DONE(Note_with_an_image_pop_up_window_elements_Line_7),
	IMPL_OK_NOTES(Note_with_an_image_pop_up_window_elements_Line_8),
	NOT_DONE(Note_with_an_image_pop_up_window_elements_Line_9),
	IMPL_OK_NOTES(Note_with_an_image_pop_up_window_elements_Line_10),
	IMPL_OK_NOTES(Note_with_an_image_pop_up_window_elements_Line_11),
	IMPL_OK_NOTES(Note_with_an_image_pop_up_window_elements_Line_12),
	IMPL_OK_NOTES(Note_with_an_image_pop_up_window_elements_Line_13),
	IMPL_OK_NOTES(Limits),	// &Note_with_an_image_pop_up_window_elements_Limits,
	IMPL_OK_NOTES(WindowTable0f),	// &Note_with_an_image_pop_up_window_elements,
	IMPL_OK_NOTES(Note_with_an_image_pop_up_window_texts_Line_1),
	IMPL_OK_NOTES(MultiLineTextLine4f),	// &Multiline_Note_with_an_image_pop_up_window_texts_Line_1,
	NOT_NEEDED(Query_with_heading_window_graphics_Line_1),
	NOT_NEEDED(Query_with_heading_window_graphics_Line_2),
	NOT_NEEDED(Query_with_heading_window_graphics_Line_3),
	NOT_NEEDED(Query_with_heading_window_graphics_Line_4),
	NOT_NEEDED(Query_with_heading_window_graphics_Line_5),
	NOT_NEEDED(Limits),	// &Query_with_heading_window_graphics_Limits,
	NOT_NEEDED(WindowTable0t),	// &Query_with_heading_window_graphics,
	NOT_DONE(popup_list_heading_pane),
	NOT_DONE(Heading_pane_elements_Line_1),
	IMPL_OK(Icon),
	IMPL_OK(Heading_pane_texts_Line_1),
	NOT_NEEDED(Data_query_pop_up_window_elements_Line_1),
	NOT_NEEDED(Data_query_pop_up_window_elements_Line_2),
	IMPL_OK_QUERIES(Data_query_pop_up_window_elements_Line_3),
	IMPL_OK_QUERIES(Data_query_pop_up_window_elements_Line_4),
	NOT_DONE(Data_query_pop_up_window_elements_Line_5),
	IMPL_OK_QUERIES(Data_query_pop_up_window_texts_Line_1),
	IMPL_OK_QUERIES(MultiLineTextLine1f),	// &Multiline_Data_query_pop_up_window_texts_Line_1,
	IMPL_OK_QUERIES(Data_query_pop_up_window_texts_Line_2),
	IMPL_OK_QUERIES(MultiLineTextLine2f),	// &Multiline_Data_query_pop_up_window_texts_Line_2,
	NOT_NEEDED(Data_query_pop_up_window_graphics_Line_1),
	NOT_NEEDED(Data_query_pop_up_window_graphics_Line_2),
	NOT_NEEDED(Data_query_pop_up_window_graphics_Line_3),
	NOT_NEEDED(Data_query_pop_up_window_graphics_Line_4),
	NOT_NEEDED(Data_query_pop_up_window_graphics_Line_5),
	NOT_NEEDED(Limits),	// &Data_query_pop_up_window_graphics_Limits,
	NOT_NEEDED(WindowTable0t),	// &Data_query_pop_up_window_graphics,
	NOT_NEEDED(Code_query_pop_up_window_elements_Line_1),
	NOT_NEEDED(Code_query_pop_up_window_elements_Line_2),
	IMPL_OK_QUERIES(Code_query_pop_up_window_elements_Line_3),
    IMPL_OK_QUERIES(Code_query_pop_up_window_elements_Line_4),
	IMPL_OK_QUERIES(Limits),	// &Code_query_pop_up_window_elements_Limits,
	IMPL_OK_QUERIES(WindowTable1f),	// &Code_query_pop_up_window_elements,
	IMPL_OK_QUERIES(Code_query_pop_up_window_texts_Line_1),
	IMPL_OK_QUERIES(MultiLineTextLine1f),	// &Multiline_Code_query_pop_up_window_texts_Line_1,
	IMPL_OK_QUERIES(Code_query_pop_up_window_texts_Line_2),
	IMPL_OK_QUERIES(MultiLineTextLine1f),	// &Multiline_Code_query_pop_up_window_texts_Line_2,
	IMPL_OK_QUERIES(Limits),	// &Code_query_pop_up_window_texts_Limits,
	IMPL_OK_QUERIES(TextTable1f),	// &Code_query_pop_up_window_texts,
	NOT_NEEDED(Combined_data_and_code_query_pop_up_window_elements_Line_1),
	NOT_NEEDED(Combined_data_and_code_query_pop_up_window_elements_Line_2),
	IMPL_OK_QUERIES(Combined_data_and_code_query_pop_up_window_elements_Line_3),
	IMPL_OK_QUERIES(Combined_data_and_code_query_pop_up_window_elements_Line_4),
	IMPL_OK_QUERIES(Combined_data_and_code_query_pop_up_window_elements_Line_5),
	IMPL_OK_QUERIES(Combined_data_and_code_query_pop_up_window_texts_Line_1),
	IMPL_OK_QUERIES(MultiLineTextLine1f),	// &Multiline_Combined_data_and_code_query_pop_up_window_texts_Line_1,
    IMPL_OK_QUERIES(Combined_data_and_code_query_pop_up_window_texts_Line_2),
	IMPL_OK_QUERIES(MultiLineTextLine1f),	// &Multiline_Combined_data_and_code_query_pop_up_window_texts_Line_2,
	IMPL_OK_QUERIES(Combined_data_and_code_query_pop_up_window_texts_Line_3),
	IMPL_OK_QUERIES(MultiLineTextLine1f),	// &Multiline_Combined_data_and_code_query_pop_up_window_texts_Line_3,
	IMPL_OK_QUERIES(Combined_data_and_code_query_pop_up_window_texts_Line_4),
	IMPL_OK_QUERIES(MultiLineTextLine1f),	// &Multiline_Combined_data_and_code_query_pop_up_window_texts_Line_4,
	IMPL_OK_QUERIES(Limits),	// &Combined_data_and_code_query_pop_up_window_texts_Limits,
	IMPL_OK_QUERIES(TextTable1f),	// &Combined_data_and_code_query_pop_up_window_texts,
	NOT_NEEDED(Combined_data_and_code_query_pop_up_window_graphics_Line_1),
	NOT_NEEDED(Combined_data_and_code_query_pop_up_window_graphics_Line_2),
	NOT_NEEDED(Combined_data_and_code_query_pop_up_window_graphics_Line_3),
	NOT_NEEDED(Combined_data_and_code_query_pop_up_window_graphics_Line_4),
	NOT_NEEDED(Combined_data_and_code_query_pop_up_window_graphics_Line_5),
	NOT_NEEDED(Limits),	// &Combined_data_and_code_query_pop_up_window_graphics_SUB_TABLE_0_Limits,
	NOT_NEEDED(WindowTable1t),	// &Combined_data_and_code_query_pop_up_window_graphics_SUB_TABLE_0,
	NOT_NEEDED(WindowLine0f),	// &Find_pop_up_window_elements_Line_1,
	NOT_NEEDED(WindowLine0f),	// &Find_pop_up_window_elements_Line_2,
	FIND_ENABLED(Find_pop_up_window_elements_Line_3),	// &Find_pop_up_window_elements_Line_3,
	FIND_ENABLED(Find_pop_up_window_elements_Line_4),
	FIND_ENABLED(Limits),	// &Find_pop_up_window_elements_Limits,
	FIND_ENABLED(WindowTable0f),	// &Find_pop_up_window_elements,
	FIND_ENABLED(Find_pop_up_window_texts_Line_1),
	NOT_NEEDED(Find_pop_up_window_graphics_Line_1),
	NOT_NEEDED(Find_pop_up_window_graphics_Line_2),
	NOT_NEEDED(Find_pop_up_window_graphics_Line_3),
	NOT_NEEDED(Find_pop_up_window_graphics_Line_4),
	NOT_NEEDED(Find_pop_up_window_graphics_Line_5),
	NOT_NEEDED(Limits),	// &Find_pop_up_window_graphics_Limits,
	NOT_NEEDED(WindowTable0f),	// &Find_pop_up_window_graphics,
	NOT_NEEDED(Pop_up_menu_with_find_pane_graphics_Line_1),
	NOT_NEEDED(Pop_up_menu_with_find_pane_graphics_Line_2),
	NOT_NEEDED(Pop_up_menu_with_find_pane_graphics_Line_3),
	NOT_NEEDED(Pop_up_menu_with_find_pane_graphics_Line_4),
	NOT_NEEDED(Pop_up_menu_with_find_pane_graphics_Line_5),
	NOT_NEEDED(Limits),	// &Pop_up_menu_with_find_pane_graphics_Limits,
	NOT_NEEDED(WindowTable0t),	// &Pop_up_menu_with_find_pane_graphics,
	IMPL_OK_QUERIES(Notification_pop_up_window_elements__text__Line_1),
	IMPL_OK_QUERIES(Notification_pop_up_window_texts__text__Line_1),
	IMPL_OK_QUERIES(MultiLineTextLine1f),	// &Multiline_Notification_pop_up_window_texts__text__Line_1,
	NOT_NEEDED(Notification_pop_up_window_graphics__text__Line_1),
	NOT_NEEDED(Notification_pop_up_window_graphics__text__Line_2),
	NOT_NEEDED(Notification_pop_up_window_graphics__text__Line_3),
	NOT_NEEDED(Notification_pop_up_window_graphics__text__Line_4),
	NOT_NEEDED(Notification_pop_up_window_graphics__text__Line_5),
	NOT_NEEDED(Limits),	// &Notification_pop_up_window_graphics__text__Limits,
	NOT_NEEDED(WindowTable0t),	// &Notification_pop_up_window_graphics__text_,
	IMPL_OK_QUERIES(Notification_pop_up_window_elements__graphic__Line_1),
	IMPL_OK_QUERIES(Notification_pop_up_window_elements__graphic__Line_2),
	IMPL_OK_QUERIES(Limits),	// &Notification_pop_up_window_elements__graphic__Limits,
	IMPL_OK_QUERIES(WindowTable0f),	// &Notification_pop_up_window_elements__graphic_,
	IMPL_OK_QUERIES(Notification_pop_up_window_texts__graphic__Line_1),
	IMPL_OK_QUERIES(MultiLineTextLine2f),	// &Multiline_Notification_pop_up_window_texts__graphic__Line_1,
	IMPL_OK(Identifier_icon_selection_pop_up_window_descendants_Line_1), //Vesa
	IMPL_OK(grid_graphic_popup_pane), //Vesa
	NOT_DONE(Identifier_icon_selection_pop_up_window_elements_Line_1),
	NOT_DONE(Identifier_icon_selection_pop_up_window_elements_Line_2),
	NOT_DONE(Identifier_icon_selection_pop_up_window_graphics_Line_1),
	NOT_DONE(Identifier_icon_selection_pop_up_window_graphics_Line_2),
	NOT_DONE(Identifier_icon_selection_pop_up_window_graphics_Line_3),
	NOT_DONE(Identifier_icon_selection_pop_up_window_graphics_Line_4),
	NOT_DONE(Identifier_icon_selection_pop_up_window_graphics_Line_5),
	NOT_DONE(Limits),	// &Identifier_icon_selection_pop_up_window_graphics_SUB_TABLE_0_Limits,
	NOT_DONE(WindowTable1t),	// &Identifier_icon_selection_pop_up_window_graphics_SUB_TABLE_0,
	IMPL_OK(Colour_selection_pop_up_window_descendants_Line_1), //	&WindowLine0f,	// &Colour_selection_pop_up_window_descendants_Line_1,
	IMPL_OK(Colour_selection_pop_up_window_descendants_Line_2), //	&WindowLine0f,	// &Colour_selection_pop_up_window_descendants_Line_2,
	IMPL_OK(grid_large_graphic_colour_popup_pane), //	&WindowLine1f,	// &grid_large_graphic_colour_popup_pane,
	IMPL_OK(Composer_symbol_selection_pop_up_window_elements_Line_1),
	IMPL_OK(Composer_symbol_selection_pop_up_window_elements_Line_2),
	NOT_DONE(Colour_selection_pop_up_window_graphics_Line_1),
	NOT_DONE(Colour_selection_pop_up_window_graphics_Line_2),
	NOT_DONE(Colour_selection_pop_up_window_graphics_Line_3),
	NOT_DONE(Colour_selection_pop_up_window_graphics_Line_4),
	NOT_DONE(Colour_selection_pop_up_window_graphics_Line_5),
	NOT_DONE(Limits),	// &Colour_selection_pop_up_window_graphics_Limits,
	NOT_DONE(WindowTable0t),	// &Colour_selection_pop_up_window_graphics,
	IMPL_OK(Fast_application_swapping_pop_up_window_descendants_Line_1), //Vesa
	NOT_DONE(Fast_application_swapping_pop_up_window_graphics_Line_1),
	NOT_DONE(Fast_application_swapping_pop_up_window_graphics_Line_2),
	NOT_DONE(Fast_application_swapping_pop_up_window_graphics_Line_3),
	NOT_DONE(Fast_application_swapping_pop_up_window_graphics_Line_4),
	NOT_DONE(Fast_application_swapping_pop_up_window_graphics_Line_5),
	NOT_DONE(Fast_application_swapping_pop_up_window_graphics_Line_6),
	NOT_DONE(Limits),	// &Fast_application_swapping_pop_up_window_graphics_SUB_TABLE_0_Limits,
	NOT_DONE(WindowTable0t),	// &Fast_application_swapping_pop_up_window_graphics_SUB_TABLE_0,
	LISTS_ENABLED(List_pane_texts__setting__double2__Line_1),
	LISTS_ENABLED(List_pane_texts__setting__double2__Line_2),
	LISTS_ENABLED(Limits),	// &List_pane_texts__setting__double2__Limits,
	LISTS_ENABLED(TextTable0f),	// &List_pane_texts__setting__double2_,
	NOT_DONE(List_pane_elements__single_2graphic__Line_1),
	NOT_DONE(List_pane_elements__single_2graphic__Line_2),
	NOT_DONE(List_pane_elements__single_2graphic__Line_3),
	NOT_DONE(List_pane_elements__single_2graphic__Line_4),
	NOT_DONE(Limits),	// &List_pane_elements__single_2graphic__SUB_TABLE_0_Limits,
	NOT_DONE(WindowTable0f),	// &List_pane_elements__single_2graphic__SUB_TABLE_0,
	NOT_DONE(List_pane_texts__single_2graphic__Line_1),	// &List_pane_texts__single_2graphic__Line_1,
	NOT_DONE(List_pane_elements__double2_graphic_large_graphic__Line_1),	// &List_pane_elements__double2_graphic_large_graphic__Line_1,
	NOT_DONE(List_pane_elements__double2_graphic_large_graphic__Line_2),	// &List_pane_elements__double2_graphic_large_graphic__Line_2,
	NOT_DONE(List_pane_elements__double2_graphic_large_graphic__Line_3),	// &List_pane_elements__double2_graphic_large_graphic__Line_3,
	NOT_DONE(List_pane_elements__double2_graphic_large_graphic__Line_4),	// &List_pane_elements__double2_graphic_large_graphic__Line_4,
	NOT_DONE(Limits),	// &List_pane_elements__double2_graphic_large_graphic__SUB_TABLE_0_Limits,
	NOT_DONE(WindowTable0f),	// &List_pane_elements__double2_graphic_large_graphic__SUB_TABLE_0,
	NOT_DONE(List_pane_texts__double2_graphic_large_graphic__Line_1),	// &List_pane_texts__double2_graphic_large_graphic__Line_1,
	NOT_DONE(List_pane_texts__double2_graphic_large_graphic__Line_2),	// &List_pane_texts__double2_graphic_large_graphic__Line_2,
	FORMS_ENABLED(Form_data_wide_graphic_field_texts_Line_1),	// &Form_data_wide_graphic_field_texts_Line_1,
	FORMS_ENABLED(Form_data_wide_graphic_field_texts_Line_2),	// &Form_data_wide_graphic_field_texts_Line_2,
	FORMS_ENABLED(Multiline_Form_data_wide_graphic_field_texts_Line_2), // &MultiLineTextLine1f,
	IMPL_OK(status_small_pane),	// &status_small_pane,
	IMPL_OK(Small_status_pane_descendants_and_elements_Line_1),	// &Small_status_pane_descendants_and_elements_Line_1,
	IMPL_OK(status_small_icon_pane),	// &status_small_icon_pane,
	IMPL_OK(status_small_wait_pane),	// &status_small_wait_pane,
	IMPL_OK(Small_status_pane_descendants_and_elements_Line_4),	// &Small_status_pane_descendants_and_elements_Line_4,
	IMPL_OK(Small_status_pane_descendants_and_elements_Line_5),	// &Small_status_pane_descendants_and_elements_Line_5,
	IMPL_OK(Small_status_pane_descendants_and_elements_Line_6),	// &Small_status_pane_descendants_and_elements_Line_6,
	NOT_DONE(Limits),	// &Small_status_pane_descendants_and_elements_Limits,
	NOT_DONE(WindowTable0f),	// &Small_status_pane_descendants_and_elements,
	IMPL_OK(Small_status_pane_texts_Line_1),	// &Small_status_pane_texts_Line_1,
	IMPL_OK(Small_status_waiting_pane_components_Line_1),	// &Small_status_waiting_pane_components_Line_1,
	IMPL_OK(Small_status_waiting_pane_components_Line_2),	// &Small_status_waiting_pane_components_Line_2,
	IMPL_OK(Small_status_waiting_pane_components_Line_3),	// &Small_status_waiting_pane_components_Line_3,
	IMPL_OK(Small_status_waiting_pane_components_Line_4),	// &Small_status_waiting_pane_components_Line_4,
	NOT_DONE(Limits),	// &Small_status_waiting_pane_components_Limits,
	NOT_DONE(WindowTable0f),	// &Small_status_waiting_pane_components,
	IMPL_OK(Note_with_additional_information_popup_window_elements_Line_1),	// &Note_with_additional_information_popup_window_elements_Line_1,
	NOT_DONE(Note_with_additional_information_popup_window_elements_Line_2),	// &Note_with_additional_information_popup_window_elements_Line_2,
	NOT_DONE(Note_with_additional_information_popup_window_elements_Line_3),	// &Note_with_additional_information_popup_window_elements_Line_3,
	NOT_DONE(Note_with_additional_information_popup_window_texts_Line_1),	// &Note_with_additional_information_popup_window_texts_Line_1,
	NOT_DONE(MultiLineTextLine2f),	// &Multiline_Note_with_additional_information_popup_window_texts_Line_1,
	NOT_DONE(Note_with_additional_information_popup_window_texts_Line_2),	// &Note_with_additional_information_popup_window_texts_Line_2,
	NOT_DONE(MultiLineTextLine1f),	// &Multiline_Note_with_additional_information_popup_window_texts_Line_2,
	NOT_DONE(Note_with_additional_information_popup_window_texts_Line_3),	// &Note_with_additional_information_popup_window_texts_Line_3,
	NOT_DONE(MultiLineTextLine2f),	// &Multiline_Note_with_additional_information_popup_window_texts_Line_3,
	IMPL_OK(Heading_pane_texts_Line_2),	// &Heading_pane_texts_Line_2,
	NOT_DONE(Side_volume_key_popup_window_elements_Line_1),	// &Side_volume_key_popup_window_elements_Line_1,
	NOT_DONE(Side_volume_key_popup_window_elements_Line_2),	// &Side_volume_key_popup_window_elements_Line_2,
	NOT_DONE(Side_volume_key_popup_window_texts_Line_1),	// &Side_volume_key_popup_window_texts_Line_1,
	NOT_DONE(Side_volume_key_popup_window_texts_Line_2),	// &Side_volume_key_popup_window_texts_Line_2,
	NOT_DONE(Side_volume_key_popup_window_background_Line_1),	// &Side_volume_key_popup_window_background_Line_1,
	NOT_DONE(Side_volume_key_popup_window_background_Line_2),	// &Side_volume_key_popup_window_background_Line_2,
	NOT_DONE(Side_volume_key_popup_window_background_Line_3),	// &Side_volume_key_popup_window_background_Line_3,
	NOT_DONE(Side_volume_key_popup_window_background_Line_4),	// &Side_volume_key_popup_window_background_Line_4,
	SETTING_PAGE_ENABLED(Transparent_setting_item_texts_Line_1),
	SETTING_PAGE_ENABLED(Transparent_setting_item_texts_Line_2),
	SETTING_PAGE_ENABLED(Transparent_setting_item_texts_Line_3),
	SETTING_PAGE_ENABLED(Transparent_setting_item_texts_Line_4),
	NOT_DONE(List_pane_texts__set_trans_graphic__Line_1),
	NOT_DONE(List_pane_texts__set_trans_graphic__Line_2),
	SETTING_PAGE_ENABLED(list_set_trans_pane),
	SETTING_PAGE_ENABLED(list_set_trans_graphic_pane),
	NOT_NEEDED(List_pane_elements__set_trans_graphic__Line_1),
	NOT_NEEDED(List_pane_elements__set_trans_graphic__Line_2),
	NOT_NEEDED(List_pane_elements__set_trans_graphic__Line_3),
	NOT_NEEDED(List_pane_elements__set_trans_graphic__Line_4),
	NOT_DONE(List_pane_elements__set_trans_graphic__Line_5),
	NOT_DONE(Soft_indicator_texts_Line_1),
	IMPL_OK_AI(ai_links_pane),
	IMPL_OK_AI(ai_gene_pane),
	NOT_NEEDED(Link_pane_elements_and_descendant_panes_Line_1),
	IMPL_OK_AI(grid_ai_links_pane),
	IMPL_OK_AI(Limits),
	IMPL_OK_AI(WindowTable0f),
	IMPL_OK_AI(cell_ai_link_pane),
	IMPL_OK_AI(Link_shortcut_cell_pane_elements_Line_1),
	IMPL_OK_AI(Link_shortcut_cell_pane_elements_Line_2),
	IMPL_OK_AI(Link_shortcut_cell_pane_elements_Line_3),
	IMPL_OK_AI(Link_shortcut_cell_pane_elements_Line_4),
	IMPL_OK_AI(Limits),
	IMPL_OK_AI(WindowTable0f),
	NOT_DONE(popup_ai_links_title_window),
	IMPL_OK_AI(Link_shortcut_title_texts_Line_1),
	NOT_NEEDED(Link_shortcut_title_pop_up_window_graphics_Line_1),
	NOT_NEEDED(Link_shortcut_title_pop_up_window_graphics_Line_2),
	NOT_NEEDED(Link_shortcut_title_pop_up_window_graphics_Line_3),
	NOT_NEEDED(Link_shortcut_title_pop_up_window_graphics_Line_4),
	NOT_NEEDED(Limits),
	NOT_NEEDED(WindowTable0t),
	IMPL_OK_AI(ai_gene_pane_1),
	IMPL_OK_AI(ai_gene_pane_2),
	IMPL_OK_AI(First_general_event_elements_Line_1),
	IMPL_OK_AI(First_general_event_elements_Line_2),
	IMPL_OK_AI(First_general_event_texts_Line_1),
	IMPL_OK_AI(Second_general_event_pane_texts_Line_1),
	NOT_DONE(Shortcut_link_highlight_Line_1),
	NOT_DONE(Highlight_for_other_Active_Idle_items_Line_1),
	FIND_ENABLED(Find_pop_up_window_texts_Line_2), // &TextLine0f,
	FIND_ENABLED(Limits), // &Limits,
	FIND_ENABLED(TextTable0f), // &TextTable0f,
	FIND_ENABLED(Find_pane_texts_Line_2), // &TextLine0f,
	FIND_ENABLED(Limits), // &Limits,
	FIND_ENABLED(TextTable0f), // &TextTable0f,
	NOT_NEEDED(ai_gene_pane_3),                         // Implementation is not needed because 
	NOT_NEEDED(Third_general_event_elements_Line_1),    // active idle application uses new layout API
	NOT_NEEDED(Third_general_event_elements_Line_2),    // if scalable layout insterface is available.
	NOT_NEEDED(Limits),
	NOT_NEEDED(WindowTable0f),
	NOT_NEEDED(popup_ai_message_window),
	NOT_NEEDED(Active_idle_message_pop_up_window_descendants_Line_1),
	NOT_NEEDED(Active_idle_message_pop_up_window_descendants_Line_2),
	NOT_NEEDED(Active_idle_message_pop_up_window_descendants_Line_3),
	NOT_NEEDED(Limits),
	NOT_NEEDED(WindowTable0f),
	NOT_NEEDED(Active_idle_message_popup_window_texts_Line_1),
	NOT_NEEDED(MultiLineTextLine2f),
	NOT_NEEDED(Active_idle_heading_pane_elements_Line_1),
	NOT_NEEDED(Active_idle_heading_pane_elements_Line_2),
	NOT_NEEDED(Active_idle_heading_pane_elements_Line_3),
	NOT_NEEDED(Active_idle_heading_pane_elements_Line_4),
	NOT_NEEDED(Limits),
	NOT_NEEDED(WindowTable0f),
	NOT_NEEDED(Active_idle_heading_pane_texts_Line_1),
	NOT_NEEDED(Active_idle_heading_pane_texts_Line_2),
	NOT_NEEDED(Active_idle_message_pop_up_window_graphics_Line_1),
	NOT_NEEDED(Active_idle_message_pop_up_window_graphics_Line_2),
	NOT_NEEDED(Active_idle_message_pop_up_window_graphics_Line_3),
	NOT_NEEDED(Active_idle_message_pop_up_window_graphics_Line_4),
	NOT_NEEDED(Active_idle_message_pop_up_window_graphics_Line_5),
	NOT_NEEDED(Limits),
	NOT_NEEDED(WindowTable0t),
	};

} // end of namespace AknLayout_Elaf_Double
