/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/

// It contains common definitions for the client and customisation API.
// It should not be modified manually.

#ifndef AKNLAYOUT_CDL_COMMON_H
#define AKNLAYOUT_CDL_COMMON_H


#include <AknLayout2Def.h>


namespace AknLayout
{
#include "aknlayout.cdl.common.hrh"

// These constants are defined by the CDL interface: AknLayout
_LIT(KCdlName, "AknLayout");
const TInt KCdlInterfaceUidValue = _CDL_AknLayout_KCdlInterfaceUidValue;
const TUid KCdlInterfaceUid = { KCdlInterfaceUidValue };
const TInt KCdlInterfaceMajorVersion = 1;
const TInt KCdlInterfaceMinorVersion = 0;
const TUint KCdlInterfaceFlags = KCdlFlagRomOnly;

// These are the API ids used in this interface.
enum TApiId
	{
	EApiId_screen,
	EApiId_application_window,
	EApiId_status_pane,
	EApiId_main_pane,
	EApiId_control_pane,
	EApiId_signal_pane,
	EApiId_context_pane,
	EApiId_title_pane,
	EApiId_battery_pane,
	EApiId_uni_indicator_pane,
	EApiId_navi_pane,
	EApiId_Status_pane_elements_Line_1,
	EApiId_Status_pane_elements_Line_2,
	EApiId_Status_pane_elements_Limits,
	EApiId_Status_pane_elements,
	EApiId_Signal_pane_elements_Line_1,
	EApiId_Signal_pane_elements_Line_2,
	EApiId_Signal_pane_elements_Limits,
	EApiId_Signal_pane_elements,
	EApiId_Signal_strength_area_values_Line_1,
	EApiId_Signal_strength_area_values_Line_2,
	EApiId_Signal_strength_area_values_Line_3,
	EApiId_Signal_strength_area_values_Line_4,
	EApiId_Signal_strength_area_values_Line_5,
	EApiId_Signal_strength_area_values_Line_6,
	EApiId_Signal_strength_area_values_Line_7,
	EApiId_Signal_strength_area_values_Line_8,
	EApiId_Signal_strength_area_values_Limits,
	EApiId_Signal_strength_area_values,
	EApiId_Battery_pane_elements_Line_1,
	EApiId_Battery_pane_elements_Line_2,
	EApiId_Battery_pane_elements_Limits,
	EApiId_Battery_pane_elements,
	EApiId_Battery_strength_area_values_Line_1,
	EApiId_Battery_strength_area_values_Line_2,
	EApiId_Battery_strength_area_values_Line_3,
	EApiId_Battery_strength_area_values_Line_4,
	EApiId_Battery_strength_area_values_Line_5,
	EApiId_Battery_strength_area_values_Line_6,
	EApiId_Battery_strength_area_values_Line_7,
	EApiId_Battery_strength_area_values_Line_8,
	EApiId_Battery_strength_area_values_Limits,
	EApiId_Battery_strength_area_values,
	EApiId_Context_pane_elements_Line_1,
	EApiId_Title_pane_texts_Line_1,
	EApiId_Title_pane_texts_Line_2,
	EApiId_Multiline_Title_pane_texts_Line_2,
	EApiId_Title_pane_elements_Line_1,
	EApiId_Universal_indicator_pane_elements_Line_1,
	EApiId_Navi_pane_arrow_elements_Line_1,
	EApiId_Navi_pane_arrow_elements_Line_2,
	EApiId_Navi_pane_tab_elements_Line_1,
	EApiId_Navi_pane_tab_elements_Line_2,
	EApiId_Navi_pane_tab_elements_Line_3,
	EApiId_Navi_pane_tab_elements_Line_4,
	EApiId_Navi_pane_tab_elements_Line_5,
	EApiId_Navi_pane_tab_elements_Line_6,
	EApiId_Navi_pane_tab_elements_Line_7,
	EApiId_Navi_pane_tab_elements_Line_8,
	EApiId_Navi_pane_tab_elements_Line_9,
	EApiId_Navi_pane_tab_elements_Line_10,
	EApiId_Navi_pane_tab_elements_Line_11,
	EApiId_Navi_pane_tab_elements_Line_12,
	EApiId_Navi_pane_tab_elements_Line_13,
	EApiId_Navi_pane_tab_elements_Line_14,
	EApiId_Navi_pane_tab_elements_Limits,
	EApiId_Navi_pane_tab_elements,
	EApiId_Elements_on_the_tabs_Line_1,
	EApiId_Elements_on_the_tabs_Line_2,
	EApiId_Elements_on_the_tabs_Line_3,
	EApiId_Elements_on_the_tabs_Limits,
	EApiId_Elements_on_the_tabs,
	EApiId_Texts_on_the_tabs_Line_1,
	EApiId_Texts_on_the_tabs_Line_2,
	EApiId_Texts_on_the_tabs_Line_3,
	EApiId_Texts_on_the_tabs_Line_4,
	EApiId_Texts_on_the_tabs_Line_5,
	EApiId_Texts_on_the_tabs_Limits,
	EApiId_Texts_on_the_tabs,
	EApiId_Navi_pane_icons_Line_1,
	EApiId_Navi_pane_icons_Line_2,
	EApiId_Navi_pane_texts_Line_1,
	EApiId_Navi_pane_texts_Line_2,
	EApiId_Navi_pane_texts_Line_3,
	EApiId_Navi_pane_texts_Line_4,
	EApiId_Navi_pane_texts_Line_5,
	EApiId_Navi_pane_texts_Line_6,
	EApiId_Navi_pane_texts_Line_7,
	EApiId_Navi_pane_area_for_editing_status_icons_Line_1,
	EApiId_Volume_glider_elements__one__Line_1,
	EApiId_volume_navi_pane,
	EApiId_Volume_glider_elements__one__Limits,
	EApiId_Volume_glider_elements__one_,
	EApiId_Volume_pane_elements__one__Line_1,
	EApiId_Volume_pane_elements__one__Line_2,
	EApiId_Volume_pane_elements__one__Line_3,
	EApiId_Volume_pane_elements__one__Line_4,
	EApiId_Volume_pane_elements__one__Line_5,
	EApiId_Volume_pane_elements__one__Line_6,
	EApiId_Volume_pane_elements__one__Line_7,
	EApiId_Volume_pane_elements__one__Line_8,
	EApiId_Volume_pane_elements__one__Line_9,
	EApiId_Volume_pane_elements__one__Line_10,
	EApiId_Volume_pane_elements__one__Limits,
	EApiId_Volume_pane_elements__one_,
	EApiId_list_gen_pane,
	EApiId_find_pane,
	EApiId_wallpaper_pane,
	EApiId_indicator_pane,
	EApiId_soft_indicator_pane,
	EApiId_A_column,
	EApiId_B_column,
	EApiId_C_column,
	EApiId_D_column,
	EApiId_List_pane_column_division_Limits,
	EApiId_List_pane_column_division,
	EApiId_list_single_pane,
	EApiId_list_single_number_pane,
	EApiId_list_single_heading_pane,
	EApiId_list_single_graphic_pane,
	EApiId_list_single_graphic_heading_pane,
	EApiId_list_single_number_heading_pane,
	EApiId_list_single_large_graphic_pane,
	EApiId_list_double_pane,
	EApiId_list_double2_pane,
	EApiId_list_double_number_pane_list_single_big_number_pane,
	EApiId_list_double_time_pane,
	EApiId_list_double_large_graphic_pane_list_double2_large_graphic_pane_list_single_big_large_graphic_pane,
	EApiId_list_double_graphic_pane_list_double2_graphic_pane,
	EApiId_list_single_big_heading_graphic_pane,
	EApiId_list_single_big_heading_pane,
	EApiId_list_setting_pane_list_big_setting_pane,
	EApiId_list_setting_number_pane_list_big_setting_number_pane,
	EApiId_list_setting_double2_pane,
	EApiId_list_double2_graphic_pane,
	EApiId_list_double2_large_graphic_pane,
	EApiId_list_single_2graphic_pane,
	EApiId_list_double2_graphic_large_graphic_pane,
	EApiId_General_list_pane_descendants_Limits,
	EApiId_General_list_pane_descendants,
	EApiId_List_pane_elements__single__Line_1,
	EApiId_List_pane_elements__single__Line_2,
	EApiId_List_pane_texts__single__Line_1,
	EApiId_List_pane_elements__single_number__Line_1,
	EApiId_List_pane_elements__single_number__Line_2,
	EApiId_List_pane_texts__single_number__Line_1,
	EApiId_List_pane_texts__single_number__Line_2,
	EApiId_List_pane_elements__single_heading__Line_1,
	EApiId_List_pane_elements__single_heading__Line_2,
	EApiId_List_pane_elements__single_heading__Line_3,
	EApiId_List_pane_elements__single_heading__SUB_TABLE_0_Limits,
	EApiId_List_pane_elements__single_heading__SUB_TABLE_0,
	EApiId_List_pane_texts__single_heading__Line_1,
	EApiId_List_pane_texts__single_heading__Line_2,
	EApiId_List_pane_texts__single_heading__Limits,
	EApiId_List_pane_texts__single_heading_,
	EApiId_List_pane_elements__single_graphic__Line_1,
	EApiId_List_pane_elements__single_graphic__Line_2,
	EApiId_List_pane_elements__single_graphic__Line_3,
	EApiId_List_pane_elements__single_graphic__SUB_TABLE_0_Limits,
	EApiId_List_pane_elements__single_graphic__SUB_TABLE_0,
	EApiId_List_pane_texts__single_graphic__Line_1,
	EApiId_List_pane_elements__single_graphic_heading__Line_1,
	EApiId_List_pane_elements__single_graphic_heading__Line_2,
	EApiId_List_pane_elements__single_graphic_heading__Line_3,
	EApiId_List_pane_elements__single_graphic_heading__Line_4,
	EApiId_List_pane_elements__single_graphic_heading__SUB_TABLE_0_Limits,
	EApiId_List_pane_elements__single_graphic_heading__SUB_TABLE_0,
	EApiId_List_pane_texts__single_graphic_heading__Line_1,
	EApiId_List_pane_texts__single_graphic_heading__Line_2,
	EApiId_List_pane_texts__single_graphic_heading__Limits,
	EApiId_List_pane_texts__single_graphic_heading_,
	EApiId_List_pane_elements__single_number_heading__Line_1,
	EApiId_List_pane_elements__single_number_heading__Line_2,
	EApiId_List_pane_elements__single_number_heading__Line_3,
	EApiId_List_pane_elements__single_number_heading__SUB_TABLE_0_Limits,
	EApiId_List_pane_elements__single_number_heading__SUB_TABLE_0,
	EApiId_List_pane_texts__single_number_heading__Line_1,
	EApiId_List_pane_texts__single_number_heading__Line_2,
	EApiId_List_pane_texts__single_number_heading__Line_3,
	EApiId_List_pane_texts__single_number_heading__Limits,
	EApiId_List_pane_texts__single_number_heading_,
	EApiId_List_pane_elements__single_large_graphic__Line_1,
	EApiId_List_pane_elements__single_large_graphic__Line_2,
	EApiId_List_pane_elements__single_large_graphic__Line_3,
	EApiId_do_not_use_empty_pane1,
	EApiId_do_not_use_empty_pane2,
	EApiId_List_pane_texts__single_large_graphic__Line_1,
	EApiId_List_pane_elements__double__Line_1,
	EApiId_List_pane_elements__double__Line_2,
	EApiId_List_pane_texts__double__Line_1,
	EApiId_List_pane_texts__double__Line_2,
	EApiId_List_pane_text__double2__Line_1,
	EApiId_List_pane_text__double2__Line_2,
	EApiId_List_pane_elements__double_number__Line_1,
	EApiId_List_pane_elements__double_number__Line_2,
	EApiId_List_pane_texts__double_number__Line_1,
	EApiId_List_pane_texts__double_number__Line_2,
	EApiId_List_pane_texts__double_number__Line_3,
	EApiId_List_pane_elements__double_graphic__Line_1,
	EApiId_List_pane_elements__double_graphic__Line_2,
	EApiId_List_pane_elements__double_graphic__Line_3,
	EApiId_List_pane_elements__double_graphic__SUB_TABLE_0_Limits,
	EApiId_List_pane_elements__double_graphic__SUB_TABLE_0,
	EApiId_List_pane_texts__double_graphic__Line_1,
	EApiId_List_pane_texts__double_graphic__Line_2,
	EApiId_List_pane_elements__double2_graphic__Line_1,
	EApiId_List_pane_elements__double2_graphic__Line_2,
	EApiId_List_pane_elements__double2_graphic__Line_3,
	EApiId_List_pane_elements__double2_graphic__SUB_TABLE_0_Limits,
	EApiId_List_pane_elements__double2_graphic__SUB_TABLE_0,
	EApiId_List_pane_texts__double2_graphic__Line_1,
	EApiId_List_pane_texts__double2_graphic__Line_2,
	EApiId_List_pane_elements__double2_large_graphic__Line_1,
	EApiId_List_pane_elements__double2_large_graphic__Line_2,
	EApiId_List_pane_elements__double2_large_graphic__Line_3,
	EApiId_List_pane_elements__double2_large_graphic__SUB_TABLE_0_Limits,
	EApiId_List_pane_elements__double2_large_graphic__SUB_TABLE_0,
	EApiId_List_pane_texts__double2_large_graphic__Line_1,
	EApiId_List_pane_texts__double2_large_graphic__Line_2,
	EApiId_List_pane_elements__large_single_heading_graphic__Line_1,
	EApiId_List_pane_elements__large_single_heading_graphic__Line_2,
	EApiId_List_pane_elements__large_single_heading_graphic__Line_3,
	EApiId_List_pane_elements__large_single_heading_graphic__SUB_TABLE_0_Limits,
	EApiId_List_pane_elements__large_single_heading_graphic__SUB_TABLE_0,
	EApiId_List_pane_texts__large_single_heading_graphic__Line_1,
	EApiId_List_pane_texts__large_single_heading_graphic__Line_2,
	EApiId_List_pane_elements__large_single_heading__Line_1,
	EApiId_List_pane_texts__large_single_heading__Line_1,
	EApiId_List_pane_texts__large_single_heading__Line_2,
	EApiId_List_pane_texts__large_single_heading__Limits,
	EApiId_List_pane_texts__large_single_heading_,
	EApiId_List_pane_elements__double_time__Line_1,
	EApiId_List_pane_texts__double_time__Line_1,
	EApiId_List_pane_texts__double_time__Line_2,
	EApiId_List_pane_texts__double_time__Line_3,
	EApiId_List_pane_texts__double_time__Line_4,
	EApiId_List_pane_texts__double_time__Limits,
	EApiId_List_pane_texts__double_time_,
	EApiId_List_pane_elements__double_large_graphic__Line_1,
	EApiId_List_pane_elements__double_large_graphic__Line_2,
	EApiId_List_pane_elements__double_large_graphic__Line_3,
	EApiId_List_pane_elements__double_large_graphic__Line_4,
	EApiId_List_pane_elements__double_large_graphic__Line_5,
	EApiId_List_pane_elements__double_large_graphic__Line_6,
	EApiId_List_pane_elements__double_large_graphic__Line_7,
	EApiId_List_pane_elements__double_large_graphic__Line_8,
	EApiId_List_pane_elements__double_large_graphic__Line_9,
	EApiId_List_pane_elements__double_large_graphic__Line_10,
	EApiId_List_pane_texts__double_large_graphic__Line_1,
	EApiId_List_pane_texts__double_large_graphic__Line_2,
	EApiId_List_pane_elements__setting__Line_1,
	EApiId_List_pane_elements__setting__Line_2,
	EApiId_List_pane_elements__setting__Line_3,
	EApiId_List_pane_elements__setting__Line_4,
	EApiId_List_pane_elements__setting__Line_5,
	EApiId_List_pane_elements__setting__Line_6,
	EApiId_List_pane_elements__setting__Limits,
	EApiId_List_pane_elements__setting_,
	EApiId_List_pane_texts__setting__Line_1,
	EApiId_List_pane_texts__setting__Line_2,
	EApiId_List_pane_texts__setting__Line_3,
	EApiId_List_pane_texts__setting__Line_4,
	EApiId_List_pane_texts__setting__Limits,
	EApiId_List_pane_texts__setting_,
	EApiId_List_pane_elements__setting_number__Line_1,
	EApiId_List_pane_elements__setting_number__Line_2,
	EApiId_List_pane_elements__setting_number__Line_3,
	EApiId_List_pane_elements__setting_number__Line_4,
	EApiId_List_pane_elements__setting_number__Line_5,
	EApiId_List_pane_elements__setting_number__Limits,
	EApiId_List_pane_elements__setting_number_,
	EApiId_List_pane_texts__setting_number__Line_1,
	EApiId_List_pane_texts__setting_number__Line_2,
	EApiId_List_pane_texts__setting_number__Line_3,
	EApiId_List_pane_texts__setting_number__Line_4,
	EApiId_List_pane_texts__setting_number__Limits,
	EApiId_List_pane_texts__setting_number_,
	EApiId_Setting_volume_elements_Line_1,
	EApiId_Setting_volume_elements_Line_2,
	EApiId_Setting_volume_elements_Line_3,
	EApiId_Setting_volume_elements_Line_4,
	EApiId_Setting_volume_elements_Line_5,
	EApiId_Setting_volume_elements_Line_6,
	EApiId_Setting_volume_elements_Line_7,
	EApiId_Setting_volume_elements_Line_8,
	EApiId_Setting_volume_elements_Line_9,
	EApiId_Setting_volume_elements_Line_10,
	EApiId_Setting_volume_elements_Limits,
	EApiId_Setting_volume_elements,
	EApiId_Setting_slider_elements_Line_1,
	EApiId_List_pane_elements__setting_double2__Line_1,
	EApiId_List_pane_elements__setting_double2__Line_2,
	EApiId_List_pane_elements__setting_double2__Line_3,
	EApiId_List_pane_elements__setting_double2__Limits,
	EApiId_List_pane_elements__setting_double2_,
	EApiId_List_pane_lines__A_column__Line_1,
	EApiId_List_pane_lines__A_column__Line_2,
	EApiId_List_pane_lines__AB_columns__Line_1,
	EApiId_List_pane_lines__AB_columns__Line_2,
	EApiId_List_pane_lines__BC_columns__Line_1,
	EApiId_List_pane_lines__BC_columns__Line_2,
	EApiId_List_pane_highlight_graphics__various__Line_1,
	EApiId_List_pane_highlight_graphics__various__Line_2,
	EApiId_List_pane_highlight_graphics__various__Line_3,
	EApiId_List_pane_highlight_graphics__various__SUB_TABLE_0_Limits,
	EApiId_List_pane_highlight_graphics__various__SUB_TABLE_0,
	EApiId_List_pane_highlight_graphics__setting_number__Line_1,
	EApiId_List_pane_highlight_graphics__setting_number__Line_2,
	EApiId_List_pane_highlight_graphics__setting_number__Line_3,
	EApiId_List_pane_highlight_graphics__setting_number__SUB_TABLE_0_Limits,
	EApiId_List_pane_highlight_graphics__setting_number__SUB_TABLE_0,
	EApiId_Find_pane_elements_Line_1,
	EApiId_Find_pane_elements_Line_2,
	EApiId_Find_pane_elements_Line_3,
	EApiId_Find_pane_elements_Line_4,
	EApiId_Find_pane_elements_Line_5,
	EApiId_Find_pane_elements_Limits,
	EApiId_Find_pane_elements,
	EApiId_Find_pane_texts_Line_1,
	EApiId_form_field_data_pane,
	EApiId_form_field_data_wide_pane,
	EApiId_form_field_popup_pane,
	EApiId_form_field_popup_wide_pane,
	EApiId_form_field_slider_pane,
	EApiId_form_field_slider_wide_pane,
	EApiId_Form_descendant_panes_Limits,
	EApiId_Form_descendant_panes,
	EApiId_Form_data_field_elements_Line_1,
	EApiId_Form_data_field_elements_Line_2,
	EApiId_Form_data_field_elements_Line_3,
	EApiId_Form_data_field_elements_Line_4,
	EApiId_Form_data_field_texts_Line_1,
	EApiId_Multiline_Form_data_field_texts_Line_1,
	EApiId_Form_data_field_texts_Line_2,
	EApiId_Multiline_Form_data_field_texts_Line_2,
	EApiId_Form_data_wide_field_elements_Line_1,
	EApiId_Form_data_wide_field_elements_Line_2,
	EApiId_Form_data_wide_field_elements_Line_3,
	EApiId_Form_data_wide_field_elements_Line_4,
	EApiId_Form_data_wide_field_texts_Line_1,
	EApiId_Form_data_wide_field_texts_Line_2,
	EApiId_Multiline_Form_data_wide_field_texts_Line_2,
	EApiId_Form_pop_up_field_elements_and_descendants_Line_1,
	EApiId_Form_pop_up_field_elements_and_descendants_Line_2,
	EApiId_Form_pop_up_field_elements_and_descendants_Line_3,
	EApiId_Form_pop_up_field_elements_and_descendants_Line_4,
	EApiId_Form_pop_up_field_elements_and_descendants_Line_5,
	EApiId_list_form_pane,
	EApiId_list_form_graphic_pane,
	EApiId_List_pane_elements__form_graphic__Line_1,
	EApiId_List_pane_elements__form_graphic__Line_2,
	EApiId_List_pane_texts__form_graphic__Line_1,
	EApiId_Form_pop_up_wide_field_elements_and_descendants_Line_1,
	EApiId_Form_pop_up_wide_field_elements_and_descendants_Line_2,
	EApiId_Form_pop_up_wide_field_elements_and_descendants_Line_3,
	EApiId_Form_pop_up_wide_field_elements_and_descendants_Line_4,
	EApiId_Form_pop_up_wide_field_elements_and_descendants_Line_5,
	EApiId_list_form_wide_pane,
	EApiId_list_form_graphic_wide_pane,
	EApiId_List_pane_elements__form_graphic_wide__Line_1,
	EApiId_List_pane_elements__form_graphic_wide__Line_2,
	EApiId_List_pane_texts__form_graphic_wide__Line_1,
	EApiId_Form_slider_field_elements_and_descendants_Line_1,
	EApiId_Form_slider_field_elements_and_descendants_Line_2,
	EApiId_Form_slider_field_elements_and_descendants_Line_3,
	EApiId_Form_slider_field_elements_and_descendants_Line_4,
	EApiId_Form_slider_field_elements_and_descendants_Line_5,
	EApiId_Form_slider_field_elements_and_descendants_Line_6,
	EApiId_Slider_pane_elements__form__Line_1,
	EApiId_Slider_pane_elements__form__Line_2,
	EApiId_Slider_pane_elements__form__Limits,
	EApiId_Slider_pane_elements__form_,
	EApiId_Form_slider_field_texts_Line_1,
	EApiId_Form_slider_field_texts_Line_2,
	EApiId_Form_slider_field_texts_Line_3,
	EApiId_Multiline_Form_slider_field_texts_Line_3,
	EApiId_Form_slider_field_texts_SUB_TABLE_0_Limits,
	EApiId_Form_slider_field_texts_SUB_TABLE_0,
	EApiId_Form_slider_field_elements_and_descendants_dup_Line_1,
	EApiId_Form_slider_field_elements_and_descendants_dup_Line_2,
	EApiId_Form_slider_field_elements_and_descendants_dup_Line_3,
	EApiId_Form_slider_field_elements_and_descendants_dup_Line_4,
	EApiId_Form_slider_field_elements_and_descendants_dup_Line_5,
	EApiId_Form_slider_field_elements_and_descendants_dup_Line_6,
	EApiId_Slider_pane_elements__form__dup_Line_1,
	EApiId_Slider_pane_elements__form__dup_Line_2,
	EApiId_Slider_pane_elements__form__dup_Limits,
	EApiId_Slider_pane_elements__form__dup,
	EApiId_Form_slider_field_texts_dup_Line_1,
	EApiId_Form_slider_field_texts_dup_Line_2,
	EApiId_Form_slider_field_texts_dup_Line_3,
	EApiId_Multiline_Form_slider_field_texts_dup_Line_3,
	EApiId_Form_slider_field_texts_dup_SUB_TABLE_0_Limits,
	EApiId_Form_slider_field_texts_dup_SUB_TABLE_0,
	EApiId_Cursor_graphics__13__Line_1,
	EApiId_Predictive_text_input_graphics__13__Line_1,
	EApiId_Predictive_text_input_graphics__13__Line_2,
	EApiId_Predictive_text_input_graphics__13__Limits,
	EApiId_Predictive_text_input_graphics__13_,
	EApiId_Cut_copy_and_paste_highlight_graphics__13__Line_1,
	EApiId_Time_and_date_entry_graphics__13__Line_1,
	EApiId_Cursor_graphics__12__Line_1,
	EApiId_Predictive_text_input_graphics__12__Line_1,
	EApiId_Predictive_text_input_graphics__12__Line_2,
	EApiId_Predictive_text_input_graphics__12__Limits,
	EApiId_Predictive_text_input_graphics__12_,
	EApiId_Cut_copy_and_paste_highlight_graphics__12__Line_1,
	EApiId_Time_and_date_entry_graphics__12__Line_1,
	EApiId_list_set_graphic_pane,
	EApiId_List_pane_elements__set_graphic__Line_1,
	EApiId_List_pane_elements__set_graphic__Line_2,
	EApiId_List_pane_elements__set_graphic__Line_3,
	EApiId_List_pane_elements__set_graphic__SUB_TABLE_0_Limits,
	EApiId_List_pane_elements__set_graphic__SUB_TABLE_0,
	EApiId_List_pane_texts__set_graphic__Line_1,
	EApiId_Application_grid_descendant_Line_1,
	EApiId_Cell_pane_elements__app__Line_1,
	EApiId_Cell_pane_elements__app__Line_2,
	EApiId_Cell_pane_elements__app__Limits,
	EApiId_Cell_pane_elements__app_,
	EApiId_Cell_pane_texts__app__Line_1,
	EApiId_Cell_pane_highlight_elements__various__Line_1,
	EApiId_Wallpaper_pane_element_Line_1,
	EApiId_Indicator_pane_elements_Line_1,
	EApiId_Soft_indicator_pane_elements_Line_1,
	EApiId_Soft_indicator_pane_texts_Line_1,
	EApiId_Multiline_Soft_indicator_pane_texts_Line_1,
	EApiId_power_save_pane,
	EApiId_Power_save_pane_descendants_Line_1,
	EApiId_Power_save_pane_descendants_Line_2,
	EApiId_Power_save_pane_descendants_Line_3,
	EApiId_Power_save_pane_descendants_Limits,
	EApiId_Power_save_pane_descendants,
	EApiId_Idle_power_save_state_texts_Line_1,
	EApiId_Idle_power_save_state_texts_Line_2,
	EApiId_Idle_power_save_state_texts_Line_3,
	EApiId_Idle_power_save_state_texts_Line_4,
	EApiId_Idle_power_save_state_texts_Limits,
	EApiId_Idle_power_save_state_texts,
	EApiId_grid_app_pane,
	EApiId_Empty_list_texts_Line_1,
	EApiId_Multiline_Empty_list_texts_Line_1,
	EApiId_Empty_list_texts__find__Line_1,
	EApiId_Multiline_Empty_list_texts__find__Line_1,
	EApiId_List_pane_elements_and_descendants__settings_edited__Line_1,
	EApiId_List_pane_elements_and_descendants__settings_edited__Line_2,
	EApiId_list_set_pane,
	EApiId_List_pane_elements_and_descendants__settings_edited__Line_4,
	EApiId_setting_volume_pane,
	EApiId_setting_slider_pane,
	EApiId_setting_slider_graphic_pane,
	EApiId_setting_text_pane,
	EApiId_setting_code_pane,
	EApiId_Setting_item_texts_Line_1,
	EApiId_Setting_item_texts_Line_2,
	EApiId_Setting_volume_pane_elements_Line_1,
	EApiId_Setting_volume_pane_elements_Line_2,
	EApiId_Setting_volume_pane_elements_Line_3,
	EApiId_Setting_volume_pane_elements_Line_4,
	EApiId_Setting_volume_pane_elements_Line_5,
	EApiId_Setting_volume_pane_elements_Line_6,
	EApiId_Setting_volume_pane_elements_Line_7,
	EApiId_Setting_volume_pane_elements_Line_8,
	EApiId_Setting_volume_pane_elements_Line_9,
	EApiId_Setting_volume_pane_elements_Line_10,
	EApiId_Setting_volume_pane_elements_Line_11,
	EApiId_Setting_volume_pane_elements_SUB_TABLE_0_Limits,
	EApiId_Setting_volume_pane_elements_SUB_TABLE_0,
	EApiId_Setting_slider_pane_elements_and_descendants_Line_1,
	EApiId_Setting_slider_pane_elements_and_descendants_Line_2,
	EApiId_Setting_slider_pane_elements_and_descendants_Limits,
	EApiId_Setting_slider_pane_elements_and_descendants,
	EApiId_Slider_pane_elements_Line_1,
	EApiId_Slider_pane_elements_Line_2,
	EApiId_Slider_pane_elements_Limits,
	EApiId_Slider_pane_elements,
	EApiId_Slider_texts__set__Line_1,
	EApiId_Slider_texts__set__Line_2,
	EApiId_Multiline_Slider_texts__set__Line_2,
	EApiId_Setting_slider_pane__graphic__elements_and_descendants_Line_1,
	EApiId_Setting_slider_pane__graphic__elements_and_descendants_Line_2,
	EApiId_Setting_slider_pane__graphic__elements_and_descendants_Line_3,
	EApiId_Setting_slider_pane__graphic__elements_and_descendants_Limits,
	EApiId_Setting_slider_pane__graphic__elements_and_descendants,
	EApiId_Slider_with_graphic_texts__set__Line_1,
	EApiId_Multiline_Slider_with_graphic_texts__set__Line_1,
	EApiId_Setting_text_pane_elements_Line_1,
	EApiId_Setting_text_pane_elements_Line_2,
	EApiId_Setting_text_pane_elements_Line_3,
	EApiId_Setting_text_pane_elements_Line_4,
	EApiId_Setting_text_pane_elements_Limits,
	EApiId_Setting_text_pane_elements,
	EApiId_Setting_text_pane_texts_Line_1,
	EApiId_Multiline_Setting_text_pane_texts_Line_1,
	EApiId_Code_time_and_date_entry_pane_elements_Line_1,
	EApiId_Code_time_and_date_entry_pane_elements_Line_2,
	EApiId_Code_time_and_date_entry_pane_elements_Line_3,
	EApiId_Code_time_and_date_entry_pane_elements_Limits,
	EApiId_Code_time_and_date_entry_pane_elements,
	EApiId_Code_time_and_date_entry_pane_texts_Line_1,
	EApiId_Control_pane_elements_Line_1,
	EApiId_Control_pane_elements_Line_2,
	EApiId_Control_pane_elements_Line_3,
	EApiId_Control_pane_elements_Line_4,
	EApiId_Control_pane_elements_Limits,
	EApiId_Control_pane_elements,
	EApiId_Control_pane_texts_Line_1,
	EApiId_Control_pane_texts_Line_2,
	EApiId_Control_pane_texts_Limits,
	EApiId_Control_pane_texts,
	EApiId_popup_menu_window,
	EApiId_Pop_up_windows__main_pane_as_parent__Line_2,
	EApiId_popup_menu_graphic_window,
	EApiId_popup_menu_graphic_heading_window,
	EApiId_popup_menu_double_window,
	EApiId_popup_menu_double_large_graphic_window,
	EApiId_popup_note_window,
	EApiId_popup_note_wait_window,
	EApiId_popup_note_image_window,
	EApiId_popup_query_data_window,
	EApiId_popup_query_code_window,
	EApiId_popup_query_time_window,
	EApiId_popup_query_date_window,
	EApiId_popup_query_data_code_window,
	EApiId_popup_find_window,
	EApiId_popup_snote_single_text_window,
	EApiId_popup_snote_single_graphic_window,
	EApiId_popup_snote_group_window,
	EApiId_popup_grid_graphic_window,
	EApiId_popup_menu_double2_window,
	EApiId_popup_grid_large_graphic_colour_window,
	EApiId_popup_fast_swap_window,
	EApiId_list_single_popup_menu_pane,
	EApiId_list_single_heading_popup_menu_pane,
	EApiId_list_single_graphic_popup_menu_pane,
	EApiId_list_single_graphic_heading_popup_menu_pane,
	EApiId_list_menu_double_popup_menu_pane,
	EApiId_list_single_popup_submenu_pane,
	EApiId_list_double_large_graphic_popup_menu_pane,
	EApiId_Pop_up_window_list_pane_descendants_Line_8,
	EApiId_list_double2_popup_menu_pane,
	EApiId_List_pane_elements__menu_single__Line_1,
	EApiId_List_pane_elements__menu_single__Line_2,
	EApiId_List_pane_elements__menu_single__Line_3,
	EApiId_List_pane_elements__menu_single__SUB_TABLE_0_Limits,
	EApiId_List_pane_elements__menu_single__SUB_TABLE_0,
	EApiId_List_pane_texts__menu_single__Line_1,
	EApiId_List_pane_text__submenu_single__Line_1,
	EApiId_List_pane_elements__menu_single_graphic__Line_1,
	EApiId_List_pane_elements__menu_single_graphic__Line_2,
	EApiId_List_pane_texts__menu_single_graphic__Line_1,
	EApiId_List_pane_elements__menu_single_heading__Line_1,
	EApiId_List_pane_elements__menu_single_heading__Line_2,
	EApiId_List_pane_texts__menu_single_heading__Line_1,
	EApiId_List_pane_texts__menu_single_heading__Line_2,
	EApiId_List_pane_elements__menu_single_graphic_heading__Line_1,
	EApiId_List_pane_elements__menu_single_graphic_heading__Line_2,
	EApiId_List_pane_elements__menu_single_graphic_heading__Line_3,
	EApiId_List_pane_texts__menu_single_graphic_heading__Line_1,
	EApiId_List_pane_texts__menu_single_graphic_heading__Line_2,
	EApiId_List_pane_texts__menu_single_graphic_heading__Limits,
	EApiId_List_pane_texts__menu_single_graphic_heading_,
	EApiId_List_pane_elements__menu_double__Line_1,
	EApiId_List_pane_texts__menu_double__Line_1,
	EApiId_List_pane_texts__menu_double__Line_2,
	EApiId_List_pane_elements__menu_double2__Line_1,
	EApiId_List_pane_texts__menu_double2__Line_1,
	EApiId_List_pane_texts__menu_double2__Line_2,
	EApiId_List_pane_elements__menu_double_large_graphic__Line_1,
	EApiId_List_pane_elements__menu_double_large_graphic__Line_2,
	EApiId_List_pane_texts__menu_double_large_graphic__Line_1,
	EApiId_List_pane_texts__menu_double_large_graphic__Line_2,
	EApiId_Highlight_graphics__various__Line_1,
	EApiId_Highlight_graphics__various__Line_2,
	EApiId_Highlight_graphics__various__Limits,
	EApiId_Highlight_graphics__various_,
	EApiId_cell_graphic_popup_pane,
	EApiId_Cell_pane_elements__pop_up_graphic__Line_1,
	EApiId_Cell_pane_texts__pop_up_graphic__Line_1,
	EApiId_cell_large_graphic_colour_popup_pane,
	EApiId_colour,
	EApiId_Pop_up_window_cell_pane__large_graphic_colour_none__Line_1,
	EApiId_Cell_pane_texts__pop_up_large_graphic_colour_none__Line_1,
	EApiId_Highlight_elements__grid_pop_up__Line_1,
	EApiId_Highlight_elements__grid_pop_up__Line_2,
	EApiId_Highlight_elements__grid_pop_up__Limits,
	EApiId_Highlight_elements__grid_pop_up_,
	EApiId_List_heading_pane_elements_Line_1,
	EApiId_List_heading_pane_elements_Line_2,
	EApiId_List_heading_pane_elements_Limits,
	EApiId_List_heading_pane_elements,
	EApiId_List_heading_pane_texts_Line_1,
	EApiId_Pop_up_menu_with_heading_window_graphics_Line_1,
	EApiId_Pop_up_menu_with_heading_window_graphics_Line_2,
	EApiId_Pop_up_menu_with_heading_window_graphics_Line_3,
	EApiId_Pop_up_menu_with_heading_window_graphics_Line_4,
	EApiId_Pop_up_menu_with_heading_window_graphics_Line_5,
	EApiId_Pop_up_menu_with_heading_window_graphics_Limits,
	EApiId_Pop_up_menu_with_heading_window_graphics,
	EApiId_list_menu_pane,
	EApiId_Menu_pop_up_window_descendants_Line_2,
	EApiId_Menu_pop_up_window_graphics_Line_1,
	EApiId_Menu_pop_up_window_graphics_Line_2,
	EApiId_Menu_pop_up_window_graphics_Line_3,
	EApiId_Menu_pop_up_window_graphics_Line_4,
	EApiId_Menu_pop_up_window_graphics_Line_5,
	EApiId_Menu_pop_up_window_graphics_Limits,
	EApiId_Menu_pop_up_window_graphics,
	EApiId_list_submenu_pane,
	EApiId_Submenu_pop_up_window_graphics_Line_1,
	EApiId_Submenu_pop_up_window_graphics_Line_2,
	EApiId_Submenu_pop_up_window_graphics_Line_3,
	EApiId_Submenu_pop_up_window_graphics_Line_4,
	EApiId_Submenu_pop_up_window_graphics_Limits,
	EApiId_Submenu_pop_up_window_graphics,
	EApiId_Submenu_pop_up_window_positioning_Line_1,
	EApiId_Submenu_pop_up_window_positioning_Line_2,
	EApiId_Submenu_pop_up_window_positioning_Limits,
	EApiId_Submenu_pop_up_window_positioning,
	EApiId_list_menu_graphic_pane,
	EApiId_list_menu_heading_pane,
	EApiId_Menu_pop_up_window_descendants__single_heading__Line_2,
	EApiId_Menu_pop_up_window_descendants__single_heading__Line_3,
	EApiId_list_menu_graphic_heading_pane,
	EApiId_Menu_pop_up_window_descendants_and_elements__single_graphic_heading__Line_2,
	EApiId_Menu_pop_up_window_descendants_and_elements__single_graphic_heading__Line_3,
	EApiId_list_menu_double_pane_list_menu_double2_pane,
	EApiId_Menu_pop_up_window_descendants__double_double2__Line_2,
	EApiId_list_menu_double_large_graphic_pane,
	EApiId_Menu_pop_up_window_descendants__double__Line_2,
	EApiId_Note_pop_up_window_elements_Line_1,
	EApiId_Note_pop_up_window_texts_Line_1,
	EApiId_Multiline_Note_pop_up_window_texts_Line_1,
	EApiId_Note_pop_up_window_graphics_Line_1,
	EApiId_Note_pop_up_window_graphics_Line_2,
	EApiId_Note_pop_up_window_graphics_Line_3,
	EApiId_Note_pop_up_window_graphics_Line_4,
	EApiId_Note_pop_up_window_graphics_Line_5,
	EApiId_Note_pop_up_window_graphics_Limits,
	EApiId_Note_pop_up_window_graphics,
	EApiId_Wait_or_progress_note_pop_up_window_elements_Line_1,
	EApiId_Wait_or_progress_note_pop_up_window_elements_Line_2,
	EApiId_Wait_or_progress_note_pop_up_window_elements_Line_3,
	EApiId_Wait_or_progress_note_pop_up_window_elements_Line_4,
	EApiId_First_general_event_elements_Limits,
	EApiId_First_general_event_elements,
	EApiId_Wait_or_progress_note_pop_up_window_texts_Line_1,
	EApiId_Multiline_Wait_or_progress_note_pop_up_window_texts_Line_1,
	EApiId_Note_with_an_image_pop_up_window_elements_Line_1,
	EApiId_Note_with_an_image_pop_up_window_elements_Line_2,
	EApiId_Note_with_an_image_pop_up_window_elements_Line_3,
	EApiId_Note_with_an_image_pop_up_window_elements_Line_4,
	EApiId_Note_with_an_image_pop_up_window_elements_Line_5,
	EApiId_Note_with_an_image_pop_up_window_elements_Line_6,
	EApiId_Note_with_an_image_pop_up_window_elements_Line_7,
	EApiId_Note_with_an_image_pop_up_window_elements_Line_8,
	EApiId_Note_with_an_image_pop_up_window_elements_Line_9,
	EApiId_Note_with_an_image_pop_up_window_elements_Line_10,
	EApiId_Note_with_an_image_pop_up_window_elements_Line_11,
	EApiId_Note_with_an_image_pop_up_window_elements_Line_12,
	EApiId_Note_with_an_image_pop_up_window_elements_Line_13,
	EApiId_Note_with_an_image_pop_up_window_elements_Limits,
	EApiId_Note_with_an_image_pop_up_window_elements,
	EApiId_Note_with_an_image_pop_up_window_texts_Line_1,
	EApiId_Multiline_Note_with_an_image_pop_up_window_texts_Line_1,
	EApiId_Query_with_heading_window_graphics_Line_1,
	EApiId_Query_with_heading_window_graphics_Line_2,
	EApiId_Query_with_heading_window_graphics_Line_3,
	EApiId_Query_with_heading_window_graphics_Line_4,
	EApiId_Query_with_heading_window_graphics_Line_5,
	EApiId_Query_with_heading_window_graphics_Limits,
	EApiId_Query_with_heading_window_graphics,
	EApiId_popup_list_heading_pane,
	EApiId_Heading_pane_elements_Line_1,
	EApiId_Icon,
	EApiId_Heading_pane_texts_Line_1,
	EApiId_Data_query_pop_up_window_elements_Line_1,
	EApiId_Data_query_pop_up_window_elements_Line_2,
	EApiId_Data_query_pop_up_window_elements_Line_3,
	EApiId_Data_query_pop_up_window_elements_Line_4,
	EApiId_Data_query_pop_up_window_elements_Line_5,
	EApiId_Data_query_pop_up_window_texts_Line_1,
	EApiId_Multiline_Data_query_pop_up_window_texts_Line_1,
	EApiId_Data_query_pop_up_window_texts_Line_2,
	EApiId_Multiline_Data_query_pop_up_window_texts_Line_2,
	EApiId_Data_query_pop_up_window_graphics_Line_1,
	EApiId_Data_query_pop_up_window_graphics_Line_2,
	EApiId_Data_query_pop_up_window_graphics_Line_3,
	EApiId_Data_query_pop_up_window_graphics_Line_4,
	EApiId_Data_query_pop_up_window_graphics_Line_5,
	EApiId_Data_query_pop_up_window_graphics_Limits,
	EApiId_Data_query_pop_up_window_graphics,
	EApiId_Code_query_pop_up_window_elements_Line_1,
	EApiId_Code_query_pop_up_window_elements_Line_2,
	EApiId_Code_query_pop_up_window_elements_Line_3,
	EApiId_Code_query_pop_up_window_elements_Line_4,
	EApiId_Code_query_pop_up_window_elements_Limits,
	EApiId_Code_query_pop_up_window_elements,
	EApiId_Code_query_pop_up_window_texts_Line_1,
	EApiId_Multiline_Code_query_pop_up_window_texts_Line_1,
	EApiId_Code_query_pop_up_window_texts_Line_2,
	EApiId_Multiline_Code_query_pop_up_window_texts_Line_2,
	EApiId_Code_query_pop_up_window_texts_Limits,
	EApiId_Code_query_pop_up_window_texts,
	EApiId_Combined_data_and_code_query_pop_up_window_elements_Line_1,
	EApiId_Combined_data_and_code_query_pop_up_window_elements_Line_2,
	EApiId_Combined_data_and_code_query_pop_up_window_elements_Line_3,
	EApiId_Combined_data_and_code_query_pop_up_window_elements_Line_4,
	EApiId_Combined_data_and_code_query_pop_up_window_elements_Line_5,
	EApiId_Combined_data_and_code_query_pop_up_window_texts_Line_1,
	EApiId_Multiline_Combined_data_and_code_query_pop_up_window_texts_Line_1,
	EApiId_Combined_data_and_code_query_pop_up_window_texts_Line_2,
	EApiId_Multiline_Combined_data_and_code_query_pop_up_window_texts_Line_2,
	EApiId_Combined_data_and_code_query_pop_up_window_texts_Line_3,
	EApiId_Multiline_Combined_data_and_code_query_pop_up_window_texts_Line_3,
	EApiId_Combined_data_and_code_query_pop_up_window_texts_Line_4,
	EApiId_Multiline_Combined_data_and_code_query_pop_up_window_texts_Line_4,
	EApiId_Combined_data_and_code_query_pop_up_window_texts_Limits,
	EApiId_Combined_data_and_code_query_pop_up_window_texts,
	EApiId_Combined_data_and_code_query_pop_up_window_graphics_Line_1,
	EApiId_Combined_data_and_code_query_pop_up_window_graphics_Line_2,
	EApiId_Combined_data_and_code_query_pop_up_window_graphics_Line_3,
	EApiId_Combined_data_and_code_query_pop_up_window_graphics_Line_4,
	EApiId_Combined_data_and_code_query_pop_up_window_graphics_Line_5,
	EApiId_Combined_data_and_code_query_pop_up_window_graphics_SUB_TABLE_0_Limits,
	EApiId_Combined_data_and_code_query_pop_up_window_graphics_SUB_TABLE_0,
	EApiId_Find_pop_up_window_elements_Line_1,
	EApiId_Find_pop_up_window_elements_Line_2,
	EApiId_Find_pop_up_window_elements_Line_3,
	EApiId_Find_pop_up_window_elements_Line_4,
	EApiId_Find_pop_up_window_elements_Limits,
	EApiId_Find_pop_up_window_elements,
	EApiId_Find_pop_up_window_texts_Line_1,
	EApiId_Find_pop_up_window_graphics_Line_1,
	EApiId_Find_pop_up_window_graphics_Line_2,
	EApiId_Find_pop_up_window_graphics_Line_3,
	EApiId_Find_pop_up_window_graphics_Line_4,
	EApiId_Find_pop_up_window_graphics_Line_5,
	EApiId_Find_pop_up_window_graphics_Limits,
	EApiId_Find_pop_up_window_graphics,
	EApiId_Pop_up_menu_with_find_pane_graphics_Line_1,
	EApiId_Pop_up_menu_with_find_pane_graphics_Line_2,
	EApiId_Pop_up_menu_with_find_pane_graphics_Line_3,
	EApiId_Pop_up_menu_with_find_pane_graphics_Line_4,
	EApiId_Pop_up_menu_with_find_pane_graphics_Line_5,
	EApiId_Pop_up_menu_with_find_pane_graphics_Limits,
	EApiId_Pop_up_menu_with_find_pane_graphics,
	EApiId_Notification_pop_up_window_elements__text__Line_1,
	EApiId_Notification_pop_up_window_texts__text__Line_1,
	EApiId_Multiline_Notification_pop_up_window_texts__text__Line_1,
	EApiId_Notification_pop_up_window_graphics__text__Line_1,
	EApiId_Notification_pop_up_window_graphics__text__Line_2,
	EApiId_Notification_pop_up_window_graphics__text__Line_3,
	EApiId_Notification_pop_up_window_graphics__text__Line_4,
	EApiId_Notification_pop_up_window_graphics__text__Line_5,
	EApiId_Notification_pop_up_window_graphics__text__Limits,
	EApiId_Notification_pop_up_window_graphics__text_,
	EApiId_Notification_pop_up_window_elements__graphic__Line_1,
	EApiId_Notification_pop_up_window_elements__graphic__Line_2,
	EApiId_Notification_pop_up_window_elements__graphic__Limits,
	EApiId_Notification_pop_up_window_elements__graphic_,
	EApiId_Notification_pop_up_window_texts__graphic__Line_1,
	EApiId_Multiline_Notification_pop_up_window_texts__graphic__Line_1,
	EApiId_Identifier_icon_selection_pop_up_window_descendants_Line_1,
	EApiId_grid_graphic_popup_pane,
	EApiId_Identifier_icon_selection_pop_up_window_elements_Line_1,
	EApiId_Identifier_icon_selection_pop_up_window_elements_Line_2,
	EApiId_Identifier_icon_selection_pop_up_window_graphics_Line_1,
	EApiId_Identifier_icon_selection_pop_up_window_graphics_Line_2,
	EApiId_Identifier_icon_selection_pop_up_window_graphics_Line_3,
	EApiId_Identifier_icon_selection_pop_up_window_graphics_Line_4,
	EApiId_Identifier_icon_selection_pop_up_window_graphics_Line_5,
	EApiId_Identifier_icon_selection_pop_up_window_graphics_SUB_TABLE_0_Limits,
	EApiId_Identifier_icon_selection_pop_up_window_graphics_SUB_TABLE_0,
	EApiId_Colour_selection_pop_up_window_descendants_Line_1,
	EApiId_Colour_selection_pop_up_window_descendants_Line_2,
	EApiId_grid_large_graphic_colour_popup_pane,
	EApiId_Composer_symbol_selection_pop_up_window_elements_Line_1,
	EApiId_Composer_symbol_selection_pop_up_window_elements_Line_2,
	EApiId_Colour_selection_pop_up_window_graphics_Line_1,
	EApiId_Colour_selection_pop_up_window_graphics_Line_2,
	EApiId_Colour_selection_pop_up_window_graphics_Line_3,
	EApiId_Colour_selection_pop_up_window_graphics_Line_4,
	EApiId_Colour_selection_pop_up_window_graphics_Line_5,
	EApiId_Colour_selection_pop_up_window_graphics_Limits,
	EApiId_Colour_selection_pop_up_window_graphics,
	EApiId_Fast_application_swapping_pop_up_window_descendants_Line_1,
	EApiId_Fast_application_swapping_pop_up_window_graphics_Line_1,
	EApiId_Fast_application_swapping_pop_up_window_graphics_Line_2,
	EApiId_Fast_application_swapping_pop_up_window_graphics_Line_3,
	EApiId_Fast_application_swapping_pop_up_window_graphics_Line_4,
	EApiId_Fast_application_swapping_pop_up_window_graphics_Line_5,
	EApiId_Fast_application_swapping_pop_up_window_graphics_Line_6,
	EApiId_Fast_application_swapping_pop_up_window_graphics_SUB_TABLE_0_Limits,
	EApiId_Fast_application_swapping_pop_up_window_graphics_SUB_TABLE_0,
	EApiId_List_pane_texts__setting__double2__Line_1,
	EApiId_List_pane_texts__setting__double2__Line_2,
	EApiId_List_pane_texts__setting__double2__Limits,
	EApiId_List_pane_texts__setting__double2_,
	EApiId_List_pane_elements__single_2graphic__Line_1,
	EApiId_List_pane_elements__single_2graphic__Line_2,
	EApiId_List_pane_elements__single_2graphic__Line_3,
	EApiId_List_pane_elements__single_2graphic__Line_4,
	EApiId_List_pane_elements__single_2graphic__SUB_TABLE_0_Limits,
	EApiId_List_pane_elements__single_2graphic__SUB_TABLE_0,
	EApiId_List_pane_texts__single_2graphic__Line_1,
	EApiId_List_pane_elements__double2_graphic_large_graphic__Line_1,
	EApiId_List_pane_elements__double2_graphic_large_graphic__Line_2,
	EApiId_List_pane_elements__double2_graphic_large_graphic__Line_3,
	EApiId_List_pane_elements__double2_graphic_large_graphic__Line_4,
	EApiId_List_pane_elements__double2_graphic_large_graphic__SUB_TABLE_0_Limits,
	EApiId_List_pane_elements__double2_graphic_large_graphic__SUB_TABLE_0,
	EApiId_List_pane_texts__double2_graphic_large_graphic__Line_1,
	EApiId_List_pane_texts__double2_graphic_large_graphic__Line_2,
	EApiId_Form_data_wide_graphic_field_texts_Line_1,
	EApiId_Form_data_wide_graphic_field_texts_Line_2,
	EApiId_Multiline_Form_data_wide_graphic_field_texts_Line_2,
	EApiId_status_small_pane,
	EApiId_Small_status_pane_descendants_and_elements_Line_1,
	EApiId_status_small_icon_pane,
	EApiId_status_small_wait_pane,
	EApiId_Small_status_pane_descendants_and_elements_Line_4,
	EApiId_Small_status_pane_descendants_and_elements_Line_5,
	EApiId_Small_status_pane_descendants_and_elements_Line_6,
	EApiId_Small_status_pane_descendants_and_elements_Limits,
	EApiId_Small_status_pane_descendants_and_elements,
	EApiId_Small_status_pane_texts_Line_1,
	EApiId_Small_status_waiting_pane_components_Line_1,
	EApiId_Small_status_waiting_pane_components_Line_2,
	EApiId_Small_status_waiting_pane_components_Line_3,
	EApiId_Small_status_waiting_pane_components_Line_4,
	EApiId_Small_status_waiting_pane_components_Limits,
	EApiId_Small_status_waiting_pane_components,
	EApiId_Note_with_additional_information_popup_window_elements_Line_1,
	EApiId_Note_with_additional_information_popup_window_elements_Line_2,
	EApiId_Note_with_additional_information_popup_window_elements_Line_3,
	EApiId_Note_with_additional_information_popup_window_texts_Line_1,
	EApiId_Multiline_Note_with_additional_information_popup_window_texts_Line_1,
	EApiId_Note_with_additional_information_popup_window_texts_Line_2,
	EApiId_Multiline_Note_with_additional_information_popup_window_texts_Line_2,
	EApiId_Note_with_additional_information_popup_window_texts_Line_3,
	EApiId_Multiline_Note_with_additional_information_popup_window_texts_Line_3,
	EApiId_Heading_pane_texts_Line_2,
	EApiId_Side_volume_key_popup_window_elements_Line_1,
	EApiId_Side_volume_key_popup_window_elements_Line_2,
	EApiId_Side_volume_key_popup_window_texts_Line_1,
	EApiId_Side_volume_key_popup_window_texts_Line_2,
	EApiId_Side_volume_key_popup_window_background_Line_1,
	EApiId_Side_volume_key_popup_window_background_Line_2,
	EApiId_Side_volume_key_popup_window_background_Line_3,
	EApiId_Side_volume_key_popup_window_background_Line_4,
	EApiId_Transparent_setting_item_texts_Line_1,
	EApiId_Transparent_setting_item_texts_Line_2,
	EApiId_Transparent_setting_item_texts_Line_3,
	EApiId_Transparent_setting_item_texts_Line_4,
	EApiId_List_pane_texts__set_trans_graphic__Line_1,
	EApiId_List_pane_texts__set_trans_graphic__Line_2,
	EApiId_list_set_trans_pane,
	EApiId_list_set_trans_graphic_pane,
	EApiId_List_pane_elements__set_trans_graphic__Line_1,
	EApiId_List_pane_elements__set_trans_graphic__Line_2,
	EApiId_List_pane_elements__set_trans_graphic__Line_3,
	EApiId_List_pane_elements__set_trans_graphic__Line_4,
	EApiId_List_pane_elements__set_trans_graphic__Line_5,
	EApiId_Soft_indicator_texts_Line_1,
	EApiId_ai_links_pane,
	EApiId_ai_gene_pane,
	EApiId_Link_pane_elements_and_descendant_panes_Line_1,
	EApiId_grid_ai_links_pane,
	EApiId_Link_pane_elements_and_descendant_panes_Limits,
	EApiId_Link_pane_elements_and_descendant_panes,
	EApiId_cell_ai_link_pane,
	EApiId_Link_shortcut_cell_pane_elements_Line_1,
	EApiId_Link_shortcut_cell_pane_elements_Line_2,
	EApiId_Link_shortcut_cell_pane_elements_Line_3,
	EApiId_Link_shortcut_cell_pane_elements_Line_4,
	EApiId_Link_shortcut_cell_pane_elements_Limits,
	EApiId_Link_shortcut_cell_pane_elements,
	EApiId_popup_ai_links_title_window,
	EApiId_Link_shortcut_title_texts_Line_1,
	EApiId_Link_shortcut_title_pop_up_window_graphics_Line_1,
	EApiId_Link_shortcut_title_pop_up_window_graphics_Line_2,
	EApiId_Link_shortcut_title_pop_up_window_graphics_Line_3,
	EApiId_Link_shortcut_title_pop_up_window_graphics_Line_4,
	EApiId_Link_shortcut_title_pop_up_window_graphics_Limits,
	EApiId_Link_shortcut_title_pop_up_window_graphics,
	EApiId_ai_gene_pane_1,
	EApiId_ai_gene_pane_2,
	EApiId_First_general_event_elements_Line_1,
	EApiId_First_general_event_elements_Line_2,
	EApiId_First_general_event_texts_Line_1,
	EApiId_Second_general_event_pane_texts_Line_1,
	EApiId_Shortcut_link_highlight_Line_1,
	EApiId_Highlight_for_other_Active_Idle_items_Line_1,
	EApiId_Find_pop_up_window_texts_Line_2,
	EApiId_Find_pop_up_window_texts_Limits,
	EApiId_Find_pop_up_window_texts,
	EApiId_Find_pane_texts_Line_2,
	EApiId_Find_pane_texts_Limits,
	EApiId_Find_pane_texts,
	EApiId_ai_gene_pane_3,
	EApiId_Third_general_event_elements_Line_1,
	EApiId_Third_general_event_elements_Line_2,
	EApiId_Third_general_event_elements_Limits,
	EApiId_Third_general_event_elements,
	EApiId_popup_ai_message_window,
	EApiId_Active_idle_message_pop_up_window_descendants_Line_1,
	EApiId_Active_idle_message_pop_up_window_descendants_Line_2,
	EApiId_Active_idle_message_pop_up_window_descendants_Line_3,
	EApiId_Active_idle_message_pop_up_window_descendants_Limits,
	EApiId_Active_idle_message_pop_up_window_descendants,
	EApiId_Active_idle_message_popup_window_texts_Line_1,
	EApiId_Multiline_Active_idle_message_popup_window_texts_Line_1,
	EApiId_Active_idle_heading_pane_elements_Line_1,
	EApiId_Active_idle_heading_pane_elements_Line_2,
	EApiId_Active_idle_heading_pane_elements_Line_3,
	EApiId_Active_idle_heading_pane_elements_Line_4,
	EApiId_Active_idle_heading_pane_elements_Limits,
	EApiId_Active_idle_heading_pane_elements,
	EApiId_Active_idle_heading_pane_texts_Line_1,
	EApiId_Active_idle_heading_pane_texts_Line_2,
	EApiId_Active_idle_message_pop_up_window_graphics_Line_1,
	EApiId_Active_idle_message_pop_up_window_graphics_Line_2,
	EApiId_Active_idle_message_pop_up_window_graphics_Line_3,
	EApiId_Active_idle_message_pop_up_window_graphics_Line_4,
	EApiId_Active_idle_message_pop_up_window_graphics_Line_5,
	EApiId_Active_idle_message_pop_up_window_graphics_Limits,
	EApiId_Active_idle_message_pop_up_window_graphics,
	E_TApiId_TableSize
	};

// This is the CDL interface definition for this interface
const SCdlInterface KCdlInterface =
	{
	KCdlCompilerMajorVersion,
	KCdlCompilerMinorVersion,
	LIT_AS_DESC_PTR(KCdlName),
	{ KCdlInterfaceUidValue },
	KCdlInterfaceMajorVersion,
	KCdlInterfaceMinorVersion,
	KCdlInterfaceFlags,
	E_TApiId_TableSize
	};

// These typedefs define the types for function APIs
typedef TAknWindowLineLayout (Tscreen_sig)();
typedef TAknWindowLineLayout (Tapplication_window_sig)(const TRect&);
typedef TAknWindowLineLayout (Tstatus_pane_sig)(const TRect&, TInt);
typedef TAknWindowLineLayout (Tmain_pane_sig)(const TRect&, TInt, TInt, TInt);
typedef TAknWindowLineLayout (Tcontrol_pane_sig)(const TRect&);
typedef TAknWindowLineLayout (Tsignal_pane_sig)(const TRect&);
typedef TAknWindowLineLayout (Tcontext_pane_sig)(const TRect&, TInt);
typedef TAknWindowLineLayout (Ttitle_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tbattery_pane_sig)(const TRect&);
typedef TAknWindowLineLayout (Tuni_indicator_pane_sig)(const TRect&);
typedef TAknWindowLineLayout (Tnavi_pane_sig)(TInt);
typedef TAknWindowLineLayout (TStatus_pane_elements_Line_1_sig)();
typedef TAknWindowLineLayout (TStatus_pane_elements_Line_2_sig)();
typedef TAknLayoutTableLimits (TStatus_pane_elements_Limits_sig)();
typedef TAknWindowLineLayout (TStatus_pane_elements_sig)(TInt);
typedef TAknWindowLineLayout (TSignal_pane_elements_Line_1_sig)();
typedef TAknWindowLineLayout (TSignal_pane_elements_Line_2_sig)();
typedef TAknLayoutTableLimits (TSignal_pane_elements_Limits_sig)();
typedef TAknWindowLineLayout (TSignal_pane_elements_sig)(TInt);
typedef TAknWindowLineLayout (TSignal_strength_area_values_Line_1_sig)();
typedef TAknWindowLineLayout (TSignal_strength_area_values_Line_2_sig)();
typedef TAknWindowLineLayout (TSignal_strength_area_values_Line_3_sig)();
typedef TAknWindowLineLayout (TSignal_strength_area_values_Line_4_sig)();
typedef TAknWindowLineLayout (TSignal_strength_area_values_Line_5_sig)();
typedef TAknWindowLineLayout (TSignal_strength_area_values_Line_6_sig)();
typedef TAknWindowLineLayout (TSignal_strength_area_values_Line_7_sig)();
typedef TAknWindowLineLayout (TSignal_strength_area_values_Line_8_sig)();
typedef TAknLayoutTableLimits (TSignal_strength_area_values_Limits_sig)();
typedef TAknWindowLineLayout (TSignal_strength_area_values_sig)(TInt);
typedef TAknWindowLineLayout (TBattery_pane_elements_Line_1_sig)();
typedef TAknWindowLineLayout (TBattery_pane_elements_Line_2_sig)();
typedef TAknLayoutTableLimits (TBattery_pane_elements_Limits_sig)();
typedef TAknWindowLineLayout (TBattery_pane_elements_sig)(TInt);
typedef TAknWindowLineLayout (TBattery_strength_area_values_Line_1_sig)();
typedef TAknWindowLineLayout (TBattery_strength_area_values_Line_2_sig)();
typedef TAknWindowLineLayout (TBattery_strength_area_values_Line_3_sig)();
typedef TAknWindowLineLayout (TBattery_strength_area_values_Line_4_sig)();
typedef TAknWindowLineLayout (TBattery_strength_area_values_Line_5_sig)();
typedef TAknWindowLineLayout (TBattery_strength_area_values_Line_6_sig)();
typedef TAknWindowLineLayout (TBattery_strength_area_values_Line_7_sig)();
typedef TAknWindowLineLayout (TBattery_strength_area_values_Line_8_sig)();
typedef TAknLayoutTableLimits (TBattery_strength_area_values_Limits_sig)();
typedef TAknWindowLineLayout (TBattery_strength_area_values_sig)(TInt);
typedef TAknWindowLineLayout (TContext_pane_elements_Line_1_sig)();
typedef TAknTextLineLayout (TTitle_pane_texts_Line_1_sig)(TInt, TInt);
typedef TAknTextLineLayout (TTitle_pane_texts_Line_2_sig)(TInt, TInt);
typedef TAknMultiLineTextLayout (TMultiline_Title_pane_texts_Line_2_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TTitle_pane_elements_Line_1_sig)();
typedef TAknWindowLineLayout (TUniversal_indicator_pane_elements_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TNavi_pane_arrow_elements_Line_1_sig)();
typedef TAknWindowLineLayout (TNavi_pane_arrow_elements_Line_2_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TNavi_pane_tab_elements_Line_1_sig)();
typedef TAknWindowLineLayout (TNavi_pane_tab_elements_Line_2_sig)();
typedef TAknWindowLineLayout (TNavi_pane_tab_elements_Line_3_sig)();
typedef TAknWindowLineLayout (TNavi_pane_tab_elements_Line_4_sig)();
typedef TAknWindowLineLayout (TNavi_pane_tab_elements_Line_5_sig)();
typedef TAknWindowLineLayout (TNavi_pane_tab_elements_Line_6_sig)();
typedef TAknWindowLineLayout (TNavi_pane_tab_elements_Line_7_sig)();
typedef TAknWindowLineLayout (TNavi_pane_tab_elements_Line_8_sig)();
typedef TAknWindowLineLayout (TNavi_pane_tab_elements_Line_9_sig)();
typedef TAknWindowLineLayout (TNavi_pane_tab_elements_Line_10_sig)();
typedef TAknWindowLineLayout (TNavi_pane_tab_elements_Line_11_sig)();
typedef TAknWindowLineLayout (TNavi_pane_tab_elements_Line_12_sig)();
typedef TAknWindowLineLayout (TNavi_pane_tab_elements_Line_13_sig)();
typedef TAknWindowLineLayout (TNavi_pane_tab_elements_Line_14_sig)();
typedef TAknLayoutTableLimits (TNavi_pane_tab_elements_Limits_sig)();
typedef TAknWindowLineLayout (TNavi_pane_tab_elements_sig)(TInt);
typedef TAknWindowLineLayout (TElements_on_the_tabs_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TElements_on_the_tabs_Line_2_sig)(TInt);
typedef TAknWindowLineLayout (TElements_on_the_tabs_Line_3_sig)(TInt);
typedef TAknLayoutTableLimits (TElements_on_the_tabs_Limits_sig)();
typedef TAknWindowLineLayout (TElements_on_the_tabs_sig)(TInt, TInt);
typedef TAknTextLineLayout (TTexts_on_the_tabs_Line_1_sig)(TInt);
typedef TAknTextLineLayout (TTexts_on_the_tabs_Line_2_sig)(TInt);
typedef TAknTextLineLayout (TTexts_on_the_tabs_Line_3_sig)(TInt);
typedef TAknTextLineLayout (TTexts_on_the_tabs_Line_4_sig)(TInt);
typedef TAknTextLineLayout (TTexts_on_the_tabs_Line_5_sig)(TInt);
typedef TAknLayoutTableLimits (TTexts_on_the_tabs_Limits_sig)();
typedef TAknTextLineLayout (TTexts_on_the_tabs_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TNavi_pane_icons_Line_1_sig)();
typedef TAknWindowLineLayout (TNavi_pane_icons_Line_2_sig)(TInt);
typedef TAknTextLineLayout (TNavi_pane_texts_Line_1_sig)(TInt);
typedef TAknTextLineLayout (TNavi_pane_texts_Line_2_sig)(TInt);
typedef TAknTextLineLayout (TNavi_pane_texts_Line_3_sig)(TInt);
typedef TAknTextLineLayout (TNavi_pane_texts_Line_4_sig)();
typedef TAknTextLineLayout (TNavi_pane_texts_Line_5_sig)();
typedef TAknTextLineLayout (TNavi_pane_texts_Line_6_sig)(TInt);
typedef TAknTextLineLayout (TNavi_pane_texts_Line_7_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TNavi_pane_area_for_editing_status_icons_Line_1_sig)();
typedef TAknWindowLineLayout (TVolume_glider_elements__one__Line_1_sig)(TInt);
typedef TAknWindowLineLayout (Tvolume_navi_pane_sig)(TInt);
typedef TAknLayoutTableLimits (TVolume_glider_elements__one__Limits_sig)();
typedef TAknWindowLineLayout (TVolume_glider_elements__one__sig)(TInt, TInt);
typedef TAknWindowLineLayout (TVolume_pane_elements__one__Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TVolume_pane_elements__one__Line_2_sig)(TInt);
typedef TAknWindowLineLayout (TVolume_pane_elements__one__Line_3_sig)(TInt);
typedef TAknWindowLineLayout (TVolume_pane_elements__one__Line_4_sig)(TInt);
typedef TAknWindowLineLayout (TVolume_pane_elements__one__Line_5_sig)(TInt);
typedef TAknWindowLineLayout (TVolume_pane_elements__one__Line_6_sig)(TInt);
typedef TAknWindowLineLayout (TVolume_pane_elements__one__Line_7_sig)(TInt);
typedef TAknWindowLineLayout (TVolume_pane_elements__one__Line_8_sig)(TInt);
typedef TAknWindowLineLayout (TVolume_pane_elements__one__Line_9_sig)(TInt);
typedef TAknWindowLineLayout (TVolume_pane_elements__one__Line_10_sig)(TInt);
typedef TAknLayoutTableLimits (TVolume_pane_elements__one__Limits_sig)();
typedef TAknWindowLineLayout (TVolume_pane_elements__one__sig)(TInt, TInt);
typedef TAknWindowLineLayout (Tlist_gen_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tfind_pane_sig)();
typedef TAknWindowLineLayout (Twallpaper_pane_sig)();
typedef TAknWindowLineLayout (Tindicator_pane_sig)();
typedef TAknWindowLineLayout (Tsoft_indicator_pane_sig)(TInt);
typedef TAknWindowLineLayout (TA_column_sig)();
typedef TAknWindowLineLayout (TB_column_sig)();
typedef TAknWindowLineLayout (TC_column_sig)();
typedef TAknWindowLineLayout (TD_column_sig)();
typedef TAknLayoutTableLimits (TList_pane_column_division_Limits_sig)();
typedef TAknWindowLineLayout (TList_pane_column_division_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_single_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_single_number_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_single_heading_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_single_graphic_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_single_graphic_heading_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_single_number_heading_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_single_large_graphic_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_double_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_double2_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_double_number_pane_list_single_big_number_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_double_time_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_double_large_graphic_pane_list_double2_large_graphic_pane_list_single_big_large_graphic_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_double_graphic_pane_list_double2_graphic_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_single_big_heading_graphic_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_single_big_heading_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_setting_pane_list_big_setting_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_setting_number_pane_list_big_setting_number_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_setting_double2_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_double2_graphic_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_double2_large_graphic_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_single_2graphic_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_double2_graphic_large_graphic_pane_sig)(TInt);
typedef TAknLayoutTableLimits (TGeneral_list_pane_descendants_Limits_sig)();
typedef TAknWindowLineLayout (TGeneral_list_pane_descendants_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TList_pane_elements__single__Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__single__Line_2_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__single__Line_1_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TList_pane_elements__single_number__Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__single_number__Line_2_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__single_number__Line_1_sig)();
typedef TAknTextLineLayout (TList_pane_texts__single_number__Line_2_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TList_pane_elements__single_heading__Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__single_heading__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__single_heading__Line_3_sig)(TInt);
typedef TAknLayoutTableLimits (TList_pane_elements__single_heading__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__single_heading__SUB_TABLE_0_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__single_heading__Line_1_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__single_heading__Line_2_sig)(TInt);
typedef TAknLayoutTableLimits (TList_pane_texts__single_heading__Limits_sig)();
typedef TAknTextLineLayout (TList_pane_texts__single_heading__sig)(TInt, TInt);
typedef TAknWindowLineLayout (TList_pane_elements__single_graphic__Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__single_graphic__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__single_graphic__Line_3_sig)(TInt);
typedef TAknLayoutTableLimits (TList_pane_elements__single_graphic__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__single_graphic__SUB_TABLE_0_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__single_graphic__Line_1_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TList_pane_elements__single_graphic_heading__Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__single_graphic_heading__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__single_graphic_heading__Line_3_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__single_graphic_heading__Line_4_sig)(TInt);
typedef TAknLayoutTableLimits (TList_pane_elements__single_graphic_heading__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__single_graphic_heading__SUB_TABLE_0_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__single_graphic_heading__Line_1_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__single_graphic_heading__Line_2_sig)(TInt);
typedef TAknLayoutTableLimits (TList_pane_texts__single_graphic_heading__Limits_sig)();
typedef TAknTextLineLayout (TList_pane_texts__single_graphic_heading__sig)(TInt, TInt);
typedef TAknWindowLineLayout (TList_pane_elements__single_number_heading__Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__single_number_heading__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__single_number_heading__Line_3_sig)(TInt);
typedef TAknLayoutTableLimits (TList_pane_elements__single_number_heading__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__single_number_heading__SUB_TABLE_0_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__single_number_heading__Line_1_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__single_number_heading__Line_2_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__single_number_heading__Line_3_sig)(TInt);
typedef TAknLayoutTableLimits (TList_pane_texts__single_number_heading__Limits_sig)();
typedef TAknTextLineLayout (TList_pane_texts__single_number_heading__sig)(TInt, TInt);
typedef TAknWindowLineLayout (TList_pane_elements__single_large_graphic__Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__single_large_graphic__Line_2_sig)(TInt);
typedef TAknWindowLineLayout (TList_pane_elements__single_large_graphic__Line_3_sig)(TInt);
typedef TAknWindowLineLayout (Tdo_not_use_empty_pane1_sig)();
typedef TAknWindowLineLayout (Tdo_not_use_empty_pane2_sig)();
typedef TAknTextLineLayout (TList_pane_texts__single_large_graphic__Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TList_pane_elements__double__Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double__Line_2_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__double__Line_1_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__double__Line_2_sig)();
typedef TAknTextLineLayout (TList_pane_text__double2__Line_1_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_text__double2__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double_number__Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double_number__Line_2_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__double_number__Line_1_sig)();
typedef TAknTextLineLayout (TList_pane_texts__double_number__Line_2_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__double_number__Line_3_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double_graphic__Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double_graphic__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double_graphic__Line_3_sig)(TInt);
typedef TAknLayoutTableLimits (TList_pane_elements__double_graphic__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double_graphic__SUB_TABLE_0_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__double_graphic__Line_1_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__double_graphic__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double2_graphic__Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double2_graphic__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double2_graphic__Line_3_sig)(TInt);
typedef TAknLayoutTableLimits (TList_pane_elements__double2_graphic__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double2_graphic__SUB_TABLE_0_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__double2_graphic__Line_1_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__double2_graphic__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double2_large_graphic__Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double2_large_graphic__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double2_large_graphic__Line_3_sig)(TInt);
typedef TAknLayoutTableLimits (TList_pane_elements__double2_large_graphic__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double2_large_graphic__SUB_TABLE_0_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__double2_large_graphic__Line_1_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__double2_large_graphic__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__large_single_heading_graphic__Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__large_single_heading_graphic__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__large_single_heading_graphic__Line_3_sig)(TInt);
typedef TAknLayoutTableLimits (TList_pane_elements__large_single_heading_graphic__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__large_single_heading_graphic__SUB_TABLE_0_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__large_single_heading_graphic__Line_1_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__large_single_heading_graphic__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__large_single_heading__Line_1_sig)();
typedef TAknTextLineLayout (TList_pane_texts__large_single_heading__Line_1_sig)();
typedef TAknTextLineLayout (TList_pane_texts__large_single_heading__Line_2_sig)();
typedef TAknLayoutTableLimits (TList_pane_texts__large_single_heading__Limits_sig)();
typedef TAknTextLineLayout (TList_pane_texts__large_single_heading__sig)(TInt);
typedef TAknWindowLineLayout (TList_pane_elements__double_time__Line_1_sig)();
typedef TAknTextLineLayout (TList_pane_texts__double_time__Line_1_sig)();
typedef TAknTextLineLayout (TList_pane_texts__double_time__Line_2_sig)();
typedef TAknTextLineLayout (TList_pane_texts__double_time__Line_3_sig)();
typedef TAknTextLineLayout (TList_pane_texts__double_time__Line_4_sig)();
typedef TAknLayoutTableLimits (TList_pane_texts__double_time__Limits_sig)();
typedef TAknTextLineLayout (TList_pane_texts__double_time__sig)(TInt);
typedef TAknWindowLineLayout (TList_pane_elements__double_large_graphic__Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double_large_graphic__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double_large_graphic__Line_3_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double_large_graphic__Line_4_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double_large_graphic__Line_5_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double_large_graphic__Line_6_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double_large_graphic__Line_7_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double_large_graphic__Line_8_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double_large_graphic__Line_9_sig)(TInt);
typedef TAknWindowLineLayout (TList_pane_elements__double_large_graphic__Line_10_sig)();
typedef TAknTextLineLayout (TList_pane_texts__double_large_graphic__Line_1_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__double_large_graphic__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__setting__Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__setting__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__setting__Line_3_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__setting__Line_4_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__setting__Line_5_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__setting__Line_6_sig)();
typedef TAknLayoutTableLimits (TList_pane_elements__setting__Limits_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__setting__sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__setting__Line_1_sig)();
typedef TAknTextLineLayout (TList_pane_texts__setting__Line_2_sig)();
typedef TAknTextLineLayout (TList_pane_texts__setting__Line_3_sig)();
typedef TAknTextLineLayout (TList_pane_texts__setting__Line_4_sig)();
typedef TAknLayoutTableLimits (TList_pane_texts__setting__Limits_sig)();
typedef TAknTextLineLayout (TList_pane_texts__setting__sig)(TInt);
typedef TAknWindowLineLayout (TList_pane_elements__setting_number__Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__setting_number__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__setting_number__Line_3_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__setting_number__Line_4_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__setting_number__Line_5_sig)();
typedef TAknLayoutTableLimits (TList_pane_elements__setting_number__Limits_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__setting_number__sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__setting_number__Line_1_sig)();
typedef TAknTextLineLayout (TList_pane_texts__setting_number__Line_2_sig)();
typedef TAknTextLineLayout (TList_pane_texts__setting_number__Line_3_sig)();
typedef TAknTextLineLayout (TList_pane_texts__setting_number__Line_4_sig)();
typedef TAknLayoutTableLimits (TList_pane_texts__setting_number__Limits_sig)();
typedef TAknTextLineLayout (TList_pane_texts__setting_number__sig)(TInt);
typedef TAknWindowLineLayout (TSetting_volume_elements_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TSetting_volume_elements_Line_2_sig)(TInt);
typedef TAknWindowLineLayout (TSetting_volume_elements_Line_3_sig)(TInt);
typedef TAknWindowLineLayout (TSetting_volume_elements_Line_4_sig)(TInt);
typedef TAknWindowLineLayout (TSetting_volume_elements_Line_5_sig)(TInt);
typedef TAknWindowLineLayout (TSetting_volume_elements_Line_6_sig)(TInt);
typedef TAknWindowLineLayout (TSetting_volume_elements_Line_7_sig)(TInt);
typedef TAknWindowLineLayout (TSetting_volume_elements_Line_8_sig)(TInt);
typedef TAknWindowLineLayout (TSetting_volume_elements_Line_9_sig)(TInt);
typedef TAknWindowLineLayout (TSetting_volume_elements_Line_10_sig)(TInt);
typedef TAknLayoutTableLimits (TSetting_volume_elements_Limits_sig)();
typedef TAknWindowLineLayout (TSetting_volume_elements_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TSetting_slider_elements_Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__setting_double2__Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__setting_double2__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__setting_double2__Line_3_sig)();
typedef TAknLayoutTableLimits (TList_pane_elements__setting_double2__Limits_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__setting_double2__sig)(TInt);
typedef TAknWindowLineLayout (TList_pane_lines__A_column__Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TList_pane_lines__A_column__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_lines__AB_columns__Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TList_pane_lines__AB_columns__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_lines__BC_columns__Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TList_pane_lines__BC_columns__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_highlight_graphics__various__Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TList_pane_highlight_graphics__various__Line_2_sig)(const TRect&);
typedef TAknWindowLineLayout (TList_pane_highlight_graphics__various__Line_3_sig)(TInt);
typedef TAknLayoutTableLimits (TList_pane_highlight_graphics__various__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TList_pane_highlight_graphics__various__SUB_TABLE_0_sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (TList_pane_highlight_graphics__setting_number__Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TList_pane_highlight_graphics__setting_number__Line_2_sig)(const TRect&);
typedef TAknWindowLineLayout (TList_pane_highlight_graphics__setting_number__Line_3_sig)();
typedef TAknLayoutTableLimits (TList_pane_highlight_graphics__setting_number__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TList_pane_highlight_graphics__setting_number__SUB_TABLE_0_sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (TFind_pane_elements_Line_1_sig)();
typedef TAknWindowLineLayout (TFind_pane_elements_Line_2_sig)();
typedef TAknWindowLineLayout (TFind_pane_elements_Line_3_sig)();
typedef TAknWindowLineLayout (TFind_pane_elements_Line_4_sig)();
typedef TAknWindowLineLayout (TFind_pane_elements_Line_5_sig)();
typedef TAknLayoutTableLimits (TFind_pane_elements_Limits_sig)();
typedef TAknWindowLineLayout (TFind_pane_elements_sig)(TInt);
typedef TAknTextLineLayout (TFind_pane_texts_Line_1_sig)();
typedef TAknWindowLineLayout (Tform_field_data_pane_sig)(TInt, TInt);
typedef TAknWindowLineLayout (Tform_field_data_wide_pane_sig)(TInt, TInt);
typedef TAknWindowLineLayout (Tform_field_popup_pane_sig)(TInt, TInt);
typedef TAknWindowLineLayout (Tform_field_popup_wide_pane_sig)(TInt, TInt);
typedef TAknWindowLineLayout (Tform_field_slider_pane_sig)(TInt, TInt);
typedef TAknWindowLineLayout (Tform_field_slider_wide_pane_sig)(TInt, TInt);
typedef TAknLayoutTableLimits (TForm_descendant_panes_Limits_sig)();
typedef TAknWindowLineLayout (TForm_descendant_panes_sig)(TInt, TInt, TInt);
typedef TAknWindowLineLayout (TForm_data_field_elements_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TForm_data_field_elements_Line_2_sig)();
typedef TAknWindowLineLayout (TForm_data_field_elements_Line_3_sig)(TInt);
typedef TAknWindowLineLayout (TForm_data_field_elements_Line_4_sig)();
typedef TAknTextLineLayout (TForm_data_field_texts_Line_1_sig)(TInt, TInt);
typedef TAknMultiLineTextLayout (TMultiline_Form_data_field_texts_Line_1_sig)(TInt, TInt);
typedef TAknTextLineLayout (TForm_data_field_texts_Line_2_sig)(TInt);
typedef TAknMultiLineTextLayout (TMultiline_Form_data_field_texts_Line_2_sig)(TInt);
typedef TAknWindowLineLayout (TForm_data_wide_field_elements_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TForm_data_wide_field_elements_Line_2_sig)();
typedef TAknWindowLineLayout (TForm_data_wide_field_elements_Line_3_sig)(TInt);
typedef TAknWindowLineLayout (TForm_data_wide_field_elements_Line_4_sig)();
typedef TAknTextLineLayout (TForm_data_wide_field_texts_Line_1_sig)();
typedef TAknTextLineLayout (TForm_data_wide_field_texts_Line_2_sig)(TInt);
typedef TAknMultiLineTextLayout (TMultiline_Form_data_wide_field_texts_Line_2_sig)(TInt);
typedef TAknWindowLineLayout (TForm_pop_up_field_elements_and_descendants_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TForm_pop_up_field_elements_and_descendants_Line_2_sig)();
typedef TAknWindowLineLayout (TForm_pop_up_field_elements_and_descendants_Line_3_sig)(TInt);
typedef TAknWindowLineLayout (TForm_pop_up_field_elements_and_descendants_Line_4_sig)();
typedef TAknWindowLineLayout (TForm_pop_up_field_elements_and_descendants_Line_5_sig)();
typedef TAknWindowLineLayout (Tlist_form_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_form_graphic_pane_sig)(TInt);
typedef TAknWindowLineLayout (TList_pane_elements__form_graphic__Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TList_pane_elements__form_graphic__Line_2_sig)();
typedef TAknTextLineLayout (TList_pane_texts__form_graphic__Line_1_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TForm_pop_up_wide_field_elements_and_descendants_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TForm_pop_up_wide_field_elements_and_descendants_Line_2_sig)();
typedef TAknWindowLineLayout (TForm_pop_up_wide_field_elements_and_descendants_Line_3_sig)(TInt);
typedef TAknWindowLineLayout (TForm_pop_up_wide_field_elements_and_descendants_Line_4_sig)();
typedef TAknWindowLineLayout (TForm_pop_up_wide_field_elements_and_descendants_Line_5_sig)();
typedef TAknWindowLineLayout (Tlist_form_wide_pane_sig)(TInt, TInt);
typedef TAknWindowLineLayout (Tlist_form_graphic_wide_pane_sig)(TInt);
typedef TAknWindowLineLayout (TList_pane_elements__form_graphic_wide__Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TList_pane_elements__form_graphic_wide__Line_2_sig)();
typedef TAknTextLineLayout (TList_pane_texts__form_graphic_wide__Line_1_sig)(TInt, TInt, TInt, TInt);
typedef TAknWindowLineLayout (TForm_slider_field_elements_and_descendants_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TForm_slider_field_elements_and_descendants_Line_2_sig)();
typedef TAknWindowLineLayout (TForm_slider_field_elements_and_descendants_Line_3_sig)(TInt);
typedef TAknWindowLineLayout (TForm_slider_field_elements_and_descendants_Line_4_sig)();
typedef TAknWindowLineLayout (TForm_slider_field_elements_and_descendants_Line_5_sig)();
typedef TAknWindowLineLayout (TForm_slider_field_elements_and_descendants_Line_6_sig)(TInt);
typedef TAknWindowLineLayout (TSlider_pane_elements__form__Line_1_sig)();
typedef TAknWindowLineLayout (TSlider_pane_elements__form__Line_2_sig)();
typedef TAknLayoutTableLimits (TSlider_pane_elements__form__Limits_sig)();
typedef TAknWindowLineLayout (TSlider_pane_elements__form__sig)(TInt);
typedef TAknTextLineLayout (TForm_slider_field_texts_Line_1_sig)();
typedef TAknTextLineLayout (TForm_slider_field_texts_Line_2_sig)();
typedef TAknTextLineLayout (TForm_slider_field_texts_Line_3_sig)(TInt, TInt);
typedef TAknMultiLineTextLayout (TMultiline_Form_slider_field_texts_Line_3_sig)(TInt, TInt);
typedef TAknLayoutTableLimits (TForm_slider_field_texts_SUB_TABLE_0_Limits_sig)();
typedef TAknTextLineLayout (TForm_slider_field_texts_SUB_TABLE_0_sig)(TInt);
typedef TAknWindowLineLayout (TForm_slider_field_elements_and_descendants_dup_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TForm_slider_field_elements_and_descendants_dup_Line_2_sig)();
typedef TAknWindowLineLayout (TForm_slider_field_elements_and_descendants_dup_Line_3_sig)(TInt);
typedef TAknWindowLineLayout (TForm_slider_field_elements_and_descendants_dup_Line_4_sig)();
typedef TAknWindowLineLayout (TForm_slider_field_elements_and_descendants_dup_Line_5_sig)();
typedef TAknWindowLineLayout (TForm_slider_field_elements_and_descendants_dup_Line_6_sig)(TInt);
typedef TAknWindowLineLayout (TSlider_pane_elements__form__dup_Line_1_sig)();
typedef TAknWindowLineLayout (TSlider_pane_elements__form__dup_Line_2_sig)();
typedef TAknLayoutTableLimits (TSlider_pane_elements__form__dup_Limits_sig)();
typedef TAknWindowLineLayout (TSlider_pane_elements__form__dup_sig)(TInt);
typedef TAknTextLineLayout (TForm_slider_field_texts_dup_Line_1_sig)();
typedef TAknTextLineLayout (TForm_slider_field_texts_dup_Line_2_sig)();
typedef TAknTextLineLayout (TForm_slider_field_texts_dup_Line_3_sig)(TInt, TInt);
typedef TAknMultiLineTextLayout (TMultiline_Form_slider_field_texts_dup_Line_3_sig)(TInt, TInt);
typedef TAknLayoutTableLimits (TForm_slider_field_texts_dup_SUB_TABLE_0_Limits_sig)();
typedef TAknTextLineLayout (TForm_slider_field_texts_dup_SUB_TABLE_0_sig)(TInt);
typedef TAknWindowLineLayout (TCursor_graphics__13__Line_1_sig)();
typedef TAknWindowLineLayout (TPredictive_text_input_graphics__13__Line_1_sig)();
typedef TAknWindowLineLayout (TPredictive_text_input_graphics__13__Line_2_sig)();
typedef TAknLayoutTableLimits (TPredictive_text_input_graphics__13__Limits_sig)();
typedef TAknWindowLineLayout (TPredictive_text_input_graphics__13__sig)(TInt);
typedef TAknWindowLineLayout (TCut_copy_and_paste_highlight_graphics__13__Line_1_sig)();
typedef TAknWindowLineLayout (TTime_and_date_entry_graphics__13__Line_1_sig)();
typedef TAknWindowLineLayout (TCursor_graphics__12__Line_1_sig)();
typedef TAknWindowLineLayout (TPredictive_text_input_graphics__12__Line_1_sig)();
typedef TAknWindowLineLayout (TPredictive_text_input_graphics__12__Line_2_sig)();
typedef TAknLayoutTableLimits (TPredictive_text_input_graphics__12__Limits_sig)();
typedef TAknWindowLineLayout (TPredictive_text_input_graphics__12__sig)(TInt);
typedef TAknWindowLineLayout (TCut_copy_and_paste_highlight_graphics__12__Line_1_sig)();
typedef TAknWindowLineLayout (TTime_and_date_entry_graphics__12__Line_1_sig)();
typedef TAknWindowLineLayout (Tlist_set_graphic_pane_sig)(TInt);
typedef TAknWindowLineLayout (TList_pane_elements__set_graphic__Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TList_pane_elements__set_graphic__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__set_graphic__Line_3_sig)();
typedef TAknLayoutTableLimits (TList_pane_elements__set_graphic__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__set_graphic__SUB_TABLE_0_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__set_graphic__Line_1_sig)(TInt, TInt, TInt);
typedef TAknWindowLineLayout (TApplication_grid_descendant_Line_1_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TCell_pane_elements__app__Line_1_sig)();
typedef TAknWindowLineLayout (TCell_pane_elements__app__Line_2_sig)();
typedef TAknLayoutTableLimits (TCell_pane_elements__app__Limits_sig)();
typedef TAknWindowLineLayout (TCell_pane_elements__app__sig)(TInt);
typedef TAknTextLineLayout (TCell_pane_texts__app__Line_1_sig)();
typedef TAknWindowLineLayout (TCell_pane_highlight_elements__various__Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TWallpaper_pane_element_Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TIndicator_pane_elements_Line_1_sig)();
typedef TAknWindowLineLayout (TSoft_indicator_pane_elements_Line_1_sig)(const TRect&, TInt, TInt);
typedef TAknTextLineLayout (TSoft_indicator_pane_texts_Line_1_sig)(TInt);
typedef TAknMultiLineTextLayout (TMultiline_Soft_indicator_pane_texts_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (Tpower_save_pane_sig)(TInt);
typedef TAknWindowLineLayout (TPower_save_pane_descendants_Line_1_sig)();
typedef TAknWindowLineLayout (TPower_save_pane_descendants_Line_2_sig)();
typedef TAknWindowLineLayout (TPower_save_pane_descendants_Line_3_sig)();
typedef TAknLayoutTableLimits (TPower_save_pane_descendants_Limits_sig)();
typedef TAknWindowLineLayout (TPower_save_pane_descendants_sig)(TInt);
typedef TAknTextLineLayout (TIdle_power_save_state_texts_Line_1_sig)();
typedef TAknTextLineLayout (TIdle_power_save_state_texts_Line_2_sig)();
typedef TAknTextLineLayout (TIdle_power_save_state_texts_Line_3_sig)();
typedef TAknTextLineLayout (TIdle_power_save_state_texts_Line_4_sig)();
typedef TAknLayoutTableLimits (TIdle_power_save_state_texts_Limits_sig)();
typedef TAknTextLineLayout (TIdle_power_save_state_texts_sig)(TInt);
typedef TAknWindowLineLayout (Tgrid_app_pane_sig)();
typedef TAknTextLineLayout (TEmpty_list_texts_Line_1_sig)(TInt);
typedef TAknMultiLineTextLayout (TMultiline_Empty_list_texts_Line_1_sig)(TInt);
typedef TAknTextLineLayout (TEmpty_list_texts__find__Line_1_sig)(TInt);
typedef TAknMultiLineTextLayout (TMultiline_Empty_list_texts__find__Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TList_pane_elements_and_descendants__settings_edited__Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements_and_descendants__settings_edited__Line_2_sig)();
typedef TAknWindowLineLayout (Tlist_set_pane_sig)(TInt);
typedef TAknWindowLineLayout (TList_pane_elements_and_descendants__settings_edited__Line_4_sig)();
typedef TAknWindowLineLayout (Tsetting_volume_pane_sig)();
typedef TAknWindowLineLayout (Tsetting_slider_pane_sig)();
typedef TAknWindowLineLayout (Tsetting_slider_graphic_pane_sig)();
typedef TAknWindowLineLayout (Tsetting_text_pane_sig)();
typedef TAknWindowLineLayout (Tsetting_code_pane_sig)();
typedef TAknTextLineLayout (TSetting_item_texts_Line_1_sig)();
typedef TAknTextLineLayout (TSetting_item_texts_Line_2_sig)(TInt);
typedef TAknWindowLineLayout (TSetting_volume_pane_elements_Line_1_sig)();
typedef TAknWindowLineLayout (TSetting_volume_pane_elements_Line_2_sig)(TInt);
typedef TAknWindowLineLayout (TSetting_volume_pane_elements_Line_3_sig)(TInt);
typedef TAknWindowLineLayout (TSetting_volume_pane_elements_Line_4_sig)(TInt);
typedef TAknWindowLineLayout (TSetting_volume_pane_elements_Line_5_sig)(TInt);
typedef TAknWindowLineLayout (TSetting_volume_pane_elements_Line_6_sig)(TInt);
typedef TAknWindowLineLayout (TSetting_volume_pane_elements_Line_7_sig)(TInt);
typedef TAknWindowLineLayout (TSetting_volume_pane_elements_Line_8_sig)(TInt);
typedef TAknWindowLineLayout (TSetting_volume_pane_elements_Line_9_sig)(TInt);
typedef TAknWindowLineLayout (TSetting_volume_pane_elements_Line_10_sig)(TInt);
typedef TAknWindowLineLayout (TSetting_volume_pane_elements_Line_11_sig)(TInt);
typedef TAknLayoutTableLimits (TSetting_volume_pane_elements_SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TSetting_volume_pane_elements_SUB_TABLE_0_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TSetting_slider_pane_elements_and_descendants_Line_1_sig)();
typedef TAknWindowLineLayout (TSetting_slider_pane_elements_and_descendants_Line_2_sig)();
typedef TAknLayoutTableLimits (TSetting_slider_pane_elements_and_descendants_Limits_sig)();
typedef TAknWindowLineLayout (TSetting_slider_pane_elements_and_descendants_sig)(TInt);
typedef TAknWindowLineLayout (TSlider_pane_elements_Line_1_sig)();
typedef TAknWindowLineLayout (TSlider_pane_elements_Line_2_sig)();
typedef TAknLayoutTableLimits (TSlider_pane_elements_Limits_sig)();
typedef TAknWindowLineLayout (TSlider_pane_elements_sig)(TInt);
typedef TAknTextLineLayout (TSlider_texts__set__Line_1_sig)();
typedef TAknTextLineLayout (TSlider_texts__set__Line_2_sig)(TInt);
typedef TAknMultiLineTextLayout (TMultiline_Slider_texts__set__Line_2_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TSetting_slider_pane__graphic__elements_and_descendants_Line_1_sig)();
typedef TAknWindowLineLayout (TSetting_slider_pane__graphic__elements_and_descendants_Line_2_sig)();
typedef TAknWindowLineLayout (TSetting_slider_pane__graphic__elements_and_descendants_Line_3_sig)();
typedef TAknLayoutTableLimits (TSetting_slider_pane__graphic__elements_and_descendants_Limits_sig)();
typedef TAknWindowLineLayout (TSetting_slider_pane__graphic__elements_and_descendants_sig)(TInt);
typedef TAknTextLineLayout (TSlider_with_graphic_texts__set__Line_1_sig)(TInt);
typedef TAknMultiLineTextLayout (TMultiline_Slider_with_graphic_texts__set__Line_1_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TSetting_text_pane_elements_Line_1_sig)();
typedef TAknWindowLineLayout (TSetting_text_pane_elements_Line_2_sig)();
typedef TAknWindowLineLayout (TSetting_text_pane_elements_Line_3_sig)();
typedef TAknWindowLineLayout (TSetting_text_pane_elements_Line_4_sig)();
typedef TAknLayoutTableLimits (TSetting_text_pane_elements_Limits_sig)();
typedef TAknWindowLineLayout (TSetting_text_pane_elements_sig)(TInt);
typedef TAknTextLineLayout (TSetting_text_pane_texts_Line_1_sig)(TInt, TInt);
typedef TAknMultiLineTextLayout (TMultiline_Setting_text_pane_texts_Line_1_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TCode_time_and_date_entry_pane_elements_Line_1_sig)();
typedef TAknWindowLineLayout (TCode_time_and_date_entry_pane_elements_Line_2_sig)();
typedef TAknWindowLineLayout (TCode_time_and_date_entry_pane_elements_Line_3_sig)();
typedef TAknLayoutTableLimits (TCode_time_and_date_entry_pane_elements_Limits_sig)();
typedef TAknWindowLineLayout (TCode_time_and_date_entry_pane_elements_sig)(TInt);
typedef TAknTextLineLayout (TCode_time_and_date_entry_pane_texts_Line_1_sig)();
typedef TAknWindowLineLayout (TControl_pane_elements_Line_1_sig)();
typedef TAknWindowLineLayout (TControl_pane_elements_Line_2_sig)();
typedef TAknWindowLineLayout (TControl_pane_elements_Line_3_sig)();
typedef TAknWindowLineLayout (TControl_pane_elements_Line_4_sig)();
typedef TAknLayoutTableLimits (TControl_pane_elements_Limits_sig)();
typedef TAknWindowLineLayout (TControl_pane_elements_sig)(TInt);
typedef TAknTextLineLayout (TControl_pane_texts_Line_1_sig)();
typedef TAknTextLineLayout (TControl_pane_texts_Line_2_sig)();
typedef TAknLayoutTableLimits (TControl_pane_texts_Limits_sig)();
typedef TAknTextLineLayout (TControl_pane_texts_sig)(TInt);
typedef TAknWindowLineLayout (Tpopup_menu_window_sig)(TInt);
typedef TAknWindowLineLayout (TPop_up_windows__main_pane_as_parent__Line_2_sig)(TInt);
typedef TAknWindowLineLayout (Tpopup_menu_graphic_window_sig)(TInt);
typedef TAknWindowLineLayout (Tpopup_menu_graphic_heading_window_sig)(TInt);
typedef TAknWindowLineLayout (Tpopup_menu_double_window_sig)(TInt);
typedef TAknWindowLineLayout (Tpopup_menu_double_large_graphic_window_sig)(TInt);
typedef TAknWindowLineLayout (Tpopup_note_window_sig)(TInt);
typedef TAknWindowLineLayout (Tpopup_note_wait_window_sig)(TInt);
typedef TAknWindowLineLayout (Tpopup_note_image_window_sig)();
typedef TAknWindowLineLayout (Tpopup_query_data_window_sig)(TInt);
typedef TAknWindowLineLayout (Tpopup_query_code_window_sig)(TInt);
typedef TAknWindowLineLayout (Tpopup_query_time_window_sig)(TInt);
typedef TAknWindowLineLayout (Tpopup_query_date_window_sig)(TInt);
typedef TAknWindowLineLayout (Tpopup_query_data_code_window_sig)(TInt);
typedef TAknWindowLineLayout (Tpopup_find_window_sig)();
typedef TAknWindowLineLayout (Tpopup_snote_single_text_window_sig)(TInt);
typedef TAknWindowLineLayout (Tpopup_snote_single_graphic_window_sig)(TInt);
typedef TAknWindowLineLayout (Tpopup_snote_group_window_sig)(TInt);
typedef TAknWindowLineLayout (Tpopup_grid_graphic_window_sig)(TInt);
typedef TAknWindowLineLayout (Tpopup_menu_double2_window_sig)(TInt);
typedef TAknWindowLineLayout (Tpopup_grid_large_graphic_colour_window_sig)();
typedef TAknWindowLineLayout (Tpopup_fast_swap_window_sig)(TInt, TInt);
typedef TAknWindowLineLayout (Tlist_single_popup_menu_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_single_heading_popup_menu_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_single_graphic_popup_menu_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_single_graphic_heading_popup_menu_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_menu_double_popup_menu_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_single_popup_submenu_pane_sig)(TInt, TInt);
typedef TAknWindowLineLayout (Tlist_double_large_graphic_popup_menu_pane_sig)(TInt);
typedef TAknWindowLineLayout (TPop_up_window_list_pane_descendants_Line_8_sig)();
typedef TAknWindowLineLayout (Tlist_double2_popup_menu_pane_sig)(TInt);
typedef TAknWindowLineLayout (TList_pane_elements__menu_single__Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__menu_single__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__menu_single__Line_3_sig)(TInt);
typedef TAknLayoutTableLimits (TList_pane_elements__menu_single__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__menu_single__SUB_TABLE_0_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__menu_single__Line_1_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_text__submenu_single__Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TList_pane_elements__menu_single_graphic__Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__menu_single_graphic__Line_2_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__menu_single_graphic__Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TList_pane_elements__menu_single_heading__Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__menu_single_heading__Line_2_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__menu_single_heading__Line_1_sig)();
typedef TAknTextLineLayout (TList_pane_texts__menu_single_heading__Line_2_sig)(TInt);
typedef TAknWindowLineLayout (TList_pane_elements__menu_single_graphic_heading__Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__menu_single_graphic_heading__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__menu_single_graphic_heading__Line_3_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__menu_single_graphic_heading__Line_1_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__menu_single_graphic_heading__Line_2_sig)(TInt);
typedef TAknLayoutTableLimits (TList_pane_texts__menu_single_graphic_heading__Limits_sig)();
typedef TAknTextLineLayout (TList_pane_texts__menu_single_graphic_heading__sig)(TInt, TInt);
typedef TAknWindowLineLayout (TList_pane_elements__menu_double__Line_1_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__menu_double__Line_1_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__menu_double__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__menu_double2__Line_1_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__menu_double2__Line_1_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__menu_double2__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__menu_double_large_graphic__Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__menu_double_large_graphic__Line_2_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__menu_double_large_graphic__Line_1_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__menu_double_large_graphic__Line_2_sig)();
typedef TAknWindowLineLayout (THighlight_graphics__various__Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (THighlight_graphics__various__Line_2_sig)(const TRect&);
typedef TAknLayoutTableLimits (THighlight_graphics__various__Limits_sig)();
typedef TAknWindowLineLayout (THighlight_graphics__various__sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (Tcell_graphic_popup_pane_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TCell_pane_elements__pop_up_graphic__Line_1_sig)();
typedef TAknTextLineLayout (TCell_pane_texts__pop_up_graphic__Line_1_sig)();
typedef TAknWindowLineLayout (Tcell_large_graphic_colour_popup_pane_sig)(TInt, TInt, TInt);
typedef TAknWindowLineLayout (Tcolour_sig)(TInt);
typedef TAknWindowLineLayout (TPop_up_window_cell_pane__large_graphic_colour_none__Line_1_sig)();
typedef TAknTextLineLayout (TCell_pane_texts__pop_up_large_graphic_colour_none__Line_1_sig)();
typedef TAknWindowLineLayout (THighlight_elements__grid_pop_up__Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (THighlight_elements__grid_pop_up__Line_2_sig)(const TRect&);
typedef TAknLayoutTableLimits (THighlight_elements__grid_pop_up__Limits_sig)();
typedef TAknWindowLineLayout (THighlight_elements__grid_pop_up__sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (TList_heading_pane_elements_Line_1_sig)();
typedef TAknWindowLineLayout (TList_heading_pane_elements_Line_2_sig)();
typedef TAknLayoutTableLimits (TList_heading_pane_elements_Limits_sig)();
typedef TAknWindowLineLayout (TList_heading_pane_elements_sig)(TInt);
typedef TAknTextLineLayout (TList_heading_pane_texts_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TPop_up_menu_with_heading_window_graphics_Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TPop_up_menu_with_heading_window_graphics_Line_2_sig)(const TRect&);
typedef TAknWindowLineLayout (TPop_up_menu_with_heading_window_graphics_Line_3_sig)(const TRect&);
typedef TAknWindowLineLayout (TPop_up_menu_with_heading_window_graphics_Line_4_sig)(const TRect&);
typedef TAknWindowLineLayout (TPop_up_menu_with_heading_window_graphics_Line_5_sig)(const TRect&);
typedef TAknLayoutTableLimits (TPop_up_menu_with_heading_window_graphics_Limits_sig)();
typedef TAknWindowLineLayout (TPop_up_menu_with_heading_window_graphics_sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (Tlist_menu_pane_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TMenu_pop_up_window_descendants_Line_2_sig)();
typedef TAknWindowLineLayout (TMenu_pop_up_window_graphics_Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TMenu_pop_up_window_graphics_Line_2_sig)(const TRect&);
typedef TAknWindowLineLayout (TMenu_pop_up_window_graphics_Line_3_sig)(const TRect&);
typedef TAknWindowLineLayout (TMenu_pop_up_window_graphics_Line_4_sig)(const TRect&);
typedef TAknWindowLineLayout (TMenu_pop_up_window_graphics_Line_5_sig)(const TRect&);
typedef TAknLayoutTableLimits (TMenu_pop_up_window_graphics_Limits_sig)();
typedef TAknWindowLineLayout (TMenu_pop_up_window_graphics_sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (Tlist_submenu_pane_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TSubmenu_pop_up_window_graphics_Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TSubmenu_pop_up_window_graphics_Line_2_sig)(const TRect&);
typedef TAknWindowLineLayout (TSubmenu_pop_up_window_graphics_Line_3_sig)(const TRect&);
typedef TAknWindowLineLayout (TSubmenu_pop_up_window_graphics_Line_4_sig)(const TRect&);
typedef TAknLayoutTableLimits (TSubmenu_pop_up_window_graphics_Limits_sig)();
typedef TAknWindowLineLayout (TSubmenu_pop_up_window_graphics_sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (TSubmenu_pop_up_window_positioning_Line_1_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TSubmenu_pop_up_window_positioning_Line_2_sig)(TInt, TInt);
typedef TAknLayoutTableLimits (TSubmenu_pop_up_window_positioning_Limits_sig)();
typedef TAknWindowLineLayout (TSubmenu_pop_up_window_positioning_sig)(TInt, TInt, TInt);
typedef TAknWindowLineLayout (Tlist_menu_graphic_pane_sig)(TInt, TInt);
typedef TAknWindowLineLayout (Tlist_menu_heading_pane_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TMenu_pop_up_window_descendants__single_heading__Line_2_sig)();
typedef TAknWindowLineLayout (TMenu_pop_up_window_descendants__single_heading__Line_3_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_menu_graphic_heading_pane_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TMenu_pop_up_window_descendants_and_elements__single_graphic_heading__Line_2_sig)();
typedef TAknWindowLineLayout (TMenu_pop_up_window_descendants_and_elements__single_graphic_heading__Line_3_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_menu_double_pane_list_menu_double2_pane_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TMenu_pop_up_window_descendants__double_double2__Line_2_sig)();
typedef TAknWindowLineLayout (Tlist_menu_double_large_graphic_pane_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TMenu_pop_up_window_descendants__double__Line_2_sig)();
typedef TAknWindowLineLayout (TNote_pop_up_window_elements_Line_1_sig)();
typedef TAknTextLineLayout (TNote_pop_up_window_texts_Line_1_sig)(TInt);
typedef TAknMultiLineTextLayout (TMultiline_Note_pop_up_window_texts_Line_1_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TNote_pop_up_window_graphics_Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TNote_pop_up_window_graphics_Line_2_sig)(const TRect&);
typedef TAknWindowLineLayout (TNote_pop_up_window_graphics_Line_3_sig)(const TRect&);
typedef TAknWindowLineLayout (TNote_pop_up_window_graphics_Line_4_sig)(const TRect&);
typedef TAknWindowLineLayout (TNote_pop_up_window_graphics_Line_5_sig)(const TRect&);
typedef TAknLayoutTableLimits (TNote_pop_up_window_graphics_Limits_sig)();
typedef TAknWindowLineLayout (TNote_pop_up_window_graphics_sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (TWait_or_progress_note_pop_up_window_elements_Line_1_sig)();
typedef TAknWindowLineLayout (TWait_or_progress_note_pop_up_window_elements_Line_2_sig)(TInt);
typedef TAknWindowLineLayout (TWait_or_progress_note_pop_up_window_elements_Line_3_sig)();
typedef TAknWindowLineLayout (TWait_or_progress_note_pop_up_window_elements_Line_4_sig)();
typedef TAknLayoutTableLimits (TFirst_general_event_elements_Limits_sig)();
typedef TAknWindowLineLayout (TFirst_general_event_elements_sig)(TInt);
typedef TAknTextLineLayout (TWait_or_progress_note_pop_up_window_texts_Line_1_sig)(TInt, TInt, TInt);
typedef TAknMultiLineTextLayout (TMultiline_Wait_or_progress_note_pop_up_window_texts_Line_1_sig)(TInt, TInt, TInt);
typedef TAknWindowLineLayout (TNote_with_an_image_pop_up_window_elements_Line_1_sig)();
typedef TAknWindowLineLayout (TNote_with_an_image_pop_up_window_elements_Line_2_sig)();
typedef TAknWindowLineLayout (TNote_with_an_image_pop_up_window_elements_Line_3_sig)();
typedef TAknWindowLineLayout (TNote_with_an_image_pop_up_window_elements_Line_4_sig)();
typedef TAknWindowLineLayout (TNote_with_an_image_pop_up_window_elements_Line_5_sig)();
typedef TAknWindowLineLayout (TNote_with_an_image_pop_up_window_elements_Line_6_sig)();
typedef TAknWindowLineLayout (TNote_with_an_image_pop_up_window_elements_Line_7_sig)();
typedef TAknWindowLineLayout (TNote_with_an_image_pop_up_window_elements_Line_8_sig)();
typedef TAknWindowLineLayout (TNote_with_an_image_pop_up_window_elements_Line_9_sig)();
typedef TAknWindowLineLayout (TNote_with_an_image_pop_up_window_elements_Line_10_sig)();
typedef TAknWindowLineLayout (TNote_with_an_image_pop_up_window_elements_Line_11_sig)();
typedef TAknWindowLineLayout (TNote_with_an_image_pop_up_window_elements_Line_12_sig)();
typedef TAknWindowLineLayout (TNote_with_an_image_pop_up_window_elements_Line_13_sig)();
typedef TAknLayoutTableLimits (TNote_with_an_image_pop_up_window_elements_Limits_sig)();
typedef TAknWindowLineLayout (TNote_with_an_image_pop_up_window_elements_sig)(TInt);
typedef TAknTextLineLayout (TNote_with_an_image_pop_up_window_texts_Line_1_sig)(TInt, TInt, TInt, TInt);
typedef TAknMultiLineTextLayout (TMultiline_Note_with_an_image_pop_up_window_texts_Line_1_sig)(TInt, TInt, TInt, TInt);
typedef TAknWindowLineLayout (TQuery_with_heading_window_graphics_Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TQuery_with_heading_window_graphics_Line_2_sig)(const TRect&);
typedef TAknWindowLineLayout (TQuery_with_heading_window_graphics_Line_3_sig)(const TRect&);
typedef TAknWindowLineLayout (TQuery_with_heading_window_graphics_Line_4_sig)(const TRect&);
typedef TAknWindowLineLayout (TQuery_with_heading_window_graphics_Line_5_sig)(const TRect&);
typedef TAknLayoutTableLimits (TQuery_with_heading_window_graphics_Limits_sig)();
typedef TAknWindowLineLayout (TQuery_with_heading_window_graphics_sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (Tpopup_list_heading_pane_sig)(const TRect&);
typedef TAknWindowLineLayout (THeading_pane_elements_Line_1_sig)();
typedef TAknWindowLineLayout (TIcon_sig)(TInt);
typedef TAknTextLineLayout (THeading_pane_texts_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TData_query_pop_up_window_elements_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TData_query_pop_up_window_elements_Line_2_sig)(const TRect&, TInt);
typedef TAknWindowLineLayout (TData_query_pop_up_window_elements_Line_3_sig)(const TRect&, TInt);
typedef TAknWindowLineLayout (TData_query_pop_up_window_elements_Line_4_sig)(TInt);
typedef TAknWindowLineLayout (TData_query_pop_up_window_elements_Line_5_sig)();
typedef TAknTextLineLayout (TData_query_pop_up_window_texts_Line_1_sig)(TInt);
typedef TAknMultiLineTextLayout (TMultiline_Data_query_pop_up_window_texts_Line_1_sig)(TInt);
typedef TAknTextLineLayout (TData_query_pop_up_window_texts_Line_2_sig)(TInt, TInt);
typedef TAknMultiLineTextLayout (TMultiline_Data_query_pop_up_window_texts_Line_2_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TData_query_pop_up_window_graphics_Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TData_query_pop_up_window_graphics_Line_2_sig)(const TRect&);
typedef TAknWindowLineLayout (TData_query_pop_up_window_graphics_Line_3_sig)(const TRect&);
typedef TAknWindowLineLayout (TData_query_pop_up_window_graphics_Line_4_sig)(const TRect&);
typedef TAknWindowLineLayout (TData_query_pop_up_window_graphics_Line_5_sig)(const TRect&);
typedef TAknLayoutTableLimits (TData_query_pop_up_window_graphics_Limits_sig)();
typedef TAknWindowLineLayout (TData_query_pop_up_window_graphics_sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (TCode_query_pop_up_window_elements_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TCode_query_pop_up_window_elements_Line_2_sig)(TInt);
typedef TAknWindowLineLayout (TCode_query_pop_up_window_elements_Line_3_sig)(TInt);
typedef TAknWindowLineLayout (TCode_query_pop_up_window_elements_Line_4_sig)(TInt);
typedef TAknLayoutTableLimits (TCode_query_pop_up_window_elements_Limits_sig)();
typedef TAknWindowLineLayout (TCode_query_pop_up_window_elements_sig)(TInt, TInt);
typedef TAknTextLineLayout (TCode_query_pop_up_window_texts_Line_1_sig)(TInt);
typedef TAknMultiLineTextLayout (TMultiline_Code_query_pop_up_window_texts_Line_1_sig)(TInt);
typedef TAknTextLineLayout (TCode_query_pop_up_window_texts_Line_2_sig)(TInt);
typedef TAknMultiLineTextLayout (TMultiline_Code_query_pop_up_window_texts_Line_2_sig)(TInt);
typedef TAknLayoutTableLimits (TCode_query_pop_up_window_texts_Limits_sig)();
typedef TAknTextLineLayout (TCode_query_pop_up_window_texts_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TCombined_data_and_code_query_pop_up_window_elements_Line_1_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TCombined_data_and_code_query_pop_up_window_elements_Line_2_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TCombined_data_and_code_query_pop_up_window_elements_Line_3_sig)(TInt);
typedef TAknWindowLineLayout (TCombined_data_and_code_query_pop_up_window_elements_Line_4_sig)(TInt);
typedef TAknWindowLineLayout (TCombined_data_and_code_query_pop_up_window_elements_Line_5_sig)(TInt);
typedef TAknTextLineLayout (TCombined_data_and_code_query_pop_up_window_texts_Line_1_sig)(TInt);
typedef TAknMultiLineTextLayout (TMultiline_Combined_data_and_code_query_pop_up_window_texts_Line_1_sig)(TInt);
typedef TAknTextLineLayout (TCombined_data_and_code_query_pop_up_window_texts_Line_2_sig)(TInt);
typedef TAknMultiLineTextLayout (TMultiline_Combined_data_and_code_query_pop_up_window_texts_Line_2_sig)(TInt);
typedef TAknTextLineLayout (TCombined_data_and_code_query_pop_up_window_texts_Line_3_sig)(TInt);
typedef TAknMultiLineTextLayout (TMultiline_Combined_data_and_code_query_pop_up_window_texts_Line_3_sig)(TInt);
typedef TAknTextLineLayout (TCombined_data_and_code_query_pop_up_window_texts_Line_4_sig)(TInt);
typedef TAknMultiLineTextLayout (TMultiline_Combined_data_and_code_query_pop_up_window_texts_Line_4_sig)(TInt);
typedef TAknLayoutTableLimits (TCombined_data_and_code_query_pop_up_window_texts_Limits_sig)();
typedef TAknTextLineLayout (TCombined_data_and_code_query_pop_up_window_texts_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TCombined_data_and_code_query_pop_up_window_graphics_Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TCombined_data_and_code_query_pop_up_window_graphics_Line_2_sig)(const TRect&, TInt);
typedef TAknWindowLineLayout (TCombined_data_and_code_query_pop_up_window_graphics_Line_3_sig)(const TRect&, TInt);
typedef TAknWindowLineLayout (TCombined_data_and_code_query_pop_up_window_graphics_Line_4_sig)(const TRect&, TInt);
typedef TAknWindowLineLayout (TCombined_data_and_code_query_pop_up_window_graphics_Line_5_sig)(const TRect&, TInt);
typedef TAknLayoutTableLimits (TCombined_data_and_code_query_pop_up_window_graphics_SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TCombined_data_and_code_query_pop_up_window_graphics_SUB_TABLE_0_sig)(TInt, const TRect&, TInt);
typedef TAknWindowLineLayout (TFind_pop_up_window_elements_Line_1_sig)();
typedef TAknWindowLineLayout (TFind_pop_up_window_elements_Line_2_sig)();
typedef TAknWindowLineLayout (TFind_pop_up_window_elements_Line_3_sig)();
typedef TAknWindowLineLayout (TFind_pop_up_window_elements_Line_4_sig)();
typedef TAknLayoutTableLimits (TFind_pop_up_window_elements_Limits_sig)();
typedef TAknWindowLineLayout (TFind_pop_up_window_elements_sig)(TInt);
typedef TAknTextLineLayout (TFind_pop_up_window_texts_Line_1_sig)();
typedef TAknWindowLineLayout (TFind_pop_up_window_graphics_Line_1_sig)();
typedef TAknWindowLineLayout (TFind_pop_up_window_graphics_Line_2_sig)();
typedef TAknWindowLineLayout (TFind_pop_up_window_graphics_Line_3_sig)();
typedef TAknWindowLineLayout (TFind_pop_up_window_graphics_Line_4_sig)();
typedef TAknWindowLineLayout (TFind_pop_up_window_graphics_Line_5_sig)();
typedef TAknLayoutTableLimits (TFind_pop_up_window_graphics_Limits_sig)();
typedef TAknWindowLineLayout (TFind_pop_up_window_graphics_sig)(TInt);
typedef TAknWindowLineLayout (TPop_up_menu_with_find_pane_graphics_Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TPop_up_menu_with_find_pane_graphics_Line_2_sig)(const TRect&);
typedef TAknWindowLineLayout (TPop_up_menu_with_find_pane_graphics_Line_3_sig)(const TRect&);
typedef TAknWindowLineLayout (TPop_up_menu_with_find_pane_graphics_Line_4_sig)(const TRect&);
typedef TAknWindowLineLayout (TPop_up_menu_with_find_pane_graphics_Line_5_sig)(const TRect&);
typedef TAknLayoutTableLimits (TPop_up_menu_with_find_pane_graphics_Limits_sig)();
typedef TAknWindowLineLayout (TPop_up_menu_with_find_pane_graphics_sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (TNotification_pop_up_window_elements__text__Line_1_sig)();
typedef TAknTextLineLayout (TNotification_pop_up_window_texts__text__Line_1_sig)(TInt);
typedef TAknMultiLineTextLayout (TMultiline_Notification_pop_up_window_texts__text__Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TNotification_pop_up_window_graphics__text__Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TNotification_pop_up_window_graphics__text__Line_2_sig)(const TRect&);
typedef TAknWindowLineLayout (TNotification_pop_up_window_graphics__text__Line_3_sig)(const TRect&);
typedef TAknWindowLineLayout (TNotification_pop_up_window_graphics__text__Line_4_sig)(const TRect&);
typedef TAknWindowLineLayout (TNotification_pop_up_window_graphics__text__Line_5_sig)(const TRect&);
typedef TAknLayoutTableLimits (TNotification_pop_up_window_graphics__text__Limits_sig)();
typedef TAknWindowLineLayout (TNotification_pop_up_window_graphics__text__sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (TNotification_pop_up_window_elements__graphic__Line_1_sig)();
typedef TAknWindowLineLayout (TNotification_pop_up_window_elements__graphic__Line_2_sig)();
typedef TAknLayoutTableLimits (TNotification_pop_up_window_elements__graphic__Limits_sig)();
typedef TAknWindowLineLayout (TNotification_pop_up_window_elements__graphic__sig)(TInt);
typedef TAknTextLineLayout (TNotification_pop_up_window_texts__graphic__Line_1_sig)(TInt);
typedef TAknMultiLineTextLayout (TMultiline_Notification_pop_up_window_texts__graphic__Line_1_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TIdentifier_icon_selection_pop_up_window_descendants_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (Tgrid_graphic_popup_pane_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TIdentifier_icon_selection_pop_up_window_elements_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TIdentifier_icon_selection_pop_up_window_elements_Line_2_sig)(TInt, TInt, TInt);
typedef TAknWindowLineLayout (TIdentifier_icon_selection_pop_up_window_graphics_Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TIdentifier_icon_selection_pop_up_window_graphics_Line_2_sig)(const TRect&, TInt);
typedef TAknWindowLineLayout (TIdentifier_icon_selection_pop_up_window_graphics_Line_3_sig)(const TRect&, TInt);
typedef TAknWindowLineLayout (TIdentifier_icon_selection_pop_up_window_graphics_Line_4_sig)(const TRect&, TInt);
typedef TAknWindowLineLayout (TIdentifier_icon_selection_pop_up_window_graphics_Line_5_sig)(const TRect&, TInt);
typedef TAknLayoutTableLimits (TIdentifier_icon_selection_pop_up_window_graphics_SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TIdentifier_icon_selection_pop_up_window_graphics_SUB_TABLE_0_sig)(TInt, const TRect&, TInt);
typedef TAknWindowLineLayout (TColour_selection_pop_up_window_descendants_Line_1_sig)();
typedef TAknWindowLineLayout (TColour_selection_pop_up_window_descendants_Line_2_sig)();
typedef TAknWindowLineLayout (Tgrid_large_graphic_colour_popup_pane_sig)(TInt);
typedef TAknWindowLineLayout (TComposer_symbol_selection_pop_up_window_elements_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TComposer_symbol_selection_pop_up_window_elements_Line_2_sig)(TInt, TInt, TInt, TInt);
typedef TAknWindowLineLayout (TColour_selection_pop_up_window_graphics_Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TColour_selection_pop_up_window_graphics_Line_2_sig)(const TRect&);
typedef TAknWindowLineLayout (TColour_selection_pop_up_window_graphics_Line_3_sig)(const TRect&);
typedef TAknWindowLineLayout (TColour_selection_pop_up_window_graphics_Line_4_sig)(const TRect&);
typedef TAknWindowLineLayout (TColour_selection_pop_up_window_graphics_Line_5_sig)(const TRect&);
typedef TAknLayoutTableLimits (TColour_selection_pop_up_window_graphics_Limits_sig)();
typedef TAknWindowLineLayout (TColour_selection_pop_up_window_graphics_sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (TFast_application_swapping_pop_up_window_descendants_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TFast_application_swapping_pop_up_window_graphics_Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TFast_application_swapping_pop_up_window_graphics_Line_2_sig)(const TRect&);
typedef TAknWindowLineLayout (TFast_application_swapping_pop_up_window_graphics_Line_3_sig)(const TRect&);
typedef TAknWindowLineLayout (TFast_application_swapping_pop_up_window_graphics_Line_4_sig)(const TRect&);
typedef TAknWindowLineLayout (TFast_application_swapping_pop_up_window_graphics_Line_5_sig)(const TRect&);
typedef TAknWindowLineLayout (TFast_application_swapping_pop_up_window_graphics_Line_6_sig)();
typedef TAknLayoutTableLimits (TFast_application_swapping_pop_up_window_graphics_SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TFast_application_swapping_pop_up_window_graphics_SUB_TABLE_0_sig)(TInt, const TRect&);
typedef TAknTextLineLayout (TList_pane_texts__setting__double2__Line_1_sig)();
typedef TAknTextLineLayout (TList_pane_texts__setting__double2__Line_2_sig)();
typedef TAknLayoutTableLimits (TList_pane_texts__setting__double2__Limits_sig)();
typedef TAknTextLineLayout (TList_pane_texts__setting__double2__sig)(TInt);
typedef TAknWindowLineLayout (TList_pane_elements__single_2graphic__Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__single_2graphic__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__single_2graphic__Line_3_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__single_2graphic__Line_4_sig)(TInt);
typedef TAknLayoutTableLimits (TList_pane_elements__single_2graphic__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__single_2graphic__SUB_TABLE_0_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__single_2graphic__Line_1_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TList_pane_elements__double2_graphic_large_graphic__Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double2_graphic_large_graphic__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double2_graphic_large_graphic__Line_3_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double2_graphic_large_graphic__Line_4_sig)(TInt);
typedef TAknLayoutTableLimits (TList_pane_elements__double2_graphic_large_graphic__SUB_TABLE_0_Limits_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__double2_graphic_large_graphic__SUB_TABLE_0_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__double2_graphic_large_graphic__Line_1_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__double2_graphic_large_graphic__Line_2_sig)();
typedef TAknTextLineLayout (TForm_data_wide_graphic_field_texts_Line_1_sig)();
typedef TAknTextLineLayout (TForm_data_wide_graphic_field_texts_Line_2_sig)(TInt);
typedef TAknMultiLineTextLayout (TMultiline_Form_data_wide_graphic_field_texts_Line_2_sig)(TInt);
typedef TAknWindowLineLayout (Tstatus_small_pane_sig)();
typedef TAknWindowLineLayout (TSmall_status_pane_descendants_and_elements_Line_1_sig)();
typedef TAknWindowLineLayout (Tstatus_small_icon_pane_sig)();
typedef TAknWindowLineLayout (Tstatus_small_wait_pane_sig)();
typedef TAknWindowLineLayout (TSmall_status_pane_descendants_and_elements_Line_4_sig)();
typedef TAknWindowLineLayout (TSmall_status_pane_descendants_and_elements_Line_5_sig)();
typedef TAknWindowLineLayout (TSmall_status_pane_descendants_and_elements_Line_6_sig)();
typedef TAknLayoutTableLimits (TSmall_status_pane_descendants_and_elements_Limits_sig)();
typedef TAknWindowLineLayout (TSmall_status_pane_descendants_and_elements_sig)(TInt);
typedef TAknTextLineLayout (TSmall_status_pane_texts_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TSmall_status_waiting_pane_components_Line_1_sig)();
typedef TAknWindowLineLayout (TSmall_status_waiting_pane_components_Line_2_sig)();
typedef TAknWindowLineLayout (TSmall_status_waiting_pane_components_Line_3_sig)();
typedef TAknWindowLineLayout (TSmall_status_waiting_pane_components_Line_4_sig)();
typedef TAknLayoutTableLimits (TSmall_status_waiting_pane_components_Limits_sig)();
typedef TAknWindowLineLayout (TSmall_status_waiting_pane_components_sig)(TInt);
typedef TAknWindowLineLayout (TNote_with_additional_information_popup_window_elements_Line_1_sig)();
typedef TAknWindowLineLayout (TNote_with_additional_information_popup_window_elements_Line_2_sig)(TInt);
typedef TAknWindowLineLayout (TNote_with_additional_information_popup_window_elements_Line_3_sig)(TInt);
typedef TAknTextLineLayout (TNote_with_additional_information_popup_window_texts_Line_1_sig)(TInt, TInt);
typedef TAknMultiLineTextLayout (TMultiline_Note_with_additional_information_popup_window_texts_Line_1_sig)(TInt, TInt);
typedef TAknTextLineLayout (TNote_with_additional_information_popup_window_texts_Line_2_sig)(TInt);
typedef TAknMultiLineTextLayout (TMultiline_Note_with_additional_information_popup_window_texts_Line_2_sig)(TInt);
typedef TAknTextLineLayout (TNote_with_additional_information_popup_window_texts_Line_3_sig)(TInt, TInt);
typedef TAknMultiLineTextLayout (TMultiline_Note_with_additional_information_popup_window_texts_Line_3_sig)(TInt, TInt);
typedef TAknTextLineLayout (THeading_pane_texts_Line_2_sig)();
typedef TAknWindowLineLayout (TSide_volume_key_popup_window_elements_Line_1_sig)();
typedef TAknWindowLineLayout (TSide_volume_key_popup_window_elements_Line_2_sig)();
typedef TAknTextLineLayout (TSide_volume_key_popup_window_texts_Line_1_sig)();
typedef TAknTextLineLayout (TSide_volume_key_popup_window_texts_Line_2_sig)();
typedef TAknWindowLineLayout (TSide_volume_key_popup_window_background_Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TSide_volume_key_popup_window_background_Line_2_sig)(const TRect&);
typedef TAknWindowLineLayout (TSide_volume_key_popup_window_background_Line_3_sig)(const TRect&);
typedef TAknWindowLineLayout (TSide_volume_key_popup_window_background_Line_4_sig)(const TRect&);
typedef TAknTextLineLayout (TTransparent_setting_item_texts_Line_1_sig)();
typedef TAknTextLineLayout (TTransparent_setting_item_texts_Line_2_sig)();
typedef TAknTextLineLayout (TTransparent_setting_item_texts_Line_3_sig)(TInt);
typedef TAknTextLineLayout (TTransparent_setting_item_texts_Line_4_sig)(TInt);
typedef TAknTextLineLayout (TList_pane_texts__set_trans_graphic__Line_1_sig)(TInt, TInt);
typedef TAknTextLineLayout (TList_pane_texts__set_trans_graphic__Line_2_sig)(TInt, TInt);
typedef TAknWindowLineLayout (Tlist_set_trans_pane_sig)(TInt);
typedef TAknWindowLineLayout (Tlist_set_trans_graphic_pane_sig)(TInt);
typedef TAknWindowLineLayout (TList_pane_elements__set_trans_graphic__Line_1_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__set_trans_graphic__Line_2_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__set_trans_graphic__Line_3_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__set_trans_graphic__Line_4_sig)();
typedef TAknWindowLineLayout (TList_pane_elements__set_trans_graphic__Line_5_sig)();
typedef TAknTextLineLayout (TSoft_indicator_texts_Line_1_sig)();
typedef TAknWindowLineLayout (Tai_links_pane_sig)();
typedef TAknWindowLineLayout (Tai_gene_pane_sig)(TInt);
typedef TAknWindowLineLayout (TLink_pane_elements_and_descendant_panes_Line_1_sig)();
typedef TAknWindowLineLayout (Tgrid_ai_links_pane_sig)();
typedef TAknLayoutTableLimits (TLink_pane_elements_and_descendant_panes_Limits_sig)();
typedef TAknWindowLineLayout (TLink_pane_elements_and_descendant_panes_sig)(TInt);
typedef TAknWindowLineLayout (Tcell_ai_link_pane_sig)(TInt);
typedef TAknWindowLineLayout (TLink_shortcut_cell_pane_elements_Line_1_sig)();
typedef TAknWindowLineLayout (TLink_shortcut_cell_pane_elements_Line_2_sig)();
typedef TAknWindowLineLayout (TLink_shortcut_cell_pane_elements_Line_3_sig)();
typedef TAknWindowLineLayout (TLink_shortcut_cell_pane_elements_Line_4_sig)();
typedef TAknLayoutTableLimits (TLink_shortcut_cell_pane_elements_Limits_sig)();
typedef TAknWindowLineLayout (TLink_shortcut_cell_pane_elements_sig)(TInt);
typedef TAknWindowLineLayout (Tpopup_ai_links_title_window_sig)();
typedef TAknTextLineLayout (TLink_shortcut_title_texts_Line_1_sig)();
typedef TAknWindowLineLayout (TLink_shortcut_title_pop_up_window_graphics_Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TLink_shortcut_title_pop_up_window_graphics_Line_2_sig)(const TRect&);
typedef TAknWindowLineLayout (TLink_shortcut_title_pop_up_window_graphics_Line_3_sig)(const TRect&);
typedef TAknWindowLineLayout (TLink_shortcut_title_pop_up_window_graphics_Line_4_sig)(const TRect&);
typedef TAknLayoutTableLimits (TLink_shortcut_title_pop_up_window_graphics_Limits_sig)();
typedef TAknWindowLineLayout (TLink_shortcut_title_pop_up_window_graphics_sig)(TInt, const TRect&);
typedef TAknWindowLineLayout (Tai_gene_pane_1_sig)();
typedef TAknWindowLineLayout (Tai_gene_pane_2_sig)(TInt);
typedef TAknWindowLineLayout (TFirst_general_event_elements_Line_1_sig)();
typedef TAknWindowLineLayout (TFirst_general_event_elements_Line_2_sig)();
typedef TAknTextLineLayout (TFirst_general_event_texts_Line_1_sig)(TInt);
typedef TAknTextLineLayout (TSecond_general_event_pane_texts_Line_1_sig)(TInt);
typedef TAknWindowLineLayout (TShortcut_link_highlight_Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (THighlight_for_other_Active_Idle_items_Line_1_sig)(const TRect&);
typedef TAknTextLineLayout (TFind_pop_up_window_texts_Line_2_sig)();
typedef TAknLayoutTableLimits (TFind_pop_up_window_texts_Limits_sig)();
typedef TAknTextLineLayout (TFind_pop_up_window_texts_sig)(TInt);
typedef TAknTextLineLayout (TFind_pane_texts_Line_2_sig)();
typedef TAknLayoutTableLimits (TFind_pane_texts_Limits_sig)();
typedef TAknTextLineLayout (TFind_pane_texts_sig)(TInt);
typedef TAknWindowLineLayout (Tai_gene_pane_3_sig)();
typedef TAknWindowLineLayout (TThird_general_event_elements_Line_1_sig)();
typedef TAknWindowLineLayout (TThird_general_event_elements_Line_2_sig)();
typedef TAknLayoutTableLimits (TThird_general_event_elements_Limits_sig)();
typedef TAknWindowLineLayout (TThird_general_event_elements_sig)(TInt);
typedef TAknWindowLineLayout (Tpopup_ai_message_window_sig)();
typedef TAknWindowLineLayout (TActive_idle_message_pop_up_window_descendants_Line_1_sig)();
typedef TAknWindowLineLayout (TActive_idle_message_pop_up_window_descendants_Line_2_sig)();
typedef TAknWindowLineLayout (TActive_idle_message_pop_up_window_descendants_Line_3_sig)();
typedef TAknLayoutTableLimits (TActive_idle_message_pop_up_window_descendants_Limits_sig)();
typedef TAknWindowLineLayout (TActive_idle_message_pop_up_window_descendants_sig)(TInt);
typedef TAknTextLineLayout (TActive_idle_message_popup_window_texts_Line_1_sig)(TInt, TInt);
typedef TAknMultiLineTextLayout (TMultiline_Active_idle_message_popup_window_texts_Line_1_sig)(TInt, TInt);
typedef TAknWindowLineLayout (TActive_idle_heading_pane_elements_Line_1_sig)();
typedef TAknWindowLineLayout (TActive_idle_heading_pane_elements_Line_2_sig)();
typedef TAknWindowLineLayout (TActive_idle_heading_pane_elements_Line_3_sig)();
typedef TAknWindowLineLayout (TActive_idle_heading_pane_elements_Line_4_sig)();
typedef TAknLayoutTableLimits (TActive_idle_heading_pane_elements_Limits_sig)();
typedef TAknWindowLineLayout (TActive_idle_heading_pane_elements_sig)(TInt);
typedef TAknTextLineLayout (TActive_idle_heading_pane_texts_Line_1_sig)(TInt);
typedef TAknTextLineLayout (TActive_idle_heading_pane_texts_Line_2_sig)();
typedef TAknWindowLineLayout (TActive_idle_message_pop_up_window_graphics_Line_1_sig)(const TRect&);
typedef TAknWindowLineLayout (TActive_idle_message_pop_up_window_graphics_Line_2_sig)(const TRect&);
typedef TAknWindowLineLayout (TActive_idle_message_pop_up_window_graphics_Line_3_sig)(const TRect&);
typedef TAknWindowLineLayout (TActive_idle_message_pop_up_window_graphics_Line_4_sig)(const TRect&);
typedef TAknWindowLineLayout (TActive_idle_message_pop_up_window_graphics_Line_5_sig)(const TRect&);
typedef TAknLayoutTableLimits (TActive_idle_message_pop_up_window_graphics_Limits_sig)();
typedef TAknWindowLineLayout (TActive_idle_message_pop_up_window_graphics_sig)(TInt, const TRect&);

} // end of namespace AknLayout

#endif // AKNLAYOUT_CDL_COMMON_H
