/*
* Copyright (c) 2003-2008 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:   Prime and generator values for modular Diffie-Hellman groups
*
*/



#ifndef _DH_PARAMETERS_H_
#define _DH_PARAMETERS_H_

#include <e32def.h>


//Group 1
//Equivalent to FFFFFFFF FFFFFFFF C90FDAA2 2168C234 C4C6628B 80DC1CD1 
//              29024E08 8A67CC74 020BBEA6 3B139B22 514A0879 8E3404DD 
//              EF9519B3 CD3A431B 302B0A6D F25F1437 4FE1356D 6D51C245 
//              E485B576 625E7EC6 F44C42E9 A63A3620 FFFFFFFF FFFFFFFF
#define MODP_768_PRIME_LENGTH   96      //bytes TUint8 (2 hex each)

const TUint8 MODP_768_PRIME[MODP_768_PRIME_LENGTH] = 
            {255,255,255,255, 255,255,255,255, 201,15,218,162,  33,104,194,52,
            196,198,98,139,   128,220,28,209,  41,2,78,8,       138,103,204,116,  
            2,11,190,166,     59,19,155,34,    81,74,8,121,     142,52,4,221,  
            239,149,25,179,   205,58,67,27,    48,43,10,109,    242,95,20,55,
            79,225,53,109,    109,81,194,69,   228,133,181,118, 98,94,126,198,
            244,76,66,233,    166,58,54,32,    255,255,255,255, 255,255,255,255};

#define MODP_768_GENERATOR_LENGTH       1       //TUint characters
const TUint8 MODP_768_GENERATOR[MODP_768_GENERATOR_LENGTH]={2};


//Group 2
//Equivalent to FFFFFFFF FFFFFFFF C90FDAA2 2168C234 C4C6628B 80DC1CD1 
//              29024E08 8A67CC74 020BBEA6 3B139B22 514A0879 8E3404DD 
//              EF9519B3 CD3A431B 302B0A6D F25F1437 4FE1356D 6D51C245 
//              E485B576 625E7EC6 F44C42E9 A637ED6B 0BFF5CB6 F406B7ED
//              EE386bFB 5A899FA5 AE9F2411 7C4B1FE6 49286651 ECE65381
//              FFFFFFFF FFFFFFFF
#define MODP_1024_PRIME_LENGTH  128     //bytes TUint8 (2 hex each)

const TUint8 MODP_1024_PRIME[MODP_1024_PRIME_LENGTH] = 
            {0xFF,0xFF,0xFF,0xFF ,0xFF,0xFF,0xFF,0xFF ,0xC9,0x0F,0xDA,0xA2 
            ,0x21,0x68,0xC2,0x34 ,0xC4,0xC6,0x62,0x8B ,0x80,0xDC,0x1C,0xD1 
            ,0x29,0x02,0x4E,0x08 ,0x8A,0x67,0xCC,0x74 ,0x02,0x0B,0xBE,0xA6 
            ,0x3B,0x13,0x9B,0x22 ,0x51,0x4A,0x08,0x79 ,0x8E,0x34,0x04,0xDD 
            ,0xEF,0x95,0x19,0xB3 ,0xCD,0x3A,0x43,0x1B ,0x30,0x2B,0x0A,0x6D
            ,0xF2,0x5F,0x14,0x37 ,0x4F,0xE1,0x35,0x6D ,0x6D,0x51,0xC2,0x45 
            ,0xE4,0x85,0xB5,0x76 ,0x62,0x5E,0x7E,0xC6 ,0xF4,0x4C,0x42,0xE9 
            ,0xA6,0x37,0xED,0x6B ,0x0B,0xFF,0x5C,0xB6 ,0xF4,0x06,0xB7,0xED
            ,0xEE,0x38,0x6b,0xFB ,0x5A,0x89,0x9F,0xA5 ,0xAE,0x9F,0x24,0x11 
            ,0x7C,0x4B,0x1F,0xE6 ,0x49,0x28,0x66,0x51 ,0xEC,0xE6,0x53,0x81
            ,0xFF,0xFF,0xFF,0xFF ,0xFF,0xFF,0xFF,0xFF };

#define MODP_1024_GENERATOR_LENGTH      1       //TUint characters
const TUint8 MODP_1024_GENERATOR[MODP_1024_GENERATOR_LENGTH]={2};


//Group 5
//Equivalent to FFFFFFFF FFFFFFFF C90FDAA2 2168C234 C4C6628B 80DC1CD1
//              29024E08 8A67CC74 020BBEA6 3B139B22 514A0879 8E3404DD
//              EF9519B3 CD3A431B 302B0A6D F25F1437 4FE1356D 6D51C245
//              E485B576 625E7EC6 F44C42E9 A637ED6B 0BFF5CB6 F406B7ED
//              EE386BFB 5A899FA5 AE9F2411 7C4B1FE6 49286651 ECE45B3D
//              C2007CB8 A163BF05 98DA4836 1C55D39A 69163FA8 FD24CF5F
//              83655D23 DCA3AD96 1C62F356 208552BB 9ED52907 7096966D
//              670C354E 4ABC9804 F1746C08 CA237327 FFFFFFFF FFFFFFFF
#define MODP_1536_PRIME_LENGTH  192     //bytes TUint8 (2 hex each)

const TUint8 MODP_1536_PRIME[MODP_1536_PRIME_LENGTH] = 
            {0xFF,0xFF,0xFF,0xFF ,0xFF,0xFF,0xFF,0xFF ,0xC9,0x0F,0xDA,0xA2 
            ,0x21,0x68,0xC2,0x34 ,0xC4,0xC6,0x62,0x8B ,0x80,0xDC,0x1C,0xD1 
            ,0x29,0x02,0x4E,0x08 ,0x8A,0x67,0xCC,0x74 ,0x02,0x0B,0xBE,0xA6 
            ,0x3B,0x13,0x9B,0x22 ,0x51,0x4A,0x08,0x79 ,0x8E,0x34,0x04,0xDD 
            ,0xEF,0x95,0x19,0xB3 ,0xCD,0x3A,0x43,0x1B ,0x30,0x2B,0x0A,0x6D
            ,0xF2,0x5F,0x14,0x37 ,0x4F,0xE1,0x35,0x6D ,0x6D,0x51,0xC2,0x45 
            ,0xE4,0x85,0xB5,0x76 ,0x62,0x5E,0x7E,0xC6 ,0xF4,0x4C,0x42,0xE9 
            ,0xA6,0x37,0xED,0x6B ,0x0B,0xFF,0x5C,0xB6 ,0xF4,0x06,0xB7,0xED
            ,0xEE,0x38,0x6b,0xFB ,0x5A,0x89,0x9F,0xA5 ,0xAE,0x9F,0x24,0x11 
            ,0x7C,0x4B,0x1F,0xE6 ,0x49,0x28,0x66,0x51 ,0xEC,0xE4,0x5B,0x3D
            ,0xC2,0x00,0x7C,0xB8 ,0xA1,0x63,0xBF,0x05 ,0x98,0xDA,0x48,0x36
            ,0x1C,0x55,0xD3,0x9A ,0x69,0x16,0x3F,0xA8 ,0xFD,0x24,0xCF,0x5F
            ,0x83,0x65,0x5D,0x23 ,0xDC,0xA3,0xAD,0x96 ,0x1C,0x62,0xF3,0x56
            ,0x20,0x85,0x52,0xBB ,0x9E,0xD5,0x29,0x07 ,0x70,0x96,0x96,0x6D
            ,0x67,0x0C,0x35,0x4E ,0x4A,0xBC,0x98,0x04 ,0xF1,0x74,0x6C,0x08
            ,0xCA,0x23,0x73,0x27, 0xFF,0xFF,0xFF,0xFF ,0xFF,0xFF,0xFF,0xFF };

#define MODP_1536_GENERATOR_LENGTH      1       //TUint characters
const TUint8 MODP_1536_GENERATOR[MODP_1536_GENERATOR_LENGTH]={2};


//Group 14
//Equivalent to FFFFFFFF FFFFFFFF C90FDAA2 2168C234 C4C6628B 80DC1CD1
//              29024E08 8A67CC74 020BBEA6 3B139B22 514A0879 8E3404DD
//              EF9519B3 CD3A431B 302B0A6D F25F1437 4FE1356D 6D51C245
//              E485B576 625E7EC6 F44C42E9 A637ED6B 0BFF5CB6 F406B7ED
//              EE386BFB 5A899FA5 AE9F2411 7C4B1FE6 49286651 ECE45B3D
//              C2007CB8 A163BF05 98DA4836 1C55D39A 69163FA8 FD24CF5F
//              83655D23 DCA3AD96 1C62F356 208552BB 9ED52907 7096966D
//              670C354E 4ABC9804 F1746C08 CA18217C 32905E46 2E36CE3B
//              E39E772C 180E8603 9B2783A2 EC07A28F B5C55DF0 6F4C52C9
//              DE2BCBF6 95581718 3995497C EA956AE5 15D22618 98FA0510
//              15728E5A 8AACAA68 FFFFFFFF FFFFFFFF
#define MODP_2048_PRIME_LENGTH  256

const TUint8 MODP_2048_PRIME[MODP_2048_PRIME_LENGTH] = 
            {0xFF,0xFF,0xFF,0xFF ,0xFF,0xFF,0xFF,0xFF ,0xC9,0x0F,0xDA,0xA2
            ,0x21,0x68,0xC2,0x34 ,0xC4,0xC6,0x62,0x8B ,0x80,0xDC,0x1C,0xD1
            ,0x29,0x02,0x4E,0x08 ,0x8A,0x67,0xCC,0x74 ,0x02,0x0B,0xBE,0xA6
            ,0x3B,0x13,0x9B,0x22 ,0x51,0x4A,0x08,0x79 ,0x8E,0x34,0x04,0xDD
            ,0xEF,0x95,0x19,0xB3 ,0xCD,0x3A,0x43,0x1B ,0x30,0x2B,0x0A,0x6D
            ,0xF2,0x5F,0x14,0x37 ,0x4F,0xE1,0x35,0x6D ,0x6D,0x51,0xC2,0x45
            ,0xE4,0x85,0xB5,0x76 ,0x62,0x5E,0x7E,0xC6 ,0xF4,0x4C,0x42,0xE9
            ,0xA6,0x37,0xED,0x6B ,0x0B,0xFF,0x5C,0xB6 ,0xF4,0x06,0xB7,0xED
            ,0xEE,0x38,0x6B,0xFB ,0x5A,0x89,0x9F,0xA5 ,0xAE,0x9F,0x24,0x11
            ,0x7C,0x4B,0x1F,0xE6 ,0x49,0x28,0x66,0x51 ,0xEC,0xE4,0x5B,0x3D
            ,0xC2,0x00,0x7C,0xB8 ,0xA1,0x63,0xBF,0x05 ,0x98,0xDA,0x48,0x36
            ,0x1C,0x55,0xD3,0x9A ,0x69,0x16,0x3F,0xA8 ,0xFD,0x24,0xCF,0x5F
            ,0x83,0x65,0x5D,0x23 ,0xDC,0xA3,0xAD,0x96 ,0x1C,0x62,0xF3,0x56
            ,0x20,0x85,0x52,0xBB ,0x9E,0xD5,0x29,0x07 ,0x70,0x96,0x96,0x6D
            ,0x67,0x0C,0x35,0x4E ,0x4A,0xBC,0x98,0x04 ,0xF1,0x74,0x6C,0x08
            ,0xCA,0x18,0x21,0x7C ,0x32,0x90,0x5E,0x46 ,0x2E,0x36,0xCE,0x3B
            ,0xE3,0x9E,0x77,0x2C ,0x18,0x0E,0x86,0x03 ,0x9B,0x27,0x83,0xA2
            ,0xEC,0x07,0xA2,0x8F ,0xB5,0xC5,0x5D,0xF0 ,0x6F,0x4C,0x52,0xC9
            ,0xDE,0x2B,0xCB,0xF6 ,0x95,0x58,0x17,0x18 ,0x39,0x95,0x49,0x7C
            ,0xEA,0x95,0x6A,0xE5 ,0x15,0xD2,0x26,0x18 ,0x98,0xFA,0x05,0x10
            ,0x15,0x72,0x8E,0x5A ,0x8A,0xAC,0xAA,0x68 ,0xFF,0xFF,0xFF,0xFF
            ,0xFF,0xFF,0xFF,0xFF };

#define MODP_2048_GENERATOR_LENGTH  1
const TUint8 MODP_2048_GENERATOR[MODP_2048_GENERATOR_LENGTH]={2};


#endif
