/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLScriptElement.h"

#include <wtf/GetPtr.h>

#include "HTMLScriptElement.h"
#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLScriptElementTableEntries[] =
{
    { "event", JSHTMLScriptElement::EventAttrNum, DontDelete, 0, 0 },
    { "htmlFor", JSHTMLScriptElement::HtmlForAttrNum, DontDelete, 0, &JSHTMLScriptElementTableEntries[9] },
    { "charset", JSHTMLScriptElement::CharsetAttrNum, DontDelete, 0, 0 },
    { "src", JSHTMLScriptElement::SrcAttrNum, DontDelete, 0, &JSHTMLScriptElementTableEntries[8] },
    { "defer", JSHTMLScriptElement::DeferAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "text", JSHTMLScriptElement::TextAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "type", JSHTMLScriptElement::TypeAttrNum, DontDelete, 0, 0 },
    { "constructor", JSHTMLScriptElement::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSHTMLScriptElementTable = 
{
    2, 10, JSHTMLScriptElementTableEntries, 8
};

/* Hash table for constructor */

static const HashEntry JSHTMLScriptElementConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLScriptElementConstructorTable = 
{
    2, 1, JSHTMLScriptElementConstructorTableEntries, 1
};

class JSHTMLScriptElementConstructor : public DOMObject {
public:
    JSHTMLScriptElementConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSHTMLScriptElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLScriptElementConstructor::info = { "HTMLScriptElementConstructor", 0, &JSHTMLScriptElementConstructorTable, 0 };

bool JSHTMLScriptElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLScriptElementConstructor, DOMObject>(exec, &JSHTMLScriptElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLScriptElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLScriptElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLScriptElementPrototypeTable = 
{
    2, 1, JSHTMLScriptElementPrototypeTableEntries, 1
};

const ClassInfo JSHTMLScriptElementPrototype::info = { "HTMLScriptElementPrototype", 0, &JSHTMLScriptElementPrototypeTable, 0 };

JSObject* JSHTMLScriptElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLScriptElementPrototype>(exec, "[[JSHTMLScriptElement.prototype]]");
}

const ClassInfo JSHTMLScriptElement::info = { "HTMLScriptElement", &JSHTMLElement::info, &JSHTMLScriptElementTable, 0 };

JSHTMLScriptElement::JSHTMLScriptElement(ExecState* exec, HTMLScriptElement* impl)
    : JSHTMLElement(exec, impl)
{
    setPrototype(JSHTMLScriptElementPrototype::self(exec));
}

bool JSHTMLScriptElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLScriptElement, JSHTMLElement>(exec, &JSHTMLScriptElementTable, this, propertyName, slot);
}

JSValue* JSHTMLScriptElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case TextAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());

        return jsString(imp->text());
    }
    case HtmlForAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());

        return jsString(imp->htmlFor());
    }
    case EventAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());

        return jsString(imp->event());
    }
    case CharsetAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());

        return jsString(imp->charset());
    }
    case DeferAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());

        return jsBoolean(imp->defer());
    }
    case SrcAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());

        return jsString(imp->src());
    }
    case TypeAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());

        return jsString(imp->type());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLScriptElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSHTMLScriptElement, JSHTMLElement>(exec, propertyName, value, attr, &JSHTMLScriptElementTable, this);
}

void JSHTMLScriptElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case TextAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());

        imp->setText(valueToStringWithNullCheck(exec, value));
        break;
    }
    case HtmlForAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());

        imp->setHtmlFor(valueToStringWithNullCheck(exec, value));
        break;
    }
    case EventAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());

        imp->setEvent(valueToStringWithNullCheck(exec, value));
        break;
    }
    case CharsetAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());

        imp->setCharset(valueToStringWithNullCheck(exec, value));
        break;
    }
    case DeferAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());

        imp->setDefer(value->toBoolean(exec));
        break;
    }
    case SrcAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());

        imp->setSrc(valueToStringWithNullCheck(exec, value));
        break;
    }
    case TypeAttrNum: {
        HTMLScriptElement* imp = static_cast<HTMLScriptElement*>(impl());

        imp->setType(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLScriptElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLScriptElementConstructor>(exec, "[[HTMLScriptElement.constructor]]");
}

}
