/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGAnimatedEnumeration.h"

#include <wtf/GetPtr.h>


using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGAnimatedEnumerationTableEntries[] =
{
    { "baseVal", JSSVGAnimatedEnumeration::BaseValAttrNum, DontDelete, 0, 0 },
    { "animVal", JSSVGAnimatedEnumeration::AnimValAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGAnimatedEnumerationTable = 
{
    2, 2, JSSVGAnimatedEnumerationTableEntries, 2
};

/* Hash table for prototype */

static const HashEntry JSSVGAnimatedEnumerationPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSSVGAnimatedEnumerationPrototypeTable = 
{
    2, 1, JSSVGAnimatedEnumerationPrototypeTableEntries, 1
};

const ClassInfo JSSVGAnimatedEnumerationPrototype::info = { "SVGAnimatedEnumerationPrototype", 0, &JSSVGAnimatedEnumerationPrototypeTable, 0 };

JSObject* JSSVGAnimatedEnumerationPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGAnimatedEnumerationPrototype>(exec, "[[JSSVGAnimatedEnumeration.prototype]]");
}

const ClassInfo JSSVGAnimatedEnumeration::info = { "SVGAnimatedEnumeration", 0, &JSSVGAnimatedEnumerationTable, 0 };

JSSVGAnimatedEnumeration::JSSVGAnimatedEnumeration(ExecState* exec, SVGAnimatedEnumeration* impl)
    : m_impl(impl)
{
    setPrototype(JSSVGAnimatedEnumerationPrototype::self(exec));
}

JSSVGAnimatedEnumeration::~JSSVGAnimatedEnumeration()
{
    SVGDocumentExtensions::forgetGenericContext<SVGAnimatedEnumeration>(m_impl.get());
    ScriptInterpreter::forgetDOMObject(m_impl.get());
}

bool JSSVGAnimatedEnumeration::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedEnumeration, KJS::DOMObject>(exec, &JSSVGAnimatedEnumerationTable, this, propertyName, slot);
}

JSValue* JSSVGAnimatedEnumeration::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case BaseValAttrNum: {
        SVGAnimatedEnumeration* imp = static_cast<SVGAnimatedEnumeration*>(impl());

        return jsNumber(imp->baseVal());
    }
    case AnimValAttrNum: {
        SVGAnimatedEnumeration* imp = static_cast<SVGAnimatedEnumeration*>(impl());

        return jsNumber(imp->animVal());
    }
    }
    return 0;
}

void JSSVGAnimatedEnumeration::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSSVGAnimatedEnumeration, KJS::DOMObject>(exec, propertyName, value, attr, &JSSVGAnimatedEnumerationTable, this);
}

void JSSVGAnimatedEnumeration::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case BaseValAttrNum: {
        SVGAnimatedEnumeration* imp = static_cast<SVGAnimatedEnumeration*>(impl());

        imp->setBaseVal(value->toInt32(exec));
        break;
    }
    }
    SVGAnimatedEnumeration* imp = static_cast<SVGAnimatedEnumeration*>(impl());

    ASSERT(exec && exec->dynamicInterpreter());
    Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
    if (!activeFrame)
        return;

    SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
    if (extensions && extensions->hasGenericContext<SVGAnimatedEnumeration>(imp)) {
        const SVGElement* context = extensions->genericContext<SVGAnimatedEnumeration>(imp);
        ASSERT(context);

        context->notifyAttributeChange();
    }

}

KJS::JSValue* toJS(KJS::ExecState* exec, SVGAnimatedEnumeration* obj)
{
    return KJS::cacheDOMObject<SVGAnimatedEnumeration, JSSVGAnimatedEnumeration>(exec, obj);
}
SVGAnimatedEnumeration* toSVGAnimatedEnumeration(KJS::JSValue* val)
{
    return val->isObject(&JSSVGAnimatedEnumeration::info) ? static_cast<JSSVGAnimatedEnumeration*>(val)->impl() : 0;
}

}

#endif // ENABLE(SVG)
