/*
 * Copyright (C) 2007 Staikos Computing Services Inc. <info@staikos.net>
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"

#include "PlatformString.h"
#include "LocalizedStrings.h"
#include "NotImplemented.h"

using namespace WebCore;


namespace WebCore {
String submitButtonDefaultLabel() { return "Submit"; }
String inputElementAltText() { return String(); }
String resetButtonDefaultLabel() { return "Reset"; }
String defaultLanguage() { return "en"; }
String searchableIndexIntroduction() { return "Searchable Index"; }
String fileButtonChooseFileLabel() { return "Choose File"; }
String fileButtonNoFileSelectedLabel() { return "No file selected"; }
String contextMenuItemTagOpenLinkInNewWindow() { return "Open in New Window"; }
String contextMenuItemTagDownloadLinkToDisk() { return "Save Link..."; }
String contextMenuItemTagCopyLinkToClipboard() { return "Copy Link"; }
String contextMenuItemTagOpenImageInNewWindow() { return "Open Image"; }
String contextMenuItemTagDownloadImageToDisk() { return "Save Image"; }
String contextMenuItemTagCopyImageToClipboard() { return "Copy Image"; }
String contextMenuItemTagOpenFrameInNewWindow() { return "Open Frame"; }
String contextMenuItemTagCopy() { return "Copy"; }
String contextMenuItemTagGoBack() { return "Go Back"; }
String contextMenuItemTagGoForward() { return "Go Forward"; }
String contextMenuItemTagStop() { return "Stop"; }
String contextMenuItemTagReload() { return "Reload"; }
String contextMenuItemTagCut() { return "Cut"; }
String contextMenuItemTagPaste() { return "Paste"; }
String contextMenuItemTagNoGuessesFound() { return String(); }
String contextMenuItemTagIgnoreSpelling() { return "Ignore"; }
String contextMenuItemTagLearnSpelling() { return "Add To Dictionary"; }
String contextMenuItemTagSearchWeb() { return "Search The Web"; }
String contextMenuItemTagLookUpInDictionary() { return "Look Up In Dictionary"; }
String contextMenuItemTagOpenLink() { return "Open Link"; }
String contextMenuItemTagIgnoreGrammar() { return "Ignore"; }
String contextMenuItemTagSpellingMenu() { return "Spelling"; }
String contextMenuItemTagShowSpellingPanel(bool show) { return String(); }
String contextMenuItemTagCheckSpelling() { return "Check Spelling"; }
String contextMenuItemTagCheckSpellingWhileTyping() { return String(); }
String contextMenuItemTagCheckGrammarWithSpelling() { return String(); }
String contextMenuItemTagFontMenu() { return "Fonts"; }
String contextMenuItemTagBold() { return "Bold"; }
String contextMenuItemTagItalic() { return "Italic"; }
String contextMenuItemTagUnderline() { return "Underline"; }
String contextMenuItemTagOutline() { return "Outline"; }
String contextMenuItemTagWritingDirectionMenu() { return "Direction"; }
String contextMenuItemTagDefaultDirection() { return "Default"; }
String contextMenuItemTagLeftToRight() { return "LTR"; }
String contextMenuItemTagRightToLeft() { return "RTL"; }
String contextMenuItemTagInspectElement() { return "Inspect"; }
String searchMenuNoRecentSearchesText() { return String(); }
String searchMenuRecentSearchesText() { return String(); }
String searchMenuClearRecentSearchesText() { return String(); }
String AXWebAreaText() { return String(); }
String AXLinkText() { return String(); }
String AXListMarkerText() { return String(); }
String AXImageMapText() { return String(); }
String AXHeadingText() { return String(); }
String unknownFileSizeText() { return "Unknown"; }

}
// vim: ts=4 sw=4 et
