/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 56 "parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token eOperator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 242
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 60
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  ExprList* yy44;
  Expr * yy116;
  int yy124;
  TriggerStep* yy137;
  SrcList* yy149;
  Expr* yy162;
  struct LikeOp yy168;
  Token yy210;
  struct LimitVal yy278;
  Select* yy313;
  struct {int value; int mask;} yy317;
  IdList* yy326;
  struct TrigEvent yy412;
  int yy483;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 563
#define YYNRULE 298
#define YYERRORSYMBOL 139
#define YYERRSYMDT yy483
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   279,   67,  283,   69,  147,  165,  201,  419,   61,   61,
 /*    10 */    61,   61,   66,   63,   63,   63,   63,   64,   64,   65,
 /*    20 */    65,   65,   66,  429,  312,  161,  432,  438,   68,   63,
 /*    30 */    63,   63,   63,   64,   64,   65,   65,   65,   66,   64,
 /*    40 */    64,   65,   65,   65,   66,   60,   58,  287,  442,  443,
 /*    50 */   439,  439,   62,   62,   61,   61,   61,   61,  501,   63,
 /*    60 */    63,   63,   63,   64,   64,   65,   65,   65,   66,  279,
 /*    70 */   308,   67,  419,   69,  147,   79,  157,  114,  219,  304,
 /*    80 */   224,  305,  169,  244,  862,  118,  562,  503,  506,    2,
 /*    90 */   245,  554,  410,   35,  218,  432,  438,  516,   20,   57,
 /*   100 */   372,  369,   63,   63,   63,   63,   64,   64,   65,   65,
 /*   110 */    65,   66,  279,  514,   60,   58,  287,  442,  443,  439,
 /*   120 */   439,   62,   62,   61,   61,   61,   61,  377,   63,   63,
 /*   130 */    63,   63,   64,   64,   65,   65,   65,   66,  432,  438,
 /*   140 */    91,  301,  373,  468,  231,  371,  263,  199,    2,   83,
 /*   150 */   563,  372,  369,  458,  191,  427,  204,   60,   58,  287,
 /*   160 */   442,  443,  439,  439,   62,   62,   61,   61,   61,   61,
 /*   170 */   167,   63,   63,   63,   63,   64,   64,   65,   65,   65,
 /*   180 */    66,  279,  474,  427,  204,  130,  109,  264,  411,  431,
 /*   190 */   390,  275,  378,  379,  429,  505,  161,  308,  495,   67,
 /*   200 */   507,   69,  147,  550,  411,  146,  225,  432,  438,  142,
 /*   210 */   143,  392,  393,  361,  389,  498,  168,  153,  502,  410,
 /*   220 */    27,  327,  414,  495,  279,  232,   60,   58,  287,  442,
 /*   230 */   443,  439,  439,   62,   62,   61,   61,   61,   61,  411,
 /*   240 */    63,   63,   63,   63,   64,   64,   65,   65,   65,   66,
 /*   250 */   432,  438,  513,  482,  319,  416,  416,  416,  165,  512,
 /*   260 */   419,  533,   67,  456,   69,  147,  265,  279,  283,   60,
 /*   270 */    58,  287,  442,  443,  439,  439,   62,   62,   61,   61,
 /*   280 */    61,   61,  308,   63,   63,   63,   63,   64,   64,   65,
 /*   290 */    65,   65,   66,  432,  438,  419,  472,  377,  282,  532,
 /*   300 */    65,   65,   65,   66,  410,   34,  527,  152,  431,  380,
 /*   310 */   381,  382,   60,   58,  287,  442,  443,  439,  439,   62,
 /*   320 */    62,   61,   61,   61,   61,  419,   63,   63,   63,   63,
 /*   330 */    64,   64,   65,   65,   65,   66,  472,  502,  325,  279,
 /*   340 */    75,  414,  145,  478,  219,  304,  224,  305,  169,  244,
 /*   350 */   357,  260,  259,  549,  530,  393,  245,  289,  308,  452,
 /*   360 */   419,  201,  378,  379,  174,  432,  438,  330,  333,  334,
 /*   370 */   493,  551,  552,  347,  416,  416,  416,  350,  236,  335,
 /*   380 */   410,   40,  529,   78,   60,   58,  287,  442,  443,  439,
 /*   390 */   439,   62,   62,   61,   61,   61,   61,  345,   63,   63,
 /*   400 */    63,   63,   64,   64,   65,   65,   65,   66,  279,  254,
 /*   410 */   174,  396,  481,  330,  333,  334,  309,  308,  506,  308,
 /*   420 */   322,  235,  799,  397,  308,  335,  313,  388,   20,  523,
 /*   430 */   344,  523,  148,  203,  432,  438,  398,  254,  394,  410,
 /*   440 */    34,  410,   34,  286,  422,  423,  410,   34,  395,  242,
 /*   450 */   255,  144,  515,   60,   58,  287,  442,  443,  439,  439,
 /*   460 */    62,   62,   61,   61,   61,   61,  411,   63,   63,   63,
 /*   470 */    63,   64,   64,   65,   65,   65,   66,  279,  539,  214,
 /*   480 */   338,  500,  290,  174,  324,  376,  330,  333,  334,  288,
 /*   490 */   308,  477,  308,  377,  453,  308,  453,  314,  335,  445,
 /*   500 */   445,  453,  440,  432,  438,  115,  203,  170,  311,  422,
 /*   510 */   423,  377,  410,   40,  410,   48,    1,  410,   48,    5,
 /*   520 */   377,  468,   60,   58,  287,  442,  443,  439,  439,   62,
 /*   530 */    62,   61,   61,   61,   61,  446,   63,   63,   63,   63,
 /*   540 */    64,   64,   65,   65,   65,   66,  279,  447,  329,  254,
 /*   550 */   248,  476,  377,  233,  171,  172,  173,  396,  378,  379,
 /*   560 */   237,  298,  377,  281,  299,  504,  433,  434,  245,  397,
 /*   570 */   185,  203,  432,  438,  499,  409,  378,  379,  314,  408,
 /*   580 */   445,  445,  398,    9,  318,  378,  379,  377,  436,  437,
 /*   590 */   366,   60,   58,  287,  442,  443,  439,  439,   62,   62,
 /*   600 */    61,   61,   61,   61,  411,   63,   63,   63,   63,   64,
 /*   610 */    64,   65,   65,   65,   66,  279,  435,  378,  379,  428,
 /*   620 */    90,  506,  314,  328,  445,  445,  308,  378,  379,  355,
 /*   630 */   559,   20,  354,  308,  314,  525,  445,  445,  415,  524,
 /*   640 */   368,  432,  438,  320,  464,  410,    3,  254,  410,   28,
 /*   650 */   351,  346,  378,  379,  465,  410,   23,  493,  279,  454,
 /*   660 */    60,   58,  287,  442,  443,  439,  439,   62,   62,   61,
 /*   670 */    61,   61,   61,  308,   63,   63,   63,   63,   64,   64,
 /*   680 */    65,   65,   65,   66,  432,  438,  202,   19,  541,  138,
 /*   690 */   254,  250,  292,   54,  493,  410,   32,  467,  212,  493,
 /*   700 */   493,  279,  468,   60,   58,  287,  442,  443,  439,  439,
 /*   710 */    62,   62,   61,   61,   61,   61,  308,   63,   63,   63,
 /*   720 */    63,   64,   64,   65,   65,   65,   66,  432,  438,  211,
 /*   730 */   180,  542,  178,  254,  293,  294,  243,  493,  410,   53,
 /*   740 */   462,  239,  254,  254,  279,  254,   60,   70,  287,  442,
 /*   750 */   443,  439,  439,   62,   62,   61,   61,   61,   61,  308,
 /*   760 */    63,   63,   63,   63,   64,   64,   65,   65,   65,   66,
 /*   770 */   432,  438,  296,  243,  543,  201,  164,  153,  243,  243,
 /*   780 */   471,  410,   24,  266,  360,  192,  268,  279,  356,  122,
 /*   790 */    58,  287,  442,  443,  439,  439,   62,   62,   61,   61,
 /*   800 */    61,   61,  308,   63,   63,   63,   63,   64,   64,   65,
 /*   810 */    65,   65,   66,  432,  438,  472,  243,   21,  461,  411,
 /*   820 */   241,  419,  405,  354,  410,   51,   74,  189,   76,  406,
 /*   830 */   149,  420,  176,   22,  287,  442,  443,  439,  439,   62,
 /*   840 */    62,   61,   61,   61,   61,  308,   63,   63,   63,   63,
 /*   850 */    64,   64,   65,   65,   65,   66,   71,  315,  308,    4,
 /*   860 */   308,  411,  308,  285,  411,  404,  411,  410,   96,  308,
 /*   870 */   363,  310,   71,  315,  308,    4,  297,  483,  179,  285,
 /*   880 */   410,   93,  410,   98,  410,   99,  419,  310,  317,  213,
 /*   890 */   201,  410,  110,  187,  409,  308,  410,  111,  408,  431,
 /*   900 */   308,  508,  308,  362,  317,  425,  425,  451,  308,   12,
 /*   910 */   141,  308,  411,  484,  220,  431,  308,  410,   16,   73,
 /*   920 */    72,  487,  410,   97,  410,   33,  221,   71,  306,  307,
 /*   930 */   410,   94,  414,  410,   52,   73,   72,  475,  410,  112,
 /*   940 */   308,  488,  158,   71,  306,  307,   71,  315,  414,    4,
 /*   950 */   308,  201,  308,  285,  308,  489,  170,  308,  401,  402,
 /*   960 */   490,  310,  410,  113,  249,  416,  416,  416,  417,  418,
 /*   970 */    11,  463,  410,   25,  410,   36,  410,   37,  317,  410,
 /*   980 */    26,  416,  416,  416,  417,  418,   11,  486,  485,  431,
 /*   990 */   155,  195,  308,   81,  291,  215,  216,  217,  105,  251,
 /*  1000 */   470,  308,  166,  308,  479,  308,   12,  308,  252,   73,
 /*  1010 */    72,  197,  281,  270,  410,   38,  253,   71,  306,  307,
 /*  1020 */   271,  308,  414,  410,   39,  410,   41,  410,   42,  410,
 /*  1030 */    43,  308,  194,  491,  532,  122,  597,  182,  151,  193,
 /*  1040 */   308,   18,  196,  410,   29,  308,  342,  247,  308,  122,
 /*  1050 */   337,  308,  122,  410,   30,  416,  416,  416,  417,  418,
 /*  1060 */    11,  386,  410,   44,  463,  258,  308,  410,   45,  349,
 /*  1070 */   410,   46,  308,  410,   47,  352,  308,  521,  522,  308,
 /*  1080 */   528,  536,  122,  166,  353,  359,  267,  259,  410,   31,
 /*  1090 */   261,  280,  262,  548,  410,   10,  201,  140,  410,   49,
 /*  1100 */   269,  410,   50,  537,  546,   88,   88,  364,  272,  273,
 /*  1110 */   558,  222,  316,  226,  424,  426,  457,  482,  156,  460,
 /*  1120 */   365,  492,  375,  494,  535,  383,  384,  332,  545,  385,
 /*  1130 */     8,  302,  303,  284,  400,  391,  399,  223,  404,  407,
 /*  1140 */   403,   81,  227,  323,   56,  412,  321,   77,   80,  205,
 /*  1150 */   163,  455,  228,  234,  229,  458,  230,  459,  119,  326,
 /*  1160 */   101,   82,  276,  496,  509,  510,  497,  413,  339,  511,
 /*  1170 */   277,  517,  177,  343,  341,  181,  238,   85,  519,  469,
 /*  1180 */   473,  206,  207,  183,  117,  348,  240,  126,  531,  209,
 /*  1190 */   358,  186,  127,  555,  538,  210,  128,  129,  300,  132,
 /*  1200 */   556,  557,  544,  560,   95,  374,  136,  135,  387,  116,
 /*  1210 */   208,  100,   55,  200,  598,  599,  159,  160,   59,  441,
 /*  1220 */   421,  430,  256,  444,  520,  137,  448,  150,    6,  449,
 /*  1230 */   120,   89,  162,  450,   13,    7,   12,   92,  121,  466,
 /*  1240 */   480,  108,   17,  154,  102,  103,  331,  246,   84,  336,
 /*  1250 */   104,  175,  221,  340,  139,  518,  123,  295,  166,  257,
 /*  1260 */   184,  124,  526,  106,  278,  534,  125,   86,  188,   14,
 /*  1270 */   190,  540,   87,  131,  133,  134,   15,  107,  547,  198,
 /*  1280 */   553,  367,  370,  274,  561,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    16,  218,   16,  220,  221,   21,  111,   23,   70,   71,
 /*    10 */    72,   73,   84,   75,   76,   77,   78,   79,   80,   81,
 /*    20 */    82,   83,   84,  162,  163,  164,   42,   43,   74,   75,
 /*    30 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   79,
 /*    40 */    80,   81,   82,   83,   84,   61,   62,   63,   64,   65,
 /*    50 */    66,   67,   68,   69,   70,   71,   72,   73,  170,   75,
 /*    60 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*    70 */   148,  218,   88,  220,  221,   22,   90,   91,   92,   93,
 /*    80 */    94,   95,   96,   97,  140,  141,  142,  170,  148,  145,
 /*    90 */   104,  238,  170,  171,  154,   42,   43,  157,  158,   46,
 /*   100 */     1,    2,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   110 */    83,   84,   16,  182,   61,   62,   63,   64,   65,   66,
 /*   120 */    67,   68,   69,   70,   71,   72,   73,   23,   75,   76,
 /*   130 */    77,   78,   79,   80,   81,   82,   83,   84,   42,   43,
 /*   140 */    44,  143,  144,  162,  222,  142,   14,  149,  145,   19,
 /*   150 */     0,    1,    2,   23,  156,   79,   80,   61,   62,   63,
 /*   160 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   170 */   156,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   180 */    84,   16,  201,   79,   80,   53,   21,   55,  190,   59,
 /*   190 */   169,  159,   88,   89,  162,  163,  164,  148,  177,  218,
 /*   200 */   182,  220,  221,   99,  190,  156,  191,   42,   43,   79,
 /*   210 */    80,  186,  187,  215,  168,  169,  202,  203,   88,  170,
 /*   220 */   171,  207,   92,  177,   16,  148,   61,   62,   63,   64,
 /*   230 */    65,   66,   67,   68,   69,   70,   71,   72,   73,  190,
 /*   240 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   250 */    42,   43,  177,  178,  187,  125,  126,  127,   21,  184,
 /*   260 */    23,   11,  218,  219,  220,  221,  134,   16,   16,   61,
 /*   270 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   280 */    72,   73,  148,   75,   76,   77,   78,   79,   80,   81,
 /*   290 */    82,   83,   84,   42,   43,   23,  148,   23,  151,   49,
 /*   300 */    81,   82,   83,   84,  170,  171,   18,  148,   59,    7,
 /*   310 */     8,    9,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   320 */    69,   70,   71,   72,   73,   88,   75,   76,   77,   78,
 /*   330 */    79,   80,   81,   82,   83,   84,  148,   88,  148,   16,
 /*   340 */   132,   92,   22,   20,   92,   93,   94,   95,   96,   97,
 /*   350 */   100,  101,  102,  148,  186,  187,  104,  209,  148,  225,
 /*   360 */    88,  111,   88,   89,   90,   42,   43,   93,   94,   95,
 /*   370 */   148,  166,  167,  226,  125,  126,  127,  230,  148,  105,
 /*   380 */   170,  171,   94,  132,   61,   62,   63,   64,   65,   66,
 /*   390 */    67,   68,   69,   70,   71,   72,   73,  209,   75,   76,
 /*   400 */    77,   78,   79,   80,   81,   82,   83,   84,   16,  148,
 /*   410 */    90,   12,   20,   93,   94,   95,  148,  148,  148,  148,
 /*   420 */   210,  211,  134,   24,  148,  105,   16,  157,  158,  100,
 /*   430 */   101,  102,  156,  228,   42,   43,   37,  148,   39,  170,
 /*   440 */   171,  170,  171,  165,  166,  167,  170,  171,   49,  227,
 /*   450 */   189,  181,  182,   61,   62,   63,   64,   65,   66,   67,
 /*   460 */    68,   69,   70,   71,   72,   73,  190,   75,   76,   77,
 /*   470 */    78,   79,   80,   81,   82,   83,   84,   16,  189,  146,
 /*   480 */    16,   20,  213,   90,  213,  148,   93,   94,   95,  213,
 /*   490 */   148,   20,  148,   23,  225,  148,  225,  107,  105,  109,
 /*   500 */   110,  225,   92,   42,   43,  148,  228,   43,  165,  166,
 /*   510 */   167,   23,  170,  171,  170,  171,   19,  170,  171,  192,
 /*   520 */    23,  162,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   530 */    69,   70,   71,   72,   73,   20,   75,   76,   77,   78,
 /*   540 */    79,   80,   81,   82,   83,   84,   16,   20,   81,  148,
 /*   550 */    20,   81,   23,  211,  100,  101,  102,   12,   88,   89,
 /*   560 */   201,  217,   23,   99,  217,  161,   42,   43,  104,   24,
 /*   570 */   156,  228,   42,   43,  170,  108,   88,   89,  107,  112,
 /*   580 */   109,  110,   37,   19,   39,   88,   89,   23,   64,   65,
 /*   590 */   189,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   600 */    70,   71,   72,   73,  190,   75,   76,   77,   78,   79,
 /*   610 */    80,   81,   82,   83,   84,   16,   92,   88,   89,  162,
 /*   620 */    21,  148,  107,  148,  109,  110,  148,   88,   89,  215,
 /*   630 */   157,  158,  148,  148,  107,   25,  109,  110,  148,   29,
 /*   640 */   239,   42,   43,  148,  115,  170,  171,  148,  170,  171,
 /*   650 */   236,   41,   88,   89,  115,  170,  171,  148,   16,  148,
 /*   660 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   670 */    71,   72,   73,  148,   75,   76,   77,   78,   79,   80,
 /*   680 */    81,   82,   83,   84,   42,   43,  193,   19,  189,   21,
 /*   690 */   148,   14,  183,  200,  148,  170,  171,  148,  214,  148,
 /*   700 */   148,   16,  162,   61,   62,   63,   64,   65,   66,   67,
 /*   710 */    68,   69,   70,   71,   72,   73,  148,   75,   76,   77,
 /*   720 */    78,   79,   80,   81,   82,   83,   84,   42,   43,  183,
 /*   730 */    53,  189,   55,  148,  183,  183,  227,  148,  170,  171,
 /*   740 */   204,  201,  148,  148,   16,  148,   61,   62,   63,   64,
 /*   750 */    65,   66,   67,   68,   69,   70,   71,   72,   73,  148,
 /*   760 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   770 */    42,   43,  183,  227,  189,  111,  202,  203,  227,  227,
 /*   780 */   148,  170,  171,  189,  189,  156,  189,   16,  124,   22,
 /*   790 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   800 */    72,   73,  148,   75,   76,   77,   78,   79,   80,   81,
 /*   810 */    82,   83,   84,   42,   43,  148,  227,   19,   22,  190,
 /*   820 */   148,   23,   27,  148,  170,  171,  131,  156,  133,   34,
 /*   830 */   156,   20,  156,   22,   63,   64,   65,   66,   67,   68,
 /*   840 */    69,   70,   71,   72,   73,  148,   75,   76,   77,   78,
 /*   850 */    79,   80,   81,   82,   83,   84,   16,   17,  148,   19,
 /*   860 */   148,  190,  148,   23,  190,   98,  190,  170,  171,  148,
 /*   870 */    91,   31,   16,   17,  148,   19,  209,  148,  156,   23,
 /*   880 */   170,  171,  170,  171,  170,  171,   88,   31,   48,  214,
 /*   890 */   111,  170,  171,   22,  108,  148,  170,  171,  112,   59,
 /*   900 */   148,  148,  148,  124,   48,  125,  126,   20,  148,   22,
 /*   910 */   114,  148,  190,  179,   92,   59,  148,  170,  171,   79,
 /*   920 */    80,   30,  170,  171,  170,  171,  104,   87,   88,   89,
 /*   930 */   170,  171,   92,  170,  171,   79,   80,   81,  170,  171,
 /*   940 */   148,   50,   19,   87,   88,   89,   16,   17,   92,   19,
 /*   950 */   148,  111,  148,   23,  148,  179,   43,  148,    7,    8,
 /*   960 */   179,   31,  170,  171,  148,  125,  126,  127,  128,  129,
 /*   970 */   130,   22,  170,  171,  170,  171,  170,  171,   48,  170,
 /*   980 */   171,  125,  126,  127,  128,  129,  130,   91,   92,   59,
 /*   990 */     5,   19,  148,  122,  103,   10,   11,   12,   13,  148,
 /*  1000 */    20,  148,   22,  148,   20,  148,   22,  148,  148,   79,
 /*  1010 */    80,   26,   99,   28,  170,  171,  148,   87,   88,   89,
 /*  1020 */    35,  148,   92,  170,  171,  170,  171,  170,  171,  170,
 /*  1030 */   171,  148,   47,   20,   49,   22,  113,  232,   89,   54,
 /*  1040 */   148,   69,   57,  170,  171,  148,  233,   20,  148,   22,
 /*  1050 */    20,  148,   22,  170,  171,  125,  126,  127,  128,  129,
 /*  1060 */   130,  150,  170,  171,  115,  148,  148,  170,  171,  148,
 /*  1070 */   170,  171,  148,  170,  171,  148,  148,   51,   52,  148,
 /*  1080 */    20,   20,   22,   22,  148,  100,  101,  102,  170,  171,
 /*  1090 */   148,  106,  148,  148,  170,  171,  111,  192,  170,  171,
 /*  1100 */   148,  170,  171,   20,   20,   22,   22,  148,  148,  148,
 /*  1110 */   148,  173,  224,  194,  229,  229,  173,  178,    6,  173,
 /*  1120 */   135,  173,  147,  173,  195,  147,  147,  174,  195,  147,
 /*  1130 */    22,  155,   99,   40,  180,  172,  172,  172,   98,  172,
 /*  1140 */   174,  122,  195,  119,  121,  190,  117,  131,  120,  223,
 /*  1150 */   113,  153,  196,   97,  197,   23,  198,  161,  153,  116,
 /*  1160 */    19,   99,  175,  161,  172,  172,  180,  199,   15,  172,
 /*  1170 */   175,  153,  152,   38,  153,  153,  205,  131,  153,  206,
 /*  1180 */   206,  212,  212,  152,   61,  153,  205,   19,  185,  212,
 /*  1190 */    15,  185,  188,   33,  195,  212,  188,  188,  153,  185,
 /*  1200 */   153,  153,  195,  138,  160,    1,  216,  216,   20,   32,
 /*  1210 */   176,  176,   19,   44,  113,  113,  113,  113,   19,   92,
 /*  1220 */    20,   20,  234,  108,  235,   19,   11,   19,  118,   20,
 /*  1230 */    19,  237,   22,   20,   22,  118,   22,  237,   20,  115,
 /*  1240 */    20,  240,  231,  113,   19,   19,   44,   20,   19,   44,
 /*  1250 */    19,   96,  104,   16,   21,   17,   99,   36,   22,  134,
 /*  1260 */    99,   45,   45,   19,    5,    1,  103,   69,  123,   19,
 /*  1270 */   114,   17,   69,  114,  103,  123,   19,   14,  124,  136,
 /*  1280 */    20,   58,    3,  137,    4,
};
#define YY_SHIFT_USE_DFLT (-106)
#define YY_SHIFT_MAX 370
static const short yy_shift_ofst[] = {
 /*     0 */    99,  840,  985,  -16,  840,  930,  930,  930,  274, -105,
 /*    10 */    96,  930,  930,  930,  930,  930,  -46,  250,  104,  488,
 /*    20 */   272,   76,   76,   53,  165,  208,  251,  323,  392,  461,
 /*    30 */   530,  599,  642,  685,  642,  642,  642,  642,  642,  642,
 /*    40 */   642,  642,  642,  642,  642,  642,  642,  642,  642,  642,
 /*    50 */   642,  728,  771,  771,  856,  930,  930,  930,  930,  930,
 /*    60 */   930,  930,  930,  930,  930,  930,  930,  930,  930,  930,
 /*    70 */   930,  930,  930,  930,  930,  930,  930,  930,  930,  930,
 /*    80 */   930,  930,  930,  930,  930,  930,  930,  930,  930,  930,
 /*    90 */   930,  930,  930,  -62,  -62,  -14,   27,   27,  -40,  219,
 /*   100 */   464,  488,  488,  488,  488,  288,  488,  488,  488,  272,
 /*   110 */   -72, -106, -106, -106,  130,  252,  399,  399,  150,  237,
 /*   120 */   488,  237,  488,  488,  488,  488,  488,  488,  488,  488,
 /*   130 */   488,  488,  488,  488,  488,  779,  664, -105, -105, -105,
 /*   140 */  -106, -106,  249,  249,  320,  393,  471,  497,  515,  527,
 /*   150 */   545,  529,  539,  564,  470,  302,  488,  488,  467,  488,
 /*   160 */   488,  798,  488,  488,  949,  488,  488,  390,  949,  488,
 /*   170 */   488,  891,  891,  891,  488,  488,  390,  488,  488,  390,
 /*   180 */   488,  610,  329,  488,  488,  390,  488,  488,  488,  390,
 /*   190 */   488,  390,  390,  488,  488,  488,  488,  488,  488,  668,
 /*   200 */   795,  786,  796,  780,  780,  695,  795,  795,  913,  795,
 /*   210 */   795,  767,  871,  871, 1112, 1112, 1112, 1112, 1108, 1033,
 /*   220 */  1033, 1093, 1033, 1040, 1033, -105, 1019, 1024, 1028, 1029,
 /*   230 */  1023, 1016, 1037, 1056, 1132, 1056, 1037, 1062, 1043, 1062,
 /*   240 */  1043, 1141, 1056, 1056, 1132, 1093, 1033, 1033, 1033, 1141,
 /*   250 */  1153, 1037, 1037, 1037, 1037, 1135, 1046, 1153, 1037, 1123,
 /*   260 */  1123, 1168, 1019, 1175, 1175, 1175, 1019, 1123, 1168, 1037,
 /*   270 */  1160, 1160, 1037, 1037, 1065, -106, -106, -106, -106,  524,
 /*   280 */   132,  454,  677,  822,  951,  923,  811,  410,  887,  980,
 /*   290 */   984,  896, 1013, 1027, 1030, 1026, 1060, 1061, 1083, 1084,
 /*   300 */   972, 1204, 1188, 1177, 1169, 1193, 1101, 1102, 1103, 1104,
 /*   310 */  1199, 1200, 1201, 1127, 1115, 1206, 1215, 1208, 1209, 1210,
 /*   320 */  1213, 1110, 1212, 1117, 1214, 1124, 1211, 1218, 1130, 1220,
 /*   330 */  1202, 1225, 1227, 1226, 1229, 1205, 1231, 1155, 1148, 1237,
 /*   340 */  1238, 1233, 1157, 1221, 1216, 1236, 1217, 1125, 1161, 1244,
 /*   350 */  1259, 1264, 1163, 1198, 1203, 1145, 1250, 1156, 1254, 1159,
 /*   360 */  1171, 1152, 1257, 1154, 1260, 1263, 1223, 1143, 1146, 1279,
 /*   370 */  1280,
};
#define YY_REDUCE_USE_DFLT (-218)
#define YY_REDUCE_MAX 278
static const short yy_reduce_ofst[] = {
 /*     0 */   -56,  276,   -2,  -19,   49,  269,  210,  271,  270,   14,
 /*    10 */  -147,  -78,  134,  342,  344,  347,   44,  414,  205,  -60,
 /*    20 */    32,  278,  343, -217, -217, -217, -217, -217, -217, -217,
 /*    30 */  -217, -217, -217, -217, -217, -217, -217, -217, -217, -217,
 /*    40 */  -217, -217, -217, -217, -217, -217, -217, -217, -217, -217,
 /*    50 */  -217, -217, -217, -217,  475,  478,  485,  525,  568,  611,
 /*    60 */   654,  697,  710,  712,  714,  721,  726,  747,  752,  754,
 /*    70 */   760,  763,  768,  792,  802,  804,  806,  809,  844,  853,
 /*    80 */   855,  857,  859,  873,  883,  892,  897,  900,  903,  918,
 /*    90 */   924,  928,  931, -217, -217,   46, -217, -217, -217, -217,
 /*   100 */    75,  509,  546,  551,  552,  147,  589,  401,  473, -139,
 /*   110 */  -217, -217, -217, -217,  404,   21,   25,  168,    3,  359,
 /*   120 */   148,  540,  222,  261,  188,  484,  667,  289,  499,  542,
 /*   130 */   585,  594,  595,  675,  597,  629,  671,  674,  676,  722,
 /*   140 */   493,  574, -112,  -83,  -69,   18,   15,   77,   15,   15,
 /*   150 */    67,  159,  190,  230,  268,  333,  337,  357,  327,  268,
 /*   160 */   490,  457,  495,  511,  536,  549,  632,   15,  536,  672,
 /*   170 */   729,  734,  776,  781,  753,  816,   15,  851,  860,   15,
 /*   180 */   868,  805,  813,  917,  921,   15,  927,  936,  942,   15,
 /*   190 */   944,   15,   15,  945,  952,  959,  960,  961,  962,  911,
 /*   200 */   938,  905,  919,  885,  886,  888,  943,  946,  939,  948,
 /*   210 */   950,  953,  929,  933,  975,  978,  979,  982,  976,  963,
 /*   220 */   964,  954,  965,  966,  967,  955,  947,  956,  957,  958,
 /*   230 */   968,  926,  998,  969,  996,  970, 1005,  971,  973,  981,
 /*   240 */   974,  987,  977,  983, 1002,  986,  992,  993,  997,  995,
 /*   250 */  1020, 1018, 1021, 1022, 1025,  988,  989, 1031, 1032, 1003,
 /*   260 */  1006,  990,  999, 1004, 1008, 1009, 1007, 1014,  991, 1045,
 /*   270 */   994, 1000, 1047, 1048, 1001, 1044, 1034, 1035, 1011,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   569,  796,  861,  684,  861,  796,  861,  796,  861,  688,
 /*    10 */   847,  792,  796,  861,  861,  861,  767,  861,  818,  861,
 /*    20 */   600,  818,  818,  719,  861,  861,  861,  861,  861,  861,
 /*    30 */   861,  861,  720,  861,  795,  791,  787,  789,  788,  721,
 /*    40 */   708,  717,  724,  700,  832,  726,  727,  733,  734,  848,
 /*    50 */   851,  755,  773,  754,  861,  861,  861,  861,  861,  861,
 /*    60 */   861,  861,  861,  861,  861,  861,  861,  861,  861,  861,
 /*    70 */   861,  861,  861,  861,  861,  861,  861,  861,  861,  861,
 /*    80 */   861,  861,  861,  861,  861,  861,  861,  861,  861,  861,
 /*    90 */   861,  861,  861,  757,  778,  593,  756,  766,  758,  759,
 /*   100 */   653,  861,  861,  861,  861,  588,  861,  861,  861,  861,
 /*   110 */   760,  761,  774,  775,  861,  861,  861,  861,  569,  684,
 /*   120 */   861,  684,  861,  861,  861,  861,  861,  861,  861,  861,
 /*   130 */   861,  861,  861,  861,  861,  861,  861,  861,  861,  861,
 /*   140 */   678,  688,  861,  861,  644,  861,  861,  861,  861,  861,
 /*   150 */   861,  861,  861,  861,  861,  576,  574,  861,  676,  861,
 /*   160 */   861,  602,  861,  861,  686,  861,  861,  691,  692,  861,
 /*   170 */   861,  861,  861,  861,  861,  861,  590,  861,  861,  665,
 /*   180 */   861,  824,  861,  861,  861,  839,  861,  861,  861,  837,
 /*   190 */   861,  667,  729,  806,  861,  861,  852,  854,  861,  861,
 /*   200 */   711,  676,  685,  861,  861,  790,  711,  711,  623,  711,
 /*   210 */   711,  626,  723,  723,  573,  573,  573,  573,  643,  655,
 /*   220 */   655,  640,  655,  626,  655,  861,  723,  714,  716,  704,
 /*   230 */   718,  861,  693,  712,  861,  712,  693,  701,  703,  701,
 /*   240 */   703,  800,  712,  712,  861,  640,  655,  655,  655,  800,
 /*   250 */   585,  693,  693,  693,  693,  828,  831,  585,  693,  657,
 /*   260 */   657,  735,  723,  664,  664,  664,  723,  657,  735,  693,
 /*   270 */   850,  850,  693,  693,  859,  610,  628,  628,  834,  861,
 /*   280 */   861,  861,  861,  861,  861,  742,  861,  861,  861,  861,
 /*   290 */   861,  861,  861,  861,  861,  861,  861,  861,  861,  861,
 /*   300 */   813,  861,  861,  861,  861,  861,  747,  743,  861,  744,
 /*   310 */   861,  861,  861,  861,  670,  861,  861,  861,  861,  861,
 /*   320 */   861,  861,  705,  861,  715,  861,  861,  861,  861,  861,
 /*   330 */   861,  861,  861,  861,  861,  861,  861,  861,  861,  861,
 /*   340 */   861,  861,  861,  861,  826,  827,  861,  861,  861,  861,
 /*   350 */   861,  861,  861,  861,  861,  861,  861,  861,  861,  861,
 /*   360 */   861,  861,  861,  861,  861,  861,  858,  861,  861,  570,
 /*   370 */   861,  564,  567,  566,  568,  572,  575,  597,  598,  599,
 /*   380 */   577,  578,  579,  580,  581,  582,  583,  589,  591,  609,
 /*   390 */   611,  618,  656,  659,  660,  661,  842,  843,  844,  619,
 /*   400 */   638,  641,  642,  620,  627,  709,  710,  621,  674,  675,
 /*   410 */   739,  668,  669,  673,  741,  745,  746,  748,  749,  596,
 /*   420 */   603,  604,  607,  608,  814,  816,  815,  817,  606,  605,
 /*   430 */   750,  753,  762,  763,  765,  771,  777,  780,  764,  769,
 /*   440 */   770,  772,  776,  779,  671,  672,  783,  785,  786,  840,
 /*   450 */   841,  781,  793,  794,  694,  784,  768,  706,  595,  713,
 /*   460 */   707,  677,  687,  696,  697,  698,  699,  682,  683,  689,
 /*   470 */   702,  737,  738,  690,  679,  680,  681,  782,  740,  751,
 /*   480 */   752,  622,  629,  630,  631,  634,  635,  636,  637,  632,
 /*   490 */   633,  801,  802,  804,  803,  624,  625,  639,  612,  613,
 /*   500 */   614,  615,  747,  616,  617,  601,  594,  645,  648,  649,
 /*   510 */   650,  651,  652,  654,  646,  647,  592,  584,  586,  695,
 /*   520 */   820,  829,  830,  825,  821,  822,  823,  587,  797,  798,
 /*   530 */   658,  731,  732,  819,  833,  835,  736,  836,  838,  662,
 /*   540 */   663,  666,  805,  845,  722,  725,  728,  730,  807,  808,
 /*   550 */   809,  810,  811,  812,  846,  849,  853,  855,  856,  857,
 /*   560 */   860,  571,  565,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*       SEMI => nothing */
   23,  /*    EXPLAIN => ID */
   23,  /*      QUERY => ID */
   23,  /*       PLAN => ID */
   23,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   23,  /*   DEFERRED => ID */
   23,  /*  IMMEDIATE => ID */
   23,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   23,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   23,  /*         IF => ID */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
   23,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   23,  /*      ABORT => ID */
   23,  /*      AFTER => ID */
   23,  /*    ANALYZE => ID */
   23,  /*        ASC => ID */
   23,  /*     ATTACH => ID */
   23,  /*     BEFORE => ID */
   23,  /*    CASCADE => ID */
   23,  /*       CAST => ID */
   23,  /*   CONFLICT => ID */
   23,  /*   DATABASE => ID */
   23,  /*       DESC => ID */
   23,  /*     DETACH => ID */
   23,  /*       EACH => ID */
   23,  /*       FAIL => ID */
   23,  /*        FOR => ID */
   23,  /*     IGNORE => ID */
   23,  /*  INITIALLY => ID */
   23,  /*    INSTEAD => ID */
   23,  /*    LIKE_KW => ID */
   23,  /*      MATCH => ID */
   23,  /*        KEY => ID */
   23,  /*         OF => ID */
   23,  /*     OFFSET => ID */
   23,  /*     PRAGMA => ID */
   23,  /*      RAISE => ID */
   23,  /*    REPLACE => ID */
   23,  /*   RESTRICT => ID */
   23,  /*        ROW => ID */
   23,  /*  STATEMENT => ID */
   23,  /*    TRIGGER => ID */
   23,  /*     VACUUM => ID */
   23,  /*       VIEW => ID */
   23,  /*    VIRTUAL => ID */
   23,  /*    REINDEX => ID */
   23,  /*     RENAME => ID */
   23,  /*   CTIME_KW => ID */
    0,  /*        ANY => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*      ALTER => nothing */
    0,  /*         TO => nothing */
    0,  /*        ADD => nothing */
    0,  /*   COLUMNKW => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMI",          "EXPLAIN",       "QUERY",       
  "PLAN",          "BEGIN",         "TRANSACTION",   "DEFERRED",    
  "IMMEDIATE",     "EXCLUSIVE",     "COMMIT",        "END",         
  "ROLLBACK",      "CREATE",        "TABLE",         "IF",          
  "NOT",           "EXISTS",        "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ANALYZE",       "ASC",         
  "ATTACH",        "BEFORE",        "CASCADE",       "CAST",        
  "CONFLICT",      "DATABASE",      "DESC",          "DETACH",      
  "EACH",          "FAIL",          "FOR",           "IGNORE",      
  "INITIALLY",     "INSTEAD",       "LIKE_KW",       "MATCH",       
  "KEY",           "OF",            "OFFSET",        "PRAGMA",      
  "RAISE",         "REPLACE",       "RESTRICT",      "ROW",         
  "STATEMENT",     "TRIGGER",       "VACUUM",        "VIEW",        
  "VIRTUAL",       "REINDEX",       "RENAME",        "CTIME_KW",    
  "ANY",           "OR",            "AND",           "IS",          
  "BETWEEN",       "IN",            "ISNULL",        "NOTNULL",     
  "NE",            "EQ",            "GT",            "LE",          
  "LT",            "GE",            "ESCAPE",        "BITAND",      
  "BITOR",         "LSHIFT",        "RSHIFT",        "PLUS",        
  "MINUS",         "STAR",          "SLASH",         "REM",         
  "CONCAT",        "UMINUS",        "UPLUS",         "BITNOT",      
  "STRING",        "JOIN_KW",       "CONSTRAINT",    "DEFAULT",     
  "NULL",          "PRIMARY",       "UNIQUE",        "CHECK",       
  "REFERENCES",    "COLLATE",       "AUTOINCR",      "ON",          
  "DELETE",        "UPDATE",        "INSERT",        "SET",         
  "DEFERRABLE",    "FOREIGN",       "DROP",          "UNION",       
  "ALL",           "EXCEPT",        "INTERSECT",     "SELECT",      
  "DISTINCT",      "DOT",           "FROM",          "JOIN",        
  "USING",         "ORDER",         "BY",            "GROUP",       
  "HAVING",        "LIMIT",         "WHERE",         "INTO",        
  "VALUES",        "INTEGER",       "FLOAT",         "BLOB",        
  "REGISTER",      "VARIABLE",      "CASE",          "WHEN",        
  "THEN",          "ELSE",          "INDEX",         "ALTER",       
  "TO",            "ADD",           "COLUMNKW",      "error",       
  "input",         "cmdlist",       "ecmd",          "cmdx",        
  "cmd",           "explain",       "transtype",     "trans_opt",   
  "nm",            "create_table",  "create_table_args",  "temp",        
  "ifnotexists",   "dbnm",          "columnlist",    "conslist_opt",
  "select",        "column",        "columnid",      "type",        
  "carglist",      "id",            "ids",           "typetoken",   
  "typename",      "signed",        "plus_num",      "minus_num",   
  "carg",          "ccons",         "term",          "expr",        
  "onconf",        "sortorder",     "autoinc",       "idxlist_opt", 
  "refargs",       "defer_subclause",  "refarg",        "refact",      
  "init_deferred_pred_opt",  "conslist",      "tcons",         "idxlist",     
  "defer_subclause_opt",  "orconf",        "resolvetype",   "raisetype",   
  "ifexists",      "fullname",      "oneselect",     "multiselect_op",
  "distinct",      "selcollist",    "from",          "where_opt",   
  "groupby_opt",   "having_opt",    "orderby_opt",   "limit_opt",   
  "sclp",          "as",            "seltablist",    "stl_prefix",  
  "joinop",        "on_opt",        "using_opt",     "seltablist_paren",
  "joinop2",       "inscollist",    "sortlist",      "sortitem",    
  "collate",       "exprlist",      "setlist",       "insert_cmd",  
  "inscollist_opt",  "itemlist",      "likeop",        "escape",      
  "between_op",    "in_op",         "case_operand",  "case_exprlist",
  "case_else",     "expritem",      "uniqueflag",    "idxitem",     
  "plus_opt",      "number",        "trigger_decl",  "trigger_cmd_list",
  "trigger_time",  "trigger_event",  "foreach_clause",  "when_clause", 
  "trigger_cmd",   "database_kw_opt",  "key_opt",       "add_column_fullname",
  "kwcolumn_opt",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "explain ::= EXPLAIN",
 /*   8 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "transtype ::=",
 /*  14 */ "transtype ::= DEFERRED",
 /*  15 */ "transtype ::= IMMEDIATE",
 /*  16 */ "transtype ::= EXCLUSIVE",
 /*  17 */ "cmd ::= COMMIT trans_opt",
 /*  18 */ "cmd ::= END trans_opt",
 /*  19 */ "cmd ::= ROLLBACK trans_opt",
 /*  20 */ "cmd ::= create_table create_table_args",
 /*  21 */ "create_table ::= CREATE temp TABLE ifnotexists nm dbnm",
 /*  22 */ "ifnotexists ::=",
 /*  23 */ "ifnotexists ::= IF NOT EXISTS",
 /*  24 */ "temp ::= TEMP",
 /*  25 */ "temp ::=",
 /*  26 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  27 */ "create_table_args ::= AS select",
 /*  28 */ "columnlist ::= columnlist COMMA column",
 /*  29 */ "columnlist ::= column",
 /*  30 */ "column ::= columnid type carglist",
 /*  31 */ "columnid ::= nm",
 /*  32 */ "id ::= ID",
 /*  33 */ "ids ::= ID|STRING",
 /*  34 */ "nm ::= ID",
 /*  35 */ "nm ::= STRING",
 /*  36 */ "nm ::= JOIN_KW",
 /*  37 */ "type ::=",
 /*  38 */ "type ::= typetoken",
 /*  39 */ "typetoken ::= typename",
 /*  40 */ "typetoken ::= typename LP signed RP",
 /*  41 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  42 */ "typename ::= ids",
 /*  43 */ "typename ::= typename ids",
 /*  44 */ "signed ::= plus_num",
 /*  45 */ "signed ::= minus_num",
 /*  46 */ "carglist ::= carglist carg",
 /*  47 */ "carglist ::=",
 /*  48 */ "carg ::= CONSTRAINT nm ccons",
 /*  49 */ "carg ::= ccons",
 /*  50 */ "carg ::= DEFAULT term",
 /*  51 */ "carg ::= DEFAULT LP expr RP",
 /*  52 */ "carg ::= DEFAULT PLUS term",
 /*  53 */ "carg ::= DEFAULT MINUS term",
 /*  54 */ "carg ::= DEFAULT id",
 /*  55 */ "ccons ::= NULL onconf",
 /*  56 */ "ccons ::= NOT NULL onconf",
 /*  57 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  58 */ "ccons ::= UNIQUE onconf",
 /*  59 */ "ccons ::= CHECK LP expr RP",
 /*  60 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  61 */ "ccons ::= defer_subclause",
 /*  62 */ "ccons ::= COLLATE id",
 /*  63 */ "autoinc ::=",
 /*  64 */ "autoinc ::= AUTOINCR",
 /*  65 */ "refargs ::=",
 /*  66 */ "refargs ::= refargs refarg",
 /*  67 */ "refarg ::= MATCH nm",
 /*  68 */ "refarg ::= ON DELETE refact",
 /*  69 */ "refarg ::= ON UPDATE refact",
 /*  70 */ "refarg ::= ON INSERT refact",
 /*  71 */ "refact ::= SET NULL",
 /*  72 */ "refact ::= SET DEFAULT",
 /*  73 */ "refact ::= CASCADE",
 /*  74 */ "refact ::= RESTRICT",
 /*  75 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  76 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  77 */ "init_deferred_pred_opt ::=",
 /*  78 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  79 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  80 */ "conslist_opt ::=",
 /*  81 */ "conslist_opt ::= COMMA conslist",
 /*  82 */ "conslist ::= conslist COMMA tcons",
 /*  83 */ "conslist ::= conslist tcons",
 /*  84 */ "conslist ::= tcons",
 /*  85 */ "tcons ::= CONSTRAINT nm",
 /*  86 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  87 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  88 */ "tcons ::= CHECK LP expr RP onconf",
 /*  89 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  90 */ "defer_subclause_opt ::=",
 /*  91 */ "defer_subclause_opt ::= defer_subclause",
 /*  92 */ "onconf ::=",
 /*  93 */ "onconf ::= ON CONFLICT resolvetype",
 /*  94 */ "orconf ::=",
 /*  95 */ "orconf ::= OR resolvetype",
 /*  96 */ "resolvetype ::= raisetype",
 /*  97 */ "resolvetype ::= IGNORE",
 /*  98 */ "resolvetype ::= REPLACE",
 /*  99 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 100 */ "ifexists ::= IF EXISTS",
 /* 101 */ "ifexists ::=",
 /* 102 */ "cmd ::= CREATE temp VIEW nm dbnm AS select",
 /* 103 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 104 */ "cmd ::= select",
 /* 105 */ "select ::= oneselect",
 /* 106 */ "select ::= select multiselect_op oneselect",
 /* 107 */ "multiselect_op ::= UNION",
 /* 108 */ "multiselect_op ::= UNION ALL",
 /* 109 */ "multiselect_op ::= EXCEPT|INTERSECT",
 /* 110 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 111 */ "distinct ::= DISTINCT",
 /* 112 */ "distinct ::= ALL",
 /* 113 */ "distinct ::=",
 /* 114 */ "sclp ::= selcollist COMMA",
 /* 115 */ "sclp ::=",
 /* 116 */ "selcollist ::= sclp expr as",
 /* 117 */ "selcollist ::= sclp STAR",
 /* 118 */ "selcollist ::= sclp nm DOT STAR",
 /* 119 */ "as ::= AS nm",
 /* 120 */ "as ::= ids",
 /* 121 */ "as ::=",
 /* 122 */ "from ::=",
 /* 123 */ "from ::= FROM seltablist",
 /* 124 */ "stl_prefix ::= seltablist joinop",
 /* 125 */ "stl_prefix ::=",
 /* 126 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 127 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 128 */ "seltablist_paren ::= select",
 /* 129 */ "seltablist_paren ::= seltablist",
 /* 130 */ "dbnm ::=",
 /* 131 */ "dbnm ::= DOT nm",
 /* 132 */ "fullname ::= nm dbnm",
 /* 133 */ "joinop ::= COMMA|JOIN",
 /* 134 */ "joinop ::= JOIN_KW JOIN",
 /* 135 */ "joinop ::= JOIN_KW nm JOIN",
 /* 136 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 137 */ "on_opt ::= ON expr",
 /* 138 */ "on_opt ::=",
 /* 139 */ "using_opt ::= USING LP inscollist RP",
 /* 140 */ "using_opt ::=",
 /* 141 */ "orderby_opt ::=",
 /* 142 */ "orderby_opt ::= ORDER BY sortlist",
 /* 143 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 144 */ "sortlist ::= sortitem collate sortorder",
 /* 145 */ "sortitem ::= expr",
 /* 146 */ "sortorder ::= ASC",
 /* 147 */ "sortorder ::= DESC",
 /* 148 */ "sortorder ::=",
 /* 149 */ "collate ::=",
 /* 150 */ "collate ::= COLLATE id",
 /* 151 */ "groupby_opt ::=",
 /* 152 */ "groupby_opt ::= GROUP BY exprlist",
 /* 153 */ "having_opt ::=",
 /* 154 */ "having_opt ::= HAVING expr",
 /* 155 */ "limit_opt ::=",
 /* 156 */ "limit_opt ::= LIMIT expr",
 /* 157 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 158 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 159 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 160 */ "where_opt ::=",
 /* 161 */ "where_opt ::= WHERE expr",
 /* 162 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 163 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 164 */ "setlist ::= nm EQ expr",
 /* 165 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 166 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 167 */ "cmd ::= insert_cmd INTO fullname inscollist_opt DEFAULT VALUES",
 /* 168 */ "insert_cmd ::= INSERT orconf",
 /* 169 */ "insert_cmd ::= REPLACE",
 /* 170 */ "itemlist ::= itemlist COMMA expr",
 /* 171 */ "itemlist ::= expr",
 /* 172 */ "inscollist_opt ::=",
 /* 173 */ "inscollist_opt ::= LP inscollist RP",
 /* 174 */ "inscollist ::= inscollist COMMA nm",
 /* 175 */ "inscollist ::= nm",
 /* 176 */ "expr ::= term",
 /* 177 */ "expr ::= LP expr RP",
 /* 178 */ "term ::= NULL",
 /* 179 */ "expr ::= ID",
 /* 180 */ "expr ::= JOIN_KW",
 /* 181 */ "expr ::= nm DOT nm",
 /* 182 */ "expr ::= nm DOT nm DOT nm",
 /* 183 */ "term ::= INTEGER|FLOAT|BLOB",
 /* 184 */ "term ::= STRING",
 /* 185 */ "expr ::= REGISTER",
 /* 186 */ "expr ::= VARIABLE",
 /* 187 */ "expr ::= CAST LP expr AS typetoken RP",
 /* 188 */ "expr ::= ID LP distinct exprlist RP",
 /* 189 */ "expr ::= ID LP STAR RP",
 /* 190 */ "term ::= CTIME_KW",
 /* 191 */ "expr ::= expr AND expr",
 /* 192 */ "expr ::= expr OR expr",
 /* 193 */ "expr ::= expr LT|GT|GE|LE expr",
 /* 194 */ "expr ::= expr EQ|NE expr",
 /* 195 */ "expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 196 */ "expr ::= expr PLUS|MINUS expr",
 /* 197 */ "expr ::= expr STAR|SLASH|REM expr",
 /* 198 */ "expr ::= expr CONCAT expr",
 /* 199 */ "likeop ::= LIKE_KW",
 /* 200 */ "likeop ::= NOT LIKE_KW",
 /* 201 */ "likeop ::= MATCH",
 /* 202 */ "likeop ::= NOT MATCH",
 /* 203 */ "escape ::= ESCAPE expr",
 /* 204 */ "escape ::=",
 /* 205 */ "expr ::= expr likeop expr escape",
 /* 206 */ "expr ::= expr ISNULL|NOTNULL",
 /* 207 */ "expr ::= expr IS NULL",
 /* 208 */ "expr ::= expr NOT NULL",
 /* 209 */ "expr ::= expr IS NOT NULL",
 /* 210 */ "expr ::= NOT|BITNOT expr",
 /* 211 */ "expr ::= MINUS expr",
 /* 212 */ "expr ::= PLUS expr",
 /* 213 */ "between_op ::= BETWEEN",
 /* 214 */ "between_op ::= NOT BETWEEN",
 /* 215 */ "expr ::= expr between_op expr AND expr",
 /* 216 */ "in_op ::= IN",
 /* 217 */ "in_op ::= NOT IN",
 /* 218 */ "expr ::= expr in_op LP exprlist RP",
 /* 219 */ "expr ::= LP select RP",
 /* 220 */ "expr ::= expr in_op LP select RP",
 /* 221 */ "expr ::= expr in_op nm dbnm",
 /* 222 */ "expr ::= EXISTS LP select RP",
 /* 223 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 224 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 225 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 226 */ "case_else ::= ELSE expr",
 /* 227 */ "case_else ::=",
 /* 228 */ "case_operand ::= expr",
 /* 229 */ "case_operand ::=",
 /* 230 */ "exprlist ::= exprlist COMMA expritem",
 /* 231 */ "exprlist ::= expritem",
 /* 232 */ "expritem ::= expr",
 /* 233 */ "expritem ::=",
 /* 234 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP",
 /* 235 */ "uniqueflag ::= UNIQUE",
 /* 236 */ "uniqueflag ::=",
 /* 237 */ "idxlist_opt ::=",
 /* 238 */ "idxlist_opt ::= LP idxlist RP",
 /* 239 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 240 */ "idxlist ::= idxitem collate sortorder",
 /* 241 */ "idxitem ::= nm",
 /* 242 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 243 */ "cmd ::= VACUUM",
 /* 244 */ "cmd ::= VACUUM nm",
 /* 245 */ "cmd ::= PRAGMA nm dbnm EQ nm",
 /* 246 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 247 */ "cmd ::= PRAGMA nm dbnm EQ plus_num",
 /* 248 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 249 */ "cmd ::= PRAGMA nm dbnm LP nm RP",
 /* 250 */ "cmd ::= PRAGMA nm dbnm",
 /* 251 */ "plus_num ::= plus_opt number",
 /* 252 */ "minus_num ::= MINUS number",
 /* 253 */ "number ::= INTEGER|FLOAT",
 /* 254 */ "plus_opt ::= PLUS",
 /* 255 */ "plus_opt ::=",
 /* 256 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 257 */ "trigger_decl ::= temp TRIGGER nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 258 */ "trigger_time ::= BEFORE",
 /* 259 */ "trigger_time ::= AFTER",
 /* 260 */ "trigger_time ::= INSTEAD OF",
 /* 261 */ "trigger_time ::=",
 /* 262 */ "trigger_event ::= DELETE|INSERT",
 /* 263 */ "trigger_event ::= UPDATE",
 /* 264 */ "trigger_event ::= UPDATE OF inscollist",
 /* 265 */ "foreach_clause ::=",
 /* 266 */ "foreach_clause ::= FOR EACH ROW",
 /* 267 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 268 */ "when_clause ::=",
 /* 269 */ "when_clause ::= WHEN expr",
 /* 270 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 271 */ "trigger_cmd_list ::=",
 /* 272 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 273 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 274 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 275 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 276 */ "trigger_cmd ::= select",
 /* 277 */ "expr ::= RAISE LP IGNORE RP",
 /* 278 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 279 */ "raisetype ::= ROLLBACK",
 /* 280 */ "raisetype ::= ABORT",
 /* 281 */ "raisetype ::= FAIL",
 /* 282 */ "cmd ::= DROP TRIGGER fullname",
 /* 283 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 284 */ "key_opt ::=",
 /* 285 */ "key_opt ::= KEY expr",
 /* 286 */ "database_kw_opt ::= DATABASE",
 /* 287 */ "database_kw_opt ::=",
 /* 288 */ "cmd ::= DETACH database_kw_opt expr",
 /* 289 */ "cmd ::= REINDEX",
 /* 290 */ "cmd ::= REINDEX nm dbnm",
 /* 291 */ "cmd ::= ANALYZE",
 /* 292 */ "cmd ::= ANALYZE nm dbnm",
 /* 293 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 294 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 295 */ "add_column_fullname ::= fullname",
 /* 296 */ "kwcolumn_opt ::=",
 /* 297 */ "kwcolumn_opt ::= COLUMNKW",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqlite3ParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 156:
    case 190:
    case 207:
#line 374 "parse.y"
{sqlite3SelectDelete((yypminor->yy313));}
#line 1226 "parse.c"
      break;
    case 170:
    case 171:
    case 195:
    case 197:
    case 205:
    case 211:
    case 219:
    case 222:
    case 224:
    case 225:
    case 235:
#line 633 "parse.y"
{sqlite3ExprDelete((yypminor->yy162));}
#line 1241 "parse.c"
      break;
    case 175:
    case 183:
    case 193:
    case 196:
    case 198:
    case 200:
    case 210:
    case 213:
    case 214:
    case 217:
    case 223:
#line 870 "parse.y"
{sqlite3ExprListDelete((yypminor->yy44));}
#line 1256 "parse.c"
      break;
    case 189:
    case 194:
    case 202:
    case 203:
#line 502 "parse.y"
{sqlite3SrcListDelete((yypminor->yy149));}
#line 1264 "parse.c"
      break;
    case 199:
#line 563 "parse.y"
{
  sqlite3ExprDelete((yypminor->yy278).pLimit);
  sqlite3ExprDelete((yypminor->yy278).pOffset);
}
#line 1272 "parse.c"
      break;
    case 206:
    case 209:
    case 216:
#line 519 "parse.y"
{sqlite3IdListDelete((yypminor->yy326));}
#line 1279 "parse.c"
      break;
    case 231:
    case 236:
#line 964 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy137));}
#line 1285 "parse.c"
      break;
    case 233:
#line 948 "parse.y"
{sqlite3IdListDelete((yypminor->yy412).b);}
#line 1290 "parse.c"
      break;
    case 238:
#line 1032 "parse.y"
{sqlite3ExprDelete((yypminor->yy116));}
#line 1295 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      int iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  if( stateno>YY_REDUCE_MAX ||
      (i = yy_reduce_ofst[stateno])==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqlite3ParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
#line 44 "parse.y"

  sqlite3ErrorMsg(pParse, "parser stack overflow");
  pParse->parseError = 1;
#line 1464 "parse.c"
     sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 140, 1 },
  { 141, 2 },
  { 141, 1 },
  { 143, 1 },
  { 142, 1 },
  { 142, 3 },
  { 145, 0 },
  { 145, 1 },
  { 145, 3 },
  { 144, 3 },
  { 147, 0 },
  { 147, 1 },
  { 147, 2 },
  { 146, 0 },
  { 146, 1 },
  { 146, 1 },
  { 146, 1 },
  { 144, 2 },
  { 144, 2 },
  { 144, 2 },
  { 144, 2 },
  { 149, 6 },
  { 152, 0 },
  { 152, 3 },
  { 151, 1 },
  { 151, 0 },
  { 150, 4 },
  { 150, 2 },
  { 154, 3 },
  { 154, 1 },
  { 157, 3 },
  { 158, 1 },
  { 161, 1 },
  { 162, 1 },
  { 148, 1 },
  { 148, 1 },
  { 148, 1 },
  { 159, 0 },
  { 159, 1 },
  { 163, 1 },
  { 163, 4 },
  { 163, 6 },
  { 164, 1 },
  { 164, 2 },
  { 165, 1 },
  { 165, 1 },
  { 160, 2 },
  { 160, 0 },
  { 168, 3 },
  { 168, 1 },
  { 168, 2 },
  { 168, 4 },
  { 168, 3 },
  { 168, 3 },
  { 168, 2 },
  { 169, 2 },
  { 169, 3 },
  { 169, 5 },
  { 169, 2 },
  { 169, 4 },
  { 169, 4 },
  { 169, 1 },
  { 169, 2 },
  { 174, 0 },
  { 174, 1 },
  { 176, 0 },
  { 176, 2 },
  { 178, 2 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 179, 2 },
  { 179, 2 },
  { 179, 1 },
  { 179, 1 },
  { 177, 3 },
  { 177, 2 },
  { 180, 0 },
  { 180, 2 },
  { 180, 2 },
  { 155, 0 },
  { 155, 2 },
  { 181, 3 },
  { 181, 2 },
  { 181, 1 },
  { 182, 2 },
  { 182, 7 },
  { 182, 5 },
  { 182, 5 },
  { 182, 10 },
  { 184, 0 },
  { 184, 1 },
  { 172, 0 },
  { 172, 3 },
  { 185, 0 },
  { 185, 2 },
  { 186, 1 },
  { 186, 1 },
  { 186, 1 },
  { 144, 4 },
  { 188, 2 },
  { 188, 0 },
  { 144, 7 },
  { 144, 4 },
  { 144, 1 },
  { 156, 1 },
  { 156, 3 },
  { 191, 1 },
  { 191, 2 },
  { 191, 1 },
  { 190, 9 },
  { 192, 1 },
  { 192, 1 },
  { 192, 0 },
  { 200, 2 },
  { 200, 0 },
  { 193, 3 },
  { 193, 2 },
  { 193, 4 },
  { 201, 2 },
  { 201, 1 },
  { 201, 0 },
  { 194, 0 },
  { 194, 2 },
  { 203, 2 },
  { 203, 0 },
  { 202, 6 },
  { 202, 7 },
  { 207, 1 },
  { 207, 1 },
  { 153, 0 },
  { 153, 2 },
  { 189, 2 },
  { 204, 1 },
  { 204, 2 },
  { 204, 3 },
  { 204, 4 },
  { 205, 2 },
  { 205, 0 },
  { 206, 4 },
  { 206, 0 },
  { 198, 0 },
  { 198, 3 },
  { 210, 5 },
  { 210, 3 },
  { 211, 1 },
  { 173, 1 },
  { 173, 1 },
  { 173, 0 },
  { 212, 0 },
  { 212, 2 },
  { 196, 0 },
  { 196, 3 },
  { 197, 0 },
  { 197, 2 },
  { 199, 0 },
  { 199, 2 },
  { 199, 4 },
  { 199, 4 },
  { 144, 4 },
  { 195, 0 },
  { 195, 2 },
  { 144, 6 },
  { 214, 5 },
  { 214, 3 },
  { 144, 8 },
  { 144, 5 },
  { 144, 6 },
  { 215, 2 },
  { 215, 1 },
  { 217, 3 },
  { 217, 1 },
  { 216, 0 },
  { 216, 3 },
  { 209, 3 },
  { 209, 1 },
  { 171, 1 },
  { 171, 3 },
  { 170, 1 },
  { 171, 1 },
  { 171, 1 },
  { 171, 3 },
  { 171, 5 },
  { 170, 1 },
  { 170, 1 },
  { 171, 1 },
  { 171, 1 },
  { 171, 6 },
  { 171, 5 },
  { 171, 4 },
  { 170, 1 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 218, 1 },
  { 218, 2 },
  { 218, 1 },
  { 218, 2 },
  { 219, 2 },
  { 219, 0 },
  { 171, 4 },
  { 171, 2 },
  { 171, 3 },
  { 171, 3 },
  { 171, 4 },
  { 171, 2 },
  { 171, 2 },
  { 171, 2 },
  { 220, 1 },
  { 220, 2 },
  { 171, 5 },
  { 221, 1 },
  { 221, 2 },
  { 171, 5 },
  { 171, 3 },
  { 171, 5 },
  { 171, 4 },
  { 171, 4 },
  { 171, 5 },
  { 223, 5 },
  { 223, 4 },
  { 224, 2 },
  { 224, 0 },
  { 222, 1 },
  { 222, 0 },
  { 213, 3 },
  { 213, 1 },
  { 225, 1 },
  { 225, 0 },
  { 144, 11 },
  { 226, 1 },
  { 226, 0 },
  { 175, 0 },
  { 175, 3 },
  { 183, 5 },
  { 183, 3 },
  { 227, 1 },
  { 144, 4 },
  { 144, 1 },
  { 144, 2 },
  { 144, 5 },
  { 144, 5 },
  { 144, 5 },
  { 144, 5 },
  { 144, 6 },
  { 144, 3 },
  { 166, 2 },
  { 167, 2 },
  { 229, 1 },
  { 228, 1 },
  { 228, 0 },
  { 144, 5 },
  { 230, 10 },
  { 232, 1 },
  { 232, 1 },
  { 232, 2 },
  { 232, 0 },
  { 233, 1 },
  { 233, 1 },
  { 233, 3 },
  { 234, 0 },
  { 234, 3 },
  { 234, 3 },
  { 235, 0 },
  { 235, 2 },
  { 231, 3 },
  { 231, 0 },
  { 236, 6 },
  { 236, 8 },
  { 236, 5 },
  { 236, 4 },
  { 236, 1 },
  { 171, 4 },
  { 171, 6 },
  { 187, 1 },
  { 187, 1 },
  { 187, 1 },
  { 144, 3 },
  { 144, 6 },
  { 238, 0 },
  { 238, 2 },
  { 237, 1 },
  { 237, 0 },
  { 144, 3 },
  { 144, 1 },
  { 144, 3 },
  { 144, 1 },
  { 144, 3 },
  { 144, 6 },
  { 144, 6 },
  { 239, 1 },
  { 240, 0 },
  { 240, 1 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

#ifndef NDEBUG
  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  */
  memset(&yygotominor, 0, sizeof(yygotominor));
#endif

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 3:
#line 100 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1840 "parse.c"
        break;
      case 6:
#line 103 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1845 "parse.c"
        break;
      case 7:
#line 105 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1850 "parse.c"
        break;
      case 8:
#line 106 "parse.y"
{ sqlite3BeginParse(pParse, 2); }
#line 1855 "parse.c"
        break;
      case 9:
#line 112 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy124);}
#line 1860 "parse.c"
        break;
      case 13:
#line 117 "parse.y"
{yygotominor.yy124 = TK_DEFERRED;}
#line 1865 "parse.c"
        break;
      case 14:
      case 15:
      case 16:
      case 107:
      case 109:
#line 118 "parse.y"
{yygotominor.yy124 = yymsp[0].major;}
#line 1874 "parse.c"
        break;
      case 17:
      case 18:
#line 121 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1880 "parse.c"
        break;
      case 19:
#line 123 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 1885 "parse.c"
        break;
      case 21:
#line 128 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-1].minor.yy210,&yymsp[0].minor.yy210,yymsp[-4].minor.yy124,0,0,yymsp[-2].minor.yy124);
}
#line 1892 "parse.c"
        break;
      case 22:
      case 25:
      case 63:
      case 77:
      case 79:
      case 90:
      case 101:
      case 112:
      case 113:
      case 213:
      case 216:
#line 132 "parse.y"
{yygotominor.yy124 = 0;}
#line 1907 "parse.c"
        break;
      case 23:
      case 24:
      case 64:
      case 78:
      case 100:
      case 111:
      case 214:
      case 217:
#line 133 "parse.y"
{yygotominor.yy124 = 1;}
#line 1919 "parse.c"
        break;
      case 26:
#line 139 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy210,&yymsp[0].minor.yy0,0);
}
#line 1926 "parse.c"
        break;
      case 27:
#line 142 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy313);
  sqlite3SelectDelete(yymsp[0].minor.yy313);
}
#line 1934 "parse.c"
        break;
      case 30:
#line 154 "parse.y"
{
  yygotominor.yy210.z = yymsp[-2].minor.yy210.z;
  yygotominor.yy210.n = (pParse->sLastToken.z-yymsp[-2].minor.yy210.z) + pParse->sLastToken.n;
}
#line 1942 "parse.c"
        break;
      case 31:
#line 158 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy210);
  yygotominor.yy210 = yymsp[0].minor.yy210;
}
#line 1950 "parse.c"
        break;
      case 32:
      case 33:
      case 34:
      case 35:
      case 36:
      case 253:
#line 168 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy0;}
#line 1960 "parse.c"
        break;
      case 38:
#line 228 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy210);}
#line 1965 "parse.c"
        break;
      case 39:
      case 42:
      case 119:
      case 120:
      case 131:
      case 150:
      case 241:
      case 251:
      case 252:
#line 229 "parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy210;}
#line 1978 "parse.c"
        break;
      case 40:
#line 230 "parse.y"
{
  yygotominor.yy210.z = yymsp[-3].minor.yy210.z;
  yygotominor.yy210.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-3].minor.yy210.z;
}
#line 1986 "parse.c"
        break;
      case 41:
#line 234 "parse.y"
{
  yygotominor.yy210.z = yymsp[-5].minor.yy210.z;
  yygotominor.yy210.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-5].minor.yy210.z;
}
#line 1994 "parse.c"
        break;
      case 43:
#line 240 "parse.y"
{yygotominor.yy210.z=yymsp[-1].minor.yy210.z; yygotominor.yy210.n=yymsp[0].minor.yy210.n+(yymsp[0].minor.yy210.z-yymsp[-1].minor.yy210.z);}
#line 1999 "parse.c"
        break;
      case 44:
#line 242 "parse.y"
{ yygotominor.yy124 = atoi((char*)yymsp[0].minor.yy210.z); }
#line 2004 "parse.c"
        break;
      case 45:
#line 243 "parse.y"
{ yygotominor.yy124 = -atoi((char*)yymsp[0].minor.yy210.z); }
#line 2009 "parse.c"
        break;
      case 50:
      case 52:
#line 252 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy162);}
#line 2015 "parse.c"
        break;
      case 51:
#line 253 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[-1].minor.yy162);}
#line 2020 "parse.c"
        break;
      case 53:
#line 255 "parse.y"
{
  Expr *p = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy162, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2028 "parse.c"
        break;
      case 54:
#line 259 "parse.y"
{
  Expr *p = sqlite3Expr(TK_STRING, 0, 0, &yymsp[0].minor.yy210);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2036 "parse.c"
        break;
      case 56:
#line 268 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy124);}
#line 2041 "parse.c"
        break;
      case 57:
#line 270 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy124,yymsp[0].minor.yy124,yymsp[-2].minor.yy124);}
#line 2046 "parse.c"
        break;
      case 58:
#line 271 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy124,0,0,0,0);}
#line 2051 "parse.c"
        break;
      case 59:
#line 272 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-1].minor.yy162);}
#line 2056 "parse.c"
        break;
      case 60:
#line 274 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy210,yymsp[-1].minor.yy44,yymsp[0].minor.yy124);}
#line 2061 "parse.c"
        break;
      case 61:
#line 275 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy124);}
#line 2066 "parse.c"
        break;
      case 62:
#line 276 "parse.y"
{sqlite3AddCollateType(pParse, (char*)yymsp[0].minor.yy210.z, yymsp[0].minor.yy210.n);}
#line 2071 "parse.c"
        break;
      case 65:
#line 289 "parse.y"
{ yygotominor.yy124 = OE_Restrict * 0x010101; }
#line 2076 "parse.c"
        break;
      case 66:
#line 290 "parse.y"
{ yygotominor.yy124 = (yymsp[-1].minor.yy124 & yymsp[0].minor.yy317.mask) | yymsp[0].minor.yy317.value; }
#line 2081 "parse.c"
        break;
      case 67:
#line 292 "parse.y"
{ yygotominor.yy317.value = 0;     yygotominor.yy317.mask = 0x000000; }
#line 2086 "parse.c"
        break;
      case 68:
#line 293 "parse.y"
{ yygotominor.yy317.value = yymsp[0].minor.yy124;     yygotominor.yy317.mask = 0x0000ff; }
#line 2091 "parse.c"
        break;
      case 69:
#line 294 "parse.y"
{ yygotominor.yy317.value = yymsp[0].minor.yy124<<8;  yygotominor.yy317.mask = 0x00ff00; }
#line 2096 "parse.c"
        break;
      case 70:
#line 295 "parse.y"
{ yygotominor.yy317.value = yymsp[0].minor.yy124<<16; yygotominor.yy317.mask = 0xff0000; }
#line 2101 "parse.c"
        break;
      case 71:
#line 297 "parse.y"
{ yygotominor.yy124 = OE_SetNull; }
#line 2106 "parse.c"
        break;
      case 72:
#line 298 "parse.y"
{ yygotominor.yy124 = OE_SetDflt; }
#line 2111 "parse.c"
        break;
      case 73:
#line 299 "parse.y"
{ yygotominor.yy124 = OE_Cascade; }
#line 2116 "parse.c"
        break;
      case 74:
#line 300 "parse.y"
{ yygotominor.yy124 = OE_Restrict; }
#line 2121 "parse.c"
        break;
      case 75:
      case 76:
      case 91:
      case 93:
      case 95:
      case 96:
      case 168:
#line 302 "parse.y"
{yygotominor.yy124 = yymsp[0].minor.yy124;}
#line 2132 "parse.c"
        break;
      case 80:
#line 312 "parse.y"
{yygotominor.yy210.n = 0; yygotominor.yy210.z = 0;}
#line 2137 "parse.c"
        break;
      case 81:
#line 313 "parse.y"
{yygotominor.yy210 = yymsp[-1].minor.yy0;}
#line 2142 "parse.c"
        break;
      case 86:
#line 319 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy44,yymsp[0].minor.yy124,yymsp[-2].minor.yy124,0);}
#line 2147 "parse.c"
        break;
      case 87:
#line 321 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy44,yymsp[0].minor.yy124,0,0,0,0);}
#line 2152 "parse.c"
        break;
      case 88:
#line 322 "parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-2].minor.yy162);}
#line 2157 "parse.c"
        break;
      case 89:
#line 324 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy44, &yymsp[-3].minor.yy210, yymsp[-2].minor.yy44, yymsp[-1].minor.yy124);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy124);
}
#line 2165 "parse.c"
        break;
      case 92:
      case 94:
#line 338 "parse.y"
{yygotominor.yy124 = OE_Default;}
#line 2171 "parse.c"
        break;
      case 97:
#line 343 "parse.y"
{yygotominor.yy124 = OE_Ignore;}
#line 2176 "parse.c"
        break;
      case 98:
      case 169:
#line 344 "parse.y"
{yygotominor.yy124 = OE_Replace;}
#line 2182 "parse.c"
        break;
      case 99:
#line 348 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy149, 0, yymsp[-1].minor.yy124);
}
#line 2189 "parse.c"
        break;
      case 102:
#line 358 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-6].minor.yy0, &yymsp[-3].minor.yy210, &yymsp[-2].minor.yy210, yymsp[0].minor.yy313, yymsp[-5].minor.yy124);
}
#line 2196 "parse.c"
        break;
      case 103:
#line 361 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy149, 1, yymsp[-1].minor.yy124);
}
#line 2203 "parse.c"
        break;
      case 104:
#line 368 "parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy313, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy313);
}
#line 2211 "parse.c"
        break;
      case 105:
      case 128:
#line 378 "parse.y"
{yygotominor.yy313 = yymsp[0].minor.yy313;}
#line 2217 "parse.c"
        break;
      case 106:
#line 380 "parse.y"
{
  if( yymsp[0].minor.yy313 ){
    yymsp[0].minor.yy313->op = yymsp[-1].minor.yy124;
    yymsp[0].minor.yy313->pPrior = yymsp[-2].minor.yy313;
  }
  yygotominor.yy313 = yymsp[0].minor.yy313;
}
#line 2228 "parse.c"
        break;
      case 108:
#line 389 "parse.y"
{yygotominor.yy124 = TK_ALL;}
#line 2233 "parse.c"
        break;
      case 110:
#line 393 "parse.y"
{
  yygotominor.yy313 = sqlite3SelectNew(yymsp[-6].minor.yy44,yymsp[-5].minor.yy149,yymsp[-4].minor.yy162,yymsp[-3].minor.yy44,yymsp[-2].minor.yy162,yymsp[-1].minor.yy44,yymsp[-7].minor.yy124,yymsp[0].minor.yy278.pLimit,yymsp[0].minor.yy278.pOffset);
}
#line 2240 "parse.c"
        break;
      case 114:
      case 238:
#line 414 "parse.y"
{yygotominor.yy44 = yymsp[-1].minor.yy44;}
#line 2246 "parse.c"
        break;
      case 115:
      case 141:
      case 151:
      case 237:
#line 415 "parse.y"
{yygotominor.yy44 = 0;}
#line 2254 "parse.c"
        break;
      case 116:
#line 416 "parse.y"
{
   yygotominor.yy44 = sqlite3ExprListAppend(yymsp[-2].minor.yy44,yymsp[-1].minor.yy162,yymsp[0].minor.yy210.n?&yymsp[0].minor.yy210:0);
}
#line 2261 "parse.c"
        break;
      case 117:
#line 419 "parse.y"
{
  yygotominor.yy44 = sqlite3ExprListAppend(yymsp[-1].minor.yy44, sqlite3Expr(TK_ALL, 0, 0, 0), 0);
}
#line 2268 "parse.c"
        break;
      case 118:
#line 422 "parse.y"
{
  Expr *pRight = sqlite3Expr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy210);
  yygotominor.yy44 = sqlite3ExprListAppend(yymsp[-3].minor.yy44, sqlite3Expr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2277 "parse.c"
        break;
      case 121:
#line 434 "parse.y"
{yygotominor.yy210.n = 0;}
#line 2282 "parse.c"
        break;
      case 122:
#line 446 "parse.y"
{yygotominor.yy149 = sqliteMalloc(sizeof(*yygotominor.yy149));}
#line 2287 "parse.c"
        break;
      case 123:
#line 447 "parse.y"
{yygotominor.yy149 = yymsp[0].minor.yy149;}
#line 2292 "parse.c"
        break;
      case 124:
#line 452 "parse.y"
{
   yygotominor.yy149 = yymsp[-1].minor.yy149;
   if( yygotominor.yy149 && yygotominor.yy149->nSrc>0 ) yygotominor.yy149->a[yygotominor.yy149->nSrc-1].jointype = yymsp[0].minor.yy124;
}
#line 2300 "parse.c"
        break;
      case 125:
#line 456 "parse.y"
{yygotominor.yy149 = 0;}
#line 2305 "parse.c"
        break;
      case 126:
#line 457 "parse.y"
{
  yygotominor.yy149 = sqlite3SrcListAppend(yymsp[-5].minor.yy149,&yymsp[-4].minor.yy210,&yymsp[-3].minor.yy210);
  if( yymsp[-2].minor.yy210.n ) sqlite3SrcListAddAlias(yygotominor.yy149,&yymsp[-2].minor.yy210);
  if( yymsp[-1].minor.yy162 ){
    if( yygotominor.yy149 && yygotominor.yy149->nSrc>1 ){ yygotominor.yy149->a[yygotominor.yy149->nSrc-2].pOn = yymsp[-1].minor.yy162; }
    else { sqlite3ExprDelete(yymsp[-1].minor.yy162); }
  }
  if( yymsp[0].minor.yy326 ){
    if( yygotominor.yy149 && yygotominor.yy149->nSrc>1 ){ yygotominor.yy149->a[yygotominor.yy149->nSrc-2].pUsing = yymsp[0].minor.yy326; }
    else { sqlite3IdListDelete(yymsp[0].minor.yy326); }
  }
}
#line 2321 "parse.c"
        break;
      case 127:
#line 471 "parse.y"
{
    yygotominor.yy149 = sqlite3SrcListAppend(yymsp[-6].minor.yy149,0,0);
    if( yygotominor.yy149 && yygotominor.yy149->nSrc>0 ) yygotominor.yy149->a[yygotominor.yy149->nSrc-1].pSelect = yymsp[-4].minor.yy313;
    if( yymsp[-2].minor.yy210.n ) sqlite3SrcListAddAlias(yygotominor.yy149,&yymsp[-2].minor.yy210);
    if( yymsp[-1].minor.yy162 ){
      if( yygotominor.yy149 && yygotominor.yy149->nSrc>1 ){ yygotominor.yy149->a[yygotominor.yy149->nSrc-2].pOn = yymsp[-1].minor.yy162; }
      else { sqlite3ExprDelete(yymsp[-1].minor.yy162); }
    }
    if( yymsp[0].minor.yy326 ){
      if( yygotominor.yy149 && yygotominor.yy149->nSrc>1 ){ yygotominor.yy149->a[yygotominor.yy149->nSrc-2].pUsing = yymsp[0].minor.yy326; }
      else { sqlite3IdListDelete(yymsp[0].minor.yy326); }
    }
  }
#line 2338 "parse.c"
        break;
      case 129:
#line 492 "parse.y"
{
     yygotominor.yy313 = sqlite3SelectNew(0,yymsp[0].minor.yy149,0,0,0,0,0,0,0);
  }
#line 2345 "parse.c"
        break;
      case 130:
#line 498 "parse.y"
{yygotominor.yy210.z=0; yygotominor.yy210.n=0;}
#line 2350 "parse.c"
        break;
      case 132:
#line 503 "parse.y"
{yygotominor.yy149 = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy210,&yymsp[0].minor.yy210);}
#line 2355 "parse.c"
        break;
      case 133:
#line 507 "parse.y"
{ yygotominor.yy124 = JT_INNER; }
#line 2360 "parse.c"
        break;
      case 134:
#line 508 "parse.y"
{ yygotominor.yy124 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2365 "parse.c"
        break;
      case 135:
#line 509 "parse.y"
{ yygotominor.yy124 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy210,0); }
#line 2370 "parse.c"
        break;
      case 136:
#line 511 "parse.y"
{ yygotominor.yy124 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy210,&yymsp[-1].minor.yy210); }
#line 2375 "parse.c"
        break;
      case 137:
      case 145:
      case 154:
      case 161:
      case 176:
      case 203:
      case 226:
      case 228:
      case 232:
#line 515 "parse.y"
{yygotominor.yy162 = yymsp[0].minor.yy162;}
#line 2388 "parse.c"
        break;
      case 138:
      case 153:
      case 160:
      case 204:
      case 227:
      case 229:
      case 233:
#line 516 "parse.y"
{yygotominor.yy162 = 0;}
#line 2399 "parse.c"
        break;
      case 139:
      case 173:
#line 520 "parse.y"
{yygotominor.yy326 = yymsp[-1].minor.yy326;}
#line 2405 "parse.c"
        break;
      case 140:
      case 172:
#line 521 "parse.y"
{yygotominor.yy326 = 0;}
#line 2411 "parse.c"
        break;
      case 142:
      case 152:
#line 532 "parse.y"
{yygotominor.yy44 = yymsp[0].minor.yy44;}
#line 2417 "parse.c"
        break;
      case 143:
#line 533 "parse.y"
{
  yygotominor.yy44 = sqlite3ExprListAppend(yymsp[-4].minor.yy44,yymsp[-2].minor.yy162,yymsp[-1].minor.yy210.n>0?&yymsp[-1].minor.yy210:0);
  if( yygotominor.yy44 ) yygotominor.yy44->a[yygotominor.yy44->nExpr-1].sortOrder = yymsp[0].minor.yy124;
}
#line 2425 "parse.c"
        break;
      case 144:
#line 537 "parse.y"
{
  yygotominor.yy44 = sqlite3ExprListAppend(0,yymsp[-2].minor.yy162,yymsp[-1].minor.yy210.n>0?&yymsp[-1].minor.yy210:0);
  if( yygotominor.yy44 && yygotominor.yy44->a ) yygotominor.yy44->a[0].sortOrder = yymsp[0].minor.yy124;
}
#line 2433 "parse.c"
        break;
      case 146:
      case 148:
#line 546 "parse.y"
{yygotominor.yy124 = SQLITE_SO_ASC;}
#line 2439 "parse.c"
        break;
      case 147:
#line 547 "parse.y"
{yygotominor.yy124 = SQLITE_SO_DESC;}
#line 2444 "parse.c"
        break;
      case 149:
#line 549 "parse.y"
{yygotominor.yy210.z = 0; yygotominor.yy210.n = 0;}
#line 2449 "parse.c"
        break;
      case 155:
#line 567 "parse.y"
{yygotominor.yy278.pLimit = 0; yygotominor.yy278.pOffset = 0;}
#line 2454 "parse.c"
        break;
      case 156:
#line 568 "parse.y"
{yygotominor.yy278.pLimit = yymsp[0].minor.yy162; yygotominor.yy278.pOffset = 0;}
#line 2459 "parse.c"
        break;
      case 157:
#line 570 "parse.y"
{yygotominor.yy278.pLimit = yymsp[-2].minor.yy162; yygotominor.yy278.pOffset = yymsp[0].minor.yy162;}
#line 2464 "parse.c"
        break;
      case 158:
#line 572 "parse.y"
{yygotominor.yy278.pOffset = yymsp[-2].minor.yy162; yygotominor.yy278.pLimit = yymsp[0].minor.yy162;}
#line 2469 "parse.c"
        break;
      case 159:
#line 576 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy149,yymsp[0].minor.yy162);}
#line 2474 "parse.c"
        break;
      case 162:
#line 587 "parse.y"
{sqlite3Update(pParse,yymsp[-3].minor.yy149,yymsp[-1].minor.yy44,yymsp[0].minor.yy162,yymsp[-4].minor.yy124);}
#line 2479 "parse.c"
        break;
      case 163:
#line 593 "parse.y"
{yygotominor.yy44 = sqlite3ExprListAppend(yymsp[-4].minor.yy44,yymsp[0].minor.yy162,&yymsp[-2].minor.yy210);}
#line 2484 "parse.c"
        break;
      case 164:
#line 594 "parse.y"
{yygotominor.yy44 = sqlite3ExprListAppend(0,yymsp[0].minor.yy162,&yymsp[-2].minor.yy210);}
#line 2489 "parse.c"
        break;
      case 165:
#line 600 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy149, yymsp[-1].minor.yy44, 0, yymsp[-4].minor.yy326, yymsp[-7].minor.yy124);}
#line 2494 "parse.c"
        break;
      case 166:
#line 602 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy149, 0, yymsp[0].minor.yy313, yymsp[-1].minor.yy326, yymsp[-4].minor.yy124);}
#line 2499 "parse.c"
        break;
      case 167:
#line 604 "parse.y"
{sqlite3Insert(pParse, yymsp[-3].minor.yy149, 0, 0, yymsp[-2].minor.yy326, yymsp[-5].minor.yy124);}
#line 2504 "parse.c"
        break;
      case 170:
      case 230:
#line 614 "parse.y"
{yygotominor.yy44 = sqlite3ExprListAppend(yymsp[-2].minor.yy44,yymsp[0].minor.yy162,0);}
#line 2510 "parse.c"
        break;
      case 171:
      case 231:
#line 615 "parse.y"
{yygotominor.yy44 = sqlite3ExprListAppend(0,yymsp[0].minor.yy162,0);}
#line 2516 "parse.c"
        break;
      case 174:
#line 624 "parse.y"
{yygotominor.yy326 = sqlite3IdListAppend(yymsp[-2].minor.yy326,&yymsp[0].minor.yy210);}
#line 2521 "parse.c"
        break;
      case 175:
#line 625 "parse.y"
{yygotominor.yy326 = sqlite3IdListAppend(0,&yymsp[0].minor.yy210);}
#line 2526 "parse.c"
        break;
      case 177:
#line 636 "parse.y"
{yygotominor.yy162 = yymsp[-1].minor.yy162; sqlite3ExprSpan(yygotominor.yy162,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2531 "parse.c"
        break;
      case 178:
      case 183:
      case 184:
#line 637 "parse.y"
{yygotominor.yy162 = sqlite3Expr(yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2538 "parse.c"
        break;
      case 179:
      case 180:
#line 638 "parse.y"
{yygotominor.yy162 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2544 "parse.c"
        break;
      case 181:
#line 640 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy210);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy210);
  yygotominor.yy162 = sqlite3Expr(TK_DOT, temp1, temp2, 0);
}
#line 2553 "parse.c"
        break;
      case 182:
#line 645 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-4].minor.yy210);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy210);
  Expr *temp3 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy210);
  Expr *temp4 = sqlite3Expr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy162 = sqlite3Expr(TK_DOT, temp1, temp4, 0);
}
#line 2564 "parse.c"
        break;
      case 185:
#line 654 "parse.y"
{yygotominor.yy162 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2569 "parse.c"
        break;
      case 186:
#line 655 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy162 = sqlite3Expr(TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2578 "parse.c"
        break;
      case 187:
#line 661 "parse.y"
{
  yygotominor.yy162 = sqlite3Expr(TK_CAST, yymsp[-3].minor.yy162, 0, &yymsp[-1].minor.yy210);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2586 "parse.c"
        break;
      case 188:
#line 666 "parse.y"
{
  yygotominor.yy162 = sqlite3ExprFunction(yymsp[-1].minor.yy44, &yymsp[-4].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy124 && yygotominor.yy162 ){
    yygotominor.yy162->flags |= EP_Distinct;
  }
}
#line 2597 "parse.c"
        break;
      case 189:
#line 673 "parse.y"
{
  yygotominor.yy162 = sqlite3ExprFunction(0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2605 "parse.c"
        break;
      case 190:
#line 677 "parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy162 = sqlite3ExprFunction(0,&yymsp[0].minor.yy0);
  if( yygotominor.yy162 ){
    yygotominor.yy162->op = TK_CONST_FUNC;  
    yygotominor.yy162->span = yymsp[0].minor.yy0;
  }
}
#line 2618 "parse.c"
        break;
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 197:
      case 198:
#line 686 "parse.y"
{yygotominor.yy162 = sqlite3Expr(yymsp[-1].major, yymsp[-2].minor.yy162, yymsp[0].minor.yy162, 0);}
#line 2630 "parse.c"
        break;
      case 199:
      case 201:
#line 696 "parse.y"
{yygotominor.yy168.eOperator = yymsp[0].minor.yy0; yygotominor.yy168.not = 0;}
#line 2636 "parse.c"
        break;
      case 200:
      case 202:
#line 697 "parse.y"
{yygotominor.yy168.eOperator = yymsp[0].minor.yy0; yygotominor.yy168.not = 1;}
#line 2642 "parse.c"
        break;
      case 205:
#line 704 "parse.y"
{
  ExprList *pList;
  pList = sqlite3ExprListAppend(0, yymsp[-1].minor.yy162, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-3].minor.yy162, 0);
  if( yymsp[0].minor.yy162 ){
    pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy162, 0);
  }
  yygotominor.yy162 = sqlite3ExprFunction(pList, &yymsp[-2].minor.yy168.eOperator);
  if( yymsp[-2].minor.yy168.not ) yygotominor.yy162 = sqlite3Expr(TK_NOT, yygotominor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162, &yymsp[-3].minor.yy162->span, &yymsp[-1].minor.yy162->span);
  if( yygotominor.yy162 ) yygotominor.yy162->flags |= EP_InfixFunc;
}
#line 2658 "parse.c"
        break;
      case 206:
#line 717 "parse.y"
{
  yygotominor.yy162 = sqlite3Expr(yymsp[0].major, yymsp[-1].minor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-1].minor.yy162->span,&yymsp[0].minor.yy0);
}
#line 2666 "parse.c"
        break;
      case 207:
#line 721 "parse.y"
{
  yygotominor.yy162 = sqlite3Expr(TK_ISNULL, yymsp[-2].minor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-2].minor.yy162->span,&yymsp[0].minor.yy0);
}
#line 2674 "parse.c"
        break;
      case 208:
#line 725 "parse.y"
{
  yygotominor.yy162 = sqlite3Expr(TK_NOTNULL, yymsp[-2].minor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-2].minor.yy162->span,&yymsp[0].minor.yy0);
}
#line 2682 "parse.c"
        break;
      case 209:
#line 729 "parse.y"
{
  yygotominor.yy162 = sqlite3Expr(TK_NOTNULL, yymsp[-3].minor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-3].minor.yy162->span,&yymsp[0].minor.yy0);
}
#line 2690 "parse.c"
        break;
      case 210:
#line 733 "parse.y"
{
  yygotominor.yy162 = sqlite3Expr(yymsp[-1].major, yymsp[0].minor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy162->span);
}
#line 2698 "parse.c"
        break;
      case 211:
#line 737 "parse.y"
{
  yygotominor.yy162 = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy162->span);
}
#line 2706 "parse.c"
        break;
      case 212:
#line 741 "parse.y"
{
  yygotominor.yy162 = sqlite3Expr(TK_UPLUS, yymsp[0].minor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy162->span);
}
#line 2714 "parse.c"
        break;
      case 215:
#line 748 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy162, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy162, 0);
  yygotominor.yy162 = sqlite3Expr(TK_BETWEEN, yymsp[-4].minor.yy162, 0, 0);
  if( yygotominor.yy162 ){
    yygotominor.yy162->pList = pList;
  }else{
    sqlite3ExprListDelete(pList);
  } 
  if( yymsp[-3].minor.yy124 ) yygotominor.yy162 = sqlite3Expr(TK_NOT, yygotominor.yy162, 0, 0);
  sqlite3ExprSpan(yygotominor.yy162,&yymsp[-4].minor.yy162->span,&yymsp[0].minor.yy162->span);
}
#line 2730 "parse.c"
        break;
      case 218:
#line 764 "parse.y"
{
    yygotominor.yy162 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy162, 0, 0);
    if( yygotominor.yy162 ){
      yygotominor.yy162->pList = yymsp[-1].minor.yy44;
    }else{
      sqlite3ExprListDelete(yymsp[-1].minor.yy44);
    }
    if( yymsp[-3].minor.yy124 ) yygotominor.yy162 = sqlite3Expr(TK_NOT, yygotominor.yy162, 0, 0);
    sqlite3ExprSpan(yygotominor.yy162,&yymsp[-4].minor.yy162->span,&yymsp[0].minor.yy0);
  }
#line 2744 "parse.c"
        break;
      case 219:
#line 774 "parse.y"
{
    yygotominor.yy162 = sqlite3Expr(TK_SELECT, 0, 0, 0);
    if( yygotominor.yy162 ){
      yygotominor.yy162->pSelect = yymsp[-1].minor.yy313;
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy313);
    }
    sqlite3ExprSpan(yygotominor.yy162,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2757 "parse.c"
        break;
      case 220:
#line 783 "parse.y"
{
    yygotominor.yy162 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy162, 0, 0);
    if( yygotominor.yy162 ){
      yygotominor.yy162->pSelect = yymsp[-1].minor.yy313;
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy313);
    }
    if( yymsp[-3].minor.yy124 ) yygotominor.yy162 = sqlite3Expr(TK_NOT, yygotominor.yy162, 0, 0);
    sqlite3ExprSpan(yygotominor.yy162,&yymsp[-4].minor.yy162->span,&yymsp[0].minor.yy0);
  }
#line 2771 "parse.c"
        break;
      case 221:
#line 793 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy210,&yymsp[0].minor.yy210);
    yygotominor.yy162 = sqlite3Expr(TK_IN, yymsp[-3].minor.yy162, 0, 0);
    if( yygotominor.yy162 ){
      yygotominor.yy162->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,0,0);
    }else{
      sqlite3SrcListDelete(pSrc);
    }
    if( yymsp[-2].minor.yy124 ) yygotominor.yy162 = sqlite3Expr(TK_NOT, yygotominor.yy162, 0, 0);
    sqlite3ExprSpan(yygotominor.yy162,&yymsp[-3].minor.yy162->span,yymsp[0].minor.yy210.z?&yymsp[0].minor.yy210:&yymsp[-1].minor.yy210);
  }
#line 2786 "parse.c"
        break;
      case 222:
#line 804 "parse.y"
{
    Expr *p = yygotominor.yy162 = sqlite3Expr(TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy313;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy313);
    }
  }
#line 2799 "parse.c"
        break;
      case 223:
#line 816 "parse.y"
{
  yygotominor.yy162 = sqlite3Expr(TK_CASE, yymsp[-3].minor.yy162, yymsp[-1].minor.yy162, 0);
  if( yygotominor.yy162 ){
    yygotominor.yy162->pList = yymsp[-2].minor.yy44;
  }else{
    sqlite3ExprListDelete(yymsp[-2].minor.yy44);
  }
  sqlite3ExprSpan(yygotominor.yy162, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2812 "parse.c"
        break;
      case 224:
#line 827 "parse.y"
{
  yygotominor.yy44 = sqlite3ExprListAppend(yymsp[-4].minor.yy44, yymsp[-2].minor.yy162, 0);
  yygotominor.yy44 = sqlite3ExprListAppend(yygotominor.yy44, yymsp[0].minor.yy162, 0);
}
#line 2820 "parse.c"
        break;
      case 225:
#line 831 "parse.y"
{
  yygotominor.yy44 = sqlite3ExprListAppend(0, yymsp[-2].minor.yy162, 0);
  yygotominor.yy44 = sqlite3ExprListAppend(yygotominor.yy44, yymsp[0].minor.yy162, 0);
}
#line 2828 "parse.c"
        break;
      case 234:
#line 858 "parse.y"
{
  sqlite3CreateIndex(pParse, &yymsp[-6].minor.yy210, &yymsp[-5].minor.yy210, sqlite3SrcListAppend(0,&yymsp[-3].minor.yy210,0), yymsp[-1].minor.yy44, yymsp[-9].minor.yy124,
                      &yymsp[-10].minor.yy0, &yymsp[0].minor.yy0, SQLITE_SO_ASC, yymsp[-7].minor.yy124);
}
#line 2836 "parse.c"
        break;
      case 235:
      case 280:
#line 864 "parse.y"
{yygotominor.yy124 = OE_Abort;}
#line 2842 "parse.c"
        break;
      case 236:
#line 865 "parse.y"
{yygotominor.yy124 = OE_None;}
#line 2847 "parse.c"
        break;
      case 239:
#line 875 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy210.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, (char*)yymsp[-1].minor.yy210.z, yymsp[-1].minor.yy210.n);
  }
  yygotominor.yy44 = sqlite3ExprListAppend(yymsp[-4].minor.yy44, p, &yymsp[-2].minor.yy210);
  if( yygotominor.yy44 ) yygotominor.yy44->a[yygotominor.yy44->nExpr-1].sortOrder = yymsp[0].minor.yy124;
}
#line 2860 "parse.c"
        break;
      case 240:
#line 884 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy210.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, (char*)yymsp[-1].minor.yy210.z, yymsp[-1].minor.yy210.n);
  }
  yygotominor.yy44 = sqlite3ExprListAppend(0, p, &yymsp[-2].minor.yy210);
  if( yygotominor.yy44 ) yygotominor.yy44->a[yygotominor.yy44->nExpr-1].sortOrder = yymsp[0].minor.yy124;
}
#line 2873 "parse.c"
        break;
      case 242:
#line 898 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy149, yymsp[-1].minor.yy124);}
#line 2878 "parse.c"
        break;
      case 243:
      case 244:
#line 902 "parse.y"
{sqlite3Vacuum(pParse);}
#line 2884 "parse.c"
        break;
      case 245:
      case 247:
#line 908 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy210,&yymsp[-2].minor.yy210,&yymsp[0].minor.yy210,0);}
#line 2890 "parse.c"
        break;
      case 246:
#line 909 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy210,&yymsp[-2].minor.yy210,&yymsp[0].minor.yy0,0);}
#line 2895 "parse.c"
        break;
      case 248:
#line 911 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy210,&yymsp[-2].minor.yy210,&yymsp[0].minor.yy210,1);
}
#line 2902 "parse.c"
        break;
      case 249:
#line 914 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy210,&yymsp[-3].minor.yy210,&yymsp[-1].minor.yy210,0);}
#line 2907 "parse.c"
        break;
      case 250:
#line 915 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy210,&yymsp[0].minor.yy210,0,0);}
#line 2912 "parse.c"
        break;
      case 256:
#line 927 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy210.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy210.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy137, &all);
}
#line 2922 "parse.c"
        break;
      case 257:
#line 936 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy210, &yymsp[-6].minor.yy210, yymsp[-5].minor.yy124, yymsp[-4].minor.yy412.a, yymsp[-4].minor.yy412.b, yymsp[-2].minor.yy149, yymsp[-1].minor.yy124, yymsp[0].minor.yy162, yymsp[-9].minor.yy124);
  yygotominor.yy210 = (yymsp[-6].minor.yy210.n==0?yymsp[-7].minor.yy210:yymsp[-6].minor.yy210);
}
#line 2930 "parse.c"
        break;
      case 258:
      case 261:
#line 942 "parse.y"
{ yygotominor.yy124 = TK_BEFORE; }
#line 2936 "parse.c"
        break;
      case 259:
#line 943 "parse.y"
{ yygotominor.yy124 = TK_AFTER;  }
#line 2941 "parse.c"
        break;
      case 260:
#line 944 "parse.y"
{ yygotominor.yy124 = TK_INSTEAD;}
#line 2946 "parse.c"
        break;
      case 262:
      case 263:
#line 949 "parse.y"
{yygotominor.yy412.a = yymsp[0].major; yygotominor.yy412.b = 0;}
#line 2952 "parse.c"
        break;
      case 264:
#line 951 "parse.y"
{yygotominor.yy412.a = TK_UPDATE; yygotominor.yy412.b = yymsp[0].minor.yy326;}
#line 2957 "parse.c"
        break;
      case 265:
      case 266:
#line 954 "parse.y"
{ yygotominor.yy124 = TK_ROW; }
#line 2963 "parse.c"
        break;
      case 267:
#line 956 "parse.y"
{ yygotominor.yy124 = TK_STATEMENT; }
#line 2968 "parse.c"
        break;
      case 268:
#line 960 "parse.y"
{ yygotominor.yy162 = 0; }
#line 2973 "parse.c"
        break;
      case 269:
#line 961 "parse.y"
{ yygotominor.yy162 = yymsp[0].minor.yy162; }
#line 2978 "parse.c"
        break;
      case 270:
#line 965 "parse.y"
{
  if( yymsp[-2].minor.yy137 ){
    yymsp[-2].minor.yy137->pLast->pNext = yymsp[-1].minor.yy137;
  }else{
    yymsp[-2].minor.yy137 = yymsp[-1].minor.yy137;
  }
  yymsp[-2].minor.yy137->pLast = yymsp[-1].minor.yy137;
  yygotominor.yy137 = yymsp[-2].minor.yy137;
}
#line 2991 "parse.c"
        break;
      case 271:
#line 974 "parse.y"
{ yygotominor.yy137 = 0; }
#line 2996 "parse.c"
        break;
      case 272:
#line 980 "parse.y"
{ yygotominor.yy137 = sqlite3TriggerUpdateStep(&yymsp[-3].minor.yy210, yymsp[-1].minor.yy44, yymsp[0].minor.yy162, yymsp[-4].minor.yy124); }
#line 3001 "parse.c"
        break;
      case 273:
#line 985 "parse.y"
{yygotominor.yy137 = sqlite3TriggerInsertStep(&yymsp[-5].minor.yy210, yymsp[-4].minor.yy326, yymsp[-1].minor.yy44, 0, yymsp[-7].minor.yy124);}
#line 3006 "parse.c"
        break;
      case 274:
#line 988 "parse.y"
{yygotominor.yy137 = sqlite3TriggerInsertStep(&yymsp[-2].minor.yy210, yymsp[-1].minor.yy326, 0, yymsp[0].minor.yy313, yymsp[-4].minor.yy124);}
#line 3011 "parse.c"
        break;
      case 275:
#line 992 "parse.y"
{yygotominor.yy137 = sqlite3TriggerDeleteStep(&yymsp[-1].minor.yy210, yymsp[0].minor.yy162);}
#line 3016 "parse.c"
        break;
      case 276:
#line 995 "parse.y"
{yygotominor.yy137 = sqlite3TriggerSelectStep(yymsp[0].minor.yy313); }
#line 3021 "parse.c"
        break;
      case 277:
#line 998 "parse.y"
{
  yygotominor.yy162 = sqlite3Expr(TK_RAISE, 0, 0, 0); 
  if( yygotominor.yy162 ){
    yygotominor.yy162->iColumn = OE_Ignore;
    sqlite3ExprSpan(yygotominor.yy162, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3032 "parse.c"
        break;
      case 278:
#line 1005 "parse.y"
{
  yygotominor.yy162 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy210); 
  if( yygotominor.yy162 ) {
    yygotominor.yy162->iColumn = yymsp[-3].minor.yy124;
    sqlite3ExprSpan(yygotominor.yy162, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3043 "parse.c"
        break;
      case 279:
#line 1015 "parse.y"
{yygotominor.yy124 = OE_Rollback;}
#line 3048 "parse.c"
        break;
      case 281:
#line 1017 "parse.y"
{yygotominor.yy124 = OE_Fail;}
#line 3053 "parse.c"
        break;
      case 282:
#line 1022 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy149);
}
#line 3060 "parse.c"
        break;
      case 283:
#line 1028 "parse.y"
{
  sqlite3Attach(pParse, yymsp[-3].minor.yy162, yymsp[-1].minor.yy162, yymsp[0].minor.yy116);
}
#line 3067 "parse.c"
        break;
      case 284:
#line 1033 "parse.y"
{ yygotominor.yy116 = 0; }
#line 3072 "parse.c"
        break;
      case 285:
#line 1034 "parse.y"
{ yygotominor.yy116 = yymsp[0].minor.yy162; }
#line 3077 "parse.c"
        break;
      case 288:
#line 1040 "parse.y"
{
  sqlite3Detach(pParse, yymsp[0].minor.yy162);
}
#line 3084 "parse.c"
        break;
      case 289:
#line 1046 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3089 "parse.c"
        break;
      case 290:
#line 1047 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy210, &yymsp[0].minor.yy210);}
#line 3094 "parse.c"
        break;
      case 291:
#line 1052 "parse.y"
{sqlite3Analyze(pParse, 0, 0);}
#line 3099 "parse.c"
        break;
      case 292:
#line 1053 "parse.y"
{sqlite3Analyze(pParse, &yymsp[-1].minor.yy210, &yymsp[0].minor.yy210);}
#line 3104 "parse.c"
        break;
      case 293:
#line 1058 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy149,&yymsp[0].minor.yy210);
}
#line 3111 "parse.c"
        break;
      case 294:
#line 1061 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy210);
}
#line 3118 "parse.c"
        break;
      case 295:
#line 1064 "parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy149);
}
#line 3125 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 34 "parse.y"

  if( !pParse->parseError ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
    pParse->parseError = 1;
  }
#line 3193 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    /* if( yymajor==0 ) return; // not sure why this was here... */
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
