/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSCanvasRenderingContext2D_H
#define JSCanvasRenderingContext2D_H

#include "kjs_binding.h"

namespace WebCore {

class CanvasRenderingContext2D;

class JSCanvasRenderingContext2D : public KJS::DOMObject {
public:
    JSCanvasRenderingContext2D(KJS::ExecState*, CanvasRenderingContext2D*);
    virtual ~JSCanvasRenderingContext2D();
    virtual bool getOwnPropertySlot(KJS::ExecState*, const KJS::Identifier&, KJS::PropertySlot&);
    KJS::JSValue* getValueProperty(KJS::ExecState*, int token) const;
    virtual void put(KJS::ExecState*, const KJS::Identifier&, KJS::JSValue*, int attr = KJS::None);
    void putValueProperty(KJS::ExecState*, int, KJS::JSValue*, int attr);
    virtual const KJS::ClassInfo* classInfo() const { return &info; }
    static const KJS::ClassInfo info;

    enum {
        // Attributes
        CanvasAttrNum, GlobalAlphaAttrNum, GlobalCompositeOperationAttrNum, LineWidthAttrNum, 
        LineCapAttrNum, LineJoinAttrNum, MiterLimitAttrNum, ShadowOffsetXAttrNum, 
        ShadowOffsetYAttrNum, ShadowBlurAttrNum, ShadowColorAttrNum, StrokeStyleAttrNum, 
        FillStyleAttrNum, 

        // Functions
        SaveFuncNum, RestoreFuncNum, ScaleFuncNum, RotateFuncNum, 
        TranslateFuncNum, CreateLinearGradientFuncNum, CreateRadialGradientFuncNum, ClearRectFuncNum, 
        FillRectFuncNum, BeginPathFuncNum, ClosePathFuncNum, MoveToFuncNum, 
        LineToFuncNum, QuadraticCurveToFuncNum, BezierCurveToFuncNum, ArcToFuncNum, 
        RectFuncNum, ArcFuncNum, FillFuncNum, StrokeFuncNum, 
        ClipFuncNum, SetAlphaFuncNum, SetCompositeOperationFuncNum, SetLineWidthFuncNum, 
        SetLineCapFuncNum, SetLineJoinFuncNum, SetMiterLimitFuncNum, ClearShadowFuncNum, 
        SetStrokeColorFuncNum, SetFillColorFuncNum, StrokeRectFuncNum, DrawImageFuncNum, 
        DrawImageFromRectFuncNum, SetShadowFuncNum, CreatePatternFuncNum
    };

    // Custom attributes
    KJS::JSValue* strokeStyle(KJS::ExecState*) const;
    void setStrokeStyle(KJS::ExecState*, KJS::JSValue*);
    KJS::JSValue* fillStyle(KJS::ExecState*) const;
    void setFillStyle(KJS::ExecState*, KJS::JSValue*);

    // Custom functions
    KJS::JSValue* setStrokeColor(KJS::ExecState*, const KJS::List&);
    KJS::JSValue* setFillColor(KJS::ExecState*, const KJS::List&);
    KJS::JSValue* strokeRect(KJS::ExecState*, const KJS::List&);
    KJS::JSValue* drawImage(KJS::ExecState*, const KJS::List&);
    KJS::JSValue* drawImageFromRect(KJS::ExecState*, const KJS::List&);
    KJS::JSValue* setShadow(KJS::ExecState*, const KJS::List&);
    KJS::JSValue* createPattern(KJS::ExecState*, const KJS::List&);
    CanvasRenderingContext2D* impl() const { return m_impl.get(); }
private:
    RefPtr<CanvasRenderingContext2D> m_impl;
};

KJS::JSValue* toJS(KJS::ExecState*, CanvasRenderingContext2D*);
CanvasRenderingContext2D* toCanvasRenderingContext2D(KJS::JSValue*);

class JSCanvasRenderingContext2DPrototype : public KJS::JSObject {
public:
    static KJS::JSObject* self(KJS::ExecState* exec);
    virtual const KJS::ClassInfo* classInfo() const { return &info; }
    static const KJS::ClassInfo info;
    bool getOwnPropertySlot(KJS::ExecState*, const KJS::Identifier&, KJS::PropertySlot&);
    JSCanvasRenderingContext2DPrototype(KJS::ExecState* exec)
        : KJS::JSObject(exec->lexicalInterpreter()->builtinObjectPrototype()) { }
};

class JSCanvasRenderingContext2DPrototypeFunction : public KJS::InternalFunctionImp {
public:
    JSCanvasRenderingContext2DPrototypeFunction(KJS::ExecState* exec, int i, int len, const KJS::Identifier& name)
        : KJS::InternalFunctionImp(static_cast<KJS::FunctionPrototype*>(exec->lexicalInterpreter()->builtinFunctionPrototype()), name)
        , id(i)
    {
        put(exec, exec->propertyNames().length, KJS::jsNumber(len), KJS::DontDelete|KJS::ReadOnly|KJS::DontEnum);
    }
    virtual KJS::JSValue* callAsFunction(KJS::ExecState*, KJS::JSObject*, const KJS::List&);

private:
    int id;
};

} // namespace WebCore

#endif
