/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSCSSImportRule.h"

#include <wtf/GetPtr.h>

#include "CSSImportRule.h"
#include "CSSStyleSheet.h"
#include "JSCSSStyleSheet.h"
#include "JSMediaList.h"
#include "MediaList.h"
#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSCSSImportRuleTableEntries[] =
{
    { "href", JSCSSImportRule::HrefAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "media", JSCSSImportRule::MediaAttrNum, DontDelete|ReadOnly, 0, &JSCSSImportRuleTableEntries[4] },
    { "styleSheet", JSCSSImportRule::StyleSheetAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "constructor", JSCSSImportRule::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSCSSImportRuleTable = 
{
    2, 5, JSCSSImportRuleTableEntries, 4
};

/* Hash table for constructor */

static const HashEntry JSCSSImportRuleConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSCSSImportRuleConstructorTable = 
{
    2, 1, JSCSSImportRuleConstructorTableEntries, 1
};

class JSCSSImportRuleConstructor : public DOMObject {
public:
    JSCSSImportRuleConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSCSSImportRulePrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSCSSImportRuleConstructor::info = { "CSSImportRuleConstructor", 0, &JSCSSImportRuleConstructorTable, 0 };

bool JSCSSImportRuleConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSImportRuleConstructor, DOMObject>(exec, &JSCSSImportRuleConstructorTable, this, propertyName, slot);
}

JSValue* JSCSSImportRuleConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSCSSImportRulePrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSCSSImportRulePrototypeTable = 
{
    2, 1, JSCSSImportRulePrototypeTableEntries, 1
};

const ClassInfo JSCSSImportRulePrototype::info = { "CSSImportRulePrototype", 0, &JSCSSImportRulePrototypeTable, 0 };

JSObject* JSCSSImportRulePrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSCSSImportRulePrototype>(exec, "[[JSCSSImportRule.prototype]]");
}

const ClassInfo JSCSSImportRule::info = { "CSSImportRule", &JSCSSRule::info, &JSCSSImportRuleTable, 0 };

JSCSSImportRule::JSCSSImportRule(ExecState* exec, CSSImportRule* impl)
    : JSCSSRule(exec, impl)
{
    setPrototype(JSCSSImportRulePrototype::self(exec));
}

bool JSCSSImportRule::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSImportRule, JSCSSRule>(exec, &JSCSSImportRuleTable, this, propertyName, slot);
}

JSValue* JSCSSImportRule::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case HrefAttrNum: {
        CSSImportRule* imp = static_cast<CSSImportRule*>(impl());

        return jsStringOrNull(imp->href());
    }
    case MediaAttrNum: {
        CSSImportRule* imp = static_cast<CSSImportRule*>(impl());

        return toJS(exec, WTF::getPtr(imp->media()));
    }
    case StyleSheetAttrNum: {
        CSSImportRule* imp = static_cast<CSSImportRule*>(impl());

        return toJS(exec, WTF::getPtr(imp->styleSheet()));
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSCSSImportRule::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSCSSImportRuleConstructor>(exec, "[[CSSImportRule.constructor]]");
}

}
