/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGDocument.h"

#include <wtf/GetPtr.h>

#include "Event.h"
#include "JSEvent.h"
#include "JSSVGSVGElement.h"
#include "PlatformString.h"
#include "SVGDocument.h"
#include "SVGSVGElement.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGDocumentTableEntries[] =
{
    { "title", JSSVGDocument::TitleAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "URL", JSSVGDocument::URLAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "domain", JSSVGDocument::DomainAttrNum, DontDelete|ReadOnly, 0, &JSSVGDocumentTableEntries[5] },
    { "referrer", JSSVGDocument::ReferrerAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "rootElement", JSSVGDocument::RootElementAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGDocumentTable = 
{
    2, 6, JSSVGDocumentTableEntries, 5
};

/* Hash table for prototype */

static const HashEntry JSSVGDocumentPrototypeTableEntries[] =
{
    { "createEvent", JSSVGDocument::CreateEventFuncNum, DontDelete|Function, 1, 0 }
};

static const HashTable JSSVGDocumentPrototypeTable = 
{
    2, 1, JSSVGDocumentPrototypeTableEntries, 1
};

const ClassInfo JSSVGDocumentPrototype::info = { "SVGDocumentPrototype", 0, &JSSVGDocumentPrototypeTable, 0 };

JSObject* JSSVGDocumentPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGDocumentPrototype>(exec, "[[JSSVGDocument.prototype]]");
}

bool JSSVGDocumentPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSSVGDocumentPrototypeFunction, JSObject>(exec, &JSSVGDocumentPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGDocument::info = { "SVGDocument", &JSDocument::info, &JSSVGDocumentTable, 0 };

JSSVGDocument::JSSVGDocument(ExecState* exec, SVGDocument* impl)
    : JSDocument(exec, impl)
{
    setPrototype(JSSVGDocumentPrototype::self(exec));
}

bool JSSVGDocument::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGDocument, JSDocument>(exec, &JSSVGDocumentTable, this, propertyName, slot);
}

JSValue* JSSVGDocument::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case TitleAttrNum: {
        SVGDocument* imp = static_cast<SVGDocument*>(impl());

        return jsString(imp->title());
    }
    case ReferrerAttrNum: {
        SVGDocument* imp = static_cast<SVGDocument*>(impl());

        return jsString(imp->referrer());
    }
    case DomainAttrNum: {
        SVGDocument* imp = static_cast<SVGDocument*>(impl());

        return jsString(imp->domain());
    }
    case URLAttrNum: {
        SVGDocument* imp = static_cast<SVGDocument*>(impl());

        return jsString(imp->URL());
    }
    case RootElementAttrNum: {
        SVGDocument* imp = static_cast<SVGDocument*>(impl());

        return toJS(exec, WTF::getPtr(imp->rootElement()));
    }
    }
    return 0;
}

JSValue* JSSVGDocumentPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSSVGDocument::info))
      return throwError(exec, TypeError);

    SVGDocument* imp = static_cast<SVGDocument*>(static_cast<JSSVGDocument*>(thisObj)->impl());

    switch (id) {
    case JSSVGDocument::CreateEventFuncNum: {
        ExceptionCode ec = 0;
        String eventType = args[0]->toString(exec);


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->createEvent(eventType, ec)));
        setDOMException(exec, ec);
        return result;
    }
    }
    return 0;
}

}

#endif // ENABLE(SVG)
