/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGAnimatedBoolean.h"

#include <wtf/GetPtr.h>


using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGAnimatedBooleanTableEntries[] =
{
    { "baseVal", JSSVGAnimatedBoolean::BaseValAttrNum, DontDelete, 0, 0 },
    { "animVal", JSSVGAnimatedBoolean::AnimValAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGAnimatedBooleanTable = 
{
    2, 2, JSSVGAnimatedBooleanTableEntries, 2
};

/* Hash table for prototype */

static const HashEntry JSSVGAnimatedBooleanPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSSVGAnimatedBooleanPrototypeTable = 
{
    2, 1, JSSVGAnimatedBooleanPrototypeTableEntries, 1
};

const ClassInfo JSSVGAnimatedBooleanPrototype::info = { "SVGAnimatedBooleanPrototype", 0, &JSSVGAnimatedBooleanPrototypeTable, 0 };

JSObject* JSSVGAnimatedBooleanPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGAnimatedBooleanPrototype>(exec, "[[JSSVGAnimatedBoolean.prototype]]");
}

const ClassInfo JSSVGAnimatedBoolean::info = { "SVGAnimatedBoolean", 0, &JSSVGAnimatedBooleanTable, 0 };

JSSVGAnimatedBoolean::JSSVGAnimatedBoolean(ExecState* exec, SVGAnimatedBoolean* impl)
    : m_impl(impl)
{
    setPrototype(JSSVGAnimatedBooleanPrototype::self(exec));
}

JSSVGAnimatedBoolean::~JSSVGAnimatedBoolean()
{
    SVGDocumentExtensions::forgetGenericContext<SVGAnimatedBoolean>(m_impl.get());
    ScriptInterpreter::forgetDOMObject(m_impl.get());
}

bool JSSVGAnimatedBoolean::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedBoolean, KJS::DOMObject>(exec, &JSSVGAnimatedBooleanTable, this, propertyName, slot);
}

JSValue* JSSVGAnimatedBoolean::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case BaseValAttrNum: {
        SVGAnimatedBoolean* imp = static_cast<SVGAnimatedBoolean*>(impl());

        return jsBoolean(imp->baseVal());
    }
    case AnimValAttrNum: {
        SVGAnimatedBoolean* imp = static_cast<SVGAnimatedBoolean*>(impl());

        return jsBoolean(imp->animVal());
    }
    }
    return 0;
}

void JSSVGAnimatedBoolean::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSSVGAnimatedBoolean, KJS::DOMObject>(exec, propertyName, value, attr, &JSSVGAnimatedBooleanTable, this);
}

void JSSVGAnimatedBoolean::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case BaseValAttrNum: {
        SVGAnimatedBoolean* imp = static_cast<SVGAnimatedBoolean*>(impl());

        imp->setBaseVal(value->toBoolean(exec));
        break;
    }
    }
    SVGAnimatedBoolean* imp = static_cast<SVGAnimatedBoolean*>(impl());

    ASSERT(exec && exec->dynamicInterpreter());
    Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
    if (!activeFrame)
        return;

    SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
    if (extensions && extensions->hasGenericContext<SVGAnimatedBoolean>(imp)) {
        const SVGElement* context = extensions->genericContext<SVGAnimatedBoolean>(imp);
        ASSERT(context);

        context->notifyAttributeChange();
    }

}

KJS::JSValue* toJS(KJS::ExecState* exec, SVGAnimatedBoolean* obj)
{
    return KJS::cacheDOMObject<SVGAnimatedBoolean, JSSVGAnimatedBoolean>(exec, obj);
}
SVGAnimatedBoolean* toSVGAnimatedBoolean(KJS::JSValue* val)
{
    return val->isObject(&JSSVGAnimatedBoolean::info) ? static_cast<JSSVGAnimatedBoolean*>(val)->impl() : 0;
}

}

#endif // ENABLE(SVG)
