/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSCSSRule.h"

#include <wtf/GetPtr.h>

#include "CSSRule.h"
#include "CSSStyleSheet.h"
#include "JSCSSRule.h"
#include "JSCSSStyleSheet.h"
#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSCSSRuleTableEntries[] =
{
    { "cssText", JSCSSRule::CssTextAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "parentStyleSheet", JSCSSRule::ParentStyleSheetAttrNum, DontDelete|ReadOnly, 0, &JSCSSRuleTableEntries[6] },
    { "type", JSCSSRule::TypeAttrNum, DontDelete|ReadOnly, 0, &JSCSSRuleTableEntries[5] },
    { 0, 0, 0, 0, 0 },
    { "parentRule", JSCSSRule::ParentRuleAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "constructor", JSCSSRule::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSCSSRuleTable = 
{
    2, 7, JSCSSRuleTableEntries, 5
};

/* Hash table for constructor */

static const HashEntry JSCSSRuleConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "MEDIA_RULE", CSSRule::MEDIA_RULE, DontDelete|ReadOnly, 0, 0 },
    { "IMPORT_RULE", CSSRule::IMPORT_RULE, DontDelete|ReadOnly, 0, &JSCSSRuleConstructorTableEntries[8] },
    { "UNKNOWN_RULE", CSSRule::UNKNOWN_RULE, DontDelete|ReadOnly, 0, &JSCSSRuleConstructorTableEntries[7] },
    { 0, 0, 0, 0, 0 },
    { "STYLE_RULE", CSSRule::STYLE_RULE, DontDelete|ReadOnly, 0, 0 },
    { "PAGE_RULE", CSSRule::PAGE_RULE, DontDelete|ReadOnly, 0, 0 },
    { "CHARSET_RULE", CSSRule::CHARSET_RULE, DontDelete|ReadOnly, 0, 0 },
    { "FONT_FACE_RULE", CSSRule::FONT_FACE_RULE, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSCSSRuleConstructorTable = 
{
    2, 9, JSCSSRuleConstructorTableEntries, 7
};

class JSCSSRuleConstructor : public DOMObject {
public:
    JSCSSRuleConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSCSSRulePrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSCSSRuleConstructor::info = { "CSSRuleConstructor", 0, &JSCSSRuleConstructorTable, 0 };

bool JSCSSRuleConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSRuleConstructor, DOMObject>(exec, &JSCSSRuleConstructorTable, this, propertyName, slot);
}

JSValue* JSCSSRuleConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSCSSRulePrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "MEDIA_RULE", CSSRule::MEDIA_RULE, DontDelete|ReadOnly, 0, 0 },
    { "IMPORT_RULE", CSSRule::IMPORT_RULE, DontDelete|ReadOnly, 0, &JSCSSRulePrototypeTableEntries[8] },
    { "UNKNOWN_RULE", CSSRule::UNKNOWN_RULE, DontDelete|ReadOnly, 0, &JSCSSRulePrototypeTableEntries[7] },
    { 0, 0, 0, 0, 0 },
    { "STYLE_RULE", CSSRule::STYLE_RULE, DontDelete|ReadOnly, 0, 0 },
    { "PAGE_RULE", CSSRule::PAGE_RULE, DontDelete|ReadOnly, 0, 0 },
    { "CHARSET_RULE", CSSRule::CHARSET_RULE, DontDelete|ReadOnly, 0, 0 },
    { "FONT_FACE_RULE", CSSRule::FONT_FACE_RULE, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSCSSRulePrototypeTable = 
{
    2, 9, JSCSSRulePrototypeTableEntries, 7
};

const ClassInfo JSCSSRulePrototype::info = { "CSSRulePrototype", 0, &JSCSSRulePrototypeTable, 0 };

JSObject* JSCSSRulePrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSCSSRulePrototype>(exec, "[[JSCSSRule.prototype]]");
}

bool JSCSSRulePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSRulePrototype, JSObject>(exec, &JSCSSRulePrototypeTable, this, propertyName, slot);
}

JSValue* JSCSSRulePrototype::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

const ClassInfo JSCSSRule::info = { "CSSRule", 0, &JSCSSRuleTable, 0 };

JSCSSRule::JSCSSRule(ExecState* exec, CSSRule* impl)
    : m_impl(impl)
{
    setPrototype(JSCSSRulePrototype::self(exec));
}

JSCSSRule::~JSCSSRule()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());
}

bool JSCSSRule::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSRule, KJS::DOMObject>(exec, &JSCSSRuleTable, this, propertyName, slot);
}

JSValue* JSCSSRule::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case TypeAttrNum: {
        CSSRule* imp = static_cast<CSSRule*>(impl());

        return jsNumber(imp->type());
    }
    case CssTextAttrNum: {
        CSSRule* imp = static_cast<CSSRule*>(impl());

        return jsStringOrNull(imp->cssText());
    }
    case ParentStyleSheetAttrNum: {
        CSSRule* imp = static_cast<CSSRule*>(impl());

        return toJS(exec, WTF::getPtr(imp->parentStyleSheet()));
    }
    case ParentRuleAttrNum: {
        CSSRule* imp = static_cast<CSSRule*>(impl());

        return toJS(exec, WTF::getPtr(imp->parentRule()));
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSCSSRule::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSCSSRule, KJS::DOMObject>(exec, propertyName, value, attr, &JSCSSRuleTable, this);
}

void JSCSSRule::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case CssTextAttrNum: {
        CSSRule* imp = static_cast<CSSRule*>(impl());

        ExceptionCode ec = 0;
        imp->setCssText(valueToStringWithNullCheck(exec, value), ec);
        setDOMException(exec, ec);
        break;
    }
    }
}

JSValue* JSCSSRule::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSCSSRuleConstructor>(exec, "[[CSSRule.constructor]]");
}
CSSRule* toCSSRule(KJS::JSValue* val)
{
    return val->isObject(&JSCSSRule::info) ? static_cast<JSCSSRule*>(val)->impl() : 0;
}

}
