/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGAnimationElement.h"

#include <wtf/GetPtr.h>

#include "JSSVGAnimatedBoolean.h"
#include "JSSVGElement.h"
#include "JSSVGStringList.h"
#include "SVGAnimationElement.h"
#include "SVGElement.h"
#include "SVGStringList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGAnimationElementTableEntries[] =
{
    { "externalResourcesRequired", JSSVGAnimationElement::ExternalResourcesRequiredAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "targetElement", JSSVGAnimationElement::TargetElementAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "requiredExtensions", JSSVGAnimationElement::RequiredExtensionsAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "requiredFeatures", JSSVGAnimationElement::RequiredFeaturesAttrNum, DontDelete|ReadOnly, 0, &JSSVGAnimationElementTableEntries[5] },
    { "systemLanguage", JSSVGAnimationElement::SystemLanguageAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGAnimationElementTable = 
{
    2, 6, JSSVGAnimationElementTableEntries, 5
};

/* Hash table for prototype */

static const HashEntry JSSVGAnimationElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "getSimpleDuration", JSSVGAnimationElement::GetSimpleDurationFuncNum, DontDelete|Function, 0, &JSSVGAnimationElementPrototypeTableEntries[4] },
    { "getCurrentTime", JSSVGAnimationElement::GetCurrentTimeFuncNum, DontDelete|Function, 0, 0 },
    { "getStartTime", JSSVGAnimationElement::GetStartTimeFuncNum, DontDelete|Function, 0, 0 },
    { "hasExtension", JSSVGAnimationElement::HasExtensionFuncNum, DontDelete|Function, 1, 0 }
};

static const HashTable JSSVGAnimationElementPrototypeTable = 
{
    2, 5, JSSVGAnimationElementPrototypeTableEntries, 4
};

const ClassInfo JSSVGAnimationElementPrototype::info = { "SVGAnimationElementPrototype", 0, &JSSVGAnimationElementPrototypeTable, 0 };

JSObject* JSSVGAnimationElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGAnimationElementPrototype>(exec, "[[JSSVGAnimationElement.prototype]]");
}

bool JSSVGAnimationElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSSVGAnimationElementPrototypeFunction, JSObject>(exec, &JSSVGAnimationElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGAnimationElement::info = { "SVGAnimationElement", &JSSVGElement::info, &JSSVGAnimationElementTable, 0 };

JSSVGAnimationElement::JSSVGAnimationElement(ExecState* exec, SVGAnimationElement* impl)
    : JSSVGElement(exec, impl)
{
    setPrototype(JSSVGAnimationElementPrototype::self(exec));
}

bool JSSVGAnimationElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimationElement, JSSVGElement>(exec, &JSSVGAnimationElementTable, this, propertyName, slot);
}

JSValue* JSSVGAnimationElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case TargetElementAttrNum: {
        SVGAnimationElement* imp = static_cast<SVGAnimationElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->targetElement()));
    }
    case RequiredFeaturesAttrNum: {
        SVGAnimationElement* imp = static_cast<SVGAnimationElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->requiredFeatures()));
    }
    case RequiredExtensionsAttrNum: {
        SVGAnimationElement* imp = static_cast<SVGAnimationElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->requiredExtensions()));
    }
    case SystemLanguageAttrNum: {
        SVGAnimationElement* imp = static_cast<SVGAnimationElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->systemLanguage()));
    }
    case ExternalResourcesRequiredAttrNum: {
        SVGAnimationElement* imp = static_cast<SVGAnimationElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedBoolean>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedBoolean>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedBoolean>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    }
    return 0;
}

JSValue* JSSVGAnimationElementPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSSVGAnimationElement::info))
      return throwError(exec, TypeError);

    SVGAnimationElement* imp = static_cast<SVGAnimationElement*>(static_cast<JSSVGAnimationElement*>(thisObj)->impl());

    switch (id) {
    case JSSVGAnimationElement::GetStartTimeFuncNum: {


        KJS::JSValue* result = jsNumber(imp->getStartTime());
        return result;
    }
    case JSSVGAnimationElement::GetCurrentTimeFuncNum: {


        KJS::JSValue* result = jsNumber(imp->getCurrentTime());
        return result;
    }
    case JSSVGAnimationElement::GetSimpleDurationFuncNum: {
        ExceptionCode ec = 0;


        KJS::JSValue* result = jsNumber(imp->getSimpleDuration(ec));
        setDOMException(exec, ec);
        return result;
    }
    case JSSVGAnimationElement::HasExtensionFuncNum: {
        String extension = args[0]->toString(exec);


        KJS::JSValue* result = jsBoolean(imp->hasExtension(extension));
        return result;
    }
    }
    return 0;
}

}

#endif // ENABLE(SVG)
