/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLFrameElement.h"

#include <wtf/GetPtr.h>

#include "Document.h"
#include "HTMLFrameElement.h"
#include "JSDocument.h"
#include "PlatformString.h"
#include "kjs_dom.h"
#include "kjs_window.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLFrameElementTableEntries[] =
{
    { "scrolling", JSHTMLFrameElement::ScrollingAttrNum, DontDelete, 0, &JSHTMLFrameElementTableEntries[16] },
    { "longDesc", JSHTMLFrameElement::LongDescAttrNum, DontDelete, 0, &JSHTMLFrameElementTableEntries[18] },
    { "location", JSHTMLFrameElement::LocationAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "marginWidth", JSHTMLFrameElement::MarginWidthAttrNum, DontDelete, 0, &JSHTMLFrameElementTableEntries[14] },
    { "name", JSHTMLFrameElement::NameAttrNum, DontDelete, 0, &JSHTMLFrameElementTableEntries[15] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "marginHeight", JSHTMLFrameElement::MarginHeightAttrNum, DontDelete, 0, 0 },
    { "frameBorder", JSHTMLFrameElement::FrameBorderAttrNum, DontDelete, 0, &JSHTMLFrameElementTableEntries[17] },
    { "noResize", JSHTMLFrameElement::NoResizeAttrNum, DontDelete, 0, 0 },
    { "src", JSHTMLFrameElement::SrcAttrNum, DontDelete, 0, &JSHTMLFrameElementTableEntries[19] },
    { "contentDocument", JSHTMLFrameElement::ContentDocumentAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "contentWindow", JSHTMLFrameElement::ContentWindowAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "width", JSHTMLFrameElement::WidthAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "height", JSHTMLFrameElement::HeightAttrNum, DontDelete|ReadOnly, 0, &JSHTMLFrameElementTableEntries[20] },
    { "constructor", JSHTMLFrameElement::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSHTMLFrameElementTable = 
{
    2, 21, JSHTMLFrameElementTableEntries, 14
};

/* Hash table for constructor */

static const HashEntry JSHTMLFrameElementConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLFrameElementConstructorTable = 
{
    2, 1, JSHTMLFrameElementConstructorTableEntries, 1
};

class JSHTMLFrameElementConstructor : public DOMObject {
public:
    JSHTMLFrameElementConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSHTMLFrameElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLFrameElementConstructor::info = { "HTMLFrameElementConstructor", 0, &JSHTMLFrameElementConstructorTable, 0 };

bool JSHTMLFrameElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLFrameElementConstructor, DOMObject>(exec, &JSHTMLFrameElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLFrameElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLFrameElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLFrameElementPrototypeTable = 
{
    2, 1, JSHTMLFrameElementPrototypeTableEntries, 1
};

const ClassInfo JSHTMLFrameElementPrototype::info = { "HTMLFrameElementPrototype", 0, &JSHTMLFrameElementPrototypeTable, 0 };

JSObject* JSHTMLFrameElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLFrameElementPrototype>(exec, "[[JSHTMLFrameElement.prototype]]");
}

const ClassInfo JSHTMLFrameElement::info = { "HTMLFrameElement", &JSHTMLElement::info, &JSHTMLFrameElementTable, 0 };

JSHTMLFrameElement::JSHTMLFrameElement(ExecState* exec, HTMLFrameElement* impl)
    : JSHTMLElement(exec, impl)
{
    setPrototype(JSHTMLFrameElementPrototype::self(exec));
}

bool JSHTMLFrameElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLFrameElement, JSHTMLElement>(exec, &JSHTMLFrameElementTable, this, propertyName, slot);
}

JSValue* JSHTMLFrameElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case FrameBorderAttrNum: {
        HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(impl());

        return jsString(imp->frameBorder());
    }
    case LongDescAttrNum: {
        HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(impl());

        return jsString(imp->longDesc());
    }
    case MarginHeightAttrNum: {
        HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(impl());

        return jsString(imp->marginHeight());
    }
    case MarginWidthAttrNum: {
        HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(impl());

        return jsString(imp->marginWidth());
    }
    case NameAttrNum: {
        HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(impl());

        return jsString(imp->name());
    }
    case NoResizeAttrNum: {
        HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(impl());

        return jsBoolean(imp->noResize());
    }
    case ScrollingAttrNum: {
        HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(impl());

        return jsString(imp->scrolling());
    }
    case SrcAttrNum: {
        HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(impl());

        return jsString(imp->src());
    }
    case ContentDocumentAttrNum: {
        HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(impl());

        return checkNodeSecurity(exec, imp->contentDocument()) ? toJS(exec, WTF::getPtr(imp->contentDocument())) : jsUndefined();
    }
    case ContentWindowAttrNum: {
        HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->contentWindow()));
    }
    case LocationAttrNum: {
        HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(impl());

        return jsString(imp->location());
    }
    case WidthAttrNum: {
        HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(impl());

        return jsNumber(imp->width());
    }
    case HeightAttrNum: {
        HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(impl());

        return jsNumber(imp->height());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLFrameElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSHTMLFrameElement, JSHTMLElement>(exec, propertyName, value, attr, &JSHTMLFrameElementTable, this);
}

void JSHTMLFrameElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case FrameBorderAttrNum: {
        HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(impl());

        imp->setFrameBorder(valueToStringWithNullCheck(exec, value));
        break;
    }
    case LongDescAttrNum: {
        HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(impl());

        imp->setLongDesc(valueToStringWithNullCheck(exec, value));
        break;
    }
    case MarginHeightAttrNum: {
        HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(impl());

        imp->setMarginHeight(valueToStringWithNullCheck(exec, value));
        break;
    }
    case MarginWidthAttrNum: {
        HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(impl());

        imp->setMarginWidth(valueToStringWithNullCheck(exec, value));
        break;
    }
    case NameAttrNum: {
        HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(impl());

        imp->setName(valueToStringWithNullCheck(exec, value));
        break;
    }
    case NoResizeAttrNum: {
        HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(impl());

        imp->setNoResize(value->toBoolean(exec));
        break;
    }
    case ScrollingAttrNum: {
        HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(impl());

        imp->setScrolling(valueToStringWithNullCheck(exec, value));
        break;
    }
    case SrcAttrNum: {
        setSrc(exec, value);
        break;
    }
    case LocationAttrNum: {
        setLocation(exec, value);
        break;
    }
    }
}

JSValue* JSHTMLFrameElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLFrameElementConstructor>(exec, "[[HTMLFrameElement.constructor]]");
}

}
