/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(XPATH)

#include "JSXPathResult.h"

#include <wtf/GetPtr.h>

#include "ExceptionCode.h"
#include "JSNode.h"
#include "Node.h"
#include "PlatformString.h"
#include "XPathResult.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSXPathResultTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "resultType", JSXPathResult::ResultTypeAttrNum, DontDelete|ReadOnly, 0, &JSXPathResultTableEntries[10] },
    { "singleNodeValue", JSXPathResult::SingleNodeValueAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "stringValue", JSXPathResult::StringValueAttrNum, DontDelete|ReadOnly, 0, &JSXPathResultTableEntries[8] },
    { 0, 0, 0, 0, 0 },
    { "booleanValue", JSXPathResult::BooleanValueAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "numberValue", JSXPathResult::NumberValueAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "invalidIteratorState", JSXPathResult::InvalidIteratorStateAttrNum, DontDelete|ReadOnly, 0, &JSXPathResultTableEntries[9] },
    { "snapshotLength", JSXPathResult::SnapshotLengthAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "constructor", JSXPathResult::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSXPathResultTable = 
{
    2, 11, JSXPathResultTableEntries, 8
};

/* Hash table for constructor */

static const HashEntry JSXPathResultConstructorTableEntries[] =
{
    { "ANY_TYPE", XPathResult::ANY_TYPE, DontDelete|ReadOnly, 0, &JSXPathResultConstructorTableEntries[13] },
    { 0, 0, 0, 0, 0 },
    { "NUMBER_TYPE", XPathResult::NUMBER_TYPE, DontDelete|ReadOnly, 0, &JSXPathResultConstructorTableEntries[12] },
    { "ORDERED_NODE_SNAPSHOT_TYPE", XPathResult::ORDERED_NODE_SNAPSHOT_TYPE, DontDelete|ReadOnly, 0, 0 },
    { "FIRST_ORDERED_NODE_TYPE", XPathResult::FIRST_ORDERED_NODE_TYPE, DontDelete|ReadOnly, 0, 0 },
    { "BOOLEAN_TYPE", XPathResult::BOOLEAN_TYPE, DontDelete|ReadOnly, 0, &JSXPathResultConstructorTableEntries[11] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "STRING_TYPE", XPathResult::STRING_TYPE, DontDelete|ReadOnly, 0, &JSXPathResultConstructorTableEntries[10] },
    { "UNORDERED_NODE_ITERATOR_TYPE", XPathResult::UNORDERED_NODE_ITERATOR_TYPE, DontDelete|ReadOnly, 0, 0 },
    { "ORDERED_NODE_ITERATOR_TYPE", XPathResult::ORDERED_NODE_ITERATOR_TYPE, DontDelete|ReadOnly, 0, 0 },
    { "UNORDERED_NODE_SNAPSHOT_TYPE", XPathResult::UNORDERED_NODE_SNAPSHOT_TYPE, DontDelete|ReadOnly, 0, 0 },
    { "ANY_UNORDERED_NODE_TYPE", XPathResult::ANY_UNORDERED_NODE_TYPE, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSXPathResultConstructorTable = 
{
    2, 14, JSXPathResultConstructorTableEntries, 10
};

class JSXPathResultConstructor : public DOMObject {
public:
    JSXPathResultConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSXPathResultPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSXPathResultConstructor::info = { "XPathResultConstructor", 0, &JSXPathResultConstructorTable, 0 };

bool JSXPathResultConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXPathResultConstructor, DOMObject>(exec, &JSXPathResultConstructorTable, this, propertyName, slot);
}

JSValue* JSXPathResultConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSXPathResultPrototypeTableEntries[] =
{
    { "UNORDERED_NODE_SNAPSHOT_TYPE", XPathResult::UNORDERED_NODE_SNAPSHOT_TYPE, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "snapshotItem", JSXPathResult::SnapshotItemFuncNum, DontDelete|Function, 1, 0 },
    { "UNORDERED_NODE_ITERATOR_TYPE", XPathResult::UNORDERED_NODE_ITERATOR_TYPE, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "BOOLEAN_TYPE", XPathResult::BOOLEAN_TYPE, DontDelete|ReadOnly, 0, 0 },
    { "ANY_UNORDERED_NODE_TYPE", XPathResult::ANY_UNORDERED_NODE_TYPE, DontDelete|ReadOnly, 0, 0 },
    { "STRING_TYPE", XPathResult::STRING_TYPE, DontDelete|ReadOnly, 0, &JSXPathResultPrototypeTableEntries[12] },
    { "ANY_TYPE", XPathResult::ANY_TYPE, DontDelete|ReadOnly, 0, &JSXPathResultPrototypeTableEntries[13] },
    { "ORDERED_NODE_ITERATOR_TYPE", XPathResult::ORDERED_NODE_ITERATOR_TYPE, DontDelete|ReadOnly, 0, &JSXPathResultPrototypeTableEntries[14] },
    { "NUMBER_TYPE", XPathResult::NUMBER_TYPE, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "ORDERED_NODE_SNAPSHOT_TYPE", XPathResult::ORDERED_NODE_SNAPSHOT_TYPE, DontDelete|ReadOnly, 0, 0 },
    { "FIRST_ORDERED_NODE_TYPE", XPathResult::FIRST_ORDERED_NODE_TYPE, DontDelete|ReadOnly, 0, 0 },
    { "iterateNext", JSXPathResult::IterateNextFuncNum, DontDelete|Function, 0, 0 }
};

static const HashTable JSXPathResultPrototypeTable = 
{
    2, 15, JSXPathResultPrototypeTableEntries, 12
};

const ClassInfo JSXPathResultPrototype::info = { "XPathResultPrototype", 0, &JSXPathResultPrototypeTable, 0 };

JSObject* JSXPathResultPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSXPathResultPrototype>(exec, "[[JSXPathResult.prototype]]");
}

bool JSXPathResultPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSXPathResultPrototypeFunction, JSXPathResultPrototype, JSObject>(exec, &JSXPathResultPrototypeTable, this, propertyName, slot);
}

JSValue* JSXPathResultPrototype::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

const ClassInfo JSXPathResult::info = { "XPathResult", 0, &JSXPathResultTable, 0 };

JSXPathResult::JSXPathResult(ExecState* exec, XPathResult* impl)
    : m_impl(impl)
{
    setPrototype(JSXPathResultPrototype::self(exec));
}

JSXPathResult::~JSXPathResult()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());
}

bool JSXPathResult::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSXPathResult, KJS::DOMObject>(exec, &JSXPathResultTable, this, propertyName, slot);
}

JSValue* JSXPathResult::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ResultTypeAttrNum: {
        XPathResult* imp = static_cast<XPathResult*>(impl());

        return jsNumber(imp->resultType());
    }
    case NumberValueAttrNum: {
        ExceptionCode ec = 0;
        XPathResult* imp = static_cast<XPathResult*>(impl());

        KJS::JSValue* result = jsNumber(imp->numberValue(ec));
        setDOMException(exec, ec);
        return result;
    }
    case StringValueAttrNum: {
        ExceptionCode ec = 0;
        XPathResult* imp = static_cast<XPathResult*>(impl());

        KJS::JSValue* result = jsString(imp->stringValue(ec));
        setDOMException(exec, ec);
        return result;
    }
    case BooleanValueAttrNum: {
        ExceptionCode ec = 0;
        XPathResult* imp = static_cast<XPathResult*>(impl());

        KJS::JSValue* result = jsBoolean(imp->booleanValue(ec));
        setDOMException(exec, ec);
        return result;
    }
    case SingleNodeValueAttrNum: {
        ExceptionCode ec = 0;
        XPathResult* imp = static_cast<XPathResult*>(impl());

        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->singleNodeValue(ec)));
        setDOMException(exec, ec);
        return result;
    }
    case InvalidIteratorStateAttrNum: {
        XPathResult* imp = static_cast<XPathResult*>(impl());

        return jsBoolean(imp->invalidIteratorState());
    }
    case SnapshotLengthAttrNum: {
        ExceptionCode ec = 0;
        XPathResult* imp = static_cast<XPathResult*>(impl());

        KJS::JSValue* result = jsNumber(imp->snapshotLength(ec));
        setDOMException(exec, ec);
        return result;
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

JSValue* JSXPathResult::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSXPathResultConstructor>(exec, "[[XPathResult.constructor]]");
}
JSValue* JSXPathResultPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSXPathResult::info))
      return throwError(exec, TypeError);

    XPathResult* imp = static_cast<XPathResult*>(static_cast<JSXPathResult*>(thisObj)->impl());

    switch (id) {
    case JSXPathResult::IterateNextFuncNum: {
        ExceptionCode ec = 0;


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->iterateNext(ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSXPathResult::SnapshotItemFuncNum: {
        ExceptionCode ec = 0;
        bool indexOk;
        unsigned index = args[0]->toInt32(exec, indexOk);
        if (!indexOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }


        KJS::JSValue* result = toJS(exec, WTF::getPtr(imp->snapshotItem(index, ec)));
        setDOMException(exec, ec);
        return result;
    }
    }
    return 0;
}
KJS::JSValue* toJS(KJS::ExecState* exec, XPathResult* obj)
{
    return KJS::cacheDOMObject<XPathResult, JSXPathResult>(exec, obj);
}
XPathResult* toXPathResult(KJS::JSValue* val)
{
    return val->isObject(&JSXPathResult::info) ? static_cast<JSXPathResult*>(val)->impl() : 0;
}

}

#endif // ENABLE(XPATH)
