/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGAnimatedRect.h"

#include <wtf/GetPtr.h>

#include "FloatRect.h"
#include "JSSVGRect.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGAnimatedRectTableEntries[] =
{
    { "baseVal", JSSVGAnimatedRect::BaseValAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "animVal", JSSVGAnimatedRect::AnimValAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGAnimatedRectTable = 
{
    2, 2, JSSVGAnimatedRectTableEntries, 2
};

/* Hash table for prototype */

static const HashEntry JSSVGAnimatedRectPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSSVGAnimatedRectPrototypeTable = 
{
    2, 1, JSSVGAnimatedRectPrototypeTableEntries, 1
};

const ClassInfo JSSVGAnimatedRectPrototype::info = { "SVGAnimatedRectPrototype", 0, &JSSVGAnimatedRectPrototypeTable, 0 };

JSObject* JSSVGAnimatedRectPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGAnimatedRectPrototype>(exec, "[[JSSVGAnimatedRect.prototype]]");
}

const ClassInfo JSSVGAnimatedRect::info = { "SVGAnimatedRect", 0, &JSSVGAnimatedRectTable, 0 };

JSSVGAnimatedRect::JSSVGAnimatedRect(ExecState* exec, SVGAnimatedRect* impl)
    : m_impl(impl)
{
    setPrototype(JSSVGAnimatedRectPrototype::self(exec));
}

JSSVGAnimatedRect::~JSSVGAnimatedRect()
{
    SVGDocumentExtensions::forgetGenericContext<SVGAnimatedRect>(m_impl.get());
    ScriptInterpreter::forgetDOMObject(m_impl.get());
}

bool JSSVGAnimatedRect::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedRect, KJS::DOMObject>(exec, &JSSVGAnimatedRectTable, this, propertyName, slot);
}

JSValue* JSSVGAnimatedRect::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case BaseValAttrNum: {
        SVGAnimatedRect* imp = static_cast<SVGAnimatedRect*>(impl());

        return toJS(exec, new JSSVGPODTypeWrapperCreator<FloatRect, SVGAnimatedRect>(imp, &SVGAnimatedRect::baseVal, &SVGAnimatedRect::setBaseVal));
    }
    case AnimValAttrNum: {
        SVGAnimatedRect* imp = static_cast<SVGAnimatedRect*>(impl());

        return toJS(exec, new JSSVGPODTypeWrapperCreator<FloatRect, SVGAnimatedRect>(imp, &SVGAnimatedRect::animVal, &SVGAnimatedRect::setAnimVal));
    }
    }
    return 0;
}

KJS::JSValue* toJS(KJS::ExecState* exec, SVGAnimatedRect* obj)
{
    return KJS::cacheDOMObject<SVGAnimatedRect, JSSVGAnimatedRect>(exec, obj);
}
SVGAnimatedRect* toSVGAnimatedRect(KJS::JSValue* val)
{
    return val->isObject(&JSSVGAnimatedRect::info) ? static_cast<JSSVGAnimatedRect*>(val)->impl() : 0;
}

}

#endif // ENABLE(SVG)
