/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGTitleElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "JSCSSStyleDeclaration.h"
#include "JSSVGAnimatedString.h"
#include "PlatformString.h"
#include "SVGTitleElement.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGTitleElementTableEntries[] =
{
    { "xmllang", JSSVGTitleElement::XmllangAttrNum, DontDelete, 0, &JSSVGTitleElementTableEntries[4] },
    { 0, 0, 0, 0, 0 },
    { "className", JSSVGTitleElement::ClassNameAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "xmlspace", JSSVGTitleElement::XmlspaceAttrNum, DontDelete, 0, &JSSVGTitleElementTableEntries[5] },
    { "style", JSSVGTitleElement::StyleAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGTitleElementTable = 
{
    2, 6, JSSVGTitleElementTableEntries, 4
};

/* Hash table for prototype */

static const HashEntry JSSVGTitleElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSSVGTitleElementPrototypeTable = 
{
    2, 1, JSSVGTitleElementPrototypeTableEntries, 1
};

const ClassInfo JSSVGTitleElementPrototype::info = { "SVGTitleElementPrototype", 0, &JSSVGTitleElementPrototypeTable, 0 };

JSObject* JSSVGTitleElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGTitleElementPrototype>(exec, "[[JSSVGTitleElement.prototype]]");
}

const ClassInfo JSSVGTitleElement::info = { "SVGTitleElement", &JSSVGElement::info, &JSSVGTitleElementTable, 0 };

JSSVGTitleElement::JSSVGTitleElement(ExecState* exec, SVGTitleElement* impl)
    : JSSVGElement(exec, impl)
{
    setPrototype(JSSVGTitleElementPrototype::self(exec));
}

bool JSSVGTitleElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGTitleElement, JSSVGElement>(exec, &JSSVGTitleElementTable, this, propertyName, slot);
}

JSValue* JSSVGTitleElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case XmllangAttrNum: {
        SVGTitleElement* imp = static_cast<SVGTitleElement*>(impl());

        return jsString(imp->xmllang());
    }
    case XmlspaceAttrNum: {
        SVGTitleElement* imp = static_cast<SVGTitleElement*>(impl());

        return jsString(imp->xmlspace());
    }
    case ClassNameAttrNum: {
        SVGTitleElement* imp = static_cast<SVGTitleElement*>(impl());

        ASSERT(exec && exec->dynamicInterpreter());

        RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
        Frame* activeFrame = static_cast<ScriptInterpreter*>(exec->dynamicInterpreter())->frame();
        if (activeFrame) {
            SVGDocumentExtensions* extensions = (activeFrame->document() ? activeFrame->document()->accessSVGExtensions() : 0);
            if (extensions) {
                if (extensions->hasGenericContext<SVGAnimatedString>(obj.get()))
                    ASSERT(extensions->genericContext<SVGAnimatedString>(obj.get()) == imp);
                else
                    extensions->setGenericContext<SVGAnimatedString>(obj.get(), imp);
            }
        }

        return toJS(exec, obj.get());
    }
    case StyleAttrNum: {
        SVGTitleElement* imp = static_cast<SVGTitleElement*>(impl());

        return toJS(exec, WTF::getPtr(imp->style()));
    }
    }
    return 0;
}

void JSSVGTitleElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSSVGTitleElement, JSSVGElement>(exec, propertyName, value, attr, &JSSVGTitleElementTable, this);
}

void JSSVGTitleElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case XmllangAttrNum: {
        SVGTitleElement* imp = static_cast<SVGTitleElement*>(impl());

        imp->setXmllang(value->toString(exec));
        break;
    }
    case XmlspaceAttrNum: {
        SVGTitleElement* imp = static_cast<SVGTitleElement*>(impl());

        imp->setXmlspace(value->toString(exec));
        break;
    }
    }
}


}

#endif // ENABLE(SVG)
