/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLFontElement.h"

#include <wtf/GetPtr.h>

#include "HTMLFontElement.h"
#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLFontElementTableEntries[] =
{
    { "size", JSHTMLFontElement::SizeAttrNum, DontDelete, 0, 0 },
    { "color", JSHTMLFontElement::ColorAttrNum, DontDelete, 0, &JSHTMLFontElementTableEntries[4] },
    { 0, 0, 0, 0, 0 },
    { "face", JSHTMLFontElement::FaceAttrNum, DontDelete, 0, 0 },
    { "constructor", JSHTMLFontElement::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSHTMLFontElementTable = 
{
    2, 5, JSHTMLFontElementTableEntries, 4
};

/* Hash table for constructor */

static const HashEntry JSHTMLFontElementConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLFontElementConstructorTable = 
{
    2, 1, JSHTMLFontElementConstructorTableEntries, 1
};

class JSHTMLFontElementConstructor : public DOMObject {
public:
    JSHTMLFontElementConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSHTMLFontElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLFontElementConstructor::info = { "HTMLFontElementConstructor", 0, &JSHTMLFontElementConstructorTable, 0 };

bool JSHTMLFontElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLFontElementConstructor, DOMObject>(exec, &JSHTMLFontElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLFontElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLFontElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLFontElementPrototypeTable = 
{
    2, 1, JSHTMLFontElementPrototypeTableEntries, 1
};

const ClassInfo JSHTMLFontElementPrototype::info = { "HTMLFontElementPrototype", 0, &JSHTMLFontElementPrototypeTable, 0 };

JSObject* JSHTMLFontElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLFontElementPrototype>(exec, "[[JSHTMLFontElement.prototype]]");
}

const ClassInfo JSHTMLFontElement::info = { "HTMLFontElement", &JSHTMLElement::info, &JSHTMLFontElementTable, 0 };

JSHTMLFontElement::JSHTMLFontElement(ExecState* exec, HTMLFontElement* impl)
    : JSHTMLElement(exec, impl)
{
    setPrototype(JSHTMLFontElementPrototype::self(exec));
}

bool JSHTMLFontElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLFontElement, JSHTMLElement>(exec, &JSHTMLFontElementTable, this, propertyName, slot);
}

JSValue* JSHTMLFontElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case ColorAttrNum: {
        HTMLFontElement* imp = static_cast<HTMLFontElement*>(impl());

        return jsString(imp->color());
    }
    case FaceAttrNum: {
        HTMLFontElement* imp = static_cast<HTMLFontElement*>(impl());

        return jsString(imp->face());
    }
    case SizeAttrNum: {
        HTMLFontElement* imp = static_cast<HTMLFontElement*>(impl());

        return jsString(imp->size());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLFontElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSHTMLFontElement, JSHTMLElement>(exec, propertyName, value, attr, &JSHTMLFontElementTable, this);
}

void JSHTMLFontElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case ColorAttrNum: {
        HTMLFontElement* imp = static_cast<HTMLFontElement*>(impl());

        imp->setColor(valueToStringWithNullCheck(exec, value));
        break;
    }
    case FaceAttrNum: {
        HTMLFontElement* imp = static_cast<HTMLFontElement*>(impl());

        imp->setFace(valueToStringWithNullCheck(exec, value));
        break;
    }
    case SizeAttrNum: {
        HTMLFontElement* imp = static_cast<HTMLFontElement*>(impl());

        imp->setSize(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLFontElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLFontElementConstructor>(exec, "[[HTMLFontElement.constructor]]");
}

}
