/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGLengthList.h"

#include <wtf/GetPtr.h>

#include "ExceptionCode.h"
#include "JSSVGLength.h"
#include "SVGLength.h"
#include "SVGLengthList.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGLengthListTableEntries[] =
{
    { "numberOfItems", JSSVGLengthList::NumberOfItemsAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGLengthListTable = 
{
    2, 1, JSSVGLengthListTableEntries, 1
};

/* Hash table for prototype */

static const HashEntry JSSVGLengthListPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "clear", JSSVGLengthList::ClearFuncNum, DontDelete|Function, 0, &JSSVGLengthListPrototypeTableEntries[9] },
    { "getItem", JSSVGLengthList::GetItemFuncNum, DontDelete|Function, 1, &JSSVGLengthListPrototypeTableEntries[7] },
    { "insertItemBefore", JSSVGLengthList::InsertItemBeforeFuncNum, DontDelete|Function, 2, &JSSVGLengthListPrototypeTableEntries[8] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "initialize", JSSVGLengthList::InitializeFuncNum, DontDelete|Function, 1, 0 },
    { "replaceItem", JSSVGLengthList::ReplaceItemFuncNum, DontDelete|Function, 2, 0 },
    { "removeItem", JSSVGLengthList::RemoveItemFuncNum, DontDelete|Function, 1, 0 },
    { "appendItem", JSSVGLengthList::AppendItemFuncNum, DontDelete|Function, 1, 0 }
};

static const HashTable JSSVGLengthListPrototypeTable = 
{
    2, 10, JSSVGLengthListPrototypeTableEntries, 7
};

const ClassInfo JSSVGLengthListPrototype::info = { "SVGLengthListPrototype", 0, &JSSVGLengthListPrototypeTable, 0 };

JSObject* JSSVGLengthListPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGLengthListPrototype>(exec, "[[JSSVGLengthList.prototype]]");
}

bool JSSVGLengthListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSSVGLengthListPrototypeFunction, JSObject>(exec, &JSSVGLengthListPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGLengthList::info = { "SVGLengthList", 0, &JSSVGLengthListTable, 0 };

JSSVGLengthList::JSSVGLengthList(ExecState* exec, SVGLengthList* impl)
    : m_impl(impl)
{
    setPrototype(JSSVGLengthListPrototype::self(exec));
}

JSSVGLengthList::~JSSVGLengthList()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());
}

bool JSSVGLengthList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGLengthList, KJS::DOMObject>(exec, &JSSVGLengthListTable, this, propertyName, slot);
}

JSValue* JSSVGLengthList::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case NumberOfItemsAttrNum: {
        SVGLengthList* imp = static_cast<SVGLengthList*>(impl());

        return jsNumber(imp->numberOfItems());
    }
    }
    return 0;
}

JSValue* JSSVGLengthListPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSSVGLengthList::info))
      return throwError(exec, TypeError);

    SVGLengthList* imp = static_cast<SVGLengthList*>(static_cast<JSSVGLengthList*>(thisObj)->impl());

    switch (id) {
    case JSSVGLengthList::ClearFuncNum: {
        ExceptionCode ec = 0;

        imp->clear(ec);
        setDOMException(exec, ec);
        return jsUndefined();
    }
    case JSSVGLengthList::InitializeFuncNum: {
        ExceptionCode ec = 0;
        SVGLength item = toSVGLength(args[0]);


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<SVGLength>(imp->initialize(item, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSSVGLengthList::GetItemFuncNum: {
        ExceptionCode ec = 0;
        bool indexOk;
        unsigned index = args[0]->toInt32(exec, indexOk);
        if (!indexOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<SVGLength>(imp->getItem(index, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSSVGLengthList::InsertItemBeforeFuncNum: {
        ExceptionCode ec = 0;
        SVGLength item = toSVGLength(args[0]);
        bool indexOk;
        unsigned index = args[1]->toInt32(exec, indexOk);
        if (!indexOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<SVGLength>(imp->insertItemBefore(item, index, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSSVGLengthList::ReplaceItemFuncNum: {
        ExceptionCode ec = 0;
        SVGLength item = toSVGLength(args[0]);
        bool indexOk;
        unsigned index = args[1]->toInt32(exec, indexOk);
        if (!indexOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<SVGLength>(imp->replaceItem(item, index, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSSVGLengthList::RemoveItemFuncNum: {
        ExceptionCode ec = 0;
        bool indexOk;
        unsigned index = args[0]->toInt32(exec, indexOk);
        if (!indexOk) {
            setDOMException(exec, TYPE_MISMATCH_ERR);
            return jsUndefined();
        }


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<SVGLength>(imp->removeItem(index, ec)));
        setDOMException(exec, ec);
        return result;
    }
    case JSSVGLengthList::AppendItemFuncNum: {
        ExceptionCode ec = 0;
        SVGLength item = toSVGLength(args[0]);


        KJS::JSValue* result = toJS(exec, new JSSVGPODTypeWrapper<SVGLength>(imp->appendItem(item, ec)));
        setDOMException(exec, ec);
        return result;
    }
    }
    return 0;
}
KJS::JSValue* toJS(KJS::ExecState* exec, SVGLengthList* obj)
{
    return KJS::cacheDOMObject<SVGLengthList, JSSVGLengthList>(exec, obj);
}
SVGLengthList* toSVGLengthList(KJS::JSValue* val)
{
    return val->isObject(&JSSVGLengthList::info) ? static_cast<JSSVGLengthList*>(val)->impl() : 0;
}

}

#endif // ENABLE(SVG)
