/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLUListElement.h"

#include <wtf/GetPtr.h>

#include "HTMLUListElement.h"
#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLUListElementTableEntries[] =
{
    { "compact", JSHTMLUListElement::CompactAttrNum, DontDelete, 0, &JSHTMLUListElementTableEntries[3] },
    { "type", JSHTMLUListElement::TypeAttrNum, DontDelete, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "constructor", JSHTMLUListElement::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSHTMLUListElementTable = 
{
    2, 4, JSHTMLUListElementTableEntries, 3
};

/* Hash table for constructor */

static const HashEntry JSHTMLUListElementConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLUListElementConstructorTable = 
{
    2, 1, JSHTMLUListElementConstructorTableEntries, 1
};

class JSHTMLUListElementConstructor : public DOMObject {
public:
    JSHTMLUListElementConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSHTMLUListElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLUListElementConstructor::info = { "HTMLUListElementConstructor", 0, &JSHTMLUListElementConstructorTable, 0 };

bool JSHTMLUListElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLUListElementConstructor, DOMObject>(exec, &JSHTMLUListElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLUListElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLUListElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLUListElementPrototypeTable = 
{
    2, 1, JSHTMLUListElementPrototypeTableEntries, 1
};

const ClassInfo JSHTMLUListElementPrototype::info = { "HTMLUListElementPrototype", 0, &JSHTMLUListElementPrototypeTable, 0 };

JSObject* JSHTMLUListElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLUListElementPrototype>(exec, "[[JSHTMLUListElement.prototype]]");
}

const ClassInfo JSHTMLUListElement::info = { "HTMLUListElement", &JSHTMLElement::info, &JSHTMLUListElementTable, 0 };

JSHTMLUListElement::JSHTMLUListElement(ExecState* exec, HTMLUListElement* impl)
    : JSHTMLElement(exec, impl)
{
    setPrototype(JSHTMLUListElementPrototype::self(exec));
}

bool JSHTMLUListElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLUListElement, JSHTMLElement>(exec, &JSHTMLUListElementTable, this, propertyName, slot);
}

JSValue* JSHTMLUListElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case CompactAttrNum: {
        HTMLUListElement* imp = static_cast<HTMLUListElement*>(impl());

        return jsBoolean(imp->compact());
    }
    case TypeAttrNum: {
        HTMLUListElement* imp = static_cast<HTMLUListElement*>(impl());

        return jsString(imp->type());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLUListElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSHTMLUListElement, JSHTMLElement>(exec, propertyName, value, attr, &JSHTMLUListElementTable, this);
}

void JSHTMLUListElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case CompactAttrNum: {
        HTMLUListElement* imp = static_cast<HTMLUListElement*>(impl());

        imp->setCompact(value->toBoolean(exec));
        break;
    }
    case TypeAttrNum: {
        HTMLUListElement* imp = static_cast<HTMLUListElement*>(impl());

        imp->setType(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLUListElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLUListElementConstructor>(exec, "[[HTMLUListElement.constructor]]");
}

}
